SAMPLE_RSS='''
<?xml version="1.0"?>
<rss version="2.0" xmlns:atom="http://www.w3.org/2005/Atom">
<channel>
<title>Planet GNOME</title>
<link>https://planet.gnome.org/</link>
<language>en</language>
<description>Planet GNOME - https://planet.gnome.org/</description>
<atom:link rel="hub" href="http://pubsubhubbub.appspot.com/"/>
<atom:link rel="self" href="https://planet.gnome.org/rss20.xml" type="application/rss+xml"/>
<item>
<title>Jussi Pakkanen: It's not what programming languages do, it's what they shepherd you to</title>
<guid isPermaLink="false">tag:blogger.com,1999:blog-5968355124473522212.post-1318135828711063313</guid>
<link>http://nibblestew.blogspot.com/2020/03/its-not-what-programming-languages-do.html</link>
<description>How many of you have listened, read or taken part in a discussion about programming languages that goes like the following:&lt;br /&gt;&lt;br /&gt;Person A: &quot;Programming language X is bad, code written in it is unreadable and horrible.&quot;&lt;br /&gt;&lt;br /&gt;Person B: &quot;No it's not. You can write good code in X, you just have to be disciplined.&quot;&lt;br /&gt;&lt;br /&gt;Person A: &quot;It does not work, if you look at existing code it is all awful.&quot;&lt;br /&gt;&lt;br /&gt;Person B: &quot;No! Wrong! Those are just people doing it badly. You can write readable code just fine.&quot;&lt;br /&gt;&lt;br /&gt;After this the discussion repeats from the beginning until either one gets fed up and just leaves.&lt;br /&gt;&lt;br /&gt;I'm guessing more than 99% of you readers have seen this, often multiple times. The sad part of this is that even though this thing happens all the time, nobody learns anything and the discussion begins anew all the time. Let's see if we can do something about this. A good way to go about it is to try to come up with a name and a description for the underlying issue.&lt;br /&gt;&lt;blockquote class=&quot;tr_bq&quot;&gt;&lt;b&gt;shepherding&lt;/b&gt; An invisible property of a progamming language and its ecosystem that drives people into solving problems in ways that are natural for the programming language itself rather than ways that are considered &quot;better&quot; in some sense. These may include things like long term maintainability, readability and performance.&lt;/blockquote&gt;This is a bit abstract, so let's look at some examples.&lt;br /&gt;&lt;h2&gt;Perl shepherds you into using regexps&lt;/h2&gt;Perl has several XML parsers available and they are presumably good at their jobs (I have never actually used one so I wouldn't know). Yet, in practice, many Perl scripts do XML (and HTML) manipulation with regexes, which is brittle and &quot;wrong&quot; for lack of a better term. This is a clear case of shepherding. Text manipulation in Perl is easy. Importing, calling and using an XML parser is not. And really all you need to do is to change that one string to a different string. It's tempting. It works. Surely it could not fail. Let's just do it and get on with other stuff. Boom, just like that you have been shepherded.&lt;br /&gt;&lt;br /&gt;Note that there is nothing about Perl that forces you to do this. It provides all the tools needed to do the right thing. And yet people don't, because they are being shepherded (unconsciously) into doing the thing that is easy and fast in Perl.&lt;br /&gt;&lt;h2&gt;Make shepherds you into embedding shell pipelines in Makefiles&lt;/h2&gt;&lt;div&gt;Compiling code with Make is tolerable, but it fails quite badly when you need to generate source code, data files and the like. The sustainable solution would be to write a standalone program in a proper scripting language that has all the code logic needed and call that from Make with your inputs and outputs. This rarely happens. Instead people think &quot;I know, I have an entire Unix userland available [1], I can just string together random text mangling tools in a pipeline, write it here and be done&quot;. This is how unmaintainability is born.&lt;/div&gt;&lt;div&gt;&lt;br /&gt;&lt;/div&gt;&lt;div&gt;Nothing about Make &lt;i&gt;forces&lt;/i&gt; people to behave like this. Make &lt;i&gt;shepherds&lt;/i&gt; people into doing this. It is the easy, natural outcome when faced with the given problem.&lt;/div&gt;&lt;h2&gt;Other examples&lt;/h2&gt;&lt;div&gt;&lt;ul&gt;&lt;li&gt;C shepherds you into manipulating data via pointers rather than value objects.&lt;/li&gt;&lt;li&gt;C++ shepherds you into providing dependencies as header-only libraries.&lt;/li&gt;&lt;li&gt;Java does not shepherd you into using classes and objects, it pretty much mandates them.&lt;/li&gt;&lt;li&gt;Turing complete configuration languages shepherd you into writing complex logic with them, even though they are usually not particularly good programming environments.&lt;/li&gt;&lt;/ul&gt;&lt;/div&gt;[1] Which you don't have on Windows. Not to mention that every Unix has slightly different command line arguments and semantics for basic commands meaning shell pipelines are not actually portable.</description>
<pubDate>Thu, 26 Mar 2020 15:18:00 +0000</pubDate>
<author>noreply@blogger.com (Jussi)</author>
</item>
</channel>
</rss>
'''
