// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use glib::error::ErrorDomain;
use glib::translate::*;
use glib::value::FromValue;
use glib::value::FromValueOptional;
use glib::value::SetValue;
use glib::value::Value;
use glib::Quark;
use glib::StaticType;
use glib::Type;
use gobject_sys;
use gst_sys;

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum BufferingMode {
    Stream,
    Download,
    Timeshift,
    Live,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for BufferingMode {
    type GlibType = gst_sys::GstBufferingMode;

    fn to_glib(&self) -> gst_sys::GstBufferingMode {
        match *self {
            BufferingMode::Stream => gst_sys::GST_BUFFERING_STREAM,
            BufferingMode::Download => gst_sys::GST_BUFFERING_DOWNLOAD,
            BufferingMode::Timeshift => gst_sys::GST_BUFFERING_TIMESHIFT,
            BufferingMode::Live => gst_sys::GST_BUFFERING_LIVE,
            BufferingMode::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstBufferingMode> for BufferingMode {
    fn from_glib(value: gst_sys::GstBufferingMode) -> Self {
        skip_assert_initialized!();
        match value {
            0 => BufferingMode::Stream,
            1 => BufferingMode::Download,
            2 => BufferingMode::Timeshift,
            3 => BufferingMode::Live,
            value => BufferingMode::__Unknown(value),
        }
    }
}

impl StaticType for BufferingMode {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_buffering_mode_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for BufferingMode {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for BufferingMode {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for BufferingMode {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum BusSyncReply {
    Drop,
    Pass,
    Async,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for BusSyncReply {
    type GlibType = gst_sys::GstBusSyncReply;

    fn to_glib(&self) -> gst_sys::GstBusSyncReply {
        match *self {
            BusSyncReply::Drop => gst_sys::GST_BUS_DROP,
            BusSyncReply::Pass => gst_sys::GST_BUS_PASS,
            BusSyncReply::Async => gst_sys::GST_BUS_ASYNC,
            BusSyncReply::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstBusSyncReply> for BusSyncReply {
    fn from_glib(value: gst_sys::GstBusSyncReply) -> Self {
        skip_assert_initialized!();
        match value {
            0 => BusSyncReply::Drop,
            1 => BusSyncReply::Pass,
            2 => BusSyncReply::Async,
            value => BusSyncReply::__Unknown(value),
        }
    }
}

impl StaticType for BusSyncReply {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_bus_sync_reply_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for BusSyncReply {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for BusSyncReply {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for BusSyncReply {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum CapsIntersectMode {
    ZigZag,
    First,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for CapsIntersectMode {
    type GlibType = gst_sys::GstCapsIntersectMode;

    fn to_glib(&self) -> gst_sys::GstCapsIntersectMode {
        match *self {
            CapsIntersectMode::ZigZag => gst_sys::GST_CAPS_INTERSECT_ZIG_ZAG,
            CapsIntersectMode::First => gst_sys::GST_CAPS_INTERSECT_FIRST,
            CapsIntersectMode::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstCapsIntersectMode> for CapsIntersectMode {
    fn from_glib(value: gst_sys::GstCapsIntersectMode) -> Self {
        skip_assert_initialized!();
        match value {
            0 => CapsIntersectMode::ZigZag,
            1 => CapsIntersectMode::First,
            value => CapsIntersectMode::__Unknown(value),
        }
    }
}

impl StaticType for CapsIntersectMode {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_caps_intersect_mode_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for CapsIntersectMode {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for CapsIntersectMode {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for CapsIntersectMode {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum ClockEntryType {
    Single,
    Periodic,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for ClockEntryType {
    type GlibType = gst_sys::GstClockEntryType;

    fn to_glib(&self) -> gst_sys::GstClockEntryType {
        match *self {
            ClockEntryType::Single => gst_sys::GST_CLOCK_ENTRY_SINGLE,
            ClockEntryType::Periodic => gst_sys::GST_CLOCK_ENTRY_PERIODIC,
            ClockEntryType::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstClockEntryType> for ClockEntryType {
    fn from_glib(value: gst_sys::GstClockEntryType) -> Self {
        skip_assert_initialized!();
        match value {
            0 => ClockEntryType::Single,
            1 => ClockEntryType::Periodic,
            value => ClockEntryType::__Unknown(value),
        }
    }
}

impl StaticType for ClockEntryType {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_clock_entry_type_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for ClockEntryType {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for ClockEntryType {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for ClockEntryType {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[must_use]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum ClockReturn {
    Ok,
    Early,
    Unscheduled,
    Busy,
    Badtime,
    Error,
    Unsupported,
    Done,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for ClockReturn {
    type GlibType = gst_sys::GstClockReturn;

    fn to_glib(&self) -> gst_sys::GstClockReturn {
        match *self {
            ClockReturn::Ok => gst_sys::GST_CLOCK_OK,
            ClockReturn::Early => gst_sys::GST_CLOCK_EARLY,
            ClockReturn::Unscheduled => gst_sys::GST_CLOCK_UNSCHEDULED,
            ClockReturn::Busy => gst_sys::GST_CLOCK_BUSY,
            ClockReturn::Badtime => gst_sys::GST_CLOCK_BADTIME,
            ClockReturn::Error => gst_sys::GST_CLOCK_ERROR,
            ClockReturn::Unsupported => gst_sys::GST_CLOCK_UNSUPPORTED,
            ClockReturn::Done => gst_sys::GST_CLOCK_DONE,
            ClockReturn::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstClockReturn> for ClockReturn {
    fn from_glib(value: gst_sys::GstClockReturn) -> Self {
        skip_assert_initialized!();
        match value {
            0 => ClockReturn::Ok,
            1 => ClockReturn::Early,
            2 => ClockReturn::Unscheduled,
            3 => ClockReturn::Busy,
            4 => ClockReturn::Badtime,
            5 => ClockReturn::Error,
            6 => ClockReturn::Unsupported,
            7 => ClockReturn::Done,
            value => ClockReturn::__Unknown(value),
        }
    }
}

impl StaticType for ClockReturn {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_clock_return_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for ClockReturn {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for ClockReturn {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for ClockReturn {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum ClockType {
    Realtime,
    Monotonic,
    Other,
    #[cfg(any(feature = "v1_18", feature = "dox"))]
    Tai,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for ClockType {
    type GlibType = gst_sys::GstClockType;

    fn to_glib(&self) -> gst_sys::GstClockType {
        match *self {
            ClockType::Realtime => gst_sys::GST_CLOCK_TYPE_REALTIME,
            ClockType::Monotonic => gst_sys::GST_CLOCK_TYPE_MONOTONIC,
            ClockType::Other => gst_sys::GST_CLOCK_TYPE_OTHER,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            ClockType::Tai => gst_sys::GST_CLOCK_TYPE_TAI,
            ClockType::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstClockType> for ClockType {
    fn from_glib(value: gst_sys::GstClockType) -> Self {
        skip_assert_initialized!();
        match value {
            0 => ClockType::Realtime,
            1 => ClockType::Monotonic,
            2 => ClockType::Other,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            3 => ClockType::Tai,
            value => ClockType::__Unknown(value),
        }
    }
}

impl StaticType for ClockType {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_clock_type_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for ClockType {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for ClockType {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for ClockType {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum CoreError {
    Failed,
    TooLazy,
    NotImplemented,
    StateChange,
    Pad,
    Thread,
    Negotiation,
    Event,
    Seek,
    Caps,
    Tag,
    MissingPlugin,
    Clock,
    Disabled,
    NumErrors,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for CoreError {
    type GlibType = gst_sys::GstCoreError;

    fn to_glib(&self) -> gst_sys::GstCoreError {
        match *self {
            CoreError::Failed => gst_sys::GST_CORE_ERROR_FAILED,
            CoreError::TooLazy => gst_sys::GST_CORE_ERROR_TOO_LAZY,
            CoreError::NotImplemented => gst_sys::GST_CORE_ERROR_NOT_IMPLEMENTED,
            CoreError::StateChange => gst_sys::GST_CORE_ERROR_STATE_CHANGE,
            CoreError::Pad => gst_sys::GST_CORE_ERROR_PAD,
            CoreError::Thread => gst_sys::GST_CORE_ERROR_THREAD,
            CoreError::Negotiation => gst_sys::GST_CORE_ERROR_NEGOTIATION,
            CoreError::Event => gst_sys::GST_CORE_ERROR_EVENT,
            CoreError::Seek => gst_sys::GST_CORE_ERROR_SEEK,
            CoreError::Caps => gst_sys::GST_CORE_ERROR_CAPS,
            CoreError::Tag => gst_sys::GST_CORE_ERROR_TAG,
            CoreError::MissingPlugin => gst_sys::GST_CORE_ERROR_MISSING_PLUGIN,
            CoreError::Clock => gst_sys::GST_CORE_ERROR_CLOCK,
            CoreError::Disabled => gst_sys::GST_CORE_ERROR_DISABLED,
            CoreError::NumErrors => gst_sys::GST_CORE_ERROR_NUM_ERRORS,
            CoreError::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstCoreError> for CoreError {
    fn from_glib(value: gst_sys::GstCoreError) -> Self {
        skip_assert_initialized!();
        match value {
            1 => CoreError::Failed,
            2 => CoreError::TooLazy,
            3 => CoreError::NotImplemented,
            4 => CoreError::StateChange,
            5 => CoreError::Pad,
            6 => CoreError::Thread,
            7 => CoreError::Negotiation,
            8 => CoreError::Event,
            9 => CoreError::Seek,
            10 => CoreError::Caps,
            11 => CoreError::Tag,
            12 => CoreError::MissingPlugin,
            13 => CoreError::Clock,
            14 => CoreError::Disabled,
            15 => CoreError::NumErrors,
            value => CoreError::__Unknown(value),
        }
    }
}

impl ErrorDomain for CoreError {
    fn domain() -> Quark {
        skip_assert_initialized!();
        unsafe { from_glib(gst_sys::gst_core_error_quark()) }
    }

    fn code(self) -> i32 {
        self.to_glib()
    }

    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match code {
            1 => Some(CoreError::Failed),
            2 => Some(CoreError::TooLazy),
            3 => Some(CoreError::NotImplemented),
            4 => Some(CoreError::StateChange),
            5 => Some(CoreError::Pad),
            6 => Some(CoreError::Thread),
            7 => Some(CoreError::Negotiation),
            8 => Some(CoreError::Event),
            9 => Some(CoreError::Seek),
            10 => Some(CoreError::Caps),
            11 => Some(CoreError::Tag),
            12 => Some(CoreError::MissingPlugin),
            13 => Some(CoreError::Clock),
            14 => Some(CoreError::Disabled),
            15 => Some(CoreError::NumErrors),
            _ => Some(CoreError::Failed),
        }
    }
}

impl StaticType for CoreError {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_core_error_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for CoreError {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for CoreError {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for CoreError {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum DebugLevel {
    None,
    Error,
    Warning,
    Fixme,
    Info,
    Debug,
    Log,
    Trace,
    Memdump,
    Count,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for DebugLevel {
    type GlibType = gst_sys::GstDebugLevel;

    fn to_glib(&self) -> gst_sys::GstDebugLevel {
        match *self {
            DebugLevel::None => gst_sys::GST_LEVEL_NONE,
            DebugLevel::Error => gst_sys::GST_LEVEL_ERROR,
            DebugLevel::Warning => gst_sys::GST_LEVEL_WARNING,
            DebugLevel::Fixme => gst_sys::GST_LEVEL_FIXME,
            DebugLevel::Info => gst_sys::GST_LEVEL_INFO,
            DebugLevel::Debug => gst_sys::GST_LEVEL_DEBUG,
            DebugLevel::Log => gst_sys::GST_LEVEL_LOG,
            DebugLevel::Trace => gst_sys::GST_LEVEL_TRACE,
            DebugLevel::Memdump => gst_sys::GST_LEVEL_MEMDUMP,
            DebugLevel::Count => gst_sys::GST_LEVEL_COUNT,
            DebugLevel::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstDebugLevel> for DebugLevel {
    fn from_glib(value: gst_sys::GstDebugLevel) -> Self {
        skip_assert_initialized!();
        match value {
            0 => DebugLevel::None,
            1 => DebugLevel::Error,
            2 => DebugLevel::Warning,
            3 => DebugLevel::Fixme,
            4 => DebugLevel::Info,
            5 => DebugLevel::Debug,
            6 => DebugLevel::Log,
            7 => DebugLevel::Trace,
            9 => DebugLevel::Memdump,
            10 => DebugLevel::Count,
            value => DebugLevel::__Unknown(value),
        }
    }
}

impl StaticType for DebugLevel {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_debug_level_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for DebugLevel {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for DebugLevel {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for DebugLevel {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, PartialEq, Eq, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum EventType {
    Unknown,
    FlushStart,
    FlushStop,
    StreamStart,
    Caps,
    Segment,
    StreamCollection,
    Tag,
    Buffersize,
    SinkMessage,
    #[cfg(any(feature = "v1_10", feature = "dox"))]
    StreamGroupDone,
    Eos,
    Toc,
    Protection,
    SegmentDone,
    Gap,
    #[cfg(any(feature = "v1_18", feature = "dox"))]
    InstantRateChange,
    Qos,
    Seek,
    Navigation,
    Latency,
    Step,
    Reconfigure,
    TocSelect,
    #[cfg(any(feature = "v1_10", feature = "dox"))]
    SelectStreams,
    #[cfg(any(feature = "v1_18", feature = "dox"))]
    InstantRateSyncTime,
    CustomUpstream,
    CustomDownstream,
    CustomDownstreamOob,
    CustomDownstreamSticky,
    CustomBoth,
    CustomBothOob,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for EventType {
    type GlibType = gst_sys::GstEventType;

    fn to_glib(&self) -> gst_sys::GstEventType {
        match *self {
            EventType::Unknown => gst_sys::GST_EVENT_UNKNOWN,
            EventType::FlushStart => gst_sys::GST_EVENT_FLUSH_START,
            EventType::FlushStop => gst_sys::GST_EVENT_FLUSH_STOP,
            EventType::StreamStart => gst_sys::GST_EVENT_STREAM_START,
            EventType::Caps => gst_sys::GST_EVENT_CAPS,
            EventType::Segment => gst_sys::GST_EVENT_SEGMENT,
            EventType::StreamCollection => gst_sys::GST_EVENT_STREAM_COLLECTION,
            EventType::Tag => gst_sys::GST_EVENT_TAG,
            EventType::Buffersize => gst_sys::GST_EVENT_BUFFERSIZE,
            EventType::SinkMessage => gst_sys::GST_EVENT_SINK_MESSAGE,
            #[cfg(any(feature = "v1_10", feature = "dox"))]
            EventType::StreamGroupDone => gst_sys::GST_EVENT_STREAM_GROUP_DONE,
            EventType::Eos => gst_sys::GST_EVENT_EOS,
            EventType::Toc => gst_sys::GST_EVENT_TOC,
            EventType::Protection => gst_sys::GST_EVENT_PROTECTION,
            EventType::SegmentDone => gst_sys::GST_EVENT_SEGMENT_DONE,
            EventType::Gap => gst_sys::GST_EVENT_GAP,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            EventType::InstantRateChange => gst_sys::GST_EVENT_INSTANT_RATE_CHANGE,
            EventType::Qos => gst_sys::GST_EVENT_QOS,
            EventType::Seek => gst_sys::GST_EVENT_SEEK,
            EventType::Navigation => gst_sys::GST_EVENT_NAVIGATION,
            EventType::Latency => gst_sys::GST_EVENT_LATENCY,
            EventType::Step => gst_sys::GST_EVENT_STEP,
            EventType::Reconfigure => gst_sys::GST_EVENT_RECONFIGURE,
            EventType::TocSelect => gst_sys::GST_EVENT_TOC_SELECT,
            #[cfg(any(feature = "v1_10", feature = "dox"))]
            EventType::SelectStreams => gst_sys::GST_EVENT_SELECT_STREAMS,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            EventType::InstantRateSyncTime => gst_sys::GST_EVENT_INSTANT_RATE_SYNC_TIME,
            EventType::CustomUpstream => gst_sys::GST_EVENT_CUSTOM_UPSTREAM,
            EventType::CustomDownstream => gst_sys::GST_EVENT_CUSTOM_DOWNSTREAM,
            EventType::CustomDownstreamOob => gst_sys::GST_EVENT_CUSTOM_DOWNSTREAM_OOB,
            EventType::CustomDownstreamSticky => gst_sys::GST_EVENT_CUSTOM_DOWNSTREAM_STICKY,
            EventType::CustomBoth => gst_sys::GST_EVENT_CUSTOM_BOTH,
            EventType::CustomBothOob => gst_sys::GST_EVENT_CUSTOM_BOTH_OOB,
            EventType::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstEventType> for EventType {
    fn from_glib(value: gst_sys::GstEventType) -> Self {
        skip_assert_initialized!();
        match value {
            0 => EventType::Unknown,
            2563 => EventType::FlushStart,
            5127 => EventType::FlushStop,
            10254 => EventType::StreamStart,
            12814 => EventType::Caps,
            17934 => EventType::Segment,
            19230 => EventType::StreamCollection,
            20510 => EventType::Tag,
            23054 => EventType::Buffersize,
            25630 => EventType::SinkMessage,
            #[cfg(any(feature = "v1_10", feature = "dox"))]
            26894 => EventType::StreamGroupDone,
            28174 => EventType::Eos,
            30750 => EventType::Toc,
            33310 => EventType::Protection,
            38406 => EventType::SegmentDone,
            40966 => EventType::Gap,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            46090 => EventType::InstantRateChange,
            48641 => EventType::Qos,
            51201 => EventType::Seek,
            53761 => EventType::Navigation,
            56321 => EventType::Latency,
            58881 => EventType::Step,
            61441 => EventType::Reconfigure,
            64001 => EventType::TocSelect,
            #[cfg(any(feature = "v1_10", feature = "dox"))]
            66561 => EventType::SelectStreams,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            66817 => EventType::InstantRateSyncTime,
            69121 => EventType::CustomUpstream,
            71686 => EventType::CustomDownstream,
            74242 => EventType::CustomDownstreamOob,
            76830 => EventType::CustomDownstreamSticky,
            79367 => EventType::CustomBoth,
            81923 => EventType::CustomBothOob,
            value => EventType::__Unknown(value),
        }
    }
}

impl StaticType for EventType {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_event_type_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for EventType {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for EventType {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for EventType {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[must_use]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum FlowReturn {
    CustomSuccess2,
    CustomSuccess1,
    CustomSuccess,
    Ok,
    NotLinked,
    Flushing,
    Eos,
    NotNegotiated,
    Error,
    NotSupported,
    CustomError,
    CustomError1,
    CustomError2,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for FlowReturn {
    type GlibType = gst_sys::GstFlowReturn;

    fn to_glib(&self) -> gst_sys::GstFlowReturn {
        match *self {
            FlowReturn::CustomSuccess2 => gst_sys::GST_FLOW_CUSTOM_SUCCESS_2,
            FlowReturn::CustomSuccess1 => gst_sys::GST_FLOW_CUSTOM_SUCCESS_1,
            FlowReturn::CustomSuccess => gst_sys::GST_FLOW_CUSTOM_SUCCESS,
            FlowReturn::Ok => gst_sys::GST_FLOW_OK,
            FlowReturn::NotLinked => gst_sys::GST_FLOW_NOT_LINKED,
            FlowReturn::Flushing => gst_sys::GST_FLOW_FLUSHING,
            FlowReturn::Eos => gst_sys::GST_FLOW_EOS,
            FlowReturn::NotNegotiated => gst_sys::GST_FLOW_NOT_NEGOTIATED,
            FlowReturn::Error => gst_sys::GST_FLOW_ERROR,
            FlowReturn::NotSupported => gst_sys::GST_FLOW_NOT_SUPPORTED,
            FlowReturn::CustomError => gst_sys::GST_FLOW_CUSTOM_ERROR,
            FlowReturn::CustomError1 => gst_sys::GST_FLOW_CUSTOM_ERROR_1,
            FlowReturn::CustomError2 => gst_sys::GST_FLOW_CUSTOM_ERROR_2,
            FlowReturn::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstFlowReturn> for FlowReturn {
    fn from_glib(value: gst_sys::GstFlowReturn) -> Self {
        skip_assert_initialized!();
        match value {
            102 => FlowReturn::CustomSuccess2,
            101 => FlowReturn::CustomSuccess1,
            100 => FlowReturn::CustomSuccess,
            0 => FlowReturn::Ok,
            -1 => FlowReturn::NotLinked,
            -2 => FlowReturn::Flushing,
            -3 => FlowReturn::Eos,
            -4 => FlowReturn::NotNegotiated,
            -5 => FlowReturn::Error,
            -6 => FlowReturn::NotSupported,
            -100 => FlowReturn::CustomError,
            -101 => FlowReturn::CustomError1,
            -102 => FlowReturn::CustomError2,
            value => FlowReturn::__Unknown(value),
        }
    }
}

impl StaticType for FlowReturn {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_flow_return_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for FlowReturn {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for FlowReturn {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for FlowReturn {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[cfg_attr(feature = "ser_de", derive(Serialize, Deserialize))]
#[derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum Format {
    Undefined,
    Default,
    Bytes,
    Time,
    Buffers,
    Percent,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for Format {
    type GlibType = gst_sys::GstFormat;

    fn to_glib(&self) -> gst_sys::GstFormat {
        match *self {
            Format::Undefined => gst_sys::GST_FORMAT_UNDEFINED,
            Format::Default => gst_sys::GST_FORMAT_DEFAULT,
            Format::Bytes => gst_sys::GST_FORMAT_BYTES,
            Format::Time => gst_sys::GST_FORMAT_TIME,
            Format::Buffers => gst_sys::GST_FORMAT_BUFFERS,
            Format::Percent => gst_sys::GST_FORMAT_PERCENT,
            Format::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstFormat> for Format {
    fn from_glib(value: gst_sys::GstFormat) -> Self {
        skip_assert_initialized!();
        match value {
            0 => Format::Undefined,
            1 => Format::Default,
            2 => Format::Bytes,
            3 => Format::Time,
            4 => Format::Buffers,
            5 => Format::Percent,
            value => Format::__Unknown(value),
        }
    }
}

impl StaticType for Format {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_format_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for Format {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for Format {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for Format {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum LibraryError {
    Failed,
    TooLazy,
    Init,
    Shutdown,
    Settings,
    Encode,
    NumErrors,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for LibraryError {
    type GlibType = gst_sys::GstLibraryError;

    fn to_glib(&self) -> gst_sys::GstLibraryError {
        match *self {
            LibraryError::Failed => gst_sys::GST_LIBRARY_ERROR_FAILED,
            LibraryError::TooLazy => gst_sys::GST_LIBRARY_ERROR_TOO_LAZY,
            LibraryError::Init => gst_sys::GST_LIBRARY_ERROR_INIT,
            LibraryError::Shutdown => gst_sys::GST_LIBRARY_ERROR_SHUTDOWN,
            LibraryError::Settings => gst_sys::GST_LIBRARY_ERROR_SETTINGS,
            LibraryError::Encode => gst_sys::GST_LIBRARY_ERROR_ENCODE,
            LibraryError::NumErrors => gst_sys::GST_LIBRARY_ERROR_NUM_ERRORS,
            LibraryError::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstLibraryError> for LibraryError {
    fn from_glib(value: gst_sys::GstLibraryError) -> Self {
        skip_assert_initialized!();
        match value {
            1 => LibraryError::Failed,
            2 => LibraryError::TooLazy,
            3 => LibraryError::Init,
            4 => LibraryError::Shutdown,
            5 => LibraryError::Settings,
            6 => LibraryError::Encode,
            7 => LibraryError::NumErrors,
            value => LibraryError::__Unknown(value),
        }
    }
}

impl ErrorDomain for LibraryError {
    fn domain() -> Quark {
        skip_assert_initialized!();
        unsafe { from_glib(gst_sys::gst_library_error_quark()) }
    }

    fn code(self) -> i32 {
        self.to_glib()
    }

    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match code {
            1 => Some(LibraryError::Failed),
            2 => Some(LibraryError::TooLazy),
            3 => Some(LibraryError::Init),
            4 => Some(LibraryError::Shutdown),
            5 => Some(LibraryError::Settings),
            6 => Some(LibraryError::Encode),
            7 => Some(LibraryError::NumErrors),
            _ => Some(LibraryError::Failed),
        }
    }
}

impl StaticType for LibraryError {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_library_error_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for LibraryError {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for LibraryError {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for LibraryError {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum PadDirection {
    Unknown,
    Src,
    Sink,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for PadDirection {
    type GlibType = gst_sys::GstPadDirection;

    fn to_glib(&self) -> gst_sys::GstPadDirection {
        match *self {
            PadDirection::Unknown => gst_sys::GST_PAD_UNKNOWN,
            PadDirection::Src => gst_sys::GST_PAD_SRC,
            PadDirection::Sink => gst_sys::GST_PAD_SINK,
            PadDirection::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstPadDirection> for PadDirection {
    fn from_glib(value: gst_sys::GstPadDirection) -> Self {
        skip_assert_initialized!();
        match value {
            0 => PadDirection::Unknown,
            1 => PadDirection::Src,
            2 => PadDirection::Sink,
            value => PadDirection::__Unknown(value),
        }
    }
}

impl StaticType for PadDirection {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_pad_direction_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for PadDirection {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for PadDirection {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for PadDirection {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[must_use]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum PadLinkReturn {
    Ok,
    WrongHierarchy,
    WasLinked,
    WrongDirection,
    Noformat,
    Nosched,
    Refused,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for PadLinkReturn {
    type GlibType = gst_sys::GstPadLinkReturn;

    fn to_glib(&self) -> gst_sys::GstPadLinkReturn {
        match *self {
            PadLinkReturn::Ok => gst_sys::GST_PAD_LINK_OK,
            PadLinkReturn::WrongHierarchy => gst_sys::GST_PAD_LINK_WRONG_HIERARCHY,
            PadLinkReturn::WasLinked => gst_sys::GST_PAD_LINK_WAS_LINKED,
            PadLinkReturn::WrongDirection => gst_sys::GST_PAD_LINK_WRONG_DIRECTION,
            PadLinkReturn::Noformat => gst_sys::GST_PAD_LINK_NOFORMAT,
            PadLinkReturn::Nosched => gst_sys::GST_PAD_LINK_NOSCHED,
            PadLinkReturn::Refused => gst_sys::GST_PAD_LINK_REFUSED,
            PadLinkReturn::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstPadLinkReturn> for PadLinkReturn {
    fn from_glib(value: gst_sys::GstPadLinkReturn) -> Self {
        skip_assert_initialized!();
        match value {
            0 => PadLinkReturn::Ok,
            -1 => PadLinkReturn::WrongHierarchy,
            -2 => PadLinkReturn::WasLinked,
            -3 => PadLinkReturn::WrongDirection,
            -4 => PadLinkReturn::Noformat,
            -5 => PadLinkReturn::Nosched,
            -6 => PadLinkReturn::Refused,
            value => PadLinkReturn::__Unknown(value),
        }
    }
}

impl StaticType for PadLinkReturn {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_pad_link_return_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for PadLinkReturn {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for PadLinkReturn {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for PadLinkReturn {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum PadMode {
    None,
    Push,
    Pull,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for PadMode {
    type GlibType = gst_sys::GstPadMode;

    fn to_glib(&self) -> gst_sys::GstPadMode {
        match *self {
            PadMode::None => gst_sys::GST_PAD_MODE_NONE,
            PadMode::Push => gst_sys::GST_PAD_MODE_PUSH,
            PadMode::Pull => gst_sys::GST_PAD_MODE_PULL,
            PadMode::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstPadMode> for PadMode {
    fn from_glib(value: gst_sys::GstPadMode) -> Self {
        skip_assert_initialized!();
        match value {
            0 => PadMode::None,
            1 => PadMode::Push,
            2 => PadMode::Pull,
            value => PadMode::__Unknown(value),
        }
    }
}

impl StaticType for PadMode {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_pad_mode_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for PadMode {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for PadMode {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for PadMode {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum PadPresence {
    Always,
    Sometimes,
    Request,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for PadPresence {
    type GlibType = gst_sys::GstPadPresence;

    fn to_glib(&self) -> gst_sys::GstPadPresence {
        match *self {
            PadPresence::Always => gst_sys::GST_PAD_ALWAYS,
            PadPresence::Sometimes => gst_sys::GST_PAD_SOMETIMES,
            PadPresence::Request => gst_sys::GST_PAD_REQUEST,
            PadPresence::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstPadPresence> for PadPresence {
    fn from_glib(value: gst_sys::GstPadPresence) -> Self {
        skip_assert_initialized!();
        match value {
            0 => PadPresence::Always,
            1 => PadPresence::Sometimes,
            2 => PadPresence::Request,
            value => PadPresence::__Unknown(value),
        }
    }
}

impl StaticType for PadPresence {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_pad_presence_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for PadPresence {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for PadPresence {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for PadPresence {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum PadProbeReturn {
    Drop,
    Ok,
    Remove,
    Pass,
    Handled,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for PadProbeReturn {
    type GlibType = gst_sys::GstPadProbeReturn;

    fn to_glib(&self) -> gst_sys::GstPadProbeReturn {
        match *self {
            PadProbeReturn::Drop => gst_sys::GST_PAD_PROBE_DROP,
            PadProbeReturn::Ok => gst_sys::GST_PAD_PROBE_OK,
            PadProbeReturn::Remove => gst_sys::GST_PAD_PROBE_REMOVE,
            PadProbeReturn::Pass => gst_sys::GST_PAD_PROBE_PASS,
            PadProbeReturn::Handled => gst_sys::GST_PAD_PROBE_HANDLED,
            PadProbeReturn::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstPadProbeReturn> for PadProbeReturn {
    fn from_glib(value: gst_sys::GstPadProbeReturn) -> Self {
        skip_assert_initialized!();
        match value {
            0 => PadProbeReturn::Drop,
            1 => PadProbeReturn::Ok,
            2 => PadProbeReturn::Remove,
            3 => PadProbeReturn::Pass,
            4 => PadProbeReturn::Handled,
            value => PadProbeReturn::__Unknown(value),
        }
    }
}

impl StaticType for PadProbeReturn {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_pad_probe_return_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for PadProbeReturn {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for PadProbeReturn {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for PadProbeReturn {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum ParseError {
    Syntax,
    NoSuchElement,
    NoSuchProperty,
    Link,
    CouldNotSetProperty,
    EmptyBin,
    Empty,
    DelayedLink,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for ParseError {
    type GlibType = gst_sys::GstParseError;

    fn to_glib(&self) -> gst_sys::GstParseError {
        match *self {
            ParseError::Syntax => gst_sys::GST_PARSE_ERROR_SYNTAX,
            ParseError::NoSuchElement => gst_sys::GST_PARSE_ERROR_NO_SUCH_ELEMENT,
            ParseError::NoSuchProperty => gst_sys::GST_PARSE_ERROR_NO_SUCH_PROPERTY,
            ParseError::Link => gst_sys::GST_PARSE_ERROR_LINK,
            ParseError::CouldNotSetProperty => gst_sys::GST_PARSE_ERROR_COULD_NOT_SET_PROPERTY,
            ParseError::EmptyBin => gst_sys::GST_PARSE_ERROR_EMPTY_BIN,
            ParseError::Empty => gst_sys::GST_PARSE_ERROR_EMPTY,
            ParseError::DelayedLink => gst_sys::GST_PARSE_ERROR_DELAYED_LINK,
            ParseError::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstParseError> for ParseError {
    fn from_glib(value: gst_sys::GstParseError) -> Self {
        skip_assert_initialized!();
        match value {
            0 => ParseError::Syntax,
            1 => ParseError::NoSuchElement,
            2 => ParseError::NoSuchProperty,
            3 => ParseError::Link,
            4 => ParseError::CouldNotSetProperty,
            5 => ParseError::EmptyBin,
            6 => ParseError::Empty,
            7 => ParseError::DelayedLink,
            value => ParseError::__Unknown(value),
        }
    }
}

impl ErrorDomain for ParseError {
    fn domain() -> Quark {
        skip_assert_initialized!();
        unsafe { from_glib(gst_sys::gst_parse_error_quark()) }
    }

    fn code(self) -> i32 {
        self.to_glib()
    }

    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match code {
            0 => Some(ParseError::Syntax),
            1 => Some(ParseError::NoSuchElement),
            2 => Some(ParseError::NoSuchProperty),
            3 => Some(ParseError::Link),
            4 => Some(ParseError::CouldNotSetProperty),
            5 => Some(ParseError::EmptyBin),
            6 => Some(ParseError::Empty),
            7 => Some(ParseError::DelayedLink),
            value => Some(ParseError::__Unknown(value)),
        }
    }
}

impl StaticType for ParseError {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_parse_error_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for ParseError {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for ParseError {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for ParseError {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum PluginError {
    Module,
    Dependencies,
    NameMismatch,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for PluginError {
    type GlibType = gst_sys::GstPluginError;

    fn to_glib(&self) -> gst_sys::GstPluginError {
        match *self {
            PluginError::Module => gst_sys::GST_PLUGIN_ERROR_MODULE,
            PluginError::Dependencies => gst_sys::GST_PLUGIN_ERROR_DEPENDENCIES,
            PluginError::NameMismatch => gst_sys::GST_PLUGIN_ERROR_NAME_MISMATCH,
            PluginError::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstPluginError> for PluginError {
    fn from_glib(value: gst_sys::GstPluginError) -> Self {
        skip_assert_initialized!();
        match value {
            0 => PluginError::Module,
            1 => PluginError::Dependencies,
            2 => PluginError::NameMismatch,
            value => PluginError::__Unknown(value),
        }
    }
}

impl ErrorDomain for PluginError {
    fn domain() -> Quark {
        skip_assert_initialized!();
        unsafe { from_glib(gst_sys::gst_plugin_error_quark()) }
    }

    fn code(self) -> i32 {
        self.to_glib()
    }

    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match code {
            0 => Some(PluginError::Module),
            1 => Some(PluginError::Dependencies),
            2 => Some(PluginError::NameMismatch),
            value => Some(PluginError::__Unknown(value)),
        }
    }
}

impl StaticType for PluginError {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_plugin_error_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for PluginError {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for PluginError {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for PluginError {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum ProgressType {
    Start,
    Continue,
    Complete,
    Canceled,
    Error,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for ProgressType {
    type GlibType = gst_sys::GstProgressType;

    fn to_glib(&self) -> gst_sys::GstProgressType {
        match *self {
            ProgressType::Start => gst_sys::GST_PROGRESS_TYPE_START,
            ProgressType::Continue => gst_sys::GST_PROGRESS_TYPE_CONTINUE,
            ProgressType::Complete => gst_sys::GST_PROGRESS_TYPE_COMPLETE,
            ProgressType::Canceled => gst_sys::GST_PROGRESS_TYPE_CANCELED,
            ProgressType::Error => gst_sys::GST_PROGRESS_TYPE_ERROR,
            ProgressType::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstProgressType> for ProgressType {
    fn from_glib(value: gst_sys::GstProgressType) -> Self {
        skip_assert_initialized!();
        match value {
            0 => ProgressType::Start,
            1 => ProgressType::Continue,
            2 => ProgressType::Complete,
            3 => ProgressType::Canceled,
            4 => ProgressType::Error,
            value => ProgressType::__Unknown(value),
        }
    }
}

impl StaticType for ProgressType {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_progress_type_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for ProgressType {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for ProgressType {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for ProgressType {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[cfg(any(feature = "v1_14", feature = "dox"))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum PromiseResult {
    Pending,
    Interrupted,
    Replied,
    Expired,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v1_14", feature = "dox"))]
#[doc(hidden)]
impl ToGlib for PromiseResult {
    type GlibType = gst_sys::GstPromiseResult;

    fn to_glib(&self) -> gst_sys::GstPromiseResult {
        match *self {
            PromiseResult::Pending => gst_sys::GST_PROMISE_RESULT_PENDING,
            PromiseResult::Interrupted => gst_sys::GST_PROMISE_RESULT_INTERRUPTED,
            PromiseResult::Replied => gst_sys::GST_PROMISE_RESULT_REPLIED,
            PromiseResult::Expired => gst_sys::GST_PROMISE_RESULT_EXPIRED,
            PromiseResult::__Unknown(value) => value,
        }
    }
}

#[cfg(any(feature = "v1_14", feature = "dox"))]
#[doc(hidden)]
impl FromGlib<gst_sys::GstPromiseResult> for PromiseResult {
    fn from_glib(value: gst_sys::GstPromiseResult) -> Self {
        skip_assert_initialized!();
        match value {
            0 => PromiseResult::Pending,
            1 => PromiseResult::Interrupted,
            2 => PromiseResult::Replied,
            3 => PromiseResult::Expired,
            value => PromiseResult::__Unknown(value),
        }
    }
}

#[cfg(any(feature = "v1_14", feature = "dox"))]
impl StaticType for PromiseResult {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_promise_result_get_type()) }
    }
}

#[cfg(any(feature = "v1_14", feature = "dox"))]
impl<'a> FromValueOptional<'a> for PromiseResult {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

#[cfg(any(feature = "v1_14", feature = "dox"))]
impl<'a> FromValue<'a> for PromiseResult {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v1_14", feature = "dox"))]
impl SetValue for PromiseResult {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum QOSType {
    Overflow,
    Underflow,
    Throttle,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for QOSType {
    type GlibType = gst_sys::GstQOSType;

    fn to_glib(&self) -> gst_sys::GstQOSType {
        match *self {
            QOSType::Overflow => gst_sys::GST_QOS_TYPE_OVERFLOW,
            QOSType::Underflow => gst_sys::GST_QOS_TYPE_UNDERFLOW,
            QOSType::Throttle => gst_sys::GST_QOS_TYPE_THROTTLE,
            QOSType::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstQOSType> for QOSType {
    fn from_glib(value: gst_sys::GstQOSType) -> Self {
        skip_assert_initialized!();
        match value {
            0 => QOSType::Overflow,
            1 => QOSType::Underflow,
            2 => QOSType::Throttle,
            value => QOSType::__Unknown(value),
        }
    }
}

impl StaticType for QOSType {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_qos_type_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for QOSType {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for QOSType {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for QOSType {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Clone, Copy)]
#[non_exhaustive]
pub enum Rank {
    None,
    Marginal,
    Secondary,
    Primary,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for Rank {
    type GlibType = gst_sys::GstRank;

    fn to_glib(&self) -> gst_sys::GstRank {
        match *self {
            Rank::None => gst_sys::GST_RANK_NONE,
            Rank::Marginal => gst_sys::GST_RANK_MARGINAL,
            Rank::Secondary => gst_sys::GST_RANK_SECONDARY,
            Rank::Primary => gst_sys::GST_RANK_PRIMARY,
            Rank::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstRank> for Rank {
    fn from_glib(value: gst_sys::GstRank) -> Self {
        skip_assert_initialized!();
        match value {
            0 => Rank::None,
            64 => Rank::Marginal,
            128 => Rank::Secondary,
            256 => Rank::Primary,
            value => Rank::__Unknown(value),
        }
    }
}

impl StaticType for Rank {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_rank_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for Rank {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for Rank {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for Rank {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum ResourceError {
    Failed,
    TooLazy,
    NotFound,
    Busy,
    OpenRead,
    OpenWrite,
    OpenReadWrite,
    Close,
    Read,
    Write,
    Seek,
    Sync,
    Settings,
    NoSpaceLeft,
    NotAuthorized,
    NumErrors,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for ResourceError {
    type GlibType = gst_sys::GstResourceError;

    fn to_glib(&self) -> gst_sys::GstResourceError {
        match *self {
            ResourceError::Failed => gst_sys::GST_RESOURCE_ERROR_FAILED,
            ResourceError::TooLazy => gst_sys::GST_RESOURCE_ERROR_TOO_LAZY,
            ResourceError::NotFound => gst_sys::GST_RESOURCE_ERROR_NOT_FOUND,
            ResourceError::Busy => gst_sys::GST_RESOURCE_ERROR_BUSY,
            ResourceError::OpenRead => gst_sys::GST_RESOURCE_ERROR_OPEN_READ,
            ResourceError::OpenWrite => gst_sys::GST_RESOURCE_ERROR_OPEN_WRITE,
            ResourceError::OpenReadWrite => gst_sys::GST_RESOURCE_ERROR_OPEN_READ_WRITE,
            ResourceError::Close => gst_sys::GST_RESOURCE_ERROR_CLOSE,
            ResourceError::Read => gst_sys::GST_RESOURCE_ERROR_READ,
            ResourceError::Write => gst_sys::GST_RESOURCE_ERROR_WRITE,
            ResourceError::Seek => gst_sys::GST_RESOURCE_ERROR_SEEK,
            ResourceError::Sync => gst_sys::GST_RESOURCE_ERROR_SYNC,
            ResourceError::Settings => gst_sys::GST_RESOURCE_ERROR_SETTINGS,
            ResourceError::NoSpaceLeft => gst_sys::GST_RESOURCE_ERROR_NO_SPACE_LEFT,
            ResourceError::NotAuthorized => gst_sys::GST_RESOURCE_ERROR_NOT_AUTHORIZED,
            ResourceError::NumErrors => gst_sys::GST_RESOURCE_ERROR_NUM_ERRORS,
            ResourceError::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstResourceError> for ResourceError {
    fn from_glib(value: gst_sys::GstResourceError) -> Self {
        skip_assert_initialized!();
        match value {
            1 => ResourceError::Failed,
            2 => ResourceError::TooLazy,
            3 => ResourceError::NotFound,
            4 => ResourceError::Busy,
            5 => ResourceError::OpenRead,
            6 => ResourceError::OpenWrite,
            7 => ResourceError::OpenReadWrite,
            8 => ResourceError::Close,
            9 => ResourceError::Read,
            10 => ResourceError::Write,
            11 => ResourceError::Seek,
            12 => ResourceError::Sync,
            13 => ResourceError::Settings,
            14 => ResourceError::NoSpaceLeft,
            15 => ResourceError::NotAuthorized,
            16 => ResourceError::NumErrors,
            value => ResourceError::__Unknown(value),
        }
    }
}

impl ErrorDomain for ResourceError {
    fn domain() -> Quark {
        skip_assert_initialized!();
        unsafe { from_glib(gst_sys::gst_resource_error_quark()) }
    }

    fn code(self) -> i32 {
        self.to_glib()
    }

    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match code {
            1 => Some(ResourceError::Failed),
            2 => Some(ResourceError::TooLazy),
            3 => Some(ResourceError::NotFound),
            4 => Some(ResourceError::Busy),
            5 => Some(ResourceError::OpenRead),
            6 => Some(ResourceError::OpenWrite),
            7 => Some(ResourceError::OpenReadWrite),
            8 => Some(ResourceError::Close),
            9 => Some(ResourceError::Read),
            10 => Some(ResourceError::Write),
            11 => Some(ResourceError::Seek),
            12 => Some(ResourceError::Sync),
            13 => Some(ResourceError::Settings),
            14 => Some(ResourceError::NoSpaceLeft),
            15 => Some(ResourceError::NotAuthorized),
            16 => Some(ResourceError::NumErrors),
            _ => Some(ResourceError::Failed),
        }
    }
}

impl StaticType for ResourceError {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_resource_error_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for ResourceError {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for ResourceError {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for ResourceError {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum SeekType {
    None,
    Set,
    End,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for SeekType {
    type GlibType = gst_sys::GstSeekType;

    fn to_glib(&self) -> gst_sys::GstSeekType {
        match *self {
            SeekType::None => gst_sys::GST_SEEK_TYPE_NONE,
            SeekType::Set => gst_sys::GST_SEEK_TYPE_SET,
            SeekType::End => gst_sys::GST_SEEK_TYPE_END,
            SeekType::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstSeekType> for SeekType {
    fn from_glib(value: gst_sys::GstSeekType) -> Self {
        skip_assert_initialized!();
        match value {
            0 => SeekType::None,
            1 => SeekType::Set,
            2 => SeekType::End,
            value => SeekType::__Unknown(value),
        }
    }
}

impl StaticType for SeekType {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_seek_type_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for SeekType {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for SeekType {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for SeekType {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum State {
    VoidPending,
    Null,
    Ready,
    Paused,
    Playing,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for State {
    type GlibType = gst_sys::GstState;

    fn to_glib(&self) -> gst_sys::GstState {
        match *self {
            State::VoidPending => gst_sys::GST_STATE_VOID_PENDING,
            State::Null => gst_sys::GST_STATE_NULL,
            State::Ready => gst_sys::GST_STATE_READY,
            State::Paused => gst_sys::GST_STATE_PAUSED,
            State::Playing => gst_sys::GST_STATE_PLAYING,
            State::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstState> for State {
    fn from_glib(value: gst_sys::GstState) -> Self {
        skip_assert_initialized!();
        match value {
            0 => State::VoidPending,
            1 => State::Null,
            2 => State::Ready,
            3 => State::Paused,
            4 => State::Playing,
            value => State::__Unknown(value),
        }
    }
}

impl StaticType for State {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_state_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for State {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for State {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for State {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum StateChange {
    NullToReady,
    ReadyToPaused,
    PausedToPlaying,
    PlayingToPaused,
    PausedToReady,
    ReadyToNull,
    NullToNull,
    ReadyToReady,
    PausedToPaused,
    PlayingToPlaying,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for StateChange {
    type GlibType = gst_sys::GstStateChange;

    fn to_glib(&self) -> gst_sys::GstStateChange {
        match *self {
            StateChange::NullToReady => gst_sys::GST_STATE_CHANGE_NULL_TO_READY,
            StateChange::ReadyToPaused => gst_sys::GST_STATE_CHANGE_READY_TO_PAUSED,
            StateChange::PausedToPlaying => gst_sys::GST_STATE_CHANGE_PAUSED_TO_PLAYING,
            StateChange::PlayingToPaused => gst_sys::GST_STATE_CHANGE_PLAYING_TO_PAUSED,
            StateChange::PausedToReady => gst_sys::GST_STATE_CHANGE_PAUSED_TO_READY,
            StateChange::ReadyToNull => gst_sys::GST_STATE_CHANGE_READY_TO_NULL,
            StateChange::NullToNull => gst_sys::GST_STATE_CHANGE_NULL_TO_NULL,
            StateChange::ReadyToReady => gst_sys::GST_STATE_CHANGE_READY_TO_READY,
            StateChange::PausedToPaused => gst_sys::GST_STATE_CHANGE_PAUSED_TO_PAUSED,
            StateChange::PlayingToPlaying => gst_sys::GST_STATE_CHANGE_PLAYING_TO_PLAYING,
            StateChange::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstStateChange> for StateChange {
    fn from_glib(value: gst_sys::GstStateChange) -> Self {
        skip_assert_initialized!();
        match value {
            10 => StateChange::NullToReady,
            19 => StateChange::ReadyToPaused,
            28 => StateChange::PausedToPlaying,
            35 => StateChange::PlayingToPaused,
            26 => StateChange::PausedToReady,
            17 => StateChange::ReadyToNull,
            9 => StateChange::NullToNull,
            18 => StateChange::ReadyToReady,
            27 => StateChange::PausedToPaused,
            36 => StateChange::PlayingToPlaying,
            value => StateChange::__Unknown(value),
        }
    }
}

impl StaticType for StateChange {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_state_change_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for StateChange {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for StateChange {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for StateChange {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[must_use]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum StateChangeReturn {
    Failure,
    Success,
    Async,
    NoPreroll,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for StateChangeReturn {
    type GlibType = gst_sys::GstStateChangeReturn;

    fn to_glib(&self) -> gst_sys::GstStateChangeReturn {
        match *self {
            StateChangeReturn::Failure => gst_sys::GST_STATE_CHANGE_FAILURE,
            StateChangeReturn::Success => gst_sys::GST_STATE_CHANGE_SUCCESS,
            StateChangeReturn::Async => gst_sys::GST_STATE_CHANGE_ASYNC,
            StateChangeReturn::NoPreroll => gst_sys::GST_STATE_CHANGE_NO_PREROLL,
            StateChangeReturn::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstStateChangeReturn> for StateChangeReturn {
    fn from_glib(value: gst_sys::GstStateChangeReturn) -> Self {
        skip_assert_initialized!();
        match value {
            0 => StateChangeReturn::Failure,
            1 => StateChangeReturn::Success,
            2 => StateChangeReturn::Async,
            3 => StateChangeReturn::NoPreroll,
            value => StateChangeReturn::__Unknown(value),
        }
    }
}

impl StaticType for StateChangeReturn {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_state_change_return_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for StateChangeReturn {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for StateChangeReturn {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for StateChangeReturn {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum StreamError {
    Failed,
    TooLazy,
    NotImplemented,
    TypeNotFound,
    WrongType,
    CodecNotFound,
    Decode,
    Encode,
    Demux,
    Mux,
    Format,
    Decrypt,
    DecryptNokey,
    NumErrors,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for StreamError {
    type GlibType = gst_sys::GstStreamError;

    fn to_glib(&self) -> gst_sys::GstStreamError {
        match *self {
            StreamError::Failed => gst_sys::GST_STREAM_ERROR_FAILED,
            StreamError::TooLazy => gst_sys::GST_STREAM_ERROR_TOO_LAZY,
            StreamError::NotImplemented => gst_sys::GST_STREAM_ERROR_NOT_IMPLEMENTED,
            StreamError::TypeNotFound => gst_sys::GST_STREAM_ERROR_TYPE_NOT_FOUND,
            StreamError::WrongType => gst_sys::GST_STREAM_ERROR_WRONG_TYPE,
            StreamError::CodecNotFound => gst_sys::GST_STREAM_ERROR_CODEC_NOT_FOUND,
            StreamError::Decode => gst_sys::GST_STREAM_ERROR_DECODE,
            StreamError::Encode => gst_sys::GST_STREAM_ERROR_ENCODE,
            StreamError::Demux => gst_sys::GST_STREAM_ERROR_DEMUX,
            StreamError::Mux => gst_sys::GST_STREAM_ERROR_MUX,
            StreamError::Format => gst_sys::GST_STREAM_ERROR_FORMAT,
            StreamError::Decrypt => gst_sys::GST_STREAM_ERROR_DECRYPT,
            StreamError::DecryptNokey => gst_sys::GST_STREAM_ERROR_DECRYPT_NOKEY,
            StreamError::NumErrors => gst_sys::GST_STREAM_ERROR_NUM_ERRORS,
            StreamError::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstStreamError> for StreamError {
    fn from_glib(value: gst_sys::GstStreamError) -> Self {
        skip_assert_initialized!();
        match value {
            1 => StreamError::Failed,
            2 => StreamError::TooLazy,
            3 => StreamError::NotImplemented,
            4 => StreamError::TypeNotFound,
            5 => StreamError::WrongType,
            6 => StreamError::CodecNotFound,
            7 => StreamError::Decode,
            8 => StreamError::Encode,
            9 => StreamError::Demux,
            10 => StreamError::Mux,
            11 => StreamError::Format,
            12 => StreamError::Decrypt,
            13 => StreamError::DecryptNokey,
            14 => StreamError::NumErrors,
            value => StreamError::__Unknown(value),
        }
    }
}

impl ErrorDomain for StreamError {
    fn domain() -> Quark {
        skip_assert_initialized!();
        unsafe { from_glib(gst_sys::gst_stream_error_quark()) }
    }

    fn code(self) -> i32 {
        self.to_glib()
    }

    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match code {
            1 => Some(StreamError::Failed),
            2 => Some(StreamError::TooLazy),
            3 => Some(StreamError::NotImplemented),
            4 => Some(StreamError::TypeNotFound),
            5 => Some(StreamError::WrongType),
            6 => Some(StreamError::CodecNotFound),
            7 => Some(StreamError::Decode),
            8 => Some(StreamError::Encode),
            9 => Some(StreamError::Demux),
            10 => Some(StreamError::Mux),
            11 => Some(StreamError::Format),
            12 => Some(StreamError::Decrypt),
            13 => Some(StreamError::DecryptNokey),
            14 => Some(StreamError::NumErrors),
            _ => Some(StreamError::Failed),
        }
    }
}

impl StaticType for StreamError {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_stream_error_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for StreamError {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for StreamError {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for StreamError {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum StreamStatusType {
    Create,
    Enter,
    Leave,
    Destroy,
    Start,
    Pause,
    Stop,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for StreamStatusType {
    type GlibType = gst_sys::GstStreamStatusType;

    fn to_glib(&self) -> gst_sys::GstStreamStatusType {
        match *self {
            StreamStatusType::Create => gst_sys::GST_STREAM_STATUS_TYPE_CREATE,
            StreamStatusType::Enter => gst_sys::GST_STREAM_STATUS_TYPE_ENTER,
            StreamStatusType::Leave => gst_sys::GST_STREAM_STATUS_TYPE_LEAVE,
            StreamStatusType::Destroy => gst_sys::GST_STREAM_STATUS_TYPE_DESTROY,
            StreamStatusType::Start => gst_sys::GST_STREAM_STATUS_TYPE_START,
            StreamStatusType::Pause => gst_sys::GST_STREAM_STATUS_TYPE_PAUSE,
            StreamStatusType::Stop => gst_sys::GST_STREAM_STATUS_TYPE_STOP,
            StreamStatusType::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstStreamStatusType> for StreamStatusType {
    fn from_glib(value: gst_sys::GstStreamStatusType) -> Self {
        skip_assert_initialized!();
        match value {
            0 => StreamStatusType::Create,
            1 => StreamStatusType::Enter,
            2 => StreamStatusType::Leave,
            3 => StreamStatusType::Destroy,
            8 => StreamStatusType::Start,
            9 => StreamStatusType::Pause,
            10 => StreamStatusType::Stop,
            value => StreamStatusType::__Unknown(value),
        }
    }
}

impl StaticType for StreamStatusType {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_stream_status_type_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for StreamStatusType {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for StreamStatusType {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for StreamStatusType {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum StructureChangeType {
    Link,
    Unlink,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for StructureChangeType {
    type GlibType = gst_sys::GstStructureChangeType;

    fn to_glib(&self) -> gst_sys::GstStructureChangeType {
        match *self {
            StructureChangeType::Link => gst_sys::GST_STRUCTURE_CHANGE_TYPE_PAD_LINK,
            StructureChangeType::Unlink => gst_sys::GST_STRUCTURE_CHANGE_TYPE_PAD_UNLINK,
            StructureChangeType::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstStructureChangeType> for StructureChangeType {
    fn from_glib(value: gst_sys::GstStructureChangeType) -> Self {
        skip_assert_initialized!();
        match value {
            0 => StructureChangeType::Link,
            1 => StructureChangeType::Unlink,
            value => StructureChangeType::__Unknown(value),
        }
    }
}

impl StaticType for StructureChangeType {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_structure_change_type_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for StructureChangeType {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for StructureChangeType {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for StructureChangeType {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum TagFlag {
    Undefined,
    Meta,
    Encoded,
    Decoded,
    Count,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for TagFlag {
    type GlibType = gst_sys::GstTagFlag;

    fn to_glib(&self) -> gst_sys::GstTagFlag {
        match *self {
            TagFlag::Undefined => gst_sys::GST_TAG_FLAG_UNDEFINED,
            TagFlag::Meta => gst_sys::GST_TAG_FLAG_META,
            TagFlag::Encoded => gst_sys::GST_TAG_FLAG_ENCODED,
            TagFlag::Decoded => gst_sys::GST_TAG_FLAG_DECODED,
            TagFlag::Count => gst_sys::GST_TAG_FLAG_COUNT,
            TagFlag::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstTagFlag> for TagFlag {
    fn from_glib(value: gst_sys::GstTagFlag) -> Self {
        skip_assert_initialized!();
        match value {
            0 => TagFlag::Undefined,
            1 => TagFlag::Meta,
            2 => TagFlag::Encoded,
            3 => TagFlag::Decoded,
            4 => TagFlag::Count,
            value => TagFlag::__Unknown(value),
        }
    }
}

impl StaticType for TagFlag {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_tag_flag_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for TagFlag {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for TagFlag {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for TagFlag {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum TagMergeMode {
    Undefined,
    ReplaceAll,
    Replace,
    Append,
    Prepend,
    Keep,
    KeepAll,
    Count,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for TagMergeMode {
    type GlibType = gst_sys::GstTagMergeMode;

    fn to_glib(&self) -> gst_sys::GstTagMergeMode {
        match *self {
            TagMergeMode::Undefined => gst_sys::GST_TAG_MERGE_UNDEFINED,
            TagMergeMode::ReplaceAll => gst_sys::GST_TAG_MERGE_REPLACE_ALL,
            TagMergeMode::Replace => gst_sys::GST_TAG_MERGE_REPLACE,
            TagMergeMode::Append => gst_sys::GST_TAG_MERGE_APPEND,
            TagMergeMode::Prepend => gst_sys::GST_TAG_MERGE_PREPEND,
            TagMergeMode::Keep => gst_sys::GST_TAG_MERGE_KEEP,
            TagMergeMode::KeepAll => gst_sys::GST_TAG_MERGE_KEEP_ALL,
            TagMergeMode::Count => gst_sys::GST_TAG_MERGE_COUNT,
            TagMergeMode::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstTagMergeMode> for TagMergeMode {
    fn from_glib(value: gst_sys::GstTagMergeMode) -> Self {
        skip_assert_initialized!();
        match value {
            0 => TagMergeMode::Undefined,
            1 => TagMergeMode::ReplaceAll,
            2 => TagMergeMode::Replace,
            3 => TagMergeMode::Append,
            4 => TagMergeMode::Prepend,
            5 => TagMergeMode::Keep,
            6 => TagMergeMode::KeepAll,
            7 => TagMergeMode::Count,
            value => TagMergeMode::__Unknown(value),
        }
    }
}

impl StaticType for TagMergeMode {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_tag_merge_mode_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for TagMergeMode {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for TagMergeMode {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for TagMergeMode {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[cfg_attr(feature = "ser_de", derive(Serialize, Deserialize))]
#[derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum TagScope {
    Stream,
    Global,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for TagScope {
    type GlibType = gst_sys::GstTagScope;

    fn to_glib(&self) -> gst_sys::GstTagScope {
        match *self {
            TagScope::Stream => gst_sys::GST_TAG_SCOPE_STREAM,
            TagScope::Global => gst_sys::GST_TAG_SCOPE_GLOBAL,
            TagScope::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstTagScope> for TagScope {
    fn from_glib(value: gst_sys::GstTagScope) -> Self {
        skip_assert_initialized!();
        match value {
            0 => TagScope::Stream,
            1 => TagScope::Global,
            value => TagScope::__Unknown(value),
        }
    }
}

impl StaticType for TagScope {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_tag_scope_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for TagScope {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for TagScope {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for TagScope {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum TaskState {
    Started,
    Stopped,
    Paused,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for TaskState {
    type GlibType = gst_sys::GstTaskState;

    fn to_glib(&self) -> gst_sys::GstTaskState {
        match *self {
            TaskState::Started => gst_sys::GST_TASK_STARTED,
            TaskState::Stopped => gst_sys::GST_TASK_STOPPED,
            TaskState::Paused => gst_sys::GST_TASK_PAUSED,
            TaskState::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstTaskState> for TaskState {
    fn from_glib(value: gst_sys::GstTaskState) -> Self {
        skip_assert_initialized!();
        match value {
            0 => TaskState::Started,
            1 => TaskState::Stopped,
            2 => TaskState::Paused,
            value => TaskState::__Unknown(value),
        }
    }
}

impl StaticType for TaskState {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_task_state_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for TaskState {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for TaskState {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for TaskState {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[cfg_attr(feature = "ser_de", derive(Serialize, Deserialize))]
#[derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum TocEntryType {
    Angle,
    Version,
    Edition,
    Invalid,
    Title,
    Track,
    Chapter,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for TocEntryType {
    type GlibType = gst_sys::GstTocEntryType;

    fn to_glib(&self) -> gst_sys::GstTocEntryType {
        match *self {
            TocEntryType::Angle => gst_sys::GST_TOC_ENTRY_TYPE_ANGLE,
            TocEntryType::Version => gst_sys::GST_TOC_ENTRY_TYPE_VERSION,
            TocEntryType::Edition => gst_sys::GST_TOC_ENTRY_TYPE_EDITION,
            TocEntryType::Invalid => gst_sys::GST_TOC_ENTRY_TYPE_INVALID,
            TocEntryType::Title => gst_sys::GST_TOC_ENTRY_TYPE_TITLE,
            TocEntryType::Track => gst_sys::GST_TOC_ENTRY_TYPE_TRACK,
            TocEntryType::Chapter => gst_sys::GST_TOC_ENTRY_TYPE_CHAPTER,
            TocEntryType::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstTocEntryType> for TocEntryType {
    fn from_glib(value: gst_sys::GstTocEntryType) -> Self {
        skip_assert_initialized!();
        match value {
            -3 => TocEntryType::Angle,
            -2 => TocEntryType::Version,
            -1 => TocEntryType::Edition,
            0 => TocEntryType::Invalid,
            1 => TocEntryType::Title,
            2 => TocEntryType::Track,
            3 => TocEntryType::Chapter,
            value => TocEntryType::__Unknown(value),
        }
    }
}

impl StaticType for TocEntryType {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_toc_entry_type_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for TocEntryType {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for TocEntryType {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for TocEntryType {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[cfg_attr(feature = "ser_de", derive(Serialize, Deserialize))]
#[derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum TocLoopType {
    None,
    Forward,
    Reverse,
    PingPong,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for TocLoopType {
    type GlibType = gst_sys::GstTocLoopType;

    fn to_glib(&self) -> gst_sys::GstTocLoopType {
        match *self {
            TocLoopType::None => gst_sys::GST_TOC_LOOP_NONE,
            TocLoopType::Forward => gst_sys::GST_TOC_LOOP_FORWARD,
            TocLoopType::Reverse => gst_sys::GST_TOC_LOOP_REVERSE,
            TocLoopType::PingPong => gst_sys::GST_TOC_LOOP_PING_PONG,
            TocLoopType::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstTocLoopType> for TocLoopType {
    fn from_glib(value: gst_sys::GstTocLoopType) -> Self {
        skip_assert_initialized!();
        match value {
            0 => TocLoopType::None,
            1 => TocLoopType::Forward,
            2 => TocLoopType::Reverse,
            3 => TocLoopType::PingPong,
            value => TocLoopType::__Unknown(value),
        }
    }
}

impl StaticType for TocLoopType {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_toc_loop_type_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for TocLoopType {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for TocLoopType {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for TocLoopType {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[cfg_attr(feature = "ser_de", derive(Serialize, Deserialize))]
#[derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum TocScope {
    Global,
    Current,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for TocScope {
    type GlibType = gst_sys::GstTocScope;

    fn to_glib(&self) -> gst_sys::GstTocScope {
        match *self {
            TocScope::Global => gst_sys::GST_TOC_SCOPE_GLOBAL,
            TocScope::Current => gst_sys::GST_TOC_SCOPE_CURRENT,
            TocScope::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstTocScope> for TocScope {
    fn from_glib(value: gst_sys::GstTocScope) -> Self {
        skip_assert_initialized!();
        match value {
            1 => TocScope::Global,
            2 => TocScope::Current,
            value => TocScope::__Unknown(value),
        }
    }
}

impl StaticType for TocScope {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_toc_scope_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for TocScope {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for TocScope {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for TocScope {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Clone, Copy)]
#[non_exhaustive]
pub enum TypeFindProbability {
    None,
    Minimum,
    Possible,
    Likely,
    NearlyCertain,
    Maximum,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for TypeFindProbability {
    type GlibType = gst_sys::GstTypeFindProbability;

    fn to_glib(&self) -> gst_sys::GstTypeFindProbability {
        match *self {
            TypeFindProbability::None => gst_sys::GST_TYPE_FIND_NONE,
            TypeFindProbability::Minimum => gst_sys::GST_TYPE_FIND_MINIMUM,
            TypeFindProbability::Possible => gst_sys::GST_TYPE_FIND_POSSIBLE,
            TypeFindProbability::Likely => gst_sys::GST_TYPE_FIND_LIKELY,
            TypeFindProbability::NearlyCertain => gst_sys::GST_TYPE_FIND_NEARLY_CERTAIN,
            TypeFindProbability::Maximum => gst_sys::GST_TYPE_FIND_MAXIMUM,
            TypeFindProbability::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstTypeFindProbability> for TypeFindProbability {
    fn from_glib(value: gst_sys::GstTypeFindProbability) -> Self {
        skip_assert_initialized!();
        match value {
            0 => TypeFindProbability::None,
            1 => TypeFindProbability::Minimum,
            50 => TypeFindProbability::Possible,
            80 => TypeFindProbability::Likely,
            99 => TypeFindProbability::NearlyCertain,
            100 => TypeFindProbability::Maximum,
            value => TypeFindProbability::__Unknown(value),
        }
    }
}

impl StaticType for TypeFindProbability {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_type_find_probability_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for TypeFindProbability {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for TypeFindProbability {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for TypeFindProbability {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum URIError {
    UnsupportedProtocol,
    BadUri,
    BadState,
    BadReference,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for URIError {
    type GlibType = gst_sys::GstURIError;

    fn to_glib(&self) -> gst_sys::GstURIError {
        match *self {
            URIError::UnsupportedProtocol => gst_sys::GST_URI_ERROR_UNSUPPORTED_PROTOCOL,
            URIError::BadUri => gst_sys::GST_URI_ERROR_BAD_URI,
            URIError::BadState => gst_sys::GST_URI_ERROR_BAD_STATE,
            URIError::BadReference => gst_sys::GST_URI_ERROR_BAD_REFERENCE,
            URIError::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstURIError> for URIError {
    fn from_glib(value: gst_sys::GstURIError) -> Self {
        skip_assert_initialized!();
        match value {
            0 => URIError::UnsupportedProtocol,
            1 => URIError::BadUri,
            2 => URIError::BadState,
            3 => URIError::BadReference,
            value => URIError::__Unknown(value),
        }
    }
}

impl ErrorDomain for URIError {
    fn domain() -> Quark {
        skip_assert_initialized!();
        unsafe { from_glib(gst_sys::gst_uri_error_quark()) }
    }

    fn code(self) -> i32 {
        self.to_glib()
    }

    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match code {
            0 => Some(URIError::UnsupportedProtocol),
            1 => Some(URIError::BadUri),
            2 => Some(URIError::BadState),
            3 => Some(URIError::BadReference),
            value => Some(URIError::__Unknown(value)),
        }
    }
}

impl StaticType for URIError {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_uri_error_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for URIError {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for URIError {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for URIError {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum URIType {
    Unknown,
    Sink,
    Src,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for URIType {
    type GlibType = gst_sys::GstURIType;

    fn to_glib(&self) -> gst_sys::GstURIType {
        match *self {
            URIType::Unknown => gst_sys::GST_URI_UNKNOWN,
            URIType::Sink => gst_sys::GST_URI_SINK,
            URIType::Src => gst_sys::GST_URI_SRC,
            URIType::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<gst_sys::GstURIType> for URIType {
    fn from_glib(value: gst_sys::GstURIType) -> Self {
        skip_assert_initialized!();
        match value {
            0 => URIType::Unknown,
            1 => URIType::Sink,
            2 => URIType::Src,
            value => URIType::__Unknown(value),
        }
    }
}

impl StaticType for URIType {
    fn static_type() -> Type {
        unsafe { from_glib(gst_sys::gst_uri_type_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for URIType {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for URIType {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for URIType {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}
