/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */

/* This file is automatically generated using bindtool */

#include <pybind11/complex.h>
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

#include <gnuradio/qtgui/utils.h>
#include <qwt_legend.h>
#include <qwt_painter.h>
#include <qwt_plot.h>
#include <qwt_plot_canvas.h>
#include <qwt_plot_curve.h>
#include <qwt_plot_magnifier.h>
#include <qwt_plot_marker.h>
#include <qwt_plot_panner.h>
#include <qwt_plot_zoomer.h>
#include <qwt_scale_engine.h>
#include <qwt_scale_widget.h>
#include <qwt_symbol.h>

#include <gnuradio/qtgui/freq_sink_f.h>
// pydoc.h is automatically generated in the build directory
#include <freq_sink_f_pydoc.h>

void bind_freq_sink_f(py::module& m)
{

    using freq_sink_f = ::gr::qtgui::freq_sink_f;


    py::class_<freq_sink_f,
               gr::sync_block,
               gr::block,
               gr::basic_block,
               std::shared_ptr<freq_sink_f>>(m, "freq_sink_f", D(freq_sink_f))

        .def(py::init(&freq_sink_f::make),
             py::arg("fftsize"),
             py::arg("wintype"),
             py::arg("fc"),
             py::arg("bw"),
             py::arg("name"),
             py::arg("nconnections") = 1,
             py::arg("parent") = nullptr,
             D(freq_sink_f, make))


        .def("exec_", &freq_sink_f::exec_, D(freq_sink_f, exec_))


        .def("qwidget", &freq_sink_f::qwidget, D(freq_sink_f, qwidget))


        // .def("pyqwidget",&freq_sink_f::pyqwidget,
        //     D(freq_sink_f,pyqwidget)
        // )
        // For the sip conversion to python to work, the widget object
        // needs to be explicitly converted to long long.
        .def(
            "pyqwidget",
            [](std::shared_ptr<freq_sink_f> p) {
                return PyLong_AsLongLong(p->pyqwidget());
            },
            D(freq_sink_f, pyqwidget))


        .def("set_fft_size",
             &freq_sink_f::set_fft_size,
             py::arg("fftsize"),
             D(freq_sink_f, set_fft_size))


        .def("fft_size", &freq_sink_f::fft_size, D(freq_sink_f, fft_size))


        .def("set_fft_average",
             &freq_sink_f::set_fft_average,
             py::arg("fftavg"),
             D(freq_sink_f, set_fft_average))


        .def("fft_average", &freq_sink_f::fft_average, D(freq_sink_f, fft_average))


        .def("set_fft_window",
             &freq_sink_f::set_fft_window,
             py::arg("win"),
             D(freq_sink_f, set_fft_window))


        .def("fft_window", &freq_sink_f::fft_window, D(freq_sink_f, fft_window))


        .def("set_fft_window_normalized",
             &freq_sink_f::set_fft_window_normalized,
             D(freq_sink_f, set_fft_window_normalized))


        .def("set_frequency_range",
             &freq_sink_f::set_frequency_range,
             py::arg("centerfreq"),
             py::arg("bandwidth"),
             D(freq_sink_f, set_frequency_range))


        .def("set_y_axis",
             &freq_sink_f::set_y_axis,
             py::arg("min"),
             py::arg("max"),
             D(freq_sink_f, set_y_axis))


        .def("set_update_time",
             &freq_sink_f::set_update_time,
             py::arg("t"),
             D(freq_sink_f, set_update_time))


        .def("set_title",
             &freq_sink_f::set_title,
             py::arg("title"),
             D(freq_sink_f, set_title))


        .def("set_y_label",
             &freq_sink_f::set_y_label,
             py::arg("label"),
             py::arg("unit"),
             D(freq_sink_f, set_y_label))


        .def("set_line_label",
             &freq_sink_f::set_line_label,
             py::arg("which"),
             py::arg("label"),
             D(freq_sink_f, set_line_label))


        .def("set_line_color",
             &freq_sink_f::set_line_color,
             py::arg("which"),
             py::arg("color"),
             D(freq_sink_f, set_line_color))


        .def("set_line_width",
             &freq_sink_f::set_line_width,
             py::arg("which"),
             py::arg("width"),
             D(freq_sink_f, set_line_width))


        .def("set_line_style",
             &freq_sink_f::set_line_style,
             py::arg("which"),
             py::arg("style"),
             D(freq_sink_f, set_line_style))


        .def("set_line_marker",
             &freq_sink_f::set_line_marker,
             py::arg("which"),
             py::arg("marker"),
             D(freq_sink_f, set_line_marker))


        .def("set_line_alpha",
             &freq_sink_f::set_line_alpha,
             py::arg("which"),
             py::arg("alpha"),
             D(freq_sink_f, set_line_alpha))


        .def("set_plot_pos_half",
             &freq_sink_f::set_plot_pos_half,
             py::arg("half"),
             D(freq_sink_f, set_plot_pos_half))


        .def("set_trigger_mode",
             &freq_sink_f::set_trigger_mode,
             py::arg("mode"),
             py::arg("level"),
             py::arg("channel"),
             py::arg("tag_key") = "",
             D(freq_sink_f, set_trigger_mode))


        .def("title", &freq_sink_f::title, D(freq_sink_f, title))


        .def("line_label",
             &freq_sink_f::line_label,
             py::arg("which"),
             D(freq_sink_f, line_label))


        .def("line_color",
             &freq_sink_f::line_color,
             py::arg("which"),
             D(freq_sink_f, line_color))


        .def("line_width",
             &freq_sink_f::line_width,
             py::arg("which"),
             D(freq_sink_f, line_width))


        .def("line_style",
             &freq_sink_f::line_style,
             py::arg("which"),
             D(freq_sink_f, line_style))


        .def("line_marker",
             &freq_sink_f::line_marker,
             py::arg("which"),
             D(freq_sink_f, line_marker))


        .def("line_alpha",
             &freq_sink_f::line_alpha,
             py::arg("which"),
             D(freq_sink_f, line_alpha))


        .def("set_size",
             &freq_sink_f::set_size,
             py::arg("width"),
             py::arg("height"),
             D(freq_sink_f, set_size))


        .def("enable_menu",
             &freq_sink_f::enable_menu,
             py::arg("en") = true,
             D(freq_sink_f, enable_menu))


        .def("enable_grid",
             &freq_sink_f::enable_grid,
             py::arg("en") = true,
             D(freq_sink_f, enable_grid))


        .def("enable_autoscale",
             &freq_sink_f::enable_autoscale,
             py::arg("en") = true,
             D(freq_sink_f, enable_autoscale))


        .def("enable_control_panel",
             &freq_sink_f::enable_control_panel,
             py::arg("en") = true,
             D(freq_sink_f, enable_control_panel))


        .def("enable_max_hold",
             &freq_sink_f::enable_max_hold,
             py::arg("en"),
             D(freq_sink_f, enable_max_hold))


        .def("enable_min_hold",
             &freq_sink_f::enable_min_hold,
             py::arg("en"),
             D(freq_sink_f, enable_min_hold))


        .def("clear_max_hold",
             &freq_sink_f::clear_max_hold,
             D(freq_sink_f, clear_max_hold))


        .def("clear_min_hold",
             &freq_sink_f::clear_min_hold,
             D(freq_sink_f, clear_min_hold))


        .def("disable_legend",
             &freq_sink_f::disable_legend,
             D(freq_sink_f, disable_legend))


        .def("reset", &freq_sink_f::reset, D(freq_sink_f, reset))


        .def("enable_axis_labels",
             &freq_sink_f::enable_axis_labels,
             py::arg("en") = true,
             D(freq_sink_f, enable_axis_labels))

        ;
}
