// Code generated by "./generator ./com.deepin.dde.daemon.dock"; DO NOT EDIT.

package dock

import (
	"errors"
	"fmt"
	"unsafe"

	"github.com/godbus/dbus"
	"pkg.deepin.io/lib/dbusutil"
	"pkg.deepin.io/lib/dbusutil/proxy"
)

type Dock interface {
	dock // interface com.deepin.dde.daemon.Dock
	proxy.Object
}

type objectDock struct {
	interfaceDock // interface com.deepin.dde.daemon.Dock
	proxy.ImplObject
}

func NewDock(conn *dbus.Conn) Dock {
	obj := new(objectDock)
	obj.ImplObject.Init_(conn, "com.deepin.dde.daemon.Dock", "/com/deepin/dde/daemon/Dock")
	return obj
}

type dock interface {
	GoActivateWindow(flags dbus.Flags, ch chan *dbus.Call, win uint32) *dbus.Call
	ActivateWindow(flags dbus.Flags, win uint32) error
	GoCancelPreviewWindow(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	CancelPreviewWindow(flags dbus.Flags) error
	GoCloseWindow(flags dbus.Flags, ch chan *dbus.Call, win uint32) *dbus.Call
	CloseWindow(flags dbus.Flags, win uint32) error
	GoGetEntryIDs(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	GetEntryIDs(flags dbus.Flags) ([]string, error)
	GoIsDocked(flags dbus.Flags, ch chan *dbus.Call, desktopFile string) *dbus.Call
	IsDocked(flags dbus.Flags, desktopFile string) (bool, error)
	GoIsOnDock(flags dbus.Flags, ch chan *dbus.Call, desktopFile string) *dbus.Call
	IsOnDock(flags dbus.Flags, desktopFile string) (bool, error)
	GoMakeWindowAbove(flags dbus.Flags, ch chan *dbus.Call, win uint32) *dbus.Call
	MakeWindowAbove(flags dbus.Flags, win uint32) error
	GoMaximizeWindow(flags dbus.Flags, ch chan *dbus.Call, win uint32) *dbus.Call
	MaximizeWindow(flags dbus.Flags, win uint32) error
	GoMinimizeWindow(flags dbus.Flags, ch chan *dbus.Call, win uint32) *dbus.Call
	MinimizeWindow(flags dbus.Flags, win uint32) error
	GoMoveEntry(flags dbus.Flags, ch chan *dbus.Call, index int32, newIndex int32) *dbus.Call
	MoveEntry(flags dbus.Flags, index int32, newIndex int32) error
	GoMoveWindow(flags dbus.Flags, ch chan *dbus.Call, win uint32) *dbus.Call
	MoveWindow(flags dbus.Flags, win uint32) error
	GoPreviewWindow(flags dbus.Flags, ch chan *dbus.Call, win uint32) *dbus.Call
	PreviewWindow(flags dbus.Flags, win uint32) error
	GoQueryWindowIdentifyMethod(flags dbus.Flags, ch chan *dbus.Call, win uint32) *dbus.Call
	QueryWindowIdentifyMethod(flags dbus.Flags, win uint32) (string, error)
	GoRequestDock(flags dbus.Flags, ch chan *dbus.Call, desktopFile string, index int32) *dbus.Call
	RequestDock(flags dbus.Flags, desktopFile string, index int32) (bool, error)
	GoRequestUndock(flags dbus.Flags, ch chan *dbus.Call, desktopFile string) *dbus.Call
	RequestUndock(flags dbus.Flags, desktopFile string) (bool, error)
	GoSetFrontendWindowRect(flags dbus.Flags, ch chan *dbus.Call, x int32, y int32, width uint32, height uint32) *dbus.Call
	SetFrontendWindowRect(flags dbus.Flags, x int32, y int32, width uint32, height uint32) error
	ConnectServiceRestarted(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectEntryAdded(cb func(path dbus.ObjectPath, index int32)) (dbusutil.SignalHandlerId, error)
	ConnectEntryRemoved(cb func(entryId string)) (dbusutil.SignalHandlerId, error)
	ShowTimeout() proxy.PropUint32
	HideTimeout() proxy.PropUint32
	FrontendWindowRect() PropDockFrontendWindowRect
	Entries() proxy.PropObjectPathArray
	HideMode() proxy.PropInt32
	DisplayMode() proxy.PropInt32
	HideState() proxy.PropInt32
	Position() proxy.PropInt32
	IconSize() proxy.PropUint32
	DockedApps() proxy.PropStringArray
}

type interfaceDock struct{}

func (v *interfaceDock) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceDock) GetInterfaceName_() string {
	return "com.deepin.dde.daemon.Dock"
}

// method ActivateWindow

func (v *interfaceDock) GoActivateWindow(flags dbus.Flags, ch chan *dbus.Call, win uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ActivateWindow", flags, ch, win)
}

func (v *interfaceDock) ActivateWindow(flags dbus.Flags, win uint32) error {
	return (<-v.GoActivateWindow(flags, make(chan *dbus.Call, 1), win).Done).Err
}

// method CancelPreviewWindow

func (v *interfaceDock) GoCancelPreviewWindow(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".CancelPreviewWindow", flags, ch)
}

func (v *interfaceDock) CancelPreviewWindow(flags dbus.Flags) error {
	return (<-v.GoCancelPreviewWindow(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method CloseWindow

func (v *interfaceDock) GoCloseWindow(flags dbus.Flags, ch chan *dbus.Call, win uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".CloseWindow", flags, ch, win)
}

func (v *interfaceDock) CloseWindow(flags dbus.Flags, win uint32) error {
	return (<-v.GoCloseWindow(flags, make(chan *dbus.Call, 1), win).Done).Err
}

// method GetEntryIDs

func (v *interfaceDock) GoGetEntryIDs(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetEntryIDs", flags, ch)
}

func (*interfaceDock) StoreGetEntryIDs(call *dbus.Call) (list []string, err error) {
	err = call.Store(&list)
	return
}

func (v *interfaceDock) GetEntryIDs(flags dbus.Flags) ([]string, error) {
	return v.StoreGetEntryIDs(
		<-v.GoGetEntryIDs(flags, make(chan *dbus.Call, 1)).Done)
}

// method IsDocked

func (v *interfaceDock) GoIsDocked(flags dbus.Flags, ch chan *dbus.Call, desktopFile string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".IsDocked", flags, ch, desktopFile)
}

func (*interfaceDock) StoreIsDocked(call *dbus.Call) (value bool, err error) {
	err = call.Store(&value)
	return
}

func (v *interfaceDock) IsDocked(flags dbus.Flags, desktopFile string) (bool, error) {
	return v.StoreIsDocked(
		<-v.GoIsDocked(flags, make(chan *dbus.Call, 1), desktopFile).Done)
}

// method IsOnDock

func (v *interfaceDock) GoIsOnDock(flags dbus.Flags, ch chan *dbus.Call, desktopFile string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".IsOnDock", flags, ch, desktopFile)
}

func (*interfaceDock) StoreIsOnDock(call *dbus.Call) (value bool, err error) {
	err = call.Store(&value)
	return
}

func (v *interfaceDock) IsOnDock(flags dbus.Flags, desktopFile string) (bool, error) {
	return v.StoreIsOnDock(
		<-v.GoIsOnDock(flags, make(chan *dbus.Call, 1), desktopFile).Done)
}

// method MakeWindowAbove

func (v *interfaceDock) GoMakeWindowAbove(flags dbus.Flags, ch chan *dbus.Call, win uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".MakeWindowAbove", flags, ch, win)
}

func (v *interfaceDock) MakeWindowAbove(flags dbus.Flags, win uint32) error {
	return (<-v.GoMakeWindowAbove(flags, make(chan *dbus.Call, 1), win).Done).Err
}

// method MaximizeWindow

func (v *interfaceDock) GoMaximizeWindow(flags dbus.Flags, ch chan *dbus.Call, win uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".MaximizeWindow", flags, ch, win)
}

func (v *interfaceDock) MaximizeWindow(flags dbus.Flags, win uint32) error {
	return (<-v.GoMaximizeWindow(flags, make(chan *dbus.Call, 1), win).Done).Err
}

// method MinimizeWindow

func (v *interfaceDock) GoMinimizeWindow(flags dbus.Flags, ch chan *dbus.Call, win uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".MinimizeWindow", flags, ch, win)
}

func (v *interfaceDock) MinimizeWindow(flags dbus.Flags, win uint32) error {
	return (<-v.GoMinimizeWindow(flags, make(chan *dbus.Call, 1), win).Done).Err
}

// method MoveEntry

func (v *interfaceDock) GoMoveEntry(flags dbus.Flags, ch chan *dbus.Call, index int32, newIndex int32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".MoveEntry", flags, ch, index, newIndex)
}

func (v *interfaceDock) MoveEntry(flags dbus.Flags, index int32, newIndex int32) error {
	return (<-v.GoMoveEntry(flags, make(chan *dbus.Call, 1), index, newIndex).Done).Err
}

// method MoveWindow

func (v *interfaceDock) GoMoveWindow(flags dbus.Flags, ch chan *dbus.Call, win uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".MoveWindow", flags, ch, win)
}

func (v *interfaceDock) MoveWindow(flags dbus.Flags, win uint32) error {
	return (<-v.GoMoveWindow(flags, make(chan *dbus.Call, 1), win).Done).Err
}

// method PreviewWindow

func (v *interfaceDock) GoPreviewWindow(flags dbus.Flags, ch chan *dbus.Call, win uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".PreviewWindow", flags, ch, win)
}

func (v *interfaceDock) PreviewWindow(flags dbus.Flags, win uint32) error {
	return (<-v.GoPreviewWindow(flags, make(chan *dbus.Call, 1), win).Done).Err
}

// method QueryWindowIdentifyMethod

func (v *interfaceDock) GoQueryWindowIdentifyMethod(flags dbus.Flags, ch chan *dbus.Call, win uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".QueryWindowIdentifyMethod", flags, ch, win)
}

func (*interfaceDock) StoreQueryWindowIdentifyMethod(call *dbus.Call) (identifyMethod string, err error) {
	err = call.Store(&identifyMethod)
	return
}

func (v *interfaceDock) QueryWindowIdentifyMethod(flags dbus.Flags, win uint32) (string, error) {
	return v.StoreQueryWindowIdentifyMethod(
		<-v.GoQueryWindowIdentifyMethod(flags, make(chan *dbus.Call, 1), win).Done)
}

// method RequestDock

func (v *interfaceDock) GoRequestDock(flags dbus.Flags, ch chan *dbus.Call, desktopFile string, index int32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RequestDock", flags, ch, desktopFile, index)
}

func (*interfaceDock) StoreRequestDock(call *dbus.Call) (ok bool, err error) {
	err = call.Store(&ok)
	return
}

func (v *interfaceDock) RequestDock(flags dbus.Flags, desktopFile string, index int32) (bool, error) {
	return v.StoreRequestDock(
		<-v.GoRequestDock(flags, make(chan *dbus.Call, 1), desktopFile, index).Done)
}

// method RequestUndock

func (v *interfaceDock) GoRequestUndock(flags dbus.Flags, ch chan *dbus.Call, desktopFile string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RequestUndock", flags, ch, desktopFile)
}

func (*interfaceDock) StoreRequestUndock(call *dbus.Call) (ok bool, err error) {
	err = call.Store(&ok)
	return
}

func (v *interfaceDock) RequestUndock(flags dbus.Flags, desktopFile string) (bool, error) {
	return v.StoreRequestUndock(
		<-v.GoRequestUndock(flags, make(chan *dbus.Call, 1), desktopFile).Done)
}

// method SetFrontendWindowRect

func (v *interfaceDock) GoSetFrontendWindowRect(flags dbus.Flags, ch chan *dbus.Call, x int32, y int32, width uint32, height uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetFrontendWindowRect", flags, ch, x, y, width, height)
}

func (v *interfaceDock) SetFrontendWindowRect(flags dbus.Flags, x int32, y int32, width uint32, height uint32) error {
	return (<-v.GoSetFrontendWindowRect(flags, make(chan *dbus.Call, 1), x, y, width, height).Done).Err
}

// signal ServiceRestarted

func (v *interfaceDock) ConnectServiceRestarted(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "ServiceRestarted", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".ServiceRestarted",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal EntryAdded

func (v *interfaceDock) ConnectEntryAdded(cb func(path dbus.ObjectPath, index int32)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "EntryAdded", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".EntryAdded",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var path dbus.ObjectPath
		var index int32
		err := dbus.Store(sig.Body, &path, &index)
		if err == nil {
			cb(path, index)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal EntryRemoved

func (v *interfaceDock) ConnectEntryRemoved(cb func(entryId string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "EntryRemoved", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".EntryRemoved",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var entryId string
		err := dbus.Store(sig.Body, &entryId)
		if err == nil {
			cb(entryId)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property ShowTimeout u

func (v *interfaceDock) ShowTimeout() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "ShowTimeout",
	}
}

// property HideTimeout u

func (v *interfaceDock) HideTimeout() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "HideTimeout",
	}
}

type PropDockFrontendWindowRect interface {
	Get(flags dbus.Flags) (value FrontendWindowRect, err error)
	Set(flags dbus.Flags, value FrontendWindowRect) error
	ConnectChanged(cb func(hasValue bool, value FrontendWindowRect)) error
}

type implPropDockFrontendWindowRect struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropDockFrontendWindowRect) Get(flags dbus.Flags) (value FrontendWindowRect, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropDockFrontendWindowRect) Set(flags dbus.Flags, value FrontendWindowRect) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropDockFrontendWindowRect) ConnectChanged(cb func(hasValue bool, value FrontendWindowRect)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v FrontendWindowRect
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, FrontendWindowRect{})
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

// property FrontendWindowRect (iiuu)

func (v *interfaceDock) FrontendWindowRect() PropDockFrontendWindowRect {
	return &implPropDockFrontendWindowRect{
		Impl: v,
		Name: "FrontendWindowRect",
	}
}

// property Entries ao

func (v *interfaceDock) Entries() proxy.PropObjectPathArray {
	return &proxy.ImplPropObjectPathArray{
		Impl: v,
		Name: "Entries",
	}
}

// property HideMode i

func (v *interfaceDock) HideMode() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "HideMode",
	}
}

// property DisplayMode i

func (v *interfaceDock) DisplayMode() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "DisplayMode",
	}
}

// property HideState i

func (v *interfaceDock) HideState() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "HideState",
	}
}

// property Position i

func (v *interfaceDock) Position() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "Position",
	}
}

// property IconSize u

func (v *interfaceDock) IconSize() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "IconSize",
	}
}

// property DockedApps as

func (v *interfaceDock) DockedApps() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "DockedApps",
	}
}

type Entry interface {
	entry // interface com.deepin.dde.daemon.Dock.Entry
	proxy.Object
}

type objectEntry struct {
	interfaceEntry // interface com.deepin.dde.daemon.Dock.Entry
	proxy.ImplObject
}

func NewEntry(conn *dbus.Conn, path dbus.ObjectPath) (Entry, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectEntry)
	obj.ImplObject.Init_(conn, "com.deepin.dde.daemon.Dock", path)
	return obj, nil
}

type entry interface {
	GoActivate(flags dbus.Flags, ch chan *dbus.Call, timestamp uint32) *dbus.Call
	Activate(flags dbus.Flags, timestamp uint32) error
	GoCheck(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Check(flags dbus.Flags) error
	GoForceQuit(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	ForceQuit(flags dbus.Flags) error
	GoHandleDragDrop(flags dbus.Flags, ch chan *dbus.Call, timestamp uint32, files []string) *dbus.Call
	HandleDragDrop(flags dbus.Flags, timestamp uint32, files []string) error
	GoHandleMenuItem(flags dbus.Flags, ch chan *dbus.Call, timestamp uint32, id string) *dbus.Call
	HandleMenuItem(flags dbus.Flags, timestamp uint32, id string) error
	GoNewInstance(flags dbus.Flags, ch chan *dbus.Call, timestamp uint32) *dbus.Call
	NewInstance(flags dbus.Flags, timestamp uint32) error
	GoPresentWindows(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	PresentWindows(flags dbus.Flags) error
	GoRequestDock(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	RequestDock(flags dbus.Flags) error
	GoRequestUndock(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	RequestUndock(flags dbus.Flags) error
	Name() proxy.PropString
	Icon() proxy.PropString
	Id() proxy.PropString
	IsActive() proxy.PropBool
	CurrentWindow() proxy.PropUint32
	IsDocked() proxy.PropBool
	WindowInfos() PropEntryWindowInfos
	Menu() proxy.PropString
	DesktopFile() proxy.PropString
}

type interfaceEntry struct{}

func (v *interfaceEntry) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceEntry) GetInterfaceName_() string {
	return "com.deepin.dde.daemon.Dock.Entry"
}

// method Activate

func (v *interfaceEntry) GoActivate(flags dbus.Flags, ch chan *dbus.Call, timestamp uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Activate", flags, ch, timestamp)
}

func (v *interfaceEntry) Activate(flags dbus.Flags, timestamp uint32) error {
	return (<-v.GoActivate(flags, make(chan *dbus.Call, 1), timestamp).Done).Err
}

// method Check

func (v *interfaceEntry) GoCheck(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Check", flags, ch)
}

func (v *interfaceEntry) Check(flags dbus.Flags) error {
	return (<-v.GoCheck(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method ForceQuit

func (v *interfaceEntry) GoForceQuit(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ForceQuit", flags, ch)
}

func (v *interfaceEntry) ForceQuit(flags dbus.Flags) error {
	return (<-v.GoForceQuit(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method HandleDragDrop

func (v *interfaceEntry) GoHandleDragDrop(flags dbus.Flags, ch chan *dbus.Call, timestamp uint32, files []string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".HandleDragDrop", flags, ch, timestamp, files)
}

func (v *interfaceEntry) HandleDragDrop(flags dbus.Flags, timestamp uint32, files []string) error {
	return (<-v.GoHandleDragDrop(flags, make(chan *dbus.Call, 1), timestamp, files).Done).Err
}

// method HandleMenuItem

func (v *interfaceEntry) GoHandleMenuItem(flags dbus.Flags, ch chan *dbus.Call, timestamp uint32, id string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".HandleMenuItem", flags, ch, timestamp, id)
}

func (v *interfaceEntry) HandleMenuItem(flags dbus.Flags, timestamp uint32, id string) error {
	return (<-v.GoHandleMenuItem(flags, make(chan *dbus.Call, 1), timestamp, id).Done).Err
}

// method NewInstance

func (v *interfaceEntry) GoNewInstance(flags dbus.Flags, ch chan *dbus.Call, timestamp uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".NewInstance", flags, ch, timestamp)
}

func (v *interfaceEntry) NewInstance(flags dbus.Flags, timestamp uint32) error {
	return (<-v.GoNewInstance(flags, make(chan *dbus.Call, 1), timestamp).Done).Err
}

// method PresentWindows

func (v *interfaceEntry) GoPresentWindows(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".PresentWindows", flags, ch)
}

func (v *interfaceEntry) PresentWindows(flags dbus.Flags) error {
	return (<-v.GoPresentWindows(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method RequestDock

func (v *interfaceEntry) GoRequestDock(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RequestDock", flags, ch)
}

func (v *interfaceEntry) RequestDock(flags dbus.Flags) error {
	return (<-v.GoRequestDock(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method RequestUndock

func (v *interfaceEntry) GoRequestUndock(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RequestUndock", flags, ch)
}

func (v *interfaceEntry) RequestUndock(flags dbus.Flags) error {
	return (<-v.GoRequestUndock(flags, make(chan *dbus.Call, 1)).Done).Err
}

// property Name s

func (v *interfaceEntry) Name() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Name",
	}
}

// property Icon s

func (v *interfaceEntry) Icon() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Icon",
	}
}

// property Id s

func (v *interfaceEntry) Id() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Id",
	}
}

// property IsActive b

func (v *interfaceEntry) IsActive() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "IsActive",
	}
}

// property CurrentWindow u

func (v *interfaceEntry) CurrentWindow() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "CurrentWindow",
	}
}

// property IsDocked b

func (v *interfaceEntry) IsDocked() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "IsDocked",
	}
}

type PropEntryWindowInfos interface {
	Get(flags dbus.Flags) (value map[uint32]WindowInfo, err error)
	Set(flags dbus.Flags, value map[uint32]WindowInfo) error
	ConnectChanged(cb func(hasValue bool, value map[uint32]WindowInfo)) error
}

type implPropEntryWindowInfos struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropEntryWindowInfos) Get(flags dbus.Flags) (value map[uint32]WindowInfo, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropEntryWindowInfos) Set(flags dbus.Flags, value map[uint32]WindowInfo) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropEntryWindowInfos) ConnectChanged(cb func(hasValue bool, value map[uint32]WindowInfo)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v map[uint32]WindowInfo
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, nil)
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

// property WindowInfos a{u(sb)}

func (v *interfaceEntry) WindowInfos() PropEntryWindowInfos {
	return &implPropEntryWindowInfos{
		Impl: v,
		Name: "WindowInfos",
	}
}

// property Menu s

func (v *interfaceEntry) Menu() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Menu",
	}
}

// property DesktopFile s

func (v *interfaceEntry) DesktopFile() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "DesktopFile",
	}
}
