// Code generated by "./generator ./fi.w1.wpa_supplicant1"; DO NOT EDIT.

package wpa_supplicant1

import (
	"errors"
	"fmt"
	"unsafe"

	"github.com/godbus/dbus"
	"pkg.deepin.io/lib/dbusutil"
	"pkg.deepin.io/lib/dbusutil/proxy"
)

type WPASupplicant interface {
	wpaSupplicant // interface fi.w1.wpa_supplicant1
	proxy.Object
}

type objectWPASupplicant struct {
	interfaceWpaSupplicant // interface fi.w1.wpa_supplicant1
	proxy.ImplObject
}

func NewWPASupplicant(conn *dbus.Conn) WPASupplicant {
	obj := new(objectWPASupplicant)
	obj.ImplObject.Init_(conn, "fi.w1.wpa_supplicant1", "/fi/w1/wpa_supplicant1")
	return obj
}

type wpaSupplicant interface {
	GoCreateInterface(flags dbus.Flags, ch chan *dbus.Call, args map[string]dbus.Variant) *dbus.Call
	CreateInterface(flags dbus.Flags, args map[string]dbus.Variant) (dbus.ObjectPath, error)
	GoRemoveInterface(flags dbus.Flags, ch chan *dbus.Call, path dbus.ObjectPath) *dbus.Call
	RemoveInterface(flags dbus.Flags, path dbus.ObjectPath) error
	GoGetInterface(flags dbus.Flags, ch chan *dbus.Call, ifname string) *dbus.Call
	GetInterface(flags dbus.Flags, ifname string) (dbus.ObjectPath, error)
	GoExpectDisconnect(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	ExpectDisconnect(flags dbus.Flags) error
	ConnectSignalInterfaceAdded(cb func(path dbus.ObjectPath, properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	ConnectSignalInterfaceRemoved(cb func(path dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	DebugLevel() proxy.PropString
	DebugTimestamp() proxy.PropBool
	DebugShowKeys() proxy.PropBool
	Interfaces() proxy.PropObjectPathArray
	EapMethods() proxy.PropStringArray
	Capabilities() proxy.PropStringArray
	WFDIEs() proxy.PropByteArray
}

type interfaceWpaSupplicant struct{}

func (v *interfaceWpaSupplicant) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceWpaSupplicant) GetInterfaceName_() string {
	return "fi.w1.wpa_supplicant1"
}

// method CreateInterface

func (v *interfaceWpaSupplicant) GoCreateInterface(flags dbus.Flags, ch chan *dbus.Call, args map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".CreateInterface", flags, ch, args)
}

func (*interfaceWpaSupplicant) StoreCreateInterface(call *dbus.Call) (path dbus.ObjectPath, err error) {
	err = call.Store(&path)
	return
}

func (v *interfaceWpaSupplicant) CreateInterface(flags dbus.Flags, args map[string]dbus.Variant) (dbus.ObjectPath, error) {
	return v.StoreCreateInterface(
		<-v.GoCreateInterface(flags, make(chan *dbus.Call, 1), args).Done)
}

// method RemoveInterface

func (v *interfaceWpaSupplicant) GoRemoveInterface(flags dbus.Flags, ch chan *dbus.Call, path dbus.ObjectPath) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RemoveInterface", flags, ch, path)
}

func (v *interfaceWpaSupplicant) RemoveInterface(flags dbus.Flags, path dbus.ObjectPath) error {
	return (<-v.GoRemoveInterface(flags, make(chan *dbus.Call, 1), path).Done).Err
}

// method GetInterface

func (v *interfaceWpaSupplicant) GoGetInterface(flags dbus.Flags, ch chan *dbus.Call, ifname string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetInterface", flags, ch, ifname)
}

func (*interfaceWpaSupplicant) StoreGetInterface(call *dbus.Call) (path dbus.ObjectPath, err error) {
	err = call.Store(&path)
	return
}

func (v *interfaceWpaSupplicant) GetInterface(flags dbus.Flags, ifname string) (dbus.ObjectPath, error) {
	return v.StoreGetInterface(
		<-v.GoGetInterface(flags, make(chan *dbus.Call, 1), ifname).Done)
}

// method ExpectDisconnect

func (v *interfaceWpaSupplicant) GoExpectDisconnect(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ExpectDisconnect", flags, ch)
}

func (v *interfaceWpaSupplicant) ExpectDisconnect(flags dbus.Flags) error {
	return (<-v.GoExpectDisconnect(flags, make(chan *dbus.Call, 1)).Done).Err
}

// signal InterfaceAdded

func (v *interfaceWpaSupplicant) ConnectSignalInterfaceAdded(cb func(path dbus.ObjectPath, properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "InterfaceAdded", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".InterfaceAdded",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var path dbus.ObjectPath
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &path, &properties)
		if err == nil {
			cb(path, properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal InterfaceRemoved

func (v *interfaceWpaSupplicant) ConnectSignalInterfaceRemoved(cb func(path dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "InterfaceRemoved", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".InterfaceRemoved",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var path dbus.ObjectPath
		err := dbus.Store(sig.Body, &path)
		if err == nil {
			cb(path)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal PropertiesChanged

func (v *interfaceWpaSupplicant) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property DebugLevel s

func (v *interfaceWpaSupplicant) DebugLevel() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "DebugLevel",
	}
}

// property DebugTimestamp b

func (v *interfaceWpaSupplicant) DebugTimestamp() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "DebugTimestamp",
	}
}

// property DebugShowKeys b

func (v *interfaceWpaSupplicant) DebugShowKeys() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "DebugShowKeys",
	}
}

// property Interfaces ao

func (v *interfaceWpaSupplicant) Interfaces() proxy.PropObjectPathArray {
	return &proxy.ImplPropObjectPathArray{
		Impl: v,
		Name: "Interfaces",
	}
}

// property EapMethods as

func (v *interfaceWpaSupplicant) EapMethods() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "EapMethods",
	}
}

// property Capabilities as

func (v *interfaceWpaSupplicant) Capabilities() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "Capabilities",
	}
}

// property WFDIEs ay

func (v *interfaceWpaSupplicant) WFDIEs() proxy.PropByteArray {
	return &proxy.ImplPropByteArray{
		Impl: v,
		Name: "WFDIEs",
	}
}

type Interface interface {
	Interface() interface1         // interface fi.w1.wpa_supplicant1.Interface
	WPS() interfaceWPS             // interface fi.w1.wpa_supplicant1.Interface.WPS
	P2PDevice() interfaceP2PDevice // interface fi.w1.wpa_supplicant1.Interface.P2PDevice
	proxy.Object
}

type objectInterface struct {
	interfaceInterface1         // interface fi.w1.wpa_supplicant1.Interface
	interfaceInterfaceWPS       // interface fi.w1.wpa_supplicant1.Interface.WPS
	interfaceInterfaceP2PDevice // interface fi.w1.wpa_supplicant1.Interface.P2PDevice
	proxy.ImplObject
}

func NewInterface(conn *dbus.Conn, path dbus.ObjectPath) (Interface, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectInterface)
	obj.ImplObject.Init_(conn, "fi.w1.wpa_supplicant1", path)
	return obj, nil
}

func (obj *objectInterface) Interface() interface1 {
	return &obj.interfaceInterface1
}

type interface1 interface {
	GoScan(flags dbus.Flags, ch chan *dbus.Call, args map[string]dbus.Variant) *dbus.Call
	Scan(flags dbus.Flags, args map[string]dbus.Variant) error
	GoSignalPoll(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	SignalPoll(flags dbus.Flags) (map[string]dbus.Variant, error)
	GoDisconnect(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Disconnect(flags dbus.Flags) error
	GoAddNetwork(flags dbus.Flags, ch chan *dbus.Call, args map[string]dbus.Variant) *dbus.Call
	AddNetwork(flags dbus.Flags, args map[string]dbus.Variant) (dbus.ObjectPath, error)
	GoReassociate(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Reassociate(flags dbus.Flags) error
	GoReattach(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Reattach(flags dbus.Flags) error
	GoReconnect(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Reconnect(flags dbus.Flags) error
	GoRemoveNetwork(flags dbus.Flags, ch chan *dbus.Call, path dbus.ObjectPath) *dbus.Call
	RemoveNetwork(flags dbus.Flags, path dbus.ObjectPath) error
	GoRemoveAllNetworks(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	RemoveAllNetworks(flags dbus.Flags) error
	GoSelectNetwork(flags dbus.Flags, ch chan *dbus.Call, path dbus.ObjectPath) *dbus.Call
	SelectNetwork(flags dbus.Flags, path dbus.ObjectPath) error
	GoNetworkReply(flags dbus.Flags, ch chan *dbus.Call, path dbus.ObjectPath, field string, value string) *dbus.Call
	NetworkReply(flags dbus.Flags, path dbus.ObjectPath, field string, value string) error
	GoAddBlob(flags dbus.Flags, ch chan *dbus.Call, name string, data []uint8) *dbus.Call
	AddBlob(flags dbus.Flags, name string, data []uint8) error
	GoGetBlob(flags dbus.Flags, ch chan *dbus.Call, name string) *dbus.Call
	GetBlob(flags dbus.Flags, name string) ([]uint8, error)
	GoRemoveBlob(flags dbus.Flags, ch chan *dbus.Call, name string) *dbus.Call
	RemoveBlob(flags dbus.Flags, name string) error
	GoSetPKCS11EngineAndModulePath(flags dbus.Flags, ch chan *dbus.Call, pkcs11_engine_path string, pkcs11_module_path string) *dbus.Call
	SetPKCS11EngineAndModulePath(flags dbus.Flags, pkcs11_engine_path string, pkcs11_module_path string) error
	GoFlushBSS(flags dbus.Flags, ch chan *dbus.Call, age uint32) *dbus.Call
	FlushBSS(flags dbus.Flags, age uint32) error
	GoSubscribeProbeReq(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	SubscribeProbeReq(flags dbus.Flags) error
	GoUnsubscribeProbeReq(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	UnsubscribeProbeReq(flags dbus.Flags) error
	GoEAPLogoff(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	EAPLogoff(flags dbus.Flags) error
	GoEAPLogon(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	EAPLogon(flags dbus.Flags) error
	GoAutoScan(flags dbus.Flags, ch chan *dbus.Call, arg string) *dbus.Call
	AutoScan(flags dbus.Flags, arg string) error
	GoTDLSDiscover(flags dbus.Flags, ch chan *dbus.Call, peer_address string) *dbus.Call
	TDLSDiscover(flags dbus.Flags, peer_address string) error
	GoTDLSSetup(flags dbus.Flags, ch chan *dbus.Call, peer_address string) *dbus.Call
	TDLSSetup(flags dbus.Flags, peer_address string) error
	GoTDLSStatus(flags dbus.Flags, ch chan *dbus.Call, peer_address string) *dbus.Call
	TDLSStatus(flags dbus.Flags, peer_address string) (string, error)
	GoTDLSTeardown(flags dbus.Flags, ch chan *dbus.Call, peer_address string) *dbus.Call
	TDLSTeardown(flags dbus.Flags, peer_address string) error
	GoTDLSChannelSwitch(flags dbus.Flags, ch chan *dbus.Call, args map[string]dbus.Variant) *dbus.Call
	TDLSChannelSwitch(flags dbus.Flags, args map[string]dbus.Variant) error
	GoTDLSCancelChannelSwitch(flags dbus.Flags, ch chan *dbus.Call, peer_address string) *dbus.Call
	TDLSCancelChannelSwitch(flags dbus.Flags, peer_address string) error
	GoVendorElemAdd(flags dbus.Flags, ch chan *dbus.Call, frame_id int32, ielems []uint8) *dbus.Call
	VendorElemAdd(flags dbus.Flags, frame_id int32, ielems []uint8) error
	GoVendorElemGet(flags dbus.Flags, ch chan *dbus.Call, frame_id int32) *dbus.Call
	VendorElemGet(flags dbus.Flags, frame_id int32) ([]uint8, error)
	GoVendorElemRem(flags dbus.Flags, ch chan *dbus.Call, frame_id int32, ielems []uint8) *dbus.Call
	VendorElemRem(flags dbus.Flags, frame_id int32, ielems []uint8) error
	GoSaveConfig(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	SaveConfig(flags dbus.Flags) error
	GoAbortScan(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	AbortScan(flags dbus.Flags) error
	ConnectScanDone(cb func(success bool)) (dbusutil.SignalHandlerId, error)
	ConnectBSSAdded(cb func(path dbus.ObjectPath, properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	ConnectBSSRemoved(cb func(path dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	ConnectBlobAdded(cb func(name string)) (dbusutil.SignalHandlerId, error)
	ConnectBlobRemoved(cb func(name string)) (dbusutil.SignalHandlerId, error)
	ConnectNetworkAdded(cb func(path dbus.ObjectPath, properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	ConnectNetworkRemoved(cb func(path dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	ConnectNetworkSelected(cb func(path dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	ConnectProbeRequest(cb func(args map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	ConnectCertification(cb func(certification map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	ConnectEAP(cb func(status string, parameter string)) (dbusutil.SignalHandlerId, error)
	ConnectStaAuthorized(cb func(name string)) (dbusutil.SignalHandlerId, error)
	ConnectStaDeauthorized(cb func(name string)) (dbusutil.SignalHandlerId, error)
	ConnectStationAdded(cb func(path dbus.ObjectPath, properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	ConnectStationRemoved(cb func(path dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	ConnectNetworkRequest(cb func(path dbus.ObjectPath, field string, text string)) (dbusutil.SignalHandlerId, error)
	Capabilities() MapStrVariant
	State() proxy.PropString
	Scanning() proxy.PropBool
	ApScan() proxy.PropUint32
	BSSExpireAge() proxy.PropUint32
	BSSExpireCount() proxy.PropUint32
	Country() proxy.PropString
	Ifname() proxy.PropString
	Driver() proxy.PropString
	BridgeIfname() proxy.PropString
	ConfigFile() proxy.PropString
	CurrentBSS() proxy.PropObjectPath
	CurrentNetwork() proxy.PropObjectPath
	CurrentAuthMode() proxy.PropString
	Blobs() PropInterfaceBlobs
	BSSs() proxy.PropObjectPathArray
	Networks() proxy.PropObjectPathArray
	FastReauth() proxy.PropBool
	ScanInterval() proxy.PropInt32
	PKCS11EnginePath() proxy.PropString
	PKCS11ModulePath() proxy.PropString
	DisconnectReason() proxy.PropInt32
	AuthStatusCode() proxy.PropInt32
	AssocStatusCode() proxy.PropInt32
	Stations() proxy.PropObjectPathArray
	CtrlInterface() proxy.PropString
	CtrlInterfaceGroup() proxy.PropString
	EapolVersion() proxy.PropString
	Bgscan() proxy.PropString
	DisableScanOffload() proxy.PropString
	OpenscEnginePath() proxy.PropString
	OpensslCiphers() proxy.PropString
	PcscReader() proxy.PropString
	PcscPin() proxy.PropString
	ExternalSim() proxy.PropString
	DriverParam() proxy.PropString
	Dot11RSNAConfigPMKLifetime() proxy.PropString
	Dot11RSNAConfigPMKReauthThreshold() proxy.PropString
	Dot11RSNAConfigSATimeout() proxy.PropString
	UpdateConfig() proxy.PropString
	Uuid() proxy.PropString
	AutoUuid() proxy.PropString
	DeviceName() proxy.PropString
	Manufacturer() proxy.PropString
	ModelName() proxy.PropString
	ModelNumber() proxy.PropString
	SerialNumber() proxy.PropString
	DeviceType() proxy.PropString
	OsVersion() proxy.PropString
	ConfigMethods() proxy.PropString
	WpsCredProcessing() proxy.PropString
	WpsVendorExtM1() proxy.PropString
	SecDeviceType() proxy.PropString
	P2pListenRegClass() proxy.PropString
	P2pListenChannel() proxy.PropString
	P2pOperRegClass() proxy.PropString
	P2pOperChannel() proxy.PropString
	P2pGoIntent() proxy.PropString
	P2pSsidPostfix() proxy.PropString
	PersistentReconnect() proxy.PropString
	P2pIntraBss() proxy.PropString
	P2pGroupIdle() proxy.PropString
	P2pGoFreqChangePolicy() proxy.PropString
	P2pPassphraseLen() proxy.PropString
	P2pPrefChan() proxy.PropString
	P2pNoGoFreq() proxy.PropString
	P2pAddCliChan() proxy.PropString
	P2pOptimizeListenChan() proxy.PropString
	P2pGoHt40() proxy.PropString
	P2pGoVht() proxy.PropString
	P2pGoHe() proxy.PropString
	P2pDisabled() proxy.PropString
	P2pGoCtwindow() proxy.PropString
	P2pNoGroupIface() proxy.PropString
	P2pIgnoreSharedFreq() proxy.PropString
	IpAddrGo() proxy.PropString
	IpAddrMask() proxy.PropString
	IpAddrStart() proxy.PropString
	IpAddrEnd() proxy.PropString
	P2pCliProbe() proxy.PropString
	P2pDeviceRandomMacAddr() proxy.PropString
	P2pDevicePersistentMacAddr() proxy.PropString
	P2pInterfaceRandomMacAddr() proxy.PropString
	BssMaxCount() proxy.PropString
	FilterSsids() proxy.PropString
	FilterRssi() proxy.PropString
	MaxNumSta() proxy.PropString
	ApIsolate() proxy.PropString
	DisassocLowAck() proxy.PropString
	Hs20() proxy.PropString
	Interworking() proxy.PropString
	Hessid() proxy.PropString
	AccessNetworkType() proxy.PropString
	GoInterworking() proxy.PropString
	GoAccessNetworkType() proxy.PropString
	GoInternet() proxy.PropString
	GoVenueGroup() proxy.PropString
	GoVenueType() proxy.PropString
	PbcInM1() proxy.PropString
	Autoscan() proxy.PropString
	WpsNfcDevPwId() proxy.PropString
	WpsNfcDhPubkey() proxy.PropString
	WpsNfcDhPrivkey() proxy.PropString
	WpsNfcDevPw() proxy.PropString
	ExtPasswordBackend() proxy.PropString
	P2pGoMaxInactivity() proxy.PropString
	AutoInterworking() proxy.PropString
	Okc() proxy.PropString
	Pmf() proxy.PropString
	SaeGroups() proxy.PropString
	DtimPeriod() proxy.PropString
	BeaconInt() proxy.PropString
	ApVendorElements() proxy.PropString
	IgnoreOldScanRes() proxy.PropString
	FreqList() proxy.PropString
	ScanCurFreq() proxy.PropString
	SchedScanInterval() proxy.PropString
	SchedScanStartDelay() proxy.PropString
	TdlsExternalControl() proxy.PropString
	OsuDir() proxy.PropString
	WowlanTriggers() proxy.PropString
	P2pSearchDelay() proxy.PropString
	MacAddr() proxy.PropString
	RandAddrLifetime() proxy.PropString
	PreassocMacAddr() proxy.PropString
	KeyMgmtOffload() proxy.PropString
	PassiveScan() proxy.PropString
	ReassocSameBssOptim() proxy.PropString
	WpsPriority() proxy.PropString
	FstGroupId() proxy.PropString
	FstPriority() proxy.PropString
	FstLlt() proxy.PropString
	CertInCb() proxy.PropString
	WpaRscRelaxation() proxy.PropString
	SchedScanPlans() proxy.PropString
	GasAddress3() proxy.PropString
	FtmResponder() proxy.PropString
	FtmInitiator() proxy.PropString
	GasRandAddrLifetime() proxy.PropString
	GasRandMacAddr() proxy.PropString
	DppConfigProcessing() proxy.PropString
	ColocIntfReporting() proxy.PropString
}

type interfaceInterface1 struct{}

func (v *interfaceInterface1) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceInterface1) GetInterfaceName_() string {
	return "fi.w1.wpa_supplicant1.Interface"
}

// method Scan

func (v *interfaceInterface1) GoScan(flags dbus.Flags, ch chan *dbus.Call, args map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Scan", flags, ch, args)
}

func (v *interfaceInterface1) Scan(flags dbus.Flags, args map[string]dbus.Variant) error {
	return (<-v.GoScan(flags, make(chan *dbus.Call, 1), args).Done).Err
}

// method SignalPoll

func (v *interfaceInterface1) GoSignalPoll(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SignalPoll", flags, ch)
}

func (*interfaceInterface1) StoreSignalPoll(call *dbus.Call) (args map[string]dbus.Variant, err error) {
	err = call.Store(&args)
	return
}

func (v *interfaceInterface1) SignalPoll(flags dbus.Flags) (map[string]dbus.Variant, error) {
	return v.StoreSignalPoll(
		<-v.GoSignalPoll(flags, make(chan *dbus.Call, 1)).Done)
}

// method Disconnect

func (v *interfaceInterface1) GoDisconnect(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Disconnect", flags, ch)
}

func (v *interfaceInterface1) Disconnect(flags dbus.Flags) error {
	return (<-v.GoDisconnect(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method AddNetwork

func (v *interfaceInterface1) GoAddNetwork(flags dbus.Flags, ch chan *dbus.Call, args map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".AddNetwork", flags, ch, args)
}

func (*interfaceInterface1) StoreAddNetwork(call *dbus.Call) (path dbus.ObjectPath, err error) {
	err = call.Store(&path)
	return
}

func (v *interfaceInterface1) AddNetwork(flags dbus.Flags, args map[string]dbus.Variant) (dbus.ObjectPath, error) {
	return v.StoreAddNetwork(
		<-v.GoAddNetwork(flags, make(chan *dbus.Call, 1), args).Done)
}

// method Reassociate

func (v *interfaceInterface1) GoReassociate(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Reassociate", flags, ch)
}

func (v *interfaceInterface1) Reassociate(flags dbus.Flags) error {
	return (<-v.GoReassociate(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method Reattach

func (v *interfaceInterface1) GoReattach(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Reattach", flags, ch)
}

func (v *interfaceInterface1) Reattach(flags dbus.Flags) error {
	return (<-v.GoReattach(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method Reconnect

func (v *interfaceInterface1) GoReconnect(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Reconnect", flags, ch)
}

func (v *interfaceInterface1) Reconnect(flags dbus.Flags) error {
	return (<-v.GoReconnect(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method RemoveNetwork

func (v *interfaceInterface1) GoRemoveNetwork(flags dbus.Flags, ch chan *dbus.Call, path dbus.ObjectPath) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RemoveNetwork", flags, ch, path)
}

func (v *interfaceInterface1) RemoveNetwork(flags dbus.Flags, path dbus.ObjectPath) error {
	return (<-v.GoRemoveNetwork(flags, make(chan *dbus.Call, 1), path).Done).Err
}

// method RemoveAllNetworks

func (v *interfaceInterface1) GoRemoveAllNetworks(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RemoveAllNetworks", flags, ch)
}

func (v *interfaceInterface1) RemoveAllNetworks(flags dbus.Flags) error {
	return (<-v.GoRemoveAllNetworks(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method SelectNetwork

func (v *interfaceInterface1) GoSelectNetwork(flags dbus.Flags, ch chan *dbus.Call, path dbus.ObjectPath) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SelectNetwork", flags, ch, path)
}

func (v *interfaceInterface1) SelectNetwork(flags dbus.Flags, path dbus.ObjectPath) error {
	return (<-v.GoSelectNetwork(flags, make(chan *dbus.Call, 1), path).Done).Err
}

// method NetworkReply

func (v *interfaceInterface1) GoNetworkReply(flags dbus.Flags, ch chan *dbus.Call, path dbus.ObjectPath, field string, value string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".NetworkReply", flags, ch, path, field, value)
}

func (v *interfaceInterface1) NetworkReply(flags dbus.Flags, path dbus.ObjectPath, field string, value string) error {
	return (<-v.GoNetworkReply(flags, make(chan *dbus.Call, 1), path, field, value).Done).Err
}

// method AddBlob

func (v *interfaceInterface1) GoAddBlob(flags dbus.Flags, ch chan *dbus.Call, name string, data []uint8) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".AddBlob", flags, ch, name, data)
}

func (v *interfaceInterface1) AddBlob(flags dbus.Flags, name string, data []uint8) error {
	return (<-v.GoAddBlob(flags, make(chan *dbus.Call, 1), name, data).Done).Err
}

// method GetBlob

func (v *interfaceInterface1) GoGetBlob(flags dbus.Flags, ch chan *dbus.Call, name string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetBlob", flags, ch, name)
}

func (*interfaceInterface1) StoreGetBlob(call *dbus.Call) (data []uint8, err error) {
	err = call.Store(&data)
	return
}

func (v *interfaceInterface1) GetBlob(flags dbus.Flags, name string) ([]uint8, error) {
	return v.StoreGetBlob(
		<-v.GoGetBlob(flags, make(chan *dbus.Call, 1), name).Done)
}

// method RemoveBlob

func (v *interfaceInterface1) GoRemoveBlob(flags dbus.Flags, ch chan *dbus.Call, name string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RemoveBlob", flags, ch, name)
}

func (v *interfaceInterface1) RemoveBlob(flags dbus.Flags, name string) error {
	return (<-v.GoRemoveBlob(flags, make(chan *dbus.Call, 1), name).Done).Err
}

// method SetPKCS11EngineAndModulePath

func (v *interfaceInterface1) GoSetPKCS11EngineAndModulePath(flags dbus.Flags, ch chan *dbus.Call, pkcs11_engine_path string, pkcs11_module_path string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetPKCS11EngineAndModulePath", flags, ch, pkcs11_engine_path, pkcs11_module_path)
}

func (v *interfaceInterface1) SetPKCS11EngineAndModulePath(flags dbus.Flags, pkcs11_engine_path string, pkcs11_module_path string) error {
	return (<-v.GoSetPKCS11EngineAndModulePath(flags, make(chan *dbus.Call, 1), pkcs11_engine_path, pkcs11_module_path).Done).Err
}

// method FlushBSS

func (v *interfaceInterface1) GoFlushBSS(flags dbus.Flags, ch chan *dbus.Call, age uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".FlushBSS", flags, ch, age)
}

func (v *interfaceInterface1) FlushBSS(flags dbus.Flags, age uint32) error {
	return (<-v.GoFlushBSS(flags, make(chan *dbus.Call, 1), age).Done).Err
}

// method SubscribeProbeReq

func (v *interfaceInterface1) GoSubscribeProbeReq(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SubscribeProbeReq", flags, ch)
}

func (v *interfaceInterface1) SubscribeProbeReq(flags dbus.Flags) error {
	return (<-v.GoSubscribeProbeReq(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method UnsubscribeProbeReq

func (v *interfaceInterface1) GoUnsubscribeProbeReq(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".UnsubscribeProbeReq", flags, ch)
}

func (v *interfaceInterface1) UnsubscribeProbeReq(flags dbus.Flags) error {
	return (<-v.GoUnsubscribeProbeReq(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method EAPLogoff

func (v *interfaceInterface1) GoEAPLogoff(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".EAPLogoff", flags, ch)
}

func (v *interfaceInterface1) EAPLogoff(flags dbus.Flags) error {
	return (<-v.GoEAPLogoff(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method EAPLogon

func (v *interfaceInterface1) GoEAPLogon(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".EAPLogon", flags, ch)
}

func (v *interfaceInterface1) EAPLogon(flags dbus.Flags) error {
	return (<-v.GoEAPLogon(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method AutoScan

func (v *interfaceInterface1) GoAutoScan(flags dbus.Flags, ch chan *dbus.Call, arg string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".AutoScan", flags, ch, arg)
}

func (v *interfaceInterface1) AutoScan(flags dbus.Flags, arg string) error {
	return (<-v.GoAutoScan(flags, make(chan *dbus.Call, 1), arg).Done).Err
}

// method TDLSDiscover

func (v *interfaceInterface1) GoTDLSDiscover(flags dbus.Flags, ch chan *dbus.Call, peer_address string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".TDLSDiscover", flags, ch, peer_address)
}

func (v *interfaceInterface1) TDLSDiscover(flags dbus.Flags, peer_address string) error {
	return (<-v.GoTDLSDiscover(flags, make(chan *dbus.Call, 1), peer_address).Done).Err
}

// method TDLSSetup

func (v *interfaceInterface1) GoTDLSSetup(flags dbus.Flags, ch chan *dbus.Call, peer_address string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".TDLSSetup", flags, ch, peer_address)
}

func (v *interfaceInterface1) TDLSSetup(flags dbus.Flags, peer_address string) error {
	return (<-v.GoTDLSSetup(flags, make(chan *dbus.Call, 1), peer_address).Done).Err
}

// method TDLSStatus

func (v *interfaceInterface1) GoTDLSStatus(flags dbus.Flags, ch chan *dbus.Call, peer_address string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".TDLSStatus", flags, ch, peer_address)
}

func (*interfaceInterface1) StoreTDLSStatus(call *dbus.Call) (status string, err error) {
	err = call.Store(&status)
	return
}

func (v *interfaceInterface1) TDLSStatus(flags dbus.Flags, peer_address string) (string, error) {
	return v.StoreTDLSStatus(
		<-v.GoTDLSStatus(flags, make(chan *dbus.Call, 1), peer_address).Done)
}

// method TDLSTeardown

func (v *interfaceInterface1) GoTDLSTeardown(flags dbus.Flags, ch chan *dbus.Call, peer_address string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".TDLSTeardown", flags, ch, peer_address)
}

func (v *interfaceInterface1) TDLSTeardown(flags dbus.Flags, peer_address string) error {
	return (<-v.GoTDLSTeardown(flags, make(chan *dbus.Call, 1), peer_address).Done).Err
}

// method TDLSChannelSwitch

func (v *interfaceInterface1) GoTDLSChannelSwitch(flags dbus.Flags, ch chan *dbus.Call, args map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".TDLSChannelSwitch", flags, ch, args)
}

func (v *interfaceInterface1) TDLSChannelSwitch(flags dbus.Flags, args map[string]dbus.Variant) error {
	return (<-v.GoTDLSChannelSwitch(flags, make(chan *dbus.Call, 1), args).Done).Err
}

// method TDLSCancelChannelSwitch

func (v *interfaceInterface1) GoTDLSCancelChannelSwitch(flags dbus.Flags, ch chan *dbus.Call, peer_address string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".TDLSCancelChannelSwitch", flags, ch, peer_address)
}

func (v *interfaceInterface1) TDLSCancelChannelSwitch(flags dbus.Flags, peer_address string) error {
	return (<-v.GoTDLSCancelChannelSwitch(flags, make(chan *dbus.Call, 1), peer_address).Done).Err
}

// method VendorElemAdd

func (v *interfaceInterface1) GoVendorElemAdd(flags dbus.Flags, ch chan *dbus.Call, frame_id int32, ielems []uint8) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".VendorElemAdd", flags, ch, frame_id, ielems)
}

func (v *interfaceInterface1) VendorElemAdd(flags dbus.Flags, frame_id int32, ielems []uint8) error {
	return (<-v.GoVendorElemAdd(flags, make(chan *dbus.Call, 1), frame_id, ielems).Done).Err
}

// method VendorElemGet

func (v *interfaceInterface1) GoVendorElemGet(flags dbus.Flags, ch chan *dbus.Call, frame_id int32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".VendorElemGet", flags, ch, frame_id)
}

func (*interfaceInterface1) StoreVendorElemGet(call *dbus.Call) (ielems []uint8, err error) {
	err = call.Store(&ielems)
	return
}

func (v *interfaceInterface1) VendorElemGet(flags dbus.Flags, frame_id int32) ([]uint8, error) {
	return v.StoreVendorElemGet(
		<-v.GoVendorElemGet(flags, make(chan *dbus.Call, 1), frame_id).Done)
}

// method VendorElemRem

func (v *interfaceInterface1) GoVendorElemRem(flags dbus.Flags, ch chan *dbus.Call, frame_id int32, ielems []uint8) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".VendorElemRem", flags, ch, frame_id, ielems)
}

func (v *interfaceInterface1) VendorElemRem(flags dbus.Flags, frame_id int32, ielems []uint8) error {
	return (<-v.GoVendorElemRem(flags, make(chan *dbus.Call, 1), frame_id, ielems).Done).Err
}

// method SaveConfig

func (v *interfaceInterface1) GoSaveConfig(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SaveConfig", flags, ch)
}

func (v *interfaceInterface1) SaveConfig(flags dbus.Flags) error {
	return (<-v.GoSaveConfig(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method AbortScan

func (v *interfaceInterface1) GoAbortScan(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".AbortScan", flags, ch)
}

func (v *interfaceInterface1) AbortScan(flags dbus.Flags) error {
	return (<-v.GoAbortScan(flags, make(chan *dbus.Call, 1)).Done).Err
}

// signal ScanDone

func (v *interfaceInterface1) ConnectScanDone(cb func(success bool)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "ScanDone", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".ScanDone",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var success bool
		err := dbus.Store(sig.Body, &success)
		if err == nil {
			cb(success)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal BSSAdded

func (v *interfaceInterface1) ConnectBSSAdded(cb func(path dbus.ObjectPath, properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "BSSAdded", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".BSSAdded",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var path dbus.ObjectPath
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &path, &properties)
		if err == nil {
			cb(path, properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal BSSRemoved

func (v *interfaceInterface1) ConnectBSSRemoved(cb func(path dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "BSSRemoved", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".BSSRemoved",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var path dbus.ObjectPath
		err := dbus.Store(sig.Body, &path)
		if err == nil {
			cb(path)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal BlobAdded

func (v *interfaceInterface1) ConnectBlobAdded(cb func(name string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "BlobAdded", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".BlobAdded",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var name string
		err := dbus.Store(sig.Body, &name)
		if err == nil {
			cb(name)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal BlobRemoved

func (v *interfaceInterface1) ConnectBlobRemoved(cb func(name string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "BlobRemoved", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".BlobRemoved",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var name string
		err := dbus.Store(sig.Body, &name)
		if err == nil {
			cb(name)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal NetworkAdded

func (v *interfaceInterface1) ConnectNetworkAdded(cb func(path dbus.ObjectPath, properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "NetworkAdded", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".NetworkAdded",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var path dbus.ObjectPath
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &path, &properties)
		if err == nil {
			cb(path, properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal NetworkRemoved

func (v *interfaceInterface1) ConnectNetworkRemoved(cb func(path dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "NetworkRemoved", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".NetworkRemoved",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var path dbus.ObjectPath
		err := dbus.Store(sig.Body, &path)
		if err == nil {
			cb(path)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal NetworkSelected

func (v *interfaceInterface1) ConnectNetworkSelected(cb func(path dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "NetworkSelected", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".NetworkSelected",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var path dbus.ObjectPath
		err := dbus.Store(sig.Body, &path)
		if err == nil {
			cb(path)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal PropertiesChanged

func (v *interfaceInterface1) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal ProbeRequest

func (v *interfaceInterface1) ConnectProbeRequest(cb func(args map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "ProbeRequest", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".ProbeRequest",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var args map[string]dbus.Variant
		err := dbus.Store(sig.Body, &args)
		if err == nil {
			cb(args)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal Certification

func (v *interfaceInterface1) ConnectCertification(cb func(certification map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "Certification", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".Certification",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var certification map[string]dbus.Variant
		err := dbus.Store(sig.Body, &certification)
		if err == nil {
			cb(certification)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal EAP

func (v *interfaceInterface1) ConnectEAP(cb func(status string, parameter string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "EAP", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".EAP",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var status string
		var parameter string
		err := dbus.Store(sig.Body, &status, &parameter)
		if err == nil {
			cb(status, parameter)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal StaAuthorized

func (v *interfaceInterface1) ConnectStaAuthorized(cb func(name string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "StaAuthorized", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".StaAuthorized",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var name string
		err := dbus.Store(sig.Body, &name)
		if err == nil {
			cb(name)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal StaDeauthorized

func (v *interfaceInterface1) ConnectStaDeauthorized(cb func(name string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "StaDeauthorized", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".StaDeauthorized",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var name string
		err := dbus.Store(sig.Body, &name)
		if err == nil {
			cb(name)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal StationAdded

func (v *interfaceInterface1) ConnectStationAdded(cb func(path dbus.ObjectPath, properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "StationAdded", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".StationAdded",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var path dbus.ObjectPath
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &path, &properties)
		if err == nil {
			cb(path, properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal StationRemoved

func (v *interfaceInterface1) ConnectStationRemoved(cb func(path dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "StationRemoved", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".StationRemoved",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var path dbus.ObjectPath
		err := dbus.Store(sig.Body, &path)
		if err == nil {
			cb(path)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal NetworkRequest

func (v *interfaceInterface1) ConnectNetworkRequest(cb func(path dbus.ObjectPath, field string, text string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "NetworkRequest", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".NetworkRequest",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var path dbus.ObjectPath
		var field string
		var text string
		err := dbus.Store(sig.Body, &path, &field, &text)
		if err == nil {
			cb(path, field, text)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property Capabilities a{sv}

func (v *interfaceInterface1) Capabilities() MapStrVariant {
	return &implMapStrVariant{
		Impl: v,
		Name: "Capabilities",
	}
}

// property State s

func (v *interfaceInterface1) State() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "State",
	}
}

// property Scanning b

func (v *interfaceInterface1) Scanning() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Scanning",
	}
}

// property ApScan u

func (v *interfaceInterface1) ApScan() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "ApScan",
	}
}

// property BSSExpireAge u

func (v *interfaceInterface1) BSSExpireAge() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "BSSExpireAge",
	}
}

// property BSSExpireCount u

func (v *interfaceInterface1) BSSExpireCount() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "BSSExpireCount",
	}
}

// property Country s

func (v *interfaceInterface1) Country() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Country",
	}
}

// property Ifname s

func (v *interfaceInterface1) Ifname() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Ifname",
	}
}

// property Driver s

func (v *interfaceInterface1) Driver() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Driver",
	}
}

// property BridgeIfname s

func (v *interfaceInterface1) BridgeIfname() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "BridgeIfname",
	}
}

// property ConfigFile s

func (v *interfaceInterface1) ConfigFile() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "ConfigFile",
	}
}

// property CurrentBSS o

func (v *interfaceInterface1) CurrentBSS() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "CurrentBSS",
	}
}

// property CurrentNetwork o

func (v *interfaceInterface1) CurrentNetwork() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "CurrentNetwork",
	}
}

// property CurrentAuthMode s

func (v *interfaceInterface1) CurrentAuthMode() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "CurrentAuthMode",
	}
}

type PropInterfaceBlobs interface {
	Get(flags dbus.Flags) (value map[string][]byte, err error)
	Set(flags dbus.Flags, value map[string][]byte) error
	ConnectChanged(cb func(hasValue bool, value map[string][]byte)) error
}

type implPropInterfaceBlobs struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropInterfaceBlobs) Get(flags dbus.Flags) (value map[string][]byte, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropInterfaceBlobs) Set(flags dbus.Flags, value map[string][]byte) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropInterfaceBlobs) ConnectChanged(cb func(hasValue bool, value map[string][]byte)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v map[string][]byte
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, nil)
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

// property Blobs a{say}

func (v *interfaceInterface1) Blobs() PropInterfaceBlobs {
	return &implPropInterfaceBlobs{
		Impl: v,
		Name: "Blobs",
	}
}

// property BSSs ao

func (v *interfaceInterface1) BSSs() proxy.PropObjectPathArray {
	return &proxy.ImplPropObjectPathArray{
		Impl: v,
		Name: "BSSs",
	}
}

// property Networks ao

func (v *interfaceInterface1) Networks() proxy.PropObjectPathArray {
	return &proxy.ImplPropObjectPathArray{
		Impl: v,
		Name: "Networks",
	}
}

// property FastReauth b

func (v *interfaceInterface1) FastReauth() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "FastReauth",
	}
}

// property ScanInterval i

func (v *interfaceInterface1) ScanInterval() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "ScanInterval",
	}
}

// property PKCS11EnginePath s

func (v *interfaceInterface1) PKCS11EnginePath() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "PKCS11EnginePath",
	}
}

// property PKCS11ModulePath s

func (v *interfaceInterface1) PKCS11ModulePath() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "PKCS11ModulePath",
	}
}

// property DisconnectReason i

func (v *interfaceInterface1) DisconnectReason() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "DisconnectReason",
	}
}

// property AuthStatusCode i

func (v *interfaceInterface1) AuthStatusCode() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "AuthStatusCode",
	}
}

// property AssocStatusCode i

func (v *interfaceInterface1) AssocStatusCode() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "AssocStatusCode",
	}
}

// property Stations ao

func (v *interfaceInterface1) Stations() proxy.PropObjectPathArray {
	return &proxy.ImplPropObjectPathArray{
		Impl: v,
		Name: "Stations",
	}
}

// property CtrlInterface s

func (v *interfaceInterface1) CtrlInterface() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "CtrlInterface",
	}
}

// property CtrlInterfaceGroup s

func (v *interfaceInterface1) CtrlInterfaceGroup() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "CtrlInterfaceGroup",
	}
}

// property EapolVersion s

func (v *interfaceInterface1) EapolVersion() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "EapolVersion",
	}
}

// property Bgscan s

func (v *interfaceInterface1) Bgscan() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Bgscan",
	}
}

// property DisableScanOffload s

func (v *interfaceInterface1) DisableScanOffload() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "DisableScanOffload",
	}
}

// property OpenscEnginePath s

func (v *interfaceInterface1) OpenscEnginePath() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "OpenscEnginePath",
	}
}

// property OpensslCiphers s

func (v *interfaceInterface1) OpensslCiphers() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "OpensslCiphers",
	}
}

// property PcscReader s

func (v *interfaceInterface1) PcscReader() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "PcscReader",
	}
}

// property PcscPin s

func (v *interfaceInterface1) PcscPin() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "PcscPin",
	}
}

// property ExternalSim s

func (v *interfaceInterface1) ExternalSim() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "ExternalSim",
	}
}

// property DriverParam s

func (v *interfaceInterface1) DriverParam() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "DriverParam",
	}
}

// property Dot11RSNAConfigPMKLifetime s

func (v *interfaceInterface1) Dot11RSNAConfigPMKLifetime() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Dot11RSNAConfigPMKLifetime",
	}
}

// property Dot11RSNAConfigPMKReauthThreshold s

func (v *interfaceInterface1) Dot11RSNAConfigPMKReauthThreshold() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Dot11RSNAConfigPMKReauthThreshold",
	}
}

// property Dot11RSNAConfigSATimeout s

func (v *interfaceInterface1) Dot11RSNAConfigSATimeout() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Dot11RSNAConfigSATimeout",
	}
}

// property UpdateConfig s

func (v *interfaceInterface1) UpdateConfig() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "UpdateConfig",
	}
}

// property Uuid s

func (v *interfaceInterface1) Uuid() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Uuid",
	}
}

// property AutoUuid s

func (v *interfaceInterface1) AutoUuid() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "AutoUuid",
	}
}

// property DeviceName s

func (v *interfaceInterface1) DeviceName() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "DeviceName",
	}
}

// property Manufacturer s

func (v *interfaceInterface1) Manufacturer() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Manufacturer",
	}
}

// property ModelName s

func (v *interfaceInterface1) ModelName() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "ModelName",
	}
}

// property ModelNumber s

func (v *interfaceInterface1) ModelNumber() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "ModelNumber",
	}
}

// property SerialNumber s

func (v *interfaceInterface1) SerialNumber() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "SerialNumber",
	}
}

// property DeviceType s

func (v *interfaceInterface1) DeviceType() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "DeviceType",
	}
}

// property OsVersion s

func (v *interfaceInterface1) OsVersion() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "OsVersion",
	}
}

// property ConfigMethods s

func (v *interfaceInterface1) ConfigMethods() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "ConfigMethods",
	}
}

// property WpsCredProcessing s

func (v *interfaceInterface1) WpsCredProcessing() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "WpsCredProcessing",
	}
}

// property WpsVendorExtM1 s

func (v *interfaceInterface1) WpsVendorExtM1() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "WpsVendorExtM1",
	}
}

// property SecDeviceType s

func (v *interfaceInterface1) SecDeviceType() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "SecDeviceType",
	}
}

// property P2pListenRegClass s

func (v *interfaceInterface1) P2pListenRegClass() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "P2pListenRegClass",
	}
}

// property P2pListenChannel s

func (v *interfaceInterface1) P2pListenChannel() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "P2pListenChannel",
	}
}

// property P2pOperRegClass s

func (v *interfaceInterface1) P2pOperRegClass() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "P2pOperRegClass",
	}
}

// property P2pOperChannel s

func (v *interfaceInterface1) P2pOperChannel() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "P2pOperChannel",
	}
}

// property P2pGoIntent s

func (v *interfaceInterface1) P2pGoIntent() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "P2pGoIntent",
	}
}

// property P2pSsidPostfix s

func (v *interfaceInterface1) P2pSsidPostfix() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "P2pSsidPostfix",
	}
}

// property PersistentReconnect s

func (v *interfaceInterface1) PersistentReconnect() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "PersistentReconnect",
	}
}

// property P2pIntraBss s

func (v *interfaceInterface1) P2pIntraBss() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "P2pIntraBss",
	}
}

// property P2pGroupIdle s

func (v *interfaceInterface1) P2pGroupIdle() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "P2pGroupIdle",
	}
}

// property P2pGoFreqChangePolicy s

func (v *interfaceInterface1) P2pGoFreqChangePolicy() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "P2pGoFreqChangePolicy",
	}
}

// property P2pPassphraseLen s

func (v *interfaceInterface1) P2pPassphraseLen() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "P2pPassphraseLen",
	}
}

// property P2pPrefChan s

func (v *interfaceInterface1) P2pPrefChan() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "P2pPrefChan",
	}
}

// property P2pNoGoFreq s

func (v *interfaceInterface1) P2pNoGoFreq() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "P2pNoGoFreq",
	}
}

// property P2pAddCliChan s

func (v *interfaceInterface1) P2pAddCliChan() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "P2pAddCliChan",
	}
}

// property P2pOptimizeListenChan s

func (v *interfaceInterface1) P2pOptimizeListenChan() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "P2pOptimizeListenChan",
	}
}

// property P2pGoHt40 s

func (v *interfaceInterface1) P2pGoHt40() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "P2pGoHt40",
	}
}

// property P2pGoVht s

func (v *interfaceInterface1) P2pGoVht() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "P2pGoVht",
	}
}

// property P2pGoHe s

func (v *interfaceInterface1) P2pGoHe() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "P2pGoHe",
	}
}

// property P2pDisabled s

func (v *interfaceInterface1) P2pDisabled() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "P2pDisabled",
	}
}

// property P2pGoCtwindow s

func (v *interfaceInterface1) P2pGoCtwindow() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "P2pGoCtwindow",
	}
}

// property P2pNoGroupIface s

func (v *interfaceInterface1) P2pNoGroupIface() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "P2pNoGroupIface",
	}
}

// property P2pIgnoreSharedFreq s

func (v *interfaceInterface1) P2pIgnoreSharedFreq() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "P2pIgnoreSharedFreq",
	}
}

// property IpAddrGo s

func (v *interfaceInterface1) IpAddrGo() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "IpAddrGo",
	}
}

// property IpAddrMask s

func (v *interfaceInterface1) IpAddrMask() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "IpAddrMask",
	}
}

// property IpAddrStart s

func (v *interfaceInterface1) IpAddrStart() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "IpAddrStart",
	}
}

// property IpAddrEnd s

func (v *interfaceInterface1) IpAddrEnd() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "IpAddrEnd",
	}
}

// property P2pCliProbe s

func (v *interfaceInterface1) P2pCliProbe() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "P2pCliProbe",
	}
}

// property P2pDeviceRandomMacAddr s

func (v *interfaceInterface1) P2pDeviceRandomMacAddr() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "P2pDeviceRandomMacAddr",
	}
}

// property P2pDevicePersistentMacAddr s

func (v *interfaceInterface1) P2pDevicePersistentMacAddr() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "P2pDevicePersistentMacAddr",
	}
}

// property P2pInterfaceRandomMacAddr s

func (v *interfaceInterface1) P2pInterfaceRandomMacAddr() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "P2pInterfaceRandomMacAddr",
	}
}

// property BssMaxCount s

func (v *interfaceInterface1) BssMaxCount() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "BssMaxCount",
	}
}

// property FilterSsids s

func (v *interfaceInterface1) FilterSsids() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "FilterSsids",
	}
}

// property FilterRssi s

func (v *interfaceInterface1) FilterRssi() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "FilterRssi",
	}
}

// property MaxNumSta s

func (v *interfaceInterface1) MaxNumSta() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "MaxNumSta",
	}
}

// property ApIsolate s

func (v *interfaceInterface1) ApIsolate() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "ApIsolate",
	}
}

// property DisassocLowAck s

func (v *interfaceInterface1) DisassocLowAck() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "DisassocLowAck",
	}
}

// property Hs20 s

func (v *interfaceInterface1) Hs20() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Hs20",
	}
}

// property Interworking s

func (v *interfaceInterface1) Interworking() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Interworking",
	}
}

// property Hessid s

func (v *interfaceInterface1) Hessid() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Hessid",
	}
}

// property AccessNetworkType s

func (v *interfaceInterface1) AccessNetworkType() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "AccessNetworkType",
	}
}

// property GoInterworking s

func (v *interfaceInterface1) GoInterworking() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "GoInterworking",
	}
}

// property GoAccessNetworkType s

func (v *interfaceInterface1) GoAccessNetworkType() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "GoAccessNetworkType",
	}
}

// property GoInternet s

func (v *interfaceInterface1) GoInternet() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "GoInternet",
	}
}

// property GoVenueGroup s

func (v *interfaceInterface1) GoVenueGroup() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "GoVenueGroup",
	}
}

// property GoVenueType s

func (v *interfaceInterface1) GoVenueType() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "GoVenueType",
	}
}

// property PbcInM1 s

func (v *interfaceInterface1) PbcInM1() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "PbcInM1",
	}
}

// property Autoscan s

func (v *interfaceInterface1) Autoscan() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Autoscan",
	}
}

// property WpsNfcDevPwId s

func (v *interfaceInterface1) WpsNfcDevPwId() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "WpsNfcDevPwId",
	}
}

// property WpsNfcDhPubkey s

func (v *interfaceInterface1) WpsNfcDhPubkey() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "WpsNfcDhPubkey",
	}
}

// property WpsNfcDhPrivkey s

func (v *interfaceInterface1) WpsNfcDhPrivkey() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "WpsNfcDhPrivkey",
	}
}

// property WpsNfcDevPw s

func (v *interfaceInterface1) WpsNfcDevPw() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "WpsNfcDevPw",
	}
}

// property ExtPasswordBackend s

func (v *interfaceInterface1) ExtPasswordBackend() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "ExtPasswordBackend",
	}
}

// property P2pGoMaxInactivity s

func (v *interfaceInterface1) P2pGoMaxInactivity() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "P2pGoMaxInactivity",
	}
}

// property AutoInterworking s

func (v *interfaceInterface1) AutoInterworking() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "AutoInterworking",
	}
}

// property Okc s

func (v *interfaceInterface1) Okc() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Okc",
	}
}

// property Pmf s

func (v *interfaceInterface1) Pmf() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Pmf",
	}
}

// property SaeGroups s

func (v *interfaceInterface1) SaeGroups() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "SaeGroups",
	}
}

// property DtimPeriod s

func (v *interfaceInterface1) DtimPeriod() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "DtimPeriod",
	}
}

// property BeaconInt s

func (v *interfaceInterface1) BeaconInt() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "BeaconInt",
	}
}

// property ApVendorElements s

func (v *interfaceInterface1) ApVendorElements() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "ApVendorElements",
	}
}

// property IgnoreOldScanRes s

func (v *interfaceInterface1) IgnoreOldScanRes() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "IgnoreOldScanRes",
	}
}

// property FreqList s

func (v *interfaceInterface1) FreqList() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "FreqList",
	}
}

// property ScanCurFreq s

func (v *interfaceInterface1) ScanCurFreq() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "ScanCurFreq",
	}
}

// property SchedScanInterval s

func (v *interfaceInterface1) SchedScanInterval() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "SchedScanInterval",
	}
}

// property SchedScanStartDelay s

func (v *interfaceInterface1) SchedScanStartDelay() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "SchedScanStartDelay",
	}
}

// property TdlsExternalControl s

func (v *interfaceInterface1) TdlsExternalControl() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "TdlsExternalControl",
	}
}

// property OsuDir s

func (v *interfaceInterface1) OsuDir() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "OsuDir",
	}
}

// property WowlanTriggers s

func (v *interfaceInterface1) WowlanTriggers() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "WowlanTriggers",
	}
}

// property P2pSearchDelay s

func (v *interfaceInterface1) P2pSearchDelay() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "P2pSearchDelay",
	}
}

// property MacAddr s

func (v *interfaceInterface1) MacAddr() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "MacAddr",
	}
}

// property RandAddrLifetime s

func (v *interfaceInterface1) RandAddrLifetime() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "RandAddrLifetime",
	}
}

// property PreassocMacAddr s

func (v *interfaceInterface1) PreassocMacAddr() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "PreassocMacAddr",
	}
}

// property KeyMgmtOffload s

func (v *interfaceInterface1) KeyMgmtOffload() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "KeyMgmtOffload",
	}
}

// property PassiveScan s

func (v *interfaceInterface1) PassiveScan() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "PassiveScan",
	}
}

// property ReassocSameBssOptim s

func (v *interfaceInterface1) ReassocSameBssOptim() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "ReassocSameBssOptim",
	}
}

// property WpsPriority s

func (v *interfaceInterface1) WpsPriority() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "WpsPriority",
	}
}

// property FstGroupId s

func (v *interfaceInterface1) FstGroupId() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "FstGroupId",
	}
}

// property FstPriority s

func (v *interfaceInterface1) FstPriority() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "FstPriority",
	}
}

// property FstLlt s

func (v *interfaceInterface1) FstLlt() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "FstLlt",
	}
}

// property CertInCb s

func (v *interfaceInterface1) CertInCb() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "CertInCb",
	}
}

// property WpaRscRelaxation s

func (v *interfaceInterface1) WpaRscRelaxation() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "WpaRscRelaxation",
	}
}

// property SchedScanPlans s

func (v *interfaceInterface1) SchedScanPlans() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "SchedScanPlans",
	}
}

// property GasAddress3 s

func (v *interfaceInterface1) GasAddress3() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "GasAddress3",
	}
}

// property FtmResponder s

func (v *interfaceInterface1) FtmResponder() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "FtmResponder",
	}
}

// property FtmInitiator s

func (v *interfaceInterface1) FtmInitiator() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "FtmInitiator",
	}
}

// property GasRandAddrLifetime s

func (v *interfaceInterface1) GasRandAddrLifetime() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "GasRandAddrLifetime",
	}
}

// property GasRandMacAddr s

func (v *interfaceInterface1) GasRandMacAddr() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "GasRandMacAddr",
	}
}

// property DppConfigProcessing s

func (v *interfaceInterface1) DppConfigProcessing() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "DppConfigProcessing",
	}
}

// property ColocIntfReporting s

func (v *interfaceInterface1) ColocIntfReporting() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "ColocIntfReporting",
	}
}

func (obj *objectInterface) WPS() interfaceWPS {
	return &obj.interfaceInterfaceWPS
}

type interfaceWPS interface {
	GoStart(flags dbus.Flags, ch chan *dbus.Call, args map[string]dbus.Variant) *dbus.Call
	Start(flags dbus.Flags, args map[string]dbus.Variant) (map[string]dbus.Variant, error)
	GoCancel(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Cancel(flags dbus.Flags) error
	ConnectEvent(cb func(name string, args map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	ConnectCredentials(cb func(credentials map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	ProcessCredentials() proxy.PropBool
	ConfigMethods() proxy.PropString
	DeviceName() proxy.PropString
	Manufacturer() proxy.PropString
	ModelName() proxy.PropString
	ModelNumber() proxy.PropString
	SerialNumber() proxy.PropString
	DeviceType() proxy.PropByteArray
}

type interfaceInterfaceWPS struct{}

func (v *interfaceInterfaceWPS) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceInterfaceWPS) GetInterfaceName_() string {
	return "fi.w1.wpa_supplicant1.Interface.WPS"
}

// method Start

func (v *interfaceInterfaceWPS) GoStart(flags dbus.Flags, ch chan *dbus.Call, args map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Start", flags, ch, args)
}

func (*interfaceInterfaceWPS) StoreStart(call *dbus.Call) (output map[string]dbus.Variant, err error) {
	err = call.Store(&output)
	return
}

func (v *interfaceInterfaceWPS) Start(flags dbus.Flags, args map[string]dbus.Variant) (map[string]dbus.Variant, error) {
	return v.StoreStart(
		<-v.GoStart(flags, make(chan *dbus.Call, 1), args).Done)
}

// method Cancel

func (v *interfaceInterfaceWPS) GoCancel(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Cancel", flags, ch)
}

func (v *interfaceInterfaceWPS) Cancel(flags dbus.Flags) error {
	return (<-v.GoCancel(flags, make(chan *dbus.Call, 1)).Done).Err
}

// signal Event

func (v *interfaceInterfaceWPS) ConnectEvent(cb func(name string, args map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "Event", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".Event",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var name string
		var args map[string]dbus.Variant
		err := dbus.Store(sig.Body, &name, &args)
		if err == nil {
			cb(name, args)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal Credentials

func (v *interfaceInterfaceWPS) ConnectCredentials(cb func(credentials map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "Credentials", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".Credentials",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var credentials map[string]dbus.Variant
		err := dbus.Store(sig.Body, &credentials)
		if err == nil {
			cb(credentials)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal PropertiesChanged

func (v *interfaceInterfaceWPS) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property ProcessCredentials b

func (v *interfaceInterfaceWPS) ProcessCredentials() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "ProcessCredentials",
	}
}

// property ConfigMethods s

func (v *interfaceInterfaceWPS) ConfigMethods() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "ConfigMethods",
	}
}

// property DeviceName s

func (v *interfaceInterfaceWPS) DeviceName() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "DeviceName",
	}
}

// property Manufacturer s

func (v *interfaceInterfaceWPS) Manufacturer() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Manufacturer",
	}
}

// property ModelName s

func (v *interfaceInterfaceWPS) ModelName() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "ModelName",
	}
}

// property ModelNumber s

func (v *interfaceInterfaceWPS) ModelNumber() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "ModelNumber",
	}
}

// property SerialNumber s

func (v *interfaceInterfaceWPS) SerialNumber() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "SerialNumber",
	}
}

// property DeviceType ay

func (v *interfaceInterfaceWPS) DeviceType() proxy.PropByteArray {
	return &proxy.ImplPropByteArray{
		Impl: v,
		Name: "DeviceType",
	}
}

func (obj *objectInterface) P2PDevice() interfaceP2PDevice {
	return &obj.interfaceInterfaceP2PDevice
}

type interfaceP2PDevice interface {
	GoFind(flags dbus.Flags, ch chan *dbus.Call, args map[string]dbus.Variant) *dbus.Call
	Find(flags dbus.Flags, args map[string]dbus.Variant) error
	GoStopFind(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	StopFind(flags dbus.Flags) error
	GoListen(flags dbus.Flags, ch chan *dbus.Call, timeout int32) *dbus.Call
	Listen(flags dbus.Flags, timeout int32) error
	GoExtendedListen(flags dbus.Flags, ch chan *dbus.Call, args map[string]dbus.Variant) *dbus.Call
	ExtendedListen(flags dbus.Flags, args map[string]dbus.Variant) error
	GoPresenceRequest(flags dbus.Flags, ch chan *dbus.Call, args map[string]dbus.Variant) *dbus.Call
	PresenceRequest(flags dbus.Flags, args map[string]dbus.Variant) error
	GoProvisionDiscoveryRequest(flags dbus.Flags, ch chan *dbus.Call, peer dbus.ObjectPath, config_method string) *dbus.Call
	ProvisionDiscoveryRequest(flags dbus.Flags, peer dbus.ObjectPath, config_method string) error
	GoConnect(flags dbus.Flags, ch chan *dbus.Call, args map[string]dbus.Variant) *dbus.Call
	Connect(flags dbus.Flags, args map[string]dbus.Variant) (string, error)
	GoGroupAdd(flags dbus.Flags, ch chan *dbus.Call, args map[string]dbus.Variant) *dbus.Call
	GroupAdd(flags dbus.Flags, args map[string]dbus.Variant) error
	GoCancel(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Cancel(flags dbus.Flags) error
	GoInvite(flags dbus.Flags, ch chan *dbus.Call, args map[string]dbus.Variant) *dbus.Call
	Invite(flags dbus.Flags, args map[string]dbus.Variant) error
	GoDisconnect(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Disconnect(flags dbus.Flags) error
	GoRejectPeer(flags dbus.Flags, ch chan *dbus.Call, peer dbus.ObjectPath) *dbus.Call
	RejectPeer(flags dbus.Flags, peer dbus.ObjectPath) error
	GoRemoveClient(flags dbus.Flags, ch chan *dbus.Call, args map[string]dbus.Variant) *dbus.Call
	RemoveClient(flags dbus.Flags, args map[string]dbus.Variant) error
	GoFlush(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Flush(flags dbus.Flags) error
	GoAddService(flags dbus.Flags, ch chan *dbus.Call, args map[string]dbus.Variant) *dbus.Call
	AddService(flags dbus.Flags, args map[string]dbus.Variant) error
	GoDeleteService(flags dbus.Flags, ch chan *dbus.Call, args map[string]dbus.Variant) *dbus.Call
	DeleteService(flags dbus.Flags, args map[string]dbus.Variant) error
	GoFlushService(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	FlushService(flags dbus.Flags) error
	GoServiceDiscoveryRequest(flags dbus.Flags, ch chan *dbus.Call, args map[string]dbus.Variant) *dbus.Call
	ServiceDiscoveryRequest(flags dbus.Flags, args map[string]dbus.Variant) (uint64, error)
	GoServiceDiscoveryResponse(flags dbus.Flags, ch chan *dbus.Call, args map[string]dbus.Variant) *dbus.Call
	ServiceDiscoveryResponse(flags dbus.Flags, args map[string]dbus.Variant) error
	GoServiceDiscoveryCancelRequest(flags dbus.Flags, ch chan *dbus.Call, args uint64) *dbus.Call
	ServiceDiscoveryCancelRequest(flags dbus.Flags, args uint64) error
	GoServiceUpdate(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	ServiceUpdate(flags dbus.Flags) error
	GoServiceDiscoveryExternal(flags dbus.Flags, ch chan *dbus.Call, arg int32) *dbus.Call
	ServiceDiscoveryExternal(flags dbus.Flags, arg int32) error
	GoAddPersistentGroup(flags dbus.Flags, ch chan *dbus.Call, args map[string]dbus.Variant) *dbus.Call
	AddPersistentGroup(flags dbus.Flags, args map[string]dbus.Variant) (dbus.ObjectPath, error)
	GoRemovePersistentGroup(flags dbus.Flags, ch chan *dbus.Call, path dbus.ObjectPath) *dbus.Call
	RemovePersistentGroup(flags dbus.Flags, path dbus.ObjectPath) error
	GoRemoveAllPersistentGroups(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	RemoveAllPersistentGroups(flags dbus.Flags) error
	ConnectDeviceFound(cb func(path dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	ConnectDeviceFoundProperties(cb func(path dbus.ObjectPath, properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	ConnectDeviceLost(cb func(path dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	ConnectFindStopped(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectProvisionDiscoveryRequestDisplayPin(cb func(peer_object dbus.ObjectPath, pin string)) (dbusutil.SignalHandlerId, error)
	ConnectProvisionDiscoveryResponseDisplayPin(cb func(peer_object dbus.ObjectPath, pin string)) (dbusutil.SignalHandlerId, error)
	ConnectProvisionDiscoveryRequestEnterPin(cb func(peer_object dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	ConnectProvisionDiscoveryResponseEnterPin(cb func(peer_object dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	ConnectProvisionDiscoveryPBCRequest(cb func(peer_object dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	ConnectProvisionDiscoveryPBCResponse(cb func(peer_object dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	ConnectProvisionDiscoveryFailure(cb func(peer_object dbus.ObjectPath, status int32)) (dbusutil.SignalHandlerId, error)
	ConnectGroupStarted(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	ConnectGroupFormationFailure(cb func(reason string)) (dbusutil.SignalHandlerId, error)
	ConnectGONegotiationSuccess(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	ConnectGONegotiationFailure(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	ConnectGONegotiationRequest(cb func(path dbus.ObjectPath, dev_passwd_id uint16, device_go_intent uint8)) (dbusutil.SignalHandlerId, error)
	ConnectInvitationResult(cb func(invite_result map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	ConnectGroupFinished(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	ConnectServiceDiscoveryRequest(cb func(sd_request map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	ConnectServiceDiscoveryResponse(cb func(sd_response map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	ConnectPersistentGroupAdded(cb func(path dbus.ObjectPath, properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	ConnectPersistentGroupRemoved(cb func(path dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	ConnectWpsFailed(cb func(name string, args map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	ConnectInvitationReceived(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	P2PDeviceConfig() MapStrVariant
	Peers() proxy.PropObjectPathArray
	Role() proxy.PropString
	Group() proxy.PropObjectPath
	PeerGO() proxy.PropObjectPath
	PersistentGroups() proxy.PropObjectPathArray
}

type interfaceInterfaceP2PDevice struct{}

func (v *interfaceInterfaceP2PDevice) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceInterfaceP2PDevice) GetInterfaceName_() string {
	return "fi.w1.wpa_supplicant1.Interface.P2PDevice"
}

// method Find

func (v *interfaceInterfaceP2PDevice) GoFind(flags dbus.Flags, ch chan *dbus.Call, args map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Find", flags, ch, args)
}

func (v *interfaceInterfaceP2PDevice) Find(flags dbus.Flags, args map[string]dbus.Variant) error {
	return (<-v.GoFind(flags, make(chan *dbus.Call, 1), args).Done).Err
}

// method StopFind

func (v *interfaceInterfaceP2PDevice) GoStopFind(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".StopFind", flags, ch)
}

func (v *interfaceInterfaceP2PDevice) StopFind(flags dbus.Flags) error {
	return (<-v.GoStopFind(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method Listen

func (v *interfaceInterfaceP2PDevice) GoListen(flags dbus.Flags, ch chan *dbus.Call, timeout int32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Listen", flags, ch, timeout)
}

func (v *interfaceInterfaceP2PDevice) Listen(flags dbus.Flags, timeout int32) error {
	return (<-v.GoListen(flags, make(chan *dbus.Call, 1), timeout).Done).Err
}

// method ExtendedListen

func (v *interfaceInterfaceP2PDevice) GoExtendedListen(flags dbus.Flags, ch chan *dbus.Call, args map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ExtendedListen", flags, ch, args)
}

func (v *interfaceInterfaceP2PDevice) ExtendedListen(flags dbus.Flags, args map[string]dbus.Variant) error {
	return (<-v.GoExtendedListen(flags, make(chan *dbus.Call, 1), args).Done).Err
}

// method PresenceRequest

func (v *interfaceInterfaceP2PDevice) GoPresenceRequest(flags dbus.Flags, ch chan *dbus.Call, args map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".PresenceRequest", flags, ch, args)
}

func (v *interfaceInterfaceP2PDevice) PresenceRequest(flags dbus.Flags, args map[string]dbus.Variant) error {
	return (<-v.GoPresenceRequest(flags, make(chan *dbus.Call, 1), args).Done).Err
}

// method ProvisionDiscoveryRequest

func (v *interfaceInterfaceP2PDevice) GoProvisionDiscoveryRequest(flags dbus.Flags, ch chan *dbus.Call, peer dbus.ObjectPath, config_method string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ProvisionDiscoveryRequest", flags, ch, peer, config_method)
}

func (v *interfaceInterfaceP2PDevice) ProvisionDiscoveryRequest(flags dbus.Flags, peer dbus.ObjectPath, config_method string) error {
	return (<-v.GoProvisionDiscoveryRequest(flags, make(chan *dbus.Call, 1), peer, config_method).Done).Err
}

// method Connect

func (v *interfaceInterfaceP2PDevice) GoConnect(flags dbus.Flags, ch chan *dbus.Call, args map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Connect", flags, ch, args)
}

func (*interfaceInterfaceP2PDevice) StoreConnect(call *dbus.Call) (generated_pin string, err error) {
	err = call.Store(&generated_pin)
	return
}

func (v *interfaceInterfaceP2PDevice) Connect(flags dbus.Flags, args map[string]dbus.Variant) (string, error) {
	return v.StoreConnect(
		<-v.GoConnect(flags, make(chan *dbus.Call, 1), args).Done)
}

// method GroupAdd

func (v *interfaceInterfaceP2PDevice) GoGroupAdd(flags dbus.Flags, ch chan *dbus.Call, args map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GroupAdd", flags, ch, args)
}

func (v *interfaceInterfaceP2PDevice) GroupAdd(flags dbus.Flags, args map[string]dbus.Variant) error {
	return (<-v.GoGroupAdd(flags, make(chan *dbus.Call, 1), args).Done).Err
}

// method Cancel

func (v *interfaceInterfaceP2PDevice) GoCancel(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Cancel", flags, ch)
}

func (v *interfaceInterfaceP2PDevice) Cancel(flags dbus.Flags) error {
	return (<-v.GoCancel(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method Invite

func (v *interfaceInterfaceP2PDevice) GoInvite(flags dbus.Flags, ch chan *dbus.Call, args map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Invite", flags, ch, args)
}

func (v *interfaceInterfaceP2PDevice) Invite(flags dbus.Flags, args map[string]dbus.Variant) error {
	return (<-v.GoInvite(flags, make(chan *dbus.Call, 1), args).Done).Err
}

// method Disconnect

func (v *interfaceInterfaceP2PDevice) GoDisconnect(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Disconnect", flags, ch)
}

func (v *interfaceInterfaceP2PDevice) Disconnect(flags dbus.Flags) error {
	return (<-v.GoDisconnect(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method RejectPeer

func (v *interfaceInterfaceP2PDevice) GoRejectPeer(flags dbus.Flags, ch chan *dbus.Call, peer dbus.ObjectPath) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RejectPeer", flags, ch, peer)
}

func (v *interfaceInterfaceP2PDevice) RejectPeer(flags dbus.Flags, peer dbus.ObjectPath) error {
	return (<-v.GoRejectPeer(flags, make(chan *dbus.Call, 1), peer).Done).Err
}

// method RemoveClient

func (v *interfaceInterfaceP2PDevice) GoRemoveClient(flags dbus.Flags, ch chan *dbus.Call, args map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RemoveClient", flags, ch, args)
}

func (v *interfaceInterfaceP2PDevice) RemoveClient(flags dbus.Flags, args map[string]dbus.Variant) error {
	return (<-v.GoRemoveClient(flags, make(chan *dbus.Call, 1), args).Done).Err
}

// method Flush

func (v *interfaceInterfaceP2PDevice) GoFlush(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Flush", flags, ch)
}

func (v *interfaceInterfaceP2PDevice) Flush(flags dbus.Flags) error {
	return (<-v.GoFlush(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method AddService

func (v *interfaceInterfaceP2PDevice) GoAddService(flags dbus.Flags, ch chan *dbus.Call, args map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".AddService", flags, ch, args)
}

func (v *interfaceInterfaceP2PDevice) AddService(flags dbus.Flags, args map[string]dbus.Variant) error {
	return (<-v.GoAddService(flags, make(chan *dbus.Call, 1), args).Done).Err
}

// method DeleteService

func (v *interfaceInterfaceP2PDevice) GoDeleteService(flags dbus.Flags, ch chan *dbus.Call, args map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".DeleteService", flags, ch, args)
}

func (v *interfaceInterfaceP2PDevice) DeleteService(flags dbus.Flags, args map[string]dbus.Variant) error {
	return (<-v.GoDeleteService(flags, make(chan *dbus.Call, 1), args).Done).Err
}

// method FlushService

func (v *interfaceInterfaceP2PDevice) GoFlushService(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".FlushService", flags, ch)
}

func (v *interfaceInterfaceP2PDevice) FlushService(flags dbus.Flags) error {
	return (<-v.GoFlushService(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method ServiceDiscoveryRequest

func (v *interfaceInterfaceP2PDevice) GoServiceDiscoveryRequest(flags dbus.Flags, ch chan *dbus.Call, args map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ServiceDiscoveryRequest", flags, ch, args)
}

func (*interfaceInterfaceP2PDevice) StoreServiceDiscoveryRequest(call *dbus.Call) (ref uint64, err error) {
	err = call.Store(&ref)
	return
}

func (v *interfaceInterfaceP2PDevice) ServiceDiscoveryRequest(flags dbus.Flags, args map[string]dbus.Variant) (uint64, error) {
	return v.StoreServiceDiscoveryRequest(
		<-v.GoServiceDiscoveryRequest(flags, make(chan *dbus.Call, 1), args).Done)
}

// method ServiceDiscoveryResponse

func (v *interfaceInterfaceP2PDevice) GoServiceDiscoveryResponse(flags dbus.Flags, ch chan *dbus.Call, args map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ServiceDiscoveryResponse", flags, ch, args)
}

func (v *interfaceInterfaceP2PDevice) ServiceDiscoveryResponse(flags dbus.Flags, args map[string]dbus.Variant) error {
	return (<-v.GoServiceDiscoveryResponse(flags, make(chan *dbus.Call, 1), args).Done).Err
}

// method ServiceDiscoveryCancelRequest

func (v *interfaceInterfaceP2PDevice) GoServiceDiscoveryCancelRequest(flags dbus.Flags, ch chan *dbus.Call, args uint64) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ServiceDiscoveryCancelRequest", flags, ch, args)
}

func (v *interfaceInterfaceP2PDevice) ServiceDiscoveryCancelRequest(flags dbus.Flags, args uint64) error {
	return (<-v.GoServiceDiscoveryCancelRequest(flags, make(chan *dbus.Call, 1), args).Done).Err
}

// method ServiceUpdate

func (v *interfaceInterfaceP2PDevice) GoServiceUpdate(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ServiceUpdate", flags, ch)
}

func (v *interfaceInterfaceP2PDevice) ServiceUpdate(flags dbus.Flags) error {
	return (<-v.GoServiceUpdate(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method ServiceDiscoveryExternal

func (v *interfaceInterfaceP2PDevice) GoServiceDiscoveryExternal(flags dbus.Flags, ch chan *dbus.Call, arg int32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ServiceDiscoveryExternal", flags, ch, arg)
}

func (v *interfaceInterfaceP2PDevice) ServiceDiscoveryExternal(flags dbus.Flags, arg int32) error {
	return (<-v.GoServiceDiscoveryExternal(flags, make(chan *dbus.Call, 1), arg).Done).Err
}

// method AddPersistentGroup

func (v *interfaceInterfaceP2PDevice) GoAddPersistentGroup(flags dbus.Flags, ch chan *dbus.Call, args map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".AddPersistentGroup", flags, ch, args)
}

func (*interfaceInterfaceP2PDevice) StoreAddPersistentGroup(call *dbus.Call) (path dbus.ObjectPath, err error) {
	err = call.Store(&path)
	return
}

func (v *interfaceInterfaceP2PDevice) AddPersistentGroup(flags dbus.Flags, args map[string]dbus.Variant) (dbus.ObjectPath, error) {
	return v.StoreAddPersistentGroup(
		<-v.GoAddPersistentGroup(flags, make(chan *dbus.Call, 1), args).Done)
}

// method RemovePersistentGroup

func (v *interfaceInterfaceP2PDevice) GoRemovePersistentGroup(flags dbus.Flags, ch chan *dbus.Call, path dbus.ObjectPath) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RemovePersistentGroup", flags, ch, path)
}

func (v *interfaceInterfaceP2PDevice) RemovePersistentGroup(flags dbus.Flags, path dbus.ObjectPath) error {
	return (<-v.GoRemovePersistentGroup(flags, make(chan *dbus.Call, 1), path).Done).Err
}

// method RemoveAllPersistentGroups

func (v *interfaceInterfaceP2PDevice) GoRemoveAllPersistentGroups(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RemoveAllPersistentGroups", flags, ch)
}

func (v *interfaceInterfaceP2PDevice) RemoveAllPersistentGroups(flags dbus.Flags) error {
	return (<-v.GoRemoveAllPersistentGroups(flags, make(chan *dbus.Call, 1)).Done).Err
}

// signal DeviceFound

func (v *interfaceInterfaceP2PDevice) ConnectDeviceFound(cb func(path dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "DeviceFound", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".DeviceFound",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var path dbus.ObjectPath
		err := dbus.Store(sig.Body, &path)
		if err == nil {
			cb(path)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal DeviceFoundProperties

func (v *interfaceInterfaceP2PDevice) ConnectDeviceFoundProperties(cb func(path dbus.ObjectPath, properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "DeviceFoundProperties", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".DeviceFoundProperties",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var path dbus.ObjectPath
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &path, &properties)
		if err == nil {
			cb(path, properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal DeviceLost

func (v *interfaceInterfaceP2PDevice) ConnectDeviceLost(cb func(path dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "DeviceLost", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".DeviceLost",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var path dbus.ObjectPath
		err := dbus.Store(sig.Body, &path)
		if err == nil {
			cb(path)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal FindStopped

func (v *interfaceInterfaceP2PDevice) ConnectFindStopped(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "FindStopped", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".FindStopped",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal ProvisionDiscoveryRequestDisplayPin

func (v *interfaceInterfaceP2PDevice) ConnectProvisionDiscoveryRequestDisplayPin(cb func(peer_object dbus.ObjectPath, pin string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "ProvisionDiscoveryRequestDisplayPin", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".ProvisionDiscoveryRequestDisplayPin",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var peer_object dbus.ObjectPath
		var pin string
		err := dbus.Store(sig.Body, &peer_object, &pin)
		if err == nil {
			cb(peer_object, pin)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal ProvisionDiscoveryResponseDisplayPin

func (v *interfaceInterfaceP2PDevice) ConnectProvisionDiscoveryResponseDisplayPin(cb func(peer_object dbus.ObjectPath, pin string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "ProvisionDiscoveryResponseDisplayPin", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".ProvisionDiscoveryResponseDisplayPin",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var peer_object dbus.ObjectPath
		var pin string
		err := dbus.Store(sig.Body, &peer_object, &pin)
		if err == nil {
			cb(peer_object, pin)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal ProvisionDiscoveryRequestEnterPin

func (v *interfaceInterfaceP2PDevice) ConnectProvisionDiscoveryRequestEnterPin(cb func(peer_object dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "ProvisionDiscoveryRequestEnterPin", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".ProvisionDiscoveryRequestEnterPin",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var peer_object dbus.ObjectPath
		err := dbus.Store(sig.Body, &peer_object)
		if err == nil {
			cb(peer_object)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal ProvisionDiscoveryResponseEnterPin

func (v *interfaceInterfaceP2PDevice) ConnectProvisionDiscoveryResponseEnterPin(cb func(peer_object dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "ProvisionDiscoveryResponseEnterPin", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".ProvisionDiscoveryResponseEnterPin",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var peer_object dbus.ObjectPath
		err := dbus.Store(sig.Body, &peer_object)
		if err == nil {
			cb(peer_object)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal ProvisionDiscoveryPBCRequest

func (v *interfaceInterfaceP2PDevice) ConnectProvisionDiscoveryPBCRequest(cb func(peer_object dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "ProvisionDiscoveryPBCRequest", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".ProvisionDiscoveryPBCRequest",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var peer_object dbus.ObjectPath
		err := dbus.Store(sig.Body, &peer_object)
		if err == nil {
			cb(peer_object)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal ProvisionDiscoveryPBCResponse

func (v *interfaceInterfaceP2PDevice) ConnectProvisionDiscoveryPBCResponse(cb func(peer_object dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "ProvisionDiscoveryPBCResponse", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".ProvisionDiscoveryPBCResponse",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var peer_object dbus.ObjectPath
		err := dbus.Store(sig.Body, &peer_object)
		if err == nil {
			cb(peer_object)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal ProvisionDiscoveryFailure

func (v *interfaceInterfaceP2PDevice) ConnectProvisionDiscoveryFailure(cb func(peer_object dbus.ObjectPath, status int32)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "ProvisionDiscoveryFailure", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".ProvisionDiscoveryFailure",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var peer_object dbus.ObjectPath
		var status int32
		err := dbus.Store(sig.Body, &peer_object, &status)
		if err == nil {
			cb(peer_object, status)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal GroupStarted

func (v *interfaceInterfaceP2PDevice) ConnectGroupStarted(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "GroupStarted", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".GroupStarted",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal GroupFormationFailure

func (v *interfaceInterfaceP2PDevice) ConnectGroupFormationFailure(cb func(reason string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "GroupFormationFailure", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".GroupFormationFailure",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var reason string
		err := dbus.Store(sig.Body, &reason)
		if err == nil {
			cb(reason)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal GONegotiationSuccess

func (v *interfaceInterfaceP2PDevice) ConnectGONegotiationSuccess(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "GONegotiationSuccess", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".GONegotiationSuccess",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal GONegotiationFailure

func (v *interfaceInterfaceP2PDevice) ConnectGONegotiationFailure(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "GONegotiationFailure", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".GONegotiationFailure",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal GONegotiationRequest

func (v *interfaceInterfaceP2PDevice) ConnectGONegotiationRequest(cb func(path dbus.ObjectPath, dev_passwd_id uint16, device_go_intent uint8)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "GONegotiationRequest", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".GONegotiationRequest",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var path dbus.ObjectPath
		var dev_passwd_id uint16
		var device_go_intent uint8
		err := dbus.Store(sig.Body, &path, &dev_passwd_id, &device_go_intent)
		if err == nil {
			cb(path, dev_passwd_id, device_go_intent)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal InvitationResult

func (v *interfaceInterfaceP2PDevice) ConnectInvitationResult(cb func(invite_result map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "InvitationResult", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".InvitationResult",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var invite_result map[string]dbus.Variant
		err := dbus.Store(sig.Body, &invite_result)
		if err == nil {
			cb(invite_result)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal GroupFinished

func (v *interfaceInterfaceP2PDevice) ConnectGroupFinished(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "GroupFinished", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".GroupFinished",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal ServiceDiscoveryRequest

func (v *interfaceInterfaceP2PDevice) ConnectServiceDiscoveryRequest(cb func(sd_request map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "ServiceDiscoveryRequest", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".ServiceDiscoveryRequest",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var sd_request map[string]dbus.Variant
		err := dbus.Store(sig.Body, &sd_request)
		if err == nil {
			cb(sd_request)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal ServiceDiscoveryResponse

func (v *interfaceInterfaceP2PDevice) ConnectServiceDiscoveryResponse(cb func(sd_response map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "ServiceDiscoveryResponse", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".ServiceDiscoveryResponse",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var sd_response map[string]dbus.Variant
		err := dbus.Store(sig.Body, &sd_response)
		if err == nil {
			cb(sd_response)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal PersistentGroupAdded

func (v *interfaceInterfaceP2PDevice) ConnectPersistentGroupAdded(cb func(path dbus.ObjectPath, properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PersistentGroupAdded", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PersistentGroupAdded",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var path dbus.ObjectPath
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &path, &properties)
		if err == nil {
			cb(path, properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal PersistentGroupRemoved

func (v *interfaceInterfaceP2PDevice) ConnectPersistentGroupRemoved(cb func(path dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PersistentGroupRemoved", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PersistentGroupRemoved",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var path dbus.ObjectPath
		err := dbus.Store(sig.Body, &path)
		if err == nil {
			cb(path)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal WpsFailed

func (v *interfaceInterfaceP2PDevice) ConnectWpsFailed(cb func(name string, args map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "WpsFailed", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".WpsFailed",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var name string
		var args map[string]dbus.Variant
		err := dbus.Store(sig.Body, &name, &args)
		if err == nil {
			cb(name, args)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal InvitationReceived

func (v *interfaceInterfaceP2PDevice) ConnectInvitationReceived(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "InvitationReceived", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".InvitationReceived",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property P2PDeviceConfig a{sv}

func (v *interfaceInterfaceP2PDevice) P2PDeviceConfig() MapStrVariant {
	return &implMapStrVariant{
		Impl: v,
		Name: "P2PDeviceConfig",
	}
}

// property Peers ao

func (v *interfaceInterfaceP2PDevice) Peers() proxy.PropObjectPathArray {
	return &proxy.ImplPropObjectPathArray{
		Impl: v,
		Name: "Peers",
	}
}

// property Role s

func (v *interfaceInterfaceP2PDevice) Role() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Role",
	}
}

// property Group o

func (v *interfaceInterfaceP2PDevice) Group() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "Group",
	}
}

// property PeerGO o

func (v *interfaceInterfaceP2PDevice) PeerGO() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "PeerGO",
	}
}

// property PersistentGroups ao

func (v *interfaceInterfaceP2PDevice) PersistentGroups() proxy.PropObjectPathArray {
	return &proxy.ImplPropObjectPathArray{
		Impl: v,
		Name: "PersistentGroups",
	}
}

type BSS interface {
	bss // interface fi.w1.wpa_supplicant1.BSS
	proxy.Object
}

type objectBSS struct {
	interfaceBss // interface fi.w1.wpa_supplicant1.BSS
	proxy.ImplObject
}

func NewBSS(conn *dbus.Conn, path dbus.ObjectPath) (BSS, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectBSS)
	obj.ImplObject.Init_(conn, "fi.w1.wpa_supplicant1", path)
	return obj, nil
}

type bss interface {
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	SSID() proxy.PropByteArray
	BSSID() proxy.PropByteArray
	Privacy() proxy.PropBool
	Mode() proxy.PropString
	Signal() proxy.PropInt16
	Frequency() proxy.PropUint16
	Rates() proxy.PropUint32Array
	WPA() MapStrVariant
	RSN() MapStrVariant
	WPS() MapStrVariant
	IEs() proxy.PropByteArray
	Age() proxy.PropUint32
}

type interfaceBss struct{}

func (v *interfaceBss) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceBss) GetInterfaceName_() string {
	return "fi.w1.wpa_supplicant1.BSS"
}

// signal PropertiesChanged

func (v *interfaceBss) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property SSID ay

func (v *interfaceBss) SSID() proxy.PropByteArray {
	return &proxy.ImplPropByteArray{
		Impl: v,
		Name: "SSID",
	}
}

// property BSSID ay

func (v *interfaceBss) BSSID() proxy.PropByteArray {
	return &proxy.ImplPropByteArray{
		Impl: v,
		Name: "BSSID",
	}
}

// property Privacy b

func (v *interfaceBss) Privacy() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Privacy",
	}
}

// property Mode s

func (v *interfaceBss) Mode() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Mode",
	}
}

// property Signal n

func (v *interfaceBss) Signal() proxy.PropInt16 {
	return &proxy.ImplPropInt16{
		Impl: v,
		Name: "Signal",
	}
}

// property Frequency q

func (v *interfaceBss) Frequency() proxy.PropUint16 {
	return &proxy.ImplPropUint16{
		Impl: v,
		Name: "Frequency",
	}
}

// property Rates au

func (v *interfaceBss) Rates() proxy.PropUint32Array {
	return &proxy.ImplPropUint32Array{
		Impl: v,
		Name: "Rates",
	}
}

// property WPA a{sv}

func (v *interfaceBss) WPA() MapStrVariant {
	return &implMapStrVariant{
		Impl: v,
		Name: "WPA",
	}
}

// property RSN a{sv}

func (v *interfaceBss) RSN() MapStrVariant {
	return &implMapStrVariant{
		Impl: v,
		Name: "RSN",
	}
}

// property WPS a{sv}

func (v *interfaceBss) WPS() MapStrVariant {
	return &implMapStrVariant{
		Impl: v,
		Name: "WPS",
	}
}

// property IEs ay

func (v *interfaceBss) IEs() proxy.PropByteArray {
	return &proxy.ImplPropByteArray{
		Impl: v,
		Name: "IEs",
	}
}

// property Age u

func (v *interfaceBss) Age() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "Age",
	}
}

type MapStrVariant interface {
	Get(flags dbus.Flags) (value map[string]dbus.Variant, err error)
	Set(flags dbus.Flags, value map[string]dbus.Variant) error
	ConnectChanged(cb func(hasValue bool, value map[string]dbus.Variant)) error
}

type implMapStrVariant struct {
	Impl proxy.Implementer
	Name string
}

func (p implMapStrVariant) Get(flags dbus.Flags) (value map[string]dbus.Variant, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implMapStrVariant) Set(flags dbus.Flags, value map[string]dbus.Variant) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implMapStrVariant) ConnectChanged(cb func(hasValue bool, value map[string]dbus.Variant)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v map[string]dbus.Variant
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, nil)
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}
