// Code generated by "./generator ./org.bluez"; DO NOT EDIT.

package bluez

import (
	"fmt"

	"github.com/godbus/dbus"
	"github.com/linuxdeepin/go-dbus-factory/object_manager"
	"github.com/stretchr/testify/mock"
	"pkg.deepin.io/lib/dbusutil/proxy"
)

type MockObjectManager struct {
	object_manager.MockInterfaceObjectManager // interface org.freedesktop.DBus.ObjectManager
}

type MockManager struct {
	mockInterfaceAgentManager   // interface org.bluez.AgentManager1
	mockInterfaceHealthManager  // interface org.bluez.HealthManager1
	mockInterfaceProfileManager // interface org.bluez.ProfileManager1
}

type mockInterfaceAgentManager struct {
	mock.Mock
}

// method RegisterAgent

func (v *mockInterfaceAgentManager) GoRegisterAgent(flags dbus.Flags, ch chan *dbus.Call, agent dbus.ObjectPath, capability string) *dbus.Call {
	mockArgs := v.Called(flags, ch, agent, capability)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *mockInterfaceAgentManager) RegisterAgent(flags dbus.Flags, agent dbus.ObjectPath, capability string) error {
	mockArgs := v.Called(flags, agent, capability)

	return mockArgs.Error(0)
}

// method UnregisterAgent

func (v *mockInterfaceAgentManager) GoUnregisterAgent(flags dbus.Flags, ch chan *dbus.Call, agent dbus.ObjectPath) *dbus.Call {
	mockArgs := v.Called(flags, ch, agent)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *mockInterfaceAgentManager) UnregisterAgent(flags dbus.Flags, agent dbus.ObjectPath) error {
	mockArgs := v.Called(flags, agent)

	return mockArgs.Error(0)
}

// method RequestDefaultAgent

func (v *mockInterfaceAgentManager) GoRequestDefaultAgent(flags dbus.Flags, ch chan *dbus.Call, agent dbus.ObjectPath) *dbus.Call {
	mockArgs := v.Called(flags, ch, agent)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *mockInterfaceAgentManager) RequestDefaultAgent(flags dbus.Flags, agent dbus.ObjectPath) error {
	mockArgs := v.Called(flags, agent)

	return mockArgs.Error(0)
}

type mockInterfaceHealthManager struct {
	mock.Mock
}

// method CreateApplication

func (v *mockInterfaceHealthManager) GoCreateApplication(flags dbus.Flags, ch chan *dbus.Call, config map[string]dbus.Variant) *dbus.Call {
	mockArgs := v.Called(flags, ch, config)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *mockInterfaceHealthManager) CreateApplication(flags dbus.Flags, config map[string]dbus.Variant) (dbus.ObjectPath, error) {
	mockArgs := v.Called(flags, config)

	ret0, ok := mockArgs.Get(0).(dbus.ObjectPath)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// method DestroyApplication

func (v *mockInterfaceHealthManager) GoDestroyApplication(flags dbus.Flags, ch chan *dbus.Call, application dbus.ObjectPath) *dbus.Call {
	mockArgs := v.Called(flags, ch, application)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *mockInterfaceHealthManager) DestroyApplication(flags dbus.Flags, application dbus.ObjectPath) error {
	mockArgs := v.Called(flags, application)

	return mockArgs.Error(0)
}

type mockInterfaceProfileManager struct {
	mock.Mock
}

// method RegisterProfile

func (v *mockInterfaceProfileManager) GoRegisterProfile(flags dbus.Flags, ch chan *dbus.Call, profile dbus.ObjectPath, UUID string, options map[string]dbus.Variant) *dbus.Call {
	mockArgs := v.Called(flags, ch, profile, UUID, options)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *mockInterfaceProfileManager) RegisterProfile(flags dbus.Flags, profile dbus.ObjectPath, UUID string, options map[string]dbus.Variant) error {
	mockArgs := v.Called(flags, profile, UUID, options)

	return mockArgs.Error(0)
}

// method UnregisterProfile

func (v *mockInterfaceProfileManager) GoUnregisterProfile(flags dbus.Flags, ch chan *dbus.Call, profile dbus.ObjectPath) *dbus.Call {
	mockArgs := v.Called(flags, ch, profile)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *mockInterfaceProfileManager) UnregisterProfile(flags dbus.Flags, profile dbus.ObjectPath) error {
	mockArgs := v.Called(flags, profile)

	return mockArgs.Error(0)
}

type MockHCI struct {
	mockInterfaceAdapter       // interface org.bluez.Adapter1
	mockInterfaceGattManager   // interface org.bluez.GattManager1
	mockInterfaceMedia         // interface org.bluez.Media1
	mockInterfaceNetworkServer // interface org.bluez.NetworkServer1
}

type mockInterfaceAdapter struct {
	mock.Mock
}

// method StartDiscovery

func (v *mockInterfaceAdapter) GoStartDiscovery(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *mockInterfaceAdapter) StartDiscovery(flags dbus.Flags) error {
	mockArgs := v.Called(flags)

	return mockArgs.Error(0)
}

// method SetDiscoveryFilter

func (v *mockInterfaceAdapter) GoSetDiscoveryFilter(flags dbus.Flags, ch chan *dbus.Call, properties map[string]dbus.Variant) *dbus.Call {
	mockArgs := v.Called(flags, ch, properties)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *mockInterfaceAdapter) SetDiscoveryFilter(flags dbus.Flags, properties map[string]dbus.Variant) error {
	mockArgs := v.Called(flags, properties)

	return mockArgs.Error(0)
}

// method StopDiscovery

func (v *mockInterfaceAdapter) GoStopDiscovery(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *mockInterfaceAdapter) StopDiscovery(flags dbus.Flags) error {
	mockArgs := v.Called(flags)

	return mockArgs.Error(0)
}

// method RemoveDevice

func (v *mockInterfaceAdapter) GoRemoveDevice(flags dbus.Flags, ch chan *dbus.Call, device dbus.ObjectPath) *dbus.Call {
	mockArgs := v.Called(flags, ch, device)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *mockInterfaceAdapter) RemoveDevice(flags dbus.Flags, device dbus.ObjectPath) error {
	mockArgs := v.Called(flags, device)

	return mockArgs.Error(0)
}

// property Address s

func (v *mockInterfaceAdapter) Address() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Name s

func (v *mockInterfaceAdapter) Name() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Alias s

func (v *mockInterfaceAdapter) Alias() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Class u

func (v *mockInterfaceAdapter) Class() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Powered b

func (v *mockInterfaceAdapter) Powered() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Discoverable b

func (v *mockInterfaceAdapter) Discoverable() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property DiscoverableTimeout u

func (v *mockInterfaceAdapter) DiscoverableTimeout() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Pairable b

func (v *mockInterfaceAdapter) Pairable() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property PairableTimeout u

func (v *mockInterfaceAdapter) PairableTimeout() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Discovering b

func (v *mockInterfaceAdapter) Discovering() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property UUIDs as

func (v *mockInterfaceAdapter) UUIDs() proxy.PropStringArray {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropStringArray)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Modalias s

func (v *mockInterfaceAdapter) Modalias() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

type mockInterfaceGattManager struct {
	mock.Mock
}

// method RegisterApplication

func (v *mockInterfaceGattManager) GoRegisterApplication(flags dbus.Flags, ch chan *dbus.Call, application dbus.ObjectPath, options map[string]dbus.Variant) *dbus.Call {
	mockArgs := v.Called(flags, ch, application, options)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *mockInterfaceGattManager) RegisterApplication(flags dbus.Flags, application dbus.ObjectPath, options map[string]dbus.Variant) error {
	mockArgs := v.Called(flags, application, options)

	return mockArgs.Error(0)
}

// method UnregisterApplication

func (v *mockInterfaceGattManager) GoUnregisterApplication(flags dbus.Flags, ch chan *dbus.Call, application dbus.ObjectPath) *dbus.Call {
	mockArgs := v.Called(flags, ch, application)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *mockInterfaceGattManager) UnregisterApplication(flags dbus.Flags, application dbus.ObjectPath) error {
	mockArgs := v.Called(flags, application)

	return mockArgs.Error(0)
}

type mockInterfaceMedia struct {
	mock.Mock
}

// method RegisterEndpoint

func (v *mockInterfaceMedia) GoRegisterEndpoint(flags dbus.Flags, ch chan *dbus.Call, endpoint dbus.ObjectPath, properties map[string]dbus.Variant) *dbus.Call {
	mockArgs := v.Called(flags, ch, endpoint, properties)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *mockInterfaceMedia) RegisterEndpoint(flags dbus.Flags, endpoint dbus.ObjectPath, properties map[string]dbus.Variant) error {
	mockArgs := v.Called(flags, endpoint, properties)

	return mockArgs.Error(0)
}

// method UnregisterEndpoint

func (v *mockInterfaceMedia) GoUnregisterEndpoint(flags dbus.Flags, ch chan *dbus.Call, endpoint dbus.ObjectPath) *dbus.Call {
	mockArgs := v.Called(flags, ch, endpoint)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *mockInterfaceMedia) UnregisterEndpoint(flags dbus.Flags, endpoint dbus.ObjectPath) error {
	mockArgs := v.Called(flags, endpoint)

	return mockArgs.Error(0)
}

// method RegisterPlayer

func (v *mockInterfaceMedia) GoRegisterPlayer(flags dbus.Flags, ch chan *dbus.Call, player dbus.ObjectPath, properties map[string]dbus.Variant) *dbus.Call {
	mockArgs := v.Called(flags, ch, player, properties)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *mockInterfaceMedia) RegisterPlayer(flags dbus.Flags, player dbus.ObjectPath, properties map[string]dbus.Variant) error {
	mockArgs := v.Called(flags, player, properties)

	return mockArgs.Error(0)
}

// method UnregisterPlayer

func (v *mockInterfaceMedia) GoUnregisterPlayer(flags dbus.Flags, ch chan *dbus.Call, player dbus.ObjectPath) *dbus.Call {
	mockArgs := v.Called(flags, ch, player)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *mockInterfaceMedia) UnregisterPlayer(flags dbus.Flags, player dbus.ObjectPath) error {
	mockArgs := v.Called(flags, player)

	return mockArgs.Error(0)
}

type mockInterfaceNetworkServer struct {
	mock.Mock
}

// method Register

func (v *mockInterfaceNetworkServer) GoRegister(flags dbus.Flags, ch chan *dbus.Call, uuid string, bridge string) *dbus.Call {
	mockArgs := v.Called(flags, ch, uuid, bridge)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *mockInterfaceNetworkServer) Register(flags dbus.Flags, uuid string, bridge string) error {
	mockArgs := v.Called(flags, uuid, bridge)

	return mockArgs.Error(0)
}

// method Unregister

func (v *mockInterfaceNetworkServer) GoUnregister(flags dbus.Flags, ch chan *dbus.Call, uuid string) *dbus.Call {
	mockArgs := v.Called(flags, ch, uuid)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *mockInterfaceNetworkServer) Unregister(flags dbus.Flags, uuid string) error {
	mockArgs := v.Called(flags, uuid)

	return mockArgs.Error(0)
}

type MockDevice struct {
	mockInterfaceDevice // interface org.bluez.Device1
}

type mockInterfaceDevice struct {
	mock.Mock
}

// method Disconnect

func (v *mockInterfaceDevice) GoDisconnect(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *mockInterfaceDevice) Disconnect(flags dbus.Flags) error {
	mockArgs := v.Called(flags)

	return mockArgs.Error(0)
}

// method Connect

func (v *mockInterfaceDevice) GoConnect(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *mockInterfaceDevice) Connect(flags dbus.Flags) error {
	mockArgs := v.Called(flags)

	return mockArgs.Error(0)
}

// method ConnectProfile

func (v *mockInterfaceDevice) GoConnectProfile(flags dbus.Flags, ch chan *dbus.Call, UUID string) *dbus.Call {
	mockArgs := v.Called(flags, ch, UUID)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *mockInterfaceDevice) ConnectProfile(flags dbus.Flags, UUID string) error {
	mockArgs := v.Called(flags, UUID)

	return mockArgs.Error(0)
}

// method DisconnectProfile

func (v *mockInterfaceDevice) GoDisconnectProfile(flags dbus.Flags, ch chan *dbus.Call, UUID string) *dbus.Call {
	mockArgs := v.Called(flags, ch, UUID)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *mockInterfaceDevice) DisconnectProfile(flags dbus.Flags, UUID string) error {
	mockArgs := v.Called(flags, UUID)

	return mockArgs.Error(0)
}

// method Pair

func (v *mockInterfaceDevice) GoPair(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *mockInterfaceDevice) Pair(flags dbus.Flags) error {
	mockArgs := v.Called(flags)

	return mockArgs.Error(0)
}

// method CancelPairing

func (v *mockInterfaceDevice) GoCancelPairing(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *mockInterfaceDevice) CancelPairing(flags dbus.Flags) error {
	mockArgs := v.Called(flags)

	return mockArgs.Error(0)
}

// property Address s

func (v *mockInterfaceDevice) Address() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property AddressType s

func (v *mockInterfaceDevice) AddressType() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Name s

func (v *mockInterfaceDevice) Name() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Alias s

func (v *mockInterfaceDevice) Alias() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Class u

func (v *mockInterfaceDevice) Class() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Appearance q

func (v *mockInterfaceDevice) Appearance() proxy.PropUint16 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint16)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Icon s

func (v *mockInterfaceDevice) Icon() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Paired b

func (v *mockInterfaceDevice) Paired() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Trusted b

func (v *mockInterfaceDevice) Trusted() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Blocked b

func (v *mockInterfaceDevice) Blocked() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property LegacyPairing b

func (v *mockInterfaceDevice) LegacyPairing() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property RSSI n

func (v *mockInterfaceDevice) RSSI() proxy.PropInt16 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropInt16)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Connected b

func (v *mockInterfaceDevice) Connected() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property UUIDs as

func (v *mockInterfaceDevice) UUIDs() proxy.PropStringArray {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropStringArray)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Modalias s

func (v *mockInterfaceDevice) Modalias() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Adapter o

func (v *mockInterfaceDevice) Adapter() proxy.PropObjectPath {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropObjectPath)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

type MockPropDeviceManufacturerData struct {
	mock.Mock
}

func (p MockPropDeviceManufacturerData) Get(flags dbus.Flags) (value map[uint16]dbus.Variant, err error) {
	args := p.Called(flags)

	var ok bool
	value, ok = args.Get(0).(map[uint16]dbus.Variant)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, args.Get(0)))
	}

	err = args.Error(1)

	return
}

func (p MockPropDeviceManufacturerData) Set(flags dbus.Flags, value map[uint16]dbus.Variant) error {
	args := p.Called(flags, value)

	return args.Error(0)
}

func (p MockPropDeviceManufacturerData) ConnectChanged(cb func(hasValue bool, value map[uint16]dbus.Variant)) error {
	args := p.Called(cb)

	return args.Error(0)
}

// property ManufacturerData a{qv}

func (v *mockInterfaceDevice) ManufacturerData() PropDeviceManufacturerData {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*MockPropDeviceManufacturerData)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

type MockPropDeviceServiceData struct {
	mock.Mock
}

func (p MockPropDeviceServiceData) Get(flags dbus.Flags) (value map[string]dbus.Variant, err error) {
	args := p.Called(flags)

	var ok bool
	value, ok = args.Get(0).(map[string]dbus.Variant)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, args.Get(0)))
	}

	err = args.Error(1)

	return
}

func (p MockPropDeviceServiceData) Set(flags dbus.Flags, value map[string]dbus.Variant) error {
	args := p.Called(flags, value)

	return args.Error(0)
}

func (p MockPropDeviceServiceData) ConnectChanged(cb func(hasValue bool, value map[string]dbus.Variant)) error {
	args := p.Called(cb)

	return args.Error(0)
}

// property ServiceData a{sv}

func (v *mockInterfaceDevice) ServiceData() PropDeviceServiceData {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*MockPropDeviceServiceData)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property TxPower n

func (v *mockInterfaceDevice) TxPower() proxy.PropInt16 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropInt16)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property ServicesResolved b

func (v *mockInterfaceDevice) ServicesResolved() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}
