// Code generated by "./generator ./org.freedesktop.systemd1"; DO NOT EDIT.

package systemd1

import (
	"errors"
	"fmt"
	"unsafe"

	"github.com/godbus/dbus"
	"pkg.deepin.io/lib/dbusutil"
	"pkg.deepin.io/lib/dbusutil/proxy"
)

type Manager interface {
	manager // interface org.freedesktop.systemd1.Manager
	proxy.Object
}

type objectManager struct {
	interfaceManager // interface org.freedesktop.systemd1.Manager
	proxy.ImplObject
}

func NewManager(conn *dbus.Conn) Manager {
	obj := new(objectManager)
	obj.ImplObject.Init_(conn, "org.freedesktop.systemd1", "/org/freedesktop/systemd1")
	return obj
}

type manager interface {
	GoGetUnit(flags dbus.Flags, ch chan *dbus.Call, name string) *dbus.Call
	GetUnit(flags dbus.Flags, name string) (dbus.ObjectPath, error)
	GoGetUnitByPID(flags dbus.Flags, ch chan *dbus.Call, pid uint32) *dbus.Call
	GetUnitByPID(flags dbus.Flags, pid uint32) (dbus.ObjectPath, error)
	GoGetUnitByInvocationID(flags dbus.Flags, ch chan *dbus.Call, invocationID []uint8) *dbus.Call
	GetUnitByInvocationID(flags dbus.Flags, invocationID []uint8) (dbus.ObjectPath, error)
	GoGetUnitByControlGroup(flags dbus.Flags, ch chan *dbus.Call, ctrlGroup string) *dbus.Call
	GetUnitByControlGroup(flags dbus.Flags, ctrlGroup string) (dbus.ObjectPath, error)
	GoLoadUnit(flags dbus.Flags, ch chan *dbus.Call, name string) *dbus.Call
	LoadUnit(flags dbus.Flags, name string) (dbus.ObjectPath, error)
	GoStartUnit(flags dbus.Flags, ch chan *dbus.Call, name string, mode string) *dbus.Call
	StartUnit(flags dbus.Flags, name string, mode string) (dbus.ObjectPath, error)
	GoStartUnitReplace(flags dbus.Flags, ch chan *dbus.Call, oldUnit string, newUnit string, mode string) *dbus.Call
	StartUnitReplace(flags dbus.Flags, oldUnit string, newUnit string, mode string) (dbus.ObjectPath, error)
	GoStopUnit(flags dbus.Flags, ch chan *dbus.Call, name string, mode string) *dbus.Call
	StopUnit(flags dbus.Flags, name string, mode string) (dbus.ObjectPath, error)
	GoReloadUnit(flags dbus.Flags, ch chan *dbus.Call, name string, mode string) *dbus.Call
	ReloadUnit(flags dbus.Flags, name string, mode string) (dbus.ObjectPath, error)
	GoRestartUnit(flags dbus.Flags, ch chan *dbus.Call, name string, mode string) *dbus.Call
	RestartUnit(flags dbus.Flags, name string, mode string) (dbus.ObjectPath, error)
	GoTryRestartUnit(flags dbus.Flags, ch chan *dbus.Call, name string, mode string) *dbus.Call
	TryRestartUnit(flags dbus.Flags, name string, mode string) (dbus.ObjectPath, error)
	GoReloadOrRestartUnit(flags dbus.Flags, ch chan *dbus.Call, name string, mode string) *dbus.Call
	ReloadOrRestartUnit(flags dbus.Flags, name string, mode string) (dbus.ObjectPath, error)
	GoReloadOrTryRestartUnit(flags dbus.Flags, ch chan *dbus.Call, name string, mode string) *dbus.Call
	ReloadOrTryRestartUnit(flags dbus.Flags, name string, mode string) (dbus.ObjectPath, error)
	GoKillUnit(flags dbus.Flags, ch chan *dbus.Call, name string, who string, signal int32) *dbus.Call
	KillUnit(flags dbus.Flags, name string, who string, signal int32) error
	GoResetFailedUnit(flags dbus.Flags, ch chan *dbus.Call, name string) *dbus.Call
	ResetFailedUnit(flags dbus.Flags, name string) error
	GoSetUnitProperties(flags dbus.Flags, ch chan *dbus.Call, name string, runtime bool, properties []Property) *dbus.Call
	SetUnitProperties(flags dbus.Flags, name string, runtime bool, properties []Property) error
	GoRefUnit(flags dbus.Flags, ch chan *dbus.Call, name string) *dbus.Call
	RefUnit(flags dbus.Flags, name string) error
	GoUnrefUnit(flags dbus.Flags, ch chan *dbus.Call, name string) *dbus.Call
	UnrefUnit(flags dbus.Flags, name string) error
	GoStartTransientUnit(flags dbus.Flags, ch chan *dbus.Call, name string, mode string, properties []Property, aux []PropertyCollection) *dbus.Call
	StartTransientUnit(flags dbus.Flags, name string, mode string, properties []Property, aux []PropertyCollection) (dbus.ObjectPath, error)
	GoGetUnitProcesses(flags dbus.Flags, ch chan *dbus.Call, name string) *dbus.Call
	GetUnitProcesses(flags dbus.Flags, name string) ([]UnitProcess, error)
	GoAttachProcessesToUnit(flags dbus.Flags, ch chan *dbus.Call, name string, path string, pids []uint32) *dbus.Call
	AttachProcessesToUnit(flags dbus.Flags, name string, path string, pids []uint32) error
	GoAbandonScope(flags dbus.Flags, ch chan *dbus.Call, name string) *dbus.Call
	AbandonScope(flags dbus.Flags, name string) error
	GoGetJob(flags dbus.Flags, ch chan *dbus.Call, id uint32) *dbus.Call
	GetJob(flags dbus.Flags, id uint32) (dbus.ObjectPath, error)
	GoGetJobAfter(flags dbus.Flags, ch chan *dbus.Call, id uint32) *dbus.Call
	GetJobAfter(flags dbus.Flags, id uint32) ([]JobInfo, error)
	GoGetJobBefore(flags dbus.Flags, ch chan *dbus.Call, id uint32) *dbus.Call
	GetJobBefore(flags dbus.Flags, id uint32) ([]JobInfo, error)
	GoCancelJob(flags dbus.Flags, ch chan *dbus.Call, id uint32) *dbus.Call
	CancelJob(flags dbus.Flags, id uint32) error
	GoClearJobs(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	ClearJobs(flags dbus.Flags) error
	GoResetFailed(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	ResetFailed(flags dbus.Flags) error
	GoListUnits(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	ListUnits(flags dbus.Flags) ([]UnitInfo, error)
	GoListUnitsFiltered(flags dbus.Flags, ch chan *dbus.Call, states []string) *dbus.Call
	ListUnitsFiltered(flags dbus.Flags, states []string) ([]UnitInfo, error)
	GoListUnitsByPatterns(flags dbus.Flags, ch chan *dbus.Call, states []string, patterns []string) *dbus.Call
	ListUnitsByPatterns(flags dbus.Flags, states []string, patterns []string) ([]UnitInfo, error)
	GoListUnitsByNames(flags dbus.Flags, ch chan *dbus.Call, names []string) *dbus.Call
	ListUnitsByNames(flags dbus.Flags, names []string) ([]UnitInfo, error)
	GoListJobs(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	ListJobs(flags dbus.Flags) ([]JobInfo, error)
	GoSubscribe(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Subscribe(flags dbus.Flags) error
	GoUnsubscribe(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Unsubscribe(flags dbus.Flags) error
	GoDump(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Dump(flags dbus.Flags) (string, error)
	GoDumpByFileDescriptor(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	DumpByFileDescriptor(flags dbus.Flags) (dbus.UnixFD, error)
	GoReload(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Reload(flags dbus.Flags) error
	GoReexecute(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Reexecute(flags dbus.Flags) error
	GoExit(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Exit(flags dbus.Flags) error
	GoReboot(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Reboot(flags dbus.Flags) error
	GoPowerOff(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	PowerOff(flags dbus.Flags) error
	GoHalt(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Halt(flags dbus.Flags) error
	GoKExec(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	KExec(flags dbus.Flags) error
	GoSwitchRoot(flags dbus.Flags, ch chan *dbus.Call, newRoot string, init string) *dbus.Call
	SwitchRoot(flags dbus.Flags, newRoot string, init string) error
	GoSetEnvironment(flags dbus.Flags, ch chan *dbus.Call, names []string) *dbus.Call
	SetEnvironment(flags dbus.Flags, names []string) error
	GoUnsetEnvironment(flags dbus.Flags, ch chan *dbus.Call, names []string) *dbus.Call
	UnsetEnvironment(flags dbus.Flags, names []string) error
	GoUnsetAndSetEnvironment(flags dbus.Flags, ch chan *dbus.Call, unset []string, set []string) *dbus.Call
	UnsetAndSetEnvironment(flags dbus.Flags, unset []string, set []string) error
	GoListUnitFiles(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	ListUnitFiles(flags dbus.Flags) ([]UnitFile, error)
	GoListUnitFilesByPatterns(flags dbus.Flags, ch chan *dbus.Call, states []string, patterns []string) *dbus.Call
	ListUnitFilesByPatterns(flags dbus.Flags, states []string, patterns []string) ([]UnitFile, error)
	GoGetUnitFileState(flags dbus.Flags, ch chan *dbus.Call, unit string) *dbus.Call
	GetUnitFileState(flags dbus.Flags, unit string) (string, error)
	GoEnableUnitFiles(flags dbus.Flags, ch chan *dbus.Call, files []string, runtime bool, force bool) *dbus.Call
	EnableUnitFiles(flags dbus.Flags, files []string, runtime bool, force bool) (bool, []UnitFileChange, error)
	GoDisableUnitFiles(flags dbus.Flags, ch chan *dbus.Call, files []string, runtime bool) *dbus.Call
	DisableUnitFiles(flags dbus.Flags, files []string, runtime bool) ([]UnitFileChange, error)
	GoReenableUnitFiles(flags dbus.Flags, ch chan *dbus.Call, files []string, runtime bool, force bool) *dbus.Call
	ReenableUnitFiles(flags dbus.Flags, files []string, runtime bool, force bool) (bool, []UnitFileChange, error)
	GoLinkUnitFiles(flags dbus.Flags, ch chan *dbus.Call, files []string, runtime bool, force bool) *dbus.Call
	LinkUnitFiles(flags dbus.Flags, files []string, runtime bool, force bool) ([]UnitFileChange, error)
	GoPresetUnitFiles(flags dbus.Flags, ch chan *dbus.Call, files []string, runtime bool, force bool) *dbus.Call
	PresetUnitFiles(flags dbus.Flags, files []string, runtime bool, force bool) (bool, []UnitFileChange, error)
	GoPresetUnitFilesWithMode(flags dbus.Flags, ch chan *dbus.Call, files []string, mode string, runtime bool, force bool) *dbus.Call
	PresetUnitFilesWithMode(flags dbus.Flags, files []string, mode string, runtime bool, force bool) (bool, []UnitFileChange, error)
	GoMaskUnitFiles(flags dbus.Flags, ch chan *dbus.Call, files []string, runtime bool, force bool) *dbus.Call
	MaskUnitFiles(flags dbus.Flags, files []string, runtime bool, force bool) ([]UnitFileChange, error)
	GoUnmaskUnitFiles(flags dbus.Flags, ch chan *dbus.Call, files []string, runtime bool) *dbus.Call
	UnmaskUnitFiles(flags dbus.Flags, files []string, runtime bool) ([]UnitFileChange, error)
	GoRevertUnitFiles(flags dbus.Flags, ch chan *dbus.Call, files []string) *dbus.Call
	RevertUnitFiles(flags dbus.Flags, files []string) ([]UnitFileChange, error)
	GoSetDefaultTarget(flags dbus.Flags, ch chan *dbus.Call, name string, force bool) *dbus.Call
	SetDefaultTarget(flags dbus.Flags, name string, force bool) ([]UnitFileChange, error)
	GoGetDefaultTarget(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	GetDefaultTarget(flags dbus.Flags) (string, error)
	GoPresetAllUnitFiles(flags dbus.Flags, ch chan *dbus.Call, mode string, runtime bool, force bool) *dbus.Call
	PresetAllUnitFiles(flags dbus.Flags, mode string, runtime bool, force bool) ([]UnitFileChange, error)
	GoAddDependencyUnitFiles(flags dbus.Flags, ch chan *dbus.Call, files []string, target string, type0 string, runtime bool, force bool) *dbus.Call
	AddDependencyUnitFiles(flags dbus.Flags, files []string, target string, type0 string, runtime bool, force bool) ([]UnitFileChange, error)
	GoGetUnitFileLinks(flags dbus.Flags, ch chan *dbus.Call, name string, runtime bool) *dbus.Call
	GetUnitFileLinks(flags dbus.Flags, name string, runtime bool) ([]string, error)
	GoSetExitCode(flags dbus.Flags, ch chan *dbus.Call, exitCode uint8) *dbus.Call
	SetExitCode(flags dbus.Flags, exitCode uint8) error
	GoLookupDynamicUserByName(flags dbus.Flags, ch chan *dbus.Call, name string) *dbus.Call
	LookupDynamicUserByName(flags dbus.Flags, name string) (uint32, error)
	GoLookupDynamicUserByUID(flags dbus.Flags, ch chan *dbus.Call, uid uint32) *dbus.Call
	LookupDynamicUserByUID(flags dbus.Flags, uid uint32) (string, error)
	GoGetDynamicUsers(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	GetDynamicUsers(flags dbus.Flags) ([]DynamicUser, error)
	ConnectUnitNew(cb func(id string, unit dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	ConnectUnitRemoved(cb func(id string, unit dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	ConnectJobNew(cb func(id uint32, job dbus.ObjectPath, unit string)) (dbusutil.SignalHandlerId, error)
	ConnectJobRemoved(cb func(id uint32, job dbus.ObjectPath, unit string, result string)) (dbusutil.SignalHandlerId, error)
	ConnectStartupFinished(cb func(firmware uint64, loader uint64, kernel uint64, initrd uint64, userspace uint64, total uint64)) (dbusutil.SignalHandlerId, error)
	ConnectUnitFilesChanged(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectReloading(cb func(active bool)) (dbusutil.SignalHandlerId, error)
	Version() proxy.PropString
	Features() proxy.PropString
	Virtualization() proxy.PropString
	Architecture() proxy.PropString
	Tainted() proxy.PropString
	FirmwareTimestamp() proxy.PropUint64
	FirmwareTimestampMonotonic() proxy.PropUint64
	LoaderTimestamp() proxy.PropUint64
	LoaderTimestampMonotonic() proxy.PropUint64
	KernelTimestamp() proxy.PropUint64
	KernelTimestampMonotonic() proxy.PropUint64
	InitRDTimestamp() proxy.PropUint64
	InitRDTimestampMonotonic() proxy.PropUint64
	UserspaceTimestamp() proxy.PropUint64
	UserspaceTimestampMonotonic() proxy.PropUint64
	FinishTimestamp() proxy.PropUint64
	FinishTimestampMonotonic() proxy.PropUint64
	SecurityStartTimestamp() proxy.PropUint64
	SecurityStartTimestampMonotonic() proxy.PropUint64
	SecurityFinishTimestamp() proxy.PropUint64
	SecurityFinishTimestampMonotonic() proxy.PropUint64
	GeneratorsStartTimestamp() proxy.PropUint64
	GeneratorsStartTimestampMonotonic() proxy.PropUint64
	GeneratorsFinishTimestamp() proxy.PropUint64
	GeneratorsFinishTimestampMonotonic() proxy.PropUint64
	UnitsLoadStartTimestamp() proxy.PropUint64
	UnitsLoadStartTimestampMonotonic() proxy.PropUint64
	UnitsLoadFinishTimestamp() proxy.PropUint64
	UnitsLoadFinishTimestampMonotonic() proxy.PropUint64
	InitRDSecurityStartTimestamp() proxy.PropUint64
	InitRDSecurityStartTimestampMonotonic() proxy.PropUint64
	InitRDSecurityFinishTimestamp() proxy.PropUint64
	InitRDSecurityFinishTimestampMonotonic() proxy.PropUint64
	InitRDGeneratorsStartTimestamp() proxy.PropUint64
	InitRDGeneratorsStartTimestampMonotonic() proxy.PropUint64
	InitRDGeneratorsFinishTimestamp() proxy.PropUint64
	InitRDGeneratorsFinishTimestampMonotonic() proxy.PropUint64
	InitRDUnitsLoadStartTimestamp() proxy.PropUint64
	InitRDUnitsLoadStartTimestampMonotonic() proxy.PropUint64
	InitRDUnitsLoadFinishTimestamp() proxy.PropUint64
	InitRDUnitsLoadFinishTimestampMonotonic() proxy.PropUint64
	LogLevel() proxy.PropString
	LogTarget() proxy.PropString
	NNames() proxy.PropUint32
	NFailedUnits() proxy.PropUint32
	NJobs() proxy.PropUint32
	NInstalledJobs() proxy.PropUint32
	NFailedJobs() proxy.PropUint32
	Progress() proxy.PropDouble
	Environment() proxy.PropStringArray
	ConfirmSpawn() proxy.PropBool
	ShowStatus() proxy.PropBool
	UnitPath() proxy.PropStringArray
	DefaultStandardOutput() proxy.PropString
	DefaultStandardError() proxy.PropString
	RuntimeWatchdogUSec() proxy.PropUint64
	ShutdownWatchdogUSec() proxy.PropUint64
	ServiceWatchdogs() proxy.PropBool
	ControlGroup() proxy.PropString
	SystemState() proxy.PropString
	ExitCode() proxy.PropByte
	DefaultTimerAccuracyUSec() proxy.PropUint64
	DefaultTimeoutStartUSec() proxy.PropUint64
	DefaultTimeoutStopUSec() proxy.PropUint64
	DefaultRestartUSec() proxy.PropUint64
	DefaultStartLimitIntervalUSec() proxy.PropUint64
	DefaultStartLimitBurst() proxy.PropUint32
	DefaultCPUAccounting() proxy.PropBool
	DefaultBlockIOAccounting() proxy.PropBool
	DefaultMemoryAccounting() proxy.PropBool
	DefaultTasksAccounting() proxy.PropBool
	DefaultLimitCPU() proxy.PropUint64
	DefaultLimitCPUSoft() proxy.PropUint64
	DefaultLimitFSIZE() proxy.PropUint64
	DefaultLimitFSIZESoft() proxy.PropUint64
	DefaultLimitDATA() proxy.PropUint64
	DefaultLimitDATASoft() proxy.PropUint64
	DefaultLimitSTACK() proxy.PropUint64
	DefaultLimitSTACKSoft() proxy.PropUint64
	DefaultLimitCORE() proxy.PropUint64
	DefaultLimitCORESoft() proxy.PropUint64
	DefaultLimitRSS() proxy.PropUint64
	DefaultLimitRSSSoft() proxy.PropUint64
	DefaultLimitNOFILE() proxy.PropUint64
	DefaultLimitNOFILESoft() proxy.PropUint64
	DefaultLimitAS() proxy.PropUint64
	DefaultLimitASSoft() proxy.PropUint64
	DefaultLimitNPROC() proxy.PropUint64
	DefaultLimitNPROCSoft() proxy.PropUint64
	DefaultLimitMEMLOCK() proxy.PropUint64
	DefaultLimitMEMLOCKSoft() proxy.PropUint64
	DefaultLimitLOCKS() proxy.PropUint64
	DefaultLimitLOCKSSoft() proxy.PropUint64
	DefaultLimitSIGPENDING() proxy.PropUint64
	DefaultLimitSIGPENDINGSoft() proxy.PropUint64
	DefaultLimitMSGQUEUE() proxy.PropUint64
	DefaultLimitMSGQUEUESoft() proxy.PropUint64
	DefaultLimitNICE() proxy.PropUint64
	DefaultLimitNICESoft() proxy.PropUint64
	DefaultLimitRTPRIO() proxy.PropUint64
	DefaultLimitRTPRIOSoft() proxy.PropUint64
	DefaultLimitRTTIME() proxy.PropUint64
	DefaultLimitRTTIMESoft() proxy.PropUint64
	DefaultTasksMax() proxy.PropUint64
	TimerSlackNSec() proxy.PropUint64
}

type interfaceManager struct{}

func (v *interfaceManager) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceManager) GetInterfaceName_() string {
	return "org.freedesktop.systemd1.Manager"
}

// method GetUnit

func (v *interfaceManager) GoGetUnit(flags dbus.Flags, ch chan *dbus.Call, name string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetUnit", flags, ch, name)
}

func (*interfaceManager) StoreGetUnit(call *dbus.Call) (unit dbus.ObjectPath, err error) {
	err = call.Store(&unit)
	return
}

func (v *interfaceManager) GetUnit(flags dbus.Flags, name string) (dbus.ObjectPath, error) {
	return v.StoreGetUnit(
		<-v.GoGetUnit(flags, make(chan *dbus.Call, 1), name).Done)
}

// method GetUnitByPID

func (v *interfaceManager) GoGetUnitByPID(flags dbus.Flags, ch chan *dbus.Call, pid uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetUnitByPID", flags, ch, pid)
}

func (*interfaceManager) StoreGetUnitByPID(call *dbus.Call) (unit dbus.ObjectPath, err error) {
	err = call.Store(&unit)
	return
}

func (v *interfaceManager) GetUnitByPID(flags dbus.Flags, pid uint32) (dbus.ObjectPath, error) {
	return v.StoreGetUnitByPID(
		<-v.GoGetUnitByPID(flags, make(chan *dbus.Call, 1), pid).Done)
}

// method GetUnitByInvocationID

func (v *interfaceManager) GoGetUnitByInvocationID(flags dbus.Flags, ch chan *dbus.Call, invocationID []uint8) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetUnitByInvocationID", flags, ch, invocationID)
}

func (*interfaceManager) StoreGetUnitByInvocationID(call *dbus.Call) (unit dbus.ObjectPath, err error) {
	err = call.Store(&unit)
	return
}

func (v *interfaceManager) GetUnitByInvocationID(flags dbus.Flags, invocationID []uint8) (dbus.ObjectPath, error) {
	return v.StoreGetUnitByInvocationID(
		<-v.GoGetUnitByInvocationID(flags, make(chan *dbus.Call, 1), invocationID).Done)
}

// method GetUnitByControlGroup

func (v *interfaceManager) GoGetUnitByControlGroup(flags dbus.Flags, ch chan *dbus.Call, ctrlGroup string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetUnitByControlGroup", flags, ch, ctrlGroup)
}

func (*interfaceManager) StoreGetUnitByControlGroup(call *dbus.Call) (unit dbus.ObjectPath, err error) {
	err = call.Store(&unit)
	return
}

func (v *interfaceManager) GetUnitByControlGroup(flags dbus.Flags, ctrlGroup string) (dbus.ObjectPath, error) {
	return v.StoreGetUnitByControlGroup(
		<-v.GoGetUnitByControlGroup(flags, make(chan *dbus.Call, 1), ctrlGroup).Done)
}

// method LoadUnit

func (v *interfaceManager) GoLoadUnit(flags dbus.Flags, ch chan *dbus.Call, name string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".LoadUnit", flags, ch, name)
}

func (*interfaceManager) StoreLoadUnit(call *dbus.Call) (unit dbus.ObjectPath, err error) {
	err = call.Store(&unit)
	return
}

func (v *interfaceManager) LoadUnit(flags dbus.Flags, name string) (dbus.ObjectPath, error) {
	return v.StoreLoadUnit(
		<-v.GoLoadUnit(flags, make(chan *dbus.Call, 1), name).Done)
}

// method StartUnit

func (v *interfaceManager) GoStartUnit(flags dbus.Flags, ch chan *dbus.Call, name string, mode string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".StartUnit", flags, ch, name, mode)
}

func (*interfaceManager) StoreStartUnit(call *dbus.Call) (unit dbus.ObjectPath, err error) {
	err = call.Store(&unit)
	return
}

func (v *interfaceManager) StartUnit(flags dbus.Flags, name string, mode string) (dbus.ObjectPath, error) {
	return v.StoreStartUnit(
		<-v.GoStartUnit(flags, make(chan *dbus.Call, 1), name, mode).Done)
}

// method StartUnitReplace

func (v *interfaceManager) GoStartUnitReplace(flags dbus.Flags, ch chan *dbus.Call, oldUnit string, newUnit string, mode string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".StartUnitReplace", flags, ch, oldUnit, newUnit, mode)
}

func (*interfaceManager) StoreStartUnitReplace(call *dbus.Call) (job dbus.ObjectPath, err error) {
	err = call.Store(&job)
	return
}

func (v *interfaceManager) StartUnitReplace(flags dbus.Flags, oldUnit string, newUnit string, mode string) (dbus.ObjectPath, error) {
	return v.StoreStartUnitReplace(
		<-v.GoStartUnitReplace(flags, make(chan *dbus.Call, 1), oldUnit, newUnit, mode).Done)
}

// method StopUnit

func (v *interfaceManager) GoStopUnit(flags dbus.Flags, ch chan *dbus.Call, name string, mode string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".StopUnit", flags, ch, name, mode)
}

func (*interfaceManager) StoreStopUnit(call *dbus.Call) (job dbus.ObjectPath, err error) {
	err = call.Store(&job)
	return
}

func (v *interfaceManager) StopUnit(flags dbus.Flags, name string, mode string) (dbus.ObjectPath, error) {
	return v.StoreStopUnit(
		<-v.GoStopUnit(flags, make(chan *dbus.Call, 1), name, mode).Done)
}

// method ReloadUnit

func (v *interfaceManager) GoReloadUnit(flags dbus.Flags, ch chan *dbus.Call, name string, mode string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ReloadUnit", flags, ch, name, mode)
}

func (*interfaceManager) StoreReloadUnit(call *dbus.Call) (job dbus.ObjectPath, err error) {
	err = call.Store(&job)
	return
}

func (v *interfaceManager) ReloadUnit(flags dbus.Flags, name string, mode string) (dbus.ObjectPath, error) {
	return v.StoreReloadUnit(
		<-v.GoReloadUnit(flags, make(chan *dbus.Call, 1), name, mode).Done)
}

// method RestartUnit

func (v *interfaceManager) GoRestartUnit(flags dbus.Flags, ch chan *dbus.Call, name string, mode string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RestartUnit", flags, ch, name, mode)
}

func (*interfaceManager) StoreRestartUnit(call *dbus.Call) (job dbus.ObjectPath, err error) {
	err = call.Store(&job)
	return
}

func (v *interfaceManager) RestartUnit(flags dbus.Flags, name string, mode string) (dbus.ObjectPath, error) {
	return v.StoreRestartUnit(
		<-v.GoRestartUnit(flags, make(chan *dbus.Call, 1), name, mode).Done)
}

// method TryRestartUnit

func (v *interfaceManager) GoTryRestartUnit(flags dbus.Flags, ch chan *dbus.Call, name string, mode string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".TryRestartUnit", flags, ch, name, mode)
}

func (*interfaceManager) StoreTryRestartUnit(call *dbus.Call) (job dbus.ObjectPath, err error) {
	err = call.Store(&job)
	return
}

func (v *interfaceManager) TryRestartUnit(flags dbus.Flags, name string, mode string) (dbus.ObjectPath, error) {
	return v.StoreTryRestartUnit(
		<-v.GoTryRestartUnit(flags, make(chan *dbus.Call, 1), name, mode).Done)
}

// method ReloadOrRestartUnit

func (v *interfaceManager) GoReloadOrRestartUnit(flags dbus.Flags, ch chan *dbus.Call, name string, mode string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ReloadOrRestartUnit", flags, ch, name, mode)
}

func (*interfaceManager) StoreReloadOrRestartUnit(call *dbus.Call) (job dbus.ObjectPath, err error) {
	err = call.Store(&job)
	return
}

func (v *interfaceManager) ReloadOrRestartUnit(flags dbus.Flags, name string, mode string) (dbus.ObjectPath, error) {
	return v.StoreReloadOrRestartUnit(
		<-v.GoReloadOrRestartUnit(flags, make(chan *dbus.Call, 1), name, mode).Done)
}

// method ReloadOrTryRestartUnit

func (v *interfaceManager) GoReloadOrTryRestartUnit(flags dbus.Flags, ch chan *dbus.Call, name string, mode string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ReloadOrTryRestartUnit", flags, ch, name, mode)
}

func (*interfaceManager) StoreReloadOrTryRestartUnit(call *dbus.Call) (job dbus.ObjectPath, err error) {
	err = call.Store(&job)
	return
}

func (v *interfaceManager) ReloadOrTryRestartUnit(flags dbus.Flags, name string, mode string) (dbus.ObjectPath, error) {
	return v.StoreReloadOrTryRestartUnit(
		<-v.GoReloadOrTryRestartUnit(flags, make(chan *dbus.Call, 1), name, mode).Done)
}

// method KillUnit

func (v *interfaceManager) GoKillUnit(flags dbus.Flags, ch chan *dbus.Call, name string, who string, signal int32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".KillUnit", flags, ch, name, who, signal)
}

func (v *interfaceManager) KillUnit(flags dbus.Flags, name string, who string, signal int32) error {
	return (<-v.GoKillUnit(flags, make(chan *dbus.Call, 1), name, who, signal).Done).Err
}

// method ResetFailedUnit

func (v *interfaceManager) GoResetFailedUnit(flags dbus.Flags, ch chan *dbus.Call, name string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ResetFailedUnit", flags, ch, name)
}

func (v *interfaceManager) ResetFailedUnit(flags dbus.Flags, name string) error {
	return (<-v.GoResetFailedUnit(flags, make(chan *dbus.Call, 1), name).Done).Err
}

// method SetUnitProperties

func (v *interfaceManager) GoSetUnitProperties(flags dbus.Flags, ch chan *dbus.Call, name string, runtime bool, properties []Property) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetUnitProperties", flags, ch, name, runtime, properties)
}

func (v *interfaceManager) SetUnitProperties(flags dbus.Flags, name string, runtime bool, properties []Property) error {
	return (<-v.GoSetUnitProperties(flags, make(chan *dbus.Call, 1), name, runtime, properties).Done).Err
}

// method RefUnit

func (v *interfaceManager) GoRefUnit(flags dbus.Flags, ch chan *dbus.Call, name string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RefUnit", flags, ch, name)
}

func (v *interfaceManager) RefUnit(flags dbus.Flags, name string) error {
	return (<-v.GoRefUnit(flags, make(chan *dbus.Call, 1), name).Done).Err
}

// method UnrefUnit

func (v *interfaceManager) GoUnrefUnit(flags dbus.Flags, ch chan *dbus.Call, name string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".UnrefUnit", flags, ch, name)
}

func (v *interfaceManager) UnrefUnit(flags dbus.Flags, name string) error {
	return (<-v.GoUnrefUnit(flags, make(chan *dbus.Call, 1), name).Done).Err
}

// method StartTransientUnit

func (v *interfaceManager) GoStartTransientUnit(flags dbus.Flags, ch chan *dbus.Call, name string, mode string, properties []Property, aux []PropertyCollection) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".StartTransientUnit", flags, ch, name, mode, properties, aux)
}

func (*interfaceManager) StoreStartTransientUnit(call *dbus.Call) (job dbus.ObjectPath, err error) {
	err = call.Store(&job)
	return
}

func (v *interfaceManager) StartTransientUnit(flags dbus.Flags, name string, mode string, properties []Property, aux []PropertyCollection) (dbus.ObjectPath, error) {
	return v.StoreStartTransientUnit(
		<-v.GoStartTransientUnit(flags, make(chan *dbus.Call, 1), name, mode, properties, aux).Done)
}

// method GetUnitProcesses

func (v *interfaceManager) GoGetUnitProcesses(flags dbus.Flags, ch chan *dbus.Call, name string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetUnitProcesses", flags, ch, name)
}

func (*interfaceManager) StoreGetUnitProcesses(call *dbus.Call) (processes []UnitProcess, err error) {
	err = call.Store(&processes)
	return
}

func (v *interfaceManager) GetUnitProcesses(flags dbus.Flags, name string) ([]UnitProcess, error) {
	return v.StoreGetUnitProcesses(
		<-v.GoGetUnitProcesses(flags, make(chan *dbus.Call, 1), name).Done)
}

// method AttachProcessesToUnit

func (v *interfaceManager) GoAttachProcessesToUnit(flags dbus.Flags, ch chan *dbus.Call, name string, path string, pids []uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".AttachProcessesToUnit", flags, ch, name, path, pids)
}

func (v *interfaceManager) AttachProcessesToUnit(flags dbus.Flags, name string, path string, pids []uint32) error {
	return (<-v.GoAttachProcessesToUnit(flags, make(chan *dbus.Call, 1), name, path, pids).Done).Err
}

// method AbandonScope

func (v *interfaceManager) GoAbandonScope(flags dbus.Flags, ch chan *dbus.Call, name string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".AbandonScope", flags, ch, name)
}

func (v *interfaceManager) AbandonScope(flags dbus.Flags, name string) error {
	return (<-v.GoAbandonScope(flags, make(chan *dbus.Call, 1), name).Done).Err
}

// method GetJob

func (v *interfaceManager) GoGetJob(flags dbus.Flags, ch chan *dbus.Call, id uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetJob", flags, ch, id)
}

func (*interfaceManager) StoreGetJob(call *dbus.Call) (job dbus.ObjectPath, err error) {
	err = call.Store(&job)
	return
}

func (v *interfaceManager) GetJob(flags dbus.Flags, id uint32) (dbus.ObjectPath, error) {
	return v.StoreGetJob(
		<-v.GoGetJob(flags, make(chan *dbus.Call, 1), id).Done)
}

// method GetJobAfter

func (v *interfaceManager) GoGetJobAfter(flags dbus.Flags, ch chan *dbus.Call, id uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetJobAfter", flags, ch, id)
}

func (*interfaceManager) StoreGetJobAfter(call *dbus.Call) (jobs []JobInfo, err error) {
	err = call.Store(&jobs)
	return
}

func (v *interfaceManager) GetJobAfter(flags dbus.Flags, id uint32) ([]JobInfo, error) {
	return v.StoreGetJobAfter(
		<-v.GoGetJobAfter(flags, make(chan *dbus.Call, 1), id).Done)
}

// method GetJobBefore

func (v *interfaceManager) GoGetJobBefore(flags dbus.Flags, ch chan *dbus.Call, id uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetJobBefore", flags, ch, id)
}

func (*interfaceManager) StoreGetJobBefore(call *dbus.Call) (jobs []JobInfo, err error) {
	err = call.Store(&jobs)
	return
}

func (v *interfaceManager) GetJobBefore(flags dbus.Flags, id uint32) ([]JobInfo, error) {
	return v.StoreGetJobBefore(
		<-v.GoGetJobBefore(flags, make(chan *dbus.Call, 1), id).Done)
}

// method CancelJob

func (v *interfaceManager) GoCancelJob(flags dbus.Flags, ch chan *dbus.Call, id uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".CancelJob", flags, ch, id)
}

func (v *interfaceManager) CancelJob(flags dbus.Flags, id uint32) error {
	return (<-v.GoCancelJob(flags, make(chan *dbus.Call, 1), id).Done).Err
}

// method ClearJobs

func (v *interfaceManager) GoClearJobs(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ClearJobs", flags, ch)
}

func (v *interfaceManager) ClearJobs(flags dbus.Flags) error {
	return (<-v.GoClearJobs(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method ResetFailed

func (v *interfaceManager) GoResetFailed(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ResetFailed", flags, ch)
}

func (v *interfaceManager) ResetFailed(flags dbus.Flags) error {
	return (<-v.GoResetFailed(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method ListUnits

func (v *interfaceManager) GoListUnits(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ListUnits", flags, ch)
}

func (*interfaceManager) StoreListUnits(call *dbus.Call) (units []UnitInfo, err error) {
	err = call.Store(&units)
	return
}

func (v *interfaceManager) ListUnits(flags dbus.Flags) ([]UnitInfo, error) {
	return v.StoreListUnits(
		<-v.GoListUnits(flags, make(chan *dbus.Call, 1)).Done)
}

// method ListUnitsFiltered

func (v *interfaceManager) GoListUnitsFiltered(flags dbus.Flags, ch chan *dbus.Call, states []string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ListUnitsFiltered", flags, ch, states)
}

func (*interfaceManager) StoreListUnitsFiltered(call *dbus.Call) (units []UnitInfo, err error) {
	err = call.Store(&units)
	return
}

func (v *interfaceManager) ListUnitsFiltered(flags dbus.Flags, states []string) ([]UnitInfo, error) {
	return v.StoreListUnitsFiltered(
		<-v.GoListUnitsFiltered(flags, make(chan *dbus.Call, 1), states).Done)
}

// method ListUnitsByPatterns

func (v *interfaceManager) GoListUnitsByPatterns(flags dbus.Flags, ch chan *dbus.Call, states []string, patterns []string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ListUnitsByPatterns", flags, ch, states, patterns)
}

func (*interfaceManager) StoreListUnitsByPatterns(call *dbus.Call) (units []UnitInfo, err error) {
	err = call.Store(&units)
	return
}

func (v *interfaceManager) ListUnitsByPatterns(flags dbus.Flags, states []string, patterns []string) ([]UnitInfo, error) {
	return v.StoreListUnitsByPatterns(
		<-v.GoListUnitsByPatterns(flags, make(chan *dbus.Call, 1), states, patterns).Done)
}

// method ListUnitsByNames

func (v *interfaceManager) GoListUnitsByNames(flags dbus.Flags, ch chan *dbus.Call, names []string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ListUnitsByNames", flags, ch, names)
}

func (*interfaceManager) StoreListUnitsByNames(call *dbus.Call) (units []UnitInfo, err error) {
	err = call.Store(&units)
	return
}

func (v *interfaceManager) ListUnitsByNames(flags dbus.Flags, names []string) ([]UnitInfo, error) {
	return v.StoreListUnitsByNames(
		<-v.GoListUnitsByNames(flags, make(chan *dbus.Call, 1), names).Done)
}

// method ListJobs

func (v *interfaceManager) GoListJobs(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ListJobs", flags, ch)
}

func (*interfaceManager) StoreListJobs(call *dbus.Call) (jobs []JobInfo, err error) {
	err = call.Store(&jobs)
	return
}

func (v *interfaceManager) ListJobs(flags dbus.Flags) ([]JobInfo, error) {
	return v.StoreListJobs(
		<-v.GoListJobs(flags, make(chan *dbus.Call, 1)).Done)
}

// method Subscribe

func (v *interfaceManager) GoSubscribe(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Subscribe", flags, ch)
}

func (v *interfaceManager) Subscribe(flags dbus.Flags) error {
	return (<-v.GoSubscribe(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method Unsubscribe

func (v *interfaceManager) GoUnsubscribe(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Unsubscribe", flags, ch)
}

func (v *interfaceManager) Unsubscribe(flags dbus.Flags) error {
	return (<-v.GoUnsubscribe(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method Dump

func (v *interfaceManager) GoDump(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Dump", flags, ch)
}

func (*interfaceManager) StoreDump(call *dbus.Call) (arg0 string, err error) {
	err = call.Store(&arg0)
	return
}

func (v *interfaceManager) Dump(flags dbus.Flags) (string, error) {
	return v.StoreDump(
		<-v.GoDump(flags, make(chan *dbus.Call, 1)).Done)
}

// method DumpByFileDescriptor

func (v *interfaceManager) GoDumpByFileDescriptor(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".DumpByFileDescriptor", flags, ch)
}

func (*interfaceManager) StoreDumpByFileDescriptor(call *dbus.Call) (fd dbus.UnixFD, err error) {
	err = call.Store(&fd)
	return
}

func (v *interfaceManager) DumpByFileDescriptor(flags dbus.Flags) (dbus.UnixFD, error) {
	return v.StoreDumpByFileDescriptor(
		<-v.GoDumpByFileDescriptor(flags, make(chan *dbus.Call, 1)).Done)
}

// method Reload

func (v *interfaceManager) GoReload(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Reload", flags, ch)
}

func (v *interfaceManager) Reload(flags dbus.Flags) error {
	return (<-v.GoReload(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method Reexecute

func (v *interfaceManager) GoReexecute(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Reexecute", flags, ch)
}

func (v *interfaceManager) Reexecute(flags dbus.Flags) error {
	return (<-v.GoReexecute(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method Exit

func (v *interfaceManager) GoExit(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Exit", flags, ch)
}

func (v *interfaceManager) Exit(flags dbus.Flags) error {
	return (<-v.GoExit(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method Reboot

func (v *interfaceManager) GoReboot(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Reboot", flags, ch)
}

func (v *interfaceManager) Reboot(flags dbus.Flags) error {
	return (<-v.GoReboot(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method PowerOff

func (v *interfaceManager) GoPowerOff(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".PowerOff", flags, ch)
}

func (v *interfaceManager) PowerOff(flags dbus.Flags) error {
	return (<-v.GoPowerOff(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method Halt

func (v *interfaceManager) GoHalt(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Halt", flags, ch)
}

func (v *interfaceManager) Halt(flags dbus.Flags) error {
	return (<-v.GoHalt(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method KExec

func (v *interfaceManager) GoKExec(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".KExec", flags, ch)
}

func (v *interfaceManager) KExec(flags dbus.Flags) error {
	return (<-v.GoKExec(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method SwitchRoot

func (v *interfaceManager) GoSwitchRoot(flags dbus.Flags, ch chan *dbus.Call, newRoot string, init string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SwitchRoot", flags, ch, newRoot, init)
}

func (v *interfaceManager) SwitchRoot(flags dbus.Flags, newRoot string, init string) error {
	return (<-v.GoSwitchRoot(flags, make(chan *dbus.Call, 1), newRoot, init).Done).Err
}

// method SetEnvironment

func (v *interfaceManager) GoSetEnvironment(flags dbus.Flags, ch chan *dbus.Call, names []string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetEnvironment", flags, ch, names)
}

func (v *interfaceManager) SetEnvironment(flags dbus.Flags, names []string) error {
	return (<-v.GoSetEnvironment(flags, make(chan *dbus.Call, 1), names).Done).Err
}

// method UnsetEnvironment

func (v *interfaceManager) GoUnsetEnvironment(flags dbus.Flags, ch chan *dbus.Call, names []string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".UnsetEnvironment", flags, ch, names)
}

func (v *interfaceManager) UnsetEnvironment(flags dbus.Flags, names []string) error {
	return (<-v.GoUnsetEnvironment(flags, make(chan *dbus.Call, 1), names).Done).Err
}

// method UnsetAndSetEnvironment

func (v *interfaceManager) GoUnsetAndSetEnvironment(flags dbus.Flags, ch chan *dbus.Call, unset []string, set []string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".UnsetAndSetEnvironment", flags, ch, unset, set)
}

func (v *interfaceManager) UnsetAndSetEnvironment(flags dbus.Flags, unset []string, set []string) error {
	return (<-v.GoUnsetAndSetEnvironment(flags, make(chan *dbus.Call, 1), unset, set).Done).Err
}

// method ListUnitFiles

func (v *interfaceManager) GoListUnitFiles(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ListUnitFiles", flags, ch)
}

func (*interfaceManager) StoreListUnitFiles(call *dbus.Call) (files []UnitFile, err error) {
	err = call.Store(&files)
	return
}

func (v *interfaceManager) ListUnitFiles(flags dbus.Flags) ([]UnitFile, error) {
	return v.StoreListUnitFiles(
		<-v.GoListUnitFiles(flags, make(chan *dbus.Call, 1)).Done)
}

// method ListUnitFilesByPatterns

func (v *interfaceManager) GoListUnitFilesByPatterns(flags dbus.Flags, ch chan *dbus.Call, states []string, patterns []string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ListUnitFilesByPatterns", flags, ch, states, patterns)
}

func (*interfaceManager) StoreListUnitFilesByPatterns(call *dbus.Call) (files []UnitFile, err error) {
	err = call.Store(&files)
	return
}

func (v *interfaceManager) ListUnitFilesByPatterns(flags dbus.Flags, states []string, patterns []string) ([]UnitFile, error) {
	return v.StoreListUnitFilesByPatterns(
		<-v.GoListUnitFilesByPatterns(flags, make(chan *dbus.Call, 1), states, patterns).Done)
}

// method GetUnitFileState

func (v *interfaceManager) GoGetUnitFileState(flags dbus.Flags, ch chan *dbus.Call, unit string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetUnitFileState", flags, ch, unit)
}

func (*interfaceManager) StoreGetUnitFileState(call *dbus.Call) (state string, err error) {
	err = call.Store(&state)
	return
}

func (v *interfaceManager) GetUnitFileState(flags dbus.Flags, unit string) (string, error) {
	return v.StoreGetUnitFileState(
		<-v.GoGetUnitFileState(flags, make(chan *dbus.Call, 1), unit).Done)
}

// method EnableUnitFiles

func (v *interfaceManager) GoEnableUnitFiles(flags dbus.Flags, ch chan *dbus.Call, files []string, runtime bool, force bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".EnableUnitFiles", flags, ch, files, runtime, force)
}

func (*interfaceManager) StoreEnableUnitFiles(call *dbus.Call) (carriesInstallInfo bool, changes []UnitFileChange, err error) {
	err = call.Store(&carriesInstallInfo, &changes)
	return
}

func (v *interfaceManager) EnableUnitFiles(flags dbus.Flags, files []string, runtime bool, force bool) (bool, []UnitFileChange, error) {
	return v.StoreEnableUnitFiles(
		<-v.GoEnableUnitFiles(flags, make(chan *dbus.Call, 1), files, runtime, force).Done)
}

// method DisableUnitFiles

func (v *interfaceManager) GoDisableUnitFiles(flags dbus.Flags, ch chan *dbus.Call, files []string, runtime bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".DisableUnitFiles", flags, ch, files, runtime)
}

func (*interfaceManager) StoreDisableUnitFiles(call *dbus.Call) (changes []UnitFileChange, err error) {
	err = call.Store(&changes)
	return
}

func (v *interfaceManager) DisableUnitFiles(flags dbus.Flags, files []string, runtime bool) ([]UnitFileChange, error) {
	return v.StoreDisableUnitFiles(
		<-v.GoDisableUnitFiles(flags, make(chan *dbus.Call, 1), files, runtime).Done)
}

// method ReenableUnitFiles

func (v *interfaceManager) GoReenableUnitFiles(flags dbus.Flags, ch chan *dbus.Call, files []string, runtime bool, force bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ReenableUnitFiles", flags, ch, files, runtime, force)
}

func (*interfaceManager) StoreReenableUnitFiles(call *dbus.Call) (carriesInstallInfo bool, changes []UnitFileChange, err error) {
	err = call.Store(&carriesInstallInfo, &changes)
	return
}

func (v *interfaceManager) ReenableUnitFiles(flags dbus.Flags, files []string, runtime bool, force bool) (bool, []UnitFileChange, error) {
	return v.StoreReenableUnitFiles(
		<-v.GoReenableUnitFiles(flags, make(chan *dbus.Call, 1), files, runtime, force).Done)
}

// method LinkUnitFiles

func (v *interfaceManager) GoLinkUnitFiles(flags dbus.Flags, ch chan *dbus.Call, files []string, runtime bool, force bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".LinkUnitFiles", flags, ch, files, runtime, force)
}

func (*interfaceManager) StoreLinkUnitFiles(call *dbus.Call) (changes []UnitFileChange, err error) {
	err = call.Store(&changes)
	return
}

func (v *interfaceManager) LinkUnitFiles(flags dbus.Flags, files []string, runtime bool, force bool) ([]UnitFileChange, error) {
	return v.StoreLinkUnitFiles(
		<-v.GoLinkUnitFiles(flags, make(chan *dbus.Call, 1), files, runtime, force).Done)
}

// method PresetUnitFiles

func (v *interfaceManager) GoPresetUnitFiles(flags dbus.Flags, ch chan *dbus.Call, files []string, runtime bool, force bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".PresetUnitFiles", flags, ch, files, runtime, force)
}

func (*interfaceManager) StorePresetUnitFiles(call *dbus.Call) (carriesInstallInfo bool, changes []UnitFileChange, err error) {
	err = call.Store(&carriesInstallInfo, &changes)
	return
}

func (v *interfaceManager) PresetUnitFiles(flags dbus.Flags, files []string, runtime bool, force bool) (bool, []UnitFileChange, error) {
	return v.StorePresetUnitFiles(
		<-v.GoPresetUnitFiles(flags, make(chan *dbus.Call, 1), files, runtime, force).Done)
}

// method PresetUnitFilesWithMode

func (v *interfaceManager) GoPresetUnitFilesWithMode(flags dbus.Flags, ch chan *dbus.Call, files []string, mode string, runtime bool, force bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".PresetUnitFilesWithMode", flags, ch, files, mode, runtime, force)
}

func (*interfaceManager) StorePresetUnitFilesWithMode(call *dbus.Call) (carriesInstallInfo bool, changes []UnitFileChange, err error) {
	err = call.Store(&carriesInstallInfo, &changes)
	return
}

func (v *interfaceManager) PresetUnitFilesWithMode(flags dbus.Flags, files []string, mode string, runtime bool, force bool) (bool, []UnitFileChange, error) {
	return v.StorePresetUnitFilesWithMode(
		<-v.GoPresetUnitFilesWithMode(flags, make(chan *dbus.Call, 1), files, mode, runtime, force).Done)
}

// method MaskUnitFiles

func (v *interfaceManager) GoMaskUnitFiles(flags dbus.Flags, ch chan *dbus.Call, files []string, runtime bool, force bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".MaskUnitFiles", flags, ch, files, runtime, force)
}

func (*interfaceManager) StoreMaskUnitFiles(call *dbus.Call) (changes []UnitFileChange, err error) {
	err = call.Store(&changes)
	return
}

func (v *interfaceManager) MaskUnitFiles(flags dbus.Flags, files []string, runtime bool, force bool) ([]UnitFileChange, error) {
	return v.StoreMaskUnitFiles(
		<-v.GoMaskUnitFiles(flags, make(chan *dbus.Call, 1), files, runtime, force).Done)
}

// method UnmaskUnitFiles

func (v *interfaceManager) GoUnmaskUnitFiles(flags dbus.Flags, ch chan *dbus.Call, files []string, runtime bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".UnmaskUnitFiles", flags, ch, files, runtime)
}

func (*interfaceManager) StoreUnmaskUnitFiles(call *dbus.Call) (changes []UnitFileChange, err error) {
	err = call.Store(&changes)
	return
}

func (v *interfaceManager) UnmaskUnitFiles(flags dbus.Flags, files []string, runtime bool) ([]UnitFileChange, error) {
	return v.StoreUnmaskUnitFiles(
		<-v.GoUnmaskUnitFiles(flags, make(chan *dbus.Call, 1), files, runtime).Done)
}

// method RevertUnitFiles

func (v *interfaceManager) GoRevertUnitFiles(flags dbus.Flags, ch chan *dbus.Call, files []string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RevertUnitFiles", flags, ch, files)
}

func (*interfaceManager) StoreRevertUnitFiles(call *dbus.Call) (changes []UnitFileChange, err error) {
	err = call.Store(&changes)
	return
}

func (v *interfaceManager) RevertUnitFiles(flags dbus.Flags, files []string) ([]UnitFileChange, error) {
	return v.StoreRevertUnitFiles(
		<-v.GoRevertUnitFiles(flags, make(chan *dbus.Call, 1), files).Done)
}

// method SetDefaultTarget

func (v *interfaceManager) GoSetDefaultTarget(flags dbus.Flags, ch chan *dbus.Call, name string, force bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetDefaultTarget", flags, ch, name, force)
}

func (*interfaceManager) StoreSetDefaultTarget(call *dbus.Call) (changes []UnitFileChange, err error) {
	err = call.Store(&changes)
	return
}

func (v *interfaceManager) SetDefaultTarget(flags dbus.Flags, name string, force bool) ([]UnitFileChange, error) {
	return v.StoreSetDefaultTarget(
		<-v.GoSetDefaultTarget(flags, make(chan *dbus.Call, 1), name, force).Done)
}

// method GetDefaultTarget

func (v *interfaceManager) GoGetDefaultTarget(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetDefaultTarget", flags, ch)
}

func (*interfaceManager) StoreGetDefaultTarget(call *dbus.Call) (name string, err error) {
	err = call.Store(&name)
	return
}

func (v *interfaceManager) GetDefaultTarget(flags dbus.Flags) (string, error) {
	return v.StoreGetDefaultTarget(
		<-v.GoGetDefaultTarget(flags, make(chan *dbus.Call, 1)).Done)
}

// method PresetAllUnitFiles

func (v *interfaceManager) GoPresetAllUnitFiles(flags dbus.Flags, ch chan *dbus.Call, mode string, runtime bool, force bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".PresetAllUnitFiles", flags, ch, mode, runtime, force)
}

func (*interfaceManager) StorePresetAllUnitFiles(call *dbus.Call) (changes []UnitFileChange, err error) {
	err = call.Store(&changes)
	return
}

func (v *interfaceManager) PresetAllUnitFiles(flags dbus.Flags, mode string, runtime bool, force bool) ([]UnitFileChange, error) {
	return v.StorePresetAllUnitFiles(
		<-v.GoPresetAllUnitFiles(flags, make(chan *dbus.Call, 1), mode, runtime, force).Done)
}

// method AddDependencyUnitFiles

func (v *interfaceManager) GoAddDependencyUnitFiles(flags dbus.Flags, ch chan *dbus.Call, files []string, target string, type0 string, runtime bool, force bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".AddDependencyUnitFiles", flags, ch, files, target, type0, runtime, force)
}

func (*interfaceManager) StoreAddDependencyUnitFiles(call *dbus.Call) (changes []UnitFileChange, err error) {
	err = call.Store(&changes)
	return
}

func (v *interfaceManager) AddDependencyUnitFiles(flags dbus.Flags, files []string, target string, type0 string, runtime bool, force bool) ([]UnitFileChange, error) {
	return v.StoreAddDependencyUnitFiles(
		<-v.GoAddDependencyUnitFiles(flags, make(chan *dbus.Call, 1), files, target, type0, runtime, force).Done)
}

// method GetUnitFileLinks

func (v *interfaceManager) GoGetUnitFileLinks(flags dbus.Flags, ch chan *dbus.Call, name string, runtime bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetUnitFileLinks", flags, ch, name, runtime)
}

func (*interfaceManager) StoreGetUnitFileLinks(call *dbus.Call) (links []string, err error) {
	err = call.Store(&links)
	return
}

func (v *interfaceManager) GetUnitFileLinks(flags dbus.Flags, name string, runtime bool) ([]string, error) {
	return v.StoreGetUnitFileLinks(
		<-v.GoGetUnitFileLinks(flags, make(chan *dbus.Call, 1), name, runtime).Done)
}

// method SetExitCode

func (v *interfaceManager) GoSetExitCode(flags dbus.Flags, ch chan *dbus.Call, exitCode uint8) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetExitCode", flags, ch, exitCode)
}

func (v *interfaceManager) SetExitCode(flags dbus.Flags, exitCode uint8) error {
	return (<-v.GoSetExitCode(flags, make(chan *dbus.Call, 1), exitCode).Done).Err
}

// method LookupDynamicUserByName

func (v *interfaceManager) GoLookupDynamicUserByName(flags dbus.Flags, ch chan *dbus.Call, name string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".LookupDynamicUserByName", flags, ch, name)
}

func (*interfaceManager) StoreLookupDynamicUserByName(call *dbus.Call) (user uint32, err error) {
	err = call.Store(&user)
	return
}

func (v *interfaceManager) LookupDynamicUserByName(flags dbus.Flags, name string) (uint32, error) {
	return v.StoreLookupDynamicUserByName(
		<-v.GoLookupDynamicUserByName(flags, make(chan *dbus.Call, 1), name).Done)
}

// method LookupDynamicUserByUID

func (v *interfaceManager) GoLookupDynamicUserByUID(flags dbus.Flags, ch chan *dbus.Call, uid uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".LookupDynamicUserByUID", flags, ch, uid)
}

func (*interfaceManager) StoreLookupDynamicUserByUID(call *dbus.Call) (user string, err error) {
	err = call.Store(&user)
	return
}

func (v *interfaceManager) LookupDynamicUserByUID(flags dbus.Flags, uid uint32) (string, error) {
	return v.StoreLookupDynamicUserByUID(
		<-v.GoLookupDynamicUserByUID(flags, make(chan *dbus.Call, 1), uid).Done)
}

// method GetDynamicUsers

func (v *interfaceManager) GoGetDynamicUsers(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetDynamicUsers", flags, ch)
}

func (*interfaceManager) StoreGetDynamicUsers(call *dbus.Call) (users []DynamicUser, err error) {
	err = call.Store(&users)
	return
}

func (v *interfaceManager) GetDynamicUsers(flags dbus.Flags) ([]DynamicUser, error) {
	return v.StoreGetDynamicUsers(
		<-v.GoGetDynamicUsers(flags, make(chan *dbus.Call, 1)).Done)
}

// signal UnitNew

func (v *interfaceManager) ConnectUnitNew(cb func(id string, unit dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "UnitNew", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".UnitNew",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var id string
		var unit dbus.ObjectPath
		err := dbus.Store(sig.Body, &id, &unit)
		if err == nil {
			cb(id, unit)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal UnitRemoved

func (v *interfaceManager) ConnectUnitRemoved(cb func(id string, unit dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "UnitRemoved", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".UnitRemoved",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var id string
		var unit dbus.ObjectPath
		err := dbus.Store(sig.Body, &id, &unit)
		if err == nil {
			cb(id, unit)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal JobNew

func (v *interfaceManager) ConnectJobNew(cb func(id uint32, job dbus.ObjectPath, unit string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "JobNew", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".JobNew",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var id uint32
		var job dbus.ObjectPath
		var unit string
		err := dbus.Store(sig.Body, &id, &job, &unit)
		if err == nil {
			cb(id, job, unit)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal JobRemoved

func (v *interfaceManager) ConnectJobRemoved(cb func(id uint32, job dbus.ObjectPath, unit string, result string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "JobRemoved", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".JobRemoved",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var id uint32
		var job dbus.ObjectPath
		var unit string
		var result string
		err := dbus.Store(sig.Body, &id, &job, &unit, &result)
		if err == nil {
			cb(id, job, unit, result)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal StartupFinished

func (v *interfaceManager) ConnectStartupFinished(cb func(firmware uint64, loader uint64, kernel uint64, initrd uint64, userspace uint64, total uint64)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "StartupFinished", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".StartupFinished",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var firmware uint64
		var loader uint64
		var kernel uint64
		var initrd uint64
		var userspace uint64
		var total uint64
		err := dbus.Store(sig.Body, &firmware, &loader, &kernel, &initrd, &userspace, &total)
		if err == nil {
			cb(firmware, loader, kernel, initrd, userspace, total)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal UnitFilesChanged

func (v *interfaceManager) ConnectUnitFilesChanged(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "UnitFilesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".UnitFilesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal Reloading

func (v *interfaceManager) ConnectReloading(cb func(active bool)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "Reloading", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".Reloading",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var active bool
		err := dbus.Store(sig.Body, &active)
		if err == nil {
			cb(active)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property Version s

func (v *interfaceManager) Version() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Version",
	}
}

// property Features s

func (v *interfaceManager) Features() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Features",
	}
}

// property Virtualization s

func (v *interfaceManager) Virtualization() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Virtualization",
	}
}

// property Architecture s

func (v *interfaceManager) Architecture() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Architecture",
	}
}

// property Tainted s

func (v *interfaceManager) Tainted() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Tainted",
	}
}

// property FirmwareTimestamp t

func (v *interfaceManager) FirmwareTimestamp() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "FirmwareTimestamp",
	}
}

// property FirmwareTimestampMonotonic t

func (v *interfaceManager) FirmwareTimestampMonotonic() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "FirmwareTimestampMonotonic",
	}
}

// property LoaderTimestamp t

func (v *interfaceManager) LoaderTimestamp() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LoaderTimestamp",
	}
}

// property LoaderTimestampMonotonic t

func (v *interfaceManager) LoaderTimestampMonotonic() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LoaderTimestampMonotonic",
	}
}

// property KernelTimestamp t

func (v *interfaceManager) KernelTimestamp() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "KernelTimestamp",
	}
}

// property KernelTimestampMonotonic t

func (v *interfaceManager) KernelTimestampMonotonic() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "KernelTimestampMonotonic",
	}
}

// property InitRDTimestamp t

func (v *interfaceManager) InitRDTimestamp() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "InitRDTimestamp",
	}
}

// property InitRDTimestampMonotonic t

func (v *interfaceManager) InitRDTimestampMonotonic() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "InitRDTimestampMonotonic",
	}
}

// property UserspaceTimestamp t

func (v *interfaceManager) UserspaceTimestamp() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "UserspaceTimestamp",
	}
}

// property UserspaceTimestampMonotonic t

func (v *interfaceManager) UserspaceTimestampMonotonic() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "UserspaceTimestampMonotonic",
	}
}

// property FinishTimestamp t

func (v *interfaceManager) FinishTimestamp() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "FinishTimestamp",
	}
}

// property FinishTimestampMonotonic t

func (v *interfaceManager) FinishTimestampMonotonic() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "FinishTimestampMonotonic",
	}
}

// property SecurityStartTimestamp t

func (v *interfaceManager) SecurityStartTimestamp() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "SecurityStartTimestamp",
	}
}

// property SecurityStartTimestampMonotonic t

func (v *interfaceManager) SecurityStartTimestampMonotonic() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "SecurityStartTimestampMonotonic",
	}
}

// property SecurityFinishTimestamp t

func (v *interfaceManager) SecurityFinishTimestamp() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "SecurityFinishTimestamp",
	}
}

// property SecurityFinishTimestampMonotonic t

func (v *interfaceManager) SecurityFinishTimestampMonotonic() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "SecurityFinishTimestampMonotonic",
	}
}

// property GeneratorsStartTimestamp t

func (v *interfaceManager) GeneratorsStartTimestamp() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "GeneratorsStartTimestamp",
	}
}

// property GeneratorsStartTimestampMonotonic t

func (v *interfaceManager) GeneratorsStartTimestampMonotonic() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "GeneratorsStartTimestampMonotonic",
	}
}

// property GeneratorsFinishTimestamp t

func (v *interfaceManager) GeneratorsFinishTimestamp() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "GeneratorsFinishTimestamp",
	}
}

// property GeneratorsFinishTimestampMonotonic t

func (v *interfaceManager) GeneratorsFinishTimestampMonotonic() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "GeneratorsFinishTimestampMonotonic",
	}
}

// property UnitsLoadStartTimestamp t

func (v *interfaceManager) UnitsLoadStartTimestamp() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "UnitsLoadStartTimestamp",
	}
}

// property UnitsLoadStartTimestampMonotonic t

func (v *interfaceManager) UnitsLoadStartTimestampMonotonic() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "UnitsLoadStartTimestampMonotonic",
	}
}

// property UnitsLoadFinishTimestamp t

func (v *interfaceManager) UnitsLoadFinishTimestamp() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "UnitsLoadFinishTimestamp",
	}
}

// property UnitsLoadFinishTimestampMonotonic t

func (v *interfaceManager) UnitsLoadFinishTimestampMonotonic() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "UnitsLoadFinishTimestampMonotonic",
	}
}

// property InitRDSecurityStartTimestamp t

func (v *interfaceManager) InitRDSecurityStartTimestamp() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "InitRDSecurityStartTimestamp",
	}
}

// property InitRDSecurityStartTimestampMonotonic t

func (v *interfaceManager) InitRDSecurityStartTimestampMonotonic() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "InitRDSecurityStartTimestampMonotonic",
	}
}

// property InitRDSecurityFinishTimestamp t

func (v *interfaceManager) InitRDSecurityFinishTimestamp() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "InitRDSecurityFinishTimestamp",
	}
}

// property InitRDSecurityFinishTimestampMonotonic t

func (v *interfaceManager) InitRDSecurityFinishTimestampMonotonic() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "InitRDSecurityFinishTimestampMonotonic",
	}
}

// property InitRDGeneratorsStartTimestamp t

func (v *interfaceManager) InitRDGeneratorsStartTimestamp() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "InitRDGeneratorsStartTimestamp",
	}
}

// property InitRDGeneratorsStartTimestampMonotonic t

func (v *interfaceManager) InitRDGeneratorsStartTimestampMonotonic() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "InitRDGeneratorsStartTimestampMonotonic",
	}
}

// property InitRDGeneratorsFinishTimestamp t

func (v *interfaceManager) InitRDGeneratorsFinishTimestamp() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "InitRDGeneratorsFinishTimestamp",
	}
}

// property InitRDGeneratorsFinishTimestampMonotonic t

func (v *interfaceManager) InitRDGeneratorsFinishTimestampMonotonic() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "InitRDGeneratorsFinishTimestampMonotonic",
	}
}

// property InitRDUnitsLoadStartTimestamp t

func (v *interfaceManager) InitRDUnitsLoadStartTimestamp() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "InitRDUnitsLoadStartTimestamp",
	}
}

// property InitRDUnitsLoadStartTimestampMonotonic t

func (v *interfaceManager) InitRDUnitsLoadStartTimestampMonotonic() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "InitRDUnitsLoadStartTimestampMonotonic",
	}
}

// property InitRDUnitsLoadFinishTimestamp t

func (v *interfaceManager) InitRDUnitsLoadFinishTimestamp() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "InitRDUnitsLoadFinishTimestamp",
	}
}

// property InitRDUnitsLoadFinishTimestampMonotonic t

func (v *interfaceManager) InitRDUnitsLoadFinishTimestampMonotonic() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "InitRDUnitsLoadFinishTimestampMonotonic",
	}
}

// property LogLevel s

func (v *interfaceManager) LogLevel() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "LogLevel",
	}
}

// property LogTarget s

func (v *interfaceManager) LogTarget() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "LogTarget",
	}
}

// property NNames u

func (v *interfaceManager) NNames() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "NNames",
	}
}

// property NFailedUnits u

func (v *interfaceManager) NFailedUnits() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "NFailedUnits",
	}
}

// property NJobs u

func (v *interfaceManager) NJobs() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "NJobs",
	}
}

// property NInstalledJobs u

func (v *interfaceManager) NInstalledJobs() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "NInstalledJobs",
	}
}

// property NFailedJobs u

func (v *interfaceManager) NFailedJobs() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "NFailedJobs",
	}
}

// property Progress d

func (v *interfaceManager) Progress() proxy.PropDouble {
	return &proxy.ImplPropDouble{
		Impl: v,
		Name: "Progress",
	}
}

// property Environment as

func (v *interfaceManager) Environment() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "Environment",
	}
}

// property ConfirmSpawn b

func (v *interfaceManager) ConfirmSpawn() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "ConfirmSpawn",
	}
}

// property ShowStatus b

func (v *interfaceManager) ShowStatus() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "ShowStatus",
	}
}

// property UnitPath as

func (v *interfaceManager) UnitPath() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "UnitPath",
	}
}

// property DefaultStandardOutput s

func (v *interfaceManager) DefaultStandardOutput() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "DefaultStandardOutput",
	}
}

// property DefaultStandardError s

func (v *interfaceManager) DefaultStandardError() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "DefaultStandardError",
	}
}

// property RuntimeWatchdogUSec t

func (v *interfaceManager) RuntimeWatchdogUSec() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "RuntimeWatchdogUSec",
	}
}

// property ShutdownWatchdogUSec t

func (v *interfaceManager) ShutdownWatchdogUSec() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "ShutdownWatchdogUSec",
	}
}

// property ServiceWatchdogs b

func (v *interfaceManager) ServiceWatchdogs() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "ServiceWatchdogs",
	}
}

// property ControlGroup s

func (v *interfaceManager) ControlGroup() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "ControlGroup",
	}
}

// property SystemState s

func (v *interfaceManager) SystemState() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "SystemState",
	}
}

// property ExitCode y

func (v *interfaceManager) ExitCode() proxy.PropByte {
	return &proxy.ImplPropByte{
		Impl: v,
		Name: "ExitCode",
	}
}

// property DefaultTimerAccuracyUSec t

func (v *interfaceManager) DefaultTimerAccuracyUSec() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultTimerAccuracyUSec",
	}
}

// property DefaultTimeoutStartUSec t

func (v *interfaceManager) DefaultTimeoutStartUSec() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultTimeoutStartUSec",
	}
}

// property DefaultTimeoutStopUSec t

func (v *interfaceManager) DefaultTimeoutStopUSec() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultTimeoutStopUSec",
	}
}

// property DefaultRestartUSec t

func (v *interfaceManager) DefaultRestartUSec() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultRestartUSec",
	}
}

// property DefaultStartLimitIntervalUSec t

func (v *interfaceManager) DefaultStartLimitIntervalUSec() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultStartLimitIntervalUSec",
	}
}

// property DefaultStartLimitBurst u

func (v *interfaceManager) DefaultStartLimitBurst() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "DefaultStartLimitBurst",
	}
}

// property DefaultCPUAccounting b

func (v *interfaceManager) DefaultCPUAccounting() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "DefaultCPUAccounting",
	}
}

// property DefaultBlockIOAccounting b

func (v *interfaceManager) DefaultBlockIOAccounting() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "DefaultBlockIOAccounting",
	}
}

// property DefaultMemoryAccounting b

func (v *interfaceManager) DefaultMemoryAccounting() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "DefaultMemoryAccounting",
	}
}

// property DefaultTasksAccounting b

func (v *interfaceManager) DefaultTasksAccounting() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "DefaultTasksAccounting",
	}
}

// property DefaultLimitCPU t

func (v *interfaceManager) DefaultLimitCPU() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultLimitCPU",
	}
}

// property DefaultLimitCPUSoft t

func (v *interfaceManager) DefaultLimitCPUSoft() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultLimitCPUSoft",
	}
}

// property DefaultLimitFSIZE t

func (v *interfaceManager) DefaultLimitFSIZE() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultLimitFSIZE",
	}
}

// property DefaultLimitFSIZESoft t

func (v *interfaceManager) DefaultLimitFSIZESoft() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultLimitFSIZESoft",
	}
}

// property DefaultLimitDATA t

func (v *interfaceManager) DefaultLimitDATA() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultLimitDATA",
	}
}

// property DefaultLimitDATASoft t

func (v *interfaceManager) DefaultLimitDATASoft() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultLimitDATASoft",
	}
}

// property DefaultLimitSTACK t

func (v *interfaceManager) DefaultLimitSTACK() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultLimitSTACK",
	}
}

// property DefaultLimitSTACKSoft t

func (v *interfaceManager) DefaultLimitSTACKSoft() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultLimitSTACKSoft",
	}
}

// property DefaultLimitCORE t

func (v *interfaceManager) DefaultLimitCORE() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultLimitCORE",
	}
}

// property DefaultLimitCORESoft t

func (v *interfaceManager) DefaultLimitCORESoft() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultLimitCORESoft",
	}
}

// property DefaultLimitRSS t

func (v *interfaceManager) DefaultLimitRSS() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultLimitRSS",
	}
}

// property DefaultLimitRSSSoft t

func (v *interfaceManager) DefaultLimitRSSSoft() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultLimitRSSSoft",
	}
}

// property DefaultLimitNOFILE t

func (v *interfaceManager) DefaultLimitNOFILE() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultLimitNOFILE",
	}
}

// property DefaultLimitNOFILESoft t

func (v *interfaceManager) DefaultLimitNOFILESoft() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultLimitNOFILESoft",
	}
}

// property DefaultLimitAS t

func (v *interfaceManager) DefaultLimitAS() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultLimitAS",
	}
}

// property DefaultLimitASSoft t

func (v *interfaceManager) DefaultLimitASSoft() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultLimitASSoft",
	}
}

// property DefaultLimitNPROC t

func (v *interfaceManager) DefaultLimitNPROC() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultLimitNPROC",
	}
}

// property DefaultLimitNPROCSoft t

func (v *interfaceManager) DefaultLimitNPROCSoft() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultLimitNPROCSoft",
	}
}

// property DefaultLimitMEMLOCK t

func (v *interfaceManager) DefaultLimitMEMLOCK() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultLimitMEMLOCK",
	}
}

// property DefaultLimitMEMLOCKSoft t

func (v *interfaceManager) DefaultLimitMEMLOCKSoft() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultLimitMEMLOCKSoft",
	}
}

// property DefaultLimitLOCKS t

func (v *interfaceManager) DefaultLimitLOCKS() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultLimitLOCKS",
	}
}

// property DefaultLimitLOCKSSoft t

func (v *interfaceManager) DefaultLimitLOCKSSoft() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultLimitLOCKSSoft",
	}
}

// property DefaultLimitSIGPENDING t

func (v *interfaceManager) DefaultLimitSIGPENDING() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultLimitSIGPENDING",
	}
}

// property DefaultLimitSIGPENDINGSoft t

func (v *interfaceManager) DefaultLimitSIGPENDINGSoft() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultLimitSIGPENDINGSoft",
	}
}

// property DefaultLimitMSGQUEUE t

func (v *interfaceManager) DefaultLimitMSGQUEUE() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultLimitMSGQUEUE",
	}
}

// property DefaultLimitMSGQUEUESoft t

func (v *interfaceManager) DefaultLimitMSGQUEUESoft() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultLimitMSGQUEUESoft",
	}
}

// property DefaultLimitNICE t

func (v *interfaceManager) DefaultLimitNICE() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultLimitNICE",
	}
}

// property DefaultLimitNICESoft t

func (v *interfaceManager) DefaultLimitNICESoft() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultLimitNICESoft",
	}
}

// property DefaultLimitRTPRIO t

func (v *interfaceManager) DefaultLimitRTPRIO() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultLimitRTPRIO",
	}
}

// property DefaultLimitRTPRIOSoft t

func (v *interfaceManager) DefaultLimitRTPRIOSoft() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultLimitRTPRIOSoft",
	}
}

// property DefaultLimitRTTIME t

func (v *interfaceManager) DefaultLimitRTTIME() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultLimitRTTIME",
	}
}

// property DefaultLimitRTTIMESoft t

func (v *interfaceManager) DefaultLimitRTTIMESoft() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultLimitRTTIMESoft",
	}
}

// property DefaultTasksMax t

func (v *interfaceManager) DefaultTasksMax() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DefaultTasksMax",
	}
}

// property TimerSlackNSec t

func (v *interfaceManager) TimerSlackNSec() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "TimerSlackNSec",
	}
}

type Unit interface {
	Unit() unit       // interface org.freedesktop.systemd1.Unit
	Service() service // interface org.freedesktop.systemd1.Service
	proxy.Object
}

type objectUnit struct {
	interfaceUnit    // interface org.freedesktop.systemd1.Unit
	interfaceService // interface org.freedesktop.systemd1.Service
	proxy.ImplObject
}

func NewUnit(conn *dbus.Conn, path dbus.ObjectPath) (Unit, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectUnit)
	obj.ImplObject.Init_(conn, "org.freedesktop.systemd1", path)
	return obj, nil
}

func (obj *objectUnit) Unit() unit {
	return &obj.interfaceUnit
}

type unit interface {
	GoStart(flags dbus.Flags, ch chan *dbus.Call, mode string) *dbus.Call
	Start(flags dbus.Flags, mode string) (dbus.ObjectPath, error)
	GoStop(flags dbus.Flags, ch chan *dbus.Call, mode string) *dbus.Call
	Stop(flags dbus.Flags, mode string) (dbus.ObjectPath, error)
	GoReload(flags dbus.Flags, ch chan *dbus.Call, mode string) *dbus.Call
	Reload(flags dbus.Flags, mode string) (dbus.ObjectPath, error)
	GoRestart(flags dbus.Flags, ch chan *dbus.Call, mode string) *dbus.Call
	Restart(flags dbus.Flags, mode string) (dbus.ObjectPath, error)
	GoTryRestart(flags dbus.Flags, ch chan *dbus.Call, mode string) *dbus.Call
	TryRestart(flags dbus.Flags, mode string) (dbus.ObjectPath, error)
	GoReloadOrRestart(flags dbus.Flags, ch chan *dbus.Call, mode string) *dbus.Call
	ReloadOrRestart(flags dbus.Flags, mode string) (dbus.ObjectPath, error)
	GoReloadOrTryRestart(flags dbus.Flags, ch chan *dbus.Call, mode string) *dbus.Call
	ReloadOrTryRestart(flags dbus.Flags, mode string) (dbus.ObjectPath, error)
	GoKill(flags dbus.Flags, ch chan *dbus.Call, who string, signal int32) *dbus.Call
	Kill(flags dbus.Flags, who string, signal int32) error
	GoResetFailed(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	ResetFailed(flags dbus.Flags) error
	GoSetProperties(flags dbus.Flags, ch chan *dbus.Call, runtime bool, properties []Property) *dbus.Call
	SetProperties(flags dbus.Flags, runtime bool, properties []Property) error
	GoRef(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Ref(flags dbus.Flags) error
	GoUnref(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Unref(flags dbus.Flags) error
	Id() proxy.PropString
	Names() proxy.PropStringArray
	Following() proxy.PropString
	Requires() proxy.PropStringArray
	Requisite() proxy.PropStringArray
	Wants() proxy.PropStringArray
	BindsTo() proxy.PropStringArray
	PartOf() proxy.PropStringArray
	RequiredBy() proxy.PropStringArray
	RequisiteOf() proxy.PropStringArray
	WantedBy() proxy.PropStringArray
	BoundBy() proxy.PropStringArray
	ConsistsOf() proxy.PropStringArray
	Conflicts() proxy.PropStringArray
	ConflictedBy() proxy.PropStringArray
	Before() proxy.PropStringArray
	After() proxy.PropStringArray
	OnFailure() proxy.PropStringArray
	Triggers() proxy.PropStringArray
	TriggeredBy() proxy.PropStringArray
	PropagatesReloadTo() proxy.PropStringArray
	ReloadPropagatedFrom() proxy.PropStringArray
	JoinsNamespaceOf() proxy.PropStringArray
	RequiresMountsFor() proxy.PropStringArray
	Documentation() proxy.PropStringArray
	Description() proxy.PropString
	LoadState() proxy.PropString
	ActiveState() proxy.PropString
	SubState() proxy.PropString
	FragmentPath() proxy.PropString
	SourcePath() proxy.PropString
	DropInPaths() proxy.PropStringArray
	UnitFileState() proxy.PropString
	UnitFilePreset() proxy.PropString
	StateChangeTimestamp() proxy.PropUint64
	StateChangeTimestampMonotonic() proxy.PropUint64
	InactiveExitTimestamp() proxy.PropUint64
	InactiveExitTimestampMonotonic() proxy.PropUint64
	ActiveEnterTimestamp() proxy.PropUint64
	ActiveEnterTimestampMonotonic() proxy.PropUint64
	ActiveExitTimestamp() proxy.PropUint64
	ActiveExitTimestampMonotonic() proxy.PropUint64
	InactiveEnterTimestamp() proxy.PropUint64
	InactiveEnterTimestampMonotonic() proxy.PropUint64
	CanStart() proxy.PropBool
	CanStop() proxy.PropBool
	CanReload() proxy.PropBool
	CanIsolate() proxy.PropBool
	Job() PropUnitJob
	StopWhenUnneeded() proxy.PropBool
	RefuseManualStart() proxy.PropBool
	RefuseManualStop() proxy.PropBool
	AllowIsolate() proxy.PropBool
	DefaultDependencies() proxy.PropBool
	OnFailureJobMode() proxy.PropString
	IgnoreOnIsolate() proxy.PropBool
	NeedDaemonReload() proxy.PropBool
	JobTimeoutUSec() proxy.PropUint64
	JobRunningTimeoutUSec() proxy.PropUint64
	JobTimeoutAction() proxy.PropString
	JobTimeoutRebootArgument() proxy.PropString
	ConditionResult() proxy.PropBool
	AssertResult() proxy.PropBool
	ConditionTimestamp() proxy.PropUint64
	ConditionTimestampMonotonic() proxy.PropUint64
	AssertTimestamp() proxy.PropUint64
	AssertTimestampMonotonic() proxy.PropUint64
	Conditions() PropUnitConditions
	Asserts() PropUnitAsserts
	LoadError() PropUnitLoadError
	Transient() proxy.PropBool
	Perpetual() proxy.PropBool
	StartLimitIntervalUSec() proxy.PropUint64
	StartLimitBurst() proxy.PropUint32
	StartLimitAction() proxy.PropString
	FailureAction() proxy.PropString
	FailureActionExitStatus() proxy.PropInt32
	SuccessAction() proxy.PropString
	SuccessActionExitStatus() proxy.PropInt32
	RebootArgument() proxy.PropString
	InvocationID() proxy.PropByteArray
	CollectMode() proxy.PropString
	Refs() proxy.PropStringArray
}

type interfaceUnit struct{}

func (v *interfaceUnit) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceUnit) GetInterfaceName_() string {
	return "org.freedesktop.systemd1.Unit"
}

// method Start

func (v *interfaceUnit) GoStart(flags dbus.Flags, ch chan *dbus.Call, mode string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Start", flags, ch, mode)
}

func (*interfaceUnit) StoreStart(call *dbus.Call) (job dbus.ObjectPath, err error) {
	err = call.Store(&job)
	return
}

func (v *interfaceUnit) Start(flags dbus.Flags, mode string) (dbus.ObjectPath, error) {
	return v.StoreStart(
		<-v.GoStart(flags, make(chan *dbus.Call, 1), mode).Done)
}

// method Stop

func (v *interfaceUnit) GoStop(flags dbus.Flags, ch chan *dbus.Call, mode string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Stop", flags, ch, mode)
}

func (*interfaceUnit) StoreStop(call *dbus.Call) (job dbus.ObjectPath, err error) {
	err = call.Store(&job)
	return
}

func (v *interfaceUnit) Stop(flags dbus.Flags, mode string) (dbus.ObjectPath, error) {
	return v.StoreStop(
		<-v.GoStop(flags, make(chan *dbus.Call, 1), mode).Done)
}

// method Reload

func (v *interfaceUnit) GoReload(flags dbus.Flags, ch chan *dbus.Call, mode string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Reload", flags, ch, mode)
}

func (*interfaceUnit) StoreReload(call *dbus.Call) (job dbus.ObjectPath, err error) {
	err = call.Store(&job)
	return
}

func (v *interfaceUnit) Reload(flags dbus.Flags, mode string) (dbus.ObjectPath, error) {
	return v.StoreReload(
		<-v.GoReload(flags, make(chan *dbus.Call, 1), mode).Done)
}

// method Restart

func (v *interfaceUnit) GoRestart(flags dbus.Flags, ch chan *dbus.Call, mode string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Restart", flags, ch, mode)
}

func (*interfaceUnit) StoreRestart(call *dbus.Call) (job dbus.ObjectPath, err error) {
	err = call.Store(&job)
	return
}

func (v *interfaceUnit) Restart(flags dbus.Flags, mode string) (dbus.ObjectPath, error) {
	return v.StoreRestart(
		<-v.GoRestart(flags, make(chan *dbus.Call, 1), mode).Done)
}

// method TryRestart

func (v *interfaceUnit) GoTryRestart(flags dbus.Flags, ch chan *dbus.Call, mode string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".TryRestart", flags, ch, mode)
}

func (*interfaceUnit) StoreTryRestart(call *dbus.Call) (job dbus.ObjectPath, err error) {
	err = call.Store(&job)
	return
}

func (v *interfaceUnit) TryRestart(flags dbus.Flags, mode string) (dbus.ObjectPath, error) {
	return v.StoreTryRestart(
		<-v.GoTryRestart(flags, make(chan *dbus.Call, 1), mode).Done)
}

// method ReloadOrRestart

func (v *interfaceUnit) GoReloadOrRestart(flags dbus.Flags, ch chan *dbus.Call, mode string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ReloadOrRestart", flags, ch, mode)
}

func (*interfaceUnit) StoreReloadOrRestart(call *dbus.Call) (job dbus.ObjectPath, err error) {
	err = call.Store(&job)
	return
}

func (v *interfaceUnit) ReloadOrRestart(flags dbus.Flags, mode string) (dbus.ObjectPath, error) {
	return v.StoreReloadOrRestart(
		<-v.GoReloadOrRestart(flags, make(chan *dbus.Call, 1), mode).Done)
}

// method ReloadOrTryRestart

func (v *interfaceUnit) GoReloadOrTryRestart(flags dbus.Flags, ch chan *dbus.Call, mode string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ReloadOrTryRestart", flags, ch, mode)
}

func (*interfaceUnit) StoreReloadOrTryRestart(call *dbus.Call) (job dbus.ObjectPath, err error) {
	err = call.Store(&job)
	return
}

func (v *interfaceUnit) ReloadOrTryRestart(flags dbus.Flags, mode string) (dbus.ObjectPath, error) {
	return v.StoreReloadOrTryRestart(
		<-v.GoReloadOrTryRestart(flags, make(chan *dbus.Call, 1), mode).Done)
}

// method Kill

func (v *interfaceUnit) GoKill(flags dbus.Flags, ch chan *dbus.Call, who string, signal int32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Kill", flags, ch, who, signal)
}

func (v *interfaceUnit) Kill(flags dbus.Flags, who string, signal int32) error {
	return (<-v.GoKill(flags, make(chan *dbus.Call, 1), who, signal).Done).Err
}

// method ResetFailed

func (v *interfaceUnit) GoResetFailed(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ResetFailed", flags, ch)
}

func (v *interfaceUnit) ResetFailed(flags dbus.Flags) error {
	return (<-v.GoResetFailed(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method SetProperties

func (v *interfaceUnit) GoSetProperties(flags dbus.Flags, ch chan *dbus.Call, runtime bool, properties []Property) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetProperties", flags, ch, runtime, properties)
}

func (v *interfaceUnit) SetProperties(flags dbus.Flags, runtime bool, properties []Property) error {
	return (<-v.GoSetProperties(flags, make(chan *dbus.Call, 1), runtime, properties).Done).Err
}

// method Ref

func (v *interfaceUnit) GoRef(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Ref", flags, ch)
}

func (v *interfaceUnit) Ref(flags dbus.Flags) error {
	return (<-v.GoRef(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method Unref

func (v *interfaceUnit) GoUnref(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Unref", flags, ch)
}

func (v *interfaceUnit) Unref(flags dbus.Flags) error {
	return (<-v.GoUnref(flags, make(chan *dbus.Call, 1)).Done).Err
}

// property Id s

func (v *interfaceUnit) Id() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Id",
	}
}

// property Names as

func (v *interfaceUnit) Names() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "Names",
	}
}

// property Following s

func (v *interfaceUnit) Following() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Following",
	}
}

// property Requires as

func (v *interfaceUnit) Requires() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "Requires",
	}
}

// property Requisite as

func (v *interfaceUnit) Requisite() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "Requisite",
	}
}

// property Wants as

func (v *interfaceUnit) Wants() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "Wants",
	}
}

// property BindsTo as

func (v *interfaceUnit) BindsTo() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "BindsTo",
	}
}

// property PartOf as

func (v *interfaceUnit) PartOf() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "PartOf",
	}
}

// property RequiredBy as

func (v *interfaceUnit) RequiredBy() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "RequiredBy",
	}
}

// property RequisiteOf as

func (v *interfaceUnit) RequisiteOf() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "RequisiteOf",
	}
}

// property WantedBy as

func (v *interfaceUnit) WantedBy() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "WantedBy",
	}
}

// property BoundBy as

func (v *interfaceUnit) BoundBy() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "BoundBy",
	}
}

// property ConsistsOf as

func (v *interfaceUnit) ConsistsOf() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "ConsistsOf",
	}
}

// property Conflicts as

func (v *interfaceUnit) Conflicts() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "Conflicts",
	}
}

// property ConflictedBy as

func (v *interfaceUnit) ConflictedBy() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "ConflictedBy",
	}
}

// property Before as

func (v *interfaceUnit) Before() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "Before",
	}
}

// property After as

func (v *interfaceUnit) After() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "After",
	}
}

// property OnFailure as

func (v *interfaceUnit) OnFailure() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "OnFailure",
	}
}

// property Triggers as

func (v *interfaceUnit) Triggers() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "Triggers",
	}
}

// property TriggeredBy as

func (v *interfaceUnit) TriggeredBy() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "TriggeredBy",
	}
}

// property PropagatesReloadTo as

func (v *interfaceUnit) PropagatesReloadTo() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "PropagatesReloadTo",
	}
}

// property ReloadPropagatedFrom as

func (v *interfaceUnit) ReloadPropagatedFrom() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "ReloadPropagatedFrom",
	}
}

// property JoinsNamespaceOf as

func (v *interfaceUnit) JoinsNamespaceOf() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "JoinsNamespaceOf",
	}
}

// property RequiresMountsFor as

func (v *interfaceUnit) RequiresMountsFor() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "RequiresMountsFor",
	}
}

// property Documentation as

func (v *interfaceUnit) Documentation() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "Documentation",
	}
}

// property Description s

func (v *interfaceUnit) Description() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Description",
	}
}

// property LoadState s

func (v *interfaceUnit) LoadState() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "LoadState",
	}
}

// property ActiveState s

func (v *interfaceUnit) ActiveState() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "ActiveState",
	}
}

// property SubState s

func (v *interfaceUnit) SubState() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "SubState",
	}
}

// property FragmentPath s

func (v *interfaceUnit) FragmentPath() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "FragmentPath",
	}
}

// property SourcePath s

func (v *interfaceUnit) SourcePath() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "SourcePath",
	}
}

// property DropInPaths as

func (v *interfaceUnit) DropInPaths() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "DropInPaths",
	}
}

// property UnitFileState s

func (v *interfaceUnit) UnitFileState() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "UnitFileState",
	}
}

// property UnitFilePreset s

func (v *interfaceUnit) UnitFilePreset() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "UnitFilePreset",
	}
}

// property StateChangeTimestamp t

func (v *interfaceUnit) StateChangeTimestamp() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "StateChangeTimestamp",
	}
}

// property StateChangeTimestampMonotonic t

func (v *interfaceUnit) StateChangeTimestampMonotonic() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "StateChangeTimestampMonotonic",
	}
}

// property InactiveExitTimestamp t

func (v *interfaceUnit) InactiveExitTimestamp() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "InactiveExitTimestamp",
	}
}

// property InactiveExitTimestampMonotonic t

func (v *interfaceUnit) InactiveExitTimestampMonotonic() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "InactiveExitTimestampMonotonic",
	}
}

// property ActiveEnterTimestamp t

func (v *interfaceUnit) ActiveEnterTimestamp() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "ActiveEnterTimestamp",
	}
}

// property ActiveEnterTimestampMonotonic t

func (v *interfaceUnit) ActiveEnterTimestampMonotonic() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "ActiveEnterTimestampMonotonic",
	}
}

// property ActiveExitTimestamp t

func (v *interfaceUnit) ActiveExitTimestamp() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "ActiveExitTimestamp",
	}
}

// property ActiveExitTimestampMonotonic t

func (v *interfaceUnit) ActiveExitTimestampMonotonic() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "ActiveExitTimestampMonotonic",
	}
}

// property InactiveEnterTimestamp t

func (v *interfaceUnit) InactiveEnterTimestamp() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "InactiveEnterTimestamp",
	}
}

// property InactiveEnterTimestampMonotonic t

func (v *interfaceUnit) InactiveEnterTimestampMonotonic() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "InactiveEnterTimestampMonotonic",
	}
}

// property CanStart b

func (v *interfaceUnit) CanStart() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "CanStart",
	}
}

// property CanStop b

func (v *interfaceUnit) CanStop() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "CanStop",
	}
}

// property CanReload b

func (v *interfaceUnit) CanReload() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "CanReload",
	}
}

// property CanIsolate b

func (v *interfaceUnit) CanIsolate() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "CanIsolate",
	}
}

type PropUnitJob interface {
	Get(flags dbus.Flags) (value JobIdPath, err error)
	Set(flags dbus.Flags, value JobIdPath) error
	ConnectChanged(cb func(hasValue bool, value JobIdPath)) error
}

type implPropUnitJob struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropUnitJob) Get(flags dbus.Flags) (value JobIdPath, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropUnitJob) Set(flags dbus.Flags, value JobIdPath) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropUnitJob) ConnectChanged(cb func(hasValue bool, value JobIdPath)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v JobIdPath
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, JobIdPath{})
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

// property Job (uo)

func (v *interfaceUnit) Job() PropUnitJob {
	return &implPropUnitJob{
		Impl: v,
		Name: "Job",
	}
}

// property StopWhenUnneeded b

func (v *interfaceUnit) StopWhenUnneeded() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "StopWhenUnneeded",
	}
}

// property RefuseManualStart b

func (v *interfaceUnit) RefuseManualStart() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "RefuseManualStart",
	}
}

// property RefuseManualStop b

func (v *interfaceUnit) RefuseManualStop() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "RefuseManualStop",
	}
}

// property AllowIsolate b

func (v *interfaceUnit) AllowIsolate() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "AllowIsolate",
	}
}

// property DefaultDependencies b

func (v *interfaceUnit) DefaultDependencies() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "DefaultDependencies",
	}
}

// property OnFailureJobMode s

func (v *interfaceUnit) OnFailureJobMode() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "OnFailureJobMode",
	}
}

// property IgnoreOnIsolate b

func (v *interfaceUnit) IgnoreOnIsolate() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "IgnoreOnIsolate",
	}
}

// property NeedDaemonReload b

func (v *interfaceUnit) NeedDaemonReload() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "NeedDaemonReload",
	}
}

// property JobTimeoutUSec t

func (v *interfaceUnit) JobTimeoutUSec() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "JobTimeoutUSec",
	}
}

// property JobRunningTimeoutUSec t

func (v *interfaceUnit) JobRunningTimeoutUSec() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "JobRunningTimeoutUSec",
	}
}

// property JobTimeoutAction s

func (v *interfaceUnit) JobTimeoutAction() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "JobTimeoutAction",
	}
}

// property JobTimeoutRebootArgument s

func (v *interfaceUnit) JobTimeoutRebootArgument() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "JobTimeoutRebootArgument",
	}
}

// property ConditionResult b

func (v *interfaceUnit) ConditionResult() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "ConditionResult",
	}
}

// property AssertResult b

func (v *interfaceUnit) AssertResult() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "AssertResult",
	}
}

// property ConditionTimestamp t

func (v *interfaceUnit) ConditionTimestamp() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "ConditionTimestamp",
	}
}

// property ConditionTimestampMonotonic t

func (v *interfaceUnit) ConditionTimestampMonotonic() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "ConditionTimestampMonotonic",
	}
}

// property AssertTimestamp t

func (v *interfaceUnit) AssertTimestamp() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "AssertTimestamp",
	}
}

// property AssertTimestampMonotonic t

func (v *interfaceUnit) AssertTimestampMonotonic() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "AssertTimestampMonotonic",
	}
}

type PropUnitConditions interface {
	Get(flags dbus.Flags) (value []Condition, err error)
	Set(flags dbus.Flags, value []Condition) error
	ConnectChanged(cb func(hasValue bool, value []Condition)) error
}

type implPropUnitConditions struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropUnitConditions) Get(flags dbus.Flags) (value []Condition, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropUnitConditions) Set(flags dbus.Flags, value []Condition) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropUnitConditions) ConnectChanged(cb func(hasValue bool, value []Condition)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v []Condition
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, nil)
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

// property Conditions a(sbbsi)

func (v *interfaceUnit) Conditions() PropUnitConditions {
	return &implPropUnitConditions{
		Impl: v,
		Name: "Conditions",
	}
}

type PropUnitAsserts interface {
	Get(flags dbus.Flags) (value []Assert, err error)
	Set(flags dbus.Flags, value []Assert) error
	ConnectChanged(cb func(hasValue bool, value []Assert)) error
}

type implPropUnitAsserts struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropUnitAsserts) Get(flags dbus.Flags) (value []Assert, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropUnitAsserts) Set(flags dbus.Flags, value []Assert) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropUnitAsserts) ConnectChanged(cb func(hasValue bool, value []Assert)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v []Assert
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, nil)
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

// property Asserts a(sbbsi)

func (v *interfaceUnit) Asserts() PropUnitAsserts {
	return &implPropUnitAsserts{
		Impl: v,
		Name: "Asserts",
	}
}

type PropUnitLoadError interface {
	Get(flags dbus.Flags) (value LoadError, err error)
	Set(flags dbus.Flags, value LoadError) error
	ConnectChanged(cb func(hasValue bool, value LoadError)) error
}

type implPropUnitLoadError struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropUnitLoadError) Get(flags dbus.Flags) (value LoadError, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropUnitLoadError) Set(flags dbus.Flags, value LoadError) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropUnitLoadError) ConnectChanged(cb func(hasValue bool, value LoadError)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v LoadError
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, LoadError{})
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

// property LoadError (ss)

func (v *interfaceUnit) LoadError() PropUnitLoadError {
	return &implPropUnitLoadError{
		Impl: v,
		Name: "LoadError",
	}
}

// property Transient b

func (v *interfaceUnit) Transient() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Transient",
	}
}

// property Perpetual b

func (v *interfaceUnit) Perpetual() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Perpetual",
	}
}

// property StartLimitIntervalUSec t

func (v *interfaceUnit) StartLimitIntervalUSec() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "StartLimitIntervalUSec",
	}
}

// property StartLimitBurst u

func (v *interfaceUnit) StartLimitBurst() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "StartLimitBurst",
	}
}

// property StartLimitAction s

func (v *interfaceUnit) StartLimitAction() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "StartLimitAction",
	}
}

// property FailureAction s

func (v *interfaceUnit) FailureAction() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "FailureAction",
	}
}

// property FailureActionExitStatus i

func (v *interfaceUnit) FailureActionExitStatus() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "FailureActionExitStatus",
	}
}

// property SuccessAction s

func (v *interfaceUnit) SuccessAction() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "SuccessAction",
	}
}

// property SuccessActionExitStatus i

func (v *interfaceUnit) SuccessActionExitStatus() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "SuccessActionExitStatus",
	}
}

// property RebootArgument s

func (v *interfaceUnit) RebootArgument() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "RebootArgument",
	}
}

// property InvocationID ay

func (v *interfaceUnit) InvocationID() proxy.PropByteArray {
	return &proxy.ImplPropByteArray{
		Impl: v,
		Name: "InvocationID",
	}
}

// property CollectMode s

func (v *interfaceUnit) CollectMode() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "CollectMode",
	}
}

// property Refs as

func (v *interfaceUnit) Refs() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "Refs",
	}
}

func (obj *objectUnit) Service() service {
	return &obj.interfaceService
}

type service interface {
	GoGetProcesses(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	GetProcesses(flags dbus.Flags) ([]UnitProcess, error)
	GoAttachProcesses(flags dbus.Flags, ch chan *dbus.Call, arg0 string, arg1 []uint32) *dbus.Call
	AttachProcesses(flags dbus.Flags, arg0 string, arg1 []uint32) error
	Type() proxy.PropString
	Restart() proxy.PropString
	PIDFile() proxy.PropString
	NotifyAccess() proxy.PropString
	RestartUSec() proxy.PropUint64
	TimeoutStartUSec() proxy.PropUint64
	TimeoutStopUSec() proxy.PropUint64
	RuntimeMaxUSec() proxy.PropUint64
	WatchdogUSec() proxy.PropUint64
	WatchdogTimestamp() proxy.PropUint64
	WatchdogTimestampMonotonic() proxy.PropUint64
	RootDirectoryStartOnly() proxy.PropBool
	RemainAfterExit() proxy.PropBool
	GuessMainPID() proxy.PropBool
	RestartPreventExitStatus() PropExitStatus
	RestartForceExitStatus() PropExitStatus
	SuccessExitStatus() PropExitStatus
	MainPID() proxy.PropUint32
	ControlPID() proxy.PropUint32
	BusName() proxy.PropString
	FileDescriptorStoreMax() proxy.PropUint32
	NFileDescriptorStore() proxy.PropUint32
	StatusText() proxy.PropString
	StatusErrno() proxy.PropInt32
	Result() proxy.PropString
	USBFunctionDescriptors() proxy.PropString
	USBFunctionStrings() proxy.PropString
	UID() proxy.PropUint32
	GID() proxy.PropUint32
	NRestarts() proxy.PropUint32
	ExecMainStartTimestamp() proxy.PropUint64
	ExecMainStartTimestampMonotonic() proxy.PropUint64
	ExecMainExitTimestamp() proxy.PropUint64
	ExecMainExitTimestampMonotonic() proxy.PropUint64
	ExecMainPID() proxy.PropUint32
	ExecMainCode() proxy.PropInt32
	ExecMainStatus() proxy.PropInt32
	ExecStartPre() PropExecInfos
	ExecStart() PropExecInfos
	ExecStartPost() PropExecInfos
	ExecReload() PropExecInfos
	ExecStop() PropExecInfos
	ExecStopPost() PropExecInfos
	Slice() proxy.PropString
	ControlGroup() proxy.PropString
	MemoryCurrent() proxy.PropUint64
	CPUUsageNSec() proxy.PropUint64
	TasksCurrent() proxy.PropUint64
	IPIngressBytes() proxy.PropUint64
	IPIngressPackets() proxy.PropUint64
	IPEgressBytes() proxy.PropUint64
	IPEgressPackets() proxy.PropUint64
	Delegate() proxy.PropBool
	DelegateControllers() proxy.PropStringArray
	CPUAccounting() proxy.PropBool
	CPUWeight() proxy.PropUint64
	StartupCPUWeight() proxy.PropUint64
	CPUShares() proxy.PropUint64
	StartupCPUShares() proxy.PropUint64
	CPUQuotaPerSecUSec() proxy.PropUint64
	IOAccounting() proxy.PropBool
	IOWeight() proxy.PropUint64
	StartupIOWeight() proxy.PropUint64
	IODeviceWeight() PropIOParams
	IOReadBandwidthMax() PropIOParams
	IOWriteBandwidthMax() PropIOParams
	IOReadIOPSMax() PropIOParams
	IOWriteIOPSMax() PropIOParams
	IODeviceLatencyTargetUSec() PropIOParams
	BlockIOAccounting() proxy.PropBool
	BlockIOWeight() proxy.PropUint64
	StartupBlockIOWeight() proxy.PropUint64
	BlockIODeviceWeight() PropIOParams
	BlockIOReadBandwidth() PropIOParams
	BlockIOWriteBandwidth() PropIOParams
	MemoryAccounting() proxy.PropBool
	MemoryMin() proxy.PropUint64
	MemoryLow() proxy.PropUint64
	MemoryHigh() proxy.PropUint64
	MemoryMax() proxy.PropUint64
	MemorySwapMax() proxy.PropUint64
	MemoryLimit() proxy.PropUint64
	DevicePolicy() proxy.PropString
	DeviceAllow() PropServiceDeviceAllow
	TasksAccounting() proxy.PropBool
	TasksMax() proxy.PropUint64
	IPAccounting() proxy.PropBool
	IPAddressAllow() PropServiceIPAddressAllow
	IPAddressDeny() PropServiceIPAddressDeny
	DisableControllers() proxy.PropStringArray
	Environment() proxy.PropStringArray
	EnvironmentFiles() PropEnvironmentFiles
	PassEnvironment() proxy.PropStringArray
	UnsetEnvironment() proxy.PropStringArray
	UMask() proxy.PropUint32
	LimitCPU() proxy.PropUint64
	LimitCPUSoft() proxy.PropUint64
	LimitFSIZE() proxy.PropUint64
	LimitFSIZESoft() proxy.PropUint64
	LimitDATA() proxy.PropUint64
	LimitDATASoft() proxy.PropUint64
	LimitSTACK() proxy.PropUint64
	LimitSTACKSoft() proxy.PropUint64
	LimitCORE() proxy.PropUint64
	LimitCORESoft() proxy.PropUint64
	LimitRSS() proxy.PropUint64
	LimitRSSSoft() proxy.PropUint64
	LimitNOFILE() proxy.PropUint64
	LimitNOFILESoft() proxy.PropUint64
	LimitAS() proxy.PropUint64
	LimitASSoft() proxy.PropUint64
	LimitNPROC() proxy.PropUint64
	LimitNPROCSoft() proxy.PropUint64
	LimitMEMLOCK() proxy.PropUint64
	LimitMEMLOCKSoft() proxy.PropUint64
	LimitLOCKS() proxy.PropUint64
	LimitLOCKSSoft() proxy.PropUint64
	LimitSIGPENDING() proxy.PropUint64
	LimitSIGPENDINGSoft() proxy.PropUint64
	LimitMSGQUEUE() proxy.PropUint64
	LimitMSGQUEUESoft() proxy.PropUint64
	LimitNICE() proxy.PropUint64
	LimitNICESoft() proxy.PropUint64
	LimitRTPRIO() proxy.PropUint64
	LimitRTPRIOSoft() proxy.PropUint64
	LimitRTTIME() proxy.PropUint64
	LimitRTTIMESoft() proxy.PropUint64
	WorkingDirectory() proxy.PropString
	RootDirectory() proxy.PropString
	RootImage() proxy.PropString
	OOMScoreAdjust() proxy.PropInt32
	Nice() proxy.PropInt32
	IOSchedulingClass() proxy.PropInt32
	IOSchedulingPriority() proxy.PropInt32
	CPUSchedulingPolicy() proxy.PropInt32
	CPUSchedulingPriority() proxy.PropInt32
	CPUAffinity() proxy.PropByteArray
	TimerSlackNSec() proxy.PropUint64
	CPUSchedulingResetOnFork() proxy.PropBool
	NonBlocking() proxy.PropBool
	StandardInput() proxy.PropString
	StandardInputFileDescriptorName() proxy.PropString
	StandardInputData() proxy.PropByteArray
	StandardOutput() proxy.PropString
	StandardOutputFileDescriptorName() proxy.PropString
	StandardError() proxy.PropString
	StandardErrorFileDescriptorName() proxy.PropString
	TTYPath() proxy.PropString
	TTYReset() proxy.PropBool
	TTYVHangup() proxy.PropBool
	TTYVTDisallocate() proxy.PropBool
	SyslogPriority() proxy.PropInt32
	SyslogIdentifier() proxy.PropString
	SyslogLevelPrefix() proxy.PropBool
	SyslogLevel() proxy.PropInt32
	SyslogFacility() proxy.PropInt32
	LogLevelMax() proxy.PropInt32
	LogRateLimitIntervalUSec() proxy.PropUint64
	LogRateLimitBurst() proxy.PropUint32
	LogExtraFields() PropServiceLogExtraFields
	SecureBits() proxy.PropInt32
	CapabilityBoundingSet() proxy.PropUint64
	AmbientCapabilities() proxy.PropUint64
	User() proxy.PropString
	Group() proxy.PropString
	DynamicUser() proxy.PropBool
	RemoveIPC() proxy.PropBool
	SupplementaryGroups() proxy.PropStringArray
	PAMName() proxy.PropString
	ReadWritePaths() proxy.PropStringArray
	ReadOnlyPaths() proxy.PropStringArray
	InaccessiblePaths() proxy.PropStringArray
	MountFlags() proxy.PropUint64
	PrivateTmp() proxy.PropBool
	PrivateDevices() proxy.PropBool
	ProtectKernelTunables() proxy.PropBool
	ProtectKernelModules() proxy.PropBool
	ProtectControlGroups() proxy.PropBool
	PrivateNetwork() proxy.PropBool
	PrivateUsers() proxy.PropBool
	PrivateMounts() proxy.PropBool
	ProtectHome() proxy.PropString
	ProtectSystem() proxy.PropString
	SameProcessGroup() proxy.PropBool
	UtmpIdentifier() proxy.PropString
	UtmpMode() proxy.PropString
	SELinuxContext() PropBS
	AppArmorProfile() PropBS
	SmackProcessLabel() PropBS
	IgnoreSIGPIPE() proxy.PropBool
	NoNewPrivileges() proxy.PropBool
	SystemCallFilter() PropServiceSystemCallFilter
	SystemCallArchitectures() proxy.PropStringArray
	SystemCallErrorNumber() proxy.PropInt32
	Personality() proxy.PropString
	LockPersonality() proxy.PropBool
	RestrictAddressFamilies() PropServiceRestrictAddressFamilies
	RuntimeDirectoryPreserve() proxy.PropString
	RuntimeDirectoryMode() proxy.PropUint32
	RuntimeDirectory() proxy.PropStringArray
	StateDirectoryMode() proxy.PropUint32
	StateDirectory() proxy.PropStringArray
	CacheDirectoryMode() proxy.PropUint32
	CacheDirectory() proxy.PropStringArray
	LogsDirectoryMode() proxy.PropUint32
	LogsDirectory() proxy.PropStringArray
	ConfigurationDirectoryMode() proxy.PropUint32
	ConfigurationDirectory() proxy.PropStringArray
	MemoryDenyWriteExecute() proxy.PropBool
	RestrictRealtime() proxy.PropBool
	RestrictNamespaces() proxy.PropUint64
	BindPaths() PropBindPaths
	BindReadOnlyPaths() PropBindPaths
	TemporaryFileSystem() PropServiceTemporaryFileSystem
	MountAPIVFS() proxy.PropBool
	KeyringMode() proxy.PropString
	KillMode() proxy.PropString
	KillSignal() proxy.PropInt32
	FinalKillSignal() proxy.PropInt32
	SendSIGKILL() proxy.PropBool
	SendSIGHUP() proxy.PropBool
	WatchdogSignal() proxy.PropInt32
}

type interfaceService struct{}

func (v *interfaceService) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceService) GetInterfaceName_() string {
	return "org.freedesktop.systemd1.Service"
}

// method GetProcesses

func (v *interfaceService) GoGetProcesses(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetProcesses", flags, ch)
}

func (*interfaceService) StoreGetProcesses(call *dbus.Call) (processes []UnitProcess, err error) {
	err = call.Store(&processes)
	return
}

func (v *interfaceService) GetProcesses(flags dbus.Flags) ([]UnitProcess, error) {
	return v.StoreGetProcesses(
		<-v.GoGetProcesses(flags, make(chan *dbus.Call, 1)).Done)
}

// method AttachProcesses

func (v *interfaceService) GoAttachProcesses(flags dbus.Flags, ch chan *dbus.Call, arg0 string, arg1 []uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".AttachProcesses", flags, ch, arg0, arg1)
}

func (v *interfaceService) AttachProcesses(flags dbus.Flags, arg0 string, arg1 []uint32) error {
	return (<-v.GoAttachProcesses(flags, make(chan *dbus.Call, 1), arg0, arg1).Done).Err
}

// property Type s

func (v *interfaceService) Type() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Type",
	}
}

// property Restart s

func (v *interfaceService) Restart() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Restart",
	}
}

// property PIDFile s

func (v *interfaceService) PIDFile() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "PIDFile",
	}
}

// property NotifyAccess s

func (v *interfaceService) NotifyAccess() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "NotifyAccess",
	}
}

// property RestartUSec t

func (v *interfaceService) RestartUSec() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "RestartUSec",
	}
}

// property TimeoutStartUSec t

func (v *interfaceService) TimeoutStartUSec() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "TimeoutStartUSec",
	}
}

// property TimeoutStopUSec t

func (v *interfaceService) TimeoutStopUSec() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "TimeoutStopUSec",
	}
}

// property RuntimeMaxUSec t

func (v *interfaceService) RuntimeMaxUSec() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "RuntimeMaxUSec",
	}
}

// property WatchdogUSec t

func (v *interfaceService) WatchdogUSec() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "WatchdogUSec",
	}
}

// property WatchdogTimestamp t

func (v *interfaceService) WatchdogTimestamp() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "WatchdogTimestamp",
	}
}

// property WatchdogTimestampMonotonic t

func (v *interfaceService) WatchdogTimestampMonotonic() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "WatchdogTimestampMonotonic",
	}
}

// property RootDirectoryStartOnly b

func (v *interfaceService) RootDirectoryStartOnly() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "RootDirectoryStartOnly",
	}
}

// property RemainAfterExit b

func (v *interfaceService) RemainAfterExit() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "RemainAfterExit",
	}
}

// property GuessMainPID b

func (v *interfaceService) GuessMainPID() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "GuessMainPID",
	}
}

// property RestartPreventExitStatus (aiai)

func (v *interfaceService) RestartPreventExitStatus() PropExitStatus {
	return &implPropExitStatus{
		Impl: v,
		Name: "RestartPreventExitStatus",
	}
}

// property RestartForceExitStatus (aiai)

func (v *interfaceService) RestartForceExitStatus() PropExitStatus {
	return &implPropExitStatus{
		Impl: v,
		Name: "RestartForceExitStatus",
	}
}

// property SuccessExitStatus (aiai)

func (v *interfaceService) SuccessExitStatus() PropExitStatus {
	return &implPropExitStatus{
		Impl: v,
		Name: "SuccessExitStatus",
	}
}

// property MainPID u

func (v *interfaceService) MainPID() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "MainPID",
	}
}

// property ControlPID u

func (v *interfaceService) ControlPID() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "ControlPID",
	}
}

// property BusName s

func (v *interfaceService) BusName() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "BusName",
	}
}

// property FileDescriptorStoreMax u

func (v *interfaceService) FileDescriptorStoreMax() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "FileDescriptorStoreMax",
	}
}

// property NFileDescriptorStore u

func (v *interfaceService) NFileDescriptorStore() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "NFileDescriptorStore",
	}
}

// property StatusText s

func (v *interfaceService) StatusText() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "StatusText",
	}
}

// property StatusErrno i

func (v *interfaceService) StatusErrno() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "StatusErrno",
	}
}

// property Result s

func (v *interfaceService) Result() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Result",
	}
}

// property USBFunctionDescriptors s

func (v *interfaceService) USBFunctionDescriptors() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "USBFunctionDescriptors",
	}
}

// property USBFunctionStrings s

func (v *interfaceService) USBFunctionStrings() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "USBFunctionStrings",
	}
}

// property UID u

func (v *interfaceService) UID() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "UID",
	}
}

// property GID u

func (v *interfaceService) GID() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "GID",
	}
}

// property NRestarts u

func (v *interfaceService) NRestarts() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "NRestarts",
	}
}

// property ExecMainStartTimestamp t

func (v *interfaceService) ExecMainStartTimestamp() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "ExecMainStartTimestamp",
	}
}

// property ExecMainStartTimestampMonotonic t

func (v *interfaceService) ExecMainStartTimestampMonotonic() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "ExecMainStartTimestampMonotonic",
	}
}

// property ExecMainExitTimestamp t

func (v *interfaceService) ExecMainExitTimestamp() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "ExecMainExitTimestamp",
	}
}

// property ExecMainExitTimestampMonotonic t

func (v *interfaceService) ExecMainExitTimestampMonotonic() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "ExecMainExitTimestampMonotonic",
	}
}

// property ExecMainPID u

func (v *interfaceService) ExecMainPID() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "ExecMainPID",
	}
}

// property ExecMainCode i

func (v *interfaceService) ExecMainCode() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "ExecMainCode",
	}
}

// property ExecMainStatus i

func (v *interfaceService) ExecMainStatus() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "ExecMainStatus",
	}
}

// property ExecStartPre a(sasbttttuii)

func (v *interfaceService) ExecStartPre() PropExecInfos {
	return &implPropExecInfos{
		Impl: v,
		Name: "ExecStartPre",
	}
}

// property ExecStart a(sasbttttuii)

func (v *interfaceService) ExecStart() PropExecInfos {
	return &implPropExecInfos{
		Impl: v,
		Name: "ExecStart",
	}
}

// property ExecStartPost a(sasbttttuii)

func (v *interfaceService) ExecStartPost() PropExecInfos {
	return &implPropExecInfos{
		Impl: v,
		Name: "ExecStartPost",
	}
}

// property ExecReload a(sasbttttuii)

func (v *interfaceService) ExecReload() PropExecInfos {
	return &implPropExecInfos{
		Impl: v,
		Name: "ExecReload",
	}
}

// property ExecStop a(sasbttttuii)

func (v *interfaceService) ExecStop() PropExecInfos {
	return &implPropExecInfos{
		Impl: v,
		Name: "ExecStop",
	}
}

// property ExecStopPost a(sasbttttuii)

func (v *interfaceService) ExecStopPost() PropExecInfos {
	return &implPropExecInfos{
		Impl: v,
		Name: "ExecStopPost",
	}
}

// property Slice s

func (v *interfaceService) Slice() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Slice",
	}
}

// property ControlGroup s

func (v *interfaceService) ControlGroup() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "ControlGroup",
	}
}

// property MemoryCurrent t

func (v *interfaceService) MemoryCurrent() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "MemoryCurrent",
	}
}

// property CPUUsageNSec t

func (v *interfaceService) CPUUsageNSec() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "CPUUsageNSec",
	}
}

// property TasksCurrent t

func (v *interfaceService) TasksCurrent() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "TasksCurrent",
	}
}

// property IPIngressBytes t

func (v *interfaceService) IPIngressBytes() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "IPIngressBytes",
	}
}

// property IPIngressPackets t

func (v *interfaceService) IPIngressPackets() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "IPIngressPackets",
	}
}

// property IPEgressBytes t

func (v *interfaceService) IPEgressBytes() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "IPEgressBytes",
	}
}

// property IPEgressPackets t

func (v *interfaceService) IPEgressPackets() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "IPEgressPackets",
	}
}

// property Delegate b

func (v *interfaceService) Delegate() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Delegate",
	}
}

// property DelegateControllers as

func (v *interfaceService) DelegateControllers() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "DelegateControllers",
	}
}

// property CPUAccounting b

func (v *interfaceService) CPUAccounting() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "CPUAccounting",
	}
}

// property CPUWeight t

func (v *interfaceService) CPUWeight() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "CPUWeight",
	}
}

// property StartupCPUWeight t

func (v *interfaceService) StartupCPUWeight() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "StartupCPUWeight",
	}
}

// property CPUShares t

func (v *interfaceService) CPUShares() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "CPUShares",
	}
}

// property StartupCPUShares t

func (v *interfaceService) StartupCPUShares() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "StartupCPUShares",
	}
}

// property CPUQuotaPerSecUSec t

func (v *interfaceService) CPUQuotaPerSecUSec() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "CPUQuotaPerSecUSec",
	}
}

// property IOAccounting b

func (v *interfaceService) IOAccounting() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "IOAccounting",
	}
}

// property IOWeight t

func (v *interfaceService) IOWeight() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "IOWeight",
	}
}

// property StartupIOWeight t

func (v *interfaceService) StartupIOWeight() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "StartupIOWeight",
	}
}

// property IODeviceWeight a(st)

func (v *interfaceService) IODeviceWeight() PropIOParams {
	return &implPropIOParams{
		Impl: v,
		Name: "IODeviceWeight",
	}
}

// property IOReadBandwidthMax a(st)

func (v *interfaceService) IOReadBandwidthMax() PropIOParams {
	return &implPropIOParams{
		Impl: v,
		Name: "IOReadBandwidthMax",
	}
}

// property IOWriteBandwidthMax a(st)

func (v *interfaceService) IOWriteBandwidthMax() PropIOParams {
	return &implPropIOParams{
		Impl: v,
		Name: "IOWriteBandwidthMax",
	}
}

// property IOReadIOPSMax a(st)

func (v *interfaceService) IOReadIOPSMax() PropIOParams {
	return &implPropIOParams{
		Impl: v,
		Name: "IOReadIOPSMax",
	}
}

// property IOWriteIOPSMax a(st)

func (v *interfaceService) IOWriteIOPSMax() PropIOParams {
	return &implPropIOParams{
		Impl: v,
		Name: "IOWriteIOPSMax",
	}
}

// property IODeviceLatencyTargetUSec a(st)

func (v *interfaceService) IODeviceLatencyTargetUSec() PropIOParams {
	return &implPropIOParams{
		Impl: v,
		Name: "IODeviceLatencyTargetUSec",
	}
}

// property BlockIOAccounting b

func (v *interfaceService) BlockIOAccounting() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "BlockIOAccounting",
	}
}

// property BlockIOWeight t

func (v *interfaceService) BlockIOWeight() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "BlockIOWeight",
	}
}

// property StartupBlockIOWeight t

func (v *interfaceService) StartupBlockIOWeight() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "StartupBlockIOWeight",
	}
}

// property BlockIODeviceWeight a(st)

func (v *interfaceService) BlockIODeviceWeight() PropIOParams {
	return &implPropIOParams{
		Impl: v,
		Name: "BlockIODeviceWeight",
	}
}

// property BlockIOReadBandwidth a(st)

func (v *interfaceService) BlockIOReadBandwidth() PropIOParams {
	return &implPropIOParams{
		Impl: v,
		Name: "BlockIOReadBandwidth",
	}
}

// property BlockIOWriteBandwidth a(st)

func (v *interfaceService) BlockIOWriteBandwidth() PropIOParams {
	return &implPropIOParams{
		Impl: v,
		Name: "BlockIOWriteBandwidth",
	}
}

// property MemoryAccounting b

func (v *interfaceService) MemoryAccounting() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "MemoryAccounting",
	}
}

// property MemoryMin t

func (v *interfaceService) MemoryMin() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "MemoryMin",
	}
}

// property MemoryLow t

func (v *interfaceService) MemoryLow() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "MemoryLow",
	}
}

// property MemoryHigh t

func (v *interfaceService) MemoryHigh() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "MemoryHigh",
	}
}

// property MemoryMax t

func (v *interfaceService) MemoryMax() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "MemoryMax",
	}
}

// property MemorySwapMax t

func (v *interfaceService) MemorySwapMax() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "MemorySwapMax",
	}
}

// property MemoryLimit t

func (v *interfaceService) MemoryLimit() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "MemoryLimit",
	}
}

// property DevicePolicy s

func (v *interfaceService) DevicePolicy() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "DevicePolicy",
	}
}

type PropServiceDeviceAllow interface {
	Get(flags dbus.Flags) (value []DeviceAllowItem, err error)
	Set(flags dbus.Flags, value []DeviceAllowItem) error
	ConnectChanged(cb func(hasValue bool, value []DeviceAllowItem)) error
}

type implPropServiceDeviceAllow struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropServiceDeviceAllow) Get(flags dbus.Flags) (value []DeviceAllowItem, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropServiceDeviceAllow) Set(flags dbus.Flags, value []DeviceAllowItem) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropServiceDeviceAllow) ConnectChanged(cb func(hasValue bool, value []DeviceAllowItem)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v []DeviceAllowItem
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, nil)
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

// property DeviceAllow a(ss)

func (v *interfaceService) DeviceAllow() PropServiceDeviceAllow {
	return &implPropServiceDeviceAllow{
		Impl: v,
		Name: "DeviceAllow",
	}
}

// property TasksAccounting b

func (v *interfaceService) TasksAccounting() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "TasksAccounting",
	}
}

// property TasksMax t

func (v *interfaceService) TasksMax() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "TasksMax",
	}
}

// property IPAccounting b

func (v *interfaceService) IPAccounting() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "IPAccounting",
	}
}

type PropServiceIPAddressAllow interface {
	Get(flags dbus.Flags) (value []IPAddressAllowItem, err error)
	Set(flags dbus.Flags, value []IPAddressAllowItem) error
	ConnectChanged(cb func(hasValue bool, value []IPAddressAllowItem)) error
}

type implPropServiceIPAddressAllow struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropServiceIPAddressAllow) Get(flags dbus.Flags) (value []IPAddressAllowItem, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropServiceIPAddressAllow) Set(flags dbus.Flags, value []IPAddressAllowItem) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropServiceIPAddressAllow) ConnectChanged(cb func(hasValue bool, value []IPAddressAllowItem)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v []IPAddressAllowItem
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, nil)
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

// property IPAddressAllow a(iayu)

func (v *interfaceService) IPAddressAllow() PropServiceIPAddressAllow {
	return &implPropServiceIPAddressAllow{
		Impl: v,
		Name: "IPAddressAllow",
	}
}

type PropServiceIPAddressDeny interface {
	Get(flags dbus.Flags) (value []IPAddressDenyItem, err error)
	Set(flags dbus.Flags, value []IPAddressDenyItem) error
	ConnectChanged(cb func(hasValue bool, value []IPAddressDenyItem)) error
}

type implPropServiceIPAddressDeny struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropServiceIPAddressDeny) Get(flags dbus.Flags) (value []IPAddressDenyItem, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropServiceIPAddressDeny) Set(flags dbus.Flags, value []IPAddressDenyItem) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropServiceIPAddressDeny) ConnectChanged(cb func(hasValue bool, value []IPAddressDenyItem)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v []IPAddressDenyItem
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, nil)
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

// property IPAddressDeny a(iayu)

func (v *interfaceService) IPAddressDeny() PropServiceIPAddressDeny {
	return &implPropServiceIPAddressDeny{
		Impl: v,
		Name: "IPAddressDeny",
	}
}

// property DisableControllers as

func (v *interfaceService) DisableControllers() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "DisableControllers",
	}
}

// property Environment as

func (v *interfaceService) Environment() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "Environment",
	}
}

// property EnvironmentFiles a(sb)

func (v *interfaceService) EnvironmentFiles() PropEnvironmentFiles {
	return &implPropEnvironmentFiles{
		Impl: v,
		Name: "EnvironmentFiles",
	}
}

// property PassEnvironment as

func (v *interfaceService) PassEnvironment() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "PassEnvironment",
	}
}

// property UnsetEnvironment as

func (v *interfaceService) UnsetEnvironment() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "UnsetEnvironment",
	}
}

// property UMask u

func (v *interfaceService) UMask() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "UMask",
	}
}

// property LimitCPU t

func (v *interfaceService) LimitCPU() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LimitCPU",
	}
}

// property LimitCPUSoft t

func (v *interfaceService) LimitCPUSoft() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LimitCPUSoft",
	}
}

// property LimitFSIZE t

func (v *interfaceService) LimitFSIZE() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LimitFSIZE",
	}
}

// property LimitFSIZESoft t

func (v *interfaceService) LimitFSIZESoft() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LimitFSIZESoft",
	}
}

// property LimitDATA t

func (v *interfaceService) LimitDATA() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LimitDATA",
	}
}

// property LimitDATASoft t

func (v *interfaceService) LimitDATASoft() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LimitDATASoft",
	}
}

// property LimitSTACK t

func (v *interfaceService) LimitSTACK() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LimitSTACK",
	}
}

// property LimitSTACKSoft t

func (v *interfaceService) LimitSTACKSoft() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LimitSTACKSoft",
	}
}

// property LimitCORE t

func (v *interfaceService) LimitCORE() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LimitCORE",
	}
}

// property LimitCORESoft t

func (v *interfaceService) LimitCORESoft() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LimitCORESoft",
	}
}

// property LimitRSS t

func (v *interfaceService) LimitRSS() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LimitRSS",
	}
}

// property LimitRSSSoft t

func (v *interfaceService) LimitRSSSoft() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LimitRSSSoft",
	}
}

// property LimitNOFILE t

func (v *interfaceService) LimitNOFILE() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LimitNOFILE",
	}
}

// property LimitNOFILESoft t

func (v *interfaceService) LimitNOFILESoft() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LimitNOFILESoft",
	}
}

// property LimitAS t

func (v *interfaceService) LimitAS() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LimitAS",
	}
}

// property LimitASSoft t

func (v *interfaceService) LimitASSoft() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LimitASSoft",
	}
}

// property LimitNPROC t

func (v *interfaceService) LimitNPROC() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LimitNPROC",
	}
}

// property LimitNPROCSoft t

func (v *interfaceService) LimitNPROCSoft() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LimitNPROCSoft",
	}
}

// property LimitMEMLOCK t

func (v *interfaceService) LimitMEMLOCK() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LimitMEMLOCK",
	}
}

// property LimitMEMLOCKSoft t

func (v *interfaceService) LimitMEMLOCKSoft() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LimitMEMLOCKSoft",
	}
}

// property LimitLOCKS t

func (v *interfaceService) LimitLOCKS() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LimitLOCKS",
	}
}

// property LimitLOCKSSoft t

func (v *interfaceService) LimitLOCKSSoft() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LimitLOCKSSoft",
	}
}

// property LimitSIGPENDING t

func (v *interfaceService) LimitSIGPENDING() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LimitSIGPENDING",
	}
}

// property LimitSIGPENDINGSoft t

func (v *interfaceService) LimitSIGPENDINGSoft() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LimitSIGPENDINGSoft",
	}
}

// property LimitMSGQUEUE t

func (v *interfaceService) LimitMSGQUEUE() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LimitMSGQUEUE",
	}
}

// property LimitMSGQUEUESoft t

func (v *interfaceService) LimitMSGQUEUESoft() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LimitMSGQUEUESoft",
	}
}

// property LimitNICE t

func (v *interfaceService) LimitNICE() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LimitNICE",
	}
}

// property LimitNICESoft t

func (v *interfaceService) LimitNICESoft() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LimitNICESoft",
	}
}

// property LimitRTPRIO t

func (v *interfaceService) LimitRTPRIO() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LimitRTPRIO",
	}
}

// property LimitRTPRIOSoft t

func (v *interfaceService) LimitRTPRIOSoft() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LimitRTPRIOSoft",
	}
}

// property LimitRTTIME t

func (v *interfaceService) LimitRTTIME() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LimitRTTIME",
	}
}

// property LimitRTTIMESoft t

func (v *interfaceService) LimitRTTIMESoft() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LimitRTTIMESoft",
	}
}

// property WorkingDirectory s

func (v *interfaceService) WorkingDirectory() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "WorkingDirectory",
	}
}

// property RootDirectory s

func (v *interfaceService) RootDirectory() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "RootDirectory",
	}
}

// property RootImage s

func (v *interfaceService) RootImage() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "RootImage",
	}
}

// property OOMScoreAdjust i

func (v *interfaceService) OOMScoreAdjust() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "OOMScoreAdjust",
	}
}

// property Nice i

func (v *interfaceService) Nice() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "Nice",
	}
}

// property IOSchedulingClass i

func (v *interfaceService) IOSchedulingClass() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "IOSchedulingClass",
	}
}

// property IOSchedulingPriority i

func (v *interfaceService) IOSchedulingPriority() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "IOSchedulingPriority",
	}
}

// property CPUSchedulingPolicy i

func (v *interfaceService) CPUSchedulingPolicy() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "CPUSchedulingPolicy",
	}
}

// property CPUSchedulingPriority i

func (v *interfaceService) CPUSchedulingPriority() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "CPUSchedulingPriority",
	}
}

// property CPUAffinity ay

func (v *interfaceService) CPUAffinity() proxy.PropByteArray {
	return &proxy.ImplPropByteArray{
		Impl: v,
		Name: "CPUAffinity",
	}
}

// property TimerSlackNSec t

func (v *interfaceService) TimerSlackNSec() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "TimerSlackNSec",
	}
}

// property CPUSchedulingResetOnFork b

func (v *interfaceService) CPUSchedulingResetOnFork() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "CPUSchedulingResetOnFork",
	}
}

// property NonBlocking b

func (v *interfaceService) NonBlocking() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "NonBlocking",
	}
}

// property StandardInput s

func (v *interfaceService) StandardInput() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "StandardInput",
	}
}

// property StandardInputFileDescriptorName s

func (v *interfaceService) StandardInputFileDescriptorName() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "StandardInputFileDescriptorName",
	}
}

// property StandardInputData ay

func (v *interfaceService) StandardInputData() proxy.PropByteArray {
	return &proxy.ImplPropByteArray{
		Impl: v,
		Name: "StandardInputData",
	}
}

// property StandardOutput s

func (v *interfaceService) StandardOutput() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "StandardOutput",
	}
}

// property StandardOutputFileDescriptorName s

func (v *interfaceService) StandardOutputFileDescriptorName() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "StandardOutputFileDescriptorName",
	}
}

// property StandardError s

func (v *interfaceService) StandardError() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "StandardError",
	}
}

// property StandardErrorFileDescriptorName s

func (v *interfaceService) StandardErrorFileDescriptorName() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "StandardErrorFileDescriptorName",
	}
}

// property TTYPath s

func (v *interfaceService) TTYPath() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "TTYPath",
	}
}

// property TTYReset b

func (v *interfaceService) TTYReset() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "TTYReset",
	}
}

// property TTYVHangup b

func (v *interfaceService) TTYVHangup() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "TTYVHangup",
	}
}

// property TTYVTDisallocate b

func (v *interfaceService) TTYVTDisallocate() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "TTYVTDisallocate",
	}
}

// property SyslogPriority i

func (v *interfaceService) SyslogPriority() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "SyslogPriority",
	}
}

// property SyslogIdentifier s

func (v *interfaceService) SyslogIdentifier() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "SyslogIdentifier",
	}
}

// property SyslogLevelPrefix b

func (v *interfaceService) SyslogLevelPrefix() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "SyslogLevelPrefix",
	}
}

// property SyslogLevel i

func (v *interfaceService) SyslogLevel() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "SyslogLevel",
	}
}

// property SyslogFacility i

func (v *interfaceService) SyslogFacility() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "SyslogFacility",
	}
}

// property LogLevelMax i

func (v *interfaceService) LogLevelMax() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "LogLevelMax",
	}
}

// property LogRateLimitIntervalUSec t

func (v *interfaceService) LogRateLimitIntervalUSec() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LogRateLimitIntervalUSec",
	}
}

// property LogRateLimitBurst u

func (v *interfaceService) LogRateLimitBurst() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "LogRateLimitBurst",
	}
}

type PropServiceLogExtraFields interface {
	Get(flags dbus.Flags) (value [][]byte, err error)
	Set(flags dbus.Flags, value [][]byte) error
	ConnectChanged(cb func(hasValue bool, value [][]byte)) error
}

type implPropServiceLogExtraFields struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropServiceLogExtraFields) Get(flags dbus.Flags) (value [][]byte, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropServiceLogExtraFields) Set(flags dbus.Flags, value [][]byte) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropServiceLogExtraFields) ConnectChanged(cb func(hasValue bool, value [][]byte)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v [][]byte
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, nil)
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

// property LogExtraFields aay

func (v *interfaceService) LogExtraFields() PropServiceLogExtraFields {
	return &implPropServiceLogExtraFields{
		Impl: v,
		Name: "LogExtraFields",
	}
}

// property SecureBits i

func (v *interfaceService) SecureBits() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "SecureBits",
	}
}

// property CapabilityBoundingSet t

func (v *interfaceService) CapabilityBoundingSet() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "CapabilityBoundingSet",
	}
}

// property AmbientCapabilities t

func (v *interfaceService) AmbientCapabilities() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "AmbientCapabilities",
	}
}

// property User s

func (v *interfaceService) User() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "User",
	}
}

// property Group s

func (v *interfaceService) Group() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Group",
	}
}

// property DynamicUser b

func (v *interfaceService) DynamicUser() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "DynamicUser",
	}
}

// property RemoveIPC b

func (v *interfaceService) RemoveIPC() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "RemoveIPC",
	}
}

// property SupplementaryGroups as

func (v *interfaceService) SupplementaryGroups() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "SupplementaryGroups",
	}
}

// property PAMName s

func (v *interfaceService) PAMName() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "PAMName",
	}
}

// property ReadWritePaths as

func (v *interfaceService) ReadWritePaths() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "ReadWritePaths",
	}
}

// property ReadOnlyPaths as

func (v *interfaceService) ReadOnlyPaths() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "ReadOnlyPaths",
	}
}

// property InaccessiblePaths as

func (v *interfaceService) InaccessiblePaths() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "InaccessiblePaths",
	}
}

// property MountFlags t

func (v *interfaceService) MountFlags() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "MountFlags",
	}
}

// property PrivateTmp b

func (v *interfaceService) PrivateTmp() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "PrivateTmp",
	}
}

// property PrivateDevices b

func (v *interfaceService) PrivateDevices() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "PrivateDevices",
	}
}

// property ProtectKernelTunables b

func (v *interfaceService) ProtectKernelTunables() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "ProtectKernelTunables",
	}
}

// property ProtectKernelModules b

func (v *interfaceService) ProtectKernelModules() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "ProtectKernelModules",
	}
}

// property ProtectControlGroups b

func (v *interfaceService) ProtectControlGroups() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "ProtectControlGroups",
	}
}

// property PrivateNetwork b

func (v *interfaceService) PrivateNetwork() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "PrivateNetwork",
	}
}

// property PrivateUsers b

func (v *interfaceService) PrivateUsers() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "PrivateUsers",
	}
}

// property PrivateMounts b

func (v *interfaceService) PrivateMounts() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "PrivateMounts",
	}
}

// property ProtectHome s

func (v *interfaceService) ProtectHome() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "ProtectHome",
	}
}

// property ProtectSystem s

func (v *interfaceService) ProtectSystem() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "ProtectSystem",
	}
}

// property SameProcessGroup b

func (v *interfaceService) SameProcessGroup() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "SameProcessGroup",
	}
}

// property UtmpIdentifier s

func (v *interfaceService) UtmpIdentifier() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "UtmpIdentifier",
	}
}

// property UtmpMode s

func (v *interfaceService) UtmpMode() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "UtmpMode",
	}
}

// property SELinuxContext (bs)

func (v *interfaceService) SELinuxContext() PropBS {
	return &implPropBS{
		Impl: v,
		Name: "SELinuxContext",
	}
}

// property AppArmorProfile (bs)

func (v *interfaceService) AppArmorProfile() PropBS {
	return &implPropBS{
		Impl: v,
		Name: "AppArmorProfile",
	}
}

// property SmackProcessLabel (bs)

func (v *interfaceService) SmackProcessLabel() PropBS {
	return &implPropBS{
		Impl: v,
		Name: "SmackProcessLabel",
	}
}

// property IgnoreSIGPIPE b

func (v *interfaceService) IgnoreSIGPIPE() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "IgnoreSIGPIPE",
	}
}

// property NoNewPrivileges b

func (v *interfaceService) NoNewPrivileges() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "NoNewPrivileges",
	}
}

type PropServiceSystemCallFilter interface {
	Get(flags dbus.Flags) (value SystemCallFilter, err error)
	Set(flags dbus.Flags, value SystemCallFilter) error
	ConnectChanged(cb func(hasValue bool, value SystemCallFilter)) error
}

type implPropServiceSystemCallFilter struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropServiceSystemCallFilter) Get(flags dbus.Flags) (value SystemCallFilter, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropServiceSystemCallFilter) Set(flags dbus.Flags, value SystemCallFilter) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropServiceSystemCallFilter) ConnectChanged(cb func(hasValue bool, value SystemCallFilter)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v SystemCallFilter
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, SystemCallFilter{})
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

// property SystemCallFilter (bas)

func (v *interfaceService) SystemCallFilter() PropServiceSystemCallFilter {
	return &implPropServiceSystemCallFilter{
		Impl: v,
		Name: "SystemCallFilter",
	}
}

// property SystemCallArchitectures as

func (v *interfaceService) SystemCallArchitectures() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "SystemCallArchitectures",
	}
}

// property SystemCallErrorNumber i

func (v *interfaceService) SystemCallErrorNumber() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "SystemCallErrorNumber",
	}
}

// property Personality s

func (v *interfaceService) Personality() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Personality",
	}
}

// property LockPersonality b

func (v *interfaceService) LockPersonality() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "LockPersonality",
	}
}

type PropServiceRestrictAddressFamilies interface {
	Get(flags dbus.Flags) (value RestrictAddressFamilies, err error)
	Set(flags dbus.Flags, value RestrictAddressFamilies) error
	ConnectChanged(cb func(hasValue bool, value RestrictAddressFamilies)) error
}

type implPropServiceRestrictAddressFamilies struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropServiceRestrictAddressFamilies) Get(flags dbus.Flags) (value RestrictAddressFamilies, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropServiceRestrictAddressFamilies) Set(flags dbus.Flags, value RestrictAddressFamilies) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropServiceRestrictAddressFamilies) ConnectChanged(cb func(hasValue bool, value RestrictAddressFamilies)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v RestrictAddressFamilies
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, RestrictAddressFamilies{})
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

// property RestrictAddressFamilies (bas)

func (v *interfaceService) RestrictAddressFamilies() PropServiceRestrictAddressFamilies {
	return &implPropServiceRestrictAddressFamilies{
		Impl: v,
		Name: "RestrictAddressFamilies",
	}
}

// property RuntimeDirectoryPreserve s

func (v *interfaceService) RuntimeDirectoryPreserve() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "RuntimeDirectoryPreserve",
	}
}

// property RuntimeDirectoryMode u

func (v *interfaceService) RuntimeDirectoryMode() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "RuntimeDirectoryMode",
	}
}

// property RuntimeDirectory as

func (v *interfaceService) RuntimeDirectory() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "RuntimeDirectory",
	}
}

// property StateDirectoryMode u

func (v *interfaceService) StateDirectoryMode() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "StateDirectoryMode",
	}
}

// property StateDirectory as

func (v *interfaceService) StateDirectory() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "StateDirectory",
	}
}

// property CacheDirectoryMode u

func (v *interfaceService) CacheDirectoryMode() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "CacheDirectoryMode",
	}
}

// property CacheDirectory as

func (v *interfaceService) CacheDirectory() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "CacheDirectory",
	}
}

// property LogsDirectoryMode u

func (v *interfaceService) LogsDirectoryMode() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "LogsDirectoryMode",
	}
}

// property LogsDirectory as

func (v *interfaceService) LogsDirectory() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "LogsDirectory",
	}
}

// property ConfigurationDirectoryMode u

func (v *interfaceService) ConfigurationDirectoryMode() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "ConfigurationDirectoryMode",
	}
}

// property ConfigurationDirectory as

func (v *interfaceService) ConfigurationDirectory() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "ConfigurationDirectory",
	}
}

// property MemoryDenyWriteExecute b

func (v *interfaceService) MemoryDenyWriteExecute() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "MemoryDenyWriteExecute",
	}
}

// property RestrictRealtime b

func (v *interfaceService) RestrictRealtime() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "RestrictRealtime",
	}
}

// property RestrictNamespaces t

func (v *interfaceService) RestrictNamespaces() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "RestrictNamespaces",
	}
}

// property BindPaths a(ssbt)

func (v *interfaceService) BindPaths() PropBindPaths {
	return &implPropBindPaths{
		Impl: v,
		Name: "BindPaths",
	}
}

// property BindReadOnlyPaths a(ssbt)

func (v *interfaceService) BindReadOnlyPaths() PropBindPaths {
	return &implPropBindPaths{
		Impl: v,
		Name: "BindReadOnlyPaths",
	}
}

type PropServiceTemporaryFileSystem interface {
	Get(flags dbus.Flags) (value []TemporaryFileSystemItem, err error)
	Set(flags dbus.Flags, value []TemporaryFileSystemItem) error
	ConnectChanged(cb func(hasValue bool, value []TemporaryFileSystemItem)) error
}

type implPropServiceTemporaryFileSystem struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropServiceTemporaryFileSystem) Get(flags dbus.Flags) (value []TemporaryFileSystemItem, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropServiceTemporaryFileSystem) Set(flags dbus.Flags, value []TemporaryFileSystemItem) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropServiceTemporaryFileSystem) ConnectChanged(cb func(hasValue bool, value []TemporaryFileSystemItem)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v []TemporaryFileSystemItem
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, nil)
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

// property TemporaryFileSystem a(ss)

func (v *interfaceService) TemporaryFileSystem() PropServiceTemporaryFileSystem {
	return &implPropServiceTemporaryFileSystem{
		Impl: v,
		Name: "TemporaryFileSystem",
	}
}

// property MountAPIVFS b

func (v *interfaceService) MountAPIVFS() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "MountAPIVFS",
	}
}

// property KeyringMode s

func (v *interfaceService) KeyringMode() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "KeyringMode",
	}
}

// property KillMode s

func (v *interfaceService) KillMode() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "KillMode",
	}
}

// property KillSignal i

func (v *interfaceService) KillSignal() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "KillSignal",
	}
}

// property FinalKillSignal i

func (v *interfaceService) FinalKillSignal() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "FinalKillSignal",
	}
}

// property SendSIGKILL b

func (v *interfaceService) SendSIGKILL() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "SendSIGKILL",
	}
}

// property SendSIGHUP b

func (v *interfaceService) SendSIGHUP() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "SendSIGHUP",
	}
}

// property WatchdogSignal i

func (v *interfaceService) WatchdogSignal() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "WatchdogSignal",
	}
}

type PropExitStatus interface {
	Get(flags dbus.Flags) (value ExitStatus, err error)
	Set(flags dbus.Flags, value ExitStatus) error
	ConnectChanged(cb func(hasValue bool, value ExitStatus)) error
}

type implPropExitStatus struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropExitStatus) Get(flags dbus.Flags) (value ExitStatus, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropExitStatus) Set(flags dbus.Flags, value ExitStatus) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropExitStatus) ConnectChanged(cb func(hasValue bool, value ExitStatus)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v ExitStatus
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, ExitStatus{})
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

type PropExecInfos interface {
	Get(flags dbus.Flags) (value []ExecInfo, err error)
	Set(flags dbus.Flags, value []ExecInfo) error
	ConnectChanged(cb func(hasValue bool, value []ExecInfo)) error
}

type implPropExecInfos struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropExecInfos) Get(flags dbus.Flags) (value []ExecInfo, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropExecInfos) Set(flags dbus.Flags, value []ExecInfo) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropExecInfos) ConnectChanged(cb func(hasValue bool, value []ExecInfo)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v []ExecInfo
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, nil)
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

type PropIOParams interface {
	Get(flags dbus.Flags) (value []IOParam, err error)
	Set(flags dbus.Flags, value []IOParam) error
	ConnectChanged(cb func(hasValue bool, value []IOParam)) error
}

type implPropIOParams struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropIOParams) Get(flags dbus.Flags) (value []IOParam, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropIOParams) Set(flags dbus.Flags, value []IOParam) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropIOParams) ConnectChanged(cb func(hasValue bool, value []IOParam)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v []IOParam
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, nil)
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

type PropEnvironmentFiles interface {
	Get(flags dbus.Flags) (value []EnvironmentFile, err error)
	Set(flags dbus.Flags, value []EnvironmentFile) error
	ConnectChanged(cb func(hasValue bool, value []EnvironmentFile)) error
}

type implPropEnvironmentFiles struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropEnvironmentFiles) Get(flags dbus.Flags) (value []EnvironmentFile, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropEnvironmentFiles) Set(flags dbus.Flags, value []EnvironmentFile) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropEnvironmentFiles) ConnectChanged(cb func(hasValue bool, value []EnvironmentFile)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v []EnvironmentFile
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, nil)
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

type PropBS interface {
	Get(flags dbus.Flags) (value BS, err error)
	Set(flags dbus.Flags, value BS) error
	ConnectChanged(cb func(hasValue bool, value BS)) error
}

type implPropBS struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropBS) Get(flags dbus.Flags) (value BS, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropBS) Set(flags dbus.Flags, value BS) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropBS) ConnectChanged(cb func(hasValue bool, value BS)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v BS
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, BS{})
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

type PropBindPaths interface {
	Get(flags dbus.Flags) (value []BindPath, err error)
	Set(flags dbus.Flags, value []BindPath) error
	ConnectChanged(cb func(hasValue bool, value []BindPath)) error
}

type implPropBindPaths struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropBindPaths) Get(flags dbus.Flags) (value []BindPath, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropBindPaths) Set(flags dbus.Flags, value []BindPath) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropBindPaths) ConnectChanged(cb func(hasValue bool, value []BindPath)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v []BindPath
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, nil)
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}
