#ifndef _CALLBACKS_H_
#define _CALLBACKS_H_

#include <gtk/gtk.h>

gboolean on_main_window_quit                       (GtkWidget *widget, GdkEvent *event, gpointer user_data);

void on_file_plaintext_new_activate                (GtkMenuItem *menuitem, gpointer user_data);
void on_file_plaintext_open_activate               (GtkMenuItem *menuitem, gpointer user_data);
void on_file_plaintext_save_activate               (GtkMenuItem *menuitem, gpointer user_data);
void on_file_plaintext_save_as_activate            (GtkMenuItem *menuitem, gpointer user_data);

void on_file_cipher_new_activate                   (GtkMenuItem *menuitem, gpointer user_data);
void on_file_cipher_open_activate                  (GtkMenuItem *menuitem, gpointer user_data);
void on_file_cipher_save_activate                  (GtkMenuItem *menuitem, gpointer user_data);
void on_file_cipher_save_as_activate               (GtkMenuItem *menuitem, gpointer user_data);

void on_file_quit_activate                         (GtkMenuItem *menuitem, gpointer user_data);

void on_edit_cut_activate                          (GtkMenuItem *menuitem, gpointer user_data);
void on_edit_copy_activate                         (GtkMenuItem *menuitem, gpointer user_data);
void on_edit_paste_activate                        (GtkMenuItem *menuitem, gpointer user_data);
void on_edit_clear_activate                        (GtkMenuItem *menuitem, gpointer user_data);
void on_edit_delete_activate                       (GtkMenuItem *menuitem, gpointer user_data);
void on_edit_select_all_activate                   (GtkMenuItem *menuitem, gpointer user_data);

void on_help_about_activate                        (GtkMenuItem *menuitem, gpointer user_data);

void on_key_combo_box_changed                      (GtkComboBox *combo_box, gpointer user_data);
void on_passphrase_callback_entry_activate         (GtkEntry *entry, gpointer user_data);

void on_bt_clear_plaintext_clicked                 (GtkButton *button, gpointer user_data);
void on_bt_select_all_plaintext_clicked            (GtkButton *button, gpointer user_data);
void on_bt_plaintext_copy_to_clipboard_clicked     (GtkButton *button, gpointer user_data);
void on_bt_plaintext_insert_from_clipboard_clicked (GtkButton *button, gpointer user_data);

void on_bt_clear_cipher_clicked                    (GtkButton *button, gpointer user_data);
void on_bt_select_all_cipher_clicked               (GtkButton *button, gpointer user_data);
void on_bt_cipher_copy_to_clipboard_clicked        (GtkButton *button, gpointer user_data);
void on_bt_cipher_insert_from_clipboard_clicked    (GtkButton *button, gpointer user_data);

void on_bt_encrypt_plaintext_clicked               (GtkButton *button, gpointer user_data);
void on_bt_decrypt_cipher_clicked                  (GtkButton *button, gpointer user_data);

void on_plaintext_file_entry_focus_in              (GtkWidget *widget, GdkEvent *event, gpointer user_data);
void on_cipher_file_entry_focus_in                 (GtkWidget *widget, GdkEvent *event, gpointer user_data);

void on_bt_plaintext_file_select_clicked           (GtkButton *button, gpointer user_data);
void on_bt_cipher_file_select_clicked              (GtkButton *button, gpointer user_data);

void on_bt_encrypt_plaintext_file_clicked          (GtkButton *button, gpointer user_data);
void on_bt_decrypt_cipher_file_clicked             (GtkButton *button, gpointer user_data);

void on_chbt_cipher_file_ascii_armor_clicked       (GtkToggleButton *button, gpointer user_data);

#endif /* _CALLBACKS_H_ */
