/*
 *      edit-operations.c
 *
 *      Copyright 2007 - 2012 Florian Sievers <florian.sievers@gmail.com>
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; version 2 of the License.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "gpg-crypter.h"
#include "edit-operations.h"

extern application_data *app_data;

void edit_cut_clipboard (GtkWidget *widget)
{
	GtkTextBuffer *buffer;
	GtkClipboard *clipboard;

	if (widget == NULL)
		widget = gtk_window_get_focus (GTK_WINDOW (app_data->main_window));

	if (widget == NULL || GTK_IS_TEXT_VIEW (widget) == FALSE)
		return;

	buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (widget));
	clipboard = gtk_widget_get_clipboard (widget, GDK_SELECTION_CLIPBOARD);

	gtk_text_buffer_cut_clipboard (buffer, clipboard, TRUE);
	gtk_text_view_scroll_to_mark (GTK_TEXT_VIEW (widget), gtk_text_buffer_get_insert (buffer), 0.0, FALSE, 0.0, 0.0);
}

void edit_copy_clipboard (GtkWidget *widget)
{
	GtkTextBuffer *buffer;
	GtkClipboard *clipboard;

	if (widget == NULL)
		widget = gtk_window_get_focus (GTK_WINDOW (app_data->main_window));

	if (widget == NULL || GTK_IS_TEXT_VIEW (widget) == FALSE)
		return;

	buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (widget));
	clipboard = gtk_widget_get_clipboard (widget, GDK_SELECTION_CLIPBOARD);

	gtk_text_buffer_copy_clipboard (buffer, clipboard);
}

void edit_paste_clipboard (GtkWidget *widget)
{
	GtkTextBuffer *buffer;
	GtkClipboard *clipboard;

	if (widget == NULL)
		widget = gtk_window_get_focus (GTK_WINDOW (app_data->main_window));

	if (widget == NULL || GTK_IS_TEXT_VIEW (widget) == FALSE)
		return;

	buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (widget));
	clipboard = gtk_widget_get_clipboard (widget, GDK_SELECTION_CLIPBOARD);

	gtk_text_buffer_paste_clipboard (buffer, clipboard, NULL, TRUE);
	gtk_text_view_scroll_to_mark (GTK_TEXT_VIEW (widget), gtk_text_buffer_get_insert (buffer), 0.0, FALSE, 0.0, 0.0);
}

void edit_delete_clipboard (GtkWidget *widget)
{
	GtkTextBuffer *buffer;

	if (widget == NULL)
		widget = gtk_window_get_focus (GTK_WINDOW (app_data->main_window));

	if (widget == NULL || GTK_IS_TEXT_VIEW (widget) == FALSE)
		return;

	buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (widget));

	gtk_text_buffer_delete_selection (buffer, TRUE, TRUE);
	gtk_text_view_scroll_to_mark (GTK_TEXT_VIEW (widget), gtk_text_buffer_get_insert (buffer), 0.0, FALSE, 0.0, 0.0);
}

void edit_select_all (GtkWidget *widget)
{
	GtkTextBuffer *buffer;
	GtkTextIter iter_start, iter_end;

	if (widget == NULL)
		widget = gtk_window_get_focus (GTK_WINDOW (app_data->main_window));

	if (widget == NULL || GTK_IS_TEXT_VIEW (widget) == FALSE)
		return;

	buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (widget));

	gtk_text_buffer_get_start_iter (buffer, &iter_start);
	gtk_text_buffer_get_end_iter (buffer, &iter_end);
	gtk_text_buffer_select_range (buffer, &iter_start, &iter_end);
}
