/*
 *      error-dialogs.c
 *
 *      Copyright 2006 - 2012 Florian Sievers <florian.sievers@gmail.com>
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; version 2 of the License.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "gpg-crypter.h"
#include "error-dialogs.h"

#include <stdarg.h>
#include <glib/gprintf.h>

extern application_data *app_data;

void error_dialog (const gchar *format, ...)
{
	va_list ap;
	gchar *string;
	GtkWidget *dialog;

	g_return_if_fail (format != NULL);

	va_start (ap, format);

	string = g_strdup_vprintf (format, ap);
	dialog = gtk_message_dialog_new (
			GTK_WINDOW (app_data ? app_data->main_window : NULL),
			GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE,
			"%s", string);

	gtk_dialog_run (GTK_DIALOG (dialog));

	gtk_widget_destroy (GTK_WIDGET (dialog));
	g_free (string);

	va_end (ap);
}

gboolean warn_dialog (const gchar *format, ...)
{
	va_list ap;
	gchar *string;
	GtkWidget *dialog;
	gint retval;

	g_return_val_if_fail (format != NULL, FALSE);

	va_start (ap, format);

	string = g_strdup_vprintf (format, ap);
	dialog = gtk_message_dialog_new (
			GTK_WINDOW (app_data ? app_data->main_window : NULL),
			GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_YES_NO,
			"%s", string);

	retval = gtk_dialog_run (GTK_DIALOG (dialog));

	gtk_widget_destroy (GTK_WIDGET (dialog));
	g_free (string);

	va_end (ap);

	return (retval == GTK_RESPONSE_YES ? TRUE : FALSE);
}
