#ifndef _GPG_CRYPTER_H_
#define _GPG_CRYPTER_H_

#include <glib/gi18n.h>
#include <gtk/gtk.h>
#include <gpgme.h>

typedef struct application_data {
	/* gpgme */
	gpgme_ctx_t ctx;
	gpgme_key_t key[2];

	gint ascii_mode;

	gint num_keys; /* number of keys in key_array and key_string_array */
	GPtrArray *key_array; /* don't sort array */
	GPtrArray *key_string_array; /* don't sort array */

	/* interface */
	GtkWidget *main_window;
	GtkWidget *key_combo_box;

	GtkWidget *menu_file_quit;

	GtkWidget *text_crypter_box;
	GtkWidget *file_crypter_box;

	GtkWidget *passphrase_callback_dialog;
	GtkWidget *passphrase_callback_entry;

	GtkWidget *plaintext_label;
	GtkWidget *cipher_label;

	GtkWidget *plaintext_textview;
	GtkWidget *cipher_textview;

	gchar *plaintext_dialog_file;
	gchar *cipher_dialog_file;

	GtkWidget *plaintext_file_entry;
	GtkWidget *cipher_file_entry;

	GtkWidget *about_dialog;

	GtkWidget *progress_bar;

} application_data;

#endif /* _GPG_CRYPTER_H_ */
