/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import javax.swing.JOptionPane;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.data.DataPoint;
import tim.prune.data.TrackInfo;
import tim.prune.undo.UndoDeleteRange;

public abstract class DeleteBitOfTrackFunction
extends GenericFunction {
    public DeleteBitOfTrackFunction(App app) {
        super(app);
    }

    protected abstract String getUndoNameKey();

    protected void deleteSection(int n, int n2) {
        this.deleteTwoSections(n, n2, -1, -1);
    }

    protected void deleteTwoSections(int n, int n2, int n3, int n4) {
        boolean[] blArray = new boolean[2];
        if (n < 0 || n2 < 0 || n2 < n) {
            n2 = -1;
            n = -1;
        }
        if (n3 < 0 || n4 < 0 || n4 < n3) {
            n4 = -1;
            n3 = -1;
        }
        if (n >= 0 && n2 < n || n3 >= 0 && (n3 < n2 || n4 <= n3)) {
            System.err.println("Invalid ranges: (" + n + " - " + n2 + "), (" + n3 + " - " + n4 + ")");
            return;
        }
        int n5 = n2 - n + 1;
        boolean[] blArray2 = new boolean[n5];
        int n6 = this.prepareDeleteMedia(n, n2, blArray, blArray2);
        if (n6 < 0) {
            return;
        }
        n5 = n4 - n3 + 1;
        boolean[] blArray3 = new boolean[n5];
        int n7 = this.prepareDeleteMedia(n3, n4, blArray, blArray3);
        if (n7 < 0) {
            return;
        }
        int n8 = n6 + n7;
        if (n8 <= 0) {
            return;
        }
        UndoDeleteRange undoDeleteRange = new UndoDeleteRange(this._app.getTrackInfo(), this.getUndoNameKey(), n, blArray2, n3, blArray3);
        if (n6 > 0) {
            DeleteBitOfTrackFunction.resolveMedia(this._app.getTrackInfo(), n, blArray2);
        }
        if (n7 > 0) {
            DeleteBitOfTrackFunction.resolveMedia(this._app.getTrackInfo(), n3, blArray3);
        }
        if (n7 > 0) {
            this._app.getTrackInfo().getTrack().deleteRange(n3, n4);
        }
        if (n6 > 0) {
            this._app.getTrackInfo().getTrack().deleteRange(n, n2);
        }
        this._app.getTrackInfo().getSelection().clearAll();
        UpdateMessageBroker.informSubscribers((byte)1);
        this._app.completeFunction(undoDeleteRange, n8 + " " + I18nManager.getText("confirm.deletepoint.multi"));
    }

    private int prepareDeleteMedia(int n, int n2, boolean[] blArray, boolean[] blArray2) {
        if (n < 0 || n2 < 0 || n2 < n) {
            return 0;
        }
        int n3 = n2 - n + 1;
        if (blArray == null || blArray.length != 2 || blArray2 == null || blArray2.length != n3) {
            return 0;
        }
        Object[] objectArray = new String[]{I18nManager.getText("button.yes"), I18nManager.getText("button.no"), I18nManager.getText("button.yestoall"), I18nManager.getText("button.notoall"), I18nManager.getText("button.cancel")};
        int n4 = 0;
        while (n4 < n3) {
            DataPoint dataPoint = this._app.getTrackInfo().getTrack().getPoint(n + n4);
            if (dataPoint.hasMedia()) {
                if (blArray[0]) {
                    blArray2[n4] = true;
                } else if (blArray[1]) {
                    blArray2[n4] = false;
                } else {
                    int n5 = JOptionPane.showOptionDialog(this._app.getFrame(), String.valueOf(I18nManager.getText("dialog.deletepoint.deletephoto")) + " " + dataPoint.getMediaName(), I18nManager.getText("dialog.deletepoint.title"), 1, 3, null, objectArray, objectArray[1]);
                    if (n5 == 4 || n5 == -1) {
                        return -1;
                    }
                    if (n5 == 0 || n5 == 2) {
                        blArray2[n4] = true;
                        if (n5 == 2) {
                            blArray[0] = true;
                        }
                    }
                    if (n5 == 3) {
                        blArray[1] = true;
                    }
                }
            }
            ++n4;
        }
        return n3;
    }

    private static void resolveMedia(TrackInfo trackInfo, int n, boolean[] blArray) {
        int n2 = 0;
        while (n2 < blArray.length) {
            DataPoint dataPoint = trackInfo.getTrack().getPoint(n2 + n);
            if (dataPoint != null && dataPoint.hasMedia()) {
                if (blArray[n2]) {
                    if (dataPoint.getPhoto() != null) {
                        trackInfo.getPhotoList().deletePhoto(trackInfo.getPhotoList().getPhotoIndex(dataPoint.getPhoto()));
                    }
                    if (dataPoint.getAudio() != null) {
                        trackInfo.getAudioList().deleteAudio(trackInfo.getAudioList().getAudioIndex(dataPoint.getAudio()));
                    }
                } else {
                    if (dataPoint.getPhoto() != null) {
                        dataPoint.getPhoto().setDataPoint(null);
                    }
                    if (dataPoint.getAudio() != null) {
                        dataPoint.getAudio().setDataPoint(null);
                    }
                }
            }
            ++n2;
        }
    }
}

