/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.data.Track;
import tim.prune.gui.map.MapSource;
import tim.prune.gui.map.MapSourceLibrary;
import tim.prune.save.BaseImageConsumer;
import tim.prune.save.GroutedImage;
import tim.prune.save.ImagePreviewPanel;
import tim.prune.save.MapGrouter;
import tim.prune.threedee.ImageDefinition;

public class BaseImageConfigDialog
implements Runnable {
    private BaseImageConsumer _parent = null;
    private JDialog _parentDialog = null;
    private Track _track = null;
    private JDialog _dialog = null;
    private JCheckBox _useImageCheckbox = null;
    private JPanel _mainPanel = null;
    private JComboBox<String> _mapSourceDropdown = null;
    private JComboBox<String> _zoomDropdown = null;
    private JButton _downloadTilesButton = null;
    private JProgressBar _progressBar = null;
    private JLabel _tilesFoundLabel = null;
    private JLabel _imageSizeLabel = null;
    private ImagePreviewPanel _previewPanel = null;
    private MapGrouter _grouter = new MapGrouter();
    private JButton _okButton = null;
    private boolean _rebuilding = false;
    private ImageDefinition _imageDef = new ImageDefinition();

    public BaseImageConfigDialog(BaseImageConsumer baseImageConsumer, JDialog jDialog, Track track) {
        this._parent = baseImageConsumer;
        this._parentDialog = jDialog;
        this._dialog = new JDialog(jDialog, I18nManager.getText("dialog.baseimage.title"), true);
        this._dialog.setDefaultCloseOperation(2);
        this._dialog.getContentPane().add(this.makeDialogComponents());
        this._dialog.pack();
        this._track = track;
    }

    public void setImageDefinition(ImageDefinition imageDefinition) {
        this._imageDef = imageDefinition;
        if (this._imageDef == null) {
            this._imageDef = new ImageDefinition();
        }
    }

    public void begin() {
        this.initDialog();
        this._dialog.setLocationRelativeTo(this._parentDialog);
        this._dialog.setVisible(true);
    }

    public void beginWithImageYes() {
        this.initDialog();
        this._useImageCheckbox.setSelected(true);
        this.refreshDialog();
        this._dialog.setVisible(true);
    }

    private void initDialog() {
        this._rebuilding = true;
        this._useImageCheckbox.setSelected(this._imageDef.getUseImage());
        this._mapSourceDropdown.removeAllItems();
        int n = 0;
        while (n < MapSourceLibrary.getNumSources()) {
            this._mapSourceDropdown.addItem(MapSourceLibrary.getSource(n).getName());
            ++n;
        }
        n = this._imageDef.getSourceIndex();
        if (n < 0 || n >= this._mapSourceDropdown.getItemCount()) {
            n = 0;
        }
        this._mapSourceDropdown.setSelectedIndex(n);
        int n2 = this._imageDef.getZoom();
        if (this._imageDef.getUseImage()) {
            int n3 = 0;
            while (n3 < this._zoomDropdown.getItemCount()) {
                String string = this._zoomDropdown.getItemAt(n3);
                try {
                    if (Integer.parseInt(string) == n2) {
                        this._zoomDropdown.setSelectedIndex(n3);
                        break;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                ++n3;
            }
        }
        this._rebuilding = false;
        this.refreshDialog();
    }

    private void refreshDialog() {
        this._mainPanel.setVisible(this._useImageCheckbox.isSelected());
        if (this._rebuilding) {
            return;
        }
        int n = 0;
        try {
            n = Integer.parseInt(this._zoomDropdown.getSelectedItem().toString());
        }
        catch (Exception exception) {}
        if (this._zoomDropdown.getItemCount() == 0) {
            n = this._imageDef.getZoom();
        }
        double d = Math.max(this._track.getXRange().getRange(), this._track.getYRange().getRange());
        int n2 = -1;
        this._rebuilding = true;
        this._zoomDropdown.removeAllItems();
        if (this._useImageCheckbox.isSelected() && this._mapSourceDropdown.getItemCount() > 0) {
            int n3 = this._mapSourceDropdown.getSelectedIndex();
            int n4 = 5;
            while (n4 < 18) {
                int n5 = 1 << n4;
                int n6 = (int)(d * (double)n5 * 256.0);
                if (n6 > 100 && n6 < 4000 && BaseImageConfigDialog.isZoomAvailable(n4, MapSourceLibrary.getSource(n3))) {
                    this._zoomDropdown.addItem("" + n4);
                    if (n4 == n) {
                        n2 = this._zoomDropdown.getItemCount() - 1;
                    }
                }
                ++n4;
            }
        }
        this._zoomDropdown.setSelectedIndex(n2);
        this._rebuilding = false;
        this._okButton.setEnabled(!this._useImageCheckbox.isSelected() || this._zoomDropdown.getItemCount() > 0 && this._zoomDropdown.getSelectedIndex() >= 0);
        this.updateImagePreview();
    }

    public static boolean isImagePossible() {
        File file;
        String string = Config.getConfigString("prune.diskcache");
        if (string != null && !string.equals("") && (file = new File(string)).exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray[n2];
                if (file2.exists() && file2.isDirectory()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static boolean isZoomAvailable(int n, MapSource mapSource) {
        File file;
        if (mapSource == null) {
            return false;
        }
        String string = Config.getConfigString("prune.diskcache");
        if (string == null || string.equals("")) {
            return false;
        }
        File file2 = new File(string);
        if (!file2.exists() || !file2.isDirectory()) {
            return false;
        }
        File file3 = new File(file2, String.valueOf(mapSource.getSiteName(0)) + n);
        if (!(file3.exists() && file3.isDirectory() && file3.canRead())) {
            return false;
        }
        return mapSource.getNumLayers() <= 1 || (file = new File(file2, String.valueOf(mapSource.getSiteName(1)) + n)).exists() && file.isDirectory() && file.canRead();
    }

    public ImageDefinition getImageDefinition() {
        return this._imageDef;
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this._useImageCheckbox = new JCheckBox(I18nManager.getText("dialog.baseimage.useimage"));
        this._useImageCheckbox.setBorder(BorderFactory.createEmptyBorder(4, 4, 6, 4));
        this._useImageCheckbox.setHorizontalAlignment(0);
        this._useImageCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BaseImageConfigDialog.this.refreshDialog();
            }
        });
        jPanel.add((Component)this._useImageCheckbox, "North");
        this._mainPanel = new JPanel();
        this._mainPanel.setLayout(new BorderLayout(1, 10));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 2, 10, 4));
        JLabel jLabel = new JLabel(String.valueOf(I18nManager.getText("dialog.baseimage.mapsource")) + ": ");
        jLabel.setHorizontalAlignment(4);
        jPanel2.add(jLabel);
        this._mapSourceDropdown = new JComboBox();
        this._mapSourceDropdown.addItem("name of map source");
        this._mapSourceDropdown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BaseImageConfigDialog.this.refreshDialog();
            }
        });
        jPanel2.add(this._mapSourceDropdown);
        JLabel jLabel2 = new JLabel(String.valueOf(I18nManager.getText("dialog.baseimage.zoom")) + ": ");
        jLabel2.setHorizontalAlignment(4);
        jPanel2.add(jLabel2);
        this._zoomDropdown = new JComboBox();
        this._zoomDropdown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (BaseImageConfigDialog.this._zoomDropdown.getSelectedIndex() >= 0) {
                    BaseImageConfigDialog.this._okButton.setEnabled(true);
                    BaseImageConfigDialog.this.updateImagePreview();
                }
            }
        });
        jPanel2.add(this._zoomDropdown);
        this._mainPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(10, 1));
        this._previewPanel = new ImagePreviewPanel();
        jPanel3.add((Component)this._previewPanel, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(4, 4));
        this._downloadTilesButton = new JButton(I18nManager.getText("button.load"));
        this._downloadTilesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BaseImageConfigDialog.this.downloadRemainingTiles();
            }
        });
        this._downloadTilesButton.setVisible(false);
        jPanel5.add((Component)this._downloadTilesButton, "North");
        this._progressBar = new JProgressBar();
        this._progressBar.setIndeterminate(true);
        this._progressBar.setVisible(false);
        jPanel5.add((Component)this._progressBar, "South");
        jPanel4.add((Component)jPanel5, "North");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayout(0, 2, 10, 4));
        jPanel6.add(new JLabel(String.valueOf(I18nManager.getText("dialog.baseimage.tiles")) + ": "));
        this._tilesFoundLabel = new JLabel("11 / 11");
        jPanel6.add(this._tilesFoundLabel);
        jPanel6.add(new JLabel(String.valueOf(I18nManager.getText("dialog.baseimage.size")) + ": "));
        this._imageSizeLabel = new JLabel("1430");
        jPanel6.add(this._imageSizeLabel);
        jPanel6.add(new JLabel(" "));
        jPanel4.add((Component)jPanel6, "South");
        jPanel3.add((Component)jPanel4, "East");
        this._mainPanel.add((Component)jPanel3, "Center");
        jPanel.add((Component)this._mainPanel, "Center");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        this._okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!BaseImageConfigDialog.this._useImageCheckbox.isSelected() || BaseImageConfigDialog.this._mapSourceDropdown.getSelectedIndex() >= 0 && BaseImageConfigDialog.this._zoomDropdown.getSelectedIndex() >= 0) {
                    BaseImageConfigDialog.this.storeValues();
                    BaseImageConfigDialog.this._dialog.dispose();
                }
            }
        });
        jPanel7.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BaseImageConfigDialog.this._dialog.dispose();
            }
        });
        jPanel7.add(jButton);
        jPanel.add((Component)jPanel7, "South");
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    BaseImageConfigDialog.this._dialog.dispose();
                }
            }
        };
        this._useImageCheckbox.addKeyListener(keyAdapter);
        this._mapSourceDropdown.addKeyListener(keyAdapter);
        this._zoomDropdown.addKeyListener(keyAdapter);
        this._okButton.addKeyListener(keyAdapter);
        jButton.addKeyListener(keyAdapter);
        return jPanel;
    }

    private void updateImagePreview() {
        this._downloadTilesButton.setVisible(false);
        this._tilesFoundLabel.setText("");
        this._imageSizeLabel.setText("");
        if (this._useImageCheckbox.isSelected() && this._mapSourceDropdown.getSelectedIndex() >= 0 && this._zoomDropdown.getItemCount() > 0 && this._zoomDropdown.getSelectedIndex() >= 0) {
            this._previewPanel.startLoading();
            new Thread(this).start();
        } else {
            this._previewPanel.setImage(null);
        }
    }

    private void storeValues() {
        this._imageDef.setUseImage(this._useImageCheckbox.isSelected(), this._mapSourceDropdown.getSelectedIndex(), this.getSelectedZoomLevel());
        this._parent.baseImageChanged();
    }

    @Override
    public void run() {
        int n = this._mapSourceDropdown.getSelectedIndex();
        int n2 = this._zoomDropdown.getSelectedIndex();
        if (!this._useImageCheckbox.isSelected() || n < 0 || n2 < 0) {
            return;
        }
        MapSource mapSource = MapSourceLibrary.getSource(n);
        GroutedImage groutedImage = this._grouter.createMapImage(this._track, mapSource, this.getSelectedZoomLevel());
        if (this._useImageCheckbox.isSelected() && this._mapSourceDropdown.getSelectedIndex() == n && this._zoomDropdown.getSelectedIndex() == n2 && groutedImage != null) {
            this._previewPanel.setImage(groutedImage);
            int n3 = groutedImage.getNumTilesTotal() - groutedImage.getNumTilesUsed();
            boolean bl = n3 > 0 && n3 < 50 && Config.getConfigBoolean("prune.onlinemode");
            this._downloadTilesButton.setVisible(bl);
            this._downloadTilesButton.setEnabled(bl);
            this._tilesFoundLabel.setText(String.valueOf(groutedImage.getNumTilesUsed()) + " / " + groutedImage.getNumTilesTotal());
            if (groutedImage.getImageSize() > 0) {
                this._imageSizeLabel.setText("" + groutedImage.getImageSize());
            } else {
                this._imageSizeLabel.setText("");
            }
        } else {
            this._previewPanel.setImage(null);
            this._downloadTilesButton.setVisible(false);
            this._tilesFoundLabel.setText("");
            this._imageSizeLabel.setText("");
        }
    }

    private int getSelectedZoomLevel() {
        int n = 0;
        try {
            n = Integer.parseInt(this._zoomDropdown.getSelectedItem().toString());
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception.getClass().getName() + " : " + exception.getMessage());
        }
        return n;
    }

    public boolean getFoundData() {
        return this._imageDef.getUseImage() && this._imageDef.getZoom() > 0 && this._previewPanel != null && this._previewPanel.getTilesFound();
    }

    public boolean isSelectedZoomValid() {
        int n;
        double d = Math.max(this._track.getXRange().getRange(), this._track.getYRange().getRange());
        int n2 = (int)(d * (double)(n = 1 << this._imageDef.getZoom()) * 256.0);
        return n2 > 100 && n2 < 4000;
    }

    public MapGrouter getGrouter() {
        return this._grouter;
    }

    private void downloadRemainingTiles() {
        this._downloadTilesButton.setEnabled(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                BaseImageConfigDialog.this._progressBar.setVisible(true);
                MapGrouter mapGrouter = new MapGrouter();
                int n = BaseImageConfigDialog.this._mapSourceDropdown.getSelectedIndex();
                if (!BaseImageConfigDialog.this._useImageCheckbox.isSelected() || n < 0) {
                    return;
                }
                MapSource mapSource = MapSourceLibrary.getSource(n);
                mapGrouter.createMapImage(BaseImageConfigDialog.this._track, mapSource, BaseImageConfigDialog.this.getSelectedZoomLevel(), true);
                BaseImageConfigDialog.this._progressBar.setVisible(false);
                BaseImageConfigDialog.this._grouter.clearMapImage();
                BaseImageConfigDialog.this.updateImagePreview();
            }
        }).start();
    }
}

