# Griffith ChangeLog
------------------
## (c) 2005-2014  Vasco Nunes, Piotr Ożarowski

---- 0.17 ----

2021-01-06 Dan Johansen

* Fix Makefile according to [Arch Linux build patch](https://github.com/archlinux/svntogit-community/blob/packages/griffith/trunk/build.patch)
* Fix compatability with Python 3.9

---- 0.16 ----

2020-07-25 Dan Johansen and John Cheetham

* Fix IMDb movie plugin
* Add DVDfr movie plugin
* Add danish translation to desktop file
* Fix TMDb movie plugin
* Change a couple of links from old address to new address of this repository

2019-12-28 Ed Brandon

* Add DVDfr movie plugin, maintained by Ed Brandon

---- 0.15 ----

2017-11-18  John Cheetham

* Port to python3 / GTK3 (pygi)

---- 0.14 ----

2017-08-23  Dan Johansen and Joshua Gentry

* Changed www.griffith.cc to www.google.com for network check
* Updated IMDb plugin
* Fixed poster size
* Copied source from launchpad, now on gitlab/github.
* Tagged as 0.14.

2014-03-13  Michael Jahn

* [#1290146] imdb searches
* [#1271874] "weitere Titel" werden in Originaltitel übernommen

2013-12-16  Michael Jahn

* better handling of temporary poster files
	
2013-12-09  Michael Jahn

* IMDb plugin updated

2013-12-03  Michael Jahn

* IMDb plugin updated

2013-11-17  Michael Jahn

* [#1251923] poster not loaded from CSFD

2013-11-12  Michael Jahn

* [#1250013] Allocine plugin do not populate the fields

2013-10-17  Michael Jahn
	
* IMDb plugin updated
* [#1235747] IMDB fields not populating
* [#1239178] IMDB fails to populate some fields
* [#1236093] IMDB failure starting around 25 Sept 2013
* [#1240477] IMDB not Downloading All Fields in 0.13 for Linux

2013-10-04  Michael Jahn

* FilmeAffinity movie plugin updated
* [#1210828] FilmAffinity
* [#1216572] [FilmAffinity plugin] doesn't show the list of movies

2013-09-27  Michael Jahn
	
* FilmeVonAZ movie plugin updated

2013-06-26  Michael Jahn

* [1194709] DVDEmpire plugin stopped returning results

2013-06-24  Michael Jahn

* [1174569] FilmAffinity plugin does not work since today

2013-06-01  Michael Jahn

* PDF export plugin updated
	
2013-05-24  Michael Jahn

* Allocine movie plugin updated

2013-04-02  Michael Jahn

* [1039068] Return the list of films sorted; added sorting by title for result lists

2013-02-21  Michael Jahn

* IMDb and Cinemovies movies plugin updated

2013-01-30  Michael Jahn

* FilmeVonAZ and OFDb movie plugins updated

2013-01-28  Michael Jahn

* Kino.de and Cineteka movie plugins updated

2012-12-29  Michael Jahn

* remove movie plugin FilmDb (site doesn't exists anymore)

2012-12-16  Michael Jahn

* fixed backup for databases other than sqlite

2012-12-06  Michael Jahn

* fixed IMDb plugins for direct search results

2012-11-29  Michael Jahn

* [1084608] IMDB does not work from November 28, 2012; fixed IMDb plugins

2012-11-20  Michael Jahn

* fixed Allocine plugin [663709]
	
2012-08-30  Michael Jahn

* [1043263] importing GriffithXML fails: posters are not added

2012-08-29  Michael Jahn

* [1037249] typo in tellico spelling
	
2012-07-03  Michael Jahn

* DVD Palace movie plugin updated
	
2012-06-09  Michael Jahn

* DVD Palace movie plugin updated

2012-06-07  Michael Jahn

* [#1010073] The MoviePosterDB seems to have quit working properly.

2012-04-10  Vasco Nunes

* [#669431] Spell checker doesn't work

2012-04-02  Michael Jahn

* fixed Allocine plugin (V3 API) (thanks to CinéphOli)

2012-01-29  Michael Jahn

* [#923416] Connection failed. (Amazon plugin)
* [#913299] importing covers gives list index out of range
* [#913283] importer: 'poster' overwritten by 'image'

2012-01-10  Piotr Ożarowski

* Filmweb movie plugin updated (thanks to mariusz2806)

2012-01-08  Piotr Ożarowski

* Tellico import plugin added (thanks to Elan Ruusamäe)

2012-01-07  Ivo Nunes

* Added a plugin for the portuguese website www.dvdpt.com

2012-01-02  Michael Jahn

* [#909513] code errors in import plugins

2011-12-27  Michael Jahn

* better error handling for PDF export plugin

2011-12-26  Piotr Ożarowski

* Restoring database from backup fixed

---- 0.13 ----

2011-12-18  Piotr Ożarowski

* Filmweb movie plugin updated (thanks to mariusz2806)

2011-12-02  Michael Jahn

* [#888347] FilmAffinity plugin doesn't work
* [#897774] removal of the first added subtitle format is not possible

2011-12-01  Michael Jahn

* [#885914] Amazon Plugin in Griffith doesn't work

2011-09-14  Michael Jahn

* [#815421] add ipython 0.11 compatibilty (thanks to Julian Taylor)

2011-09-12  Michael Jahn

* added limited urllib2 support

2011-09-04  Piotr Ożarowski

* AniDB movie plugin rewritten (uses HTTP XML API now) - needs lxml module

2011-09-01  Michael Jahn

* updated Allocine plugin, switch to JSON api
* added database maintenance extension

2011-08-30  Michael Jahn

* updated plugins: AllRovi, Cinemovies, Cineteka, CSFD, IMDb, Zelluloid

2011-08-23  Michael Jahn

* added buttons to remove and add a poster within the movie edit dialog
* fixed bug in extension "remover", it doesn't work if a criteria is required (f.e. adv filter with "required tag" did only remove the tags not the movie entries)
* extension remover now respects the simple filter condition

2011-08-20  Michael Jahn

* updated KinoDe plugin
* new icons for loading and removing posters (toolbar and menu are now the same icons)

2011-08-10  Michael Jahn

* added new icons for the extensions (thanks to CinéphOli)

2011-07-18  Michael Jahn

* configurable default value for field "seen it"
* ability to switch the behaviour of the live search that it queries only after enter is pressed (switchable via griffith.cfg only); good for bigger databases
* [#811685] IMDB movie ratings not updating when adding new movie

2011-06-22  Filippo Valsorda

* Fixed and completed PluginMovieMyMoviesIt (hidden bug)
* Added gutils.rtrim (think at string.rfind)

2011-06-20  Filippo Valsorda

* Refresh IMDB-it plugin

2011-06-20  Michael Jahn

* [#570053] Region selection shows DVD regions when media is not DVD. (added Bluray regions)

2011-06-17  Michael Jahn

* [#725810] CSFD plugin is not working

2011-06-16  Michael Jahn

* [#721033] Wrong behaviour

2011-06-13  Michael Jahn

* [#789246] movies.studio field length too short in postgres. Added a LengthValidator which truncates text fields

2011-06-01  Ivo Nunes

* fixed crash when you try fetching a movie's information without internet connection

2011-05-23  Michael Jahn

* updated MyMoviesIt plugin (full cast, screenplay, cameraman, director)
* [#721036] Problem to add a movie

2011-05-18  Michael Jahn

* updated CineMovies plugin (thanks to Olivier BOURSIN)
* small fixes for Allocine and AllRovi plugin
* added quick search for any field in the main window (thanks to Daniel Fetchinson)

2011-05-12  Michael Jahn

* added "virtual" resolutions (4:3 Fullscreen, Widescreen, Anamorphic Widescreen)

2011-05-05  Michael Jahn

* fixed movie plugin AllMovie, it is now AllRovi
* small fixes for CineMovies and HKMDB

2011-04-27  Filippo Valsorda

* New Interfilmes plugin by Elencarlos Soares

2011-04-22  Filippo Valsorda

* New CSFD plugin by Kamil Hanus
* Minor fixes in IMDB-it and MyMoviesIt plugins
* Fixed a typo in it.po

2011-03-20  Piotr Ożarowski

* "spellchekcer" typo fixed (thanks to Olivier BOURSIN)

2011-02-17  Vasco Nunes

* Added native Cocoa generic dialogs under macosx, using pyobjc.

2011-02-13  Piotr Ożarowski

* SQLAlchemy 0.7 compatibility changes

2011-02-12  Vasco Nunes

* Implemented MultiSelection support in MainTreeView
* Re-implemented macosx menubar integration 

2011-02-10  Michael Jahn

* [#716176] 0.12.1 No postgres support on Windows

2011-02-07  Ivo Nunes

* Changed the way Mac OS X creates a new database so that it doesn't open external applications
* Fixed exporting under Mac OS X

2011-02-06  Ivo Nunes

* Fixed creating a new database and restoring backups under Mac OS X

2011-02-05  Vasco Nunes

* [#703576] no automatic refresh after get back a dvd
* Sync mac menubar when menu checkMenuItems are changed
* Fixed about dialog on macosx

2011-02-05  Ivo Nunes

* Fixed and re-enabled Mac OS X UI Cocoa menu integration
* Mac OS X UI Cocoa menu integration temporarily disabled due to being broken - using native GTK
* IMDB-pt plugin added

2011-02-03  Vasco Nunes
	
* MoviePTGate plugin updated
* Added MacOSX UI integration
* Some minor macosx specific changes

2011-02-02  Michael Jahn

* [#710860] cannot import imdb movie titles starting with a bracket
* [#708472] Upgrade 0.11-0.12 fails with PostgreSQL
* [#711015] [Enhancement][Plugin FilmAffinity] See the movie year in movie list

2011-02-01  Michael Jahn

* HTML export: sorting entries case-insensitive and respect current locale settings

2011-01-25  Michael Jahn

* [#300808] forgets some inputs in languages like codex&tracks

2011-01-21  Michael Jahn

* drop-down combobox for resolution field

2011-01-19  Michael Jahn

* [#700704] Incorrect dialog size for posters
* [#493148] The Save button in the preferences window does not work well
* open of the homepage from the about dialog fixed
* enabling persons without email address

2011-01-17  Michael Jahn

* [#703728] FilmAffinity: incomplete list of results

2011-01-16  Michael Jahn

* [#697018] CSV import not working when number field not checked
* [#702495] griffith start interrupts with "TypeError: value is of the wrong type for this column"

2011-01-14  Michael Jahn

* [#687621] Remains previous cover
* [#697029] Import dlg display error when previously x-ed out 

2011-01-13  Michael Jahn

* KinoDe, IMDB-de, CineMovies and Zelluloid plugin updated

2011-01-10  Michael Jahn

* fixed iPod export plugin in case of missing values
* fixed deletion of the "created" value while updating a movie

2010-12-07  Piotr Ożarowski

* Fix few spelling mistakes (thanks to Olivier BOURSIN)

2010-12-03  Michael Jahn

* Zelluloid plugin updated

2010-11-23  Michael Jahn

* added screenplay, cameraman and barcode to the search criteria combobox
* sorted entries in the filter comboboxes of the main dialog

2010-11-16  Michael Jahn

* added fields screenplay, cameraman, width, height and barcode to the html export plugin

---- 0.12.1 ----

2010-10-18  Piotr Ożarowski

* Version changed to 0.12.1

2010-10-18  Michael Jahn

* stabilized upgrade procedure for databases which are corrupt after an interuption of a previous upgrade procedure
* enabled interactive search by number, title and original title in mainlist ("typeahead find")

2010-10-17  Michael Jahn

* Allocine plugin updated
* error fixed which prevents updates from pre-0.11 versions

2010-10-14  Michael Jahn

* E-Pipoca plugin updated

2010-10-09  Michael Jahn

* OFDb and IMDb plugin updated

2010-10-08  Piotr Ożarowski

* Filmweb movie plugin updated (thanks to Mariusz Szczepanek)

2010-10-08  Michael Jahn

* IMDb plugin updated

---- 0.12 ----

2010-10-03  Piotr Ożarowski

* Update translations
* Version changed to 0.12

2010-10-01  Michael Jahn

* [#640219] Original title is not well raised by Allocine plugin

2010-09-30  Michael Jahn

* saving the width of the columns of the mainlist
* default filter operator changed from equals to contains

2010-09-29  Michael Jahn

* added fields "created" and "updated" to movie entries

2010-09-25  Michael Jahn

* [#502990] Own settings will not be saved in HTML-Export

2010-09-15  Michael Jahn

* workaround for [#574370] freeze when i select existing mysql database

2010-08-29  Piotr Ożarowski

* Show deprecation warnings only in debug mode

2010-08-26  Michael Jahn

* small backup optimizations

2010-08-22  Michael Jahn

* reintroduce menu entry for loading and removing cover posters

2010-07-21  Michael Jahn

* compatibility fixes for sqlalchemy 0.6
* adjusting sqlite page size to the value of the filesystem page size
	  (performance optimization)

2010-07-15  Michael Jahn

* updated movie plugin FilmeVonA-Z

2010-07-14  Michael Jahn

* updated movie plugin AniDB

2010-06-25  Michael Jahn

* updated movie plugin KinoDe
* added HKMDB movie plugin
* [#596700] IMDB doesn't import original title correctly

2010-06-07  Michael Jahn

* added Clubedevideo movie plugin

2010-05-10  Michael Jahn

* updated movie plugin IMDB-de
* poster md5 wasn't saved if poster is already in database

2010-05-06  Michael Jahn

* [#324171] PDF Font Size
* support for covers, year, runtime, notes and plot for PDF export
	  elements for export can be deselected

2010-04-28  Piotr Ożarowski

* Use 255 as maximum string length for few fields (MySQL apparently
	  doesn't like >=256 on some configurations)

2010-04-21  Michael Jahn

* updated movie plugin AniDB

2010-03-28  Michael Jahn

* updated movie plugin WP

2010-03-27  Michael Jahn

* updated movie plugin IMDb-de, IMDb-es, Zelluloid

2010-03-12  Michael Jahn

* updated movie plugin DVDPalace

2010-03-04  Michael Jahn

* new import plugin: GriffithXML

2010-03-02  Michael Jahn

* [#525039] crashed while adding films wont reboot linux mint 8
* [#525869] Plugin FilmAffinity (ES) doesn't import genre
* IMDb movie plugin updated

2010-01-17  Michael Jahn

* Scope movie plugin added

2010-01-05  Michael Jahn

* delete button added to the advanced filter dialog
* updated movie plugin Cinematografo (year added to result list entries)

---- 0.11 ----

2010-01-09  Piotr Ożarowski

* Replace "Aspect ratio" field with "Resolution" (aspect ratio is hidden
	  for now)
* MyMoviesIt movie plugin updated (thanks to FiloSottile)

2010-01-06  Piotr Ożarowski

* Some cleanups

2010-01-05  Michael Jahn

* save and restore sorting column in main list
* updated movie plugin Stopklatka

2010-01-04  Piotr Ożarowski

* Add Croatian translation (thanks to Davor I and nafterburner)

2010-01-04  Michael Jahn

* add MoviePosterDB extension (supports fetching posters)

2010-01-03  Michael Jahn

* added column header row and some more columns to the basic CSV export
* added support of adding new collections, volumes, medium and vcodecs while importing data
	  (regards different import plugins)
* added support for fields screenplay, cameraman and barcode to the CSV import plugin

2010-01-01  Michael Jahn

* [#501526] Error in export GCStar/DVDProfilerXMLExportV2/3
* updated movie plugin Allocine

2009-12-28  Michael Jahn

* updated movie plugin Allocine, Amazon, FilmDb
* updated import plugin CSV
	  (optional auto-detect dialect settings, fixed pre-selection of encoding)

2009-12-23  Michael Jahn

* updated movie plugin Cinematografo

2009-12-22  Piotr Ożarowski

* Fix few spelling mistakes (thanks to Sean Cass)
* Version changed to 0.11

2009-12-21  Michael Jahn

* updated movie plugin Kino.de, Cinematografo

2009-12-20  Piotr Ożarowski

* Add "Extensions toolbar" menu item

2009-12-15  Michael Jahn

* new import plugin: MovieTrack

2009-12-12  Michael Jahn

* new import plugins: All My Movies, BES The Movie Library, Fox Movie Manager, MyDVDs, The Movie Library
	  (all MS Access / Jet DB based)
* cleanup import sections of other import plugins

2009-12-08  Michael Jahn

* [#486258] no refresh when a filter is active
* [#418911] It doesn't import cover art from FilmAffinity
* movie plugin test data updated

2009-12-01  Michael Jahn

* re-introducing a debug window on windows platforms (activated via --debug)

2009-11-22  Michael Jahn

* wintoolz Filmdatenbank import plugin added
* [#480380] Extensions: Amazon and Remover

2009-11-18  Michael Jahn

* fixed some issues with the functions "new db" and "restore db"
* [#480366] ImportError: No module named extensions

2009-11-17  Michael Jahn

* load and save of extensions preferences
* [#484385] Export to XML: no image filename exported to XML-File

2009-11-10  Michael Jahn

* updated movie plugins Allocine and FilmAffinity

2009-11-06  Michael Jahn

* Personal Video Database import plugin added
* fixed amazon binding (generation of signed urls added but
	  every user needs an amazon account for the access key and secret key)

2009-10-16  Michael Jahn

* eXtreme Movie Manager import plugin added
* import support for movie detail video codec
* "Remover" extensions removes associated tags and languages
	  before removing the movie entry

2009-10-13  Michael Jahn

* support for posters for import plugins GCstar and AMC
* [#410362] AMC importer doesn't import cover pictures

2009-10-07  Michael Jahn

* DVD Profiler import plugin added
* very small update for AMC import plugin (medium typ)
* import base class: support for looking up medium types and adding tags,
	  barcode, cameraman, screenplay
* import stabilized with try-except and error message box

2009-09-30  Piotr Ożarowski

* Change log format

2009-09-29  Michael Jahn

* GCstar import plugin added

2009-09-26  Piotr Ożarowski

* Display popup message during database upgrades

2009-09-25  Michael Jahn

* Amazon movie plugin updated

2009-09-14  Piotr Ożarowski

* Add "Remover" extension (removes selected movies)

2009-09-02  Michael Jahn

* [#336855] Error being reported saving posters
	  cleanup of generating thumbnail versions of the images
	  and filenames for default image/thumbnail

2009-08-28  Piotr Ożarowski

* [Bug 420462] --clean fixed

2009-08-26  Michael Jahn

* [#418911] It doesn't import cover art from FilmAffinity

2009-08-20  Piotr Ożarowski

* Add pool_recycle parameter in config file and set the default to 1 hour
	  (SQLAlchemy will recycle MySQL connections after given number of seconds
	  of inactivity - fixes "MySQL server has gone away" issue)

2009-08-18  Piotr Ożarowski

* Fix update_movie() to actually load the image

2009-08-13  Piotr Ożarowski

* Add 'Mark as seen' extension
* Allow PNG images to be used as toolbar icons by extensions
* gutils.question now returns True or False

2009-08-12  Piotr Ożarowski

* Remove Amazon stuff from preferences window
* Region 2 and 4 names shorten (to fit in preferences window)
* Show tabs on the left side of preferences window
* Show extension settings in preferences

2009-08-11  Piotr Ożarowski

* Add Player extension

2009-08-09  Piotr Ożarowski

* Version changed to 0.11~svn
* Initial structure for extensions created
	  + ~/.griffith/lib/extensions can be used for user's extensions
* Amazon posters feature converted to Griffith extension

---- 0.10 ----

2009-08-03  Piotr Ożarowski

* Releasing 0.10

2009-07-13  Piotr Ożarowski

* Version changed to 0.10-rc1+svn
* Filtering Volumes/Collections by loaned flag fixed

---- 0.10-rc1 ----

2009-07-12  Piotr Ożarowski

* Loaning collections with lots of movies inside will work faster now
* AniDB movie plugin updated (thanks to nickpick)
* Translation files synchronized with Rosetta

2009-07-10  Michael Jahn

* new export plugins: Ant Movie Catalog, GCstar, DVD Profiler XML Export V2 and V3

2009-07-07  Michael Jahn

* updated Allocine, CineMovies, IMDb-de, MovieMeter, Zelluloid plugin

2009-07-06  Piotr Ożarowski

* Reorganize ORM stuff file structure (db module moved to db package)

2009-07-05  Piotr Ożarowski

* Use SQLAlchemy's PickleType to store search conditions
	  (old rules are removed without warning - beta version privilege ;)
* Remove ilike from search criteria
* Update current value of sequence after restoring data from backup in
	  PostgreSQL
* Loan details and history added to the movie db model

2009-07-04  Piotr Ożarowski

* Version changed to 0.10-beta3+svn
* [#305123] If Region 0 (no region data) is selected, save "0" in
	  database otherwise default region will be used
* Mail content can be translated again (gettext issue fixed)
* [#269865] Don't change movie plugin selection after adding a movie
* Rollback all pending operations before creating new database
* Poster window (if visible) is updated along with current movie change

2009-07-03  Michael Jahn

* updated IMDb plugin
* added Ant Movie Catalog import plugin

---- 0.10-beta3 ----

2009-06-11  Piotr Ożarowski

* Don't try to open advfilter window if it's already opened
* Add "Full screen" switch in View menu
* Add "Open search window" in Tools menu
* Add "Select database" in File menu (shortcut to preferences page)
* Close poster viewer window if poster button clicked again
* Add suggestions for database names (taken from .db file names)
* Translation files synchronized with Rosetta
* Releasing 0.10-beta3

2009-06-10  Piotr Ożarowski

* Restoring from backup finally works with external databases
* Don't save full paths in backups
* Backup from MySQL fixed

2009-06-08  Piotr Ożarowski

* Restoring from backup to PostgreSQL/MySQL partially works via merging

2009-06-07  Piotr Ożarowski

* Recognize more resolution aliases

2009-05-24  Michael Jahn

* updated CineMovies, FilmAffinity, FilmDb, OFDb plugin
* added proxy support for MovieMeter plugin

2009-05-18  Michael Jahn

* [#377417] URL contains non-ASCII characters

2009-05-05  Michael Jahn

* added MovieMeter plugin

2009-04-17  Michael Jahn

* updated FilmAffinity plugin
* updated Filmtipset plugin

2009-04-16  Michael Jahn

* updated Culturalia plugin
* updated E-Pipoca plugin

2009-04-15  Michael Jahn

* added data for automated tests of the IMDB plugin
* added data for automated tests of the CineMovies plugin
* updated CineMovies plugin
* updated Cineteka plugin
* updated FilmDb plugin

2009-04-08  Michael Jahn

* added AllMovie plugin

2009-04-06  Michael Jahn

* [#348226] DVD Empire lookup problem

2009-04-05  Michael Jahn

* [#269907] PluginMovieFilmDb.py: list index out of range
	  and complete update of the plugin with test data

2009-04-02  Michael Jahn

* IMDB-de plugin updated

2009-03-29  Michael Jahn

* [#224546] Plot isn't being pulled from IMDB for some movies
* [#341826] "Country" field from IMDB contains newlines

2009-03-10  Michael Jahn

* [#337758] 'Titel' and 'Original Titel' get the same content
	  (IMDb-de plugin updated)
* added HD DVD and Blu-ray to the medium table for new databases

2009-03-03  Michael Jahn

* Cinematografo movie plugin updated

2009-02-28  Michael Jahn

* screenplay, cameraman, resolution and barcode added to Search-For
	  section in preferences

2009-02-24  Michael Jahn

* Amazon posters: removing of temporary files fixed

2009-02-12  Piotr Ożarowski

* Add new default tag: "Buy me"

2009-02-11  Piotr Ożarowski

* Version changed to 0.10-beta3~svn
* Backup function fixed
* PostgreSQL/MySQL backup support added

---- 0.10-beta2 ----

2009-02-10  Piotr Ożarowski

* Fix upgrading from v2 to v4 (columns that are not available yet, are not
	  used)
* Releasing 0.10-beta2

2009-02-07  Michael Jahn

* CineMovies movie plugin updated

2009-02-05  Michael Jahn

* AniDB movie plugin updated

2009-02-01  Piotr Ożarowski

* Add interactive shell (--shell commandline option)
* Add barcode column to the movie table
* Add resolution (width and height columns) to the movie table
* Change default type of runtime and year to SmallInteger

2009-01-31  Michael Jahn

* Allocine movie plugin updated
* small unicode fixes for 7arte movie plugin

2009-01-28  Michael Jahn

* FilmAffinity movie plugin updated

2009-01-24  Michael Jahn

* DVD-Palace movie plugin updated

2009-01-22  Michael Jahn

* fixed Greek translation of the word "Danish" (thanks to Johnny)

2009-01-18  Piotr Ożarowski

* Upgrading from 0.6.2 partially fixed (posters are missing)
* Add loaned_movies_count and returned_movies_count properties to Person

2009-01-17  Piotr Ożarowski

* Use MediumBLOB on MySQL to store posters. Database has to be recreated
	  if 0.10-beta1 was used to create it.
* Few SQL optimizations

2009-01-16  Piotr Ożarowski

* Print move details during startup in debug mode

2009-01-16  Michael Jahn

* [#317837] 007 james bond (PDF export grouping error)

2009-01-15  Michael Jahn

* Amazon movie plugin updated
* better results for amazon poster search
* movie plugin base class prepared for fetching screenplay and cameraman,
	  added fetching of screenplay to IMDB plugin 

2009-01-06  Michael Jahn

* MovieFone movie plugin updated
* windows installer: movie import plugins deselectable from installation

2009-01-04  Piotr Ożarowski

* MyMoviesIt movie plugin added (thanks to Giovanni Sposito)

2009-01-03  Michael Jahn

* [#313012] correctly round ratings

2009-01-02  Michael Jahn

* PTGate movie plugin updated

2008-12-25  Michael Jahn

* [#309373] export to pdf
* Cinematografo movie plugin updated

2008-12-19  Michael Jahn

* OFDb, IMDB-de movie plugin updated

2008-12-16  Michael Jahn

* IMDB movie plugin updated

2008-12-16  Piotr Ożarowski

* Reload movie plugin each time search is performed (in --debug mode only,
	  this should ease writing plugins)
* Canceling search doesn't throw exception anymore (closes: 100038)

2008-12-07  Piotr Ożarowski

* update_image(): update the md5 *after* all other queries (so that UPDATE
	  will not be invoked)

2008-12-07  Piotr Ożarowski

* CSFD movie plugin updated (thanks to Aleš Nejdr)

2008-12-03  Piotr Ożarowski

* Add few indexes to the model

2008-12-01  Piotr Ożarowski

* HTML export plugin exports posters again (closes: 304072)

2008-11-30  Piotr Ożarowski

* CSFD movie plugin updated (thanks to Otakar)

2008-11-25  Michael Jahn

* fixed some amazon and unicode errors

2008-11-22  Michael Jahn

* use unicode for fetched html pages in general
* fixed rating, runtime and year are not shown with MySQL backend

2008-11-10  Michael Jahn

* optimized windows setup related code, added links to documentation
	  files, forum and wiki to the installer

2008-11-18  Piotr Ożarowski

* Version changed to 0.10-beta2~svn
* command line's search fixed

---- 0.10-beta1 ----

2008-11-17  Piotr Ożarowski

* Add --version/-v command line options
* Add bash completion script
* Version changed to 0.10-beta1
* Update Polish translation

2008-11-16  Piotr Ożarowski

* fail if database requires newer Griffith version
* Rename backup/restore menu items
* Warn about developement version only once
	  + home / config/ posters directory detected before initializing Griffith

2008-11-15  Piotr Ożarowski

* Export plugins are now exporting movies listed in main window
* Replace "by ..." quick filter combo boxes with saved search conditions

2008-11-13  Piotr Ożarowski

* update translations
* sync with 0.9.x branch

2008-11-10  Michael Jahn

* updated plugins IMDB-de, Amazon, Kino.de, FilmeVonAZ

2008-11-01  Michael Jahn

* updated IMDB plugin

2008-10-26  Michael Jahn

* [#179618] During "Get from Web ", griffith window keeps stealing focus

2008-10-23  Michael Jahn

* PDF export: disabled movie grouping if movie list is not sorted by title
	  or original title
* [#258817] The application doesn't save volume

2008-10-25  Piotr Ożarowski

* add load/save search conditions

2008-10-23  Michael Jahn

* updated IMDB-de, Kino.de, Zelluloid plugin
* added original url check within plugin test

2008-10-23  Piotr Ożarowski

* clean/restore search conditions in advfilter

2008-10-19  Piotr Ożarowski

* Add more filter movie rules to the search window
* Screenplay and cameraman added to main/add windows

2008-10-18  Piotr Ożarowski

* Speed up import movies function

2008-09-23  Michael Jahn

* [#273172] "Properties/Volume/show...in this volume" is broken

2008-09-14  Piotr Ożarowski

* Warn about backups when starting develpement version
* seen/loaned settings available in adv. filter window (much more to come
	  soon)

2008-09-13  Piotr Ożarowski

* Loaning movies is working again

2008-09-12  Piotr Ożarowski

* Validate loan contact's email address
* Python required version bumped to 2.4 (it was required for a while
	  aready)
* Use SQLAlchemy's validate decorator (minimum required SA version bumped
	  to 0.5rc1)

2008-09-09  Piotr Ożarowski

* Add aspect ratio, cameraman and screenplay to the database

2008-08-16  Michael Jahn

* fixed support for german umlauts in OFDb plugin
* added Amazon plugin (supports search by UPC/EAN)
* added Amazon language support for CA and FR
* Amazon support is now closer to the current specification
* encoding error in plugins Kino.de and Zelluloid

2008-08-14  Michael Jahn

* pdf export: group movies with numbers 0-9 (thanks to Luigi Pantano)
* pdf export: [#174463] Database Export as PDF doesn't work under Ubuntu

2008-08-12  Piotr Ożarowski

* Don't refresh movie list while updating quick filter combos
* FDb movie plugin updated (thanks to Bartosz Kurczewski)

2008-08-03  Piotr Ożarowski

* Initial advanced search/filter function implemented (alpha stage)

2008-08-02  Piotr Ożarowski

* Use unicode in gettext and SQLAlchemy
* Move all posters to database, create local cache

2008-07-31  Piotr Ożarowski

* Replace gdebug with Python's logging module
* Add posters table (to store posters in database)

2008-07-30  Michael Jahn

* [#253272] extra information columns not loaded on startup
* extended debug support on windows platforms

2008-07-28  Piotr Ożarowski

* Switch back to 4 spaces indentation
* Rewrite SQLAlchemy related data to use session (to ease accessing
	  simultaneously multiple databases)

---- 0.9.7.1 ----

2008-07-26  Piotr Ożarowski

* Links to Griffith's homepage and bug tracker updated
* Version changed to 0.9.7

2008-07-24  Michael Jahn

* main treeview doesn't accept DB-NULL or empty strings for the int-fields
	  rating, year and runtime

2008-07-24  Michael Jahn

* Windows only: set_wrap_width doesn't work in filter toolbar without side
	  effects if GTK 2.12.9 is used
* updated INSTALL file to new versions (GTK, Glade, PyGTK, py2exe,
	  pywin32, Inno Setup)
* fixed URL creation in setup script; added removing of .pyo files if
	  deinstalled

---- 0.9.7 ----

2008-07-21  Piotr Ożarowski

* Fixed HTML export plugin (sorting issue)
* Amazon posters - don't fail if LargeImage attribute is not set
* Filmweb movie plugin updated (thanks to mariusz2806)
* Added Latvian translation (thanks to Aleksandrs Zdancuks)
* Added Ukrainian translation (thanks to vazaz)
* Updated translations: bg, ca, da, de, el, es, fr, it, nb, pt, pt_BR, ru,
	  sv, tr
* Version changed to 0.9.7

2008-07-18  Michael Jahn

* added User-Agent support, because some web sites doesn't like the Python
	  urllib default
* updated Zelluloid plugin
* support for accents in titles for searching if plugin needs it
	  (Zelluloid needs german umlauts)

2008-07-17  Michael Jahn

* updated OFDb plugin
* added column rating to the mainlist
* [#226269] default folders hardcoded (not fully fixed)

2008-07-13  Michael Jahn

* updated DVDEmpire plugin
* [#236598] scroll bar in filter "by volume" appears
* fixed loan label in main view if html entities are used in the name of a
	  person

2008-07-11  Michael Jahn

* added quick filter for tags
* [#244676] Griffith loses focus

2008-07-10  Michael Jahn

* updated Filmtipset plugin

2008-05-09  Michael Jahn

* added cast, genre and grouping by first letter to pdf export (thanks to
	  Luigi Pantano)

2008-05-08  Michael Jahn

* updated DVD Empire plugin

2008-04-25  Michael Jahn

* fixed fetching posters from Amazon 

2008-04-13  Michael Jahn

* updated OFDb plugin

2008-04-01  Michael Jahn

* fixed html export if sorted by collection, media, video codec or volume

2008-03-22  Piotr Ożarowski

* Python>=2.4's xml module compatibility added

2008-03-15  Michael Jahn

* quick filter for loaned-to

2008-03-04  Vasco Nunes

* Serbian language file updated (thanks to Sasa Petrovic) 
* Portuguese language file updated

2008-02-18  Piotr Ożarowski

* Filmweb movie plugin updated (thanks to Mariusz)
* Windows 64 bit is not detected correctly

2008-02-12  Michael Jahn

* fixed selecting of quick filter volume and collection in main view

2008-02-11  Vasco Nunes

* Added serbian language file (thanks to Sasa Petrovic) 

2008-02-09  Michael Jahn

* sort collection list and volume list by name

2008-02-03  Michael Jahn

* hit enter key in title/original title box starts retrieving data from
	  web for a new entry
* HTML export: replace linebreaks with <br /> in the data if "XHTML 1.0"
	  is found in the template header

---- 0.9.6 ----

2008-01-27  Michael Jahn

* Zelluloid plugin updated

2008-01-27  Piotr Ożarowski

* AniDB and Stopklatka movie plugins updated

2008-01-26  Piotr Ożarowski

* Translators tab (about dialog) filled in automatically

2008-01-13  Piotr Ożarowski

* Distribute local copy of SQLAlchemy 0.3.11 (Griffith 0.10 which will
	  work with SQLAlchemy 0.4.x is not ready yet)
* Version changed to 0.9.6
* Update .desktop file to Desktop Entry Specification's version 1.0

2008-01-10  Michael Jahn

* OFDb plugin updated

2008-01-06  Michael Jahn

* fixed pdf export with non-ascii characters [#174463]

2007-12-16  Piotr Ożarowski

* Version changed to 0.10~svn
* Started working on SQLAlchemy 0.4.x compatibility (NOT YET READY)

2007-12-08  Vasco Nunes

* Danish language file updated

2007-12-07  Vasco Nunes

* Spanish language file updated

2007-11-30  Michael Jahn

* HTML export supports video codec name
* quick filter for volumes
* export plugins remember the last directory which was used

2007-11-29  Vasco Nunes

* Russian language file updated

2007-11-28  Michael Jahn

* [#164966] deactivating spellchecker option in preferences dialog
	  disables the depending elements

2007-11-22  Michael Jahn

* added columns genre, seen, runtime and year to the mainlist
* enabled reorderable columns
* column order is saved

2007-11-12  Michael Jahn

* Kino.de plugin updated
* fixed pdf export with non-ascii characters in filenames and data
* pdf export supports sort column from configuration

2007-11-08  Michael Jahn

* status bar shows count of movies after applying a filter
* changed HTML export:
	  + exported poster file names contain the movie number instead of the
	    random name
	  + movies without a poster get the griffith picture

2007-10-15  Michael Jahn

* Kino.de plugin updated
* Fetch from Amazon function fixed

2007-09-20  Vasco Nunes

* Italian language file updated

2007-09-06  Vasco Nunes

* Berlios task [#003126] complete. Griffith's dir should point to
	  'Application Data' on windows systems.

2007-09-06  Michael Jahn

* save window state, position and size on windows systems
* save selected quick filter criteria
* fixed backup if path or filename contains special characters (like
	  german umlauts)
* use deflate for backup if available
* added auto-test feature for movie plugins (only used by developers;
	  execute test_movieplugins.py directly)
* FilmeVonAZ and OFDb plugin updated
* fixed saving media and vcodec defaults in preferences dialog

2007-09-03  Vasco Nunes

* Some documentations updates

---- 0.9.5 ----

2007-09-02  Piotr Ożarowski

* Translation files synchronized with Rosetta
	  + new: Catalan, Norwegian Bokmal
	  + uptaded: Brazilian Portuguese, Cech, Dutch, French, German, Italian,
	    Portuguese, Russian
* Polish translation updated
* Print cover function fixed (reportlab doesn't like unicode)

2007-09-02  Michael Jahn

* added support for media type, collection and volume in HTML export plugin
* added "auto-fixing" of config file values for defaults section

2007-09-01  Piotr Ożarowski

* Respect medium and video codec's default value in add window
	  (closes: #11864)
* griffith.glade file converted to glade3 format

2007-09-01  Michael Jahn

* Kino.de plugin updated
* Fix encoding of --home argument

2007-09-01  Vasco Nunes

* Several changes on loan e-mail reminder system:
		+ Loan E-mail reminder timeout implemented
		+ Support for TLS smtp auth handshaking
		+ Added smtp server port usage
		+ Added gmail smtp server support
* 7arte movie plugin updated
* Portuguese translation file updated

2007-08-31  Vasco Nunes

* Brazilian portuguese translation file updated

2007-08-26  Piotr Ożarowski

* Fix encoding problems in backup function

2007-08-23  Piotr Ożarowski

* Export disc number instead of medium id in HTML export plugin

2007-08-16  Michael Jahn

* IMDB-de plugin updated

---- 0.9.4 ----

2007-08-05  Piotr Ożarowski

* FDb movie plugin updated

2007-08-04  Piotr Ożarowski

* Removing tags function fixed
* Copy all files from "data" subdirectory to the exported location in HTML
	  export plugin
	  + add index.htm files to html_table{,s} templates
* Fixed volume/colection loaning problem

2007-08-01  Piotr Ożarowski

* Translation files synchronized with Rosetta
	  + new: Japanese, Russian and Turkish
	  + uptaded: Czech, Spanish, Bulgarian, Greek
* Polish translation updated

2007-07-31  Michael Jahn

* FilmTipset plugin added
* OFDb movie plugin updated

2007-07-21  Piotr Ożarowski

* Warn about problems with connecting to database (f.e. missing modules)

2007-07-09  Michael Jahn

* toggle seen/unseen by double-clicking the icon
* support for different database names with sqlite

2007-07-09  Piotr Ożarowski

* posters directory problem fixed (thanks to Michael)

2007-07-06  Vasco Nunes

* PTGate movie plugin updated

2007-07-04  Michael Jahn

* Kino.de movie plugin updated

2007-07-03  Michael Jahn

* DVD-Palace and IMDB-de movie plugin updated

---- 0.9.3.1 ----

2007-07-01  Piotr Ożarowski

* Problem with saving database preferences in config file fixed

---- 0.9.3 ----

2007-06-30  Piotr Ożarowski

* Use python2.5's sqlite3 module if available (no need to install
	  pysqlite2)
* Check dependencies at startup
* Detect old config while restoring data
* Stopklatka movie plugin updated

2007-06-29  Piotr Ożarowski

* Added Greek translation (thanks to Ioannis Koniaris)
* Added Simplified Chinese translation (thanks to kempson)
* Updated German, Spanish, French and Portuguese Brazilian translations
	  (from Rosetta)
* Updated Polish translations
* Do not register mime type in .desktop file

2007-06-29  Vasco Nunes

* 7arte.net and Cineteka movie plugins updated

2007-06-29  Piotr Ożarowski

* IMDb movie plugin updated

2007-06-27  Michael Jahn

* Kino.de movie plugin updated
* DVD-Palace movie plugin added

2007-06-25  Vasco Nunes

* Added Danish translation (thanks to Joe Dalton)

2007-06-20  Piotr Ożarowski

* Filmweb, WP and FDb movie plugins updated

2007-06-20  Michael Jahn

* fixed bug #11103: windows are not "on top"
* fixed bug #11088: Clone doesn't produce a new entry
* added script for database creation under Microsoft SQL Server (README)

2007-06-19  Vasco Nunes

* Portuguese translation updated
* winsetup script updated

2007-06-19  Piotr Ożarowski

* Polish translation updated

2007-06-17  Piotr Ożarowski

* Change "report bug" link in about menu
* Minor bug fixes

2007-06-13  Piotr Ożarowski

* Add sections to config file

2007-06-09  Vasco Nunes

* Added new alpha export plugin for iPods. Exports directly to iPod on
	  MacOSX for now, saves files in custom location on other platforms.Not
	  handling 4Kb iPod notes limit yet.

2007-05-31  Piotr Ożarowski

* IMDB, IMDB-de and KinoDe movie plugins updated (thanks to Michael Jahn)
* Resizable columns in add movie window's languages tab (thanks to Michael
	  Jahn)
* Increase runtime maximum value (thanks to Michael Jahn)
* Add Microsoft SQL support (thanks to Michael Jahn)

2007-05-22  Piotr Ożarowski

* Minor fix in dbupgrade.py

2007-05-19  Vasco Nunes

* French translation updated (thanks to Guillaume Pratte)
* IMDB plugin rating fix (thanks to babelfish)
* PTGate movie plugin encoding fixed
* E-pipoca movie plugin updated

2007-05-11  Jessica K. Parth

* OFDb updated

2007-05-01  Vasco Nunes

* E-Pipoca movie plugin updated (thanks to Djohnson "Joe" Lima)

2007-04-15  Piotr Ożarowski

* IMDB movie plugin updated to version 1.3 (director, rating)
* Fetch from Amazon function fixed ("No image available" image issue)

2007-04-11  Piotr Ożarowski

* Fixed medium_id and vcodec_id column type in movies table

2007-04-01  Piotr Ożarowski

* Added Dutch translation (thanks to Marcel Dijkstra)

2007-03-29  Piotr Ożarowski

* IMDB movie plugin updated
* IMDb-de movie plugin added (thanks to Michael Jahn)

2007-03-20  Piotr Ożarowski

* FilmDb and Zelluloid movie plugins added (thanks to Michael Jahn)

2007-03-11  Piotr Ożarowski

* Filmweb movie plugin updated (no more hangs if no movie info found
	  (closes #10601)
* Version changed to 0.9.2+svn
* New configuration file format (human readable) - please delete old one
	  manually

---- 0.9.2 ----

2007-02-20  Piotr Ożarowski

* IMDB movie plugin updated
* New seen/unseen icons (thanks to dragonskulle)
* About window updated

2007-02-19  Piotr Ożarowski

* CSFD movie plugin updated (still needs work)
* DVDEmpire movie plugin added (thanks to Michael Jahn)

2007-02-14  Piotr Ożarowski

* KinoDe and FilmeVonAZ movie plugins updated (thanks to Michael Jahn)

---- 0.9.1 ----

2007-02-13  Piotr Ożarowski

* KinoDe movie plugin updated (thanks to Michael Jahn)

2007-02-12  Piotr Ożarowski

* Fix broken databases automatically (return date will be set to
	  2007-01-01) - redo the upgrade process if you don't like it

2007-02-11  Piotr Ożarowski

* Fix one more bad case in upgrade function
* Fix setting loan status in upgrade function

2007-02-03  Jessica K. Parth

* OFDb movie plugin updated (website changed)

2007-01-27  Piotr Ożarowski

* English translation fixes (thanks Frijolie)

---- 0.9 ----

2007-01-26  Piotr Ożarowski

* WP and Filmweb movie plugins updated

2007-01-26  Jessica K. Parth

* Fix AniDB Problems in Windows ( file-open problem in movie.py )

2007-01-25  Piotr Ożarowski

* Fix more bad cases in upgrade from old DB function

2007-01-24  Piotr Ożarowski

* Fetch from Amazon function recognizes more posters now

2007-01-16  Vasco Nunes

* Czech translation updated (thanks to Ondra 'Kepi' Kudlík)

2007-01-15  Piotr Ożarowski

* AnimeDB movie plugin updated

2007-01-11  Piotr Ożarowski

* Fix possible memory leak
* Select first movie by default
* Remove Excel mime types from CSV import plugin
* Fix list of fields to import

2007-01-10  Vasco Nunes

* PTGate movie plugin updated

---- 0.9-rc3 ----

2007-01-09  Piotr Ożarowski

* Catch some more bad cases while upgrading database
* Switch to sqlite if psycopg2 or MySQLdb module are not available
* Fix upgrading vol/col loan data
* Version changed to 0.9-rc3

2007-01-08  Piotr Ożarowski

* Ignore bad entries in loans table
* Don't modify old database while upgrading

2007-01-08  Vasco Nunes

* Italian translation updated (Thanks to Diego)

---- 0.9-rc2 ----

2007-01-07  Piotr Ożarowski

* Copy title if original title is not available in FDb.pl movie plugin
* griffith-export-template manpage removed

2007-01-06  Piotr Ożarowski

* Clear movie details if no movie is selected
* Speed up Griffith's startup a little bit

2007-01-05  Piotr Ożarowski

* Copyright years updated
* Version changed to 0.9-rc2
* E-mails removed from changelog
* TODO updated

2007-01-05  Vasco Nunes

* Updated portuguese translation

2007-01-04  Vasco Nunes

* Updated Swedish translation (thanks to Daniel Nylander)
* Updated Czech translation and CSFD movie pluging (thanks to Blondak)
* Updated Portuguese Brazilian translation (thanks to Fábio Nogueira)
* Fixed win32 gtk locale issue
* Fixed win32 default system font directory detection (for use in
	  preferences)
* Updated French translation (thanks to Pierre-Luc Lévi)
* Latex is no more the default entry for html export plugin :)

2007-01-03  Vasco Nunes

* Using cPickle over pickle for serialization. Config files are now fully
	  cross-platform.

2007-01-03  Piotr Ożarowski

* Install Polish manpage in ISO-8859-2 encoding
* Fix clean rule
* Sort by last added movies option added
* pysqlite1.1 is not needed anymore

2007-01-02  Piotr Ożarowski

* Copy volume/collection data when cloning movie
* Fix displaying loan info (cached data can be obsolete)

2007-01-01  Jessica K. Parth

* "fixed" slow populate function
* clear_filter -> don't update four times the maintreeview
* german translation update

2007-01-01  Piotr Ożarowski

* Filmweb movie plugin updated
* Added "limit search results to x movies" in preferences
* Scroll movie list when selecting first/prev/next/last movie button
* Copy video codec data when cloning movie
* Fixed displaying volume/collection loan status
* Seen status can be now set without opening edit window

2006-12-30  Piotr Ożarowski

* Compare lower() values while importing movies
* Seen icon moved near to rating, loaned icon removed
* Speed up main list filling
* Hide number column option added
* Add Jessica's icon for seen/unseen movies

2006-12-30  Vasco Nunes

* Under MacOSX Preview.app is used for pdfs now

---- 0.9~rc1 ----

2006-12-24  Vasco Nunes

* Added some gtk dialogs when converting old db format
* Fixed some win32 setup includes

2006-12-22  Piotr Ożarowski

* Polish manpage updated

2006-12-20  Piotr Ożarowski

* Version changed to 0.9~rc1 (0.7 and 0.8 are skipped because of lots of
	  changes in this release)
* Merge function and MySQL/PostgreSQL backup disabled for now
* English manpage updated
* Homepage updated
* --fix-db option removed (no longer needed)

2006-12-18  Piotr Ożarowski

* Detect old DB (and convert it) in restore function
* UI changes (rest of windows converted to dialogs, minor changes)

2006-12-18  Jessica K. Parth

* tooltips to mange people dialog added
* german translation updated (100% finished)

2006-12-17  Jessica K. Parth

* Import CSV plugin updated to work with multiple files

2006-12-17  Piotr Ożarowski

* AniDB, Filmweb, Stopklatka and TanukiAnime movie plugins updated
* Upgrade from old database: detect SQLite3 and print some hints
* Add "commentary" to the language types

2006-12-16  Piotr Ożarowski

* WP, FDb and Onet movie plugins updated
* movie plugins:
	  + allow "%s" in self.original_url_search and self.translated_url_search
	  + opening new page inside movie plugin is now as easy as:
	    "self.new_page = self.open_page(url='http://something')"
* chardet added to optional dependencies
* Import multiple files at once

2006-12-16  Jessica K. Parth

* added a warning when there are no movies in the database to ( print
	  cover, fetch poster, change poster, edit movie, delete movie, clone
	  movie)
* Import CSV Plugin updated (use chardet "http://chardet.feedparser.org/"
	  to detect file format)

2006-12-15  Piotr Ożarowski

* Added "N/A" to some fields in "technical information" tab (NULL in
	  database)
* Added some relations between windows
* "Suggest unseen movie" now chooses movie from main list only (f.e. from
	  specified collection)

2006-12-15  Jessica K. Parth

* ODFb Plugin uses the quicksearch and returns much more and better results
* KinoDE Plugin return both results for Video/DVD and Kino now and some
	  small fixes
* German Translation updated
* Moviefone Plugin updated

2006-12-14  Piotr Ożarowski

* Search for empty fields only option added

2006-12-13  Piotr Ożarowski

* Import CSV plugin updated (thanks to Jessica)
* Fixed "unique name" bug in update poster function
* Import plugin is a lot faster now

2006-12-12  Piotr Ożarowski

* Debian files updated
* Docs updated
* Some UI improvements
* Selectable Amazon server (fetch bigger poster)
* Added "--home" command line option
* Double click on movies list -> open edit window

2006-12-10  Vasco Nunes

* Added three new movie plugins for spanish users -
	  IMDB espana, Culturalia and Film Affinity (thanks to Pedro D. Sánchez)

2006-12-08  Vasco Nunes

* Updated CSFD Plugin to use new website interface (thanks to Blonďák)
* Updated Czech translation (thanks to Blonďák)
* ClubeMyDVD movie plugin removed (site no longer exists)
* Added new portuguese movie plugin (Cineteka)

2006-12-06  Piotr Ożarowski

* Ask before adding movie which title is already in database
* New import plugin system (thanks for help, Jessica)
* CSV import plugin added (thanks to Jessica)
* IMDb movie plugin updated (thanks to Frank)
* Added myself to main authors and changed email address

2006-12-04  Piotr Ożarowski

* Added --check-dep and --show-dep command line options
* OFDb movie plugin updated (thanks to Jessica)

2006-11-20  Vasco Nunes

* Added Brasilian Portuguese translation (thanks to Fábio Nogueira)

2006-11-17  Piotr Ożarowski

* Default sort column can be set in preferences
* Menu's show seen/loaned movies only is now used more widely

2006-11-16  Piotr Ożarowski

* "Edit movie details in 'Add movie' window" transition finished
* Show right window after editing person's details
* Added more options to command line
* GNOME HIG related changes in Glade file (still needs work)

2006-11-08  Piotr Ożarowski

* "Edit movie details in 'Add movie' window" transition started
	  + Keep widgets in Griffith.widgets dictionary

2006-09-25  Piotr Ożarowski

* Added possibility to change Griffith's home directory

2006-09-24  Piotr Ożarowski

* Added Swedish translation (thanks to Daniel Nylander)

2006-09-20  Piotr Ożarowski

* AniDB movie plugin now supports gziped data (closes: #5685)

2006-09-15  Piotr Ożarowski

* Updated German translation (thanks to Malte Wiemann)

2006-09-12  Piotr Ożarowski

* "With" renamed to "Cast"
* Tiny changes in preferences window

2006-09-08  Piotr Ożarowski

* Fixed required PyGTK version
* Installation is now not required to run Griffith
	  (move griffith file to lib directory and run "./lib/griffith")

2006-09-07  Vasco Nunes

* Updated Czech translation (thanks to Ondra 'Kepi' Kudlík)

2006-09-06  Piotr Ożarowski

* Fixed CSFD movie plugin (thanks to Ondra 'Kepi' Kudlík for patch #1449)

2006-09-02  Piotr Ożarowski

* Fixed some UTF encoding problems in FDb, Filmweb, Onet and WP movie
	  plugins

2006-08-28  Piotr Ożarowski

* Some GUI changes mainly suggested by Alan Horkan:
	  + menu reorganized
	  + poster button now opens poster window
	  + changed some icons to their stock equivalent

2006-08-27  Piotr Ożarowski

* Added new green style to "html tables" template (HTML export plugin)
	  + old one renamed to "light green"
* Added some highlights for next version to NEWS file

2006-08-25  Piotr Ożarowski

* Movie plugins are now fetching only selected data.

2006-08-24  Piotr Ożarowski

* Language treeview now supports codec/channel/subtitle format data (still
	  needs work)

2006-08-23  Piotr Ożarowski

* Fixed problem with converting images on Windows (HTML export plugin)
* Fixed bug with "You have to fill language..." after updating language
	  list

2006-08-18  Piotr Ożarowski

* Added green style to "html tables" template (HTML export plugin)

2006-08-15  Vasco Nunes

* tempdir for posters is now writable by all users under win32 systems

2006-08-15  Piotr Ożarowski

* Merged changes from 0.6.2

2006-07-30  Piotr Ożarowski

* Selecting next/previous movie is now possible (new toolbar buttons)

2006-07-29  Piotr Ożarowski

* IMDb movie plugin adds new lines in "with" field again
* Draggable toolbar

2006-05-02  Piotr Ożarowski

* Added MySQL support
* Server can be changed on the fly (see database tab in preferences)

2006-04-28  Piotr Ożarowski

* SQLAlchemy transition started

2006-04-26  Piotr Ożarowski

* Added database settings to preferences window

2006-04-25  Piotr Ożarowski

* Added PostgreSQL support!
* Added merging data from .gri and .db files (still needs work)
* Fixed some minor bugs

2006-04-23  Piotr Ożarowski

* SQLite2 database automatic conversion added
* ADOdb transition completed

2006-04-22  Piotr Ożarowski

* Backup/restore function rewritten (smaller zipfile)
* Merge database function added (rewritten coffelius's patch)

2006-04-21  Piotr Ożarowski

* Adding another numeric tag/lang/volume/collection is now not possible

2006-04-20  Piotr Ożarowski

* ADOdb transition started

---- 0.6.2 ----

2006-08-08  Piotr Ożarowski

* IMDb movie plugin updated.

2006-08-05  Piotr Ożarowski

* FDb movie plugin updated.

2006-07-29  Piotr Ożarowski

* IMDb movie plugin adds new lines in "with" field again
* Update button moved to toolbar

2006-07-27  Piotr Ożarowski

* Makefile for po files updated
	  - use `cd po && make XX.po` to create new translation

2006-07-21  Piotr Ożarowski

* Updated Free Software Foundation address.
* FDb movie plugin updated.
* Filmweb movie plugin updated.

2006-07-20  Piotr Ożarowski

* Fixed media handling while exporting to HTML.

2006-06-29  Piotr Ożarowski

* German translation updated (thanks to Malte Wiemann)

2006-05-27  Vasco Nunes

* Italian translation updated.

2006-05-19  Piotr Ożarowski

* Added FDb movie plugin

2006-05-18  Piotr Ożarowski

* Movie plugins code cleanups
* Added FilmeVonAZ movie plugin (thanks to Michael Jahn)

2006-05-17  Piotr Ożarowski

* Added Kino.de movie plugin (thanks to Michael Jahn)

2006-05-08  Piotr Ożarowski

* Cinematografo movie plugin updated.

2006-05-02  Piotr Ożarowski

* Some GtkComboBoxEntry widgets changed to GtkComboBox

2006-04-25  Vasco Nunes

* Added italian translation (thanks to Diego Porcelli)

2006-04-17  Piotr Ożarowski

* Version changed to 0.6.1+svn
* Minor fixes in doc files
* Added watch file for Debian package

---- 0.6.1 ----

2006-04-14  Piotr Ożarowski

* Updated some docs (translation README and INSTALL notes)
* Fixed some typos
* Polish translation updated

2006-04-11  Piotr Ożarowski

* Filter function rewritten
	  + new fields added
	  + it should work on Windows now

2006-04-08  Piotr Ożarowski

* First tag can now be renamed

2006-04-08  Vasco Nunes

* win32 distro is using now GTK 2.8 with PyGTK 2.8. This fixes lots of old
	  PyGTK related bugs (mainly major pixbuf ones)

2006-04-07  Vasco Nunes

* some win32 related fixes

2006-04-05  Vasco Nunes

* Some changes to winsetup.py

2006-03-11  Piotr Ożarowski

* Makefile fixes:
	 + Manpages are now uninstalled as well
	 + Code cleanups
* Debian files updated

2006-03-06  Vasco Nunes

* Czech translation updated.
* CSFD - 'Cesko-Slovensk Filmov Databze' movie plugin updated.

2006-03-05  Vasco Nunes

* Spanish translation updated.
* Allocine movie plugin updated.

---- 0.6 ----

2006-03-05  Vasco Nunes

* Fixed bug when using 'clone movie' function on filtered treeview.
* When using quick filter, 'all movies' filter on menu should be checked.
	  Fixed.
* Posters are now saved to the system temp dir and only moved to posters
	  dir when the movie is really commited to db.
* Added a new feature to find and delete orphaned files in poster's
	  directory. For now, it's a console only tool (griffith -c' or
	  'griffith --clean'). Griffith should not produce orphans anymore but
	  this is useful for cleaning old ones.

2006-03-05  Piotr Ożarowski

* Fixed bug when searching movie titles containing polish characters
* Update volume/collection data after creating new database

2006-03-04  Vasco Nunes

* After deleting a movie, last row is now selected on main treeview
* Minor fixes to Allocine and 7arte movie plugins
* Portuguese translation updated.
* Quick filter not always working as expected. This is fixed now.
* When loaning/returning a movie wrong row is selected. Fixed.

2006-03-04  Piotr Ożarowski

* Fixed displaing movie info before initialization (tags problem)
* Fixed wrong poster path in cloned movie
* Clone movie function copies tag/lang data now
* Console search can now use multiple options
* Some code cleanups
* Added some tooltips to poster buttons
* Polish translation updated

2006-03-03  Vasco Nunes

* IMDB changed the way posters are included in html. Plugin fixed.
* Added custom fonts selection for PDF reports.
* Fixed bug when adding new collections.

2006-03-03  Piotr Ożarowski

* New tag/language/volume/collection name must be unique
* Volume/collection ids dictionary is filled only if needed
* Changed behaviour of poster preview and add movie window
* Fixed bug when restoring data
* Removal of any movie language is now possible (not just last one)
* Stopklatka movie plugin updated
* Onet Film movie plugin updated

2006-03-01  Vasco Nunes

* French and portuguese translations updated to match current revision
* Added a new french movie plugin - Allocine (Thanks to Pierre-Luc Lévy)

2006-02-28  Piotr Ożarowski

* All *\.py files moved to usr/share/ directory

2006-02-28  Vasco Nunes

* Added french translation (Thanks to Pierre-Luc Lévy)

2006-02-26  Piotr Ożarowski

* Movie now can't be deleted while it is loaned

2006-02-25  Vasco Nunes

* Fixed problem under macosx and safari not opening websites fired up by
	  Griffith
* Removed loan flag from the main treeview.

2006-02-21  Piotr Ożarowski

* New entries in help menu
* Worning if languages list is not filled

2006-02-20  Piotr Ożarowski

* New 'tag' feature is now complete

2006-02-19  Piotr Ożarowski

* Language/tag renaming in preferences window is finally working

2006-02-18  Piotr Ożarowski

* All language types are now saved
* Code cleanups

2006-02-17  Piotr Ożarowski

* Fixed saving languages
* Polish translation updated

2006-02-12  Piotr Ożarowski

* Onet movie plugin updated
* Some crashes while showing debug info fixed

2006-02-04  Vasco Nunes

* New console arguments: 
	 + -s, --search_title (search by title)
	 + -o, --search_original (search by original title)
	 + -d, --director (search by director)
	 + -w, --with (search by actor)
	 + -y, --year (search by year)
* Debug console argument changed to -D, --debug

2006-02-01  Vasco Nunes

* Fixed a problem with IMDB movie plugin not fetching casts for some
	  movies
* Fixed a bug on IMDB movie plugin. Some movies were giving weird results
	  on director's field.
* '"' char is now stripped from titles in all movie plugins.
* Added initial support for console arguments. No multi argument support
	  yet.
* Debug functions moved to own class
* Added basic searching by original title on the console (griffith -s
	  movie_title)

2006-01-28  Piotr Ożarowski

* Movie number is now editable
* Some language feature fixes

2006-01-28  Piotr Ożarowski

* Added languages feature (beta version)
* Added tags feature (alpha version)

2006-01-24  Vasco Nunes

* Fixed bug with spellchecker initialization when an aspell word list is
	  not installed.

2006-01-14  Piotr Ożarowski

* Filmweb movie plugin updated

2006-01-08  Piotr Ożarowski

* CSV template updated (still needs some work)

2006-01-07  Piotr Ożarowski

* [Bug #5685] AnimeDB plugin really works again

2006-01-06  Vasco Nunes

* German OFDB (Online-Filmdatenbank) movie plugin updated. (Christian
	  Sagmueller)
* German translation updated. (Christian Sagmueller)
* Portuguese translation updated.

2006-01-05  Vasco Nunes

* [Bug #5627] 7arte.net plugin with weird characters on actors field

2006-01-04  Vasco Nunes

* Main treeview being populated twice on startup. Fixed.

2006-01-04  Piotr Ożarowski

* AnimeDB plugin works again

2006-01-03  Piotr Ożarowski

* Fixed bad vol./col. ID in ComboBox after adding new entry

2006-01-02  Vasco Nunes

* [Bug #5999] Encoding problem with E-Pipoca movie plugin

2005-12-28  Piotr Ożarowski

* Fixed crash when volume or collection name wasn't string

2005-12-28  Vasco Nunes

* Proprietary unicode font used on PDF reports replaced with a free one
	  (DejaVu)
* Some changes to simple list PDF export plugin

2005-12-27  Vasco Nunes

* Added spanish translation (thanks to Daniel Ucero)

2005-12-05  Piotr Ożarowski

* Fixed aspell related problems

2005-11-30  Piotr Ożarowski

* XML template updated (HTML export plugin)

---- 0.5.1 ----

2005-11-26  Piotr Ożarowski

* Updated polish translation

2005-11-22  Vasco Nunes

* Added a new czech movie plugin (CSFD - esko-Slovensk Filmov Databze) -
	  Thanks to Blondak <blondak@neser.cz>

2005-11-21  Vasco Nunes

* Added Czech translation (Thanks to Blondak <blondak@neser.cz>)
* [Bug #5684] About window doesn't work on windows
* [Bug #5683] Two filters not working at all on windows
* Added a win32 installer custom image.
* Added portuguese, polish, german and czech translations to win32
	  installer.

2005-11-21  Piotr Ożarowski

* Added simple style to table template (HTML export plugin)
* [Bug #5686] Coll. & vol. remembers selection after adding a movie
* [Bug #5631] wrong language/locale with 0.5

2005-11-15  Vasco Nunes

* Applied Arjen Schwarz's patches addressing following problems:
	  + Removed cancel button from confirmation dialogs
	  + Fixed layer dropdown list entries
	  + 'Excellent' mispelled in condition dropdown list

2005-11-15  Piotr Ożarowski

* Try to use Psyco if available

2005-11-12  Piotr Ożarowski

* HTML export plugin updated to v3.4 (added posters conversion)

---- 0.5 ----

2005-11-11  Piotr Ożarowski

* HTML export plugin updated to v3.3
* Updated polish translation

2005-11-11  Vasco Nunes

* Fixed lots of poster operations bugs
* Added cgi module include on windows py2exe script (used by amazon.py
	  module)
* Added PIL module include on windows py2exe script
* Portuguese language file updated

2005-11-10  Vasco Nunes

* Added some cyclic garbage collector calls that really should improve
	  memory management when using large db collections

2005-11-09  Vasco Nunes

* Added a list to choose from when fetching big posters from Amazon.com
	  and an exact match is not found.

2005-11-07  Vasco Nunes

* Big posters fetched from Amazon are now previewed on built-in poster
	  viewer.

2005-11-05  Piotr Ożarowski

* Media names are now stored in database
* Updated polish translation

2005-11-04  Vasco Nunes

* On darwin and win32 platforms the poster viewer should not use
	  enter/leave events anymore. Pygtk seems buggy when handling these.
* Added initial support to fetch bigger posters using Amazon Web Services.
	  TODO: select poster to use when more than one found. Using the first one
	  for now.
* Added original Mark Pilgrim's amazon python wrapper to core distribution

2005-10-29  Vasco Nunes

* Added some HTML export plugin fixes for win32 compatibility
* Added a minor change to sql module for win32 poster paths compatibility.
	  Needs to be tested under *nix to see if nothing is broken.
* win32 build should use now the libwimp widget engine for better windows
	  visual integration

2005-10-27  Vasco Nunes

* Added some minor changes for win32 compatibility
* Now Griffith's dir defaults to localized 'My Documents' dir on win32
	  environments

2005-10-27  Piotr Ożarowski

* Volume/collection renaming is now possible
* Volume/collection can now be selected in "add movie" window
* Minor changes in volume/collection related code

2005-10-26  Vasco Nunes

* Added a winsetup.py file to be used by py2exe

2005-10-25  Piotr Ożarowski

* Correct loans history is now displayed if movie belongs to
	collection

2005-10-24  Piotr Ożarowski

* Loans are finally working correctly
* Crush when no media is selected in add movie function - fixed

2005-10-20  Piotr Ożarowski

* WP movie plugin updated
* Onet movie plugin updated

2005-10-16  Vasco Nunes

* Fixed bug with posters thumbnail generation

2005-10-15  Vasco Nunes

* Added preferences defaults to media, layers, condition, color and region

2005-10-14  Piotr Ożarowski

* [Bug #5344] fixed wrong encoding in IMDb movie plugin (thanks to dieterv)

2005-10-13  Piotr Ożarowski

* Updated WP movie plugin (webpage was changed)
* Debian menu icon was in wrong format
* Removing poster images when deleting movie feature added

2005-10-10  Piotr Ożarowski

* Fixed crash when poster file is not present

2005-10-09  Vasco Nunes

* [Bug #5306] Last toolbar button not working as expected
* Added a 'by collection' quick filter

2005-10-05  Piotr Ożarowski

* Polish translation updated

2005-10-05  Vasco Nunes

* Poster viewer events changed to only show full poster when
	  entering/leaving zoom button
* Delete/Zoom poster buttons are now sensitive to poster existence
* Portuguese translation updated

2005-10-04  Piotr Ożarowski

* Griffith now asks if you want to loan whole collection

2005-10-01  Vasco Nunes

* Moved all movie plugins logos to a new optional package
	  (griffith_extra_artwork module on cvs)
* Added some tooltips to preferences widgets
* Added some new tools to operate with posters (initial support)

2005-09-30  Piotr Ożarowski

* Volumes / Collections feature now in beta2 version (loaning is
	  working, some bugfixes)
* Some cleanups in Debian files

2005-09-26  Vasco Nunes

* Added bulgarian translation (thanks to Luchezar P. Petkov)

2005-09-27  Piotr Ożarowski

* Volumes / Collections feature now in beta version (filtering is
	  working, minor bugfixes)

2005-09-26  Piotr Ożarowski

* Volumes / Collections feature added (alpha version)

2005-09-26  Vasco Nunes

* Added a debug method to urlretrieve calls 
* Added new XML export plugin
* Renamed Export With Templates plugin to HTML export plugin
* Fixed bug with tabs not being striped on director data on ClubeMyDVD
	  movie plugin

2005-09-23  Vasco Nunes

* DVDZone2 plugin renamed to Mediadis according to new company service and
	  website. Some enhancement to this plugin implemented.

2005-09-21  Piotr Ożarowski

* Added Tanuki-Anime movie plugin.
* Minor changes in add and main window.
* Makefile update. Closes: #1324

2005-09-21  Vasco Nunes

* Added experimental support for Microsoft Windows 2000, Millenium and
	  Windows 98 systems
* [Bug #1313] Film fields with & or < break the PDF export plugin

2005-09-20  Piotr Ożarowski

* Some fixes in Makefile (for MacOSX users)

2005-09-19  Piotr Ożarowski

* UseTemplates export plugin update:
* [Bug #1314] LANG environment variable no longer required
* [Bug #1315] Added extra warning dialog when deleting directry

2005-09-18  Vasco Nunes

* Added Moviefone (America online) movie plugin.
* [Bug #1312] notes not empty after adding a movie

2005-09-14  Piotr Ożarowski

* Small main window changes

2005-09-13  Piotr Ożarowski

* Movie plugins update ("with" entry updated to use multiline, minor bugs
	  fixed)
* Gery movie plugin removed - webpage is not working
* movie.py: capwords() should be used only if needed

2005-09-12  Vasco Nunes

* [Bug #1302] Searching movies with non-english characters gives null
	  results
* Merged two patches contributed by Arjen Schwarz, addressing one problem
	  with email notification that was using an incorrect date/time format and
	  another fixing some english spell errors found in language file.
* Color, condition, layers info and region defaults now to 'n/a' when
	  adding a new movie.

2005-09-12  Piotr Ożarowski

* UseTemplates export plugin update

2005-09-11  Piotr Ożarowski

* Updated Anime Database and Filmweb movie plugins
* Add movie window reorganization

---- 0.4.2 ----

2005-09-10  Vasco Nunes

* Updated portuguese language
* Added portuguese griffith-export-template manpage
* Fixed a bug with malformed urls
* Moved some old orphan debugging lines to use new debug method
* Fixed encoding bug in built in debug method

2005-09-09  Piotr Ożarowski

* Added english and polish griffith-export-template manpage

2005-09-08  Piotr Ożarowski

* HTML export plugin renamed to "Use Templates" and updated to version 3.2
	  (now uses non-english language data from config files)
* Polish translation updated

2005-09-07  Vasco Nunes

* [Bug #1295] The 'How To Irritate People' bug :D

2005-09-05  Vasco Nunes

* Some minor changes to griffith.desktop file

2005-09-02  Vasco Nunes

* Added double click events to lists where needed
* Added a new button to add movie window: 'add movie and close'
* Added a popup menu to main treeview when left button is clicked over an
	  entry to perform common tasks

2005-08-31  Vasco Nunes

* Added portuguese manpages

2005-08-29  Piotr Ożarowski

* Some Makefiles changed/added

2005-08-28  Piotr Ożarowski
* Added english and polish manpages
* Added debug and usage command line options

2005-08-27  Piotr Ożarowski

* HTML export plugin updated to v3.1 - templates have now XML config
	  files, styles can have preview images

2005-08-24  Piotr Ożarowski

* HTML export plugin updated to v3.1-beta

2005-08-23  Piotr Ożarowski

* Updated HTML export plugin (v3.0)
* Updated polish translation
* Minor changes in Debian package generation files

2005-08-22  Vasco Nunes

* [Bug #1261] number disk is 0.

2005-08-21  Piotr Ożarowski

* HTML export plugin now uses templates! (version 3.0-rc1)

2005-08-20  Vasco Nunes

* Merged a couple of patches contributed by Arjen Schwarz, addressing the
	  following issues:
	  [Bug #1260] data for the color, region, condition and layers not being
	  stored in database; Some spelling mistakes fixed on english language
	  file.

---- 0.4.1 ----

2005-08-20  Vasco Nunes

* After adding a new movie, the original title widget has now the focus

2005-08-18  Vasco Nunes

* Fixed some minor encoding problems with 7arte.net and ClubeMyDVD movie
	  Plugins
* [Bug #1258] wrong movie fetching.
* Some UI changes on main window and add dialog
* When quick filter is changed movie details should be blank because no
	  movie is selected. Fixed.
* Password characters in email reminder preferences are now hidden

2005-08-18  Piotr Ożarowski

* Navigation bar update (HTML export plugin)

2005-08-17  Vasco Nunes

* [Bug #1253] gtkspell module not found.

---- 0.4 ----

2005-08-16  Vasco Nunes

* Loans history implemented
* Fixed bug when updating a person data. Treeview was not refreshing.
* Fixed bug when deleting a person. Should not delete entries in use.
* Fixed bugs with some movie plugins.
* Added email reminder preferences (smtp server, auth, username, password,
	  email address sender)
* Minor UI adjustment. Moved some fields from movie details tab to
	  technical information.
* Fixed bug with sugest not seen movie not working when a filter is
	  activated.
* Fix bug with random crashes when saving preferences caused by gtkspell

2005-08-15  Vasco Nunes

* Added some artwork contributed by Peek

2005-08-14  Piotr Ożarowski

* Debian package generation files - initial import

2005-08-14  Vasco Nunes

* [Bug #1250] Random Crashes. Fixed.

2005-08-13  Piotr Ożarowski

* Fixed bug #1246 (database upgrade when needed) 
* HTML export plugin update (added header entry)

2005-08-13  Vasco Nunes

* Fixed a bug in movie data updating
* Fixed some bugs in e-mail loan reminder feature.
* Some more code cleaning

2005-08-12  Piotr Ożarowski

* Some fixes in HTML export plugin and polish movie plugins
* Fixed problems with AniDB movie plugin (changed gdecode method in
	  gutils)

2005-08-11  Vasco Nunes

* [Bug #1244] Missing poster images. Fixed.
* Added four new fields: color, media condition, dvd region and dvd layers
	  information
* Merged some duplicated language strings.
* Added favorite movie plugin to preferences to be used by default when
	  fetching web data 

2005-08-11  Piotr Ożarowski

* HTML export plugin updated to 2.3beta1
* Some new arguments added to get_all_data() function in sql.py

2005-08-10  Vasco Nunes

* Added an email reminder option to loaned movies. Still todo: preferences
	  (smtp server,port,auth...)
* Fixed a bug with progressbar when fetching movie posters
* Fixed bug with wrong filter behaviour when no data is entered on it
* Implemented some generic toolbar buttons

2005-08-09  Vasco Nunes

* Fixed a couple of bugs when adding/cloning movies in empty movie
	  positions. Now the main treeview is always sorted.
* Updated polish translation
* Updated all polish movie plugins
* Added AniDB (english) movie plugin (contributed by Piotr Ożarowski)
* Added ClubeMyDVD (portuguese) movie plugin
* New method for movie plugins available - movie notes (optional). This
	  field could be used to fetch and store misc information/details about the
	  entry.
* Fixed bug in movie entry clone feature. Some fields were not being
	  escaped as expected.

2005-08-08  Vasco Nunes

* Added picture preview and filter to file choose dialog
* Makefile fixed. Make action shouldn't perform a make install.

2005-08-07  Vasco Nunes

* Fixed some minor problems with IMDB plugin
* Fixed bug with non unique filenames being produced for movie posters
* Replaced old rating spin control by an horizontal slider
* Rating and 'seen it' values are automatically saved when changed now

2005-08-05  Vasco Nunes

* Added a new 'seen movie' field to db
* View menu reworked. Added a 'view not seen movies' filter to it.
* Added a 'Suggest a movie' feature picked from not seen list.
* Portuguese translation updated

2005-08-04  Vasco Nunes

* Images are now scaled down to a new file on disk when needed and are not
	  scaled on the fly anymore. This should result in some better performance
	  results with larger collections. 
* Some minor cosmethic changes on default images
* Added spellchecker options to preferences dialog to choose fields and
	  default language to be used within (unix only)

2005-08-01  Vasco Nunes

* Added a very basic debug module

2005-07-29  Vasco Nunes

* Some API plugins changes for easier third-party development

2005-07-28  Vasco Nunes

* Added OFDb (german) movie plugin contributed by Christian Sagmueller
* Some code cleanup
* Added german language translation contributed by Christian Sagmueller

2005-07-23  Vasco Nunes

* Fixed some windows related import paths for easier packaging
* Fixed some HTML export plugin bugs when used on windows systems

---- 0.3 ----

2005-07-21  Vasco Nunes

* Updated polish and portuguese language translations
* HTML export plugin updated to v2.0RC1

2005-07-19  Vasco Nunes

* Added a free unicode truetype font (Lucida) to distribution
* Some minor PDF export plugin related fixes
* [Bug #1190] Encoding problems with polish when exporting to PDF. Fixed.
* HTML export plugin updated to v2.0beta3
* Updated polish and portuguese language translations
* Added E-Pipoca (brasilian) movie plugin

2005-07-16  Vasco Nunes

* HTML export plugin updated to v2.0beta2
* Updated polish and portuguese language translations
* Added Cinematografo (Italian) plugin
* Fixed bug. Problem with some characters not escaped as should be when
	  inserting in db.

2005-07-15  Vasco Nunes

* Old export filters changed to plugins
* Included Piotr Ożarowski's HTML export plugin v2.0beta

2005-07-14  Vasco Nunes

* Created a 'plugins' directory. Moved all movie plugins to this new 
	  directory for better organization, inside own subdirectory 'movie'
* Initial export plugins support

2005-07-12  Vasco Nunes

* [Bug #1193] Add new. Cancel not working. Fixed.

2005-07-07  Vasco Nunes

* Config module rewritten. Now config uses pickle for better cross
	  platform handling.
* Griffith now stores window size and position on exit.

2005-07-06  Vasco Nunes

* Added simple html list exporting. (thanks to Piotr Ożarowski)

2005-07-05  Vasco Nunes

* [Bug #1194] Filter drop menu not working. Fixed.
* [Bug #1195] Loans not working. Fixed.
* [Bug #1196] Can't delete people on the friends list. Fixed.
* Now is not possible to delete a person with loaned films.
* Some minor UI changes
* [Bug #1191] Main window needs to me smaller. Fixed.
* Added .ico for windows version
* [Bug #1192] New database not working under windows. Fixed.
* Added delete key event support on main viewlist to delete rows

2005-07-03  Vasco Nunes

* Added CineMovie (french) plugin

---- 0.2 ----

2005-07-02  Vasco Nunes

* [Bug] Sorting by film number don't work as expected. Fixed.
* Added toggle toolbar view functionality
* [Bug #1176] Last item not selected. Closed.

2005-07-01  Vasco Nunes

* Added some menu shortcuts
* Added view menu
* Another portuguese/polish translation update
* All polish plugins now include rating capability (thanks to Piotr
	  Ożarowski)

2005-06-30  Vasco Nunes

* Changed plugin detection function to use glob module instead
* all file operations changed to use shutil module instead
* General code cleaning
* [Bug] Before function in gutils returning incorrect string. Fixed.
	  (thanks to Piotr Ożarowski)
* added Onnet Film (polish) plugin (thanks to Piotr Ożarowski).
* polish translation updated
* portuguese translation updated
* Added film ratings
* Added ratings to quick filter
* [Bug] Clearing filter with some criterias were not refreshing main
	  treeview. Fixed.

2005-06-29  Vasco Nunes

* Moved all glade widgets/event handlers definitions for a new module
* Moved editing functions to a new module
* [Bug] Changed all file selection dialogs to modal

2005-06-28  Vasco Nunes

* Added year to search results on imdb plugin

2005-06-26  Vasco Nunes

* [Bug] Problem with null searches fixed 
* [Bug] Fixed bug on imdb plugin. exact matches were not returning any
	  results.
* When an exact match is founded griffith tries to use it automatically

2005-06-23  Vasco Nunes

* new update to polish translation.
* added FilmWeb (polish) plugin (thanks to Piotr Ożarowski).
* added WP (polish) plugin (thanks to Piotr Ożarowski).
* added csv export filter
* added initial support for gtkspell under *nix systems. new dependency:
	  python-gnome-extras (optional - will not be used if not available)
* main poster changed to a button widget allowing now to select a custom
	  poster image.

2005-06-22  Vasco Nunes

* added Gery Film (polish) plugin (thanks to Piotr Ożarowski).
* [Bug] Fixed bug with null year and runtime display
* [Bug] Fixed some bugs related with single quote problems
* Implemented a new field to write custom notes

2005-06-21  Vasco Nunes

* updated polish translation. fixed encoding problems.
* added PTGate.pt (portuguese) plugin.
* hardcoded library locations fixed.
* added main treeview flag on loaned films.
* [Bug #] After droping old database and creating a new one, new movie
	  don't get ID=1 but incremented old highest value. Fixed.

2005-06-20  Vasco Nunes

* true plugin system implemented.
* included stopklatka.pl (polish) plugin (thanks to Piotr Ożarowski).
* [Bug #] bug with year and running time not filled when image is not
	  available. Fixed.
* updated polish translation.

2005-06-19  Vasco Nunes

* added polish translation (thanks to Piotr Ożarowski).

---- 0.1 ----

2005-06-18  Vasco Nunes

* public release - version 0.1
