/*
 * Project    : ipv6calc
 * File       : databases/lib/libipv6calc_db_wrapper_IP2Location.h
 * Version    : $Id: 7c287adc5b00eef9dfde119e9c9902b0da34bdb4 $
 * Copyright  : 2013-2021 by Peter Bieringer <pb (at) bieringer.de>
 *
 * Information:
 *  Header file for libipv6calc_db_wrapper_IP2Location.c
 */

#include "ipv6calctypes.h"

#ifndef _libipv6calc_db_wrapper_IP2Location_h

#define _libipv6calc_db_wrapper_IP2Location_h 1

#ifdef SUPPORT_IP2LOCATION
#include "IP2Location.h"
#endif

#define IP2LOCATION_SUPPORT_UNKNOWN		0
#define IP2LOCATION_SUPPORT_COMPAT		1
#define IP2LOCATION_SUPPORT_FULL		2
#define IP2LOCATION_SUPPORT_NOTEXISTS		3

#define IP2LOCATION_IPV6_SUPPORT_UNKNOWN	0
#define IP2LOCATION_IPV6_SUPPORT_COMPAT		1
#define IP2LOCATION_IPV6_SUPPORT_FULL		2
#define IP2LOCATION_IPV6_SUPPORT_NOTEXISTS	3

// database types
/*** Commercial ***/
#define IP2LOCATION_IPV4_DB1	 1
#define IP2LOCATION_IPV4_DB2	 2
#define IP2LOCATION_IPV4_DB3	 3
#define IP2LOCATION_IPV4_DB4	 4
#define IP2LOCATION_IPV4_DB5	 5
#define IP2LOCATION_IPV4_DB6	 6
#define IP2LOCATION_IPV4_DB7	 7
#define IP2LOCATION_IPV4_DB8	 8
#define IP2LOCATION_IPV4_DB9	 9
#define IP2LOCATION_IPV4_DB10	 10
#define IP2LOCATION_IPV4_DB11	 11
#define IP2LOCATION_IPV4_DB12	 12
#define IP2LOCATION_IPV4_DB13	 13
#define IP2LOCATION_IPV4_DB14	 14
#define IP2LOCATION_IPV4_DB15	 15
#define IP2LOCATION_IPV4_DB16	 16
#define IP2LOCATION_IPV4_DB17	 17
#define IP2LOCATION_IPV4_DB18	 18
#define IP2LOCATION_IPV4_DB19	 19
#define IP2LOCATION_IPV4_DB20	 20
#define IP2LOCATION_IPV4_DB21	 21
#define IP2LOCATION_IPV4_DB22	 22
#define IP2LOCATION_IPV4_DB23	 23
#define IP2LOCATION_IPV4_DB24	 24
#define IP2LOCATION_IPV4_DB25	 25

#define IP2LOCATION_IPV6_DB1	 101
#define IP2LOCATION_IPV6_DB2	 102
#define IP2LOCATION_IPV6_DB3	 103
#define IP2LOCATION_IPV6_DB4	 104
#define IP2LOCATION_IPV6_DB5	 105
#define IP2LOCATION_IPV6_DB6	 106
#define IP2LOCATION_IPV6_DB7	 107
#define IP2LOCATION_IPV6_DB8	 108
#define IP2LOCATION_IPV6_DB9	 109
#define IP2LOCATION_IPV6_DB10	 110
#define IP2LOCATION_IPV6_DB11	 111
#define IP2LOCATION_IPV6_DB12	 112
#define IP2LOCATION_IPV6_DB13	 113
#define IP2LOCATION_IPV6_DB14	 114
#define IP2LOCATION_IPV6_DB15	 115
#define IP2LOCATION_IPV6_DB16	 116
#define IP2LOCATION_IPV6_DB17	 117
#define IP2LOCATION_IPV6_DB18	 118
#define IP2LOCATION_IPV6_DB19	 119
#define IP2LOCATION_IPV6_DB20	 120
#define IP2LOCATION_IPV6_DB21	 121
#define IP2LOCATION_IPV6_DB22	 122
#define IP2LOCATION_IPV6_DB23	 123
#define IP2LOCATION_IPV6_DB24	 124
#define IP2LOCATION_IPV6_DB25	 125

/* SAMPLE */
#define IP2LOCATION_IPV4_SAMPLE_DB1	 201
#define IP2LOCATION_IPV4_SAMPLE_DB2	 202
#define IP2LOCATION_IPV4_SAMPLE_DB3	 203
#define IP2LOCATION_IPV4_SAMPLE_DB4	 204
#define IP2LOCATION_IPV4_SAMPLE_DB5	 205
#define IP2LOCATION_IPV4_SAMPLE_DB6	 206
#define IP2LOCATION_IPV4_SAMPLE_DB7	 207
#define IP2LOCATION_IPV4_SAMPLE_DB8	 208
#define IP2LOCATION_IPV4_SAMPLE_DB9	 209
#define IP2LOCATION_IPV4_SAMPLE_DB10	 210
#define IP2LOCATION_IPV4_SAMPLE_DB11	 211
#define IP2LOCATION_IPV4_SAMPLE_DB12	 212
#define IP2LOCATION_IPV4_SAMPLE_DB13	 213
#define IP2LOCATION_IPV4_SAMPLE_DB14	 214
#define IP2LOCATION_IPV4_SAMPLE_DB15	 215
#define IP2LOCATION_IPV4_SAMPLE_DB16	 216
#define IP2LOCATION_IPV4_SAMPLE_DB17	 217
#define IP2LOCATION_IPV4_SAMPLE_DB18	 218
#define IP2LOCATION_IPV4_SAMPLE_DB19	 219
#define IP2LOCATION_IPV4_SAMPLE_DB20	 220
#define IP2LOCATION_IPV4_SAMPLE_DB21	 221
#define IP2LOCATION_IPV4_SAMPLE_DB22	 222
#define IP2LOCATION_IPV4_SAMPLE_DB23	 223
#define IP2LOCATION_IPV4_SAMPLE_DB24	 224
#define IP2LOCATION_IPV4_SAMPLE_DB25	 225

#define IP2LOCATION_IPV6_SAMPLE_DB1	 301
#define IP2LOCATION_IPV6_SAMPLE_DB2	 302
#define IP2LOCATION_IPV6_SAMPLE_DB3	 303
#define IP2LOCATION_IPV6_SAMPLE_DB4	 304
#define IP2LOCATION_IPV6_SAMPLE_DB5	 305
#define IP2LOCATION_IPV6_SAMPLE_DB6	 306
#define IP2LOCATION_IPV6_SAMPLE_DB7	 307
#define IP2LOCATION_IPV6_SAMPLE_DB8	 308
#define IP2LOCATION_IPV6_SAMPLE_DB9	 309
#define IP2LOCATION_IPV6_SAMPLE_DB10	 310
#define IP2LOCATION_IPV6_SAMPLE_DB11	 311
#define IP2LOCATION_IPV6_SAMPLE_DB12	 312
#define IP2LOCATION_IPV6_SAMPLE_DB13	 313
#define IP2LOCATION_IPV6_SAMPLE_DB14	 314
#define IP2LOCATION_IPV6_SAMPLE_DB15	 315
#define IP2LOCATION_IPV6_SAMPLE_DB16	 316
#define IP2LOCATION_IPV6_SAMPLE_DB17	 317
#define IP2LOCATION_IPV6_SAMPLE_DB18	 318
#define IP2LOCATION_IPV6_SAMPLE_DB19	 319
#define IP2LOCATION_IPV6_SAMPLE_DB20	 320
#define IP2LOCATION_IPV6_SAMPLE_DB21	 321
#define IP2LOCATION_IPV6_SAMPLE_DB22	 322
#define IP2LOCATION_IPV6_SAMPLE_DB23	 323
#define IP2LOCATION_IPV6_SAMPLE_DB24	 324
#define IP2LOCATION_IPV6_SAMPLE_DB25	 325

/* LITE */
#define IP2LOCATION_DB_IP_COUNTRY_LITE				401
#define IP2LOCATION_DB_IPV6_COUNTRY_LITE			501

#define IP2LOCATION_DB_IP_COUNTRY_REG_CIT_LITE			403
#define IP2LOCATION_DB_IPV6_COUNTRY_REG_CIT_LITE		503

#define IP2LOCATION_DB_IP_COUNTRY_REG_CIT_LL_LITE		405
#define IP2LOCATION_DB_IPV6_COUNTRY_REG_CIT_LL_LITE		505

#define IP2LOCATION_DB_IP_COUNTRY_REG_CIT_LL_ZIP_LITE		409
#define IP2LOCATION_DB_IPV6_COUNTRY_REG_CIT_LL_ZIP_LITE		509

#define IP2LOCATION_DB_IP_COUNTRY_REG_CIT_LL_ZIP_TZ_LITE	411
#define IP2LOCATION_DB_IPV6_COUNTRY_REG_CIT_LL_ZIP_TZ_LITE	511

/* FREE (old) */
#define IP2LOCATION_DB_IPV6_COUNTRY_FREE			666

#define IP2LOCATION_DB_MAX	 IP2LOCATION_DB_IPV6_COUNTRY_FREE

#define IP2LOCATION_DB_YEAR_MIN		2010	// older databases are ignored

// shortcuts
#define IPV6CALC_DB_SC_IP2LOCATION_IPV4_COUNTRY			(IPV6CALC_DB_IPV4_TO_CC | IPV6CALC_DB_IPV4_TO_COUNTRY | IPV6CALC_DB_IP2LOCATION_IPV4)
#define IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY			(IPV6CALC_DB_IPV4_TO_CC | IPV6CALC_DB_IPV4_TO_COUNTRY | IPV6CALC_DB_IP2LOCATION_IPV4 | IPV6CALC_DB_IPV4_TO_REGION | IPV6CALC_DB_IPV4_TO_CITY)

#define IPV6CALC_DB_SC_IP2LOCATION_IPV6_COUNTRY			(IPV6CALC_DB_IPV6_TO_CC | IPV6CALC_DB_IPV6_TO_COUNTRY | IPV6CALC_DB_IP2LOCATION_IPV6)
#define IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY			(IPV6CALC_DB_IPV6_TO_CC | IPV6CALC_DB_IPV6_TO_COUNTRY | IPV6CALC_DB_IP2LOCATION_IPV6 | IPV6CALC_DB_IPV6_TO_REGION | IPV6CALC_DB_IPV6_TO_CITY)

#define IP2LOCATION_DB1  "Country"
#define IP2LOCATION_DB2  "Country/ISP"
#define IP2LOCATION_DB3  "Country/Region/City"
#define IP2LOCATION_DB4  "Country/Region/City/ISP"
#define IP2LOCATION_DB5  "Country/Region/City/LongitudeLattitude"
#define IP2LOCATION_DB6  "Country/Region/City/LongLatt/ISP"
#define IP2LOCATION_DB7  "Co/Re/Ci/ISP/Domain"
#define IP2LOCATION_DB8  "Co/Re/Ci/LattLong/ISP/Domain"
#define IP2LOCATION_DB9  "Co/Re/Ci/LattLong/ZIP"
#define IP2LOCATION_DB10 "Co/Re/Ci/LattLong/ZIP/ISP/Domain"
#define IP2LOCATION_DB11 "Co/Re/Ci/LattLong/ZIP/TZ"
#define IP2LOCATION_DB12 "Co/Re/Ci/LaLo/ZI/TZ/IS/Domain"
#define IP2LOCATION_DB13 "Co/Re/Ci/LaLo/TZ/NetSpeed"
#define IP2LOCATION_DB14 "Co/Re/Ci/LaLo/ZI/TZ/ISP/Do/Netspeed"
#define IP2LOCATION_DB15 "Co/Re/Ci/LaLo/ZIP/TZ/Area"
#define IP2LOCATION_DB16 "Co/Re/Ci/LaLo/ZI/TZ/IS/Do/Net/Area"
#define IP2LOCATION_DB17 "Co/Re/Ci/LaLo/TZ/Net/Weather"
#define IP2LOCATION_DB18 "Co/Re/Ci/LaLo/ZI/TZ/IS/Do/Ne/Ar/Weather"
#define IP2LOCATION_DB19 "Co/Re/Ci/LaLo/ISP/Dom/Mobile"
#define IP2LOCATION_DB20 "Co/Re/Ci/LaLo/ZI/TZ/IS/Do/Ne/Ar/We/Mo"
#define IP2LOCATION_DB21 "Co/Re/Ci/LaLo/ZI/TZ/Area/Elevation"
#define IP2LOCATION_DB22 "Co/Re/Ci/LaLo/ZI/TZ/IS/Do/Ne/Ar/We/Mo/El"
#define IP2LOCATION_DB23 "Co/Re/Ci/LaLo/ISP/Dom/Mobile/Usagetype"
#define IP2LOCATION_DB24 "Co/Re/Ci/LaLo/ZI/TZ/IS/Do/Ne/Ar/We/Mo/El/Us"
#define IP2LOCATION_DB25 "Co/Re/Ci/LaLo/ZI/TZ/IS/Do/Ne/Ar/We/Mo/El/Us/Ad/Ca"


#define IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE		0x00000001
#define IPV6CALC_DB_IP2LOCATION_INTERNAL_LITE		0x00000002
#define IPV6CALC_DB_IP2LOCATION_INTERNAL_FREE		0x00000004
#define IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_6	0x00000008
#define IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_8_4 0x00000010

/*@unused@*/ static const db_file_desc2 libipv6calc_db_wrapper_IP2Location_db_file_desc[] = {
	// sequence is important for automagic selection of the best

	/*****************/
	/**** SAMPLES ****/
	/*****************/
	// SAMPLES IPv4
	{ IP2LOCATION_IPV4_SAMPLE_DB1, 
		"IP-COUNTRY-SAMPLE.BIN", IP2LOCATION_DB1,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_COUNTRY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB2, 
		"IP-COUNTRY-ISP-SAMPLE.BIN", IP2LOCATION_DB2,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_COUNTRY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB3, 
		"IP-COUNTRY-REGION-CITY-SAMPLE.BIN", IP2LOCATION_DB3,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB4, 
		"IP-COUNTRY-REGION-CITY-ISP-SAMPLE.BIN", IP2LOCATION_DB4,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB5,
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-SAMPLE.BIN", IP2LOCATION_DB5,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB6, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ISP-SAMPLE.BIN", IP2LOCATION_DB6,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB7, 
		"IP-COUNTRY-REGION-CITY-ISP-DOMAIN-SAMPLE.BIN", IP2LOCATION_DB7,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB8, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ISP-DOMAIN-SAMPLE.BIN", IP2LOCATION_DB8,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB9, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-SAMPLE.BIN", IP2LOCATION_DB9,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB10, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-ISP-DOMAIN-SAMPLE.BIN", IP2LOCATION_DB10,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB11, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-SAMPLE.BIN", IP2LOCATION_DB11,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB12, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-SAMPLE.BIN", IP2LOCATION_DB12,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB13, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-TIMEZONE-NETSPEED-SAMPLE.BIN", IP2LOCATION_DB13,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB14, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-SAMPLE.BIN", IP2LOCATION_DB14,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB15, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-AREACODE-SAMPLE.BIN", IP2LOCATION_DB15,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB16, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-SAMPLE.BIN", IP2LOCATION_DB16,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB17, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-TIMEZONE-NETSPEED-WEATHER-SAMPLE.BIN", IP2LOCATION_DB17,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB18, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER-SAMPLE.BIN", IP2LOCATION_DB18,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB19, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ISP-DOMAIN-MOBILE-SAMPLE.BIN", IP2LOCATION_DB19,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB20, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER-MOBILE-SAMPLE.BIN", IP2LOCATION_DB20,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV4_SAMPLE_DB21, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-AREACODE-ELEVATION-SAMPLE.BIN", IP2LOCATION_DB21,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE | IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_6 },
	{ IP2LOCATION_IPV4_SAMPLE_DB22, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER-MOBILE-ELEVATION-SAMPLE.BIN", IP2LOCATION_DB22,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE | IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_6 },
	{ IP2LOCATION_IPV4_SAMPLE_DB23, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ISP-DOMAIN-MOBILE-USAGETYPE-SAMPLE.BIN", IP2LOCATION_DB23,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE | IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_6 },
	{ IP2LOCATION_IPV4_SAMPLE_DB24, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER-MOBILE-ELEVATION-USAGETYPE-SAMPLE.BIN", IP2LOCATION_DB24,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE | IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_6 },
	{ IP2LOCATION_IPV4_SAMPLE_DB25,
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER-MOBILE-ELEVATION-USAGETYPE-ADDRESSTYPE-CATEGORY-SAMPLE.BIN", IP2LOCATION_DB25,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE | IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_8_4 },

	// SAMPLES IPv6
	{ IP2LOCATION_IPV6_SAMPLE_DB1, 
		"IPV6-COUNTRY.SAMPLE.BIN", IP2LOCATION_DB1,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_COUNTRY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB2, 
		"IPV6-COUNTRY-ISP.SAMPLE.BIN", IP2LOCATION_DB2,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_COUNTRY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB3, 
		"IPV6-COUNTRY-REGION-CITY.SAMPLE.BIN", IP2LOCATION_DB3,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB4, 
		"IPV6-COUNTRY-REGION-CITY-ISP.SAMPLE.BIN", IP2LOCATION_DB4,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB5, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE.SAMPLE.BIN", IP2LOCATION_DB5,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB6, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ISP.SAMPLE.BIN", IP2LOCATION_DB6,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB7, 
		"IPV6-COUNTRY-REGION-CITY-ISP-DOMAIN.SAMPLE.BIN", IP2LOCATION_DB7,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB8, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ISP-DOMAIN.SAMPLE.BIN", IP2LOCATION_DB8,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB9, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE.SAMPLE.BIN", IP2LOCATION_DB9,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB10, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-ISP-DOMAIN.SAMPLE.BIN", IP2LOCATION_DB10,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB11, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE.SAMPLE.BIN", IP2LOCATION_DB11,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB12, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN.SAMPLE.BIN", IP2LOCATION_DB12,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB13, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-TIMEZONE-NETSPEED.SAMPLE.BIN", IP2LOCATION_DB13,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB14, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED.SAMPLE.BIN", IP2LOCATION_DB14,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB15, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-AREACODE.SAMPLE.BIN", IP2LOCATION_DB15,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB16, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE.SAMPLE.BIN", IP2LOCATION_DB16,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB17, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-TIMEZONE-NETSPEED-WEATHER.SAMPLE.BIN", IP2LOCATION_DB17,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB18, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER.SAMPLE.BIN", IP2LOCATION_DB18,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB19, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ISP-DOMAIN-MOBILE.SAMPLE.BIN", IP2LOCATION_DB19,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB20, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER-MOBILE.SAMPLE.BIN", IP2LOCATION_DB20,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE },
	{ IP2LOCATION_IPV6_SAMPLE_DB21, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-AREACODE-ELEVATION.SAMPLE.BIN", IP2LOCATION_DB21,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE | IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_6 },
	{ IP2LOCATION_IPV6_SAMPLE_DB22, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER-MOBILE-ELEVATION.SAMPLE.BIN", IP2LOCATION_DB22,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE | IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_6 },
	{ IP2LOCATION_IPV6_SAMPLE_DB23, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ISP-DOMAIN-MOBILE-USAGETYPE.SAMPLE.BIN", IP2LOCATION_DB23,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE | IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_6 },
	{ IP2LOCATION_IPV6_SAMPLE_DB24, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER-MOBILE-ELEVATION-USAGETYPE.SAMPLE.BIN", IP2LOCATION_DB24,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE | IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_6 },
	{ IP2LOCATION_IPV6_SAMPLE_DB25,
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER-MOBILE-ELEVATION-USAGETYPE-ADDRESSTYPE-CATEGORY.SAMPLE.BIN", IP2LOCATION_DB25,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_SAMPLE | IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_8_4 },


	/**************/
	/**** LITE ****/
	/**************/

	// LITE IPv4
	{ IP2LOCATION_DB_IP_COUNTRY_LITE,   "IP2LOCATION-LITE-DB1.BIN"     , IP2LOCATION_DB1,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_COUNTRY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LITE },
	{ IP2LOCATION_DB_IP_COUNTRY_REG_CIT_LITE, "IP2LOCATION-LITE-DB3.BIN", IP2LOCATION_DB3,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LITE },
	{ IP2LOCATION_DB_IP_COUNTRY_REG_CIT_LL_LITE, "IP2LOCATION-LITE-DB5.BIN", IP2LOCATION_DB5,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LITE },
	{ IP2LOCATION_DB_IP_COUNTRY_REG_CIT_LL_ZIP_LITE, "IP2LOCATION-LITE-DB9.BIN", IP2LOCATION_DB9,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LITE },
	{ IP2LOCATION_DB_IP_COUNTRY_REG_CIT_LL_ZIP_TZ_LITE, "IP2LOCATION-LITE-DB11.BIN", IP2LOCATION_DB11,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LITE },

	// LITE IPv6 (having also IPv4 included)
	{ IP2LOCATION_DB_IPV6_COUNTRY_LITE, "IP2LOCATION-LITE-DB1.IPV6.BIN", IP2LOCATION_DB1,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_COUNTRY | IPV6CALC_DB_SC_IP2LOCATION_IPV4_COUNTRY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LITE },
	{ IP2LOCATION_DB_IPV6_COUNTRY_REG_CIT_LITE, "IP2LOCATION-LITE-DB3.IPV6.BIN", IP2LOCATION_DB2,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY | IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LITE },
	{ IP2LOCATION_DB_IPV6_COUNTRY_REG_CIT_LL_LITE, "IP2LOCATION-LITE-DB5.IPV6.BIN", IP2LOCATION_DB5,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY | IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LITE },
	{ IP2LOCATION_DB_IPV6_COUNTRY_REG_CIT_LL_ZIP_LITE, "IP2LOCATION-LITE-DB9.IPV6.BIN", IP2LOCATION_DB9,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY | IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LITE },
	{ IP2LOCATION_DB_IPV6_COUNTRY_REG_CIT_LL_ZIP_TZ_LITE, "IP2LOCATION-LITE-DB11.IPV6.BIN", IP2LOCATION_DB11,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY | IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LITE },


	/**************/
	/* commercial */
	/**************/

	// Commercial IPv4
	{ IP2LOCATION_IPV4_DB1, 
		"IP-COUNTRY.BIN", IP2LOCATION_DB1,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_COUNTRY, 0 },
	{ IP2LOCATION_IPV4_DB2, 
		"IP-COUNTRY-ISP.BIN", IP2LOCATION_DB2,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_COUNTRY, 0 },
	{ IP2LOCATION_IPV4_DB3, 
		"IP-COUNTRY-REGION-CITY.BIN", IP2LOCATION_DB3,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB4, 
		"IP-COUNTRY-REGION-CITY-ISP.BIN", IP2LOCATION_DB4,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB5, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE.BIN", IP2LOCATION_DB5,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB6, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ISP.BIN", IP2LOCATION_DB6,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB7, 
		"IP-COUNTRY-REGION-CITY-ISP-DOMAIN.BIN", IP2LOCATION_DB7,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB8, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ISP-DOMAIN.BIN", IP2LOCATION_DB8,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB9, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE.BIN", IP2LOCATION_DB9,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB10, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-ISP-DOMAIN.BIN", IP2LOCATION_DB10,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB11, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE.BIN", IP2LOCATION_DB11,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB12, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN.BIN", IP2LOCATION_DB12,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB13, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-TIMEZONE-NETSPEED.BIN", IP2LOCATION_DB13,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB14, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED.BIN", IP2LOCATION_DB14,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB15, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-AREACODE.BIN", IP2LOCATION_DB15,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB16, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE.BIN", IP2LOCATION_DB16,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB17, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-TIMEZONE-NETSPEED-WEATHER.BIN", IP2LOCATION_DB17,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB18, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER.BIN", IP2LOCATION_DB18,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB19, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ISP-DOMAIN-MOBILE.BIN", IP2LOCATION_DB19,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB20, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER-MOBILE.BIN", IP2LOCATION_DB20,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV4_DB21, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-AREACODE-ELEVATION.BIN", IP2LOCATION_DB21,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_6 },
	{ IP2LOCATION_IPV4_DB22, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER-MOBILE-ELEVATION.BIN", IP2LOCATION_DB22,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_6 },
	{ IP2LOCATION_IPV4_DB23, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ISP-DOMAIN-MOBILE-USAGETYPE.BIN", IP2LOCATION_DB23,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_6 },
	{ IP2LOCATION_IPV4_DB24, 
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER-MOBILE-ELEVATION-USAGETYPE.BIN", IP2LOCATION_DB24,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_6 },
	{ IP2LOCATION_IPV4_DB25,
		"IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER-MOBILE-ELEVATION-USAGETYPE-ADDRESSTYPE-CATEGORY.BIN", IP2LOCATION_DB25,
		IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_8_4 },

	// Commercial IPv6 (having also IPv4 included)
	{ IP2LOCATION_IPV6_DB1, 
		"IPV6-COUNTRY.BIN", IP2LOCATION_DB1,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_COUNTRY | IPV6CALC_DB_SC_IP2LOCATION_IPV4_COUNTRY, 0 },
	{ IP2LOCATION_IPV6_DB2, 
		"IPV6-COUNTRY-ISP.BIN", IP2LOCATION_DB2,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_COUNTRY | IPV6CALC_DB_SC_IP2LOCATION_IPV4_COUNTRY, 0 },
	{ IP2LOCATION_IPV6_DB3, 
		"IPV6-COUNTRY-REGION-CITY.BIN", IP2LOCATION_DB3,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY | IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV6_DB4, 
		"IPV6-COUNTRY-REGION-CITY-ISP.BIN", IP2LOCATION_DB4,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY | IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV6_DB5, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE.BIN", IP2LOCATION_DB5,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY | IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV6_DB6, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ISP.BIN", IP2LOCATION_DB6,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY | IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV6_DB7, 
		"IPV6-COUNTRY-REGION-CITY-ISP-DOMAIN.BIN", IP2LOCATION_DB7,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY | IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV6_DB8, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ISP-DOMAIN.BIN", IP2LOCATION_DB8,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY | IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV6_DB9, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE.BIN", IP2LOCATION_DB9,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY | IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV6_DB10, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-ISP-DOMAIN.BIN", IP2LOCATION_DB10,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY | IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV6_DB11, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE.BIN", IP2LOCATION_DB11,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY | IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV6_DB12, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN.BIN", IP2LOCATION_DB12,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY | IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV6_DB13, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-TIMEZONE-NETSPEED.BIN", IP2LOCATION_DB13,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY | IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV6_DB14, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED.BIN", IP2LOCATION_DB14,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY | IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV6_DB15, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-AREACODE.BIN", IP2LOCATION_DB15,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY | IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV6_DB16, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE.BIN", IP2LOCATION_DB16,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY | IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV6_DB17, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-TIMEZONE-NETSPEED-WEATHER.BIN", IP2LOCATION_DB17,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY | IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV6_DB18, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER.BIN", IP2LOCATION_DB18,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY | IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV6_DB19, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ISP-DOMAIN-MOBILE.BIN", IP2LOCATION_DB19,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY | IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV6_DB20, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER-MOBILE.BIN", IP2LOCATION_DB20,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY | IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, 0 },
	{ IP2LOCATION_IPV6_DB21, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-AREACODE-ELEVATION.BIN", IP2LOCATION_DB21,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY | IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_6 },
	{ IP2LOCATION_IPV6_DB22, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER-MOBILE-ELEVATION.BIN", IP2LOCATION_DB22,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY | IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_6 },
	{ IP2LOCATION_IPV6_DB23, 
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ISP-DOMAIN-MOBILE-USAGETYPE.BIN", IP2LOCATION_DB23,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY | IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_6 },
	{ IP2LOCATION_IPV6_DB24,
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER-MOBILE-ELEVATION-USAGETYPE.BIN", IP2LOCATION_DB24,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY | IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_6 },
	{ IP2LOCATION_IPV6_DB25,
		"IPV6-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER-MOBILE-ELEVATION-USAGETYPE-ADDRESSTYPE-CATEGORY.BIN", IP2LOCATION_DB25,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_CITY | IPV6CALC_DB_SC_IP2LOCATION_IPV4_CITY, IPV6CALC_DB_IP2LOCATION_INTERNAL_LIB_VERSION_8_4 },


	/*****************/
	/**** SPECIAL ****/
	/*****************/
	{ IP2LOCATION_DB_IPV6_COUNTRY_FREE, 
		"IPV6-COUNTRY-FREE.BIN", IP2LOCATION_DB1,
		IPV6CALC_DB_SC_IP2LOCATION_IPV6_COUNTRY, IPV6CALC_DB_IP2LOCATION_INTERNAL_FREE },
};

// features
extern uint32_t wrapper_features_IP2Location;

/* text representations */
/*@unused@*/ static const s_type libipv6calc_db_wrapper_IP2Location_support[] = {
	{ IP2LOCATION_SUPPORT_UNKNOWN,		"unknown" },
	{ IP2LOCATION_SUPPORT_COMPAT,		"compat" },
	{ IP2LOCATION_SUPPORT_FULL,		"full" },
	{ IP2LOCATION_SUPPORT_NOTEXISTS,	"not-exists" },
};

/* text representations */
/*@unused@*/ static const s_type libipv6calc_db_wrapper_IP2Location_IPv6_support[] = {
	{ IP2LOCATION_IPV6_SUPPORT_UNKNOWN,	"unknown" },
	{ IP2LOCATION_IPV6_SUPPORT_COMPAT,	"compat" },
	{ IP2LOCATION_IPV6_SUPPORT_FULL,	"full" },
	{ IP2LOCATION_IPV6_SUPPORT_NOTEXISTS,	"not-exists" },
};


/* IP2Location Usage Type explanation
    see also: http://www.ip2location.com/databases/db24-ip-country-region-city-latitude-longitude-zipcode-timezone-isp-domain-netspeed-areacode-weather-mobile-elevation-usagetype
*/
static const s_type2 libipv6calc_db_wrapper_IP2Location_UsageType[] = {
	{ 0,  "Commercial"                     , "COM" },
	{ 1,  "Organization"                   , "ORG" },
	{ 2,  "Government"                     , "GOV" },
	{ 3,  "Military"                       , "MIL" },
	{ 4,  "University/College/School"      , "EDU" },
	{ 5,  "Library"                        , "LIB" },
	{ 6,  "Content Delivery Network"       , "CDN" },
	{ 7,  "Fixed Line ISP"                 , "ISP" },
	{ 8,  "Mobile ISP"                     , "MOB" },
	{ 9,  "Data Center/Web Hosting/Transit", "DCH" },
	{ 10, "Search Engine Spider"           , "SES" },
	{ 11, "Reserved"                       , "RSV" }
};


#endif

extern int         libipv6calc_db_wrapper_IP2Location_wrapper_init(void);
extern int         libipv6calc_db_wrapper_IP2Location_wrapper_cleanup(void);
extern const char *libipv6calc_db_wrapper_IP2Location_wrapper_asnum_by_addr (const char *addr, const int proto);
extern void        libipv6calc_db_wrapper_IP2Location_wrapper_info(char* string, const size_t size);
extern void        libipv6calc_db_wrapper_IP2Location_wrapper_print_db_info(const int level_verbose, const char *prefix_string);
extern char       *libipv6calc_db_wrapper_IP2Location_wrapper_db_info_used(void);

extern int         libipv6calc_db_wrapper_IP2Location_wrapper_country_code_by_addr(char *addr, const int proto, char *country, const size_t country_len);

extern int         libipv6calc_db_wrapper_IP2Location_has_features(uint32_t features);

extern int         libipv6calc_db_wrapper_IP2Location_library_version_major(void);
extern int         libipv6calc_db_wrapper_IP2Location_library_version_majorminor(void);


#ifdef SUPPORT_IP2LOCATION
extern char ip2location_lib_file[PATH_MAX];
extern char ip2location_db_dir[PATH_MAX];

extern int                libipv6calc_db_wrapper_IP2Location_db_avail(const unsigned int type);
extern char              *libipv6calc_db_wrapper_IP2Location_lib_version(void);
extern IP2Location       *libipv6calc_db_wrapper_IP2Location_open(char *db);
extern IP2Location       *libipv6calc_db_wrapper_IP2Location_open_type(const unsigned int type);
extern int                libipv6calc_db_wrapper_IP2Location_close(IP2Location *loc);
extern IP2LocationRecord *libipv6calc_db_wrapper_IP2Location_get_all(IP2Location *loc, char *ip);
void                      libipv6calc_db_wrapper_IP2Location_free_record(IP2LocationRecord *record);

extern const char  *libipv6calc_db_wrapper_IP2Location_dbdescription(const unsigned int type);
extern char        *libipv6calc_db_wrapper_IP2Location_database_info(IP2Location *loc, const int level_verbose, const int entry, const int flag_copyright);

extern const char *libipv6calc_db_wrapper_IP2Location_UsageType_description(char *UsageType);

extern int ip2location_db_lite_to_sample_autoswitch_max_delta_months;
extern int ip2location_db_comm_to_lite_switch_min_delta_months;
extern int ip2location_db_only_type;
extern int ip2location_db_allow_softlinks;

extern int          libipv6calc_db_wrapper_IP2Location_all_by_addr(const ipv6calc_ipaddr *ipaddrp, libipv6calc_db_wrapper_geolocation_record *recordp);
#endif
