/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.coor.conversion.DecimalDegreesCoordinateFormat;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.JosmDecimalFormatSymbolsProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OsmUrlToBounds;

public class BoundingBoxSelection
implements DownloadSelection {
    private JosmTextField[] latlon;
    private final JosmTextArea tfOsmUrl = new JosmTextArea();
    private final JosmTextArea showUrl = new JosmTextArea();
    private DownloadDialog parent;
    private final Border errorBorder = BorderFactory.createLineBorder(Color.RED, 1);

    protected void registerBoundingBoxBuilder() {
        BoundingBoxBuilder bboxbuilder = new BoundingBoxBuilder();
        for (JosmTextField ll : this.latlon) {
            ll.addFocusListener(bboxbuilder);
            ll.addActionListener(bboxbuilder);
        }
    }

    protected void buildDownloadAreaInputFields() {
        this.latlon = new JosmTextField[4];
        for (int i = 0; i < 4; ++i) {
            this.latlon[i] = new JosmTextField(11);
            this.latlon[i].setMinimumSize(new Dimension(100, new JosmTextField().getMinimumSize().height));
            this.latlon[i].addFocusListener(new SelectAllOnFocusHandler(this.latlon[i]));
        }
        LatValueChecker latChecker = new LatValueChecker(this.latlon[0]);
        this.latlon[0].addFocusListener(latChecker);
        this.latlon[0].addActionListener(latChecker);
        latChecker = new LatValueChecker(this.latlon[2]);
        this.latlon[2].addFocusListener(latChecker);
        this.latlon[2].addActionListener(latChecker);
        LonValueChecker lonChecker = new LonValueChecker(this.latlon[1]);
        this.latlon[1].addFocusListener(lonChecker);
        this.latlon[1].addActionListener(lonChecker);
        lonChecker = new LonValueChecker(this.latlon[3]);
        this.latlon[3].addFocusListener(lonChecker);
        this.latlon[3].addActionListener(lonChecker);
        this.registerBoundingBoxBuilder();
    }

    @Override
    public void addGui(final DownloadDialog gui) {
        this.buildDownloadAreaInputFields();
        JPanel dlg = new JPanel(new GridBagLayout());
        this.tfOsmUrl.getDocument().addDocumentListener(new OsmUrlRefresher());
        this.tfOsmUrl.addFocusListener(new SelectAllOnFocusHandler(this.tfOsmUrl));
        this.tfOsmUrl.setLineWrap(true);
        this.tfOsmUrl.setBorder(this.latlon[0].getBorder());
        Panel latlonPanel = new Panel(new BorderLayout());
        String[] labels = new String[]{I18n.tr("min lat", new Object[0]), I18n.tr("min lon", new Object[0]), I18n.tr("max lat", new Object[0]), I18n.tr("max lon", new Object[0])};
        String[] positions = new String[]{"South", "West", "North", "East"};
        for (int i = 0; i < this.latlon.length; ++i) {
            Panel panel = new Panel(new GridBagLayout());
            panel.add((Component)new JLabel(labels[i]), GBC.std().insets(10, 0, 3, 0));
            panel.add(this.latlon[i]);
            latlonPanel.add((Component)panel, positions[i]);
        }
        dlg.add((Component)latlonPanel, GBC.std().insets(0, 20, 0, 0));
        JButton btnCopy = new JButton(I18n.tr("Copy bounds", new Object[0]), ImageProvider.get("copy", ImageProvider.ImageSizes.SMALLICON));
        btnCopy.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                ClipboardUtils.copyString(gui.currentBounds.encodeAsString(","));
            }
        });
        dlg.add((Component)btnCopy, GBC.eop().insets(20, 20, 0, 0));
        JButton btnClear = new JButton(I18n.tr("Clear textarea", new Object[0]));
        btnClear.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                BoundingBoxSelection.this.tfOsmUrl.setText("");
            }
        });
        dlg.add((Component)btnClear, GBC.eol().insets(10, 20, 0, 0));
        dlg.add((Component)new JLabel(I18n.tr("URL from www.openstreetmap.org (you can paste an URL here to download the area)", new Object[0])), GBC.eol().insets(10, 5, 5, 0));
        dlg.add((Component)this.tfOsmUrl, GBC.eop().insets(10, 0, 5, 0).fill());
        dlg.add((Component)this.showUrl, GBC.eop().insets(10, 0, 5, 5));
        this.showUrl.setEditable(false);
        this.showUrl.setBackground(dlg.getBackground());
        this.showUrl.addFocusListener(new SelectAllOnFocusHandler(this.showUrl));
        if (gui != null) {
            gui.addDownloadAreaSelector(dlg, I18n.tr("Bounding Box", new Object[0]));
        }
        this.parent = gui;
    }

    @Override
    public void setDownloadArea(Bounds area) {
        this.updateBboxFields(area);
        this.updateUrl(area);
    }

    public Bounds getDownloadArea() {
        double[] values = new double[4];
        for (int i = 0; i < 4; ++i) {
            try {
                values[i] = JosmDecimalFormatSymbolsProvider.parseDouble(this.latlon[i].getText());
                continue;
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        if (!LatLon.isValidLat(values[0]) || !LatLon.isValidLon(values[1])) {
            return null;
        }
        if (!LatLon.isValidLat(values[2]) || !LatLon.isValidLon(values[3])) {
            return null;
        }
        return new Bounds(values);
    }

    private boolean parseURL(DownloadDialog gui) {
        Bounds b = OsmUrlToBounds.parse(this.tfOsmUrl.getText());
        if (b == null) {
            return false;
        }
        gui.boundingBoxChanged(b, this);
        this.updateBboxFields(b);
        this.updateUrl(b);
        return true;
    }

    private void updateBboxFields(Bounds area) {
        if (area == null) {
            return;
        }
        this.latlon[0].setText(DecimalDegreesCoordinateFormat.INSTANCE.latToString(area.getMin()));
        this.latlon[1].setText(DecimalDegreesCoordinateFormat.INSTANCE.lonToString(area.getMin()));
        this.latlon[2].setText(DecimalDegreesCoordinateFormat.INSTANCE.latToString(area.getMax()));
        this.latlon[3].setText(DecimalDegreesCoordinateFormat.INSTANCE.lonToString(area.getMax()));
        for (JosmTextField tf : this.latlon) {
            this.resetErrorMessage(tf);
        }
    }

    private void updateUrl(Bounds area) {
        if (area == null) {
            return;
        }
        this.showUrl.setText(OsmUrlToBounds.getURL(area));
    }

    protected void setErrorMessage(JosmTextField tf, String msg) {
        tf.setBorder(this.errorBorder);
        tf.setToolTipText(msg);
    }

    protected void resetErrorMessage(JosmTextField tf) {
        tf.setBorder(UIManager.getBorder("TextField.border"));
        tf.setToolTipText(null);
    }

    class BoundingBoxBuilder
    extends FocusAdapter
    implements ActionListener {
        BoundingBoxBuilder() {
        }

        protected Bounds build() {
            double maxlon;
            double maxlat;
            double minlon;
            double minlat;
            try {
                minlat = JosmDecimalFormatSymbolsProvider.parseDouble(BoundingBoxSelection.this.latlon[0].getText().trim());
                minlon = JosmDecimalFormatSymbolsProvider.parseDouble(BoundingBoxSelection.this.latlon[1].getText().trim());
                maxlat = JosmDecimalFormatSymbolsProvider.parseDouble(BoundingBoxSelection.this.latlon[2].getText().trim());
                maxlon = JosmDecimalFormatSymbolsProvider.parseDouble(BoundingBoxSelection.this.latlon[3].getText().trim());
            }
            catch (NumberFormatException e) {
                Logging.trace(e);
                return null;
            }
            if (!(LatLon.isValidLon(minlon) && LatLon.isValidLon(maxlon) && LatLon.isValidLat(minlat) && LatLon.isValidLat(maxlat))) {
                return null;
            }
            if (minlon > maxlon) {
                return null;
            }
            if (minlat > maxlat) {
                return null;
            }
            return new Bounds(minlat, minlon, maxlat, maxlon);
        }

        protected void refreshBounds() {
            Bounds b = this.build();
            BoundingBoxSelection.this.parent.boundingBoxChanged(b, BoundingBoxSelection.this);
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.refreshBounds();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.refreshBounds();
        }
    }

    class OsmUrlRefresher
    implements DocumentListener {
        OsmUrlRefresher() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            BoundingBoxSelection.this.parseURL(BoundingBoxSelection.this.parent);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            BoundingBoxSelection.this.parseURL(BoundingBoxSelection.this.parent);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            BoundingBoxSelection.this.parseURL(BoundingBoxSelection.this.parent);
        }
    }

    static class SelectAllOnFocusHandler
    extends FocusAdapter {
        private final JTextComponent tfTarget;

        SelectAllOnFocusHandler(JTextComponent tfTarget) {
            this.tfTarget = tfTarget;
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.tfTarget.selectAll();
        }
    }

    class LonValueChecker
    extends FocusAdapter
    implements ActionListener {
        private final JosmTextField tfLonValue;

        LonValueChecker(JosmTextField tfLonValue) {
            this.tfLonValue = tfLonValue;
        }

        protected void check() {
            double value = 0.0;
            try {
                value = JosmDecimalFormatSymbolsProvider.parseDouble(this.tfLonValue.getText());
            }
            catch (NumberFormatException ex) {
                BoundingBoxSelection.this.setErrorMessage(this.tfLonValue, I18n.tr("The string ''{0}'' is not a valid double value.", this.tfLonValue.getText()));
                return;
            }
            if (!LatLon.isValidLon(value)) {
                BoundingBoxSelection.this.setErrorMessage(this.tfLonValue, I18n.tr("Value for longitude in range [-180,180] required.", this.tfLonValue.getText()));
                return;
            }
            BoundingBoxSelection.this.resetErrorMessage(this.tfLonValue);
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.check();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.check();
        }
    }

    class LatValueChecker
    extends FocusAdapter
    implements ActionListener {
        private final JosmTextField tfLatValue;

        LatValueChecker(JosmTextField tfLatValue) {
            this.tfLatValue = tfLatValue;
        }

        protected void check() {
            double value = 0.0;
            try {
                value = JosmDecimalFormatSymbolsProvider.parseDouble(this.tfLatValue.getText());
            }
            catch (NumberFormatException ex) {
                BoundingBoxSelection.this.setErrorMessage(this.tfLatValue, I18n.tr("The string ''{0}'' is not a valid double value.", this.tfLatValue.getText()));
                return;
            }
            if (!LatLon.isValidLat(value)) {
                BoundingBoxSelection.this.setErrorMessage(this.tfLatValue, I18n.tr("Value for latitude in range [-90,90] required.", this.tfLatValue.getText()));
                return;
            }
            BoundingBoxSelection.this.resetErrorMessage(this.tfLatValue);
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.check();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.check();
        }
    }
}

