/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.display;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import org.apache.commons.jcs3.access.exception.InvalidArgumentException;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.gpx.GpxDrawHelper;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.template_engine.ParseError;
import org.openstreetmap.josm.tools.template_engine.TemplateParser;

public class GPXSettingsPanel
extends JPanel
implements PreferenceTabbedPane.ValidationListener {
    private static final int WAYPOINT_LABEL_CUSTOM = 6;
    private static final String[] LABEL_PATTERN_TEMPLATE = new String[]{"?{ '{name} ({desc})' | '{name} ({cmt})' | '{name}' | '{desc}' | '{cmt}' }", "{name}", "{desc}", "{special:everything}", "?{ '{name}' | '{desc}' | '{formattedWaypointOffset}' }", " "};
    private static final String[] LABEL_PATTERN_DESC = new String[]{I18n.tr("Auto", new Object[0]), I18n.trc("gpx_field", "Name"), I18n.trc("gpx_field", "Desc(ription)"), I18n.tr("Everything", new Object[0]), I18n.tr("Name or offset", new Object[0]), I18n.tr("None", new Object[0]), I18n.tr("Custom", new Object[0])};
    private final JRadioButton drawRawGpsLinesGlobal = new JRadioButton(I18n.tr("Use global settings", new Object[0]));
    private final JRadioButton drawRawGpsLinesAll = new JRadioButton(I18n.tr("All", new Object[0]));
    private final JRadioButton drawRawGpsLinesLocal = new JRadioButton(I18n.tr("Local files", new Object[0]));
    private final JRadioButton drawRawGpsLinesNone = new JRadioButton(I18n.tr("None", new Object[0]));
    private transient ActionListener drawRawGpsLinesActionListener;
    private final JosmTextField drawRawGpsMaxLineLength = new JosmTextField(8);
    private final JosmTextField drawRawGpsMaxLineLengthLocal = new JosmTextField(8);
    private final JosmTextField drawLineWidth = new JosmTextField(2);
    private final JCheckBox forceRawGpsLines = new JCheckBox(I18n.tr("Force lines if no segments imported", new Object[0]));
    private final JCheckBox largeGpsPoints = new JCheckBox(I18n.tr("Draw large GPS points", new Object[0]));
    private final JCheckBox hdopCircleGpsPoints = new JCheckBox(I18n.tr("Draw a circle from HDOP value", new Object[0]));
    private final JRadioButton colorTypeVelocity = new JRadioButton(I18n.tr("Velocity (red = slow, green = fast)", new Object[0]));
    private final JRadioButton colorTypeDirection = new JRadioButton(I18n.tr("Direction (red = west, yellow = north, green = east, blue = south)", new Object[0]));
    private final JRadioButton colorTypeDilution = new JRadioButton(I18n.tr("Dilution of Position (red = high, green = low, if available)", new Object[0]));
    private final JRadioButton colorTypeQuality = new JRadioButton(I18n.tr("Quality (RTKLib only, if available)", new Object[0]));
    private final JRadioButton colorTypeTime = new JRadioButton(I18n.tr("Track date", new Object[0]));
    private final JRadioButton colorTypeHeatMap = new JRadioButton(I18n.tr("Heat Map (dark = few, bright = many)", new Object[0]));
    private final JRadioButton colorTypeNone = new JRadioButton(I18n.tr("Single Color (can be customized in the layer manager)", new Object[0]));
    private final JRadioButton colorTypeGlobal = new JRadioButton(I18n.tr("Use global settings", new Object[0]));
    private final JosmComboBox<String> colorTypeVelocityTune = new JosmComboBox<String>(new String[]{I18n.tr("Car", new Object[0]), I18n.tr("Bicycle", new Object[0]), I18n.tr("Foot", new Object[0])});
    private final JosmComboBox<String> colorTypeHeatMapTune = new JosmComboBox<String>(new String[]{I18n.trc("Heat map", "User Normal"), I18n.trc("Heat map", "User Light"), I18n.trc("Heat map", "Traffic Lights"), I18n.trc("Heat map", "Inferno"), I18n.trc("Heat map", "Viridis"), I18n.trc("Heat map", "Wood"), I18n.trc("Heat map", "Heat")});
    private final JCheckBox colorTypeHeatMapPoints = new JCheckBox(I18n.tr("Use points instead of lines for heat map", new Object[0]));
    private final JSlider colorTypeHeatMapGain = new JSlider();
    private final JSlider colorTypeHeatMapLowerLimit = new JSlider();
    private final JCheckBox makeAutoMarkers = new JCheckBox(I18n.tr("Create markers when reading GPX", new Object[0]));
    private final JCheckBox drawGpsArrows = new JCheckBox(I18n.tr("Draw Direction Arrows", new Object[0]));
    private final JCheckBox drawGpsArrowsFast = new JCheckBox(I18n.tr("Fast drawing (looks uglier)", new Object[0]));
    private final JosmTextField drawGpsArrowsMinDist = new JosmTextField(8);
    private final JCheckBox colorDynamic = new JCheckBox(I18n.tr("Dynamic color range based on data limits", new Object[0]));
    private final JosmComboBox<String> waypointLabel = new JosmComboBox<String>(LABEL_PATTERN_DESC);
    private final JosmTextField waypointLabelPattern = new JosmTextField();
    private final JosmComboBox<String> audioWaypointLabel = new JosmComboBox<String>(LABEL_PATTERN_DESC);
    private final JosmTextField audioWaypointLabelPattern = new JosmTextField();
    private final JCheckBox useGpsAntialiasing = new JCheckBox(I18n.tr("Smooth GPX graphics (antialiasing)", new Object[0]));
    private final JCheckBox drawLineWithAlpha = new JCheckBox(I18n.tr("Draw with Opacity (alpha blending) ", new Object[0]));
    private final List<GpxLayer> layers;
    private final GpxLayer firstLayer;
    private final boolean global;
    private final boolean hasLocalFile;
    private final boolean hasNonLocalFile;
    private static final Map<String, Object> DEFAULT_PREFS = GPXSettingsPanel.getDefaultPrefs();

    private static Map<String, Object> getDefaultPrefs() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("colormode", -1);
        m.put("colormode.dynamic-range", false);
        m.put("colormode.heatmap.colormap", 0);
        m.put("colormode.heatmap.gain", 0);
        m.put("colormode.heatmap.line-extra", false);
        m.put("colormode.heatmap.lower-limit", 0);
        m.put("colormode.heatmap.use-points", false);
        m.put("colormode.time.min-distance", 60);
        m.put("colormode.velocity.tune", 45);
        m.put("lines", -1);
        m.put("lines.alpha-blend", false);
        m.put("lines.arrows", false);
        m.put("lines.arrows.fast", false);
        m.put("lines.arrows.min-distance", 40);
        m.put("lines.force", false);
        m.put("lines.max-length", 200);
        m.put("lines.max-length.local", -1);
        m.put("lines.width", 0);
        m.put("markers.color", "");
        m.put("markers.show-text", true);
        m.put("markers.pattern", "?{ '{name} ({desc})' | '{name} ({cmt})' | '{name}' | '{desc}' | '{cmt}' }");
        m.put("markers.audio.pattern", "?{ '{name}' | '{desc}' | '{formattedWaypointOffset}' }");
        m.put("points.hdopcircle", false);
        m.put("points.large", false);
        m.put("points.large.alpha", -1);
        m.put("points.large.size", 3);
        return Collections.unmodifiableMap(m);
    }

    public GPXSettingsPanel(List<GpxLayer> layers) {
        super(new GridBagLayout());
        this.layers = layers;
        if (layers == null || layers.isEmpty()) {
            throw new InvalidArgumentException("At least one layer required");
        }
        this.firstLayer = layers.get(0);
        this.global = false;
        this.hasLocalFile = layers.stream().anyMatch(l -> !l.data.fromServer);
        this.hasNonLocalFile = layers.stream().anyMatch(l -> l.data.fromServer);
        this.initComponents();
        this.loadPreferences();
    }

    public GPXSettingsPanel() {
        super(new GridBagLayout());
        this.layers = null;
        this.firstLayer = null;
        this.hasNonLocalFile = true;
        this.hasLocalFile = true;
        this.global = true;
        this.initComponents();
        this.loadPreferences();
    }

    public static String getLayerPref(GpxLayer layer, String key) {
        String ds;
        Object d = DEFAULT_PREFS.get(key);
        if (d != null) {
            ds = d.toString();
        } else {
            Logging.warn("No default value found for layer preference \"" + key + "\".");
            ds = null;
        }
        return Optional.ofNullable(GPXSettingsPanel.tryGetLayerPrefLocal(layer, key)).orElse(Config.getPref().get("draw.rawgps." + key, ds));
    }

    public static int getLayerPrefInt(GpxLayer layer, String key) {
        String s = GPXSettingsPanel.getLayerPref(layer, key);
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException ex) {
                Object d = DEFAULT_PREFS.get(key);
                if (d instanceof Integer) {
                    return (Integer)d;
                }
                Logging.warn("No valid default value found for layer preference \"" + key + "\".");
            }
        }
        return 0;
    }

    public static String tryGetLayerPrefLocal(GpxLayer layer, String key) {
        return layer != null ? GPXSettingsPanel.tryGetLayerPrefLocal(layer.data, key) : null;
    }

    public static String tryGetLayerPrefLocal(GpxData data, String key) {
        return data != null ? data.getLayerPrefs().get(key) : null;
    }

    public static void putLayerPref(List<GpxLayer> layers, String key, Object value) {
        String v;
        String string = v = value == null ? null : value.toString();
        if (layers != null) {
            for (GpxLayer l : layers) {
                GPXSettingsPanel.putLayerPrefLocal(l.data, key, v);
            }
        } else {
            Config.getPref().put("draw.rawgps." + key, v);
        }
    }

    public static void putLayerPrefLocal(GpxLayer layer, String key, String value) {
        if (layer == null || layer.data == null) {
            return;
        }
        GPXSettingsPanel.putLayerPrefLocal(layer.data, key, value);
    }

    public static void putLayerPrefLocal(GpxData data, String key, String value) {
        if (value == null || value.trim().isEmpty() || GPXSettingsPanel.getLayerPref(null, key).equals(value) && DEFAULT_PREFS.get(key) != null && DEFAULT_PREFS.get(key).toString().equals(value)) {
            data.getLayerPrefs().remove(key);
        } else {
            data.getLayerPrefs().put(key, value);
        }
    }

    private String pref(String key) {
        return GPXSettingsPanel.getLayerPref(this.firstLayer, key);
    }

    private boolean prefBool(String key) {
        return Boolean.parseBoolean(this.pref(key));
    }

    private int prefInt(String key) {
        return GPXSettingsPanel.getLayerPrefInt(this.firstLayer, key);
    }

    private int prefIntLocal(String key) {
        try {
            return Integer.parseInt(GPXSettingsPanel.tryGetLayerPrefLocal(this.firstLayer, key));
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    private void putPref(String key, Object value) {
        GPXSettingsPanel.putLayerPref(this.layers, key, value);
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        if (this.global) {
            this.makeAutoMarkers.setToolTipText(I18n.tr("Automatically make a marker layer from any waypoints when opening a GPX layer.", new Object[0]));
            ExpertToggleAction.addVisibilitySwitcher(this.makeAutoMarkers);
            this.add((Component)this.makeAutoMarkers, GBC.eol().insets(20, 0, 0, 5));
        }
        ButtonGroup gpsLinesGroup = new ButtonGroup();
        if (!this.global) {
            gpsLinesGroup.add(this.drawRawGpsLinesGlobal);
        }
        gpsLinesGroup.add(this.drawRawGpsLinesNone);
        gpsLinesGroup.add(this.drawRawGpsLinesLocal);
        gpsLinesGroup.add(this.drawRawGpsLinesAll);
        JLabel label = new JLabel(I18n.tr("Draw lines between raw GPS points", new Object[0]));
        this.add((Component)label, GBC.eol().insets(20, 0, 0, 0));
        if (!this.global) {
            this.add((Component)this.drawRawGpsLinesGlobal, GBC.eol().insets(40, 0, 0, 0));
        }
        this.add((Component)this.drawRawGpsLinesNone, GBC.eol().insets(40, 0, 0, 0));
        if (this.hasLocalFile) {
            this.add((Component)this.drawRawGpsLinesLocal, GBC.eol().insets(40, 0, 0, 0));
        }
        if (this.hasNonLocalFile) {
            this.add((Component)this.drawRawGpsLinesAll, GBC.eol().insets(40, 0, 0, 0));
        }
        ExpertToggleAction.addVisibilitySwitcher(label);
        ExpertToggleAction.addVisibilitySwitcher(this.drawRawGpsLinesGlobal);
        ExpertToggleAction.addVisibilitySwitcher(this.drawRawGpsLinesNone);
        ExpertToggleAction.addVisibilitySwitcher(this.drawRawGpsLinesLocal);
        ExpertToggleAction.addVisibilitySwitcher(this.drawRawGpsLinesAll);
        this.drawRawGpsLinesActionListener = e -> {
            boolean f = this.drawRawGpsLinesNone.isSelected() || this.drawRawGpsLinesGlobal.isSelected();
            this.forceRawGpsLines.setEnabled(!f);
            this.drawRawGpsMaxLineLength.setEnabled(!f && !this.drawRawGpsLinesLocal.isSelected());
            this.drawRawGpsMaxLineLengthLocal.setEnabled(!f);
            this.drawGpsArrows.setEnabled(!f);
            this.drawGpsArrowsFast.setEnabled(this.drawGpsArrows.isSelected() && this.drawGpsArrows.isEnabled());
            this.drawGpsArrowsMinDist.setEnabled(this.drawGpsArrows.isSelected() && this.drawGpsArrows.isEnabled());
        };
        this.drawRawGpsLinesGlobal.addActionListener(this.drawRawGpsLinesActionListener);
        this.drawRawGpsLinesNone.addActionListener(this.drawRawGpsLinesActionListener);
        this.drawRawGpsLinesLocal.addActionListener(this.drawRawGpsLinesActionListener);
        this.drawRawGpsLinesAll.addActionListener(this.drawRawGpsLinesActionListener);
        this.drawRawGpsMaxLineLengthLocal.setToolTipText(I18n.tr("Maximum length (in meters) to draw lines for local files. Set to ''-1'' to draw all lines.", new Object[0]));
        label = new JLabel(I18n.tr("Maximum length for local files (meters)", new Object[0]));
        this.add((Component)label, GBC.std().insets(40, 0, 0, 0));
        this.add((Component)this.drawRawGpsMaxLineLengthLocal, GBC.eol().fill(2).insets(5, 0, 0, 5));
        ExpertToggleAction.addVisibilitySwitcher(label);
        ExpertToggleAction.addVisibilitySwitcher(this.drawRawGpsMaxLineLengthLocal);
        this.drawRawGpsMaxLineLength.setToolTipText(I18n.tr("Maximum length (in meters) to draw lines. Set to ''-1'' to draw all lines.", new Object[0]));
        label = new JLabel(I18n.tr("Maximum length (meters)", new Object[0]));
        this.add((Component)label, GBC.std().insets(40, 0, 0, 0));
        this.add((Component)this.drawRawGpsMaxLineLength, GBC.eol().fill(2).insets(5, 0, 0, 5));
        ExpertToggleAction.addVisibilitySwitcher(label);
        ExpertToggleAction.addVisibilitySwitcher(this.drawRawGpsMaxLineLength);
        this.forceRawGpsLines.setToolTipText(I18n.tr("Force drawing of lines if the imported data contain no line information.", new Object[0]));
        this.add((Component)this.forceRawGpsLines, GBC.eop().insets(40, 0, 0, 0));
        ExpertToggleAction.addVisibilitySwitcher(this.forceRawGpsLines);
        this.drawGpsArrows.addActionListener(e -> {
            this.drawGpsArrowsFast.setEnabled(this.drawGpsArrows.isSelected() && this.drawGpsArrows.isEnabled());
            this.drawGpsArrowsMinDist.setEnabled(this.drawGpsArrows.isSelected() && this.drawGpsArrows.isEnabled());
        });
        this.drawGpsArrows.setToolTipText(I18n.tr("Draw direction arrows for lines, connecting GPS points.", new Object[0]));
        this.add((Component)this.drawGpsArrows, GBC.eop().insets(20, 0, 0, 0));
        this.drawGpsArrowsFast.setToolTipText(I18n.tr("Draw the direction arrows using table lookups instead of complex math.", new Object[0]));
        this.add((Component)this.drawGpsArrowsFast, GBC.eop().insets(40, 0, 0, 0));
        ExpertToggleAction.addVisibilitySwitcher(this.drawGpsArrowsFast);
        this.drawGpsArrowsMinDist.setToolTipText(I18n.tr("Do not draw arrows if they are not at least this distance away from the last one.", new Object[0]));
        this.add((Component)new JLabel(I18n.tr("Minimum distance (pixels)", new Object[0])), GBC.std().insets(40, 0, 0, 0));
        this.add((Component)this.drawGpsArrowsMinDist, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.hdopCircleGpsPoints.setToolTipText(I18n.tr("Draw a circle from HDOP value", new Object[0]));
        this.add((Component)this.hdopCircleGpsPoints, GBC.eop().insets(20, 0, 0, 0));
        ExpertToggleAction.addVisibilitySwitcher(this.hdopCircleGpsPoints);
        this.largeGpsPoints.setToolTipText(I18n.tr("Draw larger dots for the GPS points.", new Object[0]));
        this.add((Component)this.largeGpsPoints, GBC.eop().insets(20, 0, 0, 0));
        this.drawLineWidth.setToolTipText(I18n.tr("Width of drawn GPX line (0 for default)", new Object[0]));
        this.add((Component)new JLabel(I18n.tr("Drawing width of GPX lines", new Object[0])), GBC.std().insets(20, 0, 0, 0));
        this.add((Component)this.drawLineWidth, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.useGpsAntialiasing.setToolTipText(I18n.tr("Apply antialiasing to the GPX lines resulting in a smoother appearance.", new Object[0]));
        this.add((Component)this.useGpsAntialiasing, GBC.eop().insets(20, 0, 0, 0));
        ExpertToggleAction.addVisibilitySwitcher(this.useGpsAntialiasing);
        this.drawLineWithAlpha.setToolTipText(I18n.tr("Apply dynamic alpha-blending and adjust width based on zoom level for all GPX lines.", new Object[0]));
        this.add((Component)this.drawLineWithAlpha, GBC.eop().insets(20, 0, 0, 0));
        ExpertToggleAction.addVisibilitySwitcher(this.drawLineWithAlpha);
        ButtonGroup colorGroup = new ButtonGroup();
        if (!this.global) {
            colorGroup.add(this.colorTypeGlobal);
        }
        colorGroup.add(this.colorTypeNone);
        colorGroup.add(this.colorTypeVelocity);
        colorGroup.add(this.colorTypeDirection);
        colorGroup.add(this.colorTypeDilution);
        colorGroup.add(this.colorTypeQuality);
        colorGroup.add(this.colorTypeTime);
        colorGroup.add(this.colorTypeHeatMap);
        this.colorTypeNone.setToolTipText(I18n.tr("All points and track segments will have their own color. Can be customized in Layer Manager.", new Object[0]));
        this.colorTypeVelocity.setToolTipText(I18n.tr("Colors points and track segments by velocity.", new Object[0]));
        this.colorTypeDirection.setToolTipText(I18n.tr("Colors points and track segments by direction.", new Object[0]));
        this.colorTypeDilution.setToolTipText(I18n.tr("Colors points and track segments by dilution of position (HDOP). Your capture device needs to log that information.", new Object[0]));
        this.colorTypeQuality.setToolTipText(I18n.tr("Colors points and track segments by RTKLib quality flag (Q). Your capture device needs to log that information.", new Object[0]));
        this.colorTypeTime.setToolTipText(I18n.tr("Colors points and track segments by its timestamp.", new Object[0]));
        this.colorTypeHeatMap.setToolTipText(I18n.tr("Collected points and track segments for a position and displayed as heat map.", new Object[0]));
        this.colorTypeVelocityTune.setToolTipText(I18n.tr("Allows to tune the track coloring for different average speeds.", new Object[0]));
        this.colorTypeHeatMapTune.setToolTipText(I18n.tr("Selects the color schema for heat map.", new Object[0]));
        JLabel colorTypeHeatIconLabel = new JLabel();
        this.add(Box.createVerticalGlue(), GBC.eol().insets(0, 20, 0, 0));
        this.add((Component)new JLabel(I18n.tr("Track and Point Coloring", new Object[0])), GBC.eol().insets(20, 0, 0, 0));
        if (!this.global) {
            this.add((Component)this.colorTypeGlobal, GBC.eol().insets(40, 0, 0, 0));
        }
        this.add((Component)this.colorTypeNone, GBC.eol().insets(40, 0, 0, 0));
        this.add((Component)this.colorTypeVelocity, GBC.std().insets(40, 0, 0, 0));
        this.add(this.colorTypeVelocityTune, GBC.eop().fill(2).insets(5, 0, 0, 5));
        this.add((Component)this.colorTypeDirection, GBC.eol().insets(40, 0, 0, 0));
        this.add((Component)this.colorTypeDilution, GBC.eol().insets(40, 0, 0, 0));
        this.add((Component)this.colorTypeQuality, GBC.eol().insets(40, 0, 0, 0));
        this.add((Component)this.colorTypeTime, GBC.eol().insets(40, 0, 0, 0));
        this.add((Component)this.colorTypeHeatMap, GBC.std().insets(40, 0, 0, 0));
        this.add((Component)colorTypeHeatIconLabel, GBC.std().insets(5, 0, 0, 5));
        this.add(this.colorTypeHeatMapTune, GBC.eol().fill(2).insets(5, 0, 0, 5));
        JLabel colorTypeHeatMapGainLabel = new JLabel(I18n.tr("Overlay gain adjustment", new Object[0]));
        JLabel colorTypeHeatMapLowerLimitLabel = new JLabel(I18n.tr("Lower limit of visibility", new Object[0]));
        this.add((Component)colorTypeHeatMapGainLabel, GBC.std().insets(80, 0, 0, 0));
        this.add((Component)this.colorTypeHeatMapGain, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.add((Component)colorTypeHeatMapLowerLimitLabel, GBC.std().insets(80, 0, 0, 0));
        this.add((Component)this.colorTypeHeatMapLowerLimit, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.add((Component)this.colorTypeHeatMapPoints, GBC.eol().insets(60, 0, 0, 0));
        this.colorTypeHeatMapGain.setToolTipText(I18n.tr("Adjust the gain of overlay blending.", new Object[0]));
        this.colorTypeHeatMapGain.setOrientation(0);
        this.colorTypeHeatMapGain.setPaintLabels(true);
        this.colorTypeHeatMapGain.setMinimum(-10);
        this.colorTypeHeatMapGain.setMaximum(10);
        this.colorTypeHeatMapGain.setMinorTickSpacing(1);
        this.colorTypeHeatMapGain.setMajorTickSpacing(5);
        this.colorTypeHeatMapLowerLimit.setToolTipText(I18n.tr("Draw all GPX traces that exceed this threshold.", new Object[0]));
        this.colorTypeHeatMapLowerLimit.setOrientation(0);
        this.colorTypeHeatMapLowerLimit.setMinimum(0);
        this.colorTypeHeatMapLowerLimit.setMaximum(254);
        this.colorTypeHeatMapLowerLimit.setPaintLabels(true);
        this.colorTypeHeatMapLowerLimit.setMinorTickSpacing(10);
        this.colorTypeHeatMapLowerLimit.setMajorTickSpacing(100);
        this.colorTypeHeatMapPoints.setToolTipText(I18n.tr("Render engine uses points with simulated position error instead of lines. ", new Object[0]));
        Enumeration<AbstractButton> button = colorGroup.getElements();
        while (button.hasMoreElements()) {
            button.nextElement().addChangeListener(e -> {
                this.colorTypeVelocityTune.setEnabled(this.colorTypeVelocity.isSelected());
                this.colorTypeHeatMapTune.setEnabled(this.colorTypeHeatMap.isSelected());
                this.colorTypeHeatMapPoints.setEnabled(this.colorTypeHeatMap.isSelected());
                this.colorTypeHeatMapGain.setEnabled(this.colorTypeHeatMap.isSelected());
                this.colorTypeHeatMapLowerLimit.setEnabled(this.colorTypeHeatMap.isSelected());
                colorTypeHeatMapGainLabel.setEnabled(this.colorTypeHeatMap.isSelected());
                colorTypeHeatMapLowerLimitLabel.setEnabled(this.colorTypeHeatMap.isSelected());
                this.colorDynamic.setEnabled(this.colorTypeVelocity.isSelected() || this.colorTypeDilution.isSelected());
            });
        }
        this.colorTypeHeatMapTune.addActionListener(e -> {
            Dimension dim = this.colorTypeHeatMapTune.getPreferredSize();
            if (null != dim) {
                int iconSize = (int)dim.getHeight();
                colorTypeHeatIconLabel.setIcon(GpxDrawHelper.getColorMapImageIcon(GpxDrawHelper.DEFAULT_COLOR_PROPERTY.get(), this.colorTypeHeatMapTune.getSelectedIndex(), iconSize));
            }
        });
        ExpertToggleAction.addVisibilitySwitcher(this.colorTypeDirection);
        ExpertToggleAction.addVisibilitySwitcher(this.colorTypeDilution);
        ExpertToggleAction.addVisibilitySwitcher(this.colorTypeQuality);
        ExpertToggleAction.addVisibilitySwitcher(this.colorTypeHeatMapLowerLimit);
        ExpertToggleAction.addVisibilitySwitcher(colorTypeHeatMapLowerLimitLabel);
        this.colorDynamic.setToolTipText(I18n.tr("Colors points and track segments by data limits.", new Object[0]));
        this.add((Component)this.colorDynamic, GBC.eop().insets(40, 0, 0, 0));
        ExpertToggleAction.addVisibilitySwitcher(this.colorDynamic);
        if (this.global) {
            label = new JLabel(I18n.tr("Waypoint labelling", new Object[0]));
            this.add((Component)label, GBC.std().insets(20, 0, 0, 0));
            label.setLabelFor(this.waypointLabel);
            this.add(this.waypointLabel, GBC.eol().fill(2).insets(5, 0, 0, 5));
            this.waypointLabel.addActionListener(e -> GPXSettingsPanel.updateWaypointPattern(this.waypointLabel, this.waypointLabelPattern));
            this.add((Component)this.waypointLabelPattern, GBC.eol().fill(2).insets(20, 0, 0, 5));
            ExpertToggleAction.addVisibilitySwitcher(label);
            ExpertToggleAction.addVisibilitySwitcher(this.waypointLabel);
            ExpertToggleAction.addVisibilitySwitcher(this.waypointLabelPattern);
            Component glue = Box.createVerticalGlue();
            this.add(glue, GBC.eol().insets(0, 20, 0, 0));
            ExpertToggleAction.addVisibilitySwitcher(glue);
            label = new JLabel(I18n.tr("Audio waypoint labelling", new Object[0]));
            this.add((Component)label, GBC.std().insets(20, 0, 0, 0));
            label.setLabelFor(this.audioWaypointLabel);
            this.add(this.audioWaypointLabel, GBC.eol().fill(2).insets(5, 0, 0, 5));
            this.audioWaypointLabel.addActionListener(e -> GPXSettingsPanel.updateWaypointPattern(this.audioWaypointLabel, this.audioWaypointLabelPattern));
            this.add((Component)this.audioWaypointLabelPattern, GBC.eol().fill(2).insets(20, 0, 0, 5));
            ExpertToggleAction.addVisibilitySwitcher(label);
            ExpertToggleAction.addVisibilitySwitcher(this.audioWaypointLabel);
            ExpertToggleAction.addVisibilitySwitcher(this.audioWaypointLabelPattern);
        }
        this.add(Box.createVerticalGlue(), GBC.eol().fill(1));
    }

    public final void loadPreferences() {
        int lines;
        this.makeAutoMarkers.setSelected(Config.getPref().getBoolean("marker.makeautomarkers", true));
        int n = lines = this.global ? this.prefInt("lines") : this.prefIntLocal("lines");
        if (lines == 2 && this.hasNonLocalFile || lines == -1 && this.global) {
            this.drawRawGpsLinesAll.setSelected(true);
        } else if (lines == 1 && this.hasLocalFile) {
            this.drawRawGpsLinesLocal.setSelected(true);
        } else if (lines == 0) {
            this.drawRawGpsLinesNone.setSelected(true);
        } else if (lines == -1) {
            this.drawRawGpsLinesGlobal.setSelected(true);
        } else {
            Logging.warn("Unknown line type: " + lines);
        }
        this.drawRawGpsMaxLineLengthLocal.setText(this.pref("lines.max-length.local"));
        this.drawRawGpsMaxLineLength.setText(this.pref("lines.max-length"));
        this.drawLineWidth.setText(this.pref("lines.width"));
        this.drawLineWithAlpha.setSelected(this.prefBool("lines.alpha-blend"));
        this.forceRawGpsLines.setSelected(this.prefBool("lines.force"));
        this.drawGpsArrows.setSelected(this.prefBool("lines.arrows"));
        this.drawGpsArrowsFast.setSelected(this.prefBool("lines.arrows.fast"));
        this.drawGpsArrowsMinDist.setText(this.pref("lines.arrows.min-distance"));
        this.hdopCircleGpsPoints.setSelected(this.prefBool("points.hdopcircle"));
        this.largeGpsPoints.setSelected(this.prefBool("points.large"));
        this.useGpsAntialiasing.setSelected(Config.getPref().getBoolean("mappaint.gpx.use-antialiasing", false));
        this.drawRawGpsLinesActionListener.actionPerformed(null);
        if (!this.global && this.prefIntLocal("colormode") == -1) {
            this.colorTypeGlobal.setSelected(true);
            this.colorDynamic.setSelected(false);
            this.colorDynamic.setEnabled(false);
            this.colorTypeHeatMapPoints.setSelected(false);
            this.colorTypeHeatMapGain.setValue(0);
            this.colorTypeHeatMapLowerLimit.setValue(0);
        } else {
            int colorType = this.prefInt("colormode");
            switch (colorType) {
                case -1: 
                case 0: {
                    this.colorTypeNone.setSelected(true);
                    break;
                }
                case 1: {
                    this.colorTypeVelocity.setSelected(true);
                    break;
                }
                case 2: {
                    this.colorTypeDilution.setSelected(true);
                    break;
                }
                case 3: {
                    this.colorTypeDirection.setSelected(true);
                    break;
                }
                case 4: {
                    this.colorTypeTime.setSelected(true);
                    break;
                }
                case 5: {
                    this.colorTypeHeatMap.setSelected(true);
                    break;
                }
                case 6: {
                    this.colorTypeQuality.setSelected(true);
                    break;
                }
                default: {
                    Logging.warn("Unknown color type: " + colorType);
                }
            }
            int ccts = this.prefInt("colormode.velocity.tune");
            this.colorTypeVelocityTune.setSelectedIndex(ccts == 10 ? 2 : (ccts == 20 ? 1 : 0));
            this.colorTypeHeatMapTune.setSelectedIndex(this.prefInt("colormode.heatmap.colormap"));
            this.colorDynamic.setSelected(this.prefBool("colormode.dynamic-range"));
            this.colorTypeHeatMapPoints.setSelected(this.prefBool("colormode.heatmap.use-points"));
            this.colorTypeHeatMapGain.setValue(this.prefInt("colormode.heatmap.gain"));
            this.colorTypeHeatMapLowerLimit.setValue(this.prefInt("colormode.heatmap.lower-limit"));
        }
        GPXSettingsPanel.updateWaypointLabelCombobox(this.waypointLabel, this.waypointLabelPattern, this.pref("markers.pattern"));
        GPXSettingsPanel.updateWaypointLabelCombobox(this.audioWaypointLabel, this.audioWaypointLabelPattern, this.pref("markers.audio.pattern"));
    }

    public boolean savePreferences() {
        boolean g;
        if (this.global) {
            Config.getPref().putBoolean("marker.makeautomarkers", this.makeAutoMarkers.isSelected());
            this.putPref("markers.pattern", this.waypointLabelPattern.getText());
            this.putPref("markers.audio.pattern", this.audioWaypointLabelPattern.getText());
        }
        if (!this.global && ((g = this.drawRawGpsLinesGlobal.isSelected()) || this.drawRawGpsLinesNone.isSelected())) {
            if (g) {
                this.putPref("lines", null);
            } else {
                this.putPref("lines", 0);
            }
            this.putPref("lines.max-length", null);
            this.putPref("lines.max-length.local", null);
            this.putPref("lines.force", null);
            this.putPref("lines.arrows", null);
            this.putPref("lines.arrows.fast", null);
            this.putPref("lines.arrows.min-distance", null);
        } else {
            if (this.drawRawGpsLinesLocal.isSelected()) {
                this.putPref("lines", 1);
            } else if (this.drawRawGpsLinesAll.isSelected()) {
                this.putPref("lines", 2);
            }
            this.putPref("lines.max-length", this.drawRawGpsMaxLineLength.getText());
            this.putPref("lines.max-length.local", this.drawRawGpsMaxLineLengthLocal.getText());
            this.putPref("lines.force", this.forceRawGpsLines.isSelected());
            this.putPref("lines.arrows", this.drawGpsArrows.isSelected());
            this.putPref("lines.arrows.fast", this.drawGpsArrowsFast.isSelected());
            this.putPref("lines.arrows.min-distance", this.drawGpsArrowsMinDist.getText());
        }
        this.putPref("points.hdopcircle", this.hdopCircleGpsPoints.isSelected());
        this.putPref("points.large", this.largeGpsPoints.isSelected());
        this.putPref("lines.width", this.drawLineWidth.getText());
        this.putPref("lines.alpha-blend", this.drawLineWithAlpha.isSelected());
        Config.getPref().putBoolean("mappaint.gpx.use-antialiasing", this.useGpsAntialiasing.isSelected());
        if (this.colorTypeGlobal.isSelected()) {
            this.putPref("colormode", null);
            this.putPref("colormode.dynamic-range", null);
            this.putPref("colormode.velocity.tune", null);
            return false;
        }
        if (this.colorTypeVelocity.isSelected()) {
            this.putPref("colormode", 1);
        } else if (this.colorTypeDilution.isSelected()) {
            this.putPref("colormode", 2);
        } else if (this.colorTypeDirection.isSelected()) {
            this.putPref("colormode", 3);
        } else if (this.colorTypeTime.isSelected()) {
            this.putPref("colormode", 4);
        } else if (this.colorTypeHeatMap.isSelected()) {
            this.putPref("colormode", 5);
        } else if (this.colorTypeQuality.isSelected()) {
            this.putPref("colormode", 6);
        } else {
            this.putPref("colormode", 0);
        }
        this.putPref("colormode.dynamic-range", this.colorDynamic.isSelected());
        int ccti = this.colorTypeVelocityTune.getSelectedIndex();
        this.putPref("colormode.velocity.tune", ccti == 2 ? 10 : (ccti == 1 ? 20 : 45));
        this.putPref("colormode.heatmap.colormap", this.colorTypeHeatMapTune.getSelectedIndex());
        this.putPref("colormode.heatmap.use-points", this.colorTypeHeatMapPoints.isSelected());
        this.putPref("colormode.heatmap.gain", this.colorTypeHeatMapGain.getValue());
        this.putPref("colormode.heatmap.lower-limit", this.colorTypeHeatMapLowerLimit.getValue());
        if (!this.global && this.layers != null && !this.layers.isEmpty()) {
            this.layers.forEach(l -> l.data.invalidate());
        }
        return false;
    }

    private static void updateWaypointLabelCombobox(JosmComboBox<String> cb, JosmTextField tf, String labelPattern) {
        boolean found = false;
        for (int i = 0; i < LABEL_PATTERN_TEMPLATE.length; ++i) {
            if (!LABEL_PATTERN_TEMPLATE[i].equals(labelPattern)) continue;
            cb.setSelectedIndex(i);
            found = true;
            break;
        }
        if (!found) {
            cb.setSelectedIndex(6);
            tf.setEnabled(true);
            tf.setText(labelPattern);
        }
    }

    private static void updateWaypointPattern(JosmComboBox<String> cb, JosmTextField tf) {
        if (cb.getSelectedIndex() == 6) {
            tf.setEnabled(true);
        } else {
            tf.setEnabled(false);
            tf.setText(LABEL_PATTERN_TEMPLATE[cb.getSelectedIndex()]);
        }
    }

    @Override
    public boolean validatePreferences() {
        TemplateParser parser = new TemplateParser(this.waypointLabelPattern.getText());
        try {
            parser.parse();
        }
        catch (ParseError e) {
            Logging.warn(e);
            JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("Incorrect waypoint label pattern: {0}", e.getMessage()), I18n.tr("Incorrect pattern", new Object[0]), 0);
            this.waypointLabelPattern.requestFocus();
            return false;
        }
        parser = new TemplateParser(this.audioWaypointLabelPattern.getText());
        try {
            parser.parse();
        }
        catch (ParseError e) {
            Logging.warn(e);
            JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("Incorrect audio waypoint label pattern: {0}", e.getMessage()), I18n.tr("Incorrect pattern", new Object[0]), 0);
            this.audioWaypointLabelPattern.requestFocus();
            return false;
        }
        return true;
    }
}

