import datetime

from jrnl import time


def test_default_hour_is_added():
    assert time.parse(
        "2020-06-20", inclusive=False, default_hour=9, default_minute=0, bracketed=False
    ) == datetime.datetime(2020, 6, 20, 9)


def test_default_minute_is_added():
    assert (
        time.parse(
            "2020-06-20",
            inclusive=False,
            default_hour=0,
            default_minute=30,
            bracketed=False,
        )
        == datetime.datetime(2020, 6, 20, 0, 30)
    )
