
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2021 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQApplication.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QApplication>
#include <QSessionManager>
#include <QDesktopWidget>
#include <QStyle>
#include <QScreen>
#include <QLocale>
#include <QClipboard>
#include <QInputContext>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include "gsiDeclQtGuiTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QApplication

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QApplication::staticMetaObject);
}


// bool QApplication::autoSipEnabled()


static void _init_f_autoSipEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_autoSipEnabled_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QApplication *)cls)->autoSipEnabled ());
}


// QInputContext *QApplication::inputContext()


static void _init_f_inputContext_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QInputContext * > ();
}

static void _call_f_inputContext_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QInputContext * > ((QInputContext *)((QApplication *)cls)->inputContext ());
}


// bool QApplication::isSessionRestored()


static void _init_f_isSessionRestored_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSessionRestored_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QApplication *)cls)->isSessionRestored ());
}


// QString QApplication::sessionId()


static void _init_f_sessionId_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_sessionId_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QApplication *)cls)->sessionId ());
}


// QString QApplication::sessionKey()


static void _init_f_sessionKey_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_sessionKey_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QApplication *)cls)->sessionKey ());
}


// void QApplication::setAutoSipEnabled(const bool enabled)


static void _init_f_setAutoSipEnabled_1559 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<const bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAutoSipEnabled_1559 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const bool arg1 = gsi::arg_reader<const bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QApplication *)cls)->setAutoSipEnabled (arg1);
}


// void QApplication::setInputContext(QInputContext *)


static void _init_f_setInputContext_1972 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputContext * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setInputContext_1972 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QInputContext *arg1 = gsi::arg_reader<QInputContext * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QApplication *)cls)->setInputContext (arg1);
}


// void QApplication::setStyleSheet(const QString &sheet)


static void _init_f_setStyleSheet_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sheet");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStyleSheet_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QApplication *)cls)->setStyleSheet (arg1);
}


// QString QApplication::styleSheet()


static void _init_f_styleSheet_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_styleSheet_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QApplication *)cls)->styleSheet ());
}


// static void QApplication::aboutQt()


static void _init_f_aboutQt_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_aboutQt_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::aboutQt ();
}


// static QWidget *QApplication::activeModalWidget()


static void _init_f_activeModalWidget_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_activeModalWidget_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)QApplication::activeModalWidget ());
}


// static QWidget *QApplication::activePopupWidget()


static void _init_f_activePopupWidget_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_activePopupWidget_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)QApplication::activePopupWidget ());
}


// static QWidget *QApplication::activeWindow()


static void _init_f_activeWindow_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_activeWindow_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)QApplication::activeWindow ());
}


// static void QApplication::alert(QWidget *widget, int duration)


static void _init_f_alert_1974 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("duration", true, "0");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_alert_1974 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  int arg2 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::alert (arg1, arg2);
}


// static QList<QWidget *> QApplication::allWidgets()


static void _init_f_allWidgets_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QList<QWidget *> > ();
}

static void _call_f_allWidgets_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QWidget *> > ((QList<QWidget *>)QApplication::allWidgets ());
}


// static void QApplication::beep()


static void _init_f_beep_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_beep_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::beep ();
}


// static void QApplication::changeOverrideCursor(const QCursor &)


static void _init_f_changeOverrideCursor_2032 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QCursor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_changeOverrideCursor_2032 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QCursor &arg1 = gsi::arg_reader<const QCursor & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::changeOverrideCursor (arg1);
}


// static QClipboard *QApplication::clipboard()


static void _init_f_clipboard_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QClipboard * > ();
}

static void _call_f_clipboard_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QClipboard * > ((QClipboard *)QApplication::clipboard ());
}


// static void QApplication::closeAllWindows()


static void _init_f_closeAllWindows_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_closeAllWindows_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::closeAllWindows ();
}


// static int QApplication::colorSpec()


static void _init_f_colorSpec_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_colorSpec_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)QApplication::colorSpec ());
}


// static int QApplication::cursorFlashTime()


static void _init_f_cursorFlashTime_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_cursorFlashTime_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)QApplication::cursorFlashTime ());
}


// static QDesktopWidget *QApplication::desktop()


static void _init_f_desktop_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QDesktopWidget * > ();
}

static void _call_f_desktop_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDesktopWidget * > ((QDesktopWidget *)QApplication::desktop ());
}


// static bool QApplication::desktopSettingsAware()


static void _init_f_desktopSettingsAware_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_desktopSettingsAware_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)QApplication::desktopSettingsAware ());
}


// static int QApplication::doubleClickInterval()


static void _init_f_doubleClickInterval_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_doubleClickInterval_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)QApplication::doubleClickInterval ());
}


// static int QApplication::exec()


static void _init_f_exec_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_exec_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)QApplication::exec ());
}


// static QWidget *QApplication::focusWidget()


static void _init_f_focusWidget_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_focusWidget_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)QApplication::focusWidget ());
}


// static QFont QApplication::font()


static void _init_f_font_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QFont > ();
}

static void _call_f_font_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFont > ((QFont)QApplication::font ());
}


// static QFont QApplication::font(const QWidget *)


static void _init_f_font_2010 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QWidget * > (argspec_0);
  decl->set_return<QFont > ();
}

static void _call_f_font_2010 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QWidget *arg1 = gsi::arg_reader<const QWidget * >() (args, heap);
  ret.write<QFont > ((QFont)QApplication::font (arg1));
}


// static QFont QApplication::font(const char *className)


static void _init_f_font_1731 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("className");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<QFont > ();
}

static void _call_f_font_1731 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<QFont > ((QFont)QApplication::font (arg1));
}


// static QFontMetrics QApplication::fontMetrics()


static void _init_f_fontMetrics_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QFontMetrics > ();
}

static void _call_f_fontMetrics_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFontMetrics > ((QFontMetrics)QApplication::fontMetrics ());
}


// static QSize QApplication::globalStrut()


static void _init_f_globalStrut_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_globalStrut_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)QApplication::globalStrut ());
}


// static bool QApplication::isEffectEnabled(Qt::UIEffect)


static void _init_f_isEffectEnabled_1496 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::UIEffect>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isEffectEnabled_1496 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::UIEffect>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::UIEffect>::target_type & >() (args, heap);
  ret.write<bool > ((bool)QApplication::isEffectEnabled (qt_gsi::QtToCppAdaptor<Qt::UIEffect>(arg1).cref()));
}


// static bool QApplication::isLeftToRight()


static void _init_f_isLeftToRight_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isLeftToRight_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)QApplication::isLeftToRight ());
}


// static bool QApplication::isRightToLeft()


static void _init_f_isRightToLeft_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isRightToLeft_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)QApplication::isRightToLeft ());
}


// static Qt::LayoutDirection QApplication::keyboardInputDirection()


static void _init_f_keyboardInputDirection_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::LayoutDirection>::target_type > ();
}

static void _call_f_keyboardInputDirection_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::LayoutDirection>::target_type > ((qt_gsi::Converter<Qt::LayoutDirection>::target_type)qt_gsi::CppToQtAdaptor<Qt::LayoutDirection>(QApplication::keyboardInputDirection ()));
}


// static int QApplication::keyboardInputInterval()


static void _init_f_keyboardInputInterval_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_keyboardInputInterval_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)QApplication::keyboardInputInterval ());
}


// static QLocale QApplication::keyboardInputLocale()


static void _init_f_keyboardInputLocale_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QLocale > ();
}

static void _call_f_keyboardInputLocale_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QLocale > ((QLocale)QApplication::keyboardInputLocale ());
}


// static QFlags<Qt::KeyboardModifier> QApplication::keyboardModifiers()


static void _init_f_keyboardModifiers_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QFlags<Qt::KeyboardModifier> > ();
}

static void _call_f_keyboardModifiers_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::KeyboardModifier> > ((QFlags<Qt::KeyboardModifier>)QApplication::keyboardModifiers ());
}


// static Qt::LayoutDirection QApplication::layoutDirection()


static void _init_f_layoutDirection_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::LayoutDirection>::target_type > ();
}

static void _call_f_layoutDirection_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::LayoutDirection>::target_type > ((qt_gsi::Converter<Qt::LayoutDirection>::target_type)qt_gsi::CppToQtAdaptor<Qt::LayoutDirection>(QApplication::layoutDirection ()));
}


// static QFlags<Qt::MouseButton> QApplication::mouseButtons()


static void _init_f_mouseButtons_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QFlags<Qt::MouseButton> > ();
}

static void _call_f_mouseButtons_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::MouseButton> > ((QFlags<Qt::MouseButton>)QApplication::mouseButtons ());
}


// static QCursor *QApplication::overrideCursor()


static void _init_f_overrideCursor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QCursor * > ();
}

static void _call_f_overrideCursor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QCursor * > ((QCursor *)QApplication::overrideCursor ());
}


// static QPalette QApplication::palette()


static void _init_f_palette_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QPalette > ();
}

static void _call_f_palette_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPalette > ((QPalette)QApplication::palette ());
}


// static QPalette QApplication::palette(const QWidget *)


static void _init_f_palette_2010 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QWidget * > (argspec_0);
  decl->set_return<QPalette > ();
}

static void _call_f_palette_2010 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QWidget *arg1 = gsi::arg_reader<const QWidget * >() (args, heap);
  ret.write<QPalette > ((QPalette)QApplication::palette (arg1));
}


// static QPalette QApplication::palette(const char *className)


static void _init_f_palette_1731 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("className");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<QPalette > ();
}

static void _call_f_palette_1731 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<QPalette > ((QPalette)QApplication::palette (arg1));
}


// static bool QApplication::quitOnLastWindowClosed()


static void _init_f_quitOnLastWindowClosed_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_quitOnLastWindowClosed_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)QApplication::quitOnLastWindowClosed ());
}


// static void QApplication::restoreOverrideCursor()


static void _init_f_restoreOverrideCursor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_restoreOverrideCursor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::restoreOverrideCursor ();
}


// static void QApplication::setActiveWindow(QWidget *act)


static void _init_f_setActiveWindow_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("act");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setActiveWindow_1315 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::setActiveWindow (arg1);
}


// static void QApplication::setColorSpec(int)


static void _init_f_setColorSpec_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setColorSpec_767 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::setColorSpec (arg1);
}


// static void QApplication::setCursorFlashTime(int)


static void _init_f_setCursorFlashTime_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCursorFlashTime_767 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::setCursorFlashTime (arg1);
}


// static void QApplication::setDesktopSettingsAware(bool)


static void _init_f_setDesktopSettingsAware_864 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDesktopSettingsAware_864 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::setDesktopSettingsAware (arg1);
}


// static void QApplication::setDoubleClickInterval(int)


static void _init_f_setDoubleClickInterval_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDoubleClickInterval_767 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::setDoubleClickInterval (arg1);
}


// static void QApplication::setEffectEnabled(Qt::UIEffect, bool enable)


static void _init_f_setEffectEnabled_2252 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::UIEffect>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("enable", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setEffectEnabled_2252 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::UIEffect>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::UIEffect>::target_type & >() (args, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::setEffectEnabled (qt_gsi::QtToCppAdaptor<Qt::UIEffect>(arg1).cref(), arg2);
}


// static void QApplication::setFont(const QFont &, const char *className)


static void _init_f_setFont_3424 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("className", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setFont_3424 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFont &arg1 = gsi::arg_reader<const QFont & >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::setFont (arg1, arg2);
}


// static void QApplication::setGlobalStrut(const QSize &)


static void _init_f_setGlobalStrut_1805 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGlobalStrut_1805 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSize &arg1 = gsi::arg_reader<const QSize & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::setGlobalStrut (arg1);
}


// static void QApplication::setGraphicsSystem(const QString &)


static void _init_f_setGraphicsSystem_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGraphicsSystem_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::setGraphicsSystem (arg1);
}


// static void QApplication::setKeyboardInputInterval(int)


static void _init_f_setKeyboardInputInterval_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setKeyboardInputInterval_767 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::setKeyboardInputInterval (arg1);
}


// static void QApplication::setLayoutDirection(Qt::LayoutDirection direction)


static void _init_f_setLayoutDirection_2316 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("direction");
  decl->add_arg<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLayoutDirection_2316 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::LayoutDirection>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::setLayoutDirection (qt_gsi::QtToCppAdaptor<Qt::LayoutDirection>(arg1).cref());
}


// static void QApplication::setOverrideCursor(const QCursor &)


static void _init_f_setOverrideCursor_2032 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QCursor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOverrideCursor_2032 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QCursor &arg1 = gsi::arg_reader<const QCursor & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::setOverrideCursor (arg1);
}


// static void QApplication::setPalette(const QPalette &, const char *className)


static void _init_f_setPalette_3736 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("className", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setPalette_3736 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPalette &arg1 = gsi::arg_reader<const QPalette & >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::setPalette (arg1, arg2);
}


// static void QApplication::setQuitOnLastWindowClosed(bool quit)


static void _init_f_setQuitOnLastWindowClosed_864 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("quit");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setQuitOnLastWindowClosed_864 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::setQuitOnLastWindowClosed (arg1);
}


// static void QApplication::setStartDragDistance(int l)


static void _init_f_setStartDragDistance_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("l");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStartDragDistance_767 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::setStartDragDistance (arg1);
}


// static void QApplication::setStartDragTime(int ms)


static void _init_f_setStartDragTime_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ms");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStartDragTime_767 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::setStartDragTime (arg1);
}


// static void QApplication::setStyle(QStyle *)


static void _init_f_setStyle_1232 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QStyle * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStyle_1232 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStyle *arg1 = gsi::arg_reader<QStyle * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::setStyle (arg1);
}


// static QStyle *QApplication::setStyle(const QString &)


static void _init_f_setStyle_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QStyle * > ();
}

static void _call_f_setStyle_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QStyle * > ((QStyle *)QApplication::setStyle (arg1));
}


// static void QApplication::setWheelScrollLines(int)


static void _init_f_setWheelScrollLines_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWheelScrollLines_767 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::setWheelScrollLines (arg1);
}


// static void QApplication::setWindowIcon(const QIcon &icon)


static void _init_f_setWindowIcon_1787 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWindowIcon_1787 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QIcon &arg1 = gsi::arg_reader<const QIcon & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::setWindowIcon (arg1);
}


// static int QApplication::startDragDistance()


static void _init_f_startDragDistance_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_startDragDistance_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)QApplication::startDragDistance ());
}


// static int QApplication::startDragTime()


static void _init_f_startDragTime_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_startDragTime_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)QApplication::startDragTime ());
}


// static QStyle *QApplication::style()


static void _init_f_style_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QStyle * > ();
}

static void _call_f_style_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStyle * > ((QStyle *)QApplication::style ());
}


// static void QApplication::syncX()


static void _init_f_syncX_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_syncX_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::syncX ();
}


// static QWidget *QApplication::topLevelAt(const QPoint &p)


static void _init_f_topLevelAt_1916 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QWidget * > ();
}

static void _call_f_topLevelAt_1916 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ret.write<QWidget * > ((QWidget *)QApplication::topLevelAt (arg1));
}


// static QWidget *QApplication::topLevelAt(int x, int y)


static void _init_f_topLevelAt_1426 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QWidget * > ();
}

static void _call_f_topLevelAt_1426 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ret.write<QWidget * > ((QWidget *)QApplication::topLevelAt (arg1, arg2));
}


// static QList<QWidget *> QApplication::topLevelWidgets()


static void _init_f_topLevelWidgets_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QList<QWidget *> > ();
}

static void _call_f_topLevelWidgets_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QWidget *> > ((QList<QWidget *>)QApplication::topLevelWidgets ());
}


// static QString QApplication::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QApplication::tr (arg1, arg2));
}


// static QString QApplication::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QApplication::tr (arg1, arg2, arg3));
}


// static QString QApplication::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QApplication::trUtf8 (arg1, arg2));
}


// static QString QApplication::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QApplication::trUtf8 (arg1, arg2, arg3));
}


// static QApplication::Type QApplication::type()


static void _init_f_type_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QApplication::Type>::target_type > ();
}

static void _call_f_type_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QApplication::Type>::target_type > ((qt_gsi::Converter<QApplication::Type>::target_type)qt_gsi::CppToQtAdaptor<QApplication::Type>(QApplication::type ()));
}


// static int QApplication::wheelScrollLines()


static void _init_f_wheelScrollLines_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_wheelScrollLines_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)QApplication::wheelScrollLines ());
}


// static QWidget *QApplication::widgetAt(const QPoint &p)


static void _init_f_widgetAt_1916 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QWidget * > ();
}

static void _call_f_widgetAt_1916 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ret.write<QWidget * > ((QWidget *)QApplication::widgetAt (arg1));
}


// static QWidget *QApplication::widgetAt(int x, int y)


static void _init_f_widgetAt_1426 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QWidget * > ();
}

static void _call_f_widgetAt_1426 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ret.write<QWidget * > ((QWidget *)QApplication::widgetAt (arg1, arg2));
}


// static QIcon QApplication::windowIcon()


static void _init_f_windowIcon_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QIcon > ();
}

static void _call_f_windowIcon_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QIcon > ((QIcon)QApplication::windowIcon ());
}


namespace gsi
{

static gsi::Methods methods_QApplication () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":autoSipEnabled", "@brief Method bool QApplication::autoSipEnabled()\n", true, &_init_f_autoSipEnabled_c0, &_call_f_autoSipEnabled_c0);
  methods += new qt_gsi::GenericMethod (":inputContext", "@brief Method QInputContext *QApplication::inputContext()\n", true, &_init_f_inputContext_c0, &_call_f_inputContext_c0);
  methods += new qt_gsi::GenericMethod ("isSessionRestored?", "@brief Method bool QApplication::isSessionRestored()\n", true, &_init_f_isSessionRestored_c0, &_call_f_isSessionRestored_c0);
  methods += new qt_gsi::GenericMethod ("sessionId", "@brief Method QString QApplication::sessionId()\n", true, &_init_f_sessionId_c0, &_call_f_sessionId_c0);
  methods += new qt_gsi::GenericMethod ("sessionKey", "@brief Method QString QApplication::sessionKey()\n", true, &_init_f_sessionKey_c0, &_call_f_sessionKey_c0);
  methods += new qt_gsi::GenericMethod ("setAutoSipEnabled|autoSipEnabled=", "@brief Method void QApplication::setAutoSipEnabled(const bool enabled)\n", false, &_init_f_setAutoSipEnabled_1559, &_call_f_setAutoSipEnabled_1559);
  methods += new qt_gsi::GenericMethod ("setInputContext|inputContext=", "@brief Method void QApplication::setInputContext(QInputContext *)\n", false, &_init_f_setInputContext_1972, &_call_f_setInputContext_1972);
  methods += new qt_gsi::GenericMethod ("setStyleSheet|styleSheet=", "@brief Method void QApplication::setStyleSheet(const QString &sheet)\n", false, &_init_f_setStyleSheet_2025, &_call_f_setStyleSheet_2025);
  methods += new qt_gsi::GenericMethod (":styleSheet", "@brief Method QString QApplication::styleSheet()\n", true, &_init_f_styleSheet_c0, &_call_f_styleSheet_c0);
  methods += gsi::qt_signal ("aboutToQuit()", "aboutToQuit", "@brief Signal declaration for QApplication::aboutToQuit()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QApplication::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QWidget *, QWidget * > ("focusChanged(QWidget *, QWidget *)", "focusChanged", gsi::arg("old"), gsi::arg("now"), "@brief Signal declaration for QApplication::focusChanged(QWidget *old, QWidget *now)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("fontDatabaseChanged()", "fontDatabaseChanged", "@brief Signal declaration for QApplication::fontDatabaseChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("lastWindowClosed()", "lastWindowClosed", "@brief Signal declaration for QApplication::lastWindowClosed()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("unixSignal(int)", "unixSignal", gsi::arg("arg1"), "@brief Signal declaration for QApplication::unixSignal(int)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("aboutQt", "@brief Static method void QApplication::aboutQt()\nThis method is static and can be called without an instance.", &_init_f_aboutQt_0, &_call_f_aboutQt_0);
  methods += new qt_gsi::GenericStaticMethod ("activeModalWidget", "@brief Static method QWidget *QApplication::activeModalWidget()\nThis method is static and can be called without an instance.", &_init_f_activeModalWidget_0, &_call_f_activeModalWidget_0);
  methods += new qt_gsi::GenericStaticMethod ("activePopupWidget", "@brief Static method QWidget *QApplication::activePopupWidget()\nThis method is static and can be called without an instance.", &_init_f_activePopupWidget_0, &_call_f_activePopupWidget_0);
  methods += new qt_gsi::GenericStaticMethod (":activeWindow", "@brief Static method QWidget *QApplication::activeWindow()\nThis method is static and can be called without an instance.", &_init_f_activeWindow_0, &_call_f_activeWindow_0);
  methods += new qt_gsi::GenericStaticMethod ("alert", "@brief Static method void QApplication::alert(QWidget *widget, int duration)\nThis method is static and can be called without an instance.", &_init_f_alert_1974, &_call_f_alert_1974);
  methods += new qt_gsi::GenericStaticMethod ("allWidgets", "@brief Static method QList<QWidget *> QApplication::allWidgets()\nThis method is static and can be called without an instance.", &_init_f_allWidgets_0, &_call_f_allWidgets_0);
  methods += new qt_gsi::GenericStaticMethod ("beep", "@brief Static method void QApplication::beep()\nThis method is static and can be called without an instance.", &_init_f_beep_0, &_call_f_beep_0);
  methods += new qt_gsi::GenericStaticMethod ("changeOverrideCursor", "@brief Static method void QApplication::changeOverrideCursor(const QCursor &)\nThis method is static and can be called without an instance.", &_init_f_changeOverrideCursor_2032, &_call_f_changeOverrideCursor_2032);
  methods += new qt_gsi::GenericStaticMethod ("clipboard", "@brief Static method QClipboard *QApplication::clipboard()\nThis method is static and can be called without an instance.", &_init_f_clipboard_0, &_call_f_clipboard_0);
  methods += new qt_gsi::GenericStaticMethod ("closeAllWindows", "@brief Static method void QApplication::closeAllWindows()\nThis method is static and can be called without an instance.", &_init_f_closeAllWindows_0, &_call_f_closeAllWindows_0);
  methods += new qt_gsi::GenericStaticMethod (":colorSpec", "@brief Static method int QApplication::colorSpec()\nThis method is static and can be called without an instance.", &_init_f_colorSpec_0, &_call_f_colorSpec_0);
  methods += new qt_gsi::GenericStaticMethod (":cursorFlashTime", "@brief Static method int QApplication::cursorFlashTime()\nThis method is static and can be called without an instance.", &_init_f_cursorFlashTime_0, &_call_f_cursorFlashTime_0);
  methods += new qt_gsi::GenericStaticMethod ("desktop", "@brief Static method QDesktopWidget *QApplication::desktop()\nThis method is static and can be called without an instance.", &_init_f_desktop_0, &_call_f_desktop_0);
  methods += new qt_gsi::GenericStaticMethod (":desktopSettingsAware", "@brief Static method bool QApplication::desktopSettingsAware()\nThis method is static and can be called without an instance.", &_init_f_desktopSettingsAware_0, &_call_f_desktopSettingsAware_0);
  methods += new qt_gsi::GenericStaticMethod (":doubleClickInterval", "@brief Static method int QApplication::doubleClickInterval()\nThis method is static and can be called without an instance.", &_init_f_doubleClickInterval_0, &_call_f_doubleClickInterval_0);
  methods += new qt_gsi::GenericStaticMethod ("exec", "@brief Static method int QApplication::exec()\nThis method is static and can be called without an instance.", &_init_f_exec_0, &_call_f_exec_0);
  methods += new qt_gsi::GenericStaticMethod ("focusWidget", "@brief Static method QWidget *QApplication::focusWidget()\nThis method is static and can be called without an instance.", &_init_f_focusWidget_0, &_call_f_focusWidget_0);
  methods += new qt_gsi::GenericStaticMethod (":font", "@brief Static method QFont QApplication::font()\nThis method is static and can be called without an instance.", &_init_f_font_0, &_call_f_font_0);
  methods += new qt_gsi::GenericStaticMethod ("font", "@brief Static method QFont QApplication::font(const QWidget *)\nThis method is static and can be called without an instance.", &_init_f_font_2010, &_call_f_font_2010);
  methods += new qt_gsi::GenericStaticMethod ("font", "@brief Static method QFont QApplication::font(const char *className)\nThis method is static and can be called without an instance.", &_init_f_font_1731, &_call_f_font_1731);
  methods += new qt_gsi::GenericStaticMethod ("fontMetrics", "@brief Static method QFontMetrics QApplication::fontMetrics()\nThis method is static and can be called without an instance.", &_init_f_fontMetrics_0, &_call_f_fontMetrics_0);
  methods += new qt_gsi::GenericStaticMethod (":globalStrut", "@brief Static method QSize QApplication::globalStrut()\nThis method is static and can be called without an instance.", &_init_f_globalStrut_0, &_call_f_globalStrut_0);
  methods += new qt_gsi::GenericStaticMethod ("isEffectEnabled?", "@brief Static method bool QApplication::isEffectEnabled(Qt::UIEffect)\nThis method is static and can be called without an instance.", &_init_f_isEffectEnabled_1496, &_call_f_isEffectEnabled_1496);
  methods += new qt_gsi::GenericStaticMethod ("isLeftToRight?", "@brief Static method bool QApplication::isLeftToRight()\nThis method is static and can be called without an instance.", &_init_f_isLeftToRight_0, &_call_f_isLeftToRight_0);
  methods += new qt_gsi::GenericStaticMethod ("isRightToLeft?", "@brief Static method bool QApplication::isRightToLeft()\nThis method is static and can be called without an instance.", &_init_f_isRightToLeft_0, &_call_f_isRightToLeft_0);
  methods += new qt_gsi::GenericStaticMethod ("keyboardInputDirection", "@brief Static method Qt::LayoutDirection QApplication::keyboardInputDirection()\nThis method is static and can be called without an instance.", &_init_f_keyboardInputDirection_0, &_call_f_keyboardInputDirection_0);
  methods += new qt_gsi::GenericStaticMethod (":keyboardInputInterval", "@brief Static method int QApplication::keyboardInputInterval()\nThis method is static and can be called without an instance.", &_init_f_keyboardInputInterval_0, &_call_f_keyboardInputInterval_0);
  methods += new qt_gsi::GenericStaticMethod ("keyboardInputLocale", "@brief Static method QLocale QApplication::keyboardInputLocale()\nThis method is static and can be called without an instance.", &_init_f_keyboardInputLocale_0, &_call_f_keyboardInputLocale_0);
  methods += new qt_gsi::GenericStaticMethod ("keyboardModifiers", "@brief Static method QFlags<Qt::KeyboardModifier> QApplication::keyboardModifiers()\nThis method is static and can be called without an instance.", &_init_f_keyboardModifiers_0, &_call_f_keyboardModifiers_0);
  methods += new qt_gsi::GenericStaticMethod (":layoutDirection", "@brief Static method Qt::LayoutDirection QApplication::layoutDirection()\nThis method is static and can be called without an instance.", &_init_f_layoutDirection_0, &_call_f_layoutDirection_0);
  methods += new qt_gsi::GenericStaticMethod ("mouseButtons", "@brief Static method QFlags<Qt::MouseButton> QApplication::mouseButtons()\nThis method is static and can be called without an instance.", &_init_f_mouseButtons_0, &_call_f_mouseButtons_0);
  methods += new qt_gsi::GenericStaticMethod ("overrideCursor", "@brief Static method QCursor *QApplication::overrideCursor()\nThis method is static and can be called without an instance.", &_init_f_overrideCursor_0, &_call_f_overrideCursor_0);
  methods += new qt_gsi::GenericStaticMethod (":palette", "@brief Static method QPalette QApplication::palette()\nThis method is static and can be called without an instance.", &_init_f_palette_0, &_call_f_palette_0);
  methods += new qt_gsi::GenericStaticMethod ("palette", "@brief Static method QPalette QApplication::palette(const QWidget *)\nThis method is static and can be called without an instance.", &_init_f_palette_2010, &_call_f_palette_2010);
  methods += new qt_gsi::GenericStaticMethod ("palette", "@brief Static method QPalette QApplication::palette(const char *className)\nThis method is static and can be called without an instance.", &_init_f_palette_1731, &_call_f_palette_1731);
  methods += new qt_gsi::GenericStaticMethod (":quitOnLastWindowClosed", "@brief Static method bool QApplication::quitOnLastWindowClosed()\nThis method is static and can be called without an instance.", &_init_f_quitOnLastWindowClosed_0, &_call_f_quitOnLastWindowClosed_0);
  methods += new qt_gsi::GenericStaticMethod ("restoreOverrideCursor", "@brief Static method void QApplication::restoreOverrideCursor()\nThis method is static and can be called without an instance.", &_init_f_restoreOverrideCursor_0, &_call_f_restoreOverrideCursor_0);
  methods += new qt_gsi::GenericStaticMethod ("setActiveWindow|activeWindow=", "@brief Static method void QApplication::setActiveWindow(QWidget *act)\nThis method is static and can be called without an instance.", &_init_f_setActiveWindow_1315, &_call_f_setActiveWindow_1315);
  methods += new qt_gsi::GenericStaticMethod ("setColorSpec|colorSpec=", "@brief Static method void QApplication::setColorSpec(int)\nThis method is static and can be called without an instance.", &_init_f_setColorSpec_767, &_call_f_setColorSpec_767);
  methods += new qt_gsi::GenericStaticMethod ("setCursorFlashTime|cursorFlashTime=", "@brief Static method void QApplication::setCursorFlashTime(int)\nThis method is static and can be called without an instance.", &_init_f_setCursorFlashTime_767, &_call_f_setCursorFlashTime_767);
  methods += new qt_gsi::GenericStaticMethod ("setDesktopSettingsAware|desktopSettingsAware=", "@brief Static method void QApplication::setDesktopSettingsAware(bool)\nThis method is static and can be called without an instance.", &_init_f_setDesktopSettingsAware_864, &_call_f_setDesktopSettingsAware_864);
  methods += new qt_gsi::GenericStaticMethod ("setDoubleClickInterval|doubleClickInterval=", "@brief Static method void QApplication::setDoubleClickInterval(int)\nThis method is static and can be called without an instance.", &_init_f_setDoubleClickInterval_767, &_call_f_setDoubleClickInterval_767);
  methods += new qt_gsi::GenericStaticMethod ("setEffectEnabled", "@brief Static method void QApplication::setEffectEnabled(Qt::UIEffect, bool enable)\nThis method is static and can be called without an instance.", &_init_f_setEffectEnabled_2252, &_call_f_setEffectEnabled_2252);
  methods += new qt_gsi::GenericStaticMethod ("setFont", "@brief Static method void QApplication::setFont(const QFont &, const char *className)\nThis method is static and can be called without an instance.", &_init_f_setFont_3424, &_call_f_setFont_3424);
  methods += new qt_gsi::GenericStaticMethod ("setGlobalStrut|globalStrut=", "@brief Static method void QApplication::setGlobalStrut(const QSize &)\nThis method is static and can be called without an instance.", &_init_f_setGlobalStrut_1805, &_call_f_setGlobalStrut_1805);
  methods += new qt_gsi::GenericStaticMethod ("setGraphicsSystem", "@brief Static method void QApplication::setGraphicsSystem(const QString &)\nThis method is static and can be called without an instance.", &_init_f_setGraphicsSystem_2025, &_call_f_setGraphicsSystem_2025);
  methods += new qt_gsi::GenericStaticMethod ("setKeyboardInputInterval|keyboardInputInterval=", "@brief Static method void QApplication::setKeyboardInputInterval(int)\nThis method is static and can be called without an instance.", &_init_f_setKeyboardInputInterval_767, &_call_f_setKeyboardInputInterval_767);
  methods += new qt_gsi::GenericStaticMethod ("setLayoutDirection|layoutDirection=", "@brief Static method void QApplication::setLayoutDirection(Qt::LayoutDirection direction)\nThis method is static and can be called without an instance.", &_init_f_setLayoutDirection_2316, &_call_f_setLayoutDirection_2316);
  methods += new qt_gsi::GenericStaticMethod ("setOverrideCursor", "@brief Static method void QApplication::setOverrideCursor(const QCursor &)\nThis method is static and can be called without an instance.", &_init_f_setOverrideCursor_2032, &_call_f_setOverrideCursor_2032);
  methods += new qt_gsi::GenericStaticMethod ("setPalette", "@brief Static method void QApplication::setPalette(const QPalette &, const char *className)\nThis method is static and can be called without an instance.", &_init_f_setPalette_3736, &_call_f_setPalette_3736);
  methods += new qt_gsi::GenericStaticMethod ("setQuitOnLastWindowClosed|quitOnLastWindowClosed=", "@brief Static method void QApplication::setQuitOnLastWindowClosed(bool quit)\nThis method is static and can be called without an instance.", &_init_f_setQuitOnLastWindowClosed_864, &_call_f_setQuitOnLastWindowClosed_864);
  methods += new qt_gsi::GenericStaticMethod ("setStartDragDistance|startDragDistance=", "@brief Static method void QApplication::setStartDragDistance(int l)\nThis method is static and can be called without an instance.", &_init_f_setStartDragDistance_767, &_call_f_setStartDragDistance_767);
  methods += new qt_gsi::GenericStaticMethod ("setStartDragTime|startDragTime=", "@brief Static method void QApplication::setStartDragTime(int ms)\nThis method is static and can be called without an instance.", &_init_f_setStartDragTime_767, &_call_f_setStartDragTime_767);
  methods += new qt_gsi::GenericStaticMethod ("setStyle|style=", "@brief Static method void QApplication::setStyle(QStyle *)\nThis method is static and can be called without an instance.", &_init_f_setStyle_1232, &_call_f_setStyle_1232);
  methods += new qt_gsi::GenericStaticMethod ("setStyle|style=", "@brief Static method QStyle *QApplication::setStyle(const QString &)\nThis method is static and can be called without an instance.", &_init_f_setStyle_2025, &_call_f_setStyle_2025);
  methods += new qt_gsi::GenericStaticMethod ("setWheelScrollLines|wheelScrollLines=", "@brief Static method void QApplication::setWheelScrollLines(int)\nThis method is static and can be called without an instance.", &_init_f_setWheelScrollLines_767, &_call_f_setWheelScrollLines_767);
  methods += new qt_gsi::GenericStaticMethod ("setWindowIcon|windowIcon=", "@brief Static method void QApplication::setWindowIcon(const QIcon &icon)\nThis method is static and can be called without an instance.", &_init_f_setWindowIcon_1787, &_call_f_setWindowIcon_1787);
  methods += new qt_gsi::GenericStaticMethod (":startDragDistance", "@brief Static method int QApplication::startDragDistance()\nThis method is static and can be called without an instance.", &_init_f_startDragDistance_0, &_call_f_startDragDistance_0);
  methods += new qt_gsi::GenericStaticMethod (":startDragTime", "@brief Static method int QApplication::startDragTime()\nThis method is static and can be called without an instance.", &_init_f_startDragTime_0, &_call_f_startDragTime_0);
  methods += new qt_gsi::GenericStaticMethod (":style", "@brief Static method QStyle *QApplication::style()\nThis method is static and can be called without an instance.", &_init_f_style_0, &_call_f_style_0);
  methods += new qt_gsi::GenericStaticMethod ("syncX", "@brief Static method void QApplication::syncX()\nThis method is static and can be called without an instance.", &_init_f_syncX_0, &_call_f_syncX_0);
  methods += new qt_gsi::GenericStaticMethod ("topLevelAt", "@brief Static method QWidget *QApplication::topLevelAt(const QPoint &p)\nThis method is static and can be called without an instance.", &_init_f_topLevelAt_1916, &_call_f_topLevelAt_1916);
  methods += new qt_gsi::GenericStaticMethod ("topLevelAt", "@brief Static method QWidget *QApplication::topLevelAt(int x, int y)\nThis method is static and can be called without an instance.", &_init_f_topLevelAt_1426, &_call_f_topLevelAt_1426);
  methods += new qt_gsi::GenericStaticMethod ("topLevelWidgets", "@brief Static method QList<QWidget *> QApplication::topLevelWidgets()\nThis method is static and can be called without an instance.", &_init_f_topLevelWidgets_0, &_call_f_topLevelWidgets_0);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QApplication::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QApplication::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QApplication::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QApplication::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  methods += new qt_gsi::GenericStaticMethod ("type", "@brief Static method QApplication::Type QApplication::type()\nThis method is static and can be called without an instance.", &_init_f_type_0, &_call_f_type_0);
  methods += new qt_gsi::GenericStaticMethod (":wheelScrollLines", "@brief Static method int QApplication::wheelScrollLines()\nThis method is static and can be called without an instance.", &_init_f_wheelScrollLines_0, &_call_f_wheelScrollLines_0);
  methods += new qt_gsi::GenericStaticMethod ("widgetAt", "@brief Static method QWidget *QApplication::widgetAt(const QPoint &p)\nThis method is static and can be called without an instance.", &_init_f_widgetAt_1916, &_call_f_widgetAt_1916);
  methods += new qt_gsi::GenericStaticMethod ("widgetAt", "@brief Static method QWidget *QApplication::widgetAt(int x, int y)\nThis method is static and can be called without an instance.", &_init_f_widgetAt_1426, &_call_f_widgetAt_1426);
  methods += new qt_gsi::GenericStaticMethod (":windowIcon", "@brief Static method QIcon QApplication::windowIcon()\nThis method is static and can be called without an instance.", &_init_f_windowIcon_0, &_call_f_windowIcon_0);
  return methods;
}

gsi::Class<QCoreApplication> &qtdecl_QCoreApplication ();

qt_gsi::QtNativeClass<QApplication> decl_QApplication (qtdecl_QCoreApplication (), "QtGui", "QApplication_Native",
  methods_QApplication (),
  "@hide\n@alias QApplication");

GSI_QTGUI_PUBLIC gsi::Class<QApplication> &qtdecl_QApplication () { return decl_QApplication; }

}


class QApplication_Adaptor : public QApplication, public qt_gsi::QtObjectBase
{
public:
  static QApplication *ctor_QApplication_Adaptor_args(const std::vector<std::string> &args, bool gui)
  {
    //  QApplication needs static sources, so we give it some.
    static char **argv = 0;
    static std::vector<std::string> args_copy;
    static int argc = 0;

    if (argv != 0) {
      throw tl::Exception(tl::to_string(QObject::tr("QApplication cannot be instantiated twice")));
    }
    argv = new char *[args.size ()];
    args_copy = args;
    argc = int (args.size ());
    for (std::vector<std::string>::const_iterator a = args_copy.begin (); a != args_copy.end (); ++a) {
      argv[a - args_copy.begin ()] = (char *) a->c_str ();
    }

    return new QApplication_Adaptor (argc, argv, gui);
  }

  QApplication_Adaptor (int &argc, char **argv, bool gui) : QApplication (argc, argv, gui) { }

  virtual ~QApplication_Adaptor();

  //  [expose] int QApplication::receivers(const char *signal)
  int fp_QApplication_receivers_c1731 (const char *signal) const {
    return QApplication::receivers(signal);
  }

  //  [expose] QObject *QApplication::sender()
  QObject * fp_QApplication_sender_c0 () const {
    return QApplication::sender();
  }

  //  [adaptor impl] bool QApplication::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QApplication::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QApplication_Adaptor, bool, QObject *, QEvent *>(&QApplication_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QApplication::eventFilter(arg1, arg2);
    }
  }

  //  [emitter impl] void QApplication::aboutToQuit()
  void emitter_QApplication_aboutToQuit_0()
  {
    emit QApplication::aboutToQuit();
  }

  //  [adaptor impl] void QApplication::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QApplication::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QApplication_Adaptor, QChildEvent *>(&QApplication_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QApplication::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QApplication::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QApplication::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QApplication_Adaptor, QEvent *>(&QApplication_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QApplication::customEvent(arg1);
    }
  }

  //  [emitter impl] void QApplication::destroyed(QObject *)
  void emitter_QApplication_destroyed_1302(QObject *arg1)
  {
    emit QApplication::destroyed(arg1);
  }

  //  [adaptor impl] void QApplication::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QApplication::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QApplication_Adaptor, const char *>(&QApplication_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QApplication::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] bool QApplication::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QApplication::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QApplication_Adaptor, bool, QEvent *>(&QApplication_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QApplication::event(arg1);
    }
  }

  //  [emitter impl] void QApplication::focusChanged(QWidget *old, QWidget *now)
  void emitter_QApplication_focusChanged_2522(QWidget *old, QWidget *now)
  {
    emit QApplication::focusChanged(old, now);
  }

  //  [emitter impl] void QApplication::fontDatabaseChanged()
  void emitter_QApplication_fontDatabaseChanged_0()
  {
    emit QApplication::fontDatabaseChanged();
  }

  //  [emitter impl] void QApplication::lastWindowClosed()
  void emitter_QApplication_lastWindowClosed_0()
  {
    emit QApplication::lastWindowClosed();
  }

  //  [adaptor impl] void QApplication::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QApplication::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QApplication_Adaptor, QTimerEvent *>(&QApplication_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QApplication::timerEvent(arg1);
    }
  }

  //  [emitter impl] void QApplication::unixSignal(int)
  void emitter_QApplication_unixSignal_767(int arg1)
  {
    emit QApplication::unixSignal(arg1);
  }

  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QApplication_Adaptor::~QApplication_Adaptor() { }

// emitter void QApplication::aboutToQuit()

static void _init_emitter_aboutToQuit_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_aboutToQuit_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QApplication_Adaptor *)cls)->emitter_QApplication_aboutToQuit_0 ();
}


// void QApplication::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QApplication_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QApplication_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QApplication::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QApplication_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QApplication_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QApplication::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QApplication_Adaptor *)cls)->emitter_QApplication_destroyed_1302 (arg1);
}


// void QApplication::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QApplication_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QApplication_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}


// bool QApplication::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QApplication_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QApplication_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QApplication::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QApplication_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QApplication_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// emitter void QApplication::focusChanged(QWidget *old, QWidget *now)

static void _init_emitter_focusChanged_2522 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("old");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("now");
  decl->add_arg<QWidget * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_focusChanged_2522 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  QWidget *arg2 = gsi::arg_reader<QWidget * >() (args, heap);
  ((QApplication_Adaptor *)cls)->emitter_QApplication_focusChanged_2522 (arg1, arg2);
}


// emitter void QApplication::fontDatabaseChanged()

static void _init_emitter_fontDatabaseChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_fontDatabaseChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QApplication_Adaptor *)cls)->emitter_QApplication_fontDatabaseChanged_0 ();
}


// emitter void QApplication::lastWindowClosed()

static void _init_emitter_lastWindowClosed_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_lastWindowClosed_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QApplication_Adaptor *)cls)->emitter_QApplication_lastWindowClosed_0 ();
}


// exposed int QApplication::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QApplication_Adaptor *)cls)->fp_QApplication_receivers_c1731 (arg1));
}


// exposed QObject *QApplication::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QApplication_Adaptor *)cls)->fp_QApplication_sender_c0 ());
}


// void QApplication::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QApplication_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QApplication_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// emitter void QApplication::unixSignal(int)

static void _init_emitter_unixSignal_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_unixSignal_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QApplication_Adaptor *)cls)->emitter_QApplication_unixSignal_767 (arg1);
}


namespace gsi
{

gsi::Class<QApplication> &qtdecl_QApplication ();

static gsi::Methods methods_QApplication_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod ("emit_aboutToQuit", "@brief Emitter for signal void QApplication::aboutToQuit()\nCall this method to emit this signal.", false, &_init_emitter_aboutToQuit_0, &_call_emitter_aboutToQuit_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QApplication::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QApplication::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QApplication::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QApplication::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QApplication::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QApplication::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("emit_focusChanged", "@brief Emitter for signal void QApplication::focusChanged(QWidget *old, QWidget *now)\nCall this method to emit this signal.", false, &_init_emitter_focusChanged_2522, &_call_emitter_focusChanged_2522);
  methods += new qt_gsi::GenericMethod ("emit_fontDatabaseChanged", "@brief Emitter for signal void QApplication::fontDatabaseChanged()\nCall this method to emit this signal.", false, &_init_emitter_fontDatabaseChanged_0, &_call_emitter_fontDatabaseChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_lastWindowClosed", "@brief Emitter for signal void QApplication::lastWindowClosed()\nCall this method to emit this signal.", false, &_init_emitter_lastWindowClosed_0, &_call_emitter_lastWindowClosed_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QApplication::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QApplication::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QApplication::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("emit_unixSignal", "@brief Emitter for signal void QApplication::unixSignal(int)\nCall this method to emit this signal.", false, &_init_emitter_unixSignal_767, &_call_emitter_unixSignal_767);
  return methods;
}

gsi::Class<QApplication_Adaptor> decl_QApplication_Adaptor (qtdecl_QApplication (), "QtGui", "QApplication",
    gsi::constructor("new", &QApplication_Adaptor::ctor_QApplication_Adaptor_args, gsi::arg ("argv"), gsi::arg ("gui", true), "@brief Creates a new QApplication object\n\n@param argv The command line arguments to pass to Qt\n@param gui If true, a GUI-enabled application is constructed")
+
  methods_QApplication_Adaptor (),
  "@qt\n@brief Binding of QApplication");

}


//  Implementation of the enum wrapper class for QApplication::Type
namespace qt_gsi
{

static gsi::Enum<QApplication::Type> decl_QApplication_Type_Enum ("QtGui", "QApplication_Type",
    gsi::enum_const ("Tty", QApplication::Tty, "@brief Enum constant QApplication::Tty") +
    gsi::enum_const ("GuiClient", QApplication::GuiClient, "@brief Enum constant QApplication::GuiClient") +
    gsi::enum_const ("GuiServer", QApplication::GuiServer, "@brief Enum constant QApplication::GuiServer"),
  "@qt\n@brief This class represents the QApplication::Type enum");

static gsi::QFlagsClass<QApplication::Type > decl_QApplication_Type_Enums ("QtGui", "QApplication_QFlags_Type",
  "@qt\n@brief This class represents the QFlags<QApplication::Type> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QApplication> inject_QApplication_Type_Enum_in_parent (decl_QApplication_Type_Enum.defs ());
static gsi::ClassExt<QApplication> decl_QApplication_Type_Enum_as_child (decl_QApplication_Type_Enum, "Type");
static gsi::ClassExt<QApplication> decl_QApplication_Type_Enums_as_child (decl_QApplication_Type_Enums, "QFlags_Type");

}

