
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2021 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQFileDialog.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QFileDialog>
#include <QAbstractItemDelegate>
#include <QAbstractProxyModel>
#include <QAction>
#include <QActionEvent>
#include <QBitmap>
#include <QChildEvent>
#include <QCloseEvent>
#include <QContextMenuEvent>
#include <QCursor>
#include <QDir>
#include <QDragEnterEvent>
#include <QDragLeaveEvent>
#include <QDragMoveEvent>
#include <QDropEvent>
#include <QEvent>
#include <QFileIconProvider>
#include <QFocusEvent>
#include <QFont>
#include <QFontInfo>
#include <QFontMetrics>
#include <QGraphicsEffect>
#include <QGraphicsProxyWidget>
#include <QHideEvent>
#include <QIcon>
#include <QInputContext>
#include <QInputMethodEvent>
#include <QKeyEvent>
#include <QKeySequence>
#include <QLayout>
#include <QLocale>
#include <QMargins>
#include <QMouseEvent>
#include <QMoveEvent>
#include <QObject>
#include <QPaintDevice>
#include <QPaintEngine>
#include <QPaintEvent>
#include <QPainter>
#include <QPalette>
#include <QPoint>
#include <QRect>
#include <QRegion>
#include <QResizeEvent>
#include <QShowEvent>
#include <QSize>
#include <QSizePolicy>
#include <QStyle>
#include <QTabletEvent>
#include <QThread>
#include <QTimerEvent>
#include <QUrl>
#include <QWheelEvent>
#include <QWidget>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include "gsiDeclQtGuiTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QFileDialog

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QFileDialog::staticMetaObject);
}


// QFileDialog::AcceptMode QFileDialog::acceptMode()


static void _init_f_acceptMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFileDialog::AcceptMode>::target_type > ();
}

static void _call_f_acceptMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QFileDialog::AcceptMode>::target_type > ((qt_gsi::Converter<QFileDialog::AcceptMode>::target_type)qt_gsi::CppToQtAdaptor<QFileDialog::AcceptMode>(((QFileDialog *)cls)->acceptMode ()));
}


// bool QFileDialog::confirmOverwrite()


static void _init_f_confirmOverwrite_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_confirmOverwrite_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QFileDialog *)cls)->confirmOverwrite ());
}


// QString QFileDialog::defaultSuffix()


static void _init_f_defaultSuffix_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_defaultSuffix_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QFileDialog *)cls)->defaultSuffix ());
}


// QDir QFileDialog::directory()


static void _init_f_directory_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDir > ();
}

static void _call_f_directory_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDir > ((QDir)((QFileDialog *)cls)->directory ());
}


// QFileDialog::FileMode QFileDialog::fileMode()


static void _init_f_fileMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFileDialog::FileMode>::target_type > ();
}

static void _call_f_fileMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QFileDialog::FileMode>::target_type > ((qt_gsi::Converter<QFileDialog::FileMode>::target_type)qt_gsi::CppToQtAdaptor<QFileDialog::FileMode>(((QFileDialog *)cls)->fileMode ()));
}


// QFlags<QDir::Filter> QFileDialog::filter()


static void _init_f_filter_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QDir::Filter> > ();
}

static void _call_f_filter_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QDir::Filter> > ((QFlags<QDir::Filter>)((QFileDialog *)cls)->filter ());
}


// QStringList QFileDialog::filters()


static void _init_f_filters_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_filters_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QFileDialog *)cls)->filters ());
}


// QStringList QFileDialog::history()


static void _init_f_history_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_history_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QFileDialog *)cls)->history ());
}


// QFileIconProvider *QFileDialog::iconProvider()


static void _init_f_iconProvider_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFileIconProvider * > ();
}

static void _call_f_iconProvider_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFileIconProvider * > ((QFileIconProvider *)((QFileDialog *)cls)->iconProvider ());
}


// bool QFileDialog::isNameFilterDetailsVisible()


static void _init_f_isNameFilterDetailsVisible_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isNameFilterDetailsVisible_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QFileDialog *)cls)->isNameFilterDetailsVisible ());
}


// bool QFileDialog::isReadOnly()


static void _init_f_isReadOnly_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isReadOnly_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QFileDialog *)cls)->isReadOnly ());
}


// QAbstractItemDelegate *QFileDialog::itemDelegate()


static void _init_f_itemDelegate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAbstractItemDelegate * > ();
}

static void _call_f_itemDelegate_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAbstractItemDelegate * > ((QAbstractItemDelegate *)((QFileDialog *)cls)->itemDelegate ());
}


// QString QFileDialog::labelText(QFileDialog::DialogLabel label)


static void _init_f_labelText_c2681 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("label");
  decl->add_arg<const qt_gsi::Converter<QFileDialog::DialogLabel>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_labelText_c2681 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QFileDialog::DialogLabel>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QFileDialog::DialogLabel>::target_type & >() (args, heap);
  ret.write<QString > ((QString)((QFileDialog *)cls)->labelText (qt_gsi::QtToCppAdaptor<QFileDialog::DialogLabel>(arg1).cref()));
}


// QStringList QFileDialog::nameFilters()


static void _init_f_nameFilters_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_nameFilters_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QFileDialog *)cls)->nameFilters ());
}


// void QFileDialog::open()


static void _init_f_open_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_open_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->open ();
}


// void QFileDialog::open(QObject *receiver, const char *member)


static void _init_f_open_2925 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("receiver");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("member");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_open_2925 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->open (arg1, arg2);
}


// QFlags<QFileDialog::Option> QFileDialog::options()


static void _init_f_options_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QFileDialog::Option> > ();
}

static void _call_f_options_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QFileDialog::Option> > ((QFlags<QFileDialog::Option>)((QFileDialog *)cls)->options ());
}


// QAbstractProxyModel *QFileDialog::proxyModel()


static void _init_f_proxyModel_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAbstractProxyModel * > ();
}

static void _call_f_proxyModel_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAbstractProxyModel * > ((QAbstractProxyModel *)((QFileDialog *)cls)->proxyModel ());
}


// bool QFileDialog::resolveSymlinks()


static void _init_f_resolveSymlinks_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_resolveSymlinks_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QFileDialog *)cls)->resolveSymlinks ());
}


// bool QFileDialog::restoreState(const QByteArray &state)


static void _init_f_restoreState_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_restoreState_2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = gsi::arg_reader<const QByteArray & >() (args, heap);
  ret.write<bool > ((bool)((QFileDialog *)cls)->restoreState (arg1));
}


// QByteArray QFileDialog::saveState()


static void _init_f_saveState_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_saveState_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QByteArray > ((QByteArray)((QFileDialog *)cls)->saveState ());
}


// void QFileDialog::selectFile(const QString &filename)


static void _init_f_selectFile_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filename");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_selectFile_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->selectFile (arg1);
}


// void QFileDialog::selectFilter(const QString &filter)


static void _init_f_selectFilter_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filter");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_selectFilter_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->selectFilter (arg1);
}


// void QFileDialog::selectNameFilter(const QString &filter)


static void _init_f_selectNameFilter_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filter");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_selectNameFilter_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->selectNameFilter (arg1);
}


// QStringList QFileDialog::selectedFiles()


static void _init_f_selectedFiles_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_selectedFiles_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QFileDialog *)cls)->selectedFiles ());
}


// QString QFileDialog::selectedFilter()


static void _init_f_selectedFilter_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_selectedFilter_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QFileDialog *)cls)->selectedFilter ());
}


// QString QFileDialog::selectedNameFilter()


static void _init_f_selectedNameFilter_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_selectedNameFilter_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QFileDialog *)cls)->selectedNameFilter ());
}


// void QFileDialog::setAcceptMode(QFileDialog::AcceptMode mode)


static void _init_f_setAcceptMode_2590 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QFileDialog::AcceptMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAcceptMode_2590 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QFileDialog::AcceptMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QFileDialog::AcceptMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setAcceptMode (qt_gsi::QtToCppAdaptor<QFileDialog::AcceptMode>(arg1).cref());
}


// void QFileDialog::setConfirmOverwrite(bool enabled)


static void _init_f_setConfirmOverwrite_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setConfirmOverwrite_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setConfirmOverwrite (arg1);
}


// void QFileDialog::setDefaultSuffix(const QString &suffix)


static void _init_f_setDefaultSuffix_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("suffix");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDefaultSuffix_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setDefaultSuffix (arg1);
}


// void QFileDialog::setDirectory(const QString &directory)


static void _init_f_setDirectory_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("directory");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDirectory_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setDirectory (arg1);
}


// void QFileDialog::setDirectory(const QDir &directory)


static void _init_f_setDirectory_1681 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("directory");
  decl->add_arg<const QDir & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDirectory_1681 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QDir &arg1 = gsi::arg_reader<const QDir & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setDirectory (arg1);
}


// void QFileDialog::setFileMode(QFileDialog::FileMode mode)


static void _init_f_setFileMode_2382 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QFileDialog::FileMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFileMode_2382 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QFileDialog::FileMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QFileDialog::FileMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setFileMode (qt_gsi::QtToCppAdaptor<QFileDialog::FileMode>(arg1).cref());
}


// void QFileDialog::setFilter(const QString &filter)


static void _init_f_setFilter_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filter");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFilter_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setFilter (arg1);
}


// void QFileDialog::setFilter(QFlags<QDir::Filter> filters)


static void _init_f_setFilter_2230 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filters");
  decl->add_arg<QFlags<QDir::Filter> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFilter_2230 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QDir::Filter> arg1 = gsi::arg_reader<QFlags<QDir::Filter> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setFilter (arg1);
}


// void QFileDialog::setFilters(const QStringList &filters)


static void _init_f_setFilters_2437 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filters");
  decl->add_arg<const QStringList & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFilters_2437 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStringList &arg1 = gsi::arg_reader<const QStringList & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setFilters (arg1);
}


// void QFileDialog::setHistory(const QStringList &paths)


static void _init_f_setHistory_2437 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("paths");
  decl->add_arg<const QStringList & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHistory_2437 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStringList &arg1 = gsi::arg_reader<const QStringList & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setHistory (arg1);
}


// void QFileDialog::setIconProvider(QFileIconProvider *provider)


static void _init_f_setIconProvider_2323 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("provider");
  decl->add_arg<QFileIconProvider * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIconProvider_2323 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFileIconProvider *arg1 = gsi::arg_reader<QFileIconProvider * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setIconProvider (arg1);
}


// void QFileDialog::setItemDelegate(QAbstractItemDelegate *delegate)


static void _init_f_setItemDelegate_2717 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("delegate");
  decl->add_arg<QAbstractItemDelegate * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setItemDelegate_2717 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractItemDelegate *arg1 = gsi::arg_reader<QAbstractItemDelegate * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setItemDelegate (arg1);
}


// void QFileDialog::setLabelText(QFileDialog::DialogLabel label, const QString &text)


static void _init_f_setLabelText_4598 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("label");
  decl->add_arg<const qt_gsi::Converter<QFileDialog::DialogLabel>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("text");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setLabelText_4598 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QFileDialog::DialogLabel>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QFileDialog::DialogLabel>::target_type & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setLabelText (qt_gsi::QtToCppAdaptor<QFileDialog::DialogLabel>(arg1).cref(), arg2);
}


// void QFileDialog::setNameFilter(const QString &filter)


static void _init_f_setNameFilter_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filter");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNameFilter_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setNameFilter (arg1);
}


// void QFileDialog::setNameFilterDetailsVisible(bool enabled)


static void _init_f_setNameFilterDetailsVisible_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNameFilterDetailsVisible_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setNameFilterDetailsVisible (arg1);
}


// void QFileDialog::setNameFilters(const QStringList &filters)


static void _init_f_setNameFilters_2437 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filters");
  decl->add_arg<const QStringList & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNameFilters_2437 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStringList &arg1 = gsi::arg_reader<const QStringList & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setNameFilters (arg1);
}


// void QFileDialog::setOption(QFileDialog::Option option, bool on)


static void _init_f_setOption_2998 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QFileDialog::Option>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("on", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setOption_2998 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QFileDialog::Option>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QFileDialog::Option>::target_type & >() (args, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setOption (qt_gsi::QtToCppAdaptor<QFileDialog::Option>(arg1).cref(), arg2);
}


// void QFileDialog::setOptions(QFlags<QFileDialog::Option> options)


static void _init_f_setOptions_2938 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("options");
  decl->add_arg<QFlags<QFileDialog::Option> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOptions_2938 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QFileDialog::Option> arg1 = gsi::arg_reader<QFlags<QFileDialog::Option> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setOptions (arg1);
}


// void QFileDialog::setProxyModel(QAbstractProxyModel *model)


static void _init_f_setProxyModel_2566 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("model");
  decl->add_arg<QAbstractProxyModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setProxyModel_2566 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractProxyModel *arg1 = gsi::arg_reader<QAbstractProxyModel * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setProxyModel (arg1);
}


// void QFileDialog::setReadOnly(bool enabled)


static void _init_f_setReadOnly_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setReadOnly_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setReadOnly (arg1);
}


// void QFileDialog::setResolveSymlinks(bool enabled)


static void _init_f_setResolveSymlinks_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setResolveSymlinks_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setResolveSymlinks (arg1);
}


// void QFileDialog::setSidebarUrls(const QList<QUrl> &urls)


static void _init_f_setSidebarUrls_2316 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("urls");
  decl->add_arg<const QList<QUrl> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSidebarUrls_2316 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QUrl> &arg1 = gsi::arg_reader<const QList<QUrl> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setSidebarUrls (arg1);
}


// void QFileDialog::setViewMode(QFileDialog::ViewMode mode)


static void _init_f_setViewMode_2409 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QFileDialog::ViewMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setViewMode_2409 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QFileDialog::ViewMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QFileDialog::ViewMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setViewMode (qt_gsi::QtToCppAdaptor<QFileDialog::ViewMode>(arg1).cref());
}


// void QFileDialog::setVisible(bool visible)


static void _init_f_setVisible_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVisible_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setVisible (arg1);
}


// QList<QUrl> QFileDialog::sidebarUrls()


static void _init_f_sidebarUrls_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QUrl> > ();
}

static void _call_f_sidebarUrls_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QUrl> > ((QList<QUrl>)((QFileDialog *)cls)->sidebarUrls ());
}


// bool QFileDialog::testOption(QFileDialog::Option option)


static void _init_f_testOption_c2242 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QFileDialog::Option>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_testOption_c2242 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QFileDialog::Option>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QFileDialog::Option>::target_type & >() (args, heap);
  ret.write<bool > ((bool)((QFileDialog *)cls)->testOption (qt_gsi::QtToCppAdaptor<QFileDialog::Option>(arg1).cref()));
}


// QFileDialog::ViewMode QFileDialog::viewMode()


static void _init_f_viewMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFileDialog::ViewMode>::target_type > ();
}

static void _call_f_viewMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QFileDialog::ViewMode>::target_type > ((qt_gsi::Converter<QFileDialog::ViewMode>::target_type)qt_gsi::CppToQtAdaptor<QFileDialog::ViewMode>(((QFileDialog *)cls)->viewMode ()));
}


// static QString QFileDialog::getExistingDirectory(QWidget *parent, const QString &caption, const QString &dir, QFlags<QFileDialog::Option> options)


static void _init_f_getExistingDirectory_7979 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("caption", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("dir", true, "QString()");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("options", true, "QFileDialog::ShowDirsOnly");
  decl->add_arg<QFlags<QFileDialog::Option> > (argspec_3);
  decl->set_return<QString > ();
}

static void _call_f_getExistingDirectory_7979 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (0, heap);
  const QString &arg2 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  const QString &arg3 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  QFlags<QFileDialog::Option> arg4 = args ? gsi::arg_reader<QFlags<QFileDialog::Option> >() (args, heap) : gsi::arg_maker<QFlags<QFileDialog::Option> >() (QFileDialog::ShowDirsOnly, heap);
  ret.write<QString > ((QString)QFileDialog::getExistingDirectory (arg1, arg2, arg3, arg4));
}


// static QString QFileDialog::getOpenFileName(QWidget *parent, const QString &caption, const QString &dir, const QString &filter, QString *selectedFilter, QFlags<QFileDialog::Option> options)


static void _init_f_getOpenFileName_11122 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("caption", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("dir", true, "QString()");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("filter", true, "QString()");
  decl->add_arg<const QString & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("selectedFilter", true, "0");
  decl->add_arg<QString * > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("options", true, "0");
  decl->add_arg<QFlags<QFileDialog::Option> > (argspec_5);
  decl->set_return<QString > ();
}

static void _call_f_getOpenFileName_11122 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (0, heap);
  const QString &arg2 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  const QString &arg3 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  const QString &arg4 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  QString *arg5 = args ? gsi::arg_reader<QString * >() (args, heap) : gsi::arg_maker<QString * >() (0, heap);
  QFlags<QFileDialog::Option> arg6 = args ? gsi::arg_reader<QFlags<QFileDialog::Option> >() (args, heap) : gsi::arg_maker<QFlags<QFileDialog::Option> >() (0, heap);
  ret.write<QString > ((QString)QFileDialog::getOpenFileName (arg1, arg2, arg3, arg4, arg5, arg6));
}


// static QStringList QFileDialog::getOpenFileNames(QWidget *parent, const QString &caption, const QString &dir, const QString &filter, QString *selectedFilter, QFlags<QFileDialog::Option> options)


static void _init_f_getOpenFileNames_11122 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("caption", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("dir", true, "QString()");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("filter", true, "QString()");
  decl->add_arg<const QString & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("selectedFilter", true, "0");
  decl->add_arg<QString * > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("options", true, "0");
  decl->add_arg<QFlags<QFileDialog::Option> > (argspec_5);
  decl->set_return<QStringList > ();
}

static void _call_f_getOpenFileNames_11122 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (0, heap);
  const QString &arg2 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  const QString &arg3 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  const QString &arg4 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  QString *arg5 = args ? gsi::arg_reader<QString * >() (args, heap) : gsi::arg_maker<QString * >() (0, heap);
  QFlags<QFileDialog::Option> arg6 = args ? gsi::arg_reader<QFlags<QFileDialog::Option> >() (args, heap) : gsi::arg_maker<QFlags<QFileDialog::Option> >() (0, heap);
  ret.write<QStringList > ((QStringList)QFileDialog::getOpenFileNames (arg1, arg2, arg3, arg4, arg5, arg6));
}


// static QString QFileDialog::getSaveFileName(QWidget *parent, const QString &caption, const QString &dir, const QString &filter, QString *selectedFilter, QFlags<QFileDialog::Option> options)


static void _init_f_getSaveFileName_11122 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("caption", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("dir", true, "QString()");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("filter", true, "QString()");
  decl->add_arg<const QString & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("selectedFilter", true, "0");
  decl->add_arg<QString * > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("options", true, "0");
  decl->add_arg<QFlags<QFileDialog::Option> > (argspec_5);
  decl->set_return<QString > ();
}

static void _call_f_getSaveFileName_11122 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (0, heap);
  const QString &arg2 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  const QString &arg3 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  const QString &arg4 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  QString *arg5 = args ? gsi::arg_reader<QString * >() (args, heap) : gsi::arg_maker<QString * >() (0, heap);
  QFlags<QFileDialog::Option> arg6 = args ? gsi::arg_reader<QFlags<QFileDialog::Option> >() (args, heap) : gsi::arg_maker<QFlags<QFileDialog::Option> >() (0, heap);
  ret.write<QString > ((QString)QFileDialog::getSaveFileName (arg1, arg2, arg3, arg4, arg5, arg6));
}


// static QString QFileDialog::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QFileDialog::tr (arg1, arg2));
}


// static QString QFileDialog::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QFileDialog::tr (arg1, arg2, arg3));
}


// static QString QFileDialog::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QFileDialog::trUtf8 (arg1, arg2));
}


// static QString QFileDialog::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QFileDialog::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QFileDialog () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":acceptMode", "@brief Method QFileDialog::AcceptMode QFileDialog::acceptMode()\n", true, &_init_f_acceptMode_c0, &_call_f_acceptMode_c0);
  methods += new qt_gsi::GenericMethod (":confirmOverwrite", "@brief Method bool QFileDialog::confirmOverwrite()\n", true, &_init_f_confirmOverwrite_c0, &_call_f_confirmOverwrite_c0);
  methods += new qt_gsi::GenericMethod (":defaultSuffix", "@brief Method QString QFileDialog::defaultSuffix()\n", true, &_init_f_defaultSuffix_c0, &_call_f_defaultSuffix_c0);
  methods += new qt_gsi::GenericMethod ("directory", "@brief Method QDir QFileDialog::directory()\n", true, &_init_f_directory_c0, &_call_f_directory_c0);
  methods += new qt_gsi::GenericMethod (":fileMode", "@brief Method QFileDialog::FileMode QFileDialog::fileMode()\n", true, &_init_f_fileMode_c0, &_call_f_fileMode_c0);
  methods += new qt_gsi::GenericMethod ("filter", "@brief Method QFlags<QDir::Filter> QFileDialog::filter()\n", true, &_init_f_filter_c0, &_call_f_filter_c0);
  methods += new qt_gsi::GenericMethod (":filters", "@brief Method QStringList QFileDialog::filters()\n", true, &_init_f_filters_c0, &_call_f_filters_c0);
  methods += new qt_gsi::GenericMethod (":history", "@brief Method QStringList QFileDialog::history()\n", true, &_init_f_history_c0, &_call_f_history_c0);
  methods += new qt_gsi::GenericMethod (":iconProvider", "@brief Method QFileIconProvider *QFileDialog::iconProvider()\n", true, &_init_f_iconProvider_c0, &_call_f_iconProvider_c0);
  methods += new qt_gsi::GenericMethod ("isNameFilterDetailsVisible?|:nameFilterDetailsVisible", "@brief Method bool QFileDialog::isNameFilterDetailsVisible()\n", true, &_init_f_isNameFilterDetailsVisible_c0, &_call_f_isNameFilterDetailsVisible_c0);
  methods += new qt_gsi::GenericMethod ("isReadOnly?|:readOnly", "@brief Method bool QFileDialog::isReadOnly()\n", true, &_init_f_isReadOnly_c0, &_call_f_isReadOnly_c0);
  methods += new qt_gsi::GenericMethod (":itemDelegate", "@brief Method QAbstractItemDelegate *QFileDialog::itemDelegate()\n", true, &_init_f_itemDelegate_c0, &_call_f_itemDelegate_c0);
  methods += new qt_gsi::GenericMethod ("labelText", "@brief Method QString QFileDialog::labelText(QFileDialog::DialogLabel label)\n", true, &_init_f_labelText_c2681, &_call_f_labelText_c2681);
  methods += new qt_gsi::GenericMethod (":nameFilters", "@brief Method QStringList QFileDialog::nameFilters()\n", true, &_init_f_nameFilters_c0, &_call_f_nameFilters_c0);
  methods += new qt_gsi::GenericMethod ("open", "@brief Method void QFileDialog::open()\n", false, &_init_f_open_0, &_call_f_open_0);
  methods += new qt_gsi::GenericMethod ("open", "@brief Method void QFileDialog::open(QObject *receiver, const char *member)\n", false, &_init_f_open_2925, &_call_f_open_2925);
  methods += new qt_gsi::GenericMethod (":options", "@brief Method QFlags<QFileDialog::Option> QFileDialog::options()\n", true, &_init_f_options_c0, &_call_f_options_c0);
  methods += new qt_gsi::GenericMethod (":proxyModel", "@brief Method QAbstractProxyModel *QFileDialog::proxyModel()\n", true, &_init_f_proxyModel_c0, &_call_f_proxyModel_c0);
  methods += new qt_gsi::GenericMethod (":resolveSymlinks", "@brief Method bool QFileDialog::resolveSymlinks()\n", true, &_init_f_resolveSymlinks_c0, &_call_f_resolveSymlinks_c0);
  methods += new qt_gsi::GenericMethod ("restoreState", "@brief Method bool QFileDialog::restoreState(const QByteArray &state)\n", false, &_init_f_restoreState_2309, &_call_f_restoreState_2309);
  methods += new qt_gsi::GenericMethod ("saveState", "@brief Method QByteArray QFileDialog::saveState()\n", true, &_init_f_saveState_c0, &_call_f_saveState_c0);
  methods += new qt_gsi::GenericMethod ("selectFile", "@brief Method void QFileDialog::selectFile(const QString &filename)\n", false, &_init_f_selectFile_2025, &_call_f_selectFile_2025);
  methods += new qt_gsi::GenericMethod ("selectFilter", "@brief Method void QFileDialog::selectFilter(const QString &filter)\n", false, &_init_f_selectFilter_2025, &_call_f_selectFilter_2025);
  methods += new qt_gsi::GenericMethod ("selectNameFilter", "@brief Method void QFileDialog::selectNameFilter(const QString &filter)\n", false, &_init_f_selectNameFilter_2025, &_call_f_selectNameFilter_2025);
  methods += new qt_gsi::GenericMethod ("selectedFiles", "@brief Method QStringList QFileDialog::selectedFiles()\n", true, &_init_f_selectedFiles_c0, &_call_f_selectedFiles_c0);
  methods += new qt_gsi::GenericMethod ("selectedFilter", "@brief Method QString QFileDialog::selectedFilter()\n", true, &_init_f_selectedFilter_c0, &_call_f_selectedFilter_c0);
  methods += new qt_gsi::GenericMethod ("selectedNameFilter", "@brief Method QString QFileDialog::selectedNameFilter()\n", true, &_init_f_selectedNameFilter_c0, &_call_f_selectedNameFilter_c0);
  methods += new qt_gsi::GenericMethod ("setAcceptMode|acceptMode=", "@brief Method void QFileDialog::setAcceptMode(QFileDialog::AcceptMode mode)\n", false, &_init_f_setAcceptMode_2590, &_call_f_setAcceptMode_2590);
  methods += new qt_gsi::GenericMethod ("setConfirmOverwrite|confirmOverwrite=", "@brief Method void QFileDialog::setConfirmOverwrite(bool enabled)\n", false, &_init_f_setConfirmOverwrite_864, &_call_f_setConfirmOverwrite_864);
  methods += new qt_gsi::GenericMethod ("setDefaultSuffix|defaultSuffix=", "@brief Method void QFileDialog::setDefaultSuffix(const QString &suffix)\n", false, &_init_f_setDefaultSuffix_2025, &_call_f_setDefaultSuffix_2025);
  methods += new qt_gsi::GenericMethod ("setDirectory", "@brief Method void QFileDialog::setDirectory(const QString &directory)\n", false, &_init_f_setDirectory_2025, &_call_f_setDirectory_2025);
  methods += new qt_gsi::GenericMethod ("setDirectory", "@brief Method void QFileDialog::setDirectory(const QDir &directory)\n", false, &_init_f_setDirectory_1681, &_call_f_setDirectory_1681);
  methods += new qt_gsi::GenericMethod ("setFileMode|fileMode=", "@brief Method void QFileDialog::setFileMode(QFileDialog::FileMode mode)\n", false, &_init_f_setFileMode_2382, &_call_f_setFileMode_2382);
  methods += new qt_gsi::GenericMethod ("setFilter", "@brief Method void QFileDialog::setFilter(const QString &filter)\n", false, &_init_f_setFilter_2025, &_call_f_setFilter_2025);
  methods += new qt_gsi::GenericMethod ("setFilter", "@brief Method void QFileDialog::setFilter(QFlags<QDir::Filter> filters)\n", false, &_init_f_setFilter_2230, &_call_f_setFilter_2230);
  methods += new qt_gsi::GenericMethod ("setFilters|filters=", "@brief Method void QFileDialog::setFilters(const QStringList &filters)\n", false, &_init_f_setFilters_2437, &_call_f_setFilters_2437);
  methods += new qt_gsi::GenericMethod ("setHistory|history=", "@brief Method void QFileDialog::setHistory(const QStringList &paths)\n", false, &_init_f_setHistory_2437, &_call_f_setHistory_2437);
  methods += new qt_gsi::GenericMethod ("setIconProvider|iconProvider=", "@brief Method void QFileDialog::setIconProvider(QFileIconProvider *provider)\n", false, &_init_f_setIconProvider_2323, &_call_f_setIconProvider_2323);
  methods += new qt_gsi::GenericMethod ("setItemDelegate|itemDelegate=", "@brief Method void QFileDialog::setItemDelegate(QAbstractItemDelegate *delegate)\n", false, &_init_f_setItemDelegate_2717, &_call_f_setItemDelegate_2717);
  methods += new qt_gsi::GenericMethod ("setLabelText", "@brief Method void QFileDialog::setLabelText(QFileDialog::DialogLabel label, const QString &text)\n", false, &_init_f_setLabelText_4598, &_call_f_setLabelText_4598);
  methods += new qt_gsi::GenericMethod ("setNameFilter", "@brief Method void QFileDialog::setNameFilter(const QString &filter)\n", false, &_init_f_setNameFilter_2025, &_call_f_setNameFilter_2025);
  methods += new qt_gsi::GenericMethod ("setNameFilterDetailsVisible|nameFilterDetailsVisible=", "@brief Method void QFileDialog::setNameFilterDetailsVisible(bool enabled)\n", false, &_init_f_setNameFilterDetailsVisible_864, &_call_f_setNameFilterDetailsVisible_864);
  methods += new qt_gsi::GenericMethod ("setNameFilters|nameFilters=", "@brief Method void QFileDialog::setNameFilters(const QStringList &filters)\n", false, &_init_f_setNameFilters_2437, &_call_f_setNameFilters_2437);
  methods += new qt_gsi::GenericMethod ("setOption", "@brief Method void QFileDialog::setOption(QFileDialog::Option option, bool on)\n", false, &_init_f_setOption_2998, &_call_f_setOption_2998);
  methods += new qt_gsi::GenericMethod ("setOptions|options=", "@brief Method void QFileDialog::setOptions(QFlags<QFileDialog::Option> options)\n", false, &_init_f_setOptions_2938, &_call_f_setOptions_2938);
  methods += new qt_gsi::GenericMethod ("setProxyModel|proxyModel=", "@brief Method void QFileDialog::setProxyModel(QAbstractProxyModel *model)\n", false, &_init_f_setProxyModel_2566, &_call_f_setProxyModel_2566);
  methods += new qt_gsi::GenericMethod ("setReadOnly|readOnly=", "@brief Method void QFileDialog::setReadOnly(bool enabled)\n", false, &_init_f_setReadOnly_864, &_call_f_setReadOnly_864);
  methods += new qt_gsi::GenericMethod ("setResolveSymlinks|resolveSymlinks=", "@brief Method void QFileDialog::setResolveSymlinks(bool enabled)\n", false, &_init_f_setResolveSymlinks_864, &_call_f_setResolveSymlinks_864);
  methods += new qt_gsi::GenericMethod ("setSidebarUrls|sidebarUrls=", "@brief Method void QFileDialog::setSidebarUrls(const QList<QUrl> &urls)\n", false, &_init_f_setSidebarUrls_2316, &_call_f_setSidebarUrls_2316);
  methods += new qt_gsi::GenericMethod ("setViewMode|viewMode=", "@brief Method void QFileDialog::setViewMode(QFileDialog::ViewMode mode)\n", false, &_init_f_setViewMode_2409, &_call_f_setViewMode_2409);
  methods += new qt_gsi::GenericMethod ("setVisible|visible=", "@brief Method void QFileDialog::setVisible(bool visible)\nThis is a reimplementation of QDialog::setVisible", false, &_init_f_setVisible_864, &_call_f_setVisible_864);
  methods += new qt_gsi::GenericMethod (":sidebarUrls", "@brief Method QList<QUrl> QFileDialog::sidebarUrls()\n", true, &_init_f_sidebarUrls_c0, &_call_f_sidebarUrls_c0);
  methods += new qt_gsi::GenericMethod ("testOption", "@brief Method bool QFileDialog::testOption(QFileDialog::Option option)\n", true, &_init_f_testOption_c2242, &_call_f_testOption_c2242);
  methods += new qt_gsi::GenericMethod (":viewMode", "@brief Method QFileDialog::ViewMode QFileDialog::viewMode()\n", true, &_init_f_viewMode_c0, &_call_f_viewMode_c0);
  methods += gsi::qt_signal ("accepted()", "accepted", "@brief Signal declaration for QFileDialog::accepted()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("currentChanged(const QString &)", "currentChanged", gsi::arg("path"), "@brief Signal declaration for QFileDialog::currentChanged(const QString &path)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QPoint & > ("customContextMenuRequested(const QPoint &)", "customContextMenuRequested", gsi::arg("pos"), "@brief Signal declaration for QFileDialog::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QFileDialog::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("directoryEntered(const QString &)", "directoryEntered", gsi::arg("directory"), "@brief Signal declaration for QFileDialog::directoryEntered(const QString &directory)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("fileSelected(const QString &)", "fileSelected", gsi::arg("file"), "@brief Signal declaration for QFileDialog::fileSelected(const QString &file)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QStringList & > ("filesSelected(const QStringList &)", "filesSelected", gsi::arg("files"), "@brief Signal declaration for QFileDialog::filesSelected(const QStringList &files)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("filterSelected(const QString &)", "filterSelected", gsi::arg("filter"), "@brief Signal declaration for QFileDialog::filterSelected(const QString &filter)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("finished(int)", "finished", gsi::arg("result"), "@brief Signal declaration for QFileDialog::finished(int result)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("rejected()", "rejected", "@brief Signal declaration for QFileDialog::rejected()\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("getExistingDirectory", "@brief Static method QString QFileDialog::getExistingDirectory(QWidget *parent, const QString &caption, const QString &dir, QFlags<QFileDialog::Option> options)\nThis method is static and can be called without an instance.", &_init_f_getExistingDirectory_7979, &_call_f_getExistingDirectory_7979);
  methods += new qt_gsi::GenericStaticMethod ("getOpenFileName", "@brief Static method QString QFileDialog::getOpenFileName(QWidget *parent, const QString &caption, const QString &dir, const QString &filter, QString *selectedFilter, QFlags<QFileDialog::Option> options)\nThis method is static and can be called without an instance.", &_init_f_getOpenFileName_11122, &_call_f_getOpenFileName_11122);
  methods += new qt_gsi::GenericStaticMethod ("getOpenFileNames", "@brief Static method QStringList QFileDialog::getOpenFileNames(QWidget *parent, const QString &caption, const QString &dir, const QString &filter, QString *selectedFilter, QFlags<QFileDialog::Option> options)\nThis method is static and can be called without an instance.", &_init_f_getOpenFileNames_11122, &_call_f_getOpenFileNames_11122);
  methods += new qt_gsi::GenericStaticMethod ("getSaveFileName", "@brief Static method QString QFileDialog::getSaveFileName(QWidget *parent, const QString &caption, const QString &dir, const QString &filter, QString *selectedFilter, QFlags<QFileDialog::Option> options)\nThis method is static and can be called without an instance.", &_init_f_getSaveFileName_11122, &_call_f_getSaveFileName_11122);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QFileDialog::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QFileDialog::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QFileDialog::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QFileDialog::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QDialog> &qtdecl_QDialog ();

qt_gsi::QtNativeClass<QFileDialog> decl_QFileDialog (qtdecl_QDialog (), "QtGui", "QFileDialog_Native",
  methods_QFileDialog (),
  "@hide\n@alias QFileDialog");

GSI_QTGUI_PUBLIC gsi::Class<QFileDialog> &qtdecl_QFileDialog () { return decl_QFileDialog; }

}


class QFileDialog_Adaptor : public QFileDialog, public qt_gsi::QtObjectBase
{
public:

  virtual ~QFileDialog_Adaptor();

  //  [adaptor ctor] QFileDialog::QFileDialog(QWidget *parent, QFlags<Qt::WindowType> f)
  QFileDialog_Adaptor(QWidget *parent, QFlags<Qt::WindowType> f) : QFileDialog(parent, f)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QFileDialog::QFileDialog(QWidget *parent, const QString &caption, const QString &directory, const QString &filter)
  QFileDialog_Adaptor() : QFileDialog()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QFileDialog::QFileDialog(QWidget *parent, const QString &caption, const QString &directory, const QString &filter)
  QFileDialog_Adaptor(QWidget *parent) : QFileDialog(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QFileDialog::QFileDialog(QWidget *parent, const QString &caption, const QString &directory, const QString &filter)
  QFileDialog_Adaptor(QWidget *parent, const QString &caption) : QFileDialog(parent, caption)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QFileDialog::QFileDialog(QWidget *parent, const QString &caption, const QString &directory, const QString &filter)
  QFileDialog_Adaptor(QWidget *parent, const QString &caption, const QString &directory) : QFileDialog(parent, caption, directory)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QFileDialog::QFileDialog(QWidget *parent, const QString &caption, const QString &directory, const QString &filter)
  QFileDialog_Adaptor(QWidget *parent, const QString &caption, const QString &directory, const QString &filter) : QFileDialog(parent, caption, directory, filter)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QFileDialog::adjustPosition(QWidget *)
  void fp_QFileDialog_adjustPosition_1315 (QWidget *arg1) {
    QFileDialog::adjustPosition(arg1);
  }

  //  [expose] void QFileDialog::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QFileDialog_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QFileDialog::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  [expose] void QFileDialog::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QFileDialog_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QFileDialog::destroy(destroyWindow, destroySubWindows);
  }

  //  [expose] bool QFileDialog::focusNextChild()
  bool fp_QFileDialog_focusNextChild_0 () {
    return QFileDialog::focusNextChild();
  }

  //  [expose] bool QFileDialog::focusPreviousChild()
  bool fp_QFileDialog_focusPreviousChild_0 () {
    return QFileDialog::focusPreviousChild();
  }

  //  [expose] int QFileDialog::receivers(const char *signal)
  int fp_QFileDialog_receivers_c1731 (const char *signal) const {
    return QFileDialog::receivers(signal);
  }

  //  [expose] void QFileDialog::resetInputContext()
  void fp_QFileDialog_resetInputContext_0 () {
    QFileDialog::resetInputContext();
  }

  //  [expose] QObject *QFileDialog::sender()
  QObject * fp_QFileDialog_sender_c0 () const {
    return QFileDialog::sender();
  }

  //  [expose] void QFileDialog::updateMicroFocus()
  void fp_QFileDialog_updateMicroFocus_0 () {
    QFileDialog::updateMicroFocus();
  }

  //  [adaptor impl] int QFileDialog::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QFileDialog::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QFileDialog_Adaptor, int, int>(&QFileDialog_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QFileDialog::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QFileDialog::inputMethodQuery(Qt::InputMethodQuery)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1) const
  {
    return QFileDialog::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg1) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QFileDialog_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QFileDialog_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(arg1));
    } else {
      return QFileDialog::inputMethodQuery(arg1);
    }
  }

  //  [adaptor impl] QSize QFileDialog::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QFileDialog::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QFileDialog_Adaptor, QSize>(&QFileDialog_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QFileDialog::minimumSizeHint();
    }
  }

  //  [adaptor impl] QPaintEngine *QFileDialog::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QFileDialog::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QFileDialog_Adaptor, QPaintEngine *>(&QFileDialog_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QFileDialog::paintEngine();
    }
  }

  //  [adaptor impl] void QFileDialog::reject()
  void cbs_reject_0_0()
  {
    QFileDialog::reject();
  }

  virtual void reject()
  {
    if (cb_reject_0_0.can_issue()) {
      cb_reject_0_0.issue<QFileDialog_Adaptor>(&QFileDialog_Adaptor::cbs_reject_0_0);
    } else {
      QFileDialog::reject();
    }
  }

  //  [adaptor impl] void QFileDialog::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QFileDialog::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QFileDialog_Adaptor, bool>(&QFileDialog_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QFileDialog::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QFileDialog::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QFileDialog::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QFileDialog_Adaptor, QSize>(&QFileDialog_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QFileDialog::sizeHint();
    }
  }

  //  [adaptor impl] void QFileDialog::accept()
  void cbs_accept_0_0()
  {
    QFileDialog::accept();
  }

  virtual void accept()
  {
    if (cb_accept_0_0.can_issue()) {
      cb_accept_0_0.issue<QFileDialog_Adaptor>(&QFileDialog_Adaptor::cbs_accept_0_0);
    } else {
      QFileDialog::accept();
    }
  }

  //  [emitter impl] void QFileDialog::accepted()
  void emitter_QFileDialog_accepted_0()
  {
    emit QFileDialog::accepted();
  }

  //  [adaptor impl] void QFileDialog::actionEvent(QActionEvent *)
  void cbs_actionEvent_1823_0(QActionEvent *arg1)
  {
    QFileDialog::actionEvent(arg1);
  }

  virtual void actionEvent(QActionEvent *arg1)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QFileDialog_Adaptor, QActionEvent *>(&QFileDialog_Adaptor::cbs_actionEvent_1823_0, arg1);
    } else {
      QFileDialog::actionEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::changeEvent(QEvent *e)
  void cbs_changeEvent_1217_0(QEvent *e)
  {
    QFileDialog::changeEvent(e);
  }

  virtual void changeEvent(QEvent *e)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QFileDialog_Adaptor, QEvent *>(&QFileDialog_Adaptor::cbs_changeEvent_1217_0, e);
    } else {
      QFileDialog::changeEvent(e);
    }
  }

  //  [adaptor impl] void QFileDialog::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QFileDialog::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QFileDialog_Adaptor, QChildEvent *>(&QFileDialog_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QFileDialog::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::closeEvent(QCloseEvent *)
  void cbs_closeEvent_1719_0(QCloseEvent *arg1)
  {
    QFileDialog::closeEvent(arg1);
  }

  virtual void closeEvent(QCloseEvent *arg1)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QFileDialog_Adaptor, QCloseEvent *>(&QFileDialog_Adaptor::cbs_closeEvent_1719_0, arg1);
    } else {
      QFileDialog::closeEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::contextMenuEvent(QContextMenuEvent *)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *arg1)
  {
    QFileDialog::contextMenuEvent(arg1);
  }

  virtual void contextMenuEvent(QContextMenuEvent *arg1)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QFileDialog_Adaptor, QContextMenuEvent *>(&QFileDialog_Adaptor::cbs_contextMenuEvent_2363_0, arg1);
    } else {
      QFileDialog::contextMenuEvent(arg1);
    }
  }

  //  [emitter impl] void QFileDialog::currentChanged(const QString &path)
  void emitter_QFileDialog_currentChanged_2025(const QString &path)
  {
    emit QFileDialog::currentChanged(path);
  }

  //  [emitter impl] void QFileDialog::customContextMenuRequested(const QPoint &pos)
  void emitter_QFileDialog_customContextMenuRequested_1916(const QPoint &pos)
  {
    emit QFileDialog::customContextMenuRequested(pos);
  }

  //  [adaptor impl] void QFileDialog::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QFileDialog::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QFileDialog_Adaptor, QEvent *>(&QFileDialog_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QFileDialog::customEvent(arg1);
    }
  }

  //  [emitter impl] void QFileDialog::destroyed(QObject *)
  void emitter_QFileDialog_destroyed_1302(QObject *arg1)
  {
    emit QFileDialog::destroyed(arg1);
  }

  //  [emitter impl] void QFileDialog::directoryEntered(const QString &directory)
  void emitter_QFileDialog_directoryEntered_2025(const QString &directory)
  {
    emit QFileDialog::directoryEntered(directory);
  }

  //  [adaptor impl] void QFileDialog::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QFileDialog::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QFileDialog_Adaptor, const char *>(&QFileDialog_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QFileDialog::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QFileDialog::done(int result)
  void cbs_done_767_0(int result)
  {
    QFileDialog::done(result);
  }

  virtual void done(int result)
  {
    if (cb_done_767_0.can_issue()) {
      cb_done_767_0.issue<QFileDialog_Adaptor, int>(&QFileDialog_Adaptor::cbs_done_767_0, result);
    } else {
      QFileDialog::done(result);
    }
  }

  //  [adaptor impl] void QFileDialog::dragEnterEvent(QDragEnterEvent *)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *arg1)
  {
    QFileDialog::dragEnterEvent(arg1);
  }

  virtual void dragEnterEvent(QDragEnterEvent *arg1)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QFileDialog_Adaptor, QDragEnterEvent *>(&QFileDialog_Adaptor::cbs_dragEnterEvent_2109_0, arg1);
    } else {
      QFileDialog::dragEnterEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::dragLeaveEvent(QDragLeaveEvent *)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *arg1)
  {
    QFileDialog::dragLeaveEvent(arg1);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *arg1)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QFileDialog_Adaptor, QDragLeaveEvent *>(&QFileDialog_Adaptor::cbs_dragLeaveEvent_2092_0, arg1);
    } else {
      QFileDialog::dragLeaveEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::dragMoveEvent(QDragMoveEvent *)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *arg1)
  {
    QFileDialog::dragMoveEvent(arg1);
  }

  virtual void dragMoveEvent(QDragMoveEvent *arg1)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QFileDialog_Adaptor, QDragMoveEvent *>(&QFileDialog_Adaptor::cbs_dragMoveEvent_2006_0, arg1);
    } else {
      QFileDialog::dragMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::dropEvent(QDropEvent *)
  void cbs_dropEvent_1622_0(QDropEvent *arg1)
  {
    QFileDialog::dropEvent(arg1);
  }

  virtual void dropEvent(QDropEvent *arg1)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QFileDialog_Adaptor, QDropEvent *>(&QFileDialog_Adaptor::cbs_dropEvent_1622_0, arg1);
    } else {
      QFileDialog::dropEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::enabledChange(bool)
  void cbs_enabledChange_864_0(bool arg1)
  {
    QFileDialog::enabledChange(arg1);
  }

  virtual void enabledChange(bool arg1)
  {
    if (cb_enabledChange_864_0.can_issue()) {
      cb_enabledChange_864_0.issue<QFileDialog_Adaptor, bool>(&QFileDialog_Adaptor::cbs_enabledChange_864_0, arg1);
    } else {
      QFileDialog::enabledChange(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::enterEvent(QEvent *)
  void cbs_enterEvent_1217_0(QEvent *arg1)
  {
    QFileDialog::enterEvent(arg1);
  }

  virtual void enterEvent(QEvent *arg1)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QFileDialog_Adaptor, QEvent *>(&QFileDialog_Adaptor::cbs_enterEvent_1217_0, arg1);
    } else {
      QFileDialog::enterEvent(arg1);
    }
  }

  //  [adaptor impl] bool QFileDialog::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QFileDialog::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QFileDialog_Adaptor, bool, QEvent *>(&QFileDialog_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QFileDialog::event(arg1);
    }
  }

  //  [adaptor impl] bool QFileDialog::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QFileDialog::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QFileDialog_Adaptor, bool, QObject *, QEvent *>(&QFileDialog_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QFileDialog::eventFilter(arg1, arg2);
    }
  }

  //  [emitter impl] void QFileDialog::fileSelected(const QString &file)
  void emitter_QFileDialog_fileSelected_2025(const QString &file)
  {
    emit QFileDialog::fileSelected(file);
  }

  //  [emitter impl] void QFileDialog::filesSelected(const QStringList &files)
  void emitter_QFileDialog_filesSelected_2437(const QStringList &files)
  {
    emit QFileDialog::filesSelected(files);
  }

  //  [emitter impl] void QFileDialog::filterSelected(const QString &filter)
  void emitter_QFileDialog_filterSelected_2025(const QString &filter)
  {
    emit QFileDialog::filterSelected(filter);
  }

  //  [emitter impl] void QFileDialog::finished(int result)
  void emitter_QFileDialog_finished_767(int result)
  {
    emit QFileDialog::finished(result);
  }

  //  [adaptor impl] void QFileDialog::focusInEvent(QFocusEvent *)
  void cbs_focusInEvent_1729_0(QFocusEvent *arg1)
  {
    QFileDialog::focusInEvent(arg1);
  }

  virtual void focusInEvent(QFocusEvent *arg1)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QFileDialog_Adaptor, QFocusEvent *>(&QFileDialog_Adaptor::cbs_focusInEvent_1729_0, arg1);
    } else {
      QFileDialog::focusInEvent(arg1);
    }
  }

  //  [adaptor impl] bool QFileDialog::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QFileDialog::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QFileDialog_Adaptor, bool, bool>(&QFileDialog_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QFileDialog::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QFileDialog::focusOutEvent(QFocusEvent *)
  void cbs_focusOutEvent_1729_0(QFocusEvent *arg1)
  {
    QFileDialog::focusOutEvent(arg1);
  }

  virtual void focusOutEvent(QFocusEvent *arg1)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QFileDialog_Adaptor, QFocusEvent *>(&QFileDialog_Adaptor::cbs_focusOutEvent_1729_0, arg1);
    } else {
      QFileDialog::focusOutEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::fontChange(const QFont &)
  void cbs_fontChange_1801_0(const QFont &arg1)
  {
    QFileDialog::fontChange(arg1);
  }

  virtual void fontChange(const QFont &arg1)
  {
    if (cb_fontChange_1801_0.can_issue()) {
      cb_fontChange_1801_0.issue<QFileDialog_Adaptor, const QFont &>(&QFileDialog_Adaptor::cbs_fontChange_1801_0, arg1);
    } else {
      QFileDialog::fontChange(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::hideEvent(QHideEvent *)
  void cbs_hideEvent_1595_0(QHideEvent *arg1)
  {
    QFileDialog::hideEvent(arg1);
  }

  virtual void hideEvent(QHideEvent *arg1)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QFileDialog_Adaptor, QHideEvent *>(&QFileDialog_Adaptor::cbs_hideEvent_1595_0, arg1);
    } else {
      QFileDialog::hideEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QFileDialog::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QFileDialog_Adaptor, QInputMethodEvent *>(&QFileDialog_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QFileDialog::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::keyPressEvent(QKeyEvent *)
  void cbs_keyPressEvent_1514_0(QKeyEvent *arg1)
  {
    QFileDialog::keyPressEvent(arg1);
  }

  virtual void keyPressEvent(QKeyEvent *arg1)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QFileDialog_Adaptor, QKeyEvent *>(&QFileDialog_Adaptor::cbs_keyPressEvent_1514_0, arg1);
    } else {
      QFileDialog::keyPressEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::keyReleaseEvent(QKeyEvent *)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *arg1)
  {
    QFileDialog::keyReleaseEvent(arg1);
  }

  virtual void keyReleaseEvent(QKeyEvent *arg1)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QFileDialog_Adaptor, QKeyEvent *>(&QFileDialog_Adaptor::cbs_keyReleaseEvent_1514_0, arg1);
    } else {
      QFileDialog::keyReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::languageChange()
  void cbs_languageChange_0_0()
  {
    QFileDialog::languageChange();
  }

  virtual void languageChange()
  {
    if (cb_languageChange_0_0.can_issue()) {
      cb_languageChange_0_0.issue<QFileDialog_Adaptor>(&QFileDialog_Adaptor::cbs_languageChange_0_0);
    } else {
      QFileDialog::languageChange();
    }
  }

  //  [adaptor impl] void QFileDialog::leaveEvent(QEvent *)
  void cbs_leaveEvent_1217_0(QEvent *arg1)
  {
    QFileDialog::leaveEvent(arg1);
  }

  virtual void leaveEvent(QEvent *arg1)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QFileDialog_Adaptor, QEvent *>(&QFileDialog_Adaptor::cbs_leaveEvent_1217_0, arg1);
    } else {
      QFileDialog::leaveEvent(arg1);
    }
  }

  //  [adaptor impl] int QFileDialog::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QFileDialog::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QFileDialog_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QFileDialog_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QFileDialog::metric(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::mouseDoubleClickEvent(QMouseEvent *)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *arg1)
  {
    QFileDialog::mouseDoubleClickEvent(arg1);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *arg1)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QFileDialog_Adaptor, QMouseEvent *>(&QFileDialog_Adaptor::cbs_mouseDoubleClickEvent_1738_0, arg1);
    } else {
      QFileDialog::mouseDoubleClickEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::mouseMoveEvent(QMouseEvent *)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *arg1)
  {
    QFileDialog::mouseMoveEvent(arg1);
  }

  virtual void mouseMoveEvent(QMouseEvent *arg1)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QFileDialog_Adaptor, QMouseEvent *>(&QFileDialog_Adaptor::cbs_mouseMoveEvent_1738_0, arg1);
    } else {
      QFileDialog::mouseMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::mousePressEvent(QMouseEvent *)
  void cbs_mousePressEvent_1738_0(QMouseEvent *arg1)
  {
    QFileDialog::mousePressEvent(arg1);
  }

  virtual void mousePressEvent(QMouseEvent *arg1)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QFileDialog_Adaptor, QMouseEvent *>(&QFileDialog_Adaptor::cbs_mousePressEvent_1738_0, arg1);
    } else {
      QFileDialog::mousePressEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::mouseReleaseEvent(QMouseEvent *)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *arg1)
  {
    QFileDialog::mouseReleaseEvent(arg1);
  }

  virtual void mouseReleaseEvent(QMouseEvent *arg1)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QFileDialog_Adaptor, QMouseEvent *>(&QFileDialog_Adaptor::cbs_mouseReleaseEvent_1738_0, arg1);
    } else {
      QFileDialog::mouseReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::moveEvent(QMoveEvent *)
  void cbs_moveEvent_1624_0(QMoveEvent *arg1)
  {
    QFileDialog::moveEvent(arg1);
  }

  virtual void moveEvent(QMoveEvent *arg1)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QFileDialog_Adaptor, QMoveEvent *>(&QFileDialog_Adaptor::cbs_moveEvent_1624_0, arg1);
    } else {
      QFileDialog::moveEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::paintEvent(QPaintEvent *)
  void cbs_paintEvent_1725_0(QPaintEvent *arg1)
  {
    QFileDialog::paintEvent(arg1);
  }

  virtual void paintEvent(QPaintEvent *arg1)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QFileDialog_Adaptor, QPaintEvent *>(&QFileDialog_Adaptor::cbs_paintEvent_1725_0, arg1);
    } else {
      QFileDialog::paintEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::paletteChange(const QPalette &)
  void cbs_paletteChange_2113_0(const QPalette &arg1)
  {
    QFileDialog::paletteChange(arg1);
  }

  virtual void paletteChange(const QPalette &arg1)
  {
    if (cb_paletteChange_2113_0.can_issue()) {
      cb_paletteChange_2113_0.issue<QFileDialog_Adaptor, const QPalette &>(&QFileDialog_Adaptor::cbs_paletteChange_2113_0, arg1);
    } else {
      QFileDialog::paletteChange(arg1);
    }
  }

  //  [emitter impl] void QFileDialog::rejected()
  void emitter_QFileDialog_rejected_0()
  {
    emit QFileDialog::rejected();
  }

  //  [adaptor impl] void QFileDialog::resizeEvent(QResizeEvent *)
  void cbs_resizeEvent_1843_0(QResizeEvent *arg1)
  {
    QFileDialog::resizeEvent(arg1);
  }

  virtual void resizeEvent(QResizeEvent *arg1)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QFileDialog_Adaptor, QResizeEvent *>(&QFileDialog_Adaptor::cbs_resizeEvent_1843_0, arg1);
    } else {
      QFileDialog::resizeEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::showEvent(QShowEvent *)
  void cbs_showEvent_1634_0(QShowEvent *arg1)
  {
    QFileDialog::showEvent(arg1);
  }

  virtual void showEvent(QShowEvent *arg1)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QFileDialog_Adaptor, QShowEvent *>(&QFileDialog_Adaptor::cbs_showEvent_1634_0, arg1);
    } else {
      QFileDialog::showEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::styleChange(QStyle &)
  void cbs_styleChange_1228_0(QStyle &arg1)
  {
    QFileDialog::styleChange(arg1);
  }

  virtual void styleChange(QStyle &arg1)
  {
    if (cb_styleChange_1228_0.can_issue()) {
      cb_styleChange_1228_0.issue<QFileDialog_Adaptor, QStyle &>(&QFileDialog_Adaptor::cbs_styleChange_1228_0, arg1);
    } else {
      QFileDialog::styleChange(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QFileDialog::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QFileDialog_Adaptor, QTabletEvent *>(&QFileDialog_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QFileDialog::tabletEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QFileDialog::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QFileDialog_Adaptor, QTimerEvent *>(&QFileDialog_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QFileDialog::timerEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::wheelEvent(QWheelEvent *)
  void cbs_wheelEvent_1718_0(QWheelEvent *arg1)
  {
    QFileDialog::wheelEvent(arg1);
  }

  virtual void wheelEvent(QWheelEvent *arg1)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QFileDialog_Adaptor, QWheelEvent *>(&QFileDialog_Adaptor::cbs_wheelEvent_1718_0, arg1);
    } else {
      QFileDialog::wheelEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::windowActivationChange(bool)
  void cbs_windowActivationChange_864_0(bool arg1)
  {
    QFileDialog::windowActivationChange(arg1);
  }

  virtual void windowActivationChange(bool arg1)
  {
    if (cb_windowActivationChange_864_0.can_issue()) {
      cb_windowActivationChange_864_0.issue<QFileDialog_Adaptor, bool>(&QFileDialog_Adaptor::cbs_windowActivationChange_864_0, arg1);
    } else {
      QFileDialog::windowActivationChange(arg1);
    }
  }

  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_reject_0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_accept_0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_done_767_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enabledChange_864_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_fontChange_1801_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_languageChange_0_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_paletteChange_2113_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_styleChange_1228_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_wheelEvent_1718_0;
  gsi::Callback cb_windowActivationChange_864_0;
};

QFileDialog_Adaptor::~QFileDialog_Adaptor() { }

//  Constructor QFileDialog::QFileDialog(QWidget *parent, QFlags<Qt::WindowType> f) (adaptor class)

static void _init_ctor_QFileDialog_Adaptor_3702 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("f");
  decl->add_arg<QFlags<Qt::WindowType> > (argspec_1);
  decl->set_return_new<QFileDialog_Adaptor> ();
}

static void _call_ctor_QFileDialog_Adaptor_3702 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  QFlags<Qt::WindowType> arg2 = gsi::arg_reader<QFlags<Qt::WindowType> >() (args, heap);
  ret.write<QFileDialog_Adaptor *> (new QFileDialog_Adaptor (arg1, arg2));
}


//  Constructor QFileDialog::QFileDialog(QWidget *parent, const QString &caption, const QString &directory, const QString &filter) (adaptor class)

static void _init_ctor_QFileDialog_Adaptor_7066 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("caption", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("directory", true, "QString()");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("filter", true, "QString()");
  decl->add_arg<const QString & > (argspec_3);
  decl->set_return_new<QFileDialog_Adaptor> ();
}

static void _call_ctor_QFileDialog_Adaptor_7066 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (0, heap);
  const QString &arg2 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  const QString &arg3 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  const QString &arg4 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  ret.write<QFileDialog_Adaptor *> (new QFileDialog_Adaptor (arg1, arg2, arg3, arg4));
}


// void QFileDialog::accept()

static void _init_cbs_accept_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_accept_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_accept_0_0 ();
}

static void _set_callback_cbs_accept_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_accept_0_0 = cb;
}


// emitter void QFileDialog::accepted()

static void _init_emitter_accepted_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_accepted_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QFileDialog_Adaptor *)cls)->emitter_QFileDialog_accepted_0 ();
}


// void QFileDialog::actionEvent(QActionEvent *)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QActionEvent *arg1 = args.read<QActionEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}


// exposed void QFileDialog::adjustPosition(QWidget *)

static void _init_fp_adjustPosition_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_adjustPosition_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->fp_QFileDialog_adjustPosition_1315 (arg1);
}


// void QFileDialog::changeEvent(QEvent *e)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}


// void QFileDialog::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QFileDialog::closeEvent(QCloseEvent *)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCloseEvent *arg1 = args.read<QCloseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}


// void QFileDialog::contextMenuEvent(QContextMenuEvent *)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}


// exposed void QFileDialog::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<WId>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<WId>::target_type & >() (qt_gsi::CppToQtReadAdaptor<WId>(heap, 0), heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg3 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->fp_QFileDialog_create_2208 (arg1, arg2, arg3);
}


// emitter void QFileDialog::currentChanged(const QString &path)

static void _init_emitter_currentChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_currentChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QFileDialog_Adaptor *)cls)->emitter_QFileDialog_currentChanged_2025 (arg1);
}


// emitter void QFileDialog::customContextMenuRequested(const QPoint &pos)

static void _init_emitter_customContextMenuRequested_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_customContextMenuRequested_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ((QFileDialog_Adaptor *)cls)->emitter_QFileDialog_customContextMenuRequested_1916 (arg1);
}


// void QFileDialog::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// exposed void QFileDialog::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->fp_QFileDialog_destroy_1620 (arg1, arg2);
}


// emitter void QFileDialog::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QFileDialog_Adaptor *)cls)->emitter_QFileDialog_destroyed_1302 (arg1);
}


// emitter void QFileDialog::directoryEntered(const QString &directory)

static void _init_emitter_directoryEntered_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("directory");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_directoryEntered_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QFileDialog_Adaptor *)cls)->emitter_QFileDialog_directoryEntered_2025 (arg1);
}


// void QFileDialog::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}


// void QFileDialog::done(int result)

static void _init_cbs_done_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("result");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_done_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_done_767_0 (arg1);
}

static void _set_callback_cbs_done_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_done_767_0 = cb;
}


// void QFileDialog::dragEnterEvent(QDragEnterEvent *)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}


// void QFileDialog::dragLeaveEvent(QDragLeaveEvent *)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}


// void QFileDialog::dragMoveEvent(QDragMoveEvent *)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}


// void QFileDialog::dropEvent(QDropEvent *)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDropEvent *arg1 = args.read<QDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}


// void QFileDialog::enabledChange(bool)

static void _init_cbs_enabledChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enabledChange_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_enabledChange_864_0 (arg1);
}

static void _set_callback_cbs_enabledChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_enabledChange_864_0 = cb;
}


// void QFileDialog::enterEvent(QEvent *)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}


// bool QFileDialog::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QFileDialog_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QFileDialog::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QFileDialog_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// emitter void QFileDialog::fileSelected(const QString &file)

static void _init_emitter_fileSelected_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("file");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_fileSelected_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QFileDialog_Adaptor *)cls)->emitter_QFileDialog_fileSelected_2025 (arg1);
}


// emitter void QFileDialog::filesSelected(const QStringList &files)

static void _init_emitter_filesSelected_2437 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("files");
  decl->add_arg<const QStringList & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_filesSelected_2437 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStringList &arg1 = gsi::arg_reader<const QStringList & >() (args, heap);
  ((QFileDialog_Adaptor *)cls)->emitter_QFileDialog_filesSelected_2437 (arg1);
}


// emitter void QFileDialog::filterSelected(const QString &filter)

static void _init_emitter_filterSelected_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filter");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_filterSelected_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QFileDialog_Adaptor *)cls)->emitter_QFileDialog_filterSelected_2025 (arg1);
}


// emitter void QFileDialog::finished(int result)

static void _init_emitter_finished_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("result");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_finished_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QFileDialog_Adaptor *)cls)->emitter_QFileDialog_finished_767 (arg1);
}


// void QFileDialog::focusInEvent(QFocusEvent *)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// exposed bool QFileDialog::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QFileDialog_Adaptor *)cls)->fp_QFileDialog_focusNextChild_0 ());
}


// bool QFileDialog::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ret.write<bool > ((bool)((QFileDialog_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}


// void QFileDialog::focusOutEvent(QFocusEvent *)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// exposed bool QFileDialog::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QFileDialog_Adaptor *)cls)->fp_QFileDialog_focusPreviousChild_0 ());
}


// void QFileDialog::fontChange(const QFont &)

static void _init_cbs_fontChange_1801_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fontChange_1801_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFont &arg1 = args.read<const QFont & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_fontChange_1801_0 (arg1);
}

static void _set_callback_cbs_fontChange_1801_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_fontChange_1801_0 = cb;
}


// int QFileDialog::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QFileDialog_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}


// void QFileDialog::hideEvent(QHideEvent *)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHideEvent *arg1 = args.read<QHideEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}


// void QFileDialog::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}


// QVariant QFileDialog::inputMethodQuery(Qt::InputMethodQuery)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QFileDialog_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}


// void QFileDialog::keyPressEvent(QKeyEvent *)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QFileDialog::keyReleaseEvent(QKeyEvent *)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// void QFileDialog::languageChange()

static void _init_cbs_languageChange_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_languageChange_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_languageChange_0_0 ();
}

static void _set_callback_cbs_languageChange_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_languageChange_0_0 = cb;
}


// void QFileDialog::leaveEvent(QEvent *)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}


// int QFileDialog::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QFileDialog_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// QSize QFileDialog::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QFileDialog_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}


// void QFileDialog::mouseDoubleClickEvent(QMouseEvent *)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}


// void QFileDialog::mouseMoveEvent(QMouseEvent *)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}


// void QFileDialog::mousePressEvent(QMouseEvent *)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}


// void QFileDialog::mouseReleaseEvent(QMouseEvent *)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}


// void QFileDialog::moveEvent(QMoveEvent *)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMoveEvent *arg1 = args.read<QMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}


// QPaintEngine *QFileDialog::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QFileDialog_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}


// void QFileDialog::paintEvent(QPaintEvent *)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintEvent *arg1 = args.read<QPaintEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}


// void QFileDialog::paletteChange(const QPalette &)

static void _init_cbs_paletteChange_2113_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paletteChange_2113_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPalette &arg1 = args.read<const QPalette & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_paletteChange_2113_0 (arg1);
}

static void _set_callback_cbs_paletteChange_2113_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_paletteChange_2113_0 = cb;
}


// exposed int QFileDialog::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QFileDialog_Adaptor *)cls)->fp_QFileDialog_receivers_c1731 (arg1));
}


// void QFileDialog::reject()

static void _init_cbs_reject_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_reject_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_reject_0_0 ();
}

static void _set_callback_cbs_reject_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_reject_0_0 = cb;
}


// emitter void QFileDialog::rejected()

static void _init_emitter_rejected_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_rejected_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QFileDialog_Adaptor *)cls)->emitter_QFileDialog_rejected_0 ();
}


// exposed void QFileDialog::resetInputContext()

static void _init_fp_resetInputContext_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_resetInputContext_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->fp_QFileDialog_resetInputContext_0 ();
}


// void QFileDialog::resizeEvent(QResizeEvent *)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QResizeEvent *arg1 = args.read<QResizeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}


// exposed QObject *QFileDialog::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QFileDialog_Adaptor *)cls)->fp_QFileDialog_sender_c0 ());
}


// void QFileDialog::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}


// void QFileDialog::showEvent(QShowEvent *)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QShowEvent *arg1 = args.read<QShowEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}


// QSize QFileDialog::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QFileDialog_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}


// void QFileDialog::styleChange(QStyle &)

static void _init_cbs_styleChange_1228_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QStyle & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_styleChange_1228_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStyle &arg1 = args.read<QStyle & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_styleChange_1228_0 (arg1);
}

static void _set_callback_cbs_styleChange_1228_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_styleChange_1228_0 = cb;
}


// void QFileDialog::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTabletEvent *arg1 = args.read<QTabletEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}


// void QFileDialog::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// exposed void QFileDialog::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->fp_QFileDialog_updateMicroFocus_0 ();
}


// void QFileDialog::wheelEvent(QWheelEvent *)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWheelEvent *arg1 = args.read<QWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}


// void QFileDialog::windowActivationChange(bool)

static void _init_cbs_windowActivationChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_windowActivationChange_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_windowActivationChange_864_0 (arg1);
}

static void _set_callback_cbs_windowActivationChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_windowActivationChange_864_0 = cb;
}


namespace gsi
{

gsi::Class<QFileDialog> &qtdecl_QFileDialog ();

static gsi::Methods methods_QFileDialog_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QFileDialog::QFileDialog(QWidget *parent, QFlags<Qt::WindowType> f)\nThis method creates an object of class QFileDialog.", &_init_ctor_QFileDialog_Adaptor_3702, &_call_ctor_QFileDialog_Adaptor_3702);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QFileDialog::QFileDialog(QWidget *parent, const QString &caption, const QString &directory, const QString &filter)\nThis method creates an object of class QFileDialog.", &_init_ctor_QFileDialog_Adaptor_7066, &_call_ctor_QFileDialog_Adaptor_7066);
  methods += new qt_gsi::GenericMethod ("*accept", "@brief Virtual method void QFileDialog::accept()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_accept_0_0, &_call_cbs_accept_0_0);
  methods += new qt_gsi::GenericMethod ("*accept", "@hide", false, &_init_cbs_accept_0_0, &_call_cbs_accept_0_0, &_set_callback_cbs_accept_0_0);
  methods += new qt_gsi::GenericMethod ("emit_accepted", "@brief Emitter for signal void QFileDialog::accepted()\nCall this method to emit this signal.", false, &_init_emitter_accepted_0, &_call_emitter_accepted_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QFileDialog::actionEvent(QActionEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*adjustPosition", "@brief Method void QFileDialog::adjustPosition(QWidget *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_adjustPosition_1315, &_call_fp_adjustPosition_1315);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QFileDialog::changeEvent(QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QFileDialog::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QFileDialog::closeEvent(QCloseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QFileDialog::contextMenuEvent(QContextMenuEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*qt_create", "@brief Method void QFileDialog::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
  methods += new qt_gsi::GenericMethod ("emit_currentChanged", "@brief Emitter for signal void QFileDialog::currentChanged(const QString &path)\nCall this method to emit this signal.", false, &_init_emitter_currentChanged_2025, &_call_emitter_currentChanged_2025);
  methods += new qt_gsi::GenericMethod ("emit_customContextMenuRequested", "@brief Emitter for signal void QFileDialog::customContextMenuRequested(const QPoint &pos)\nCall this method to emit this signal.", false, &_init_emitter_customContextMenuRequested_1916, &_call_emitter_customContextMenuRequested_1916);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QFileDialog::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*qt_destroy", "@brief Method void QFileDialog::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QFileDialog::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("emit_directoryEntered", "@brief Emitter for signal void QFileDialog::directoryEntered(const QString &directory)\nCall this method to emit this signal.", false, &_init_emitter_directoryEntered_2025, &_call_emitter_directoryEntered_2025);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QFileDialog::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*done", "@brief Virtual method void QFileDialog::done(int result)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_done_767_0, &_call_cbs_done_767_0);
  methods += new qt_gsi::GenericMethod ("*done", "@hide", false, &_init_cbs_done_767_0, &_call_cbs_done_767_0, &_set_callback_cbs_done_767_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QFileDialog::dragEnterEvent(QDragEnterEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QFileDialog::dragLeaveEvent(QDragLeaveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QFileDialog::dragMoveEvent(QDragMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QFileDialog::dropEvent(QDropEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*enabledChange", "@brief Virtual method void QFileDialog::enabledChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0);
  methods += new qt_gsi::GenericMethod ("*enabledChange", "@hide", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0, &_set_callback_cbs_enabledChange_864_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QFileDialog::enterEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QFileDialog::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@brief Virtual method bool QFileDialog::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("emit_fileSelected", "@brief Emitter for signal void QFileDialog::fileSelected(const QString &file)\nCall this method to emit this signal.", false, &_init_emitter_fileSelected_2025, &_call_emitter_fileSelected_2025);
  methods += new qt_gsi::GenericMethod ("emit_filesSelected", "@brief Emitter for signal void QFileDialog::filesSelected(const QStringList &files)\nCall this method to emit this signal.", false, &_init_emitter_filesSelected_2437, &_call_emitter_filesSelected_2437);
  methods += new qt_gsi::GenericMethod ("emit_filterSelected", "@brief Emitter for signal void QFileDialog::filterSelected(const QString &filter)\nCall this method to emit this signal.", false, &_init_emitter_filterSelected_2025, &_call_emitter_filterSelected_2025);
  methods += new qt_gsi::GenericMethod ("emit_finished", "@brief Emitter for signal void QFileDialog::finished(int result)\nCall this method to emit this signal.", false, &_init_emitter_finished_767, &_call_emitter_finished_767);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QFileDialog::focusInEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusNextChild", "@brief Method bool QFileDialog::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QFileDialog::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QFileDialog::focusOutEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusPreviousChild", "@brief Method bool QFileDialog::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
  methods += new qt_gsi::GenericMethod ("*fontChange", "@brief Virtual method void QFileDialog::fontChange(const QFont &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0);
  methods += new qt_gsi::GenericMethod ("*fontChange", "@hide", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0, &_set_callback_cbs_fontChange_1801_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QFileDialog::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QFileDialog::hideEvent(QHideEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QFileDialog::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QFileDialog::inputMethodQuery(Qt::InputMethodQuery)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QFileDialog::keyPressEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QFileDialog::keyReleaseEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*languageChange", "@brief Virtual method void QFileDialog::languageChange()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0);
  methods += new qt_gsi::GenericMethod ("*languageChange", "@hide", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0, &_set_callback_cbs_languageChange_0_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QFileDialog::leaveEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QFileDialog::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QFileDialog::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QFileDialog::mouseDoubleClickEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QFileDialog::mouseMoveEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QFileDialog::mousePressEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QFileDialog::mouseReleaseEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QFileDialog::moveEvent(QMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QFileDialog::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QFileDialog::paintEvent(QPaintEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paletteChange", "@brief Virtual method void QFileDialog::paletteChange(const QPalette &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0);
  methods += new qt_gsi::GenericMethod ("*paletteChange", "@hide", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0, &_set_callback_cbs_paletteChange_2113_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QFileDialog::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("reject", "@brief Virtual method void QFileDialog::reject()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_reject_0_0, &_call_cbs_reject_0_0);
  methods += new qt_gsi::GenericMethod ("reject", "@hide", false, &_init_cbs_reject_0_0, &_call_cbs_reject_0_0, &_set_callback_cbs_reject_0_0);
  methods += new qt_gsi::GenericMethod ("emit_rejected", "@brief Emitter for signal void QFileDialog::rejected()\nCall this method to emit this signal.", false, &_init_emitter_rejected_0, &_call_emitter_rejected_0);
  methods += new qt_gsi::GenericMethod ("*resetInputContext", "@brief Method void QFileDialog::resetInputContext()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resetInputContext_0, &_call_fp_resetInputContext_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QFileDialog::resizeEvent(QResizeEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QFileDialog::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QFileDialog::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QFileDialog::showEvent(QShowEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QFileDialog::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*styleChange", "@brief Virtual method void QFileDialog::styleChange(QStyle &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0);
  methods += new qt_gsi::GenericMethod ("*styleChange", "@hide", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0, &_set_callback_cbs_styleChange_1228_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QFileDialog::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QFileDialog::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateMicroFocus", "@brief Method void QFileDialog::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QFileDialog::wheelEvent(QWheelEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*windowActivationChange", "@brief Virtual method void QFileDialog::windowActivationChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0);
  methods += new qt_gsi::GenericMethod ("*windowActivationChange", "@hide", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0, &_set_callback_cbs_windowActivationChange_864_0);
  return methods;
}

gsi::Class<QFileDialog_Adaptor> decl_QFileDialog_Adaptor (qtdecl_QFileDialog (), "QtGui", "QFileDialog",
  methods_QFileDialog_Adaptor (),
  "@qt\n@brief Binding of QFileDialog");

}


//  Implementation of the enum wrapper class for QFileDialog::AcceptMode
namespace qt_gsi
{

static gsi::Enum<QFileDialog::AcceptMode> decl_QFileDialog_AcceptMode_Enum ("QtGui", "QFileDialog_AcceptMode",
    gsi::enum_const ("AcceptOpen", QFileDialog::AcceptOpen, "@brief Enum constant QFileDialog::AcceptOpen") +
    gsi::enum_const ("AcceptSave", QFileDialog::AcceptSave, "@brief Enum constant QFileDialog::AcceptSave"),
  "@qt\n@brief This class represents the QFileDialog::AcceptMode enum");

static gsi::QFlagsClass<QFileDialog::AcceptMode > decl_QFileDialog_AcceptMode_Enums ("QtGui", "QFileDialog_QFlags_AcceptMode",
  "@qt\n@brief This class represents the QFlags<QFileDialog::AcceptMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QFileDialog> inject_QFileDialog_AcceptMode_Enum_in_parent (decl_QFileDialog_AcceptMode_Enum.defs ());
static gsi::ClassExt<QFileDialog> decl_QFileDialog_AcceptMode_Enum_as_child (decl_QFileDialog_AcceptMode_Enum, "AcceptMode");
static gsi::ClassExt<QFileDialog> decl_QFileDialog_AcceptMode_Enums_as_child (decl_QFileDialog_AcceptMode_Enums, "QFlags_AcceptMode");

}


//  Implementation of the enum wrapper class for QFileDialog::DialogLabel
namespace qt_gsi
{

static gsi::Enum<QFileDialog::DialogLabel> decl_QFileDialog_DialogLabel_Enum ("QtGui", "QFileDialog_DialogLabel",
    gsi::enum_const ("LookIn", QFileDialog::LookIn, "@brief Enum constant QFileDialog::LookIn") +
    gsi::enum_const ("FileName", QFileDialog::FileName, "@brief Enum constant QFileDialog::FileName") +
    gsi::enum_const ("FileType", QFileDialog::FileType, "@brief Enum constant QFileDialog::FileType") +
    gsi::enum_const ("Accept", QFileDialog::Accept, "@brief Enum constant QFileDialog::Accept") +
    gsi::enum_const ("Reject", QFileDialog::Reject, "@brief Enum constant QFileDialog::Reject"),
  "@qt\n@brief This class represents the QFileDialog::DialogLabel enum");

static gsi::QFlagsClass<QFileDialog::DialogLabel > decl_QFileDialog_DialogLabel_Enums ("QtGui", "QFileDialog_QFlags_DialogLabel",
  "@qt\n@brief This class represents the QFlags<QFileDialog::DialogLabel> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QFileDialog> inject_QFileDialog_DialogLabel_Enum_in_parent (decl_QFileDialog_DialogLabel_Enum.defs ());
static gsi::ClassExt<QFileDialog> decl_QFileDialog_DialogLabel_Enum_as_child (decl_QFileDialog_DialogLabel_Enum, "DialogLabel");
static gsi::ClassExt<QFileDialog> decl_QFileDialog_DialogLabel_Enums_as_child (decl_QFileDialog_DialogLabel_Enums, "QFlags_DialogLabel");

}


//  Implementation of the enum wrapper class for QFileDialog::FileMode
namespace qt_gsi
{

static gsi::Enum<QFileDialog::FileMode> decl_QFileDialog_FileMode_Enum ("QtGui", "QFileDialog_FileMode",
    gsi::enum_const ("AnyFile", QFileDialog::AnyFile, "@brief Enum constant QFileDialog::AnyFile") +
    gsi::enum_const ("ExistingFile", QFileDialog::ExistingFile, "@brief Enum constant QFileDialog::ExistingFile") +
    gsi::enum_const ("Directory", QFileDialog::Directory, "@brief Enum constant QFileDialog::Directory") +
    gsi::enum_const ("ExistingFiles", QFileDialog::ExistingFiles, "@brief Enum constant QFileDialog::ExistingFiles") +
    gsi::enum_const ("DirectoryOnly", QFileDialog::DirectoryOnly, "@brief Enum constant QFileDialog::DirectoryOnly"),
  "@qt\n@brief This class represents the QFileDialog::FileMode enum");

static gsi::QFlagsClass<QFileDialog::FileMode > decl_QFileDialog_FileMode_Enums ("QtGui", "QFileDialog_QFlags_FileMode",
  "@qt\n@brief This class represents the QFlags<QFileDialog::FileMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QFileDialog> inject_QFileDialog_FileMode_Enum_in_parent (decl_QFileDialog_FileMode_Enum.defs ());
static gsi::ClassExt<QFileDialog> decl_QFileDialog_FileMode_Enum_as_child (decl_QFileDialog_FileMode_Enum, "FileMode");
static gsi::ClassExt<QFileDialog> decl_QFileDialog_FileMode_Enums_as_child (decl_QFileDialog_FileMode_Enums, "QFlags_FileMode");

}


//  Implementation of the enum wrapper class for QFileDialog::Option
namespace qt_gsi
{

static gsi::Enum<QFileDialog::Option> decl_QFileDialog_Option_Enum ("QtGui", "QFileDialog_Option",
    gsi::enum_const ("ShowDirsOnly", QFileDialog::ShowDirsOnly, "@brief Enum constant QFileDialog::ShowDirsOnly") +
    gsi::enum_const ("DontResolveSymlinks", QFileDialog::DontResolveSymlinks, "@brief Enum constant QFileDialog::DontResolveSymlinks") +
    gsi::enum_const ("DontConfirmOverwrite", QFileDialog::DontConfirmOverwrite, "@brief Enum constant QFileDialog::DontConfirmOverwrite") +
    gsi::enum_const ("DontUseSheet", QFileDialog::DontUseSheet, "@brief Enum constant QFileDialog::DontUseSheet") +
    gsi::enum_const ("DontUseNativeDialog", QFileDialog::DontUseNativeDialog, "@brief Enum constant QFileDialog::DontUseNativeDialog") +
    gsi::enum_const ("ReadOnly", QFileDialog::ReadOnly, "@brief Enum constant QFileDialog::ReadOnly") +
    gsi::enum_const ("HideNameFilterDetails", QFileDialog::HideNameFilterDetails, "@brief Enum constant QFileDialog::HideNameFilterDetails"),
  "@qt\n@brief This class represents the QFileDialog::Option enum");

static gsi::QFlagsClass<QFileDialog::Option > decl_QFileDialog_Option_Enums ("QtGui", "QFileDialog_QFlags_Option",
  "@qt\n@brief This class represents the QFlags<QFileDialog::Option> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QFileDialog> inject_QFileDialog_Option_Enum_in_parent (decl_QFileDialog_Option_Enum.defs ());
static gsi::ClassExt<QFileDialog> decl_QFileDialog_Option_Enum_as_child (decl_QFileDialog_Option_Enum, "Option");
static gsi::ClassExt<QFileDialog> decl_QFileDialog_Option_Enums_as_child (decl_QFileDialog_Option_Enums, "QFlags_Option");

}


//  Implementation of the enum wrapper class for QFileDialog::ViewMode
namespace qt_gsi
{

static gsi::Enum<QFileDialog::ViewMode> decl_QFileDialog_ViewMode_Enum ("QtGui", "QFileDialog_ViewMode",
    gsi::enum_const ("Detail", QFileDialog::Detail, "@brief Enum constant QFileDialog::Detail") +
    gsi::enum_const ("List", QFileDialog::List, "@brief Enum constant QFileDialog::List"),
  "@qt\n@brief This class represents the QFileDialog::ViewMode enum");

static gsi::QFlagsClass<QFileDialog::ViewMode > decl_QFileDialog_ViewMode_Enums ("QtGui", "QFileDialog_QFlags_ViewMode",
  "@qt\n@brief This class represents the QFlags<QFileDialog::ViewMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QFileDialog> inject_QFileDialog_ViewMode_Enum_in_parent (decl_QFileDialog_ViewMode_Enum.defs ());
static gsi::ClassExt<QFileDialog> decl_QFileDialog_ViewMode_Enum_as_child (decl_QFileDialog_ViewMode_Enum, "ViewMode");
static gsi::ClassExt<QFileDialog> decl_QFileDialog_ViewMode_Enums_as_child (decl_QFileDialog_ViewMode_Enums, "QFlags_ViewMode");

}

