
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2021 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQPrinter.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QPrinter>
#include <QPaintEngine>
#include <QPrintEngine>
#include <QPrinterInfo>
#include <QRect>
#include <QRectF>
#include <QSizeF>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include "gsiDeclQtGuiTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QPrinter

// bool QPrinter::abort()


static void _init_f_abort_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_abort_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPrinter *)cls)->abort ());
}


// int QPrinter::actualNumCopies()


static void _init_f_actualNumCopies_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_actualNumCopies_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QPrinter *)cls)->actualNumCopies ());
}


// bool QPrinter::collateCopies()


static void _init_f_collateCopies_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_collateCopies_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPrinter *)cls)->collateCopies ());
}


// QPrinter::ColorMode QPrinter::colorMode()


static void _init_f_colorMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QPrinter::ColorMode>::target_type > ();
}

static void _call_f_colorMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QPrinter::ColorMode>::target_type > ((qt_gsi::Converter<QPrinter::ColorMode>::target_type)qt_gsi::CppToQtAdaptor<QPrinter::ColorMode>(((QPrinter *)cls)->colorMode ()));
}


// QString QPrinter::creator()


static void _init_f_creator_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_creator_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QPrinter *)cls)->creator ());
}


// QString QPrinter::docName()


static void _init_f_docName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_docName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QPrinter *)cls)->docName ());
}


// bool QPrinter::doubleSidedPrinting()


static void _init_f_doubleSidedPrinting_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_doubleSidedPrinting_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPrinter *)cls)->doubleSidedPrinting ());
}


// QPrinter::DuplexMode QPrinter::duplex()


static void _init_f_duplex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QPrinter::DuplexMode>::target_type > ();
}

static void _call_f_duplex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QPrinter::DuplexMode>::target_type > ((qt_gsi::Converter<QPrinter::DuplexMode>::target_type)qt_gsi::CppToQtAdaptor<QPrinter::DuplexMode>(((QPrinter *)cls)->duplex ()));
}


// bool QPrinter::fontEmbeddingEnabled()


static void _init_f_fontEmbeddingEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_fontEmbeddingEnabled_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPrinter *)cls)->fontEmbeddingEnabled ());
}


// int QPrinter::fromPage()


static void _init_f_fromPage_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_fromPage_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QPrinter *)cls)->fromPage ());
}


// bool QPrinter::fullPage()


static void _init_f_fullPage_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_fullPage_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPrinter *)cls)->fullPage ());
}


// void QPrinter::getPageMargins(double *left, double *top, double *right, double *bottom, QPrinter::Unit unit)


static void _init_f_getPageMargins_c6385 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<double * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<double * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<double * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<double * > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("unit");
  decl->add_arg<const qt_gsi::Converter<QPrinter::Unit>::target_type & > (argspec_4);
  decl->set_return<void > ();
}

static void _call_f_getPageMargins_c6385 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double *arg1 = gsi::arg_reader<double * >() (args, heap);
  double *arg2 = gsi::arg_reader<double * >() (args, heap);
  double *arg3 = gsi::arg_reader<double * >() (args, heap);
  double *arg4 = gsi::arg_reader<double * >() (args, heap);
  const qt_gsi::Converter<QPrinter::Unit>::target_type & arg5 = gsi::arg_reader<const qt_gsi::Converter<QPrinter::Unit>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrinter *)cls)->getPageMargins (arg1, arg2, arg3, arg4, qt_gsi::QtToCppAdaptor<QPrinter::Unit>(arg5).cref());
}


// bool QPrinter::isValid()


static void _init_f_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isValid_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPrinter *)cls)->isValid ());
}


// bool QPrinter::newPage()


static void _init_f_newPage_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_newPage_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPrinter *)cls)->newPage ());
}


// int QPrinter::numCopies()


static void _init_f_numCopies_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_numCopies_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QPrinter *)cls)->numCopies ());
}


// QPrinter::Orientation QPrinter::orientation()


static void _init_f_orientation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QPrinter::Orientation>::target_type > ();
}

static void _call_f_orientation_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QPrinter::Orientation>::target_type > ((qt_gsi::Converter<QPrinter::Orientation>::target_type)qt_gsi::CppToQtAdaptor<QPrinter::Orientation>(((QPrinter *)cls)->orientation ()));
}


// QString QPrinter::outputFileName()


static void _init_f_outputFileName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_outputFileName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QPrinter *)cls)->outputFileName ());
}


// QPrinter::OutputFormat QPrinter::outputFormat()


static void _init_f_outputFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QPrinter::OutputFormat>::target_type > ();
}

static void _call_f_outputFormat_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QPrinter::OutputFormat>::target_type > ((qt_gsi::Converter<QPrinter::OutputFormat>::target_type)qt_gsi::CppToQtAdaptor<QPrinter::OutputFormat>(((QPrinter *)cls)->outputFormat ()));
}


// QPrinter::PageOrder QPrinter::pageOrder()


static void _init_f_pageOrder_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QPrinter::PageOrder>::target_type > ();
}

static void _call_f_pageOrder_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QPrinter::PageOrder>::target_type > ((qt_gsi::Converter<QPrinter::PageOrder>::target_type)qt_gsi::CppToQtAdaptor<QPrinter::PageOrder>(((QPrinter *)cls)->pageOrder ()));
}


// QRect QPrinter::pageRect()


static void _init_f_pageRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_pageRect_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QPrinter *)cls)->pageRect ());
}


// QRectF QPrinter::pageRect(QPrinter::Unit)


static void _init_f_pageRect_c1789 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPrinter::Unit>::target_type & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_pageRect_c1789 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPrinter::Unit>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPrinter::Unit>::target_type & >() (args, heap);
  ret.write<QRectF > ((QRectF)((QPrinter *)cls)->pageRect (qt_gsi::QtToCppAdaptor<QPrinter::Unit>(arg1).cref()));
}


// QPrinter::PageSize QPrinter::pageSize()


static void _init_f_pageSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QPrinter::PageSize>::target_type > ();
}

static void _call_f_pageSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QPrinter::PageSize>::target_type > ((qt_gsi::Converter<QPrinter::PageSize>::target_type)qt_gsi::CppToQtAdaptor<QPrinter::PageSize>(((QPrinter *)cls)->pageSize ()));
}


// QPaintEngine *QPrinter::paintEngine()


static void _init_f_paintEngine_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_f_paintEngine_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QPrinter *)cls)->paintEngine ());
}


// QRect QPrinter::paperRect()


static void _init_f_paperRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_paperRect_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QPrinter *)cls)->paperRect ());
}


// QRectF QPrinter::paperRect(QPrinter::Unit)


static void _init_f_paperRect_c1789 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPrinter::Unit>::target_type & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_paperRect_c1789 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPrinter::Unit>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPrinter::Unit>::target_type & >() (args, heap);
  ret.write<QRectF > ((QRectF)((QPrinter *)cls)->paperRect (qt_gsi::QtToCppAdaptor<QPrinter::Unit>(arg1).cref()));
}


// QPrinter::PageSize QPrinter::paperSize()


static void _init_f_paperSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QPrinter::PageSize>::target_type > ();
}

static void _call_f_paperSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QPrinter::PageSize>::target_type > ((qt_gsi::Converter<QPrinter::PageSize>::target_type)qt_gsi::CppToQtAdaptor<QPrinter::PageSize>(((QPrinter *)cls)->paperSize ()));
}


// QSizeF QPrinter::paperSize(QPrinter::Unit unit)


static void _init_f_paperSize_c1789 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("unit");
  decl->add_arg<const qt_gsi::Converter<QPrinter::Unit>::target_type & > (argspec_0);
  decl->set_return<QSizeF > ();
}

static void _call_f_paperSize_c1789 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPrinter::Unit>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPrinter::Unit>::target_type & >() (args, heap);
  ret.write<QSizeF > ((QSizeF)((QPrinter *)cls)->paperSize (qt_gsi::QtToCppAdaptor<QPrinter::Unit>(arg1).cref()));
}


// QPrinter::PaperSource QPrinter::paperSource()


static void _init_f_paperSource_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QPrinter::PaperSource>::target_type > ();
}

static void _call_f_paperSource_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QPrinter::PaperSource>::target_type > ((qt_gsi::Converter<QPrinter::PaperSource>::target_type)qt_gsi::CppToQtAdaptor<QPrinter::PaperSource>(((QPrinter *)cls)->paperSource ()));
}


// QPrintEngine *QPrinter::printEngine()


static void _init_f_printEngine_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPrintEngine * > ();
}

static void _call_f_printEngine_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPrintEngine * > ((QPrintEngine *)((QPrinter *)cls)->printEngine ());
}


// QString QPrinter::printProgram()


static void _init_f_printProgram_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_printProgram_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QPrinter *)cls)->printProgram ());
}


// QPrinter::PrintRange QPrinter::printRange()


static void _init_f_printRange_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QPrinter::PrintRange>::target_type > ();
}

static void _call_f_printRange_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QPrinter::PrintRange>::target_type > ((qt_gsi::Converter<QPrinter::PrintRange>::target_type)qt_gsi::CppToQtAdaptor<QPrinter::PrintRange>(((QPrinter *)cls)->printRange ()));
}


// QString QPrinter::printerName()


static void _init_f_printerName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_printerName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QPrinter *)cls)->printerName ());
}


// QPrinter::PrinterState QPrinter::printerState()


static void _init_f_printerState_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QPrinter::PrinterState>::target_type > ();
}

static void _call_f_printerState_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QPrinter::PrinterState>::target_type > ((qt_gsi::Converter<QPrinter::PrinterState>::target_type)qt_gsi::CppToQtAdaptor<QPrinter::PrinterState>(((QPrinter *)cls)->printerState ()));
}


// int QPrinter::resolution()


static void _init_f_resolution_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_resolution_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QPrinter *)cls)->resolution ());
}


// void QPrinter::setCollateCopies(bool collate)


static void _init_f_setCollateCopies_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("collate");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCollateCopies_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrinter *)cls)->setCollateCopies (arg1);
}


// void QPrinter::setColorMode(QPrinter::ColorMode)


static void _init_f_setColorMode_2273 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPrinter::ColorMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setColorMode_2273 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPrinter::ColorMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPrinter::ColorMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrinter *)cls)->setColorMode (qt_gsi::QtToCppAdaptor<QPrinter::ColorMode>(arg1).cref());
}


// void QPrinter::setCreator(const QString &)


static void _init_f_setCreator_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCreator_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrinter *)cls)->setCreator (arg1);
}


// void QPrinter::setDocName(const QString &)


static void _init_f_setDocName_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDocName_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrinter *)cls)->setDocName (arg1);
}


// void QPrinter::setDoubleSidedPrinting(bool enable)


static void _init_f_setDoubleSidedPrinting_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDoubleSidedPrinting_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrinter *)cls)->setDoubleSidedPrinting (arg1);
}


// void QPrinter::setDuplex(QPrinter::DuplexMode duplex)


static void _init_f_setDuplex_2388 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("duplex");
  decl->add_arg<const qt_gsi::Converter<QPrinter::DuplexMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDuplex_2388 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPrinter::DuplexMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPrinter::DuplexMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrinter *)cls)->setDuplex (qt_gsi::QtToCppAdaptor<QPrinter::DuplexMode>(arg1).cref());
}


// void QPrinter::setFontEmbeddingEnabled(bool enable)


static void _init_f_setFontEmbeddingEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFontEmbeddingEnabled_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrinter *)cls)->setFontEmbeddingEnabled (arg1);
}


// void QPrinter::setFromTo(int fromPage, int toPage)


static void _init_f_setFromTo_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fromPage");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("toPage");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setFromTo_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrinter *)cls)->setFromTo (arg1, arg2);
}


// void QPrinter::setFullPage(bool)


static void _init_f_setFullPage_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFullPage_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrinter *)cls)->setFullPage (arg1);
}


// void QPrinter::setNumCopies(int)


static void _init_f_setNumCopies_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNumCopies_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrinter *)cls)->setNumCopies (arg1);
}


// void QPrinter::setOrientation(QPrinter::Orientation)


static void _init_f_setOrientation_2537 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPrinter::Orientation>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOrientation_2537 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPrinter::Orientation>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPrinter::Orientation>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrinter *)cls)->setOrientation (qt_gsi::QtToCppAdaptor<QPrinter::Orientation>(arg1).cref());
}


// void QPrinter::setOutputFileName(const QString &)


static void _init_f_setOutputFileName_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOutputFileName_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrinter *)cls)->setOutputFileName (arg1);
}


// void QPrinter::setOutputFormat(QPrinter::OutputFormat format)


static void _init_f_setOutputFormat_2647 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const qt_gsi::Converter<QPrinter::OutputFormat>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOutputFormat_2647 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPrinter::OutputFormat>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPrinter::OutputFormat>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrinter *)cls)->setOutputFormat (qt_gsi::QtToCppAdaptor<QPrinter::OutputFormat>(arg1).cref());
}


// void QPrinter::setPageMargins(double left, double top, double right, double bottom, QPrinter::Unit unit)


static void _init_f_setPageMargins_5641 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("unit");
  decl->add_arg<const qt_gsi::Converter<QPrinter::Unit>::target_type & > (argspec_4);
  decl->set_return<void > ();
}

static void _call_f_setPageMargins_5641 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  const qt_gsi::Converter<QPrinter::Unit>::target_type & arg5 = gsi::arg_reader<const qt_gsi::Converter<QPrinter::Unit>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrinter *)cls)->setPageMargins (arg1, arg2, arg3, arg4, qt_gsi::QtToCppAdaptor<QPrinter::Unit>(arg5).cref());
}


// void QPrinter::setPageOrder(QPrinter::PageOrder)


static void _init_f_setPageOrder_2262 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPrinter::PageOrder>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPageOrder_2262 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPrinter::PageOrder>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPrinter::PageOrder>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrinter *)cls)->setPageOrder (qt_gsi::QtToCppAdaptor<QPrinter::PageOrder>(arg1).cref());
}


// void QPrinter::setPageSize(QPrinter::PageSize)


static void _init_f_setPageSize_2165 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPrinter::PageSize>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPageSize_2165 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPrinter::PageSize>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPrinter::PageSize>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrinter *)cls)->setPageSize (qt_gsi::QtToCppAdaptor<QPrinter::PageSize>(arg1).cref());
}


// void QPrinter::setPaperSize(QPrinter::PageSize)


static void _init_f_setPaperSize_2165 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPrinter::PageSize>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPaperSize_2165 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPrinter::PageSize>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPrinter::PageSize>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrinter *)cls)->setPaperSize (qt_gsi::QtToCppAdaptor<QPrinter::PageSize>(arg1).cref());
}


// void QPrinter::setPaperSize(const QSizeF &paperSize, QPrinter::Unit unit)


static void _init_f_setPaperSize_3556 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("paperSize");
  decl->add_arg<const QSizeF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("unit");
  decl->add_arg<const qt_gsi::Converter<QPrinter::Unit>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setPaperSize_3556 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSizeF &arg1 = gsi::arg_reader<const QSizeF & >() (args, heap);
  const qt_gsi::Converter<QPrinter::Unit>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QPrinter::Unit>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrinter *)cls)->setPaperSize (arg1, qt_gsi::QtToCppAdaptor<QPrinter::Unit>(arg2).cref());
}


// void QPrinter::setPaperSource(QPrinter::PaperSource)


static void _init_f_setPaperSource_2502 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPrinter::PaperSource>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPaperSource_2502 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPrinter::PaperSource>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPrinter::PaperSource>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrinter *)cls)->setPaperSource (qt_gsi::QtToCppAdaptor<QPrinter::PaperSource>(arg1).cref());
}


// void QPrinter::setPrintProgram(const QString &)


static void _init_f_setPrintProgram_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPrintProgram_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrinter *)cls)->setPrintProgram (arg1);
}


// void QPrinter::setPrintRange(QPrinter::PrintRange range)


static void _init_f_setPrintRange_2391 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("range");
  decl->add_arg<const qt_gsi::Converter<QPrinter::PrintRange>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPrintRange_2391 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPrinter::PrintRange>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPrinter::PrintRange>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrinter *)cls)->setPrintRange (qt_gsi::QtToCppAdaptor<QPrinter::PrintRange>(arg1).cref());
}


// void QPrinter::setPrinterName(const QString &)


static void _init_f_setPrinterName_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPrinterName_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrinter *)cls)->setPrinterName (arg1);
}


// void QPrinter::setResolution(int)


static void _init_f_setResolution_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setResolution_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrinter *)cls)->setResolution (arg1);
}


// QList<int> QPrinter::supportedResolutions()


static void _init_f_supportedResolutions_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<int> > ();
}

static void _call_f_supportedResolutions_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<int> > ((QList<int>)((QPrinter *)cls)->supportedResolutions ());
}


// int QPrinter::toPage()


static void _init_f_toPage_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_toPage_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QPrinter *)cls)->toPage ());
}


namespace gsi
{

static gsi::Methods methods_QPrinter () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod ("abort", "@brief Method bool QPrinter::abort()\n", false, &_init_f_abort_0, &_call_f_abort_0);
  methods += new qt_gsi::GenericMethod ("actualNumCopies", "@brief Method int QPrinter::actualNumCopies()\n", true, &_init_f_actualNumCopies_c0, &_call_f_actualNumCopies_c0);
  methods += new qt_gsi::GenericMethod (":collateCopies", "@brief Method bool QPrinter::collateCopies()\n", true, &_init_f_collateCopies_c0, &_call_f_collateCopies_c0);
  methods += new qt_gsi::GenericMethod (":colorMode", "@brief Method QPrinter::ColorMode QPrinter::colorMode()\n", true, &_init_f_colorMode_c0, &_call_f_colorMode_c0);
  methods += new qt_gsi::GenericMethod (":creator", "@brief Method QString QPrinter::creator()\n", true, &_init_f_creator_c0, &_call_f_creator_c0);
  methods += new qt_gsi::GenericMethod (":docName", "@brief Method QString QPrinter::docName()\n", true, &_init_f_docName_c0, &_call_f_docName_c0);
  methods += new qt_gsi::GenericMethod (":doubleSidedPrinting", "@brief Method bool QPrinter::doubleSidedPrinting()\n", true, &_init_f_doubleSidedPrinting_c0, &_call_f_doubleSidedPrinting_c0);
  methods += new qt_gsi::GenericMethod (":duplex", "@brief Method QPrinter::DuplexMode QPrinter::duplex()\n", true, &_init_f_duplex_c0, &_call_f_duplex_c0);
  methods += new qt_gsi::GenericMethod (":fontEmbeddingEnabled", "@brief Method bool QPrinter::fontEmbeddingEnabled()\n", true, &_init_f_fontEmbeddingEnabled_c0, &_call_f_fontEmbeddingEnabled_c0);
  methods += new qt_gsi::GenericMethod ("fromPage", "@brief Method int QPrinter::fromPage()\n", true, &_init_f_fromPage_c0, &_call_f_fromPage_c0);
  methods += new qt_gsi::GenericMethod (":fullPage", "@brief Method bool QPrinter::fullPage()\n", true, &_init_f_fullPage_c0, &_call_f_fullPage_c0);
  methods += new qt_gsi::GenericMethod ("getPageMargins", "@brief Method void QPrinter::getPageMargins(double *left, double *top, double *right, double *bottom, QPrinter::Unit unit)\n", true, &_init_f_getPageMargins_c6385, &_call_f_getPageMargins_c6385);
  methods += new qt_gsi::GenericMethod ("isValid?", "@brief Method bool QPrinter::isValid()\n", true, &_init_f_isValid_c0, &_call_f_isValid_c0);
  methods += new qt_gsi::GenericMethod ("newPage", "@brief Method bool QPrinter::newPage()\n", false, &_init_f_newPage_0, &_call_f_newPage_0);
  methods += new qt_gsi::GenericMethod (":numCopies", "@brief Method int QPrinter::numCopies()\n", true, &_init_f_numCopies_c0, &_call_f_numCopies_c0);
  methods += new qt_gsi::GenericMethod (":orientation", "@brief Method QPrinter::Orientation QPrinter::orientation()\n", true, &_init_f_orientation_c0, &_call_f_orientation_c0);
  methods += new qt_gsi::GenericMethod (":outputFileName", "@brief Method QString QPrinter::outputFileName()\n", true, &_init_f_outputFileName_c0, &_call_f_outputFileName_c0);
  methods += new qt_gsi::GenericMethod (":outputFormat", "@brief Method QPrinter::OutputFormat QPrinter::outputFormat()\n", true, &_init_f_outputFormat_c0, &_call_f_outputFormat_c0);
  methods += new qt_gsi::GenericMethod (":pageOrder", "@brief Method QPrinter::PageOrder QPrinter::pageOrder()\n", true, &_init_f_pageOrder_c0, &_call_f_pageOrder_c0);
  methods += new qt_gsi::GenericMethod ("pageRect", "@brief Method QRect QPrinter::pageRect()\n", true, &_init_f_pageRect_c0, &_call_f_pageRect_c0);
  methods += new qt_gsi::GenericMethod ("pageRect", "@brief Method QRectF QPrinter::pageRect(QPrinter::Unit)\n", true, &_init_f_pageRect_c1789, &_call_f_pageRect_c1789);
  methods += new qt_gsi::GenericMethod (":pageSize", "@brief Method QPrinter::PageSize QPrinter::pageSize()\n", true, &_init_f_pageSize_c0, &_call_f_pageSize_c0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Method QPaintEngine *QPrinter::paintEngine()\nThis is a reimplementation of QPaintDevice::paintEngine", true, &_init_f_paintEngine_c0, &_call_f_paintEngine_c0);
  methods += new qt_gsi::GenericMethod ("paperRect", "@brief Method QRect QPrinter::paperRect()\n", true, &_init_f_paperRect_c0, &_call_f_paperRect_c0);
  methods += new qt_gsi::GenericMethod ("paperRect", "@brief Method QRectF QPrinter::paperRect(QPrinter::Unit)\n", true, &_init_f_paperRect_c1789, &_call_f_paperRect_c1789);
  methods += new qt_gsi::GenericMethod (":paperSize", "@brief Method QPrinter::PageSize QPrinter::paperSize()\n", true, &_init_f_paperSize_c0, &_call_f_paperSize_c0);
  methods += new qt_gsi::GenericMethod ("paperSize", "@brief Method QSizeF QPrinter::paperSize(QPrinter::Unit unit)\n", true, &_init_f_paperSize_c1789, &_call_f_paperSize_c1789);
  methods += new qt_gsi::GenericMethod (":paperSource", "@brief Method QPrinter::PaperSource QPrinter::paperSource()\n", true, &_init_f_paperSource_c0, &_call_f_paperSource_c0);
  methods += new qt_gsi::GenericMethod ("printEngine", "@brief Method QPrintEngine *QPrinter::printEngine()\n", true, &_init_f_printEngine_c0, &_call_f_printEngine_c0);
  methods += new qt_gsi::GenericMethod (":printProgram", "@brief Method QString QPrinter::printProgram()\n", true, &_init_f_printProgram_c0, &_call_f_printProgram_c0);
  methods += new qt_gsi::GenericMethod (":printRange", "@brief Method QPrinter::PrintRange QPrinter::printRange()\n", true, &_init_f_printRange_c0, &_call_f_printRange_c0);
  methods += new qt_gsi::GenericMethod (":printerName", "@brief Method QString QPrinter::printerName()\n", true, &_init_f_printerName_c0, &_call_f_printerName_c0);
  methods += new qt_gsi::GenericMethod ("printerState", "@brief Method QPrinter::PrinterState QPrinter::printerState()\n", true, &_init_f_printerState_c0, &_call_f_printerState_c0);
  methods += new qt_gsi::GenericMethod (":resolution", "@brief Method int QPrinter::resolution()\n", true, &_init_f_resolution_c0, &_call_f_resolution_c0);
  methods += new qt_gsi::GenericMethod ("setCollateCopies|collateCopies=", "@brief Method void QPrinter::setCollateCopies(bool collate)\n", false, &_init_f_setCollateCopies_864, &_call_f_setCollateCopies_864);
  methods += new qt_gsi::GenericMethod ("setColorMode|colorMode=", "@brief Method void QPrinter::setColorMode(QPrinter::ColorMode)\n", false, &_init_f_setColorMode_2273, &_call_f_setColorMode_2273);
  methods += new qt_gsi::GenericMethod ("setCreator|creator=", "@brief Method void QPrinter::setCreator(const QString &)\n", false, &_init_f_setCreator_2025, &_call_f_setCreator_2025);
  methods += new qt_gsi::GenericMethod ("setDocName|docName=", "@brief Method void QPrinter::setDocName(const QString &)\n", false, &_init_f_setDocName_2025, &_call_f_setDocName_2025);
  methods += new qt_gsi::GenericMethod ("setDoubleSidedPrinting|doubleSidedPrinting=", "@brief Method void QPrinter::setDoubleSidedPrinting(bool enable)\n", false, &_init_f_setDoubleSidedPrinting_864, &_call_f_setDoubleSidedPrinting_864);
  methods += new qt_gsi::GenericMethod ("setDuplex|duplex=", "@brief Method void QPrinter::setDuplex(QPrinter::DuplexMode duplex)\n", false, &_init_f_setDuplex_2388, &_call_f_setDuplex_2388);
  methods += new qt_gsi::GenericMethod ("setFontEmbeddingEnabled|fontEmbeddingEnabled=", "@brief Method void QPrinter::setFontEmbeddingEnabled(bool enable)\n", false, &_init_f_setFontEmbeddingEnabled_864, &_call_f_setFontEmbeddingEnabled_864);
  methods += new qt_gsi::GenericMethod ("setFromTo", "@brief Method void QPrinter::setFromTo(int fromPage, int toPage)\n", false, &_init_f_setFromTo_1426, &_call_f_setFromTo_1426);
  methods += new qt_gsi::GenericMethod ("setFullPage|fullPage=", "@brief Method void QPrinter::setFullPage(bool)\n", false, &_init_f_setFullPage_864, &_call_f_setFullPage_864);
  methods += new qt_gsi::GenericMethod ("setNumCopies|numCopies=", "@brief Method void QPrinter::setNumCopies(int)\n", false, &_init_f_setNumCopies_767, &_call_f_setNumCopies_767);
  methods += new qt_gsi::GenericMethod ("setOrientation|orientation=", "@brief Method void QPrinter::setOrientation(QPrinter::Orientation)\n", false, &_init_f_setOrientation_2537, &_call_f_setOrientation_2537);
  methods += new qt_gsi::GenericMethod ("setOutputFileName|outputFileName=", "@brief Method void QPrinter::setOutputFileName(const QString &)\n", false, &_init_f_setOutputFileName_2025, &_call_f_setOutputFileName_2025);
  methods += new qt_gsi::GenericMethod ("setOutputFormat|outputFormat=", "@brief Method void QPrinter::setOutputFormat(QPrinter::OutputFormat format)\n", false, &_init_f_setOutputFormat_2647, &_call_f_setOutputFormat_2647);
  methods += new qt_gsi::GenericMethod ("setPageMargins", "@brief Method void QPrinter::setPageMargins(double left, double top, double right, double bottom, QPrinter::Unit unit)\n", false, &_init_f_setPageMargins_5641, &_call_f_setPageMargins_5641);
  methods += new qt_gsi::GenericMethod ("setPageOrder|pageOrder=", "@brief Method void QPrinter::setPageOrder(QPrinter::PageOrder)\n", false, &_init_f_setPageOrder_2262, &_call_f_setPageOrder_2262);
  methods += new qt_gsi::GenericMethod ("setPageSize|pageSize=", "@brief Method void QPrinter::setPageSize(QPrinter::PageSize)\n", false, &_init_f_setPageSize_2165, &_call_f_setPageSize_2165);
  methods += new qt_gsi::GenericMethod ("setPaperSize|paperSize=", "@brief Method void QPrinter::setPaperSize(QPrinter::PageSize)\n", false, &_init_f_setPaperSize_2165, &_call_f_setPaperSize_2165);
  methods += new qt_gsi::GenericMethod ("setPaperSize", "@brief Method void QPrinter::setPaperSize(const QSizeF &paperSize, QPrinter::Unit unit)\n", false, &_init_f_setPaperSize_3556, &_call_f_setPaperSize_3556);
  methods += new qt_gsi::GenericMethod ("setPaperSource|paperSource=", "@brief Method void QPrinter::setPaperSource(QPrinter::PaperSource)\n", false, &_init_f_setPaperSource_2502, &_call_f_setPaperSource_2502);
  methods += new qt_gsi::GenericMethod ("setPrintProgram|printProgram=", "@brief Method void QPrinter::setPrintProgram(const QString &)\n", false, &_init_f_setPrintProgram_2025, &_call_f_setPrintProgram_2025);
  methods += new qt_gsi::GenericMethod ("setPrintRange|printRange=", "@brief Method void QPrinter::setPrintRange(QPrinter::PrintRange range)\n", false, &_init_f_setPrintRange_2391, &_call_f_setPrintRange_2391);
  methods += new qt_gsi::GenericMethod ("setPrinterName|printerName=", "@brief Method void QPrinter::setPrinterName(const QString &)\n", false, &_init_f_setPrinterName_2025, &_call_f_setPrinterName_2025);
  methods += new qt_gsi::GenericMethod ("setResolution|resolution=", "@brief Method void QPrinter::setResolution(int)\n", false, &_init_f_setResolution_767, &_call_f_setResolution_767);
  methods += new qt_gsi::GenericMethod ("supportedResolutions", "@brief Method QList<int> QPrinter::supportedResolutions()\n", true, &_init_f_supportedResolutions_c0, &_call_f_supportedResolutions_c0);
  methods += new qt_gsi::GenericMethod ("toPage", "@brief Method int QPrinter::toPage()\n", true, &_init_f_toPage_c0, &_call_f_toPage_c0);
  return methods;
}

gsi::Class<QPaintDevice> &qtdecl_QPaintDevice ();

gsi::Class<QPrinter> decl_QPrinter (qtdecl_QPaintDevice (), "QtGui", "QPrinter_Native",
  methods_QPrinter (),
  "@hide\n@alias QPrinter");

GSI_QTGUI_PUBLIC gsi::Class<QPrinter> &qtdecl_QPrinter () { return decl_QPrinter; }

}


class QPrinter_Adaptor : public QPrinter, public qt_gsi::QtObjectBase
{
public:

  virtual ~QPrinter_Adaptor();

  //  [adaptor ctor] QPrinter::QPrinter(QPrinter::PrinterMode mode)
  QPrinter_Adaptor() : QPrinter()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPrinter::QPrinter(QPrinter::PrinterMode mode)
  QPrinter_Adaptor(QPrinter::PrinterMode mode) : QPrinter(mode)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPrinter::QPrinter(const QPrinterInfo &printer, QPrinter::PrinterMode mode)
  QPrinter_Adaptor(const QPrinterInfo &printer) : QPrinter(printer)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPrinter::QPrinter(const QPrinterInfo &printer, QPrinter::PrinterMode mode)
  QPrinter_Adaptor(const QPrinterInfo &printer, QPrinter::PrinterMode mode) : QPrinter(printer, mode)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QPrinter::setEngines(QPrintEngine *printEngine, QPaintEngine *paintEngine)
  void fp_QPrinter_setEngines_3527 (QPrintEngine *printEngine, QPaintEngine *paintEngine) {
    QPrinter::setEngines(printEngine, paintEngine);
  }

  //  [adaptor impl] QPaintEngine *QPrinter::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QPrinter::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QPrinter_Adaptor, QPaintEngine *>(&QPrinter_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QPrinter::paintEngine();
    }
  }

  //  [adaptor impl] int QPrinter::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QPrinter::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QPrinter_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QPrinter_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QPrinter::metric(arg1);
    }
  }

  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_metric_c3445_0;
};

QPrinter_Adaptor::~QPrinter_Adaptor() { }

//  Constructor QPrinter::QPrinter(QPrinter::PrinterMode mode) (adaptor class)

static void _init_ctor_QPrinter_Adaptor_2502 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode", true, "QPrinter::ScreenResolution");
  decl->add_arg<const qt_gsi::Converter<QPrinter::PrinterMode>::target_type & > (argspec_0);
  decl->set_return_new<QPrinter_Adaptor> ();
}

static void _call_ctor_QPrinter_Adaptor_2502 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPrinter::PrinterMode>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<QPrinter::PrinterMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QPrinter::PrinterMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QPrinter::PrinterMode>(heap, QPrinter::ScreenResolution), heap);
  ret.write<QPrinter_Adaptor *> (new QPrinter_Adaptor (qt_gsi::QtToCppAdaptor<QPrinter::PrinterMode>(arg1).cref()));
}


//  Constructor QPrinter::QPrinter(const QPrinterInfo &printer, QPrinter::PrinterMode mode) (adaptor class)

static void _init_ctor_QPrinter_Adaptor_4924 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("printer");
  decl->add_arg<const QPrinterInfo & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "QPrinter::ScreenResolution");
  decl->add_arg<const qt_gsi::Converter<QPrinter::PrinterMode>::target_type & > (argspec_1);
  decl->set_return_new<QPrinter_Adaptor> ();
}

static void _call_ctor_QPrinter_Adaptor_4924 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPrinterInfo &arg1 = gsi::arg_reader<const QPrinterInfo & >() (args, heap);
  const qt_gsi::Converter<QPrinter::PrinterMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QPrinter::PrinterMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QPrinter::PrinterMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QPrinter::PrinterMode>(heap, QPrinter::ScreenResolution), heap);
  ret.write<QPrinter_Adaptor *> (new QPrinter_Adaptor (arg1, qt_gsi::QtToCppAdaptor<QPrinter::PrinterMode>(arg2).cref()));
}


// int QPrinter::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QPrinter_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrinter_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// QPaintEngine *QPrinter::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QPrinter_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrinter_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}


// exposed void QPrinter::setEngines(QPrintEngine *printEngine, QPaintEngine *paintEngine)

static void _init_fp_setEngines_3527 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("printEngine");
  decl->add_arg<QPrintEngine * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("paintEngine");
  decl->add_arg<QPaintEngine * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_setEngines_3527 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPrintEngine *arg1 = gsi::arg_reader<QPrintEngine * >() (args, heap);
  QPaintEngine *arg2 = gsi::arg_reader<QPaintEngine * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrinter_Adaptor *)cls)->fp_QPrinter_setEngines_3527 (arg1, arg2);
}


namespace gsi
{

gsi::Class<QPrinter> &qtdecl_QPrinter ();

static gsi::Methods methods_QPrinter_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPrinter::QPrinter(QPrinter::PrinterMode mode)\nThis method creates an object of class QPrinter.", &_init_ctor_QPrinter_Adaptor_2502, &_call_ctor_QPrinter_Adaptor_2502);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPrinter::QPrinter(const QPrinterInfo &printer, QPrinter::PrinterMode mode)\nThis method creates an object of class QPrinter.", &_init_ctor_QPrinter_Adaptor_4924, &_call_ctor_QPrinter_Adaptor_4924);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QPrinter::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QPrinter::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*setEngines", "@brief Method void QPrinter::setEngines(QPrintEngine *printEngine, QPaintEngine *paintEngine)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setEngines_3527, &_call_fp_setEngines_3527);
  return methods;
}

gsi::Class<QPrinter_Adaptor> decl_QPrinter_Adaptor (qtdecl_QPrinter (), "QtGui", "QPrinter",
  methods_QPrinter_Adaptor (),
  "@qt\n@brief Binding of QPrinter");

}


//  Implementation of the enum wrapper class for QPrinter::ColorMode
namespace qt_gsi
{

static gsi::Enum<QPrinter::ColorMode> decl_QPrinter_ColorMode_Enum ("QtGui", "QPrinter_ColorMode",
    gsi::enum_const ("GrayScale", QPrinter::GrayScale, "@brief Enum constant QPrinter::GrayScale") +
    gsi::enum_const ("Color", QPrinter::Color, "@brief Enum constant QPrinter::Color"),
  "@qt\n@brief This class represents the QPrinter::ColorMode enum");

static gsi::QFlagsClass<QPrinter::ColorMode > decl_QPrinter_ColorMode_Enums ("QtGui", "QPrinter_QFlags_ColorMode",
  "@qt\n@brief This class represents the QFlags<QPrinter::ColorMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QPrinter> inject_QPrinter_ColorMode_Enum_in_parent (decl_QPrinter_ColorMode_Enum.defs ());
static gsi::ClassExt<QPrinter> decl_QPrinter_ColorMode_Enum_as_child (decl_QPrinter_ColorMode_Enum, "ColorMode");
static gsi::ClassExt<QPrinter> decl_QPrinter_ColorMode_Enums_as_child (decl_QPrinter_ColorMode_Enums, "QFlags_ColorMode");

}


//  Implementation of the enum wrapper class for QPrinter::DuplexMode
namespace qt_gsi
{

static gsi::Enum<QPrinter::DuplexMode> decl_QPrinter_DuplexMode_Enum ("QtGui", "QPrinter_DuplexMode",
    gsi::enum_const ("DuplexNone", QPrinter::DuplexNone, "@brief Enum constant QPrinter::DuplexNone") +
    gsi::enum_const ("DuplexAuto", QPrinter::DuplexAuto, "@brief Enum constant QPrinter::DuplexAuto") +
    gsi::enum_const ("DuplexLongSide", QPrinter::DuplexLongSide, "@brief Enum constant QPrinter::DuplexLongSide") +
    gsi::enum_const ("DuplexShortSide", QPrinter::DuplexShortSide, "@brief Enum constant QPrinter::DuplexShortSide"),
  "@qt\n@brief This class represents the QPrinter::DuplexMode enum");

static gsi::QFlagsClass<QPrinter::DuplexMode > decl_QPrinter_DuplexMode_Enums ("QtGui", "QPrinter_QFlags_DuplexMode",
  "@qt\n@brief This class represents the QFlags<QPrinter::DuplexMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QPrinter> inject_QPrinter_DuplexMode_Enum_in_parent (decl_QPrinter_DuplexMode_Enum.defs ());
static gsi::ClassExt<QPrinter> decl_QPrinter_DuplexMode_Enum_as_child (decl_QPrinter_DuplexMode_Enum, "DuplexMode");
static gsi::ClassExt<QPrinter> decl_QPrinter_DuplexMode_Enums_as_child (decl_QPrinter_DuplexMode_Enums, "QFlags_DuplexMode");

}


//  Implementation of the enum wrapper class for QPrinter::Orientation
namespace qt_gsi
{

static gsi::Enum<QPrinter::Orientation> decl_QPrinter_Orientation_Enum ("QtGui", "QPrinter_Orientation",
    gsi::enum_const ("Portrait", QPrinter::Portrait, "@brief Enum constant QPrinter::Portrait") +
    gsi::enum_const ("Landscape", QPrinter::Landscape, "@brief Enum constant QPrinter::Landscape"),
  "@qt\n@brief This class represents the QPrinter::Orientation enum");

static gsi::QFlagsClass<QPrinter::Orientation > decl_QPrinter_Orientation_Enums ("QtGui", "QPrinter_QFlags_Orientation",
  "@qt\n@brief This class represents the QFlags<QPrinter::Orientation> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QPrinter> inject_QPrinter_Orientation_Enum_in_parent (decl_QPrinter_Orientation_Enum.defs ());
static gsi::ClassExt<QPrinter> decl_QPrinter_Orientation_Enum_as_child (decl_QPrinter_Orientation_Enum, "Orientation");
static gsi::ClassExt<QPrinter> decl_QPrinter_Orientation_Enums_as_child (decl_QPrinter_Orientation_Enums, "QFlags_Orientation");

}


//  Implementation of the enum wrapper class for QPrinter::OutputFormat
namespace qt_gsi
{

static gsi::Enum<QPrinter::OutputFormat> decl_QPrinter_OutputFormat_Enum ("QtGui", "QPrinter_OutputFormat",
    gsi::enum_const ("NativeFormat", QPrinter::NativeFormat, "@brief Enum constant QPrinter::NativeFormat") +
    gsi::enum_const ("PdfFormat", QPrinter::PdfFormat, "@brief Enum constant QPrinter::PdfFormat") +
    gsi::enum_const ("PostScriptFormat", QPrinter::PostScriptFormat, "@brief Enum constant QPrinter::PostScriptFormat"),
  "@qt\n@brief This class represents the QPrinter::OutputFormat enum");

static gsi::QFlagsClass<QPrinter::OutputFormat > decl_QPrinter_OutputFormat_Enums ("QtGui", "QPrinter_QFlags_OutputFormat",
  "@qt\n@brief This class represents the QFlags<QPrinter::OutputFormat> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QPrinter> inject_QPrinter_OutputFormat_Enum_in_parent (decl_QPrinter_OutputFormat_Enum.defs ());
static gsi::ClassExt<QPrinter> decl_QPrinter_OutputFormat_Enum_as_child (decl_QPrinter_OutputFormat_Enum, "OutputFormat");
static gsi::ClassExt<QPrinter> decl_QPrinter_OutputFormat_Enums_as_child (decl_QPrinter_OutputFormat_Enums, "QFlags_OutputFormat");

}


//  Implementation of the enum wrapper class for QPrinter::PageOrder
namespace qt_gsi
{

static gsi::Enum<QPrinter::PageOrder> decl_QPrinter_PageOrder_Enum ("QtGui", "QPrinter_PageOrder",
    gsi::enum_const ("FirstPageFirst", QPrinter::FirstPageFirst, "@brief Enum constant QPrinter::FirstPageFirst") +
    gsi::enum_const ("LastPageFirst", QPrinter::LastPageFirst, "@brief Enum constant QPrinter::LastPageFirst"),
  "@qt\n@brief This class represents the QPrinter::PageOrder enum");

static gsi::QFlagsClass<QPrinter::PageOrder > decl_QPrinter_PageOrder_Enums ("QtGui", "QPrinter_QFlags_PageOrder",
  "@qt\n@brief This class represents the QFlags<QPrinter::PageOrder> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QPrinter> inject_QPrinter_PageOrder_Enum_in_parent (decl_QPrinter_PageOrder_Enum.defs ());
static gsi::ClassExt<QPrinter> decl_QPrinter_PageOrder_Enum_as_child (decl_QPrinter_PageOrder_Enum, "PageOrder");
static gsi::ClassExt<QPrinter> decl_QPrinter_PageOrder_Enums_as_child (decl_QPrinter_PageOrder_Enums, "QFlags_PageOrder");

}


//  Implementation of the enum wrapper class for QPrinter::PageSize
namespace qt_gsi
{

static gsi::Enum<QPrinter::PageSize> decl_QPrinter_PageSize_Enum ("QtGui", "QPrinter_PageSize",
    gsi::enum_const ("A4", QPrinter::A4, "@brief Enum constant QPrinter::A4") +
    gsi::enum_const ("B5", QPrinter::B5, "@brief Enum constant QPrinter::B5") +
    gsi::enum_const ("Letter", QPrinter::Letter, "@brief Enum constant QPrinter::Letter") +
    gsi::enum_const ("Legal", QPrinter::Legal, "@brief Enum constant QPrinter::Legal") +
    gsi::enum_const ("Executive", QPrinter::Executive, "@brief Enum constant QPrinter::Executive") +
    gsi::enum_const ("A0", QPrinter::A0, "@brief Enum constant QPrinter::A0") +
    gsi::enum_const ("A1", QPrinter::A1, "@brief Enum constant QPrinter::A1") +
    gsi::enum_const ("A2", QPrinter::A2, "@brief Enum constant QPrinter::A2") +
    gsi::enum_const ("A3", QPrinter::A3, "@brief Enum constant QPrinter::A3") +
    gsi::enum_const ("A5", QPrinter::A5, "@brief Enum constant QPrinter::A5") +
    gsi::enum_const ("A6", QPrinter::A6, "@brief Enum constant QPrinter::A6") +
    gsi::enum_const ("A7", QPrinter::A7, "@brief Enum constant QPrinter::A7") +
    gsi::enum_const ("A8", QPrinter::A8, "@brief Enum constant QPrinter::A8") +
    gsi::enum_const ("A9", QPrinter::A9, "@brief Enum constant QPrinter::A9") +
    gsi::enum_const ("B0", QPrinter::B0, "@brief Enum constant QPrinter::B0") +
    gsi::enum_const ("B1", QPrinter::B1, "@brief Enum constant QPrinter::B1") +
    gsi::enum_const ("B10", QPrinter::B10, "@brief Enum constant QPrinter::B10") +
    gsi::enum_const ("B2", QPrinter::B2, "@brief Enum constant QPrinter::B2") +
    gsi::enum_const ("B3", QPrinter::B3, "@brief Enum constant QPrinter::B3") +
    gsi::enum_const ("B4", QPrinter::B4, "@brief Enum constant QPrinter::B4") +
    gsi::enum_const ("B6", QPrinter::B6, "@brief Enum constant QPrinter::B6") +
    gsi::enum_const ("B7", QPrinter::B7, "@brief Enum constant QPrinter::B7") +
    gsi::enum_const ("B8", QPrinter::B8, "@brief Enum constant QPrinter::B8") +
    gsi::enum_const ("B9", QPrinter::B9, "@brief Enum constant QPrinter::B9") +
    gsi::enum_const ("C5E", QPrinter::C5E, "@brief Enum constant QPrinter::C5E") +
    gsi::enum_const ("Comm10E", QPrinter::Comm10E, "@brief Enum constant QPrinter::Comm10E") +
    gsi::enum_const ("DLE", QPrinter::DLE, "@brief Enum constant QPrinter::DLE") +
    gsi::enum_const ("Folio", QPrinter::Folio, "@brief Enum constant QPrinter::Folio") +
    gsi::enum_const ("Ledger", QPrinter::Ledger, "@brief Enum constant QPrinter::Ledger") +
    gsi::enum_const ("Tabloid", QPrinter::Tabloid, "@brief Enum constant QPrinter::Tabloid") +
    gsi::enum_const ("Custom", QPrinter::Custom, "@brief Enum constant QPrinter::Custom") +
    gsi::enum_const ("NPageSize", QPrinter::NPageSize, "@brief Enum constant QPrinter::NPageSize") +
    gsi::enum_const ("NPaperSize", QPrinter::NPaperSize, "@brief Enum constant QPrinter::NPaperSize"),
  "@qt\n@brief This class represents the QPrinter::PageSize enum");

static gsi::QFlagsClass<QPrinter::PageSize > decl_QPrinter_PageSize_Enums ("QtGui", "QPrinter_QFlags_PageSize",
  "@qt\n@brief This class represents the QFlags<QPrinter::PageSize> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QPrinter> inject_QPrinter_PageSize_Enum_in_parent (decl_QPrinter_PageSize_Enum.defs ());
static gsi::ClassExt<QPrinter> decl_QPrinter_PageSize_Enum_as_child (decl_QPrinter_PageSize_Enum, "PageSize");
static gsi::ClassExt<QPrinter> decl_QPrinter_PageSize_Enums_as_child (decl_QPrinter_PageSize_Enums, "QFlags_PageSize");

}


//  Implementation of the enum wrapper class for QPrinter::PaperSource
namespace qt_gsi
{

static gsi::Enum<QPrinter::PaperSource> decl_QPrinter_PaperSource_Enum ("QtGui", "QPrinter_PaperSource",
    gsi::enum_const ("OnlyOne", QPrinter::OnlyOne, "@brief Enum constant QPrinter::OnlyOne") +
    gsi::enum_const ("Lower", QPrinter::Lower, "@brief Enum constant QPrinter::Lower") +
    gsi::enum_const ("Middle", QPrinter::Middle, "@brief Enum constant QPrinter::Middle") +
    gsi::enum_const ("Manual", QPrinter::Manual, "@brief Enum constant QPrinter::Manual") +
    gsi::enum_const ("Envelope", QPrinter::Envelope, "@brief Enum constant QPrinter::Envelope") +
    gsi::enum_const ("EnvelopeManual", QPrinter::EnvelopeManual, "@brief Enum constant QPrinter::EnvelopeManual") +
    gsi::enum_const ("Auto", QPrinter::Auto, "@brief Enum constant QPrinter::Auto") +
    gsi::enum_const ("Tractor", QPrinter::Tractor, "@brief Enum constant QPrinter::Tractor") +
    gsi::enum_const ("SmallFormat", QPrinter::SmallFormat, "@brief Enum constant QPrinter::SmallFormat") +
    gsi::enum_const ("LargeFormat", QPrinter::LargeFormat, "@brief Enum constant QPrinter::LargeFormat") +
    gsi::enum_const ("LargeCapacity", QPrinter::LargeCapacity, "@brief Enum constant QPrinter::LargeCapacity") +
    gsi::enum_const ("Cassette", QPrinter::Cassette, "@brief Enum constant QPrinter::Cassette") +
    gsi::enum_const ("FormSource", QPrinter::FormSource, "@brief Enum constant QPrinter::FormSource") +
    gsi::enum_const ("MaxPageSource", QPrinter::MaxPageSource, "@brief Enum constant QPrinter::MaxPageSource"),
  "@qt\n@brief This class represents the QPrinter::PaperSource enum");

static gsi::QFlagsClass<QPrinter::PaperSource > decl_QPrinter_PaperSource_Enums ("QtGui", "QPrinter_QFlags_PaperSource",
  "@qt\n@brief This class represents the QFlags<QPrinter::PaperSource> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QPrinter> inject_QPrinter_PaperSource_Enum_in_parent (decl_QPrinter_PaperSource_Enum.defs ());
static gsi::ClassExt<QPrinter> decl_QPrinter_PaperSource_Enum_as_child (decl_QPrinter_PaperSource_Enum, "PaperSource");
static gsi::ClassExt<QPrinter> decl_QPrinter_PaperSource_Enums_as_child (decl_QPrinter_PaperSource_Enums, "QFlags_PaperSource");

}


//  Implementation of the enum wrapper class for QPrinter::PrintRange
namespace qt_gsi
{

static gsi::Enum<QPrinter::PrintRange> decl_QPrinter_PrintRange_Enum ("QtGui", "QPrinter_PrintRange",
    gsi::enum_const ("AllPages", QPrinter::AllPages, "@brief Enum constant QPrinter::AllPages") +
    gsi::enum_const ("Selection", QPrinter::Selection, "@brief Enum constant QPrinter::Selection") +
    gsi::enum_const ("PageRange", QPrinter::PageRange, "@brief Enum constant QPrinter::PageRange"),
  "@qt\n@brief This class represents the QPrinter::PrintRange enum");

static gsi::QFlagsClass<QPrinter::PrintRange > decl_QPrinter_PrintRange_Enums ("QtGui", "QPrinter_QFlags_PrintRange",
  "@qt\n@brief This class represents the QFlags<QPrinter::PrintRange> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QPrinter> inject_QPrinter_PrintRange_Enum_in_parent (decl_QPrinter_PrintRange_Enum.defs ());
static gsi::ClassExt<QPrinter> decl_QPrinter_PrintRange_Enum_as_child (decl_QPrinter_PrintRange_Enum, "PrintRange");
static gsi::ClassExt<QPrinter> decl_QPrinter_PrintRange_Enums_as_child (decl_QPrinter_PrintRange_Enums, "QFlags_PrintRange");

}


//  Implementation of the enum wrapper class for QPrinter::PrinterMode
namespace qt_gsi
{

static gsi::Enum<QPrinter::PrinterMode> decl_QPrinter_PrinterMode_Enum ("QtGui", "QPrinter_PrinterMode",
    gsi::enum_const ("ScreenResolution", QPrinter::ScreenResolution, "@brief Enum constant QPrinter::ScreenResolution") +
    gsi::enum_const ("PrinterResolution", QPrinter::PrinterResolution, "@brief Enum constant QPrinter::PrinterResolution") +
    gsi::enum_const ("HighResolution", QPrinter::HighResolution, "@brief Enum constant QPrinter::HighResolution"),
  "@qt\n@brief This class represents the QPrinter::PrinterMode enum");

static gsi::QFlagsClass<QPrinter::PrinterMode > decl_QPrinter_PrinterMode_Enums ("QtGui", "QPrinter_QFlags_PrinterMode",
  "@qt\n@brief This class represents the QFlags<QPrinter::PrinterMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QPrinter> inject_QPrinter_PrinterMode_Enum_in_parent (decl_QPrinter_PrinterMode_Enum.defs ());
static gsi::ClassExt<QPrinter> decl_QPrinter_PrinterMode_Enum_as_child (decl_QPrinter_PrinterMode_Enum, "PrinterMode");
static gsi::ClassExt<QPrinter> decl_QPrinter_PrinterMode_Enums_as_child (decl_QPrinter_PrinterMode_Enums, "QFlags_PrinterMode");

}


//  Implementation of the enum wrapper class for QPrinter::PrinterState
namespace qt_gsi
{

static gsi::Enum<QPrinter::PrinterState> decl_QPrinter_PrinterState_Enum ("QtGui", "QPrinter_PrinterState",
    gsi::enum_const ("Idle", QPrinter::Idle, "@brief Enum constant QPrinter::Idle") +
    gsi::enum_const ("Active", QPrinter::Active, "@brief Enum constant QPrinter::Active") +
    gsi::enum_const ("Aborted", QPrinter::Aborted, "@brief Enum constant QPrinter::Aborted") +
    gsi::enum_const ("Error", QPrinter::Error, "@brief Enum constant QPrinter::Error"),
  "@qt\n@brief This class represents the QPrinter::PrinterState enum");

static gsi::QFlagsClass<QPrinter::PrinterState > decl_QPrinter_PrinterState_Enums ("QtGui", "QPrinter_QFlags_PrinterState",
  "@qt\n@brief This class represents the QFlags<QPrinter::PrinterState> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QPrinter> inject_QPrinter_PrinterState_Enum_in_parent (decl_QPrinter_PrinterState_Enum.defs ());
static gsi::ClassExt<QPrinter> decl_QPrinter_PrinterState_Enum_as_child (decl_QPrinter_PrinterState_Enum, "PrinterState");
static gsi::ClassExt<QPrinter> decl_QPrinter_PrinterState_Enums_as_child (decl_QPrinter_PrinterState_Enums, "QFlags_PrinterState");

}


//  Implementation of the enum wrapper class for QPrinter::Unit
namespace qt_gsi
{

static gsi::Enum<QPrinter::Unit> decl_QPrinter_Unit_Enum ("QtGui", "QPrinter_Unit",
    gsi::enum_const ("Millimeter", QPrinter::Millimeter, "@brief Enum constant QPrinter::Millimeter") +
    gsi::enum_const ("Point", QPrinter::Point, "@brief Enum constant QPrinter::Point") +
    gsi::enum_const ("Inch", QPrinter::Inch, "@brief Enum constant QPrinter::Inch") +
    gsi::enum_const ("Pica", QPrinter::Pica, "@brief Enum constant QPrinter::Pica") +
    gsi::enum_const ("Didot", QPrinter::Didot, "@brief Enum constant QPrinter::Didot") +
    gsi::enum_const ("Cicero", QPrinter::Cicero, "@brief Enum constant QPrinter::Cicero") +
    gsi::enum_const ("DevicePixel", QPrinter::DevicePixel, "@brief Enum constant QPrinter::DevicePixel"),
  "@qt\n@brief This class represents the QPrinter::Unit enum");

static gsi::QFlagsClass<QPrinter::Unit > decl_QPrinter_Unit_Enums ("QtGui", "QPrinter_QFlags_Unit",
  "@qt\n@brief This class represents the QFlags<QPrinter::Unit> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QPrinter> inject_QPrinter_Unit_Enum_in_parent (decl_QPrinter_Unit_Enum.defs ());
static gsi::ClassExt<QPrinter> decl_QPrinter_Unit_Enum_as_child (decl_QPrinter_Unit_Enum, "Unit");
static gsi::ClassExt<QPrinter> decl_QPrinter_Unit_Enums_as_child (decl_QPrinter_Unit_Enums, "QFlags_Unit");

}

