
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2021 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQStandardItem.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QStandardItem>
#include <QBrush>
#include <QDataStream>
#include <QFont>
#include <QIcon>
#include <QModelIndex>
#include <QSize>
#include <QStandardItemModel>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include "gsiDeclQtGuiTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QStandardItem

// QString QStandardItem::accessibleDescription()


static void _init_f_accessibleDescription_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_accessibleDescription_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QStandardItem *)cls)->accessibleDescription ());
}


// QString QStandardItem::accessibleText()


static void _init_f_accessibleText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_accessibleText_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QStandardItem *)cls)->accessibleText ());
}


// void QStandardItem::appendColumn(const QList<QStandardItem*> &items)


static void _init_f_appendColumn_3267 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("items");
  decl->add_arg<const QList<QStandardItem*> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_appendColumn_3267 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QStandardItem*> &arg1 = gsi::arg_reader<const QList<QStandardItem*> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->appendColumn (arg1);
}


// void QStandardItem::appendRow(const QList<QStandardItem*> &items)


static void _init_f_appendRow_3267 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("items");
  decl->add_arg<const QList<QStandardItem*> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_appendRow_3267 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QStandardItem*> &arg1 = gsi::arg_reader<const QList<QStandardItem*> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->appendRow (arg1);
}


// void QStandardItem::appendRow(QStandardItem *item)


static void _init_f_appendRow_1919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QStandardItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_appendRow_1919 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStandardItem *arg1 = gsi::arg_reader<QStandardItem * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->appendRow (arg1);
}


// void QStandardItem::appendRows(const QList<QStandardItem*> &items)


static void _init_f_appendRows_3267 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("items");
  decl->add_arg<const QList<QStandardItem*> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_appendRows_3267 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QStandardItem*> &arg1 = gsi::arg_reader<const QList<QStandardItem*> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->appendRows (arg1);
}


// QBrush QStandardItem::background()


static void _init_f_background_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QBrush > ();
}

static void _call_f_background_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QBrush > ((QBrush)((QStandardItem *)cls)->background ());
}


// Qt::CheckState QStandardItem::checkState()


static void _init_f_checkState_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::CheckState>::target_type > ();
}

static void _call_f_checkState_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::CheckState>::target_type > ((qt_gsi::Converter<Qt::CheckState>::target_type)qt_gsi::CppToQtAdaptor<Qt::CheckState>(((QStandardItem *)cls)->checkState ()));
}


// QStandardItem *QStandardItem::child(int row, int column)


static void _init_f_child_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column", true, "0");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QStandardItem * > ();
}

static void _call_f_child_c1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  ret.write<QStandardItem * > ((QStandardItem *)((QStandardItem *)cls)->child (arg1, arg2));
}


// QStandardItem *QStandardItem::clone()


static void _init_f_clone_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStandardItem * > ();
}

static void _call_f_clone_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStandardItem * > ((QStandardItem *)((QStandardItem *)cls)->clone ());
}


// int QStandardItem::column()


static void _init_f_column_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_column_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QStandardItem *)cls)->column ());
}


// int QStandardItem::columnCount()


static void _init_f_columnCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_columnCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QStandardItem *)cls)->columnCount ());
}


// QVariant QStandardItem::data(int role)


static void _init_f_data_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("role", true, "Qt::UserRole + 1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_data_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (Qt::UserRole + 1, heap);
  ret.write<QVariant > ((QVariant)((QStandardItem *)cls)->data (arg1));
}


// QFlags<Qt::ItemFlag> QStandardItem::flags()


static void _init_f_flags_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::ItemFlag> > ();
}

static void _call_f_flags_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::ItemFlag> > ((QFlags<Qt::ItemFlag>)((QStandardItem *)cls)->flags ());
}


// QFont QStandardItem::font()


static void _init_f_font_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFont > ();
}

static void _call_f_font_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFont > ((QFont)((QStandardItem *)cls)->font ());
}


// QBrush QStandardItem::foreground()


static void _init_f_foreground_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QBrush > ();
}

static void _call_f_foreground_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QBrush > ((QBrush)((QStandardItem *)cls)->foreground ());
}


// bool QStandardItem::hasChildren()


static void _init_f_hasChildren_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasChildren_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QStandardItem *)cls)->hasChildren ());
}


// QIcon QStandardItem::icon()


static void _init_f_icon_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QIcon > ();
}

static void _call_f_icon_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QIcon > ((QIcon)((QStandardItem *)cls)->icon ());
}


// QModelIndex QStandardItem::index()


static void _init_f_index_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QModelIndex > ();
}

static void _call_f_index_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QModelIndex > ((QModelIndex)((QStandardItem *)cls)->index ());
}


// void QStandardItem::insertColumn(int column, const QList<QStandardItem*> &items)


static void _init_f_insertColumn_3926 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("items");
  decl->add_arg<const QList<QStandardItem*> & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertColumn_3926 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QList<QStandardItem*> &arg2 = gsi::arg_reader<const QList<QStandardItem*> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->insertColumn (arg1, arg2);
}


// void QStandardItem::insertColumns(int column, int count)


static void _init_f_insertColumns_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertColumns_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->insertColumns (arg1, arg2);
}


// void QStandardItem::insertRow(int row, const QList<QStandardItem*> &items)


static void _init_f_insertRow_3926 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("items");
  decl->add_arg<const QList<QStandardItem*> & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertRow_3926 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QList<QStandardItem*> &arg2 = gsi::arg_reader<const QList<QStandardItem*> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->insertRow (arg1, arg2);
}


// void QStandardItem::insertRow(int row, QStandardItem *item)


static void _init_f_insertRow_2578 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("item");
  decl->add_arg<QStandardItem * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertRow_2578 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  QStandardItem *arg2 = gsi::arg_reader<QStandardItem * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->insertRow (arg1, arg2);
}


// void QStandardItem::insertRows(int row, const QList<QStandardItem*> &items)


static void _init_f_insertRows_3926 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("items");
  decl->add_arg<const QList<QStandardItem*> & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertRows_3926 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QList<QStandardItem*> &arg2 = gsi::arg_reader<const QList<QStandardItem*> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->insertRows (arg1, arg2);
}


// void QStandardItem::insertRows(int row, int count)


static void _init_f_insertRows_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertRows_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->insertRows (arg1, arg2);
}


// bool QStandardItem::isCheckable()


static void _init_f_isCheckable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isCheckable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QStandardItem *)cls)->isCheckable ());
}


// bool QStandardItem::isDragEnabled()


static void _init_f_isDragEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isDragEnabled_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QStandardItem *)cls)->isDragEnabled ());
}


// bool QStandardItem::isDropEnabled()


static void _init_f_isDropEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isDropEnabled_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QStandardItem *)cls)->isDropEnabled ());
}


// bool QStandardItem::isEditable()


static void _init_f_isEditable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEditable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QStandardItem *)cls)->isEditable ());
}


// bool QStandardItem::isEnabled()


static void _init_f_isEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEnabled_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QStandardItem *)cls)->isEnabled ());
}


// bool QStandardItem::isSelectable()


static void _init_f_isSelectable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSelectable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QStandardItem *)cls)->isSelectable ());
}


// bool QStandardItem::isTristate()


static void _init_f_isTristate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isTristate_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QStandardItem *)cls)->isTristate ());
}


// QStandardItemModel *QStandardItem::model()


static void _init_f_model_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStandardItemModel * > ();
}

static void _call_f_model_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStandardItemModel * > ((QStandardItemModel *)((QStandardItem *)cls)->model ());
}


// bool QStandardItem::operator<(const QStandardItem &other)


static void _init_f_operator_lt__c2610 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QStandardItem & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_lt__c2610 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStandardItem &arg1 = gsi::arg_reader<const QStandardItem & >() (args, heap);
  ret.write<bool > ((bool)((QStandardItem *)cls)->operator< (arg1));
}


// QStandardItem *QStandardItem::parent()


static void _init_f_parent_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStandardItem * > ();
}

static void _call_f_parent_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStandardItem * > ((QStandardItem *)((QStandardItem *)cls)->parent ());
}


// void QStandardItem::read(QDataStream &in)


static void _init_f_read_1697 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("in");
  decl->add_arg<QDataStream & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_read_1697 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDataStream &arg1 = gsi::arg_reader<QDataStream & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->read (arg1);
}


// void QStandardItem::removeColumn(int column)


static void _init_f_removeColumn_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeColumn_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->removeColumn (arg1);
}


// void QStandardItem::removeColumns(int column, int count)


static void _init_f_removeColumns_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_removeColumns_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->removeColumns (arg1, arg2);
}


// void QStandardItem::removeRow(int row)


static void _init_f_removeRow_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeRow_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->removeRow (arg1);
}


// void QStandardItem::removeRows(int row, int count)


static void _init_f_removeRows_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_removeRows_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->removeRows (arg1, arg2);
}


// int QStandardItem::row()


static void _init_f_row_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_row_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QStandardItem *)cls)->row ());
}


// int QStandardItem::rowCount()


static void _init_f_rowCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_rowCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QStandardItem *)cls)->rowCount ());
}


// void QStandardItem::setAccessibleDescription(const QString &accessibleDescription)


static void _init_f_setAccessibleDescription_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("accessibleDescription");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAccessibleDescription_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->setAccessibleDescription (arg1);
}


// void QStandardItem::setAccessibleText(const QString &accessibleText)


static void _init_f_setAccessibleText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("accessibleText");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAccessibleText_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->setAccessibleText (arg1);
}


// void QStandardItem::setBackground(const QBrush &brush)


static void _init_f_setBackground_1910 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("brush");
  decl->add_arg<const QBrush & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBackground_1910 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QBrush &arg1 = gsi::arg_reader<const QBrush & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->setBackground (arg1);
}


// void QStandardItem::setCheckState(Qt::CheckState checkState)


static void _init_f_setCheckState_1740 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("checkState");
  decl->add_arg<const qt_gsi::Converter<Qt::CheckState>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCheckState_1740 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::CheckState>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::CheckState>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->setCheckState (qt_gsi::QtToCppAdaptor<Qt::CheckState>(arg1).cref());
}


// void QStandardItem::setCheckable(bool checkable)


static void _init_f_setCheckable_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("checkable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCheckable_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->setCheckable (arg1);
}


// void QStandardItem::setChild(int row, int column, QStandardItem *item)


static void _init_f_setChild_3237 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("item");
  decl->add_arg<QStandardItem * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setChild_3237 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  QStandardItem *arg3 = gsi::arg_reader<QStandardItem * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->setChild (arg1, arg2, arg3);
}


// void QStandardItem::setChild(int row, QStandardItem *item)


static void _init_f_setChild_2578 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("item");
  decl->add_arg<QStandardItem * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setChild_2578 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  QStandardItem *arg2 = gsi::arg_reader<QStandardItem * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->setChild (arg1, arg2);
}


// void QStandardItem::setColumnCount(int columns)


static void _init_f_setColumnCount_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("columns");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setColumnCount_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->setColumnCount (arg1);
}


// void QStandardItem::setData(const QVariant &value, int role)


static void _init_f_setData_2778u1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<const QVariant & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role", true, "Qt::UserRole + 1");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setData_2778u1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVariant &arg1 = gsi::arg_reader<const QVariant & >() (args, heap);
  int arg2 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (Qt::UserRole + 1, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->setData (arg1, arg2);
}


// void QStandardItem::setDragEnabled(bool dragEnabled)


static void _init_f_setDragEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dragEnabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDragEnabled_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->setDragEnabled (arg1);
}


// void QStandardItem::setDropEnabled(bool dropEnabled)


static void _init_f_setDropEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dropEnabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDropEnabled_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->setDropEnabled (arg1);
}


// void QStandardItem::setEditable(bool editable)


static void _init_f_setEditable_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEditable_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->setEditable (arg1);
}


// void QStandardItem::setEnabled(bool enabled)


static void _init_f_setEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEnabled_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->setEnabled (arg1);
}


// void QStandardItem::setFlags(QFlags<Qt::ItemFlag> flags)


static void _init_f_setFlags_2222 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags");
  decl->add_arg<QFlags<Qt::ItemFlag> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFlags_2222 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<Qt::ItemFlag> arg1 = gsi::arg_reader<QFlags<Qt::ItemFlag> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->setFlags (arg1);
}


// void QStandardItem::setFont(const QFont &font)


static void _init_f_setFont_1801 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("font");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFont_1801 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFont &arg1 = gsi::arg_reader<const QFont & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->setFont (arg1);
}


// void QStandardItem::setForeground(const QBrush &brush)


static void _init_f_setForeground_1910 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("brush");
  decl->add_arg<const QBrush & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setForeground_1910 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QBrush &arg1 = gsi::arg_reader<const QBrush & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->setForeground (arg1);
}


// void QStandardItem::setIcon(const QIcon &icon)


static void _init_f_setIcon_1787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIcon_1787 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QIcon &arg1 = gsi::arg_reader<const QIcon & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->setIcon (arg1);
}


// void QStandardItem::setRowCount(int rows)


static void _init_f_setRowCount_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rows");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRowCount_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->setRowCount (arg1);
}


// void QStandardItem::setSelectable(bool selectable)


static void _init_f_setSelectable_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selectable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSelectable_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->setSelectable (arg1);
}


// void QStandardItem::setSizeHint(const QSize &sizeHint)


static void _init_f_setSizeHint_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sizeHint");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSizeHint_1805 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSize &arg1 = gsi::arg_reader<const QSize & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->setSizeHint (arg1);
}


// void QStandardItem::setStatusTip(const QString &statusTip)


static void _init_f_setStatusTip_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("statusTip");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStatusTip_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->setStatusTip (arg1);
}


// void QStandardItem::setText(const QString &text)


static void _init_f_setText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setText_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->setText (arg1);
}


// void QStandardItem::setTextAlignment(QFlags<Qt::AlignmentFlag> textAlignment)


static void _init_f_setTextAlignment_2750 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("textAlignment");
  decl->add_arg<QFlags<Qt::AlignmentFlag> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTextAlignment_2750 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<Qt::AlignmentFlag> arg1 = gsi::arg_reader<QFlags<Qt::AlignmentFlag> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->setTextAlignment (arg1);
}


// void QStandardItem::setToolTip(const QString &toolTip)


static void _init_f_setToolTip_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("toolTip");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setToolTip_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->setToolTip (arg1);
}


// void QStandardItem::setTristate(bool tristate)


static void _init_f_setTristate_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("tristate");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTristate_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->setTristate (arg1);
}


// void QStandardItem::setWhatsThis(const QString &whatsThis)


static void _init_f_setWhatsThis_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("whatsThis");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWhatsThis_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->setWhatsThis (arg1);
}


// QSize QStandardItem::sizeHint()


static void _init_f_sizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QStandardItem *)cls)->sizeHint ());
}


// void QStandardItem::sortChildren(int column, Qt::SortOrder order)


static void _init_f_sortChildren_2340 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("order", true, "Qt::AscendingOrder");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_sortChildren_2340 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::SortOrder>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::SortOrder>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::SortOrder>(heap, Qt::AscendingOrder), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->sortChildren (arg1, qt_gsi::QtToCppAdaptor<Qt::SortOrder>(arg2).cref());
}


// QString QStandardItem::statusTip()


static void _init_f_statusTip_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_statusTip_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QStandardItem *)cls)->statusTip ());
}


// QStandardItem *QStandardItem::takeChild(int row, int column)


static void _init_f_takeChild_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column", true, "0");
  decl->add_arg<int > (argspec_1);
  decl->set_return_new<QStandardItem * > ();
}

static void _call_f_takeChild_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  ret.write<QStandardItem * > ((QStandardItem *)((QStandardItem *)cls)->takeChild (arg1, arg2));
}


// QList<QStandardItem*> QStandardItem::takeColumn(int column)


static void _init_f_takeColumn_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return_new<QList<QStandardItem*> > ();
}

static void _call_f_takeColumn_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QList<QStandardItem*> > ((QList<QStandardItem*>)((QStandardItem *)cls)->takeColumn (arg1));
}


// QList<QStandardItem*> QStandardItem::takeRow(int row)


static void _init_f_takeRow_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return_new<QList<QStandardItem*> > ();
}

static void _call_f_takeRow_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QList<QStandardItem*> > ((QList<QStandardItem*>)((QStandardItem *)cls)->takeRow (arg1));
}


// QString QStandardItem::text()


static void _init_f_text_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_text_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QStandardItem *)cls)->text ());
}


// QFlags<Qt::AlignmentFlag> QStandardItem::textAlignment()


static void _init_f_textAlignment_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::AlignmentFlag> > ();
}

static void _call_f_textAlignment_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::AlignmentFlag> > ((QFlags<Qt::AlignmentFlag>)((QStandardItem *)cls)->textAlignment ());
}


// QString QStandardItem::toolTip()


static void _init_f_toolTip_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_toolTip_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QStandardItem *)cls)->toolTip ());
}


// int QStandardItem::type()


static void _init_f_type_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_type_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QStandardItem *)cls)->type ());
}


// QString QStandardItem::whatsThis()


static void _init_f_whatsThis_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_whatsThis_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QStandardItem *)cls)->whatsThis ());
}


// void QStandardItem::write(QDataStream &out)


static void _init_f_write_c1697 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("out");
  decl->add_arg<QDataStream & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_write_c1697 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDataStream &arg1 = gsi::arg_reader<QDataStream & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem *)cls)->write (arg1);
}


namespace gsi
{

static gsi::Methods methods_QStandardItem () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod (":accessibleDescription", "@brief Method QString QStandardItem::accessibleDescription()\n", true, &_init_f_accessibleDescription_c0, &_call_f_accessibleDescription_c0);
  methods += new qt_gsi::GenericMethod (":accessibleText", "@brief Method QString QStandardItem::accessibleText()\n", true, &_init_f_accessibleText_c0, &_call_f_accessibleText_c0);
  methods += new qt_gsi::GenericMethod ("appendColumn", "@brief Method void QStandardItem::appendColumn(const QList<QStandardItem*> &items)\n", false, &_init_f_appendColumn_3267, &_call_f_appendColumn_3267);
  methods += new qt_gsi::GenericMethod ("appendRow", "@brief Method void QStandardItem::appendRow(const QList<QStandardItem*> &items)\n", false, &_init_f_appendRow_3267, &_call_f_appendRow_3267);
  methods += new qt_gsi::GenericMethod ("appendRow", "@brief Method void QStandardItem::appendRow(QStandardItem *item)\n", false, &_init_f_appendRow_1919, &_call_f_appendRow_1919);
  methods += new qt_gsi::GenericMethod ("appendRows", "@brief Method void QStandardItem::appendRows(const QList<QStandardItem*> &items)\n", false, &_init_f_appendRows_3267, &_call_f_appendRows_3267);
  methods += new qt_gsi::GenericMethod (":background", "@brief Method QBrush QStandardItem::background()\n", true, &_init_f_background_c0, &_call_f_background_c0);
  methods += new qt_gsi::GenericMethod (":checkState", "@brief Method Qt::CheckState QStandardItem::checkState()\n", true, &_init_f_checkState_c0, &_call_f_checkState_c0);
  methods += new qt_gsi::GenericMethod ("child", "@brief Method QStandardItem *QStandardItem::child(int row, int column)\n", true, &_init_f_child_c1426, &_call_f_child_c1426);
  methods += new qt_gsi::GenericMethod ("clone", "@brief Method QStandardItem *QStandardItem::clone()\n", true, &_init_f_clone_c0, &_call_f_clone_c0);
  methods += new qt_gsi::GenericMethod ("column", "@brief Method int QStandardItem::column()\n", true, &_init_f_column_c0, &_call_f_column_c0);
  methods += new qt_gsi::GenericMethod (":columnCount", "@brief Method int QStandardItem::columnCount()\n", true, &_init_f_columnCount_c0, &_call_f_columnCount_c0);
  methods += new qt_gsi::GenericMethod ("data", "@brief Method QVariant QStandardItem::data(int role)\n", true, &_init_f_data_c767, &_call_f_data_c767);
  methods += new qt_gsi::GenericMethod (":flags", "@brief Method QFlags<Qt::ItemFlag> QStandardItem::flags()\n", true, &_init_f_flags_c0, &_call_f_flags_c0);
  methods += new qt_gsi::GenericMethod (":font", "@brief Method QFont QStandardItem::font()\n", true, &_init_f_font_c0, &_call_f_font_c0);
  methods += new qt_gsi::GenericMethod (":foreground", "@brief Method QBrush QStandardItem::foreground()\n", true, &_init_f_foreground_c0, &_call_f_foreground_c0);
  methods += new qt_gsi::GenericMethod ("hasChildren", "@brief Method bool QStandardItem::hasChildren()\n", true, &_init_f_hasChildren_c0, &_call_f_hasChildren_c0);
  methods += new qt_gsi::GenericMethod (":icon", "@brief Method QIcon QStandardItem::icon()\n", true, &_init_f_icon_c0, &_call_f_icon_c0);
  methods += new qt_gsi::GenericMethod ("index", "@brief Method QModelIndex QStandardItem::index()\n", true, &_init_f_index_c0, &_call_f_index_c0);
  methods += new qt_gsi::GenericMethod ("insertColumn", "@brief Method void QStandardItem::insertColumn(int column, const QList<QStandardItem*> &items)\n", false, &_init_f_insertColumn_3926, &_call_f_insertColumn_3926);
  methods += new qt_gsi::GenericMethod ("insertColumns", "@brief Method void QStandardItem::insertColumns(int column, int count)\n", false, &_init_f_insertColumns_1426, &_call_f_insertColumns_1426);
  methods += new qt_gsi::GenericMethod ("insertRow", "@brief Method void QStandardItem::insertRow(int row, const QList<QStandardItem*> &items)\n", false, &_init_f_insertRow_3926, &_call_f_insertRow_3926);
  methods += new qt_gsi::GenericMethod ("insertRow", "@brief Method void QStandardItem::insertRow(int row, QStandardItem *item)\n", false, &_init_f_insertRow_2578, &_call_f_insertRow_2578);
  methods += new qt_gsi::GenericMethod ("insertRows", "@brief Method void QStandardItem::insertRows(int row, const QList<QStandardItem*> &items)\n", false, &_init_f_insertRows_3926, &_call_f_insertRows_3926);
  methods += new qt_gsi::GenericMethod ("insertRows", "@brief Method void QStandardItem::insertRows(int row, int count)\n", false, &_init_f_insertRows_1426, &_call_f_insertRows_1426);
  methods += new qt_gsi::GenericMethod ("isCheckable?|:checkable", "@brief Method bool QStandardItem::isCheckable()\n", true, &_init_f_isCheckable_c0, &_call_f_isCheckable_c0);
  methods += new qt_gsi::GenericMethod ("isDragEnabled?|:dragEnabled", "@brief Method bool QStandardItem::isDragEnabled()\n", true, &_init_f_isDragEnabled_c0, &_call_f_isDragEnabled_c0);
  methods += new qt_gsi::GenericMethod ("isDropEnabled?|:dropEnabled", "@brief Method bool QStandardItem::isDropEnabled()\n", true, &_init_f_isDropEnabled_c0, &_call_f_isDropEnabled_c0);
  methods += new qt_gsi::GenericMethod ("isEditable?|:editable", "@brief Method bool QStandardItem::isEditable()\n", true, &_init_f_isEditable_c0, &_call_f_isEditable_c0);
  methods += new qt_gsi::GenericMethod ("isEnabled?|:enabled", "@brief Method bool QStandardItem::isEnabled()\n", true, &_init_f_isEnabled_c0, &_call_f_isEnabled_c0);
  methods += new qt_gsi::GenericMethod ("isSelectable?|:selectable", "@brief Method bool QStandardItem::isSelectable()\n", true, &_init_f_isSelectable_c0, &_call_f_isSelectable_c0);
  methods += new qt_gsi::GenericMethod ("isTristate?|:tristate", "@brief Method bool QStandardItem::isTristate()\n", true, &_init_f_isTristate_c0, &_call_f_isTristate_c0);
  methods += new qt_gsi::GenericMethod ("model", "@brief Method QStandardItemModel *QStandardItem::model()\n", true, &_init_f_model_c0, &_call_f_model_c0);
  methods += new qt_gsi::GenericMethod ("<", "@brief Method bool QStandardItem::operator<(const QStandardItem &other)\n", true, &_init_f_operator_lt__c2610, &_call_f_operator_lt__c2610);
  methods += new qt_gsi::GenericMethod ("parent", "@brief Method QStandardItem *QStandardItem::parent()\n", true, &_init_f_parent_c0, &_call_f_parent_c0);
  methods += new qt_gsi::GenericMethod ("read", "@brief Method void QStandardItem::read(QDataStream &in)\n", false, &_init_f_read_1697, &_call_f_read_1697);
  methods += new qt_gsi::GenericMethod ("removeColumn", "@brief Method void QStandardItem::removeColumn(int column)\n", false, &_init_f_removeColumn_767, &_call_f_removeColumn_767);
  methods += new qt_gsi::GenericMethod ("removeColumns", "@brief Method void QStandardItem::removeColumns(int column, int count)\n", false, &_init_f_removeColumns_1426, &_call_f_removeColumns_1426);
  methods += new qt_gsi::GenericMethod ("removeRow", "@brief Method void QStandardItem::removeRow(int row)\n", false, &_init_f_removeRow_767, &_call_f_removeRow_767);
  methods += new qt_gsi::GenericMethod ("removeRows", "@brief Method void QStandardItem::removeRows(int row, int count)\n", false, &_init_f_removeRows_1426, &_call_f_removeRows_1426);
  methods += new qt_gsi::GenericMethod ("row", "@brief Method int QStandardItem::row()\n", true, &_init_f_row_c0, &_call_f_row_c0);
  methods += new qt_gsi::GenericMethod (":rowCount", "@brief Method int QStandardItem::rowCount()\n", true, &_init_f_rowCount_c0, &_call_f_rowCount_c0);
  methods += new qt_gsi::GenericMethod ("setAccessibleDescription|accessibleDescription=", "@brief Method void QStandardItem::setAccessibleDescription(const QString &accessibleDescription)\n", false, &_init_f_setAccessibleDescription_2025, &_call_f_setAccessibleDescription_2025);
  methods += new qt_gsi::GenericMethod ("setAccessibleText|accessibleText=", "@brief Method void QStandardItem::setAccessibleText(const QString &accessibleText)\n", false, &_init_f_setAccessibleText_2025, &_call_f_setAccessibleText_2025);
  methods += new qt_gsi::GenericMethod ("setBackground|background=", "@brief Method void QStandardItem::setBackground(const QBrush &brush)\n", false, &_init_f_setBackground_1910, &_call_f_setBackground_1910);
  methods += new qt_gsi::GenericMethod ("setCheckState|checkState=", "@brief Method void QStandardItem::setCheckState(Qt::CheckState checkState)\n", false, &_init_f_setCheckState_1740, &_call_f_setCheckState_1740);
  methods += new qt_gsi::GenericMethod ("setCheckable|checkable=", "@brief Method void QStandardItem::setCheckable(bool checkable)\n", false, &_init_f_setCheckable_864, &_call_f_setCheckable_864);
  methods += new qt_gsi::GenericMethod ("setChild", "@brief Method void QStandardItem::setChild(int row, int column, QStandardItem *item)\n", false, &_init_f_setChild_3237, &_call_f_setChild_3237);
  methods += new qt_gsi::GenericMethod ("setChild", "@brief Method void QStandardItem::setChild(int row, QStandardItem *item)\n", false, &_init_f_setChild_2578, &_call_f_setChild_2578);
  methods += new qt_gsi::GenericMethod ("setColumnCount|columnCount=", "@brief Method void QStandardItem::setColumnCount(int columns)\n", false, &_init_f_setColumnCount_767, &_call_f_setColumnCount_767);
  methods += new qt_gsi::GenericMethod ("setData", "@brief Method void QStandardItem::setData(const QVariant &value, int role)\n", false, &_init_f_setData_2778u1, &_call_f_setData_2778u1);
  methods += new qt_gsi::GenericMethod ("setDragEnabled|dragEnabled=", "@brief Method void QStandardItem::setDragEnabled(bool dragEnabled)\n", false, &_init_f_setDragEnabled_864, &_call_f_setDragEnabled_864);
  methods += new qt_gsi::GenericMethod ("setDropEnabled|dropEnabled=", "@brief Method void QStandardItem::setDropEnabled(bool dropEnabled)\n", false, &_init_f_setDropEnabled_864, &_call_f_setDropEnabled_864);
  methods += new qt_gsi::GenericMethod ("setEditable|editable=", "@brief Method void QStandardItem::setEditable(bool editable)\n", false, &_init_f_setEditable_864, &_call_f_setEditable_864);
  methods += new qt_gsi::GenericMethod ("setEnabled|enabled=", "@brief Method void QStandardItem::setEnabled(bool enabled)\n", false, &_init_f_setEnabled_864, &_call_f_setEnabled_864);
  methods += new qt_gsi::GenericMethod ("setFlags|flags=", "@brief Method void QStandardItem::setFlags(QFlags<Qt::ItemFlag> flags)\n", false, &_init_f_setFlags_2222, &_call_f_setFlags_2222);
  methods += new qt_gsi::GenericMethod ("setFont|font=", "@brief Method void QStandardItem::setFont(const QFont &font)\n", false, &_init_f_setFont_1801, &_call_f_setFont_1801);
  methods += new qt_gsi::GenericMethod ("setForeground|foreground=", "@brief Method void QStandardItem::setForeground(const QBrush &brush)\n", false, &_init_f_setForeground_1910, &_call_f_setForeground_1910);
  methods += new qt_gsi::GenericMethod ("setIcon|icon=", "@brief Method void QStandardItem::setIcon(const QIcon &icon)\n", false, &_init_f_setIcon_1787, &_call_f_setIcon_1787);
  methods += new qt_gsi::GenericMethod ("setRowCount|rowCount=", "@brief Method void QStandardItem::setRowCount(int rows)\n", false, &_init_f_setRowCount_767, &_call_f_setRowCount_767);
  methods += new qt_gsi::GenericMethod ("setSelectable|selectable=", "@brief Method void QStandardItem::setSelectable(bool selectable)\n", false, &_init_f_setSelectable_864, &_call_f_setSelectable_864);
  methods += new qt_gsi::GenericMethod ("setSizeHint|sizeHint=", "@brief Method void QStandardItem::setSizeHint(const QSize &sizeHint)\n", false, &_init_f_setSizeHint_1805, &_call_f_setSizeHint_1805);
  methods += new qt_gsi::GenericMethod ("setStatusTip|statusTip=", "@brief Method void QStandardItem::setStatusTip(const QString &statusTip)\n", false, &_init_f_setStatusTip_2025, &_call_f_setStatusTip_2025);
  methods += new qt_gsi::GenericMethod ("setText|text=", "@brief Method void QStandardItem::setText(const QString &text)\n", false, &_init_f_setText_2025, &_call_f_setText_2025);
  methods += new qt_gsi::GenericMethod ("setTextAlignment|textAlignment=", "@brief Method void QStandardItem::setTextAlignment(QFlags<Qt::AlignmentFlag> textAlignment)\n", false, &_init_f_setTextAlignment_2750, &_call_f_setTextAlignment_2750);
  methods += new qt_gsi::GenericMethod ("setToolTip|toolTip=", "@brief Method void QStandardItem::setToolTip(const QString &toolTip)\n", false, &_init_f_setToolTip_2025, &_call_f_setToolTip_2025);
  methods += new qt_gsi::GenericMethod ("setTristate|tristate=", "@brief Method void QStandardItem::setTristate(bool tristate)\n", false, &_init_f_setTristate_864, &_call_f_setTristate_864);
  methods += new qt_gsi::GenericMethod ("setWhatsThis|whatsThis=", "@brief Method void QStandardItem::setWhatsThis(const QString &whatsThis)\n", false, &_init_f_setWhatsThis_2025, &_call_f_setWhatsThis_2025);
  methods += new qt_gsi::GenericMethod (":sizeHint", "@brief Method QSize QStandardItem::sizeHint()\n", true, &_init_f_sizeHint_c0, &_call_f_sizeHint_c0);
  methods += new qt_gsi::GenericMethod ("sortChildren", "@brief Method void QStandardItem::sortChildren(int column, Qt::SortOrder order)\n", false, &_init_f_sortChildren_2340, &_call_f_sortChildren_2340);
  methods += new qt_gsi::GenericMethod (":statusTip", "@brief Method QString QStandardItem::statusTip()\n", true, &_init_f_statusTip_c0, &_call_f_statusTip_c0);
  methods += new qt_gsi::GenericMethod ("takeChild", "@brief Method QStandardItem *QStandardItem::takeChild(int row, int column)\n", false, &_init_f_takeChild_1426, &_call_f_takeChild_1426);
  methods += new qt_gsi::GenericMethod ("takeColumn", "@brief Method QList<QStandardItem*> QStandardItem::takeColumn(int column)\n", false, &_init_f_takeColumn_767, &_call_f_takeColumn_767);
  methods += new qt_gsi::GenericMethod ("takeRow", "@brief Method QList<QStandardItem*> QStandardItem::takeRow(int row)\n", false, &_init_f_takeRow_767, &_call_f_takeRow_767);
  methods += new qt_gsi::GenericMethod (":text", "@brief Method QString QStandardItem::text()\n", true, &_init_f_text_c0, &_call_f_text_c0);
  methods += new qt_gsi::GenericMethod (":textAlignment", "@brief Method QFlags<Qt::AlignmentFlag> QStandardItem::textAlignment()\n", true, &_init_f_textAlignment_c0, &_call_f_textAlignment_c0);
  methods += new qt_gsi::GenericMethod (":toolTip", "@brief Method QString QStandardItem::toolTip()\n", true, &_init_f_toolTip_c0, &_call_f_toolTip_c0);
  methods += new qt_gsi::GenericMethod ("type", "@brief Method int QStandardItem::type()\n", true, &_init_f_type_c0, &_call_f_type_c0);
  methods += new qt_gsi::GenericMethod (":whatsThis", "@brief Method QString QStandardItem::whatsThis()\n", true, &_init_f_whatsThis_c0, &_call_f_whatsThis_c0);
  methods += new qt_gsi::GenericMethod ("write", "@brief Method void QStandardItem::write(QDataStream &out)\n", true, &_init_f_write_c1697, &_call_f_write_c1697);
  return methods;
}

gsi::Class<QStandardItem> decl_QStandardItem ("QtGui", "QStandardItem_Native",
  methods_QStandardItem (),
  "@hide\n@alias QStandardItem");

GSI_QTGUI_PUBLIC gsi::Class<QStandardItem> &qtdecl_QStandardItem () { return decl_QStandardItem; }

}


class QStandardItem_Adaptor : public QStandardItem, public qt_gsi::QtObjectBase
{
public:

  virtual ~QStandardItem_Adaptor();

  //  [adaptor ctor] QStandardItem::QStandardItem()
  QStandardItem_Adaptor() : QStandardItem()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QStandardItem::QStandardItem(const QString &text)
  QStandardItem_Adaptor(const QString &text) : QStandardItem(text)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QStandardItem::QStandardItem(const QIcon &icon, const QString &text)
  QStandardItem_Adaptor(const QIcon &icon, const QString &text) : QStandardItem(icon, text)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QStandardItem::QStandardItem(int rows, int columns)
  QStandardItem_Adaptor(int rows) : QStandardItem(rows)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QStandardItem::QStandardItem(int rows, int columns)
  QStandardItem_Adaptor(int rows, int columns) : QStandardItem(rows, columns)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QStandardItem::emitDataChanged()
  void fp_QStandardItem_emitDataChanged_0 () {
    QStandardItem::emitDataChanged();
  }

  //  [expose] QStandardItem &QStandardItem::operator=(const QStandardItem &other)
  QStandardItem & fp_QStandardItem_operator_eq__2610 (const QStandardItem &other) {
    return QStandardItem::operator=(other);
  }

  //  [adaptor impl] QStandardItem *QStandardItem::clone()
  QStandardItem * cbs_clone_c0_0() const
  {
    return QStandardItem::clone();
  }

  virtual QStandardItem * clone() const
  {
    if (cb_clone_c0_0.can_issue()) {
      return cb_clone_c0_0.issue<QStandardItem_Adaptor, QStandardItem *>(&QStandardItem_Adaptor::cbs_clone_c0_0);
    } else {
      return QStandardItem::clone();
    }
  }

  //  [adaptor impl] QVariant QStandardItem::data(int role)
  QVariant cbs_data_c767_1(int role) const
  {
    return QStandardItem::data(role);
  }

  virtual QVariant data(int role) const
  {
    if (cb_data_c767_1.can_issue()) {
      return cb_data_c767_1.issue<QStandardItem_Adaptor, QVariant, int>(&QStandardItem_Adaptor::cbs_data_c767_1, role);
    } else {
      return QStandardItem::data(role);
    }
  }

  //  [adaptor impl] bool QStandardItem::operator<(const QStandardItem &other)
  bool cbs_operator_lt__c2610_0(const QStandardItem &other) const
  {
    return QStandardItem::operator<(other);
  }

  virtual bool operator<(const QStandardItem &other) const
  {
    if (cb_operator_lt__c2610_0.can_issue()) {
      return cb_operator_lt__c2610_0.issue<QStandardItem_Adaptor, bool, const QStandardItem &>(&QStandardItem_Adaptor::cbs_operator_lt__c2610_0, other);
    } else {
      return QStandardItem::operator<(other);
    }
  }

  //  [adaptor impl] void QStandardItem::read(QDataStream &in)
  void cbs_read_1697_0(QDataStream &in)
  {
    QStandardItem::read(in);
  }

  virtual void read(QDataStream &in)
  {
    if (cb_read_1697_0.can_issue()) {
      cb_read_1697_0.issue<QStandardItem_Adaptor, QDataStream &>(&QStandardItem_Adaptor::cbs_read_1697_0, in);
    } else {
      QStandardItem::read(in);
    }
  }

  //  [adaptor impl] void QStandardItem::setData(const QVariant &value, int role)
  void cbs_setData_2778u1_1(const QVariant &value, int role)
  {
    QStandardItem::setData(value, role);
  }

  virtual void setData(const QVariant &value, int role)
  {
    if (cb_setData_2778u1_1.can_issue()) {
      cb_setData_2778u1_1.issue<QStandardItem_Adaptor, const QVariant &, int>(&QStandardItem_Adaptor::cbs_setData_2778u1_1, value, role);
    } else {
      QStandardItem::setData(value, role);
    }
  }

  //  [adaptor impl] int QStandardItem::type()
  int cbs_type_c0_0() const
  {
    return QStandardItem::type();
  }

  virtual int type() const
  {
    if (cb_type_c0_0.can_issue()) {
      return cb_type_c0_0.issue<QStandardItem_Adaptor, int>(&QStandardItem_Adaptor::cbs_type_c0_0);
    } else {
      return QStandardItem::type();
    }
  }

  //  [adaptor impl] void QStandardItem::write(QDataStream &out)
  void cbs_write_c1697_0(QDataStream &out) const
  {
    QStandardItem::write(out);
  }

  virtual void write(QDataStream &out) const
  {
    if (cb_write_c1697_0.can_issue()) {
      cb_write_c1697_0.issue<QStandardItem_Adaptor, QDataStream &>(&QStandardItem_Adaptor::cbs_write_c1697_0, out);
    } else {
      QStandardItem::write(out);
    }
  }

  gsi::Callback cb_clone_c0_0;
  gsi::Callback cb_data_c767_1;
  gsi::Callback cb_operator_lt__c2610_0;
  gsi::Callback cb_read_1697_0;
  gsi::Callback cb_setData_2778u1_1;
  gsi::Callback cb_type_c0_0;
  gsi::Callback cb_write_c1697_0;
};

QStandardItem_Adaptor::~QStandardItem_Adaptor() { }

//  Constructor QStandardItem::QStandardItem() (adaptor class)

static void _init_ctor_QStandardItem_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QStandardItem_Adaptor> ();
}

static void _call_ctor_QStandardItem_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStandardItem_Adaptor *> (new QStandardItem_Adaptor ());
}


//  Constructor QStandardItem::QStandardItem(const QString &text) (adaptor class)

static void _init_ctor_QStandardItem_Adaptor_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return_new<QStandardItem_Adaptor> ();
}

static void _call_ctor_QStandardItem_Adaptor_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QStandardItem_Adaptor *> (new QStandardItem_Adaptor (arg1));
}


//  Constructor QStandardItem::QStandardItem(const QIcon &icon, const QString &text) (adaptor class)

static void _init_ctor_QStandardItem_Adaptor_3704 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("text");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return_new<QStandardItem_Adaptor> ();
}

static void _call_ctor_QStandardItem_Adaptor_3704 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QIcon &arg1 = gsi::arg_reader<const QIcon & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QStandardItem_Adaptor *> (new QStandardItem_Adaptor (arg1, arg2));
}


//  Constructor QStandardItem::QStandardItem(int rows, int columns) (adaptor class)

static void _init_ctor_QStandardItem_Adaptor_1426 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rows");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("columns", true, "1");
  decl->add_arg<int > (argspec_1);
  decl->set_return_new<QStandardItem_Adaptor> ();
}

static void _call_ctor_QStandardItem_Adaptor_1426 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (1, heap);
  ret.write<QStandardItem_Adaptor *> (new QStandardItem_Adaptor (arg1, arg2));
}


// QStandardItem *QStandardItem::clone()

static void _init_cbs_clone_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStandardItem * > ();
}

static void _call_cbs_clone_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStandardItem * > ((QStandardItem *)((QStandardItem_Adaptor *)cls)->cbs_clone_c0_0 ());
}

static void _set_callback_cbs_clone_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItem_Adaptor *)cls)->cb_clone_c0_0 = cb;
}


// QVariant QStandardItem::data(int role)

static void _init_cbs_data_c767_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("role");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_data_c767_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<QVariant > ((QVariant)((QStandardItem_Adaptor *)cls)->cbs_data_c767_1 (arg1));
}

static void _set_callback_cbs_data_c767_1 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItem_Adaptor *)cls)->cb_data_c767_1 = cb;
}


// exposed void QStandardItem::emitDataChanged()

static void _init_fp_emitDataChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_emitDataChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem_Adaptor *)cls)->fp_QStandardItem_emitDataChanged_0 ();
}


// bool QStandardItem::operator<(const QStandardItem &other)

static void _init_cbs_operator_lt__c2610_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QStandardItem & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_operator_lt__c2610_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStandardItem &arg1 = args.read<const QStandardItem & > (heap);
  ret.write<bool > ((bool)((QStandardItem_Adaptor *)cls)->cbs_operator_lt__c2610_0 (arg1));
}

static void _set_callback_cbs_operator_lt__c2610_0 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItem_Adaptor *)cls)->cb_operator_lt__c2610_0 = cb;
}


// exposed QStandardItem &QStandardItem::operator=(const QStandardItem &other)

static void _init_fp_operator_eq__2610 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QStandardItem & > (argspec_0);
  decl->set_return<QStandardItem & > ();
}

static void _call_fp_operator_eq__2610 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStandardItem &arg1 = gsi::arg_reader<const QStandardItem & >() (args, heap);
  ret.write<QStandardItem & > ((QStandardItem &)((QStandardItem_Adaptor *)cls)->fp_QStandardItem_operator_eq__2610 (arg1));
}


// void QStandardItem::read(QDataStream &in)

static void _init_cbs_read_1697_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("in");
  decl->add_arg<QDataStream & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_read_1697_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDataStream &arg1 = args.read<QDataStream & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem_Adaptor *)cls)->cbs_read_1697_0 (arg1);
}

static void _set_callback_cbs_read_1697_0 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItem_Adaptor *)cls)->cb_read_1697_0 = cb;
}


// void QStandardItem::setData(const QVariant &value, int role)

static void _init_cbs_setData_2778u1_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<const QVariant & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setData_2778u1_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVariant &arg1 = args.read<const QVariant & > (heap);
  int arg2 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem_Adaptor *)cls)->cbs_setData_2778u1_1 (arg1, arg2);
}

static void _set_callback_cbs_setData_2778u1_1 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItem_Adaptor *)cls)->cb_setData_2778u1_1 = cb;
}


// int QStandardItem::type()

static void _init_cbs_type_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_type_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QStandardItem_Adaptor *)cls)->cbs_type_c0_0 ());
}

static void _set_callback_cbs_type_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItem_Adaptor *)cls)->cb_type_c0_0 = cb;
}


// void QStandardItem::write(QDataStream &out)

static void _init_cbs_write_c1697_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("out");
  decl->add_arg<QDataStream & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_write_c1697_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDataStream &arg1 = args.read<QDataStream & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStandardItem_Adaptor *)cls)->cbs_write_c1697_0 (arg1);
}

static void _set_callback_cbs_write_c1697_0 (void *cls, const gsi::Callback &cb)
{
  ((QStandardItem_Adaptor *)cls)->cb_write_c1697_0 = cb;
}


namespace gsi
{

gsi::Class<QStandardItem> &qtdecl_QStandardItem ();

static gsi::Methods methods_QStandardItem_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QStandardItem::QStandardItem()\nThis method creates an object of class QStandardItem.", &_init_ctor_QStandardItem_Adaptor_0, &_call_ctor_QStandardItem_Adaptor_0);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QStandardItem::QStandardItem(const QString &text)\nThis method creates an object of class QStandardItem.", &_init_ctor_QStandardItem_Adaptor_2025, &_call_ctor_QStandardItem_Adaptor_2025);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QStandardItem::QStandardItem(const QIcon &icon, const QString &text)\nThis method creates an object of class QStandardItem.", &_init_ctor_QStandardItem_Adaptor_3704, &_call_ctor_QStandardItem_Adaptor_3704);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QStandardItem::QStandardItem(int rows, int columns)\nThis method creates an object of class QStandardItem.", &_init_ctor_QStandardItem_Adaptor_1426, &_call_ctor_QStandardItem_Adaptor_1426);
  methods += new qt_gsi::GenericMethod ("clone", "@brief Virtual method QStandardItem *QStandardItem::clone()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_clone_c0_0, &_call_cbs_clone_c0_0);
  methods += new qt_gsi::GenericMethod ("clone", "@hide", true, &_init_cbs_clone_c0_0, &_call_cbs_clone_c0_0, &_set_callback_cbs_clone_c0_0);
  methods += new qt_gsi::GenericMethod ("data", "@brief Virtual method QVariant QStandardItem::data(int role)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_data_c767_1, &_call_cbs_data_c767_1);
  methods += new qt_gsi::GenericMethod ("data", "@hide", true, &_init_cbs_data_c767_1, &_call_cbs_data_c767_1, &_set_callback_cbs_data_c767_1);
  methods += new qt_gsi::GenericMethod ("*emitDataChanged", "@brief Method void QStandardItem::emitDataChanged()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_emitDataChanged_0, &_call_fp_emitDataChanged_0);
  methods += new qt_gsi::GenericMethod ("<", "@brief Virtual method bool QStandardItem::operator<(const QStandardItem &other)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_operator_lt__c2610_0, &_call_cbs_operator_lt__c2610_0);
  methods += new qt_gsi::GenericMethod ("<", "@hide", true, &_init_cbs_operator_lt__c2610_0, &_call_cbs_operator_lt__c2610_0, &_set_callback_cbs_operator_lt__c2610_0);
  methods += new qt_gsi::GenericMethod ("*assign", "@brief Method QStandardItem &QStandardItem::operator=(const QStandardItem &other)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_operator_eq__2610, &_call_fp_operator_eq__2610);
  methods += new qt_gsi::GenericMethod ("read", "@brief Virtual method void QStandardItem::read(QDataStream &in)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_read_1697_0, &_call_cbs_read_1697_0);
  methods += new qt_gsi::GenericMethod ("read", "@hide", false, &_init_cbs_read_1697_0, &_call_cbs_read_1697_0, &_set_callback_cbs_read_1697_0);
  methods += new qt_gsi::GenericMethod ("setData", "@brief Virtual method void QStandardItem::setData(const QVariant &value, int role)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setData_2778u1_1, &_call_cbs_setData_2778u1_1);
  methods += new qt_gsi::GenericMethod ("setData", "@hide", false, &_init_cbs_setData_2778u1_1, &_call_cbs_setData_2778u1_1, &_set_callback_cbs_setData_2778u1_1);
  methods += new qt_gsi::GenericMethod ("type", "@brief Virtual method int QStandardItem::type()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_type_c0_0, &_call_cbs_type_c0_0);
  methods += new qt_gsi::GenericMethod ("type", "@hide", true, &_init_cbs_type_c0_0, &_call_cbs_type_c0_0, &_set_callback_cbs_type_c0_0);
  methods += new qt_gsi::GenericMethod ("write", "@brief Virtual method void QStandardItem::write(QDataStream &out)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_write_c1697_0, &_call_cbs_write_c1697_0);
  methods += new qt_gsi::GenericMethod ("write", "@hide", true, &_init_cbs_write_c1697_0, &_call_cbs_write_c1697_0, &_set_callback_cbs_write_c1697_0);
  return methods;
}

gsi::Class<QStandardItem_Adaptor> decl_QStandardItem_Adaptor (qtdecl_QStandardItem (), "QtGui", "QStandardItem",
  methods_QStandardItem_Adaptor (),
  "@qt\n@brief Binding of QStandardItem");

}

