
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2021 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQFileDevice.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QFileDevice>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include "gsiDeclQtCoreTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QFileDevice

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QFileDevice::staticMetaObject);
}


// bool QFileDevice::atEnd()


static void _init_f_atEnd_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_atEnd_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QFileDevice *)cls)->atEnd ());
}


// void QFileDevice::close()


static void _init_f_close_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_close_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDevice *)cls)->close ();
}


// QFileDevice::FileError QFileDevice::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFileDevice::FileError>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QFileDevice::FileError>::target_type > ((qt_gsi::Converter<QFileDevice::FileError>::target_type)qt_gsi::CppToQtAdaptor<QFileDevice::FileError>(((QFileDevice *)cls)->error ()));
}


// QString QFileDevice::fileName()


static void _init_f_fileName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_fileName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QFileDevice *)cls)->fileName ());
}


// bool QFileDevice::flush()


static void _init_f_flush_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_flush_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QFileDevice *)cls)->flush ());
}


// int QFileDevice::handle()


static void _init_f_handle_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_handle_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QFileDevice *)cls)->handle ());
}


// bool QFileDevice::isSequential()


static void _init_f_isSequential_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSequential_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QFileDevice *)cls)->isSequential ());
}


// QFlags<QFileDevice::Permission> QFileDevice::permissions()


static void _init_f_permissions_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QFileDevice::Permission> > ();
}

static void _call_f_permissions_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QFileDevice::Permission> > ((QFlags<QFileDevice::Permission>)((QFileDevice *)cls)->permissions ());
}


// qint64 QFileDevice::pos()


static void _init_f_pos_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_pos_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QFileDevice *)cls)->pos ());
}


// bool QFileDevice::resize(qint64 sz)


static void _init_f_resize_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sz");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_resize_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  ret.write<bool > ((bool)((QFileDevice *)cls)->resize (arg1));
}


// bool QFileDevice::seek(qint64 offset)


static void _init_f_seek_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_seek_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  ret.write<bool > ((bool)((QFileDevice *)cls)->seek (arg1));
}


// bool QFileDevice::setPermissions(QFlags<QFileDevice::Permission> permissionSpec)


static void _init_f_setPermissions_3370 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("permissionSpec");
  decl->add_arg<QFlags<QFileDevice::Permission> > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_setPermissions_3370 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QFileDevice::Permission> arg1 = gsi::arg_reader<QFlags<QFileDevice::Permission> >() (args, heap);
  ret.write<bool > ((bool)((QFileDevice *)cls)->setPermissions (arg1));
}


// qint64 QFileDevice::size()


static void _init_f_size_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_size_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QFileDevice *)cls)->size ());
}


// void QFileDevice::unsetError()


static void _init_f_unsetError_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_unsetError_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDevice *)cls)->unsetError ();
}


// static QString QFileDevice::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QFileDevice::tr (arg1, arg2, arg3));
}


// static QString QFileDevice::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QFileDevice::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QFileDevice () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("atEnd", "@brief Method bool QFileDevice::atEnd()\nThis is a reimplementation of QIODevice::atEnd", true, &_init_f_atEnd_c0, &_call_f_atEnd_c0);
  methods += new qt_gsi::GenericMethod ("close", "@brief Method void QFileDevice::close()\nThis is a reimplementation of QIODevice::close", false, &_init_f_close_0, &_call_f_close_0);
  methods += new qt_gsi::GenericMethod ("error", "@brief Method QFileDevice::FileError QFileDevice::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
  methods += new qt_gsi::GenericMethod ("fileName", "@brief Method QString QFileDevice::fileName()\n", true, &_init_f_fileName_c0, &_call_f_fileName_c0);
  methods += new qt_gsi::GenericMethod ("flush", "@brief Method bool QFileDevice::flush()\n", false, &_init_f_flush_0, &_call_f_flush_0);
  methods += new qt_gsi::GenericMethod ("handle", "@brief Method int QFileDevice::handle()\n", true, &_init_f_handle_c0, &_call_f_handle_c0);
  methods += new qt_gsi::GenericMethod ("isSequential?", "@brief Method bool QFileDevice::isSequential()\nThis is a reimplementation of QIODevice::isSequential", true, &_init_f_isSequential_c0, &_call_f_isSequential_c0);
  methods += new qt_gsi::GenericMethod ("permissions", "@brief Method QFlags<QFileDevice::Permission> QFileDevice::permissions()\n", true, &_init_f_permissions_c0, &_call_f_permissions_c0);
  methods += new qt_gsi::GenericMethod ("pos", "@brief Method qint64 QFileDevice::pos()\nThis is a reimplementation of QIODevice::pos", true, &_init_f_pos_c0, &_call_f_pos_c0);
  methods += new qt_gsi::GenericMethod ("resize", "@brief Method bool QFileDevice::resize(qint64 sz)\n", false, &_init_f_resize_986, &_call_f_resize_986);
  methods += new qt_gsi::GenericMethod ("seek", "@brief Method bool QFileDevice::seek(qint64 offset)\nThis is a reimplementation of QIODevice::seek", false, &_init_f_seek_986, &_call_f_seek_986);
  methods += new qt_gsi::GenericMethod ("setPermissions", "@brief Method bool QFileDevice::setPermissions(QFlags<QFileDevice::Permission> permissionSpec)\n", false, &_init_f_setPermissions_3370, &_call_f_setPermissions_3370);
  methods += new qt_gsi::GenericMethod ("size", "@brief Method qint64 QFileDevice::size()\nThis is a reimplementation of QIODevice::size", true, &_init_f_size_c0, &_call_f_size_c0);
  methods += new qt_gsi::GenericMethod ("unsetError", "@brief Method void QFileDevice::unsetError()\n", false, &_init_f_unsetError_0, &_call_f_unsetError_0);
  methods += gsi::qt_signal ("aboutToClose()", "aboutToClose", "@brief Signal declaration for QFileDevice::aboutToClose()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<qint64 > ("bytesWritten(qint64)", "bytesWritten", gsi::arg("bytes"), "@brief Signal declaration for QFileDevice::bytesWritten(qint64 bytes)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QFileDevice::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QFileDevice::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("readChannelFinished()", "readChannelFinished", "@brief Signal declaration for QFileDevice::readChannelFinished()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("readyRead()", "readyRead", "@brief Signal declaration for QFileDevice::readyRead()\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QFileDevice::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QFileDevice::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QIODevice> &qtdecl_QIODevice ();

qt_gsi::QtNativeClass<QFileDevice> decl_QFileDevice (qtdecl_QIODevice (), "QtCore", "QFileDevice_Native",
  methods_QFileDevice (),
  "@hide\n@alias QFileDevice");

GSI_QTCORE_PUBLIC gsi::Class<QFileDevice> &qtdecl_QFileDevice () { return decl_QFileDevice; }

}


class QFileDevice_Adaptor : public QFileDevice, public qt_gsi::QtObjectBase
{
public:

  virtual ~QFileDevice_Adaptor();

  //  [expose] bool QFileDevice::isSignalConnected(const QMetaMethod &signal)
  bool fp_QFileDevice_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QFileDevice::isSignalConnected(signal);
  }

  //  [expose] int QFileDevice::receivers(const char *signal)
  int fp_QFileDevice_receivers_c1731 (const char *signal) const {
    return QFileDevice::receivers(signal);
  }

  //  [expose] QObject *QFileDevice::sender()
  QObject * fp_QFileDevice_sender_c0 () const {
    return QFileDevice::sender();
  }

  //  [expose] int QFileDevice::senderSignalIndex()
  int fp_QFileDevice_senderSignalIndex_c0 () const {
    return QFileDevice::senderSignalIndex();
  }

  //  [expose] void QFileDevice::setErrorString(const QString &errorString)
  void fp_QFileDevice_setErrorString_2025 (const QString &errorString) {
    QFileDevice::setErrorString(errorString);
  }

  //  [expose] void QFileDevice::setOpenMode(QFlags<QIODevice::OpenModeFlag> openMode)
  void fp_QFileDevice_setOpenMode_3242 (QFlags<QIODevice::OpenModeFlag> openMode) {
    QFileDevice::setOpenMode(openMode);
  }

  //  [emitter impl] void QFileDevice::aboutToClose()
  void emitter_QFileDevice_aboutToClose_0()
  {
    emit QFileDevice::aboutToClose();
  }

  //  [adaptor impl] bool QFileDevice::atEnd()
  bool cbs_atEnd_c0_0() const
  {
    return QFileDevice::atEnd();
  }

  virtual bool atEnd() const
  {
    if (cb_atEnd_c0_0.can_issue()) {
      return cb_atEnd_c0_0.issue<QFileDevice_Adaptor, bool>(&QFileDevice_Adaptor::cbs_atEnd_c0_0);
    } else {
      return QFileDevice::atEnd();
    }
  }

  //  [adaptor impl] qint64 QFileDevice::bytesAvailable()
  qint64 cbs_bytesAvailable_c0_0() const
  {
    return QFileDevice::bytesAvailable();
  }

  virtual qint64 bytesAvailable() const
  {
    if (cb_bytesAvailable_c0_0.can_issue()) {
      return cb_bytesAvailable_c0_0.issue<QFileDevice_Adaptor, qint64>(&QFileDevice_Adaptor::cbs_bytesAvailable_c0_0);
    } else {
      return QFileDevice::bytesAvailable();
    }
  }

  //  [adaptor impl] qint64 QFileDevice::bytesToWrite()
  qint64 cbs_bytesToWrite_c0_0() const
  {
    return QFileDevice::bytesToWrite();
  }

  virtual qint64 bytesToWrite() const
  {
    if (cb_bytesToWrite_c0_0.can_issue()) {
      return cb_bytesToWrite_c0_0.issue<QFileDevice_Adaptor, qint64>(&QFileDevice_Adaptor::cbs_bytesToWrite_c0_0);
    } else {
      return QFileDevice::bytesToWrite();
    }
  }

  //  [emitter impl] void QFileDevice::bytesWritten(qint64 bytes)
  void emitter_QFileDevice_bytesWritten_986(qint64 bytes)
  {
    emit QFileDevice::bytesWritten(bytes);
  }

  //  [adaptor impl] bool QFileDevice::canReadLine()
  bool cbs_canReadLine_c0_0() const
  {
    return QFileDevice::canReadLine();
  }

  virtual bool canReadLine() const
  {
    if (cb_canReadLine_c0_0.can_issue()) {
      return cb_canReadLine_c0_0.issue<QFileDevice_Adaptor, bool>(&QFileDevice_Adaptor::cbs_canReadLine_c0_0);
    } else {
      return QFileDevice::canReadLine();
    }
  }

  //  [adaptor impl] void QFileDevice::close()
  void cbs_close_0_0()
  {
    QFileDevice::close();
  }

  virtual void close()
  {
    if (cb_close_0_0.can_issue()) {
      cb_close_0_0.issue<QFileDevice_Adaptor>(&QFileDevice_Adaptor::cbs_close_0_0);
    } else {
      QFileDevice::close();
    }
  }

  //  [emitter impl] void QFileDevice::destroyed(QObject *)
  void emitter_QFileDevice_destroyed_1302(QObject *arg1)
  {
    emit QFileDevice::destroyed(arg1);
  }

  //  [adaptor impl] bool QFileDevice::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QFileDevice::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QFileDevice_Adaptor, bool, QEvent *>(&QFileDevice_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QFileDevice::event(arg1);
    }
  }

  //  [adaptor impl] bool QFileDevice::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QFileDevice::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QFileDevice_Adaptor, bool, QObject *, QEvent *>(&QFileDevice_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QFileDevice::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] QString QFileDevice::fileName()
  QString cbs_fileName_c0_0() const
  {
    return QFileDevice::fileName();
  }

  virtual QString fileName() const
  {
    if (cb_fileName_c0_0.can_issue()) {
      return cb_fileName_c0_0.issue<QFileDevice_Adaptor, QString>(&QFileDevice_Adaptor::cbs_fileName_c0_0);
    } else {
      return QFileDevice::fileName();
    }
  }

  //  [adaptor impl] bool QFileDevice::isSequential()
  bool cbs_isSequential_c0_0() const
  {
    return QFileDevice::isSequential();
  }

  virtual bool isSequential() const
  {
    if (cb_isSequential_c0_0.can_issue()) {
      return cb_isSequential_c0_0.issue<QFileDevice_Adaptor, bool>(&QFileDevice_Adaptor::cbs_isSequential_c0_0);
    } else {
      return QFileDevice::isSequential();
    }
  }

  //  [emitter impl] void QFileDevice::objectNameChanged(const QString &objectName)
  void emitter_QFileDevice_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QFileDevice::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] bool QFileDevice::open(QFlags<QIODevice::OpenModeFlag> mode)
  bool cbs_open_3242_0(QFlags<QIODevice::OpenModeFlag> mode)
  {
    return QFileDevice::open(mode);
  }

  virtual bool open(QFlags<QIODevice::OpenModeFlag> mode)
  {
    if (cb_open_3242_0.can_issue()) {
      return cb_open_3242_0.issue<QFileDevice_Adaptor, bool, QFlags<QIODevice::OpenModeFlag> >(&QFileDevice_Adaptor::cbs_open_3242_0, mode);
    } else {
      return QFileDevice::open(mode);
    }
  }

  //  [adaptor impl] QFlags<QFileDevice::Permission> QFileDevice::permissions()
  QFlags<QFileDevice::Permission> cbs_permissions_c0_0() const
  {
    return QFileDevice::permissions();
  }

  virtual QFlags<QFileDevice::Permission> permissions() const
  {
    if (cb_permissions_c0_0.can_issue()) {
      return cb_permissions_c0_0.issue<QFileDevice_Adaptor, QFlags<QFileDevice::Permission> >(&QFileDevice_Adaptor::cbs_permissions_c0_0);
    } else {
      return QFileDevice::permissions();
    }
  }

  //  [adaptor impl] qint64 QFileDevice::pos()
  qint64 cbs_pos_c0_0() const
  {
    return QFileDevice::pos();
  }

  virtual qint64 pos() const
  {
    if (cb_pos_c0_0.can_issue()) {
      return cb_pos_c0_0.issue<QFileDevice_Adaptor, qint64>(&QFileDevice_Adaptor::cbs_pos_c0_0);
    } else {
      return QFileDevice::pos();
    }
  }

  //  [emitter impl] void QFileDevice::readChannelFinished()
  void emitter_QFileDevice_readChannelFinished_0()
  {
    emit QFileDevice::readChannelFinished();
  }

  //  [emitter impl] void QFileDevice::readyRead()
  void emitter_QFileDevice_readyRead_0()
  {
    emit QFileDevice::readyRead();
  }

  //  [adaptor impl] bool QFileDevice::reset()
  bool cbs_reset_0_0()
  {
    return QFileDevice::reset();
  }

  virtual bool reset()
  {
    if (cb_reset_0_0.can_issue()) {
      return cb_reset_0_0.issue<QFileDevice_Adaptor, bool>(&QFileDevice_Adaptor::cbs_reset_0_0);
    } else {
      return QFileDevice::reset();
    }
  }

  //  [adaptor impl] bool QFileDevice::resize(qint64 sz)
  bool cbs_resize_986_0(qint64 sz)
  {
    return QFileDevice::resize(sz);
  }

  virtual bool resize(qint64 sz)
  {
    if (cb_resize_986_0.can_issue()) {
      return cb_resize_986_0.issue<QFileDevice_Adaptor, bool, qint64>(&QFileDevice_Adaptor::cbs_resize_986_0, sz);
    } else {
      return QFileDevice::resize(sz);
    }
  }

  //  [adaptor impl] bool QFileDevice::seek(qint64 offset)
  bool cbs_seek_986_0(qint64 offset)
  {
    return QFileDevice::seek(offset);
  }

  virtual bool seek(qint64 offset)
  {
    if (cb_seek_986_0.can_issue()) {
      return cb_seek_986_0.issue<QFileDevice_Adaptor, bool, qint64>(&QFileDevice_Adaptor::cbs_seek_986_0, offset);
    } else {
      return QFileDevice::seek(offset);
    }
  }

  //  [adaptor impl] bool QFileDevice::setPermissions(QFlags<QFileDevice::Permission> permissionSpec)
  bool cbs_setPermissions_3370_0(QFlags<QFileDevice::Permission> permissionSpec)
  {
    return QFileDevice::setPermissions(permissionSpec);
  }

  virtual bool setPermissions(QFlags<QFileDevice::Permission> permissionSpec)
  {
    if (cb_setPermissions_3370_0.can_issue()) {
      return cb_setPermissions_3370_0.issue<QFileDevice_Adaptor, bool, QFlags<QFileDevice::Permission> >(&QFileDevice_Adaptor::cbs_setPermissions_3370_0, permissionSpec);
    } else {
      return QFileDevice::setPermissions(permissionSpec);
    }
  }

  //  [adaptor impl] qint64 QFileDevice::size()
  qint64 cbs_size_c0_0() const
  {
    return QFileDevice::size();
  }

  virtual qint64 size() const
  {
    if (cb_size_c0_0.can_issue()) {
      return cb_size_c0_0.issue<QFileDevice_Adaptor, qint64>(&QFileDevice_Adaptor::cbs_size_c0_0);
    } else {
      return QFileDevice::size();
    }
  }

  //  [adaptor impl] bool QFileDevice::waitForBytesWritten(int msecs)
  bool cbs_waitForBytesWritten_767_0(int msecs)
  {
    return QFileDevice::waitForBytesWritten(msecs);
  }

  virtual bool waitForBytesWritten(int msecs)
  {
    if (cb_waitForBytesWritten_767_0.can_issue()) {
      return cb_waitForBytesWritten_767_0.issue<QFileDevice_Adaptor, bool, int>(&QFileDevice_Adaptor::cbs_waitForBytesWritten_767_0, msecs);
    } else {
      return QFileDevice::waitForBytesWritten(msecs);
    }
  }

  //  [adaptor impl] bool QFileDevice::waitForReadyRead(int msecs)
  bool cbs_waitForReadyRead_767_0(int msecs)
  {
    return QFileDevice::waitForReadyRead(msecs);
  }

  virtual bool waitForReadyRead(int msecs)
  {
    if (cb_waitForReadyRead_767_0.can_issue()) {
      return cb_waitForReadyRead_767_0.issue<QFileDevice_Adaptor, bool, int>(&QFileDevice_Adaptor::cbs_waitForReadyRead_767_0, msecs);
    } else {
      return QFileDevice::waitForReadyRead(msecs);
    }
  }

  //  [adaptor impl] void QFileDevice::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QFileDevice::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QFileDevice_Adaptor, QChildEvent *>(&QFileDevice_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QFileDevice::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDevice::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QFileDevice::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QFileDevice_Adaptor, QEvent *>(&QFileDevice_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QFileDevice::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDevice::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QFileDevice::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QFileDevice_Adaptor, const QMetaMethod &>(&QFileDevice_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QFileDevice::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QFileDevice::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QFileDevice::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QFileDevice_Adaptor, QTimerEvent *>(&QFileDevice_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QFileDevice::timerEvent(arg1);
    }
  }

  //  [adaptor impl] qint64 QFileDevice::writeData(const char *data, qint64 len)
  qint64 cbs_writeData_2609_0(const char *data, qint64 len)
  {
    return QFileDevice::writeData(data, len);
  }

  virtual qint64 writeData(const char *data, qint64 len)
  {
    if (cb_writeData_2609_0.can_issue()) {
      return cb_writeData_2609_0.issue<QFileDevice_Adaptor, qint64, const char *, qint64>(&QFileDevice_Adaptor::cbs_writeData_2609_0, data, len);
    } else {
      return QFileDevice::writeData(data, len);
    }
  }

  gsi::Callback cb_atEnd_c0_0;
  gsi::Callback cb_bytesAvailable_c0_0;
  gsi::Callback cb_bytesToWrite_c0_0;
  gsi::Callback cb_canReadLine_c0_0;
  gsi::Callback cb_close_0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_fileName_c0_0;
  gsi::Callback cb_isSequential_c0_0;
  gsi::Callback cb_open_3242_0;
  gsi::Callback cb_permissions_c0_0;
  gsi::Callback cb_pos_c0_0;
  gsi::Callback cb_reset_0_0;
  gsi::Callback cb_resize_986_0;
  gsi::Callback cb_seek_986_0;
  gsi::Callback cb_setPermissions_3370_0;
  gsi::Callback cb_size_c0_0;
  gsi::Callback cb_waitForBytesWritten_767_0;
  gsi::Callback cb_waitForReadyRead_767_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_writeData_2609_0;
};

QFileDevice_Adaptor::~QFileDevice_Adaptor() { }

// emitter void QFileDevice::aboutToClose()

static void _init_emitter_aboutToClose_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_aboutToClose_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QFileDevice_Adaptor *)cls)->emitter_QFileDevice_aboutToClose_0 ();
}


// bool QFileDevice::atEnd()

static void _init_cbs_atEnd_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_atEnd_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QFileDevice_Adaptor *)cls)->cbs_atEnd_c0_0 ());
}

static void _set_callback_cbs_atEnd_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDevice_Adaptor *)cls)->cb_atEnd_c0_0 = cb;
}


// qint64 QFileDevice::bytesAvailable()

static void _init_cbs_bytesAvailable_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_cbs_bytesAvailable_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QFileDevice_Adaptor *)cls)->cbs_bytesAvailable_c0_0 ());
}

static void _set_callback_cbs_bytesAvailable_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDevice_Adaptor *)cls)->cb_bytesAvailable_c0_0 = cb;
}


// qint64 QFileDevice::bytesToWrite()

static void _init_cbs_bytesToWrite_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_cbs_bytesToWrite_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QFileDevice_Adaptor *)cls)->cbs_bytesToWrite_c0_0 ());
}

static void _set_callback_cbs_bytesToWrite_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDevice_Adaptor *)cls)->cb_bytesToWrite_c0_0 = cb;
}


// emitter void QFileDevice::bytesWritten(qint64 bytes)

static void _init_emitter_bytesWritten_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("bytes");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_bytesWritten_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  ((QFileDevice_Adaptor *)cls)->emitter_QFileDevice_bytesWritten_986 (arg1);
}


// bool QFileDevice::canReadLine()

static void _init_cbs_canReadLine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_canReadLine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QFileDevice_Adaptor *)cls)->cbs_canReadLine_c0_0 ());
}

static void _set_callback_cbs_canReadLine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDevice_Adaptor *)cls)->cb_canReadLine_c0_0 = cb;
}


// void QFileDevice::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDevice_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDevice_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QFileDevice::close()

static void _init_cbs_close_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_close_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDevice_Adaptor *)cls)->cbs_close_0_0 ();
}

static void _set_callback_cbs_close_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDevice_Adaptor *)cls)->cb_close_0_0 = cb;
}


// void QFileDevice::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDevice_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDevice_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QFileDevice::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QFileDevice_Adaptor *)cls)->emitter_QFileDevice_destroyed_1302 (arg1);
}


// void QFileDevice::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDevice_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDevice_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QFileDevice::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QFileDevice_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDevice_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QFileDevice::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QFileDevice_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDevice_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// QString QFileDevice::fileName()

static void _init_cbs_fileName_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_cbs_fileName_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QFileDevice_Adaptor *)cls)->cbs_fileName_c0_0 ());
}

static void _set_callback_cbs_fileName_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDevice_Adaptor *)cls)->cb_fileName_c0_0 = cb;
}


// bool QFileDevice::isSequential()

static void _init_cbs_isSequential_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isSequential_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QFileDevice_Adaptor *)cls)->cbs_isSequential_c0_0 ());
}

static void _set_callback_cbs_isSequential_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDevice_Adaptor *)cls)->cb_isSequential_c0_0 = cb;
}


// exposed bool QFileDevice::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QFileDevice_Adaptor *)cls)->fp_QFileDevice_isSignalConnected_c2394 (arg1));
}


// emitter void QFileDevice::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QFileDevice_Adaptor *)cls)->emitter_QFileDevice_objectNameChanged_4567 (arg1);
}


// bool QFileDevice::open(QFlags<QIODevice::OpenModeFlag> mode)

static void _init_cbs_open_3242_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<QFlags<QIODevice::OpenModeFlag> > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_open_3242_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QIODevice::OpenModeFlag> arg1 = args.read<QFlags<QIODevice::OpenModeFlag> > (heap);
  ret.write<bool > ((bool)((QFileDevice_Adaptor *)cls)->cbs_open_3242_0 (arg1));
}

static void _set_callback_cbs_open_3242_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDevice_Adaptor *)cls)->cb_open_3242_0 = cb;
}


// QFlags<QFileDevice::Permission> QFileDevice::permissions()

static void _init_cbs_permissions_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QFileDevice::Permission> > ();
}

static void _call_cbs_permissions_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QFileDevice::Permission> > ((QFlags<QFileDevice::Permission>)((QFileDevice_Adaptor *)cls)->cbs_permissions_c0_0 ());
}

static void _set_callback_cbs_permissions_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDevice_Adaptor *)cls)->cb_permissions_c0_0 = cb;
}


// qint64 QFileDevice::pos()

static void _init_cbs_pos_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_cbs_pos_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QFileDevice_Adaptor *)cls)->cbs_pos_c0_0 ());
}

static void _set_callback_cbs_pos_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDevice_Adaptor *)cls)->cb_pos_c0_0 = cb;
}


// emitter void QFileDevice::readChannelFinished()

static void _init_emitter_readChannelFinished_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_readChannelFinished_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QFileDevice_Adaptor *)cls)->emitter_QFileDevice_readChannelFinished_0 ();
}


// emitter void QFileDevice::readyRead()

static void _init_emitter_readyRead_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_readyRead_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QFileDevice_Adaptor *)cls)->emitter_QFileDevice_readyRead_0 ();
}


// exposed int QFileDevice::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QFileDevice_Adaptor *)cls)->fp_QFileDevice_receivers_c1731 (arg1));
}


// bool QFileDevice::reset()

static void _init_cbs_reset_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_reset_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QFileDevice_Adaptor *)cls)->cbs_reset_0_0 ());
}

static void _set_callback_cbs_reset_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDevice_Adaptor *)cls)->cb_reset_0_0 = cb;
}


// bool QFileDevice::resize(qint64 sz)

static void _init_cbs_resize_986_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sz");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_resize_986_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = args.read<qint64 > (heap);
  ret.write<bool > ((bool)((QFileDevice_Adaptor *)cls)->cbs_resize_986_0 (arg1));
}

static void _set_callback_cbs_resize_986_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDevice_Adaptor *)cls)->cb_resize_986_0 = cb;
}


// bool QFileDevice::seek(qint64 offset)

static void _init_cbs_seek_986_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_seek_986_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = args.read<qint64 > (heap);
  ret.write<bool > ((bool)((QFileDevice_Adaptor *)cls)->cbs_seek_986_0 (arg1));
}

static void _set_callback_cbs_seek_986_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDevice_Adaptor *)cls)->cb_seek_986_0 = cb;
}


// exposed QObject *QFileDevice::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QFileDevice_Adaptor *)cls)->fp_QFileDevice_sender_c0 ());
}


// exposed int QFileDevice::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QFileDevice_Adaptor *)cls)->fp_QFileDevice_senderSignalIndex_c0 ());
}


// exposed void QFileDevice::setErrorString(const QString &errorString)

static void _init_fp_setErrorString_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("errorString");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setErrorString_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDevice_Adaptor *)cls)->fp_QFileDevice_setErrorString_2025 (arg1);
}


// exposed void QFileDevice::setOpenMode(QFlags<QIODevice::OpenModeFlag> openMode)

static void _init_fp_setOpenMode_3242 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("openMode");
  decl->add_arg<QFlags<QIODevice::OpenModeFlag> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setOpenMode_3242 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QIODevice::OpenModeFlag> arg1 = gsi::arg_reader<QFlags<QIODevice::OpenModeFlag> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDevice_Adaptor *)cls)->fp_QFileDevice_setOpenMode_3242 (arg1);
}


// bool QFileDevice::setPermissions(QFlags<QFileDevice::Permission> permissionSpec)

static void _init_cbs_setPermissions_3370_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("permissionSpec");
  decl->add_arg<QFlags<QFileDevice::Permission> > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_setPermissions_3370_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QFileDevice::Permission> arg1 = args.read<QFlags<QFileDevice::Permission> > (heap);
  ret.write<bool > ((bool)((QFileDevice_Adaptor *)cls)->cbs_setPermissions_3370_0 (arg1));
}

static void _set_callback_cbs_setPermissions_3370_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDevice_Adaptor *)cls)->cb_setPermissions_3370_0 = cb;
}


// qint64 QFileDevice::size()

static void _init_cbs_size_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_cbs_size_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QFileDevice_Adaptor *)cls)->cbs_size_c0_0 ());
}

static void _set_callback_cbs_size_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDevice_Adaptor *)cls)->cb_size_c0_0 = cb;
}


// void QFileDevice::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDevice_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDevice_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// bool QFileDevice::waitForBytesWritten(int msecs)

static void _init_cbs_waitForBytesWritten_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_waitForBytesWritten_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<bool > ((bool)((QFileDevice_Adaptor *)cls)->cbs_waitForBytesWritten_767_0 (arg1));
}

static void _set_callback_cbs_waitForBytesWritten_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDevice_Adaptor *)cls)->cb_waitForBytesWritten_767_0 = cb;
}


// bool QFileDevice::waitForReadyRead(int msecs)

static void _init_cbs_waitForReadyRead_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_waitForReadyRead_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<bool > ((bool)((QFileDevice_Adaptor *)cls)->cbs_waitForReadyRead_767_0 (arg1));
}

static void _set_callback_cbs_waitForReadyRead_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDevice_Adaptor *)cls)->cb_waitForReadyRead_767_0 = cb;
}


// qint64 QFileDevice::writeData(const char *data, qint64 len)

static void _init_cbs_writeData_2609_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("len");
  decl->add_arg<qint64 > (argspec_1);
  decl->set_return<qint64 > ();
}

static void _call_cbs_writeData_2609_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  qint64 arg2 = args.read<qint64 > (heap);
  ret.write<qint64 > ((qint64)((QFileDevice_Adaptor *)cls)->cbs_writeData_2609_0 (arg1, arg2));
}

static void _set_callback_cbs_writeData_2609_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDevice_Adaptor *)cls)->cb_writeData_2609_0 = cb;
}


namespace gsi
{

gsi::Class<QFileDevice> &qtdecl_QFileDevice ();

static gsi::Methods methods_QFileDevice_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod ("emit_aboutToClose", "@brief Emitter for signal void QFileDevice::aboutToClose()\nCall this method to emit this signal.", false, &_init_emitter_aboutToClose_0, &_call_emitter_aboutToClose_0);
  methods += new qt_gsi::GenericMethod ("atEnd", "@brief Virtual method bool QFileDevice::atEnd()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_atEnd_c0_0, &_call_cbs_atEnd_c0_0);
  methods += new qt_gsi::GenericMethod ("atEnd", "@hide", true, &_init_cbs_atEnd_c0_0, &_call_cbs_atEnd_c0_0, &_set_callback_cbs_atEnd_c0_0);
  methods += new qt_gsi::GenericMethod ("bytesAvailable", "@brief Virtual method qint64 QFileDevice::bytesAvailable()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_bytesAvailable_c0_0, &_call_cbs_bytesAvailable_c0_0);
  methods += new qt_gsi::GenericMethod ("bytesAvailable", "@hide", true, &_init_cbs_bytesAvailable_c0_0, &_call_cbs_bytesAvailable_c0_0, &_set_callback_cbs_bytesAvailable_c0_0);
  methods += new qt_gsi::GenericMethod ("bytesToWrite", "@brief Virtual method qint64 QFileDevice::bytesToWrite()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_bytesToWrite_c0_0, &_call_cbs_bytesToWrite_c0_0);
  methods += new qt_gsi::GenericMethod ("bytesToWrite", "@hide", true, &_init_cbs_bytesToWrite_c0_0, &_call_cbs_bytesToWrite_c0_0, &_set_callback_cbs_bytesToWrite_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_bytesWritten", "@brief Emitter for signal void QFileDevice::bytesWritten(qint64 bytes)\nCall this method to emit this signal.", false, &_init_emitter_bytesWritten_986, &_call_emitter_bytesWritten_986);
  methods += new qt_gsi::GenericMethod ("canReadLine", "@brief Virtual method bool QFileDevice::canReadLine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_canReadLine_c0_0, &_call_cbs_canReadLine_c0_0);
  methods += new qt_gsi::GenericMethod ("canReadLine", "@hide", true, &_init_cbs_canReadLine_c0_0, &_call_cbs_canReadLine_c0_0, &_set_callback_cbs_canReadLine_c0_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QFileDevice::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("close", "@brief Virtual method void QFileDevice::close()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_close_0_0, &_call_cbs_close_0_0);
  methods += new qt_gsi::GenericMethod ("close", "@hide", false, &_init_cbs_close_0_0, &_call_cbs_close_0_0, &_set_callback_cbs_close_0_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QFileDevice::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QFileDevice::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QFileDevice::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QFileDevice::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QFileDevice::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("fileName", "@brief Virtual method QString QFileDevice::fileName()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_fileName_c0_0, &_call_cbs_fileName_c0_0);
  methods += new qt_gsi::GenericMethod ("fileName", "@hide", true, &_init_cbs_fileName_c0_0, &_call_cbs_fileName_c0_0, &_set_callback_cbs_fileName_c0_0);
  methods += new qt_gsi::GenericMethod ("isSequential", "@brief Virtual method bool QFileDevice::isSequential()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isSequential_c0_0, &_call_cbs_isSequential_c0_0);
  methods += new qt_gsi::GenericMethod ("isSequential", "@hide", true, &_init_cbs_isSequential_c0_0, &_call_cbs_isSequential_c0_0, &_set_callback_cbs_isSequential_c0_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QFileDevice::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QFileDevice::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("open", "@brief Virtual method bool QFileDevice::open(QFlags<QIODevice::OpenModeFlag> mode)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_open_3242_0, &_call_cbs_open_3242_0);
  methods += new qt_gsi::GenericMethod ("open", "@hide", false, &_init_cbs_open_3242_0, &_call_cbs_open_3242_0, &_set_callback_cbs_open_3242_0);
  methods += new qt_gsi::GenericMethod ("permissions", "@brief Virtual method QFlags<QFileDevice::Permission> QFileDevice::permissions()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_permissions_c0_0, &_call_cbs_permissions_c0_0);
  methods += new qt_gsi::GenericMethod ("permissions", "@hide", true, &_init_cbs_permissions_c0_0, &_call_cbs_permissions_c0_0, &_set_callback_cbs_permissions_c0_0);
  methods += new qt_gsi::GenericMethod ("pos", "@brief Virtual method qint64 QFileDevice::pos()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_pos_c0_0, &_call_cbs_pos_c0_0);
  methods += new qt_gsi::GenericMethod ("pos", "@hide", true, &_init_cbs_pos_c0_0, &_call_cbs_pos_c0_0, &_set_callback_cbs_pos_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_readChannelFinished", "@brief Emitter for signal void QFileDevice::readChannelFinished()\nCall this method to emit this signal.", false, &_init_emitter_readChannelFinished_0, &_call_emitter_readChannelFinished_0);
  methods += new qt_gsi::GenericMethod ("emit_readyRead", "@brief Emitter for signal void QFileDevice::readyRead()\nCall this method to emit this signal.", false, &_init_emitter_readyRead_0, &_call_emitter_readyRead_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QFileDevice::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("reset", "@brief Virtual method bool QFileDevice::reset()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_reset_0_0, &_call_cbs_reset_0_0);
  methods += new qt_gsi::GenericMethod ("reset", "@hide", false, &_init_cbs_reset_0_0, &_call_cbs_reset_0_0, &_set_callback_cbs_reset_0_0);
  methods += new qt_gsi::GenericMethod ("resize", "@brief Virtual method bool QFileDevice::resize(qint64 sz)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resize_986_0, &_call_cbs_resize_986_0);
  methods += new qt_gsi::GenericMethod ("resize", "@hide", false, &_init_cbs_resize_986_0, &_call_cbs_resize_986_0, &_set_callback_cbs_resize_986_0);
  methods += new qt_gsi::GenericMethod ("seek", "@brief Virtual method bool QFileDevice::seek(qint64 offset)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_seek_986_0, &_call_cbs_seek_986_0);
  methods += new qt_gsi::GenericMethod ("seek", "@hide", false, &_init_cbs_seek_986_0, &_call_cbs_seek_986_0, &_set_callback_cbs_seek_986_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QFileDevice::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QFileDevice::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*setErrorString", "@brief Method void QFileDevice::setErrorString(const QString &errorString)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setErrorString_2025, &_call_fp_setErrorString_2025);
  methods += new qt_gsi::GenericMethod ("*setOpenMode", "@brief Method void QFileDevice::setOpenMode(QFlags<QIODevice::OpenModeFlag> openMode)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setOpenMode_3242, &_call_fp_setOpenMode_3242);
  methods += new qt_gsi::GenericMethod ("setPermissions", "@brief Virtual method bool QFileDevice::setPermissions(QFlags<QFileDevice::Permission> permissionSpec)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setPermissions_3370_0, &_call_cbs_setPermissions_3370_0);
  methods += new qt_gsi::GenericMethod ("setPermissions", "@hide", false, &_init_cbs_setPermissions_3370_0, &_call_cbs_setPermissions_3370_0, &_set_callback_cbs_setPermissions_3370_0);
  methods += new qt_gsi::GenericMethod ("size", "@brief Virtual method qint64 QFileDevice::size()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_size_c0_0, &_call_cbs_size_c0_0);
  methods += new qt_gsi::GenericMethod ("size", "@hide", true, &_init_cbs_size_c0_0, &_call_cbs_size_c0_0, &_set_callback_cbs_size_c0_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QFileDevice::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("waitForBytesWritten", "@brief Virtual method bool QFileDevice::waitForBytesWritten(int msecs)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_waitForBytesWritten_767_0, &_call_cbs_waitForBytesWritten_767_0);
  methods += new qt_gsi::GenericMethod ("waitForBytesWritten", "@hide", false, &_init_cbs_waitForBytesWritten_767_0, &_call_cbs_waitForBytesWritten_767_0, &_set_callback_cbs_waitForBytesWritten_767_0);
  methods += new qt_gsi::GenericMethod ("waitForReadyRead", "@brief Virtual method bool QFileDevice::waitForReadyRead(int msecs)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_waitForReadyRead_767_0, &_call_cbs_waitForReadyRead_767_0);
  methods += new qt_gsi::GenericMethod ("waitForReadyRead", "@hide", false, &_init_cbs_waitForReadyRead_767_0, &_call_cbs_waitForReadyRead_767_0, &_set_callback_cbs_waitForReadyRead_767_0);
  methods += new qt_gsi::GenericMethod ("*writeData", "@brief Virtual method qint64 QFileDevice::writeData(const char *data, qint64 len)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_writeData_2609_0, &_call_cbs_writeData_2609_0);
  methods += new qt_gsi::GenericMethod ("*writeData", "@hide", false, &_init_cbs_writeData_2609_0, &_call_cbs_writeData_2609_0, &_set_callback_cbs_writeData_2609_0);
  return methods;
}

gsi::Class<QFileDevice_Adaptor> decl_QFileDevice_Adaptor (qtdecl_QFileDevice (), "QtCore", "QFileDevice",
  methods_QFileDevice_Adaptor (),
  "@qt\n@brief Binding of QFileDevice");

}


//  Implementation of the enum wrapper class for QFileDevice::FileError
namespace qt_gsi
{

static gsi::Enum<QFileDevice::FileError> decl_QFileDevice_FileError_Enum ("QtCore", "QFileDevice_FileError",
    gsi::enum_const ("NoError", QFileDevice::NoError, "@brief Enum constant QFileDevice::NoError") +
    gsi::enum_const ("ReadError", QFileDevice::ReadError, "@brief Enum constant QFileDevice::ReadError") +
    gsi::enum_const ("WriteError", QFileDevice::WriteError, "@brief Enum constant QFileDevice::WriteError") +
    gsi::enum_const ("FatalError", QFileDevice::FatalError, "@brief Enum constant QFileDevice::FatalError") +
    gsi::enum_const ("ResourceError", QFileDevice::ResourceError, "@brief Enum constant QFileDevice::ResourceError") +
    gsi::enum_const ("OpenError", QFileDevice::OpenError, "@brief Enum constant QFileDevice::OpenError") +
    gsi::enum_const ("AbortError", QFileDevice::AbortError, "@brief Enum constant QFileDevice::AbortError") +
    gsi::enum_const ("TimeOutError", QFileDevice::TimeOutError, "@brief Enum constant QFileDevice::TimeOutError") +
    gsi::enum_const ("UnspecifiedError", QFileDevice::UnspecifiedError, "@brief Enum constant QFileDevice::UnspecifiedError") +
    gsi::enum_const ("RemoveError", QFileDevice::RemoveError, "@brief Enum constant QFileDevice::RemoveError") +
    gsi::enum_const ("RenameError", QFileDevice::RenameError, "@brief Enum constant QFileDevice::RenameError") +
    gsi::enum_const ("PositionError", QFileDevice::PositionError, "@brief Enum constant QFileDevice::PositionError") +
    gsi::enum_const ("ResizeError", QFileDevice::ResizeError, "@brief Enum constant QFileDevice::ResizeError") +
    gsi::enum_const ("PermissionsError", QFileDevice::PermissionsError, "@brief Enum constant QFileDevice::PermissionsError") +
    gsi::enum_const ("CopyError", QFileDevice::CopyError, "@brief Enum constant QFileDevice::CopyError"),
  "@qt\n@brief This class represents the QFileDevice::FileError enum");

static gsi::QFlagsClass<QFileDevice::FileError > decl_QFileDevice_FileError_Enums ("QtCore", "QFileDevice_QFlags_FileError",
  "@qt\n@brief This class represents the QFlags<QFileDevice::FileError> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QFileDevice> inject_QFileDevice_FileError_Enum_in_parent (decl_QFileDevice_FileError_Enum.defs ());
static gsi::ClassExt<QFileDevice> decl_QFileDevice_FileError_Enum_as_child (decl_QFileDevice_FileError_Enum, "FileError");
static gsi::ClassExt<QFileDevice> decl_QFileDevice_FileError_Enums_as_child (decl_QFileDevice_FileError_Enums, "QFlags_FileError");

}


//  Implementation of the enum wrapper class for QFileDevice::Permission
namespace qt_gsi
{

static gsi::Enum<QFileDevice::Permission> decl_QFileDevice_Permission_Enum ("QtCore", "QFileDevice_Permission",
    gsi::enum_const ("ReadOwner", QFileDevice::ReadOwner, "@brief Enum constant QFileDevice::ReadOwner") +
    gsi::enum_const ("WriteOwner", QFileDevice::WriteOwner, "@brief Enum constant QFileDevice::WriteOwner") +
    gsi::enum_const ("ExeOwner", QFileDevice::ExeOwner, "@brief Enum constant QFileDevice::ExeOwner") +
    gsi::enum_const ("ReadUser", QFileDevice::ReadUser, "@brief Enum constant QFileDevice::ReadUser") +
    gsi::enum_const ("WriteUser", QFileDevice::WriteUser, "@brief Enum constant QFileDevice::WriteUser") +
    gsi::enum_const ("ExeUser", QFileDevice::ExeUser, "@brief Enum constant QFileDevice::ExeUser") +
    gsi::enum_const ("ReadGroup", QFileDevice::ReadGroup, "@brief Enum constant QFileDevice::ReadGroup") +
    gsi::enum_const ("WriteGroup", QFileDevice::WriteGroup, "@brief Enum constant QFileDevice::WriteGroup") +
    gsi::enum_const ("ExeGroup", QFileDevice::ExeGroup, "@brief Enum constant QFileDevice::ExeGroup") +
    gsi::enum_const ("ReadOther", QFileDevice::ReadOther, "@brief Enum constant QFileDevice::ReadOther") +
    gsi::enum_const ("WriteOther", QFileDevice::WriteOther, "@brief Enum constant QFileDevice::WriteOther") +
    gsi::enum_const ("ExeOther", QFileDevice::ExeOther, "@brief Enum constant QFileDevice::ExeOther"),
  "@qt\n@brief This class represents the QFileDevice::Permission enum");

static gsi::QFlagsClass<QFileDevice::Permission > decl_QFileDevice_Permission_Enums ("QtCore", "QFileDevice_QFlags_Permission",
  "@qt\n@brief This class represents the QFlags<QFileDevice::Permission> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QFileDevice> inject_QFileDevice_Permission_Enum_in_parent (decl_QFileDevice_Permission_Enum.defs ());
static gsi::ClassExt<QFileDevice> decl_QFileDevice_Permission_Enum_as_child (decl_QFileDevice_Permission_Enum, "Permission");
static gsi::ClassExt<QFileDevice> decl_QFileDevice_Permission_Enums_as_child (decl_QFileDevice_Permission_Enums, "QFlags_Permission");

}

