
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2021 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQIdentityProxyModel.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QIdentityProxyModel>
#include <QAbstractItemModel>
#include <QChildEvent>
#include <QDataStream>
#include <QEvent>
#include <QItemSelection>
#include <QMetaMethod>
#include <QMimeData>
#include <QModelIndex>
#include <QObject>
#include <QPersistentModelIndex>
#include <QSize>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include "gsiDeclQtCoreTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QIdentityProxyModel

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QIdentityProxyModel::staticMetaObject);
}


// int QIdentityProxyModel::columnCount(const QModelIndex &parent)


static void _init_f_columnCount_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_columnCount_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<int > ((int)((QIdentityProxyModel *)cls)->columnCount (arg1));
}


// bool QIdentityProxyModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)


static void _init_f_dropMimeData_7425 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QMimeData * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("action");
  decl->add_arg<const qt_gsi::Converter<Qt::DropAction>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("row");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("column");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_f_dropMimeData_7425 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMimeData *arg1 = gsi::arg_reader<const QMimeData * >() (args, heap);
  const qt_gsi::Converter<Qt::DropAction>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<Qt::DropAction>::target_type & >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg5 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<bool > ((bool)((QIdentityProxyModel *)cls)->dropMimeData (arg1, qt_gsi::QtToCppAdaptor<Qt::DropAction>(arg2).cref(), arg3, arg4, arg5));
}


// QVariant QIdentityProxyModel::headerData(int section, Qt::Orientation orientation, int role)


static void _init_f_headerData_c3231 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role", true, "Qt::DisplayRole");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QVariant > ();
}

static void _call_f_headerData_c3231 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<Qt::Orientation>::target_type & >() (args, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (Qt::DisplayRole, heap);
  ret.write<QVariant > ((QVariant)((QIdentityProxyModel *)cls)->headerData (arg1, qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg2).cref(), arg3));
}


// QModelIndex QIdentityProxyModel::index(int row, int column, const QModelIndex &parent)


static void _init_f_index_c3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_f_index_c3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg3 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<QModelIndex > ((QModelIndex)((QIdentityProxyModel *)cls)->index (arg1, arg2, arg3));
}


// bool QIdentityProxyModel::insertColumns(int column, int count, const QModelIndex &parent)


static void _init_f_insertColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_insertColumns_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg3 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<bool > ((bool)((QIdentityProxyModel *)cls)->insertColumns (arg1, arg2, arg3));
}


// bool QIdentityProxyModel::insertRows(int row, int count, const QModelIndex &parent)


static void _init_f_insertRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_insertRows_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg3 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<bool > ((bool)((QIdentityProxyModel *)cls)->insertRows (arg1, arg2, arg3));
}


// QModelIndex QIdentityProxyModel::mapFromSource(const QModelIndex &sourceIndex)


static void _init_f_mapFromSource_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceIndex");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_f_mapFromSource_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QModelIndex > ((QModelIndex)((QIdentityProxyModel *)cls)->mapFromSource (arg1));
}


// QItemSelection QIdentityProxyModel::mapSelectionFromSource(const QItemSelection &selection)


static void _init_f_mapSelectionFromSource_c2727 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selection");
  decl->add_arg<const QItemSelection & > (argspec_0);
  decl->set_return<QItemSelection > ();
}

static void _call_f_mapSelectionFromSource_c2727 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QItemSelection &arg1 = gsi::arg_reader<const QItemSelection & >() (args, heap);
  ret.write<QItemSelection > ((QItemSelection)((QIdentityProxyModel *)cls)->mapSelectionFromSource (arg1));
}


// QItemSelection QIdentityProxyModel::mapSelectionToSource(const QItemSelection &selection)


static void _init_f_mapSelectionToSource_c2727 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selection");
  decl->add_arg<const QItemSelection & > (argspec_0);
  decl->set_return<QItemSelection > ();
}

static void _call_f_mapSelectionToSource_c2727 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QItemSelection &arg1 = gsi::arg_reader<const QItemSelection & >() (args, heap);
  ret.write<QItemSelection > ((QItemSelection)((QIdentityProxyModel *)cls)->mapSelectionToSource (arg1));
}


// QModelIndex QIdentityProxyModel::mapToSource(const QModelIndex &proxyIndex)


static void _init_f_mapToSource_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("proxyIndex");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_f_mapToSource_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QModelIndex > ((QModelIndex)((QIdentityProxyModel *)cls)->mapToSource (arg1));
}


// QList<QModelIndex> QIdentityProxyModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)


static void _init_f_match_c7932 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("start");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("hits", true, "1");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("flags", true, "Qt::MatchFlags(Qt::MatchStartsWith|Qt::MatchWrap)");
  decl->add_arg<QFlags<Qt::MatchFlag> > (argspec_4);
  decl->set_return<QList<QModelIndex> > ();
}

static void _call_f_match_c7932 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QVariant &arg3 = gsi::arg_reader<const QVariant & >() (args, heap);
  int arg4 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (1, heap);
  QFlags<Qt::MatchFlag> arg5 = args ? gsi::arg_reader<QFlags<Qt::MatchFlag> >() (args, heap) : gsi::arg_maker<QFlags<Qt::MatchFlag> >() (Qt::MatchFlags(Qt::MatchStartsWith|Qt::MatchWrap), heap);
  ret.write<QList<QModelIndex> > ((QList<QModelIndex>)((QIdentityProxyModel *)cls)->match (arg1, arg2, arg3, arg4, arg5));
}


// QModelIndex QIdentityProxyModel::parent(const QModelIndex &child)


static void _init_f_parent_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("child");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_f_parent_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QModelIndex > ((QModelIndex)((QIdentityProxyModel *)cls)->parent (arg1));
}


// bool QIdentityProxyModel::removeColumns(int column, int count, const QModelIndex &parent)


static void _init_f_removeColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_removeColumns_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg3 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<bool > ((bool)((QIdentityProxyModel *)cls)->removeColumns (arg1, arg2, arg3));
}


// bool QIdentityProxyModel::removeRows(int row, int count, const QModelIndex &parent)


static void _init_f_removeRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_removeRows_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg3 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<bool > ((bool)((QIdentityProxyModel *)cls)->removeRows (arg1, arg2, arg3));
}


// int QIdentityProxyModel::rowCount(const QModelIndex &parent)


static void _init_f_rowCount_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_rowCount_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<int > ((int)((QIdentityProxyModel *)cls)->rowCount (arg1));
}


// void QIdentityProxyModel::setSourceModel(QAbstractItemModel *sourceModel)


static void _init_f_setSourceModel_2419 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceModel");
  decl->add_arg<QAbstractItemModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSourceModel_2419 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractItemModel *arg1 = gsi::arg_reader<QAbstractItemModel * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QIdentityProxyModel *)cls)->setSourceModel (arg1);
}


// QModelIndex QIdentityProxyModel::sibling(int row, int column, const QModelIndex &idx)


static void _init_f_sibling_c3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("idx");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_f_sibling_c3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg3 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QModelIndex > ((QModelIndex)((QIdentityProxyModel *)cls)->sibling (arg1, arg2, arg3));
}


// static QString QIdentityProxyModel::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QIdentityProxyModel::tr (arg1, arg2, arg3));
}


// static QString QIdentityProxyModel::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QIdentityProxyModel::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QIdentityProxyModel () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("columnCount", "@brief Method int QIdentityProxyModel::columnCount(const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::columnCount", true, &_init_f_columnCount_c2395, &_call_f_columnCount_c2395);
  methods += new qt_gsi::GenericMethod ("dropMimeData", "@brief Method bool QIdentityProxyModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)\nThis is a reimplementation of QAbstractProxyModel::dropMimeData", false, &_init_f_dropMimeData_7425, &_call_f_dropMimeData_7425);
  methods += new qt_gsi::GenericMethod ("headerData", "@brief Method QVariant QIdentityProxyModel::headerData(int section, Qt::Orientation orientation, int role)\nThis is a reimplementation of QAbstractProxyModel::headerData", true, &_init_f_headerData_c3231, &_call_f_headerData_c3231);
  methods += new qt_gsi::GenericMethod ("index", "@brief Method QModelIndex QIdentityProxyModel::index(int row, int column, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::index", true, &_init_f_index_c3713, &_call_f_index_c3713);
  methods += new qt_gsi::GenericMethod ("insertColumns", "@brief Method bool QIdentityProxyModel::insertColumns(int column, int count, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::insertColumns", false, &_init_f_insertColumns_3713, &_call_f_insertColumns_3713);
  methods += new qt_gsi::GenericMethod ("insertRows", "@brief Method bool QIdentityProxyModel::insertRows(int row, int count, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::insertRows", false, &_init_f_insertRows_3713, &_call_f_insertRows_3713);
  methods += new qt_gsi::GenericMethod ("mapFromSource", "@brief Method QModelIndex QIdentityProxyModel::mapFromSource(const QModelIndex &sourceIndex)\nThis is a reimplementation of QAbstractProxyModel::mapFromSource", true, &_init_f_mapFromSource_c2395, &_call_f_mapFromSource_c2395);
  methods += new qt_gsi::GenericMethod ("mapSelectionFromSource", "@brief Method QItemSelection QIdentityProxyModel::mapSelectionFromSource(const QItemSelection &selection)\nThis is a reimplementation of QAbstractProxyModel::mapSelectionFromSource", true, &_init_f_mapSelectionFromSource_c2727, &_call_f_mapSelectionFromSource_c2727);
  methods += new qt_gsi::GenericMethod ("mapSelectionToSource", "@brief Method QItemSelection QIdentityProxyModel::mapSelectionToSource(const QItemSelection &selection)\nThis is a reimplementation of QAbstractProxyModel::mapSelectionToSource", true, &_init_f_mapSelectionToSource_c2727, &_call_f_mapSelectionToSource_c2727);
  methods += new qt_gsi::GenericMethod ("mapToSource", "@brief Method QModelIndex QIdentityProxyModel::mapToSource(const QModelIndex &proxyIndex)\nThis is a reimplementation of QAbstractProxyModel::mapToSource", true, &_init_f_mapToSource_c2395, &_call_f_mapToSource_c2395);
  methods += new qt_gsi::GenericMethod ("match", "@brief Method QList<QModelIndex> QIdentityProxyModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)\nThis is a reimplementation of QAbstractItemModel::match", true, &_init_f_match_c7932, &_call_f_match_c7932);
  methods += new qt_gsi::GenericMethod ("parent", "@brief Method QModelIndex QIdentityProxyModel::parent(const QModelIndex &child)\nThis is a reimplementation of QAbstractItemModel::parent", true, &_init_f_parent_c2395, &_call_f_parent_c2395);
  methods += new qt_gsi::GenericMethod ("removeColumns", "@brief Method bool QIdentityProxyModel::removeColumns(int column, int count, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::removeColumns", false, &_init_f_removeColumns_3713, &_call_f_removeColumns_3713);
  methods += new qt_gsi::GenericMethod ("removeRows", "@brief Method bool QIdentityProxyModel::removeRows(int row, int count, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::removeRows", false, &_init_f_removeRows_3713, &_call_f_removeRows_3713);
  methods += new qt_gsi::GenericMethod ("rowCount", "@brief Method int QIdentityProxyModel::rowCount(const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::rowCount", true, &_init_f_rowCount_c2395, &_call_f_rowCount_c2395);
  methods += new qt_gsi::GenericMethod ("setSourceModel|sourceModel=", "@brief Method void QIdentityProxyModel::setSourceModel(QAbstractItemModel *sourceModel)\nThis is a reimplementation of QAbstractProxyModel::setSourceModel", false, &_init_f_setSourceModel_2419, &_call_f_setSourceModel_2419);
  methods += new qt_gsi::GenericMethod ("sibling", "@brief Method QModelIndex QIdentityProxyModel::sibling(int row, int column, const QModelIndex &idx)\nThis is a reimplementation of QAbstractProxyModel::sibling", true, &_init_f_sibling_c3713, &_call_f_sibling_c3713);
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("columnsAboutToBeInserted(const QModelIndex &, int, int)", "columnsAboutToBeInserted", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QIdentityProxyModel::columnsAboutToBeInserted(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int, const QModelIndex &, int > ("columnsAboutToBeMoved(const QModelIndex &, int, int, const QModelIndex &, int)", "columnsAboutToBeMoved", gsi::arg("sourceParent"), gsi::arg("sourceStart"), gsi::arg("sourceEnd"), gsi::arg("destinationParent"), gsi::arg("destinationColumn"), "@brief Signal declaration for QIdentityProxyModel::columnsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationColumn)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("columnsAboutToBeRemoved(const QModelIndex &, int, int)", "columnsAboutToBeRemoved", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QIdentityProxyModel::columnsAboutToBeRemoved(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("columnsInserted(const QModelIndex &, int, int)", "columnsInserted", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QIdentityProxyModel::columnsInserted(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int, const QModelIndex &, int > ("columnsMoved(const QModelIndex &, int, int, const QModelIndex &, int)", "columnsMoved", gsi::arg("parent"), gsi::arg("start"), gsi::arg("end"), gsi::arg("destination"), gsi::arg("column"), "@brief Signal declaration for QIdentityProxyModel::columnsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int column)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("columnsRemoved(const QModelIndex &, int, int)", "columnsRemoved", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QIdentityProxyModel::columnsRemoved(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, const QModelIndex &, const QVector<int> & > ("dataChanged(const QModelIndex &, const QModelIndex &, const QVector<int> &)", "dataChanged", gsi::arg("topLeft"), gsi::arg("bottomRight"), gsi::arg("roles"), "@brief Signal declaration for QIdentityProxyModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QVector<int> &roles)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QIdentityProxyModel::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<Qt::Orientation>::target_type &, int, int > ("headerDataChanged(Qt::Orientation, int, int)", "headerDataChanged", gsi::arg("orientation"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QIdentityProxyModel::headerDataChanged(Qt::Orientation orientation, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QList<QPersistentModelIndex> &, const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & > ("layoutAboutToBeChanged(const QList<QPersistentModelIndex> &, QAbstractItemModel::LayoutChangeHint)", "layoutAboutToBeChanged", gsi::arg("parents"), gsi::arg("hint"), "@brief Signal declaration for QIdentityProxyModel::layoutAboutToBeChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QList<QPersistentModelIndex> &, const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & > ("layoutChanged(const QList<QPersistentModelIndex> &, QAbstractItemModel::LayoutChangeHint)", "layoutChanged", gsi::arg("parents"), gsi::arg("hint"), "@brief Signal declaration for QIdentityProxyModel::layoutChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("modelAboutToBeReset()", "modelAboutToBeReset", "@brief Signal declaration for QIdentityProxyModel::modelAboutToBeReset()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("modelReset()", "modelReset", "@brief Signal declaration for QIdentityProxyModel::modelReset()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QIdentityProxyModel::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("rowsAboutToBeInserted(const QModelIndex &, int, int)", "rowsAboutToBeInserted", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QIdentityProxyModel::rowsAboutToBeInserted(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int, const QModelIndex &, int > ("rowsAboutToBeMoved(const QModelIndex &, int, int, const QModelIndex &, int)", "rowsAboutToBeMoved", gsi::arg("sourceParent"), gsi::arg("sourceStart"), gsi::arg("sourceEnd"), gsi::arg("destinationParent"), gsi::arg("destinationRow"), "@brief Signal declaration for QIdentityProxyModel::rowsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationRow)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("rowsAboutToBeRemoved(const QModelIndex &, int, int)", "rowsAboutToBeRemoved", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QIdentityProxyModel::rowsAboutToBeRemoved(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("rowsInserted(const QModelIndex &, int, int)", "rowsInserted", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QIdentityProxyModel::rowsInserted(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int, const QModelIndex &, int > ("rowsMoved(const QModelIndex &, int, int, const QModelIndex &, int)", "rowsMoved", gsi::arg("parent"), gsi::arg("start"), gsi::arg("end"), gsi::arg("destination"), gsi::arg("row"), "@brief Signal declaration for QIdentityProxyModel::rowsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int row)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("rowsRemoved(const QModelIndex &, int, int)", "rowsRemoved", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QIdentityProxyModel::rowsRemoved(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("sourceModelChanged()", "sourceModelChanged", "@brief Signal declaration for QIdentityProxyModel::sourceModelChanged()\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QIdentityProxyModel::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QIdentityProxyModel::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QAbstractProxyModel> &qtdecl_QAbstractProxyModel ();

qt_gsi::QtNativeClass<QIdentityProxyModel> decl_QIdentityProxyModel (qtdecl_QAbstractProxyModel (), "QtCore", "QIdentityProxyModel_Native",
  methods_QIdentityProxyModel (),
  "@hide\n@alias QIdentityProxyModel");

GSI_QTCORE_PUBLIC gsi::Class<QIdentityProxyModel> &qtdecl_QIdentityProxyModel () { return decl_QIdentityProxyModel; }

}


class QIdentityProxyModel_Adaptor : public QIdentityProxyModel, public qt_gsi::QtObjectBase
{
public:

  virtual ~QIdentityProxyModel_Adaptor();

  //  [adaptor ctor] QIdentityProxyModel::QIdentityProxyModel(QObject *parent)
  QIdentityProxyModel_Adaptor() : QIdentityProxyModel()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QIdentityProxyModel::QIdentityProxyModel(QObject *parent)
  QIdentityProxyModel_Adaptor(QObject *parent) : QIdentityProxyModel(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QIdentityProxyModel::beginInsertColumns(const QModelIndex &parent, int first, int last)
  void fp_QIdentityProxyModel_beginInsertColumns_3713 (const QModelIndex &parent, int first, int last) {
    QIdentityProxyModel::beginInsertColumns(parent, first, last);
  }

  //  [expose] void QIdentityProxyModel::beginInsertRows(const QModelIndex &parent, int first, int last)
  void fp_QIdentityProxyModel_beginInsertRows_3713 (const QModelIndex &parent, int first, int last) {
    QIdentityProxyModel::beginInsertRows(parent, first, last);
  }

  //  [expose] bool QIdentityProxyModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)
  bool fp_QIdentityProxyModel_beginMoveColumns_6659 (const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn) {
    return QIdentityProxyModel::beginMoveColumns(sourceParent, sourceFirst, sourceLast, destinationParent, destinationColumn);
  }

  //  [expose] bool QIdentityProxyModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)
  bool fp_QIdentityProxyModel_beginMoveRows_6659 (const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow) {
    return QIdentityProxyModel::beginMoveRows(sourceParent, sourceFirst, sourceLast, destinationParent, destinationRow);
  }

  //  [expose] void QIdentityProxyModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)
  void fp_QIdentityProxyModel_beginRemoveColumns_3713 (const QModelIndex &parent, int first, int last) {
    QIdentityProxyModel::beginRemoveColumns(parent, first, last);
  }

  //  [expose] void QIdentityProxyModel::beginRemoveRows(const QModelIndex &parent, int first, int last)
  void fp_QIdentityProxyModel_beginRemoveRows_3713 (const QModelIndex &parent, int first, int last) {
    QIdentityProxyModel::beginRemoveRows(parent, first, last);
  }

  //  [expose] void QIdentityProxyModel::beginResetModel()
  void fp_QIdentityProxyModel_beginResetModel_0 () {
    QIdentityProxyModel::beginResetModel();
  }

  //  [expose] void QIdentityProxyModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)
  void fp_QIdentityProxyModel_changePersistentIndex_4682 (const QModelIndex &from, const QModelIndex &to) {
    QIdentityProxyModel::changePersistentIndex(from, to);
  }

  //  [expose] void QIdentityProxyModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)
  void fp_QIdentityProxyModel_changePersistentIndexList_5912 (const QList<QModelIndex> &from, const QList<QModelIndex> &to) {
    QIdentityProxyModel::changePersistentIndexList(from, to);
  }

  //  [expose] QModelIndex QIdentityProxyModel::createIndex(int row, int column, void *data)
  QModelIndex fp_QIdentityProxyModel_createIndex_c2374 (int row, int column, void *data) const {
    return QIdentityProxyModel::createIndex(row, column, data);
  }

  //  [expose] QModelIndex QIdentityProxyModel::createIndex(int row, int column, quintptr id)
  QModelIndex fp_QIdentityProxyModel_createIndex_c2657 (int row, int column, quintptr id) const {
    return QIdentityProxyModel::createIndex(row, column, id);
  }

  //  [expose] bool QIdentityProxyModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)
  bool fp_QIdentityProxyModel_decodeData_5302 (int row, int column, const QModelIndex &parent, QDataStream &stream) {
    return QIdentityProxyModel::decodeData(row, column, parent, stream);
  }

  //  [expose] void QIdentityProxyModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)
  void fp_QIdentityProxyModel_encodeData_c4599 (const QList<QModelIndex> &indexes, QDataStream &stream) const {
    QIdentityProxyModel::encodeData(indexes, stream);
  }

  //  [expose] void QIdentityProxyModel::endInsertColumns()
  void fp_QIdentityProxyModel_endInsertColumns_0 () {
    QIdentityProxyModel::endInsertColumns();
  }

  //  [expose] void QIdentityProxyModel::endInsertRows()
  void fp_QIdentityProxyModel_endInsertRows_0 () {
    QIdentityProxyModel::endInsertRows();
  }

  //  [expose] void QIdentityProxyModel::endMoveColumns()
  void fp_QIdentityProxyModel_endMoveColumns_0 () {
    QIdentityProxyModel::endMoveColumns();
  }

  //  [expose] void QIdentityProxyModel::endMoveRows()
  void fp_QIdentityProxyModel_endMoveRows_0 () {
    QIdentityProxyModel::endMoveRows();
  }

  //  [expose] void QIdentityProxyModel::endRemoveColumns()
  void fp_QIdentityProxyModel_endRemoveColumns_0 () {
    QIdentityProxyModel::endRemoveColumns();
  }

  //  [expose] void QIdentityProxyModel::endRemoveRows()
  void fp_QIdentityProxyModel_endRemoveRows_0 () {
    QIdentityProxyModel::endRemoveRows();
  }

  //  [expose] void QIdentityProxyModel::endResetModel()
  void fp_QIdentityProxyModel_endResetModel_0 () {
    QIdentityProxyModel::endResetModel();
  }

  //  [expose] bool QIdentityProxyModel::isSignalConnected(const QMetaMethod &signal)
  bool fp_QIdentityProxyModel_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QIdentityProxyModel::isSignalConnected(signal);
  }

  //  [expose] QList<QModelIndex> QIdentityProxyModel::persistentIndexList()
  QList<QModelIndex> fp_QIdentityProxyModel_persistentIndexList_c0 () const {
    return QIdentityProxyModel::persistentIndexList();
  }

  //  [expose] int QIdentityProxyModel::receivers(const char *signal)
  int fp_QIdentityProxyModel_receivers_c1731 (const char *signal) const {
    return QIdentityProxyModel::receivers(signal);
  }

  //  [expose] void QIdentityProxyModel::resetInternalData()
  void fp_QIdentityProxyModel_resetInternalData_0 () {
    QIdentityProxyModel::resetInternalData();
  }

  //  [expose] QObject *QIdentityProxyModel::sender()
  QObject * fp_QIdentityProxyModel_sender_c0 () const {
    return QIdentityProxyModel::sender();
  }

  //  [expose] int QIdentityProxyModel::senderSignalIndex()
  int fp_QIdentityProxyModel_senderSignalIndex_c0 () const {
    return QIdentityProxyModel::senderSignalIndex();
  }

  //  [adaptor impl] QModelIndex QIdentityProxyModel::buddy(const QModelIndex &index)
  QModelIndex cbs_buddy_c2395_0(const QModelIndex &index) const
  {
    return QIdentityProxyModel::buddy(index);
  }

  virtual QModelIndex buddy(const QModelIndex &index) const
  {
    if (cb_buddy_c2395_0.can_issue()) {
      return cb_buddy_c2395_0.issue<QIdentityProxyModel_Adaptor, QModelIndex, const QModelIndex &>(&QIdentityProxyModel_Adaptor::cbs_buddy_c2395_0, index);
    } else {
      return QIdentityProxyModel::buddy(index);
    }
  }

  //  [adaptor impl] bool QIdentityProxyModel::canDropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)
  bool cbs_canDropMimeData_c7425_0(const QMimeData *data, const qt_gsi::Converter<Qt::DropAction>::target_type & action, int row, int column, const QModelIndex &parent) const
  {
    return QIdentityProxyModel::canDropMimeData(data, qt_gsi::QtToCppAdaptor<Qt::DropAction>(action).cref(), row, column, parent);
  }

  virtual bool canDropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent) const
  {
    if (cb_canDropMimeData_c7425_0.can_issue()) {
      return cb_canDropMimeData_c7425_0.issue<QIdentityProxyModel_Adaptor, bool, const QMimeData *, const qt_gsi::Converter<Qt::DropAction>::target_type &, int, int, const QModelIndex &>(&QIdentityProxyModel_Adaptor::cbs_canDropMimeData_c7425_0, data, qt_gsi::CppToQtAdaptor<Qt::DropAction>(action), row, column, parent);
    } else {
      return QIdentityProxyModel::canDropMimeData(data, action, row, column, parent);
    }
  }

  //  [adaptor impl] bool QIdentityProxyModel::canFetchMore(const QModelIndex &parent)
  bool cbs_canFetchMore_c2395_0(const QModelIndex &parent) const
  {
    return QIdentityProxyModel::canFetchMore(parent);
  }

  virtual bool canFetchMore(const QModelIndex &parent) const
  {
    if (cb_canFetchMore_c2395_0.can_issue()) {
      return cb_canFetchMore_c2395_0.issue<QIdentityProxyModel_Adaptor, bool, const QModelIndex &>(&QIdentityProxyModel_Adaptor::cbs_canFetchMore_c2395_0, parent);
    } else {
      return QIdentityProxyModel::canFetchMore(parent);
    }
  }

  //  [adaptor impl] int QIdentityProxyModel::columnCount(const QModelIndex &parent)
  int cbs_columnCount_c2395_1(const QModelIndex &parent) const
  {
    return QIdentityProxyModel::columnCount(parent);
  }

  virtual int columnCount(const QModelIndex &parent) const
  {
    if (cb_columnCount_c2395_1.can_issue()) {
      return cb_columnCount_c2395_1.issue<QIdentityProxyModel_Adaptor, int, const QModelIndex &>(&QIdentityProxyModel_Adaptor::cbs_columnCount_c2395_1, parent);
    } else {
      return QIdentityProxyModel::columnCount(parent);
    }
  }

  //  [emitter impl] void QIdentityProxyModel::columnsAboutToBeInserted(const QModelIndex &parent, int first, int last)
  void emitter_QIdentityProxyModel_columnsAboutToBeInserted_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QIdentityProxyModel::columnsAboutToBeInserted(const QModelIndex &parent, int first, int last)'");
  }

  //  [emitter impl] void QIdentityProxyModel::columnsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationColumn)
  void emitter_QIdentityProxyModel_columnsAboutToBeMoved_10318(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationColumn)
  {
    __SUPPRESS_UNUSED_WARNING (sourceParent);
    __SUPPRESS_UNUSED_WARNING (sourceStart);
    __SUPPRESS_UNUSED_WARNING (sourceEnd);
    __SUPPRESS_UNUSED_WARNING (destinationParent);
    __SUPPRESS_UNUSED_WARNING (destinationColumn);
    throw tl::Exception ("Can't emit private signal 'void QIdentityProxyModel::columnsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationColumn)'");
  }

  //  [emitter impl] void QIdentityProxyModel::columnsAboutToBeRemoved(const QModelIndex &parent, int first, int last)
  void emitter_QIdentityProxyModel_columnsAboutToBeRemoved_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QIdentityProxyModel::columnsAboutToBeRemoved(const QModelIndex &parent, int first, int last)'");
  }

  //  [emitter impl] void QIdentityProxyModel::columnsInserted(const QModelIndex &parent, int first, int last)
  void emitter_QIdentityProxyModel_columnsInserted_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QIdentityProxyModel::columnsInserted(const QModelIndex &parent, int first, int last)'");
  }

  //  [emitter impl] void QIdentityProxyModel::columnsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int column)
  void emitter_QIdentityProxyModel_columnsMoved_10318(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int column)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (start);
    __SUPPRESS_UNUSED_WARNING (end);
    __SUPPRESS_UNUSED_WARNING (destination);
    __SUPPRESS_UNUSED_WARNING (column);
    throw tl::Exception ("Can't emit private signal 'void QIdentityProxyModel::columnsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int column)'");
  }

  //  [emitter impl] void QIdentityProxyModel::columnsRemoved(const QModelIndex &parent, int first, int last)
  void emitter_QIdentityProxyModel_columnsRemoved_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QIdentityProxyModel::columnsRemoved(const QModelIndex &parent, int first, int last)'");
  }

  //  [adaptor impl] QVariant QIdentityProxyModel::data(const QModelIndex &proxyIndex, int role)
  QVariant cbs_data_c3054_1(const QModelIndex &proxyIndex, int role) const
  {
    return QIdentityProxyModel::data(proxyIndex, role);
  }

  virtual QVariant data(const QModelIndex &proxyIndex, int role) const
  {
    if (cb_data_c3054_1.can_issue()) {
      return cb_data_c3054_1.issue<QIdentityProxyModel_Adaptor, QVariant, const QModelIndex &, int>(&QIdentityProxyModel_Adaptor::cbs_data_c3054_1, proxyIndex, role);
    } else {
      return QIdentityProxyModel::data(proxyIndex, role);
    }
  }

  //  [emitter impl] void QIdentityProxyModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QVector<int> &roles)
  void emitter_QIdentityProxyModel_dataChanged_7048(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QVector<int> &roles)
  {
    emit QIdentityProxyModel::dataChanged(topLeft, bottomRight, roles);
  }

  //  [emitter impl] void QIdentityProxyModel::destroyed(QObject *)
  void emitter_QIdentityProxyModel_destroyed_1302(QObject *arg1)
  {
    emit QIdentityProxyModel::destroyed(arg1);
  }

  //  [adaptor impl] bool QIdentityProxyModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)
  bool cbs_dropMimeData_7425_0(const QMimeData *data, const qt_gsi::Converter<Qt::DropAction>::target_type & action, int row, int column, const QModelIndex &parent)
  {
    return QIdentityProxyModel::dropMimeData(data, qt_gsi::QtToCppAdaptor<Qt::DropAction>(action).cref(), row, column, parent);
  }

  virtual bool dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)
  {
    if (cb_dropMimeData_7425_0.can_issue()) {
      return cb_dropMimeData_7425_0.issue<QIdentityProxyModel_Adaptor, bool, const QMimeData *, const qt_gsi::Converter<Qt::DropAction>::target_type &, int, int, const QModelIndex &>(&QIdentityProxyModel_Adaptor::cbs_dropMimeData_7425_0, data, qt_gsi::CppToQtAdaptor<Qt::DropAction>(action), row, column, parent);
    } else {
      return QIdentityProxyModel::dropMimeData(data, action, row, column, parent);
    }
  }

  //  [adaptor impl] bool QIdentityProxyModel::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QIdentityProxyModel::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QIdentityProxyModel_Adaptor, bool, QEvent *>(&QIdentityProxyModel_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QIdentityProxyModel::event(arg1);
    }
  }

  //  [adaptor impl] bool QIdentityProxyModel::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QIdentityProxyModel::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QIdentityProxyModel_Adaptor, bool, QObject *, QEvent *>(&QIdentityProxyModel_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QIdentityProxyModel::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QIdentityProxyModel::fetchMore(const QModelIndex &parent)
  void cbs_fetchMore_2395_0(const QModelIndex &parent)
  {
    QIdentityProxyModel::fetchMore(parent);
  }

  virtual void fetchMore(const QModelIndex &parent)
  {
    if (cb_fetchMore_2395_0.can_issue()) {
      cb_fetchMore_2395_0.issue<QIdentityProxyModel_Adaptor, const QModelIndex &>(&QIdentityProxyModel_Adaptor::cbs_fetchMore_2395_0, parent);
    } else {
      QIdentityProxyModel::fetchMore(parent);
    }
  }

  //  [adaptor impl] QFlags<Qt::ItemFlag> QIdentityProxyModel::flags(const QModelIndex &index)
  QFlags<Qt::ItemFlag> cbs_flags_c2395_0(const QModelIndex &index) const
  {
    return QIdentityProxyModel::flags(index);
  }

  virtual QFlags<Qt::ItemFlag> flags(const QModelIndex &index) const
  {
    if (cb_flags_c2395_0.can_issue()) {
      return cb_flags_c2395_0.issue<QIdentityProxyModel_Adaptor, QFlags<Qt::ItemFlag>, const QModelIndex &>(&QIdentityProxyModel_Adaptor::cbs_flags_c2395_0, index);
    } else {
      return QIdentityProxyModel::flags(index);
    }
  }

  //  [adaptor impl] bool QIdentityProxyModel::hasChildren(const QModelIndex &parent)
  bool cbs_hasChildren_c2395_1(const QModelIndex &parent) const
  {
    return QIdentityProxyModel::hasChildren(parent);
  }

  virtual bool hasChildren(const QModelIndex &parent) const
  {
    if (cb_hasChildren_c2395_1.can_issue()) {
      return cb_hasChildren_c2395_1.issue<QIdentityProxyModel_Adaptor, bool, const QModelIndex &>(&QIdentityProxyModel_Adaptor::cbs_hasChildren_c2395_1, parent);
    } else {
      return QIdentityProxyModel::hasChildren(parent);
    }
  }

  //  [adaptor impl] QVariant QIdentityProxyModel::headerData(int section, Qt::Orientation orientation, int role)
  QVariant cbs_headerData_c3231_1(int section, const qt_gsi::Converter<Qt::Orientation>::target_type & orientation, int role) const
  {
    return QIdentityProxyModel::headerData(section, qt_gsi::QtToCppAdaptor<Qt::Orientation>(orientation).cref(), role);
  }

  virtual QVariant headerData(int section, Qt::Orientation orientation, int role) const
  {
    if (cb_headerData_c3231_1.can_issue()) {
      return cb_headerData_c3231_1.issue<QIdentityProxyModel_Adaptor, QVariant, int, const qt_gsi::Converter<Qt::Orientation>::target_type &, int>(&QIdentityProxyModel_Adaptor::cbs_headerData_c3231_1, section, qt_gsi::CppToQtAdaptor<Qt::Orientation>(orientation), role);
    } else {
      return QIdentityProxyModel::headerData(section, orientation, role);
    }
  }

  //  [emitter impl] void QIdentityProxyModel::headerDataChanged(Qt::Orientation orientation, int first, int last)
  void emitter_QIdentityProxyModel_headerDataChanged_3231(Qt::Orientation orientation, int first, int last)
  {
    emit QIdentityProxyModel::headerDataChanged(orientation, first, last);
  }

  //  [adaptor impl] QModelIndex QIdentityProxyModel::index(int row, int column, const QModelIndex &parent)
  QModelIndex cbs_index_c3713_1(int row, int column, const QModelIndex &parent) const
  {
    return QIdentityProxyModel::index(row, column, parent);
  }

  virtual QModelIndex index(int row, int column, const QModelIndex &parent) const
  {
    if (cb_index_c3713_1.can_issue()) {
      return cb_index_c3713_1.issue<QIdentityProxyModel_Adaptor, QModelIndex, int, int, const QModelIndex &>(&QIdentityProxyModel_Adaptor::cbs_index_c3713_1, row, column, parent);
    } else {
      return QIdentityProxyModel::index(row, column, parent);
    }
  }

  //  [adaptor impl] bool QIdentityProxyModel::insertColumns(int column, int count, const QModelIndex &parent)
  bool cbs_insertColumns_3713_1(int column, int count, const QModelIndex &parent)
  {
    return QIdentityProxyModel::insertColumns(column, count, parent);
  }

  virtual bool insertColumns(int column, int count, const QModelIndex &parent)
  {
    if (cb_insertColumns_3713_1.can_issue()) {
      return cb_insertColumns_3713_1.issue<QIdentityProxyModel_Adaptor, bool, int, int, const QModelIndex &>(&QIdentityProxyModel_Adaptor::cbs_insertColumns_3713_1, column, count, parent);
    } else {
      return QIdentityProxyModel::insertColumns(column, count, parent);
    }
  }

  //  [adaptor impl] bool QIdentityProxyModel::insertRows(int row, int count, const QModelIndex &parent)
  bool cbs_insertRows_3713_1(int row, int count, const QModelIndex &parent)
  {
    return QIdentityProxyModel::insertRows(row, count, parent);
  }

  virtual bool insertRows(int row, int count, const QModelIndex &parent)
  {
    if (cb_insertRows_3713_1.can_issue()) {
      return cb_insertRows_3713_1.issue<QIdentityProxyModel_Adaptor, bool, int, int, const QModelIndex &>(&QIdentityProxyModel_Adaptor::cbs_insertRows_3713_1, row, count, parent);
    } else {
      return QIdentityProxyModel::insertRows(row, count, parent);
    }
  }

  //  [adaptor impl] QMap<int, QVariant> QIdentityProxyModel::itemData(const QModelIndex &index)
  QMap<int, QVariant> cbs_itemData_c2395_0(const QModelIndex &index) const
  {
    return QIdentityProxyModel::itemData(index);
  }

  virtual QMap<int, QVariant> itemData(const QModelIndex &index) const
  {
    if (cb_itemData_c2395_0.can_issue()) {
      return cb_itemData_c2395_0.issue<QIdentityProxyModel_Adaptor, QMap<int, QVariant>, const QModelIndex &>(&QIdentityProxyModel_Adaptor::cbs_itemData_c2395_0, index);
    } else {
      return QIdentityProxyModel::itemData(index);
    }
  }

  //  [emitter impl] void QIdentityProxyModel::layoutAboutToBeChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)
  void emitter_QIdentityProxyModel_layoutAboutToBeChanged_7947(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)
  {
    emit QIdentityProxyModel::layoutAboutToBeChanged(parents, hint);
  }

  //  [emitter impl] void QIdentityProxyModel::layoutChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)
  void emitter_QIdentityProxyModel_layoutChanged_7947(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)
  {
    emit QIdentityProxyModel::layoutChanged(parents, hint);
  }

  //  [adaptor impl] QModelIndex QIdentityProxyModel::mapFromSource(const QModelIndex &sourceIndex)
  QModelIndex cbs_mapFromSource_c2395_0(const QModelIndex &sourceIndex) const
  {
    return QIdentityProxyModel::mapFromSource(sourceIndex);
  }

  virtual QModelIndex mapFromSource(const QModelIndex &sourceIndex) const
  {
    if (cb_mapFromSource_c2395_0.can_issue()) {
      return cb_mapFromSource_c2395_0.issue<QIdentityProxyModel_Adaptor, QModelIndex, const QModelIndex &>(&QIdentityProxyModel_Adaptor::cbs_mapFromSource_c2395_0, sourceIndex);
    } else {
      return QIdentityProxyModel::mapFromSource(sourceIndex);
    }
  }

  //  [adaptor impl] QItemSelection QIdentityProxyModel::mapSelectionFromSource(const QItemSelection &selection)
  QItemSelection cbs_mapSelectionFromSource_c2727_0(const QItemSelection &selection) const
  {
    return QIdentityProxyModel::mapSelectionFromSource(selection);
  }

  virtual QItemSelection mapSelectionFromSource(const QItemSelection &selection) const
  {
    if (cb_mapSelectionFromSource_c2727_0.can_issue()) {
      return cb_mapSelectionFromSource_c2727_0.issue<QIdentityProxyModel_Adaptor, QItemSelection, const QItemSelection &>(&QIdentityProxyModel_Adaptor::cbs_mapSelectionFromSource_c2727_0, selection);
    } else {
      return QIdentityProxyModel::mapSelectionFromSource(selection);
    }
  }

  //  [adaptor impl] QItemSelection QIdentityProxyModel::mapSelectionToSource(const QItemSelection &selection)
  QItemSelection cbs_mapSelectionToSource_c2727_0(const QItemSelection &selection) const
  {
    return QIdentityProxyModel::mapSelectionToSource(selection);
  }

  virtual QItemSelection mapSelectionToSource(const QItemSelection &selection) const
  {
    if (cb_mapSelectionToSource_c2727_0.can_issue()) {
      return cb_mapSelectionToSource_c2727_0.issue<QIdentityProxyModel_Adaptor, QItemSelection, const QItemSelection &>(&QIdentityProxyModel_Adaptor::cbs_mapSelectionToSource_c2727_0, selection);
    } else {
      return QIdentityProxyModel::mapSelectionToSource(selection);
    }
  }

  //  [adaptor impl] QModelIndex QIdentityProxyModel::mapToSource(const QModelIndex &proxyIndex)
  QModelIndex cbs_mapToSource_c2395_0(const QModelIndex &proxyIndex) const
  {
    return QIdentityProxyModel::mapToSource(proxyIndex);
  }

  virtual QModelIndex mapToSource(const QModelIndex &proxyIndex) const
  {
    if (cb_mapToSource_c2395_0.can_issue()) {
      return cb_mapToSource_c2395_0.issue<QIdentityProxyModel_Adaptor, QModelIndex, const QModelIndex &>(&QIdentityProxyModel_Adaptor::cbs_mapToSource_c2395_0, proxyIndex);
    } else {
      return QIdentityProxyModel::mapToSource(proxyIndex);
    }
  }

  //  [adaptor impl] QList<QModelIndex> QIdentityProxyModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)
  QList<QModelIndex> cbs_match_c7932_2(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags) const
  {
    return QIdentityProxyModel::match(start, role, value, hits, flags);
  }

  virtual QList<QModelIndex> match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags) const
  {
    if (cb_match_c7932_2.can_issue()) {
      return cb_match_c7932_2.issue<QIdentityProxyModel_Adaptor, QList<QModelIndex>, const QModelIndex &, int, const QVariant &, int, QFlags<Qt::MatchFlag> >(&QIdentityProxyModel_Adaptor::cbs_match_c7932_2, start, role, value, hits, flags);
    } else {
      return QIdentityProxyModel::match(start, role, value, hits, flags);
    }
  }

  //  [adaptor impl] QMimeData *QIdentityProxyModel::mimeData(const QList<QModelIndex> &indexes)
  QMimeData * cbs_mimeData_c3010_0(const QList<QModelIndex> &indexes) const
  {
    return QIdentityProxyModel::mimeData(indexes);
  }

  virtual QMimeData * mimeData(const QList<QModelIndex> &indexes) const
  {
    if (cb_mimeData_c3010_0.can_issue()) {
      return cb_mimeData_c3010_0.issue<QIdentityProxyModel_Adaptor, QMimeData *, const QList<QModelIndex> &>(&QIdentityProxyModel_Adaptor::cbs_mimeData_c3010_0, indexes);
    } else {
      return QIdentityProxyModel::mimeData(indexes);
    }
  }

  //  [adaptor impl] QStringList QIdentityProxyModel::mimeTypes()
  QStringList cbs_mimeTypes_c0_0() const
  {
    return QIdentityProxyModel::mimeTypes();
  }

  virtual QStringList mimeTypes() const
  {
    if (cb_mimeTypes_c0_0.can_issue()) {
      return cb_mimeTypes_c0_0.issue<QIdentityProxyModel_Adaptor, QStringList>(&QIdentityProxyModel_Adaptor::cbs_mimeTypes_c0_0);
    } else {
      return QIdentityProxyModel::mimeTypes();
    }
  }

  //  [emitter impl] void QIdentityProxyModel::modelAboutToBeReset()
  void emitter_QIdentityProxyModel_modelAboutToBeReset_3767()
  {
    throw tl::Exception ("Can't emit private signal 'void QIdentityProxyModel::modelAboutToBeReset()'");
  }

  //  [emitter impl] void QIdentityProxyModel::modelReset()
  void emitter_QIdentityProxyModel_modelReset_3767()
  {
    throw tl::Exception ("Can't emit private signal 'void QIdentityProxyModel::modelReset()'");
  }

  //  [adaptor impl] bool QIdentityProxyModel::moveColumns(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)
  bool cbs_moveColumns_6659_0(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)
  {
    return QIdentityProxyModel::moveColumns(sourceParent, sourceColumn, count, destinationParent, destinationChild);
  }

  virtual bool moveColumns(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)
  {
    if (cb_moveColumns_6659_0.can_issue()) {
      return cb_moveColumns_6659_0.issue<QIdentityProxyModel_Adaptor, bool, const QModelIndex &, int, int, const QModelIndex &, int>(&QIdentityProxyModel_Adaptor::cbs_moveColumns_6659_0, sourceParent, sourceColumn, count, destinationParent, destinationChild);
    } else {
      return QIdentityProxyModel::moveColumns(sourceParent, sourceColumn, count, destinationParent, destinationChild);
    }
  }

  //  [adaptor impl] bool QIdentityProxyModel::moveRows(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)
  bool cbs_moveRows_6659_0(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)
  {
    return QIdentityProxyModel::moveRows(sourceParent, sourceRow, count, destinationParent, destinationChild);
  }

  virtual bool moveRows(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)
  {
    if (cb_moveRows_6659_0.can_issue()) {
      return cb_moveRows_6659_0.issue<QIdentityProxyModel_Adaptor, bool, const QModelIndex &, int, int, const QModelIndex &, int>(&QIdentityProxyModel_Adaptor::cbs_moveRows_6659_0, sourceParent, sourceRow, count, destinationParent, destinationChild);
    } else {
      return QIdentityProxyModel::moveRows(sourceParent, sourceRow, count, destinationParent, destinationChild);
    }
  }

  //  [emitter impl] void QIdentityProxyModel::objectNameChanged(const QString &objectName)
  void emitter_QIdentityProxyModel_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QIdentityProxyModel::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] QModelIndex QIdentityProxyModel::parent(const QModelIndex &child)
  QModelIndex cbs_parent_c2395_0(const QModelIndex &child) const
  {
    return QIdentityProxyModel::parent(child);
  }

  virtual QModelIndex parent(const QModelIndex &child) const
  {
    if (cb_parent_c2395_0.can_issue()) {
      return cb_parent_c2395_0.issue<QIdentityProxyModel_Adaptor, QModelIndex, const QModelIndex &>(&QIdentityProxyModel_Adaptor::cbs_parent_c2395_0, child);
    } else {
      return QIdentityProxyModel::parent(child);
    }
  }

  //  [adaptor impl] bool QIdentityProxyModel::removeColumns(int column, int count, const QModelIndex &parent)
  bool cbs_removeColumns_3713_1(int column, int count, const QModelIndex &parent)
  {
    return QIdentityProxyModel::removeColumns(column, count, parent);
  }

  virtual bool removeColumns(int column, int count, const QModelIndex &parent)
  {
    if (cb_removeColumns_3713_1.can_issue()) {
      return cb_removeColumns_3713_1.issue<QIdentityProxyModel_Adaptor, bool, int, int, const QModelIndex &>(&QIdentityProxyModel_Adaptor::cbs_removeColumns_3713_1, column, count, parent);
    } else {
      return QIdentityProxyModel::removeColumns(column, count, parent);
    }
  }

  //  [adaptor impl] bool QIdentityProxyModel::removeRows(int row, int count, const QModelIndex &parent)
  bool cbs_removeRows_3713_1(int row, int count, const QModelIndex &parent)
  {
    return QIdentityProxyModel::removeRows(row, count, parent);
  }

  virtual bool removeRows(int row, int count, const QModelIndex &parent)
  {
    if (cb_removeRows_3713_1.can_issue()) {
      return cb_removeRows_3713_1.issue<QIdentityProxyModel_Adaptor, bool, int, int, const QModelIndex &>(&QIdentityProxyModel_Adaptor::cbs_removeRows_3713_1, row, count, parent);
    } else {
      return QIdentityProxyModel::removeRows(row, count, parent);
    }
  }

  //  [adaptor impl] void QIdentityProxyModel::revert()
  void cbs_revert_0_0()
  {
    QIdentityProxyModel::revert();
  }

  virtual void revert()
  {
    if (cb_revert_0_0.can_issue()) {
      cb_revert_0_0.issue<QIdentityProxyModel_Adaptor>(&QIdentityProxyModel_Adaptor::cbs_revert_0_0);
    } else {
      QIdentityProxyModel::revert();
    }
  }

  //  [adaptor impl] QHash<int, QByteArray> QIdentityProxyModel::roleNames()
  QHash<int, QByteArray> cbs_roleNames_c0_0() const
  {
    return QIdentityProxyModel::roleNames();
  }

  virtual QHash<int, QByteArray> roleNames() const
  {
    if (cb_roleNames_c0_0.can_issue()) {
      return cb_roleNames_c0_0.issue<QIdentityProxyModel_Adaptor, QHash<int, QByteArray> >(&QIdentityProxyModel_Adaptor::cbs_roleNames_c0_0);
    } else {
      return QIdentityProxyModel::roleNames();
    }
  }

  //  [adaptor impl] int QIdentityProxyModel::rowCount(const QModelIndex &parent)
  int cbs_rowCount_c2395_1(const QModelIndex &parent) const
  {
    return QIdentityProxyModel::rowCount(parent);
  }

  virtual int rowCount(const QModelIndex &parent) const
  {
    if (cb_rowCount_c2395_1.can_issue()) {
      return cb_rowCount_c2395_1.issue<QIdentityProxyModel_Adaptor, int, const QModelIndex &>(&QIdentityProxyModel_Adaptor::cbs_rowCount_c2395_1, parent);
    } else {
      return QIdentityProxyModel::rowCount(parent);
    }
  }

  //  [emitter impl] void QIdentityProxyModel::rowsAboutToBeInserted(const QModelIndex &parent, int first, int last)
  void emitter_QIdentityProxyModel_rowsAboutToBeInserted_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QIdentityProxyModel::rowsAboutToBeInserted(const QModelIndex &parent, int first, int last)'");
  }

  //  [emitter impl] void QIdentityProxyModel::rowsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationRow)
  void emitter_QIdentityProxyModel_rowsAboutToBeMoved_10318(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationRow)
  {
    __SUPPRESS_UNUSED_WARNING (sourceParent);
    __SUPPRESS_UNUSED_WARNING (sourceStart);
    __SUPPRESS_UNUSED_WARNING (sourceEnd);
    __SUPPRESS_UNUSED_WARNING (destinationParent);
    __SUPPRESS_UNUSED_WARNING (destinationRow);
    throw tl::Exception ("Can't emit private signal 'void QIdentityProxyModel::rowsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationRow)'");
  }

  //  [emitter impl] void QIdentityProxyModel::rowsAboutToBeRemoved(const QModelIndex &parent, int first, int last)
  void emitter_QIdentityProxyModel_rowsAboutToBeRemoved_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QIdentityProxyModel::rowsAboutToBeRemoved(const QModelIndex &parent, int first, int last)'");
  }

  //  [emitter impl] void QIdentityProxyModel::rowsInserted(const QModelIndex &parent, int first, int last)
  void emitter_QIdentityProxyModel_rowsInserted_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QIdentityProxyModel::rowsInserted(const QModelIndex &parent, int first, int last)'");
  }

  //  [emitter impl] void QIdentityProxyModel::rowsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int row)
  void emitter_QIdentityProxyModel_rowsMoved_10318(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int row)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (start);
    __SUPPRESS_UNUSED_WARNING (end);
    __SUPPRESS_UNUSED_WARNING (destination);
    __SUPPRESS_UNUSED_WARNING (row);
    throw tl::Exception ("Can't emit private signal 'void QIdentityProxyModel::rowsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int row)'");
  }

  //  [emitter impl] void QIdentityProxyModel::rowsRemoved(const QModelIndex &parent, int first, int last)
  void emitter_QIdentityProxyModel_rowsRemoved_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QIdentityProxyModel::rowsRemoved(const QModelIndex &parent, int first, int last)'");
  }

  //  [adaptor impl] bool QIdentityProxyModel::setData(const QModelIndex &index, const QVariant &value, int role)
  bool cbs_setData_5065_1(const QModelIndex &index, const QVariant &value, int role)
  {
    return QIdentityProxyModel::setData(index, value, role);
  }

  virtual bool setData(const QModelIndex &index, const QVariant &value, int role)
  {
    if (cb_setData_5065_1.can_issue()) {
      return cb_setData_5065_1.issue<QIdentityProxyModel_Adaptor, bool, const QModelIndex &, const QVariant &, int>(&QIdentityProxyModel_Adaptor::cbs_setData_5065_1, index, value, role);
    } else {
      return QIdentityProxyModel::setData(index, value, role);
    }
  }

  //  [adaptor impl] bool QIdentityProxyModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)
  bool cbs_setHeaderData_5242_1(int section, const qt_gsi::Converter<Qt::Orientation>::target_type & orientation, const QVariant &value, int role)
  {
    return QIdentityProxyModel::setHeaderData(section, qt_gsi::QtToCppAdaptor<Qt::Orientation>(orientation).cref(), value, role);
  }

  virtual bool setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)
  {
    if (cb_setHeaderData_5242_1.can_issue()) {
      return cb_setHeaderData_5242_1.issue<QIdentityProxyModel_Adaptor, bool, int, const qt_gsi::Converter<Qt::Orientation>::target_type &, const QVariant &, int>(&QIdentityProxyModel_Adaptor::cbs_setHeaderData_5242_1, section, qt_gsi::CppToQtAdaptor<Qt::Orientation>(orientation), value, role);
    } else {
      return QIdentityProxyModel::setHeaderData(section, orientation, value, role);
    }
  }

  //  [adaptor impl] bool QIdentityProxyModel::setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)
  bool cbs_setItemData_5414_0(const QModelIndex &index, const QMap<int, QVariant> &roles)
  {
    return QIdentityProxyModel::setItemData(index, roles);
  }

  virtual bool setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)
  {
    if (cb_setItemData_5414_0.can_issue()) {
      return cb_setItemData_5414_0.issue<QIdentityProxyModel_Adaptor, bool, const QModelIndex &, const QMap<int, QVariant> &>(&QIdentityProxyModel_Adaptor::cbs_setItemData_5414_0, index, roles);
    } else {
      return QIdentityProxyModel::setItemData(index, roles);
    }
  }

  //  [adaptor impl] void QIdentityProxyModel::setSourceModel(QAbstractItemModel *sourceModel)
  void cbs_setSourceModel_2419_0(QAbstractItemModel *sourceModel)
  {
    QIdentityProxyModel::setSourceModel(sourceModel);
  }

  virtual void setSourceModel(QAbstractItemModel *sourceModel)
  {
    if (cb_setSourceModel_2419_0.can_issue()) {
      cb_setSourceModel_2419_0.issue<QIdentityProxyModel_Adaptor, QAbstractItemModel *>(&QIdentityProxyModel_Adaptor::cbs_setSourceModel_2419_0, sourceModel);
    } else {
      QIdentityProxyModel::setSourceModel(sourceModel);
    }
  }

  //  [adaptor impl] QModelIndex QIdentityProxyModel::sibling(int row, int column, const QModelIndex &idx)
  QModelIndex cbs_sibling_c3713_0(int row, int column, const QModelIndex &idx) const
  {
    return QIdentityProxyModel::sibling(row, column, idx);
  }

  virtual QModelIndex sibling(int row, int column, const QModelIndex &idx) const
  {
    if (cb_sibling_c3713_0.can_issue()) {
      return cb_sibling_c3713_0.issue<QIdentityProxyModel_Adaptor, QModelIndex, int, int, const QModelIndex &>(&QIdentityProxyModel_Adaptor::cbs_sibling_c3713_0, row, column, idx);
    } else {
      return QIdentityProxyModel::sibling(row, column, idx);
    }
  }

  //  [adaptor impl] void QIdentityProxyModel::sort(int column, Qt::SortOrder order)
  void cbs_sort_2340_1(int column, const qt_gsi::Converter<Qt::SortOrder>::target_type & order)
  {
    QIdentityProxyModel::sort(column, qt_gsi::QtToCppAdaptor<Qt::SortOrder>(order).cref());
  }

  virtual void sort(int column, Qt::SortOrder order)
  {
    if (cb_sort_2340_1.can_issue()) {
      cb_sort_2340_1.issue<QIdentityProxyModel_Adaptor, int, const qt_gsi::Converter<Qt::SortOrder>::target_type &>(&QIdentityProxyModel_Adaptor::cbs_sort_2340_1, column, qt_gsi::CppToQtAdaptor<Qt::SortOrder>(order));
    } else {
      QIdentityProxyModel::sort(column, order);
    }
  }

  //  [emitter impl] void QIdentityProxyModel::sourceModelChanged()
  void emitter_QIdentityProxyModel_sourceModelChanged_3914()
  {
    throw tl::Exception ("Can't emit private signal 'void QIdentityProxyModel::sourceModelChanged()'");
  }

  //  [adaptor impl] QSize QIdentityProxyModel::span(const QModelIndex &index)
  QSize cbs_span_c2395_0(const QModelIndex &index) const
  {
    return QIdentityProxyModel::span(index);
  }

  virtual QSize span(const QModelIndex &index) const
  {
    if (cb_span_c2395_0.can_issue()) {
      return cb_span_c2395_0.issue<QIdentityProxyModel_Adaptor, QSize, const QModelIndex &>(&QIdentityProxyModel_Adaptor::cbs_span_c2395_0, index);
    } else {
      return QIdentityProxyModel::span(index);
    }
  }

  //  [adaptor impl] bool QIdentityProxyModel::submit()
  bool cbs_submit_0_0()
  {
    return QIdentityProxyModel::submit();
  }

  virtual bool submit()
  {
    if (cb_submit_0_0.can_issue()) {
      return cb_submit_0_0.issue<QIdentityProxyModel_Adaptor, bool>(&QIdentityProxyModel_Adaptor::cbs_submit_0_0);
    } else {
      return QIdentityProxyModel::submit();
    }
  }

  //  [adaptor impl] QFlags<Qt::DropAction> QIdentityProxyModel::supportedDragActions()
  QFlags<Qt::DropAction> cbs_supportedDragActions_c0_0() const
  {
    return QIdentityProxyModel::supportedDragActions();
  }

  virtual QFlags<Qt::DropAction> supportedDragActions() const
  {
    if (cb_supportedDragActions_c0_0.can_issue()) {
      return cb_supportedDragActions_c0_0.issue<QIdentityProxyModel_Adaptor, QFlags<Qt::DropAction> >(&QIdentityProxyModel_Adaptor::cbs_supportedDragActions_c0_0);
    } else {
      return QIdentityProxyModel::supportedDragActions();
    }
  }

  //  [adaptor impl] QFlags<Qt::DropAction> QIdentityProxyModel::supportedDropActions()
  QFlags<Qt::DropAction> cbs_supportedDropActions_c0_0() const
  {
    return QIdentityProxyModel::supportedDropActions();
  }

  virtual QFlags<Qt::DropAction> supportedDropActions() const
  {
    if (cb_supportedDropActions_c0_0.can_issue()) {
      return cb_supportedDropActions_c0_0.issue<QIdentityProxyModel_Adaptor, QFlags<Qt::DropAction> >(&QIdentityProxyModel_Adaptor::cbs_supportedDropActions_c0_0);
    } else {
      return QIdentityProxyModel::supportedDropActions();
    }
  }

  //  [adaptor impl] void QIdentityProxyModel::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QIdentityProxyModel::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QIdentityProxyModel_Adaptor, QChildEvent *>(&QIdentityProxyModel_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QIdentityProxyModel::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QIdentityProxyModel::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QIdentityProxyModel::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QIdentityProxyModel_Adaptor, QEvent *>(&QIdentityProxyModel_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QIdentityProxyModel::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QIdentityProxyModel::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QIdentityProxyModel::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QIdentityProxyModel_Adaptor, const QMetaMethod &>(&QIdentityProxyModel_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QIdentityProxyModel::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QIdentityProxyModel::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QIdentityProxyModel::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QIdentityProxyModel_Adaptor, QTimerEvent *>(&QIdentityProxyModel_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QIdentityProxyModel::timerEvent(arg1);
    }
  }

  gsi::Callback cb_buddy_c2395_0;
  gsi::Callback cb_canDropMimeData_c7425_0;
  gsi::Callback cb_canFetchMore_c2395_0;
  gsi::Callback cb_columnCount_c2395_1;
  gsi::Callback cb_data_c3054_1;
  gsi::Callback cb_dropMimeData_7425_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_fetchMore_2395_0;
  gsi::Callback cb_flags_c2395_0;
  gsi::Callback cb_hasChildren_c2395_1;
  gsi::Callback cb_headerData_c3231_1;
  gsi::Callback cb_index_c3713_1;
  gsi::Callback cb_insertColumns_3713_1;
  gsi::Callback cb_insertRows_3713_1;
  gsi::Callback cb_itemData_c2395_0;
  gsi::Callback cb_mapFromSource_c2395_0;
  gsi::Callback cb_mapSelectionFromSource_c2727_0;
  gsi::Callback cb_mapSelectionToSource_c2727_0;
  gsi::Callback cb_mapToSource_c2395_0;
  gsi::Callback cb_match_c7932_2;
  gsi::Callback cb_mimeData_c3010_0;
  gsi::Callback cb_mimeTypes_c0_0;
  gsi::Callback cb_moveColumns_6659_0;
  gsi::Callback cb_moveRows_6659_0;
  gsi::Callback cb_parent_c2395_0;
  gsi::Callback cb_removeColumns_3713_1;
  gsi::Callback cb_removeRows_3713_1;
  gsi::Callback cb_revert_0_0;
  gsi::Callback cb_roleNames_c0_0;
  gsi::Callback cb_rowCount_c2395_1;
  gsi::Callback cb_setData_5065_1;
  gsi::Callback cb_setHeaderData_5242_1;
  gsi::Callback cb_setItemData_5414_0;
  gsi::Callback cb_setSourceModel_2419_0;
  gsi::Callback cb_sibling_c3713_0;
  gsi::Callback cb_sort_2340_1;
  gsi::Callback cb_span_c2395_0;
  gsi::Callback cb_submit_0_0;
  gsi::Callback cb_supportedDragActions_c0_0;
  gsi::Callback cb_supportedDropActions_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QIdentityProxyModel_Adaptor::~QIdentityProxyModel_Adaptor() { }

//  Constructor QIdentityProxyModel::QIdentityProxyModel(QObject *parent) (adaptor class)

static void _init_ctor_QIdentityProxyModel_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QIdentityProxyModel_Adaptor> ();
}

static void _call_ctor_QIdentityProxyModel_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QIdentityProxyModel_Adaptor *> (new QIdentityProxyModel_Adaptor (arg1));
}


// exposed void QIdentityProxyModel::beginInsertColumns(const QModelIndex &parent, int first, int last)

static void _init_fp_beginInsertColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginInsertColumns_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QIdentityProxyModel_Adaptor *)cls)->fp_QIdentityProxyModel_beginInsertColumns_3713 (arg1, arg2, arg3);
}


// exposed void QIdentityProxyModel::beginInsertRows(const QModelIndex &parent, int first, int last)

static void _init_fp_beginInsertRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginInsertRows_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QIdentityProxyModel_Adaptor *)cls)->fp_QIdentityProxyModel_beginInsertRows_3713 (arg1, arg2, arg3);
}


// exposed bool QIdentityProxyModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)

static void _init_fp_beginMoveColumns_6659 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceFirst");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceLast");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationColumn");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_fp_beginMoveColumns_6659 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QIdentityProxyModel_Adaptor *)cls)->fp_QIdentityProxyModel_beginMoveColumns_6659 (arg1, arg2, arg3, arg4, arg5));
}


// exposed bool QIdentityProxyModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)

static void _init_fp_beginMoveRows_6659 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceFirst");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceLast");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationRow");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_fp_beginMoveRows_6659 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QIdentityProxyModel_Adaptor *)cls)->fp_QIdentityProxyModel_beginMoveRows_6659 (arg1, arg2, arg3, arg4, arg5));
}


// exposed void QIdentityProxyModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)

static void _init_fp_beginRemoveColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginRemoveColumns_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QIdentityProxyModel_Adaptor *)cls)->fp_QIdentityProxyModel_beginRemoveColumns_3713 (arg1, arg2, arg3);
}


// exposed void QIdentityProxyModel::beginRemoveRows(const QModelIndex &parent, int first, int last)

static void _init_fp_beginRemoveRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginRemoveRows_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QIdentityProxyModel_Adaptor *)cls)->fp_QIdentityProxyModel_beginRemoveRows_3713 (arg1, arg2, arg3);
}


// exposed void QIdentityProxyModel::beginResetModel()

static void _init_fp_beginResetModel_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_beginResetModel_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QIdentityProxyModel_Adaptor *)cls)->fp_QIdentityProxyModel_beginResetModel_0 ();
}


// QModelIndex QIdentityProxyModel::buddy(const QModelIndex &index)

static void _init_cbs_buddy_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_buddy_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QIdentityProxyModel_Adaptor *)cls)->cbs_buddy_c2395_0 (arg1));
}

static void _set_callback_cbs_buddy_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_buddy_c2395_0 = cb;
}


// bool QIdentityProxyModel::canDropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)

static void _init_cbs_canDropMimeData_c7425_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QMimeData * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("action");
  decl->add_arg<const qt_gsi::Converter<Qt::DropAction>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("row");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("column");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_cbs_canDropMimeData_c7425_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMimeData *arg1 = args.read<const QMimeData * > (heap);
  const qt_gsi::Converter<Qt::DropAction>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::DropAction>::target_type & > (heap);
  int arg3 = args.read<int > (heap);
  int arg4 = args.read<int > (heap);
  const QModelIndex &arg5 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QIdentityProxyModel_Adaptor *)cls)->cbs_canDropMimeData_c7425_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_canDropMimeData_c7425_0 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_canDropMimeData_c7425_0 = cb;
}


// bool QIdentityProxyModel::canFetchMore(const QModelIndex &parent)

static void _init_cbs_canFetchMore_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_canFetchMore_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QIdentityProxyModel_Adaptor *)cls)->cbs_canFetchMore_c2395_0 (arg1));
}

static void _set_callback_cbs_canFetchMore_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_canFetchMore_c2395_0 = cb;
}


// exposed void QIdentityProxyModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)

static void _init_fp_changePersistentIndex_4682 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("to");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_changePersistentIndex_4682 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QIdentityProxyModel_Adaptor *)cls)->fp_QIdentityProxyModel_changePersistentIndex_4682 (arg1, arg2);
}


// exposed void QIdentityProxyModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)

static void _init_fp_changePersistentIndexList_5912 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<const QList<QModelIndex> & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("to");
  decl->add_arg<const QList<QModelIndex> & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_changePersistentIndexList_5912 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QModelIndex> &arg1 = gsi::arg_reader<const QList<QModelIndex> & >() (args, heap);
  const QList<QModelIndex> &arg2 = gsi::arg_reader<const QList<QModelIndex> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QIdentityProxyModel_Adaptor *)cls)->fp_QIdentityProxyModel_changePersistentIndexList_5912 (arg1, arg2);
}


// void QIdentityProxyModel::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QIdentityProxyModel_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// int QIdentityProxyModel::columnCount(const QModelIndex &parent)

static void _init_cbs_columnCount_c2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_columnCount_c2395_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<int > ((int)((QIdentityProxyModel_Adaptor *)cls)->cbs_columnCount_c2395_1 (arg1));
}

static void _set_callback_cbs_columnCount_c2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_columnCount_c2395_1 = cb;
}


// emitter void QIdentityProxyModel::columnsAboutToBeInserted(const QModelIndex &parent, int first, int last)

static void _init_emitter_columnsAboutToBeInserted_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_columnsAboutToBeInserted_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QIdentityProxyModel_Adaptor *)cls)->emitter_QIdentityProxyModel_columnsAboutToBeInserted_7372 (arg1, arg2, arg3);
}


// emitter void QIdentityProxyModel::columnsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationColumn)

static void _init_emitter_columnsAboutToBeMoved_10318 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceStart");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceEnd");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationColumn");
  decl->add_arg<int > (argspec_4);
  decl->set_return<void > ();
}

static void _call_emitter_columnsAboutToBeMoved_10318 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ((QIdentityProxyModel_Adaptor *)cls)->emitter_QIdentityProxyModel_columnsAboutToBeMoved_10318 (arg1, arg2, arg3, arg4, arg5);
}


// emitter void QIdentityProxyModel::columnsAboutToBeRemoved(const QModelIndex &parent, int first, int last)

static void _init_emitter_columnsAboutToBeRemoved_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_columnsAboutToBeRemoved_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QIdentityProxyModel_Adaptor *)cls)->emitter_QIdentityProxyModel_columnsAboutToBeRemoved_7372 (arg1, arg2, arg3);
}


// emitter void QIdentityProxyModel::columnsInserted(const QModelIndex &parent, int first, int last)

static void _init_emitter_columnsInserted_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_columnsInserted_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QIdentityProxyModel_Adaptor *)cls)->emitter_QIdentityProxyModel_columnsInserted_7372 (arg1, arg2, arg3);
}


// emitter void QIdentityProxyModel::columnsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int column)

static void _init_emitter_columnsMoved_10318 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("start");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("end");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destination");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("column");
  decl->add_arg<int > (argspec_4);
  decl->set_return<void > ();
}

static void _call_emitter_columnsMoved_10318 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ((QIdentityProxyModel_Adaptor *)cls)->emitter_QIdentityProxyModel_columnsMoved_10318 (arg1, arg2, arg3, arg4, arg5);
}


// emitter void QIdentityProxyModel::columnsRemoved(const QModelIndex &parent, int first, int last)

static void _init_emitter_columnsRemoved_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_columnsRemoved_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QIdentityProxyModel_Adaptor *)cls)->emitter_QIdentityProxyModel_columnsRemoved_7372 (arg1, arg2, arg3);
}


// exposed QModelIndex QIdentityProxyModel::createIndex(int row, int column, void *data)

static void _init_fp_createIndex_c2374 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("data", true, "0");
  decl->add_arg<void * > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_createIndex_c2374 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  void *arg3 = args ? gsi::arg_reader<void * >() (args, heap) : gsi::arg_maker<void * >() (0, heap);
  ret.write<QModelIndex > ((QModelIndex)((QIdentityProxyModel_Adaptor *)cls)->fp_QIdentityProxyModel_createIndex_c2374 (arg1, arg2, arg3));
}


// exposed QModelIndex QIdentityProxyModel::createIndex(int row, int column, quintptr id)

static void _init_fp_createIndex_c2657 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("id");
  decl->add_arg<quintptr > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_createIndex_c2657 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  quintptr arg3 = gsi::arg_reader<quintptr >() (args, heap);
  ret.write<QModelIndex > ((QModelIndex)((QIdentityProxyModel_Adaptor *)cls)->fp_QIdentityProxyModel_createIndex_c2657 (arg1, arg2, arg3));
}


// void QIdentityProxyModel::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QIdentityProxyModel_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// QVariant QIdentityProxyModel::data(const QModelIndex &proxyIndex, int role)

static void _init_cbs_data_c3054_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("proxyIndex");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_cbs_data_c3054_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  ret.write<QVariant > ((QVariant)((QIdentityProxyModel_Adaptor *)cls)->cbs_data_c3054_1 (arg1, arg2));
}

static void _set_callback_cbs_data_c3054_1 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_data_c3054_1 = cb;
}


// emitter void QIdentityProxyModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QVector<int> &roles)

static void _init_emitter_dataChanged_7048 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("topLeft");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("bottomRight");
  decl->add_arg<const QModelIndex & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("roles", true, "QVector<int>()");
  decl->add_arg<const QVector<int> & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_dataChanged_7048 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const QVector<int> &arg3 = args ? gsi::arg_reader<const QVector<int> & >() (args, heap) : gsi::arg_maker<const QVector<int> & >() (QVector<int>(), heap);
  ((QIdentityProxyModel_Adaptor *)cls)->emitter_QIdentityProxyModel_dataChanged_7048 (arg1, arg2, arg3);
}


// exposed bool QIdentityProxyModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)

static void _init_fp_decodeData_5302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("stream");
  decl->add_arg<QDataStream & > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_fp_decodeData_5302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg3 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  QDataStream &arg4 = gsi::arg_reader<QDataStream & >() (args, heap);
  ret.write<bool > ((bool)((QIdentityProxyModel_Adaptor *)cls)->fp_QIdentityProxyModel_decodeData_5302 (arg1, arg2, arg3, arg4));
}


// emitter void QIdentityProxyModel::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QIdentityProxyModel_Adaptor *)cls)->emitter_QIdentityProxyModel_destroyed_1302 (arg1);
}


// void QIdentityProxyModel::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QIdentityProxyModel_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QIdentityProxyModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)

static void _init_cbs_dropMimeData_7425_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QMimeData * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("action");
  decl->add_arg<const qt_gsi::Converter<Qt::DropAction>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("row");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("column");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_cbs_dropMimeData_7425_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMimeData *arg1 = args.read<const QMimeData * > (heap);
  const qt_gsi::Converter<Qt::DropAction>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::DropAction>::target_type & > (heap);
  int arg3 = args.read<int > (heap);
  int arg4 = args.read<int > (heap);
  const QModelIndex &arg5 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QIdentityProxyModel_Adaptor *)cls)->cbs_dropMimeData_7425_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_dropMimeData_7425_0 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_dropMimeData_7425_0 = cb;
}


// exposed void QIdentityProxyModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)

static void _init_fp_encodeData_c4599 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("indexes");
  decl->add_arg<const QList<QModelIndex> & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("stream");
  decl->add_arg<QDataStream & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_encodeData_c4599 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QModelIndex> &arg1 = gsi::arg_reader<const QList<QModelIndex> & >() (args, heap);
  QDataStream &arg2 = gsi::arg_reader<QDataStream & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QIdentityProxyModel_Adaptor *)cls)->fp_QIdentityProxyModel_encodeData_c4599 (arg1, arg2);
}


// exposed void QIdentityProxyModel::endInsertColumns()

static void _init_fp_endInsertColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endInsertColumns_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QIdentityProxyModel_Adaptor *)cls)->fp_QIdentityProxyModel_endInsertColumns_0 ();
}


// exposed void QIdentityProxyModel::endInsertRows()

static void _init_fp_endInsertRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endInsertRows_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QIdentityProxyModel_Adaptor *)cls)->fp_QIdentityProxyModel_endInsertRows_0 ();
}


// exposed void QIdentityProxyModel::endMoveColumns()

static void _init_fp_endMoveColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endMoveColumns_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QIdentityProxyModel_Adaptor *)cls)->fp_QIdentityProxyModel_endMoveColumns_0 ();
}


// exposed void QIdentityProxyModel::endMoveRows()

static void _init_fp_endMoveRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endMoveRows_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QIdentityProxyModel_Adaptor *)cls)->fp_QIdentityProxyModel_endMoveRows_0 ();
}


// exposed void QIdentityProxyModel::endRemoveColumns()

static void _init_fp_endRemoveColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endRemoveColumns_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QIdentityProxyModel_Adaptor *)cls)->fp_QIdentityProxyModel_endRemoveColumns_0 ();
}


// exposed void QIdentityProxyModel::endRemoveRows()

static void _init_fp_endRemoveRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endRemoveRows_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QIdentityProxyModel_Adaptor *)cls)->fp_QIdentityProxyModel_endRemoveRows_0 ();
}


// exposed void QIdentityProxyModel::endResetModel()

static void _init_fp_endResetModel_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endResetModel_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QIdentityProxyModel_Adaptor *)cls)->fp_QIdentityProxyModel_endResetModel_0 ();
}


// bool QIdentityProxyModel::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QIdentityProxyModel_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QIdentityProxyModel::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QIdentityProxyModel_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QIdentityProxyModel::fetchMore(const QModelIndex &parent)

static void _init_cbs_fetchMore_2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fetchMore_2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QIdentityProxyModel_Adaptor *)cls)->cbs_fetchMore_2395_0 (arg1);
}

static void _set_callback_cbs_fetchMore_2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_fetchMore_2395_0 = cb;
}


// QFlags<Qt::ItemFlag> QIdentityProxyModel::flags(const QModelIndex &index)

static void _init_cbs_flags_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QFlags<Qt::ItemFlag> > ();
}

static void _call_cbs_flags_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QFlags<Qt::ItemFlag> > ((QFlags<Qt::ItemFlag>)((QIdentityProxyModel_Adaptor *)cls)->cbs_flags_c2395_0 (arg1));
}

static void _set_callback_cbs_flags_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_flags_c2395_0 = cb;
}


// bool QIdentityProxyModel::hasChildren(const QModelIndex &parent)

static void _init_cbs_hasChildren_c2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_hasChildren_c2395_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QIdentityProxyModel_Adaptor *)cls)->cbs_hasChildren_c2395_1 (arg1));
}

static void _set_callback_cbs_hasChildren_c2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_hasChildren_c2395_1 = cb;
}


// QVariant QIdentityProxyModel::headerData(int section, Qt::Orientation orientation, int role)

static void _init_cbs_headerData_c3231_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QVariant > ();
}

static void _call_cbs_headerData_c3231_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > (heap);
  int arg3 = args.read<int > (heap);
  ret.write<QVariant > ((QVariant)((QIdentityProxyModel_Adaptor *)cls)->cbs_headerData_c3231_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_headerData_c3231_1 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_headerData_c3231_1 = cb;
}


// emitter void QIdentityProxyModel::headerDataChanged(Qt::Orientation orientation, int first, int last)

static void _init_emitter_headerDataChanged_3231 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_headerDataChanged_3231 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::Orientation>::target_type & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QIdentityProxyModel_Adaptor *)cls)->emitter_QIdentityProxyModel_headerDataChanged_3231 (arg1, arg2, arg3);
}


// QModelIndex QIdentityProxyModel::index(int row, int column, const QModelIndex &parent)

static void _init_cbs_index_c3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_index_c3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QIdentityProxyModel_Adaptor *)cls)->cbs_index_c3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_index_c3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_index_c3713_1 = cb;
}


// bool QIdentityProxyModel::insertColumns(int column, int count, const QModelIndex &parent)

static void _init_cbs_insertColumns_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_insertColumns_3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QIdentityProxyModel_Adaptor *)cls)->cbs_insertColumns_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_insertColumns_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_insertColumns_3713_1 = cb;
}


// bool QIdentityProxyModel::insertRows(int row, int count, const QModelIndex &parent)

static void _init_cbs_insertRows_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_insertRows_3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QIdentityProxyModel_Adaptor *)cls)->cbs_insertRows_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_insertRows_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_insertRows_3713_1 = cb;
}


// exposed bool QIdentityProxyModel::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QIdentityProxyModel_Adaptor *)cls)->fp_QIdentityProxyModel_isSignalConnected_c2394 (arg1));
}


// QMap<int, QVariant> QIdentityProxyModel::itemData(const QModelIndex &index)

static void _init_cbs_itemData_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QMap<int, QVariant> > ();
}

static void _call_cbs_itemData_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QMap<int, QVariant> > ((QMap<int, QVariant>)((QIdentityProxyModel_Adaptor *)cls)->cbs_itemData_c2395_0 (arg1));
}

static void _set_callback_cbs_itemData_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_itemData_c2395_0 = cb;
}


// emitter void QIdentityProxyModel::layoutAboutToBeChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)

static void _init_emitter_layoutAboutToBeChanged_7947 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parents", true, "QList<QPersistentModelIndex>()");
  decl->add_arg<const QList<QPersistentModelIndex> & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint", true, "QAbstractItemModel::NoLayoutChangeHint");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_layoutAboutToBeChanged_7947 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QPersistentModelIndex> &arg1 = args ? gsi::arg_reader<const QList<QPersistentModelIndex> & >() (args, heap) : gsi::arg_maker<const QList<QPersistentModelIndex> & >() (QList<QPersistentModelIndex>(), heap);
  const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QAbstractItemModel::LayoutChangeHint>(heap, QAbstractItemModel::NoLayoutChangeHint), heap);
  ((QIdentityProxyModel_Adaptor *)cls)->emitter_QIdentityProxyModel_layoutAboutToBeChanged_7947 (arg1, arg2);
}


// emitter void QIdentityProxyModel::layoutChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)

static void _init_emitter_layoutChanged_7947 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parents", true, "QList<QPersistentModelIndex>()");
  decl->add_arg<const QList<QPersistentModelIndex> & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint", true, "QAbstractItemModel::NoLayoutChangeHint");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_layoutChanged_7947 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QPersistentModelIndex> &arg1 = args ? gsi::arg_reader<const QList<QPersistentModelIndex> & >() (args, heap) : gsi::arg_maker<const QList<QPersistentModelIndex> & >() (QList<QPersistentModelIndex>(), heap);
  const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QAbstractItemModel::LayoutChangeHint>(heap, QAbstractItemModel::NoLayoutChangeHint), heap);
  ((QIdentityProxyModel_Adaptor *)cls)->emitter_QIdentityProxyModel_layoutChanged_7947 (arg1, arg2);
}


// QModelIndex QIdentityProxyModel::mapFromSource(const QModelIndex &sourceIndex)

static void _init_cbs_mapFromSource_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceIndex");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_mapFromSource_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QIdentityProxyModel_Adaptor *)cls)->cbs_mapFromSource_c2395_0 (arg1));
}

static void _set_callback_cbs_mapFromSource_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_mapFromSource_c2395_0 = cb;
}


// QItemSelection QIdentityProxyModel::mapSelectionFromSource(const QItemSelection &selection)

static void _init_cbs_mapSelectionFromSource_c2727_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selection");
  decl->add_arg<const QItemSelection & > (argspec_0);
  decl->set_return<QItemSelection > ();
}

static void _call_cbs_mapSelectionFromSource_c2727_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QItemSelection &arg1 = args.read<const QItemSelection & > (heap);
  ret.write<QItemSelection > ((QItemSelection)((QIdentityProxyModel_Adaptor *)cls)->cbs_mapSelectionFromSource_c2727_0 (arg1));
}

static void _set_callback_cbs_mapSelectionFromSource_c2727_0 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_mapSelectionFromSource_c2727_0 = cb;
}


// QItemSelection QIdentityProxyModel::mapSelectionToSource(const QItemSelection &selection)

static void _init_cbs_mapSelectionToSource_c2727_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selection");
  decl->add_arg<const QItemSelection & > (argspec_0);
  decl->set_return<QItemSelection > ();
}

static void _call_cbs_mapSelectionToSource_c2727_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QItemSelection &arg1 = args.read<const QItemSelection & > (heap);
  ret.write<QItemSelection > ((QItemSelection)((QIdentityProxyModel_Adaptor *)cls)->cbs_mapSelectionToSource_c2727_0 (arg1));
}

static void _set_callback_cbs_mapSelectionToSource_c2727_0 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_mapSelectionToSource_c2727_0 = cb;
}


// QModelIndex QIdentityProxyModel::mapToSource(const QModelIndex &proxyIndex)

static void _init_cbs_mapToSource_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("proxyIndex");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_mapToSource_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QIdentityProxyModel_Adaptor *)cls)->cbs_mapToSource_c2395_0 (arg1));
}

static void _set_callback_cbs_mapToSource_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_mapToSource_c2395_0 = cb;
}


// QList<QModelIndex> QIdentityProxyModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)

static void _init_cbs_match_c7932_2 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("start");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("hits");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("flags");
  decl->add_arg<QFlags<Qt::MatchFlag> > (argspec_4);
  decl->set_return<QList<QModelIndex> > ();
}

static void _call_cbs_match_c7932_2 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  const QVariant &arg3 = args.read<const QVariant & > (heap);
  int arg4 = args.read<int > (heap);
  QFlags<Qt::MatchFlag> arg5 = args.read<QFlags<Qt::MatchFlag> > (heap);
  ret.write<QList<QModelIndex> > ((QList<QModelIndex>)((QIdentityProxyModel_Adaptor *)cls)->cbs_match_c7932_2 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_match_c7932_2 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_match_c7932_2 = cb;
}


// QMimeData *QIdentityProxyModel::mimeData(const QList<QModelIndex> &indexes)

static void _init_cbs_mimeData_c3010_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("indexes");
  decl->add_arg<const QList<QModelIndex> & > (argspec_0);
  decl->set_return<QMimeData * > ();
}

static void _call_cbs_mimeData_c3010_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QModelIndex> &arg1 = args.read<const QList<QModelIndex> & > (heap);
  ret.write<QMimeData * > ((QMimeData *)((QIdentityProxyModel_Adaptor *)cls)->cbs_mimeData_c3010_0 (arg1));
}

static void _set_callback_cbs_mimeData_c3010_0 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_mimeData_c3010_0 = cb;
}


// QStringList QIdentityProxyModel::mimeTypes()

static void _init_cbs_mimeTypes_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_cbs_mimeTypes_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QIdentityProxyModel_Adaptor *)cls)->cbs_mimeTypes_c0_0 ());
}

static void _set_callback_cbs_mimeTypes_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_mimeTypes_c0_0 = cb;
}


// emitter void QIdentityProxyModel::modelAboutToBeReset()

static void _init_emitter_modelAboutToBeReset_3767 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_modelAboutToBeReset_3767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QIdentityProxyModel_Adaptor *)cls)->emitter_QIdentityProxyModel_modelAboutToBeReset_3767 ();
}


// emitter void QIdentityProxyModel::modelReset()

static void _init_emitter_modelReset_3767 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_modelReset_3767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QIdentityProxyModel_Adaptor *)cls)->emitter_QIdentityProxyModel_modelReset_3767 ();
}


// bool QIdentityProxyModel::moveColumns(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)

static void _init_cbs_moveColumns_6659_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceColumn");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("count");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationChild");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_cbs_moveColumns_6659_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  int arg3 = args.read<int > (heap);
  const QModelIndex &arg4 = args.read<const QModelIndex & > (heap);
  int arg5 = args.read<int > (heap);
  ret.write<bool > ((bool)((QIdentityProxyModel_Adaptor *)cls)->cbs_moveColumns_6659_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_moveColumns_6659_0 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_moveColumns_6659_0 = cb;
}


// bool QIdentityProxyModel::moveRows(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)

static void _init_cbs_moveRows_6659_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceRow");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("count");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationChild");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_cbs_moveRows_6659_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  int arg3 = args.read<int > (heap);
  const QModelIndex &arg4 = args.read<const QModelIndex & > (heap);
  int arg5 = args.read<int > (heap);
  ret.write<bool > ((bool)((QIdentityProxyModel_Adaptor *)cls)->cbs_moveRows_6659_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_moveRows_6659_0 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_moveRows_6659_0 = cb;
}


// emitter void QIdentityProxyModel::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QIdentityProxyModel_Adaptor *)cls)->emitter_QIdentityProxyModel_objectNameChanged_4567 (arg1);
}


// QModelIndex QIdentityProxyModel::parent(const QModelIndex &child)

static void _init_cbs_parent_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("child");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_parent_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QIdentityProxyModel_Adaptor *)cls)->cbs_parent_c2395_0 (arg1));
}

static void _set_callback_cbs_parent_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_parent_c2395_0 = cb;
}


// exposed QList<QModelIndex> QIdentityProxyModel::persistentIndexList()

static void _init_fp_persistentIndexList_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QModelIndex> > ();
}

static void _call_fp_persistentIndexList_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QModelIndex> > ((QList<QModelIndex>)((QIdentityProxyModel_Adaptor *)cls)->fp_QIdentityProxyModel_persistentIndexList_c0 ());
}


// exposed int QIdentityProxyModel::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QIdentityProxyModel_Adaptor *)cls)->fp_QIdentityProxyModel_receivers_c1731 (arg1));
}


// bool QIdentityProxyModel::removeColumns(int column, int count, const QModelIndex &parent)

static void _init_cbs_removeColumns_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_removeColumns_3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QIdentityProxyModel_Adaptor *)cls)->cbs_removeColumns_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_removeColumns_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_removeColumns_3713_1 = cb;
}


// bool QIdentityProxyModel::removeRows(int row, int count, const QModelIndex &parent)

static void _init_cbs_removeRows_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_removeRows_3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QIdentityProxyModel_Adaptor *)cls)->cbs_removeRows_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_removeRows_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_removeRows_3713_1 = cb;
}


// exposed void QIdentityProxyModel::resetInternalData()

static void _init_fp_resetInternalData_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_resetInternalData_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QIdentityProxyModel_Adaptor *)cls)->fp_QIdentityProxyModel_resetInternalData_0 ();
}


// void QIdentityProxyModel::revert()

static void _init_cbs_revert_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_revert_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QIdentityProxyModel_Adaptor *)cls)->cbs_revert_0_0 ();
}

static void _set_callback_cbs_revert_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_revert_0_0 = cb;
}


// QHash<int, QByteArray> QIdentityProxyModel::roleNames()

static void _init_cbs_roleNames_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QHash<int, QByteArray> > ();
}

static void _call_cbs_roleNames_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QHash<int, QByteArray> > ((QHash<int, QByteArray>)((QIdentityProxyModel_Adaptor *)cls)->cbs_roleNames_c0_0 ());
}

static void _set_callback_cbs_roleNames_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_roleNames_c0_0 = cb;
}


// int QIdentityProxyModel::rowCount(const QModelIndex &parent)

static void _init_cbs_rowCount_c2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_rowCount_c2395_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<int > ((int)((QIdentityProxyModel_Adaptor *)cls)->cbs_rowCount_c2395_1 (arg1));
}

static void _set_callback_cbs_rowCount_c2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_rowCount_c2395_1 = cb;
}


// emitter void QIdentityProxyModel::rowsAboutToBeInserted(const QModelIndex &parent, int first, int last)

static void _init_emitter_rowsAboutToBeInserted_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_rowsAboutToBeInserted_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QIdentityProxyModel_Adaptor *)cls)->emitter_QIdentityProxyModel_rowsAboutToBeInserted_7372 (arg1, arg2, arg3);
}


// emitter void QIdentityProxyModel::rowsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationRow)

static void _init_emitter_rowsAboutToBeMoved_10318 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceStart");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceEnd");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationRow");
  decl->add_arg<int > (argspec_4);
  decl->set_return<void > ();
}

static void _call_emitter_rowsAboutToBeMoved_10318 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ((QIdentityProxyModel_Adaptor *)cls)->emitter_QIdentityProxyModel_rowsAboutToBeMoved_10318 (arg1, arg2, arg3, arg4, arg5);
}


// emitter void QIdentityProxyModel::rowsAboutToBeRemoved(const QModelIndex &parent, int first, int last)

static void _init_emitter_rowsAboutToBeRemoved_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_rowsAboutToBeRemoved_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QIdentityProxyModel_Adaptor *)cls)->emitter_QIdentityProxyModel_rowsAboutToBeRemoved_7372 (arg1, arg2, arg3);
}


// emitter void QIdentityProxyModel::rowsInserted(const QModelIndex &parent, int first, int last)

static void _init_emitter_rowsInserted_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_rowsInserted_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QIdentityProxyModel_Adaptor *)cls)->emitter_QIdentityProxyModel_rowsInserted_7372 (arg1, arg2, arg3);
}


// emitter void QIdentityProxyModel::rowsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int row)

static void _init_emitter_rowsMoved_10318 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("start");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("end");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destination");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("row");
  decl->add_arg<int > (argspec_4);
  decl->set_return<void > ();
}

static void _call_emitter_rowsMoved_10318 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ((QIdentityProxyModel_Adaptor *)cls)->emitter_QIdentityProxyModel_rowsMoved_10318 (arg1, arg2, arg3, arg4, arg5);
}


// emitter void QIdentityProxyModel::rowsRemoved(const QModelIndex &parent, int first, int last)

static void _init_emitter_rowsRemoved_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_rowsRemoved_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QIdentityProxyModel_Adaptor *)cls)->emitter_QIdentityProxyModel_rowsRemoved_7372 (arg1, arg2, arg3);
}


// exposed QObject *QIdentityProxyModel::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QIdentityProxyModel_Adaptor *)cls)->fp_QIdentityProxyModel_sender_c0 ());
}


// exposed int QIdentityProxyModel::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QIdentityProxyModel_Adaptor *)cls)->fp_QIdentityProxyModel_senderSignalIndex_c0 ());
}


// bool QIdentityProxyModel::setData(const QModelIndex &index, const QVariant &value, int role)

static void _init_cbs_setData_5065_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_setData_5065_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  const QVariant &arg2 = args.read<const QVariant & > (heap);
  int arg3 = args.read<int > (heap);
  ret.write<bool > ((bool)((QIdentityProxyModel_Adaptor *)cls)->cbs_setData_5065_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_setData_5065_1 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_setData_5065_1 = cb;
}


// bool QIdentityProxyModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)

static void _init_cbs_setHeaderData_5242_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("role");
  decl->add_arg<int > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_cbs_setHeaderData_5242_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > (heap);
  const QVariant &arg3 = args.read<const QVariant & > (heap);
  int arg4 = args.read<int > (heap);
  ret.write<bool > ((bool)((QIdentityProxyModel_Adaptor *)cls)->cbs_setHeaderData_5242_1 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_setHeaderData_5242_1 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_setHeaderData_5242_1 = cb;
}


// bool QIdentityProxyModel::setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)

static void _init_cbs_setItemData_5414_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("roles");
  decl->add_arg<const QMap<int, QVariant> & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_setItemData_5414_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  const QMap<int, QVariant> &arg2 = args.read<const QMap<int, QVariant> & > (heap);
  ret.write<bool > ((bool)((QIdentityProxyModel_Adaptor *)cls)->cbs_setItemData_5414_0 (arg1, arg2));
}

static void _set_callback_cbs_setItemData_5414_0 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_setItemData_5414_0 = cb;
}


// void QIdentityProxyModel::setSourceModel(QAbstractItemModel *sourceModel)

static void _init_cbs_setSourceModel_2419_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceModel");
  decl->add_arg<QAbstractItemModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setSourceModel_2419_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractItemModel *arg1 = args.read<QAbstractItemModel * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QIdentityProxyModel_Adaptor *)cls)->cbs_setSourceModel_2419_0 (arg1);
}

static void _set_callback_cbs_setSourceModel_2419_0 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_setSourceModel_2419_0 = cb;
}


// QModelIndex QIdentityProxyModel::sibling(int row, int column, const QModelIndex &idx)

static void _init_cbs_sibling_c3713_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("idx");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_sibling_c3713_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QIdentityProxyModel_Adaptor *)cls)->cbs_sibling_c3713_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_sibling_c3713_0 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_sibling_c3713_0 = cb;
}


// void QIdentityProxyModel::sort(int column, Qt::SortOrder order)

static void _init_cbs_sort_2340_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("order");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_sort_2340_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QIdentityProxyModel_Adaptor *)cls)->cbs_sort_2340_1 (arg1, arg2);
}

static void _set_callback_cbs_sort_2340_1 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_sort_2340_1 = cb;
}


// emitter void QIdentityProxyModel::sourceModelChanged()

static void _init_emitter_sourceModelChanged_3914 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_sourceModelChanged_3914 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QIdentityProxyModel_Adaptor *)cls)->emitter_QIdentityProxyModel_sourceModelChanged_3914 ();
}


// QSize QIdentityProxyModel::span(const QModelIndex &index)

static void _init_cbs_span_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QSize > ();
}

static void _call_cbs_span_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QSize > ((QSize)((QIdentityProxyModel_Adaptor *)cls)->cbs_span_c2395_0 (arg1));
}

static void _set_callback_cbs_span_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_span_c2395_0 = cb;
}


// bool QIdentityProxyModel::submit()

static void _init_cbs_submit_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_submit_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QIdentityProxyModel_Adaptor *)cls)->cbs_submit_0_0 ());
}

static void _set_callback_cbs_submit_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_submit_0_0 = cb;
}


// QFlags<Qt::DropAction> QIdentityProxyModel::supportedDragActions()

static void _init_cbs_supportedDragActions_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::DropAction> > ();
}

static void _call_cbs_supportedDragActions_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::DropAction> > ((QFlags<Qt::DropAction>)((QIdentityProxyModel_Adaptor *)cls)->cbs_supportedDragActions_c0_0 ());
}

static void _set_callback_cbs_supportedDragActions_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_supportedDragActions_c0_0 = cb;
}


// QFlags<Qt::DropAction> QIdentityProxyModel::supportedDropActions()

static void _init_cbs_supportedDropActions_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::DropAction> > ();
}

static void _call_cbs_supportedDropActions_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::DropAction> > ((QFlags<Qt::DropAction>)((QIdentityProxyModel_Adaptor *)cls)->cbs_supportedDropActions_c0_0 ());
}

static void _set_callback_cbs_supportedDropActions_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_supportedDropActions_c0_0 = cb;
}


// void QIdentityProxyModel::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QIdentityProxyModel_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QIdentityProxyModel_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QIdentityProxyModel> &qtdecl_QIdentityProxyModel ();

static gsi::Methods methods_QIdentityProxyModel_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QIdentityProxyModel::QIdentityProxyModel(QObject *parent)\nThis method creates an object of class QIdentityProxyModel.", &_init_ctor_QIdentityProxyModel_Adaptor_1302, &_call_ctor_QIdentityProxyModel_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("*beginInsertColumns", "@brief Method void QIdentityProxyModel::beginInsertColumns(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginInsertColumns_3713, &_call_fp_beginInsertColumns_3713);
  methods += new qt_gsi::GenericMethod ("*beginInsertRows", "@brief Method void QIdentityProxyModel::beginInsertRows(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginInsertRows_3713, &_call_fp_beginInsertRows_3713);
  methods += new qt_gsi::GenericMethod ("*beginMoveColumns", "@brief Method bool QIdentityProxyModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginMoveColumns_6659, &_call_fp_beginMoveColumns_6659);
  methods += new qt_gsi::GenericMethod ("*beginMoveRows", "@brief Method bool QIdentityProxyModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginMoveRows_6659, &_call_fp_beginMoveRows_6659);
  methods += new qt_gsi::GenericMethod ("*beginRemoveColumns", "@brief Method void QIdentityProxyModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginRemoveColumns_3713, &_call_fp_beginRemoveColumns_3713);
  methods += new qt_gsi::GenericMethod ("*beginRemoveRows", "@brief Method void QIdentityProxyModel::beginRemoveRows(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginRemoveRows_3713, &_call_fp_beginRemoveRows_3713);
  methods += new qt_gsi::GenericMethod ("*beginResetModel", "@brief Method void QIdentityProxyModel::beginResetModel()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginResetModel_0, &_call_fp_beginResetModel_0);
  methods += new qt_gsi::GenericMethod ("buddy", "@brief Virtual method QModelIndex QIdentityProxyModel::buddy(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_buddy_c2395_0, &_call_cbs_buddy_c2395_0);
  methods += new qt_gsi::GenericMethod ("buddy", "@hide", true, &_init_cbs_buddy_c2395_0, &_call_cbs_buddy_c2395_0, &_set_callback_cbs_buddy_c2395_0);
  methods += new qt_gsi::GenericMethod ("canDropMimeData", "@brief Virtual method bool QIdentityProxyModel::canDropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_canDropMimeData_c7425_0, &_call_cbs_canDropMimeData_c7425_0);
  methods += new qt_gsi::GenericMethod ("canDropMimeData", "@hide", true, &_init_cbs_canDropMimeData_c7425_0, &_call_cbs_canDropMimeData_c7425_0, &_set_callback_cbs_canDropMimeData_c7425_0);
  methods += new qt_gsi::GenericMethod ("canFetchMore", "@brief Virtual method bool QIdentityProxyModel::canFetchMore(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_canFetchMore_c2395_0, &_call_cbs_canFetchMore_c2395_0);
  methods += new qt_gsi::GenericMethod ("canFetchMore", "@hide", true, &_init_cbs_canFetchMore_c2395_0, &_call_cbs_canFetchMore_c2395_0, &_set_callback_cbs_canFetchMore_c2395_0);
  methods += new qt_gsi::GenericMethod ("*changePersistentIndex", "@brief Method void QIdentityProxyModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_changePersistentIndex_4682, &_call_fp_changePersistentIndex_4682);
  methods += new qt_gsi::GenericMethod ("*changePersistentIndexList", "@brief Method void QIdentityProxyModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_changePersistentIndexList_5912, &_call_fp_changePersistentIndexList_5912);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QIdentityProxyModel::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("columnCount", "@brief Virtual method int QIdentityProxyModel::columnCount(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_columnCount_c2395_1, &_call_cbs_columnCount_c2395_1);
  methods += new qt_gsi::GenericMethod ("columnCount", "@hide", true, &_init_cbs_columnCount_c2395_1, &_call_cbs_columnCount_c2395_1, &_set_callback_cbs_columnCount_c2395_1);
  methods += new qt_gsi::GenericMethod ("emit_columnsAboutToBeInserted", "@brief Emitter for signal void QIdentityProxyModel::columnsAboutToBeInserted(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_columnsAboutToBeInserted_7372, &_call_emitter_columnsAboutToBeInserted_7372);
  methods += new qt_gsi::GenericMethod ("emit_columnsAboutToBeMoved", "@brief Emitter for signal void QIdentityProxyModel::columnsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationColumn)\nCall this method to emit this signal.", false, &_init_emitter_columnsAboutToBeMoved_10318, &_call_emitter_columnsAboutToBeMoved_10318);
  methods += new qt_gsi::GenericMethod ("emit_columnsAboutToBeRemoved", "@brief Emitter for signal void QIdentityProxyModel::columnsAboutToBeRemoved(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_columnsAboutToBeRemoved_7372, &_call_emitter_columnsAboutToBeRemoved_7372);
  methods += new qt_gsi::GenericMethod ("emit_columnsInserted", "@brief Emitter for signal void QIdentityProxyModel::columnsInserted(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_columnsInserted_7372, &_call_emitter_columnsInserted_7372);
  methods += new qt_gsi::GenericMethod ("emit_columnsMoved", "@brief Emitter for signal void QIdentityProxyModel::columnsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int column)\nCall this method to emit this signal.", false, &_init_emitter_columnsMoved_10318, &_call_emitter_columnsMoved_10318);
  methods += new qt_gsi::GenericMethod ("emit_columnsRemoved", "@brief Emitter for signal void QIdentityProxyModel::columnsRemoved(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_columnsRemoved_7372, &_call_emitter_columnsRemoved_7372);
  methods += new qt_gsi::GenericMethod ("*createIndex", "@brief Method QModelIndex QIdentityProxyModel::createIndex(int row, int column, void *data)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_createIndex_c2374, &_call_fp_createIndex_c2374);
  methods += new qt_gsi::GenericMethod ("*createIndex", "@brief Method QModelIndex QIdentityProxyModel::createIndex(int row, int column, quintptr id)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_createIndex_c2657, &_call_fp_createIndex_c2657);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QIdentityProxyModel::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("data", "@brief Virtual method QVariant QIdentityProxyModel::data(const QModelIndex &proxyIndex, int role)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_data_c3054_1, &_call_cbs_data_c3054_1);
  methods += new qt_gsi::GenericMethod ("data", "@hide", true, &_init_cbs_data_c3054_1, &_call_cbs_data_c3054_1, &_set_callback_cbs_data_c3054_1);
  methods += new qt_gsi::GenericMethod ("emit_dataChanged", "@brief Emitter for signal void QIdentityProxyModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QVector<int> &roles)\nCall this method to emit this signal.", false, &_init_emitter_dataChanged_7048, &_call_emitter_dataChanged_7048);
  methods += new qt_gsi::GenericMethod ("*decodeData", "@brief Method bool QIdentityProxyModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_decodeData_5302, &_call_fp_decodeData_5302);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QIdentityProxyModel::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QIdentityProxyModel::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("dropMimeData", "@brief Virtual method bool QIdentityProxyModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropMimeData_7425_0, &_call_cbs_dropMimeData_7425_0);
  methods += new qt_gsi::GenericMethod ("dropMimeData", "@hide", false, &_init_cbs_dropMimeData_7425_0, &_call_cbs_dropMimeData_7425_0, &_set_callback_cbs_dropMimeData_7425_0);
  methods += new qt_gsi::GenericMethod ("*encodeData", "@brief Method void QIdentityProxyModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_encodeData_c4599, &_call_fp_encodeData_c4599);
  methods += new qt_gsi::GenericMethod ("*endInsertColumns", "@brief Method void QIdentityProxyModel::endInsertColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endInsertColumns_0, &_call_fp_endInsertColumns_0);
  methods += new qt_gsi::GenericMethod ("*endInsertRows", "@brief Method void QIdentityProxyModel::endInsertRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endInsertRows_0, &_call_fp_endInsertRows_0);
  methods += new qt_gsi::GenericMethod ("*endMoveColumns", "@brief Method void QIdentityProxyModel::endMoveColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endMoveColumns_0, &_call_fp_endMoveColumns_0);
  methods += new qt_gsi::GenericMethod ("*endMoveRows", "@brief Method void QIdentityProxyModel::endMoveRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endMoveRows_0, &_call_fp_endMoveRows_0);
  methods += new qt_gsi::GenericMethod ("*endRemoveColumns", "@brief Method void QIdentityProxyModel::endRemoveColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endRemoveColumns_0, &_call_fp_endRemoveColumns_0);
  methods += new qt_gsi::GenericMethod ("*endRemoveRows", "@brief Method void QIdentityProxyModel::endRemoveRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endRemoveRows_0, &_call_fp_endRemoveRows_0);
  methods += new qt_gsi::GenericMethod ("*endResetModel", "@brief Method void QIdentityProxyModel::endResetModel()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endResetModel_0, &_call_fp_endResetModel_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QIdentityProxyModel::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QIdentityProxyModel::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("fetchMore", "@brief Virtual method void QIdentityProxyModel::fetchMore(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fetchMore_2395_0, &_call_cbs_fetchMore_2395_0);
  methods += new qt_gsi::GenericMethod ("fetchMore", "@hide", false, &_init_cbs_fetchMore_2395_0, &_call_cbs_fetchMore_2395_0, &_set_callback_cbs_fetchMore_2395_0);
  methods += new qt_gsi::GenericMethod ("flags", "@brief Virtual method QFlags<Qt::ItemFlag> QIdentityProxyModel::flags(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_flags_c2395_0, &_call_cbs_flags_c2395_0);
  methods += new qt_gsi::GenericMethod ("flags", "@hide", true, &_init_cbs_flags_c2395_0, &_call_cbs_flags_c2395_0, &_set_callback_cbs_flags_c2395_0);
  methods += new qt_gsi::GenericMethod ("hasChildren", "@brief Virtual method bool QIdentityProxyModel::hasChildren(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasChildren_c2395_1, &_call_cbs_hasChildren_c2395_1);
  methods += new qt_gsi::GenericMethod ("hasChildren", "@hide", true, &_init_cbs_hasChildren_c2395_1, &_call_cbs_hasChildren_c2395_1, &_set_callback_cbs_hasChildren_c2395_1);
  methods += new qt_gsi::GenericMethod ("headerData", "@brief Virtual method QVariant QIdentityProxyModel::headerData(int section, Qt::Orientation orientation, int role)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_headerData_c3231_1, &_call_cbs_headerData_c3231_1);
  methods += new qt_gsi::GenericMethod ("headerData", "@hide", true, &_init_cbs_headerData_c3231_1, &_call_cbs_headerData_c3231_1, &_set_callback_cbs_headerData_c3231_1);
  methods += new qt_gsi::GenericMethod ("emit_headerDataChanged", "@brief Emitter for signal void QIdentityProxyModel::headerDataChanged(Qt::Orientation orientation, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_headerDataChanged_3231, &_call_emitter_headerDataChanged_3231);
  methods += new qt_gsi::GenericMethod ("index", "@brief Virtual method QModelIndex QIdentityProxyModel::index(int row, int column, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_index_c3713_1, &_call_cbs_index_c3713_1);
  methods += new qt_gsi::GenericMethod ("index", "@hide", true, &_init_cbs_index_c3713_1, &_call_cbs_index_c3713_1, &_set_callback_cbs_index_c3713_1);
  methods += new qt_gsi::GenericMethod ("insertColumns", "@brief Virtual method bool QIdentityProxyModel::insertColumns(int column, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_insertColumns_3713_1, &_call_cbs_insertColumns_3713_1);
  methods += new qt_gsi::GenericMethod ("insertColumns", "@hide", false, &_init_cbs_insertColumns_3713_1, &_call_cbs_insertColumns_3713_1, &_set_callback_cbs_insertColumns_3713_1);
  methods += new qt_gsi::GenericMethod ("insertRows", "@brief Virtual method bool QIdentityProxyModel::insertRows(int row, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_insertRows_3713_1, &_call_cbs_insertRows_3713_1);
  methods += new qt_gsi::GenericMethod ("insertRows", "@hide", false, &_init_cbs_insertRows_3713_1, &_call_cbs_insertRows_3713_1, &_set_callback_cbs_insertRows_3713_1);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QIdentityProxyModel::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("itemData", "@brief Virtual method QMap<int, QVariant> QIdentityProxyModel::itemData(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_itemData_c2395_0, &_call_cbs_itemData_c2395_0);
  methods += new qt_gsi::GenericMethod ("itemData", "@hide", true, &_init_cbs_itemData_c2395_0, &_call_cbs_itemData_c2395_0, &_set_callback_cbs_itemData_c2395_0);
  methods += new qt_gsi::GenericMethod ("emit_layoutAboutToBeChanged", "@brief Emitter for signal void QIdentityProxyModel::layoutAboutToBeChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)\nCall this method to emit this signal.", false, &_init_emitter_layoutAboutToBeChanged_7947, &_call_emitter_layoutAboutToBeChanged_7947);
  methods += new qt_gsi::GenericMethod ("emit_layoutChanged", "@brief Emitter for signal void QIdentityProxyModel::layoutChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)\nCall this method to emit this signal.", false, &_init_emitter_layoutChanged_7947, &_call_emitter_layoutChanged_7947);
  methods += new qt_gsi::GenericMethod ("mapFromSource", "@brief Virtual method QModelIndex QIdentityProxyModel::mapFromSource(const QModelIndex &sourceIndex)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mapFromSource_c2395_0, &_call_cbs_mapFromSource_c2395_0);
  methods += new qt_gsi::GenericMethod ("mapFromSource", "@hide", true, &_init_cbs_mapFromSource_c2395_0, &_call_cbs_mapFromSource_c2395_0, &_set_callback_cbs_mapFromSource_c2395_0);
  methods += new qt_gsi::GenericMethod ("mapSelectionFromSource", "@brief Virtual method QItemSelection QIdentityProxyModel::mapSelectionFromSource(const QItemSelection &selection)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mapSelectionFromSource_c2727_0, &_call_cbs_mapSelectionFromSource_c2727_0);
  methods += new qt_gsi::GenericMethod ("mapSelectionFromSource", "@hide", true, &_init_cbs_mapSelectionFromSource_c2727_0, &_call_cbs_mapSelectionFromSource_c2727_0, &_set_callback_cbs_mapSelectionFromSource_c2727_0);
  methods += new qt_gsi::GenericMethod ("mapSelectionToSource", "@brief Virtual method QItemSelection QIdentityProxyModel::mapSelectionToSource(const QItemSelection &selection)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mapSelectionToSource_c2727_0, &_call_cbs_mapSelectionToSource_c2727_0);
  methods += new qt_gsi::GenericMethod ("mapSelectionToSource", "@hide", true, &_init_cbs_mapSelectionToSource_c2727_0, &_call_cbs_mapSelectionToSource_c2727_0, &_set_callback_cbs_mapSelectionToSource_c2727_0);
  methods += new qt_gsi::GenericMethod ("mapToSource", "@brief Virtual method QModelIndex QIdentityProxyModel::mapToSource(const QModelIndex &proxyIndex)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mapToSource_c2395_0, &_call_cbs_mapToSource_c2395_0);
  methods += new qt_gsi::GenericMethod ("mapToSource", "@hide", true, &_init_cbs_mapToSource_c2395_0, &_call_cbs_mapToSource_c2395_0, &_set_callback_cbs_mapToSource_c2395_0);
  methods += new qt_gsi::GenericMethod ("match", "@brief Virtual method QList<QModelIndex> QIdentityProxyModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_match_c7932_2, &_call_cbs_match_c7932_2);
  methods += new qt_gsi::GenericMethod ("match", "@hide", true, &_init_cbs_match_c7932_2, &_call_cbs_match_c7932_2, &_set_callback_cbs_match_c7932_2);
  methods += new qt_gsi::GenericMethod ("mimeData", "@brief Virtual method QMimeData *QIdentityProxyModel::mimeData(const QList<QModelIndex> &indexes)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mimeData_c3010_0, &_call_cbs_mimeData_c3010_0);
  methods += new qt_gsi::GenericMethod ("mimeData", "@hide", true, &_init_cbs_mimeData_c3010_0, &_call_cbs_mimeData_c3010_0, &_set_callback_cbs_mimeData_c3010_0);
  methods += new qt_gsi::GenericMethod ("mimeTypes", "@brief Virtual method QStringList QIdentityProxyModel::mimeTypes()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mimeTypes_c0_0, &_call_cbs_mimeTypes_c0_0);
  methods += new qt_gsi::GenericMethod ("mimeTypes", "@hide", true, &_init_cbs_mimeTypes_c0_0, &_call_cbs_mimeTypes_c0_0, &_set_callback_cbs_mimeTypes_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_modelAboutToBeReset", "@brief Emitter for signal void QIdentityProxyModel::modelAboutToBeReset()\nCall this method to emit this signal.", false, &_init_emitter_modelAboutToBeReset_3767, &_call_emitter_modelAboutToBeReset_3767);
  methods += new qt_gsi::GenericMethod ("emit_modelReset", "@brief Emitter for signal void QIdentityProxyModel::modelReset()\nCall this method to emit this signal.", false, &_init_emitter_modelReset_3767, &_call_emitter_modelReset_3767);
  methods += new qt_gsi::GenericMethod ("moveColumns", "@brief Virtual method bool QIdentityProxyModel::moveColumns(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveColumns_6659_0, &_call_cbs_moveColumns_6659_0);
  methods += new qt_gsi::GenericMethod ("moveColumns", "@hide", false, &_init_cbs_moveColumns_6659_0, &_call_cbs_moveColumns_6659_0, &_set_callback_cbs_moveColumns_6659_0);
  methods += new qt_gsi::GenericMethod ("moveRows", "@brief Virtual method bool QIdentityProxyModel::moveRows(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveRows_6659_0, &_call_cbs_moveRows_6659_0);
  methods += new qt_gsi::GenericMethod ("moveRows", "@hide", false, &_init_cbs_moveRows_6659_0, &_call_cbs_moveRows_6659_0, &_set_callback_cbs_moveRows_6659_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QIdentityProxyModel::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("parent", "@brief Virtual method QModelIndex QIdentityProxyModel::parent(const QModelIndex &child)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_parent_c2395_0, &_call_cbs_parent_c2395_0);
  methods += new qt_gsi::GenericMethod ("parent", "@hide", true, &_init_cbs_parent_c2395_0, &_call_cbs_parent_c2395_0, &_set_callback_cbs_parent_c2395_0);
  methods += new qt_gsi::GenericMethod ("*persistentIndexList", "@brief Method QList<QModelIndex> QIdentityProxyModel::persistentIndexList()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_persistentIndexList_c0, &_call_fp_persistentIndexList_c0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QIdentityProxyModel::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("removeColumns", "@brief Virtual method bool QIdentityProxyModel::removeColumns(int column, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_removeColumns_3713_1, &_call_cbs_removeColumns_3713_1);
  methods += new qt_gsi::GenericMethod ("removeColumns", "@hide", false, &_init_cbs_removeColumns_3713_1, &_call_cbs_removeColumns_3713_1, &_set_callback_cbs_removeColumns_3713_1);
  methods += new qt_gsi::GenericMethod ("removeRows", "@brief Virtual method bool QIdentityProxyModel::removeRows(int row, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_removeRows_3713_1, &_call_cbs_removeRows_3713_1);
  methods += new qt_gsi::GenericMethod ("removeRows", "@hide", false, &_init_cbs_removeRows_3713_1, &_call_cbs_removeRows_3713_1, &_set_callback_cbs_removeRows_3713_1);
  methods += new qt_gsi::GenericMethod ("*resetInternalData", "@brief Method void QIdentityProxyModel::resetInternalData()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resetInternalData_0, &_call_fp_resetInternalData_0);
  methods += new qt_gsi::GenericMethod ("revert", "@brief Virtual method void QIdentityProxyModel::revert()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_revert_0_0, &_call_cbs_revert_0_0);
  methods += new qt_gsi::GenericMethod ("revert", "@hide", false, &_init_cbs_revert_0_0, &_call_cbs_revert_0_0, &_set_callback_cbs_revert_0_0);
  methods += new qt_gsi::GenericMethod ("roleNames", "@brief Virtual method QHash<int, QByteArray> QIdentityProxyModel::roleNames()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_roleNames_c0_0, &_call_cbs_roleNames_c0_0);
  methods += new qt_gsi::GenericMethod ("roleNames", "@hide", true, &_init_cbs_roleNames_c0_0, &_call_cbs_roleNames_c0_0, &_set_callback_cbs_roleNames_c0_0);
  methods += new qt_gsi::GenericMethod ("rowCount", "@brief Virtual method int QIdentityProxyModel::rowCount(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_rowCount_c2395_1, &_call_cbs_rowCount_c2395_1);
  methods += new qt_gsi::GenericMethod ("rowCount", "@hide", true, &_init_cbs_rowCount_c2395_1, &_call_cbs_rowCount_c2395_1, &_set_callback_cbs_rowCount_c2395_1);
  methods += new qt_gsi::GenericMethod ("emit_rowsAboutToBeInserted", "@brief Emitter for signal void QIdentityProxyModel::rowsAboutToBeInserted(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_rowsAboutToBeInserted_7372, &_call_emitter_rowsAboutToBeInserted_7372);
  methods += new qt_gsi::GenericMethod ("emit_rowsAboutToBeMoved", "@brief Emitter for signal void QIdentityProxyModel::rowsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationRow)\nCall this method to emit this signal.", false, &_init_emitter_rowsAboutToBeMoved_10318, &_call_emitter_rowsAboutToBeMoved_10318);
  methods += new qt_gsi::GenericMethod ("emit_rowsAboutToBeRemoved", "@brief Emitter for signal void QIdentityProxyModel::rowsAboutToBeRemoved(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_rowsAboutToBeRemoved_7372, &_call_emitter_rowsAboutToBeRemoved_7372);
  methods += new qt_gsi::GenericMethod ("emit_rowsInserted", "@brief Emitter for signal void QIdentityProxyModel::rowsInserted(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_rowsInserted_7372, &_call_emitter_rowsInserted_7372);
  methods += new qt_gsi::GenericMethod ("emit_rowsMoved", "@brief Emitter for signal void QIdentityProxyModel::rowsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int row)\nCall this method to emit this signal.", false, &_init_emitter_rowsMoved_10318, &_call_emitter_rowsMoved_10318);
  methods += new qt_gsi::GenericMethod ("emit_rowsRemoved", "@brief Emitter for signal void QIdentityProxyModel::rowsRemoved(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_rowsRemoved_7372, &_call_emitter_rowsRemoved_7372);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QIdentityProxyModel::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QIdentityProxyModel::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setData", "@brief Virtual method bool QIdentityProxyModel::setData(const QModelIndex &index, const QVariant &value, int role)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setData_5065_1, &_call_cbs_setData_5065_1);
  methods += new qt_gsi::GenericMethod ("setData", "@hide", false, &_init_cbs_setData_5065_1, &_call_cbs_setData_5065_1, &_set_callback_cbs_setData_5065_1);
  methods += new qt_gsi::GenericMethod ("setHeaderData", "@brief Virtual method bool QIdentityProxyModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setHeaderData_5242_1, &_call_cbs_setHeaderData_5242_1);
  methods += new qt_gsi::GenericMethod ("setHeaderData", "@hide", false, &_init_cbs_setHeaderData_5242_1, &_call_cbs_setHeaderData_5242_1, &_set_callback_cbs_setHeaderData_5242_1);
  methods += new qt_gsi::GenericMethod ("setItemData", "@brief Virtual method bool QIdentityProxyModel::setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setItemData_5414_0, &_call_cbs_setItemData_5414_0);
  methods += new qt_gsi::GenericMethod ("setItemData", "@hide", false, &_init_cbs_setItemData_5414_0, &_call_cbs_setItemData_5414_0, &_set_callback_cbs_setItemData_5414_0);
  methods += new qt_gsi::GenericMethod ("setSourceModel", "@brief Virtual method void QIdentityProxyModel::setSourceModel(QAbstractItemModel *sourceModel)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setSourceModel_2419_0, &_call_cbs_setSourceModel_2419_0);
  methods += new qt_gsi::GenericMethod ("setSourceModel", "@hide", false, &_init_cbs_setSourceModel_2419_0, &_call_cbs_setSourceModel_2419_0, &_set_callback_cbs_setSourceModel_2419_0);
  methods += new qt_gsi::GenericMethod ("sibling", "@brief Virtual method QModelIndex QIdentityProxyModel::sibling(int row, int column, const QModelIndex &idx)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sibling_c3713_0, &_call_cbs_sibling_c3713_0);
  methods += new qt_gsi::GenericMethod ("sibling", "@hide", true, &_init_cbs_sibling_c3713_0, &_call_cbs_sibling_c3713_0, &_set_callback_cbs_sibling_c3713_0);
  methods += new qt_gsi::GenericMethod ("sort", "@brief Virtual method void QIdentityProxyModel::sort(int column, Qt::SortOrder order)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sort_2340_1, &_call_cbs_sort_2340_1);
  methods += new qt_gsi::GenericMethod ("sort", "@hide", false, &_init_cbs_sort_2340_1, &_call_cbs_sort_2340_1, &_set_callback_cbs_sort_2340_1);
  methods += new qt_gsi::GenericMethod ("emit_sourceModelChanged", "@brief Emitter for signal void QIdentityProxyModel::sourceModelChanged()\nCall this method to emit this signal.", false, &_init_emitter_sourceModelChanged_3914, &_call_emitter_sourceModelChanged_3914);
  methods += new qt_gsi::GenericMethod ("span", "@brief Virtual method QSize QIdentityProxyModel::span(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_span_c2395_0, &_call_cbs_span_c2395_0);
  methods += new qt_gsi::GenericMethod ("span", "@hide", true, &_init_cbs_span_c2395_0, &_call_cbs_span_c2395_0, &_set_callback_cbs_span_c2395_0);
  methods += new qt_gsi::GenericMethod ("submit", "@brief Virtual method bool QIdentityProxyModel::submit()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_submit_0_0, &_call_cbs_submit_0_0);
  methods += new qt_gsi::GenericMethod ("submit", "@hide", false, &_init_cbs_submit_0_0, &_call_cbs_submit_0_0, &_set_callback_cbs_submit_0_0);
  methods += new qt_gsi::GenericMethod ("supportedDragActions", "@brief Virtual method QFlags<Qt::DropAction> QIdentityProxyModel::supportedDragActions()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportedDragActions_c0_0, &_call_cbs_supportedDragActions_c0_0);
  methods += new qt_gsi::GenericMethod ("supportedDragActions", "@hide", true, &_init_cbs_supportedDragActions_c0_0, &_call_cbs_supportedDragActions_c0_0, &_set_callback_cbs_supportedDragActions_c0_0);
  methods += new qt_gsi::GenericMethod ("supportedDropActions", "@brief Virtual method QFlags<Qt::DropAction> QIdentityProxyModel::supportedDropActions()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportedDropActions_c0_0, &_call_cbs_supportedDropActions_c0_0);
  methods += new qt_gsi::GenericMethod ("supportedDropActions", "@hide", true, &_init_cbs_supportedDropActions_c0_0, &_call_cbs_supportedDropActions_c0_0, &_set_callback_cbs_supportedDropActions_c0_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QIdentityProxyModel::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QIdentityProxyModel_Adaptor> decl_QIdentityProxyModel_Adaptor (qtdecl_QIdentityProxyModel (), "QtCore", "QIdentityProxyModel",
  methods_QIdentityProxyModel_Adaptor (),
  "@qt\n@brief Binding of QIdentityProxyModel");

}

