
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2021 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQStyleHints.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QStyleHints>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include "gsiDeclQtGuiTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QStyleHints

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QStyleHints::staticMetaObject);
}


// int QStyleHints::cursorFlashTime()


static void _init_f_cursorFlashTime_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_cursorFlashTime_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QStyleHints *)cls)->cursorFlashTime ());
}


// double QStyleHints::fontSmoothingGamma()


static void _init_f_fontSmoothingGamma_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_fontSmoothingGamma_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QStyleHints *)cls)->fontSmoothingGamma ());
}


// int QStyleHints::keyboardAutoRepeatRate()


static void _init_f_keyboardAutoRepeatRate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_keyboardAutoRepeatRate_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QStyleHints *)cls)->keyboardAutoRepeatRate ());
}


// int QStyleHints::keyboardInputInterval()


static void _init_f_keyboardInputInterval_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_keyboardInputInterval_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QStyleHints *)cls)->keyboardInputInterval ());
}


// int QStyleHints::mouseDoubleClickInterval()


static void _init_f_mouseDoubleClickInterval_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_mouseDoubleClickInterval_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QStyleHints *)cls)->mouseDoubleClickInterval ());
}


// int QStyleHints::mousePressAndHoldInterval()


static void _init_f_mousePressAndHoldInterval_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_mousePressAndHoldInterval_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QStyleHints *)cls)->mousePressAndHoldInterval ());
}


// QChar QStyleHints::passwordMaskCharacter()


static void _init_f_passwordMaskCharacter_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QChar>::target_type > ();
}

static void _call_f_passwordMaskCharacter_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QChar>::target_type > ((qt_gsi::Converter<QChar>::target_type)qt_gsi::CppToQtAdaptor<QChar>(((QStyleHints *)cls)->passwordMaskCharacter ()));
}


// int QStyleHints::passwordMaskDelay()


static void _init_f_passwordMaskDelay_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_passwordMaskDelay_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QStyleHints *)cls)->passwordMaskDelay ());
}


// void QStyleHints::setCursorFlashTime(int cursorFlashTime)


static void _init_f_setCursorFlashTime_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cursorFlashTime");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCursorFlashTime_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyleHints *)cls)->setCursorFlashTime (arg1);
}


// bool QStyleHints::setFocusOnTouchRelease()


static void _init_f_setFocusOnTouchRelease_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_setFocusOnTouchRelease_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QStyleHints *)cls)->setFocusOnTouchRelease ());
}


// void QStyleHints::setKeyboardInputInterval(int keyboardInputInterval)


static void _init_f_setKeyboardInputInterval_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("keyboardInputInterval");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setKeyboardInputInterval_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyleHints *)cls)->setKeyboardInputInterval (arg1);
}


// void QStyleHints::setMouseDoubleClickInterval(int mouseDoubleClickInterval)


static void _init_f_setMouseDoubleClickInterval_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mouseDoubleClickInterval");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMouseDoubleClickInterval_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyleHints *)cls)->setMouseDoubleClickInterval (arg1);
}


// void QStyleHints::setStartDragDistance(int startDragDistance)


static void _init_f_setStartDragDistance_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("startDragDistance");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStartDragDistance_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyleHints *)cls)->setStartDragDistance (arg1);
}


// void QStyleHints::setStartDragTime(int startDragTime)


static void _init_f_setStartDragTime_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("startDragTime");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStartDragTime_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyleHints *)cls)->setStartDragTime (arg1);
}


// bool QStyleHints::showIsFullScreen()


static void _init_f_showIsFullScreen_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_showIsFullScreen_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QStyleHints *)cls)->showIsFullScreen ());
}


// bool QStyleHints::singleClickActivation()


static void _init_f_singleClickActivation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_singleClickActivation_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QStyleHints *)cls)->singleClickActivation ());
}


// int QStyleHints::startDragDistance()


static void _init_f_startDragDistance_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_startDragDistance_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QStyleHints *)cls)->startDragDistance ());
}


// int QStyleHints::startDragTime()


static void _init_f_startDragTime_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_startDragTime_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QStyleHints *)cls)->startDragTime ());
}


// int QStyleHints::startDragVelocity()


static void _init_f_startDragVelocity_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_startDragVelocity_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QStyleHints *)cls)->startDragVelocity ());
}


// Qt::TabFocusBehavior QStyleHints::tabFocusBehavior()


static void _init_f_tabFocusBehavior_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::TabFocusBehavior>::target_type > ();
}

static void _call_f_tabFocusBehavior_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::TabFocusBehavior>::target_type > ((qt_gsi::Converter<Qt::TabFocusBehavior>::target_type)qt_gsi::CppToQtAdaptor<Qt::TabFocusBehavior>(((QStyleHints *)cls)->tabFocusBehavior ()));
}


// bool QStyleHints::useRtlExtensions()


static void _init_f_useRtlExtensions_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_useRtlExtensions_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QStyleHints *)cls)->useRtlExtensions ());
}


// static QString QStyleHints::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QStyleHints::tr (arg1, arg2, arg3));
}


// static QString QStyleHints::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QStyleHints::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QStyleHints () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":cursorFlashTime", "@brief Method int QStyleHints::cursorFlashTime()\n", true, &_init_f_cursorFlashTime_c0, &_call_f_cursorFlashTime_c0);
  methods += new qt_gsi::GenericMethod (":fontSmoothingGamma", "@brief Method double QStyleHints::fontSmoothingGamma()\n", true, &_init_f_fontSmoothingGamma_c0, &_call_f_fontSmoothingGamma_c0);
  methods += new qt_gsi::GenericMethod (":keyboardAutoRepeatRate", "@brief Method int QStyleHints::keyboardAutoRepeatRate()\n", true, &_init_f_keyboardAutoRepeatRate_c0, &_call_f_keyboardAutoRepeatRate_c0);
  methods += new qt_gsi::GenericMethod (":keyboardInputInterval", "@brief Method int QStyleHints::keyboardInputInterval()\n", true, &_init_f_keyboardInputInterval_c0, &_call_f_keyboardInputInterval_c0);
  methods += new qt_gsi::GenericMethod (":mouseDoubleClickInterval", "@brief Method int QStyleHints::mouseDoubleClickInterval()\n", true, &_init_f_mouseDoubleClickInterval_c0, &_call_f_mouseDoubleClickInterval_c0);
  methods += new qt_gsi::GenericMethod (":mousePressAndHoldInterval", "@brief Method int QStyleHints::mousePressAndHoldInterval()\n", true, &_init_f_mousePressAndHoldInterval_c0, &_call_f_mousePressAndHoldInterval_c0);
  methods += new qt_gsi::GenericMethod (":passwordMaskCharacter", "@brief Method QChar QStyleHints::passwordMaskCharacter()\n", true, &_init_f_passwordMaskCharacter_c0, &_call_f_passwordMaskCharacter_c0);
  methods += new qt_gsi::GenericMethod (":passwordMaskDelay", "@brief Method int QStyleHints::passwordMaskDelay()\n", true, &_init_f_passwordMaskDelay_c0, &_call_f_passwordMaskDelay_c0);
  methods += new qt_gsi::GenericMethod ("setCursorFlashTime", "@brief Method void QStyleHints::setCursorFlashTime(int cursorFlashTime)\n", false, &_init_f_setCursorFlashTime_767, &_call_f_setCursorFlashTime_767);
  methods += new qt_gsi::GenericMethod (":setFocusOnTouchRelease", "@brief Method bool QStyleHints::setFocusOnTouchRelease()\n", true, &_init_f_setFocusOnTouchRelease_c0, &_call_f_setFocusOnTouchRelease_c0);
  methods += new qt_gsi::GenericMethod ("setKeyboardInputInterval", "@brief Method void QStyleHints::setKeyboardInputInterval(int keyboardInputInterval)\n", false, &_init_f_setKeyboardInputInterval_767, &_call_f_setKeyboardInputInterval_767);
  methods += new qt_gsi::GenericMethod ("setMouseDoubleClickInterval", "@brief Method void QStyleHints::setMouseDoubleClickInterval(int mouseDoubleClickInterval)\n", false, &_init_f_setMouseDoubleClickInterval_767, &_call_f_setMouseDoubleClickInterval_767);
  methods += new qt_gsi::GenericMethod ("setStartDragDistance", "@brief Method void QStyleHints::setStartDragDistance(int startDragDistance)\n", false, &_init_f_setStartDragDistance_767, &_call_f_setStartDragDistance_767);
  methods += new qt_gsi::GenericMethod ("setStartDragTime", "@brief Method void QStyleHints::setStartDragTime(int startDragTime)\n", false, &_init_f_setStartDragTime_767, &_call_f_setStartDragTime_767);
  methods += new qt_gsi::GenericMethod (":showIsFullScreen", "@brief Method bool QStyleHints::showIsFullScreen()\n", true, &_init_f_showIsFullScreen_c0, &_call_f_showIsFullScreen_c0);
  methods += new qt_gsi::GenericMethod (":singleClickActivation", "@brief Method bool QStyleHints::singleClickActivation()\n", true, &_init_f_singleClickActivation_c0, &_call_f_singleClickActivation_c0);
  methods += new qt_gsi::GenericMethod (":startDragDistance", "@brief Method int QStyleHints::startDragDistance()\n", true, &_init_f_startDragDistance_c0, &_call_f_startDragDistance_c0);
  methods += new qt_gsi::GenericMethod (":startDragTime", "@brief Method int QStyleHints::startDragTime()\n", true, &_init_f_startDragTime_c0, &_call_f_startDragTime_c0);
  methods += new qt_gsi::GenericMethod (":startDragVelocity", "@brief Method int QStyleHints::startDragVelocity()\n", true, &_init_f_startDragVelocity_c0, &_call_f_startDragVelocity_c0);
  methods += new qt_gsi::GenericMethod (":tabFocusBehavior", "@brief Method Qt::TabFocusBehavior QStyleHints::tabFocusBehavior()\n", true, &_init_f_tabFocusBehavior_c0, &_call_f_tabFocusBehavior_c0);
  methods += new qt_gsi::GenericMethod (":useRtlExtensions", "@brief Method bool QStyleHints::useRtlExtensions()\n", true, &_init_f_useRtlExtensions_c0, &_call_f_useRtlExtensions_c0);
  methods += gsi::qt_signal<int > ("cursorFlashTimeChanged(int)", "cursorFlashTimeChanged", gsi::arg("cursorFlashTime"), "@brief Signal declaration for QStyleHints::cursorFlashTimeChanged(int cursorFlashTime)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QStyleHints::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("keyboardInputIntervalChanged(int)", "keyboardInputIntervalChanged", gsi::arg("keyboardInputInterval"), "@brief Signal declaration for QStyleHints::keyboardInputIntervalChanged(int keyboardInputInterval)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("mouseDoubleClickIntervalChanged(int)", "mouseDoubleClickIntervalChanged", gsi::arg("mouseDoubleClickInterval"), "@brief Signal declaration for QStyleHints::mouseDoubleClickIntervalChanged(int mouseDoubleClickInterval)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QStyleHints::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("startDragDistanceChanged(int)", "startDragDistanceChanged", gsi::arg("startDragDistance"), "@brief Signal declaration for QStyleHints::startDragDistanceChanged(int startDragDistance)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("startDragTimeChanged(int)", "startDragTimeChanged", gsi::arg("startDragTime"), "@brief Signal declaration for QStyleHints::startDragTimeChanged(int startDragTime)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QStyleHints::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QStyleHints::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QStyleHints> decl_QStyleHints (qtdecl_QObject (), "QtGui", "QStyleHints_Native",
  methods_QStyleHints (),
  "@hide\n@alias QStyleHints");

GSI_QTGUI_PUBLIC gsi::Class<QStyleHints> &qtdecl_QStyleHints () { return decl_QStyleHints; }

}


class QStyleHints_Adaptor : public QStyleHints, public qt_gsi::QtObjectBase
{
public:

  virtual ~QStyleHints_Adaptor();

  //  [expose] bool QStyleHints::isSignalConnected(const QMetaMethod &signal)
  bool fp_QStyleHints_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QStyleHints::isSignalConnected(signal);
  }

  //  [expose] int QStyleHints::receivers(const char *signal)
  int fp_QStyleHints_receivers_c1731 (const char *signal) const {
    return QStyleHints::receivers(signal);
  }

  //  [expose] QObject *QStyleHints::sender()
  QObject * fp_QStyleHints_sender_c0 () const {
    return QStyleHints::sender();
  }

  //  [expose] int QStyleHints::senderSignalIndex()
  int fp_QStyleHints_senderSignalIndex_c0 () const {
    return QStyleHints::senderSignalIndex();
  }

  //  [emitter impl] void QStyleHints::cursorFlashTimeChanged(int cursorFlashTime)
  void emitter_QStyleHints_cursorFlashTimeChanged_767(int cursorFlashTime)
  {
    emit QStyleHints::cursorFlashTimeChanged(cursorFlashTime);
  }

  //  [emitter impl] void QStyleHints::destroyed(QObject *)
  void emitter_QStyleHints_destroyed_1302(QObject *arg1)
  {
    emit QStyleHints::destroyed(arg1);
  }

  //  [adaptor impl] bool QStyleHints::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QStyleHints::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QStyleHints_Adaptor, bool, QEvent *>(&QStyleHints_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QStyleHints::event(arg1);
    }
  }

  //  [adaptor impl] bool QStyleHints::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QStyleHints::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QStyleHints_Adaptor, bool, QObject *, QEvent *>(&QStyleHints_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QStyleHints::eventFilter(arg1, arg2);
    }
  }

  //  [emitter impl] void QStyleHints::keyboardInputIntervalChanged(int keyboardInputInterval)
  void emitter_QStyleHints_keyboardInputIntervalChanged_767(int keyboardInputInterval)
  {
    emit QStyleHints::keyboardInputIntervalChanged(keyboardInputInterval);
  }

  //  [emitter impl] void QStyleHints::mouseDoubleClickIntervalChanged(int mouseDoubleClickInterval)
  void emitter_QStyleHints_mouseDoubleClickIntervalChanged_767(int mouseDoubleClickInterval)
  {
    emit QStyleHints::mouseDoubleClickIntervalChanged(mouseDoubleClickInterval);
  }

  //  [emitter impl] void QStyleHints::objectNameChanged(const QString &objectName)
  void emitter_QStyleHints_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QStyleHints::objectNameChanged(const QString &objectName)'");
  }

  //  [emitter impl] void QStyleHints::startDragDistanceChanged(int startDragDistance)
  void emitter_QStyleHints_startDragDistanceChanged_767(int startDragDistance)
  {
    emit QStyleHints::startDragDistanceChanged(startDragDistance);
  }

  //  [emitter impl] void QStyleHints::startDragTimeChanged(int startDragTime)
  void emitter_QStyleHints_startDragTimeChanged_767(int startDragTime)
  {
    emit QStyleHints::startDragTimeChanged(startDragTime);
  }

  //  [adaptor impl] void QStyleHints::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QStyleHints::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QStyleHints_Adaptor, QChildEvent *>(&QStyleHints_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QStyleHints::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QStyleHints::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QStyleHints::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QStyleHints_Adaptor, QEvent *>(&QStyleHints_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QStyleHints::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QStyleHints::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QStyleHints::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QStyleHints_Adaptor, const QMetaMethod &>(&QStyleHints_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QStyleHints::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QStyleHints::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QStyleHints::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QStyleHints_Adaptor, QTimerEvent *>(&QStyleHints_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QStyleHints::timerEvent(arg1);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QStyleHints_Adaptor::~QStyleHints_Adaptor() { }

// void QStyleHints::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyleHints_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyleHints_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// emitter void QStyleHints::cursorFlashTimeChanged(int cursorFlashTime)

static void _init_emitter_cursorFlashTimeChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cursorFlashTime");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_cursorFlashTimeChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QStyleHints_Adaptor *)cls)->emitter_QStyleHints_cursorFlashTimeChanged_767 (arg1);
}


// void QStyleHints::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyleHints_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyleHints_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QStyleHints::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QStyleHints_Adaptor *)cls)->emitter_QStyleHints_destroyed_1302 (arg1);
}


// void QStyleHints::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyleHints_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyleHints_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QStyleHints::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QStyleHints_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyleHints_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QStyleHints::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QStyleHints_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyleHints_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed bool QStyleHints::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QStyleHints_Adaptor *)cls)->fp_QStyleHints_isSignalConnected_c2394 (arg1));
}


// emitter void QStyleHints::keyboardInputIntervalChanged(int keyboardInputInterval)

static void _init_emitter_keyboardInputIntervalChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("keyboardInputInterval");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_keyboardInputIntervalChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QStyleHints_Adaptor *)cls)->emitter_QStyleHints_keyboardInputIntervalChanged_767 (arg1);
}


// emitter void QStyleHints::mouseDoubleClickIntervalChanged(int mouseDoubleClickInterval)

static void _init_emitter_mouseDoubleClickIntervalChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mouseDoubleClickInterval");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_mouseDoubleClickIntervalChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QStyleHints_Adaptor *)cls)->emitter_QStyleHints_mouseDoubleClickIntervalChanged_767 (arg1);
}


// emitter void QStyleHints::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QStyleHints_Adaptor *)cls)->emitter_QStyleHints_objectNameChanged_4567 (arg1);
}


// exposed int QStyleHints::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QStyleHints_Adaptor *)cls)->fp_QStyleHints_receivers_c1731 (arg1));
}


// exposed QObject *QStyleHints::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QStyleHints_Adaptor *)cls)->fp_QStyleHints_sender_c0 ());
}


// exposed int QStyleHints::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QStyleHints_Adaptor *)cls)->fp_QStyleHints_senderSignalIndex_c0 ());
}


// emitter void QStyleHints::startDragDistanceChanged(int startDragDistance)

static void _init_emitter_startDragDistanceChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("startDragDistance");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_startDragDistanceChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QStyleHints_Adaptor *)cls)->emitter_QStyleHints_startDragDistanceChanged_767 (arg1);
}


// emitter void QStyleHints::startDragTimeChanged(int startDragTime)

static void _init_emitter_startDragTimeChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("startDragTime");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_startDragTimeChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QStyleHints_Adaptor *)cls)->emitter_QStyleHints_startDragTimeChanged_767 (arg1);
}


// void QStyleHints::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyleHints_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyleHints_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QStyleHints> &qtdecl_QStyleHints ();

static gsi::Methods methods_QStyleHints_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QStyleHints::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("emit_cursorFlashTimeChanged", "@brief Emitter for signal void QStyleHints::cursorFlashTimeChanged(int cursorFlashTime)\nCall this method to emit this signal.", false, &_init_emitter_cursorFlashTimeChanged_767, &_call_emitter_cursorFlashTimeChanged_767);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QStyleHints::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QStyleHints::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QStyleHints::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QStyleHints::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QStyleHints::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QStyleHints::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_keyboardInputIntervalChanged", "@brief Emitter for signal void QStyleHints::keyboardInputIntervalChanged(int keyboardInputInterval)\nCall this method to emit this signal.", false, &_init_emitter_keyboardInputIntervalChanged_767, &_call_emitter_keyboardInputIntervalChanged_767);
  methods += new qt_gsi::GenericMethod ("emit_mouseDoubleClickIntervalChanged", "@brief Emitter for signal void QStyleHints::mouseDoubleClickIntervalChanged(int mouseDoubleClickInterval)\nCall this method to emit this signal.", false, &_init_emitter_mouseDoubleClickIntervalChanged_767, &_call_emitter_mouseDoubleClickIntervalChanged_767);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QStyleHints::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QStyleHints::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QStyleHints::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QStyleHints::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("emit_startDragDistanceChanged", "@brief Emitter for signal void QStyleHints::startDragDistanceChanged(int startDragDistance)\nCall this method to emit this signal.", false, &_init_emitter_startDragDistanceChanged_767, &_call_emitter_startDragDistanceChanged_767);
  methods += new qt_gsi::GenericMethod ("emit_startDragTimeChanged", "@brief Emitter for signal void QStyleHints::startDragTimeChanged(int startDragTime)\nCall this method to emit this signal.", false, &_init_emitter_startDragTimeChanged_767, &_call_emitter_startDragTimeChanged_767);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QStyleHints::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QStyleHints_Adaptor> decl_QStyleHints_Adaptor (qtdecl_QStyleHints (), "QtGui", "QStyleHints",
  methods_QStyleHints_Adaptor (),
  "@qt\n@brief Binding of QStyleHints");

}

