
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2021 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQCameraExposure.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QCameraExposure>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QPointF>
#include <QThread>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include "gsiDeclQtMultimediaTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QCameraExposure

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QCameraExposure::staticMetaObject);
}


// double QCameraExposure::aperture()


static void _init_f_aperture_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_aperture_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QCameraExposure *)cls)->aperture ());
}


// void QCameraExposure::apertureChanged(double)


static void _init_f_apertureChanged_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_apertureChanged_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraExposure *)cls)->apertureChanged (arg1);
}


// void QCameraExposure::apertureRangeChanged()


static void _init_f_apertureRangeChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_apertureRangeChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraExposure *)cls)->apertureRangeChanged ();
}


// double QCameraExposure::exposureCompensation()


static void _init_f_exposureCompensation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_exposureCompensation_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QCameraExposure *)cls)->exposureCompensation ());
}


// void QCameraExposure::exposureCompensationChanged(double)


static void _init_f_exposureCompensationChanged_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_exposureCompensationChanged_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraExposure *)cls)->exposureCompensationChanged (arg1);
}


// QCameraExposure::ExposureMode QCameraExposure::exposureMode()


static void _init_f_exposureMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QCameraExposure::ExposureMode>::target_type > ();
}

static void _call_f_exposureMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QCameraExposure::ExposureMode>::target_type > ((qt_gsi::Converter<QCameraExposure::ExposureMode>::target_type)qt_gsi::CppToQtAdaptor<QCameraExposure::ExposureMode>(((QCameraExposure *)cls)->exposureMode ()));
}


// QFlags<QCameraExposure::FlashMode> QCameraExposure::flashMode()


static void _init_f_flashMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QCameraExposure::FlashMode> > ();
}

static void _call_f_flashMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QCameraExposure::FlashMode> > ((QFlags<QCameraExposure::FlashMode>)((QCameraExposure *)cls)->flashMode ());
}


// void QCameraExposure::flashReady(bool)


static void _init_f_flashReady_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_flashReady_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraExposure *)cls)->flashReady (arg1);
}


// bool QCameraExposure::isAvailable()


static void _init_f_isAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isAvailable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QCameraExposure *)cls)->isAvailable ());
}


// bool QCameraExposure::isExposureModeSupported(QCameraExposure::ExposureMode mode)


static void _init_f_isExposureModeSupported_c3325 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QCameraExposure::ExposureMode>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isExposureModeSupported_c3325 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraExposure::ExposureMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCameraExposure::ExposureMode>::target_type & >() (args, heap);
  ret.write<bool > ((bool)((QCameraExposure *)cls)->isExposureModeSupported (qt_gsi::QtToCppAdaptor<QCameraExposure::ExposureMode>(arg1).cref()));
}


// bool QCameraExposure::isFlashModeSupported(QFlags<QCameraExposure::FlashMode> mode)


static void _init_f_isFlashModeSupported_c3656 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<QFlags<QCameraExposure::FlashMode> > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isFlashModeSupported_c3656 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QCameraExposure::FlashMode> arg1 = gsi::arg_reader<QFlags<QCameraExposure::FlashMode> >() (args, heap);
  ret.write<bool > ((bool)((QCameraExposure *)cls)->isFlashModeSupported (arg1));
}


// bool QCameraExposure::isFlashReady()


static void _init_f_isFlashReady_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isFlashReady_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QCameraExposure *)cls)->isFlashReady ());
}


// bool QCameraExposure::isMeteringModeSupported(QCameraExposure::MeteringMode mode)


static void _init_f_isMeteringModeSupported_c3293 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QCameraExposure::MeteringMode>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isMeteringModeSupported_c3293 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraExposure::MeteringMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCameraExposure::MeteringMode>::target_type & >() (args, heap);
  ret.write<bool > ((bool)((QCameraExposure *)cls)->isMeteringModeSupported (qt_gsi::QtToCppAdaptor<QCameraExposure::MeteringMode>(arg1).cref()));
}


// int QCameraExposure::isoSensitivity()


static void _init_f_isoSensitivity_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_isoSensitivity_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QCameraExposure *)cls)->isoSensitivity ());
}


// void QCameraExposure::isoSensitivityChanged(int)


static void _init_f_isoSensitivityChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_isoSensitivityChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraExposure *)cls)->isoSensitivityChanged (arg1);
}


// QCameraExposure::MeteringMode QCameraExposure::meteringMode()


static void _init_f_meteringMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QCameraExposure::MeteringMode>::target_type > ();
}

static void _call_f_meteringMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QCameraExposure::MeteringMode>::target_type > ((qt_gsi::Converter<QCameraExposure::MeteringMode>::target_type)qt_gsi::CppToQtAdaptor<QCameraExposure::MeteringMode>(((QCameraExposure *)cls)->meteringMode ()));
}


// double QCameraExposure::requestedAperture()


static void _init_f_requestedAperture_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_requestedAperture_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QCameraExposure *)cls)->requestedAperture ());
}


// int QCameraExposure::requestedIsoSensitivity()


static void _init_f_requestedIsoSensitivity_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_requestedIsoSensitivity_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QCameraExposure *)cls)->requestedIsoSensitivity ());
}


// double QCameraExposure::requestedShutterSpeed()


static void _init_f_requestedShutterSpeed_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_requestedShutterSpeed_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QCameraExposure *)cls)->requestedShutterSpeed ());
}


// void QCameraExposure::setAutoAperture()


static void _init_f_setAutoAperture_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_setAutoAperture_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraExposure *)cls)->setAutoAperture ();
}


// void QCameraExposure::setAutoIsoSensitivity()


static void _init_f_setAutoIsoSensitivity_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_setAutoIsoSensitivity_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraExposure *)cls)->setAutoIsoSensitivity ();
}


// void QCameraExposure::setAutoShutterSpeed()


static void _init_f_setAutoShutterSpeed_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_setAutoShutterSpeed_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraExposure *)cls)->setAutoShutterSpeed ();
}


// void QCameraExposure::setExposureCompensation(double ev)


static void _init_f_setExposureCompensation_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ev");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setExposureCompensation_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraExposure *)cls)->setExposureCompensation (arg1);
}


// void QCameraExposure::setExposureMode(QCameraExposure::ExposureMode mode)


static void _init_f_setExposureMode_3325 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QCameraExposure::ExposureMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setExposureMode_3325 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraExposure::ExposureMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCameraExposure::ExposureMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraExposure *)cls)->setExposureMode (qt_gsi::QtToCppAdaptor<QCameraExposure::ExposureMode>(arg1).cref());
}


// void QCameraExposure::setFlashMode(QFlags<QCameraExposure::FlashMode> mode)


static void _init_f_setFlashMode_3656 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<QFlags<QCameraExposure::FlashMode> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFlashMode_3656 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QCameraExposure::FlashMode> arg1 = gsi::arg_reader<QFlags<QCameraExposure::FlashMode> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraExposure *)cls)->setFlashMode (arg1);
}


// void QCameraExposure::setManualAperture(double aperture)


static void _init_f_setManualAperture_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("aperture");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setManualAperture_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraExposure *)cls)->setManualAperture (arg1);
}


// void QCameraExposure::setManualIsoSensitivity(int iso)


static void _init_f_setManualIsoSensitivity_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("iso");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setManualIsoSensitivity_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraExposure *)cls)->setManualIsoSensitivity (arg1);
}


// void QCameraExposure::setManualShutterSpeed(double seconds)


static void _init_f_setManualShutterSpeed_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("seconds");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setManualShutterSpeed_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraExposure *)cls)->setManualShutterSpeed (arg1);
}


// void QCameraExposure::setMeteringMode(QCameraExposure::MeteringMode mode)


static void _init_f_setMeteringMode_3293 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QCameraExposure::MeteringMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMeteringMode_3293 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraExposure::MeteringMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCameraExposure::MeteringMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraExposure *)cls)->setMeteringMode (qt_gsi::QtToCppAdaptor<QCameraExposure::MeteringMode>(arg1).cref());
}


// void QCameraExposure::setSpotMeteringPoint(const QPointF &point)


static void _init_f_setSpotMeteringPoint_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSpotMeteringPoint_1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraExposure *)cls)->setSpotMeteringPoint (arg1);
}


// double QCameraExposure::shutterSpeed()


static void _init_f_shutterSpeed_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_shutterSpeed_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QCameraExposure *)cls)->shutterSpeed ());
}


// void QCameraExposure::shutterSpeedChanged(double)


static void _init_f_shutterSpeedChanged_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_shutterSpeedChanged_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraExposure *)cls)->shutterSpeedChanged (arg1);
}


// void QCameraExposure::shutterSpeedRangeChanged()


static void _init_f_shutterSpeedRangeChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_shutterSpeedRangeChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraExposure *)cls)->shutterSpeedRangeChanged ();
}


// QPointF QCameraExposure::spotMeteringPoint()


static void _init_f_spotMeteringPoint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPointF > ();
}

static void _call_f_spotMeteringPoint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPointF > ((QPointF)((QCameraExposure *)cls)->spotMeteringPoint ());
}


// QList<qreal> QCameraExposure::supportedApertures(bool *continuous)


static void _init_f_supportedApertures_c1050 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("continuous", true, "0");
  decl->add_arg<bool * > (argspec_0);
  decl->set_return<QList<qreal> > ();
}

static void _call_f_supportedApertures_c1050 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool *arg1 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (0, heap);
  ret.write<QList<qreal> > ((QList<qreal>)((QCameraExposure *)cls)->supportedApertures (arg1));
}


// QList<int> QCameraExposure::supportedIsoSensitivities(bool *continuous)


static void _init_f_supportedIsoSensitivities_c1050 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("continuous", true, "0");
  decl->add_arg<bool * > (argspec_0);
  decl->set_return<QList<int> > ();
}

static void _call_f_supportedIsoSensitivities_c1050 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool *arg1 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (0, heap);
  ret.write<QList<int> > ((QList<int>)((QCameraExposure *)cls)->supportedIsoSensitivities (arg1));
}


// QList<qreal> QCameraExposure::supportedShutterSpeeds(bool *continuous)


static void _init_f_supportedShutterSpeeds_c1050 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("continuous", true, "0");
  decl->add_arg<bool * > (argspec_0);
  decl->set_return<QList<qreal> > ();
}

static void _call_f_supportedShutterSpeeds_c1050 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool *arg1 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (0, heap);
  ret.write<QList<qreal> > ((QList<qreal>)((QCameraExposure *)cls)->supportedShutterSpeeds (arg1));
}


// static QString QCameraExposure::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QCameraExposure::tr (arg1, arg2, arg3));
}


// static QString QCameraExposure::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QCameraExposure::trUtf8 (arg1, arg2, arg3));
}



namespace gsi
{

static gsi::Methods methods_QCameraExposure () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":aperture", "@brief Method double QCameraExposure::aperture()\n", true, &_init_f_aperture_c0, &_call_f_aperture_c0);
  methods += new qt_gsi::GenericMethod ("apertureChanged", "@brief Method void QCameraExposure::apertureChanged(double)\n", false, &_init_f_apertureChanged_1071, &_call_f_apertureChanged_1071);
  methods += new qt_gsi::GenericMethod ("apertureRangeChanged", "@brief Method void QCameraExposure::apertureRangeChanged()\n", false, &_init_f_apertureRangeChanged_0, &_call_f_apertureRangeChanged_0);
  methods += new qt_gsi::GenericMethod (":exposureCompensation", "@brief Method double QCameraExposure::exposureCompensation()\n", true, &_init_f_exposureCompensation_c0, &_call_f_exposureCompensation_c0);
  methods += new qt_gsi::GenericMethod ("exposureCompensationChanged", "@brief Method void QCameraExposure::exposureCompensationChanged(double)\n", false, &_init_f_exposureCompensationChanged_1071, &_call_f_exposureCompensationChanged_1071);
  methods += new qt_gsi::GenericMethod (":exposureMode", "@brief Method QCameraExposure::ExposureMode QCameraExposure::exposureMode()\n", true, &_init_f_exposureMode_c0, &_call_f_exposureMode_c0);
  methods += new qt_gsi::GenericMethod (":flashMode", "@brief Method QFlags<QCameraExposure::FlashMode> QCameraExposure::flashMode()\n", true, &_init_f_flashMode_c0, &_call_f_flashMode_c0);
  methods += new qt_gsi::GenericMethod ("flashReady_sig", "@brief Method void QCameraExposure::flashReady(bool)\n", false, &_init_f_flashReady_864, &_call_f_flashReady_864);
  methods += new qt_gsi::GenericMethod ("isAvailable?", "@brief Method bool QCameraExposure::isAvailable()\n", true, &_init_f_isAvailable_c0, &_call_f_isAvailable_c0);
  methods += new qt_gsi::GenericMethod ("isExposureModeSupported?", "@brief Method bool QCameraExposure::isExposureModeSupported(QCameraExposure::ExposureMode mode)\n", true, &_init_f_isExposureModeSupported_c3325, &_call_f_isExposureModeSupported_c3325);
  methods += new qt_gsi::GenericMethod ("isFlashModeSupported?", "@brief Method bool QCameraExposure::isFlashModeSupported(QFlags<QCameraExposure::FlashMode> mode)\n", true, &_init_f_isFlashModeSupported_c3656, &_call_f_isFlashModeSupported_c3656);
  methods += new qt_gsi::GenericMethod ("isFlashReady?|:flashReady", "@brief Method bool QCameraExposure::isFlashReady()\n", true, &_init_f_isFlashReady_c0, &_call_f_isFlashReady_c0);
  methods += new qt_gsi::GenericMethod ("isMeteringModeSupported?", "@brief Method bool QCameraExposure::isMeteringModeSupported(QCameraExposure::MeteringMode mode)\n", true, &_init_f_isMeteringModeSupported_c3293, &_call_f_isMeteringModeSupported_c3293);
  methods += new qt_gsi::GenericMethod (":isoSensitivity", "@brief Method int QCameraExposure::isoSensitivity()\n", true, &_init_f_isoSensitivity_c0, &_call_f_isoSensitivity_c0);
  methods += new qt_gsi::GenericMethod ("isoSensitivityChanged", "@brief Method void QCameraExposure::isoSensitivityChanged(int)\n", false, &_init_f_isoSensitivityChanged_767, &_call_f_isoSensitivityChanged_767);
  methods += new qt_gsi::GenericMethod (":meteringMode", "@brief Method QCameraExposure::MeteringMode QCameraExposure::meteringMode()\n", true, &_init_f_meteringMode_c0, &_call_f_meteringMode_c0);
  methods += new qt_gsi::GenericMethod ("requestedAperture", "@brief Method double QCameraExposure::requestedAperture()\n", true, &_init_f_requestedAperture_c0, &_call_f_requestedAperture_c0);
  methods += new qt_gsi::GenericMethod ("requestedIsoSensitivity", "@brief Method int QCameraExposure::requestedIsoSensitivity()\n", true, &_init_f_requestedIsoSensitivity_c0, &_call_f_requestedIsoSensitivity_c0);
  methods += new qt_gsi::GenericMethod ("requestedShutterSpeed", "@brief Method double QCameraExposure::requestedShutterSpeed()\n", true, &_init_f_requestedShutterSpeed_c0, &_call_f_requestedShutterSpeed_c0);
  methods += new qt_gsi::GenericMethod ("setAutoAperture", "@brief Method void QCameraExposure::setAutoAperture()\n", false, &_init_f_setAutoAperture_0, &_call_f_setAutoAperture_0);
  methods += new qt_gsi::GenericMethod ("setAutoIsoSensitivity", "@brief Method void QCameraExposure::setAutoIsoSensitivity()\n", false, &_init_f_setAutoIsoSensitivity_0, &_call_f_setAutoIsoSensitivity_0);
  methods += new qt_gsi::GenericMethod ("setAutoShutterSpeed", "@brief Method void QCameraExposure::setAutoShutterSpeed()\n", false, &_init_f_setAutoShutterSpeed_0, &_call_f_setAutoShutterSpeed_0);
  methods += new qt_gsi::GenericMethod ("setExposureCompensation|exposureCompensation=", "@brief Method void QCameraExposure::setExposureCompensation(double ev)\n", false, &_init_f_setExposureCompensation_1071, &_call_f_setExposureCompensation_1071);
  methods += new qt_gsi::GenericMethod ("setExposureMode|exposureMode=", "@brief Method void QCameraExposure::setExposureMode(QCameraExposure::ExposureMode mode)\n", false, &_init_f_setExposureMode_3325, &_call_f_setExposureMode_3325);
  methods += new qt_gsi::GenericMethod ("setFlashMode|flashMode=", "@brief Method void QCameraExposure::setFlashMode(QFlags<QCameraExposure::FlashMode> mode)\n", false, &_init_f_setFlashMode_3656, &_call_f_setFlashMode_3656);
  methods += new qt_gsi::GenericMethod ("setManualAperture", "@brief Method void QCameraExposure::setManualAperture(double aperture)\n", false, &_init_f_setManualAperture_1071, &_call_f_setManualAperture_1071);
  methods += new qt_gsi::GenericMethod ("setManualIsoSensitivity", "@brief Method void QCameraExposure::setManualIsoSensitivity(int iso)\n", false, &_init_f_setManualIsoSensitivity_767, &_call_f_setManualIsoSensitivity_767);
  methods += new qt_gsi::GenericMethod ("setManualShutterSpeed", "@brief Method void QCameraExposure::setManualShutterSpeed(double seconds)\n", false, &_init_f_setManualShutterSpeed_1071, &_call_f_setManualShutterSpeed_1071);
  methods += new qt_gsi::GenericMethod ("setMeteringMode|meteringMode=", "@brief Method void QCameraExposure::setMeteringMode(QCameraExposure::MeteringMode mode)\n", false, &_init_f_setMeteringMode_3293, &_call_f_setMeteringMode_3293);
  methods += new qt_gsi::GenericMethod ("setSpotMeteringPoint|spotMeteringPoint=", "@brief Method void QCameraExposure::setSpotMeteringPoint(const QPointF &point)\n", false, &_init_f_setSpotMeteringPoint_1986, &_call_f_setSpotMeteringPoint_1986);
  methods += new qt_gsi::GenericMethod (":shutterSpeed", "@brief Method double QCameraExposure::shutterSpeed()\n", true, &_init_f_shutterSpeed_c0, &_call_f_shutterSpeed_c0);
  methods += new qt_gsi::GenericMethod ("shutterSpeedChanged", "@brief Method void QCameraExposure::shutterSpeedChanged(double)\n", false, &_init_f_shutterSpeedChanged_1071, &_call_f_shutterSpeedChanged_1071);
  methods += new qt_gsi::GenericMethod ("shutterSpeedRangeChanged", "@brief Method void QCameraExposure::shutterSpeedRangeChanged()\n", false, &_init_f_shutterSpeedRangeChanged_0, &_call_f_shutterSpeedRangeChanged_0);
  methods += new qt_gsi::GenericMethod (":spotMeteringPoint", "@brief Method QPointF QCameraExposure::spotMeteringPoint()\n", true, &_init_f_spotMeteringPoint_c0, &_call_f_spotMeteringPoint_c0);
  methods += new qt_gsi::GenericMethod ("supportedApertures", "@brief Method QList<qreal> QCameraExposure::supportedApertures(bool *continuous)\n", true, &_init_f_supportedApertures_c1050, &_call_f_supportedApertures_c1050);
  methods += new qt_gsi::GenericMethod ("supportedIsoSensitivities", "@brief Method QList<int> QCameraExposure::supportedIsoSensitivities(bool *continuous)\n", true, &_init_f_supportedIsoSensitivities_c1050, &_call_f_supportedIsoSensitivities_c1050);
  methods += new qt_gsi::GenericMethod ("supportedShutterSpeeds", "@brief Method QList<qreal> QCameraExposure::supportedShutterSpeeds(bool *continuous)\n", true, &_init_f_supportedShutterSpeeds_c1050, &_call_f_supportedShutterSpeeds_c1050);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QCameraExposure::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QCameraExposure::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QCameraExposure> decl_QCameraExposure (qtdecl_QObject (), "QtMultimedia", "QCameraExposure",
  methods_QCameraExposure (),
  "@qt\n@brief Binding of QCameraExposure");


GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QCameraExposure> &qtdecl_QCameraExposure () { return decl_QCameraExposure; }

}


//  Implementation of the enum wrapper class for QCameraExposure::ExposureMode
namespace qt_gsi
{

static gsi::Enum<QCameraExposure::ExposureMode> decl_QCameraExposure_ExposureMode_Enum ("QtMultimedia", "QCameraExposure_ExposureMode",
    gsi::enum_const ("ExposureAuto", QCameraExposure::ExposureAuto, "@brief Enum constant QCameraExposure::ExposureAuto") +
    gsi::enum_const ("ExposureManual", QCameraExposure::ExposureManual, "@brief Enum constant QCameraExposure::ExposureManual") +
    gsi::enum_const ("ExposurePortrait", QCameraExposure::ExposurePortrait, "@brief Enum constant QCameraExposure::ExposurePortrait") +
    gsi::enum_const ("ExposureNight", QCameraExposure::ExposureNight, "@brief Enum constant QCameraExposure::ExposureNight") +
    gsi::enum_const ("ExposureBacklight", QCameraExposure::ExposureBacklight, "@brief Enum constant QCameraExposure::ExposureBacklight") +
    gsi::enum_const ("ExposureSpotlight", QCameraExposure::ExposureSpotlight, "@brief Enum constant QCameraExposure::ExposureSpotlight") +
    gsi::enum_const ("ExposureSports", QCameraExposure::ExposureSports, "@brief Enum constant QCameraExposure::ExposureSports") +
    gsi::enum_const ("ExposureSnow", QCameraExposure::ExposureSnow, "@brief Enum constant QCameraExposure::ExposureSnow") +
    gsi::enum_const ("ExposureBeach", QCameraExposure::ExposureBeach, "@brief Enum constant QCameraExposure::ExposureBeach") +
    gsi::enum_const ("ExposureLargeAperture", QCameraExposure::ExposureLargeAperture, "@brief Enum constant QCameraExposure::ExposureLargeAperture") +
    gsi::enum_const ("ExposureSmallAperture", QCameraExposure::ExposureSmallAperture, "@brief Enum constant QCameraExposure::ExposureSmallAperture") +
    gsi::enum_const ("ExposureAction", QCameraExposure::ExposureAction, "@brief Enum constant QCameraExposure::ExposureAction") +
    gsi::enum_const ("ExposureLandscape", QCameraExposure::ExposureLandscape, "@brief Enum constant QCameraExposure::ExposureLandscape") +
    gsi::enum_const ("ExposureNightPortrait", QCameraExposure::ExposureNightPortrait, "@brief Enum constant QCameraExposure::ExposureNightPortrait") +
    gsi::enum_const ("ExposureTheatre", QCameraExposure::ExposureTheatre, "@brief Enum constant QCameraExposure::ExposureTheatre") +
    gsi::enum_const ("ExposureSunset", QCameraExposure::ExposureSunset, "@brief Enum constant QCameraExposure::ExposureSunset") +
    gsi::enum_const ("ExposureSteadyPhoto", QCameraExposure::ExposureSteadyPhoto, "@brief Enum constant QCameraExposure::ExposureSteadyPhoto") +
    gsi::enum_const ("ExposureFireworks", QCameraExposure::ExposureFireworks, "@brief Enum constant QCameraExposure::ExposureFireworks") +
    gsi::enum_const ("ExposureParty", QCameraExposure::ExposureParty, "@brief Enum constant QCameraExposure::ExposureParty") +
    gsi::enum_const ("ExposureCandlelight", QCameraExposure::ExposureCandlelight, "@brief Enum constant QCameraExposure::ExposureCandlelight") +
    gsi::enum_const ("ExposureBarcode", QCameraExposure::ExposureBarcode, "@brief Enum constant QCameraExposure::ExposureBarcode") +
    gsi::enum_const ("ExposureModeVendor", QCameraExposure::ExposureModeVendor, "@brief Enum constant QCameraExposure::ExposureModeVendor"),
  "@qt\n@brief This class represents the QCameraExposure::ExposureMode enum");

static gsi::QFlagsClass<QCameraExposure::ExposureMode > decl_QCameraExposure_ExposureMode_Enums ("QtMultimedia", "QCameraExposure_QFlags_ExposureMode",
  "@qt\n@brief This class represents the QFlags<QCameraExposure::ExposureMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QCameraExposure> inject_QCameraExposure_ExposureMode_Enum_in_parent (decl_QCameraExposure_ExposureMode_Enum.defs ());
static gsi::ClassExt<QCameraExposure> decl_QCameraExposure_ExposureMode_Enum_as_child (decl_QCameraExposure_ExposureMode_Enum, "ExposureMode");
static gsi::ClassExt<QCameraExposure> decl_QCameraExposure_ExposureMode_Enums_as_child (decl_QCameraExposure_ExposureMode_Enums, "QFlags_ExposureMode");

}


//  Implementation of the enum wrapper class for QCameraExposure::FlashMode
namespace qt_gsi
{

static gsi::Enum<QCameraExposure::FlashMode> decl_QCameraExposure_FlashMode_Enum ("QtMultimedia", "QCameraExposure_FlashMode",
    gsi::enum_const ("FlashAuto", QCameraExposure::FlashAuto, "@brief Enum constant QCameraExposure::FlashAuto") +
    gsi::enum_const ("FlashOff", QCameraExposure::FlashOff, "@brief Enum constant QCameraExposure::FlashOff") +
    gsi::enum_const ("FlashOn", QCameraExposure::FlashOn, "@brief Enum constant QCameraExposure::FlashOn") +
    gsi::enum_const ("FlashRedEyeReduction", QCameraExposure::FlashRedEyeReduction, "@brief Enum constant QCameraExposure::FlashRedEyeReduction") +
    gsi::enum_const ("FlashFill", QCameraExposure::FlashFill, "@brief Enum constant QCameraExposure::FlashFill") +
    gsi::enum_const ("FlashTorch", QCameraExposure::FlashTorch, "@brief Enum constant QCameraExposure::FlashTorch") +
    gsi::enum_const ("FlashVideoLight", QCameraExposure::FlashVideoLight, "@brief Enum constant QCameraExposure::FlashVideoLight") +
    gsi::enum_const ("FlashSlowSyncFrontCurtain", QCameraExposure::FlashSlowSyncFrontCurtain, "@brief Enum constant QCameraExposure::FlashSlowSyncFrontCurtain") +
    gsi::enum_const ("FlashSlowSyncRearCurtain", QCameraExposure::FlashSlowSyncRearCurtain, "@brief Enum constant QCameraExposure::FlashSlowSyncRearCurtain") +
    gsi::enum_const ("FlashManual", QCameraExposure::FlashManual, "@brief Enum constant QCameraExposure::FlashManual"),
  "@qt\n@brief This class represents the QCameraExposure::FlashMode enum");

static gsi::QFlagsClass<QCameraExposure::FlashMode > decl_QCameraExposure_FlashMode_Enums ("QtMultimedia", "QCameraExposure_QFlags_FlashMode",
  "@qt\n@brief This class represents the QFlags<QCameraExposure::FlashMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QCameraExposure> inject_QCameraExposure_FlashMode_Enum_in_parent (decl_QCameraExposure_FlashMode_Enum.defs ());
static gsi::ClassExt<QCameraExposure> decl_QCameraExposure_FlashMode_Enum_as_child (decl_QCameraExposure_FlashMode_Enum, "FlashMode");
static gsi::ClassExt<QCameraExposure> decl_QCameraExposure_FlashMode_Enums_as_child (decl_QCameraExposure_FlashMode_Enums, "QFlags_FlashMode");

}


//  Implementation of the enum wrapper class for QCameraExposure::MeteringMode
namespace qt_gsi
{

static gsi::Enum<QCameraExposure::MeteringMode> decl_QCameraExposure_MeteringMode_Enum ("QtMultimedia", "QCameraExposure_MeteringMode",
    gsi::enum_const ("MeteringMatrix", QCameraExposure::MeteringMatrix, "@brief Enum constant QCameraExposure::MeteringMatrix") +
    gsi::enum_const ("MeteringAverage", QCameraExposure::MeteringAverage, "@brief Enum constant QCameraExposure::MeteringAverage") +
    gsi::enum_const ("MeteringSpot", QCameraExposure::MeteringSpot, "@brief Enum constant QCameraExposure::MeteringSpot"),
  "@qt\n@brief This class represents the QCameraExposure::MeteringMode enum");

static gsi::QFlagsClass<QCameraExposure::MeteringMode > decl_QCameraExposure_MeteringMode_Enums ("QtMultimedia", "QCameraExposure_QFlags_MeteringMode",
  "@qt\n@brief This class represents the QFlags<QCameraExposure::MeteringMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QCameraExposure> inject_QCameraExposure_MeteringMode_Enum_in_parent (decl_QCameraExposure_MeteringMode_Enum.defs ());
static gsi::ClassExt<QCameraExposure> decl_QCameraExposure_MeteringMode_Enum_as_child (decl_QCameraExposure_MeteringMode_Enum, "MeteringMode");
static gsi::ClassExt<QCameraExposure> decl_QCameraExposure_MeteringMode_Enums_as_child (decl_QCameraExposure_MeteringMode_Enums, "QFlags_MeteringMode");

}

