
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2021 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQCameraImageProcessingControl.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QCameraImageProcessingControl>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include "gsiDeclQtMultimediaTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QCameraImageProcessingControl

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QCameraImageProcessingControl::staticMetaObject);
}


// bool QCameraImageProcessingControl::isParameterSupported(QCameraImageProcessingControl::ProcessingParameter)


static void _init_f_isParameterSupported_c5473 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QCameraImageProcessingControl::ProcessingParameter>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isParameterSupported_c5473 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraImageProcessingControl::ProcessingParameter>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCameraImageProcessingControl::ProcessingParameter>::target_type & >() (args, heap);
  ret.write<bool > ((bool)((QCameraImageProcessingControl *)cls)->isParameterSupported (qt_gsi::QtToCppAdaptor<QCameraImageProcessingControl::ProcessingParameter>(arg1).cref()));
}


// bool QCameraImageProcessingControl::isParameterValueSupported(QCameraImageProcessingControl::ProcessingParameter parameter, const QVariant &value)


static void _init_f_isParameterValueSupported_c7484 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parameter");
  decl->add_arg<const qt_gsi::Converter<QCameraImageProcessingControl::ProcessingParameter>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_isParameterValueSupported_c7484 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraImageProcessingControl::ProcessingParameter>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCameraImageProcessingControl::ProcessingParameter>::target_type & >() (args, heap);
  const QVariant &arg2 = gsi::arg_reader<const QVariant & >() (args, heap);
  ret.write<bool > ((bool)((QCameraImageProcessingControl *)cls)->isParameterValueSupported (qt_gsi::QtToCppAdaptor<QCameraImageProcessingControl::ProcessingParameter>(arg1).cref(), arg2));
}


// QVariant QCameraImageProcessingControl::parameter(QCameraImageProcessingControl::ProcessingParameter parameter)


static void _init_f_parameter_c5473 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parameter");
  decl->add_arg<const qt_gsi::Converter<QCameraImageProcessingControl::ProcessingParameter>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_parameter_c5473 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraImageProcessingControl::ProcessingParameter>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCameraImageProcessingControl::ProcessingParameter>::target_type & >() (args, heap);
  ret.write<QVariant > ((QVariant)((QCameraImageProcessingControl *)cls)->parameter (qt_gsi::QtToCppAdaptor<QCameraImageProcessingControl::ProcessingParameter>(arg1).cref()));
}


// void QCameraImageProcessingControl::setParameter(QCameraImageProcessingControl::ProcessingParameter parameter, const QVariant &value)


static void _init_f_setParameter_7484 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parameter");
  decl->add_arg<const qt_gsi::Converter<QCameraImageProcessingControl::ProcessingParameter>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setParameter_7484 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraImageProcessingControl::ProcessingParameter>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCameraImageProcessingControl::ProcessingParameter>::target_type & >() (args, heap);
  const QVariant &arg2 = gsi::arg_reader<const QVariant & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageProcessingControl *)cls)->setParameter (qt_gsi::QtToCppAdaptor<QCameraImageProcessingControl::ProcessingParameter>(arg1).cref(), arg2);
}


// static QString QCameraImageProcessingControl::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QCameraImageProcessingControl::tr (arg1, arg2, arg3));
}


// static QString QCameraImageProcessingControl::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QCameraImageProcessingControl::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QCameraImageProcessingControl () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("isParameterSupported?", "@brief Method bool QCameraImageProcessingControl::isParameterSupported(QCameraImageProcessingControl::ProcessingParameter)\n", true, &_init_f_isParameterSupported_c5473, &_call_f_isParameterSupported_c5473);
  methods += new qt_gsi::GenericMethod ("isParameterValueSupported?", "@brief Method bool QCameraImageProcessingControl::isParameterValueSupported(QCameraImageProcessingControl::ProcessingParameter parameter, const QVariant &value)\n", true, &_init_f_isParameterValueSupported_c7484, &_call_f_isParameterValueSupported_c7484);
  methods += new qt_gsi::GenericMethod ("parameter", "@brief Method QVariant QCameraImageProcessingControl::parameter(QCameraImageProcessingControl::ProcessingParameter parameter)\n", true, &_init_f_parameter_c5473, &_call_f_parameter_c5473);
  methods += new qt_gsi::GenericMethod ("setParameter", "@brief Method void QCameraImageProcessingControl::setParameter(QCameraImageProcessingControl::ProcessingParameter parameter, const QVariant &value)\n", false, &_init_f_setParameter_7484, &_call_f_setParameter_7484);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QCameraImageProcessingControl::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QCameraImageProcessingControl::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QMediaControl> &qtdecl_QMediaControl ();

qt_gsi::QtNativeClass<QCameraImageProcessingControl> decl_QCameraImageProcessingControl (qtdecl_QMediaControl (), "QtMultimedia", "QCameraImageProcessingControl_Native",
  methods_QCameraImageProcessingControl (),
  "@hide\n@alias QCameraImageProcessingControl");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QCameraImageProcessingControl> &qtdecl_QCameraImageProcessingControl () { return decl_QCameraImageProcessingControl; }

}


class QCameraImageProcessingControl_Adaptor : public QCameraImageProcessingControl, public qt_gsi::QtObjectBase
{
public:

  virtual ~QCameraImageProcessingControl_Adaptor();

  //  [adaptor ctor] QCameraImageProcessingControl::QCameraImageProcessingControl()
  QCameraImageProcessingControl_Adaptor() : QCameraImageProcessingControl()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QCameraImageProcessingControl::isSignalConnected(const QMetaMethod &signal)
  bool fp_QCameraImageProcessingControl_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QCameraImageProcessingControl::isSignalConnected(signal);
  }

  //  [expose] int QCameraImageProcessingControl::receivers(const char *signal)
  int fp_QCameraImageProcessingControl_receivers_c1731 (const char *signal) const {
    return QCameraImageProcessingControl::receivers(signal);
  }

  //  [expose] QObject *QCameraImageProcessingControl::sender()
  QObject * fp_QCameraImageProcessingControl_sender_c0 () const {
    return QCameraImageProcessingControl::sender();
  }

  //  [expose] int QCameraImageProcessingControl::senderSignalIndex()
  int fp_QCameraImageProcessingControl_senderSignalIndex_c0 () const {
    return QCameraImageProcessingControl::senderSignalIndex();
  }

  //  [adaptor impl] bool QCameraImageProcessingControl::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QCameraImageProcessingControl::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QCameraImageProcessingControl_Adaptor, bool, QEvent *>(&QCameraImageProcessingControl_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QCameraImageProcessingControl::event(arg1);
    }
  }

  //  [adaptor impl] bool QCameraImageProcessingControl::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QCameraImageProcessingControl::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QCameraImageProcessingControl_Adaptor, bool, QObject *, QEvent *>(&QCameraImageProcessingControl_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QCameraImageProcessingControl::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] bool QCameraImageProcessingControl::isParameterSupported(QCameraImageProcessingControl::ProcessingParameter)
  bool cbs_isParameterSupported_c5473_0(const qt_gsi::Converter<QCameraImageProcessingControl::ProcessingParameter>::target_type & arg1) const
  {
    __SUPPRESS_UNUSED_WARNING (arg1);
    throw qt_gsi::AbstractMethodCalledException("isParameterSupported");
  }

  virtual bool isParameterSupported(QCameraImageProcessingControl::ProcessingParameter arg1) const
  {
    if (cb_isParameterSupported_c5473_0.can_issue()) {
      return cb_isParameterSupported_c5473_0.issue<QCameraImageProcessingControl_Adaptor, bool, const qt_gsi::Converter<QCameraImageProcessingControl::ProcessingParameter>::target_type &>(&QCameraImageProcessingControl_Adaptor::cbs_isParameterSupported_c5473_0, qt_gsi::CppToQtAdaptor<QCameraImageProcessingControl::ProcessingParameter>(arg1));
    } else {
      throw qt_gsi::AbstractMethodCalledException("isParameterSupported");
    }
  }

  //  [adaptor impl] bool QCameraImageProcessingControl::isParameterValueSupported(QCameraImageProcessingControl::ProcessingParameter parameter, const QVariant &value)
  bool cbs_isParameterValueSupported_c7484_0(const qt_gsi::Converter<QCameraImageProcessingControl::ProcessingParameter>::target_type & parameter, const QVariant &value) const
  {
    __SUPPRESS_UNUSED_WARNING (parameter);
    __SUPPRESS_UNUSED_WARNING (value);
    throw qt_gsi::AbstractMethodCalledException("isParameterValueSupported");
  }

  virtual bool isParameterValueSupported(QCameraImageProcessingControl::ProcessingParameter parameter, const QVariant &value) const
  {
    if (cb_isParameterValueSupported_c7484_0.can_issue()) {
      return cb_isParameterValueSupported_c7484_0.issue<QCameraImageProcessingControl_Adaptor, bool, const qt_gsi::Converter<QCameraImageProcessingControl::ProcessingParameter>::target_type &, const QVariant &>(&QCameraImageProcessingControl_Adaptor::cbs_isParameterValueSupported_c7484_0, qt_gsi::CppToQtAdaptor<QCameraImageProcessingControl::ProcessingParameter>(parameter), value);
    } else {
      throw qt_gsi::AbstractMethodCalledException("isParameterValueSupported");
    }
  }

  //  [adaptor impl] QVariant QCameraImageProcessingControl::parameter(QCameraImageProcessingControl::ProcessingParameter parameter)
  QVariant cbs_parameter_c5473_0(const qt_gsi::Converter<QCameraImageProcessingControl::ProcessingParameter>::target_type & _parameter) const
  {
    __SUPPRESS_UNUSED_WARNING (_parameter);
    throw qt_gsi::AbstractMethodCalledException("parameter");
  }

  virtual QVariant parameter(QCameraImageProcessingControl::ProcessingParameter _parameter) const
  {
    if (cb_parameter_c5473_0.can_issue()) {
      return cb_parameter_c5473_0.issue<QCameraImageProcessingControl_Adaptor, QVariant, const qt_gsi::Converter<QCameraImageProcessingControl::ProcessingParameter>::target_type &>(&QCameraImageProcessingControl_Adaptor::cbs_parameter_c5473_0, qt_gsi::CppToQtAdaptor<QCameraImageProcessingControl::ProcessingParameter>(_parameter));
    } else {
      throw qt_gsi::AbstractMethodCalledException("parameter");
    }
  }

  //  [adaptor impl] void QCameraImageProcessingControl::setParameter(QCameraImageProcessingControl::ProcessingParameter parameter, const QVariant &value)
  void cbs_setParameter_7484_0(const qt_gsi::Converter<QCameraImageProcessingControl::ProcessingParameter>::target_type & parameter, const QVariant &value)
  {
    __SUPPRESS_UNUSED_WARNING (parameter);
    __SUPPRESS_UNUSED_WARNING (value);
    throw qt_gsi::AbstractMethodCalledException("setParameter");
  }

  virtual void setParameter(QCameraImageProcessingControl::ProcessingParameter parameter, const QVariant &value)
  {
    if (cb_setParameter_7484_0.can_issue()) {
      cb_setParameter_7484_0.issue<QCameraImageProcessingControl_Adaptor, const qt_gsi::Converter<QCameraImageProcessingControl::ProcessingParameter>::target_type &, const QVariant &>(&QCameraImageProcessingControl_Adaptor::cbs_setParameter_7484_0, qt_gsi::CppToQtAdaptor<QCameraImageProcessingControl::ProcessingParameter>(parameter), value);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setParameter");
    }
  }

  //  [adaptor impl] void QCameraImageProcessingControl::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QCameraImageProcessingControl::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QCameraImageProcessingControl_Adaptor, QChildEvent *>(&QCameraImageProcessingControl_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QCameraImageProcessingControl::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QCameraImageProcessingControl::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QCameraImageProcessingControl::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QCameraImageProcessingControl_Adaptor, QEvent *>(&QCameraImageProcessingControl_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QCameraImageProcessingControl::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QCameraImageProcessingControl::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QCameraImageProcessingControl::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QCameraImageProcessingControl_Adaptor, const QMetaMethod &>(&QCameraImageProcessingControl_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QCameraImageProcessingControl::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QCameraImageProcessingControl::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QCameraImageProcessingControl::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QCameraImageProcessingControl_Adaptor, QTimerEvent *>(&QCameraImageProcessingControl_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QCameraImageProcessingControl::timerEvent(arg1);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_isParameterSupported_c5473_0;
  gsi::Callback cb_isParameterValueSupported_c7484_0;
  gsi::Callback cb_parameter_c5473_0;
  gsi::Callback cb_setParameter_7484_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QCameraImageProcessingControl_Adaptor::~QCameraImageProcessingControl_Adaptor() { }

//  Constructor QCameraImageProcessingControl::QCameraImageProcessingControl() (adaptor class)

static void _init_ctor_QCameraImageProcessingControl_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QCameraImageProcessingControl_Adaptor> ();
}

static void _call_ctor_QCameraImageProcessingControl_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QCameraImageProcessingControl_Adaptor *> (new QCameraImageProcessingControl_Adaptor ());
}


// void QCameraImageProcessingControl::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageProcessingControl_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageProcessingControl_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QCameraImageProcessingControl::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageProcessingControl_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageProcessingControl_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// void QCameraImageProcessingControl::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageProcessingControl_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageProcessingControl_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QCameraImageProcessingControl::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QCameraImageProcessingControl_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageProcessingControl_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QCameraImageProcessingControl::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QCameraImageProcessingControl_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageProcessingControl_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// bool QCameraImageProcessingControl::isParameterSupported(QCameraImageProcessingControl::ProcessingParameter)

static void _init_cbs_isParameterSupported_c5473_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QCameraImageProcessingControl::ProcessingParameter>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_isParameterSupported_c5473_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraImageProcessingControl::ProcessingParameter>::target_type & arg1 = args.read<const qt_gsi::Converter<QCameraImageProcessingControl::ProcessingParameter>::target_type & > (heap);
  ret.write<bool > ((bool)((QCameraImageProcessingControl_Adaptor *)cls)->cbs_isParameterSupported_c5473_0 (arg1));
}

static void _set_callback_cbs_isParameterSupported_c5473_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageProcessingControl_Adaptor *)cls)->cb_isParameterSupported_c5473_0 = cb;
}


// bool QCameraImageProcessingControl::isParameterValueSupported(QCameraImageProcessingControl::ProcessingParameter parameter, const QVariant &value)

static void _init_cbs_isParameterValueSupported_c7484_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parameter");
  decl->add_arg<const qt_gsi::Converter<QCameraImageProcessingControl::ProcessingParameter>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_isParameterValueSupported_c7484_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraImageProcessingControl::ProcessingParameter>::target_type & arg1 = args.read<const qt_gsi::Converter<QCameraImageProcessingControl::ProcessingParameter>::target_type & > (heap);
  const QVariant &arg2 = args.read<const QVariant & > (heap);
  ret.write<bool > ((bool)((QCameraImageProcessingControl_Adaptor *)cls)->cbs_isParameterValueSupported_c7484_0 (arg1, arg2));
}

static void _set_callback_cbs_isParameterValueSupported_c7484_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageProcessingControl_Adaptor *)cls)->cb_isParameterValueSupported_c7484_0 = cb;
}


// exposed bool QCameraImageProcessingControl::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QCameraImageProcessingControl_Adaptor *)cls)->fp_QCameraImageProcessingControl_isSignalConnected_c2394 (arg1));
}


// QVariant QCameraImageProcessingControl::parameter(QCameraImageProcessingControl::ProcessingParameter parameter)

static void _init_cbs_parameter_c5473_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parameter");
  decl->add_arg<const qt_gsi::Converter<QCameraImageProcessingControl::ProcessingParameter>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_parameter_c5473_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraImageProcessingControl::ProcessingParameter>::target_type & arg1 = args.read<const qt_gsi::Converter<QCameraImageProcessingControl::ProcessingParameter>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QCameraImageProcessingControl_Adaptor *)cls)->cbs_parameter_c5473_0 (arg1));
}

static void _set_callback_cbs_parameter_c5473_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageProcessingControl_Adaptor *)cls)->cb_parameter_c5473_0 = cb;
}


// exposed int QCameraImageProcessingControl::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QCameraImageProcessingControl_Adaptor *)cls)->fp_QCameraImageProcessingControl_receivers_c1731 (arg1));
}


// exposed QObject *QCameraImageProcessingControl::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QCameraImageProcessingControl_Adaptor *)cls)->fp_QCameraImageProcessingControl_sender_c0 ());
}


// exposed int QCameraImageProcessingControl::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QCameraImageProcessingControl_Adaptor *)cls)->fp_QCameraImageProcessingControl_senderSignalIndex_c0 ());
}


// void QCameraImageProcessingControl::setParameter(QCameraImageProcessingControl::ProcessingParameter parameter, const QVariant &value)

static void _init_cbs_setParameter_7484_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parameter");
  decl->add_arg<const qt_gsi::Converter<QCameraImageProcessingControl::ProcessingParameter>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setParameter_7484_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraImageProcessingControl::ProcessingParameter>::target_type & arg1 = args.read<const qt_gsi::Converter<QCameraImageProcessingControl::ProcessingParameter>::target_type & > (heap);
  const QVariant &arg2 = args.read<const QVariant & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageProcessingControl_Adaptor *)cls)->cbs_setParameter_7484_0 (arg1, arg2);
}

static void _set_callback_cbs_setParameter_7484_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageProcessingControl_Adaptor *)cls)->cb_setParameter_7484_0 = cb;
}


// void QCameraImageProcessingControl::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageProcessingControl_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageProcessingControl_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QCameraImageProcessingControl> &qtdecl_QCameraImageProcessingControl ();

static gsi::Methods methods_QCameraImageProcessingControl_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QCameraImageProcessingControl::QCameraImageProcessingControl()\nThis method creates an object of class QCameraImageProcessingControl.", &_init_ctor_QCameraImageProcessingControl_Adaptor_0, &_call_ctor_QCameraImageProcessingControl_Adaptor_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QCameraImageProcessingControl::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QCameraImageProcessingControl::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QCameraImageProcessingControl::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QCameraImageProcessingControl::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QCameraImageProcessingControl::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("isParameterSupported", "@brief Virtual method bool QCameraImageProcessingControl::isParameterSupported(QCameraImageProcessingControl::ProcessingParameter)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isParameterSupported_c5473_0, &_call_cbs_isParameterSupported_c5473_0);
  methods += new qt_gsi::GenericMethod ("isParameterSupported", "@hide", true, &_init_cbs_isParameterSupported_c5473_0, &_call_cbs_isParameterSupported_c5473_0, &_set_callback_cbs_isParameterSupported_c5473_0);
  methods += new qt_gsi::GenericMethod ("isParameterValueSupported", "@brief Virtual method bool QCameraImageProcessingControl::isParameterValueSupported(QCameraImageProcessingControl::ProcessingParameter parameter, const QVariant &value)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isParameterValueSupported_c7484_0, &_call_cbs_isParameterValueSupported_c7484_0);
  methods += new qt_gsi::GenericMethod ("isParameterValueSupported", "@hide", true, &_init_cbs_isParameterValueSupported_c7484_0, &_call_cbs_isParameterValueSupported_c7484_0, &_set_callback_cbs_isParameterValueSupported_c7484_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QCameraImageProcessingControl::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("parameter", "@brief Virtual method QVariant QCameraImageProcessingControl::parameter(QCameraImageProcessingControl::ProcessingParameter parameter)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_parameter_c5473_0, &_call_cbs_parameter_c5473_0);
  methods += new qt_gsi::GenericMethod ("parameter", "@hide", true, &_init_cbs_parameter_c5473_0, &_call_cbs_parameter_c5473_0, &_set_callback_cbs_parameter_c5473_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QCameraImageProcessingControl::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QCameraImageProcessingControl::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QCameraImageProcessingControl::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setParameter", "@brief Virtual method void QCameraImageProcessingControl::setParameter(QCameraImageProcessingControl::ProcessingParameter parameter, const QVariant &value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setParameter_7484_0, &_call_cbs_setParameter_7484_0);
  methods += new qt_gsi::GenericMethod ("setParameter", "@hide", false, &_init_cbs_setParameter_7484_0, &_call_cbs_setParameter_7484_0, &_set_callback_cbs_setParameter_7484_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QCameraImageProcessingControl::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QCameraImageProcessingControl_Adaptor> decl_QCameraImageProcessingControl_Adaptor (qtdecl_QCameraImageProcessingControl (), "QtMultimedia", "QCameraImageProcessingControl",
  methods_QCameraImageProcessingControl_Adaptor (),
  "@qt\n@brief Binding of QCameraImageProcessingControl");

}


//  Implementation of the enum wrapper class for QCameraImageProcessingControl::ProcessingParameter
namespace qt_gsi
{

static gsi::Enum<QCameraImageProcessingControl::ProcessingParameter> decl_QCameraImageProcessingControl_ProcessingParameter_Enum ("QtMultimedia", "QCameraImageProcessingControl_ProcessingParameter",
    gsi::enum_const ("WhiteBalancePreset", QCameraImageProcessingControl::WhiteBalancePreset, "@brief Enum constant QCameraImageProcessingControl::WhiteBalancePreset") +
    gsi::enum_const ("ColorTemperature", QCameraImageProcessingControl::ColorTemperature, "@brief Enum constant QCameraImageProcessingControl::ColorTemperature") +
    gsi::enum_const ("Contrast", QCameraImageProcessingControl::Contrast, "@brief Enum constant QCameraImageProcessingControl::Contrast") +
    gsi::enum_const ("Saturation", QCameraImageProcessingControl::Saturation, "@brief Enum constant QCameraImageProcessingControl::Saturation") +
    gsi::enum_const ("Brightness", QCameraImageProcessingControl::Brightness, "@brief Enum constant QCameraImageProcessingControl::Brightness") +
    gsi::enum_const ("Sharpening", QCameraImageProcessingControl::Sharpening, "@brief Enum constant QCameraImageProcessingControl::Sharpening") +
    gsi::enum_const ("Denoising", QCameraImageProcessingControl::Denoising, "@brief Enum constant QCameraImageProcessingControl::Denoising") +
    gsi::enum_const ("ContrastAdjustment", QCameraImageProcessingControl::ContrastAdjustment, "@brief Enum constant QCameraImageProcessingControl::ContrastAdjustment") +
    gsi::enum_const ("SaturationAdjustment", QCameraImageProcessingControl::SaturationAdjustment, "@brief Enum constant QCameraImageProcessingControl::SaturationAdjustment") +
    gsi::enum_const ("BrightnessAdjustment", QCameraImageProcessingControl::BrightnessAdjustment, "@brief Enum constant QCameraImageProcessingControl::BrightnessAdjustment") +
    gsi::enum_const ("SharpeningAdjustment", QCameraImageProcessingControl::SharpeningAdjustment, "@brief Enum constant QCameraImageProcessingControl::SharpeningAdjustment") +
    gsi::enum_const ("DenoisingAdjustment", QCameraImageProcessingControl::DenoisingAdjustment, "@brief Enum constant QCameraImageProcessingControl::DenoisingAdjustment") +
    gsi::enum_const ("ColorFilter", QCameraImageProcessingControl::ColorFilter, "@brief Enum constant QCameraImageProcessingControl::ColorFilter") +
    gsi::enum_const ("ExtendedParameter", QCameraImageProcessingControl::ExtendedParameter, "@brief Enum constant QCameraImageProcessingControl::ExtendedParameter"),
  "@qt\n@brief This class represents the QCameraImageProcessingControl::ProcessingParameter enum");

static gsi::QFlagsClass<QCameraImageProcessingControl::ProcessingParameter > decl_QCameraImageProcessingControl_ProcessingParameter_Enums ("QtMultimedia", "QCameraImageProcessingControl_QFlags_ProcessingParameter",
  "@qt\n@brief This class represents the QFlags<QCameraImageProcessingControl::ProcessingParameter> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QCameraImageProcessingControl> inject_QCameraImageProcessingControl_ProcessingParameter_Enum_in_parent (decl_QCameraImageProcessingControl_ProcessingParameter_Enum.defs ());
static gsi::ClassExt<QCameraImageProcessingControl> decl_QCameraImageProcessingControl_ProcessingParameter_Enum_as_child (decl_QCameraImageProcessingControl_ProcessingParameter_Enum, "ProcessingParameter");
static gsi::ClassExt<QCameraImageProcessingControl> decl_QCameraImageProcessingControl_ProcessingParameter_Enums_as_child (decl_QCameraImageProcessingControl_ProcessingParameter_Enums, "QFlags_ProcessingParameter");

}

