
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2021 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQMediaPlayerControl.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QMediaPlayerControl>
#include <QChildEvent>
#include <QEvent>
#include <QIODevice>
#include <QMediaContent>
#include <QMediaTimeRange>
#include <QMetaMethod>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include "gsiDeclQtMultimediaTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QMediaPlayerControl

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QMediaPlayerControl::staticMetaObject);
}


// void QMediaPlayerControl::audioAvailableChanged(bool audioAvailable)


static void _init_f_audioAvailableChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("audioAvailable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_audioAvailableChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl *)cls)->audioAvailableChanged (arg1);
}


// QMediaTimeRange QMediaPlayerControl::availablePlaybackRanges()


static void _init_f_availablePlaybackRanges_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaTimeRange > ();
}

static void _call_f_availablePlaybackRanges_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaTimeRange > ((QMediaTimeRange)((QMediaPlayerControl *)cls)->availablePlaybackRanges ());
}


// void QMediaPlayerControl::availablePlaybackRangesChanged(const QMediaTimeRange &)


static void _init_f_availablePlaybackRangesChanged_2766 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QMediaTimeRange & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_availablePlaybackRangesChanged_2766 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMediaTimeRange &arg1 = gsi::arg_reader<const QMediaTimeRange & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl *)cls)->availablePlaybackRangesChanged (arg1);
}


// int QMediaPlayerControl::bufferStatus()


static void _init_f_bufferStatus_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_bufferStatus_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMediaPlayerControl *)cls)->bufferStatus ());
}


// void QMediaPlayerControl::bufferStatusChanged(int percentFilled)


static void _init_f_bufferStatusChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("percentFilled");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_bufferStatusChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl *)cls)->bufferStatusChanged (arg1);
}


// qint64 QMediaPlayerControl::duration()


static void _init_f_duration_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_duration_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QMediaPlayerControl *)cls)->duration ());
}


// void QMediaPlayerControl::durationChanged(qint64 duration)


static void _init_f_durationChanged_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("duration");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_durationChanged_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl *)cls)->durationChanged (arg1);
}


// void QMediaPlayerControl::error(int error, const QString &errorString)


static void _init_f_error_2684 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("error");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("errorString");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_error_2684 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl *)cls)->error (arg1, arg2);
}


// bool QMediaPlayerControl::isAudioAvailable()


static void _init_f_isAudioAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isAudioAvailable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaPlayerControl *)cls)->isAudioAvailable ());
}


// bool QMediaPlayerControl::isMuted()


static void _init_f_isMuted_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isMuted_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaPlayerControl *)cls)->isMuted ());
}


// bool QMediaPlayerControl::isSeekable()


static void _init_f_isSeekable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSeekable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaPlayerControl *)cls)->isSeekable ());
}


// bool QMediaPlayerControl::isVideoAvailable()


static void _init_f_isVideoAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isVideoAvailable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaPlayerControl *)cls)->isVideoAvailable ());
}


// QMediaContent QMediaPlayerControl::media()


static void _init_f_media_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaContent > ();
}

static void _call_f_media_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaContent > ((QMediaContent)((QMediaPlayerControl *)cls)->media ());
}


// void QMediaPlayerControl::mediaChanged(const QMediaContent &content)


static void _init_f_mediaChanged_2605 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("content");
  decl->add_arg<const QMediaContent & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_mediaChanged_2605 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMediaContent &arg1 = gsi::arg_reader<const QMediaContent & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl *)cls)->mediaChanged (arg1);
}


// QMediaPlayer::MediaStatus QMediaPlayerControl::mediaStatus()


static void _init_f_mediaStatus_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type > ();
}

static void _call_f_mediaStatus_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type > ((qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type)qt_gsi::CppToQtAdaptor<QMediaPlayer::MediaStatus>(((QMediaPlayerControl *)cls)->mediaStatus ()));
}


// void QMediaPlayerControl::mediaStatusChanged(QMediaPlayer::MediaStatus status)


static void _init_f_mediaStatusChanged_2858 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("status");
  decl->add_arg<const qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_mediaStatusChanged_2858 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl *)cls)->mediaStatusChanged (qt_gsi::QtToCppAdaptor<QMediaPlayer::MediaStatus>(arg1).cref());
}


// const QIODevice *QMediaPlayerControl::mediaStream()


static void _init_f_mediaStream_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QIODevice * > ();
}

static void _call_f_mediaStream_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QIODevice * > ((const QIODevice *)((QMediaPlayerControl *)cls)->mediaStream ());
}


// void QMediaPlayerControl::mutedChanged(bool muted)


static void _init_f_mutedChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("muted");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_mutedChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl *)cls)->mutedChanged (arg1);
}


// void QMediaPlayerControl::pause()


static void _init_f_pause_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_pause_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl *)cls)->pause ();
}


// void QMediaPlayerControl::play()


static void _init_f_play_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_play_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl *)cls)->play ();
}


// double QMediaPlayerControl::playbackRate()


static void _init_f_playbackRate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_playbackRate_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QMediaPlayerControl *)cls)->playbackRate ());
}


// void QMediaPlayerControl::playbackRateChanged(double rate)


static void _init_f_playbackRateChanged_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rate");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_playbackRateChanged_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl *)cls)->playbackRateChanged (arg1);
}


// qint64 QMediaPlayerControl::position()


static void _init_f_position_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_position_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QMediaPlayerControl *)cls)->position ());
}


// void QMediaPlayerControl::positionChanged(qint64 position)


static void _init_f_positionChanged_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("position");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_positionChanged_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl *)cls)->positionChanged (arg1);
}


// void QMediaPlayerControl::seekableChanged(bool)


static void _init_f_seekableChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_seekableChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl *)cls)->seekableChanged (arg1);
}


// void QMediaPlayerControl::setMedia(const QMediaContent &media, QIODevice *stream)


static void _init_f_setMedia_3944 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("media");
  decl->add_arg<const QMediaContent & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("stream");
  decl->add_arg<QIODevice * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setMedia_3944 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMediaContent &arg1 = gsi::arg_reader<const QMediaContent & >() (args, heap);
  QIODevice *arg2 = gsi::arg_reader<QIODevice * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl *)cls)->setMedia (arg1, arg2);
}


// void QMediaPlayerControl::setMuted(bool muted)


static void _init_f_setMuted_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("muted");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMuted_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl *)cls)->setMuted (arg1);
}


// void QMediaPlayerControl::setPlaybackRate(double rate)


static void _init_f_setPlaybackRate_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rate");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPlaybackRate_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl *)cls)->setPlaybackRate (arg1);
}


// void QMediaPlayerControl::setPosition(qint64 position)


static void _init_f_setPosition_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("position");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPosition_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl *)cls)->setPosition (arg1);
}


// void QMediaPlayerControl::setVolume(int volume)


static void _init_f_setVolume_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("volume");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVolume_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl *)cls)->setVolume (arg1);
}


// QMediaPlayer::State QMediaPlayerControl::state()


static void _init_f_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMediaPlayer::State>::target_type > ();
}

static void _call_f_state_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMediaPlayer::State>::target_type > ((qt_gsi::Converter<QMediaPlayer::State>::target_type)qt_gsi::CppToQtAdaptor<QMediaPlayer::State>(((QMediaPlayerControl *)cls)->state ()));
}


// void QMediaPlayerControl::stateChanged(QMediaPlayer::State newState)


static void _init_f_stateChanged_2247 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newState");
  decl->add_arg<const qt_gsi::Converter<QMediaPlayer::State>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_stateChanged_2247 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaPlayer::State>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaPlayer::State>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl *)cls)->stateChanged (qt_gsi::QtToCppAdaptor<QMediaPlayer::State>(arg1).cref());
}


// void QMediaPlayerControl::stop()


static void _init_f_stop_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_stop_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl *)cls)->stop ();
}


// void QMediaPlayerControl::videoAvailableChanged(bool videoAvailable)


static void _init_f_videoAvailableChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("videoAvailable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_videoAvailableChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl *)cls)->videoAvailableChanged (arg1);
}


// int QMediaPlayerControl::volume()


static void _init_f_volume_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_volume_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMediaPlayerControl *)cls)->volume ());
}


// void QMediaPlayerControl::volumeChanged(int volume)


static void _init_f_volumeChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("volume");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_volumeChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl *)cls)->volumeChanged (arg1);
}


// static QString QMediaPlayerControl::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QMediaPlayerControl::tr (arg1, arg2, arg3));
}


// static QString QMediaPlayerControl::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QMediaPlayerControl::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QMediaPlayerControl () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("audioAvailableChanged", "@brief Method void QMediaPlayerControl::audioAvailableChanged(bool audioAvailable)\n", false, &_init_f_audioAvailableChanged_864, &_call_f_audioAvailableChanged_864);
  methods += new qt_gsi::GenericMethod ("availablePlaybackRanges", "@brief Method QMediaTimeRange QMediaPlayerControl::availablePlaybackRanges()\n", true, &_init_f_availablePlaybackRanges_c0, &_call_f_availablePlaybackRanges_c0);
  methods += new qt_gsi::GenericMethod ("availablePlaybackRangesChanged", "@brief Method void QMediaPlayerControl::availablePlaybackRangesChanged(const QMediaTimeRange &)\n", false, &_init_f_availablePlaybackRangesChanged_2766, &_call_f_availablePlaybackRangesChanged_2766);
  methods += new qt_gsi::GenericMethod ("bufferStatus", "@brief Method int QMediaPlayerControl::bufferStatus()\n", true, &_init_f_bufferStatus_c0, &_call_f_bufferStatus_c0);
  methods += new qt_gsi::GenericMethod ("bufferStatusChanged", "@brief Method void QMediaPlayerControl::bufferStatusChanged(int percentFilled)\n", false, &_init_f_bufferStatusChanged_767, &_call_f_bufferStatusChanged_767);
  methods += new qt_gsi::GenericMethod ("duration", "@brief Method qint64 QMediaPlayerControl::duration()\n", true, &_init_f_duration_c0, &_call_f_duration_c0);
  methods += new qt_gsi::GenericMethod ("durationChanged", "@brief Method void QMediaPlayerControl::durationChanged(qint64 duration)\n", false, &_init_f_durationChanged_986, &_call_f_durationChanged_986);
  methods += new qt_gsi::GenericMethod ("error", "@brief Method void QMediaPlayerControl::error(int error, const QString &errorString)\n", false, &_init_f_error_2684, &_call_f_error_2684);
  methods += new qt_gsi::GenericMethod ("isAudioAvailable?", "@brief Method bool QMediaPlayerControl::isAudioAvailable()\n", true, &_init_f_isAudioAvailable_c0, &_call_f_isAudioAvailable_c0);
  methods += new qt_gsi::GenericMethod ("isMuted?|:muted", "@brief Method bool QMediaPlayerControl::isMuted()\n", true, &_init_f_isMuted_c0, &_call_f_isMuted_c0);
  methods += new qt_gsi::GenericMethod ("isSeekable?", "@brief Method bool QMediaPlayerControl::isSeekable()\n", true, &_init_f_isSeekable_c0, &_call_f_isSeekable_c0);
  methods += new qt_gsi::GenericMethod ("isVideoAvailable?", "@brief Method bool QMediaPlayerControl::isVideoAvailable()\n", true, &_init_f_isVideoAvailable_c0, &_call_f_isVideoAvailable_c0);
  methods += new qt_gsi::GenericMethod ("media", "@brief Method QMediaContent QMediaPlayerControl::media()\n", true, &_init_f_media_c0, &_call_f_media_c0);
  methods += new qt_gsi::GenericMethod ("mediaChanged", "@brief Method void QMediaPlayerControl::mediaChanged(const QMediaContent &content)\n", false, &_init_f_mediaChanged_2605, &_call_f_mediaChanged_2605);
  methods += new qt_gsi::GenericMethod ("mediaStatus", "@brief Method QMediaPlayer::MediaStatus QMediaPlayerControl::mediaStatus()\n", true, &_init_f_mediaStatus_c0, &_call_f_mediaStatus_c0);
  methods += new qt_gsi::GenericMethod ("mediaStatusChanged", "@brief Method void QMediaPlayerControl::mediaStatusChanged(QMediaPlayer::MediaStatus status)\n", false, &_init_f_mediaStatusChanged_2858, &_call_f_mediaStatusChanged_2858);
  methods += new qt_gsi::GenericMethod ("mediaStream", "@brief Method const QIODevice *QMediaPlayerControl::mediaStream()\n", true, &_init_f_mediaStream_c0, &_call_f_mediaStream_c0);
  methods += new qt_gsi::GenericMethod ("mutedChanged", "@brief Method void QMediaPlayerControl::mutedChanged(bool muted)\n", false, &_init_f_mutedChanged_864, &_call_f_mutedChanged_864);
  methods += new qt_gsi::GenericMethod ("pause", "@brief Method void QMediaPlayerControl::pause()\n", false, &_init_f_pause_0, &_call_f_pause_0);
  methods += new qt_gsi::GenericMethod ("play", "@brief Method void QMediaPlayerControl::play()\n", false, &_init_f_play_0, &_call_f_play_0);
  methods += new qt_gsi::GenericMethod (":playbackRate", "@brief Method double QMediaPlayerControl::playbackRate()\n", true, &_init_f_playbackRate_c0, &_call_f_playbackRate_c0);
  methods += new qt_gsi::GenericMethod ("playbackRateChanged", "@brief Method void QMediaPlayerControl::playbackRateChanged(double rate)\n", false, &_init_f_playbackRateChanged_1071, &_call_f_playbackRateChanged_1071);
  methods += new qt_gsi::GenericMethod (":position", "@brief Method qint64 QMediaPlayerControl::position()\n", true, &_init_f_position_c0, &_call_f_position_c0);
  methods += new qt_gsi::GenericMethod ("positionChanged", "@brief Method void QMediaPlayerControl::positionChanged(qint64 position)\n", false, &_init_f_positionChanged_986, &_call_f_positionChanged_986);
  methods += new qt_gsi::GenericMethod ("seekableChanged", "@brief Method void QMediaPlayerControl::seekableChanged(bool)\n", false, &_init_f_seekableChanged_864, &_call_f_seekableChanged_864);
  methods += new qt_gsi::GenericMethod ("setMedia", "@brief Method void QMediaPlayerControl::setMedia(const QMediaContent &media, QIODevice *stream)\n", false, &_init_f_setMedia_3944, &_call_f_setMedia_3944);
  methods += new qt_gsi::GenericMethod ("setMuted|muted=", "@brief Method void QMediaPlayerControl::setMuted(bool muted)\n", false, &_init_f_setMuted_864, &_call_f_setMuted_864);
  methods += new qt_gsi::GenericMethod ("setPlaybackRate|playbackRate=", "@brief Method void QMediaPlayerControl::setPlaybackRate(double rate)\n", false, &_init_f_setPlaybackRate_1071, &_call_f_setPlaybackRate_1071);
  methods += new qt_gsi::GenericMethod ("setPosition|position=", "@brief Method void QMediaPlayerControl::setPosition(qint64 position)\n", false, &_init_f_setPosition_986, &_call_f_setPosition_986);
  methods += new qt_gsi::GenericMethod ("setVolume|volume=", "@brief Method void QMediaPlayerControl::setVolume(int volume)\n", false, &_init_f_setVolume_767, &_call_f_setVolume_767);
  methods += new qt_gsi::GenericMethod ("state", "@brief Method QMediaPlayer::State QMediaPlayerControl::state()\n", true, &_init_f_state_c0, &_call_f_state_c0);
  methods += new qt_gsi::GenericMethod ("stateChanged", "@brief Method void QMediaPlayerControl::stateChanged(QMediaPlayer::State newState)\n", false, &_init_f_stateChanged_2247, &_call_f_stateChanged_2247);
  methods += new qt_gsi::GenericMethod ("stop", "@brief Method void QMediaPlayerControl::stop()\n", false, &_init_f_stop_0, &_call_f_stop_0);
  methods += new qt_gsi::GenericMethod ("videoAvailableChanged", "@brief Method void QMediaPlayerControl::videoAvailableChanged(bool videoAvailable)\n", false, &_init_f_videoAvailableChanged_864, &_call_f_videoAvailableChanged_864);
  methods += new qt_gsi::GenericMethod (":volume", "@brief Method int QMediaPlayerControl::volume()\n", true, &_init_f_volume_c0, &_call_f_volume_c0);
  methods += new qt_gsi::GenericMethod ("volumeChanged", "@brief Method void QMediaPlayerControl::volumeChanged(int volume)\n", false, &_init_f_volumeChanged_767, &_call_f_volumeChanged_767);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QMediaPlayerControl::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QMediaPlayerControl::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QMediaControl> &qtdecl_QMediaControl ();

qt_gsi::QtNativeClass<QMediaPlayerControl> decl_QMediaPlayerControl (qtdecl_QMediaControl (), "QtMultimedia", "QMediaPlayerControl_Native",
  methods_QMediaPlayerControl (),
  "@hide\n@alias QMediaPlayerControl");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QMediaPlayerControl> &qtdecl_QMediaPlayerControl () { return decl_QMediaPlayerControl; }

}


class QMediaPlayerControl_Adaptor : public QMediaPlayerControl, public qt_gsi::QtObjectBase
{
public:

  virtual ~QMediaPlayerControl_Adaptor();

  //  [adaptor ctor] QMediaPlayerControl::QMediaPlayerControl()
  QMediaPlayerControl_Adaptor() : QMediaPlayerControl()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QMediaPlayerControl::isSignalConnected(const QMetaMethod &signal)
  bool fp_QMediaPlayerControl_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QMediaPlayerControl::isSignalConnected(signal);
  }

  //  [expose] int QMediaPlayerControl::receivers(const char *signal)
  int fp_QMediaPlayerControl_receivers_c1731 (const char *signal) const {
    return QMediaPlayerControl::receivers(signal);
  }

  //  [expose] QObject *QMediaPlayerControl::sender()
  QObject * fp_QMediaPlayerControl_sender_c0 () const {
    return QMediaPlayerControl::sender();
  }

  //  [expose] int QMediaPlayerControl::senderSignalIndex()
  int fp_QMediaPlayerControl_senderSignalIndex_c0 () const {
    return QMediaPlayerControl::senderSignalIndex();
  }

  //  [adaptor impl] QMediaTimeRange QMediaPlayerControl::availablePlaybackRanges()
  QMediaTimeRange cbs_availablePlaybackRanges_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("availablePlaybackRanges");
  }

  virtual QMediaTimeRange availablePlaybackRanges() const
  {
    if (cb_availablePlaybackRanges_c0_0.can_issue()) {
      return cb_availablePlaybackRanges_c0_0.issue<QMediaPlayerControl_Adaptor, QMediaTimeRange>(&QMediaPlayerControl_Adaptor::cbs_availablePlaybackRanges_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("availablePlaybackRanges");
    }
  }

  //  [adaptor impl] int QMediaPlayerControl::bufferStatus()
  int cbs_bufferStatus_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("bufferStatus");
  }

  virtual int bufferStatus() const
  {
    if (cb_bufferStatus_c0_0.can_issue()) {
      return cb_bufferStatus_c0_0.issue<QMediaPlayerControl_Adaptor, int>(&QMediaPlayerControl_Adaptor::cbs_bufferStatus_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("bufferStatus");
    }
  }

  //  [adaptor impl] qint64 QMediaPlayerControl::duration()
  qint64 cbs_duration_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("duration");
  }

  virtual qint64 duration() const
  {
    if (cb_duration_c0_0.can_issue()) {
      return cb_duration_c0_0.issue<QMediaPlayerControl_Adaptor, qint64>(&QMediaPlayerControl_Adaptor::cbs_duration_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("duration");
    }
  }

  //  [adaptor impl] bool QMediaPlayerControl::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QMediaPlayerControl::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QMediaPlayerControl_Adaptor, bool, QEvent *>(&QMediaPlayerControl_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QMediaPlayerControl::event(arg1);
    }
  }

  //  [adaptor impl] bool QMediaPlayerControl::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QMediaPlayerControl::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QMediaPlayerControl_Adaptor, bool, QObject *, QEvent *>(&QMediaPlayerControl_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QMediaPlayerControl::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] bool QMediaPlayerControl::isAudioAvailable()
  bool cbs_isAudioAvailable_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("isAudioAvailable");
  }

  virtual bool isAudioAvailable() const
  {
    if (cb_isAudioAvailable_c0_0.can_issue()) {
      return cb_isAudioAvailable_c0_0.issue<QMediaPlayerControl_Adaptor, bool>(&QMediaPlayerControl_Adaptor::cbs_isAudioAvailable_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("isAudioAvailable");
    }
  }

  //  [adaptor impl] bool QMediaPlayerControl::isMuted()
  bool cbs_isMuted_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("isMuted");
  }

  virtual bool isMuted() const
  {
    if (cb_isMuted_c0_0.can_issue()) {
      return cb_isMuted_c0_0.issue<QMediaPlayerControl_Adaptor, bool>(&QMediaPlayerControl_Adaptor::cbs_isMuted_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("isMuted");
    }
  }

  //  [adaptor impl] bool QMediaPlayerControl::isSeekable()
  bool cbs_isSeekable_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("isSeekable");
  }

  virtual bool isSeekable() const
  {
    if (cb_isSeekable_c0_0.can_issue()) {
      return cb_isSeekable_c0_0.issue<QMediaPlayerControl_Adaptor, bool>(&QMediaPlayerControl_Adaptor::cbs_isSeekable_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("isSeekable");
    }
  }

  //  [adaptor impl] bool QMediaPlayerControl::isVideoAvailable()
  bool cbs_isVideoAvailable_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("isVideoAvailable");
  }

  virtual bool isVideoAvailable() const
  {
    if (cb_isVideoAvailable_c0_0.can_issue()) {
      return cb_isVideoAvailable_c0_0.issue<QMediaPlayerControl_Adaptor, bool>(&QMediaPlayerControl_Adaptor::cbs_isVideoAvailable_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("isVideoAvailable");
    }
  }

  //  [adaptor impl] QMediaContent QMediaPlayerControl::media()
  QMediaContent cbs_media_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("media");
  }

  virtual QMediaContent media() const
  {
    if (cb_media_c0_0.can_issue()) {
      return cb_media_c0_0.issue<QMediaPlayerControl_Adaptor, QMediaContent>(&QMediaPlayerControl_Adaptor::cbs_media_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("media");
    }
  }

  //  [adaptor impl] QMediaPlayer::MediaStatus QMediaPlayerControl::mediaStatus()
  qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type cbs_mediaStatus_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("mediaStatus");
  }

  virtual QMediaPlayer::MediaStatus mediaStatus() const
  {
    if (cb_mediaStatus_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QMediaPlayer::MediaStatus>(cb_mediaStatus_c0_0.issue<QMediaPlayerControl_Adaptor, qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type>(&QMediaPlayerControl_Adaptor::cbs_mediaStatus_c0_0)).cref();
    } else {
      throw qt_gsi::AbstractMethodCalledException("mediaStatus");
    }
  }

  //  [adaptor impl] const QIODevice *QMediaPlayerControl::mediaStream()
  const QIODevice * cbs_mediaStream_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("mediaStream");
  }

  virtual const QIODevice * mediaStream() const
  {
    if (cb_mediaStream_c0_0.can_issue()) {
      return cb_mediaStream_c0_0.issue<QMediaPlayerControl_Adaptor, const QIODevice *>(&QMediaPlayerControl_Adaptor::cbs_mediaStream_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("mediaStream");
    }
  }

  //  [adaptor impl] void QMediaPlayerControl::pause()
  void cbs_pause_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("pause");
  }

  virtual void pause()
  {
    if (cb_pause_0_0.can_issue()) {
      cb_pause_0_0.issue<QMediaPlayerControl_Adaptor>(&QMediaPlayerControl_Adaptor::cbs_pause_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("pause");
    }
  }

  //  [adaptor impl] void QMediaPlayerControl::play()
  void cbs_play_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("play");
  }

  virtual void play()
  {
    if (cb_play_0_0.can_issue()) {
      cb_play_0_0.issue<QMediaPlayerControl_Adaptor>(&QMediaPlayerControl_Adaptor::cbs_play_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("play");
    }
  }

  //  [adaptor impl] double QMediaPlayerControl::playbackRate()
  double cbs_playbackRate_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("playbackRate");
  }

  virtual double playbackRate() const
  {
    if (cb_playbackRate_c0_0.can_issue()) {
      return cb_playbackRate_c0_0.issue<QMediaPlayerControl_Adaptor, double>(&QMediaPlayerControl_Adaptor::cbs_playbackRate_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("playbackRate");
    }
  }

  //  [adaptor impl] qint64 QMediaPlayerControl::position()
  qint64 cbs_position_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("position");
  }

  virtual qint64 position() const
  {
    if (cb_position_c0_0.can_issue()) {
      return cb_position_c0_0.issue<QMediaPlayerControl_Adaptor, qint64>(&QMediaPlayerControl_Adaptor::cbs_position_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("position");
    }
  }

  //  [adaptor impl] void QMediaPlayerControl::setMedia(const QMediaContent &media, QIODevice *stream)
  void cbs_setMedia_3944_0(const QMediaContent &media, QIODevice *stream)
  {
    __SUPPRESS_UNUSED_WARNING (media);
    __SUPPRESS_UNUSED_WARNING (stream);
    throw qt_gsi::AbstractMethodCalledException("setMedia");
  }

  virtual void setMedia(const QMediaContent &media, QIODevice *stream)
  {
    if (cb_setMedia_3944_0.can_issue()) {
      cb_setMedia_3944_0.issue<QMediaPlayerControl_Adaptor, const QMediaContent &, QIODevice *>(&QMediaPlayerControl_Adaptor::cbs_setMedia_3944_0, media, stream);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setMedia");
    }
  }

  //  [adaptor impl] void QMediaPlayerControl::setMuted(bool muted)
  void cbs_setMuted_864_0(bool muted)
  {
    __SUPPRESS_UNUSED_WARNING (muted);
    throw qt_gsi::AbstractMethodCalledException("setMuted");
  }

  virtual void setMuted(bool muted)
  {
    if (cb_setMuted_864_0.can_issue()) {
      cb_setMuted_864_0.issue<QMediaPlayerControl_Adaptor, bool>(&QMediaPlayerControl_Adaptor::cbs_setMuted_864_0, muted);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setMuted");
    }
  }

  //  [adaptor impl] void QMediaPlayerControl::setPlaybackRate(double rate)
  void cbs_setPlaybackRate_1071_0(double rate)
  {
    __SUPPRESS_UNUSED_WARNING (rate);
    throw qt_gsi::AbstractMethodCalledException("setPlaybackRate");
  }

  virtual void setPlaybackRate(double rate)
  {
    if (cb_setPlaybackRate_1071_0.can_issue()) {
      cb_setPlaybackRate_1071_0.issue<QMediaPlayerControl_Adaptor, double>(&QMediaPlayerControl_Adaptor::cbs_setPlaybackRate_1071_0, rate);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setPlaybackRate");
    }
  }

  //  [adaptor impl] void QMediaPlayerControl::setPosition(qint64 position)
  void cbs_setPosition_986_0(qint64 position)
  {
    __SUPPRESS_UNUSED_WARNING (position);
    throw qt_gsi::AbstractMethodCalledException("setPosition");
  }

  virtual void setPosition(qint64 position)
  {
    if (cb_setPosition_986_0.can_issue()) {
      cb_setPosition_986_0.issue<QMediaPlayerControl_Adaptor, qint64>(&QMediaPlayerControl_Adaptor::cbs_setPosition_986_0, position);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setPosition");
    }
  }

  //  [adaptor impl] void QMediaPlayerControl::setVolume(int volume)
  void cbs_setVolume_767_0(int volume)
  {
    __SUPPRESS_UNUSED_WARNING (volume);
    throw qt_gsi::AbstractMethodCalledException("setVolume");
  }

  virtual void setVolume(int volume)
  {
    if (cb_setVolume_767_0.can_issue()) {
      cb_setVolume_767_0.issue<QMediaPlayerControl_Adaptor, int>(&QMediaPlayerControl_Adaptor::cbs_setVolume_767_0, volume);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setVolume");
    }
  }

  //  [adaptor impl] QMediaPlayer::State QMediaPlayerControl::state()
  qt_gsi::Converter<QMediaPlayer::State>::target_type cbs_state_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("state");
  }

  virtual QMediaPlayer::State state() const
  {
    if (cb_state_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QMediaPlayer::State>(cb_state_c0_0.issue<QMediaPlayerControl_Adaptor, qt_gsi::Converter<QMediaPlayer::State>::target_type>(&QMediaPlayerControl_Adaptor::cbs_state_c0_0)).cref();
    } else {
      throw qt_gsi::AbstractMethodCalledException("state");
    }
  }

  //  [adaptor impl] void QMediaPlayerControl::stop()
  void cbs_stop_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("stop");
  }

  virtual void stop()
  {
    if (cb_stop_0_0.can_issue()) {
      cb_stop_0_0.issue<QMediaPlayerControl_Adaptor>(&QMediaPlayerControl_Adaptor::cbs_stop_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("stop");
    }
  }

  //  [adaptor impl] int QMediaPlayerControl::volume()
  int cbs_volume_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("volume");
  }

  virtual int volume() const
  {
    if (cb_volume_c0_0.can_issue()) {
      return cb_volume_c0_0.issue<QMediaPlayerControl_Adaptor, int>(&QMediaPlayerControl_Adaptor::cbs_volume_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("volume");
    }
  }

  //  [adaptor impl] void QMediaPlayerControl::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QMediaPlayerControl::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QMediaPlayerControl_Adaptor, QChildEvent *>(&QMediaPlayerControl_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QMediaPlayerControl::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QMediaPlayerControl::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QMediaPlayerControl::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QMediaPlayerControl_Adaptor, QEvent *>(&QMediaPlayerControl_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QMediaPlayerControl::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QMediaPlayerControl::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QMediaPlayerControl::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QMediaPlayerControl_Adaptor, const QMetaMethod &>(&QMediaPlayerControl_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QMediaPlayerControl::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QMediaPlayerControl::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QMediaPlayerControl::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QMediaPlayerControl_Adaptor, QTimerEvent *>(&QMediaPlayerControl_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QMediaPlayerControl::timerEvent(arg1);
    }
  }

  gsi::Callback cb_availablePlaybackRanges_c0_0;
  gsi::Callback cb_bufferStatus_c0_0;
  gsi::Callback cb_duration_c0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_isAudioAvailable_c0_0;
  gsi::Callback cb_isMuted_c0_0;
  gsi::Callback cb_isSeekable_c0_0;
  gsi::Callback cb_isVideoAvailable_c0_0;
  gsi::Callback cb_media_c0_0;
  gsi::Callback cb_mediaStatus_c0_0;
  gsi::Callback cb_mediaStream_c0_0;
  gsi::Callback cb_pause_0_0;
  gsi::Callback cb_play_0_0;
  gsi::Callback cb_playbackRate_c0_0;
  gsi::Callback cb_position_c0_0;
  gsi::Callback cb_setMedia_3944_0;
  gsi::Callback cb_setMuted_864_0;
  gsi::Callback cb_setPlaybackRate_1071_0;
  gsi::Callback cb_setPosition_986_0;
  gsi::Callback cb_setVolume_767_0;
  gsi::Callback cb_state_c0_0;
  gsi::Callback cb_stop_0_0;
  gsi::Callback cb_volume_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QMediaPlayerControl_Adaptor::~QMediaPlayerControl_Adaptor() { }

//  Constructor QMediaPlayerControl::QMediaPlayerControl() (adaptor class)

static void _init_ctor_QMediaPlayerControl_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QMediaPlayerControl_Adaptor> ();
}

static void _call_ctor_QMediaPlayerControl_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaPlayerControl_Adaptor *> (new QMediaPlayerControl_Adaptor ());
}


// QMediaTimeRange QMediaPlayerControl::availablePlaybackRanges()

static void _init_cbs_availablePlaybackRanges_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaTimeRange > ();
}

static void _call_cbs_availablePlaybackRanges_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaTimeRange > ((QMediaTimeRange)((QMediaPlayerControl_Adaptor *)cls)->cbs_availablePlaybackRanges_c0_0 ());
}

static void _set_callback_cbs_availablePlaybackRanges_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_availablePlaybackRanges_c0_0 = cb;
}


// int QMediaPlayerControl::bufferStatus()

static void _init_cbs_bufferStatus_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_bufferStatus_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMediaPlayerControl_Adaptor *)cls)->cbs_bufferStatus_c0_0 ());
}

static void _set_callback_cbs_bufferStatus_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_bufferStatus_c0_0 = cb;
}


// void QMediaPlayerControl::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QMediaPlayerControl::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// void QMediaPlayerControl::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// qint64 QMediaPlayerControl::duration()

static void _init_cbs_duration_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_cbs_duration_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QMediaPlayerControl_Adaptor *)cls)->cbs_duration_c0_0 ());
}

static void _set_callback_cbs_duration_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_duration_c0_0 = cb;
}


// bool QMediaPlayerControl::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QMediaPlayerControl_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QMediaPlayerControl::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QMediaPlayerControl_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// bool QMediaPlayerControl::isAudioAvailable()

static void _init_cbs_isAudioAvailable_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isAudioAvailable_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaPlayerControl_Adaptor *)cls)->cbs_isAudioAvailable_c0_0 ());
}

static void _set_callback_cbs_isAudioAvailable_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_isAudioAvailable_c0_0 = cb;
}


// bool QMediaPlayerControl::isMuted()

static void _init_cbs_isMuted_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isMuted_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaPlayerControl_Adaptor *)cls)->cbs_isMuted_c0_0 ());
}

static void _set_callback_cbs_isMuted_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_isMuted_c0_0 = cb;
}


// bool QMediaPlayerControl::isSeekable()

static void _init_cbs_isSeekable_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isSeekable_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaPlayerControl_Adaptor *)cls)->cbs_isSeekable_c0_0 ());
}

static void _set_callback_cbs_isSeekable_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_isSeekable_c0_0 = cb;
}


// exposed bool QMediaPlayerControl::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QMediaPlayerControl_Adaptor *)cls)->fp_QMediaPlayerControl_isSignalConnected_c2394 (arg1));
}


// bool QMediaPlayerControl::isVideoAvailable()

static void _init_cbs_isVideoAvailable_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isVideoAvailable_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaPlayerControl_Adaptor *)cls)->cbs_isVideoAvailable_c0_0 ());
}

static void _set_callback_cbs_isVideoAvailable_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_isVideoAvailable_c0_0 = cb;
}


// QMediaContent QMediaPlayerControl::media()

static void _init_cbs_media_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaContent > ();
}

static void _call_cbs_media_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaContent > ((QMediaContent)((QMediaPlayerControl_Adaptor *)cls)->cbs_media_c0_0 ());
}

static void _set_callback_cbs_media_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_media_c0_0 = cb;
}


// QMediaPlayer::MediaStatus QMediaPlayerControl::mediaStatus()

static void _init_cbs_mediaStatus_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type > ();
}

static void _call_cbs_mediaStatus_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type > ((qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type)((QMediaPlayerControl_Adaptor *)cls)->cbs_mediaStatus_c0_0 ());
}

static void _set_callback_cbs_mediaStatus_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_mediaStatus_c0_0 = cb;
}


// const QIODevice *QMediaPlayerControl::mediaStream()

static void _init_cbs_mediaStream_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QIODevice * > ();
}

static void _call_cbs_mediaStream_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QIODevice * > ((const QIODevice *)((QMediaPlayerControl_Adaptor *)cls)->cbs_mediaStream_c0_0 ());
}

static void _set_callback_cbs_mediaStream_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_mediaStream_c0_0 = cb;
}


// void QMediaPlayerControl::pause()

static void _init_cbs_pause_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_pause_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl_Adaptor *)cls)->cbs_pause_0_0 ();
}

static void _set_callback_cbs_pause_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_pause_0_0 = cb;
}


// void QMediaPlayerControl::play()

static void _init_cbs_play_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_play_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl_Adaptor *)cls)->cbs_play_0_0 ();
}

static void _set_callback_cbs_play_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_play_0_0 = cb;
}


// double QMediaPlayerControl::playbackRate()

static void _init_cbs_playbackRate_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_cbs_playbackRate_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QMediaPlayerControl_Adaptor *)cls)->cbs_playbackRate_c0_0 ());
}

static void _set_callback_cbs_playbackRate_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_playbackRate_c0_0 = cb;
}


// qint64 QMediaPlayerControl::position()

static void _init_cbs_position_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_cbs_position_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QMediaPlayerControl_Adaptor *)cls)->cbs_position_c0_0 ());
}

static void _set_callback_cbs_position_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_position_c0_0 = cb;
}


// exposed int QMediaPlayerControl::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QMediaPlayerControl_Adaptor *)cls)->fp_QMediaPlayerControl_receivers_c1731 (arg1));
}


// exposed QObject *QMediaPlayerControl::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QMediaPlayerControl_Adaptor *)cls)->fp_QMediaPlayerControl_sender_c0 ());
}


// exposed int QMediaPlayerControl::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMediaPlayerControl_Adaptor *)cls)->fp_QMediaPlayerControl_senderSignalIndex_c0 ());
}


// void QMediaPlayerControl::setMedia(const QMediaContent &media, QIODevice *stream)

static void _init_cbs_setMedia_3944_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("media");
  decl->add_arg<const QMediaContent & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("stream");
  decl->add_arg<QIODevice * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setMedia_3944_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMediaContent &arg1 = args.read<const QMediaContent & > (heap);
  QIODevice *arg2 = args.read<QIODevice * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl_Adaptor *)cls)->cbs_setMedia_3944_0 (arg1, arg2);
}

static void _set_callback_cbs_setMedia_3944_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_setMedia_3944_0 = cb;
}


// void QMediaPlayerControl::setMuted(bool muted)

static void _init_cbs_setMuted_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("muted");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setMuted_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl_Adaptor *)cls)->cbs_setMuted_864_0 (arg1);
}

static void _set_callback_cbs_setMuted_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_setMuted_864_0 = cb;
}


// void QMediaPlayerControl::setPlaybackRate(double rate)

static void _init_cbs_setPlaybackRate_1071_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rate");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setPlaybackRate_1071_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = args.read<double > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl_Adaptor *)cls)->cbs_setPlaybackRate_1071_0 (arg1);
}

static void _set_callback_cbs_setPlaybackRate_1071_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_setPlaybackRate_1071_0 = cb;
}


// void QMediaPlayerControl::setPosition(qint64 position)

static void _init_cbs_setPosition_986_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("position");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setPosition_986_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = args.read<qint64 > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl_Adaptor *)cls)->cbs_setPosition_986_0 (arg1);
}

static void _set_callback_cbs_setPosition_986_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_setPosition_986_0 = cb;
}


// void QMediaPlayerControl::setVolume(int volume)

static void _init_cbs_setVolume_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("volume");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVolume_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl_Adaptor *)cls)->cbs_setVolume_767_0 (arg1);
}

static void _set_callback_cbs_setVolume_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_setVolume_767_0 = cb;
}


// QMediaPlayer::State QMediaPlayerControl::state()

static void _init_cbs_state_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMediaPlayer::State>::target_type > ();
}

static void _call_cbs_state_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMediaPlayer::State>::target_type > ((qt_gsi::Converter<QMediaPlayer::State>::target_type)((QMediaPlayerControl_Adaptor *)cls)->cbs_state_c0_0 ());
}

static void _set_callback_cbs_state_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_state_c0_0 = cb;
}


// void QMediaPlayerControl::stop()

static void _init_cbs_stop_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_stop_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl_Adaptor *)cls)->cbs_stop_0_0 ();
}

static void _set_callback_cbs_stop_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_stop_0_0 = cb;
}


// void QMediaPlayerControl::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// int QMediaPlayerControl::volume()

static void _init_cbs_volume_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_volume_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMediaPlayerControl_Adaptor *)cls)->cbs_volume_c0_0 ());
}

static void _set_callback_cbs_volume_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_volume_c0_0 = cb;
}


namespace gsi
{

gsi::Class<QMediaPlayerControl> &qtdecl_QMediaPlayerControl ();

static gsi::Methods methods_QMediaPlayerControl_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMediaPlayerControl::QMediaPlayerControl()\nThis method creates an object of class QMediaPlayerControl.", &_init_ctor_QMediaPlayerControl_Adaptor_0, &_call_ctor_QMediaPlayerControl_Adaptor_0);
  methods += new qt_gsi::GenericMethod ("availablePlaybackRanges", "@brief Virtual method QMediaTimeRange QMediaPlayerControl::availablePlaybackRanges()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_availablePlaybackRanges_c0_0, &_call_cbs_availablePlaybackRanges_c0_0);
  methods += new qt_gsi::GenericMethod ("availablePlaybackRanges", "@hide", true, &_init_cbs_availablePlaybackRanges_c0_0, &_call_cbs_availablePlaybackRanges_c0_0, &_set_callback_cbs_availablePlaybackRanges_c0_0);
  methods += new qt_gsi::GenericMethod ("bufferStatus", "@brief Virtual method int QMediaPlayerControl::bufferStatus()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_bufferStatus_c0_0, &_call_cbs_bufferStatus_c0_0);
  methods += new qt_gsi::GenericMethod ("bufferStatus", "@hide", true, &_init_cbs_bufferStatus_c0_0, &_call_cbs_bufferStatus_c0_0, &_set_callback_cbs_bufferStatus_c0_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QMediaPlayerControl::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QMediaPlayerControl::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QMediaPlayerControl::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("duration", "@brief Virtual method qint64 QMediaPlayerControl::duration()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_duration_c0_0, &_call_cbs_duration_c0_0);
  methods += new qt_gsi::GenericMethod ("duration", "@hide", true, &_init_cbs_duration_c0_0, &_call_cbs_duration_c0_0, &_set_callback_cbs_duration_c0_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QMediaPlayerControl::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QMediaPlayerControl::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("isAudioAvailable", "@brief Virtual method bool QMediaPlayerControl::isAudioAvailable()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isAudioAvailable_c0_0, &_call_cbs_isAudioAvailable_c0_0);
  methods += new qt_gsi::GenericMethod ("isAudioAvailable", "@hide", true, &_init_cbs_isAudioAvailable_c0_0, &_call_cbs_isAudioAvailable_c0_0, &_set_callback_cbs_isAudioAvailable_c0_0);
  methods += new qt_gsi::GenericMethod ("isMuted", "@brief Virtual method bool QMediaPlayerControl::isMuted()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isMuted_c0_0, &_call_cbs_isMuted_c0_0);
  methods += new qt_gsi::GenericMethod ("isMuted", "@hide", true, &_init_cbs_isMuted_c0_0, &_call_cbs_isMuted_c0_0, &_set_callback_cbs_isMuted_c0_0);
  methods += new qt_gsi::GenericMethod ("isSeekable", "@brief Virtual method bool QMediaPlayerControl::isSeekable()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isSeekable_c0_0, &_call_cbs_isSeekable_c0_0);
  methods += new qt_gsi::GenericMethod ("isSeekable", "@hide", true, &_init_cbs_isSeekable_c0_0, &_call_cbs_isSeekable_c0_0, &_set_callback_cbs_isSeekable_c0_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QMediaPlayerControl::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("isVideoAvailable", "@brief Virtual method bool QMediaPlayerControl::isVideoAvailable()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isVideoAvailable_c0_0, &_call_cbs_isVideoAvailable_c0_0);
  methods += new qt_gsi::GenericMethod ("isVideoAvailable", "@hide", true, &_init_cbs_isVideoAvailable_c0_0, &_call_cbs_isVideoAvailable_c0_0, &_set_callback_cbs_isVideoAvailable_c0_0);
  methods += new qt_gsi::GenericMethod ("media", "@brief Virtual method QMediaContent QMediaPlayerControl::media()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_media_c0_0, &_call_cbs_media_c0_0);
  methods += new qt_gsi::GenericMethod ("media", "@hide", true, &_init_cbs_media_c0_0, &_call_cbs_media_c0_0, &_set_callback_cbs_media_c0_0);
  methods += new qt_gsi::GenericMethod ("mediaStatus", "@brief Virtual method QMediaPlayer::MediaStatus QMediaPlayerControl::mediaStatus()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mediaStatus_c0_0, &_call_cbs_mediaStatus_c0_0);
  methods += new qt_gsi::GenericMethod ("mediaStatus", "@hide", true, &_init_cbs_mediaStatus_c0_0, &_call_cbs_mediaStatus_c0_0, &_set_callback_cbs_mediaStatus_c0_0);
  methods += new qt_gsi::GenericMethod ("mediaStream", "@brief Virtual method const QIODevice *QMediaPlayerControl::mediaStream()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mediaStream_c0_0, &_call_cbs_mediaStream_c0_0);
  methods += new qt_gsi::GenericMethod ("mediaStream", "@hide", true, &_init_cbs_mediaStream_c0_0, &_call_cbs_mediaStream_c0_0, &_set_callback_cbs_mediaStream_c0_0);
  methods += new qt_gsi::GenericMethod ("pause", "@brief Virtual method void QMediaPlayerControl::pause()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_pause_0_0, &_call_cbs_pause_0_0);
  methods += new qt_gsi::GenericMethod ("pause", "@hide", false, &_init_cbs_pause_0_0, &_call_cbs_pause_0_0, &_set_callback_cbs_pause_0_0);
  methods += new qt_gsi::GenericMethod ("play", "@brief Virtual method void QMediaPlayerControl::play()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_play_0_0, &_call_cbs_play_0_0);
  methods += new qt_gsi::GenericMethod ("play", "@hide", false, &_init_cbs_play_0_0, &_call_cbs_play_0_0, &_set_callback_cbs_play_0_0);
  methods += new qt_gsi::GenericMethod ("playbackRate", "@brief Virtual method double QMediaPlayerControl::playbackRate()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_playbackRate_c0_0, &_call_cbs_playbackRate_c0_0);
  methods += new qt_gsi::GenericMethod ("playbackRate", "@hide", true, &_init_cbs_playbackRate_c0_0, &_call_cbs_playbackRate_c0_0, &_set_callback_cbs_playbackRate_c0_0);
  methods += new qt_gsi::GenericMethod ("position", "@brief Virtual method qint64 QMediaPlayerControl::position()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_position_c0_0, &_call_cbs_position_c0_0);
  methods += new qt_gsi::GenericMethod ("position", "@hide", true, &_init_cbs_position_c0_0, &_call_cbs_position_c0_0, &_set_callback_cbs_position_c0_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QMediaPlayerControl::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QMediaPlayerControl::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QMediaPlayerControl::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setMedia", "@brief Virtual method void QMediaPlayerControl::setMedia(const QMediaContent &media, QIODevice *stream)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setMedia_3944_0, &_call_cbs_setMedia_3944_0);
  methods += new qt_gsi::GenericMethod ("setMedia", "@hide", false, &_init_cbs_setMedia_3944_0, &_call_cbs_setMedia_3944_0, &_set_callback_cbs_setMedia_3944_0);
  methods += new qt_gsi::GenericMethod ("setMuted", "@brief Virtual method void QMediaPlayerControl::setMuted(bool muted)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setMuted_864_0, &_call_cbs_setMuted_864_0);
  methods += new qt_gsi::GenericMethod ("setMuted", "@hide", false, &_init_cbs_setMuted_864_0, &_call_cbs_setMuted_864_0, &_set_callback_cbs_setMuted_864_0);
  methods += new qt_gsi::GenericMethod ("setPlaybackRate", "@brief Virtual method void QMediaPlayerControl::setPlaybackRate(double rate)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setPlaybackRate_1071_0, &_call_cbs_setPlaybackRate_1071_0);
  methods += new qt_gsi::GenericMethod ("setPlaybackRate", "@hide", false, &_init_cbs_setPlaybackRate_1071_0, &_call_cbs_setPlaybackRate_1071_0, &_set_callback_cbs_setPlaybackRate_1071_0);
  methods += new qt_gsi::GenericMethod ("setPosition", "@brief Virtual method void QMediaPlayerControl::setPosition(qint64 position)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setPosition_986_0, &_call_cbs_setPosition_986_0);
  methods += new qt_gsi::GenericMethod ("setPosition", "@hide", false, &_init_cbs_setPosition_986_0, &_call_cbs_setPosition_986_0, &_set_callback_cbs_setPosition_986_0);
  methods += new qt_gsi::GenericMethod ("setVolume", "@brief Virtual method void QMediaPlayerControl::setVolume(int volume)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVolume_767_0, &_call_cbs_setVolume_767_0);
  methods += new qt_gsi::GenericMethod ("setVolume", "@hide", false, &_init_cbs_setVolume_767_0, &_call_cbs_setVolume_767_0, &_set_callback_cbs_setVolume_767_0);
  methods += new qt_gsi::GenericMethod ("state", "@brief Virtual method QMediaPlayer::State QMediaPlayerControl::state()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_state_c0_0, &_call_cbs_state_c0_0);
  methods += new qt_gsi::GenericMethod ("state", "@hide", true, &_init_cbs_state_c0_0, &_call_cbs_state_c0_0, &_set_callback_cbs_state_c0_0);
  methods += new qt_gsi::GenericMethod ("stop", "@brief Virtual method void QMediaPlayerControl::stop()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_stop_0_0, &_call_cbs_stop_0_0);
  methods += new qt_gsi::GenericMethod ("stop", "@hide", false, &_init_cbs_stop_0_0, &_call_cbs_stop_0_0, &_set_callback_cbs_stop_0_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QMediaPlayerControl::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("volume", "@brief Virtual method int QMediaPlayerControl::volume()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_volume_c0_0, &_call_cbs_volume_c0_0);
  methods += new qt_gsi::GenericMethod ("volume", "@hide", true, &_init_cbs_volume_c0_0, &_call_cbs_volume_c0_0, &_set_callback_cbs_volume_c0_0);
  return methods;
}

gsi::Class<QMediaPlayerControl_Adaptor> decl_QMediaPlayerControl_Adaptor (qtdecl_QMediaPlayerControl (), "QtMultimedia", "QMediaPlayerControl",
  methods_QMediaPlayerControl_Adaptor (),
  "@qt\n@brief Binding of QMediaPlayerControl");

}

