
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2021 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQMediaPlaylist.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QMediaPlaylist>
#include <QChildEvent>
#include <QEvent>
#include <QIODevice>
#include <QMediaContent>
#include <QMediaObject>
#include <QMetaMethod>
#include <QNetworkRequest>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include <QUrl>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include "gsiDeclQtMultimediaTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QMediaPlaylist

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QMediaPlaylist::staticMetaObject);
}


// bool QMediaPlaylist::addMedia(const QMediaContent &content)


static void _init_f_addMedia_2605 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("content");
  decl->add_arg<const QMediaContent & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_addMedia_2605 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMediaContent &arg1 = gsi::arg_reader<const QMediaContent & >() (args, heap);
  ret.write<bool > ((bool)((QMediaPlaylist *)cls)->addMedia (arg1));
}


// bool QMediaPlaylist::addMedia(const QList<QMediaContent> &items)


static void _init_f_addMedia_3220 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("items");
  decl->add_arg<const QList<QMediaContent> & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_addMedia_3220 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QMediaContent> &arg1 = gsi::arg_reader<const QList<QMediaContent> & >() (args, heap);
  ret.write<bool > ((bool)((QMediaPlaylist *)cls)->addMedia (arg1));
}


// bool QMediaPlaylist::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaPlaylist *)cls)->clear ());
}


// int QMediaPlaylist::currentIndex()


static void _init_f_currentIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_currentIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMediaPlaylist *)cls)->currentIndex ());
}


// void QMediaPlaylist::currentIndexChanged(int index)


static void _init_f_currentIndexChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_currentIndexChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlaylist *)cls)->currentIndexChanged (arg1);
}


// QMediaContent QMediaPlaylist::currentMedia()


static void _init_f_currentMedia_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaContent > ();
}

static void _call_f_currentMedia_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaContent > ((QMediaContent)((QMediaPlaylist *)cls)->currentMedia ());
}


// void QMediaPlaylist::currentMediaChanged(const QMediaContent &)


static void _init_f_currentMediaChanged_2605 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QMediaContent & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_currentMediaChanged_2605 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMediaContent &arg1 = gsi::arg_reader<const QMediaContent & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlaylist *)cls)->currentMediaChanged (arg1);
}


// QMediaPlaylist::Error QMediaPlaylist::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMediaPlaylist::Error>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMediaPlaylist::Error>::target_type > ((qt_gsi::Converter<QMediaPlaylist::Error>::target_type)qt_gsi::CppToQtAdaptor<QMediaPlaylist::Error>(((QMediaPlaylist *)cls)->error ()));
}


// QString QMediaPlaylist::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QMediaPlaylist *)cls)->errorString ());
}


// bool QMediaPlaylist::insertMedia(int index, const QMediaContent &content)


static void _init_f_insertMedia_3264 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("content");
  decl->add_arg<const QMediaContent & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_insertMedia_3264 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QMediaContent &arg2 = gsi::arg_reader<const QMediaContent & >() (args, heap);
  ret.write<bool > ((bool)((QMediaPlaylist *)cls)->insertMedia (arg1, arg2));
}


// bool QMediaPlaylist::insertMedia(int index, const QList<QMediaContent> &items)


static void _init_f_insertMedia_3879 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("items");
  decl->add_arg<const QList<QMediaContent> & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_insertMedia_3879 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QList<QMediaContent> &arg2 = gsi::arg_reader<const QList<QMediaContent> & >() (args, heap);
  ret.write<bool > ((bool)((QMediaPlaylist *)cls)->insertMedia (arg1, arg2));
}


// bool QMediaPlaylist::isEmpty()


static void _init_f_isEmpty_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEmpty_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaPlaylist *)cls)->isEmpty ());
}


// bool QMediaPlaylist::isReadOnly()


static void _init_f_isReadOnly_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isReadOnly_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaPlaylist *)cls)->isReadOnly ());
}


// void QMediaPlaylist::load(const QNetworkRequest &request, const char *format)


static void _init_f_load_4508 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("request");
  decl->add_arg<const QNetworkRequest & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_load_4508 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QNetworkRequest &arg1 = gsi::arg_reader<const QNetworkRequest & >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlaylist *)cls)->load (arg1, arg2);
}


// void QMediaPlaylist::load(const QUrl &location, const char *format)


static void _init_f_load_3324 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("location");
  decl->add_arg<const QUrl & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_load_3324 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlaylist *)cls)->load (arg1, arg2);
}


// void QMediaPlaylist::load(QIODevice *device, const char *format)


static void _init_f_load_3070 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_load_3070 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QIODevice *arg1 = gsi::arg_reader<QIODevice * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlaylist *)cls)->load (arg1, arg2);
}


// void QMediaPlaylist::loadFailed()


static void _init_f_loadFailed_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_loadFailed_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlaylist *)cls)->loadFailed ();
}


// void QMediaPlaylist::loaded()


static void _init_f_loaded_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_loaded_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlaylist *)cls)->loaded ();
}


// QMediaContent QMediaPlaylist::media(int index)


static void _init_f_media_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QMediaContent > ();
}

static void _call_f_media_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QMediaContent > ((QMediaContent)((QMediaPlaylist *)cls)->media (arg1));
}


// void QMediaPlaylist::mediaAboutToBeInserted(int start, int end)


static void _init_f_mediaAboutToBeInserted_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("start");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("end");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_mediaAboutToBeInserted_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlaylist *)cls)->mediaAboutToBeInserted (arg1, arg2);
}


// void QMediaPlaylist::mediaAboutToBeRemoved(int start, int end)


static void _init_f_mediaAboutToBeRemoved_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("start");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("end");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_mediaAboutToBeRemoved_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlaylist *)cls)->mediaAboutToBeRemoved (arg1, arg2);
}


// void QMediaPlaylist::mediaChanged(int start, int end)


static void _init_f_mediaChanged_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("start");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("end");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_mediaChanged_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlaylist *)cls)->mediaChanged (arg1, arg2);
}


// int QMediaPlaylist::mediaCount()


static void _init_f_mediaCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_mediaCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMediaPlaylist *)cls)->mediaCount ());
}


// void QMediaPlaylist::mediaInserted(int start, int end)


static void _init_f_mediaInserted_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("start");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("end");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_mediaInserted_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlaylist *)cls)->mediaInserted (arg1, arg2);
}


// QMediaObject *QMediaPlaylist::mediaObject()


static void _init_f_mediaObject_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaObject * > ();
}

static void _call_f_mediaObject_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaObject * > ((QMediaObject *)((QMediaPlaylist *)cls)->mediaObject ());
}


// void QMediaPlaylist::mediaRemoved(int start, int end)


static void _init_f_mediaRemoved_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("start");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("end");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_mediaRemoved_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlaylist *)cls)->mediaRemoved (arg1, arg2);
}


// void QMediaPlaylist::next()


static void _init_f_next_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_next_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlaylist *)cls)->next ();
}


// int QMediaPlaylist::nextIndex(int steps)


static void _init_f_nextIndex_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("steps", true, "1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_nextIndex_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (1, heap);
  ret.write<int > ((int)((QMediaPlaylist *)cls)->nextIndex (arg1));
}


// QMediaPlaylist::PlaybackMode QMediaPlaylist::playbackMode()


static void _init_f_playbackMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMediaPlaylist::PlaybackMode>::target_type > ();
}

static void _call_f_playbackMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMediaPlaylist::PlaybackMode>::target_type > ((qt_gsi::Converter<QMediaPlaylist::PlaybackMode>::target_type)qt_gsi::CppToQtAdaptor<QMediaPlaylist::PlaybackMode>(((QMediaPlaylist *)cls)->playbackMode ()));
}


// void QMediaPlaylist::playbackModeChanged(QMediaPlaylist::PlaybackMode mode)


static void _init_f_playbackModeChanged_3159 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QMediaPlaylist::PlaybackMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_playbackModeChanged_3159 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaPlaylist::PlaybackMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaPlaylist::PlaybackMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlaylist *)cls)->playbackModeChanged (qt_gsi::QtToCppAdaptor<QMediaPlaylist::PlaybackMode>(arg1).cref());
}


// void QMediaPlaylist::previous()


static void _init_f_previous_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_previous_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlaylist *)cls)->previous ();
}


// int QMediaPlaylist::previousIndex(int steps)


static void _init_f_previousIndex_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("steps", true, "1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_previousIndex_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (1, heap);
  ret.write<int > ((int)((QMediaPlaylist *)cls)->previousIndex (arg1));
}


// bool QMediaPlaylist::removeMedia(int pos)


static void _init_f_removeMedia_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_removeMedia_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QMediaPlaylist *)cls)->removeMedia (arg1));
}


// bool QMediaPlaylist::removeMedia(int start, int end)


static void _init_f_removeMedia_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("start");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("end");
  decl->add_arg<int > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_removeMedia_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QMediaPlaylist *)cls)->removeMedia (arg1, arg2));
}


// bool QMediaPlaylist::save(const QUrl &location, const char *format)


static void _init_f_save_3324 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("location");
  decl->add_arg<const QUrl & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_save_3324 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<bool > ((bool)((QMediaPlaylist *)cls)->save (arg1, arg2));
}


// bool QMediaPlaylist::save(QIODevice *device, const char *format)


static void _init_f_save_3070 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_save_3070 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QIODevice *arg1 = gsi::arg_reader<QIODevice * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<bool > ((bool)((QMediaPlaylist *)cls)->save (arg1, arg2));
}


// void QMediaPlaylist::setCurrentIndex(int index)


static void _init_f_setCurrentIndex_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCurrentIndex_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlaylist *)cls)->setCurrentIndex (arg1);
}


// void QMediaPlaylist::setPlaybackMode(QMediaPlaylist::PlaybackMode mode)


static void _init_f_setPlaybackMode_3159 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QMediaPlaylist::PlaybackMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPlaybackMode_3159 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaPlaylist::PlaybackMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaPlaylist::PlaybackMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlaylist *)cls)->setPlaybackMode (qt_gsi::QtToCppAdaptor<QMediaPlaylist::PlaybackMode>(arg1).cref());
}


// void QMediaPlaylist::shuffle()


static void _init_f_shuffle_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_shuffle_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlaylist *)cls)->shuffle ();
}


// static QString QMediaPlaylist::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QMediaPlaylist::tr (arg1, arg2, arg3));
}


// static QString QMediaPlaylist::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QMediaPlaylist::trUtf8 (arg1, arg2, arg3));
}


//  base class cast for QObject

static void _init_f_QMediaPlaylist_as_QObject (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject *> ();
}

static void _call_f_QMediaPlaylist_as_QObject (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<QObject *> ((QObject *)(QMediaPlaylist *)cls);
}

static void _init_f_QMediaPlaylist_as_const_QObject (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QObject *> ();
}

static void _call_f_QMediaPlaylist_as_const_QObject (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QObject *> ((const QObject *)(const QMediaPlaylist *)cls);
}

//  base class cast for QMediaBindableInterface

static void _init_f_QMediaPlaylist_as_QMediaBindableInterface (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaBindableInterface *> ();
}

static void _call_f_QMediaPlaylist_as_QMediaBindableInterface (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<QMediaBindableInterface *> ((QMediaBindableInterface *)(QMediaPlaylist *)cls);
}

static void _init_f_QMediaPlaylist_as_const_QMediaBindableInterface (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QMediaBindableInterface *> ();
}

static void _call_f_QMediaPlaylist_as_const_QMediaBindableInterface (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMediaBindableInterface *> ((const QMediaBindableInterface *)(const QMediaPlaylist *)cls);
}


namespace gsi
{

static gsi::Methods methods_QMediaPlaylist () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("addMedia", "@brief Method bool QMediaPlaylist::addMedia(const QMediaContent &content)\n", false, &_init_f_addMedia_2605, &_call_f_addMedia_2605);
  methods += new qt_gsi::GenericMethod ("addMedia", "@brief Method bool QMediaPlaylist::addMedia(const QList<QMediaContent> &items)\n", false, &_init_f_addMedia_3220, &_call_f_addMedia_3220);
  methods += new qt_gsi::GenericMethod ("clear", "@brief Method bool QMediaPlaylist::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
  methods += new qt_gsi::GenericMethod (":currentIndex", "@brief Method int QMediaPlaylist::currentIndex()\n", true, &_init_f_currentIndex_c0, &_call_f_currentIndex_c0);
  methods += new qt_gsi::GenericMethod ("currentIndexChanged", "@brief Method void QMediaPlaylist::currentIndexChanged(int index)\n", false, &_init_f_currentIndexChanged_767, &_call_f_currentIndexChanged_767);
  methods += new qt_gsi::GenericMethod (":currentMedia", "@brief Method QMediaContent QMediaPlaylist::currentMedia()\n", true, &_init_f_currentMedia_c0, &_call_f_currentMedia_c0);
  methods += new qt_gsi::GenericMethod ("currentMediaChanged", "@brief Method void QMediaPlaylist::currentMediaChanged(const QMediaContent &)\n", false, &_init_f_currentMediaChanged_2605, &_call_f_currentMediaChanged_2605);
  methods += new qt_gsi::GenericMethod ("error", "@brief Method QMediaPlaylist::Error QMediaPlaylist::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
  methods += new qt_gsi::GenericMethod ("errorString", "@brief Method QString QMediaPlaylist::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
  methods += new qt_gsi::GenericMethod ("insertMedia", "@brief Method bool QMediaPlaylist::insertMedia(int index, const QMediaContent &content)\n", false, &_init_f_insertMedia_3264, &_call_f_insertMedia_3264);
  methods += new qt_gsi::GenericMethod ("insertMedia", "@brief Method bool QMediaPlaylist::insertMedia(int index, const QList<QMediaContent> &items)\n", false, &_init_f_insertMedia_3879, &_call_f_insertMedia_3879);
  methods += new qt_gsi::GenericMethod ("isEmpty?", "@brief Method bool QMediaPlaylist::isEmpty()\n", true, &_init_f_isEmpty_c0, &_call_f_isEmpty_c0);
  methods += new qt_gsi::GenericMethod ("isReadOnly?", "@brief Method bool QMediaPlaylist::isReadOnly()\n", true, &_init_f_isReadOnly_c0, &_call_f_isReadOnly_c0);
  methods += new qt_gsi::GenericMethod ("load", "@brief Method void QMediaPlaylist::load(const QNetworkRequest &request, const char *format)\n", false, &_init_f_load_4508, &_call_f_load_4508);
  methods += new qt_gsi::GenericMethod ("load", "@brief Method void QMediaPlaylist::load(const QUrl &location, const char *format)\n", false, &_init_f_load_3324, &_call_f_load_3324);
  methods += new qt_gsi::GenericMethod ("load", "@brief Method void QMediaPlaylist::load(QIODevice *device, const char *format)\n", false, &_init_f_load_3070, &_call_f_load_3070);
  methods += new qt_gsi::GenericMethod ("loadFailed", "@brief Method void QMediaPlaylist::loadFailed()\n", false, &_init_f_loadFailed_0, &_call_f_loadFailed_0);
  methods += new qt_gsi::GenericMethod ("loaded", "@brief Method void QMediaPlaylist::loaded()\n", false, &_init_f_loaded_0, &_call_f_loaded_0);
  methods += new qt_gsi::GenericMethod ("media", "@brief Method QMediaContent QMediaPlaylist::media(int index)\n", true, &_init_f_media_c767, &_call_f_media_c767);
  methods += new qt_gsi::GenericMethod ("mediaAboutToBeInserted", "@brief Method void QMediaPlaylist::mediaAboutToBeInserted(int start, int end)\n", false, &_init_f_mediaAboutToBeInserted_1426, &_call_f_mediaAboutToBeInserted_1426);
  methods += new qt_gsi::GenericMethod ("mediaAboutToBeRemoved", "@brief Method void QMediaPlaylist::mediaAboutToBeRemoved(int start, int end)\n", false, &_init_f_mediaAboutToBeRemoved_1426, &_call_f_mediaAboutToBeRemoved_1426);
  methods += new qt_gsi::GenericMethod ("mediaChanged", "@brief Method void QMediaPlaylist::mediaChanged(int start, int end)\n", false, &_init_f_mediaChanged_1426, &_call_f_mediaChanged_1426);
  methods += new qt_gsi::GenericMethod ("mediaCount", "@brief Method int QMediaPlaylist::mediaCount()\n", true, &_init_f_mediaCount_c0, &_call_f_mediaCount_c0);
  methods += new qt_gsi::GenericMethod ("mediaInserted", "@brief Method void QMediaPlaylist::mediaInserted(int start, int end)\n", false, &_init_f_mediaInserted_1426, &_call_f_mediaInserted_1426);
  methods += new qt_gsi::GenericMethod ("mediaObject", "@brief Method QMediaObject *QMediaPlaylist::mediaObject()\nThis is a reimplementation of QMediaBindableInterface::mediaObject", true, &_init_f_mediaObject_c0, &_call_f_mediaObject_c0);
  methods += new qt_gsi::GenericMethod ("mediaRemoved", "@brief Method void QMediaPlaylist::mediaRemoved(int start, int end)\n", false, &_init_f_mediaRemoved_1426, &_call_f_mediaRemoved_1426);
  methods += new qt_gsi::GenericMethod ("next", "@brief Method void QMediaPlaylist::next()\n", false, &_init_f_next_0, &_call_f_next_0);
  methods += new qt_gsi::GenericMethod ("nextIndex", "@brief Method int QMediaPlaylist::nextIndex(int steps)\n", true, &_init_f_nextIndex_c767, &_call_f_nextIndex_c767);
  methods += new qt_gsi::GenericMethod (":playbackMode", "@brief Method QMediaPlaylist::PlaybackMode QMediaPlaylist::playbackMode()\n", true, &_init_f_playbackMode_c0, &_call_f_playbackMode_c0);
  methods += new qt_gsi::GenericMethod ("playbackModeChanged", "@brief Method void QMediaPlaylist::playbackModeChanged(QMediaPlaylist::PlaybackMode mode)\n", false, &_init_f_playbackModeChanged_3159, &_call_f_playbackModeChanged_3159);
  methods += new qt_gsi::GenericMethod ("previous", "@brief Method void QMediaPlaylist::previous()\n", false, &_init_f_previous_0, &_call_f_previous_0);
  methods += new qt_gsi::GenericMethod ("previousIndex", "@brief Method int QMediaPlaylist::previousIndex(int steps)\n", true, &_init_f_previousIndex_c767, &_call_f_previousIndex_c767);
  methods += new qt_gsi::GenericMethod ("removeMedia", "@brief Method bool QMediaPlaylist::removeMedia(int pos)\n", false, &_init_f_removeMedia_767, &_call_f_removeMedia_767);
  methods += new qt_gsi::GenericMethod ("removeMedia", "@brief Method bool QMediaPlaylist::removeMedia(int start, int end)\n", false, &_init_f_removeMedia_1426, &_call_f_removeMedia_1426);
  methods += new qt_gsi::GenericMethod ("save", "@brief Method bool QMediaPlaylist::save(const QUrl &location, const char *format)\n", false, &_init_f_save_3324, &_call_f_save_3324);
  methods += new qt_gsi::GenericMethod ("save", "@brief Method bool QMediaPlaylist::save(QIODevice *device, const char *format)\n", false, &_init_f_save_3070, &_call_f_save_3070);
  methods += new qt_gsi::GenericMethod ("setCurrentIndex|currentIndex=", "@brief Method void QMediaPlaylist::setCurrentIndex(int index)\n", false, &_init_f_setCurrentIndex_767, &_call_f_setCurrentIndex_767);
  methods += new qt_gsi::GenericMethod ("setPlaybackMode|playbackMode=", "@brief Method void QMediaPlaylist::setPlaybackMode(QMediaPlaylist::PlaybackMode mode)\n", false, &_init_f_setPlaybackMode_3159, &_call_f_setPlaybackMode_3159);
  methods += new qt_gsi::GenericMethod ("shuffle", "@brief Method void QMediaPlaylist::shuffle()\n", false, &_init_f_shuffle_0, &_call_f_shuffle_0);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QMediaPlaylist::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QMediaPlaylist::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  methods += new qt_gsi::GenericMethod ("asQObject", "@brief Delivers the base class interface QObject of QMediaPlaylist\nClass QMediaPlaylist is derived from multiple base classes. This method delivers the QObject base class aspect.", false, &_init_f_QMediaPlaylist_as_QObject, &_call_f_QMediaPlaylist_as_QObject);
  methods += new qt_gsi::GenericMethod ("asConstQObject", "@brief Delivers the base class interface QObject of QMediaPlaylist\nClass QMediaPlaylist is derived from multiple base classes. This method delivers the QObject base class aspect.\n\nUse this version if you have a const reference.", true, &_init_f_QMediaPlaylist_as_const_QObject, &_call_f_QMediaPlaylist_as_const_QObject);
  methods += new qt_gsi::GenericMethod ("asQMediaBindableInterface", "@brief Delivers the base class interface QMediaBindableInterface of QMediaPlaylist\nClass QMediaPlaylist is derived from multiple base classes. This method delivers the QMediaBindableInterface base class aspect.", false, &_init_f_QMediaPlaylist_as_QMediaBindableInterface, &_call_f_QMediaPlaylist_as_QMediaBindableInterface);
  methods += new qt_gsi::GenericMethod ("asConstQMediaBindableInterface", "@brief Delivers the base class interface QMediaBindableInterface of QMediaPlaylist\nClass QMediaPlaylist is derived from multiple base classes. This method delivers the QMediaBindableInterface base class aspect.\n\nUse this version if you have a const reference.", true, &_init_f_QMediaPlaylist_as_const_QMediaBindableInterface, &_call_f_QMediaPlaylist_as_const_QMediaBindableInterface);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QMediaPlaylist> decl_QMediaPlaylist (qtdecl_QObject (), "QtMultimedia", "QMediaPlaylist_Native",
  methods_QMediaPlaylist (),
  "@hide\n@alias QMediaPlaylist");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QMediaPlaylist> &qtdecl_QMediaPlaylist () { return decl_QMediaPlaylist; }

}


class QMediaPlaylist_Adaptor : public QMediaPlaylist, public qt_gsi::QtObjectBase
{
public:

  virtual ~QMediaPlaylist_Adaptor();

  //  [adaptor ctor] QMediaPlaylist::QMediaPlaylist(QObject *parent)
  QMediaPlaylist_Adaptor() : QMediaPlaylist()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMediaPlaylist::QMediaPlaylist(QObject *parent)
  QMediaPlaylist_Adaptor(QObject *parent) : QMediaPlaylist(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QMediaPlaylist::isSignalConnected(const QMetaMethod &signal)
  bool fp_QMediaPlaylist_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QMediaPlaylist::isSignalConnected(signal);
  }

  //  [expose] int QMediaPlaylist::receivers(const char *signal)
  int fp_QMediaPlaylist_receivers_c1731 (const char *signal) const {
    return QMediaPlaylist::receivers(signal);
  }

  //  [expose] QObject *QMediaPlaylist::sender()
  QObject * fp_QMediaPlaylist_sender_c0 () const {
    return QMediaPlaylist::sender();
  }

  //  [expose] int QMediaPlaylist::senderSignalIndex()
  int fp_QMediaPlaylist_senderSignalIndex_c0 () const {
    return QMediaPlaylist::senderSignalIndex();
  }

  //  [adaptor impl] bool QMediaPlaylist::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QMediaPlaylist::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QMediaPlaylist_Adaptor, bool, QEvent *>(&QMediaPlaylist_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QMediaPlaylist::event(arg1);
    }
  }

  //  [adaptor impl] bool QMediaPlaylist::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QMediaPlaylist::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QMediaPlaylist_Adaptor, bool, QObject *, QEvent *>(&QMediaPlaylist_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QMediaPlaylist::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] QMediaObject *QMediaPlaylist::mediaObject()
  QMediaObject * cbs_mediaObject_c0_0() const
  {
    return QMediaPlaylist::mediaObject();
  }

  virtual QMediaObject * mediaObject() const
  {
    if (cb_mediaObject_c0_0.can_issue()) {
      return cb_mediaObject_c0_0.issue<QMediaPlaylist_Adaptor, QMediaObject *>(&QMediaPlaylist_Adaptor::cbs_mediaObject_c0_0);
    } else {
      return QMediaPlaylist::mediaObject();
    }
  }

  //  [adaptor impl] void QMediaPlaylist::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QMediaPlaylist::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QMediaPlaylist_Adaptor, QChildEvent *>(&QMediaPlaylist_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QMediaPlaylist::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QMediaPlaylist::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QMediaPlaylist::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QMediaPlaylist_Adaptor, QEvent *>(&QMediaPlaylist_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QMediaPlaylist::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QMediaPlaylist::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QMediaPlaylist::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QMediaPlaylist_Adaptor, const QMetaMethod &>(&QMediaPlaylist_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QMediaPlaylist::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] bool QMediaPlaylist::setMediaObject(QMediaObject *object)
  bool cbs_setMediaObject_1782_0(QMediaObject *object)
  {
    return QMediaPlaylist::setMediaObject(object);
  }

  virtual bool setMediaObject(QMediaObject *object)
  {
    if (cb_setMediaObject_1782_0.can_issue()) {
      return cb_setMediaObject_1782_0.issue<QMediaPlaylist_Adaptor, bool, QMediaObject *>(&QMediaPlaylist_Adaptor::cbs_setMediaObject_1782_0, object);
    } else {
      return QMediaPlaylist::setMediaObject(object);
    }
  }

  //  [adaptor impl] void QMediaPlaylist::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QMediaPlaylist::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QMediaPlaylist_Adaptor, QTimerEvent *>(&QMediaPlaylist_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QMediaPlaylist::timerEvent(arg1);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_mediaObject_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_setMediaObject_1782_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QMediaPlaylist_Adaptor::~QMediaPlaylist_Adaptor() { }

//  Constructor QMediaPlaylist::QMediaPlaylist(QObject *parent) (adaptor class)

static void _init_ctor_QMediaPlaylist_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QMediaPlaylist_Adaptor> ();
}

static void _call_ctor_QMediaPlaylist_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QMediaPlaylist_Adaptor *> (new QMediaPlaylist_Adaptor (arg1));
}


// void QMediaPlaylist::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlaylist_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlaylist_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QMediaPlaylist::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlaylist_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlaylist_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// void QMediaPlaylist::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlaylist_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlaylist_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QMediaPlaylist::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QMediaPlaylist_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlaylist_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QMediaPlaylist::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QMediaPlaylist_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlaylist_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed bool QMediaPlaylist::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QMediaPlaylist_Adaptor *)cls)->fp_QMediaPlaylist_isSignalConnected_c2394 (arg1));
}


// QMediaObject *QMediaPlaylist::mediaObject()

static void _init_cbs_mediaObject_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaObject * > ();
}

static void _call_cbs_mediaObject_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaObject * > ((QMediaObject *)((QMediaPlaylist_Adaptor *)cls)->cbs_mediaObject_c0_0 ());
}

static void _set_callback_cbs_mediaObject_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlaylist_Adaptor *)cls)->cb_mediaObject_c0_0 = cb;
}


// exposed int QMediaPlaylist::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QMediaPlaylist_Adaptor *)cls)->fp_QMediaPlaylist_receivers_c1731 (arg1));
}


// exposed QObject *QMediaPlaylist::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QMediaPlaylist_Adaptor *)cls)->fp_QMediaPlaylist_sender_c0 ());
}


// exposed int QMediaPlaylist::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMediaPlaylist_Adaptor *)cls)->fp_QMediaPlaylist_senderSignalIndex_c0 ());
}


// bool QMediaPlaylist::setMediaObject(QMediaObject *object)

static void _init_cbs_setMediaObject_1782_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("object");
  decl->add_arg<QMediaObject * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_setMediaObject_1782_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMediaObject *arg1 = args.read<QMediaObject * > (heap);
  ret.write<bool > ((bool)((QMediaPlaylist_Adaptor *)cls)->cbs_setMediaObject_1782_0 (arg1));
}

static void _set_callback_cbs_setMediaObject_1782_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlaylist_Adaptor *)cls)->cb_setMediaObject_1782_0 = cb;
}


// void QMediaPlaylist::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlaylist_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlaylist_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QMediaPlaylist> &qtdecl_QMediaPlaylist ();

static gsi::Methods methods_QMediaPlaylist_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMediaPlaylist::QMediaPlaylist(QObject *parent)\nThis method creates an object of class QMediaPlaylist.", &_init_ctor_QMediaPlaylist_Adaptor_1302, &_call_ctor_QMediaPlaylist_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QMediaPlaylist::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QMediaPlaylist::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QMediaPlaylist::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QMediaPlaylist::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QMediaPlaylist::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QMediaPlaylist::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("mediaObject", "@brief Virtual method QMediaObject *QMediaPlaylist::mediaObject()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mediaObject_c0_0, &_call_cbs_mediaObject_c0_0);
  methods += new qt_gsi::GenericMethod ("mediaObject", "@hide", true, &_init_cbs_mediaObject_c0_0, &_call_cbs_mediaObject_c0_0, &_set_callback_cbs_mediaObject_c0_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QMediaPlaylist::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QMediaPlaylist::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QMediaPlaylist::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*setMediaObject", "@brief Virtual method bool QMediaPlaylist::setMediaObject(QMediaObject *object)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setMediaObject_1782_0, &_call_cbs_setMediaObject_1782_0);
  methods += new qt_gsi::GenericMethod ("*setMediaObject", "@hide", false, &_init_cbs_setMediaObject_1782_0, &_call_cbs_setMediaObject_1782_0, &_set_callback_cbs_setMediaObject_1782_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QMediaPlaylist::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QMediaPlaylist_Adaptor> decl_QMediaPlaylist_Adaptor (qtdecl_QMediaPlaylist (), "QtMultimedia", "QMediaPlaylist",
  methods_QMediaPlaylist_Adaptor (),
  "@qt\n@brief Binding of QMediaPlaylist");

}


//  Implementation of the enum wrapper class for QMediaPlaylist::Error
namespace qt_gsi
{

static gsi::Enum<QMediaPlaylist::Error> decl_QMediaPlaylist_Error_Enum ("QtMultimedia", "QMediaPlaylist_Error",
    gsi::enum_const ("NoError", QMediaPlaylist::NoError, "@brief Enum constant QMediaPlaylist::NoError") +
    gsi::enum_const ("FormatError", QMediaPlaylist::FormatError, "@brief Enum constant QMediaPlaylist::FormatError") +
    gsi::enum_const ("FormatNotSupportedError", QMediaPlaylist::FormatNotSupportedError, "@brief Enum constant QMediaPlaylist::FormatNotSupportedError") +
    gsi::enum_const ("NetworkError", QMediaPlaylist::NetworkError, "@brief Enum constant QMediaPlaylist::NetworkError") +
    gsi::enum_const ("AccessDeniedError", QMediaPlaylist::AccessDeniedError, "@brief Enum constant QMediaPlaylist::AccessDeniedError"),
  "@qt\n@brief This class represents the QMediaPlaylist::Error enum");

static gsi::QFlagsClass<QMediaPlaylist::Error > decl_QMediaPlaylist_Error_Enums ("QtMultimedia", "QMediaPlaylist_QFlags_Error",
  "@qt\n@brief This class represents the QFlags<QMediaPlaylist::Error> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QMediaPlaylist> inject_QMediaPlaylist_Error_Enum_in_parent (decl_QMediaPlaylist_Error_Enum.defs ());
static gsi::ClassExt<QMediaPlaylist> decl_QMediaPlaylist_Error_Enum_as_child (decl_QMediaPlaylist_Error_Enum, "Error");
static gsi::ClassExt<QMediaPlaylist> decl_QMediaPlaylist_Error_Enums_as_child (decl_QMediaPlaylist_Error_Enums, "QFlags_Error");

}


//  Implementation of the enum wrapper class for QMediaPlaylist::PlaybackMode
namespace qt_gsi
{

static gsi::Enum<QMediaPlaylist::PlaybackMode> decl_QMediaPlaylist_PlaybackMode_Enum ("QtMultimedia", "QMediaPlaylist_PlaybackMode",
    gsi::enum_const ("CurrentItemOnce", QMediaPlaylist::CurrentItemOnce, "@brief Enum constant QMediaPlaylist::CurrentItemOnce") +
    gsi::enum_const ("CurrentItemInLoop", QMediaPlaylist::CurrentItemInLoop, "@brief Enum constant QMediaPlaylist::CurrentItemInLoop") +
    gsi::enum_const ("Sequential", QMediaPlaylist::Sequential, "@brief Enum constant QMediaPlaylist::Sequential") +
    gsi::enum_const ("Loop", QMediaPlaylist::Loop, "@brief Enum constant QMediaPlaylist::Loop") +
    gsi::enum_const ("Random", QMediaPlaylist::Random, "@brief Enum constant QMediaPlaylist::Random"),
  "@qt\n@brief This class represents the QMediaPlaylist::PlaybackMode enum");

static gsi::QFlagsClass<QMediaPlaylist::PlaybackMode > decl_QMediaPlaylist_PlaybackMode_Enums ("QtMultimedia", "QMediaPlaylist_QFlags_PlaybackMode",
  "@qt\n@brief This class represents the QFlags<QMediaPlaylist::PlaybackMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QMediaPlaylist> inject_QMediaPlaylist_PlaybackMode_Enum_in_parent (decl_QMediaPlaylist_PlaybackMode_Enum.defs ());
static gsi::ClassExt<QMediaPlaylist> decl_QMediaPlaylist_PlaybackMode_Enum_as_child (decl_QMediaPlaylist_PlaybackMode_Enum, "PlaybackMode");
static gsi::ClassExt<QMediaPlaylist> decl_QMediaPlaylist_PlaybackMode_Enums_as_child (decl_QMediaPlaylist_PlaybackMode_Enums, "QFlags_PlaybackMode");

}

