
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2021 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQRadioDataControl.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QRadioDataControl>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include "gsiDeclQtMultimediaTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QRadioDataControl

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QRadioDataControl::staticMetaObject);
}


// void QRadioDataControl::alternativeFrequenciesEnabledChanged(bool enabled)


static void _init_f_alternativeFrequenciesEnabledChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_alternativeFrequenciesEnabledChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioDataControl *)cls)->alternativeFrequenciesEnabledChanged (arg1);
}


// QRadioData::Error QRadioDataControl::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QRadioData::Error>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QRadioData::Error>::target_type > ((qt_gsi::Converter<QRadioData::Error>::target_type)qt_gsi::CppToQtAdaptor<QRadioData::Error>(((QRadioDataControl *)cls)->error ()));
}


// void QRadioDataControl::error(QRadioData::Error err)


static void _init_f_error_2028 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("err");
  decl->add_arg<const qt_gsi::Converter<QRadioData::Error>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_error_2028 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QRadioData::Error>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QRadioData::Error>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioDataControl *)cls)->error (qt_gsi::QtToCppAdaptor<QRadioData::Error>(arg1).cref());
}


// QString QRadioDataControl::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QRadioDataControl *)cls)->errorString ());
}


// bool QRadioDataControl::isAlternativeFrequenciesEnabled()


static void _init_f_isAlternativeFrequenciesEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isAlternativeFrequenciesEnabled_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QRadioDataControl *)cls)->isAlternativeFrequenciesEnabled ());
}


// QRadioData::ProgramType QRadioDataControl::programType()


static void _init_f_programType_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QRadioData::ProgramType>::target_type > ();
}

static void _call_f_programType_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QRadioData::ProgramType>::target_type > ((qt_gsi::Converter<QRadioData::ProgramType>::target_type)qt_gsi::CppToQtAdaptor<QRadioData::ProgramType>(((QRadioDataControl *)cls)->programType ()));
}


// void QRadioDataControl::programTypeChanged(QRadioData::ProgramType programType)


static void _init_f_programTypeChanged_2652 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("programType");
  decl->add_arg<const qt_gsi::Converter<QRadioData::ProgramType>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_programTypeChanged_2652 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QRadioData::ProgramType>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QRadioData::ProgramType>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioDataControl *)cls)->programTypeChanged (qt_gsi::QtToCppAdaptor<QRadioData::ProgramType>(arg1).cref());
}


// QString QRadioDataControl::programTypeName()


static void _init_f_programTypeName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_programTypeName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QRadioDataControl *)cls)->programTypeName ());
}


// void QRadioDataControl::programTypeNameChanged(QString programTypeName)


static void _init_f_programTypeNameChanged_1148 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("programTypeName");
  decl->add_arg<QString > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_programTypeNameChanged_1148 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QString arg1 = gsi::arg_reader<QString >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioDataControl *)cls)->programTypeNameChanged (arg1);
}


// QString QRadioDataControl::radioText()


static void _init_f_radioText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_radioText_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QRadioDataControl *)cls)->radioText ());
}


// void QRadioDataControl::radioTextChanged(QString radioText)


static void _init_f_radioTextChanged_1148 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("radioText");
  decl->add_arg<QString > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_radioTextChanged_1148 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QString arg1 = gsi::arg_reader<QString >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioDataControl *)cls)->radioTextChanged (arg1);
}


// void QRadioDataControl::setAlternativeFrequenciesEnabled(bool enabled)


static void _init_f_setAlternativeFrequenciesEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAlternativeFrequenciesEnabled_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioDataControl *)cls)->setAlternativeFrequenciesEnabled (arg1);
}


// QString QRadioDataControl::stationId()


static void _init_f_stationId_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_stationId_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QRadioDataControl *)cls)->stationId ());
}


// void QRadioDataControl::stationIdChanged(QString stationId)


static void _init_f_stationIdChanged_1148 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("stationId");
  decl->add_arg<QString > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_stationIdChanged_1148 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QString arg1 = gsi::arg_reader<QString >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioDataControl *)cls)->stationIdChanged (arg1);
}


// QString QRadioDataControl::stationName()


static void _init_f_stationName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_stationName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QRadioDataControl *)cls)->stationName ());
}


// void QRadioDataControl::stationNameChanged(QString stationName)


static void _init_f_stationNameChanged_1148 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("stationName");
  decl->add_arg<QString > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_stationNameChanged_1148 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QString arg1 = gsi::arg_reader<QString >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioDataControl *)cls)->stationNameChanged (arg1);
}


// static QString QRadioDataControl::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QRadioDataControl::tr (arg1, arg2, arg3));
}


// static QString QRadioDataControl::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QRadioDataControl::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QRadioDataControl () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("alternativeFrequenciesEnabledChanged", "@brief Method void QRadioDataControl::alternativeFrequenciesEnabledChanged(bool enabled)\n", false, &_init_f_alternativeFrequenciesEnabledChanged_864, &_call_f_alternativeFrequenciesEnabledChanged_864);
  methods += new qt_gsi::GenericMethod ("error", "@brief Method QRadioData::Error QRadioDataControl::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
  methods += new qt_gsi::GenericMethod ("error_sig", "@brief Method void QRadioDataControl::error(QRadioData::Error err)\n", false, &_init_f_error_2028, &_call_f_error_2028);
  methods += new qt_gsi::GenericMethod ("errorString", "@brief Method QString QRadioDataControl::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
  methods += new qt_gsi::GenericMethod ("isAlternativeFrequenciesEnabled?|:alternativeFrequenciesEnabled", "@brief Method bool QRadioDataControl::isAlternativeFrequenciesEnabled()\n", true, &_init_f_isAlternativeFrequenciesEnabled_c0, &_call_f_isAlternativeFrequenciesEnabled_c0);
  methods += new qt_gsi::GenericMethod ("programType", "@brief Method QRadioData::ProgramType QRadioDataControl::programType()\n", true, &_init_f_programType_c0, &_call_f_programType_c0);
  methods += new qt_gsi::GenericMethod ("programTypeChanged", "@brief Method void QRadioDataControl::programTypeChanged(QRadioData::ProgramType programType)\n", false, &_init_f_programTypeChanged_2652, &_call_f_programTypeChanged_2652);
  methods += new qt_gsi::GenericMethod ("programTypeName", "@brief Method QString QRadioDataControl::programTypeName()\n", true, &_init_f_programTypeName_c0, &_call_f_programTypeName_c0);
  methods += new qt_gsi::GenericMethod ("programTypeNameChanged", "@brief Method void QRadioDataControl::programTypeNameChanged(QString programTypeName)\n", false, &_init_f_programTypeNameChanged_1148, &_call_f_programTypeNameChanged_1148);
  methods += new qt_gsi::GenericMethod ("radioText", "@brief Method QString QRadioDataControl::radioText()\n", true, &_init_f_radioText_c0, &_call_f_radioText_c0);
  methods += new qt_gsi::GenericMethod ("radioTextChanged", "@brief Method void QRadioDataControl::radioTextChanged(QString radioText)\n", false, &_init_f_radioTextChanged_1148, &_call_f_radioTextChanged_1148);
  methods += new qt_gsi::GenericMethod ("setAlternativeFrequenciesEnabled|alternativeFrequenciesEnabled=", "@brief Method void QRadioDataControl::setAlternativeFrequenciesEnabled(bool enabled)\n", false, &_init_f_setAlternativeFrequenciesEnabled_864, &_call_f_setAlternativeFrequenciesEnabled_864);
  methods += new qt_gsi::GenericMethod ("stationId", "@brief Method QString QRadioDataControl::stationId()\n", true, &_init_f_stationId_c0, &_call_f_stationId_c0);
  methods += new qt_gsi::GenericMethod ("stationIdChanged", "@brief Method void QRadioDataControl::stationIdChanged(QString stationId)\n", false, &_init_f_stationIdChanged_1148, &_call_f_stationIdChanged_1148);
  methods += new qt_gsi::GenericMethod ("stationName", "@brief Method QString QRadioDataControl::stationName()\n", true, &_init_f_stationName_c0, &_call_f_stationName_c0);
  methods += new qt_gsi::GenericMethod ("stationNameChanged", "@brief Method void QRadioDataControl::stationNameChanged(QString stationName)\n", false, &_init_f_stationNameChanged_1148, &_call_f_stationNameChanged_1148);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QRadioDataControl::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QRadioDataControl::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QMediaControl> &qtdecl_QMediaControl ();

qt_gsi::QtNativeClass<QRadioDataControl> decl_QRadioDataControl (qtdecl_QMediaControl (), "QtMultimedia", "QRadioDataControl_Native",
  methods_QRadioDataControl (),
  "@hide\n@alias QRadioDataControl");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QRadioDataControl> &qtdecl_QRadioDataControl () { return decl_QRadioDataControl; }

}


class QRadioDataControl_Adaptor : public QRadioDataControl, public qt_gsi::QtObjectBase
{
public:

  virtual ~QRadioDataControl_Adaptor();

  //  [expose] bool QRadioDataControl::isSignalConnected(const QMetaMethod &signal)
  bool fp_QRadioDataControl_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QRadioDataControl::isSignalConnected(signal);
  }

  //  [expose] int QRadioDataControl::receivers(const char *signal)
  int fp_QRadioDataControl_receivers_c1731 (const char *signal) const {
    return QRadioDataControl::receivers(signal);
  }

  //  [expose] QObject *QRadioDataControl::sender()
  QObject * fp_QRadioDataControl_sender_c0 () const {
    return QRadioDataControl::sender();
  }

  //  [expose] int QRadioDataControl::senderSignalIndex()
  int fp_QRadioDataControl_senderSignalIndex_c0 () const {
    return QRadioDataControl::senderSignalIndex();
  }

  //  [adaptor impl] QRadioData::Error QRadioDataControl::error()
  qt_gsi::Converter<QRadioData::Error>::target_type cbs_error_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("error");
  }

  virtual QRadioData::Error error() const
  {
    if (cb_error_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QRadioData::Error>(cb_error_c0_0.issue<QRadioDataControl_Adaptor, qt_gsi::Converter<QRadioData::Error>::target_type>(&QRadioDataControl_Adaptor::cbs_error_c0_0)).cref();
    } else {
      throw qt_gsi::AbstractMethodCalledException("error");
    }
  }

  //  [adaptor impl] QString QRadioDataControl::errorString()
  QString cbs_errorString_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("errorString");
  }

  virtual QString errorString() const
  {
    if (cb_errorString_c0_0.can_issue()) {
      return cb_errorString_c0_0.issue<QRadioDataControl_Adaptor, QString>(&QRadioDataControl_Adaptor::cbs_errorString_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("errorString");
    }
  }

  //  [adaptor impl] bool QRadioDataControl::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QRadioDataControl::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QRadioDataControl_Adaptor, bool, QEvent *>(&QRadioDataControl_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QRadioDataControl::event(arg1);
    }
  }

  //  [adaptor impl] bool QRadioDataControl::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QRadioDataControl::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QRadioDataControl_Adaptor, bool, QObject *, QEvent *>(&QRadioDataControl_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QRadioDataControl::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] bool QRadioDataControl::isAlternativeFrequenciesEnabled()
  bool cbs_isAlternativeFrequenciesEnabled_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("isAlternativeFrequenciesEnabled");
  }

  virtual bool isAlternativeFrequenciesEnabled() const
  {
    if (cb_isAlternativeFrequenciesEnabled_c0_0.can_issue()) {
      return cb_isAlternativeFrequenciesEnabled_c0_0.issue<QRadioDataControl_Adaptor, bool>(&QRadioDataControl_Adaptor::cbs_isAlternativeFrequenciesEnabled_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("isAlternativeFrequenciesEnabled");
    }
  }

  //  [adaptor impl] QRadioData::ProgramType QRadioDataControl::programType()
  qt_gsi::Converter<QRadioData::ProgramType>::target_type cbs_programType_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("programType");
  }

  virtual QRadioData::ProgramType programType() const
  {
    if (cb_programType_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QRadioData::ProgramType>(cb_programType_c0_0.issue<QRadioDataControl_Adaptor, qt_gsi::Converter<QRadioData::ProgramType>::target_type>(&QRadioDataControl_Adaptor::cbs_programType_c0_0)).cref();
    } else {
      throw qt_gsi::AbstractMethodCalledException("programType");
    }
  }

  //  [adaptor impl] QString QRadioDataControl::programTypeName()
  QString cbs_programTypeName_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("programTypeName");
  }

  virtual QString programTypeName() const
  {
    if (cb_programTypeName_c0_0.can_issue()) {
      return cb_programTypeName_c0_0.issue<QRadioDataControl_Adaptor, QString>(&QRadioDataControl_Adaptor::cbs_programTypeName_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("programTypeName");
    }
  }

  //  [adaptor impl] QString QRadioDataControl::radioText()
  QString cbs_radioText_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("radioText");
  }

  virtual QString radioText() const
  {
    if (cb_radioText_c0_0.can_issue()) {
      return cb_radioText_c0_0.issue<QRadioDataControl_Adaptor, QString>(&QRadioDataControl_Adaptor::cbs_radioText_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("radioText");
    }
  }

  //  [adaptor impl] void QRadioDataControl::setAlternativeFrequenciesEnabled(bool enabled)
  void cbs_setAlternativeFrequenciesEnabled_864_0(bool enabled)
  {
    __SUPPRESS_UNUSED_WARNING (enabled);
    throw qt_gsi::AbstractMethodCalledException("setAlternativeFrequenciesEnabled");
  }

  virtual void setAlternativeFrequenciesEnabled(bool enabled)
  {
    if (cb_setAlternativeFrequenciesEnabled_864_0.can_issue()) {
      cb_setAlternativeFrequenciesEnabled_864_0.issue<QRadioDataControl_Adaptor, bool>(&QRadioDataControl_Adaptor::cbs_setAlternativeFrequenciesEnabled_864_0, enabled);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setAlternativeFrequenciesEnabled");
    }
  }

  //  [adaptor impl] QString QRadioDataControl::stationId()
  QString cbs_stationId_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("stationId");
  }

  virtual QString stationId() const
  {
    if (cb_stationId_c0_0.can_issue()) {
      return cb_stationId_c0_0.issue<QRadioDataControl_Adaptor, QString>(&QRadioDataControl_Adaptor::cbs_stationId_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("stationId");
    }
  }

  //  [adaptor impl] QString QRadioDataControl::stationName()
  QString cbs_stationName_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("stationName");
  }

  virtual QString stationName() const
  {
    if (cb_stationName_c0_0.can_issue()) {
      return cb_stationName_c0_0.issue<QRadioDataControl_Adaptor, QString>(&QRadioDataControl_Adaptor::cbs_stationName_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("stationName");
    }
  }

  //  [adaptor impl] void QRadioDataControl::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QRadioDataControl::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QRadioDataControl_Adaptor, QChildEvent *>(&QRadioDataControl_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QRadioDataControl::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QRadioDataControl::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QRadioDataControl::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QRadioDataControl_Adaptor, QEvent *>(&QRadioDataControl_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QRadioDataControl::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QRadioDataControl::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QRadioDataControl::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QRadioDataControl_Adaptor, const QMetaMethod &>(&QRadioDataControl_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QRadioDataControl::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QRadioDataControl::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QRadioDataControl::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QRadioDataControl_Adaptor, QTimerEvent *>(&QRadioDataControl_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QRadioDataControl::timerEvent(arg1);
    }
  }

  gsi::Callback cb_error_c0_0;
  gsi::Callback cb_errorString_c0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_isAlternativeFrequenciesEnabled_c0_0;
  gsi::Callback cb_programType_c0_0;
  gsi::Callback cb_programTypeName_c0_0;
  gsi::Callback cb_radioText_c0_0;
  gsi::Callback cb_setAlternativeFrequenciesEnabled_864_0;
  gsi::Callback cb_stationId_c0_0;
  gsi::Callback cb_stationName_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QRadioDataControl_Adaptor::~QRadioDataControl_Adaptor() { }

// void QRadioDataControl::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioDataControl_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioDataControl_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QRadioDataControl::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioDataControl_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioDataControl_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// void QRadioDataControl::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioDataControl_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioDataControl_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// QRadioData::Error QRadioDataControl::error()

static void _init_cbs_error_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QRadioData::Error>::target_type > ();
}

static void _call_cbs_error_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QRadioData::Error>::target_type > ((qt_gsi::Converter<QRadioData::Error>::target_type)((QRadioDataControl_Adaptor *)cls)->cbs_error_c0_0 ());
}

static void _set_callback_cbs_error_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioDataControl_Adaptor *)cls)->cb_error_c0_0 = cb;
}


// QString QRadioDataControl::errorString()

static void _init_cbs_errorString_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_cbs_errorString_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QRadioDataControl_Adaptor *)cls)->cbs_errorString_c0_0 ());
}

static void _set_callback_cbs_errorString_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioDataControl_Adaptor *)cls)->cb_errorString_c0_0 = cb;
}


// bool QRadioDataControl::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QRadioDataControl_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioDataControl_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QRadioDataControl::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QRadioDataControl_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioDataControl_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// bool QRadioDataControl::isAlternativeFrequenciesEnabled()

static void _init_cbs_isAlternativeFrequenciesEnabled_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isAlternativeFrequenciesEnabled_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QRadioDataControl_Adaptor *)cls)->cbs_isAlternativeFrequenciesEnabled_c0_0 ());
}

static void _set_callback_cbs_isAlternativeFrequenciesEnabled_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioDataControl_Adaptor *)cls)->cb_isAlternativeFrequenciesEnabled_c0_0 = cb;
}


// exposed bool QRadioDataControl::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QRadioDataControl_Adaptor *)cls)->fp_QRadioDataControl_isSignalConnected_c2394 (arg1));
}


// QRadioData::ProgramType QRadioDataControl::programType()

static void _init_cbs_programType_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QRadioData::ProgramType>::target_type > ();
}

static void _call_cbs_programType_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QRadioData::ProgramType>::target_type > ((qt_gsi::Converter<QRadioData::ProgramType>::target_type)((QRadioDataControl_Adaptor *)cls)->cbs_programType_c0_0 ());
}

static void _set_callback_cbs_programType_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioDataControl_Adaptor *)cls)->cb_programType_c0_0 = cb;
}


// QString QRadioDataControl::programTypeName()

static void _init_cbs_programTypeName_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_cbs_programTypeName_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QRadioDataControl_Adaptor *)cls)->cbs_programTypeName_c0_0 ());
}

static void _set_callback_cbs_programTypeName_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioDataControl_Adaptor *)cls)->cb_programTypeName_c0_0 = cb;
}


// QString QRadioDataControl::radioText()

static void _init_cbs_radioText_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_cbs_radioText_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QRadioDataControl_Adaptor *)cls)->cbs_radioText_c0_0 ());
}

static void _set_callback_cbs_radioText_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioDataControl_Adaptor *)cls)->cb_radioText_c0_0 = cb;
}


// exposed int QRadioDataControl::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QRadioDataControl_Adaptor *)cls)->fp_QRadioDataControl_receivers_c1731 (arg1));
}


// exposed QObject *QRadioDataControl::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QRadioDataControl_Adaptor *)cls)->fp_QRadioDataControl_sender_c0 ());
}


// exposed int QRadioDataControl::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QRadioDataControl_Adaptor *)cls)->fp_QRadioDataControl_senderSignalIndex_c0 ());
}


// void QRadioDataControl::setAlternativeFrequenciesEnabled(bool enabled)

static void _init_cbs_setAlternativeFrequenciesEnabled_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setAlternativeFrequenciesEnabled_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioDataControl_Adaptor *)cls)->cbs_setAlternativeFrequenciesEnabled_864_0 (arg1);
}

static void _set_callback_cbs_setAlternativeFrequenciesEnabled_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioDataControl_Adaptor *)cls)->cb_setAlternativeFrequenciesEnabled_864_0 = cb;
}


// QString QRadioDataControl::stationId()

static void _init_cbs_stationId_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_cbs_stationId_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QRadioDataControl_Adaptor *)cls)->cbs_stationId_c0_0 ());
}

static void _set_callback_cbs_stationId_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioDataControl_Adaptor *)cls)->cb_stationId_c0_0 = cb;
}


// QString QRadioDataControl::stationName()

static void _init_cbs_stationName_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_cbs_stationName_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QRadioDataControl_Adaptor *)cls)->cbs_stationName_c0_0 ());
}

static void _set_callback_cbs_stationName_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioDataControl_Adaptor *)cls)->cb_stationName_c0_0 = cb;
}


// void QRadioDataControl::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioDataControl_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioDataControl_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QRadioDataControl> &qtdecl_QRadioDataControl ();

static gsi::Methods methods_QRadioDataControl_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QRadioDataControl::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QRadioDataControl::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QRadioDataControl::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("error", "@brief Virtual method QRadioData::Error QRadioDataControl::error()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_error_c0_0, &_call_cbs_error_c0_0);
  methods += new qt_gsi::GenericMethod ("error", "@hide", true, &_init_cbs_error_c0_0, &_call_cbs_error_c0_0, &_set_callback_cbs_error_c0_0);
  methods += new qt_gsi::GenericMethod ("errorString", "@brief Virtual method QString QRadioDataControl::errorString()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_errorString_c0_0, &_call_cbs_errorString_c0_0);
  methods += new qt_gsi::GenericMethod ("errorString", "@hide", true, &_init_cbs_errorString_c0_0, &_call_cbs_errorString_c0_0, &_set_callback_cbs_errorString_c0_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QRadioDataControl::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QRadioDataControl::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("isAlternativeFrequenciesEnabled", "@brief Virtual method bool QRadioDataControl::isAlternativeFrequenciesEnabled()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isAlternativeFrequenciesEnabled_c0_0, &_call_cbs_isAlternativeFrequenciesEnabled_c0_0);
  methods += new qt_gsi::GenericMethod ("isAlternativeFrequenciesEnabled", "@hide", true, &_init_cbs_isAlternativeFrequenciesEnabled_c0_0, &_call_cbs_isAlternativeFrequenciesEnabled_c0_0, &_set_callback_cbs_isAlternativeFrequenciesEnabled_c0_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QRadioDataControl::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("programType", "@brief Virtual method QRadioData::ProgramType QRadioDataControl::programType()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_programType_c0_0, &_call_cbs_programType_c0_0);
  methods += new qt_gsi::GenericMethod ("programType", "@hide", true, &_init_cbs_programType_c0_0, &_call_cbs_programType_c0_0, &_set_callback_cbs_programType_c0_0);
  methods += new qt_gsi::GenericMethod ("programTypeName", "@brief Virtual method QString QRadioDataControl::programTypeName()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_programTypeName_c0_0, &_call_cbs_programTypeName_c0_0);
  methods += new qt_gsi::GenericMethod ("programTypeName", "@hide", true, &_init_cbs_programTypeName_c0_0, &_call_cbs_programTypeName_c0_0, &_set_callback_cbs_programTypeName_c0_0);
  methods += new qt_gsi::GenericMethod ("radioText", "@brief Virtual method QString QRadioDataControl::radioText()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_radioText_c0_0, &_call_cbs_radioText_c0_0);
  methods += new qt_gsi::GenericMethod ("radioText", "@hide", true, &_init_cbs_radioText_c0_0, &_call_cbs_radioText_c0_0, &_set_callback_cbs_radioText_c0_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QRadioDataControl::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QRadioDataControl::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QRadioDataControl::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setAlternativeFrequenciesEnabled", "@brief Virtual method void QRadioDataControl::setAlternativeFrequenciesEnabled(bool enabled)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setAlternativeFrequenciesEnabled_864_0, &_call_cbs_setAlternativeFrequenciesEnabled_864_0);
  methods += new qt_gsi::GenericMethod ("setAlternativeFrequenciesEnabled", "@hide", false, &_init_cbs_setAlternativeFrequenciesEnabled_864_0, &_call_cbs_setAlternativeFrequenciesEnabled_864_0, &_set_callback_cbs_setAlternativeFrequenciesEnabled_864_0);
  methods += new qt_gsi::GenericMethod ("stationId", "@brief Virtual method QString QRadioDataControl::stationId()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_stationId_c0_0, &_call_cbs_stationId_c0_0);
  methods += new qt_gsi::GenericMethod ("stationId", "@hide", true, &_init_cbs_stationId_c0_0, &_call_cbs_stationId_c0_0, &_set_callback_cbs_stationId_c0_0);
  methods += new qt_gsi::GenericMethod ("stationName", "@brief Virtual method QString QRadioDataControl::stationName()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_stationName_c0_0, &_call_cbs_stationName_c0_0);
  methods += new qt_gsi::GenericMethod ("stationName", "@hide", true, &_init_cbs_stationName_c0_0, &_call_cbs_stationName_c0_0, &_set_callback_cbs_stationName_c0_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QRadioDataControl::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QRadioDataControl_Adaptor> decl_QRadioDataControl_Adaptor (qtdecl_QRadioDataControl (), "QtMultimedia", "QRadioDataControl",
  methods_QRadioDataControl_Adaptor (),
  "@qt\n@brief Binding of QRadioDataControl");

}

