
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2021 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQRadioTunerControl.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QRadioTunerControl>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include "gsiDeclQtMultimediaTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QRadioTunerControl

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QRadioTunerControl::staticMetaObject);
}


// void QRadioTunerControl::antennaConnectedChanged(bool connectionStatus)


static void _init_f_antennaConnectedChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("connectionStatus");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_antennaConnectedChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl *)cls)->antennaConnectedChanged (arg1);
}


// QRadioTuner::Band QRadioTunerControl::band()


static void _init_f_band_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QRadioTuner::Band>::target_type > ();
}

static void _call_f_band_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QRadioTuner::Band>::target_type > ((qt_gsi::Converter<QRadioTuner::Band>::target_type)qt_gsi::CppToQtAdaptor<QRadioTuner::Band>(((QRadioTunerControl *)cls)->band ()));
}


// void QRadioTunerControl::bandChanged(QRadioTuner::Band band)


static void _init_f_bandChanged_2027 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("band");
  decl->add_arg<const qt_gsi::Converter<QRadioTuner::Band>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_bandChanged_2027 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QRadioTuner::Band>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QRadioTuner::Band>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl *)cls)->bandChanged (qt_gsi::QtToCppAdaptor<QRadioTuner::Band>(arg1).cref());
}


// void QRadioTunerControl::cancelSearch()


static void _init_f_cancelSearch_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_cancelSearch_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl *)cls)->cancelSearch ();
}


// QRadioTuner::Error QRadioTunerControl::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QRadioTuner::Error>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QRadioTuner::Error>::target_type > ((qt_gsi::Converter<QRadioTuner::Error>::target_type)qt_gsi::CppToQtAdaptor<QRadioTuner::Error>(((QRadioTunerControl *)cls)->error ()));
}


// void QRadioTunerControl::error(QRadioTuner::Error err)


static void _init_f_error_2176 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("err");
  decl->add_arg<const qt_gsi::Converter<QRadioTuner::Error>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_error_2176 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QRadioTuner::Error>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QRadioTuner::Error>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl *)cls)->error (qt_gsi::QtToCppAdaptor<QRadioTuner::Error>(arg1).cref());
}


// QString QRadioTunerControl::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QRadioTunerControl *)cls)->errorString ());
}


// int QRadioTunerControl::frequency()


static void _init_f_frequency_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_frequency_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QRadioTunerControl *)cls)->frequency ());
}


// void QRadioTunerControl::frequencyChanged(int frequency)


static void _init_f_frequencyChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("frequency");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_frequencyChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl *)cls)->frequencyChanged (arg1);
}


// QPair<int, int> QRadioTunerControl::frequencyRange(QRadioTuner::Band b)


static void _init_f_frequencyRange_c2027 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<const qt_gsi::Converter<QRadioTuner::Band>::target_type & > (argspec_0);
  decl->set_return<QPair<int, int> > ();
}

static void _call_f_frequencyRange_c2027 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QRadioTuner::Band>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QRadioTuner::Band>::target_type & >() (args, heap);
  ret.write<QPair<int, int> > ((QPair<int, int>)((QRadioTunerControl *)cls)->frequencyRange (qt_gsi::QtToCppAdaptor<QRadioTuner::Band>(arg1).cref()));
}


// int QRadioTunerControl::frequencyStep(QRadioTuner::Band b)


static void _init_f_frequencyStep_c2027 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<const qt_gsi::Converter<QRadioTuner::Band>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_frequencyStep_c2027 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QRadioTuner::Band>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QRadioTuner::Band>::target_type & >() (args, heap);
  ret.write<int > ((int)((QRadioTunerControl *)cls)->frequencyStep (qt_gsi::QtToCppAdaptor<QRadioTuner::Band>(arg1).cref()));
}


// bool QRadioTunerControl::isAntennaConnected()


static void _init_f_isAntennaConnected_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isAntennaConnected_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QRadioTunerControl *)cls)->isAntennaConnected ());
}


// bool QRadioTunerControl::isBandSupported(QRadioTuner::Band b)


static void _init_f_isBandSupported_c2027 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<const qt_gsi::Converter<QRadioTuner::Band>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isBandSupported_c2027 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QRadioTuner::Band>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QRadioTuner::Band>::target_type & >() (args, heap);
  ret.write<bool > ((bool)((QRadioTunerControl *)cls)->isBandSupported (qt_gsi::QtToCppAdaptor<QRadioTuner::Band>(arg1).cref()));
}


// bool QRadioTunerControl::isMuted()


static void _init_f_isMuted_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isMuted_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QRadioTunerControl *)cls)->isMuted ());
}


// bool QRadioTunerControl::isSearching()


static void _init_f_isSearching_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSearching_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QRadioTunerControl *)cls)->isSearching ());
}


// bool QRadioTunerControl::isStereo()


static void _init_f_isStereo_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isStereo_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QRadioTunerControl *)cls)->isStereo ());
}


// void QRadioTunerControl::mutedChanged(bool muted)


static void _init_f_mutedChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("muted");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_mutedChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl *)cls)->mutedChanged (arg1);
}


// void QRadioTunerControl::searchAllStations(QRadioTuner::SearchMode searchMode)


static void _init_f_searchAllStations_2641 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("searchMode", true, "QRadioTuner::SearchFast");
  decl->add_arg<const qt_gsi::Converter<QRadioTuner::SearchMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_searchAllStations_2641 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QRadioTuner::SearchMode>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<QRadioTuner::SearchMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QRadioTuner::SearchMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QRadioTuner::SearchMode>(heap, QRadioTuner::SearchFast), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl *)cls)->searchAllStations (qt_gsi::QtToCppAdaptor<QRadioTuner::SearchMode>(arg1).cref());
}


// void QRadioTunerControl::searchBackward()


static void _init_f_searchBackward_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_searchBackward_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl *)cls)->searchBackward ();
}


// void QRadioTunerControl::searchForward()


static void _init_f_searchForward_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_searchForward_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl *)cls)->searchForward ();
}


// void QRadioTunerControl::searchingChanged(bool searching)


static void _init_f_searchingChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("searching");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_searchingChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl *)cls)->searchingChanged (arg1);
}


// void QRadioTunerControl::setBand(QRadioTuner::Band b)


static void _init_f_setBand_2027 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<const qt_gsi::Converter<QRadioTuner::Band>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBand_2027 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QRadioTuner::Band>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QRadioTuner::Band>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl *)cls)->setBand (qt_gsi::QtToCppAdaptor<QRadioTuner::Band>(arg1).cref());
}


// void QRadioTunerControl::setFrequency(int frequency)


static void _init_f_setFrequency_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("frequency");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFrequency_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl *)cls)->setFrequency (arg1);
}


// void QRadioTunerControl::setMuted(bool muted)


static void _init_f_setMuted_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("muted");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMuted_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl *)cls)->setMuted (arg1);
}


// void QRadioTunerControl::setStereoMode(QRadioTuner::StereoMode mode)


static void _init_f_setStereoMode_2669 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QRadioTuner::StereoMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStereoMode_2669 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QRadioTuner::StereoMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QRadioTuner::StereoMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl *)cls)->setStereoMode (qt_gsi::QtToCppAdaptor<QRadioTuner::StereoMode>(arg1).cref());
}


// void QRadioTunerControl::setVolume(int volume)


static void _init_f_setVolume_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("volume");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVolume_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl *)cls)->setVolume (arg1);
}


// int QRadioTunerControl::signalStrength()


static void _init_f_signalStrength_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_signalStrength_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QRadioTunerControl *)cls)->signalStrength ());
}


// void QRadioTunerControl::signalStrengthChanged(int signalStrength)


static void _init_f_signalStrengthChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signalStrength");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_signalStrengthChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl *)cls)->signalStrengthChanged (arg1);
}


// void QRadioTunerControl::start()


static void _init_f_start_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_start_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl *)cls)->start ();
}


// QRadioTuner::State QRadioTunerControl::state()


static void _init_f_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QRadioTuner::State>::target_type > ();
}

static void _call_f_state_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QRadioTuner::State>::target_type > ((qt_gsi::Converter<QRadioTuner::State>::target_type)qt_gsi::CppToQtAdaptor<QRadioTuner::State>(((QRadioTunerControl *)cls)->state ()));
}


// void QRadioTunerControl::stateChanged(QRadioTuner::State state)


static void _init_f_stateChanged_2167 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<const qt_gsi::Converter<QRadioTuner::State>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_stateChanged_2167 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QRadioTuner::State>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QRadioTuner::State>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl *)cls)->stateChanged (qt_gsi::QtToCppAdaptor<QRadioTuner::State>(arg1).cref());
}


// void QRadioTunerControl::stationFound(int frequency, QString stationId)


static void _init_f_stationFound_1807 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("frequency");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("stationId");
  decl->add_arg<QString > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_stationFound_1807 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  QString arg2 = gsi::arg_reader<QString >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl *)cls)->stationFound (arg1, arg2);
}


// QRadioTuner::StereoMode QRadioTunerControl::stereoMode()


static void _init_f_stereoMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QRadioTuner::StereoMode>::target_type > ();
}

static void _call_f_stereoMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QRadioTuner::StereoMode>::target_type > ((qt_gsi::Converter<QRadioTuner::StereoMode>::target_type)qt_gsi::CppToQtAdaptor<QRadioTuner::StereoMode>(((QRadioTunerControl *)cls)->stereoMode ()));
}


// void QRadioTunerControl::stereoStatusChanged(bool stereo)


static void _init_f_stereoStatusChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("stereo");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_stereoStatusChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl *)cls)->stereoStatusChanged (arg1);
}


// void QRadioTunerControl::stop()


static void _init_f_stop_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_stop_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl *)cls)->stop ();
}


// int QRadioTunerControl::volume()


static void _init_f_volume_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_volume_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QRadioTunerControl *)cls)->volume ());
}


// void QRadioTunerControl::volumeChanged(int volume)


static void _init_f_volumeChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("volume");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_volumeChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl *)cls)->volumeChanged (arg1);
}


// static QString QRadioTunerControl::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QRadioTunerControl::tr (arg1, arg2, arg3));
}


// static QString QRadioTunerControl::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QRadioTunerControl::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QRadioTunerControl () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("antennaConnectedChanged", "@brief Method void QRadioTunerControl::antennaConnectedChanged(bool connectionStatus)\n", false, &_init_f_antennaConnectedChanged_864, &_call_f_antennaConnectedChanged_864);
  methods += new qt_gsi::GenericMethod (":band", "@brief Method QRadioTuner::Band QRadioTunerControl::band()\n", true, &_init_f_band_c0, &_call_f_band_c0);
  methods += new qt_gsi::GenericMethod ("bandChanged", "@brief Method void QRadioTunerControl::bandChanged(QRadioTuner::Band band)\n", false, &_init_f_bandChanged_2027, &_call_f_bandChanged_2027);
  methods += new qt_gsi::GenericMethod ("cancelSearch", "@brief Method void QRadioTunerControl::cancelSearch()\n", false, &_init_f_cancelSearch_0, &_call_f_cancelSearch_0);
  methods += new qt_gsi::GenericMethod ("error", "@brief Method QRadioTuner::Error QRadioTunerControl::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
  methods += new qt_gsi::GenericMethod ("error_sig", "@brief Method void QRadioTunerControl::error(QRadioTuner::Error err)\n", false, &_init_f_error_2176, &_call_f_error_2176);
  methods += new qt_gsi::GenericMethod ("errorString", "@brief Method QString QRadioTunerControl::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
  methods += new qt_gsi::GenericMethod (":frequency", "@brief Method int QRadioTunerControl::frequency()\n", true, &_init_f_frequency_c0, &_call_f_frequency_c0);
  methods += new qt_gsi::GenericMethod ("frequencyChanged", "@brief Method void QRadioTunerControl::frequencyChanged(int frequency)\n", false, &_init_f_frequencyChanged_767, &_call_f_frequencyChanged_767);
  methods += new qt_gsi::GenericMethod ("frequencyRange", "@brief Method QPair<int, int> QRadioTunerControl::frequencyRange(QRadioTuner::Band b)\n", true, &_init_f_frequencyRange_c2027, &_call_f_frequencyRange_c2027);
  methods += new qt_gsi::GenericMethod ("frequencyStep", "@brief Method int QRadioTunerControl::frequencyStep(QRadioTuner::Band b)\n", true, &_init_f_frequencyStep_c2027, &_call_f_frequencyStep_c2027);
  methods += new qt_gsi::GenericMethod ("isAntennaConnected?", "@brief Method bool QRadioTunerControl::isAntennaConnected()\n", true, &_init_f_isAntennaConnected_c0, &_call_f_isAntennaConnected_c0);
  methods += new qt_gsi::GenericMethod ("isBandSupported?", "@brief Method bool QRadioTunerControl::isBandSupported(QRadioTuner::Band b)\n", true, &_init_f_isBandSupported_c2027, &_call_f_isBandSupported_c2027);
  methods += new qt_gsi::GenericMethod ("isMuted?|:muted", "@brief Method bool QRadioTunerControl::isMuted()\n", true, &_init_f_isMuted_c0, &_call_f_isMuted_c0);
  methods += new qt_gsi::GenericMethod ("isSearching?", "@brief Method bool QRadioTunerControl::isSearching()\n", true, &_init_f_isSearching_c0, &_call_f_isSearching_c0);
  methods += new qt_gsi::GenericMethod ("isStereo?", "@brief Method bool QRadioTunerControl::isStereo()\n", true, &_init_f_isStereo_c0, &_call_f_isStereo_c0);
  methods += new qt_gsi::GenericMethod ("mutedChanged", "@brief Method void QRadioTunerControl::mutedChanged(bool muted)\n", false, &_init_f_mutedChanged_864, &_call_f_mutedChanged_864);
  methods += new qt_gsi::GenericMethod ("searchAllStations", "@brief Method void QRadioTunerControl::searchAllStations(QRadioTuner::SearchMode searchMode)\n", false, &_init_f_searchAllStations_2641, &_call_f_searchAllStations_2641);
  methods += new qt_gsi::GenericMethod ("searchBackward", "@brief Method void QRadioTunerControl::searchBackward()\n", false, &_init_f_searchBackward_0, &_call_f_searchBackward_0);
  methods += new qt_gsi::GenericMethod ("searchForward", "@brief Method void QRadioTunerControl::searchForward()\n", false, &_init_f_searchForward_0, &_call_f_searchForward_0);
  methods += new qt_gsi::GenericMethod ("searchingChanged", "@brief Method void QRadioTunerControl::searchingChanged(bool searching)\n", false, &_init_f_searchingChanged_864, &_call_f_searchingChanged_864);
  methods += new qt_gsi::GenericMethod ("setBand|band=", "@brief Method void QRadioTunerControl::setBand(QRadioTuner::Band b)\n", false, &_init_f_setBand_2027, &_call_f_setBand_2027);
  methods += new qt_gsi::GenericMethod ("setFrequency|frequency=", "@brief Method void QRadioTunerControl::setFrequency(int frequency)\n", false, &_init_f_setFrequency_767, &_call_f_setFrequency_767);
  methods += new qt_gsi::GenericMethod ("setMuted|muted=", "@brief Method void QRadioTunerControl::setMuted(bool muted)\n", false, &_init_f_setMuted_864, &_call_f_setMuted_864);
  methods += new qt_gsi::GenericMethod ("setStereoMode|stereoMode=", "@brief Method void QRadioTunerControl::setStereoMode(QRadioTuner::StereoMode mode)\n", false, &_init_f_setStereoMode_2669, &_call_f_setStereoMode_2669);
  methods += new qt_gsi::GenericMethod ("setVolume|volume=", "@brief Method void QRadioTunerControl::setVolume(int volume)\n", false, &_init_f_setVolume_767, &_call_f_setVolume_767);
  methods += new qt_gsi::GenericMethod ("signalStrength", "@brief Method int QRadioTunerControl::signalStrength()\n", true, &_init_f_signalStrength_c0, &_call_f_signalStrength_c0);
  methods += new qt_gsi::GenericMethod ("signalStrengthChanged", "@brief Method void QRadioTunerControl::signalStrengthChanged(int signalStrength)\n", false, &_init_f_signalStrengthChanged_767, &_call_f_signalStrengthChanged_767);
  methods += new qt_gsi::GenericMethod ("start", "@brief Method void QRadioTunerControl::start()\n", false, &_init_f_start_0, &_call_f_start_0);
  methods += new qt_gsi::GenericMethod ("state", "@brief Method QRadioTuner::State QRadioTunerControl::state()\n", true, &_init_f_state_c0, &_call_f_state_c0);
  methods += new qt_gsi::GenericMethod ("stateChanged", "@brief Method void QRadioTunerControl::stateChanged(QRadioTuner::State state)\n", false, &_init_f_stateChanged_2167, &_call_f_stateChanged_2167);
  methods += new qt_gsi::GenericMethod ("stationFound", "@brief Method void QRadioTunerControl::stationFound(int frequency, QString stationId)\n", false, &_init_f_stationFound_1807, &_call_f_stationFound_1807);
  methods += new qt_gsi::GenericMethod (":stereoMode", "@brief Method QRadioTuner::StereoMode QRadioTunerControl::stereoMode()\n", true, &_init_f_stereoMode_c0, &_call_f_stereoMode_c0);
  methods += new qt_gsi::GenericMethod ("stereoStatusChanged", "@brief Method void QRadioTunerControl::stereoStatusChanged(bool stereo)\n", false, &_init_f_stereoStatusChanged_864, &_call_f_stereoStatusChanged_864);
  methods += new qt_gsi::GenericMethod ("stop", "@brief Method void QRadioTunerControl::stop()\n", false, &_init_f_stop_0, &_call_f_stop_0);
  methods += new qt_gsi::GenericMethod (":volume", "@brief Method int QRadioTunerControl::volume()\n", true, &_init_f_volume_c0, &_call_f_volume_c0);
  methods += new qt_gsi::GenericMethod ("volumeChanged", "@brief Method void QRadioTunerControl::volumeChanged(int volume)\n", false, &_init_f_volumeChanged_767, &_call_f_volumeChanged_767);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QRadioTunerControl::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QRadioTunerControl::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QMediaControl> &qtdecl_QMediaControl ();

qt_gsi::QtNativeClass<QRadioTunerControl> decl_QRadioTunerControl (qtdecl_QMediaControl (), "QtMultimedia", "QRadioTunerControl_Native",
  methods_QRadioTunerControl (),
  "@hide\n@alias QRadioTunerControl");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QRadioTunerControl> &qtdecl_QRadioTunerControl () { return decl_QRadioTunerControl; }

}


class QRadioTunerControl_Adaptor : public QRadioTunerControl, public qt_gsi::QtObjectBase
{
public:

  virtual ~QRadioTunerControl_Adaptor();

  //  [expose] bool QRadioTunerControl::isSignalConnected(const QMetaMethod &signal)
  bool fp_QRadioTunerControl_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QRadioTunerControl::isSignalConnected(signal);
  }

  //  [expose] int QRadioTunerControl::receivers(const char *signal)
  int fp_QRadioTunerControl_receivers_c1731 (const char *signal) const {
    return QRadioTunerControl::receivers(signal);
  }

  //  [expose] QObject *QRadioTunerControl::sender()
  QObject * fp_QRadioTunerControl_sender_c0 () const {
    return QRadioTunerControl::sender();
  }

  //  [expose] int QRadioTunerControl::senderSignalIndex()
  int fp_QRadioTunerControl_senderSignalIndex_c0 () const {
    return QRadioTunerControl::senderSignalIndex();
  }

  //  [adaptor impl] QRadioTuner::Band QRadioTunerControl::band()
  qt_gsi::Converter<QRadioTuner::Band>::target_type cbs_band_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("band");
  }

  virtual QRadioTuner::Band band() const
  {
    if (cb_band_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QRadioTuner::Band>(cb_band_c0_0.issue<QRadioTunerControl_Adaptor, qt_gsi::Converter<QRadioTuner::Band>::target_type>(&QRadioTunerControl_Adaptor::cbs_band_c0_0)).cref();
    } else {
      throw qt_gsi::AbstractMethodCalledException("band");
    }
  }

  //  [adaptor impl] void QRadioTunerControl::cancelSearch()
  void cbs_cancelSearch_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("cancelSearch");
  }

  virtual void cancelSearch()
  {
    if (cb_cancelSearch_0_0.can_issue()) {
      cb_cancelSearch_0_0.issue<QRadioTunerControl_Adaptor>(&QRadioTunerControl_Adaptor::cbs_cancelSearch_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("cancelSearch");
    }
  }

  //  [adaptor impl] QRadioTuner::Error QRadioTunerControl::error()
  qt_gsi::Converter<QRadioTuner::Error>::target_type cbs_error_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("error");
  }

  virtual QRadioTuner::Error error() const
  {
    if (cb_error_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QRadioTuner::Error>(cb_error_c0_0.issue<QRadioTunerControl_Adaptor, qt_gsi::Converter<QRadioTuner::Error>::target_type>(&QRadioTunerControl_Adaptor::cbs_error_c0_0)).cref();
    } else {
      throw qt_gsi::AbstractMethodCalledException("error");
    }
  }

  //  [adaptor impl] QString QRadioTunerControl::errorString()
  QString cbs_errorString_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("errorString");
  }

  virtual QString errorString() const
  {
    if (cb_errorString_c0_0.can_issue()) {
      return cb_errorString_c0_0.issue<QRadioTunerControl_Adaptor, QString>(&QRadioTunerControl_Adaptor::cbs_errorString_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("errorString");
    }
  }

  //  [adaptor impl] bool QRadioTunerControl::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QRadioTunerControl::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QRadioTunerControl_Adaptor, bool, QEvent *>(&QRadioTunerControl_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QRadioTunerControl::event(arg1);
    }
  }

  //  [adaptor impl] bool QRadioTunerControl::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QRadioTunerControl::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QRadioTunerControl_Adaptor, bool, QObject *, QEvent *>(&QRadioTunerControl_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QRadioTunerControl::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] int QRadioTunerControl::frequency()
  int cbs_frequency_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("frequency");
  }

  virtual int frequency() const
  {
    if (cb_frequency_c0_0.can_issue()) {
      return cb_frequency_c0_0.issue<QRadioTunerControl_Adaptor, int>(&QRadioTunerControl_Adaptor::cbs_frequency_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("frequency");
    }
  }

  //  [adaptor impl] QPair<int, int> QRadioTunerControl::frequencyRange(QRadioTuner::Band b)
  QPair<int, int> cbs_frequencyRange_c2027_0(const qt_gsi::Converter<QRadioTuner::Band>::target_type & b) const
  {
    __SUPPRESS_UNUSED_WARNING (b);
    throw qt_gsi::AbstractMethodCalledException("frequencyRange");
  }

  virtual QPair<int, int> frequencyRange(QRadioTuner::Band b) const
  {
    if (cb_frequencyRange_c2027_0.can_issue()) {
      return cb_frequencyRange_c2027_0.issue<QRadioTunerControl_Adaptor, QPair<int, int>, const qt_gsi::Converter<QRadioTuner::Band>::target_type &>(&QRadioTunerControl_Adaptor::cbs_frequencyRange_c2027_0, qt_gsi::CppToQtAdaptor<QRadioTuner::Band>(b));
    } else {
      throw qt_gsi::AbstractMethodCalledException("frequencyRange");
    }
  }

  //  [adaptor impl] int QRadioTunerControl::frequencyStep(QRadioTuner::Band b)
  int cbs_frequencyStep_c2027_0(const qt_gsi::Converter<QRadioTuner::Band>::target_type & b) const
  {
    __SUPPRESS_UNUSED_WARNING (b);
    throw qt_gsi::AbstractMethodCalledException("frequencyStep");
  }

  virtual int frequencyStep(QRadioTuner::Band b) const
  {
    if (cb_frequencyStep_c2027_0.can_issue()) {
      return cb_frequencyStep_c2027_0.issue<QRadioTunerControl_Adaptor, int, const qt_gsi::Converter<QRadioTuner::Band>::target_type &>(&QRadioTunerControl_Adaptor::cbs_frequencyStep_c2027_0, qt_gsi::CppToQtAdaptor<QRadioTuner::Band>(b));
    } else {
      throw qt_gsi::AbstractMethodCalledException("frequencyStep");
    }
  }

  //  [adaptor impl] bool QRadioTunerControl::isAntennaConnected()
  bool cbs_isAntennaConnected_c0_0() const
  {
    return QRadioTunerControl::isAntennaConnected();
  }

  virtual bool isAntennaConnected() const
  {
    if (cb_isAntennaConnected_c0_0.can_issue()) {
      return cb_isAntennaConnected_c0_0.issue<QRadioTunerControl_Adaptor, bool>(&QRadioTunerControl_Adaptor::cbs_isAntennaConnected_c0_0);
    } else {
      return QRadioTunerControl::isAntennaConnected();
    }
  }

  //  [adaptor impl] bool QRadioTunerControl::isBandSupported(QRadioTuner::Band b)
  bool cbs_isBandSupported_c2027_0(const qt_gsi::Converter<QRadioTuner::Band>::target_type & b) const
  {
    __SUPPRESS_UNUSED_WARNING (b);
    throw qt_gsi::AbstractMethodCalledException("isBandSupported");
  }

  virtual bool isBandSupported(QRadioTuner::Band b) const
  {
    if (cb_isBandSupported_c2027_0.can_issue()) {
      return cb_isBandSupported_c2027_0.issue<QRadioTunerControl_Adaptor, bool, const qt_gsi::Converter<QRadioTuner::Band>::target_type &>(&QRadioTunerControl_Adaptor::cbs_isBandSupported_c2027_0, qt_gsi::CppToQtAdaptor<QRadioTuner::Band>(b));
    } else {
      throw qt_gsi::AbstractMethodCalledException("isBandSupported");
    }
  }

  //  [adaptor impl] bool QRadioTunerControl::isMuted()
  bool cbs_isMuted_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("isMuted");
  }

  virtual bool isMuted() const
  {
    if (cb_isMuted_c0_0.can_issue()) {
      return cb_isMuted_c0_0.issue<QRadioTunerControl_Adaptor, bool>(&QRadioTunerControl_Adaptor::cbs_isMuted_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("isMuted");
    }
  }

  //  [adaptor impl] bool QRadioTunerControl::isSearching()
  bool cbs_isSearching_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("isSearching");
  }

  virtual bool isSearching() const
  {
    if (cb_isSearching_c0_0.can_issue()) {
      return cb_isSearching_c0_0.issue<QRadioTunerControl_Adaptor, bool>(&QRadioTunerControl_Adaptor::cbs_isSearching_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("isSearching");
    }
  }

  //  [adaptor impl] bool QRadioTunerControl::isStereo()
  bool cbs_isStereo_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("isStereo");
  }

  virtual bool isStereo() const
  {
    if (cb_isStereo_c0_0.can_issue()) {
      return cb_isStereo_c0_0.issue<QRadioTunerControl_Adaptor, bool>(&QRadioTunerControl_Adaptor::cbs_isStereo_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("isStereo");
    }
  }

  //  [adaptor impl] void QRadioTunerControl::searchAllStations(QRadioTuner::SearchMode searchMode)
  void cbs_searchAllStations_2641_1(const qt_gsi::Converter<QRadioTuner::SearchMode>::target_type & searchMode)
  {
    __SUPPRESS_UNUSED_WARNING (searchMode);
    throw qt_gsi::AbstractMethodCalledException("searchAllStations");
  }

  virtual void searchAllStations(QRadioTuner::SearchMode searchMode)
  {
    if (cb_searchAllStations_2641_1.can_issue()) {
      cb_searchAllStations_2641_1.issue<QRadioTunerControl_Adaptor, const qt_gsi::Converter<QRadioTuner::SearchMode>::target_type &>(&QRadioTunerControl_Adaptor::cbs_searchAllStations_2641_1, qt_gsi::CppToQtAdaptor<QRadioTuner::SearchMode>(searchMode));
    } else {
      throw qt_gsi::AbstractMethodCalledException("searchAllStations");
    }
  }

  //  [adaptor impl] void QRadioTunerControl::searchBackward()
  void cbs_searchBackward_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("searchBackward");
  }

  virtual void searchBackward()
  {
    if (cb_searchBackward_0_0.can_issue()) {
      cb_searchBackward_0_0.issue<QRadioTunerControl_Adaptor>(&QRadioTunerControl_Adaptor::cbs_searchBackward_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("searchBackward");
    }
  }

  //  [adaptor impl] void QRadioTunerControl::searchForward()
  void cbs_searchForward_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("searchForward");
  }

  virtual void searchForward()
  {
    if (cb_searchForward_0_0.can_issue()) {
      cb_searchForward_0_0.issue<QRadioTunerControl_Adaptor>(&QRadioTunerControl_Adaptor::cbs_searchForward_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("searchForward");
    }
  }

  //  [adaptor impl] void QRadioTunerControl::setBand(QRadioTuner::Band b)
  void cbs_setBand_2027_0(const qt_gsi::Converter<QRadioTuner::Band>::target_type & b)
  {
    __SUPPRESS_UNUSED_WARNING (b);
    throw qt_gsi::AbstractMethodCalledException("setBand");
  }

  virtual void setBand(QRadioTuner::Band b)
  {
    if (cb_setBand_2027_0.can_issue()) {
      cb_setBand_2027_0.issue<QRadioTunerControl_Adaptor, const qt_gsi::Converter<QRadioTuner::Band>::target_type &>(&QRadioTunerControl_Adaptor::cbs_setBand_2027_0, qt_gsi::CppToQtAdaptor<QRadioTuner::Band>(b));
    } else {
      throw qt_gsi::AbstractMethodCalledException("setBand");
    }
  }

  //  [adaptor impl] void QRadioTunerControl::setFrequency(int frequency)
  void cbs_setFrequency_767_0(int frequency)
  {
    __SUPPRESS_UNUSED_WARNING (frequency);
    throw qt_gsi::AbstractMethodCalledException("setFrequency");
  }

  virtual void setFrequency(int frequency)
  {
    if (cb_setFrequency_767_0.can_issue()) {
      cb_setFrequency_767_0.issue<QRadioTunerControl_Adaptor, int>(&QRadioTunerControl_Adaptor::cbs_setFrequency_767_0, frequency);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setFrequency");
    }
  }

  //  [adaptor impl] void QRadioTunerControl::setMuted(bool muted)
  void cbs_setMuted_864_0(bool muted)
  {
    __SUPPRESS_UNUSED_WARNING (muted);
    throw qt_gsi::AbstractMethodCalledException("setMuted");
  }

  virtual void setMuted(bool muted)
  {
    if (cb_setMuted_864_0.can_issue()) {
      cb_setMuted_864_0.issue<QRadioTunerControl_Adaptor, bool>(&QRadioTunerControl_Adaptor::cbs_setMuted_864_0, muted);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setMuted");
    }
  }

  //  [adaptor impl] void QRadioTunerControl::setStereoMode(QRadioTuner::StereoMode mode)
  void cbs_setStereoMode_2669_0(const qt_gsi::Converter<QRadioTuner::StereoMode>::target_type & mode)
  {
    __SUPPRESS_UNUSED_WARNING (mode);
    throw qt_gsi::AbstractMethodCalledException("setStereoMode");
  }

  virtual void setStereoMode(QRadioTuner::StereoMode mode)
  {
    if (cb_setStereoMode_2669_0.can_issue()) {
      cb_setStereoMode_2669_0.issue<QRadioTunerControl_Adaptor, const qt_gsi::Converter<QRadioTuner::StereoMode>::target_type &>(&QRadioTunerControl_Adaptor::cbs_setStereoMode_2669_0, qt_gsi::CppToQtAdaptor<QRadioTuner::StereoMode>(mode));
    } else {
      throw qt_gsi::AbstractMethodCalledException("setStereoMode");
    }
  }

  //  [adaptor impl] void QRadioTunerControl::setVolume(int volume)
  void cbs_setVolume_767_0(int volume)
  {
    __SUPPRESS_UNUSED_WARNING (volume);
    throw qt_gsi::AbstractMethodCalledException("setVolume");
  }

  virtual void setVolume(int volume)
  {
    if (cb_setVolume_767_0.can_issue()) {
      cb_setVolume_767_0.issue<QRadioTunerControl_Adaptor, int>(&QRadioTunerControl_Adaptor::cbs_setVolume_767_0, volume);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setVolume");
    }
  }

  //  [adaptor impl] int QRadioTunerControl::signalStrength()
  int cbs_signalStrength_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("signalStrength");
  }

  virtual int signalStrength() const
  {
    if (cb_signalStrength_c0_0.can_issue()) {
      return cb_signalStrength_c0_0.issue<QRadioTunerControl_Adaptor, int>(&QRadioTunerControl_Adaptor::cbs_signalStrength_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("signalStrength");
    }
  }

  //  [adaptor impl] void QRadioTunerControl::start()
  void cbs_start_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("start");
  }

  virtual void start()
  {
    if (cb_start_0_0.can_issue()) {
      cb_start_0_0.issue<QRadioTunerControl_Adaptor>(&QRadioTunerControl_Adaptor::cbs_start_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("start");
    }
  }

  //  [adaptor impl] QRadioTuner::State QRadioTunerControl::state()
  qt_gsi::Converter<QRadioTuner::State>::target_type cbs_state_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("state");
  }

  virtual QRadioTuner::State state() const
  {
    if (cb_state_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QRadioTuner::State>(cb_state_c0_0.issue<QRadioTunerControl_Adaptor, qt_gsi::Converter<QRadioTuner::State>::target_type>(&QRadioTunerControl_Adaptor::cbs_state_c0_0)).cref();
    } else {
      throw qt_gsi::AbstractMethodCalledException("state");
    }
  }

  //  [adaptor impl] QRadioTuner::StereoMode QRadioTunerControl::stereoMode()
  qt_gsi::Converter<QRadioTuner::StereoMode>::target_type cbs_stereoMode_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("stereoMode");
  }

  virtual QRadioTuner::StereoMode stereoMode() const
  {
    if (cb_stereoMode_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QRadioTuner::StereoMode>(cb_stereoMode_c0_0.issue<QRadioTunerControl_Adaptor, qt_gsi::Converter<QRadioTuner::StereoMode>::target_type>(&QRadioTunerControl_Adaptor::cbs_stereoMode_c0_0)).cref();
    } else {
      throw qt_gsi::AbstractMethodCalledException("stereoMode");
    }
  }

  //  [adaptor impl] void QRadioTunerControl::stop()
  void cbs_stop_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("stop");
  }

  virtual void stop()
  {
    if (cb_stop_0_0.can_issue()) {
      cb_stop_0_0.issue<QRadioTunerControl_Adaptor>(&QRadioTunerControl_Adaptor::cbs_stop_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("stop");
    }
  }

  //  [adaptor impl] int QRadioTunerControl::volume()
  int cbs_volume_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("volume");
  }

  virtual int volume() const
  {
    if (cb_volume_c0_0.can_issue()) {
      return cb_volume_c0_0.issue<QRadioTunerControl_Adaptor, int>(&QRadioTunerControl_Adaptor::cbs_volume_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("volume");
    }
  }

  //  [adaptor impl] void QRadioTunerControl::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QRadioTunerControl::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QRadioTunerControl_Adaptor, QChildEvent *>(&QRadioTunerControl_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QRadioTunerControl::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QRadioTunerControl::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QRadioTunerControl::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QRadioTunerControl_Adaptor, QEvent *>(&QRadioTunerControl_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QRadioTunerControl::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QRadioTunerControl::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QRadioTunerControl::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QRadioTunerControl_Adaptor, const QMetaMethod &>(&QRadioTunerControl_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QRadioTunerControl::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QRadioTunerControl::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QRadioTunerControl::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QRadioTunerControl_Adaptor, QTimerEvent *>(&QRadioTunerControl_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QRadioTunerControl::timerEvent(arg1);
    }
  }

  gsi::Callback cb_band_c0_0;
  gsi::Callback cb_cancelSearch_0_0;
  gsi::Callback cb_error_c0_0;
  gsi::Callback cb_errorString_c0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_frequency_c0_0;
  gsi::Callback cb_frequencyRange_c2027_0;
  gsi::Callback cb_frequencyStep_c2027_0;
  gsi::Callback cb_isAntennaConnected_c0_0;
  gsi::Callback cb_isBandSupported_c2027_0;
  gsi::Callback cb_isMuted_c0_0;
  gsi::Callback cb_isSearching_c0_0;
  gsi::Callback cb_isStereo_c0_0;
  gsi::Callback cb_searchAllStations_2641_1;
  gsi::Callback cb_searchBackward_0_0;
  gsi::Callback cb_searchForward_0_0;
  gsi::Callback cb_setBand_2027_0;
  gsi::Callback cb_setFrequency_767_0;
  gsi::Callback cb_setMuted_864_0;
  gsi::Callback cb_setStereoMode_2669_0;
  gsi::Callback cb_setVolume_767_0;
  gsi::Callback cb_signalStrength_c0_0;
  gsi::Callback cb_start_0_0;
  gsi::Callback cb_state_c0_0;
  gsi::Callback cb_stereoMode_c0_0;
  gsi::Callback cb_stop_0_0;
  gsi::Callback cb_volume_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QRadioTunerControl_Adaptor::~QRadioTunerControl_Adaptor() { }

// QRadioTuner::Band QRadioTunerControl::band()

static void _init_cbs_band_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QRadioTuner::Band>::target_type > ();
}

static void _call_cbs_band_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QRadioTuner::Band>::target_type > ((qt_gsi::Converter<QRadioTuner::Band>::target_type)((QRadioTunerControl_Adaptor *)cls)->cbs_band_c0_0 ());
}

static void _set_callback_cbs_band_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTunerControl_Adaptor *)cls)->cb_band_c0_0 = cb;
}


// void QRadioTunerControl::cancelSearch()

static void _init_cbs_cancelSearch_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_cancelSearch_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl_Adaptor *)cls)->cbs_cancelSearch_0_0 ();
}

static void _set_callback_cbs_cancelSearch_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTunerControl_Adaptor *)cls)->cb_cancelSearch_0_0 = cb;
}


// void QRadioTunerControl::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTunerControl_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QRadioTunerControl::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTunerControl_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// void QRadioTunerControl::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTunerControl_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// QRadioTuner::Error QRadioTunerControl::error()

static void _init_cbs_error_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QRadioTuner::Error>::target_type > ();
}

static void _call_cbs_error_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QRadioTuner::Error>::target_type > ((qt_gsi::Converter<QRadioTuner::Error>::target_type)((QRadioTunerControl_Adaptor *)cls)->cbs_error_c0_0 ());
}

static void _set_callback_cbs_error_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTunerControl_Adaptor *)cls)->cb_error_c0_0 = cb;
}


// QString QRadioTunerControl::errorString()

static void _init_cbs_errorString_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_cbs_errorString_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QRadioTunerControl_Adaptor *)cls)->cbs_errorString_c0_0 ());
}

static void _set_callback_cbs_errorString_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTunerControl_Adaptor *)cls)->cb_errorString_c0_0 = cb;
}


// bool QRadioTunerControl::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QRadioTunerControl_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTunerControl_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QRadioTunerControl::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QRadioTunerControl_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTunerControl_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// int QRadioTunerControl::frequency()

static void _init_cbs_frequency_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_frequency_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QRadioTunerControl_Adaptor *)cls)->cbs_frequency_c0_0 ());
}

static void _set_callback_cbs_frequency_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTunerControl_Adaptor *)cls)->cb_frequency_c0_0 = cb;
}


// QPair<int, int> QRadioTunerControl::frequencyRange(QRadioTuner::Band b)

static void _init_cbs_frequencyRange_c2027_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<const qt_gsi::Converter<QRadioTuner::Band>::target_type & > (argspec_0);
  decl->set_return<QPair<int, int> > ();
}

static void _call_cbs_frequencyRange_c2027_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QRadioTuner::Band>::target_type & arg1 = args.read<const qt_gsi::Converter<QRadioTuner::Band>::target_type & > (heap);
  ret.write<QPair<int, int> > ((QPair<int, int>)((QRadioTunerControl_Adaptor *)cls)->cbs_frequencyRange_c2027_0 (arg1));
}

static void _set_callback_cbs_frequencyRange_c2027_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTunerControl_Adaptor *)cls)->cb_frequencyRange_c2027_0 = cb;
}


// int QRadioTunerControl::frequencyStep(QRadioTuner::Band b)

static void _init_cbs_frequencyStep_c2027_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<const qt_gsi::Converter<QRadioTuner::Band>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_frequencyStep_c2027_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QRadioTuner::Band>::target_type & arg1 = args.read<const qt_gsi::Converter<QRadioTuner::Band>::target_type & > (heap);
  ret.write<int > ((int)((QRadioTunerControl_Adaptor *)cls)->cbs_frequencyStep_c2027_0 (arg1));
}

static void _set_callback_cbs_frequencyStep_c2027_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTunerControl_Adaptor *)cls)->cb_frequencyStep_c2027_0 = cb;
}


// bool QRadioTunerControl::isAntennaConnected()

static void _init_cbs_isAntennaConnected_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isAntennaConnected_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QRadioTunerControl_Adaptor *)cls)->cbs_isAntennaConnected_c0_0 ());
}

static void _set_callback_cbs_isAntennaConnected_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTunerControl_Adaptor *)cls)->cb_isAntennaConnected_c0_0 = cb;
}


// bool QRadioTunerControl::isBandSupported(QRadioTuner::Band b)

static void _init_cbs_isBandSupported_c2027_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<const qt_gsi::Converter<QRadioTuner::Band>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_isBandSupported_c2027_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QRadioTuner::Band>::target_type & arg1 = args.read<const qt_gsi::Converter<QRadioTuner::Band>::target_type & > (heap);
  ret.write<bool > ((bool)((QRadioTunerControl_Adaptor *)cls)->cbs_isBandSupported_c2027_0 (arg1));
}

static void _set_callback_cbs_isBandSupported_c2027_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTunerControl_Adaptor *)cls)->cb_isBandSupported_c2027_0 = cb;
}


// bool QRadioTunerControl::isMuted()

static void _init_cbs_isMuted_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isMuted_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QRadioTunerControl_Adaptor *)cls)->cbs_isMuted_c0_0 ());
}

static void _set_callback_cbs_isMuted_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTunerControl_Adaptor *)cls)->cb_isMuted_c0_0 = cb;
}


// bool QRadioTunerControl::isSearching()

static void _init_cbs_isSearching_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isSearching_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QRadioTunerControl_Adaptor *)cls)->cbs_isSearching_c0_0 ());
}

static void _set_callback_cbs_isSearching_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTunerControl_Adaptor *)cls)->cb_isSearching_c0_0 = cb;
}


// exposed bool QRadioTunerControl::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QRadioTunerControl_Adaptor *)cls)->fp_QRadioTunerControl_isSignalConnected_c2394 (arg1));
}


// bool QRadioTunerControl::isStereo()

static void _init_cbs_isStereo_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isStereo_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QRadioTunerControl_Adaptor *)cls)->cbs_isStereo_c0_0 ());
}

static void _set_callback_cbs_isStereo_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTunerControl_Adaptor *)cls)->cb_isStereo_c0_0 = cb;
}


// exposed int QRadioTunerControl::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QRadioTunerControl_Adaptor *)cls)->fp_QRadioTunerControl_receivers_c1731 (arg1));
}


// void QRadioTunerControl::searchAllStations(QRadioTuner::SearchMode searchMode)

static void _init_cbs_searchAllStations_2641_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("searchMode");
  decl->add_arg<const qt_gsi::Converter<QRadioTuner::SearchMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_searchAllStations_2641_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QRadioTuner::SearchMode>::target_type & arg1 = args.read<const qt_gsi::Converter<QRadioTuner::SearchMode>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl_Adaptor *)cls)->cbs_searchAllStations_2641_1 (arg1);
}

static void _set_callback_cbs_searchAllStations_2641_1 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTunerControl_Adaptor *)cls)->cb_searchAllStations_2641_1 = cb;
}


// void QRadioTunerControl::searchBackward()

static void _init_cbs_searchBackward_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_searchBackward_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl_Adaptor *)cls)->cbs_searchBackward_0_0 ();
}

static void _set_callback_cbs_searchBackward_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTunerControl_Adaptor *)cls)->cb_searchBackward_0_0 = cb;
}


// void QRadioTunerControl::searchForward()

static void _init_cbs_searchForward_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_searchForward_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl_Adaptor *)cls)->cbs_searchForward_0_0 ();
}

static void _set_callback_cbs_searchForward_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTunerControl_Adaptor *)cls)->cb_searchForward_0_0 = cb;
}


// exposed QObject *QRadioTunerControl::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QRadioTunerControl_Adaptor *)cls)->fp_QRadioTunerControl_sender_c0 ());
}


// exposed int QRadioTunerControl::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QRadioTunerControl_Adaptor *)cls)->fp_QRadioTunerControl_senderSignalIndex_c0 ());
}


// void QRadioTunerControl::setBand(QRadioTuner::Band b)

static void _init_cbs_setBand_2027_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<const qt_gsi::Converter<QRadioTuner::Band>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setBand_2027_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QRadioTuner::Band>::target_type & arg1 = args.read<const qt_gsi::Converter<QRadioTuner::Band>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl_Adaptor *)cls)->cbs_setBand_2027_0 (arg1);
}

static void _set_callback_cbs_setBand_2027_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTunerControl_Adaptor *)cls)->cb_setBand_2027_0 = cb;
}


// void QRadioTunerControl::setFrequency(int frequency)

static void _init_cbs_setFrequency_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("frequency");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setFrequency_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl_Adaptor *)cls)->cbs_setFrequency_767_0 (arg1);
}

static void _set_callback_cbs_setFrequency_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTunerControl_Adaptor *)cls)->cb_setFrequency_767_0 = cb;
}


// void QRadioTunerControl::setMuted(bool muted)

static void _init_cbs_setMuted_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("muted");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setMuted_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl_Adaptor *)cls)->cbs_setMuted_864_0 (arg1);
}

static void _set_callback_cbs_setMuted_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTunerControl_Adaptor *)cls)->cb_setMuted_864_0 = cb;
}


// void QRadioTunerControl::setStereoMode(QRadioTuner::StereoMode mode)

static void _init_cbs_setStereoMode_2669_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QRadioTuner::StereoMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setStereoMode_2669_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QRadioTuner::StereoMode>::target_type & arg1 = args.read<const qt_gsi::Converter<QRadioTuner::StereoMode>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl_Adaptor *)cls)->cbs_setStereoMode_2669_0 (arg1);
}

static void _set_callback_cbs_setStereoMode_2669_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTunerControl_Adaptor *)cls)->cb_setStereoMode_2669_0 = cb;
}


// void QRadioTunerControl::setVolume(int volume)

static void _init_cbs_setVolume_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("volume");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVolume_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl_Adaptor *)cls)->cbs_setVolume_767_0 (arg1);
}

static void _set_callback_cbs_setVolume_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTunerControl_Adaptor *)cls)->cb_setVolume_767_0 = cb;
}


// int QRadioTunerControl::signalStrength()

static void _init_cbs_signalStrength_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_signalStrength_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QRadioTunerControl_Adaptor *)cls)->cbs_signalStrength_c0_0 ());
}

static void _set_callback_cbs_signalStrength_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTunerControl_Adaptor *)cls)->cb_signalStrength_c0_0 = cb;
}


// void QRadioTunerControl::start()

static void _init_cbs_start_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_start_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl_Adaptor *)cls)->cbs_start_0_0 ();
}

static void _set_callback_cbs_start_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTunerControl_Adaptor *)cls)->cb_start_0_0 = cb;
}


// QRadioTuner::State QRadioTunerControl::state()

static void _init_cbs_state_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QRadioTuner::State>::target_type > ();
}

static void _call_cbs_state_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QRadioTuner::State>::target_type > ((qt_gsi::Converter<QRadioTuner::State>::target_type)((QRadioTunerControl_Adaptor *)cls)->cbs_state_c0_0 ());
}

static void _set_callback_cbs_state_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTunerControl_Adaptor *)cls)->cb_state_c0_0 = cb;
}


// QRadioTuner::StereoMode QRadioTunerControl::stereoMode()

static void _init_cbs_stereoMode_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QRadioTuner::StereoMode>::target_type > ();
}

static void _call_cbs_stereoMode_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QRadioTuner::StereoMode>::target_type > ((qt_gsi::Converter<QRadioTuner::StereoMode>::target_type)((QRadioTunerControl_Adaptor *)cls)->cbs_stereoMode_c0_0 ());
}

static void _set_callback_cbs_stereoMode_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTunerControl_Adaptor *)cls)->cb_stereoMode_c0_0 = cb;
}


// void QRadioTunerControl::stop()

static void _init_cbs_stop_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_stop_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl_Adaptor *)cls)->cbs_stop_0_0 ();
}

static void _set_callback_cbs_stop_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTunerControl_Adaptor *)cls)->cb_stop_0_0 = cb;
}


// void QRadioTunerControl::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTunerControl_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTunerControl_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// int QRadioTunerControl::volume()

static void _init_cbs_volume_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_volume_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QRadioTunerControl_Adaptor *)cls)->cbs_volume_c0_0 ());
}

static void _set_callback_cbs_volume_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTunerControl_Adaptor *)cls)->cb_volume_c0_0 = cb;
}


namespace gsi
{

gsi::Class<QRadioTunerControl> &qtdecl_QRadioTunerControl ();

static gsi::Methods methods_QRadioTunerControl_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod ("band", "@brief Virtual method QRadioTuner::Band QRadioTunerControl::band()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_band_c0_0, &_call_cbs_band_c0_0);
  methods += new qt_gsi::GenericMethod ("band", "@hide", true, &_init_cbs_band_c0_0, &_call_cbs_band_c0_0, &_set_callback_cbs_band_c0_0);
  methods += new qt_gsi::GenericMethod ("cancelSearch", "@brief Virtual method void QRadioTunerControl::cancelSearch()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_cancelSearch_0_0, &_call_cbs_cancelSearch_0_0);
  methods += new qt_gsi::GenericMethod ("cancelSearch", "@hide", false, &_init_cbs_cancelSearch_0_0, &_call_cbs_cancelSearch_0_0, &_set_callback_cbs_cancelSearch_0_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QRadioTunerControl::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QRadioTunerControl::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QRadioTunerControl::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("error", "@brief Virtual method QRadioTuner::Error QRadioTunerControl::error()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_error_c0_0, &_call_cbs_error_c0_0);
  methods += new qt_gsi::GenericMethod ("error", "@hide", true, &_init_cbs_error_c0_0, &_call_cbs_error_c0_0, &_set_callback_cbs_error_c0_0);
  methods += new qt_gsi::GenericMethod ("errorString", "@brief Virtual method QString QRadioTunerControl::errorString()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_errorString_c0_0, &_call_cbs_errorString_c0_0);
  methods += new qt_gsi::GenericMethod ("errorString", "@hide", true, &_init_cbs_errorString_c0_0, &_call_cbs_errorString_c0_0, &_set_callback_cbs_errorString_c0_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QRadioTunerControl::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QRadioTunerControl::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("frequency", "@brief Virtual method int QRadioTunerControl::frequency()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_frequency_c0_0, &_call_cbs_frequency_c0_0);
  methods += new qt_gsi::GenericMethod ("frequency", "@hide", true, &_init_cbs_frequency_c0_0, &_call_cbs_frequency_c0_0, &_set_callback_cbs_frequency_c0_0);
  methods += new qt_gsi::GenericMethod ("frequencyRange", "@brief Virtual method QPair<int, int> QRadioTunerControl::frequencyRange(QRadioTuner::Band b)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_frequencyRange_c2027_0, &_call_cbs_frequencyRange_c2027_0);
  methods += new qt_gsi::GenericMethod ("frequencyRange", "@hide", true, &_init_cbs_frequencyRange_c2027_0, &_call_cbs_frequencyRange_c2027_0, &_set_callback_cbs_frequencyRange_c2027_0);
  methods += new qt_gsi::GenericMethod ("frequencyStep", "@brief Virtual method int QRadioTunerControl::frequencyStep(QRadioTuner::Band b)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_frequencyStep_c2027_0, &_call_cbs_frequencyStep_c2027_0);
  methods += new qt_gsi::GenericMethod ("frequencyStep", "@hide", true, &_init_cbs_frequencyStep_c2027_0, &_call_cbs_frequencyStep_c2027_0, &_set_callback_cbs_frequencyStep_c2027_0);
  methods += new qt_gsi::GenericMethod ("isAntennaConnected", "@brief Virtual method bool QRadioTunerControl::isAntennaConnected()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isAntennaConnected_c0_0, &_call_cbs_isAntennaConnected_c0_0);
  methods += new qt_gsi::GenericMethod ("isAntennaConnected", "@hide", true, &_init_cbs_isAntennaConnected_c0_0, &_call_cbs_isAntennaConnected_c0_0, &_set_callback_cbs_isAntennaConnected_c0_0);
  methods += new qt_gsi::GenericMethod ("isBandSupported", "@brief Virtual method bool QRadioTunerControl::isBandSupported(QRadioTuner::Band b)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isBandSupported_c2027_0, &_call_cbs_isBandSupported_c2027_0);
  methods += new qt_gsi::GenericMethod ("isBandSupported", "@hide", true, &_init_cbs_isBandSupported_c2027_0, &_call_cbs_isBandSupported_c2027_0, &_set_callback_cbs_isBandSupported_c2027_0);
  methods += new qt_gsi::GenericMethod ("isMuted", "@brief Virtual method bool QRadioTunerControl::isMuted()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isMuted_c0_0, &_call_cbs_isMuted_c0_0);
  methods += new qt_gsi::GenericMethod ("isMuted", "@hide", true, &_init_cbs_isMuted_c0_0, &_call_cbs_isMuted_c0_0, &_set_callback_cbs_isMuted_c0_0);
  methods += new qt_gsi::GenericMethod ("isSearching", "@brief Virtual method bool QRadioTunerControl::isSearching()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isSearching_c0_0, &_call_cbs_isSearching_c0_0);
  methods += new qt_gsi::GenericMethod ("isSearching", "@hide", true, &_init_cbs_isSearching_c0_0, &_call_cbs_isSearching_c0_0, &_set_callback_cbs_isSearching_c0_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QRadioTunerControl::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("isStereo", "@brief Virtual method bool QRadioTunerControl::isStereo()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isStereo_c0_0, &_call_cbs_isStereo_c0_0);
  methods += new qt_gsi::GenericMethod ("isStereo", "@hide", true, &_init_cbs_isStereo_c0_0, &_call_cbs_isStereo_c0_0, &_set_callback_cbs_isStereo_c0_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QRadioTunerControl::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("searchAllStations", "@brief Virtual method void QRadioTunerControl::searchAllStations(QRadioTuner::SearchMode searchMode)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_searchAllStations_2641_1, &_call_cbs_searchAllStations_2641_1);
  methods += new qt_gsi::GenericMethod ("searchAllStations", "@hide", false, &_init_cbs_searchAllStations_2641_1, &_call_cbs_searchAllStations_2641_1, &_set_callback_cbs_searchAllStations_2641_1);
  methods += new qt_gsi::GenericMethod ("searchBackward", "@brief Virtual method void QRadioTunerControl::searchBackward()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_searchBackward_0_0, &_call_cbs_searchBackward_0_0);
  methods += new qt_gsi::GenericMethod ("searchBackward", "@hide", false, &_init_cbs_searchBackward_0_0, &_call_cbs_searchBackward_0_0, &_set_callback_cbs_searchBackward_0_0);
  methods += new qt_gsi::GenericMethod ("searchForward", "@brief Virtual method void QRadioTunerControl::searchForward()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_searchForward_0_0, &_call_cbs_searchForward_0_0);
  methods += new qt_gsi::GenericMethod ("searchForward", "@hide", false, &_init_cbs_searchForward_0_0, &_call_cbs_searchForward_0_0, &_set_callback_cbs_searchForward_0_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QRadioTunerControl::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QRadioTunerControl::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setBand", "@brief Virtual method void QRadioTunerControl::setBand(QRadioTuner::Band b)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setBand_2027_0, &_call_cbs_setBand_2027_0);
  methods += new qt_gsi::GenericMethod ("setBand", "@hide", false, &_init_cbs_setBand_2027_0, &_call_cbs_setBand_2027_0, &_set_callback_cbs_setBand_2027_0);
  methods += new qt_gsi::GenericMethod ("setFrequency", "@brief Virtual method void QRadioTunerControl::setFrequency(int frequency)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setFrequency_767_0, &_call_cbs_setFrequency_767_0);
  methods += new qt_gsi::GenericMethod ("setFrequency", "@hide", false, &_init_cbs_setFrequency_767_0, &_call_cbs_setFrequency_767_0, &_set_callback_cbs_setFrequency_767_0);
  methods += new qt_gsi::GenericMethod ("setMuted", "@brief Virtual method void QRadioTunerControl::setMuted(bool muted)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setMuted_864_0, &_call_cbs_setMuted_864_0);
  methods += new qt_gsi::GenericMethod ("setMuted", "@hide", false, &_init_cbs_setMuted_864_0, &_call_cbs_setMuted_864_0, &_set_callback_cbs_setMuted_864_0);
  methods += new qt_gsi::GenericMethod ("setStereoMode", "@brief Virtual method void QRadioTunerControl::setStereoMode(QRadioTuner::StereoMode mode)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setStereoMode_2669_0, &_call_cbs_setStereoMode_2669_0);
  methods += new qt_gsi::GenericMethod ("setStereoMode", "@hide", false, &_init_cbs_setStereoMode_2669_0, &_call_cbs_setStereoMode_2669_0, &_set_callback_cbs_setStereoMode_2669_0);
  methods += new qt_gsi::GenericMethod ("setVolume", "@brief Virtual method void QRadioTunerControl::setVolume(int volume)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVolume_767_0, &_call_cbs_setVolume_767_0);
  methods += new qt_gsi::GenericMethod ("setVolume", "@hide", false, &_init_cbs_setVolume_767_0, &_call_cbs_setVolume_767_0, &_set_callback_cbs_setVolume_767_0);
  methods += new qt_gsi::GenericMethod ("signalStrength", "@brief Virtual method int QRadioTunerControl::signalStrength()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_signalStrength_c0_0, &_call_cbs_signalStrength_c0_0);
  methods += new qt_gsi::GenericMethod ("signalStrength", "@hide", true, &_init_cbs_signalStrength_c0_0, &_call_cbs_signalStrength_c0_0, &_set_callback_cbs_signalStrength_c0_0);
  methods += new qt_gsi::GenericMethod ("start", "@brief Virtual method void QRadioTunerControl::start()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_start_0_0, &_call_cbs_start_0_0);
  methods += new qt_gsi::GenericMethod ("start", "@hide", false, &_init_cbs_start_0_0, &_call_cbs_start_0_0, &_set_callback_cbs_start_0_0);
  methods += new qt_gsi::GenericMethod ("state", "@brief Virtual method QRadioTuner::State QRadioTunerControl::state()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_state_c0_0, &_call_cbs_state_c0_0);
  methods += new qt_gsi::GenericMethod ("state", "@hide", true, &_init_cbs_state_c0_0, &_call_cbs_state_c0_0, &_set_callback_cbs_state_c0_0);
  methods += new qt_gsi::GenericMethod ("stereoMode", "@brief Virtual method QRadioTuner::StereoMode QRadioTunerControl::stereoMode()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_stereoMode_c0_0, &_call_cbs_stereoMode_c0_0);
  methods += new qt_gsi::GenericMethod ("stereoMode", "@hide", true, &_init_cbs_stereoMode_c0_0, &_call_cbs_stereoMode_c0_0, &_set_callback_cbs_stereoMode_c0_0);
  methods += new qt_gsi::GenericMethod ("stop", "@brief Virtual method void QRadioTunerControl::stop()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_stop_0_0, &_call_cbs_stop_0_0);
  methods += new qt_gsi::GenericMethod ("stop", "@hide", false, &_init_cbs_stop_0_0, &_call_cbs_stop_0_0, &_set_callback_cbs_stop_0_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QRadioTunerControl::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("volume", "@brief Virtual method int QRadioTunerControl::volume()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_volume_c0_0, &_call_cbs_volume_c0_0);
  methods += new qt_gsi::GenericMethod ("volume", "@hide", true, &_init_cbs_volume_c0_0, &_call_cbs_volume_c0_0, &_set_callback_cbs_volume_c0_0);
  return methods;
}

gsi::Class<QRadioTunerControl_Adaptor> decl_QRadioTunerControl_Adaptor (qtdecl_QRadioTunerControl (), "QtMultimedia", "QRadioTunerControl",
  methods_QRadioTunerControl_Adaptor (),
  "@qt\n@brief Binding of QRadioTunerControl");

}

