
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2021 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQAbstractNetworkCache.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QAbstractNetworkCache>
#include <QChildEvent>
#include <QEvent>
#include <QIODevice>
#include <QMetaMethod>
#include <QNetworkCacheMetaData>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include <QUrl>
#include "gsiQt.h"
#include "gsiQtNetworkCommon.h"
#include "gsiDeclQtNetworkTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QAbstractNetworkCache

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QAbstractNetworkCache::staticMetaObject);
}


// qint64 QAbstractNetworkCache::cacheSize()


static void _init_f_cacheSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_cacheSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QAbstractNetworkCache *)cls)->cacheSize ());
}


// void QAbstractNetworkCache::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractNetworkCache *)cls)->clear ();
}


// QIODevice *QAbstractNetworkCache::data(const QUrl &url)


static void _init_f_data_1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<QIODevice * > ();
}

static void _call_f_data_1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  ret.write<QIODevice * > ((QIODevice *)((QAbstractNetworkCache *)cls)->data (arg1));
}


// void QAbstractNetworkCache::insert(QIODevice *device)


static void _init_f_insert_1447 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_insert_1447 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QIODevice *arg1 = gsi::arg_reader<QIODevice * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractNetworkCache *)cls)->insert (arg1);
}


// QNetworkCacheMetaData QAbstractNetworkCache::metaData(const QUrl &url)


static void _init_f_metaData_1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<QNetworkCacheMetaData > ();
}

static void _call_f_metaData_1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  ret.write<QNetworkCacheMetaData > ((QNetworkCacheMetaData)((QAbstractNetworkCache *)cls)->metaData (arg1));
}


// QIODevice *QAbstractNetworkCache::prepare(const QNetworkCacheMetaData &metaData)


static void _init_f_prepare_3377 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("metaData");
  decl->add_arg<const QNetworkCacheMetaData & > (argspec_0);
  decl->set_return<QIODevice * > ();
}

static void _call_f_prepare_3377 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QNetworkCacheMetaData &arg1 = gsi::arg_reader<const QNetworkCacheMetaData & >() (args, heap);
  ret.write<QIODevice * > ((QIODevice *)((QAbstractNetworkCache *)cls)->prepare (arg1));
}


// bool QAbstractNetworkCache::remove(const QUrl &url)


static void _init_f_remove_1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_remove_1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  ret.write<bool > ((bool)((QAbstractNetworkCache *)cls)->remove (arg1));
}


// void QAbstractNetworkCache::updateMetaData(const QNetworkCacheMetaData &metaData)


static void _init_f_updateMetaData_3377 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("metaData");
  decl->add_arg<const QNetworkCacheMetaData & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_updateMetaData_3377 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QNetworkCacheMetaData &arg1 = gsi::arg_reader<const QNetworkCacheMetaData & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractNetworkCache *)cls)->updateMetaData (arg1);
}


// static QString QAbstractNetworkCache::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QAbstractNetworkCache::tr (arg1, arg2, arg3));
}


// static QString QAbstractNetworkCache::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QAbstractNetworkCache::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QAbstractNetworkCache () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("cacheSize", "@brief Method qint64 QAbstractNetworkCache::cacheSize()\n", true, &_init_f_cacheSize_c0, &_call_f_cacheSize_c0);
  methods += new qt_gsi::GenericMethod ("clear", "@brief Method void QAbstractNetworkCache::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
  methods += new qt_gsi::GenericMethod ("data", "@brief Method QIODevice *QAbstractNetworkCache::data(const QUrl &url)\n", false, &_init_f_data_1701, &_call_f_data_1701);
  methods += new qt_gsi::GenericMethod ("insert", "@brief Method void QAbstractNetworkCache::insert(QIODevice *device)\n", false, &_init_f_insert_1447, &_call_f_insert_1447);
  methods += new qt_gsi::GenericMethod ("metaData", "@brief Method QNetworkCacheMetaData QAbstractNetworkCache::metaData(const QUrl &url)\n", false, &_init_f_metaData_1701, &_call_f_metaData_1701);
  methods += new qt_gsi::GenericMethod ("prepare", "@brief Method QIODevice *QAbstractNetworkCache::prepare(const QNetworkCacheMetaData &metaData)\n", false, &_init_f_prepare_3377, &_call_f_prepare_3377);
  methods += new qt_gsi::GenericMethod ("remove", "@brief Method bool QAbstractNetworkCache::remove(const QUrl &url)\n", false, &_init_f_remove_1701, &_call_f_remove_1701);
  methods += new qt_gsi::GenericMethod ("updateMetaData", "@brief Method void QAbstractNetworkCache::updateMetaData(const QNetworkCacheMetaData &metaData)\n", false, &_init_f_updateMetaData_3377, &_call_f_updateMetaData_3377);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QAbstractNetworkCache::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QAbstractNetworkCache::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QAbstractNetworkCache::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QAbstractNetworkCache::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QAbstractNetworkCache> decl_QAbstractNetworkCache (qtdecl_QObject (), "QtNetwork", "QAbstractNetworkCache_Native",
  methods_QAbstractNetworkCache (),
  "@hide\n@alias QAbstractNetworkCache");

GSI_QTNETWORK_PUBLIC gsi::Class<QAbstractNetworkCache> &qtdecl_QAbstractNetworkCache () { return decl_QAbstractNetworkCache; }

}


class QAbstractNetworkCache_Adaptor : public QAbstractNetworkCache, public qt_gsi::QtObjectBase
{
public:

  virtual ~QAbstractNetworkCache_Adaptor();

  //  [adaptor ctor] QAbstractNetworkCache::QAbstractNetworkCache()
  QAbstractNetworkCache_Adaptor() : QAbstractNetworkCache()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QAbstractNetworkCache::isSignalConnected(const QMetaMethod &signal)
  bool fp_QAbstractNetworkCache_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QAbstractNetworkCache::isSignalConnected(signal);
  }

  //  [expose] int QAbstractNetworkCache::receivers(const char *signal)
  int fp_QAbstractNetworkCache_receivers_c1731 (const char *signal) const {
    return QAbstractNetworkCache::receivers(signal);
  }

  //  [expose] QObject *QAbstractNetworkCache::sender()
  QObject * fp_QAbstractNetworkCache_sender_c0 () const {
    return QAbstractNetworkCache::sender();
  }

  //  [expose] int QAbstractNetworkCache::senderSignalIndex()
  int fp_QAbstractNetworkCache_senderSignalIndex_c0 () const {
    return QAbstractNetworkCache::senderSignalIndex();
  }

  //  [adaptor impl] qint64 QAbstractNetworkCache::cacheSize()
  qint64 cbs_cacheSize_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("cacheSize");
  }

  virtual qint64 cacheSize() const
  {
    if (cb_cacheSize_c0_0.can_issue()) {
      return cb_cacheSize_c0_0.issue<QAbstractNetworkCache_Adaptor, qint64>(&QAbstractNetworkCache_Adaptor::cbs_cacheSize_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("cacheSize");
    }
  }

  //  [adaptor impl] void QAbstractNetworkCache::clear()
  void cbs_clear_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("clear");
  }

  virtual void clear()
  {
    if (cb_clear_0_0.can_issue()) {
      cb_clear_0_0.issue<QAbstractNetworkCache_Adaptor>(&QAbstractNetworkCache_Adaptor::cbs_clear_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("clear");
    }
  }

  //  [adaptor impl] QIODevice *QAbstractNetworkCache::data(const QUrl &url)
  QIODevice * cbs_data_1701_0(const QUrl &url)
  {
    __SUPPRESS_UNUSED_WARNING (url);
    throw qt_gsi::AbstractMethodCalledException("data");
  }

  virtual QIODevice * data(const QUrl &url)
  {
    if (cb_data_1701_0.can_issue()) {
      return cb_data_1701_0.issue<QAbstractNetworkCache_Adaptor, QIODevice *, const QUrl &>(&QAbstractNetworkCache_Adaptor::cbs_data_1701_0, url);
    } else {
      throw qt_gsi::AbstractMethodCalledException("data");
    }
  }

  //  [emitter impl] void QAbstractNetworkCache::destroyed(QObject *)
  void emitter_QAbstractNetworkCache_destroyed_1302(QObject *arg1)
  {
    emit QAbstractNetworkCache::destroyed(arg1);
  }

  //  [adaptor impl] bool QAbstractNetworkCache::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QAbstractNetworkCache::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QAbstractNetworkCache_Adaptor, bool, QEvent *>(&QAbstractNetworkCache_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QAbstractNetworkCache::event(arg1);
    }
  }

  //  [adaptor impl] bool QAbstractNetworkCache::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QAbstractNetworkCache::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QAbstractNetworkCache_Adaptor, bool, QObject *, QEvent *>(&QAbstractNetworkCache_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QAbstractNetworkCache::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QAbstractNetworkCache::insert(QIODevice *device)
  void cbs_insert_1447_0(QIODevice *device)
  {
    __SUPPRESS_UNUSED_WARNING (device);
    throw qt_gsi::AbstractMethodCalledException("insert");
  }

  virtual void insert(QIODevice *device)
  {
    if (cb_insert_1447_0.can_issue()) {
      cb_insert_1447_0.issue<QAbstractNetworkCache_Adaptor, QIODevice *>(&QAbstractNetworkCache_Adaptor::cbs_insert_1447_0, device);
    } else {
      throw qt_gsi::AbstractMethodCalledException("insert");
    }
  }

  //  [adaptor impl] QNetworkCacheMetaData QAbstractNetworkCache::metaData(const QUrl &url)
  QNetworkCacheMetaData cbs_metaData_1701_0(const QUrl &url)
  {
    __SUPPRESS_UNUSED_WARNING (url);
    throw qt_gsi::AbstractMethodCalledException("metaData");
  }

  virtual QNetworkCacheMetaData metaData(const QUrl &url)
  {
    if (cb_metaData_1701_0.can_issue()) {
      return cb_metaData_1701_0.issue<QAbstractNetworkCache_Adaptor, QNetworkCacheMetaData, const QUrl &>(&QAbstractNetworkCache_Adaptor::cbs_metaData_1701_0, url);
    } else {
      throw qt_gsi::AbstractMethodCalledException("metaData");
    }
  }

  //  [emitter impl] void QAbstractNetworkCache::objectNameChanged(const QString &objectName)
  void emitter_QAbstractNetworkCache_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QAbstractNetworkCache::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] QIODevice *QAbstractNetworkCache::prepare(const QNetworkCacheMetaData &metaData)
  QIODevice * cbs_prepare_3377_0(const QNetworkCacheMetaData &metaData)
  {
    __SUPPRESS_UNUSED_WARNING (metaData);
    throw qt_gsi::AbstractMethodCalledException("prepare");
  }

  virtual QIODevice * prepare(const QNetworkCacheMetaData &metaData)
  {
    if (cb_prepare_3377_0.can_issue()) {
      return cb_prepare_3377_0.issue<QAbstractNetworkCache_Adaptor, QIODevice *, const QNetworkCacheMetaData &>(&QAbstractNetworkCache_Adaptor::cbs_prepare_3377_0, metaData);
    } else {
      throw qt_gsi::AbstractMethodCalledException("prepare");
    }
  }

  //  [adaptor impl] bool QAbstractNetworkCache::remove(const QUrl &url)
  bool cbs_remove_1701_0(const QUrl &url)
  {
    __SUPPRESS_UNUSED_WARNING (url);
    throw qt_gsi::AbstractMethodCalledException("remove");
  }

  virtual bool remove(const QUrl &url)
  {
    if (cb_remove_1701_0.can_issue()) {
      return cb_remove_1701_0.issue<QAbstractNetworkCache_Adaptor, bool, const QUrl &>(&QAbstractNetworkCache_Adaptor::cbs_remove_1701_0, url);
    } else {
      throw qt_gsi::AbstractMethodCalledException("remove");
    }
  }

  //  [adaptor impl] void QAbstractNetworkCache::updateMetaData(const QNetworkCacheMetaData &metaData)
  void cbs_updateMetaData_3377_0(const QNetworkCacheMetaData &metaData)
  {
    __SUPPRESS_UNUSED_WARNING (metaData);
    throw qt_gsi::AbstractMethodCalledException("updateMetaData");
  }

  virtual void updateMetaData(const QNetworkCacheMetaData &metaData)
  {
    if (cb_updateMetaData_3377_0.can_issue()) {
      cb_updateMetaData_3377_0.issue<QAbstractNetworkCache_Adaptor, const QNetworkCacheMetaData &>(&QAbstractNetworkCache_Adaptor::cbs_updateMetaData_3377_0, metaData);
    } else {
      throw qt_gsi::AbstractMethodCalledException("updateMetaData");
    }
  }

  //  [adaptor impl] void QAbstractNetworkCache::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QAbstractNetworkCache::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QAbstractNetworkCache_Adaptor, QChildEvent *>(&QAbstractNetworkCache_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QAbstractNetworkCache::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractNetworkCache::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QAbstractNetworkCache::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QAbstractNetworkCache_Adaptor, QEvent *>(&QAbstractNetworkCache_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QAbstractNetworkCache::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractNetworkCache::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QAbstractNetworkCache::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QAbstractNetworkCache_Adaptor, const QMetaMethod &>(&QAbstractNetworkCache_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QAbstractNetworkCache::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QAbstractNetworkCache::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QAbstractNetworkCache::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QAbstractNetworkCache_Adaptor, QTimerEvent *>(&QAbstractNetworkCache_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QAbstractNetworkCache::timerEvent(arg1);
    }
  }

  gsi::Callback cb_cacheSize_c0_0;
  gsi::Callback cb_clear_0_0;
  gsi::Callback cb_data_1701_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_insert_1447_0;
  gsi::Callback cb_metaData_1701_0;
  gsi::Callback cb_prepare_3377_0;
  gsi::Callback cb_remove_1701_0;
  gsi::Callback cb_updateMetaData_3377_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QAbstractNetworkCache_Adaptor::~QAbstractNetworkCache_Adaptor() { }

//  Constructor QAbstractNetworkCache::QAbstractNetworkCache() (adaptor class)

static void _init_ctor_QAbstractNetworkCache_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QAbstractNetworkCache_Adaptor> ();
}

static void _call_ctor_QAbstractNetworkCache_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAbstractNetworkCache_Adaptor *> (new QAbstractNetworkCache_Adaptor ());
}


// qint64 QAbstractNetworkCache::cacheSize()

static void _init_cbs_cacheSize_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_cbs_cacheSize_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QAbstractNetworkCache_Adaptor *)cls)->cbs_cacheSize_c0_0 ());
}

static void _set_callback_cbs_cacheSize_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractNetworkCache_Adaptor *)cls)->cb_cacheSize_c0_0 = cb;
}


// void QAbstractNetworkCache::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractNetworkCache_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractNetworkCache_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QAbstractNetworkCache::clear()

static void _init_cbs_clear_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_clear_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractNetworkCache_Adaptor *)cls)->cbs_clear_0_0 ();
}

static void _set_callback_cbs_clear_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractNetworkCache_Adaptor *)cls)->cb_clear_0_0 = cb;
}


// void QAbstractNetworkCache::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractNetworkCache_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractNetworkCache_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// QIODevice *QAbstractNetworkCache::data(const QUrl &url)

static void _init_cbs_data_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<QIODevice * > ();
}

static void _call_cbs_data_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = args.read<const QUrl & > (heap);
  ret.write<QIODevice * > ((QIODevice *)((QAbstractNetworkCache_Adaptor *)cls)->cbs_data_1701_0 (arg1));
}

static void _set_callback_cbs_data_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractNetworkCache_Adaptor *)cls)->cb_data_1701_0 = cb;
}


// emitter void QAbstractNetworkCache::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QAbstractNetworkCache_Adaptor *)cls)->emitter_QAbstractNetworkCache_destroyed_1302 (arg1);
}


// void QAbstractNetworkCache::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractNetworkCache_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractNetworkCache_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QAbstractNetworkCache::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QAbstractNetworkCache_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractNetworkCache_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QAbstractNetworkCache::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QAbstractNetworkCache_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractNetworkCache_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QAbstractNetworkCache::insert(QIODevice *device)

static void _init_cbs_insert_1447_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_insert_1447_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QIODevice *arg1 = args.read<QIODevice * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractNetworkCache_Adaptor *)cls)->cbs_insert_1447_0 (arg1);
}

static void _set_callback_cbs_insert_1447_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractNetworkCache_Adaptor *)cls)->cb_insert_1447_0 = cb;
}


// exposed bool QAbstractNetworkCache::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QAbstractNetworkCache_Adaptor *)cls)->fp_QAbstractNetworkCache_isSignalConnected_c2394 (arg1));
}


// QNetworkCacheMetaData QAbstractNetworkCache::metaData(const QUrl &url)

static void _init_cbs_metaData_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<QNetworkCacheMetaData > ();
}

static void _call_cbs_metaData_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = args.read<const QUrl & > (heap);
  ret.write<QNetworkCacheMetaData > ((QNetworkCacheMetaData)((QAbstractNetworkCache_Adaptor *)cls)->cbs_metaData_1701_0 (arg1));
}

static void _set_callback_cbs_metaData_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractNetworkCache_Adaptor *)cls)->cb_metaData_1701_0 = cb;
}


// emitter void QAbstractNetworkCache::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QAbstractNetworkCache_Adaptor *)cls)->emitter_QAbstractNetworkCache_objectNameChanged_4567 (arg1);
}


// QIODevice *QAbstractNetworkCache::prepare(const QNetworkCacheMetaData &metaData)

static void _init_cbs_prepare_3377_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("metaData");
  decl->add_arg<const QNetworkCacheMetaData & > (argspec_0);
  decl->set_return<QIODevice * > ();
}

static void _call_cbs_prepare_3377_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QNetworkCacheMetaData &arg1 = args.read<const QNetworkCacheMetaData & > (heap);
  ret.write<QIODevice * > ((QIODevice *)((QAbstractNetworkCache_Adaptor *)cls)->cbs_prepare_3377_0 (arg1));
}

static void _set_callback_cbs_prepare_3377_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractNetworkCache_Adaptor *)cls)->cb_prepare_3377_0 = cb;
}


// exposed int QAbstractNetworkCache::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QAbstractNetworkCache_Adaptor *)cls)->fp_QAbstractNetworkCache_receivers_c1731 (arg1));
}


// bool QAbstractNetworkCache::remove(const QUrl &url)

static void _init_cbs_remove_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_remove_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = args.read<const QUrl & > (heap);
  ret.write<bool > ((bool)((QAbstractNetworkCache_Adaptor *)cls)->cbs_remove_1701_0 (arg1));
}

static void _set_callback_cbs_remove_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractNetworkCache_Adaptor *)cls)->cb_remove_1701_0 = cb;
}


// exposed QObject *QAbstractNetworkCache::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QAbstractNetworkCache_Adaptor *)cls)->fp_QAbstractNetworkCache_sender_c0 ());
}


// exposed int QAbstractNetworkCache::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractNetworkCache_Adaptor *)cls)->fp_QAbstractNetworkCache_senderSignalIndex_c0 ());
}


// void QAbstractNetworkCache::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractNetworkCache_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractNetworkCache_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// void QAbstractNetworkCache::updateMetaData(const QNetworkCacheMetaData &metaData)

static void _init_cbs_updateMetaData_3377_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("metaData");
  decl->add_arg<const QNetworkCacheMetaData & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_updateMetaData_3377_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QNetworkCacheMetaData &arg1 = args.read<const QNetworkCacheMetaData & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractNetworkCache_Adaptor *)cls)->cbs_updateMetaData_3377_0 (arg1);
}

static void _set_callback_cbs_updateMetaData_3377_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractNetworkCache_Adaptor *)cls)->cb_updateMetaData_3377_0 = cb;
}


namespace gsi
{

gsi::Class<QAbstractNetworkCache> &qtdecl_QAbstractNetworkCache ();

static gsi::Methods methods_QAbstractNetworkCache_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAbstractNetworkCache::QAbstractNetworkCache()\nThis method creates an object of class QAbstractNetworkCache.", &_init_ctor_QAbstractNetworkCache_Adaptor_0, &_call_ctor_QAbstractNetworkCache_Adaptor_0);
  methods += new qt_gsi::GenericMethod ("cacheSize", "@brief Virtual method qint64 QAbstractNetworkCache::cacheSize()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_cacheSize_c0_0, &_call_cbs_cacheSize_c0_0);
  methods += new qt_gsi::GenericMethod ("cacheSize", "@hide", true, &_init_cbs_cacheSize_c0_0, &_call_cbs_cacheSize_c0_0, &_set_callback_cbs_cacheSize_c0_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QAbstractNetworkCache::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("clear", "@brief Virtual method void QAbstractNetworkCache::clear()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_clear_0_0, &_call_cbs_clear_0_0);
  methods += new qt_gsi::GenericMethod ("clear", "@hide", false, &_init_cbs_clear_0_0, &_call_cbs_clear_0_0, &_set_callback_cbs_clear_0_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QAbstractNetworkCache::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("data", "@brief Virtual method QIODevice *QAbstractNetworkCache::data(const QUrl &url)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_data_1701_0, &_call_cbs_data_1701_0);
  methods += new qt_gsi::GenericMethod ("data", "@hide", false, &_init_cbs_data_1701_0, &_call_cbs_data_1701_0, &_set_callback_cbs_data_1701_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QAbstractNetworkCache::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QAbstractNetworkCache::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QAbstractNetworkCache::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QAbstractNetworkCache::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("insert", "@brief Virtual method void QAbstractNetworkCache::insert(QIODevice *device)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_insert_1447_0, &_call_cbs_insert_1447_0);
  methods += new qt_gsi::GenericMethod ("insert", "@hide", false, &_init_cbs_insert_1447_0, &_call_cbs_insert_1447_0, &_set_callback_cbs_insert_1447_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QAbstractNetworkCache::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("metaData", "@brief Virtual method QNetworkCacheMetaData QAbstractNetworkCache::metaData(const QUrl &url)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_metaData_1701_0, &_call_cbs_metaData_1701_0);
  methods += new qt_gsi::GenericMethod ("metaData", "@hide", false, &_init_cbs_metaData_1701_0, &_call_cbs_metaData_1701_0, &_set_callback_cbs_metaData_1701_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QAbstractNetworkCache::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("prepare", "@brief Virtual method QIODevice *QAbstractNetworkCache::prepare(const QNetworkCacheMetaData &metaData)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_prepare_3377_0, &_call_cbs_prepare_3377_0);
  methods += new qt_gsi::GenericMethod ("prepare", "@hide", false, &_init_cbs_prepare_3377_0, &_call_cbs_prepare_3377_0, &_set_callback_cbs_prepare_3377_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QAbstractNetworkCache::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("remove", "@brief Virtual method bool QAbstractNetworkCache::remove(const QUrl &url)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_remove_1701_0, &_call_cbs_remove_1701_0);
  methods += new qt_gsi::GenericMethod ("remove", "@hide", false, &_init_cbs_remove_1701_0, &_call_cbs_remove_1701_0, &_set_callback_cbs_remove_1701_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QAbstractNetworkCache::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QAbstractNetworkCache::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QAbstractNetworkCache::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("updateMetaData", "@brief Virtual method void QAbstractNetworkCache::updateMetaData(const QNetworkCacheMetaData &metaData)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateMetaData_3377_0, &_call_cbs_updateMetaData_3377_0);
  methods += new qt_gsi::GenericMethod ("updateMetaData", "@hide", false, &_init_cbs_updateMetaData_3377_0, &_call_cbs_updateMetaData_3377_0, &_set_callback_cbs_updateMetaData_3377_0);
  return methods;
}

gsi::Class<QAbstractNetworkCache_Adaptor> decl_QAbstractNetworkCache_Adaptor (qtdecl_QAbstractNetworkCache (), "QtNetwork", "QAbstractNetworkCache",
  methods_QAbstractNetworkCache_Adaptor (),
  "@qt\n@brief Binding of QAbstractNetworkCache");

}

