
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2021 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQSqlResult.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QSqlResult>
#include <QSqlDriver>
#include <QSqlError>
#include <QSqlRecord>
#include "gsiQt.h"
#include "gsiQtSqlCommon.h"
#include "gsiDeclQtSqlTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QSqlResult

// QVariant QSqlResult::handle()


static void _init_f_handle_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QVariant > ();
}

static void _call_f_handle_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QVariant > ((QVariant)((QSqlResult *)cls)->handle ());
}


namespace gsi
{

static gsi::Methods methods_QSqlResult () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod ("handle", "@brief Method QVariant QSqlResult::handle()\n", true, &_init_f_handle_c0, &_call_f_handle_c0);
  return methods;
}

gsi::Class<QSqlResult> decl_QSqlResult ("QtSql", "QSqlResult_Native",
  methods_QSqlResult (),
  "@hide\n@alias QSqlResult");

GSI_QTSQL_PUBLIC gsi::Class<QSqlResult> &qtdecl_QSqlResult () { return decl_QSqlResult; }

}


class QSqlResult_Adaptor : public QSqlResult, public qt_gsi::QtObjectBase
{
public:

  virtual ~QSqlResult_Adaptor();

  //  [expose] void QSqlResult::addBindValue(const QVariant &val, QFlags<QSql::ParamTypeFlag> type)
  void fp_QSqlResult_addBindValue_4937 (const QVariant &val, QFlags<QSql::ParamTypeFlag> type) {
    QSqlResult::addBindValue(val, type);
  }

  //  [expose] int QSqlResult::at()
  int fp_QSqlResult_at_c0 () const {
    return QSqlResult::at();
  }

  //  [expose] QFlags<QSql::ParamTypeFlag> QSqlResult::bindValueType(const QString &placeholder)
  QFlags<QSql::ParamTypeFlag> fp_QSqlResult_bindValueType_c2025 (const QString &placeholder) const {
    return QSqlResult::bindValueType(placeholder);
  }

  //  [expose] QFlags<QSql::ParamTypeFlag> QSqlResult::bindValueType(int pos)
  QFlags<QSql::ParamTypeFlag> fp_QSqlResult_bindValueType_c767 (int pos) const {
    return QSqlResult::bindValueType(pos);
  }

  //  [expose] QSqlResult::BindingSyntax QSqlResult::bindingSyntax()
  unsigned int fp_QSqlResult_bindingSyntax_c0 () const {
    return (unsigned int)(QSqlResult::bindingSyntax());
  }

  //  [expose] QVariant QSqlResult::boundValue(const QString &placeholder)
  QVariant fp_QSqlResult_boundValue_c2025 (const QString &placeholder) const {
    return QSqlResult::boundValue(placeholder);
  }

  //  [expose] QVariant QSqlResult::boundValue(int pos)
  QVariant fp_QSqlResult_boundValue_c767 (int pos) const {
    return QSqlResult::boundValue(pos);
  }

  //  [expose] int QSqlResult::boundValueCount()
  int fp_QSqlResult_boundValueCount_c0 () const {
    return QSqlResult::boundValueCount();
  }

  //  [expose] QString QSqlResult::boundValueName(int pos)
  QString fp_QSqlResult_boundValueName_c767 (int pos) const {
    return QSqlResult::boundValueName(pos);
  }

  //  [expose] QVector<QVariant> &QSqlResult::boundValues()
  QVector<QVariant> & fp_QSqlResult_boundValues_c0 () const {
    return QSqlResult::boundValues();
  }

  //  [expose] void QSqlResult::clear()
  void fp_QSqlResult_clear_0 () {
    QSqlResult::clear();
  }

  //  [expose] const QSqlDriver *QSqlResult::driver()
  const QSqlDriver * fp_QSqlResult_driver_c0 () const {
    return QSqlResult::driver();
  }

  //  [expose] QString QSqlResult::executedQuery()
  QString fp_QSqlResult_executedQuery_c0 () const {
    return QSqlResult::executedQuery();
  }

  //  [expose] bool QSqlResult::hasOutValues()
  bool fp_QSqlResult_hasOutValues_c0 () const {
    return QSqlResult::hasOutValues();
  }

  //  [expose] bool QSqlResult::isActive()
  bool fp_QSqlResult_isActive_c0 () const {
    return QSqlResult::isActive();
  }

  //  [expose] bool QSqlResult::isForwardOnly()
  bool fp_QSqlResult_isForwardOnly_c0 () const {
    return QSqlResult::isForwardOnly();
  }

  //  [expose] bool QSqlResult::isSelect()
  bool fp_QSqlResult_isSelect_c0 () const {
    return QSqlResult::isSelect();
  }

  //  [expose] bool QSqlResult::isValid()
  bool fp_QSqlResult_isValid_c0 () const {
    return QSqlResult::isValid();
  }

  //  [expose] QSqlError QSqlResult::lastError()
  QSqlError fp_QSqlResult_lastError_c0 () const {
    return QSqlResult::lastError();
  }

  //  [expose] QString QSqlResult::lastQuery()
  QString fp_QSqlResult_lastQuery_c0 () const {
    return QSqlResult::lastQuery();
  }

  //  [expose] QSql::NumericalPrecisionPolicy QSqlResult::numericalPrecisionPolicy()
  qt_gsi::Converter<QSql::NumericalPrecisionPolicy>::target_type fp_QSqlResult_numericalPrecisionPolicy_c0 () const {
    return qt_gsi::CppToQtAdaptor<QSql::NumericalPrecisionPolicy>(QSqlResult::numericalPrecisionPolicy());
  }

  //  [expose] void QSqlResult::resetBindCount()
  void fp_QSqlResult_resetBindCount_0 () {
    QSqlResult::resetBindCount();
  }

  //  [adaptor impl] QVariant QSqlResult::handle()
  QVariant cbs_handle_c0_0() const
  {
    return QSqlResult::handle();
  }

  virtual QVariant handle() const
  {
    if (cb_handle_c0_0.can_issue()) {
      return cb_handle_c0_0.issue<QSqlResult_Adaptor, QVariant>(&QSqlResult_Adaptor::cbs_handle_c0_0);
    } else {
      return QSqlResult::handle();
    }
  }

  //  [adaptor impl] void QSqlResult::bindValue(int pos, const QVariant &val, QFlags<QSql::ParamTypeFlag> type)
  void cbs_bindValue_5596_0(int pos, const QVariant &val, QFlags<QSql::ParamTypeFlag> type)
  {
    QSqlResult::bindValue(pos, val, type);
  }

  virtual void bindValue(int pos, const QVariant &val, QFlags<QSql::ParamTypeFlag> type)
  {
    if (cb_bindValue_5596_0.can_issue()) {
      cb_bindValue_5596_0.issue<QSqlResult_Adaptor, int, const QVariant &, QFlags<QSql::ParamTypeFlag> >(&QSqlResult_Adaptor::cbs_bindValue_5596_0, pos, val, type);
    } else {
      QSqlResult::bindValue(pos, val, type);
    }
  }

  //  [adaptor impl] void QSqlResult::bindValue(const QString &placeholder, const QVariant &val, QFlags<QSql::ParamTypeFlag> type)
  void cbs_bindValue_6854_0(const QString &placeholder, const QVariant &val, QFlags<QSql::ParamTypeFlag> type)
  {
    QSqlResult::bindValue(placeholder, val, type);
  }

  virtual void bindValue(const QString &placeholder, const QVariant &val, QFlags<QSql::ParamTypeFlag> type)
  {
    if (cb_bindValue_6854_0.can_issue()) {
      cb_bindValue_6854_0.issue<QSqlResult_Adaptor, const QString &, const QVariant &, QFlags<QSql::ParamTypeFlag> >(&QSqlResult_Adaptor::cbs_bindValue_6854_0, placeholder, val, type);
    } else {
      QSqlResult::bindValue(placeholder, val, type);
    }
  }

  //  [adaptor impl] QVariant QSqlResult::data(int i)
  QVariant cbs_data_767_0(int i)
  {
    __SUPPRESS_UNUSED_WARNING (i);
    throw qt_gsi::AbstractMethodCalledException("data");
  }

  virtual QVariant data(int i)
  {
    if (cb_data_767_0.can_issue()) {
      return cb_data_767_0.issue<QSqlResult_Adaptor, QVariant, int>(&QSqlResult_Adaptor::cbs_data_767_0, i);
    } else {
      throw qt_gsi::AbstractMethodCalledException("data");
    }
  }

  //  [adaptor impl] void QSqlResult::detachFromResultSet()
  void cbs_detachFromResultSet_0_0()
  {
    QSqlResult::detachFromResultSet();
  }

  virtual void detachFromResultSet()
  {
    if (cb_detachFromResultSet_0_0.can_issue()) {
      cb_detachFromResultSet_0_0.issue<QSqlResult_Adaptor>(&QSqlResult_Adaptor::cbs_detachFromResultSet_0_0);
    } else {
      QSqlResult::detachFromResultSet();
    }
  }

  //  [adaptor impl] bool QSqlResult::exec()
  bool cbs_exec_0_0()
  {
    return QSqlResult::exec();
  }

  virtual bool exec()
  {
    if (cb_exec_0_0.can_issue()) {
      return cb_exec_0_0.issue<QSqlResult_Adaptor, bool>(&QSqlResult_Adaptor::cbs_exec_0_0);
    } else {
      return QSqlResult::exec();
    }
  }

  //  [adaptor impl] bool QSqlResult::execBatch(bool arrayBind)
  bool cbs_execBatch_864_1(bool arrayBind)
  {
    return QSqlResult::execBatch(arrayBind);
  }

  virtual bool execBatch(bool arrayBind)
  {
    if (cb_execBatch_864_1.can_issue()) {
      return cb_execBatch_864_1.issue<QSqlResult_Adaptor, bool, bool>(&QSqlResult_Adaptor::cbs_execBatch_864_1, arrayBind);
    } else {
      return QSqlResult::execBatch(arrayBind);
    }
  }

  //  [adaptor impl] bool QSqlResult::fetch(int i)
  bool cbs_fetch_767_0(int i)
  {
    __SUPPRESS_UNUSED_WARNING (i);
    throw qt_gsi::AbstractMethodCalledException("fetch");
  }

  virtual bool fetch(int i)
  {
    if (cb_fetch_767_0.can_issue()) {
      return cb_fetch_767_0.issue<QSqlResult_Adaptor, bool, int>(&QSqlResult_Adaptor::cbs_fetch_767_0, i);
    } else {
      throw qt_gsi::AbstractMethodCalledException("fetch");
    }
  }

  //  [adaptor impl] bool QSqlResult::fetchFirst()
  bool cbs_fetchFirst_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("fetchFirst");
  }

  virtual bool fetchFirst()
  {
    if (cb_fetchFirst_0_0.can_issue()) {
      return cb_fetchFirst_0_0.issue<QSqlResult_Adaptor, bool>(&QSqlResult_Adaptor::cbs_fetchFirst_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("fetchFirst");
    }
  }

  //  [adaptor impl] bool QSqlResult::fetchLast()
  bool cbs_fetchLast_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("fetchLast");
  }

  virtual bool fetchLast()
  {
    if (cb_fetchLast_0_0.can_issue()) {
      return cb_fetchLast_0_0.issue<QSqlResult_Adaptor, bool>(&QSqlResult_Adaptor::cbs_fetchLast_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("fetchLast");
    }
  }

  //  [adaptor impl] bool QSqlResult::fetchNext()
  bool cbs_fetchNext_0_0()
  {
    return QSqlResult::fetchNext();
  }

  virtual bool fetchNext()
  {
    if (cb_fetchNext_0_0.can_issue()) {
      return cb_fetchNext_0_0.issue<QSqlResult_Adaptor, bool>(&QSqlResult_Adaptor::cbs_fetchNext_0_0);
    } else {
      return QSqlResult::fetchNext();
    }
  }

  //  [adaptor impl] bool QSqlResult::fetchPrevious()
  bool cbs_fetchPrevious_0_0()
  {
    return QSqlResult::fetchPrevious();
  }

  virtual bool fetchPrevious()
  {
    if (cb_fetchPrevious_0_0.can_issue()) {
      return cb_fetchPrevious_0_0.issue<QSqlResult_Adaptor, bool>(&QSqlResult_Adaptor::cbs_fetchPrevious_0_0);
    } else {
      return QSqlResult::fetchPrevious();
    }
  }

  //  [adaptor impl] bool QSqlResult::isNull(int i)
  bool cbs_isNull_767_0(int i)
  {
    __SUPPRESS_UNUSED_WARNING (i);
    throw qt_gsi::AbstractMethodCalledException("isNull");
  }

  virtual bool isNull(int i)
  {
    if (cb_isNull_767_0.can_issue()) {
      return cb_isNull_767_0.issue<QSqlResult_Adaptor, bool, int>(&QSqlResult_Adaptor::cbs_isNull_767_0, i);
    } else {
      throw qt_gsi::AbstractMethodCalledException("isNull");
    }
  }

  //  [adaptor impl] QVariant QSqlResult::lastInsertId()
  QVariant cbs_lastInsertId_c0_0() const
  {
    return QSqlResult::lastInsertId();
  }

  virtual QVariant lastInsertId() const
  {
    if (cb_lastInsertId_c0_0.can_issue()) {
      return cb_lastInsertId_c0_0.issue<QSqlResult_Adaptor, QVariant>(&QSqlResult_Adaptor::cbs_lastInsertId_c0_0);
    } else {
      return QSqlResult::lastInsertId();
    }
  }

  //  [adaptor impl] bool QSqlResult::nextResult()
  bool cbs_nextResult_0_0()
  {
    return QSqlResult::nextResult();
  }

  virtual bool nextResult()
  {
    if (cb_nextResult_0_0.can_issue()) {
      return cb_nextResult_0_0.issue<QSqlResult_Adaptor, bool>(&QSqlResult_Adaptor::cbs_nextResult_0_0);
    } else {
      return QSqlResult::nextResult();
    }
  }

  //  [adaptor impl] int QSqlResult::numRowsAffected()
  int cbs_numRowsAffected_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("numRowsAffected");
  }

  virtual int numRowsAffected()
  {
    if (cb_numRowsAffected_0_0.can_issue()) {
      return cb_numRowsAffected_0_0.issue<QSqlResult_Adaptor, int>(&QSqlResult_Adaptor::cbs_numRowsAffected_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("numRowsAffected");
    }
  }

  //  [adaptor impl] bool QSqlResult::prepare(const QString &query)
  bool cbs_prepare_2025_0(const QString &query)
  {
    return QSqlResult::prepare(query);
  }

  virtual bool prepare(const QString &query)
  {
    if (cb_prepare_2025_0.can_issue()) {
      return cb_prepare_2025_0.issue<QSqlResult_Adaptor, bool, const QString &>(&QSqlResult_Adaptor::cbs_prepare_2025_0, query);
    } else {
      return QSqlResult::prepare(query);
    }
  }

  //  [adaptor impl] QSqlRecord QSqlResult::record()
  QSqlRecord cbs_record_c0_0() const
  {
    return QSqlResult::record();
  }

  virtual QSqlRecord record() const
  {
    if (cb_record_c0_0.can_issue()) {
      return cb_record_c0_0.issue<QSqlResult_Adaptor, QSqlRecord>(&QSqlResult_Adaptor::cbs_record_c0_0);
    } else {
      return QSqlResult::record();
    }
  }

  //  [adaptor impl] bool QSqlResult::reset(const QString &sqlquery)
  bool cbs_reset_2025_0(const QString &sqlquery)
  {
    __SUPPRESS_UNUSED_WARNING (sqlquery);
    throw qt_gsi::AbstractMethodCalledException("reset");
  }

  virtual bool reset(const QString &sqlquery)
  {
    if (cb_reset_2025_0.can_issue()) {
      return cb_reset_2025_0.issue<QSqlResult_Adaptor, bool, const QString &>(&QSqlResult_Adaptor::cbs_reset_2025_0, sqlquery);
    } else {
      throw qt_gsi::AbstractMethodCalledException("reset");
    }
  }

  //  [adaptor impl] bool QSqlResult::savePrepare(const QString &sqlquery)
  bool cbs_savePrepare_2025_0(const QString &sqlquery)
  {
    return QSqlResult::savePrepare(sqlquery);
  }

  virtual bool savePrepare(const QString &sqlquery)
  {
    if (cb_savePrepare_2025_0.can_issue()) {
      return cb_savePrepare_2025_0.issue<QSqlResult_Adaptor, bool, const QString &>(&QSqlResult_Adaptor::cbs_savePrepare_2025_0, sqlquery);
    } else {
      return QSqlResult::savePrepare(sqlquery);
    }
  }

  //  [adaptor impl] void QSqlResult::setActive(bool a)
  void cbs_setActive_864_0(bool a)
  {
    QSqlResult::setActive(a);
  }

  virtual void setActive(bool a)
  {
    if (cb_setActive_864_0.can_issue()) {
      cb_setActive_864_0.issue<QSqlResult_Adaptor, bool>(&QSqlResult_Adaptor::cbs_setActive_864_0, a);
    } else {
      QSqlResult::setActive(a);
    }
  }

  //  [adaptor impl] void QSqlResult::setAt(int at)
  void cbs_setAt_767_0(int at)
  {
    QSqlResult::setAt(at);
  }

  virtual void setAt(int at)
  {
    if (cb_setAt_767_0.can_issue()) {
      cb_setAt_767_0.issue<QSqlResult_Adaptor, int>(&QSqlResult_Adaptor::cbs_setAt_767_0, at);
    } else {
      QSqlResult::setAt(at);
    }
  }

  //  [adaptor impl] void QSqlResult::setForwardOnly(bool forward)
  void cbs_setForwardOnly_864_0(bool forward)
  {
    QSqlResult::setForwardOnly(forward);
  }

  virtual void setForwardOnly(bool forward)
  {
    if (cb_setForwardOnly_864_0.can_issue()) {
      cb_setForwardOnly_864_0.issue<QSqlResult_Adaptor, bool>(&QSqlResult_Adaptor::cbs_setForwardOnly_864_0, forward);
    } else {
      QSqlResult::setForwardOnly(forward);
    }
  }

  //  [adaptor impl] void QSqlResult::setLastError(const QSqlError &e)
  void cbs_setLastError_2220_0(const QSqlError &e)
  {
    QSqlResult::setLastError(e);
  }

  virtual void setLastError(const QSqlError &e)
  {
    if (cb_setLastError_2220_0.can_issue()) {
      cb_setLastError_2220_0.issue<QSqlResult_Adaptor, const QSqlError &>(&QSqlResult_Adaptor::cbs_setLastError_2220_0, e);
    } else {
      QSqlResult::setLastError(e);
    }
  }

  //  [adaptor impl] void QSqlResult::setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy policy)
  void cbs_setNumericalPrecisionPolicy_3429_0(const qt_gsi::Converter<QSql::NumericalPrecisionPolicy>::target_type & policy)
  {
    QSqlResult::setNumericalPrecisionPolicy(qt_gsi::QtToCppAdaptor<QSql::NumericalPrecisionPolicy>(policy).cref());
  }

  virtual void setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy policy)
  {
    if (cb_setNumericalPrecisionPolicy_3429_0.can_issue()) {
      cb_setNumericalPrecisionPolicy_3429_0.issue<QSqlResult_Adaptor, const qt_gsi::Converter<QSql::NumericalPrecisionPolicy>::target_type &>(&QSqlResult_Adaptor::cbs_setNumericalPrecisionPolicy_3429_0, qt_gsi::CppToQtAdaptor<QSql::NumericalPrecisionPolicy>(policy));
    } else {
      QSqlResult::setNumericalPrecisionPolicy(policy);
    }
  }

  //  [adaptor impl] void QSqlResult::setQuery(const QString &query)
  void cbs_setQuery_2025_0(const QString &query)
  {
    QSqlResult::setQuery(query);
  }

  virtual void setQuery(const QString &query)
  {
    if (cb_setQuery_2025_0.can_issue()) {
      cb_setQuery_2025_0.issue<QSqlResult_Adaptor, const QString &>(&QSqlResult_Adaptor::cbs_setQuery_2025_0, query);
    } else {
      QSqlResult::setQuery(query);
    }
  }

  //  [adaptor impl] void QSqlResult::setSelect(bool s)
  void cbs_setSelect_864_0(bool s)
  {
    QSqlResult::setSelect(s);
  }

  virtual void setSelect(bool s)
  {
    if (cb_setSelect_864_0.can_issue()) {
      cb_setSelect_864_0.issue<QSqlResult_Adaptor, bool>(&QSqlResult_Adaptor::cbs_setSelect_864_0, s);
    } else {
      QSqlResult::setSelect(s);
    }
  }

  //  [adaptor impl] int QSqlResult::size()
  int cbs_size_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("size");
  }

  virtual int size()
  {
    if (cb_size_0_0.can_issue()) {
      return cb_size_0_0.issue<QSqlResult_Adaptor, int>(&QSqlResult_Adaptor::cbs_size_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("size");
    }
  }

  //  [adaptor impl] void QSqlResult::virtual_hook(int id, void *data)
  void cbs_virtual_hook_1715_0(int id, void *data)
  {
    QSqlResult::virtual_hook(id, data);
  }

  virtual void virtual_hook(int id, void *data)
  {
    if (cb_virtual_hook_1715_0.can_issue()) {
      cb_virtual_hook_1715_0.issue<QSqlResult_Adaptor, int, void *>(&QSqlResult_Adaptor::cbs_virtual_hook_1715_0, id, data);
    } else {
      QSqlResult::virtual_hook(id, data);
    }
  }

  gsi::Callback cb_handle_c0_0;
  gsi::Callback cb_bindValue_5596_0;
  gsi::Callback cb_bindValue_6854_0;
  gsi::Callback cb_data_767_0;
  gsi::Callback cb_detachFromResultSet_0_0;
  gsi::Callback cb_exec_0_0;
  gsi::Callback cb_execBatch_864_1;
  gsi::Callback cb_fetch_767_0;
  gsi::Callback cb_fetchFirst_0_0;
  gsi::Callback cb_fetchLast_0_0;
  gsi::Callback cb_fetchNext_0_0;
  gsi::Callback cb_fetchPrevious_0_0;
  gsi::Callback cb_isNull_767_0;
  gsi::Callback cb_lastInsertId_c0_0;
  gsi::Callback cb_nextResult_0_0;
  gsi::Callback cb_numRowsAffected_0_0;
  gsi::Callback cb_prepare_2025_0;
  gsi::Callback cb_record_c0_0;
  gsi::Callback cb_reset_2025_0;
  gsi::Callback cb_savePrepare_2025_0;
  gsi::Callback cb_setActive_864_0;
  gsi::Callback cb_setAt_767_0;
  gsi::Callback cb_setForwardOnly_864_0;
  gsi::Callback cb_setLastError_2220_0;
  gsi::Callback cb_setNumericalPrecisionPolicy_3429_0;
  gsi::Callback cb_setQuery_2025_0;
  gsi::Callback cb_setSelect_864_0;
  gsi::Callback cb_size_0_0;
  gsi::Callback cb_virtual_hook_1715_0;
};

QSqlResult_Adaptor::~QSqlResult_Adaptor() { }

// exposed void QSqlResult::addBindValue(const QVariant &val, QFlags<QSql::ParamTypeFlag> type)

static void _init_fp_addBindValue_4937 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("val");
  decl->add_arg<const QVariant & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("type");
  decl->add_arg<QFlags<QSql::ParamTypeFlag> > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_addBindValue_4937 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVariant &arg1 = gsi::arg_reader<const QVariant & >() (args, heap);
  QFlags<QSql::ParamTypeFlag> arg2 = gsi::arg_reader<QFlags<QSql::ParamTypeFlag> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlResult_Adaptor *)cls)->fp_QSqlResult_addBindValue_4937 (arg1, arg2);
}


// exposed int QSqlResult::at()

static void _init_fp_at_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_at_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSqlResult_Adaptor *)cls)->fp_QSqlResult_at_c0 ());
}


// void QSqlResult::bindValue(int pos, const QVariant &val, QFlags<QSql::ParamTypeFlag> type)

static void _init_cbs_bindValue_5596_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("val");
  decl->add_arg<const QVariant & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("type");
  decl->add_arg<QFlags<QSql::ParamTypeFlag> > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_bindValue_5596_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const QVariant &arg2 = args.read<const QVariant & > (heap);
  QFlags<QSql::ParamTypeFlag> arg3 = args.read<QFlags<QSql::ParamTypeFlag> > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlResult_Adaptor *)cls)->cbs_bindValue_5596_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_bindValue_5596_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlResult_Adaptor *)cls)->cb_bindValue_5596_0 = cb;
}


// void QSqlResult::bindValue(const QString &placeholder, const QVariant &val, QFlags<QSql::ParamTypeFlag> type)

static void _init_cbs_bindValue_6854_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("placeholder");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("val");
  decl->add_arg<const QVariant & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("type");
  decl->add_arg<QFlags<QSql::ParamTypeFlag> > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_bindValue_6854_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  const QVariant &arg2 = args.read<const QVariant & > (heap);
  QFlags<QSql::ParamTypeFlag> arg3 = args.read<QFlags<QSql::ParamTypeFlag> > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlResult_Adaptor *)cls)->cbs_bindValue_6854_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_bindValue_6854_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlResult_Adaptor *)cls)->cb_bindValue_6854_0 = cb;
}


// exposed QFlags<QSql::ParamTypeFlag> QSqlResult::bindValueType(const QString &placeholder)

static void _init_fp_bindValueType_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("placeholder");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QFlags<QSql::ParamTypeFlag> > ();
}

static void _call_fp_bindValueType_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QFlags<QSql::ParamTypeFlag> > ((QFlags<QSql::ParamTypeFlag>)((QSqlResult_Adaptor *)cls)->fp_QSqlResult_bindValueType_c2025 (arg1));
}


// exposed QFlags<QSql::ParamTypeFlag> QSqlResult::bindValueType(int pos)

static void _init_fp_bindValueType_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QFlags<QSql::ParamTypeFlag> > ();
}

static void _call_fp_bindValueType_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QFlags<QSql::ParamTypeFlag> > ((QFlags<QSql::ParamTypeFlag>)((QSqlResult_Adaptor *)cls)->fp_QSqlResult_bindValueType_c767 (arg1));
}


// exposed QSqlResult::BindingSyntax QSqlResult::bindingSyntax()

static void _init_fp_bindingSyntax_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<unsigned int > ();
}

static void _call_fp_bindingSyntax_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<unsigned int > ((unsigned int)((QSqlResult_Adaptor *)cls)->fp_QSqlResult_bindingSyntax_c0 ());
}


// exposed QVariant QSqlResult::boundValue(const QString &placeholder)

static void _init_fp_boundValue_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("placeholder");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_fp_boundValue_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QVariant > ((QVariant)((QSqlResult_Adaptor *)cls)->fp_QSqlResult_boundValue_c2025 (arg1));
}


// exposed QVariant QSqlResult::boundValue(int pos)

static void _init_fp_boundValue_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_fp_boundValue_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QVariant > ((QVariant)((QSqlResult_Adaptor *)cls)->fp_QSqlResult_boundValue_c767 (arg1));
}


// exposed int QSqlResult::boundValueCount()

static void _init_fp_boundValueCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_boundValueCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSqlResult_Adaptor *)cls)->fp_QSqlResult_boundValueCount_c0 ());
}


// exposed QString QSqlResult::boundValueName(int pos)

static void _init_fp_boundValueName_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_fp_boundValueName_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)((QSqlResult_Adaptor *)cls)->fp_QSqlResult_boundValueName_c767 (arg1));
}


// exposed QVector<QVariant> &QSqlResult::boundValues()

static void _init_fp_boundValues_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QVector<QVariant> & > ();
}

static void _call_fp_boundValues_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QVector<QVariant> & > ((QVector<QVariant> &)((QSqlResult_Adaptor *)cls)->fp_QSqlResult_boundValues_c0 ());
}


// exposed void QSqlResult::clear()

static void _init_fp_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_clear_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlResult_Adaptor *)cls)->fp_QSqlResult_clear_0 ();
}


// QVariant QSqlResult::data(int i)

static void _init_cbs_data_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_data_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<QVariant > ((QVariant)((QSqlResult_Adaptor *)cls)->cbs_data_767_0 (arg1));
}

static void _set_callback_cbs_data_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlResult_Adaptor *)cls)->cb_data_767_0 = cb;
}


// void QSqlResult::detachFromResultSet()

static void _init_cbs_detachFromResultSet_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_detachFromResultSet_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlResult_Adaptor *)cls)->cbs_detachFromResultSet_0_0 ();
}

static void _set_callback_cbs_detachFromResultSet_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlResult_Adaptor *)cls)->cb_detachFromResultSet_0_0 = cb;
}


// exposed const QSqlDriver *QSqlResult::driver()

static void _init_fp_driver_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QSqlDriver * > ();
}

static void _call_fp_driver_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QSqlDriver * > ((const QSqlDriver *)((QSqlResult_Adaptor *)cls)->fp_QSqlResult_driver_c0 ());
}


// bool QSqlResult::exec()

static void _init_cbs_exec_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_exec_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSqlResult_Adaptor *)cls)->cbs_exec_0_0 ());
}

static void _set_callback_cbs_exec_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlResult_Adaptor *)cls)->cb_exec_0_0 = cb;
}


// bool QSqlResult::execBatch(bool arrayBind)

static void _init_cbs_execBatch_864_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arrayBind");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_execBatch_864_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ret.write<bool > ((bool)((QSqlResult_Adaptor *)cls)->cbs_execBatch_864_1 (arg1));
}

static void _set_callback_cbs_execBatch_864_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlResult_Adaptor *)cls)->cb_execBatch_864_1 = cb;
}


// exposed QString QSqlResult::executedQuery()

static void _init_fp_executedQuery_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_fp_executedQuery_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QSqlResult_Adaptor *)cls)->fp_QSqlResult_executedQuery_c0 ());
}


// bool QSqlResult::fetch(int i)

static void _init_cbs_fetch_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_fetch_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<bool > ((bool)((QSqlResult_Adaptor *)cls)->cbs_fetch_767_0 (arg1));
}

static void _set_callback_cbs_fetch_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlResult_Adaptor *)cls)->cb_fetch_767_0 = cb;
}


// bool QSqlResult::fetchFirst()

static void _init_cbs_fetchFirst_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_fetchFirst_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSqlResult_Adaptor *)cls)->cbs_fetchFirst_0_0 ());
}

static void _set_callback_cbs_fetchFirst_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlResult_Adaptor *)cls)->cb_fetchFirst_0_0 = cb;
}


// bool QSqlResult::fetchLast()

static void _init_cbs_fetchLast_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_fetchLast_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSqlResult_Adaptor *)cls)->cbs_fetchLast_0_0 ());
}

static void _set_callback_cbs_fetchLast_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlResult_Adaptor *)cls)->cb_fetchLast_0_0 = cb;
}


// bool QSqlResult::fetchNext()

static void _init_cbs_fetchNext_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_fetchNext_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSqlResult_Adaptor *)cls)->cbs_fetchNext_0_0 ());
}

static void _set_callback_cbs_fetchNext_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlResult_Adaptor *)cls)->cb_fetchNext_0_0 = cb;
}


// bool QSqlResult::fetchPrevious()

static void _init_cbs_fetchPrevious_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_fetchPrevious_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSqlResult_Adaptor *)cls)->cbs_fetchPrevious_0_0 ());
}

static void _set_callback_cbs_fetchPrevious_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlResult_Adaptor *)cls)->cb_fetchPrevious_0_0 = cb;
}


// QVariant QSqlResult::handle()

static void _init_cbs_handle_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QVariant > ();
}

static void _call_cbs_handle_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QVariant > ((QVariant)((QSqlResult_Adaptor *)cls)->cbs_handle_c0_0 ());
}

static void _set_callback_cbs_handle_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlResult_Adaptor *)cls)->cb_handle_c0_0 = cb;
}


// exposed bool QSqlResult::hasOutValues()

static void _init_fp_hasOutValues_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_hasOutValues_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSqlResult_Adaptor *)cls)->fp_QSqlResult_hasOutValues_c0 ());
}


// exposed bool QSqlResult::isActive()

static void _init_fp_isActive_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_isActive_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSqlResult_Adaptor *)cls)->fp_QSqlResult_isActive_c0 ());
}


// exposed bool QSqlResult::isForwardOnly()

static void _init_fp_isForwardOnly_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_isForwardOnly_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSqlResult_Adaptor *)cls)->fp_QSqlResult_isForwardOnly_c0 ());
}


// bool QSqlResult::isNull(int i)

static void _init_cbs_isNull_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_isNull_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<bool > ((bool)((QSqlResult_Adaptor *)cls)->cbs_isNull_767_0 (arg1));
}

static void _set_callback_cbs_isNull_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlResult_Adaptor *)cls)->cb_isNull_767_0 = cb;
}


// exposed bool QSqlResult::isSelect()

static void _init_fp_isSelect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_isSelect_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSqlResult_Adaptor *)cls)->fp_QSqlResult_isSelect_c0 ());
}


// exposed bool QSqlResult::isValid()

static void _init_fp_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_isValid_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSqlResult_Adaptor *)cls)->fp_QSqlResult_isValid_c0 ());
}


// exposed QSqlError QSqlResult::lastError()

static void _init_fp_lastError_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSqlError > ();
}

static void _call_fp_lastError_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSqlError > ((QSqlError)((QSqlResult_Adaptor *)cls)->fp_QSqlResult_lastError_c0 ());
}


// QVariant QSqlResult::lastInsertId()

static void _init_cbs_lastInsertId_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QVariant > ();
}

static void _call_cbs_lastInsertId_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QVariant > ((QVariant)((QSqlResult_Adaptor *)cls)->cbs_lastInsertId_c0_0 ());
}

static void _set_callback_cbs_lastInsertId_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlResult_Adaptor *)cls)->cb_lastInsertId_c0_0 = cb;
}


// exposed QString QSqlResult::lastQuery()

static void _init_fp_lastQuery_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_fp_lastQuery_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QSqlResult_Adaptor *)cls)->fp_QSqlResult_lastQuery_c0 ());
}


// bool QSqlResult::nextResult()

static void _init_cbs_nextResult_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_nextResult_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSqlResult_Adaptor *)cls)->cbs_nextResult_0_0 ());
}

static void _set_callback_cbs_nextResult_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlResult_Adaptor *)cls)->cb_nextResult_0_0 = cb;
}


// int QSqlResult::numRowsAffected()

static void _init_cbs_numRowsAffected_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_numRowsAffected_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSqlResult_Adaptor *)cls)->cbs_numRowsAffected_0_0 ());
}

static void _set_callback_cbs_numRowsAffected_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlResult_Adaptor *)cls)->cb_numRowsAffected_0_0 = cb;
}


// exposed QSql::NumericalPrecisionPolicy QSqlResult::numericalPrecisionPolicy()

static void _init_fp_numericalPrecisionPolicy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QSql::NumericalPrecisionPolicy>::target_type > ();
}

static void _call_fp_numericalPrecisionPolicy_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QSql::NumericalPrecisionPolicy>::target_type > ((qt_gsi::Converter<QSql::NumericalPrecisionPolicy>::target_type)((QSqlResult_Adaptor *)cls)->fp_QSqlResult_numericalPrecisionPolicy_c0 ());
}


// bool QSqlResult::prepare(const QString &query)

static void _init_cbs_prepare_2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_prepare_2025_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<bool > ((bool)((QSqlResult_Adaptor *)cls)->cbs_prepare_2025_0 (arg1));
}

static void _set_callback_cbs_prepare_2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlResult_Adaptor *)cls)->cb_prepare_2025_0 = cb;
}


// QSqlRecord QSqlResult::record()

static void _init_cbs_record_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSqlRecord > ();
}

static void _call_cbs_record_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSqlRecord > ((QSqlRecord)((QSqlResult_Adaptor *)cls)->cbs_record_c0_0 ());
}

static void _set_callback_cbs_record_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlResult_Adaptor *)cls)->cb_record_c0_0 = cb;
}


// bool QSqlResult::reset(const QString &sqlquery)

static void _init_cbs_reset_2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sqlquery");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_reset_2025_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<bool > ((bool)((QSqlResult_Adaptor *)cls)->cbs_reset_2025_0 (arg1));
}

static void _set_callback_cbs_reset_2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlResult_Adaptor *)cls)->cb_reset_2025_0 = cb;
}


// exposed void QSqlResult::resetBindCount()

static void _init_fp_resetBindCount_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_resetBindCount_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlResult_Adaptor *)cls)->fp_QSqlResult_resetBindCount_0 ();
}


// bool QSqlResult::savePrepare(const QString &sqlquery)

static void _init_cbs_savePrepare_2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sqlquery");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_savePrepare_2025_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<bool > ((bool)((QSqlResult_Adaptor *)cls)->cbs_savePrepare_2025_0 (arg1));
}

static void _set_callback_cbs_savePrepare_2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlResult_Adaptor *)cls)->cb_savePrepare_2025_0 = cb;
}


// void QSqlResult::setActive(bool a)

static void _init_cbs_setActive_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("a");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setActive_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlResult_Adaptor *)cls)->cbs_setActive_864_0 (arg1);
}

static void _set_callback_cbs_setActive_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlResult_Adaptor *)cls)->cb_setActive_864_0 = cb;
}


// void QSqlResult::setAt(int at)

static void _init_cbs_setAt_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("at");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setAt_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlResult_Adaptor *)cls)->cbs_setAt_767_0 (arg1);
}

static void _set_callback_cbs_setAt_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlResult_Adaptor *)cls)->cb_setAt_767_0 = cb;
}


// void QSqlResult::setForwardOnly(bool forward)

static void _init_cbs_setForwardOnly_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("forward");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setForwardOnly_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlResult_Adaptor *)cls)->cbs_setForwardOnly_864_0 (arg1);
}

static void _set_callback_cbs_setForwardOnly_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlResult_Adaptor *)cls)->cb_setForwardOnly_864_0 = cb;
}


// void QSqlResult::setLastError(const QSqlError &e)

static void _init_cbs_setLastError_2220_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<const QSqlError & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setLastError_2220_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSqlError &arg1 = args.read<const QSqlError & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlResult_Adaptor *)cls)->cbs_setLastError_2220_0 (arg1);
}

static void _set_callback_cbs_setLastError_2220_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlResult_Adaptor *)cls)->cb_setLastError_2220_0 = cb;
}


// void QSqlResult::setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy policy)

static void _init_cbs_setNumericalPrecisionPolicy_3429_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("policy");
  decl->add_arg<const qt_gsi::Converter<QSql::NumericalPrecisionPolicy>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setNumericalPrecisionPolicy_3429_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QSql::NumericalPrecisionPolicy>::target_type & arg1 = args.read<const qt_gsi::Converter<QSql::NumericalPrecisionPolicy>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlResult_Adaptor *)cls)->cbs_setNumericalPrecisionPolicy_3429_0 (arg1);
}

static void _set_callback_cbs_setNumericalPrecisionPolicy_3429_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlResult_Adaptor *)cls)->cb_setNumericalPrecisionPolicy_3429_0 = cb;
}


// void QSqlResult::setQuery(const QString &query)

static void _init_cbs_setQuery_2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setQuery_2025_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlResult_Adaptor *)cls)->cbs_setQuery_2025_0 (arg1);
}

static void _set_callback_cbs_setQuery_2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlResult_Adaptor *)cls)->cb_setQuery_2025_0 = cb;
}


// void QSqlResult::setSelect(bool s)

static void _init_cbs_setSelect_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setSelect_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlResult_Adaptor *)cls)->cbs_setSelect_864_0 (arg1);
}

static void _set_callback_cbs_setSelect_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlResult_Adaptor *)cls)->cb_setSelect_864_0 = cb;
}


// int QSqlResult::size()

static void _init_cbs_size_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_size_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSqlResult_Adaptor *)cls)->cbs_size_0_0 ());
}

static void _set_callback_cbs_size_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlResult_Adaptor *)cls)->cb_size_0_0 = cb;
}


// void QSqlResult::virtual_hook(int id, void *data)

static void _init_cbs_virtual_hook_1715_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("data");
  decl->add_arg<void * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_virtual_hook_1715_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  void *arg2 = args.read<void * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlResult_Adaptor *)cls)->cbs_virtual_hook_1715_0 (arg1, arg2);
}

static void _set_callback_cbs_virtual_hook_1715_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlResult_Adaptor *)cls)->cb_virtual_hook_1715_0 = cb;
}


namespace gsi
{

gsi::Class<QSqlResult> &qtdecl_QSqlResult ();

static gsi::Methods methods_QSqlResult_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod ("*addBindValue", "@brief Method void QSqlResult::addBindValue(const QVariant &val, QFlags<QSql::ParamTypeFlag> type)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_addBindValue_4937, &_call_fp_addBindValue_4937);
  methods += new qt_gsi::GenericMethod ("*at", "@brief Method int QSqlResult::at()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_at_c0, &_call_fp_at_c0);
  methods += new qt_gsi::GenericMethod ("*bindValue", "@brief Virtual method void QSqlResult::bindValue(int pos, const QVariant &val, QFlags<QSql::ParamTypeFlag> type)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_bindValue_5596_0, &_call_cbs_bindValue_5596_0);
  methods += new qt_gsi::GenericMethod ("*bindValue", "@hide", false, &_init_cbs_bindValue_5596_0, &_call_cbs_bindValue_5596_0, &_set_callback_cbs_bindValue_5596_0);
  methods += new qt_gsi::GenericMethod ("*bindValue", "@brief Virtual method void QSqlResult::bindValue(const QString &placeholder, const QVariant &val, QFlags<QSql::ParamTypeFlag> type)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_bindValue_6854_0, &_call_cbs_bindValue_6854_0);
  methods += new qt_gsi::GenericMethod ("*bindValue", "@hide", false, &_init_cbs_bindValue_6854_0, &_call_cbs_bindValue_6854_0, &_set_callback_cbs_bindValue_6854_0);
  methods += new qt_gsi::GenericMethod ("*bindValueType", "@brief Method QFlags<QSql::ParamTypeFlag> QSqlResult::bindValueType(const QString &placeholder)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_bindValueType_c2025, &_call_fp_bindValueType_c2025);
  methods += new qt_gsi::GenericMethod ("*bindValueType", "@brief Method QFlags<QSql::ParamTypeFlag> QSqlResult::bindValueType(int pos)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_bindValueType_c767, &_call_fp_bindValueType_c767);
  methods += new qt_gsi::GenericMethod ("*bindingSyntax", "@brief Method QSqlResult::BindingSyntax QSqlResult::bindingSyntax()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_bindingSyntax_c0, &_call_fp_bindingSyntax_c0);
  methods += new qt_gsi::GenericMethod ("*boundValue", "@brief Method QVariant QSqlResult::boundValue(const QString &placeholder)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_boundValue_c2025, &_call_fp_boundValue_c2025);
  methods += new qt_gsi::GenericMethod ("*boundValue", "@brief Method QVariant QSqlResult::boundValue(int pos)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_boundValue_c767, &_call_fp_boundValue_c767);
  methods += new qt_gsi::GenericMethod ("*boundValueCount", "@brief Method int QSqlResult::boundValueCount()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_boundValueCount_c0, &_call_fp_boundValueCount_c0);
  methods += new qt_gsi::GenericMethod ("*boundValueName", "@brief Method QString QSqlResult::boundValueName(int pos)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_boundValueName_c767, &_call_fp_boundValueName_c767);
  methods += new qt_gsi::GenericMethod ("*boundValues", "@brief Method QVector<QVariant> &QSqlResult::boundValues()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_boundValues_c0, &_call_fp_boundValues_c0);
  methods += new qt_gsi::GenericMethod ("*clear", "@brief Method void QSqlResult::clear()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_clear_0, &_call_fp_clear_0);
  methods += new qt_gsi::GenericMethod ("*data", "@brief Virtual method QVariant QSqlResult::data(int i)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_data_767_0, &_call_cbs_data_767_0);
  methods += new qt_gsi::GenericMethod ("*data", "@hide", false, &_init_cbs_data_767_0, &_call_cbs_data_767_0, &_set_callback_cbs_data_767_0);
  methods += new qt_gsi::GenericMethod ("*detachFromResultSet", "@brief Virtual method void QSqlResult::detachFromResultSet()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_detachFromResultSet_0_0, &_call_cbs_detachFromResultSet_0_0);
  methods += new qt_gsi::GenericMethod ("*detachFromResultSet", "@hide", false, &_init_cbs_detachFromResultSet_0_0, &_call_cbs_detachFromResultSet_0_0, &_set_callback_cbs_detachFromResultSet_0_0);
  methods += new qt_gsi::GenericMethod ("*driver", "@brief Method const QSqlDriver *QSqlResult::driver()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_driver_c0, &_call_fp_driver_c0);
  methods += new qt_gsi::GenericMethod ("*exec", "@brief Virtual method bool QSqlResult::exec()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_exec_0_0, &_call_cbs_exec_0_0);
  methods += new qt_gsi::GenericMethod ("*exec", "@hide", false, &_init_cbs_exec_0_0, &_call_cbs_exec_0_0, &_set_callback_cbs_exec_0_0);
  methods += new qt_gsi::GenericMethod ("*execBatch", "@brief Virtual method bool QSqlResult::execBatch(bool arrayBind)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_execBatch_864_1, &_call_cbs_execBatch_864_1);
  methods += new qt_gsi::GenericMethod ("*execBatch", "@hide", false, &_init_cbs_execBatch_864_1, &_call_cbs_execBatch_864_1, &_set_callback_cbs_execBatch_864_1);
  methods += new qt_gsi::GenericMethod ("*executedQuery", "@brief Method QString QSqlResult::executedQuery()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_executedQuery_c0, &_call_fp_executedQuery_c0);
  methods += new qt_gsi::GenericMethod ("*fetch", "@brief Virtual method bool QSqlResult::fetch(int i)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fetch_767_0, &_call_cbs_fetch_767_0);
  methods += new qt_gsi::GenericMethod ("*fetch", "@hide", false, &_init_cbs_fetch_767_0, &_call_cbs_fetch_767_0, &_set_callback_cbs_fetch_767_0);
  methods += new qt_gsi::GenericMethod ("*fetchFirst", "@brief Virtual method bool QSqlResult::fetchFirst()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fetchFirst_0_0, &_call_cbs_fetchFirst_0_0);
  methods += new qt_gsi::GenericMethod ("*fetchFirst", "@hide", false, &_init_cbs_fetchFirst_0_0, &_call_cbs_fetchFirst_0_0, &_set_callback_cbs_fetchFirst_0_0);
  methods += new qt_gsi::GenericMethod ("*fetchLast", "@brief Virtual method bool QSqlResult::fetchLast()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fetchLast_0_0, &_call_cbs_fetchLast_0_0);
  methods += new qt_gsi::GenericMethod ("*fetchLast", "@hide", false, &_init_cbs_fetchLast_0_0, &_call_cbs_fetchLast_0_0, &_set_callback_cbs_fetchLast_0_0);
  methods += new qt_gsi::GenericMethod ("*fetchNext", "@brief Virtual method bool QSqlResult::fetchNext()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fetchNext_0_0, &_call_cbs_fetchNext_0_0);
  methods += new qt_gsi::GenericMethod ("*fetchNext", "@hide", false, &_init_cbs_fetchNext_0_0, &_call_cbs_fetchNext_0_0, &_set_callback_cbs_fetchNext_0_0);
  methods += new qt_gsi::GenericMethod ("*fetchPrevious", "@brief Virtual method bool QSqlResult::fetchPrevious()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fetchPrevious_0_0, &_call_cbs_fetchPrevious_0_0);
  methods += new qt_gsi::GenericMethod ("*fetchPrevious", "@hide", false, &_init_cbs_fetchPrevious_0_0, &_call_cbs_fetchPrevious_0_0, &_set_callback_cbs_fetchPrevious_0_0);
  methods += new qt_gsi::GenericMethod ("handle", "@brief Virtual method QVariant QSqlResult::handle()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_handle_c0_0, &_call_cbs_handle_c0_0);
  methods += new qt_gsi::GenericMethod ("handle", "@hide", true, &_init_cbs_handle_c0_0, &_call_cbs_handle_c0_0, &_set_callback_cbs_handle_c0_0);
  methods += new qt_gsi::GenericMethod ("*hasOutValues", "@brief Method bool QSqlResult::hasOutValues()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_hasOutValues_c0, &_call_fp_hasOutValues_c0);
  methods += new qt_gsi::GenericMethod ("*isActive", "@brief Method bool QSqlResult::isActive()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isActive_c0, &_call_fp_isActive_c0);
  methods += new qt_gsi::GenericMethod ("*isForwardOnly", "@brief Method bool QSqlResult::isForwardOnly()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isForwardOnly_c0, &_call_fp_isForwardOnly_c0);
  methods += new qt_gsi::GenericMethod ("*isNull", "@brief Virtual method bool QSqlResult::isNull(int i)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_isNull_767_0, &_call_cbs_isNull_767_0);
  methods += new qt_gsi::GenericMethod ("*isNull", "@hide", false, &_init_cbs_isNull_767_0, &_call_cbs_isNull_767_0, &_set_callback_cbs_isNull_767_0);
  methods += new qt_gsi::GenericMethod ("*isSelect", "@brief Method bool QSqlResult::isSelect()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSelect_c0, &_call_fp_isSelect_c0);
  methods += new qt_gsi::GenericMethod ("*isValid", "@brief Method bool QSqlResult::isValid()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isValid_c0, &_call_fp_isValid_c0);
  methods += new qt_gsi::GenericMethod ("*lastError", "@brief Method QSqlError QSqlResult::lastError()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_lastError_c0, &_call_fp_lastError_c0);
  methods += new qt_gsi::GenericMethod ("*lastInsertId", "@brief Virtual method QVariant QSqlResult::lastInsertId()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_lastInsertId_c0_0, &_call_cbs_lastInsertId_c0_0);
  methods += new qt_gsi::GenericMethod ("*lastInsertId", "@hide", true, &_init_cbs_lastInsertId_c0_0, &_call_cbs_lastInsertId_c0_0, &_set_callback_cbs_lastInsertId_c0_0);
  methods += new qt_gsi::GenericMethod ("*lastQuery", "@brief Method QString QSqlResult::lastQuery()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_lastQuery_c0, &_call_fp_lastQuery_c0);
  methods += new qt_gsi::GenericMethod ("*nextResult", "@brief Virtual method bool QSqlResult::nextResult()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_nextResult_0_0, &_call_cbs_nextResult_0_0);
  methods += new qt_gsi::GenericMethod ("*nextResult", "@hide", false, &_init_cbs_nextResult_0_0, &_call_cbs_nextResult_0_0, &_set_callback_cbs_nextResult_0_0);
  methods += new qt_gsi::GenericMethod ("*numRowsAffected", "@brief Virtual method int QSqlResult::numRowsAffected()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_numRowsAffected_0_0, &_call_cbs_numRowsAffected_0_0);
  methods += new qt_gsi::GenericMethod ("*numRowsAffected", "@hide", false, &_init_cbs_numRowsAffected_0_0, &_call_cbs_numRowsAffected_0_0, &_set_callback_cbs_numRowsAffected_0_0);
  methods += new qt_gsi::GenericMethod ("*numericalPrecisionPolicy", "@brief Method QSql::NumericalPrecisionPolicy QSqlResult::numericalPrecisionPolicy()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_numericalPrecisionPolicy_c0, &_call_fp_numericalPrecisionPolicy_c0);
  methods += new qt_gsi::GenericMethod ("*prepare", "@brief Virtual method bool QSqlResult::prepare(const QString &query)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_prepare_2025_0, &_call_cbs_prepare_2025_0);
  methods += new qt_gsi::GenericMethod ("*prepare", "@hide", false, &_init_cbs_prepare_2025_0, &_call_cbs_prepare_2025_0, &_set_callback_cbs_prepare_2025_0);
  methods += new qt_gsi::GenericMethod ("*record", "@brief Virtual method QSqlRecord QSqlResult::record()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_record_c0_0, &_call_cbs_record_c0_0);
  methods += new qt_gsi::GenericMethod ("*record", "@hide", true, &_init_cbs_record_c0_0, &_call_cbs_record_c0_0, &_set_callback_cbs_record_c0_0);
  methods += new qt_gsi::GenericMethod ("*reset", "@brief Virtual method bool QSqlResult::reset(const QString &sqlquery)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_reset_2025_0, &_call_cbs_reset_2025_0);
  methods += new qt_gsi::GenericMethod ("*reset", "@hide", false, &_init_cbs_reset_2025_0, &_call_cbs_reset_2025_0, &_set_callback_cbs_reset_2025_0);
  methods += new qt_gsi::GenericMethod ("*resetBindCount", "@brief Method void QSqlResult::resetBindCount()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resetBindCount_0, &_call_fp_resetBindCount_0);
  methods += new qt_gsi::GenericMethod ("*savePrepare", "@brief Virtual method bool QSqlResult::savePrepare(const QString &sqlquery)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_savePrepare_2025_0, &_call_cbs_savePrepare_2025_0);
  methods += new qt_gsi::GenericMethod ("*savePrepare", "@hide", false, &_init_cbs_savePrepare_2025_0, &_call_cbs_savePrepare_2025_0, &_set_callback_cbs_savePrepare_2025_0);
  methods += new qt_gsi::GenericMethod ("*setActive", "@brief Virtual method void QSqlResult::setActive(bool a)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setActive_864_0, &_call_cbs_setActive_864_0);
  methods += new qt_gsi::GenericMethod ("*setActive", "@hide", false, &_init_cbs_setActive_864_0, &_call_cbs_setActive_864_0, &_set_callback_cbs_setActive_864_0);
  methods += new qt_gsi::GenericMethod ("*setAt", "@brief Virtual method void QSqlResult::setAt(int at)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setAt_767_0, &_call_cbs_setAt_767_0);
  methods += new qt_gsi::GenericMethod ("*setAt", "@hide", false, &_init_cbs_setAt_767_0, &_call_cbs_setAt_767_0, &_set_callback_cbs_setAt_767_0);
  methods += new qt_gsi::GenericMethod ("*setForwardOnly", "@brief Virtual method void QSqlResult::setForwardOnly(bool forward)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setForwardOnly_864_0, &_call_cbs_setForwardOnly_864_0);
  methods += new qt_gsi::GenericMethod ("*setForwardOnly", "@hide", false, &_init_cbs_setForwardOnly_864_0, &_call_cbs_setForwardOnly_864_0, &_set_callback_cbs_setForwardOnly_864_0);
  methods += new qt_gsi::GenericMethod ("*setLastError", "@brief Virtual method void QSqlResult::setLastError(const QSqlError &e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setLastError_2220_0, &_call_cbs_setLastError_2220_0);
  methods += new qt_gsi::GenericMethod ("*setLastError", "@hide", false, &_init_cbs_setLastError_2220_0, &_call_cbs_setLastError_2220_0, &_set_callback_cbs_setLastError_2220_0);
  methods += new qt_gsi::GenericMethod ("*setNumericalPrecisionPolicy", "@brief Virtual method void QSqlResult::setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy policy)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setNumericalPrecisionPolicy_3429_0, &_call_cbs_setNumericalPrecisionPolicy_3429_0);
  methods += new qt_gsi::GenericMethod ("*setNumericalPrecisionPolicy", "@hide", false, &_init_cbs_setNumericalPrecisionPolicy_3429_0, &_call_cbs_setNumericalPrecisionPolicy_3429_0, &_set_callback_cbs_setNumericalPrecisionPolicy_3429_0);
  methods += new qt_gsi::GenericMethod ("*setQuery", "@brief Virtual method void QSqlResult::setQuery(const QString &query)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setQuery_2025_0, &_call_cbs_setQuery_2025_0);
  methods += new qt_gsi::GenericMethod ("*setQuery", "@hide", false, &_init_cbs_setQuery_2025_0, &_call_cbs_setQuery_2025_0, &_set_callback_cbs_setQuery_2025_0);
  methods += new qt_gsi::GenericMethod ("*setSelect", "@brief Virtual method void QSqlResult::setSelect(bool s)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setSelect_864_0, &_call_cbs_setSelect_864_0);
  methods += new qt_gsi::GenericMethod ("*setSelect", "@hide", false, &_init_cbs_setSelect_864_0, &_call_cbs_setSelect_864_0, &_set_callback_cbs_setSelect_864_0);
  methods += new qt_gsi::GenericMethod ("*size", "@brief Virtual method int QSqlResult::size()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_size_0_0, &_call_cbs_size_0_0);
  methods += new qt_gsi::GenericMethod ("*size", "@hide", false, &_init_cbs_size_0_0, &_call_cbs_size_0_0, &_set_callback_cbs_size_0_0);
  methods += new qt_gsi::GenericMethod ("*virtual_hook", "@brief Virtual method void QSqlResult::virtual_hook(int id, void *data)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_virtual_hook_1715_0, &_call_cbs_virtual_hook_1715_0);
  methods += new qt_gsi::GenericMethod ("*virtual_hook", "@hide", false, &_init_cbs_virtual_hook_1715_0, &_call_cbs_virtual_hook_1715_0, &_set_callback_cbs_virtual_hook_1715_0);
  return methods;
}

gsi::Class<QSqlResult_Adaptor> decl_QSqlResult_Adaptor (qtdecl_QSqlResult (), "QtSql", "QSqlResult",
  methods_QSqlResult_Adaptor (),
  "@qt\n@brief Binding of QSqlResult");

}

