#include <stdio.h>
#include <curl/curl.h>
#include <curl/easy.h>

#ifndef LASTFM_PRIV_H
#define LASTFM_PRIV_H

/* Characters needed to store a 128bit MD5 string 
 * 1 char for every 4 bits + 1 for NULL terminator */
#define MD5_BUFFER		33	

#define SMALL_BUFFER		128
#define LARGE_BUFFER		1024

/*** liblastfm.so session handle ***/
typedef struct {
	/* Curl handle */
	CURL *curl;

	/* The status of the last call to lastfm */
	char status[SMALL_BUFFER];
	/* Error Code */
	int error_code;
	/* Error message */
	char error_text[SMALL_BUFFER];

	/* Clear text username */
	char *username;
	/* MD5(password) */
	char password[MD5_BUFFER];
	
	/* Progress % (between 0.0 to 1.0), -1 means not doing anything */
	double fraction;
	
	/* MD5(username + MD5(password)) */
	char auth_token[MD5_BUFFER];
	/* Use it to tell last.fm who we are */
	char api_key[MD5_BUFFER];
	/* Secrets used to get auth.getSession */
	char secret[MD5_BUFFER];
	/* The very important user authorised session key */
	char session_key[MD5_BUFFER];

	/* Scrobbler session ID */
	char session_id[MD5_BUFFER];

	/* The URL that should be used for a now-playing request */
	char *playing_url;
	/* The URL that should be used for submissions */
	char *submission_url;
} LASTFM_SESSION;

#endif

#include "clastfm.h"
