/* Generated by re2c 1.2.1 on Wed Apr  1 00:57:32 2020 */
#line 1 "src/system/Time.re"
/*
 * Copyright (C) Tildeslash Ltd. All rights reserved.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 *
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.
 */


#include "Config.h"

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <time.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/select.h>
#include <limits.h>

#include "Str.h"
#include "system/System.h"
#include "system/Time.h"


/**
 * Implementation of the Time interface
 *
 * ISO 8601: http://en.wikipedia.org/wiki/ISO_8601
 * @file
 */


/* ----------------------------------------------------------- Definitions */

#ifndef HAVE_TIMEGM
/*
 * Spdylay - SPDY Library
 *
 * Copyright (c) 2013 Tatsuhiro Tsujikawa
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */


/* Counter the number of leap year in the range [0, y). The |y| is the
 year, including century (e.g., 2012) */
static int count_leap_year(int y)
{
        y -= 1;
        return y/4-y/100+y/400;
}


/* Returns nonzero if the |y| is the leap year. The |y| is the year,
 including century (e.g., 2012) */
static int is_leap_year(int y)
{
        return y%4 == 0 && (y%100 != 0 || y%400 == 0);
}


/* The number of days before ith month begins */
static int daysum[] = {
        0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334
};


/* Based on the algorithm of Python 2.7 calendar.timegm. */
time_t timegm(struct tm *tm)
{
        int days;
        int num_leap_year;
        int64_t t;
        if(tm->tm_mon > 11) {
                return -1;
        }
        num_leap_year = count_leap_year(tm->tm_year + 1900) - count_leap_year(1970);
        days = (tm->tm_year - 70) * 365 +
        num_leap_year + daysum[tm->tm_mon] + tm->tm_mday-1;
        if(tm->tm_mon >= 2 && is_leap_year(tm->tm_year + 1900)) {
                ++days;
        }
        t = ((int64_t)days * 24 + tm->tm_hour) * 3600 + tm->tm_min * 60 + tm->tm_sec;
        if(sizeof(time_t) == 4) {
                if(t < INT_MIN || t > INT_MAX) {
                        return -1;
                }
        }
        return t;
}
#endif /* !HAVE_TIMEGM */

#if HAVE_STRUCT_TM_TM_GMTOFF
#define TM_GMTOFF tm_gmtoff
#else
#define TM_GMTOFF tm_wday
#endif

#define _i2a(i) (x[0] = ((i) / 10) + '0', x[1] = ((i) % 10) + '0')


/* --------------------------------------------------------------- Private */


static inline int _a2i(const char *a, int l) {
        int n = 0;
        for (; *a && l--; a++)
                n = n * 10 + (*a - '0');
        return n;
}


/* ----------------------------------------------------- Protected methods */


#ifdef PACKAGE_PROTECTED
#pragma GCC visibility push(hidden)
#endif


time_t Time_toTimestamp(const char *s) {
        if (STR_DEF(s)) {
                struct tm t = {};
                if (Time_toDateTime(s, &t)) {
                        t.tm_year -= 1900;
                        time_t offset = t.TM_GMTOFF;
                        return timegm(&t) - offset;
                }
        }
	return 0;
}


struct tm *Time_toDateTime(const char *s, struct tm *t) {
        assert(t);
        assert(s);
        struct tm tm = {.tm_isdst = -1}; 
        int have_date = false, have_time = false;
        const char *limit = s + strlen(s), *marker, *token, *cursor = s;
	while (true) {
		if (cursor >= limit) {
                        if (have_date || have_time) {
                                *(struct tm*)t = tm;
                                return t;
                        }
                        THROW(SQLException, "Invalid date or time");
                }
                token = cursor;
                
#line 187 "<stdout>"
{
	unsigned char yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
	};
	yych = *cursor;
	if (yych <= ',') {
		if (yych == '+') goto yy4;
	} else {
		if (yych <= '-') goto yy4;
		if (yych <= '/') goto yy2;
		if (yych <= '9') goto yy5;
	}
yy2:
	++cursor;
yy3:
#line 259 "src/system/Time.re"
	{
                        continue;
                 }
#line 240 "<stdout>"
yy4:
	yyaccept = 0;
	yych = *(marker = ++cursor);
	if (yych <= '/') goto yy3;
	if (yych <= '9') goto yy6;
	goto yy3;
yy5:
	yyaccept = 0;
	yych = *(marker = ++cursor);
	if (yych <= '/') goto yy3;
	if (yych <= '9') goto yy8;
	goto yy3;
yy6:
	yych = *++cursor;
	if (yych <= '/') goto yy7;
	if (yych <= '9') goto yy9;
yy7:
	cursor = marker;
	if (yyaccept <= 2) {
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto yy3;
			} else {
				goto yy10;
			}
		} else {
			goto yy25;
		}
	} else {
		if (yyaccept == 3) {
			goto yy30;
		} else {
			goto yy36;
		}
	}
yy8:
	yych = *++cursor;
	if (yych <= '/') goto yy11;
	if (yych <= '9') goto yy12;
	if (yych <= ':') goto yy13;
	goto yy11;
yy9:
	yyaccept = 1;
	yych = *(marker = ++cursor);
	if (yych == '\n') goto yy10;
	if (yych <= '/') goto yy14;
	if (yych <= '9') goto yy15;
	goto yy14;
yy10:
#line 246 "src/system/Time.re"
	{ // Timezone: +-HH:MM, +-HH or +-HHMM is offset from UTC in seconds
                        if (have_time) { // Only set timezone if we have parsed time
                                tm.TM_GMTOFF = _a2i(token + 1, 2) * 3600;
                                if (isdigit(token[3]))
                                        tm.TM_GMTOFF += _a2i(token + 3, 2) * 60;
                                else if (isdigit(token[4]))
                                        tm.TM_GMTOFF += _a2i(token + 4, 2) * 60;
                                if (token[0] == '-')
                                        tm.TM_GMTOFF *= -1;
                        }
                        continue;
                 }
#line 303 "<stdout>"
yy11:
	yych = *++cursor;
	if (yych <= '/') goto yy7;
	if (yych <= '9') goto yy16;
	goto yy7;
yy12:
	yych = *++cursor;
	if (yych <= '/') goto yy7;
	if (yych <= '9') goto yy17;
	goto yy7;
yy13:
	yych = *++cursor;
	if (yych <= '/') goto yy7;
	if (yych <= '9') goto yy18;
	goto yy7;
yy14:
	yych = *++cursor;
	if (yych <= '/') goto yy7;
	if (yych <= '9') goto yy19;
	goto yy7;
yy15:
	yych = *++cursor;
	if (yych <= '/') goto yy7;
	if (yych <= '9') goto yy20;
	goto yy7;
yy16:
	yych = *++cursor;
	if (yych <= '/') goto yy7;
	if (yych <= '9') goto yy21;
	goto yy7;
yy17:
	yych = *++cursor;
	if (yych <= '/') goto yy22;
	if (yych <= '9') goto yy23;
	goto yy22;
yy18:
	yych = *++cursor;
	if (yych <= '/') goto yy7;
	if (yych <= '9') goto yy24;
	goto yy7;
yy19:
	yych = *++cursor;
	if (yych <= '/') goto yy7;
	if (yych <= '9') goto yy26;
	goto yy7;
yy20:
	yych = *++cursor;
	if (yych <= '/') goto yy10;
	if (yych <= '9') goto yy26;
	goto yy10;
yy21:
	yych = *++cursor;
	if (yych <= '/') goto yy27;
	if (yych <= '9') goto yy7;
	goto yy27;
yy22:
	yych = *++cursor;
	if (yych <= '/') goto yy7;
	if (yych <= '9') goto yy28;
	goto yy7;
yy23:
	yych = *++cursor;
	if (yych <= '/') goto yy7;
	if (yych <= '9') goto yy29;
	goto yy7;
yy24:
	yyaccept = 2;
	yych = *(marker = ++cursor);
	if (yych <= '/') goto yy27;
	if (yych >= ':') goto yy27;
yy25:
#line 238 "src/system/Time.re"
	{ // Time: HH:MM
                        tm.tm_hour = _a2i(token, 2);
                        tm.tm_min  = _a2i(token + 3, 2);
                        tm.tm_sec  = 0;
                        have_time = true;
                        continue;
                 }
#line 383 "<stdout>"
yy26:
	++cursor;
	goto yy10;
yy27:
	yych = *++cursor;
	if (yych <= '/') goto yy7;
	if (yych <= '9') goto yy31;
	goto yy7;
yy28:
	yych = *++cursor;
	if (yych <= '/') goto yy7;
	if (yych <= '9') goto yy32;
	goto yy7;
yy29:
	yyaccept = 3;
	yych = *(marker = ++cursor);
	if (yych <= '-') {
		if (yych == ',') goto yy33;
	} else {
		if (yych <= '.') goto yy33;
		if (yych <= '/') goto yy30;
		if (yych <= '9') goto yy34;
	}
yy30:
#line 230 "src/system/Time.re"
	{ // Compressed Time: HHMMSS
                        tm.tm_hour = _a2i(token, 2);
                        tm.tm_min  = _a2i(token + 2, 2);
                        tm.tm_sec  = _a2i(token + 4, 2);
                        have_time = true;
                        continue;
                 }
#line 416 "<stdout>"
yy31:
	yych = *++cursor;
	if (yych <= '/') goto yy7;
	if (yych <= '9') goto yy35;
	goto yy7;
yy32:
	yych = *++cursor;
	if (yych <= '/') goto yy37;
	if (yych <= '9') goto yy7;
	goto yy37;
yy33:
	yych = *++cursor;
	if (yybm[0+yych] & 128) {
		goto yy38;
	}
	goto yy7;
yy34:
	yych = *++cursor;
	if (yych <= '/') goto yy7;
	if (yych <= '9') goto yy40;
	goto yy7;
yy35:
	yyaccept = 4;
	yych = *(marker = ++cursor);
	if (yych <= '-') {
		if (yych == ',') goto yy42;
	} else {
		if (yych <= '.') goto yy42;
		if (yych <= '/') goto yy36;
		if (yych <= '9') goto yy43;
	}
yy36:
#line 222 "src/system/Time.re"
	{ // Time: HH:MM:SS
                        tm.tm_hour = _a2i(token, 2);
                        tm.tm_min  = _a2i(token + 3, 2);
                        tm.tm_sec  = _a2i(token + 6, 2);
                        have_time = true;
                        continue;
                 }
#line 457 "<stdout>"
yy37:
	yych = *++cursor;
	if (yych <= '/') goto yy7;
	if (yych <= '9') goto yy44;
	goto yy7;
yy38:
	yych = *++cursor;
	if (yybm[0+yych] & 128) {
		goto yy38;
	}
	goto yy30;
yy40:
	++cursor;
#line 206 "src/system/Time.re"
	{ // Compressed Date: YYYYMMDD
                        tm.tm_year  = _a2i(token, 4);
                        tm.tm_mon   = _a2i(token + 4, 2) - 1;
                        tm.tm_mday  = _a2i(token + 6, 2);
                        have_date = true;
                        continue;
                 }
#line 479 "<stdout>"
yy42:
	yych = *++cursor;
	if (yych <= '/') goto yy7;
	if (yych <= '9') goto yy45;
	goto yy7;
yy43:
	yych = *++cursor;
	if (yych <= '/') goto yy7;
	if (yych <= '9') goto yy47;
	goto yy7;
yy44:
	yych = *++cursor;
	if (yych <= '/') goto yy7;
	if (yych <= '9') goto yy49;
	goto yy7;
yy45:
	yych = *++cursor;
	if (yych <= '/') goto yy36;
	if (yych <= '9') goto yy45;
	goto yy36;
yy47:
	++cursor;
#line 214 "src/system/Time.re"
	{ // Date: dd/mm/yyyy
                        tm.tm_mday  = _a2i(token, 2);
                        tm.tm_mon   = _a2i(token + 3, 2) - 1;
                        tm.tm_year  = _a2i(token + 6, 4);
                        have_date = true;
                        continue;
                 }
#line 510 "<stdout>"
yy49:
	++cursor;
#line 198 "src/system/Time.re"
	{ // Date: YYYY-MM-DD
                        tm.tm_year  = _a2i(token, 4);
                        tm.tm_mon   = _a2i(token + 5, 2) - 1;
                        tm.tm_mday  = _a2i(token + 8, 2);
                        have_date = true;
                        continue;
                 }
#line 521 "<stdout>"
}
#line 262 "src/system/Time.re"

        }
	return NULL;
}


char *Time_toString(time_t time, char result[static 20]) {
        assert(result);
        char x[2];
        struct tm ts = {.tm_isdst = -1};
        gmtime_r(&time, &ts);
        memcpy(result, "YYYY-MM-DD HH:MM:SS\0", 20);
        /*              0    5  8  11 14 17 */
        _i2a((ts.tm_year+1900)/100);
        result[0] = x[0];
        result[1] = x[1];
        _i2a((ts.tm_year+1900)%100);
        result[2] = x[0];
        result[3] = x[1];
        _i2a(ts.tm_mon + 1); // Months in 01-12
        result[5] = x[0];
        result[6] = x[1];
        _i2a(ts.tm_mday);
        result[8] = x[0];
        result[9] = x[1];
        _i2a(ts.tm_hour);
        result[11] = x[0];
        result[12] = x[1];
        _i2a(ts.tm_min);
        result[14] = x[0];
        result[15] = x[1];
        _i2a(ts.tm_sec);
        result[17] = x[0];
        result[18] = x[1];
	return result;
}


time_t Time_now(void) {
	struct timeval t;
	if (gettimeofday(&t, NULL) != 0)
                THROW(AssertException, "%s", System_getLastError());
	return t.tv_sec;
}


long long Time_milli(void) {
	struct timeval t;
	if (gettimeofday(&t, NULL) != 0)
                THROW(AssertException, "%s", System_getLastError());
	return (long long)t.tv_sec * 1000  +  (long long)t.tv_usec / 1000;
}


bool Time_usleep(long u) {
        struct timeval t;
        t.tv_sec = u / USEC_PER_SEC;
        t.tv_usec = (suseconds_t)(u % USEC_PER_SEC);
        select(0, 0, 0, 0, &t);
        return true;
}


#ifdef PACKAGE_PROTECTED
#pragma GCC visibility pop
#endif
