## setup OS_LIBS
set (OS_LIBS)

if (MARSYAS_MACOSX)
  list (APPEND OS_LIBS ${COREFOUNDATION_LIBRARY})
  if (MARSYAS_AUDIOIO)
    list (APPEND OS_LIBS ${COREAUDIO_LIBRARY})
  endif (MARSYAS_AUDIOIO)
  if (MARSYAS_MIDIIO)
    list (APPEND OS_LIBS ${COREMIDI_LIBRARY})
  endif (MARSYAS_MIDIIO)
  if (CMAKE_BUILD_TYPE STREQUAL "Profile")
    list (APPEND OS_LIBS Saturn)
  endif (CMAKE_BUILD_TYPE STREQUAL "Profile")
endif (MARSYAS_MACOSX)

if (MARSYAS_LINUX)
  if(MARSYAS_AUDIOIO OR MARSYAS_MIDIIO)
    if(WITH_JACK AND JACK_FOUND)
      list(APPEND OS_LIBS ${JACK_LIBRARIES})
    endif()
    if(WITH_ALSA AND ALSA_FOUND)
      list(APPEND OS_LIBS ${ALSA_LIBRARY})
    endif()
    # No libraries for OSS
  endif()

  list (APPEND OS_LIBS pthread rt)
endif (MARSYAS_LINUX)

if(MARSYAS_WIN32 OR MARSYAS_MINGW OR MARSYAS_CYGWIN)
  if(MARSYAS_AUDIOIO)
    if(MARSYAS_ASIO)
      # FIXME: insert ASIO library here!
    else()
      list(APPEND OS_LIBS ${DSOUND_LIBRARY})
    endif()
  endif()
  if(MARSYAS_MIDIIO)
    list(APPEND OS_LIBS winmm)
  endif()
  if(MARSYAS_WIN32)
    set(CMAKE_MODULE_LINKER_FLAGS_PROFILE "/INCREMENTAL:NO")
  endif()
endif()
