/*
** Copyright (C) 1998-2010 George Tzanetakis <gtzan@cs.uvic.ca>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef MARSYAS_INJECT_H
#define MARSYAS_INJECT_H

#include <marsyas/system/MarSystem.h>

namespace Marsyas
{
/**
	\class Inject
	\ingroup Processing
	\brief Inject a vector specified by the mrs_realvec/inject control
	into the datastream

	Controls:
	- \b mrs_realvec/inject [w] : the vector to be injected
	- \b mrs_natural/injectSize [w] : how many observations to
	  inject
	- \b mrs_string/injectNames [w] : names of the
	  observations (for weka output)
*/

class marsyas_EXPORT Inject: public MarSystem
{
private:

  /// Add specific controls needed by this MarSystem.
  void addControls();

  /// Reads changed controls and sets up variables if necessary.
  void myUpdate(MarControlPtr sender);


  /// MarControlPtr for the gain control
  MarControlPtr ctrl_inject_;
  MarControlPtr ctrl_injectSize_;
  MarControlPtr ctrl_injectNames_;

  mrs_natural prev_injectSize_;


public:
  /// Inject constructor.
  Inject(std::string name);

  /// Inject copy constructor.
  Inject(const Inject& a);

  /// Inject destructor.
  ~Inject();

  /// Implementation of the MarSystem::clone() method.
  MarSystem* clone() const;

  /// Implementation of the MarSystem::myProcess method.
  void myProcess(realvec& in, realvec& out);
};

}
//namespace Marsyas

#endif
//MARSYAS_INJECT_H

