.\"
.\" Copyright (c) 1997-2019 Tom Schmidt.
.\" This software may be freely distributed provided it is not sold for
.\" profit and the author is credited appropriately.
.\"
.\" $Revision: 3.15 $
.\"
.TH memconf 1m "16 Jul 2019" "Maintenance Commands"
.SH NAME
memconf \- Display information about installed memory
.SH SYNOPSIS
.BI memconf
[
.B \-h
] [
.B \-D
] [
.B \-v
] [
.B explorer_dir
] 
.SH DESCRIPTION
.I memconf
is a
.B Perl
script that displays information about the memory installed on a Solaris,
Linux, FreeBSD or HP-UX workstation or server.
It reports the size of each SIMM/DIMM memory module installed in a system,
including which motherboard memory slot each is in.
And it also reports the system type and any empty memory sockets.
It works for most SPARC systems running SunOS 4.1.X or Solaris 2.X,
Solaris 10 6/06 or later on x86 with /usr/platform/i86pc/sbin/prtdiag,
Linux on SPARC with sparc-utils and /dev/openprom,
Linux on x86 and x86_64 with kernel-utils or pmtools for dmidecode,
FreeBSD on x86 and x86_64 with dmidecode,
and most HP-UX systems with SysMgmtPlus (cprop) or Support Tools Manager (cstm).

.SH OPTIONS
.TP 8
.B \-h
Display a small help message.
.TP 8
.B \-D
Send results to
.I memconf
maintainer. This will E-mail the output of "memconf -d", "prtconf -vp" or
"devinfo -pv", and if available, the output of "prtdiag -v", "prtfru -x",
"prtpicl -v", "psrinfo -v", "psrinfo -p -v" and "cfgadm -al"
to tom@4schmidts.com
.TP 8
.B \-v
Be verbose. In this mode
.I memconf
also reports:  banner name, model, and CPU/system frequencies, as well
as the address range and bank numbers for each memory module.
.TP 8
.B explorer_dir
Uses Sun Explorer output directory for input. You can download Sun
Explorer from http://sunsolve.Sun.COM/diag/explorer/SUNWexplo.tar.Z
In this case,
.I memconf
can be run on Sun Explorer data on any platform with
.B Perl
installed, including Solaris x86, Linux and Windows.

.SH WEBSITE
http://www.4schmidts.com/unix.html

.SH BUGS
Please send bug reports and enhancement requests along with the output of
the following commands to tom@4schmidts.com as E\-mail attachments so that
.I memconf
can be enhanced. Please include the Sun Model and Operating System version.
.PP
SunOS 4.1.X
.RS
/usr/etc/devinfo \-pv
.RE
Solaris 2.X
.RS
/usr/sbin/prtconf \-vp
.br
/usr/platform/`uname \-m`/sbin/prtdiag \-v (if available)
.br
/usr/sbin/prtfru \-x (if available)
.br
/usr/sbin/prtpicl \-v (if available)
.br
/usr/sbin/psrinfo \-v (if available)
.br
/usr/sbin/psrinfo \-p \-v (if available)
.br
/usr/sbin/cfgadm \-al (if available)
.RE
Linux
.RS
/usr/sbin/dmidecode
.RE
.PP
You can do this using the 'memconf -D' command.
If an unrecognized system is a Sun clone, please also send any hardware
documentation on the memory layout that you may have.

.SH AUTHORS
Tom Schmidt (tom@4schmidts.com)
.br
Original version based on SunManagers SUMMARY by Howard Modell
(h.modell@ieee.org)

.SH SEE ALSO
devinfo(8s), prtconf(1m), prtdiag(1m), prtfru(1m), prtpicl(1m), psrinfo(1m),
cfgadm(1m), perl(1), sysinfo(1), dmidecode(8)

