/* A Bison parser, made by GNU Bison 3.5.1.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2020 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Undocumented macros, especially those whose name start with YY_,
   are private implementation details.  Do not rely on them.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.5.1"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 26 "src/p.y"


/*
 * DESCRIPTION
 *   Simple context-free grammar for parsing the control file.
 *
 */

#include "config.h"

#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif

#ifdef HAVE_CTYPE_H
#include <ctype.h>
#endif

#ifdef HAVE_PWD_H
#include <pwd.h>
#endif

#ifdef HAVE_GRP_H
#include <grp.h>
#endif

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#endif

#ifdef HAVE_TIME_H
#include <time.h>
#endif

#ifdef HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#endif

#ifdef HAVE_ASM_PARAM_H
#include <asm/param.h>
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif

#ifdef HAVE_NETDB_H
#include <netdb.h>
#endif

#ifdef HAVE_SYSLOG_H
#include <syslog.h>
#endif

#ifdef HAVE_NETINET_IN_SYSTM_H
#include <netinet/in_systm.h>
#endif

#ifdef HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif

#ifdef HAVE_NETINET_IP_H
#include <netinet/ip.h>
#endif

#ifdef HAVE_NETINET_IP_ICMP_H
#include <netinet/ip_icmp.h>
#endif

#ifdef HAVE_REGEX_H
#include <regex.h>
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef HAVE_OPENSSL
#include <openssl/ssl.h>
#endif

#include "monit.h"
#include "protocol.h"
#include "engine.h"
#include "alert.h"
#include "ProcessTree.h"
#include "device.h"
#include "processor.h"
#include "md5.h"
#include "sha1.h"
#include "checksum.h"
#include "process_sysdep.h"

// libmonit
#include "io/File.h"
#include "util/Str.h"
#include "thread/Thread.h"


/* ------------------------------------------------------------- Definitions */


struct precedence_t {
        bool daemon;
        bool logfile;
        bool pidfile;
};

struct rate_t {
        unsigned int count;
        unsigned int cycles;
};

/* yacc interface */
void  yyerror(const char *,...) __attribute__((format (printf, 1, 2)));
void  yyerror2(const char *,...) __attribute__((format (printf, 1, 2)));
void  yywarning(const char *,...) __attribute__((format (printf, 1, 2)));
void  yywarning2(const char *,...) __attribute__((format (printf, 1, 2)));

/* lexer interface */
int yylex(void);
extern FILE *yyin;
extern int lineno;
extern int arglineno;
extern char *yytext;
extern char *argyytext;
extern char *currentfile;
extern char *argcurrentfile;
extern int buffer_stack_ptr;

/* Local variables */
static int cfg_errflag = 0;
static Service_T tail = NULL;
static Service_T current = NULL;
static Request_T urlrequest = NULL;
static command_t command = NULL;
static command_t command1 = NULL;
static command_t command2 = NULL;
static Service_T depend_list = NULL;
static struct Uid_T uidset = {};
static struct Gid_T gidset = {};
static struct Pid_T pidset = {};
static struct Pid_T ppidset = {};
static struct FsFlag_T fsflagset = {};
static struct NonExist_T nonexistset = {};
static struct Exist_T existset = {};
static struct Status_T statusset = {};
static struct Perm_T permset = {};
static struct Size_T sizeset = {};
static struct Uptime_T uptimeset = {};
static struct ResponseTime_T responsetimeset = {};
static struct LinkStatus_T linkstatusset = {};
static struct LinkSpeed_T linkspeedset = {};
static struct LinkSaturation_T linksaturationset = {};
static struct Bandwidth_T bandwidthset = {};
static struct Match_T matchset = {};
static struct Icmp_T icmpset = {};
static struct Mail_T mailset = {};
static struct SslOptions_T sslset = {};
static struct Port_T portset = {};
static struct MailServer_T mailserverset = {};
static struct Mmonit_T mmonitset = {};
static struct FileSystem_T filesystemset = {};
static struct Resource_T resourceset = {};
static struct Checksum_T checksumset = {};
static struct Timestamp_T timestampset = {};
static struct ActionRate_T actionrateset = {};
static struct precedence_t ihp = {false, false, false};
static struct rate_t rate = {1, 1};
static struct rate_t rate1 = {1, 1};
static struct rate_t rate2 = {1, 1};
static char * htpasswd_file = NULL;
static unsigned int repeat = 0;
static unsigned int repeat1 = 0;
static unsigned int repeat2 = 0;
static Digest_Type digesttype = Digest_Cleartext;

#define BITMAP_MAX (sizeof(long long) * 8)


/* -------------------------------------------------------------- Prototypes */

static void  preparse(void);
static void  postparse(void);
static bool _parseOutgoingAddress(char *ip, Outgoing_T *outgoing);
static void  addmail(char *, Mail_T, Mail_T *);
static Service_T createservice(Service_Type, char *, char *, State_Type (*)(Service_T));
static void  addservice(Service_T);
static void  adddependant(char *);
static void  addservicegroup(char *);
static void  addport(Port_T *, Port_T);
static void  addhttpheader(Port_T, char *);
static void  addresource(Resource_T);
static void  addtimestamp(Timestamp_T);
static void  addactionrate(ActionRate_T);
static void  addsize(Size_T);
static void  adduptime(Uptime_T);
static void  addpid(Pid_T);
static void  addppid(Pid_T);
static void  addfsflag(FsFlag_T);
static void  addnonexist(NonExist_T);
static void  addexist(Exist_T);
static void  addlinkstatus(Service_T, LinkStatus_T);
static void  addlinkspeed(Service_T, LinkSpeed_T);
static void  addlinksaturation(Service_T, LinkSaturation_T);
static void  addbandwidth(Bandwidth_T *, Bandwidth_T);
static void  addfilesystem(FileSystem_T);
static void  addicmp(Icmp_T);
static void  addgeneric(Port_T, char*, char*);
static void  addcommand(int, unsigned);
static void  addargument(char *);
static void  addmmonit(Mmonit_T);
static void  addmailserver(MailServer_T);
static bool addcredentials(char *, char *, Digest_Type, bool);
#ifdef HAVE_LIBPAM
static void  addpamauth(char *, int);
#endif
static void  addhtpasswdentry(char *, char *, Digest_Type);
static uid_t get_uid(char *, uid_t);
static gid_t get_gid(char *, gid_t);
static void  addchecksum(Checksum_T);
static void  addperm(Perm_T);
static void  addmatch(Match_T, int, int);
static void  addmatchpath(Match_T, Action_Type);
static void  addstatus(Status_T);
static Uid_T adduid(Uid_T);
static Gid_T addgid(Gid_T);
static void  addeuid(uid_t);
static void  addegid(gid_t);
static void  addeventaction(EventAction_T *, Action_Type, Action_Type);
static void  prepare_urlrequest(URL_T U);
static void  seturlrequest(int, char *);
static void  setlogfile(char *);
static void  setpidfile(char *);
static void  reset_sslset(void);
static void  reset_mailset(void);
static void  reset_mailserverset(void);
static void  reset_mmonitset(void);
static void  reset_portset(void);
static void  reset_resourceset(void);
static void  reset_timestampset(void);
static void  reset_actionrateset(void);
static void  reset_sizeset(void);
static void  reset_uptimeset(void);
static void  reset_responsetimeset(void);
static void  reset_pidset(void);
static void  reset_ppidset(void);
static void  reset_fsflagset(void);
static void  reset_nonexistset(void);
static void  reset_existset(void);
static void  reset_linkstatusset(void);
static void  reset_linkspeedset(void);
static void  reset_linksaturationset(void);
static void  reset_bandwidthset(void);
static void  reset_checksumset(void);
static void  reset_permset(void);
static void  reset_uidset(void);
static void  reset_gidset(void);
static void  reset_statusset(void);
static void  reset_filesystemset(void);
static void  reset_icmpset(void);
static void  reset_rateset(struct rate_t *);
static void  check_name(char *);
static int   check_perm(int);
static void  check_exec(char *);
static int   cleanup_hash_string(char *);
static void  check_depend(void);
static void  setsyslog(char *);
static command_t copycommand(command_t);
static int verifyMaxForward(int);
static void _setPEM(char **store, char *path, const char *description, bool isFile);
static void _setSSLOptions(SslOptions_T options);
#ifdef HAVE_OPENSSL
static void _setSSLVersion(short version);
#endif
static void _unsetSSLVersion(short version);
static void addsecurityattribute(char *, Action_Type, Action_Type);
static void addfiledescriptors(Operator_Type, bool, long long, float, Action_Type, Action_Type);
static void _sanityCheckEveryStatement(Service_T s);


#line 369 "src/y.tab.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Use api.header.include to #include this header
   instead of duplicating it here.  */
#ifndef YY_YY_SRC_Y_TAB_H_INCLUDED
# define YY_YY_SRC_Y_TAB_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    IF = 258,
    ELSE = 259,
    THEN = 260,
    FAILED = 261,
    SET = 262,
    LOGFILE = 263,
    FACILITY = 264,
    DAEMON = 265,
    SYSLOG = 266,
    MAILSERVER = 267,
    HTTPD = 268,
    ALLOW = 269,
    REJECTOPT = 270,
    ADDRESS = 271,
    INIT = 272,
    TERMINAL = 273,
    BATCH = 274,
    READONLY = 275,
    CLEARTEXT = 276,
    MD5HASH = 277,
    SHA1HASH = 278,
    CRYPT = 279,
    DELAY = 280,
    PEMFILE = 281,
    PEMKEY = 282,
    PEMCHAIN = 283,
    ENABLE = 284,
    DISABLE = 285,
    SSLTOKEN = 286,
    CIPHER = 287,
    CLIENTPEMFILE = 288,
    ALLOWSELFCERTIFICATION = 289,
    SELFSIGNED = 290,
    VERIFY = 291,
    CERTIFICATE = 292,
    CACERTIFICATEFILE = 293,
    CACERTIFICATEPATH = 294,
    VALID = 295,
    INTERFACE = 296,
    LINK = 297,
    PACKET = 298,
    BYTEIN = 299,
    BYTEOUT = 300,
    PACKETIN = 301,
    PACKETOUT = 302,
    SPEED = 303,
    SATURATION = 304,
    UPLOAD = 305,
    DOWNLOAD = 306,
    TOTAL = 307,
    UP = 308,
    DOWN = 309,
    IDFILE = 310,
    STATEFILE = 311,
    SEND = 312,
    EXPECT = 313,
    CYCLE = 314,
    COUNT = 315,
    REMINDER = 316,
    REPEAT = 317,
    LIMITS = 318,
    SENDEXPECTBUFFER = 319,
    EXPECTBUFFER = 320,
    FILECONTENTBUFFER = 321,
    HTTPCONTENTBUFFER = 322,
    PROGRAMOUTPUT = 323,
    NETWORKTIMEOUT = 324,
    PROGRAMTIMEOUT = 325,
    STARTTIMEOUT = 326,
    STOPTIMEOUT = 327,
    RESTARTTIMEOUT = 328,
    PIDFILE = 329,
    START = 330,
    STOP = 331,
    PATHTOK = 332,
    RSAKEY = 333,
    HOST = 334,
    HOSTNAME = 335,
    PORT = 336,
    IPV4 = 337,
    IPV6 = 338,
    TYPE = 339,
    UDP = 340,
    TCP = 341,
    TCPSSL = 342,
    PROTOCOL = 343,
    CONNECTION = 344,
    ALERT = 345,
    NOALERT = 346,
    MAILFORMAT = 347,
    UNIXSOCKET = 348,
    SIGNATURE = 349,
    TIMEOUT = 350,
    RETRY = 351,
    RESTART = 352,
    CHECKSUM = 353,
    EVERY = 354,
    NOTEVERY = 355,
    DEFAULT = 356,
    HTTP = 357,
    HTTPS = 358,
    APACHESTATUS = 359,
    FTP = 360,
    SMTP = 361,
    SMTPS = 362,
    POP = 363,
    POPS = 364,
    IMAP = 365,
    IMAPS = 366,
    CLAMAV = 367,
    NNTP = 368,
    NTP3 = 369,
    MYSQL = 370,
    MYSQLS = 371,
    DNS = 372,
    WEBSOCKET = 373,
    MQTT = 374,
    SSH = 375,
    DWP = 376,
    LDAP2 = 377,
    LDAP3 = 378,
    RDATE = 379,
    RSYNC = 380,
    TNS = 381,
    PGSQL = 382,
    POSTFIXPOLICY = 383,
    SIP = 384,
    LMTP = 385,
    GPS = 386,
    RADIUS = 387,
    MEMCACHE = 388,
    REDIS = 389,
    MONGODB = 390,
    SIEVE = 391,
    SPAMASSASSIN = 392,
    FAIL2BAN = 393,
    STRING = 394,
    PATH = 395,
    MAILADDR = 396,
    MAILFROM = 397,
    MAILREPLYTO = 398,
    MAILSUBJECT = 399,
    MAILBODY = 400,
    SERVICENAME = 401,
    STRINGNAME = 402,
    NUMBER = 403,
    PERCENT = 404,
    LOGLIMIT = 405,
    CLOSELIMIT = 406,
    DNSLIMIT = 407,
    KEEPALIVELIMIT = 408,
    REPLYLIMIT = 409,
    REQUESTLIMIT = 410,
    STARTLIMIT = 411,
    WAITLIMIT = 412,
    GRACEFULLIMIT = 413,
    CLEANUPLIMIT = 414,
    REAL = 415,
    CHECKPROC = 416,
    CHECKFILESYS = 417,
    CHECKFILE = 418,
    CHECKDIR = 419,
    CHECKHOST = 420,
    CHECKSYSTEM = 421,
    CHECKFIFO = 422,
    CHECKPROGRAM = 423,
    CHECKNET = 424,
    THREADS = 425,
    CHILDREN = 426,
    METHOD = 427,
    GET = 428,
    HEAD = 429,
    STATUS = 430,
    ORIGIN = 431,
    VERSIONOPT = 432,
    READ = 433,
    WRITE = 434,
    OPERATION = 435,
    SERVICETIME = 436,
    DISK = 437,
    RESOURCE = 438,
    MEMORY = 439,
    TOTALMEMORY = 440,
    LOADAVG1 = 441,
    LOADAVG5 = 442,
    LOADAVG15 = 443,
    SWAP = 444,
    MODE = 445,
    ACTIVE = 446,
    PASSIVE = 447,
    MANUAL = 448,
    ONREBOOT = 449,
    NOSTART = 450,
    LASTSTATE = 451,
    CORE = 452,
    CPU = 453,
    TOTALCPU = 454,
    CPUUSER = 455,
    CPUSYSTEM = 456,
    CPUWAIT = 457,
    CPUNICE = 458,
    CPUHARDIRQ = 459,
    CPUSOFTIRQ = 460,
    CPUSTEAL = 461,
    CPUGUEST = 462,
    CPUGUESTNICE = 463,
    GROUP = 464,
    REQUEST = 465,
    DEPENDS = 466,
    BASEDIR = 467,
    SLOT = 468,
    EVENTQUEUE = 469,
    SECRET = 470,
    HOSTHEADER = 471,
    UID = 472,
    EUID = 473,
    GID = 474,
    MMONIT = 475,
    INSTANCE = 476,
    USERNAME = 477,
    PASSWORD = 478,
    DATABASE = 479,
    TIME = 480,
    ATIME = 481,
    CTIME = 482,
    MTIME = 483,
    CHANGED = 484,
    MILLISECOND = 485,
    SECOND = 486,
    MINUTE = 487,
    HOUR = 488,
    DAY = 489,
    MONTH = 490,
    SSLV2 = 491,
    SSLV3 = 492,
    TLSV1 = 493,
    TLSV11 = 494,
    TLSV12 = 495,
    TLSV13 = 496,
    CERTMD5 = 497,
    AUTO = 498,
    NOSSLV2 = 499,
    NOSSLV3 = 500,
    NOTLSV1 = 501,
    NOTLSV11 = 502,
    NOTLSV12 = 503,
    NOTLSV13 = 504,
    BYTE = 505,
    KILOBYTE = 506,
    MEGABYTE = 507,
    GIGABYTE = 508,
    INODE = 509,
    SPACE = 510,
    TFREE = 511,
    PERMISSION = 512,
    SIZE = 513,
    MATCH = 514,
    NOT = 515,
    IGNORE = 516,
    ACTION = 517,
    UPTIME = 518,
    RESPONSETIME = 519,
    EXEC = 520,
    UNMONITOR = 521,
    PING = 522,
    PING4 = 523,
    PING6 = 524,
    ICMP = 525,
    ICMPECHO = 526,
    NONEXIST = 527,
    EXIST = 528,
    INVALID = 529,
    DATA = 530,
    RECOVERED = 531,
    PASSED = 532,
    SUCCEEDED = 533,
    URL = 534,
    CONTENT = 535,
    PID = 536,
    PPID = 537,
    FSFLAG = 538,
    REGISTER = 539,
    CREDENTIALS = 540,
    URLOBJECT = 541,
    ADDRESSOBJECT = 542,
    TARGET = 543,
    TIMESPEC = 544,
    HTTPHEADER = 545,
    MAXFORWARD = 546,
    FIPS = 547,
    SECURITY = 548,
    ATTRIBUTE = 549,
    FILEDESCRIPTORS = 550,
    GREATER = 551,
    GREATEROREQUAL = 552,
    LESS = 553,
    LESSOREQUAL = 554,
    EQUAL = 555,
    NOTEQUAL = 556
  };
#endif
/* Tokens.  */
#define IF 258
#define ELSE 259
#define THEN 260
#define FAILED 261
#define SET 262
#define LOGFILE 263
#define FACILITY 264
#define DAEMON 265
#define SYSLOG 266
#define MAILSERVER 267
#define HTTPD 268
#define ALLOW 269
#define REJECTOPT 270
#define ADDRESS 271
#define INIT 272
#define TERMINAL 273
#define BATCH 274
#define READONLY 275
#define CLEARTEXT 276
#define MD5HASH 277
#define SHA1HASH 278
#define CRYPT 279
#define DELAY 280
#define PEMFILE 281
#define PEMKEY 282
#define PEMCHAIN 283
#define ENABLE 284
#define DISABLE 285
#define SSLTOKEN 286
#define CIPHER 287
#define CLIENTPEMFILE 288
#define ALLOWSELFCERTIFICATION 289
#define SELFSIGNED 290
#define VERIFY 291
#define CERTIFICATE 292
#define CACERTIFICATEFILE 293
#define CACERTIFICATEPATH 294
#define VALID 295
#define INTERFACE 296
#define LINK 297
#define PACKET 298
#define BYTEIN 299
#define BYTEOUT 300
#define PACKETIN 301
#define PACKETOUT 302
#define SPEED 303
#define SATURATION 304
#define UPLOAD 305
#define DOWNLOAD 306
#define TOTAL 307
#define UP 308
#define DOWN 309
#define IDFILE 310
#define STATEFILE 311
#define SEND 312
#define EXPECT 313
#define CYCLE 314
#define COUNT 315
#define REMINDER 316
#define REPEAT 317
#define LIMITS 318
#define SENDEXPECTBUFFER 319
#define EXPECTBUFFER 320
#define FILECONTENTBUFFER 321
#define HTTPCONTENTBUFFER 322
#define PROGRAMOUTPUT 323
#define NETWORKTIMEOUT 324
#define PROGRAMTIMEOUT 325
#define STARTTIMEOUT 326
#define STOPTIMEOUT 327
#define RESTARTTIMEOUT 328
#define PIDFILE 329
#define START 330
#define STOP 331
#define PATHTOK 332
#define RSAKEY 333
#define HOST 334
#define HOSTNAME 335
#define PORT 336
#define IPV4 337
#define IPV6 338
#define TYPE 339
#define UDP 340
#define TCP 341
#define TCPSSL 342
#define PROTOCOL 343
#define CONNECTION 344
#define ALERT 345
#define NOALERT 346
#define MAILFORMAT 347
#define UNIXSOCKET 348
#define SIGNATURE 349
#define TIMEOUT 350
#define RETRY 351
#define RESTART 352
#define CHECKSUM 353
#define EVERY 354
#define NOTEVERY 355
#define DEFAULT 356
#define HTTP 357
#define HTTPS 358
#define APACHESTATUS 359
#define FTP 360
#define SMTP 361
#define SMTPS 362
#define POP 363
#define POPS 364
#define IMAP 365
#define IMAPS 366
#define CLAMAV 367
#define NNTP 368
#define NTP3 369
#define MYSQL 370
#define MYSQLS 371
#define DNS 372
#define WEBSOCKET 373
#define MQTT 374
#define SSH 375
#define DWP 376
#define LDAP2 377
#define LDAP3 378
#define RDATE 379
#define RSYNC 380
#define TNS 381
#define PGSQL 382
#define POSTFIXPOLICY 383
#define SIP 384
#define LMTP 385
#define GPS 386
#define RADIUS 387
#define MEMCACHE 388
#define REDIS 389
#define MONGODB 390
#define SIEVE 391
#define SPAMASSASSIN 392
#define FAIL2BAN 393
#define STRING 394
#define PATH 395
#define MAILADDR 396
#define MAILFROM 397
#define MAILREPLYTO 398
#define MAILSUBJECT 399
#define MAILBODY 400
#define SERVICENAME 401
#define STRINGNAME 402
#define NUMBER 403
#define PERCENT 404
#define LOGLIMIT 405
#define CLOSELIMIT 406
#define DNSLIMIT 407
#define KEEPALIVELIMIT 408
#define REPLYLIMIT 409
#define REQUESTLIMIT 410
#define STARTLIMIT 411
#define WAITLIMIT 412
#define GRACEFULLIMIT 413
#define CLEANUPLIMIT 414
#define REAL 415
#define CHECKPROC 416
#define CHECKFILESYS 417
#define CHECKFILE 418
#define CHECKDIR 419
#define CHECKHOST 420
#define CHECKSYSTEM 421
#define CHECKFIFO 422
#define CHECKPROGRAM 423
#define CHECKNET 424
#define THREADS 425
#define CHILDREN 426
#define METHOD 427
#define GET 428
#define HEAD 429
#define STATUS 430
#define ORIGIN 431
#define VERSIONOPT 432
#define READ 433
#define WRITE 434
#define OPERATION 435
#define SERVICETIME 436
#define DISK 437
#define RESOURCE 438
#define MEMORY 439
#define TOTALMEMORY 440
#define LOADAVG1 441
#define LOADAVG5 442
#define LOADAVG15 443
#define SWAP 444
#define MODE 445
#define ACTIVE 446
#define PASSIVE 447
#define MANUAL 448
#define ONREBOOT 449
#define NOSTART 450
#define LASTSTATE 451
#define CORE 452
#define CPU 453
#define TOTALCPU 454
#define CPUUSER 455
#define CPUSYSTEM 456
#define CPUWAIT 457
#define CPUNICE 458
#define CPUHARDIRQ 459
#define CPUSOFTIRQ 460
#define CPUSTEAL 461
#define CPUGUEST 462
#define CPUGUESTNICE 463
#define GROUP 464
#define REQUEST 465
#define DEPENDS 466
#define BASEDIR 467
#define SLOT 468
#define EVENTQUEUE 469
#define SECRET 470
#define HOSTHEADER 471
#define UID 472
#define EUID 473
#define GID 474
#define MMONIT 475
#define INSTANCE 476
#define USERNAME 477
#define PASSWORD 478
#define DATABASE 479
#define TIME 480
#define ATIME 481
#define CTIME 482
#define MTIME 483
#define CHANGED 484
#define MILLISECOND 485
#define SECOND 486
#define MINUTE 487
#define HOUR 488
#define DAY 489
#define MONTH 490
#define SSLV2 491
#define SSLV3 492
#define TLSV1 493
#define TLSV11 494
#define TLSV12 495
#define TLSV13 496
#define CERTMD5 497
#define AUTO 498
#define NOSSLV2 499
#define NOSSLV3 500
#define NOTLSV1 501
#define NOTLSV11 502
#define NOTLSV12 503
#define NOTLSV13 504
#define BYTE 505
#define KILOBYTE 506
#define MEGABYTE 507
#define GIGABYTE 508
#define INODE 509
#define SPACE 510
#define TFREE 511
#define PERMISSION 512
#define SIZE 513
#define MATCH 514
#define NOT 515
#define IGNORE 516
#define ACTION 517
#define UPTIME 518
#define RESPONSETIME 519
#define EXEC 520
#define UNMONITOR 521
#define PING 522
#define PING4 523
#define PING6 524
#define ICMP 525
#define ICMPECHO 526
#define NONEXIST 527
#define EXIST 528
#define INVALID 529
#define DATA 530
#define RECOVERED 531
#define PASSED 532
#define SUCCEEDED 533
#define URL 534
#define CONTENT 535
#define PID 536
#define PPID 537
#define FSFLAG 538
#define REGISTER 539
#define CREDENTIALS 540
#define URLOBJECT 541
#define ADDRESSOBJECT 542
#define TARGET 543
#define TIMESPEC 544
#define HTTPHEADER 545
#define MAXFORWARD 546
#define FIPS 547
#define SECURITY 548
#define ATTRIBUTE 549
#define FILEDESCRIPTORS 550
#define GREATER 551
#define GREATEROREQUAL 552
#define LESS 553
#define LESSOREQUAL 554
#define EQUAL 555
#define NOTEQUAL 556

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
union YYSTYPE
{
#line 325 "src/p.y"

        URL_T url;
        Address_T address;
        float real;
        int   number;
        char *string;

#line 1031 "src/y.tab.c"

};
typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif


extern YYSTYPE yylval;

int yyparse (void);

#endif /* !YY_YY_SRC_Y_TAB_H_INCLUDED  */



#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))

/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && ! defined __ICC && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                            \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  69
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   2009

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  308
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  251
/* YYNRULES -- Number of rules.  */
#define YYNRULES  837
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  1624

#define YYUNDEFTOK  2
#define YYMAXUTOK   556


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   304,     2,
       2,     2,     2,     2,   305,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   306,     2,   307,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   302,     2,   303,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   379,   379,   380,   383,   384,   387,   388,   389,   390,
     391,   392,   393,   394,   395,   396,   397,   398,   399,   400,
     401,   402,   403,   404,   405,   406,   407,   408,   409,   410,
     411,   412,   413,   416,   417,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   446,
     447,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   462,   463,   464,   465,   466,   467,   470,
     471,   474,   475,   476,   477,   478,   479,   480,   481,   482,
     483,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     493,   496,   497,   500,   501,   502,   503,   504,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   517,   518,
     521,   522,   523,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   536,   537,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     557,   558,   561,   562,   563,   564,   565,   566,   567,   568,
     569,   570,   571,   572,   573,   576,   577,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
     593,   594,   597,   598,   601,   602,   603,   604,   605,   606,
     607,   608,   609,   610,   611,   612,   615,   619,   622,   628,
     638,   643,   646,   651,   656,   659,   662,   667,   673,   676,
     677,   680,   683,   686,   689,   692,   695,   698,   701,   704,
     707,   710,   713,   716,   719,   724,   729,   737,   740,   745,
     748,   752,   758,   763,   768,   776,   779,   780,   783,   789,
     790,   793,   796,   797,   798,   799,   802,   803,   808,   813,
     816,   819,   820,   823,   827,   831,   835,   839,   842,   846,
     849,   852,   855,   858,   861,   866,   872,   873,   876,   890,
     897,   906,   907,   910,   911,   914,   921,   924,   931,   934,
     941,   944,   951,   954,   961,   964,   971,   974,   985,   994,
    1001,  1016,  1017,  1020,  1029,  1040,  1041,  1044,  1047,  1050,
    1051,  1052,  1053,  1056,  1083,  1084,  1087,  1088,  1089,  1090,
    1091,  1092,  1093,  1094,  1095,  1099,  1105,  1111,  1117,  1123,
    1129,  1130,  1133,  1138,  1143,  1147,  1151,  1157,  1158,  1161,
    1162,  1165,  1168,  1173,  1178,  1181,  1189,  1193,  1197,  1201,
    1205,  1205,  1212,  1212,  1219,  1219,  1226,  1226,  1233,  1240,
    1241,  1244,  1250,  1253,  1258,  1261,  1264,  1271,  1280,  1285,
    1288,  1293,  1298,  1303,  1311,  1317,  1332,  1337,  1343,  1351,
    1354,  1359,  1362,  1368,  1371,  1376,  1377,  1380,  1381,  1384,
    1387,  1392,  1396,  1400,  1403,  1408,  1411,  1416,  1421,  1426,
    1429,  1434,  1444,  1454,  1455,  1458,  1459,  1460,  1461,  1462,
    1463,  1464,  1465,  1466,  1467,  1468,  1469,  1472,  1480,  1490,
    1491,  1494,  1495,  1496,  1497,  1498,  1499,  1502,  1509,  1518,
    1519,  1522,  1523,  1524,  1525,  1526,  1527,  1530,  1539,  1545,
    1551,  1557,  1566,  1572,  1578,  1586,  1587,  1590,  1591,  1592,
    1593,  1596,  1599,  1604,  1609,  1615,  1618,  1623,  1626,  1630,
    1635,  1636,  1639,  1640,  1643,  1648,  1651,  1654,  1657,  1660,
    1663,  1666,  1669,  1672,  1675,  1680,  1683,  1688,  1691,  1694,
    1697,  1700,  1703,  1706,  1709,  1713,  1716,  1720,  1723,  1726,
    1731,  1734,  1737,  1740,  1743,  1746,  1749,  1752,  1755,  1760,
    1763,  1766,  1769,  1774,  1782,  1792,  1793,  1796,  1799,  1802,
    1805,  1810,  1811,  1814,  1817,  1822,  1823,  1826,  1829,  1834,
    1835,  1838,  1841,  1844,  1857,  1863,  1871,  1872,  1875,  1878,
    1881,  1886,  1889,  1894,  1899,  1900,  1903,  1906,  1911,  1912,
    1915,  1918,  1921,  1922,  1923,  1924,  1925,  1926,  1929,  1939,
    1942,  1947,  1951,  1957,  1962,  1968,  1969,  1974,  1979,  1980,
    1983,  1988,  1989,  1992,  1995,  1998,  2001,  2005,  2009,  2013,
    2017,  2021,  2025,  2029,  2033,  2037,  2043,  2047,  2054,  2060,
    2066,  2074,  2078,  2084,  2089,  2099,  2104,  2109,  2112,  2117,
    2120,  2125,  2128,  2133,  2136,  2141,  2144,  2149,  2154,  2159,
    2165,  2173,  2179,  2180,  2183,  2187,  2190,  2194,  2199,  2202,
    2205,  2206,  2209,  2210,  2211,  2212,  2213,  2214,  2215,  2216,
    2217,  2218,  2219,  2220,  2221,  2222,  2223,  2224,  2225,  2226,
    2227,  2228,  2229,  2230,  2231,  2232,  2233,  2234,  2235,  2236,
    2237,  2238,  2241,  2242,  2245,  2246,  2249,  2250,  2251,  2252,
    2255,  2260,  2265,  2272,  2275,  2278,  2284,  2287,  2291,  2296,
    2303,  2306,  2307,  2310,  2313,  2320,  2329,  2335,  2336,  2339,
    2340,  2341,  2342,  2343,  2344,  2345,  2348,  2354,  2355,  2358,
    2359,  2360,  2361,  2364,  2369,  2376,  2383,  2389,  2395,  2401,
    2407,  2413,  2419,  2425,  2431,  2437,  2442,  2447,  2454,  2459,
    2464,  2469,  2476,  2481,  2488,  2495,  2502,  2522,  2523,  2524,
    2527,  2528,  2532,  2537,  2542,  2549,  2554,  2559,  2566,  2567,
    2570,  2571,  2572,  2573,  2576,  2583,  2591,  2592,  2593,  2594,
    2595,  2596,  2597,  2598,  2601,  2602,  2603,  2604,  2605,  2606,
    2609,  2610,  2611,  2613,  2614,  2616,  2619,  2622,  2630,  2633,
    2636,  2640,  2643,  2646,  2649,  2654,  2665,  2676,  2686,  2698,
    2699,  2704,  2711,  2712,  2717,  2724,  2727,  2730,  2733,  2736,
    2741,  2744,  2747,  2752,  2756,  2763,  2769,  2770,  2771,  2774,
    2781,  2788,  2795,  2804,  2811,  2818,  2825,  2834,  2841,  2850,
    2857,  2866,  2873,  2882,  2888,  2889,  2890,  2891,  2892,  2895,
    2900,  2907,  2916,  2924,  2931,  2939,  2947,  2954,  2960,  2967,
    2975,  2978,  2984,  2990,  2997,  3003,  3010,  3016,  3023,  3026,
    3031,  3037,  3045,  3051,  3059,  3067,  3073,  3080,  3084,  3089,
    3096,  3101,  3109,  3117,  3125,  3133,  3141,  3149,  3159,  3167,
    3175,  3183,  3191,  3199,  3209,  3212,  3213,  3214
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 0
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "IF", "ELSE", "THEN", "FAILED", "SET",
  "LOGFILE", "FACILITY", "DAEMON", "SYSLOG", "MAILSERVER", "HTTPD",
  "ALLOW", "REJECTOPT", "ADDRESS", "INIT", "TERMINAL", "BATCH", "READONLY",
  "CLEARTEXT", "MD5HASH", "SHA1HASH", "CRYPT", "DELAY", "PEMFILE",
  "PEMKEY", "PEMCHAIN", "ENABLE", "DISABLE", "SSLTOKEN", "CIPHER",
  "CLIENTPEMFILE", "ALLOWSELFCERTIFICATION", "SELFSIGNED", "VERIFY",
  "CERTIFICATE", "CACERTIFICATEFILE", "CACERTIFICATEPATH", "VALID",
  "INTERFACE", "LINK", "PACKET", "BYTEIN", "BYTEOUT", "PACKETIN",
  "PACKETOUT", "SPEED", "SATURATION", "UPLOAD", "DOWNLOAD", "TOTAL", "UP",
  "DOWN", "IDFILE", "STATEFILE", "SEND", "EXPECT", "CYCLE", "COUNT",
  "REMINDER", "REPEAT", "LIMITS", "SENDEXPECTBUFFER", "EXPECTBUFFER",
  "FILECONTENTBUFFER", "HTTPCONTENTBUFFER", "PROGRAMOUTPUT",
  "NETWORKTIMEOUT", "PROGRAMTIMEOUT", "STARTTIMEOUT", "STOPTIMEOUT",
  "RESTARTTIMEOUT", "PIDFILE", "START", "STOP", "PATHTOK", "RSAKEY",
  "HOST", "HOSTNAME", "PORT", "IPV4", "IPV6", "TYPE", "UDP", "TCP",
  "TCPSSL", "PROTOCOL", "CONNECTION", "ALERT", "NOALERT", "MAILFORMAT",
  "UNIXSOCKET", "SIGNATURE", "TIMEOUT", "RETRY", "RESTART", "CHECKSUM",
  "EVERY", "NOTEVERY", "DEFAULT", "HTTP", "HTTPS", "APACHESTATUS", "FTP",
  "SMTP", "SMTPS", "POP", "POPS", "IMAP", "IMAPS", "CLAMAV", "NNTP",
  "NTP3", "MYSQL", "MYSQLS", "DNS", "WEBSOCKET", "MQTT", "SSH", "DWP",
  "LDAP2", "LDAP3", "RDATE", "RSYNC", "TNS", "PGSQL", "POSTFIXPOLICY",
  "SIP", "LMTP", "GPS", "RADIUS", "MEMCACHE", "REDIS", "MONGODB", "SIEVE",
  "SPAMASSASSIN", "FAIL2BAN", "STRING", "PATH", "MAILADDR", "MAILFROM",
  "MAILREPLYTO", "MAILSUBJECT", "MAILBODY", "SERVICENAME", "STRINGNAME",
  "NUMBER", "PERCENT", "LOGLIMIT", "CLOSELIMIT", "DNSLIMIT",
  "KEEPALIVELIMIT", "REPLYLIMIT", "REQUESTLIMIT", "STARTLIMIT",
  "WAITLIMIT", "GRACEFULLIMIT", "CLEANUPLIMIT", "REAL", "CHECKPROC",
  "CHECKFILESYS", "CHECKFILE", "CHECKDIR", "CHECKHOST", "CHECKSYSTEM",
  "CHECKFIFO", "CHECKPROGRAM", "CHECKNET", "THREADS", "CHILDREN", "METHOD",
  "GET", "HEAD", "STATUS", "ORIGIN", "VERSIONOPT", "READ", "WRITE",
  "OPERATION", "SERVICETIME", "DISK", "RESOURCE", "MEMORY", "TOTALMEMORY",
  "LOADAVG1", "LOADAVG5", "LOADAVG15", "SWAP", "MODE", "ACTIVE", "PASSIVE",
  "MANUAL", "ONREBOOT", "NOSTART", "LASTSTATE", "CORE", "CPU", "TOTALCPU",
  "CPUUSER", "CPUSYSTEM", "CPUWAIT", "CPUNICE", "CPUHARDIRQ", "CPUSOFTIRQ",
  "CPUSTEAL", "CPUGUEST", "CPUGUESTNICE", "GROUP", "REQUEST", "DEPENDS",
  "BASEDIR", "SLOT", "EVENTQUEUE", "SECRET", "HOSTHEADER", "UID", "EUID",
  "GID", "MMONIT", "INSTANCE", "USERNAME", "PASSWORD", "DATABASE", "TIME",
  "ATIME", "CTIME", "MTIME", "CHANGED", "MILLISECOND", "SECOND", "MINUTE",
  "HOUR", "DAY", "MONTH", "SSLV2", "SSLV3", "TLSV1", "TLSV11", "TLSV12",
  "TLSV13", "CERTMD5", "AUTO", "NOSSLV2", "NOSSLV3", "NOTLSV1", "NOTLSV11",
  "NOTLSV12", "NOTLSV13", "BYTE", "KILOBYTE", "MEGABYTE", "GIGABYTE",
  "INODE", "SPACE", "TFREE", "PERMISSION", "SIZE", "MATCH", "NOT",
  "IGNORE", "ACTION", "UPTIME", "RESPONSETIME", "EXEC", "UNMONITOR",
  "PING", "PING4", "PING6", "ICMP", "ICMPECHO", "NONEXIST", "EXIST",
  "INVALID", "DATA", "RECOVERED", "PASSED", "SUCCEEDED", "URL", "CONTENT",
  "PID", "PPID", "FSFLAG", "REGISTER", "CREDENTIALS", "URLOBJECT",
  "ADDRESSOBJECT", "TARGET", "TIMESPEC", "HTTPHEADER", "MAXFORWARD",
  "FIPS", "SECURITY", "ATTRIBUTE", "FILEDESCRIPTORS", "GREATER",
  "GREATEROREQUAL", "LESS", "LESSOREQUAL", "EQUAL", "NOTEQUAL", "'{'",
  "'}'", "':'", "'@'", "'['", "']'", "$accept", "cfgfile",
  "statement_list", "statement", "optproclist", "optproc", "optfilelist",
  "optfile", "optfilesyslist", "optfilesys", "optdirlist", "optdir",
  "opthostlist", "opthost", "optnetlist", "optnet", "optsystemlist",
  "optsystem", "optfifolist", "optfifo", "optprogramlist", "optprogram",
  "setalert", "setdaemon", "setterminal", "startdelay", "setinit",
  "setonreboot", "setexpectbuffer", "setlimits", "limitlist", "limit",
  "setfips", "setlog", "seteventqueue", "setidfile", "setstatefile",
  "setpid", "setmmonits", "mmonitlist", "mmonit", "mmonitoptlist",
  "mmonitopt", "credentials", "setssl", "ssl", "ssloptionlist",
  "ssloption", "sslexpire", "expireoperator", "sslchecksum",
  "checksumoperator", "sslversionlist", "sslversion", "certmd5",
  "setmailservers", "setmailformat", "mailserverlist", "mailserver",
  "mailserveroptlist", "mailserveropt", "sethttpd", "httpdlist",
  "httpdoption", "pemfile", "clientpemfile", "allowselfcert", "httpdport",
  "httpdsocket", "httpdsocketoptionlist", "httpdsocketoption", "sigenable",
  "sigdisable", "signature", "bindaddress", "allow", "$@1", "$@2", "$@3",
  "$@4", "allowuserlist", "allowuser", "readonly", "checkproc",
  "checkfile", "checkfilesys", "checkdir", "checkhost", "checknet",
  "checksystem", "checkfifo", "checkprogram", "start", "stop", "restart",
  "argumentlist", "useroptionlist", "argument", "useroption", "username",
  "password", "database", "hostname", "connection", "connectionoptlist",
  "connectionopt", "connectionurl", "connectionurloptlist",
  "connectionurlopt", "connectionunix", "connectionuxoptlist",
  "connectionuxopt", "icmp", "icmpoptlist", "icmpopt", "host", "port",
  "unixsocket", "ip", "type", "typeoptlist", "typeopt", "outgoing",
  "protocol", "sendexpect", "websocketlist", "websocket", "smtplist",
  "smtp", "mqttlist", "mqtt", "mysqllist", "mysql", "postgresqllist",
  "postgresql", "target", "maxforward", "siplist", "sip", "httplist",
  "http", "status", "method", "request", "responsesum", "hostheader",
  "httpheaderlist", "secret", "radiuslist", "radius", "apache_stat_list",
  "apache_stat", "exist", "pid", "ppid", "uptime", "responsetime",
  "icmpcount", "icmpsize", "icmptimeout", "icmpoutgoing", "stoptimeout",
  "starttimeout", "restarttimeout", "programtimeout", "nettimeout",
  "connectiontimeout", "retry", "actionrate", "urloption", "urloperator",
  "alert", "alertmail", "noalertmail", "eventoptionlist", "eventoption",
  "formatlist", "formatoptionlist", "formatoption", "every", "mode",
  "onreboot", "group", "depend", "dependlist", "dependant", "statusvalue",
  "resourceprocess", "resourceprocesslist", "resourceprocessopt",
  "resourcesystem", "resourcesystemlist", "resourcesystemopt",
  "resourcecpuproc", "resourcecpu", "resourcecpuid", "resourcemem",
  "resourcememproc", "resourceswap", "resourcethreads", "resourcechild",
  "resourceload", "resourceloadavg", "coremultiplier", "resourceread",
  "resourcewrite", "value", "timestamptype", "timestamp", "operator",
  "time", "totaltime", "currenttime", "repeat", "action", "action1",
  "action2", "rateXcycles", "rateXYcycles", "rate1", "rate2",
  "recovery_success", "recovery_failure", "checksum", "hashtype", "inode",
  "space", "read", "write", "servicetime", "fsflag", "unit", "permission",
  "programmatch", "match", "matchflagnot", "size", "uid", "euid",
  "secattr", "filedescriptorssystem", "filedescriptorsprocess",
  "filedescriptorsprocesstotal", "gid", "linkstatus", "linkspeed",
  "linksaturation", "upload", "download", "icmptype", "reminder", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_int16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   123,   125,    58,    64,    91,    93
};
# endif

#define YYPACT_NINF (-1344)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-750)

#define yytable_value_is_error(Yyn) \
  0

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
     803,    42,  -101,   -35,   -16,    84,   107,   115,   139,   147,
     166,   141,   803, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
   -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
   -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
   -1344,    55,   175,   204, -1344, -1344,   346,  -140,   239,   247,
      91,   276,   297,   290,   146,   150,   461,   190, -1344,   -43,
      48,   422,   432,   445,   468, -1344,   452,   462,    92, -1344,
   -1344,  1051,   603,  1483,  1644,  1680,  1685,  1711,  1644,  1724,
     533, -1344,   472,   482,    20, -1344,  1209, -1344, -1344, -1344,
   -1344, -1344,   745, -1344, -1344,   858, -1344, -1344, -1344,   431,
     425, -1344,   190,   300,   284,   310,  1443,   559,   483,   487,
     549,   566,   502,   519,   499,   531,   584,   537,   553,   775,
     584,   584,   578,   584,   -71,   450,   218,   291,   594,   567,
   -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
   -1344, -1344, -1344,    62, -1344, -1344, -1344, -1344, -1344, -1344,
   -1344, -1344, -1344, -1344, -1344, -1344, -1344,   100,  -142, -1344,
   -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
   -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344,   196, -1344,
   -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
   -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
     123, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
   -1344, -1344, -1344, -1344, -1344, -1344, -1344,    17, -1344, -1344,
   -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
   -1344, -1344,   161, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
   -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344,  1026,
   -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
   -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
   -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
     -56, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
   -1344, -1344, -1344, -1344,   622,   741, -1344,   621,   673,   626,
   -1344,   697,    10,   641,   644,   693,   696,   511,   671, -1344,
     670,   689,   777, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
   -1344, -1344, -1344, -1344, -1344,   125,   118, -1344, -1344, -1344,
   -1344, -1344,   550,   561, -1344, -1344,    54, -1344,   665, -1344,
     860,   300,   605, -1344,   858,  1443, -1344, -1344, -1344, -1344,
   -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
   -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
   -1344, -1344, -1344, -1344, -1344, -1344,  1088, -1344,   752, -1344,
   -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
   -1344, -1344,   443, -1344, -1344, -1344,   136,   610,   811,   814,
     814,   814,   814,   666,   814,   814, -1344, -1344, -1344,   814,
     814,   571,   654,   814,   782,    11,   814,  1758, -1344, -1344,
   -1344, -1344, -1344, -1344,   735, -1344, -1344,   490,   509, -1344,
     572,   875, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
   -1344, -1344,   567, -1344,   642,  1443,   559,    41, -1344, -1344,
   -1344, -1344,    78,   814,   654,   624,   814,   699, -1344,   624,
     724,   424,   814,   814,   814,  -155,   790,   893,   438,   203,
     282,   914,   831,   814,   814,   814,   886,   943,   814,   814,
   -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
     814,  1641, -1344, -1344,   814, -1344, -1344, -1344,   814,   812,
     624, -1344,   845, -1344,   912,   265,   884, -1344, -1344, -1344,
   -1344, -1344, -1344,   888, -1344, -1344, -1344, -1344, -1344, -1344,
   -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344,   794,   895,
   -1344,   892,   899,   907,   755,   924,   926, -1344, -1344, -1344,
   -1344, -1344, -1344, -1344, -1344, -1344, -1344,   757,   815,   816,
     817,   824,   834,   835,   839,   848,   849, -1344, -1344,   850,
     851,   852,   854,   855,   856,   866,   867,   874, -1344, -1344,
   -1344, -1344, -1344, -1344,   970,   975, -1344, -1344, -1344, -1344,
   -1344, -1344, -1344,   315,  1160,  1032, -1344,  1066,   981,    87,
      89,   186, -1344, -1344, -1344,   992,  1024,   377,   480,   581,
     880,   846,  1092, -1344,   814,  1031, -1344, -1344, -1344, -1344,
   -1344, -1344, -1344,  1033,  1034,    -5,    -5,   814,   814,    -5,
      -5,    -5,    -5,   782,   782,   782,  1036,    -3, -1344, -1344,
    1180,   902,  1092, -1344,    23, -1344,  1190, -1344,   814,  1048,
     286, -1344,  1049,   339, -1344,  1050,   407, -1344, -1344, -1344,
    1443,  1236, -1344, -1344, -1344,  1052,  1101,   782,   782,   782,
    1105,  1063, -1344, -1344,   836,  1068,   869,   873,   878,   287,
     331,   366,   782,   814,   400,   814,    -5, -1344, -1344, -1344,
    1133, -1344, -1344, -1344,  1133,   782,   782,   782,  1070,  1071,
    1072,   814,   814,   782,    -5,    -5,   449, -1344,  1216,    -5,
    1074,   782,  1097, -1344,   673,    13, -1344, -1344, -1344, -1344,
   -1344, -1344,  1098,  1107,  1108,  1112,  1113,  1233,   142,   535,
    1119,  1121,  1128,  1130,  1132,  1006,  1000,  1134,  1135, -1344,
    1122,  1125,  1129,  1131,  1138,  1139,  1140,  1151,  1152, -1344,
    1045, -1344,  1032,   559, -1344,  1073, -1344, -1344, -1344, -1344,
   -1344, -1344, -1344, -1344,   782,   782,   782,   782,   782,   782,
   -1344,   897,  1153, -1344,   143,  1158,  1249, -1344, -1344, -1344,
   -1344,   745,   745,   474,   496,   446,   465,  1162,  1166,  1312,
    1313,  1314,   708, -1344,  1261,   157, -1344, -1344,   143,    46,
    1173,   157,    -5,  1096, -1344,  1102, -1344,  1106, -1344,  1350,
    1032,   782,    28,  1318,  1324,  1327,   782,   745,   782,   782,
     708,   782,   782, -1344, -1344, -1344, -1344,  1156,   745,  1159,
     745,  1110,  1111,  1333,   498,    46,  1192,    -5,   552,    31,
      31,    31,  1076, -1344,    31,    31,    31, -1344,  1339,  1343,
    1344,  1203,    -1,    14,  1206,  1207,  1351,   615,   727,    46,
    1208,   157,  1210,   782,  1359,   782,  1065,  1065, -1344,  1227,
    1113,  1113,  1113,  1233, -1344,  1113, -1344, -1344, -1344, -1344,
     597,   614,  1224, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
   -1344, -1344, -1344, -1344, -1344,  1760,   745,   745,   745,   745,
     819,   821,   825,   827,   837, -1344,   559, -1344, -1344,  1362,
    1368,  1369,  1370,  1371,  1373,    44,   782,   782, -1344,   751,
    1241,  1243,   368,  1857,  1235,  1238,   814, -1344, -1344, -1344,
   -1344, -1344, -1344, -1344,  1379,   782,  1382,  1157,  1157,  1213,
     745,  1228,   745, -1344, -1344, -1344, -1344, -1344, -1344,   157,
     157,   157, -1344, -1344, -1344, -1344, -1344,   782, -1344, -1344,
   -1344, -1344, -1344,   584, -1344, -1344,  1385,    44,   751,  1404,
    1405,   782,  1385, -1344, -1344, -1344, -1344,  1032,   559,  1407,
    1251,  1408,   157,   157,   157,  1409,   782,  1410,  1411,   782,
    1415,  1416,   782,  1157,   782,  1157,   782,   782,   157,    46,
    1275,  1421,   782,   739,   782,   782,  1288,  1280,  1281,  1283,
   -1344, -1344, -1344, -1344, -1344,  1431,  1432,  1433, -1344,    31,
    1439,  1441,  1442,    31,   157,   157,   157,   782,  1157,  1157,
    1157,  1157,    22,    80,   157, -1344, -1344, -1344, -1344,  1444,
     782,  1385, -1344,  1445,   157,  1446,  1315,  1317, -1344,  1113,
    1113,  1113, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
   -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
   -1344, -1344, -1344, -1344, -1344,   157,   157,   157,   157,   157,
     157,    74,   624, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
    1447,  1453,  1454,  1321, -1344, -1344, -1344, -1344, -1344, -1344,
   -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344,  1457,
   -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344,   922, -1344,
   -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
   -1344, -1344,   347, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
   -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
   -1344, -1344, -1344,  1242, -1344,  1326,   157,  1467,   388, -1344,
   -1344, -1344, -1344,  1157, -1344,  1157, -1344, -1344,  1385,  1470,
     326,    34, -1344,  1471,  1474,   157,   157,  1475, -1344,   559,
   -1344,   157,   782,   157,  1385, -1344, -1344,   157,  1478,   157,
     157,  1479,   157,   157,  1490,   782,  1491,   782,  1492,  1495,
   -1344,  1497,   782,   157,  1498,   782,   782,  1499,  1500, -1344,
   -1344,  1276, -1344,   157,   157,   157,  1507,   157,   157,   157,
    1509,  1385,  1511,  1385,  1515,   782,   782,   782,   782,   -86,
     356,   539,   583,  1385,   157,  1516, -1344,   157, -1344,   157,
   -1344, -1344,  1385,  1385,  1385,  1385,  1385,  1385,  1226,  1384,
     157,   157,   157, -1344,   157,  1620,   258,   258,  1387,   814,
     814,   814,   814,   814,   814,   814,   814,   814,   814, -1344,
   -1344,   922, -1344,   822,   822,    -2,    -2,  1389,  1390,  1383,
    1395,   347, -1344,   822,   647,    29,  1322, -1344,   862,  1385,
     157, -1344, -1344, -1344, -1344, -1344,   157,  1437,    75, -1344,
     518, -1344, -1344,   157,   157,  1511,  1385,   157, -1344,  1385,
    1525,  1385, -1344, -1344,   157, -1344, -1344,   157, -1344, -1344,
     157,  1535,   157,  1537,   157,   157,   157,  1538,  1385,   157,
    1539,  1540,   157,   157, -1344,  1385,  1385,  1385,   157,  1511,
    1511,  1511,   157, -1344,    45, -1344, -1344,   157,  1541,  1542,
    1545,  1546,   648, -1344, -1344, -1344,   782,   648,   782,   648,
     782,   648,   782, -1344,  1385,   157,  1385, -1344, -1344, -1344,
   -1344, -1344, -1344, -1344, -1344,  1412, -1344,  1385,  1385,  1385,
    1385, -1344, -1344, -1344,  1413,   921,   814,   977,  1417, -1344,
   -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344,  1414,
    1418,  1420,  1422,  1424,  1428,  1429,  1430,  1449,  1450, -1344,
   -1344, -1344, -1344,  1459, -1344, -1344, -1344, -1344, -1344, -1344,
   -1344, -1344, -1344, -1344, -1344,  1425, -1344, -1344, -1344, -1344,
     427,  1455, -1344, -1344, -1344,  1426, -1344, -1344, -1344, -1344,
   -1344,  1385,  1385,    68, -1344,   782,   782,   782,  1511,  1511,
   -1344, -1344,  1385, -1344,   157, -1344,  1385,  1385,  1385,   157,
    1385,   157,  1385,  1385,  1385,   157, -1344,  1385,   157,   157,
    1385,  1385, -1344, -1344, -1344,  1385, -1344, -1344, -1344,  1511,
    1549, -1344,  1385,   157,   157,   157,   157,   782,  1556,   782,
    1558,   782,  1574,   782,  1576, -1344,  1385, -1344,  1372, -1344,
   -1344, -1344, -1344, -1344, -1344, -1344,  1456, -1344, -1344, -1344,
      69,  1460,  1461,  1462,  1468,  1472,  1480,  1485,  1486,  1488,
    1503,    16, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
    1557, -1344, -1344,  1600,  1614,  1622, -1344, -1344, -1344,  1385,
   -1344, -1344, -1344,  1385, -1344,  1385, -1344, -1344, -1344,  1385,
   -1344,  1385,  1385, -1344, -1344, -1344, -1344,   782, -1344,  1385,
    1385,  1385,  1385,  1623,   157,  1643,   157,  1650,   157,  1652,
     157, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
   -1344, -1344, -1344, -1344, -1344, -1344,  1065,  1065,  1519, -1344,
     157,   157,   157, -1344, -1344, -1344, -1344, -1344, -1344,  1654,
   -1344, -1344, -1344, -1344,   157,  1385,   157,  1385,   157,  1385,
     157,  1385,  1522,  1524, -1344, -1344, -1344, -1344,   157,  1385,
   -1344,  1385, -1344,  1385, -1344,  1385, -1344, -1344, -1344, -1344,
   -1344, -1344, -1344, -1344
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       2,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     3,     4,     6,     8,     9,    20,    22,    19,
      21,    23,    10,    11,    17,    18,    16,    12,     7,    13,
      14,    15,    33,    59,    79,   101,   118,   133,   150,   165,
     182,     0,     0,     0,   304,   203,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   225,   632,
       0,     0,     0,     0,     0,   365,     0,     0,     0,     1,
       5,    24,    25,    26,    27,    28,    32,    29,    30,    31,
     227,   226,   201,   295,   585,   291,   303,   200,   251,   232,
     233,   209,   784,   234,   598,     0,   204,   205,   206,     0,
       0,   239,   235,   246,     0,     0,     0,   835,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      34,    35,    36,    37,    48,    49,    50,    38,    39,    40,
      47,    51,    52,   632,   597,    53,    54,    55,    56,    57,
      58,    41,    42,    43,    44,    45,    46,   800,   800,    60,
      61,    62,    63,    64,    66,    68,    67,    75,    76,    77,
      78,    65,    72,    69,    74,    73,    70,    71,     0,    80,
      81,    82,    83,    84,    85,    87,    86,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,    88,    89,    90,
       0,   102,   103,   104,   105,   106,   108,   110,   109,   114,
     115,   116,   117,   107,   111,   112,   113,     0,   119,   120,
     121,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,     0,   134,   135,   136,   137,   143,   147,   144,
     145,   146,   148,   149,   138,   139,   140,   141,   142,     0,
     151,   152,   153,   154,   163,   155,   156,   157,   158,   159,
     160,   161,   162,   164,   166,   167,   168,   169,   170,   172,
     174,   173,   178,   179,   180,   181,   171,   175,   176,   177,
       0,   183,   184,   185,   186,   187,   188,   189,   190,   191,
     192,   193,   194,   195,     0,     0,   199,     0,   293,     0,
     292,   389,     0,     0,     0,     0,     0,   249,     0,   317,
       0,     0,     0,   306,   305,   307,   308,   309,   313,   314,
     331,   332,   310,   311,   312,     0,     0,   785,   786,   787,
     788,   207,     0,     0,   638,   639,     0,   634,   229,   231,
     238,   246,     0,   236,     0,     0,   616,   603,   604,   618,
     619,   626,   624,   606,   628,   605,   627,   623,   630,   612,
     614,   629,   620,   625,   602,   631,   609,   613,   617,   610,
     615,   608,   607,   621,   622,   611,     0,   600,     0,   196,
     354,   355,   356,   357,   360,   359,   358,   361,   362,   366,
     379,   380,   583,   375,   363,   364,   441,     0,     0,   716,
     716,   716,   716,     0,   716,   716,   697,   698,   699,   716,
     716,     0,     0,   716,   749,   441,   716,   749,   657,   659,
     660,   661,   662,   663,   700,   664,   665,   579,   577,   599,
     581,     0,   641,   642,   643,   644,   645,   646,   647,   648,
     649,   653,   650,   651,     0,     0,   835,   766,   710,   711,
     712,   713,   766,   716,   801,     0,   716,     0,   801,     0,
       0,     0,   716,   716,   716,     0,   716,   716,     0,   441,
     441,     0,     0,   716,   716,   716,     0,     0,   716,   716,
     685,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     716,   749,   667,   672,   716,   670,   671,   669,   716,     0,
       0,   228,     0,   295,     0,     0,     0,   275,   277,   279,
     281,   283,   285,     0,   287,   276,   278,   280,   282,   284,
     286,   299,   300,   301,   302,   296,   297,   298,     0,     0,
     289,     0,     0,     0,   348,   336,     0,   333,   315,   328,
     330,   251,   316,   318,   320,   327,   329,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   248,   252,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   208,   210,
     636,   637,   290,   635,     0,     0,   240,   242,   243,   244,
     245,   237,   247,     0,     0,   632,   601,   836,     0,     0,
       0,   583,   376,   377,   367,     0,     0,     0,     0,     0,
       0,     0,     0,   419,   716,     0,   723,   717,   718,   719,
     720,   721,   722,     0,     0,     0,     0,   716,   716,     0,
       0,     0,     0,   749,   749,   749,     0,     0,   750,   751,
       0,     0,     0,   419,     0,   658,     0,   701,   716,     0,
     579,   369,     0,   577,   371,     0,   581,   373,   640,   652,
       0,     0,   594,   767,   768,     0,     0,   749,   749,   749,
       0,     0,   592,   593,     0,     0,     0,     0,     0,     0,
       0,     0,   749,   716,     0,   716,     0,   435,   435,   435,
       0,   435,   435,   435,     0,   749,   749,   749,     0,     0,
       0,   716,   716,   749,     0,     0,     0,   668,     0,     0,
       0,   749,     0,   202,   294,   271,   386,   385,   387,   288,
     586,   390,   337,   338,   339,     0,     0,   352,     0,   319,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   273,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   230,
       0,   633,   632,   835,   837,     0,   381,   383,   382,   384,
     378,   368,   442,   444,   749,   749,   749,   749,   749,   749,
     409,     0,     0,   393,   749,     0,     0,   694,   695,   709,
     708,   784,   784,     0,     0,   784,   784,     0,     0,     0,
       0,     0,   724,   747,     0,     0,   409,   393,   749,   709,
       0,     0,     0,     0,   370,     0,   372,     0,   374,     0,
     632,   749,   749,     0,     0,     0,   749,   784,   749,   749,
     724,   749,   749,   795,   794,   799,   798,   709,   784,   709,
     784,   709,     0,     0,     0,   709,     0,     0,   784,   749,
     749,   749,     0,   435,   749,   749,   749,   435,     0,     0,
       0,     0,   784,   784,     0,     0,     0,   784,   784,   709,
       0,     0,     0,   749,     0,   749,   271,   271,   272,     0,
       0,     0,     0,   352,   351,   341,   349,   353,   335,   250,
       0,     0,     0,   321,   259,   261,   260,   258,   262,   255,
     256,   253,   254,   263,   264,   257,   784,   784,   784,   784,
       0,     0,     0,     0,     0,   241,   835,   197,   584,     0,
       0,     0,     0,     0,     0,   749,   749,   749,   443,   749,
       0,     0,     0,     0,     0,     0,   716,   420,   421,   422,
     423,   425,   424,   426,     0,   749,     0,   733,   733,   709,
     784,   709,   784,   689,   688,   691,   690,   673,   674,     0,
       0,     0,   725,   726,   727,   728,   729,   749,   748,   742,
     743,   738,   741,     0,   744,   745,   755,   749,   749,     0,
       0,   749,   755,   696,   580,   578,   582,   632,   835,     0,
       0,     0,     0,     0,     0,     0,   749,     0,     0,   749,
       0,     0,   749,   733,   749,   733,   749,   749,     0,   709,
       0,     0,   749,   784,   749,   749,     0,     0,     0,     0,
     436,   437,   438,   439,   440,     0,     0,     0,   834,   749,
       0,     0,     0,   749,     0,     0,     0,   749,   733,   733,
     733,   733,   784,   784,     0,   687,   686,   693,   692,     0,
     749,   755,   675,     0,     0,     0,     0,     0,   268,   343,
     345,   347,   334,   350,   322,   324,   323,   325,   326,   274,
     211,   212,   213,   214,   215,   216,   217,   218,   221,   222,
     219,   220,   223,   224,   198,     0,     0,     0,     0,     0,
       0,     0,     0,   414,   416,   415,   410,   412,   413,   411,
       0,     0,     0,     0,   445,   446,   404,   406,   405,   394,
     395,   396,   402,   397,   398,   401,   400,   403,   399,     0,
     493,   494,   449,   447,   450,   457,   528,   528,     0,   461,
     501,   501,   478,   479,   465,   466,   456,   475,   476,   509,
     509,   458,     0,   505,   490,   459,   467,   468,   482,   484,
     491,   516,   480,   524,   469,   462,   548,   470,   483,   471,
     485,   489,   460,     0,   588,     0,     0,     0,     0,   734,
     702,   705,   704,   733,   707,   733,   568,   569,   755,     0,
     735,     0,   567,     0,     0,     0,     0,     0,   656,   835,
     595,     0,   749,     0,   755,   803,   715,     0,     0,     0,
       0,     0,     0,     0,     0,   749,     0,   749,     0,     0,
     783,     0,   749,     0,     0,   749,   749,     0,     0,   576,
     573,     0,   574,     0,     0,     0,     0,     0,     0,     0,
       0,   755,   760,   755,     0,   749,   749,   749,   749,     0,
       0,     0,     0,   755,     0,     0,   666,     0,   655,     0,
     269,   270,   755,   755,   755,   755,   755,   755,   266,     0,
       0,     0,     0,   454,     0,   448,   463,   464,     0,   716,
     716,   716,   716,   716,   716,   716,   716,   716,   716,   553,
     554,   455,   551,   487,   488,   473,   474,     0,     0,     0,
       0,   492,   495,   472,   477,   486,   481,   587,     0,   755,
       0,   590,   589,   703,   706,   566,     0,     0,   735,   739,
       0,   746,   756,     0,     0,   760,   755,     0,   596,   755,
       0,   755,   790,   765,     0,   793,   792,     0,   797,   796,
       0,     0,     0,     0,     0,     0,     0,     0,   755,     0,
       0,     0,     0,     0,   575,   755,   755,   755,     0,   760,
     760,   760,     0,   817,     0,   819,   818,     0,     0,     0,
       0,     0,     0,   730,   731,   732,   749,     0,   749,     0,
     749,     0,   749,   820,   755,     0,   755,   791,   804,   805,
     806,   807,   815,   816,   267,     0,   591,   755,   755,   755,
     755,   452,   453,   451,     0,     0,   716,     0,     0,   545,
     530,   531,   529,   534,   535,   532,   533,   536,   555,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   552,
     503,   504,   502,     0,   511,   512,   510,   499,   497,   500,
     498,   496,   507,   508,   506,     0,   518,   519,   520,   517,
       0,     0,   526,   527,   525,     0,   550,   549,   571,   572,
     417,   755,   755,     0,   740,   752,   752,   752,   760,   760,
     418,   812,   755,   789,     0,   763,   755,   755,   755,     0,
     755,     0,   755,   755,   755,     0,   769,   755,     0,     0,
     755,   755,   428,   429,   430,   755,   432,   433,   434,   760,
       0,   761,   755,     0,     0,     0,     0,   749,     0,   749,
       0,   749,     0,   749,     0,   810,   755,   654,     0,   407,
     808,   809,   391,   543,   539,   540,     0,   542,   541,   544,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   271,   388,   522,   521,   523,   547,   814,   570,   736,
       0,   753,   754,     0,     0,     0,   408,   392,   813,   755,
     802,   714,   778,   755,   780,   755,   781,   782,   771,   755,
     770,   755,   755,   774,   773,   427,   431,   752,   821,   755,
     755,   755,   755,     0,     0,     0,     0,     0,     0,     0,
       0,   811,   265,   538,   546,   537,   556,   557,   558,   559,
     560,   561,   562,   563,   564,   565,   271,   271,     0,   737,
       0,     0,     0,   764,   777,   779,   772,   776,   775,     0,
     825,   822,   831,   828,     0,   755,     0,   755,     0,   755,
       0,   755,     0,     0,   513,   757,   758,   759,     0,   755,
     826,   755,   823,   755,   832,   755,   829,   514,   515,   762,
     827,   824,   833,   830
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -1344, -1344, -1344,  1653, -1344, -1344, -1344, -1344, -1344, -1344,
   -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
   -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
   -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
    1564, -1344, -1344,  1329, -1344,   -83,  1126, -1344,  -822, -1344,
    -318,  -828, -1344,  -339,  -338, -1344, -1344, -1344,  1585,  1168,
   -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
   -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
     145,  -795,   809, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
   -1344, -1344,  1219,  1328,  1392,  -104,  -403,  -384,  -558,  -746,
    -423, -1344, -1344,  1603,   894, -1344,  1605,   896, -1344, -1344,
    1053, -1344, -1344,  -147, -1344,  -326,  1055,  1269, -1344,  -792,
   -1344, -1344, -1344,  -753,  -695, -1344,   414,   579, -1344, -1344,
   -1344,   569, -1344, -1344, -1344, -1344, -1344, -1344, -1344,   586,
   -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
   -1344,   430,   747, -1344, -1344,  1618,  -588, -1344, -1344, -1344,
   -1344,  1054,  1056,  1057,  1116, -1344,  -307,  -172,  1512,  -531,
    -447,  1567,  1697, -1344,  -332,  -350,  -139,  1358,  -306,  1673,
    1690,  1718,  1808,  1875, -1344,  1262, -1344, -1344, -1344,  1292,
   -1344, -1344,  1220, -1344, -1344, -1344, -1344, -1344, -1344, -1344,
   -1344,  -208, -1344, -1344, -1344, -1344,   980,  -356,   308,  -395,
     900,  -667,  -508,   433, -1141,  -572, -1294,  -856,  -820,  -417,
   -1343,  -285,  -932, -1344,  1260, -1344, -1344, -1344, -1344, -1344,
   -1344,   706,   685, -1344, -1344,  1572, -1344,   758, -1344, -1344,
   -1344, -1344, -1344,   820, -1344, -1344, -1344, -1344, -1344,  1038,
    -435
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    11,    12,    13,    71,   130,    72,   159,    73,   179,
      74,   201,    75,   218,    76,   233,    77,   250,    78,   264,
      79,   281,    14,    15,    16,   296,    17,    18,    19,    20,
     326,   569,    21,    22,    23,    24,    25,    26,    27,   102,
     103,   340,   576,   343,    28,   521,   325,   558,  1074,  1365,
     522,   859,   885,   523,   524,    29,    30,    84,    85,   298,
     525,    31,    86,   314,   315,   316,   317,   318,   319,   719,
     873,   320,   321,   322,   323,   324,   716,   860,   861,   862,
     865,   866,   868,    32,    33,    34,    35,    36,    37,    38,
      39,    40,   131,   132,   133,   392,   591,   393,   593,   526,
     527,  1418,   530,   134,   909,  1089,   135,   905,  1076,   136,
     764,   917,   224,   829,  1000,   602,   763,   603,  1090,   918,
    1245,  1373,  1092,   919,   920,  1271,  1272,  1263,  1402,  1273,
    1414,  1265,  1406,  1274,  1419,  1422,  1423,  1275,  1424,  1246,
    1382,  1383,  1384,  1385,  1386,  1387,  1500,  1426,  1276,  1427,
    1261,  1262,   137,   138,   139,   140,   921,  1001,  1002,  1003,
    1004,   644,   641,   647,   594,   301,   922,   923,   141,  1079,
     664,   142,   143,   144,   376,   377,   107,   336,   337,   145,
     146,   147,   148,   149,   442,   443,   292,   150,   417,   418,
     262,   491,   492,   419,   493,   494,   495,   420,   496,   421,
     422,   423,   424,   638,   425,   426,   771,   456,   171,   613,
     947,  1346,  1150,  1289,   955,   956,  1292,   628,   629,   630,
    1523,  1162,  1335,   172,   656,   191,   192,   193,   194,   195,
     196,   331,   173,   293,   174,   457,   175,   151,   152,   153,
     263,   154,   155,   156,   244,   245,   246,   247,   248,   833,
     379
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     636,   579,   580,   313,   446,   614,   615,   616,   592,   619,
     620,   652,   667,   584,   621,   622,   427,   428,   626,   430,
    1291,   634,   578,   469,   640,   643,   586,   646,  1036,  1037,
     573,   531,   532,   750,   533,   856,   857,  1290,  1576,  1577,
    1471,   497,  1018,   592,   592,    60,   592,   996,  1470,   104,
      41,  -749,    42,   702,    43,    44,   783,  1020,   661,    45,
      46,   665,  1342,   653,   654,  1219,    80,   669,   670,   671,
    1043,   674,   676,    47,   698,   307,  1403,   431,   688,   689,
     690,  1071,   750,   694,   695,   750,   970,  1087,   750,   632,
     595,   997,   398,  1524,  1525,   696,   659,    48,    49,   699,
     653,   654,   657,   700,   596,    50,   447,    51,   117,   949,
     950,    61,   659,   651,  1238,   299,    52,  1091,   458,   498,
     949,   950,   108,  1221,   951,   109,   998,  1519,   672,   461,
      62,   952,    53,   118,    54,   951,  1087,  1287,   459,   914,
     915,    69,   952,   769,   632,   784,  1343,  1344,  1345,   534,
     535,   547,   548,   549,   104,   770,  1093,   550,   551,    83,
     552,   553,    88,   554,   555,   398,  1091,   471,   547,   548,
     549,   789,   705,   499,   550,   551,   627,   552,   553,   627,
     554,   555,   559,   770,   560,   561,   562,   563,   564,   565,
     566,   567,   627,  1291,   627,    81,   332,   333,   334,   335,
     910,   911,   461,   472,  1589,  1093,   779,   780,   781,   765,
     473,   474,   475,   476,  1094,   595,  1520,   105,   432,   962,
     505,   506,   773,   774,   500,    96,   746,   912,   748,   596,
      63,   913,   949,   950,   586,   747,    55,   749,   914,   915,
     803,   804,   805,   792,  1043,  1043,  1043,   951,   398,   327,
     328,   329,   330,    64,   952,   823,    56,   577,   597,   106,
     599,    65,    57,  1094,   327,   328,   329,   330,   838,   839,
     840,   398,   327,   328,   329,   330,   846,   573,   824,  1031,
     827,   588,   595,   497,   854,    66,  1605,  1606,  1607,   999,
     631,   627,   589,    67,   590,   470,   844,   845,   655,   953,
     954,   586,   556,   448,   449,   450,   451,   110,   897,   398,
     953,   954,    68,   858,  1619,   536,   858,  1420,   799,   556,
    1421,  1095,   444,    82,  1072,   448,   449,   450,   451,   452,
     327,   328,   329,   330,    58,   657,   658,   899,   900,   901,
     902,   903,   904,    83,   398,    97,    98,   924,   448,   449,
     450,   451,   468,   597,   598,   599,  1374,   572,   453,  1564,
     454,   595,  1259,  1440,   445,    87,   437,  1156,  1157,  1158,
    1095,   959,   960,   414,   462,   463,  1565,   464,  1098,    89,
     455,   639,   213,   412,   969,   971,   276,    90,  1287,   975,
     477,   977,   978,    91,   980,   981,   414,  1466,  1467,  1468,
    1174,  1175,  1176,   589,   706,   590,   707,   916,   991,   434,
     435,   436,  1005,  1006,  1007,   600,  1190,  1010,  1011,  1012,
    1151,   568,   953,   954,    92,   465,  1267,  1098,   557,   601,
    1375,    94,  1029,  1376,   642,   817,  1033,    93,  1035,  1291,
    1291,  1291,  1211,  1212,  1213,   869,   743,   770,    95,   586,
     466,   467,  1223,  1102,  1103,  1104,   412,   332,   333,   334,
     335,  1064,  1228,   949,   950,   390,   391,  1291,  1377,   414,
     677,   678,   679,   680,  1378,  1185,   101,  1187,   951,   819,
     505,   506,   600,  1281,   114,   952,   438,   439,  1080,  1081,
    1082,   770,  1099,  1232,  1233,  1234,  1235,  1236,  1237,   111,
    1380,  1380,   645,   589,  1347,   590,  1526,  1527,  1147,   112,
    1215,  1216,  1217,  1218,   821,  1259,   754,  1400,  1400,  1404,
    1404,  1145,   113,  1268,  1269,   755,   770,  1412,  1416,   115,
    1159,   830,   831,  1170,   834,   835,   836,  1546,   588,   116,
    1163,  1164,   294,   589,  1167,   590,  1049,   295,   825,   681,
     682,   683,   684,  1348,  1350,  1352,   589,  1270,   590,  1178,
     770,   631,  1181,   297,  1379,  1184,  1513,  1186,  1514,  1188,
    1189,   338,  1191,   339,  1279,  1194,  1282,  1197,  1198,  1521,
    1521,  1521,   390,   391,   342,   639,   344,  1075,  1343,  1344,
    1345,  1088,  1206,  1295,  1296,   933,  1210,   849,  1077,  1299,
    1214,  1301,  1096,   896,   642,  1303,   157,  1305,  1306,   770,
    1308,  1309,   345,  1225,   935,  1522,  1522,  1522,   741,   756,
     378,  1318,   929,   380,   589,  1239,   590,   381,   757,   390,
     391,  1325,  1326,  1327,   770,  1329,  1330,  1331,   388,  1075,
    1088,   597,   386,   599,   931,  1283,   989,  1284,   390,   391,
    1077,  1096,  1354,   953,   954,  1356,   770,  1357,   770,   387,
     589,   968,   590,   448,   449,   450,   451,   645,  1367,  1368,
    1369,   389,  1370,    99,   100,  1477,   394,  1168,   120,   121,
    1479,   655,  1481,  1578,  1483,  1260,  1009,  1349,   382,   383,
    1013,  1521,   395,    53,   122,   657,   327,   328,   329,   330,
     123,   994,   124,   125,   307,   384,   385,   589,  1431,   590,
     504,   390,   391,   441,  1432,   327,   328,   329,   330,   429,
     758,  1438,  1439,   390,   391,  1442,   589,  1522,   590,   759,
     750,  1351,  1446,  1078,  1298,  1447,  1044,  1097,  1448,   433,
    1450,   440,  1452,  1453,  1454,  1045,  1226,  1457,  1602,  1603,
    1460,  1461,   870,  1046,   871,  1300,  1465,  1288,   197,   214,
    1469,   501,  1047,   277,  1025,  1472,   502,  1083,  1311,   503,
    1313,  1343,  1344,  1345,   528,  1317,   592,   529,  1320,  1321,
     537,   396,   307,  1486,   538,  1078,  1097,   539,  1071,   589,
     540,   590,   872,   126,  1435,  1436,  1437,   127,  1338,  1339,
    1340,  1341,   327,   328,   329,   330,   545,   546,   910,   911,
       1,   542,   128,   541,   129,  1343,  1344,  1345,   543,   163,
     183,   205,  1073,  1381,  1381,   268,  1086,   397,  1169,   544,
     176,   198,   215,  1084,  1085,   912,   278,   570,  1260,   913,
    1401,  1401,  1405,  1405,   617,   618,   914,   915,   571,  1160,
    1413,  1417,   623,   624,  1389,  1390,  1391,  1392,  1393,  1394,
    1395,  1396,  1397,  1398,   158,   327,   328,   329,   330,   505,
     506,  1415,  1529,  1285,  1073,  1086,  1027,  1533,   574,  1535,
    1343,  1344,  1345,  1539,   686,   687,  1541,  1542,  1195,  1302,
     582,   307,   177,   199,   216,   505,   506,   504,   279,   627,
     587,  1549,  1550,  1551,  1552,   604,  1371,  1372,   605,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   398,   662,   663,  1333,   625,  1336,  1478,
     627,  1480,   637,  1482,   648,  1484,   691,   692,  1353,   942,
     943,   944,   945,   946,   650,   399,   400,  1358,  1359,  1360,
    1361,  1362,  1363,   401,   402,   575,   685,   403,   666,   404,
     405,   406,   407,   408,     2,     3,     4,     5,     6,     7,
       8,     9,    10,   409,   410,   808,   809,   327,   328,   329,
     330,  1496,  1595,   668,  1597,   693,  1599,   701,  1601,   327,
     328,   329,   330,   703,  1430,   327,   328,   329,   330,  1248,
     332,   333,   334,   335,   411,  1039,  1040,  1041,   811,   812,
     705,  1441,   813,   814,  1443,   916,  1445,   815,   816,   606,
     879,   880,  1609,   708,  1611,   710,  1613,   709,  1615,   881,
     882,  1072,   712,  1456,   711,   412,   906,   907,   413,   713,
    1462,  1463,  1464,   606,   505,   506,   673,   714,   414,  1054,
    1055,  1056,  1057,   415,   119,  1058,  1059,  1060,  1061,   715,
    1553,   720,  1555,  -340,  1557,   717,  1559,  1062,  1063,  1485,
     416,  1487,  1249,  1250,  1251,  1252,  1253,  1254,  1255,  1256,
    1257,  1258,  1489,  1490,  1491,  1492,   607,   608,   609,   610,
     611,   612,  1428,  1429,  1494,  1495,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     607,   608,   609,   610,   611,   612,  1497,  1498,   739,   721,
     722,   723,   606,   740,   104,   744,   120,   121,   724,   745,
     346,   752,   347,   348,   349,   350,   351,   352,   725,   726,
     761,    53,   122,   727,   505,   506,  1517,  1518,   123,   675,
     124,   125,   728,   729,   730,   731,   732,  1528,   733,   734,
     735,  1530,  1531,  1532,   753,  1534,   760,  1536,  1537,  1538,
     736,   737,  1540,   762,   398,  1543,  1544,   353,   738,   766,
    1545,   767,   768,   354,   782,   785,   355,  1548,   786,   607,
     608,   609,   610,   611,   612,   791,   793,   795,   797,   802,
     801,  1561,   346,   806,   347,   348,   349,   350,   351,   352,
     478,   807,   406,   407,   408,   479,   810,   832,   841,   842,
     843,   851,   853,   302,   480,   303,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   304,   855,  -342,   305,   306,
     307,   126,   308,   309,  1583,   127,  -344,  -346,  1584,   353,
    1585,   863,   864,   867,  1586,   354,  1587,  1588,   355,   874,
     128,   875,   129,   356,  1590,  1591,  1592,  1593,   876,   877,
     886,   357,   878,   887,   883,   884,   895,   888,   346,   889,
     347,   348,   349,   350,   351,   352,   890,   891,   892,   413,
     310,   160,   180,   202,   219,   234,   251,   265,   282,   893,
     894,   908,   311,   312,   898,   358,   925,   359,   926,   360,
    1610,   937,  1612,   361,  1614,   938,  1616,   939,   940,   941,
     948,   490,   961,   972,  1620,   353,  1621,   964,  1622,   973,
    1623,   354,   974,   965,   355,   356,   982,   966,   988,   984,
     986,   992,   987,   357,  1014,   362,   363,  1008,  1015,  1016,
     364,   365,  1017,   366,  1022,  1023,  1024,  1030,   367,  1032,
     368,   369,   370,   371,  1034,   858,  1038,  1065,   372,   373,
     374,   375,  1048,  1066,  1067,  1068,  1069,   358,  1070,   359,
    1100,   360,  1101,  1143,  1146,   361,  1144,  1148,  1149,  1161,
    1172,   585,   346,  1152,   347,   348,   349,   350,   351,   352,
     161,   181,   203,   220,   235,   252,   266,   283,  1154,  1165,
    1166,   356,  1171,  1173,  1177,  1179,  1180,   362,   363,   357,
    1182,  1183,   364,   365,  1192,   366,  1193,  1199,  1200,  1201,
     367,  1202,   368,   369,   370,   371,  1203,  1204,  1205,   353,
     372,   373,   374,   375,  1207,   354,  1208,  1209,   355,  1224,
    1227,  1229,  1240,   358,  1230,   359,  1231,   360,  1241,  1242,
    1243,   361,  1244,   742,   162,   182,   204,   221,   236,   253,
     267,   284,  1280,  1277,  1278,  1286,  1293,   927,   928,  1294,
    1297,   934,   936,  1304,  1307,   346,   178,   347,   348,   349,
     350,   351,   352,   362,   363,  1310,  1312,  1314,   364,   365,
    1315,   366,  1316,  1319,  1322,  1323,   367,  1324,   368,   369,
     370,   371,  1328,   976,  1332,  1334,   372,   373,   374,   375,
    1337,  1355,  1364,  1366,   983,   356,   985,  1388,  1407,  1408,
    1444,  1409,   353,   357,   995,  1410,  1433,  1425,   354,   800,
    1449,   355,  1451,  1455,  1458,  1459,  1473,  1474,  1019,  1021,
    1475,  1476,  1493,  1026,  1028,  1547,  1499,  1511,   120,   121,
    1488,  1554,  1501,  1556,  1512,  1516,  1502,   358,  1503,   359,
    1504,   360,  1505,    53,   122,   361,  1506,  1507,  1508,  1558,
     123,  1560,   124,   125,   164,   184,   206,   225,   237,   255,
     269,   285,  1050,  1051,  1052,  1053,   772,  1509,  1510,   775,
     776,   777,   778,  1515,  1563,  1580,  1562,   362,   363,  1566,
    1567,  1568,   364,   365,   790,   366,  1579,  1569,   356,  1581,
     367,  1570,   368,   369,   370,   371,   357,  1582,  1594,  1571,
     372,   373,   374,   375,  1572,  1573,  1153,  1574,  1155,   165,
     185,   207,   226,   238,   256,   270,   286,   200,  1596,   818,
     820,   822,  1575,   967,   826,  1598,   828,  1600,  1604,  1608,
     358,  1617,   359,  1618,   360,    70,   341,   718,   361,   300,
     581,   704,  1042,   126,   847,   848,   850,   127,   222,   852,
     223,   958,   957,   217,   633,  1411,   788,   787,   232,  1266,
    1264,  1399,   128,  1247,   129,   254,   794,   796,    59,  1196,
     362,   363,   583,   798,   649,   364,   365,   751,   366,   635,
     979,   697,   660,   367,   249,   368,   369,   370,   371,   120,
     121,  1434,   837,   372,   373,   374,   375,   280,  1220,  1222,
     460,     0,     0,     0,    53,   122,     0,     0,     0,     0,
       0,   123,     0,   124,   125,   166,   186,   208,   227,   239,
     257,   271,   287,   930,   932,   120,   121,     0,     0,     0,
     120,   121,   167,   187,   209,   228,   240,   258,   272,   288,
      53,   122,   963,     0,     0,    53,   122,   123,     0,   124,
     125,     0,   123,     0,   124,   125,   120,   121,     0,   627,
     168,   188,   210,   229,   241,   259,   273,   289,     0,   120,
     121,    53,   122,     0,   990,     0,     0,   993,   123,     0,
     124,   125,     0,     0,    53,   122,     0,     0,     0,     0,
       0,   123,     0,   124,   125,   478,     0,   406,   407,   408,
     479,     0,     0,     0,   126,     0,     0,     0,   127,   480,
       0,   481,   482,   483,   484,   485,   486,   487,   488,   489,
       0,     0,     0,   128,     0,   129,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     126,     0,     0,     0,   127,   126,     0,     0,     0,   127,
     169,   189,   211,   230,   242,   260,   274,   290,     0,   128,
       0,   129,     0,     0,   128,     0,   129,     0,     0,     0,
       0,   126,     0,     0,     0,   127,   627,     0,     0,     0,
       0,     0,     0,     0,   126,     0,     0,     0,   127,     0,
     128,     0,   129,     0,     0,     0,     0,     0,   399,   400,
       0,     0,     0,   128,     0,   129,   401,   402,     0,     0,
     403,     0,   404,   405,   406,   407,   408,   170,   190,   212,
     231,   243,   261,   275,   291,     0,   409,   410,  1105,  1106,
    1107,  1108,  1109,  1110,  1111,  1112,  1113,  1114,  1115,  1116,
    1117,  1118,  1119,  1120,  1121,  1122,  1123,  1124,  1125,  1126,
    1127,  1128,  1129,  1130,  1131,  1132,  1133,  1134,  1135,  1136,
    1137,  1138,  1139,  1140,  1141,  1142,   507,   508,   509,   510,
     511,   512,     0,   514,   515,   516,   517,   518,   519,   520
};

static const yytype_int16 yycheck[] =
{
     417,   340,   340,    86,   143,   400,   401,   402,   392,   404,
     405,   446,   459,   345,   409,   410,   120,   121,   413,   123,
    1161,   416,   340,     6,   427,   428,   376,   430,   856,   857,
     336,    21,    22,   591,    24,    22,    23,     3,    22,    23,
    1334,   249,    43,   427,   428,   146,   430,    16,     3,    92,
       8,     5,    10,   500,    12,    13,    59,    43,   453,    17,
      18,   456,   148,    22,    23,    43,    11,   462,   463,   464,
     865,   466,   467,    31,   491,    31,    78,   148,   473,   474,
     475,    37,   640,   478,   479,   643,    58,   909,   646,   415,
      79,    60,   148,  1436,  1437,   490,   452,    55,    56,   494,
      22,    23,   257,   498,    93,    63,     6,    65,    16,    75,
      76,   146,   468,   445,    40,    95,    74,   909,   260,   175,
      75,    76,    74,    43,    90,    77,    95,    59,   283,     6,
     146,    97,    90,    41,    92,    90,   958,    62,   280,    95,
      96,     0,    97,   148,   470,   148,   232,   233,   234,   139,
     140,    26,    27,    28,    92,   160,   909,    32,    33,   139,
      35,    36,   302,    38,    39,   148,   958,     6,    26,    27,
      28,   148,    98,   229,    32,    33,   148,    35,    36,   148,
      38,    39,    64,   160,    66,    67,    68,    69,    70,    71,
      72,    73,   148,  1334,   148,   140,   142,   143,   144,   145,
      57,    58,     6,    42,  1547,   958,   623,   624,   625,   604,
      49,    50,    51,    52,   909,    79,   148,   260,   289,   791,
     222,   223,   617,   618,   280,    75,   139,    84,   139,    93,
     146,    88,    75,    76,   584,   148,   194,   148,    95,    96,
     657,   658,   659,   638,  1039,  1040,  1041,    90,   148,   250,
     251,   252,   253,   146,    97,   672,   214,   340,   217,   302,
     219,   146,   220,   958,   250,   251,   252,   253,   685,   686,
     687,   148,   250,   251,   252,   253,   693,   583,   673,   851,
     675,    95,    79,   491,   701,   146,  1580,  1581,  1582,   258,
     279,   148,   217,   146,   219,   278,   691,   692,   257,   265,
     266,   651,   177,   225,   226,   227,   228,   259,   743,   148,
     265,   266,   146,   300,  1608,   305,   300,   288,   650,   177,
     291,   909,   260,   148,   280,   225,   226,   227,   228,   229,
     250,   251,   252,   253,   292,   257,   258,   754,   755,   756,
     757,   758,   759,   139,   148,   195,   196,   764,   225,   226,
     227,   228,   229,   217,   218,   219,    98,   303,   258,   290,
     260,    79,  1108,  1295,   302,    19,    75,   939,   940,   941,
     958,   788,   789,   273,   178,   179,   307,   181,   909,   140,
     280,    95,    74,   260,   801,   802,    78,   140,    62,   806,
     229,   808,   809,   302,   811,   812,   273,  1329,  1330,  1331,
     972,   973,   974,   217,   139,   219,   141,   264,   825,   191,
     192,   193,   829,   830,   831,   279,   988,   834,   835,   836,
     928,   303,   265,   266,   148,   229,    79,   958,   303,   293,
     172,   141,   849,   175,    95,   148,   853,   140,   855,  1580,
    1581,  1582,  1014,  1015,  1016,   303,   585,   160,   302,   799,
     254,   255,  1024,    85,    86,    87,   260,   142,   143,   144,
     145,   896,  1034,    75,    76,   139,   140,  1608,   210,   273,
     267,   268,   269,   270,   216,   983,   286,   985,    90,   148,
     222,   223,   279,    95,    16,    97,   195,   196,   905,   906,
     907,   160,   909,  1065,  1066,  1067,  1068,  1069,  1070,    77,
    1246,  1247,    95,   217,   148,   219,  1438,  1439,   925,    77,
    1018,  1019,  1020,  1021,   148,  1261,   139,  1263,  1264,  1265,
    1266,   916,    77,   176,   177,   148,   160,  1273,  1274,    77,
     947,   678,   679,   968,   681,   682,   683,  1469,    95,    77,
     957,   958,     9,   217,   961,   219,   885,    75,   148,   267,
     268,   269,   270,  1220,  1221,  1222,   217,   210,   219,   976,
     160,   279,   979,    81,   306,   982,   139,   984,   141,   986,
     987,   140,   989,   148,  1146,   992,  1148,   994,   995,  1435,
    1436,  1437,   139,   140,   284,    95,   302,   905,   232,   233,
     234,   909,  1009,  1165,  1166,   149,  1013,   148,   905,  1171,
    1017,  1173,   909,   742,    95,  1177,     3,  1179,  1180,   160,
    1182,  1183,   302,  1030,   149,  1435,  1436,  1437,   303,   139,
      61,  1193,   148,   140,   217,  1072,   219,   140,   148,   139,
     140,  1203,  1204,  1205,   160,  1207,  1208,  1209,   139,   957,
     958,   217,   140,   219,   148,  1153,   148,  1155,   139,   140,
     957,   958,  1224,   265,   266,  1227,   160,  1229,   160,   140,
     217,   800,   219,   225,   226,   227,   228,    95,  1240,  1241,
    1242,   140,  1244,   212,   213,  1342,   139,   962,    75,    76,
    1347,   257,  1349,  1511,  1351,  1108,   833,   148,   139,   140,
     837,  1547,   139,    90,    91,   257,   250,   251,   252,   253,
      97,   149,    99,   100,    31,   139,   140,   217,  1280,   219,
      37,   139,   140,   146,  1286,   250,   251,   252,   253,   141,
     139,  1293,  1294,   139,   140,  1297,   217,  1547,   219,   148,
    1288,   148,  1304,   905,  1169,  1307,   139,   909,  1310,   289,
    1312,   147,  1314,  1315,  1316,   148,  1031,  1319,  1576,  1577,
    1322,  1323,   217,   139,   219,  1172,  1328,  1160,    73,    74,
    1332,   139,   148,    78,   149,  1337,    25,    16,  1185,   148,
    1187,   232,   233,   234,   148,  1192,  1160,    80,  1195,  1196,
     139,     6,    31,  1355,   140,   957,   958,    94,    37,   217,
      94,   219,   257,   190,   276,   277,   278,   194,  1215,  1216,
    1217,  1218,   250,   251,   252,   253,    29,    30,    57,    58,
       7,   140,   209,   302,   211,   232,   233,   234,   148,    72,
      73,    74,   905,  1246,  1247,    78,   909,    52,   967,   140,
      72,    73,    74,    82,    83,    84,    78,   287,  1261,    88,
    1263,  1264,  1265,  1266,   178,   179,    95,    96,   287,   953,
    1273,  1274,   281,   282,  1249,  1250,  1251,  1252,  1253,  1254,
    1255,  1256,  1257,  1258,   261,   250,   251,   252,   253,   222,
     223,   224,  1444,  1158,   957,   958,   149,  1449,   213,  1451,
     232,   233,   234,  1455,    53,    54,  1458,  1459,   149,  1174,
     285,    31,    72,    73,    74,   222,   223,    37,    78,   148,
     148,  1473,  1474,  1475,  1476,   295,  1245,  1245,    97,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   148,   300,   301,  1211,   273,  1213,  1346,
     148,  1348,   197,  1350,    59,  1352,    50,    51,  1223,   231,
     232,   233,   234,   235,   302,   170,   171,  1232,  1233,  1234,
    1235,  1236,  1237,   178,   179,    95,    42,   182,   259,   184,
     185,   186,   187,   188,   161,   162,   163,   164,   165,   166,
     167,   168,   169,   198,   199,   139,   140,   250,   251,   252,
     253,  1376,  1554,   259,  1556,    42,  1558,   175,  1560,   250,
     251,   252,   253,   148,  1279,   250,   251,   252,   253,    77,
     142,   143,   144,   145,   229,   860,   861,   862,   139,   140,
      98,  1296,   139,   140,  1299,   264,  1301,   139,   140,   229,
      14,    15,  1594,   139,  1596,   231,  1598,   139,  1600,    29,
      30,   280,   140,  1318,   139,   260,   139,   140,   263,   140,
    1325,  1326,  1327,   229,   222,   223,   256,   140,   273,   230,
     231,   230,   231,   278,     3,   230,   231,   230,   231,   304,
    1477,   304,  1479,   139,  1481,   139,  1483,   230,   231,  1354,
     295,  1356,   150,   151,   152,   153,   154,   155,   156,   157,
     158,   159,  1367,  1368,  1369,  1370,   296,   297,   298,   299,
     300,   301,   230,   231,   173,   174,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
     296,   297,   298,   299,   300,   301,   139,   140,   148,   304,
     304,   304,   229,   148,    92,    59,    75,    76,   304,   148,
      42,   139,    44,    45,    46,    47,    48,    49,   304,   304,
     294,    90,    91,   304,   222,   223,  1431,  1432,    97,   256,
      99,   100,   304,   304,   304,   304,   304,  1442,   304,   304,
     304,  1446,  1447,  1448,   140,  1450,   286,  1452,  1453,  1454,
     304,   304,  1457,    81,   148,  1460,  1461,    89,   304,   148,
    1465,   148,   148,    95,   148,     5,    98,  1472,   286,   296,
     297,   298,   299,   300,   301,     5,   148,   148,   148,    98,
     148,  1486,    42,    98,    44,    45,    46,    47,    48,    49,
     184,   148,   186,   187,   188,   189,   148,    84,   148,   148,
     148,     5,   148,    14,   198,    16,   200,   201,   202,   203,
     204,   205,   206,   207,   208,    26,   139,   139,    29,    30,
      31,   190,    33,    34,  1529,   194,   139,   139,  1533,    89,
    1535,   139,   139,    20,  1539,    95,  1541,  1542,    98,   140,
     209,   140,   211,   175,  1549,  1550,  1551,  1552,   140,   139,
     148,   183,   140,   148,   140,   140,   231,   148,    42,   148,
      44,    45,    46,    47,    48,    49,   148,   148,   148,   263,
      81,    72,    73,    74,    75,    76,    77,    78,    79,   148,
     148,   148,    93,    94,   231,   217,   148,   219,    59,   221,
    1595,   149,  1597,   225,  1599,   149,  1601,     5,     5,     5,
      59,   295,   149,     5,  1609,    89,  1611,   231,  1613,     5,
    1615,    95,     5,   231,    98,   175,   180,   231,     5,   180,
     230,   149,   231,   183,     5,   257,   258,   271,     5,     5,
     262,   263,   149,   265,   148,   148,     5,   149,   270,   149,
     272,   273,   274,   275,     5,   300,   139,     5,   280,   281,
     282,   283,   148,     5,     5,     5,     5,   217,     5,   219,
     139,   221,   139,   148,     5,   225,   148,     5,   231,     4,
     139,   303,    42,   180,    44,    45,    46,    47,    48,    49,
      72,    73,    74,    75,    76,    77,    78,    79,   180,     5,
       5,   175,     5,     5,     5,     5,     5,   257,   258,   183,
       5,     5,   262,   263,   149,   265,     5,   139,   148,   148,
     270,   148,   272,   273,   274,   275,     5,     5,     5,    89,
     280,   281,   282,   283,     5,    95,     5,     5,    98,     5,
       5,     5,     5,   217,   139,   219,   139,   221,     5,     5,
     139,   225,     5,   303,    72,    73,    74,    75,    76,    77,
      78,    79,     5,   231,   148,     5,     5,   771,   772,     5,
       5,   775,   776,     5,     5,    42,     3,    44,    45,    46,
      47,    48,    49,   257,   258,     5,     5,     5,   262,   263,
       5,   265,     5,     5,     5,     5,   270,   231,   272,   273,
     274,   275,     5,   807,     5,     4,   280,   281,   282,   283,
       5,     5,   296,   139,   818,   175,   820,   140,   139,   139,
       5,   148,    89,   183,   828,   140,    99,   215,    95,   303,
       5,    98,     5,     5,     5,     5,     5,     5,   842,   843,
       5,     5,   139,   847,   848,     6,   139,    98,    75,    76,
     148,     5,   148,     5,   139,   139,   148,   217,   148,   219,
     148,   221,   148,    90,    91,   225,   148,   148,   148,     5,
      97,     5,    99,   100,    72,    73,    74,    75,    76,    77,
      78,    79,   886,   887,   888,   889,   616,   148,   148,   619,
     620,   621,   622,   148,   148,     5,   234,   257,   258,   149,
     149,   149,   262,   263,   634,   265,    59,   149,   175,     5,
     270,   149,   272,   273,   274,   275,   183,     5,     5,   149,
     280,   281,   282,   283,   149,   149,   930,   149,   932,    72,
      73,    74,    75,    76,    77,    78,    79,     3,     5,   669,
     670,   671,   149,   303,   674,     5,   676,     5,   139,     5,
     217,   139,   219,   139,   221,    12,   102,   541,   225,    84,
     341,   503,   863,   190,   694,   695,   696,   194,    75,   699,
      75,   787,   786,     3,   415,  1271,   633,   632,     3,  1120,
    1111,  1261,   209,  1107,   211,    77,   640,   643,     1,   993,
     257,   258,   344,   646,   442,   262,   263,   591,   265,   417,
     810,   491,   452,   270,     3,   272,   273,   274,   275,    75,
      76,  1288,   684,   280,   281,   282,   283,     3,  1022,  1023,
     158,    -1,    -1,    -1,    90,    91,    -1,    -1,    -1,    -1,
      -1,    97,    -1,    99,   100,    72,    73,    74,    75,    76,
      77,    78,    79,   773,   774,    75,    76,    -1,    -1,    -1,
      75,    76,    72,    73,    74,    75,    76,    77,    78,    79,
      90,    91,   792,    -1,    -1,    90,    91,    97,    -1,    99,
     100,    -1,    97,    -1,    99,   100,    75,    76,    -1,   148,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    75,
      76,    90,    91,    -1,   824,    -1,    -1,   827,    97,    -1,
      99,   100,    -1,    -1,    90,    91,    -1,    -1,    -1,    -1,
      -1,    97,    -1,    99,   100,   184,    -1,   186,   187,   188,
     189,    -1,    -1,    -1,   190,    -1,    -1,    -1,   194,   198,
      -1,   200,   201,   202,   203,   204,   205,   206,   207,   208,
      -1,    -1,    -1,   209,    -1,   211,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
     190,    -1,    -1,    -1,   194,   190,    -1,    -1,    -1,   194,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,   209,
      -1,   211,    -1,    -1,   209,    -1,   211,    -1,    -1,    -1,
      -1,   190,    -1,    -1,    -1,   194,   148,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   190,    -1,    -1,    -1,   194,    -1,
     209,    -1,   211,    -1,    -1,    -1,    -1,    -1,   170,   171,
      -1,    -1,    -1,   209,    -1,   211,   178,   179,    -1,    -1,
     182,    -1,   184,   185,   186,   187,   188,    72,    73,    74,
      75,    76,    77,    78,    79,    -1,   198,   199,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,   136,   137,   138,   236,   237,   238,   239,
     240,   241,    -1,   243,   244,   245,   246,   247,   248,   249
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_int16 yystos[] =
{
       0,     7,   161,   162,   163,   164,   165,   166,   167,   168,
     169,   309,   310,   311,   330,   331,   332,   334,   335,   336,
     337,   340,   341,   342,   343,   344,   345,   346,   352,   363,
     364,   369,   391,   392,   393,   394,   395,   396,   397,   398,
     399,     8,    10,    12,    13,    17,    18,    31,    55,    56,
      63,    65,    74,    90,    92,   194,   214,   220,   292,   480,
     146,   146,   146,   146,   146,   146,   146,   146,   146,     0,
     311,   312,   314,   316,   318,   320,   322,   324,   326,   328,
      11,   140,   148,   139,   365,   366,   370,    19,   302,   140,
     140,   302,   148,   140,   141,   302,    75,   195,   196,   212,
     213,   286,   347,   348,    92,   260,   302,   484,    74,    77,
     259,    77,    77,    77,    16,    77,    77,    16,    41,     3,
      75,    76,    91,    97,    99,   100,   190,   194,   209,   211,
     313,   400,   401,   402,   411,   414,   417,   460,   461,   462,
     463,   476,   479,   480,   481,   487,   488,   489,   490,   491,
     495,   545,   546,   547,   549,   550,   551,     3,   261,   315,
     400,   401,   402,   460,   476,   479,   487,   488,   489,   490,
     491,   516,   531,   540,   542,   544,   545,   551,     3,   317,
     400,   401,   402,   460,   476,   479,   487,   488,   489,   490,
     491,   533,   534,   535,   536,   537,   538,   540,   545,   551,
       3,   319,   400,   401,   402,   460,   476,   479,   487,   488,
     489,   490,   491,   516,   540,   545,   551,     3,   321,   400,
     401,   402,   411,   414,   420,   476,   479,   487,   488,   489,
     490,   491,     3,   323,   400,   401,   402,   476,   479,   487,
     488,   489,   490,   491,   552,   553,   554,   555,   556,     3,
     325,   400,   401,   402,   463,   476,   479,   487,   488,   489,
     490,   491,   498,   548,   327,   400,   401,   402,   460,   476,
     479,   487,   488,   489,   490,   491,   516,   540,   545,   551,
       3,   329,   400,   401,   402,   476,   479,   487,   488,   489,
     490,   491,   494,   541,     9,    75,   333,    81,   367,    95,
     366,   473,    14,    16,    26,    29,    30,    31,    33,    34,
      81,    93,    94,   353,   371,   372,   373,   374,   375,   376,
     379,   380,   381,   382,   383,   354,   338,   250,   251,   252,
     253,   539,   142,   143,   144,   145,   485,   486,   140,   148,
     349,   348,   284,   351,   302,   302,    42,    44,    45,    46,
      47,    48,    49,    89,    95,    98,   175,   183,   217,   219,
     221,   225,   257,   258,   262,   263,   265,   270,   272,   273,
     274,   275,   280,   281,   282,   283,   482,   483,    61,   558,
     140,   140,   139,   140,   139,   140,   140,   140,   139,   140,
     139,   140,   403,   405,   139,   139,     6,    52,   148,   170,
     171,   178,   179,   182,   184,   185,   186,   187,   188,   198,
     199,   229,   260,   263,   273,   278,   295,   496,   497,   501,
     505,   507,   508,   509,   510,   512,   513,   403,   403,   141,
     403,   148,   289,   289,   191,   192,   193,    75,   195,   196,
     147,   146,   492,   493,   260,   302,   484,     6,   225,   226,
     227,   228,   229,   258,   260,   280,   515,   543,   260,   280,
     543,     6,   178,   179,   181,   229,   254,   255,   229,     6,
     278,     6,    42,    49,    50,    51,    52,   229,   184,   189,
     198,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     295,   499,   500,   502,   503,   504,   506,   509,   175,   229,
     280,   139,    25,   148,    37,   222,   223,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   353,   358,   361,   362,   368,   407,   408,   148,    80,
     410,    21,    22,    24,   139,   140,   305,   139,   140,    94,
      94,   302,   140,   148,   140,    29,    30,    26,    27,    28,
      32,    33,    35,    36,    38,    39,   177,   303,   355,    64,
      66,    67,    68,    69,    70,    71,    72,    73,   303,   339,
     287,   287,   303,   486,   213,    95,   350,   353,   358,   361,
     362,   351,   285,   485,   482,   303,   483,   148,    95,   217,
     219,   404,   405,   406,   472,    79,    93,   217,   218,   219,
     279,   293,   423,   425,   295,    97,   229,   296,   297,   298,
     299,   300,   301,   517,   517,   517,   517,   178,   179,   517,
     517,   517,   517,   281,   282,   273,   517,   148,   525,   526,
     527,   279,   423,   425,   517,   497,   527,   197,   511,    95,
     404,   470,    95,   404,   469,    95,   404,   471,    59,   493,
     302,   482,   558,    22,    23,   257,   532,   257,   258,   515,
     532,   517,   300,   301,   478,   517,   259,   478,   259,   517,
     517,   517,   283,   256,   517,   256,   517,   267,   268,   269,
     270,   267,   268,   269,   270,    42,    53,    54,   517,   517,
     517,    50,    51,    42,   517,   517,   517,   500,   527,   517,
     517,   175,   478,   148,   367,    98,   139,   141,   139,   139,
     231,   139,   140,   140,   140,   304,   384,   139,   354,   377,
     304,   304,   304,   304,   304,   304,   304,   304,   304,   304,
     304,   304,   304,   304,   304,   304,   304,   304,   304,   148,
     148,   303,   303,   484,    59,   148,   139,   148,   139,   148,
     406,   472,   139,   140,   139,   148,   139,   148,   139,   148,
     286,   294,    81,   424,   418,   517,   148,   148,   148,   148,
     160,   514,   514,   517,   517,   514,   514,   514,   514,   527,
     527,   527,   148,    59,   148,     5,   286,   424,   418,   148,
     514,     5,   517,   148,   470,   148,   469,   148,   471,   482,
     303,   148,    98,   527,   527,   527,    98,   148,   139,   140,
     148,   139,   140,   139,   140,   139,   140,   148,   514,   148,
     514,   148,   514,   527,   517,   148,   514,   517,   514,   421,
     421,   421,    84,   557,   421,   421,   421,   557,   527,   527,
     527,   148,   148,   148,   517,   517,   527,   514,   514,   148,
     514,     5,   514,   148,   527,   139,    22,    23,   300,   359,
     385,   386,   387,   139,   139,   388,   389,    20,   390,   303,
     217,   219,   257,   378,   140,   140,   140,   139,   140,    14,
      15,    29,    30,   140,   140,   360,   148,   148,   148,   148,
     148,   148,   148,   148,   148,   231,   484,   558,   231,   527,
     527,   527,   527,   527,   527,   415,   139,   140,   148,   412,
      57,    58,    84,    88,    95,    96,   264,   419,   427,   431,
     432,   464,   474,   475,   527,   148,    59,   539,   539,   148,
     514,   148,   514,   149,   539,   149,   539,   149,   149,     5,
       5,     5,   231,   232,   233,   234,   235,   518,    59,    75,
      76,    90,    97,   265,   266,   522,   523,   415,   412,   527,
     527,   149,   523,   514,   231,   231,   231,   303,   484,   527,
      58,   527,     5,     5,     5,   527,   539,   527,   527,   518,
     527,   527,   180,   539,   180,   539,   230,   231,     5,   148,
     514,   527,   149,   514,   149,   539,    16,    60,    95,   258,
     422,   465,   466,   467,   468,   527,   527,   527,   271,   421,
     527,   527,   527,   421,     5,     5,     5,   149,    43,   539,
      43,   539,   148,   148,     5,   149,   539,   149,   539,   527,
     149,   523,   149,   527,     5,   527,   359,   359,   139,   388,
     388,   388,   390,   389,   139,   148,   139,   148,   148,   361,
     539,   539,   539,   539,   230,   231,   230,   231,   230,   231,
     230,   231,   230,   231,   558,     5,     5,     5,     5,     5,
       5,    37,   280,   353,   356,   358,   416,   474,   475,   477,
     527,   527,   527,    16,    82,    83,   353,   356,   358,   413,
     426,   427,   430,   431,   432,   464,   474,   475,   477,   527,
     139,   139,    85,    86,    87,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   138,   148,   148,   517,     5,   527,     5,   231,
     520,   520,   180,   539,   180,   539,   523,   523,   523,   527,
     403,     4,   529,   527,   527,     5,     5,   527,   529,   484,
     558,     5,   139,     5,   523,   523,   523,     5,   527,     5,
       5,   527,     5,     5,   527,   520,   527,   520,   527,   527,
     523,   527,   149,     5,   527,   149,   539,   527,   527,   139,
     148,   148,   148,     5,     5,     5,   527,     5,     5,     5,
     527,   523,   523,   523,   527,   520,   520,   520,   520,    43,
     539,    43,   539,   523,     5,   527,   529,     5,   523,     5,
     139,   139,   523,   523,   523,   523,   523,   523,    40,   478,
       5,     5,     5,   139,     5,   428,   447,   447,    77,   150,
     151,   152,   153,   154,   155,   156,   157,   158,   159,   407,
     408,   458,   459,   435,   435,   439,   439,    79,   176,   177,
     210,   433,   434,   437,   441,   445,   456,   231,   148,   523,
       5,    95,   523,   520,   520,   529,     5,    62,   404,   521,
       3,   522,   524,     5,     5,   523,   523,     5,   558,   523,
     527,   523,   529,   523,     5,   523,   523,     5,   523,   523,
       5,   527,     5,   527,     5,     5,     5,   527,   523,     5,
     527,   527,     5,     5,   231,   523,   523,   523,     5,   523,
     523,   523,     5,   529,     4,   530,   529,     5,   527,   527,
     527,   527,   148,   232,   233,   234,   519,   148,   519,   148,
     519,   148,   519,   529,   523,     5,   523,   523,   529,   529,
     529,   529,   529,   529,   296,   357,   139,   523,   523,   523,
     523,   361,   362,   429,    98,   172,   175,   210,   216,   306,
     407,   408,   448,   449,   450,   451,   452,   453,   140,   517,
     517,   517,   517,   517,   517,   517,   517,   517,   517,   459,
     407,   408,   436,    78,   407,   408,   440,   139,   139,   148,
     140,   434,   407,   408,   438,   224,   407,   408,   409,   442,
     288,   291,   443,   444,   446,   215,   455,   457,   230,   231,
     529,   523,   523,    99,   521,   276,   277,   278,   523,   523,
     530,   529,   523,   529,     5,   529,   523,   523,   523,     5,
     523,     5,   523,   523,   523,     5,   529,   523,     5,     5,
     523,   523,   529,   529,   529,   523,   530,   530,   530,   523,
       3,   524,   523,     5,     5,     5,     5,   519,   527,   519,
     527,   519,   527,   519,   527,   529,   523,   529,   148,   529,
     529,   529,   529,   139,   173,   174,   517,   139,   140,   139,
     454,   148,   148,   148,   148,   148,   148,   148,   148,   148,
     148,    98,   139,   139,   141,   148,   139,   529,   529,    59,
     148,   525,   526,   528,   528,   528,   530,   530,   529,   523,
     529,   529,   529,   523,   529,   523,   529,   529,   529,   523,
     529,   523,   523,   529,   529,   529,   530,     6,   529,   523,
     523,   523,   523,   527,     5,   527,     5,   527,     5,   527,
       5,   529,   234,   148,   290,   307,   149,   149,   149,   149,
     149,   149,   149,   149,   149,   149,    22,    23,   359,    59,
       5,     5,     5,   529,   529,   529,   529,   529,   529,   528,
     529,   529,   529,   529,     5,   523,     5,   523,     5,   523,
       5,   523,   359,   359,   139,   524,   524,   524,     5,   523,
     529,   523,   529,   523,   529,   523,   529,   139,   139,   524,
     529,   529,   529,   529
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_int16 yyr1[] =
{
       0,   308,   309,   309,   310,   310,   311,   311,   311,   311,
     311,   311,   311,   311,   311,   311,   311,   311,   311,   311,
     311,   311,   311,   311,   311,   311,   311,   311,   311,   311,
     311,   311,   311,   312,   312,   313,   313,   313,   313,   313,
     313,   313,   313,   313,   313,   313,   313,   313,   313,   313,
     313,   313,   313,   313,   313,   313,   313,   313,   313,   314,
     314,   315,   315,   315,   315,   315,   315,   315,   315,   315,
     315,   315,   315,   315,   315,   315,   315,   315,   315,   316,
     316,   317,   317,   317,   317,   317,   317,   317,   317,   317,
     317,   317,   317,   317,   317,   317,   317,   317,   317,   317,
     317,   318,   318,   319,   319,   319,   319,   319,   319,   319,
     319,   319,   319,   319,   319,   319,   319,   319,   320,   320,
     321,   321,   321,   321,   321,   321,   321,   321,   321,   321,
     321,   321,   321,   322,   322,   323,   323,   323,   323,   323,
     323,   323,   323,   323,   323,   323,   323,   323,   323,   323,
     324,   324,   325,   325,   325,   325,   325,   325,   325,   325,
     325,   325,   325,   325,   325,   326,   326,   327,   327,   327,
     327,   327,   327,   327,   327,   327,   327,   327,   327,   327,
     327,   327,   328,   328,   329,   329,   329,   329,   329,   329,
     329,   329,   329,   329,   329,   329,   330,   330,   330,   331,
     332,   333,   333,   334,   335,   335,   335,   336,   337,   338,
     338,   339,   339,   339,   339,   339,   339,   339,   339,   339,
     339,   339,   339,   339,   339,   340,   341,   341,   341,   342,
     342,   342,   343,   344,   345,   346,   347,   347,   348,   349,
     349,   350,   350,   350,   350,   350,   351,   351,   352,   353,
     353,   354,   354,   355,   355,   355,   355,   355,   355,   355,
     355,   355,   355,   355,   355,   356,   357,   357,   358,   358,
     358,   359,   359,   360,   360,   361,   361,   361,   361,   361,
     361,   361,   361,   361,   361,   361,   361,   361,   362,   363,
     364,   365,   365,   366,   366,   367,   367,   368,   368,   368,
     368,   368,   368,   369,   370,   370,   371,   371,   371,   371,
     371,   371,   371,   371,   371,   372,   373,   374,   375,   376,
     377,   377,   378,   378,   378,   378,   378,   379,   379,   380,
     380,   381,   381,   382,   383,   383,   383,   383,   383,   383,
     384,   383,   385,   383,   386,   383,   387,   383,   383,   388,
     388,   389,   390,   390,   391,   391,   391,   391,   392,   393,
     393,   394,   395,   396,   396,   397,   398,   399,   399,   400,
     400,   401,   401,   402,   402,   403,   403,   404,   404,   405,
     405,   406,   406,   406,   406,   407,   407,   408,   409,   410,
     410,   411,   411,   412,   412,   413,   413,   413,   413,   413,
     413,   413,   413,   413,   413,   413,   413,   414,   414,   415,
     415,   416,   416,   416,   416,   416,   416,   417,   417,   418,
     418,   419,   419,   419,   419,   419,   419,   420,   420,   420,
     420,   420,   420,   420,   420,   421,   421,   422,   422,   422,
     422,   423,   423,   424,   425,   426,   426,   427,   427,   427,
     428,   428,   429,   429,   430,   431,   431,   431,   431,   431,
     431,   431,   431,   431,   431,   431,   431,   431,   431,   431,
     431,   431,   431,   431,   431,   431,   431,   431,   431,   431,
     431,   431,   431,   431,   431,   431,   431,   431,   431,   431,
     431,   431,   431,   432,   432,   433,   433,   434,   434,   434,
     434,   435,   435,   436,   436,   437,   437,   438,   438,   439,
     439,   440,   440,   440,   440,   440,   441,   441,   442,   442,
     442,   443,   443,   444,   445,   445,   446,   446,   447,   447,
     448,   448,   448,   448,   448,   448,   448,   448,   449,   450,
     450,   451,   451,   452,   453,   454,   454,   455,   456,   456,
     457,   458,   458,   459,   459,   459,   459,   459,   459,   459,
     459,   459,   459,   459,   459,   459,   460,   460,   461,   462,
     463,   464,   464,   465,   466,   467,   468,   469,   469,   470,
     470,   471,   471,   472,   472,   473,   473,   474,   475,   476,
     476,   477,   478,   478,   479,   479,   479,   479,   480,   481,
     482,   482,   483,   483,   483,   483,   483,   483,   483,   483,
     483,   483,   483,   483,   483,   483,   483,   483,   483,   483,
     483,   483,   483,   483,   483,   483,   483,   483,   483,   483,
     483,   483,   484,   484,   485,   485,   486,   486,   486,   486,
     487,   487,   487,   488,   488,   488,   489,   489,   489,   490,
     491,   492,   492,   493,   494,   494,   495,   496,   496,   497,
     497,   497,   497,   497,   497,   497,   498,   499,   499,   500,
     500,   500,   500,   501,   501,   502,   503,   503,   503,   503,
     503,   503,   503,   503,   503,   503,   504,   504,   505,   505,
     505,   505,   506,   506,   507,   508,   509,   510,   510,   510,
     511,   511,   512,   512,   512,   513,   513,   513,   514,   514,
     515,   515,   515,   515,   516,   516,   517,   517,   517,   517,
     517,   517,   517,   517,   518,   518,   518,   518,   518,   518,
     519,   519,   519,   520,   520,   521,   521,   521,   522,   522,
     522,   522,   522,   522,   522,   523,   524,   525,   526,   527,
     527,   527,   528,   528,   528,   529,   529,   529,   529,   529,
     530,   530,   530,   531,   531,   531,   532,   532,   532,   533,
     533,   533,   533,   534,   534,   534,   534,   535,   535,   536,
     536,   537,   537,   538,   539,   539,   539,   539,   539,   540,
     540,   541,   542,   542,   542,   542,   542,   542,   542,   542,
     543,   543,   544,   544,   545,   545,   546,   546,   547,   547,
     548,   548,   549,   549,   550,   551,   551,   552,   552,   552,
     553,   554,   555,   555,   555,   555,   555,   555,   556,   556,
     556,   556,   556,   556,   557,   558,   558,   558
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     0,     1,     1,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     0,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     4,     7,     8,     4,
       3,     0,     3,     2,     3,     3,     3,     4,     5,     0,
       2,     4,     4,     4,     4,     4,     4,     4,     4,     4,
       4,     4,     4,     4,     4,     2,     3,     3,     5,     4,
       6,     4,     3,     3,     3,     3,     2,     3,     2,     0,
       2,     3,     1,     1,     1,     1,     0,     2,     5,     1,
       4,     0,     2,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     5,     0,     1,     4,     5,
       5,     0,     1,     0,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     5,
       5,     1,     2,     2,     4,     0,     2,     1,     1,     1,
       1,     1,     1,     3,     0,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     2,     1,     2,     3,
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     1,     1,     2,     5,     4,     2,     3,     3,     3,
       0,     4,     0,     5,     0,     5,     0,     5,     2,     1,
       2,     1,     0,     1,     4,     4,     4,     4,     4,     4,
       4,     4,     4,     4,     4,     2,     4,     5,     6,     3,
       4,     3,     4,     3,     4,     1,     2,     1,     2,     1,
       1,     2,     2,     2,     2,     2,     2,     2,     2,     0,
       2,     9,     9,     0,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     9,     9,     0,
       2,     1,     1,     1,     1,     1,     1,     8,     8,     0,
       2,     1,     1,     1,     1,     1,     1,     9,     8,     8,
       8,     9,     8,     8,     8,     0,     2,     1,     1,     1,
       1,     0,     2,     2,     2,     1,     1,     2,     3,     2,
       0,     2,     1,     1,     2,     3,     2,     2,     2,     2,
       2,     2,     2,     3,     3,     2,     2,     2,     2,     2,
       2,     2,     3,     3,     3,     2,     2,     3,     2,     2,
       2,     3,     2,     2,     2,     2,     3,     3,     3,     2,
       2,     2,     3,     2,     2,     1,     2,     2,     2,     2,
       2,     0,     2,     1,     1,     0,     2,     1,     1,     0,
       2,     1,     1,     4,     5,     5,     0,     2,     1,     1,
       1,     2,     2,     2,     0,     2,     1,     1,     0,     2,
       1,     1,     1,     1,     1,     1,     1,     3,     3,     2,
       2,     2,     2,     2,     2,     0,     2,     2,     0,     2,
       1,     1,     2,     1,     1,     2,     4,     4,     4,     4,
       4,     4,     4,     4,     4,     4,     7,     6,     6,     6,
       9,     4,     4,     2,     2,     3,     2,     0,     3,     0,
       3,     0,     3,     0,     3,     0,     3,     3,     2,     7,
       7,     3,     1,     1,     3,     6,     7,     1,     2,     2,
       1,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     4,     1,     2,     2,     2,     1,     1,
       3,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     1,     2,     1,     8,     6,     6,     1,     2,     1,
       1,     1,     1,     1,     1,     1,     6,     1,     2,     1,
       1,     1,     1,     4,     4,     4,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     4,     4,     4,     4,
       4,     4,     4,     4,     3,     3,     4,     1,     1,     1,
       0,     1,     5,     6,     5,     5,     6,     5,     1,     1,
       1,     1,     1,     1,     9,     6,     0,     1,     1,     1,
       1,     1,     1,     1,     0,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     1,     0,     3,     4,     1,     3,
       4,     1,     1,     1,     1,     1,     1,     2,     3,     0,
       1,     1,     0,     1,     1,     0,     2,     6,     6,     6,
       0,     2,     6,     8,    10,     7,     0,     1,     1,     8,
       9,     9,    10,     9,     9,    10,    10,    10,     9,    10,
       9,     9,     9,     6,     0,     1,     1,     1,     1,     8,
       7,     7,     7,     7,     4,     4,     7,     7,     4,     4,
       0,     1,     9,     6,     8,     8,     8,     8,     9,     9,
       8,     9,     8,     9,     9,     8,     8,     7,     7,     7,
       7,     9,    10,    11,    12,    10,    11,    12,    10,    11,
      12,    10,    11,    12,     2,     0,     2,     3
};


#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)
#define YYEMPTY         (-2)
#define YYEOF           0

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Error token number */
#define YYTERROR        1
#define YYERRCODE       256



/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)

/* This macro is provided for backward compatibility. */
#ifndef YY_LOCATION_PRINT
# define YY_LOCATION_PRINT(File, Loc) ((void) 0)
#endif


# define YY_SYMBOL_PRINT(Title, Type, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Type, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo, int yytype, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YYUSE (yyoutput);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyo, yytoknum[yytype], *yyvaluep);
# endif
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yytype);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo, int yytype, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yytype < YYNTOKENS ? "token" : "nterm", yytname[yytype]);

  yy_symbol_value_print (yyo, yytype, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp, int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       yystos[+yyssp[yyi + 1 - yynrhs]],
                       &yyvsp[(yyi + 1) - (yynrhs)]
                                              );
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
#  else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                yy_state_t *yyssp, int yytoken)
{
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Actual size of YYARG. */
  int yycount = 0;
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[+*yyssp];
      YYPTRDIFF_T yysize0 = yytnamerr (YY_NULLPTR, yytname[yytoken]);
      yysize = yysize0;
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                {
                  YYPTRDIFF_T yysize1
                    = yysize + yytnamerr (YY_NULLPTR, yytname[yyx]);
                  if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
                    yysize = yysize1;
                  else
                    return 2;
                }
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  {
    /* Don't count the "%s"s in the final size, but reserve room for
       the terminator.  */
    YYPTRDIFF_T yysize1 = yysize + (yystrlen (yyformat) - 2 * yycount) + 1;
    if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
      yysize = yysize1;
    else
      return 2;
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
{
  YYUSE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yytype);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}




/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;


/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       'yyss': related to states.
       'yyvs': related to semantic values.

       Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss;
    yy_state_t *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYPTRDIFF_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yyssp = yyss = yyssa;
  yyvsp = yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    goto yyexhaustedlab;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
# undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 196:
#line 615 "src/p.y"
                                                    {
                        mailset.events = Event_All;
                        addmail((yyvsp[-2].string), &mailset, &Run.maillist);
                  }
#line 3540 "src/y.tab.c"
    break;

  case 197:
#line 619 "src/p.y"
                                                                            {
                        addmail((yyvsp[-5].string), &mailset, &Run.maillist);
                  }
#line 3548 "src/y.tab.c"
    break;

  case 198:
#line 622 "src/p.y"
                                                                                {
                        mailset.events = ~mailset.events;
                        addmail((yyvsp[-6].string), &mailset, &Run.maillist);
                  }
#line 3557 "src/y.tab.c"
    break;

  case 199:
#line 628 "src/p.y"
                                               {
                        if (! (Run.flags & Run_Daemon) || ihp.daemon) {
                                ihp.daemon     = true;
                                Run.flags      |= Run_Daemon;
                                Run.polltime   = (yyvsp[-1].number);
                                Run.startdelay = (yyvsp[0].number);
                        }
                  }
#line 3570 "src/y.tab.c"
    break;

  case 200:
#line 638 "src/p.y"
                                     {
                        Run.flags |= Run_Batch;
                  }
#line 3578 "src/y.tab.c"
    break;

  case 201:
#line 643 "src/p.y"
                              {
                        (yyval.number) = 0;
                  }
#line 3586 "src/y.tab.c"
    break;

  case 202:
#line 646 "src/p.y"
                                     {
                        (yyval.number) = (yyvsp[0].number);
                  }
#line 3594 "src/y.tab.c"
    break;

  case 203:
#line 651 "src/p.y"
                           {
                        Run.flags |= Run_Foreground;
                  }
#line 3602 "src/y.tab.c"
    break;

  case 204:
#line 656 "src/p.y"
                                     {
                        Run.onreboot = Onreboot_Start;
                  }
#line 3610 "src/y.tab.c"
    break;

  case 205:
#line 659 "src/p.y"
                                       {
                        Run.onreboot = Onreboot_Nostart;
                  }
#line 3618 "src/y.tab.c"
    break;

  case 206:
#line 662 "src/p.y"
                                         {
                        Run.onreboot = Onreboot_Laststate;
                  }
#line 3626 "src/y.tab.c"
    break;

  case 207:
#line 667 "src/p.y"
                                               {
                        // Note: deprecated (replaced by "set limits" statement's "sendExpectBuffer" option)
                        Run.limits.sendExpectBuffer = (yyvsp[-1].number) * (yyvsp[0].number);
                  }
#line 3635 "src/y.tab.c"
    break;

  case 211:
#line 680 "src/p.y"
                                                   {
                        Run.limits.sendExpectBuffer = (yyvsp[-1].number) * (yyvsp[0].number);
                  }
#line 3643 "src/y.tab.c"
    break;

  case 212:
#line 683 "src/p.y"
                                                    {
                        Run.limits.fileContentBuffer = (yyvsp[-1].number) * (yyvsp[0].number);
                  }
#line 3651 "src/y.tab.c"
    break;

  case 213:
#line 686 "src/p.y"
                                                    {
                        Run.limits.httpContentBuffer = (yyvsp[-1].number) * (yyvsp[0].number);
                  }
#line 3659 "src/y.tab.c"
    break;

  case 214:
#line 689 "src/p.y"
                                                {
                        Run.limits.programOutput = (yyvsp[-1].number) * (yyvsp[0].number);
                  }
#line 3667 "src/y.tab.c"
    break;

  case 215:
#line 692 "src/p.y"
                                                        {
                        Run.limits.networkTimeout = (yyvsp[-1].number);
                  }
#line 3675 "src/y.tab.c"
    break;

  case 216:
#line 695 "src/p.y"
                                                   {
                        Run.limits.networkTimeout = (yyvsp[-1].number) * 1000;
                  }
#line 3683 "src/y.tab.c"
    break;

  case 217:
#line 698 "src/p.y"
                                                        {
                        Run.limits.programTimeout = (yyvsp[-1].number);
                  }
#line 3691 "src/y.tab.c"
    break;

  case 218:
#line 701 "src/p.y"
                                                   {
                        Run.limits.programTimeout = (yyvsp[-1].number) * 1000;
                  }
#line 3699 "src/y.tab.c"
    break;

  case 219:
#line 704 "src/p.y"
                                                     {
                        Run.limits.stopTimeout = (yyvsp[-1].number);
                  }
#line 3707 "src/y.tab.c"
    break;

  case 220:
#line 707 "src/p.y"
                                                {
                        Run.limits.stopTimeout = (yyvsp[-1].number) * 1000;
                  }
#line 3715 "src/y.tab.c"
    break;

  case 221:
#line 710 "src/p.y"
                                                      {
                        Run.limits.startTimeout = (yyvsp[-1].number);
                  }
#line 3723 "src/y.tab.c"
    break;

  case 222:
#line 713 "src/p.y"
                                                 {
                        Run.limits.startTimeout = (yyvsp[-1].number) * 1000;
                  }
#line 3731 "src/y.tab.c"
    break;

  case 223:
#line 716 "src/p.y"
                                                        {
                        Run.limits.restartTimeout = (yyvsp[-1].number);
                  }
#line 3739 "src/y.tab.c"
    break;

  case 224:
#line 719 "src/p.y"
                                                   {
                        Run.limits.restartTimeout = (yyvsp[-1].number) * 1000;
                  }
#line 3747 "src/y.tab.c"
    break;

  case 225:
#line 724 "src/p.y"
                           {
                        Run.flags |= Run_FipsEnabled;
                  }
#line 3755 "src/y.tab.c"
    break;

  case 226:
#line 729 "src/p.y"
                                     {
                        if (! Run.files.log || ihp.logfile) {
                                ihp.logfile = true;
                                setlogfile((yyvsp[0].string));
                                Run.flags &= ~Run_UseSyslog;
                                Run.flags |= Run_Log;
                        }
                  }
#line 3768 "src/y.tab.c"
    break;

  case 227:
#line 737 "src/p.y"
                                     {
                        setsyslog(NULL);
                  }
#line 3776 "src/y.tab.c"
    break;

  case 228:
#line 740 "src/p.y"
                                                     {
                        setsyslog((yyvsp[0].string)); FREE((yyvsp[0].string));
                  }
#line 3784 "src/y.tab.c"
    break;

  case 229:
#line 745 "src/p.y"
                                              {
                        Run.eventlist_dir = (yyvsp[0].string);
                  }
#line 3792 "src/y.tab.c"
    break;

  case 230:
#line 748 "src/p.y"
                                                          {
                        Run.eventlist_dir = (yyvsp[-2].string);
                        Run.eventlist_slots = (yyvsp[0].number);
                  }
#line 3801 "src/y.tab.c"
    break;

  case 231:
#line 752 "src/p.y"
                                             {
                        Run.eventlist_dir = Str_dup(MYEVENTLISTBASE);
                        Run.eventlist_slots = (yyvsp[0].number);
                  }
#line 3810 "src/y.tab.c"
    break;

  case 232:
#line 758 "src/p.y"
                                  {
                        Run.files.id = (yyvsp[0].string);
                  }
#line 3818 "src/y.tab.c"
    break;

  case 233:
#line 763 "src/p.y"
                                     {
                        Run.files.state = (yyvsp[0].string);
                  }
#line 3826 "src/y.tab.c"
    break;

  case 234:
#line 768 "src/p.y"
                                   {
                        if (! Run.files.pid || ihp.pidfile) {
                                ihp.pidfile = true;
                                setpidfile((yyvsp[0].string));
                        }
                  }
#line 3837 "src/y.tab.c"
    break;

  case 238:
#line 783 "src/p.y"
                                          {
                        mmonitset.url = (yyvsp[-1].url);
                        addmmonit(&mmonitset);
                  }
#line 3846 "src/y.tab.c"
    break;

  case 241:
#line 793 "src/p.y"
                                        {
                        mmonitset.timeout = (yyvsp[-1].number) * 1000; // net timeout is in milliseconds internally
                  }
#line 3854 "src/y.tab.c"
    break;

  case 247:
#line 803 "src/p.y"
                                       {
                        Run.flags &= ~Run_MmonitCredentials;
                  }
#line 3862 "src/y.tab.c"
    break;

  case 248:
#line 808 "src/p.y"
                                                     {
                        _setSSLOptions(&(Run.ssl));
                  }
#line 3870 "src/y.tab.c"
    break;

  case 249:
#line 813 "src/p.y"
                           {
                        sslset.flags = SSL_Enabled;
                  }
#line 3878 "src/y.tab.c"
    break;

  case 253:
#line 823 "src/p.y"
                                    {
                        sslset.flags = SSL_Enabled;
                        sslset.verify = true;
                  }
#line 3887 "src/y.tab.c"
    break;

  case 254:
#line 827 "src/p.y"
                                     {
                        sslset.flags = SSL_Enabled;
                        sslset.verify = false;
                  }
#line 3896 "src/y.tab.c"
    break;

  case 255:
#line 831 "src/p.y"
                                       {
                        sslset.flags = SSL_Enabled;
                        sslset.allowSelfSigned = true;
                  }
#line 3905 "src/y.tab.c"
    break;

  case 256:
#line 835 "src/p.y"
                                           {
                        sslset.flags = SSL_Enabled;
                        sslset.allowSelfSigned = false;
                  }
#line 3914 "src/y.tab.c"
    break;

  case 257:
#line 839 "src/p.y"
                                                {
                        sslset.flags = SSL_Enabled;
                  }
#line 3922 "src/y.tab.c"
    break;

  case 258:
#line 842 "src/p.y"
                                    {
                        FREE(sslset.ciphers);
                        sslset.ciphers = (yyvsp[0].string);
                  }
#line 3931 "src/y.tab.c"
    break;

  case 259:
#line 846 "src/p.y"
                                   {
                        _setPEM(&(sslset.pemfile), (yyvsp[0].string), "SSL server PEM file", true);
                  }
#line 3939 "src/y.tab.c"
    break;

  case 260:
#line 849 "src/p.y"
                                    {
                        _setPEM(&(sslset.pemchain), (yyvsp[0].string), "SSL certificate chain PEM file", true);
                  }
#line 3947 "src/y.tab.c"
    break;

  case 261:
#line 852 "src/p.y"
                                  {
                        _setPEM(&(sslset.pemkey), (yyvsp[0].string), "SSL server private key PEM file", true);
                  }
#line 3955 "src/y.tab.c"
    break;

  case 262:
#line 855 "src/p.y"
                                         {
                        _setPEM(&(sslset.clientpemfile), (yyvsp[0].string), "SSL client PEM file", true);
                  }
#line 3963 "src/y.tab.c"
    break;

  case 263:
#line 858 "src/p.y"
                                             {
                        _setPEM(&(sslset.CACertificateFile), (yyvsp[0].string), "SSL CA certificates file", true);
                  }
#line 3971 "src/y.tab.c"
    break;

  case 264:
#line 861 "src/p.y"
                                             {
                        _setPEM(&(sslset.CACertificatePath), (yyvsp[0].string), "SSL CA certificates directory", false);
                  }
#line 3979 "src/y.tab.c"
    break;

  case 265:
#line 866 "src/p.y"
                                                              {
                        sslset.flags = SSL_Enabled;
                        portset.target.net.ssl.certificate.minimumDays = (yyvsp[-1].number);
                  }
#line 3988 "src/y.tab.c"
    break;

  case 268:
#line 876 "src/p.y"
                                                               {
                        sslset.flags = SSL_Enabled;
                        sslset.checksum = (yyvsp[0].string);
                        switch (cleanup_hash_string(sslset.checksum)) {
                                case 32:
                                        sslset.checksumType = Hash_Md5;
                                        break;
                                case 40:
                                        sslset.checksumType = Hash_Sha1;
                                        break;
                                default:
                                        yyerror2("Unknown checksum type: [%s] is not MD5 nor SHA1", sslset.checksum);
                        }
                  }
#line 4007 "src/y.tab.c"
    break;

  case 269:
#line 890 "src/p.y"
                                                                       {
                        sslset.flags = SSL_Enabled;
                        sslset.checksum = (yyvsp[0].string);
                        if (cleanup_hash_string(sslset.checksum) != 32)
                                yyerror2("Unknown checksum type: [%s] is not MD5", sslset.checksum);
                        sslset.checksumType = Hash_Md5;
                  }
#line 4019 "src/y.tab.c"
    break;

  case 270:
#line 897 "src/p.y"
                                                                        {
                        sslset.flags = SSL_Enabled;
                        sslset.checksum = (yyvsp[0].string);
                        if (cleanup_hash_string(sslset.checksum) != 40)
                                yyerror2("Unknown checksum type: [%s] is not SHA1", sslset.checksum);
                        sslset.checksumType = Hash_Sha1;
                  }
#line 4031 "src/y.tab.c"
    break;

  case 275:
#line 914 "src/p.y"
                        {
#if defined OPENSSL_NO_SSL2 || ! defined HAVE_SSLV2 || ! defined HAVE_OPENSSL
                        yyerror("Your SSL Library does not support SSL version 2");
#else
                        _setSSLVersion(SSL_V2);
#endif
                  }
#line 4043 "src/y.tab.c"
    break;

  case 276:
#line 921 "src/p.y"
                          {
                        _unsetSSLVersion(SSL_V2);
                  }
#line 4051 "src/y.tab.c"
    break;

  case 277:
#line 924 "src/p.y"
                        {
#if defined OPENSSL_NO_SSL3 || ! defined HAVE_OPENSSL
                        yyerror("Your SSL Library does not support SSL version 3");
#else
                        _setSSLVersion(SSL_V3);
#endif
                  }
#line 4063 "src/y.tab.c"
    break;

  case 278:
#line 931 "src/p.y"
                          {
                        _unsetSSLVersion(SSL_V3);
                  }
#line 4071 "src/y.tab.c"
    break;

  case 279:
#line 934 "src/p.y"
                        {
#if defined OPENSSL_NO_TLS1_METHOD || ! defined HAVE_OPENSSL
                        yyerror("Your SSL Library does not support TLS version 1.0");
#else
                        _setSSLVersion(SSL_TLSV1);
#endif
                  }
#line 4083 "src/y.tab.c"
    break;

  case 280:
#line 941 "src/p.y"
                          {
                        _unsetSSLVersion(SSL_TLSV1);
                  }
#line 4091 "src/y.tab.c"
    break;

  case 281:
#line 944 "src/p.y"
                         {
#if defined OPENSSL_NO_TLS1_1_METHOD || ! defined HAVE_TLSV1_1 || ! defined HAVE_OPENSSL
                        yyerror("Your SSL Library does not support TLS version 1.1");
#else
                        _setSSLVersion(SSL_TLSV11);
#endif
                }
#line 4103 "src/y.tab.c"
    break;

  case 282:
#line 951 "src/p.y"
                           {
                        _unsetSSLVersion(SSL_TLSV11);
                  }
#line 4111 "src/y.tab.c"
    break;

  case 283:
#line 954 "src/p.y"
                         {
#if defined OPENSSL_NO_TLS1_2_METHOD || ! defined HAVE_TLSV1_2 || ! defined HAVE_OPENSSL
                        yyerror("Your SSL Library does not support TLS version 1.2");
#else
                        _setSSLVersion(SSL_TLSV12);
#endif
                }
#line 4123 "src/y.tab.c"
    break;

  case 284:
#line 961 "src/p.y"
                           {
                        _unsetSSLVersion(SSL_TLSV12);
                  }
#line 4131 "src/y.tab.c"
    break;

  case 285:
#line 964 "src/p.y"
                         {
#if defined OPENSSL_NO_TLS1_3_METHOD || ! defined HAVE_TLSV1_3 || ! defined HAVE_OPENSSL
                        yyerror("Your SSL Library does not support TLS version 1.3");
#else
                        _setSSLVersion(SSL_TLSV13);
#endif
                }
#line 4143 "src/y.tab.c"
    break;

  case 286:
#line 971 "src/p.y"
                           {
                        _unsetSSLVersion(SSL_TLSV13);
                  }
#line 4151 "src/y.tab.c"
    break;

  case 287:
#line 974 "src/p.y"
                       {
                        // Enable just TLS 1.2 and 1.3 by default
#if ! defined OPENSSL_NO_TLS1_2_METHOD && defined HAVE_TLSV1_2 && defined HAVE_OPENSSL
                        _setSSLVersion(SSL_TLSV12);
#endif
#if ! defined OPENSSL_NO_TLS1_3_METHOD && defined HAVE_TLSV1_3 && defined HAVE_OPENSSL
                        _setSSLVersion(SSL_TLSV13);
#endif
                  }
#line 4165 "src/y.tab.c"
    break;

  case 288:
#line 985 "src/p.y"
                                 { // Backward compatibility
                        sslset.flags = SSL_Enabled;
                        sslset.checksum = (yyvsp[0].string);
                        if (cleanup_hash_string(sslset.checksum) != 32)
                                yyerror2("Unknown checksum type: [%s] is not MD5", sslset.checksum);
                        sslset.checksumType = Hash_Md5;
                  }
#line 4177 "src/y.tab.c"
    break;

  case 289:
#line 994 "src/p.y"
                                                                    {
                        if (((yyvsp[-1].number)) > SMTP_TIMEOUT)
                                Run.mailserver_timeout = (yyvsp[-1].number);
                        Run.mail_hostname = (yyvsp[0].string);
                  }
#line 4187 "src/y.tab.c"
    break;

  case 290:
#line 1001 "src/p.y"
                                                          {
                        if (mailset.from) {
                                Run.MailFormat.from = mailset.from;
                        } else {
                                Run.MailFormat.from = Address_new();
                                Run.MailFormat.from->address = Str_dup(ALERT_FROM);
                        }
                        if (mailset.replyto)
                                Run.MailFormat.replyto = mailset.replyto;
                        Run.MailFormat.subject = mailset.subject ?  mailset.subject : Str_dup(ALERT_SUBJECT);
                        Run.MailFormat.message = mailset.message ?  mailset.message : Str_dup(ALERT_MESSAGE);
                        reset_mailset();
                  }
#line 4205 "src/y.tab.c"
    break;

  case 293:
#line 1020 "src/p.y"
                                           {
                        /* Restore the current text overridden by lookahead */
                        FREE(argyytext);
                        argyytext = Str_dup((yyvsp[-1].string));

                        mailserverset.host = (yyvsp[-1].string);
                        mailserverset.port = PORT_SMTP;
                        addmailserver(&mailserverset);
                  }
#line 4219 "src/y.tab.c"
    break;

  case 294:
#line 1029 "src/p.y"
                                                       {
                        /* Restore the current text overridden by lookahead */
                        FREE(argyytext);
                        argyytext = Str_dup((yyvsp[-3].string));

                        mailserverset.host = (yyvsp[-3].string);
                        mailserverset.port = (yyvsp[-1].number);
                        addmailserver(&mailserverset);
                  }
#line 4233 "src/y.tab.c"
    break;

  case 297:
#line 1044 "src/p.y"
                           {
                        mailserverset.username = (yyvsp[0].string);
                  }
#line 4241 "src/y.tab.c"
    break;

  case 298:
#line 1047 "src/p.y"
                           {
                        mailserverset.password = (yyvsp[0].string);
                  }
#line 4249 "src/y.tab.c"
    break;

  case 303:
#line 1056 "src/p.y"
                                      {
                        if (sslset.flags & SSL_Enabled) {
#ifdef HAVE_OPENSSL
                                if (sslset.pemfile) {
                                        if (sslset.pemchain || sslset.pemkey) {
                                                yyerror("SSL server option pemfile and pemchain|pemkey are mutually exclusive");
                                        } else if (! file_checkStat(sslset.pemfile, "SSL server PEM file", S_IRWXU | S_IRGRP | S_IXGRP)) {
                                                yyerror("SSL server PEM file permissions check failed");
                                        } else {
                                                _setSSLOptions(&(Run.httpd.socket.net.ssl));
                                        }
                                } else if (sslset.pemchain && sslset.pemkey) {
                                        if (! file_checkStat(sslset.pemkey, "SSL server private key PEM file", S_IRWXU | S_IRGRP | S_IXGRP)) {
                                                yyerror("SSL server private key PEM file permissions check failed");
                                        } else {
                                                _setSSLOptions(&(Run.httpd.socket.net.ssl));
                                        }
                                } else {
                                        yyerror("SSL server PEM file is required (please use ssl pemfile option)");
                                }
#else
                                yyerror("SSL is not supported");
#endif
                        }
                  }
#line 4279 "src/y.tab.c"
    break;

  case 315:
#line 1099 "src/p.y"
                               {
                        _setPEM(&(sslset.pemfile), (yyvsp[0].string), "SSL server PEM file", true);
                  }
#line 4287 "src/y.tab.c"
    break;

  case 316:
#line 1105 "src/p.y"
                                     {
                        _setPEM(&(sslset.clientpemfile), (yyvsp[0].string), "SSL client PEM file", true);
                  }
#line 4295 "src/y.tab.c"
    break;

  case 317:
#line 1111 "src/p.y"
                                         {
                        sslset.flags = SSL_Enabled;
                        sslset.allowSelfSigned = true;
                  }
#line 4304 "src/y.tab.c"
    break;

  case 318:
#line 1117 "src/p.y"
                              {
                        Run.httpd.flags |= Httpd_Net;
                        Run.httpd.socket.net.port = (yyvsp[0].number);
                  }
#line 4313 "src/y.tab.c"
    break;

  case 319:
#line 1123 "src/p.y"
                                                        {
                        Run.httpd.flags |= Httpd_Unix;
                        Run.httpd.socket.unix.path = (yyvsp[-1].string);
                  }
#line 4322 "src/y.tab.c"
    break;

  case 322:
#line 1133 "src/p.y"
                               {
                        Run.httpd.flags |= Httpd_UnixUid;
                        Run.httpd.socket.unix.uid = get_uid((yyvsp[0].string), 0);
                        FREE((yyvsp[0].string));
                    }
#line 4332 "src/y.tab.c"
    break;

  case 323:
#line 1138 "src/p.y"
                               {
                        Run.httpd.flags |= Httpd_UnixGid;
                        Run.httpd.socket.unix.gid = get_gid((yyvsp[0].string), 0);
                        FREE((yyvsp[0].string));
                    }
#line 4342 "src/y.tab.c"
    break;

  case 324:
#line 1143 "src/p.y"
                               {
                        Run.httpd.flags |= Httpd_UnixUid;
                        Run.httpd.socket.unix.uid = get_uid(NULL, (yyvsp[0].number));
                    }
#line 4351 "src/y.tab.c"
    break;

  case 325:
#line 1147 "src/p.y"
                               {
                        Run.httpd.flags |= Httpd_UnixGid;
                        Run.httpd.socket.unix.gid = get_gid(NULL, (yyvsp[0].number));
                    }
#line 4360 "src/y.tab.c"
    break;

  case 326:
#line 1151 "src/p.y"
                                      {
                        Run.httpd.flags |= Httpd_UnixPermission;
                        Run.httpd.socket.unix.permission = check_perm((yyvsp[0].number));
                    }
#line 4369 "src/y.tab.c"
    break;

  case 331:
#line 1165 "src/p.y"
                             {
                        Run.httpd.flags |= Httpd_Signature;
                  }
#line 4377 "src/y.tab.c"
    break;

  case 332:
#line 1168 "src/p.y"
                             {
                        Run.httpd.flags &= ~Httpd_Signature;
                  }
#line 4385 "src/y.tab.c"
    break;

  case 333:
#line 1173 "src/p.y"
                                 {
                        Run.httpd.socket.net.address = (yyvsp[0].string);
                  }
#line 4393 "src/y.tab.c"
    break;

  case 334:
#line 1178 "src/p.y"
                                                 {
                        addcredentials((yyvsp[-3].string), (yyvsp[-1].string), Digest_Cleartext, (yyvsp[0].number));
                  }
#line 4401 "src/y.tab.c"
    break;

  case 335:
#line 1181 "src/p.y"
                                           {
#ifdef HAVE_LIBPAM
                        addpamauth((yyvsp[-1].string), (yyvsp[0].number));
#else
                        yyerror("PAM is not supported");
                        FREE((yyvsp[-1].string));
#endif
                  }
#line 4414 "src/y.tab.c"
    break;

  case 336:
#line 1189 "src/p.y"
                             {
                        addhtpasswdentry((yyvsp[0].string), NULL, Digest_Cleartext);
                        FREE((yyvsp[0].string));
                  }
#line 4423 "src/y.tab.c"
    break;

  case 337:
#line 1193 "src/p.y"
                                       {
                        addhtpasswdentry((yyvsp[0].string), NULL, Digest_Cleartext);
                        FREE((yyvsp[0].string));
                  }
#line 4432 "src/y.tab.c"
    break;

  case 338:
#line 1197 "src/p.y"
                                     {
                        addhtpasswdentry((yyvsp[0].string), NULL, Digest_Md5);
                        FREE((yyvsp[0].string));
                  }
#line 4441 "src/y.tab.c"
    break;

  case 339:
#line 1201 "src/p.y"
                                   {
                        addhtpasswdentry((yyvsp[0].string), NULL, Digest_Crypt);
                        FREE((yyvsp[0].string));
                  }
#line 4450 "src/y.tab.c"
    break;

  case 340:
#line 1205 "src/p.y"
                             {
                        htpasswd_file = (yyvsp[0].string);
                        digesttype = Digest_Cleartext;
                  }
#line 4459 "src/y.tab.c"
    break;

  case 341:
#line 1209 "src/p.y"
                                {
                        FREE(htpasswd_file);
                  }
#line 4467 "src/y.tab.c"
    break;

  case 342:
#line 1212 "src/p.y"
                                       {
                        htpasswd_file = (yyvsp[0].string);
                        digesttype = Digest_Cleartext;
                  }
#line 4476 "src/y.tab.c"
    break;

  case 343:
#line 1216 "src/p.y"
                                {
                        FREE(htpasswd_file);
                  }
#line 4484 "src/y.tab.c"
    break;

  case 344:
#line 1219 "src/p.y"
                                     {
                        htpasswd_file = (yyvsp[0].string);
                        digesttype = Digest_Md5;
                  }
#line 4493 "src/y.tab.c"
    break;

  case 345:
#line 1223 "src/p.y"
                                {
                        FREE(htpasswd_file);
                  }
#line 4501 "src/y.tab.c"
    break;

  case 346:
#line 1226 "src/p.y"
                                   {
                        htpasswd_file = (yyvsp[0].string);
                        digesttype = Digest_Crypt;
                  }
#line 4510 "src/y.tab.c"
    break;

  case 347:
#line 1230 "src/p.y"
                                {
                        FREE(htpasswd_file);
                  }
#line 4518 "src/y.tab.c"
    break;

  case 348:
#line 1233 "src/p.y"
                               {
                        if (! Engine_addAllow((yyvsp[0].string)))
                                yywarning2("invalid allow option: %s", (yyvsp[0].string));
                        FREE((yyvsp[0].string));
                  }
#line 4528 "src/y.tab.c"
    break;

  case 351:
#line 1244 "src/p.y"
                         {
                        addhtpasswdentry(htpasswd_file, (yyvsp[0].string), digesttype);
                        FREE((yyvsp[0].string));
                  }
#line 4537 "src/y.tab.c"
    break;

  case 352:
#line 1250 "src/p.y"
                              {
                        (yyval.number) = false;
                  }
#line 4545 "src/y.tab.c"
    break;

  case 353:
#line 1253 "src/p.y"
                           {
                        (yyval.number) = true;
                  }
#line 4553 "src/y.tab.c"
    break;

  case 354:
#line 1258 "src/p.y"
                                                     {
                        createservice(Service_Process, (yyvsp[-2].string), (yyvsp[0].string), check_process);
                  }
#line 4561 "src/y.tab.c"
    break;

  case 355:
#line 1261 "src/p.y"
                                                     {
                        createservice(Service_Process, (yyvsp[-2].string), (yyvsp[0].string), check_process);
                  }
#line 4569 "src/y.tab.c"
    break;

  case 356:
#line 1264 "src/p.y"
                                                     {
                        createservice(Service_Process, (yyvsp[-2].string), (yyvsp[0].string), check_process);
                        matchset.ignore = false;
                        matchset.match_path = NULL;
                        matchset.match_string = Str_dup((yyvsp[0].string));
                        addmatch(&matchset, Action_Ignored, 0);
                  }
#line 4581 "src/y.tab.c"
    break;

  case 357:
#line 1271 "src/p.y"
                                                   {
                        createservice(Service_Process, (yyvsp[-2].string), (yyvsp[0].string), check_process);
                        matchset.ignore = false;
                        matchset.match_path = NULL;
                        matchset.match_string = Str_dup((yyvsp[0].string));
                        addmatch(&matchset, Action_Ignored, 0);
                  }
#line 4593 "src/y.tab.c"
    break;

  case 358:
#line 1280 "src/p.y"
                                                     {
                        createservice(Service_File, (yyvsp[-2].string), (yyvsp[0].string), check_file);
                  }
#line 4601 "src/y.tab.c"
    break;

  case 359:
#line 1285 "src/p.y"
                                                        {
                        createservice(Service_Filesystem, (yyvsp[-2].string), (yyvsp[0].string), check_filesystem);
                  }
#line 4609 "src/y.tab.c"
    break;

  case 360:
#line 1288 "src/p.y"
                                                          {
                        createservice(Service_Filesystem, (yyvsp[-2].string), (yyvsp[0].string), check_filesystem);
                  }
#line 4617 "src/y.tab.c"
    break;

  case 361:
#line 1293 "src/p.y"
                                                    {
                        createservice(Service_Directory, (yyvsp[-2].string), (yyvsp[0].string), check_directory);
                  }
#line 4625 "src/y.tab.c"
    break;

  case 362:
#line 1298 "src/p.y"
                                                       {
                        createservice(Service_Host, (yyvsp[-2].string), (yyvsp[0].string), check_remote_host);
                  }
#line 4633 "src/y.tab.c"
    break;

  case 363:
#line 1303 "src/p.y"
                                                      {
                        if (Link_isGetByAddressSupported()) {
                                createservice(Service_Net, (yyvsp[-2].string), (yyvsp[0].string), check_net);
                                current->inf.net->stats = Link_createForAddress((yyvsp[0].string));
                        } else {
                                yyerror("Network monitoring by IP address is not supported on this platform, please use 'check network <foo> with interface <bar>' instead");
                        }
                  }
#line 4646 "src/y.tab.c"
    break;

  case 364:
#line 1311 "src/p.y"
                                                        {
                        createservice(Service_Net, (yyvsp[-2].string), (yyvsp[0].string), check_net);
                        current->inf.net->stats = Link_createForInterface((yyvsp[0].string));
                  }
#line 4655 "src/y.tab.c"
    break;

  case 365:
#line 1317 "src/p.y"
                                          {
                        char *servicename = (yyvsp[0].string);
                        if (Str_sub(servicename, "$HOST")) {
                                char hostname[STRLEN];
                                if (gethostname(hostname, sizeof(hostname))) {
                                        Log_error("System hostname error -- %s\n", STRERROR);
                                        cfg_errflag++;
                                } else {
                                        Util_replaceString(&servicename, "$HOST", hostname);
                                }
                        }
                        Run.system = createservice(Service_System, servicename, NULL, check_system); // The name given in the 'check system' statement overrides system hostname
                  }
#line 4673 "src/y.tab.c"
    break;

  case 366:
#line 1332 "src/p.y"
                                                     {
                        createservice(Service_Fifo, (yyvsp[-2].string), (yyvsp[0].string), check_fifo);
                  }
#line 4681 "src/y.tab.c"
    break;

  case 367:
#line 1337 "src/p.y"
                                                                               {
                        createservice(Service_Program, (yyvsp[-3].string), NULL, check_program);
                        current->program->timeout = (yyvsp[0].number);
                        current->program->lastOutput = StringBuffer_create(64);
                        current->program->inprogressOutput = StringBuffer_create(64);
                 }
#line 4692 "src/y.tab.c"
    break;

  case 368:
#line 1343 "src/p.y"
                                                                                              {
                        createservice(Service_Program, (yyvsp[-4].string), NULL, check_program);
                        current->program->timeout = (yyvsp[0].number);
                        current->program->lastOutput = StringBuffer_create(64);
                        current->program->inprogressOutput = StringBuffer_create(64);
                 }
#line 4703 "src/y.tab.c"
    break;

  case 369:
#line 1351 "src/p.y"
                                                  {
                        addcommand(START, (yyvsp[0].number));
                  }
#line 4711 "src/y.tab.c"
    break;

  case 370:
#line 1354 "src/p.y"
                                                                 {
                        addcommand(START, (yyvsp[0].number));
                  }
#line 4719 "src/y.tab.c"
    break;

  case 371:
#line 1359 "src/p.y"
                                                {
                        addcommand(STOP, (yyvsp[0].number));
                  }
#line 4727 "src/y.tab.c"
    break;

  case 372:
#line 1362 "src/p.y"
                                                               {
                        addcommand(STOP, (yyvsp[0].number));
                  }
#line 4735 "src/y.tab.c"
    break;

  case 373:
#line 1368 "src/p.y"
                                                      {
                        addcommand(RESTART, (yyvsp[0].number));
                  }
#line 4743 "src/y.tab.c"
    break;

  case 374:
#line 1371 "src/p.y"
                                                                     {
                        addcommand(RESTART, (yyvsp[0].number));
                  }
#line 4751 "src/y.tab.c"
    break;

  case 379:
#line 1384 "src/p.y"
                         {
                        addargument((yyvsp[0].string));
                  }
#line 4759 "src/y.tab.c"
    break;

  case 380:
#line 1387 "src/p.y"
                       {
                        addargument((yyvsp[0].string));
                  }
#line 4767 "src/y.tab.c"
    break;

  case 381:
#line 1392 "src/p.y"
                             {
                        addeuid(get_uid((yyvsp[0].string), 0));
                        FREE((yyvsp[0].string));
                  }
#line 4776 "src/y.tab.c"
    break;

  case 382:
#line 1396 "src/p.y"
                             {
                        addegid(get_gid((yyvsp[0].string), 0));
                        FREE((yyvsp[0].string));
                  }
#line 4785 "src/y.tab.c"
    break;

  case 383:
#line 1400 "src/p.y"
                             {
                        addeuid(get_uid(NULL, (yyvsp[0].number)));
                  }
#line 4793 "src/y.tab.c"
    break;

  case 384:
#line 1403 "src/p.y"
                             {
                        addegid(get_gid(NULL, (yyvsp[0].number)));
                  }
#line 4801 "src/y.tab.c"
    break;

  case 385:
#line 1408 "src/p.y"
                                    {
                        (yyval.string) = (yyvsp[0].string);
                  }
#line 4809 "src/y.tab.c"
    break;

  case 386:
#line 1411 "src/p.y"
                                  {
                        (yyval.string) = (yyvsp[0].string);
                  }
#line 4817 "src/y.tab.c"
    break;

  case 387:
#line 1416 "src/p.y"
                                  {
                        (yyval.string) = (yyvsp[0].string);
                  }
#line 4825 "src/y.tab.c"
    break;

  case 388:
#line 1421 "src/p.y"
                                  {
                        (yyval.string) = (yyvsp[0].string);
                  }
#line 4833 "src/y.tab.c"
    break;

  case 389:
#line 1426 "src/p.y"
                                  {
                        (yyval.string) = NULL;
                  }
#line 4841 "src/y.tab.c"
    break;

  case 390:
#line 1429 "src/p.y"
                                  {
                        (yyval.string) = (yyvsp[0].string);
                  }
#line 4849 "src/y.tab.c"
    break;

  case 391:
#line 1434 "src/p.y"
                                                                                            {
                        /* This is a workaround to support content match without having to create an URL object. 'urloption' creates the Request_T object we need minus the URL object, but with enough information to perform content test.
                           TODO: Parser is in need of refactoring */
                        portset.url_request = urlrequest;
                        portset.check_invers = false;
                        portset.responsetime.operator = responsetimeset.operator;
                        portset.responsetime.limit = responsetimeset.limit;
                        addeventaction(&(portset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addport(&(current->portlist), &portset);
                  }
#line 4864 "src/y.tab.c"
    break;

  case 392:
#line 1444 "src/p.y"
                                                                                               {
                        portset.url_request = urlrequest;
                        portset.check_invers = true;
                        portset.responsetime.operator = responsetimeset.operator;
                        portset.responsetime.limit = responsetimeset.limit;
                        addeventaction(&(portset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addport(&(current->portlist), &portset);
                  }
#line 4877 "src/y.tab.c"
    break;

  case 407:
#line 1472 "src/p.y"
                                                                                                   {
                        portset.check_invers = false;
                        portset.responsetime.operator = responsetimeset.operator;
                        portset.responsetime.limit = responsetimeset.limit;
                        prepare_urlrequest((yyvsp[-5].url));
                        addeventaction(&(portset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addport(&(current->portlist), &portset);
                  }
#line 4890 "src/y.tab.c"
    break;

  case 408:
#line 1480 "src/p.y"
                                                                                                      {
                        portset.check_invers = true;
                        portset.responsetime.operator = responsetimeset.operator;
                        portset.responsetime.limit = responsetimeset.limit;
                        prepare_urlrequest((yyvsp[-5].url));
                        addeventaction(&(portset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addport(&(current->portlist), &portset);
                  }
#line 4903 "src/y.tab.c"
    break;

  case 417:
#line 1502 "src/p.y"
                                                                                               {
                        portset.check_invers = false;
                        portset.responsetime.operator = responsetimeset.operator;
                        portset.responsetime.limit = responsetimeset.limit;
                        addeventaction(&(portset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addport(&(current->socketlist), &portset);
                  }
#line 4915 "src/y.tab.c"
    break;

  case 418:
#line 1509 "src/p.y"
                                                                                                  {
                        portset.check_invers = true;
                        portset.responsetime.operator = responsetimeset.operator;
                        portset.responsetime.limit = responsetimeset.limit;
                        addeventaction(&(portset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addport(&(current->socketlist), &portset);
                  }
#line 4927 "src/y.tab.c"
    break;

  case 427:
#line 1530 "src/p.y"
                                                                                          {
                        icmpset.family = Socket_Ip;
                        icmpset.check_invers = false;
                        icmpset.type = (yyvsp[-5].number);
                        icmpset.responsetime.operator = responsetimeset.operator;
                        icmpset.responsetime.limit = responsetimeset.limit;
                        addeventaction(&(icmpset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addicmp(&icmpset);
                  }
#line 4941 "src/y.tab.c"
    break;

  case 428:
#line 1539 "src/p.y"
                                                                                 {
                        icmpset.family = Socket_Ip;
                        icmpset.check_invers = false;
                        addeventaction(&(icmpset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addicmp(&icmpset);
                 }
#line 4952 "src/y.tab.c"
    break;

  case 429:
#line 1545 "src/p.y"
                                                                                  {
                        icmpset.family = Socket_Ip4;
                        icmpset.check_invers = false;
                        addeventaction(&(icmpset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addicmp(&icmpset);
                 }
#line 4963 "src/y.tab.c"
    break;

  case 430:
#line 1551 "src/p.y"
                                                                                  {
                        icmpset.family = Socket_Ip6;
                        icmpset.check_invers = false;
                        addeventaction(&(icmpset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addicmp(&icmpset);
                 }
#line 4974 "src/y.tab.c"
    break;

  case 431:
#line 1557 "src/p.y"
                                                                                             {
                        icmpset.family = Socket_Ip;
                        icmpset.check_invers = true;
                        icmpset.type = (yyvsp[-5].number);
                        icmpset.responsetime.operator = responsetimeset.operator;
                        icmpset.responsetime.limit = responsetimeset.limit;
                        addeventaction(&(icmpset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addicmp(&icmpset);
                  }
#line 4988 "src/y.tab.c"
    break;

  case 432:
#line 1566 "src/p.y"
                                                                                    {
                        icmpset.family = Socket_Ip;
                        icmpset.check_invers = true;
                        addeventaction(&(icmpset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addicmp(&icmpset);
                 }
#line 4999 "src/y.tab.c"
    break;

  case 433:
#line 1572 "src/p.y"
                                                                                     {
                        icmpset.family = Socket_Ip4;
                        icmpset.check_invers = true;
                        addeventaction(&(icmpset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addicmp(&icmpset);
                 }
#line 5010 "src/y.tab.c"
    break;

  case 434:
#line 1578 "src/p.y"
                                                                                     {
                        icmpset.family = Socket_Ip6;
                        icmpset.check_invers = true;
                        addeventaction(&(icmpset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addicmp(&icmpset);
                 }
#line 5021 "src/y.tab.c"
    break;

  case 441:
#line 1596 "src/p.y"
                              {
                        portset.hostname = Str_dup(current->type == Service_Host ? current->path : LOCALHOST);
                  }
#line 5029 "src/y.tab.c"
    break;

  case 442:
#line 1599 "src/p.y"
                              {
                        portset.hostname = (yyvsp[0].string);
                  }
#line 5037 "src/y.tab.c"
    break;

  case 443:
#line 1604 "src/p.y"
                              {
                        portset.target.net.port = (yyvsp[0].number);
                  }
#line 5045 "src/y.tab.c"
    break;

  case 444:
#line 1609 "src/p.y"
                                  {
                        portset.family = Socket_Unix;
                        portset.target.unix.pathname = (yyvsp[0].string);
                  }
#line 5054 "src/y.tab.c"
    break;

  case 445:
#line 1615 "src/p.y"
                       {
                        portset.family = Socket_Ip4;
                  }
#line 5062 "src/y.tab.c"
    break;

  case 446:
#line 1618 "src/p.y"
                       {
                        portset.family = Socket_Ip6;
                  }
#line 5070 "src/y.tab.c"
    break;

  case 447:
#line 1623 "src/p.y"
                           {
                        portset.type = Socket_Tcp;
                  }
#line 5078 "src/y.tab.c"
    break;

  case 448:
#line 1626 "src/p.y"
                                          { // The typelist is kept for backward compatibility (replaced by ssloptionlist)
                        portset.type = Socket_Tcp;
                        sslset.flags = SSL_Enabled;
                  }
#line 5087 "src/y.tab.c"
    break;

  case 449:
#line 1630 "src/p.y"
                           {
                        portset.type = Socket_Udp;
                  }
#line 5095 "src/y.tab.c"
    break;

  case 454:
#line 1643 "src/p.y"
                                 {
                        _parseOutgoingAddress((yyvsp[0].string), &(portset.outgoing));
                  }
#line 5103 "src/y.tab.c"
    break;

  case 455:
#line 1648 "src/p.y"
                                                         {
                        portset.protocol = Protocol_get(Protocol_APACHESTATUS);
                  }
#line 5111 "src/y.tab.c"
    break;

  case 456:
#line 1651 "src/p.y"
                                  {
                        portset.protocol = Protocol_get(Protocol_CLAMAV);
                  }
#line 5119 "src/y.tab.c"
    break;

  case 457:
#line 1654 "src/p.y"
                                   {
                        portset.protocol = Protocol_get(Protocol_DEFAULT);
                  }
#line 5127 "src/y.tab.c"
    break;

  case 458:
#line 1657 "src/p.y"
                               {
                        portset.protocol = Protocol_get(Protocol_DNS);
                  }
#line 5135 "src/y.tab.c"
    break;

  case 459:
#line 1660 "src/p.y"
                                {
                        portset.protocol = Protocol_get(Protocol_DWP);
                  }
#line 5143 "src/y.tab.c"
    break;

  case 460:
#line 1663 "src/p.y"
                                    {
                        portset.protocol = Protocol_get(Protocol_FAIL2BAN);
                }
#line 5151 "src/y.tab.c"
    break;

  case 461:
#line 1666 "src/p.y"
                               {
                        portset.protocol = Protocol_get(Protocol_FTP);
                  }
#line 5159 "src/y.tab.c"
    break;

  case 462:
#line 1669 "src/p.y"
                               {
                        portset.protocol = Protocol_get(Protocol_GPS);
                  }
#line 5167 "src/y.tab.c"
    break;

  case 463:
#line 1672 "src/p.y"
                                         {
                        portset.protocol = Protocol_get(Protocol_HTTP);
                  }
#line 5175 "src/y.tab.c"
    break;

  case 464:
#line 1675 "src/p.y"
                                          {
                        sslset.flags = SSL_Enabled;
                        portset.type = Socket_Tcp;
                        portset.protocol = Protocol_get(Protocol_HTTP);
                 }
#line 5185 "src/y.tab.c"
    break;

  case 465:
#line 1680 "src/p.y"
                                {
                        portset.protocol = Protocol_get(Protocol_IMAP);
                  }
#line 5193 "src/y.tab.c"
    break;

  case 466:
#line 1683 "src/p.y"
                                 {
                        sslset.flags = SSL_Enabled;
                        portset.type = Socket_Tcp;
                        portset.protocol = Protocol_get(Protocol_IMAP);
                  }
#line 5203 "src/y.tab.c"
    break;

  case 467:
#line 1688 "src/p.y"
                                 {
                        portset.protocol = Protocol_get(Protocol_LDAP2);
                  }
#line 5211 "src/y.tab.c"
    break;

  case 468:
#line 1691 "src/p.y"
                                 {
                        portset.protocol = Protocol_get(Protocol_LDAP3);
                  }
#line 5219 "src/y.tab.c"
    break;

  case 469:
#line 1694 "src/p.y"
                                {
                        portset.protocol = Protocol_get(Protocol_LMTP);
                  }
#line 5227 "src/y.tab.c"
    break;

  case 470:
#line 1697 "src/p.y"
                                    {
                        portset.protocol = Protocol_get(Protocol_MEMCACHE);
                  }
#line 5235 "src/y.tab.c"
    break;

  case 471:
#line 1700 "src/p.y"
                                    {
                        portset.protocol = Protocol_get(Protocol_MONGODB);
                  }
#line 5243 "src/y.tab.c"
    break;

  case 472:
#line 1703 "src/p.y"
                                         {
                        portset.protocol = Protocol_get(Protocol_MQTT);
                  }
#line 5251 "src/y.tab.c"
    break;

  case 473:
#line 1706 "src/p.y"
                                           {
                        portset.protocol = Protocol_get(Protocol_MYSQL);
                  }
#line 5259 "src/y.tab.c"
    break;

  case 474:
#line 1709 "src/p.y"
                                            {
                        sslset.flags = SSL_StartTLS;
                        portset.protocol = Protocol_get(Protocol_MYSQL);
                  }
#line 5268 "src/y.tab.c"
    break;

  case 475:
#line 1713 "src/p.y"
                                {
                        portset.protocol = Protocol_get(Protocol_NNTP);
                  }
#line 5276 "src/y.tab.c"
    break;

  case 476:
#line 1716 "src/p.y"
                                 {
                        portset.protocol = Protocol_get(Protocol_NTP3);
                        portset.type = Socket_Udp;
                  }
#line 5285 "src/y.tab.c"
    break;

  case 477:
#line 1720 "src/p.y"
                                                {
                        portset.protocol = Protocol_get(Protocol_PGSQL);
                  }
#line 5293 "src/y.tab.c"
    break;

  case 478:
#line 1723 "src/p.y"
                               {
                        portset.protocol = Protocol_get(Protocol_POP);
                  }
#line 5301 "src/y.tab.c"
    break;

  case 479:
#line 1726 "src/p.y"
                                {
                        sslset.flags = SSL_Enabled;
                        portset.type = Socket_Tcp;
                        portset.protocol = Protocol_get(Protocol_POP);
                  }
#line 5311 "src/y.tab.c"
    break;

  case 480:
#line 1731 "src/p.y"
                                         {
                        portset.protocol = Protocol_get(Protocol_POSTFIXPOLICY);
                  }
#line 5319 "src/y.tab.c"
    break;

  case 481:
#line 1734 "src/p.y"
                                             {
                        portset.protocol = Protocol_get(Protocol_RADIUS);
                  }
#line 5327 "src/y.tab.c"
    break;

  case 482:
#line 1737 "src/p.y"
                                 {
                        portset.protocol = Protocol_get(Protocol_RDATE);
                  }
#line 5335 "src/y.tab.c"
    break;

  case 483:
#line 1740 "src/p.y"
                                  {
                        portset.protocol = Protocol_get(Protocol_REDIS);
                  }
#line 5343 "src/y.tab.c"
    break;

  case 484:
#line 1743 "src/p.y"
                                 {
                        portset.protocol = Protocol_get(Protocol_RSYNC);
                  }
#line 5351 "src/y.tab.c"
    break;

  case 485:
#line 1746 "src/p.y"
                                 {
                        portset.protocol = Protocol_get(Protocol_SIEVE);
                  }
#line 5359 "src/y.tab.c"
    break;

  case 486:
#line 1749 "src/p.y"
                                       {
                        portset.protocol = Protocol_get(Protocol_SIP);
                  }
#line 5367 "src/y.tab.c"
    break;

  case 487:
#line 1752 "src/p.y"
                                         {
                        portset.protocol = Protocol_get(Protocol_SMTP);
                  }
#line 5375 "src/y.tab.c"
    break;

  case 488:
#line 1755 "src/p.y"
                                          {
                        sslset.flags = SSL_Enabled;
                        portset.type = Socket_Tcp;
                        portset.protocol = Protocol_get(Protocol_SMTP);
                 }
#line 5385 "src/y.tab.c"
    break;

  case 489:
#line 1760 "src/p.y"
                                        {
                        portset.protocol = Protocol_get(Protocol_SPAMASSASSIN);
                  }
#line 5393 "src/y.tab.c"
    break;

  case 490:
#line 1763 "src/p.y"
                                {
                        portset.protocol = Protocol_get(Protocol_SSH);
                  }
#line 5401 "src/y.tab.c"
    break;

  case 491:
#line 1766 "src/p.y"
                               {
                        portset.protocol = Protocol_get(Protocol_TNS);
                  }
#line 5409 "src/y.tab.c"
    break;

  case 492:
#line 1769 "src/p.y"
                                                   {
                        portset.protocol = Protocol_get(Protocol_WEBSOCKET);
                  }
#line 5417 "src/y.tab.c"
    break;

  case 493:
#line 1774 "src/p.y"
                              {
                        if (portset.protocol->check == check_default || portset.protocol->check == check_generic) {
                                portset.protocol = Protocol_get(Protocol_GENERIC);
                                addgeneric(&portset, (yyvsp[0].string), NULL);
                        } else {
                                yyerror("The SEND statement is not allowed in the %s protocol context", portset.protocol->name);
                        }
                  }
#line 5430 "src/y.tab.c"
    break;

  case 494:
#line 1782 "src/p.y"
                                {
                        if (portset.protocol->check == check_default || portset.protocol->check == check_generic) {
                                portset.protocol = Protocol_get(Protocol_GENERIC);
                                addgeneric(&portset, NULL, (yyvsp[0].string));
                        } else {
                                yyerror("The EXPECT statement is not allowed in the %s protocol context", portset.protocol->name);
                        }
                  }
#line 5443 "src/y.tab.c"
    break;

  case 497:
#line 1796 "src/p.y"
                                {
                        portset.parameters.websocket.origin = (yyvsp[0].string);
                  }
#line 5451 "src/y.tab.c"
    break;

  case 498:
#line 1799 "src/p.y"
                               {
                        portset.parameters.websocket.request = (yyvsp[0].string);
                  }
#line 5459 "src/y.tab.c"
    break;

  case 499:
#line 1802 "src/p.y"
                              {
                        portset.parameters.websocket.host = (yyvsp[0].string);
                  }
#line 5467 "src/y.tab.c"
    break;

  case 500:
#line 1805 "src/p.y"
                                    {
                        portset.parameters.websocket.version = (yyvsp[0].number);
                  }
#line 5475 "src/y.tab.c"
    break;

  case 503:
#line 1814 "src/p.y"
                           {
                        portset.parameters.smtp.username = (yyvsp[0].string);
                  }
#line 5483 "src/y.tab.c"
    break;

  case 504:
#line 1817 "src/p.y"
                           {
                        portset.parameters.smtp.password = (yyvsp[0].string);
                  }
#line 5491 "src/y.tab.c"
    break;

  case 507:
#line 1826 "src/p.y"
                           {
                        portset.parameters.mqtt.username = (yyvsp[0].string);
                  }
#line 5499 "src/y.tab.c"
    break;

  case 508:
#line 1829 "src/p.y"
                           {
                        portset.parameters.mqtt.password = (yyvsp[0].string);
                  }
#line 5507 "src/y.tab.c"
    break;

  case 511:
#line 1838 "src/p.y"
                           {
                        portset.parameters.mysql.username = (yyvsp[0].string);
                  }
#line 5515 "src/y.tab.c"
    break;

  case 512:
#line 1841 "src/p.y"
                           {
                        portset.parameters.mysql.password = (yyvsp[0].string);
                  }
#line 5523 "src/y.tab.c"
    break;

  case 513:
#line 1844 "src/p.y"
                                                          {
                        portset.parameters.mysql.rsaChecksum = (yyvsp[0].string);
                        switch (cleanup_hash_string(portset.parameters.mysql.rsaChecksum)) {
                                case 32:
                                        portset.parameters.mysql.rsaChecksumType = Hash_Md5;
                                        break;
                                case 40:
                                        portset.parameters.mysql.rsaChecksumType = Hash_Sha1;
                                        break;
                                default:
                                        yyerror2("Unknown checksum type: [%s] is not MD5 nor SHA1", portset.parameters.mysql.rsaChecksum);
                        }
                  }
#line 5541 "src/y.tab.c"
    break;

  case 514:
#line 1857 "src/p.y"
                                                                  {
                        portset.parameters.mysql.rsaChecksum = (yyvsp[0].string);
                        if (cleanup_hash_string(portset.parameters.mysql.rsaChecksum) != 32)
                                yyerror2("Unknown checksum type: [%s] is not MD5", portset.parameters.mysql.rsaChecksum);
                        portset.parameters.mysql.rsaChecksumType = Hash_Md5;
                  }
#line 5552 "src/y.tab.c"
    break;

  case 515:
#line 1863 "src/p.y"
                                                                   {
                        portset.parameters.mysql.rsaChecksum = (yyvsp[0].string);
                        if (cleanup_hash_string(portset.parameters.mysql.rsaChecksum) != 40)
                                yyerror2("Unknown checksum type: [%s] is not SHA1", portset.parameters.mysql.rsaChecksum);
                        portset.parameters.mysql.rsaChecksumType = Hash_Sha1;
                  }
#line 5563 "src/y.tab.c"
    break;

  case 518:
#line 1875 "src/p.y"
                           {
                        portset.parameters.postgresql.username = (yyvsp[0].string);
                  }
#line 5571 "src/y.tab.c"
    break;

  case 519:
#line 1878 "src/p.y"
                           {
                        portset.parameters.postgresql.password = (yyvsp[0].string);
                  }
#line 5579 "src/y.tab.c"
    break;

  case 520:
#line 1881 "src/p.y"
                           {
                        portset.parameters.postgresql.database = (yyvsp[0].string);
                  }
#line 5587 "src/y.tab.c"
    break;

  case 521:
#line 1886 "src/p.y"
                                  {
                        (yyval.string) = (yyvsp[0].string);
                  }
#line 5595 "src/y.tab.c"
    break;

  case 522:
#line 1889 "src/p.y"
                                {
                        (yyval.string) = (yyvsp[0].string);
                  }
#line 5603 "src/y.tab.c"
    break;

  case 523:
#line 1894 "src/p.y"
                                    {
                        (yyval.number) = verifyMaxForward((yyvsp[0].number));
                  }
#line 5611 "src/y.tab.c"
    break;

  case 526:
#line 1903 "src/p.y"
                         {
                        portset.parameters.sip.target = (yyvsp[0].string);
                  }
#line 5619 "src/y.tab.c"
    break;

  case 527:
#line 1906 "src/p.y"
                             {
                        portset.parameters.sip.maxforward = (yyvsp[0].number);
                  }
#line 5627 "src/y.tab.c"
    break;

  case 530:
#line 1915 "src/p.y"
                           {
                        portset.parameters.http.username = (yyvsp[0].string);
                  }
#line 5635 "src/y.tab.c"
    break;

  case 531:
#line 1918 "src/p.y"
                           {
                        portset.parameters.http.password = (yyvsp[0].string);
                  }
#line 5643 "src/y.tab.c"
    break;

  case 538:
#line 1929 "src/p.y"
                                         {
                        if ((yyvsp[0].number) < 0) {
                                yyerror2("The status value must be greater or equal to 0");
                        }
                        portset.parameters.http.operator = (yyvsp[-1].number);
                        portset.parameters.http.status = (yyvsp[0].number);
                        portset.parameters.http.hasStatus = true;
                  }
#line 5656 "src/y.tab.c"
    break;

  case 539:
#line 1939 "src/p.y"
                             {
                        portset.parameters.http.method = Http_Get;
                  }
#line 5664 "src/y.tab.c"
    break;

  case 540:
#line 1942 "src/p.y"
                              {
                        portset.parameters.http.method = Http_Head;
                  }
#line 5672 "src/y.tab.c"
    break;

  case 541:
#line 1947 "src/p.y"
                               {
                        portset.parameters.http.request = Util_urlEncode((yyvsp[0].string), false);
                        FREE((yyvsp[0].string));
                  }
#line 5681 "src/y.tab.c"
    break;

  case 542:
#line 1951 "src/p.y"
                                 {
                        portset.parameters.http.request = Util_urlEncode((yyvsp[0].string), false);
                        FREE((yyvsp[0].string));
                  }
#line 5690 "src/y.tab.c"
    break;

  case 543:
#line 1957 "src/p.y"
                                  {
                        portset.parameters.http.checksum = (yyvsp[0].string);
                  }
#line 5698 "src/y.tab.c"
    break;

  case 544:
#line 1962 "src/p.y"
                                    {
                        addhttpheader(&portset, Str_cat("Host:%s", (yyvsp[0].string)));
                        FREE((yyvsp[0].string));
                  }
#line 5707 "src/y.tab.c"
    break;

  case 546:
#line 1969 "src/p.y"
                                            {
                        addhttpheader(&portset, (yyvsp[0].string));
                 }
#line 5715 "src/y.tab.c"
    break;

  case 547:
#line 1974 "src/p.y"
                                {
                        (yyval.string) = (yyvsp[0].string);
                  }
#line 5723 "src/y.tab.c"
    break;

  case 550:
#line 1983 "src/p.y"
                         {
                        portset.parameters.radius.secret = (yyvsp[0].string);
                  }
#line 5731 "src/y.tab.c"
    break;

  case 553:
#line 1992 "src/p.y"
                           {
                        portset.parameters.apachestatus.username = (yyvsp[0].string);
                  }
#line 5739 "src/y.tab.c"
    break;

  case 554:
#line 1995 "src/p.y"
                           {
                        portset.parameters.apachestatus.password = (yyvsp[0].string);
                  }
#line 5747 "src/y.tab.c"
    break;

  case 555:
#line 1998 "src/p.y"
                               {
                        portset.parameters.apachestatus.path = (yyvsp[0].string);
                  }
#line 5755 "src/y.tab.c"
    break;

  case 556:
#line 2001 "src/p.y"
                                                   {
                        portset.parameters.apachestatus.loglimitOP = (yyvsp[-2].number);
                        portset.parameters.apachestatus.loglimit = (yyvsp[-1].number);
                  }
#line 5764 "src/y.tab.c"
    break;

  case 557:
#line 2005 "src/p.y"
                                                     {
                        portset.parameters.apachestatus.closelimitOP = (yyvsp[-2].number);
                        portset.parameters.apachestatus.closelimit = (yyvsp[-1].number);
                  }
#line 5773 "src/y.tab.c"
    break;

  case 558:
#line 2009 "src/p.y"
                                                   {
                        portset.parameters.apachestatus.dnslimitOP = (yyvsp[-2].number);
                        portset.parameters.apachestatus.dnslimit = (yyvsp[-1].number);
                  }
#line 5782 "src/y.tab.c"
    break;

  case 559:
#line 2013 "src/p.y"
                                                         {
                        portset.parameters.apachestatus.keepalivelimitOP = (yyvsp[-2].number);
                        portset.parameters.apachestatus.keepalivelimit = (yyvsp[-1].number);
                  }
#line 5791 "src/y.tab.c"
    break;

  case 560:
#line 2017 "src/p.y"
                                                     {
                        portset.parameters.apachestatus.replylimitOP = (yyvsp[-2].number);
                        portset.parameters.apachestatus.replylimit = (yyvsp[-1].number);
                  }
#line 5800 "src/y.tab.c"
    break;

  case 561:
#line 2021 "src/p.y"
                                                       {
                        portset.parameters.apachestatus.requestlimitOP = (yyvsp[-2].number);
                        portset.parameters.apachestatus.requestlimit = (yyvsp[-1].number);
                  }
#line 5809 "src/y.tab.c"
    break;

  case 562:
#line 2025 "src/p.y"
                                                     {
                        portset.parameters.apachestatus.startlimitOP = (yyvsp[-2].number);
                        portset.parameters.apachestatus.startlimit = (yyvsp[-1].number);
                  }
#line 5818 "src/y.tab.c"
    break;

  case 563:
#line 2029 "src/p.y"
                                                    {
                        portset.parameters.apachestatus.waitlimitOP = (yyvsp[-2].number);
                        portset.parameters.apachestatus.waitlimit = (yyvsp[-1].number);
                  }
#line 5827 "src/y.tab.c"
    break;

  case 564:
#line 2033 "src/p.y"
                                                        {
                        portset.parameters.apachestatus.gracefullimitOP = (yyvsp[-2].number);
                        portset.parameters.apachestatus.gracefullimit = (yyvsp[-1].number);
                  }
#line 5836 "src/y.tab.c"
    break;

  case 565:
#line 2037 "src/p.y"
                                                       {
                        portset.parameters.apachestatus.cleanuplimitOP = (yyvsp[-2].number);
                        portset.parameters.apachestatus.cleanuplimit = (yyvsp[-1].number);
                  }
#line 5845 "src/y.tab.c"
    break;

  case 566:
#line 2043 "src/p.y"
                                                                   {
                        addeventaction(&(nonexistset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addnonexist(&nonexistset);
                  }
#line 5854 "src/y.tab.c"
    break;

  case 567:
#line 2047 "src/p.y"
                                                               {
                        addeventaction(&(existset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addexist(&existset);
                  }
#line 5863 "src/y.tab.c"
    break;

  case 568:
#line 2054 "src/p.y"
                                                    {
                        addeventaction(&(pidset).action, (yyvsp[0].number), Action_Ignored);
                        addpid(&pidset);
                  }
#line 5872 "src/y.tab.c"
    break;

  case 569:
#line 2060 "src/p.y"
                                                     {
                        addeventaction(&(ppidset).action, (yyvsp[0].number), Action_Ignored);
                        addppid(&ppidset);
                  }
#line 5881 "src/y.tab.c"
    break;

  case 570:
#line 2066 "src/p.y"
                                                                                     {
                        uptimeset.operator = (yyvsp[-6].number);
                        uptimeset.uptime = ((unsigned long long)(yyvsp[-5].number) * (yyvsp[-4].number));
                        addeventaction(&(uptimeset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        adduptime(&uptimeset);
                  }
#line 5892 "src/y.tab.c"
    break;

  case 571:
#line 2074 "src/p.y"
                                                           {
                        responsetimeset.operator = (yyvsp[-2].number);
                        responsetimeset.limit = (yyvsp[-1].number);
                  }
#line 5901 "src/y.tab.c"
    break;

  case 572:
#line 2078 "src/p.y"
                                                      {
                        responsetimeset.operator = (yyvsp[-2].number);
                        responsetimeset.limit = (yyvsp[-1].number) * 1000;
                  }
#line 5910 "src/y.tab.c"
    break;

  case 573:
#line 2084 "src/p.y"
                               {
                        icmpset.count = (yyvsp[0].number);
                 }
#line 5918 "src/y.tab.c"
    break;

  case 574:
#line 2089 "src/p.y"
                              {
                        icmpset.size = (yyvsp[0].number);
                        if (icmpset.size < 8) {
                                yyerror2("The minimum ping size is 8 bytes");
                        } else if (icmpset.size > 1492) {
                                yyerror2("The maximum ping size is 1492 bytes");
                        }
                 }
#line 5931 "src/y.tab.c"
    break;

  case 575:
#line 2099 "src/p.y"
                                        {
                        icmpset.timeout = (yyvsp[-1].number) * 1000; // timeout is in milliseconds internally
                    }
#line 5939 "src/y.tab.c"
    break;

  case 576:
#line 2104 "src/p.y"
                                 {
                        _parseOutgoingAddress((yyvsp[0].string), &(icmpset.outgoing));
                  }
#line 5947 "src/y.tab.c"
    break;

  case 577:
#line 2109 "src/p.y"
                              {
                        (yyval.number) = Run.limits.stopTimeout;
                  }
#line 5955 "src/y.tab.c"
    break;

  case 578:
#line 2112 "src/p.y"
                                        {
                        (yyval.number) = (yyvsp[-1].number) * 1000; // milliseconds internally
                  }
#line 5963 "src/y.tab.c"
    break;

  case 579:
#line 2117 "src/p.y"
                              {
                        (yyval.number) = Run.limits.startTimeout;
                  }
#line 5971 "src/y.tab.c"
    break;

  case 580:
#line 2120 "src/p.y"
                                        {
                        (yyval.number) = (yyvsp[-1].number) * 1000; // milliseconds internally
                  }
#line 5979 "src/y.tab.c"
    break;

  case 581:
#line 2125 "src/p.y"
                              {
                        (yyval.number) = Run.limits.restartTimeout;
                  }
#line 5987 "src/y.tab.c"
    break;

  case 582:
#line 2128 "src/p.y"
                                        {
                        (yyval.number) = (yyvsp[-1].number) * 1000; // milliseconds internally
                  }
#line 5995 "src/y.tab.c"
    break;

  case 583:
#line 2133 "src/p.y"
                              {
                        (yyval.number) = Run.limits.programTimeout;
                  }
#line 6003 "src/y.tab.c"
    break;

  case 584:
#line 2136 "src/p.y"
                                        {
                        (yyval.number) = (yyvsp[-1].number) * 1000; // milliseconds internally
                  }
#line 6011 "src/y.tab.c"
    break;

  case 585:
#line 2141 "src/p.y"
                              {
                        (yyval.number) = Run.limits.networkTimeout;
                  }
#line 6019 "src/y.tab.c"
    break;

  case 586:
#line 2144 "src/p.y"
                                        {
                        (yyval.number) = (yyvsp[-1].number) * 1000; // net timeout is in milliseconds internally
                  }
#line 6027 "src/y.tab.c"
    break;

  case 587:
#line 2149 "src/p.y"
                                          {
                        portset.timeout = (yyvsp[-1].number) * 1000; // timeout is in milliseconds internally
                    }
#line 6035 "src/y.tab.c"
    break;

  case 588:
#line 2154 "src/p.y"
                               {
                        portset.retry = (yyvsp[0].number);
                  }
#line 6043 "src/y.tab.c"
    break;

  case 589:
#line 2159 "src/p.y"
                                                              {
                        actionrateset.count = (yyvsp[-5].number);
                        actionrateset.cycle = (yyvsp[-3].number);
                        addeventaction(&(actionrateset).action, (yyvsp[0].number), Action_Alert);
                        addactionrate(&actionrateset);
                  }
#line 6054 "src/y.tab.c"
    break;

  case 590:
#line 2165 "src/p.y"
                                                              {
                        actionrateset.count = (yyvsp[-5].number);
                        actionrateset.cycle = (yyvsp[-3].number);
                        addeventaction(&(actionrateset).action, Action_Unmonitor, Action_Alert);
                        addactionrate(&actionrateset);
                  }
#line 6065 "src/y.tab.c"
    break;

  case 591:
#line 2173 "src/p.y"
                                             {
                        seturlrequest((yyvsp[-1].number), (yyvsp[0].string));
                        FREE((yyvsp[0].string));
                  }
#line 6074 "src/y.tab.c"
    break;

  case 592:
#line 2179 "src/p.y"
                           { (yyval.number) = Operator_Equal; }
#line 6080 "src/y.tab.c"
    break;

  case 593:
#line 2180 "src/p.y"
                           { (yyval.number) = Operator_NotEqual; }
#line 6086 "src/y.tab.c"
    break;

  case 594:
#line 2183 "src/p.y"
                                                {
                        mailset.events = Event_All;
                        addmail((yyvsp[-2].string), &mailset, &current->maillist);
                  }
#line 6095 "src/y.tab.c"
    break;

  case 595:
#line 2187 "src/p.y"
                                                                        {
                        addmail((yyvsp[-5].string), &mailset, &current->maillist);
                  }
#line 6103 "src/y.tab.c"
    break;

  case 596:
#line 2190 "src/p.y"
                                                                            {
                        mailset.events = ~mailset.events;
                        addmail((yyvsp[-6].string), &mailset, &current->maillist);
                  }
#line 6112 "src/y.tab.c"
    break;

  case 597:
#line 2194 "src/p.y"
                              {
                        addmail((yyvsp[0].string), &mailset, &current->maillist);
                  }
#line 6120 "src/y.tab.c"
    break;

  case 598:
#line 2199 "src/p.y"
                                 { (yyval.string) = (yyvsp[0].string); }
#line 6126 "src/y.tab.c"
    break;

  case 599:
#line 2202 "src/p.y"
                                   { (yyval.string) = (yyvsp[0].string); }
#line 6132 "src/y.tab.c"
    break;

  case 602:
#line 2209 "src/p.y"
                                  { mailset.events |= Event_Action; }
#line 6138 "src/y.tab.c"
    break;

  case 603:
#line 2210 "src/p.y"
                                  { mailset.events |= Event_ByteIn; }
#line 6144 "src/y.tab.c"
    break;

  case 604:
#line 2211 "src/p.y"
                                  { mailset.events |= Event_ByteOut; }
#line 6150 "src/y.tab.c"
    break;

  case 605:
#line 2212 "src/p.y"
                                  { mailset.events |= Event_Checksum; }
#line 6156 "src/y.tab.c"
    break;

  case 606:
#line 2213 "src/p.y"
                                  { mailset.events |= Event_Connection; }
#line 6162 "src/y.tab.c"
    break;

  case 607:
#line 2214 "src/p.y"
                                  { mailset.events |= Event_Content; }
#line 6168 "src/y.tab.c"
    break;

  case 608:
#line 2215 "src/p.y"
                                  { mailset.events |= Event_Data; }
#line 6174 "src/y.tab.c"
    break;

  case 609:
#line 2216 "src/p.y"
                                  { mailset.events |= Event_Exec; }
#line 6180 "src/y.tab.c"
    break;

  case 610:
#line 2217 "src/p.y"
                                  { mailset.events |= Event_Exist; }
#line 6186 "src/y.tab.c"
    break;

  case 611:
#line 2218 "src/p.y"
                                  { mailset.events |= Event_FsFlag; }
#line 6192 "src/y.tab.c"
    break;

  case 612:
#line 2219 "src/p.y"
                                  { mailset.events |= Event_Gid; }
#line 6198 "src/y.tab.c"
    break;

  case 613:
#line 2220 "src/p.y"
                                  { mailset.events |= Event_Icmp; }
#line 6204 "src/y.tab.c"
    break;

  case 614:
#line 2221 "src/p.y"
                                  { mailset.events |= Event_Instance; }
#line 6210 "src/y.tab.c"
    break;

  case 615:
#line 2222 "src/p.y"
                                  { mailset.events |= Event_Invalid; }
#line 6216 "src/y.tab.c"
    break;

  case 616:
#line 2223 "src/p.y"
                                  { mailset.events |= Event_Link; }
#line 6222 "src/y.tab.c"
    break;

  case 617:
#line 2224 "src/p.y"
                                  { mailset.events |= Event_NonExist; }
#line 6228 "src/y.tab.c"
    break;

  case 618:
#line 2225 "src/p.y"
                                  { mailset.events |= Event_PacketIn; }
#line 6234 "src/y.tab.c"
    break;

  case 619:
#line 2226 "src/p.y"
                                  { mailset.events |= Event_PacketOut; }
#line 6240 "src/y.tab.c"
    break;

  case 620:
#line 2227 "src/p.y"
                                  { mailset.events |= Event_Permission; }
#line 6246 "src/y.tab.c"
    break;

  case 621:
#line 2228 "src/p.y"
                                  { mailset.events |= Event_Pid; }
#line 6252 "src/y.tab.c"
    break;

  case 622:
#line 2229 "src/p.y"
                                  { mailset.events |= Event_PPid; }
#line 6258 "src/y.tab.c"
    break;

  case 623:
#line 2230 "src/p.y"
                                  { mailset.events |= Event_Resource; }
#line 6264 "src/y.tab.c"
    break;

  case 624:
#line 2231 "src/p.y"
                                  { mailset.events |= Event_Saturation; }
#line 6270 "src/y.tab.c"
    break;

  case 625:
#line 2232 "src/p.y"
                                  { mailset.events |= Event_Size; }
#line 6276 "src/y.tab.c"
    break;

  case 626:
#line 2233 "src/p.y"
                                  { mailset.events |= Event_Speed; }
#line 6282 "src/y.tab.c"
    break;

  case 627:
#line 2234 "src/p.y"
                                  { mailset.events |= Event_Status; }
#line 6288 "src/y.tab.c"
    break;

  case 628:
#line 2235 "src/p.y"
                                  { mailset.events |= Event_Timeout; }
#line 6294 "src/y.tab.c"
    break;

  case 629:
#line 2236 "src/p.y"
                                  { mailset.events |= Event_Timestamp; }
#line 6300 "src/y.tab.c"
    break;

  case 630:
#line 2237 "src/p.y"
                                  { mailset.events |= Event_Uid; }
#line 6306 "src/y.tab.c"
    break;

  case 631:
#line 2238 "src/p.y"
                                  { mailset.events |= Event_Uptime; }
#line 6312 "src/y.tab.c"
    break;

  case 636:
#line 2249 "src/p.y"
                                         { mailset.from = (yyvsp[-1].address); }
#line 6318 "src/y.tab.c"
    break;

  case 637:
#line 2250 "src/p.y"
                                            { mailset.replyto = (yyvsp[-1].address); }
#line 6324 "src/y.tab.c"
    break;

  case 638:
#line 2251 "src/p.y"
                              { mailset.subject = (yyvsp[0].string); }
#line 6330 "src/y.tab.c"
    break;

  case 639:
#line 2252 "src/p.y"
                           { mailset.message = (yyvsp[0].string); }
#line 6336 "src/y.tab.c"
    break;

  case 640:
#line 2255 "src/p.y"
                                     {
                        _sanityCheckEveryStatement(current);
                        current->every.type = Every_SkipCycles;
                        current->every.spec.cycle.counter = current->every.spec.cycle.number = (yyvsp[-1].number);
                 }
#line 6346 "src/y.tab.c"
    break;

  case 641:
#line 2260 "src/p.y"
                                 {
                        _sanityCheckEveryStatement(current);
                        current->every.type = Every_Cron;
                        current->every.spec.cron = (yyvsp[0].string);
                 }
#line 6356 "src/y.tab.c"
    break;

  case 642:
#line 2265 "src/p.y"
                                    {
                        _sanityCheckEveryStatement(current);
                        current->every.type = Every_NotInCron;
                        current->every.spec.cron = (yyvsp[0].string);
                 }
#line 6366 "src/y.tab.c"
    break;

  case 643:
#line 2272 "src/p.y"
                              {
                        current->mode = Monitor_Active;
                  }
#line 6374 "src/y.tab.c"
    break;

  case 644:
#line 2275 "src/p.y"
                               {
                        current->mode = Monitor_Passive;
                  }
#line 6382 "src/y.tab.c"
    break;

  case 645:
#line 2278 "src/p.y"
                              {
                        // Deprecated since monit 5.18
                        current->onreboot = Onreboot_Laststate;
                  }
#line 6391 "src/y.tab.c"
    break;

  case 646:
#line 2284 "src/p.y"
                                 {
                        current->onreboot = Onreboot_Start;
                  }
#line 6399 "src/y.tab.c"
    break;

  case 647:
#line 2287 "src/p.y"
                                   {
                        current->onreboot = Onreboot_Nostart;
                        current->monitor = Monitor_Not;
                  }
#line 6408 "src/y.tab.c"
    break;

  case 648:
#line 2291 "src/p.y"
                                     {
                        current->onreboot = Onreboot_Laststate;
                  }
#line 6416 "src/y.tab.c"
    break;

  case 649:
#line 2296 "src/p.y"
                                   {
                        addservicegroup((yyvsp[0].string));
                        FREE((yyvsp[0].string));
                  }
#line 6425 "src/y.tab.c"
    break;

  case 653:
#line 2310 "src/p.y"
                              { adddependant((yyvsp[0].string)); }
#line 6431 "src/y.tab.c"
    break;

  case 654:
#line 2313 "src/p.y"
                                                                                {
                        statusset.initialized = true;
                        statusset.operator = (yyvsp[-5].number);
                        statusset.return_value = (yyvsp[-4].number);
                        addeventaction(&(statusset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addstatus(&statusset);
                   }
#line 6443 "src/y.tab.c"
    break;

  case 655:
#line 2320 "src/p.y"
                                                       {
                        statusset.initialized = false;
                        statusset.operator = Operator_Changed;
                        statusset.return_value = 0;
                        addeventaction(&(statusset).action, (yyvsp[0].number), Action_Ignored);
                        addstatus(&statusset);
                   }
#line 6455 "src/y.tab.c"
    break;

  case 656:
#line 2329 "src/p.y"
                                                                             {
                        addeventaction(&(resourceset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addresource(&resourceset);
                   }
#line 6464 "src/y.tab.c"
    break;

  case 666:
#line 2348 "src/p.y"
                                                                            {
                        addeventaction(&(resourceset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addresource(&resourceset);
                   }
#line 6473 "src/y.tab.c"
    break;

  case 673:
#line 2364 "src/p.y"
                                             {
                        resourceset.resource_id = Resource_CpuPercent;
                        resourceset.operator = (yyvsp[-2].number);
                        resourceset.limit = (yyvsp[-1].real);
                  }
#line 6483 "src/y.tab.c"
    break;

  case 674:
#line 2369 "src/p.y"
                                                  {
                        resourceset.resource_id = Resource_CpuPercentTotal;
                        resourceset.operator = (yyvsp[-2].number);
                        resourceset.limit = (yyvsp[-1].real);
                  }
#line 6493 "src/y.tab.c"
    break;

  case 675:
#line 2376 "src/p.y"
                                                       {
                        resourceset.resource_id = (yyvsp[-3].number);
                        resourceset.operator = (yyvsp[-2].number);
                        resourceset.limit = (yyvsp[-1].real);
                  }
#line 6503 "src/y.tab.c"
    break;

  case 676:
#line 2383 "src/p.y"
                          {
                        if (systeminfo.statisticsAvailable & Statistics_CpuUser)
                                (yyval.number) = Resource_CpuUser;
                        else
                                yywarning2("The CPU user usage statistics is not available on this system\n");
                  }
#line 6514 "src/y.tab.c"
    break;

  case 677:
#line 2389 "src/p.y"
                            {
                        if (systeminfo.statisticsAvailable & Statistics_CpuSystem)
                                (yyval.number) = Resource_CpuSystem;
                        else
                                yywarning2("The CPU system usage statistics is not available on this system\n");
                  }
#line 6525 "src/y.tab.c"
    break;

  case 678:
#line 2395 "src/p.y"
                          {
                        if (systeminfo.statisticsAvailable & Statistics_CpuIOWait)
                                (yyval.number) = Resource_CpuWait;
                        else
                                yywarning2("The CPU I/O wait usage statistics is not available on this system\n");
                  }
#line 6536 "src/y.tab.c"
    break;

  case 679:
#line 2401 "src/p.y"
                          {
                        if (systeminfo.statisticsAvailable & Statistics_CpuNice)
                                (yyval.number) = Resource_CpuNice;
                        else
                                yywarning2("The CPU nice usage statistics is not available on this system\n");
                  }
#line 6547 "src/y.tab.c"
    break;

  case 680:
#line 2407 "src/p.y"
                             {
                        if (systeminfo.statisticsAvailable & Statistics_CpuHardIRQ)
                                (yyval.number) = Resource_CpuHardIRQ;
                        else
                                yywarning2("The CPU hardware IRQ usage statistics is not available on this system\n");
                  }
#line 6558 "src/y.tab.c"
    break;

  case 681:
#line 2413 "src/p.y"
                             {
                        if (systeminfo.statisticsAvailable & Statistics_CpuSoftIRQ)
                                (yyval.number) = Resource_CpuSoftIRQ;
                        else
                                yywarning2("The CPU software IRQ usage statistics is not available on this system\n");
                  }
#line 6569 "src/y.tab.c"
    break;

  case 682:
#line 2419 "src/p.y"
                           {
                        if (systeminfo.statisticsAvailable & Statistics_CpuSteal)
                                (yyval.number) = Resource_CpuSteal;
                        else
                                yywarning2("The CPU steal usage statistics is not available on this system\n");
                  }
#line 6580 "src/y.tab.c"
    break;

  case 683:
#line 2425 "src/p.y"
                           {
                        if (systeminfo.statisticsAvailable & Statistics_CpuGuest)
                                (yyval.number) = Resource_CpuGuest;
                        else
                                yywarning2("The CPU guest usage statistics is not available on this system\n");
                  }
#line 6591 "src/y.tab.c"
    break;

  case 684:
#line 2431 "src/p.y"
                               {
                        if (systeminfo.statisticsAvailable & Statistics_CpuGuestNice)
                                (yyval.number) = Resource_CpuGuestNice;
                        else
                                yywarning2("The CPU guest nice usage statistics is not available on this system\n");
                  }
#line 6602 "src/y.tab.c"
    break;

  case 685:
#line 2437 "src/p.y"
                      {
                        (yyval.number) = Resource_CpuPercent;
                  }
#line 6610 "src/y.tab.c"
    break;

  case 686:
#line 2442 "src/p.y"
                                             {
                        resourceset.resource_id = Resource_MemoryKbyte;
                        resourceset.operator = (yyvsp[-2].number);
                        resourceset.limit = (yyvsp[-1].real) * (yyvsp[0].number);
                  }
#line 6620 "src/y.tab.c"
    break;

  case 687:
#line 2447 "src/p.y"
                                                {
                        resourceset.resource_id = Resource_MemoryPercent;
                        resourceset.operator = (yyvsp[-2].number);
                        resourceset.limit = (yyvsp[-1].real);
                  }
#line 6630 "src/y.tab.c"
    break;

  case 688:
#line 2454 "src/p.y"
                                             {
                        resourceset.resource_id = Resource_MemoryKbyte;
                        resourceset.operator = (yyvsp[-2].number);
                        resourceset.limit = (yyvsp[-1].real) * (yyvsp[0].number);
                  }
#line 6640 "src/y.tab.c"
    break;

  case 689:
#line 2459 "src/p.y"
                                                {
                        resourceset.resource_id = Resource_MemoryPercent;
                        resourceset.operator = (yyvsp[-2].number);
                        resourceset.limit = (yyvsp[-1].real);
                  }
#line 6650 "src/y.tab.c"
    break;

  case 690:
#line 2464 "src/p.y"
                                                  {
                        resourceset.resource_id = Resource_MemoryKbyteTotal;
                        resourceset.operator = (yyvsp[-2].number);
                        resourceset.limit = (yyvsp[-1].real) * (yyvsp[0].number);
                  }
#line 6660 "src/y.tab.c"
    break;

  case 691:
#line 2469 "src/p.y"
                                                      {
                        resourceset.resource_id = Resource_MemoryPercentTotal;
                        resourceset.operator = (yyvsp[-2].number);
                        resourceset.limit = (yyvsp[-1].real);
                  }
#line 6670 "src/y.tab.c"
    break;

  case 692:
#line 2476 "src/p.y"
                                           {
                        resourceset.resource_id = Resource_SwapKbyte;
                        resourceset.operator = (yyvsp[-2].number);
                        resourceset.limit = (yyvsp[-1].real) * (yyvsp[0].number);
                  }
#line 6680 "src/y.tab.c"
    break;

  case 693:
#line 2481 "src/p.y"
                                              {
                        resourceset.resource_id = Resource_SwapPercent;
                        resourceset.operator = (yyvsp[-2].number);
                        resourceset.limit = (yyvsp[-1].real);
                  }
#line 6690 "src/y.tab.c"
    break;

  case 694:
#line 2488 "src/p.y"
                                          {
                        resourceset.resource_id = Resource_Threads;
                        resourceset.operator = (yyvsp[-1].number);
                        resourceset.limit = (yyvsp[0].number);
                  }
#line 6700 "src/y.tab.c"
    break;

  case 695:
#line 2495 "src/p.y"
                                           {
                        resourceset.resource_id = Resource_Children;
                        resourceset.operator = (yyvsp[-1].number);
                        resourceset.limit = (yyvsp[0].number);
                  }
#line 6710 "src/y.tab.c"
    break;

  case 696:
#line 2502 "src/p.y"
                                                                {
                        switch ((yyvsp[-3].number)) {
                                case Resource_LoadAverage1m:
                                        resourceset.resource_id = (yyvsp[-2].number) > 1 ? Resource_LoadAveragePerCore1m : (yyvsp[-3].number);
                                        break;
                                case Resource_LoadAverage5m:
                                        resourceset.resource_id = (yyvsp[-2].number) > 1 ? Resource_LoadAveragePerCore5m : (yyvsp[-3].number);
                                        break;
                                case Resource_LoadAverage15m:
                                        resourceset.resource_id = (yyvsp[-2].number) > 1 ? Resource_LoadAveragePerCore15m : (yyvsp[-3].number);
                                        break;
                                default:
                                        resourceset.resource_id = (yyvsp[-3].number);
                                        break;
                        }
                        resourceset.operator = (yyvsp[-1].number);
                        resourceset.limit = (yyvsp[0].real);
                  }
#line 6733 "src/y.tab.c"
    break;

  case 697:
#line 2522 "src/p.y"
                            { (yyval.number) = Resource_LoadAverage1m; }
#line 6739 "src/y.tab.c"
    break;

  case 698:
#line 2523 "src/p.y"
                            { (yyval.number) = Resource_LoadAverage5m; }
#line 6745 "src/y.tab.c"
    break;

  case 699:
#line 2524 "src/p.y"
                            { (yyval.number) = Resource_LoadAverage15m; }
#line 6751 "src/y.tab.c"
    break;

  case 700:
#line 2527 "src/p.y"
                              { (yyval.number) = 1; }
#line 6757 "src/y.tab.c"
    break;

  case 701:
#line 2528 "src/p.y"
                              { (yyval.number) = systeminfo.cpu.count; }
#line 6763 "src/y.tab.c"
    break;

  case 702:
#line 2532 "src/p.y"
                                                       {
                        resourceset.resource_id = Resource_ReadBytes;
                        resourceset.operator = (yyvsp[-3].number);
                        resourceset.limit = (yyvsp[-2].real) * (yyvsp[-1].number);
                  }
#line 6773 "src/y.tab.c"
    break;

  case 703:
#line 2537 "src/p.y"
                                                            {
                        resourceset.resource_id = Resource_ReadBytesPhysical;
                        resourceset.operator = (yyvsp[-3].number);
                        resourceset.limit = (yyvsp[-2].real) * (yyvsp[-1].number);
                  }
#line 6783 "src/y.tab.c"
    break;

  case 704:
#line 2542 "src/p.y"
                                                      {
                        resourceset.resource_id = Resource_ReadOperations;
                        resourceset.operator = (yyvsp[-2].number);
                        resourceset.limit = (yyvsp[-1].number);
                  }
#line 6793 "src/y.tab.c"
    break;

  case 705:
#line 2549 "src/p.y"
                                                        {
                        resourceset.resource_id = Resource_WriteBytes;
                        resourceset.operator = (yyvsp[-3].number);
                        resourceset.limit = (yyvsp[-2].real) * (yyvsp[-1].number);
                  }
#line 6803 "src/y.tab.c"
    break;

  case 706:
#line 2554 "src/p.y"
                                                             {
                        resourceset.resource_id = Resource_WriteBytesPhysical;
                        resourceset.operator = (yyvsp[-3].number);
                        resourceset.limit = (yyvsp[-2].real) * (yyvsp[-1].number);
                  }
#line 6813 "src/y.tab.c"
    break;

  case 707:
#line 2559 "src/p.y"
                                                       {
                        resourceset.resource_id = Resource_WriteOperations;
                        resourceset.operator = (yyvsp[-2].number);
                        resourceset.limit = (yyvsp[-1].number);
                  }
#line 6823 "src/y.tab.c"
    break;

  case 708:
#line 2566 "src/p.y"
                       { (yyval.real) = (yyvsp[0].real); }
#line 6829 "src/y.tab.c"
    break;

  case 709:
#line 2567 "src/p.y"
                         { (yyval.real) = (float) (yyvsp[0].number); }
#line 6835 "src/y.tab.c"
    break;

  case 710:
#line 2570 "src/p.y"
                        { (yyval.number) = Timestamp_Default; }
#line 6841 "src/y.tab.c"
    break;

  case 711:
#line 2571 "src/p.y"
                        { (yyval.number) = Timestamp_Access; }
#line 6847 "src/y.tab.c"
    break;

  case 712:
#line 2572 "src/p.y"
                        { (yyval.number) = Timestamp_Change; }
#line 6853 "src/y.tab.c"
    break;

  case 713:
#line 2573 "src/p.y"
                        { (yyval.number) = Timestamp_Modification; }
#line 6859 "src/y.tab.c"
    break;

  case 714:
#line 2576 "src/p.y"
                                                                                            {
                        timestampset.type = (yyvsp[-7].number);
                        timestampset.operator = (yyvsp[-6].number);
                        timestampset.time = ((yyvsp[-5].number) * (yyvsp[-4].number));
                        addeventaction(&(timestampset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addtimestamp(&timestampset);
                  }
#line 6871 "src/y.tab.c"
    break;

  case 715:
#line 2583 "src/p.y"
                                                              {
                        timestampset.type = (yyvsp[-3].number);
                        timestampset.test_changes = true;
                        addeventaction(&(timestampset).action, (yyvsp[0].number), Action_Ignored);
                        addtimestamp(&timestampset);
                  }
#line 6882 "src/y.tab.c"
    break;

  case 716:
#line 2591 "src/p.y"
                                 { (yyval.number) = Operator_Equal; }
#line 6888 "src/y.tab.c"
    break;

  case 717:
#line 2592 "src/p.y"
                                 { (yyval.number) = Operator_Greater; }
#line 6894 "src/y.tab.c"
    break;

  case 718:
#line 2593 "src/p.y"
                                 { (yyval.number) = Operator_GreaterOrEqual; }
#line 6900 "src/y.tab.c"
    break;

  case 719:
#line 2594 "src/p.y"
                                 { (yyval.number) = Operator_Less; }
#line 6906 "src/y.tab.c"
    break;

  case 720:
#line 2595 "src/p.y"
                                 { (yyval.number) = Operator_LessOrEqual; }
#line 6912 "src/y.tab.c"
    break;

  case 721:
#line 2596 "src/p.y"
                                 { (yyval.number) = Operator_Equal; }
#line 6918 "src/y.tab.c"
    break;

  case 722:
#line 2597 "src/p.y"
                                 { (yyval.number) = Operator_NotEqual; }
#line 6924 "src/y.tab.c"
    break;

  case 723:
#line 2598 "src/p.y"
                                 { (yyval.number) = Operator_Changed; }
#line 6930 "src/y.tab.c"
    break;

  case 724:
#line 2601 "src/p.y"
                              { (yyval.number) = Time_Second; }
#line 6936 "src/y.tab.c"
    break;

  case 725:
#line 2602 "src/p.y"
                              { (yyval.number) = Time_Second; }
#line 6942 "src/y.tab.c"
    break;

  case 726:
#line 2603 "src/p.y"
                              { (yyval.number) = Time_Minute; }
#line 6948 "src/y.tab.c"
    break;

  case 727:
#line 2604 "src/p.y"
                              { (yyval.number) = Time_Hour; }
#line 6954 "src/y.tab.c"
    break;

  case 728:
#line 2605 "src/p.y"
                              { (yyval.number) = Time_Day; }
#line 6960 "src/y.tab.c"
    break;

  case 729:
#line 2606 "src/p.y"
                              { (yyval.number) = Time_Month; }
#line 6966 "src/y.tab.c"
    break;

  case 730:
#line 2609 "src/p.y"
                              { (yyval.number) = Time_Minute; }
#line 6972 "src/y.tab.c"
    break;

  case 731:
#line 2610 "src/p.y"
                              { (yyval.number) = Time_Hour; }
#line 6978 "src/y.tab.c"
    break;

  case 732:
#line 2611 "src/p.y"
                              { (yyval.number) = Time_Day; }
#line 6984 "src/y.tab.c"
    break;

  case 733:
#line 2613 "src/p.y"
                              { (yyval.number) = Time_Second; }
#line 6990 "src/y.tab.c"
    break;

  case 734:
#line 2614 "src/p.y"
                              { (yyval.number) = Time_Second; }
#line 6996 "src/y.tab.c"
    break;

  case 735:
#line 2616 "src/p.y"
                              {
                        repeat = 0;
                  }
#line 7004 "src/y.tab.c"
    break;

  case 736:
#line 2619 "src/p.y"
                                     {
                        repeat = 1;
                  }
#line 7012 "src/y.tab.c"
    break;

  case 737:
#line 2622 "src/p.y"
                                            {
                        if ((yyvsp[-1].number) < 0) {
                                yyerror2("The number of repeat cycles must be greater or equal to 0");
                        }
                        repeat = (yyvsp[-1].number);
                  }
#line 7023 "src/y.tab.c"
    break;

  case 738:
#line 2630 "src/p.y"
                        {
                        (yyval.number) = Action_Alert;
                  }
#line 7031 "src/y.tab.c"
    break;

  case 739:
#line 2633 "src/p.y"
                                           {
                        (yyval.number) = Action_Exec;
                  }
#line 7039 "src/y.tab.c"
    break;

  case 740:
#line 2637 "src/p.y"
                  {
                        (yyval.number) = Action_Exec;
                  }
#line 7047 "src/y.tab.c"
    break;

  case 741:
#line 2640 "src/p.y"
                          {
                        (yyval.number) = Action_Restart;
                  }
#line 7055 "src/y.tab.c"
    break;

  case 742:
#line 2643 "src/p.y"
                        {
                        (yyval.number) = Action_Start;
                  }
#line 7063 "src/y.tab.c"
    break;

  case 743:
#line 2646 "src/p.y"
                       {
                        (yyval.number) = Action_Stop;
                  }
#line 7071 "src/y.tab.c"
    break;

  case 744:
#line 2649 "src/p.y"
                            {
                        (yyval.number) = Action_Unmonitor;
                  }
#line 7079 "src/y.tab.c"
    break;

  case 745:
#line 2654 "src/p.y"
                         {
                        (yyval.number) = (yyvsp[0].number);
                        if ((yyvsp[0].number) == Action_Exec && command) {
                                repeat1 = repeat;
                                repeat = 0;
                                command1 = command;
                                command = NULL;
                        }
                  }
#line 7093 "src/y.tab.c"
    break;

  case 746:
#line 2665 "src/p.y"
                         {
                        (yyval.number) = (yyvsp[0].number);
                        if ((yyvsp[0].number) == Action_Exec && command) {
                                repeat2 = repeat;
                                repeat = 0;
                                command2 = command;
                                command = NULL;
                        }
                  }
#line 7107 "src/y.tab.c"
    break;

  case 747:
#line 2676 "src/p.y"
                               {
                        if ((yyvsp[-1].number) < 1 || (unsigned long)(yyvsp[-1].number) > BITMAP_MAX) {
                                yyerror2("The number of cycles must be between 1 and %zu", BITMAP_MAX);
                        } else {
                                rate.count  = (yyvsp[-1].number);
                                rate.cycles = (yyvsp[-1].number);
                        }
                  }
#line 7120 "src/y.tab.c"
    break;

  case 748:
#line 2686 "src/p.y"
                                      {
                        if ((yyvsp[-1].number) < 1 || (unsigned long)(yyvsp[-1].number) > BITMAP_MAX) {
                                yyerror2("The number of cycles must be between 1 and %zu", BITMAP_MAX);
                        } else if ((yyvsp[-2].number) < 1 || (yyvsp[-2].number) > (yyvsp[-1].number)) {
                                yyerror2("The number of events must be between 1 and less then poll cycles");
                        } else {
                                rate.count  = (yyvsp[-2].number);
                                rate.cycles = (yyvsp[-1].number);
                        }
                  }
#line 7135 "src/y.tab.c"
    break;

  case 750:
#line 2699 "src/p.y"
                              {
                        rate1.count = rate.count;
                        rate1.cycles = rate.cycles;
                        reset_rateset(&rate);
                  }
#line 7145 "src/y.tab.c"
    break;

  case 751:
#line 2704 "src/p.y"
                               {
                        rate1.count = rate.count;
                        rate1.cycles = rate.cycles;
                        reset_rateset(&rate);
                }
#line 7155 "src/y.tab.c"
    break;

  case 753:
#line 2712 "src/p.y"
                              {
                        rate2.count = rate.count;
                        rate2.cycles = rate.cycles;
                        reset_rateset(&rate);
                  }
#line 7165 "src/y.tab.c"
    break;

  case 754:
#line 2717 "src/p.y"
                               {
                        rate2.count = rate.count;
                        rate2.cycles = rate.cycles;
                        reset_rateset(&rate);
                }
#line 7175 "src/y.tab.c"
    break;

  case 755:
#line 2724 "src/p.y"
                               {
                        (yyval.number) = Action_Alert;
                  }
#line 7183 "src/y.tab.c"
    break;

  case 756:
#line 2727 "src/p.y"
                               {
                        (yyval.number) = (yyvsp[0].number);
                  }
#line 7191 "src/y.tab.c"
    break;

  case 757:
#line 2730 "src/p.y"
                                                       {
                        (yyval.number) = (yyvsp[0].number);
                  }
#line 7199 "src/y.tab.c"
    break;

  case 758:
#line 2733 "src/p.y"
                                                    {
                        (yyval.number) = (yyvsp[0].number);
                  }
#line 7207 "src/y.tab.c"
    break;

  case 759:
#line 2736 "src/p.y"
                                                       {
                        (yyval.number) = (yyvsp[0].number);
                  }
#line 7215 "src/y.tab.c"
    break;

  case 760:
#line 2741 "src/p.y"
                               {
                        (yyval.number) = Action_Alert;
                  }
#line 7223 "src/y.tab.c"
    break;

  case 761:
#line 2744 "src/p.y"
                               {
                        (yyval.number) = (yyvsp[0].number);
                  }
#line 7231 "src/y.tab.c"
    break;

  case 762:
#line 2747 "src/p.y"
                                                    {
                        (yyval.number) = (yyvsp[0].number);
                  }
#line 7239 "src/y.tab.c"
    break;

  case 763:
#line 2752 "src/p.y"
                                                                                  {
                        addeventaction(&(checksumset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addchecksum(&checksumset);
                  }
#line 7248 "src/y.tab.c"
    break;

  case 764:
#line 2757 "src/p.y"
                                   {
                        snprintf(checksumset.hash, sizeof(checksumset.hash), "%s", (yyvsp[-4].string));
                        FREE((yyvsp[-4].string));
                        addeventaction(&(checksumset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addchecksum(&checksumset);
                  }
#line 7259 "src/y.tab.c"
    break;

  case 765:
#line 2763 "src/p.y"
                                                                  {
                        checksumset.test_changes = true;
                        addeventaction(&(checksumset).action, (yyvsp[0].number), Action_Ignored);
                        addchecksum(&checksumset);
                  }
#line 7269 "src/y.tab.c"
    break;

  case 766:
#line 2769 "src/p.y"
                              { checksumset.type = Hash_Unknown; }
#line 7275 "src/y.tab.c"
    break;

  case 767:
#line 2770 "src/p.y"
                              { checksumset.type = Hash_Md5; }
#line 7281 "src/y.tab.c"
    break;

  case 768:
#line 2771 "src/p.y"
                              { checksumset.type = Hash_Sha1; }
#line 7287 "src/y.tab.c"
    break;

  case 769:
#line 2774 "src/p.y"
                                                                               {
                        filesystemset.resource = Resource_Inode;
                        filesystemset.operator = (yyvsp[-5].number);
                        filesystemset.limit_absolute = (yyvsp[-4].number);
                        addeventaction(&(filesystemset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addfilesystem(&filesystemset);
                  }
#line 7299 "src/y.tab.c"
    break;

  case 770:
#line 2781 "src/p.y"
                                                                                      {
                        filesystemset.resource = Resource_Inode;
                        filesystemset.operator = (yyvsp[-6].number);
                        filesystemset.limit_percent = (yyvsp[-5].real);
                        addeventaction(&(filesystemset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addfilesystem(&filesystemset);
                  }
#line 7311 "src/y.tab.c"
    break;

  case 771:
#line 2788 "src/p.y"
                                                                                     {
                        filesystemset.resource = Resource_InodeFree;
                        filesystemset.operator = (yyvsp[-5].number);
                        filesystemset.limit_absolute = (yyvsp[-4].number);
                        addeventaction(&(filesystemset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addfilesystem(&filesystemset);
                  }
#line 7323 "src/y.tab.c"
    break;

  case 772:
#line 2795 "src/p.y"
                                                                                            {
                        filesystemset.resource = Resource_InodeFree;
                        filesystemset.operator = (yyvsp[-6].number);
                        filesystemset.limit_percent = (yyvsp[-5].real);
                        addeventaction(&(filesystemset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addfilesystem(&filesystemset);
                  }
#line 7335 "src/y.tab.c"
    break;

  case 773:
#line 2804 "src/p.y"
                                                                                   {
                        filesystemset.resource = Resource_Space;
                        filesystemset.operator = (yyvsp[-6].number);
                        filesystemset.limit_absolute = (yyvsp[-5].real) * (yyvsp[-4].number);
                        addeventaction(&(filesystemset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addfilesystem(&filesystemset);
                  }
#line 7347 "src/y.tab.c"
    break;

  case 774:
#line 2811 "src/p.y"
                                                                                      {
                        filesystemset.resource = Resource_Space;
                        filesystemset.operator = (yyvsp[-6].number);
                        filesystemset.limit_percent = (yyvsp[-5].real);
                        addeventaction(&(filesystemset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addfilesystem(&filesystemset);
                  }
#line 7359 "src/y.tab.c"
    break;

  case 775:
#line 2818 "src/p.y"
                                                                                         {
                        filesystemset.resource = Resource_SpaceFree;
                        filesystemset.operator = (yyvsp[-6].number);
                        filesystemset.limit_absolute = (yyvsp[-5].real) * (yyvsp[-4].number);
                        addeventaction(&(filesystemset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addfilesystem(&filesystemset);
                  }
#line 7371 "src/y.tab.c"
    break;

  case 776:
#line 2825 "src/p.y"
                                                                                            {
                        filesystemset.resource = Resource_SpaceFree;
                        filesystemset.operator = (yyvsp[-6].number);
                        filesystemset.limit_percent = (yyvsp[-5].real);
                        addeventaction(&(filesystemset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addfilesystem(&filesystemset);
                  }
#line 7383 "src/y.tab.c"
    break;

  case 777:
#line 2834 "src/p.y"
                                                                                              {
                        filesystemset.resource = Resource_ReadBytes;
                        filesystemset.operator = (yyvsp[-7].number);
                        filesystemset.limit_absolute = (yyvsp[-6].real) * (yyvsp[-5].number);
                        addeventaction(&(filesystemset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addfilesystem(&filesystemset);
                  }
#line 7395 "src/y.tab.c"
    break;

  case 778:
#line 2841 "src/p.y"
                                                                                        {
                        filesystemset.resource = Resource_ReadOperations;
                        filesystemset.operator = (yyvsp[-6].number);
                        filesystemset.limit_absolute = (yyvsp[-5].number);
                        addeventaction(&(filesystemset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addfilesystem(&filesystemset);
                  }
#line 7407 "src/y.tab.c"
    break;

  case 779:
#line 2850 "src/p.y"
                                                                                               {
                        filesystemset.resource = Resource_WriteBytes;
                        filesystemset.operator = (yyvsp[-7].number);
                        filesystemset.limit_absolute = (yyvsp[-6].real) * (yyvsp[-5].number);
                        addeventaction(&(filesystemset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addfilesystem(&filesystemset);
                  }
#line 7419 "src/y.tab.c"
    break;

  case 780:
#line 2857 "src/p.y"
                                                                                         {
                        filesystemset.resource = Resource_WriteOperations;
                        filesystemset.operator = (yyvsp[-6].number);
                        filesystemset.limit_absolute = (yyvsp[-5].number);
                        addeventaction(&(filesystemset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addfilesystem(&filesystemset);
                  }
#line 7431 "src/y.tab.c"
    break;

  case 781:
#line 2866 "src/p.y"
                                                                                                 {
                        filesystemset.resource = Resource_ServiceTime;
                        filesystemset.operator = (yyvsp[-6].number);
                        filesystemset.limit_absolute = (yyvsp[-5].number);
                        addeventaction(&(filesystemset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addfilesystem(&filesystemset);
                  }
#line 7443 "src/y.tab.c"
    break;

  case 782:
#line 2873 "src/p.y"
                                                                                           {
                        filesystemset.resource = Resource_ServiceTime;
                        filesystemset.operator = (yyvsp[-6].number);
                        filesystemset.limit_absolute = (yyvsp[-5].real) * 1000;
                        addeventaction(&(filesystemset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addfilesystem(&filesystemset);
                  }
#line 7455 "src/y.tab.c"
    break;

  case 783:
#line 2882 "src/p.y"
                                                       {
                        addeventaction(&(fsflagset).action, (yyvsp[0].number), Action_Ignored);
                        addfsflag(&fsflagset);
                  }
#line 7464 "src/y.tab.c"
    break;

  case 784:
#line 2888 "src/p.y"
                               { (yyval.number) = Unit_Byte; }
#line 7470 "src/y.tab.c"
    break;

  case 785:
#line 2889 "src/p.y"
                               { (yyval.number) = Unit_Byte; }
#line 7476 "src/y.tab.c"
    break;

  case 786:
#line 2890 "src/p.y"
                               { (yyval.number) = Unit_Kilobyte; }
#line 7482 "src/y.tab.c"
    break;

  case 787:
#line 2891 "src/p.y"
                               { (yyval.number) = Unit_Megabyte; }
#line 7488 "src/y.tab.c"
    break;

  case 788:
#line 2892 "src/p.y"
                               { (yyval.number) = Unit_Gigabyte; }
#line 7494 "src/y.tab.c"
    break;

  case 789:
#line 2895 "src/p.y"
                                                                                  {
                        permset.perm = check_perm((yyvsp[-4].number));
                        addeventaction(&(permset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addperm(&permset);
                  }
#line 7504 "src/y.tab.c"
    break;

  case 790:
#line 2900 "src/p.y"
                                                                            {
                        permset.test_changes = true;
                        addeventaction(&(permset).action, (yyvsp[-1].number), Action_Ignored);
                        addperm(&permset);
                  }
#line 7514 "src/y.tab.c"
    break;

  case 791:
#line 2907 "src/p.y"
                                                                   {
                        matchset.not = (yyvsp[-4].number) == Operator_Equal ? false : true;
                        matchset.ignore = false;
                        matchset.match_path = NULL;
                        matchset.match_string = (yyvsp[-3].string);
                        addmatch(&matchset, (yyvsp[0].number), 0);
                  }
#line 7526 "src/y.tab.c"
    break;

  case 792:
#line 2916 "src/p.y"
                                                                 {
                        matchset.not = (yyvsp[-4].number) == Operator_Equal ? false : true;
                        matchset.ignore = false;
                        matchset.match_path = (yyvsp[-3].string);
                        matchset.match_string = NULL;
                        addmatchpath(&matchset, (yyvsp[0].number));
                        FREE((yyvsp[-3].string));
                  }
#line 7539 "src/y.tab.c"
    break;

  case 793:
#line 2924 "src/p.y"
                                                                   {
                        matchset.not = (yyvsp[-4].number) == Operator_Equal ? false : true;
                        matchset.ignore = false;
                        matchset.match_path = NULL;
                        matchset.match_string = (yyvsp[-3].string);
                        addmatch(&matchset, (yyvsp[0].number), 0);
                  }
#line 7551 "src/y.tab.c"
    break;

  case 794:
#line 2931 "src/p.y"
                                                  {
                        matchset.not = (yyvsp[-1].number) == Operator_Equal ? false : true;
                        matchset.ignore = true;
                        matchset.match_path = (yyvsp[0].string);
                        matchset.match_string = NULL;
                        addmatchpath(&matchset, Action_Ignored);
                        FREE((yyvsp[0].string));
                  }
#line 7564 "src/y.tab.c"
    break;

  case 795:
#line 2939 "src/p.y"
                                                    {
                        matchset.not = (yyvsp[-1].number) == Operator_Equal ? false : true;
                        matchset.ignore = true;
                        matchset.match_path = NULL;
                        matchset.match_string = (yyvsp[0].string);
                        addmatch(&matchset, Action_Ignored, 0);
                  }
#line 7576 "src/y.tab.c"
    break;

  case 796:
#line 2947 "src/p.y"
                                                                {
                        matchset.ignore = false;
                        matchset.match_path = (yyvsp[-3].string);
                        matchset.match_string = NULL;
                        addmatchpath(&matchset, (yyvsp[0].number));
                        FREE((yyvsp[-3].string));
                  }
#line 7588 "src/y.tab.c"
    break;

  case 797:
#line 2954 "src/p.y"
                                                                  {
                        matchset.ignore = false;
                        matchset.match_path = NULL;
                        matchset.match_string = (yyvsp[-3].string);
                        addmatch(&matchset, (yyvsp[0].number), 0);
                  }
#line 7599 "src/y.tab.c"
    break;

  case 798:
#line 2960 "src/p.y"
                                                 {
                        matchset.ignore = true;
                        matchset.match_path = (yyvsp[0].string);
                        matchset.match_string = NULL;
                        addmatchpath(&matchset, Action_Ignored);
                        FREE((yyvsp[0].string));
                  }
#line 7611 "src/y.tab.c"
    break;

  case 799:
#line 2967 "src/p.y"
                                                   {
                        matchset.ignore = true;
                        matchset.match_path = NULL;
                        matchset.match_string = (yyvsp[0].string);
                        addmatch(&matchset, Action_Ignored, 0);
                  }
#line 7622 "src/y.tab.c"
    break;

  case 800:
#line 2975 "src/p.y"
                              {
                        matchset.not = false;
                  }
#line 7630 "src/y.tab.c"
    break;

  case 801:
#line 2978 "src/p.y"
                      {
                        matchset.not = true;
                  }
#line 7638 "src/y.tab.c"
    break;

  case 802:
#line 2984 "src/p.y"
                                                                                   {
                        sizeset.operator = (yyvsp[-6].number);
                        sizeset.size = ((unsigned long long)(yyvsp[-5].number) * (yyvsp[-4].number));
                        addeventaction(&(sizeset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addsize(&sizeset);
                  }
#line 7649 "src/y.tab.c"
    break;

  case 803:
#line 2990 "src/p.y"
                                                     {
                        sizeset.test_changes = true;
                        addeventaction(&(sizeset).action, (yyvsp[0].number), Action_Ignored);
                        addsize(&sizeset);
                  }
#line 7659 "src/y.tab.c"
    break;

  case 804:
#line 2997 "src/p.y"
                                                                           {
                        uidset.uid = get_uid((yyvsp[-4].string), 0);
                        addeventaction(&(uidset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        current->uid = adduid(&uidset);
                        FREE((yyvsp[-4].string));
                  }
#line 7670 "src/y.tab.c"
    break;

  case 805:
#line 3003 "src/p.y"
                                                                           {
                    uidset.uid = get_uid(NULL, (yyvsp[-4].number));
                    addeventaction(&(uidset).action, (yyvsp[-1].number), (yyvsp[0].number));
                    current->uid = adduid(&uidset);
                  }
#line 7680 "src/y.tab.c"
    break;

  case 806:
#line 3010 "src/p.y"
                                                                            {
                        uidset.uid = get_uid((yyvsp[-4].string), 0);
                        addeventaction(&(uidset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        current->euid = adduid(&uidset);
                        FREE((yyvsp[-4].string));
                  }
#line 7691 "src/y.tab.c"
    break;

  case 807:
#line 3016 "src/p.y"
                                                                            {
                        uidset.uid = get_uid(NULL, (yyvsp[-4].number));
                        addeventaction(&(uidset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        current->euid = adduid(&uidset);
                  }
#line 7701 "src/y.tab.c"
    break;

  case 808:
#line 3023 "src/p.y"
                                                                                          {
                        addsecurityattribute((yyvsp[-4].string), (yyvsp[-1].number), (yyvsp[0].number));
                  }
#line 7709 "src/y.tab.c"
    break;

  case 809:
#line 3026 "src/p.y"
                                                                                        {
                        addsecurityattribute((yyvsp[-4].string), (yyvsp[-1].number), (yyvsp[0].number));
                  }
#line 7717 "src/y.tab.c"
    break;

  case 810:
#line 3031 "src/p.y"
                                                                                               {
                        if (systeminfo.statisticsAvailable & Statistics_FiledescriptorsPerSystem)
                                addfiledescriptors((yyvsp[-5].number), false, (long long)(yyvsp[-4].number), -1., (yyvsp[-1].number), (yyvsp[0].number));
                        else
                                yywarning("The per-system filedescriptors statistics is not available on this system\n");
                  }
#line 7728 "src/y.tab.c"
    break;

  case 811:
#line 3037 "src/p.y"
                                                                                                {
                        if (systeminfo.statisticsAvailable & Statistics_FiledescriptorsPerSystem)
                                addfiledescriptors((yyvsp[-6].number), false, -1LL, (yyvsp[-5].real), (yyvsp[-1].number), (yyvsp[0].number));
                        else
                                yywarning("The per-system filedescriptors statistics is not available on this system\n");
                  }
#line 7739 "src/y.tab.c"
    break;

  case 812:
#line 3045 "src/p.y"
                                                                                                {
                        if (systeminfo.statisticsAvailable & Statistics_FiledescriptorsPerProcess)
                                addfiledescriptors((yyvsp[-5].number), false, (long long)(yyvsp[-4].number), -1., (yyvsp[-1].number), (yyvsp[0].number));
                        else
                                yywarning("The per-process filedescriptors statistics is not available on this system\n");
                  }
#line 7750 "src/y.tab.c"
    break;

  case 813:
#line 3051 "src/p.y"
                                                                                                {
                        if (systeminfo.statisticsAvailable & Statistics_FiledescriptorsPerProcessMax)
                                addfiledescriptors((yyvsp[-6].number), false, -1LL, (yyvsp[-5].real), (yyvsp[-1].number), (yyvsp[0].number));
                        else
                                yywarning("The per-process filedescriptors maximum is not exposed on this system, so we cannot compute usage %%, please use the test with absolute value\n");
                  }
#line 7761 "src/y.tab.c"
    break;

  case 814:
#line 3059 "src/p.y"
                                                                                                           {
                        if (systeminfo.statisticsAvailable & Statistics_FiledescriptorsPerProcess)
                                addfiledescriptors((yyvsp[-5].number), true, (long long)(yyvsp[-4].number), -1., (yyvsp[-1].number), (yyvsp[0].number));
                        else
                                yywarning("The per-process filedescriptors statistics is not available on this system\n");
                  }
#line 7772 "src/y.tab.c"
    break;

  case 815:
#line 3067 "src/p.y"
                                                                           {
                        gidset.gid = get_gid((yyvsp[-4].string), 0);
                        addeventaction(&(gidset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        current->gid = addgid(&gidset);
                        FREE((yyvsp[-4].string));
                  }
#line 7783 "src/y.tab.c"
    break;

  case 816:
#line 3073 "src/p.y"
                                                                           {
                        gidset.gid = get_gid(NULL, (yyvsp[-4].number));
                        addeventaction(&(gidset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        current->gid = addgid(&gidset);
                  }
#line 7793 "src/y.tab.c"
    break;

  case 817:
#line 3080 "src/p.y"
                                                                  { /* Deprecated */
                        addeventaction(&(linkstatusset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addlinkstatus(current, &linkstatusset);
                  }
#line 7802 "src/y.tab.c"
    break;

  case 818:
#line 3084 "src/p.y"
                                                                {
                        linkstatusset.check_invers = false;
                        addeventaction(&(linkstatusset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addlinkstatus(current, &linkstatusset);
                  }
#line 7812 "src/y.tab.c"
    break;

  case 819:
#line 3089 "src/p.y"
                                                              {
                        linkstatusset.check_invers = true;
                        addeventaction(&(linkstatusset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addlinkstatus(current, &linkstatusset);
                  }
#line 7822 "src/y.tab.c"
    break;

  case 820:
#line 3096 "src/p.y"
                                                                   {
                        addeventaction(&(linkspeedset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addlinkspeed(current, &linkspeedset);
                  }
#line 7831 "src/y.tab.c"
    break;

  case 821:
#line 3101 "src/p.y"
                                                                                           {
                        linksaturationset.operator = (yyvsp[-6].number);
                        linksaturationset.limit = (unsigned long long)(yyvsp[-5].number);
                        addeventaction(&(linksaturationset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addlinksaturation(current, &linksaturationset);
                  }
#line 7842 "src/y.tab.c"
    break;

  case 822:
#line 3109 "src/p.y"
                                                                                                 {
                        bandwidthset.operator = (yyvsp[-7].number);
                        bandwidthset.limit = ((unsigned long long)(yyvsp[-6].number) * (yyvsp[-5].number));
                        bandwidthset.rangecount = 1;
                        bandwidthset.range = (yyvsp[-4].number);
                        addeventaction(&(bandwidthset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addbandwidth(&(current->uploadbyteslist), &bandwidthset);
                  }
#line 7855 "src/y.tab.c"
    break;

  case 823:
#line 3117 "src/p.y"
                                                                                                     {
                        bandwidthset.operator = (yyvsp[-7].number);
                        bandwidthset.limit = ((unsigned long long)(yyvsp[-6].number) * (yyvsp[-5].number));
                        bandwidthset.rangecount = 1;
                        bandwidthset.range = (yyvsp[-4].number);
                        addeventaction(&(bandwidthset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addbandwidth(&(current->uploadbyteslist), &bandwidthset);
                  }
#line 7868 "src/y.tab.c"
    break;

  case 824:
#line 3125 "src/p.y"
                                                                                                            {
                        bandwidthset.operator = (yyvsp[-8].number);
                        bandwidthset.limit = ((unsigned long long)(yyvsp[-7].number) * (yyvsp[-6].number));
                        bandwidthset.rangecount = (yyvsp[-5].number);
                        bandwidthset.range = (yyvsp[-4].number);
                        addeventaction(&(bandwidthset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addbandwidth(&(current->uploadbyteslist), &bandwidthset);
                  }
#line 7881 "src/y.tab.c"
    break;

  case 825:
#line 3133 "src/p.y"
                                                                                                   {
                        bandwidthset.operator = (yyvsp[-7].number);
                        bandwidthset.limit = (unsigned long long)(yyvsp[-6].number);
                        bandwidthset.rangecount = 1;
                        bandwidthset.range = (yyvsp[-4].number);
                        addeventaction(&(bandwidthset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addbandwidth(&(current->uploadpacketslist), &bandwidthset);
                  }
#line 7894 "src/y.tab.c"
    break;

  case 826:
#line 3141 "src/p.y"
                                                                                                       {
                        bandwidthset.operator = (yyvsp[-7].number);
                        bandwidthset.limit = (unsigned long long)(yyvsp[-6].number);
                        bandwidthset.rangecount = 1;
                        bandwidthset.range = (yyvsp[-4].number);
                        addeventaction(&(bandwidthset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addbandwidth(&(current->uploadpacketslist), &bandwidthset);
                  }
#line 7907 "src/y.tab.c"
    break;

  case 827:
#line 3149 "src/p.y"
                                                                                                              {
                        bandwidthset.operator = (yyvsp[-8].number);
                        bandwidthset.limit = (unsigned long long)(yyvsp[-7].number);
                        bandwidthset.rangecount = (yyvsp[-5].number);
                        bandwidthset.range = (yyvsp[-4].number);
                        addeventaction(&(bandwidthset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addbandwidth(&(current->uploadpacketslist), &bandwidthset);
                  }
#line 7920 "src/y.tab.c"
    break;

  case 828:
#line 3159 "src/p.y"
                                                                                                   {
                        bandwidthset.operator = (yyvsp[-7].number);
                        bandwidthset.limit = ((unsigned long long)(yyvsp[-6].number) * (yyvsp[-5].number));
                        bandwidthset.rangecount = 1;
                        bandwidthset.range = (yyvsp[-4].number);
                        addeventaction(&(bandwidthset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addbandwidth(&(current->downloadbyteslist), &bandwidthset);
                  }
#line 7933 "src/y.tab.c"
    break;

  case 829:
#line 3167 "src/p.y"
                                                                                                       {
                        bandwidthset.operator = (yyvsp[-7].number);
                        bandwidthset.limit = ((unsigned long long)(yyvsp[-6].number) * (yyvsp[-5].number));
                        bandwidthset.rangecount = 1;
                        bandwidthset.range = (yyvsp[-4].number);
                        addeventaction(&(bandwidthset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addbandwidth(&(current->downloadbyteslist), &bandwidthset);
                  }
#line 7946 "src/y.tab.c"
    break;

  case 830:
#line 3175 "src/p.y"
                                                                                                              {
                        bandwidthset.operator = (yyvsp[-8].number);
                        bandwidthset.limit = ((unsigned long long)(yyvsp[-7].number) * (yyvsp[-6].number));
                        bandwidthset.rangecount = (yyvsp[-5].number);
                        bandwidthset.range = (yyvsp[-4].number);
                        addeventaction(&(bandwidthset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addbandwidth(&(current->downloadbyteslist), &bandwidthset);
                  }
#line 7959 "src/y.tab.c"
    break;

  case 831:
#line 3183 "src/p.y"
                                                                                                     {
                        bandwidthset.operator = (yyvsp[-7].number);
                        bandwidthset.limit = (unsigned long long)(yyvsp[-6].number);
                        bandwidthset.rangecount = 1;
                        bandwidthset.range = (yyvsp[-4].number);
                        addeventaction(&(bandwidthset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addbandwidth(&(current->downloadpacketslist), &bandwidthset);
                  }
#line 7972 "src/y.tab.c"
    break;

  case 832:
#line 3191 "src/p.y"
                                                                                                         {
                        bandwidthset.operator = (yyvsp[-7].number);
                        bandwidthset.limit = (unsigned long long)(yyvsp[-6].number);
                        bandwidthset.rangecount = 1;
                        bandwidthset.range = (yyvsp[-4].number);
                        addeventaction(&(bandwidthset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addbandwidth(&(current->downloadpacketslist), &bandwidthset);
                  }
#line 7985 "src/y.tab.c"
    break;

  case 833:
#line 3199 "src/p.y"
                                                                                                                {
                        bandwidthset.operator = (yyvsp[-8].number);
                        bandwidthset.limit = (unsigned long long)(yyvsp[-7].number);
                        bandwidthset.rangecount = (yyvsp[-5].number);
                        bandwidthset.range = (yyvsp[-4].number);
                        addeventaction(&(bandwidthset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addbandwidth(&(current->downloadpacketslist), &bandwidthset);
                  }
#line 7998 "src/y.tab.c"
    break;

  case 834:
#line 3209 "src/p.y"
                                { (yyval.number) = ICMP_ECHO; }
#line 8004 "src/y.tab.c"
    break;

  case 835:
#line 3212 "src/p.y"
                                        { mailset.reminder = 0; }
#line 8010 "src/y.tab.c"
    break;

  case 836:
#line 3213 "src/p.y"
                                        { mailset.reminder = (yyvsp[0].number); }
#line 8016 "src/y.tab.c"
    break;

  case 837:
#line 3214 "src/p.y"
                                        { mailset.reminder = (yyvsp[-1].number); }
#line 8022 "src/y.tab.c"
    break;


#line 8026 "src/y.tab.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYEMPTY : YYTRANSLATE (yychar);

  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (YY_("syntax error"));
#else
# define YYSYNTAX_ERROR yysyntax_error (&yymsg_alloc, &yymsg, \
                                        yyssp, yytoken)
      {
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = YYSYNTAX_ERROR;
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == 1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = YY_CAST (char *, YYSTACK_ALLOC (YY_CAST (YYSIZE_T, yymsg_alloc)));
            if (!yymsg)
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = 2;
              }
            else
              {
                yysyntax_error_status = YYSYNTAX_ERROR;
                yymsgp = yymsg;
              }
          }
        yyerror (yymsgp);
        if (yysyntax_error_status == 2)
          goto yyexhaustedlab;
      }
# undef YYSYNTAX_ERROR
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYTERROR;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  yystos[yystate], yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;


#if !defined yyoverflow || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif


/*-----------------------------------------------------.
| yyreturn -- parsing is finished, return the result.  |
`-----------------------------------------------------*/
yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  yystos[+*yyssp], yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  return yyresult;
}
#line 3217 "src/p.y"



/* -------------------------------------------------------- Parser interface */


/**
 * Syntactic error routine
 *
 * This routine is automatically called by the lexer!
 */
void yyerror(const char *s, ...) {
        ASSERT(s);
        char *msg = NULL;
        va_list ap;
        va_start(ap, s);
        msg = Str_vcat(s, ap);
        va_end(ap);
        Log_error("%s:%i: %s '%s'\n", currentfile, lineno, msg, yytext);
        cfg_errflag++;
        FREE(msg);
}


/**
 * Syntactical warning routine
 */
void yywarning(const char *s, ...) {
        ASSERT(s);
        char *msg = NULL;
        va_list ap;
        va_start(ap, s);
        msg = Str_vcat(s, ap);
        va_end(ap);
        Log_warning("%s:%i: %s '%s'\n", currentfile, lineno, msg, yytext);
        FREE(msg);
}


/**
 * Argument error routine
 */
void yyerror2(const char *s, ...) {
        ASSERT(s);
        char *msg = NULL;
        va_list ap;
        va_start(ap, s);
        msg = Str_vcat(s, ap);
        va_end(ap);
        Log_error("%s:%i: %s '%s'\n", argcurrentfile, arglineno, msg, argyytext);
        cfg_errflag++;
        FREE(msg);
}


/**
 * Argument warning routine
 */
void yywarning2(const char *s, ...) {
        ASSERT(s);
        char *msg = NULL;
        va_list ap;
        va_start(ap, s);
        msg = Str_vcat(s, ap);
        va_end(ap);
        Log_warning("%s:%i: %s '%s'\n", argcurrentfile, arglineno, msg, argyytext);
        FREE(msg);
}


/*
 * The Parser hook - start parsing the control file
 * Returns true if parsing succeeded, otherwise false
 */
bool parse(char *controlfile) {
        ASSERT(controlfile);

        if ((yyin = fopen(controlfile,"r")) == (FILE *)NULL) {
                Log_error("Cannot open the control file '%s' -- %s\n", controlfile, STRERROR);
                return false;
        }

        currentfile = Str_dup(controlfile);

        available_statistics(&systeminfo);

        /*
         * Creation of the global service list is synchronized
         */
        LOCK(Run.mutex)
        {
                preparse();
                yyparse();
                fclose(yyin);
                postparse();
        }
        END_LOCK;

        FREE(currentfile);

        if (argyytext != NULL)
                FREE(argyytext);

        /*
         * Secure check the monitrc file. The run control file must have the
         * same uid as the REAL uid of this process, it must have permissions
         * no greater than 700 and it must not be a symbolic link.
         */
        if (! file_checkStat(controlfile, "control file", S_IRUSR|S_IWUSR|S_IXUSR))
                return false;

        return cfg_errflag == 0;
}


/* ----------------------------------------------------------------- Private */


/**
 * Initialize objects used by the parser.
 */
static void preparse() {
        servicelist = tail = current = NULL;
        /* Set instance incarnation ID */
        time(&Run.incarnation);
        /* Reset lexer */
        buffer_stack_ptr            = 0;
        lineno                      = 1;
        arglineno                   = 1;
        argcurrentfile              = NULL;
        argyytext                   = NULL;
        /* Reset parser */
        Run.limits.sendExpectBuffer  = LIMIT_SENDEXPECTBUFFER;
        Run.limits.fileContentBuffer = LIMIT_FILECONTENTBUFFER;
        Run.limits.httpContentBuffer = LIMIT_HTTPCONTENTBUFFER;
        Run.limits.programOutput     = LIMIT_PROGRAMOUTPUT;
        Run.limits.networkTimeout    = LIMIT_NETWORKTIMEOUT;
        Run.limits.programTimeout    = LIMIT_PROGRAMTIMEOUT;
        Run.limits.stopTimeout       = LIMIT_STOPTIMEOUT;
        Run.limits.startTimeout      = LIMIT_STARTTIMEOUT;
        Run.limits.restartTimeout    = LIMIT_RESTARTTIMEOUT;
        Run.onreboot                 = Onreboot_Start;
        Run.mmonitcredentials        = NULL;
        Run.httpd.flags              = Httpd_Disabled | Httpd_Signature;
        Run.httpd.credentials        = NULL;
        memset(&(Run.httpd.socket), 0, sizeof(Run.httpd.socket));
        Run.mailserver_timeout       = SMTP_TIMEOUT;
        Run.eventlist_dir            = NULL;
        Run.eventlist_slots          = -1;
        Run.system                   = NULL;
        Run.mmonits                  = NULL;
        Run.maillist                 = NULL;
        Run.mailservers              = NULL;
        Run.MailFormat.from          = NULL;
        Run.MailFormat.replyto       = NULL;
        Run.MailFormat.subject       = NULL;
        Run.MailFormat.message       = NULL;
        depend_list                  = NULL;
        Run.flags |= Run_HandlerInit | Run_MmonitCredentials;
        for (int i = 0; i <= Handler_Max; i++)
                Run.handler_queue[i] = 0;

        /*
         * Initialize objects
         */
        reset_uidset();
        reset_gidset();
        reset_statusset();
        reset_sizeset();
        reset_mailset();
        reset_sslset();
        reset_mailserverset();
        reset_mmonitset();
        reset_responsetimeset();
        reset_portset();
        reset_permset();
        reset_icmpset();
        reset_linkstatusset();
        reset_linkspeedset();
        reset_linksaturationset();
        reset_bandwidthset();
        reset_rateset(&rate);
        reset_rateset(&rate1);
        reset_rateset(&rate2);
        reset_filesystemset();
        reset_resourceset();
        reset_checksumset();
        reset_timestampset();
        reset_actionrateset();
}


/*
 * Check that values are reasonable after parsing
 */
static void postparse() {
        if (cfg_errflag)
                return;

        /* If defined - add the last service to the service list */
        if (current) {
                addservice(current);
                current = NULL;
        }

        /* Check that we do not start monit in daemon mode without having a poll time */
        if (! Run.polltime && ((Run.flags & Run_Daemon) || (Run.flags & Run_Foreground))) {
                Log_error("Poll time is invalid or not defined. Please define poll time in the control file\nas a number (> 0)  or use the -d option when starting monit\n");
                cfg_errflag++;
        }

        if (Run.files.log)
                Run.flags |= Run_Log;

        /* Add the default general system service if not specified explicitly: service name default to hostname */
        if (! Run.system) {
                char hostname[STRLEN];
                if (gethostname(hostname, sizeof(hostname))) {
                        Log_error("Cannot get system hostname -- please add 'check system <name>'\n");
                        cfg_errflag++;
                }
                if (Util_existService(hostname)) {
                        Log_error("'check system' not defined in control file, failed to add automatic configuration (service name %s is used already) -- please add 'check system <name>' manually\n", hostname);
                        cfg_errflag++;
                }
                Run.system = createservice(Service_System, Str_dup(hostname), NULL, check_system);
                addservice(Run.system);
        }
        addeventaction(&(Run.system->action_MONIT_START), Action_Start, Action_Ignored);
        addeventaction(&(Run.system->action_MONIT_STOP), Action_Stop,  Action_Ignored);

        if (Run.mmonits) {
                if (Run.httpd.flags & Httpd_Net) {
                        if (Run.flags & Run_MmonitCredentials) {
                                Auth_T c;
                                for (c = Run.httpd.credentials; c; c = c->next) {
                                        if (c->digesttype == Digest_Cleartext && ! c->is_readonly) {
                                                Run.mmonitcredentials = c;
                                                break;
                                        }
                                }
                                if (! Run.mmonitcredentials)
                                        Log_warning("M/Monit registration with credentials enabled, but no suitable credentials found in monit configuration file -- please add 'allow user:password' option to 'set httpd' statement\n");
                        }
                } else if (Run.httpd.flags & Httpd_Unix) {
                        Log_warning("M/Monit enabled but Monit httpd is using unix socket -- please change 'set httpd' statement to use TCP port in order to be able to manage services on Monit\n");
                } else {
                        Log_warning("M/Monit enabled but no httpd allowed -- please add 'set httpd' statement\n");
                }
        }

        /* Check the sanity of any dependency graph */
        check_depend();

#if defined HAVE_OPENSSL && defined OPENSSL_FIPS
        Ssl_setFipsMode(Run.flags & Run_FipsEnabled);
#endif

        Processor_setHttpPostLimit();
}


static bool _parseOutgoingAddress(char *ip, Outgoing_T *outgoing) {
        struct addrinfo *result, hints = {.ai_flags = AI_NUMERICHOST};
        int status = getaddrinfo(ip, NULL, &hints, &result);
        if (status == 0) {
                outgoing->ip = ip;
                outgoing->addrlen = result->ai_addrlen;
                memcpy(&(outgoing->addr), result->ai_addr, result->ai_addrlen);
                freeaddrinfo(result);
                return true;
        } else {
                yyerror2("IP address parsing failed for %s -- %s", ip, status == EAI_SYSTEM ? STRERROR : gai_strerror(status));
        }
        return false;
}


/*
 * Create a new service object and add any current objects to the
 * service list.
 */
static Service_T createservice(Service_Type type, char *name, char *value, State_Type (*check)(Service_T s)) {
        ASSERT(name);

        check_name(name);

        if (current)
                addservice(current);

        NEW(current);
        current->type = type;
        switch (type) {
                case Service_Directory:
                        NEW(current->inf.directory);
                        break;
                case Service_Fifo:
                        NEW(current->inf.fifo);
                        break;
                case Service_File:
                        NEW(current->inf.file);
                        break;
                case Service_Filesystem:
                        NEW(current->inf.filesystem);
                        break;
                case Service_Net:
                        NEW(current->inf.net);
                        break;
                case Service_Process:
                        NEW(current->inf.process);
                        break;
                default:
                        break;
        }
        Util_resetInfo(current);

        if (type == Service_Program) {
                NEW(current->program);
                current->program->args = command;
                command = NULL;
                current->program->timeout = Run.limits.programTimeout;
        }

        /* Set default values */
        current->onrebootRestored = false;
        current->mode     = Monitor_Active;
        current->monitor  = Monitor_Init;
        current->onreboot = Run.onreboot;
        current->name     = name;
        current->name_urlescaped = Util_urlEncode(name, false);
        current->name_htmlescaped = escapeHTML(StringBuffer_create(16), name);
        current->check    = check;
        current->path     = value;

        /* Initialize general event handlers */
        addeventaction(&(current)->action_DATA,     Action_Alert,     Action_Alert);
        addeventaction(&(current)->action_EXEC,     Action_Alert,     Action_Alert);
        addeventaction(&(current)->action_INVALID,  Action_Restart,   Action_Alert);

        /* Initialize internal event handlers */
        addeventaction(&(current)->action_ACTION,       Action_Alert, Action_Ignored);

        gettimeofday(&current->collected, NULL);

        return current;
}


/*
 * Add a service object to the servicelist
 */
static void addservice(Service_T s) {
        ASSERT(s);

        // Test sanity check
        switch (s->type) {
                case Service_Host:
                        // Verify that a remote service has a port or an icmp list
                        if (! s->portlist && ! s->icmplist) {
                                Log_error("'check host' statement is incomplete: Please specify a port number to test\n or an icmp test at the remote host: '%s'\n", s->name);
                                cfg_errflag++;
                        }
                        break;
                case Service_Program:
                        // Verify that a program test has a status test
                        if (! s->statuslist && ! s->matchlist) {
                                Log_error("'check program %s' is incomplete: Please add a 'status' or 'content' test\n", s->name);
                                cfg_errflag++;
                        }
                        char program[PATH_MAX];
                        strncpy(program, s->program->args->arg[0], sizeof(program) - 1);
                        // Require that the program exist before creating the Command object
                        if (File_isExecutable(program)) {
                                s->program->C = Command_new(program, NULL);
                                for (int i = 1; i < s->program->args->length; i++) {
                                        Command_appendArgument(s->program->C, s->program->args->arg[i]);
                                        snprintf(program + strlen(program), sizeof(program) - strlen(program) - 1, " %s", s->program->args->arg[i]);
                                }
                                s->path = Str_dup(program);
                                if (s->program->args->has_uid)
                                        Command_setUid(s->program->C, s->program->args->uid);
                                if (s->program->args->has_gid)
                                        Command_setGid(s->program->C, s->program->args->gid);
                                // Set environment
                                Command_setEnv(s->program->C, "MONIT_SERVICE", s->name);
                        } else {
                                Log_error("A 'check program' statement requires the program to exist '%s'\n", program);
                                cfg_errflag++;
                        }
                        break;
                case Service_Net:
                        if (! s->linkstatuslist) {
                                // Add link status test if not defined
                                addeventaction(&(linkstatusset).action, Action_Alert, Action_Alert);
                                addlinkstatus(s, &linkstatusset);
                        }
                        break;
                case Service_Filesystem:
                        if (! s->nonexistlist && ! s->existlist) {
                                // Add non-existence test if not defined
                                addeventaction(&(nonexistset).action, Action_Restart, Action_Alert);
                                addnonexist(&nonexistset);
                        }
                        if (! s->fsflaglist) {
                                // Add filesystem flags change test if not defined
                                addeventaction(&(fsflagset).action, Action_Alert, Action_Ignored);
                                addfsflag(&fsflagset);
                        }
                        break;
                case Service_Directory:
                case Service_Fifo:
                case Service_File:
                case Service_Process:
                        if (! s->nonexistlist && ! s->existlist) {
                                // Add existence test if not defined
                                addeventaction(&(nonexistset).action, Action_Restart, Action_Alert);
                                addnonexist(&nonexistset);
                        }
                        break;
                default:
                        break;
        }

        // No "every" statement was used, monitor each cycle
        if (s->every.type == Every_Initializing)
                s->every.type = Every_Cycle;

        /* Add the service to the end of the service list */
        if (tail != NULL) {
                tail->next = s;
                tail->next_conf = s;
        } else {
                servicelist = s;
                servicelist_conf = s;
        }
        tail = s;
}


/*
 * Add entry to service group list
 */
static void addservicegroup(char *name) {
        ServiceGroup_T g;

        ASSERT(name);

        /* Check if service group with the same name is defined already */
        for (g = servicegrouplist; g; g = g->next)
                if (IS(g->name, name))
                        break;

        if (! g) {
                NEW(g);
                g->name = Str_dup(name);
                g->members = List_new();
                g->next = servicegrouplist;
                servicegrouplist = g;
        }

        List_append(g->members, current);
}


/*
 * Add a dependant entry to the current service dependant list
 */
static void adddependant(char *dependant) {
        Dependant_T d;

        ASSERT(dependant);

        NEW(d);

        if (current->dependantlist)
                d->next = current->dependantlist;

        d->dependant = dependant;
        d->dependant_urlescaped = Util_urlEncode(dependant, false);
        d->dependant_htmlescaped = escapeHTML(StringBuffer_create(16), dependant);
        current->dependantlist = d;

}


/*
 * Add the given mailaddress with the appropriate alert notification
 * values and mail attributes to the given mailinglist.
 */
static void addmail(char *mailto, Mail_T f, Mail_T *l) {
        Mail_T m;

        ASSERT(mailto);

        NEW(m);
        m->to       = mailto;
        m->from     = f->from;
        m->replyto  = f->replyto;
        m->subject  = f->subject;
        m->message  = f->message;
        m->events   = f->events;
        m->reminder = f->reminder;

        m->next = *l;
        *l = m;

        reset_mailset();
}


/*
 * Add the given portset to the current service's portlist
 */
static void addport(Port_T *list, Port_T port) {
        ASSERT(port);

        if (port->protocol->check == check_radius && port->type != Socket_Udp)
                yyerror("Radius protocol test supports UDP only");

        Port_T p;
        NEW(p);
        p->is_available       = Connection_Init;
        p->check_invers       = port->check_invers;
        p->type               = port->type;
        p->socket             = port->socket;
        p->family             = port->family;
        p->action             = port->action;
        p->timeout            = port->timeout;
        p->retry              = port->retry;
        p->protocol           = port->protocol;
        p->hostname           = port->hostname;
        p->url_request        = port->url_request;
        p->outgoing           = port->outgoing;

        if (p->family == Socket_Unix) {
                p->target.unix.pathname = port->target.unix.pathname;
        } else {
                p->target.net.port = port->target.net.port;
                if (sslset.flags) {
#ifdef HAVE_OPENSSL
                        p->target.net.ssl.certificate.minimumDays = port->target.net.ssl.certificate.minimumDays;
                        if (sslset.flags && (p->target.net.port == 25 || p->target.net.port == 143 || p->target.net.port == 587))
                                sslset.flags = SSL_StartTLS;
                        _setSSLOptions(&(p->target.net.ssl.options));
#else
                        yyerror("SSL check cannot be activated -- Monit was not built with SSL support");
#endif
                }
        }
        memcpy(&p->parameters, &port->parameters, sizeof(port->parameters));

        if (p->protocol->check == check_http) {
                if (p->parameters.http.checksum) {
                        cleanup_hash_string(p->parameters.http.checksum);
                        if (strlen(p->parameters.http.checksum) == 32)
                                p->parameters.http.hashtype = Hash_Md5;
                        else if (strlen(p->parameters.http.checksum) == 40)
                                p->parameters.http.hashtype = Hash_Sha1;
                        else
                                yyerror2("invalid checksum [%s]", p->parameters.http.checksum);
                } else {
                        p->parameters.http.hashtype = Hash_Unknown;
                }
                if (! p->parameters.http.method) {
                        p->parameters.http.method = Http_Get;
                } else if (p->parameters.http.method == Http_Head) {
                        // Sanity check: if content or checksum test is used, the method Http_Head is not allowed, as we need the content
                        if ((p->url_request && p->url_request->regex) || p->parameters.http.checksum) {
                                yyerror2("if response content or checksum test is enabled, the HEAD method is not allowed");
                        }
                }
        } else if (p->protocol->check == check_mysql) {
                if (p->parameters.mysql.rsaChecksum) {
                        if (! p->parameters.mysql.username)
                                yyerror2("the rsakey checksum test requires credentials to be defined");
                        if (p->target.net.ssl.options.flags != SSL_Disabled)
                                yyerror2("the rsakey checksum test can be used just with unsecured mysql protocol");
                }
        }

        p->responsetime.limit    = responsetimeset.limit;
        p->responsetime.current  = responsetimeset.current;
        p->responsetime.operator = responsetimeset.operator;

        p->next = *list;
        *list = p;

        reset_sslset();
        reset_responsetimeset();
        reset_portset();

}


static void addhttpheader(Port_T port, char *header) {
        if (! port->parameters.http.headers) {
                port->parameters.http.headers = List_new();
        }
        if (Str_startsWith(header, "Connection:") && ! Str_sub(header, "close")) {
                yywarning("We don't recommend setting the Connection header. Monit will always close the connection even if 'keep-alive' is set\n");
        }
        List_append(port->parameters.http.headers, header);
}


/*
 * Add a new resource object to the current service resource list
 */
static void addresource(Resource_T rr) {
        ASSERT(rr);
        if (Run.flags & Run_ProcessEngineEnabled) {
                Resource_T r;
                NEW(r);
                r->resource_id = rr->resource_id;
                r->limit       = rr->limit;
                r->action      = rr->action;
                r->operator    = rr->operator;
                r->next        = current->resourcelist;
                current->resourcelist = r;
        } else {
                yywarning("Cannot activate service check. The process status engine was disabled. On certain systems you must run monit as root to utilize this feature)\n");
        }
        reset_resourceset();
}


/*
 * Add a new file object to the current service timestamp list
 */
static void addtimestamp(Timestamp_T ts) {
        ASSERT(ts);

        Timestamp_T t;
        NEW(t);
        t->type         = ts->type;
        t->operator     = ts->operator;
        t->time         = ts->time;
        t->action       = ts->action;
        t->test_changes = ts->test_changes;

        t->next = current->timestamplist;
        current->timestamplist = t;

        reset_timestampset();
}


/*
 * Add a new object to the current service actionrate list
 */
static void addactionrate(ActionRate_T ar) {
        ActionRate_T a;

        ASSERT(ar);

        if (ar->count > ar->cycle)
                yyerror2("The number of restarts must be less than poll cycles");
        if (ar->count <= 0 || ar->cycle <= 0)
                yyerror2("Zero or negative values not allowed in a action rate statement");

        NEW(a);
        a->count  = ar->count;
        a->cycle  = ar->cycle;
        a->action = ar->action;

        a->next = current->actionratelist;
        current->actionratelist = a;

        reset_actionrateset();
}



/*
 * Add a new Size object to the current service size list
 */
static void addsize(Size_T ss) {
        Size_T s;
        struct stat buf;

        ASSERT(ss);

        NEW(s);
        s->operator     = ss->operator;
        s->size         = ss->size;
        s->action       = ss->action;
        s->test_changes = ss->test_changes;
        /* Get the initial size for future comparison, if the file exists */
        if (s->test_changes) {
                s->initialized = ! stat(current->path, &buf);
                if (s->initialized)
                        s->size = (unsigned long long)buf.st_size;
        }

        s->next = current->sizelist;
        current->sizelist = s;

        reset_sizeset();
}


/*
 * Add a new Uptime object to the current service uptime list
 */
static void adduptime(Uptime_T uu) {
        Uptime_T u;

        ASSERT(uu);

        NEW(u);
        u->operator = uu->operator;
        u->uptime = uu->uptime;
        u->action = uu->action;

        u->next = current->uptimelist;
        current->uptimelist = u;

        reset_uptimeset();
}


/*
 * Add a new Pid object to the current service pid list
 */
static void addpid(Pid_T pp) {
        ASSERT(pp);

        Pid_T p;
        NEW(p);
        p->action = pp->action;

        p->next = current->pidlist;
        current->pidlist = p;

        reset_pidset();
}


/*
 * Add a new PPid object to the current service ppid list
 */
static void addppid(Pid_T pp) {
        ASSERT(pp);

        Pid_T p;
        NEW(p);
        p->action = pp->action;

        p->next = current->ppidlist;
        current->ppidlist = p;

        reset_ppidset();
}


/*
 * Add a new Fsflag object to the current service fsflag list
 */
static void addfsflag(FsFlag_T ff) {
        ASSERT(ff);

        FsFlag_T f;
        NEW(f);
        f->action = ff->action;

        f->next = current->fsflaglist;
        current->fsflaglist = f;

        reset_fsflagset();
}


/*
 * Add a new Nonexist object to the current service list
 */
static void addnonexist(NonExist_T ff) {
        ASSERT(ff);

        NonExist_T f;
        NEW(f);
        f->action = ff->action;

        f->next = current->nonexistlist;
        current->nonexistlist = f;

        reset_nonexistset();
}


static void addexist(Exist_T rule) {
        ASSERT(rule);
        Exist_T r;
        NEW(r);
        r->action = rule->action;
        r->next = current->existlist;
        current->existlist = r;
        reset_existset();
}


/*
 * Set Checksum object in the current service
 */
static void addchecksum(Checksum_T cs) {
        ASSERT(cs);

        cs->initialized = true;

        if (STR_UNDEF(cs->hash)) {
                if (cs->type == Hash_Unknown)
                        cs->type = Hash_Default;
                if (! (Checksum_getChecksum(current->path, cs->type, cs->hash, sizeof(cs->hash)))) {
                        /* If the file doesn't exist, set dummy value */
                        snprintf(cs->hash, sizeof(cs->hash), cs->type == Hash_Md5 ? "00000000000000000000000000000000" : "0000000000000000000000000000000000000000");
                        cs->initialized = false;
                        yywarning2("Cannot compute a checksum for file %s", current->path);
                }
        }

        int len = cleanup_hash_string(cs->hash);
        if (cs->type == Hash_Unknown) {
                if (len == 32) {
                        cs->type = Hash_Md5;
                } else if (len == 40) {
                        cs->type = Hash_Sha1;
                } else {
                        yyerror2("Unknown checksum type [%s] for file %s", cs->hash, current->path);
                        reset_checksumset();
                        return;
                }
        } else if ((cs->type == Hash_Md5 && len != 32) || (cs->type == Hash_Sha1 && len != 40)) {
                yyerror2("Invalid checksum [%s] for file %s", cs->hash, current->path);
                reset_checksumset();
                return;
        }

        Checksum_T c;
        NEW(c);
        c->type         = cs->type;
        c->test_changes = cs->test_changes;
        c->initialized  = cs->initialized;
        c->action       = cs->action;
        snprintf(c->hash, sizeof(c->hash), "%s", cs->hash);

        current->checksum = c;

        reset_checksumset();

}


/*
 * Set Perm object in the current service
 */
static void addperm(Perm_T ps) {
        ASSERT(ps);

        Perm_T p;
        NEW(p);
        p->action = ps->action;
        p->test_changes = ps->test_changes;
        if (p->test_changes) {
                if (! File_exist(current->path))
                        DEBUG("The path '%s' used in the PERMISSION statement refer to a non-existing object\n", current->path);
                else if ((p->perm = File_mod(current->path)) < 0)
                        yyerror2("Cannot get the timestamp for '%s'", current->path);
                else
                        p->perm &= 07777;
        } else {
                p->perm = ps->perm;
        }
        current->perm = p;
        reset_permset();
}


static void addlinkstatus(Service_T s, LinkStatus_T L) {
        ASSERT(L);

        LinkStatus_T l;

        // Sanity check: we don't support link up/down tests mix
        for (l = s->linkstatuslist; l; l = l->next) {
                if (l->check_invers != L->check_invers)
                        yyerror2("Mixing link up and down tests is not supported");
        }
                        
        if (L->check_invers)
                s->inverseStatus = true;

        NEW(l);
        l->check_invers = L->check_invers;
        l->action = L->action;

        l->next = s->linkstatuslist;
        s->linkstatuslist = l;

        reset_linkstatusset();
}


static void addlinkspeed(Service_T s, LinkSpeed_T L) {
        ASSERT(L);

        LinkSpeed_T l;
        NEW(l);
        l->action = L->action;

        l->next = s->linkspeedlist;
        s->linkspeedlist = l;

        reset_linkspeedset();
}


static void addlinksaturation(Service_T s, LinkSaturation_T L) {
        ASSERT(L);

        LinkSaturation_T l;
        NEW(l);
        l->operator = L->operator;
        l->limit = L->limit;
        l->action = L->action;

        l->next = s->linksaturationlist;
        s->linksaturationlist = l;

        reset_linksaturationset();
}


/*
 * Return Bandwidth object
 */
static void addbandwidth(Bandwidth_T *list, Bandwidth_T b) {
        ASSERT(list);
        ASSERT(b);

        if (b->rangecount * b->range > 24 * Time_Hour) {
                yyerror2("Maximum range for total test is 24 hours");
        } else if (b->range == Time_Minute && b->rangecount > 60) {
                yyerror2("Maximum value for [minute(s)] unit is 60");
        } else if (b->range == Time_Hour && b->rangecount > 24) {
                yyerror2("Maximum value for [hour(s)] unit is 24");
        } else if (b->range == Time_Day && b->rangecount > 1) {
                yyerror2("Maximum value for [day(s)] unit is 1");
        } else {
                if (b->range == Time_Day) {
                        // translate last day -> last 24 hours
                        b->rangecount = 24;
                        b->range = Time_Hour;
                }
                Bandwidth_T bandwidth;
                NEW(bandwidth);
                bandwidth->operator = b->operator;
                bandwidth->limit = b->limit;
                bandwidth->rangecount = b->rangecount;
                bandwidth->range = b->range;
                bandwidth->action = b->action;
                bandwidth->next = *list;
                *list = bandwidth;
        }
        reset_bandwidthset();
}


static void appendmatch(Match_T *list, Match_T item) {
        if (*list) {
                /* Find the end of the list (keep the same patterns order as in the config file) */
                Match_T last;
                for (last = *list; last->next; last = last->next)
                        ;
                last->next = item;
        } else {
                *list = item;
        }
}


/*
 * Set Match object in the current service
 */
static void addmatch(Match_T ms, int actionnumber, int linenumber) {
        Match_T m;

        ASSERT(ms);

        NEW(m);
        NEW(m->regex_comp);

        m->match_string = ms->match_string;
        m->match_path   = ms->match_path ? Str_dup(ms->match_path) : NULL;
        m->action       = ms->action;
        m->not          = ms->not;
        m->ignore       = ms->ignore;
        m->next         = NULL;

        addeventaction(&(m->action), actionnumber, Action_Ignored);

        int reg_return = regcomp(m->regex_comp, ms->match_string, REG_NOSUB|REG_EXTENDED);

        if (reg_return != 0) {
                char errbuf[STRLEN];
                regerror(reg_return, ms->regex_comp, errbuf, STRLEN);
                if (m->match_path != NULL)
                        yyerror2("Regex parsing error: %s on line %i of", errbuf, linenumber);
                else
                        yyerror2("Regex parsing error: %s", errbuf);
        }
        appendmatch(m->ignore ? &current->matchignorelist : &current->matchlist, m);
}


static void addmatchpath(Match_T ms, Action_Type actionnumber) {
        ASSERT(ms->match_path);

        FILE *handle = fopen(ms->match_path, "r");
        if (handle == NULL) {
                yyerror2("Cannot read regex match file (%s)", ms->match_path);
                return;
        }

        // The addeventaction() called from addmatch() will reset the command1 to NULL, but we need to duplicate the command for each line, thus need to save it here
        command_t savecommand = command1;
        for (int linenumber = 1; ! feof(handle); linenumber++) {
                char buf[2048];

                if (! fgets(buf, sizeof(buf), handle))
                        continue;

                size_t len = strlen(buf);

                if (len == 0 || buf[0] == '\n')
                        continue;

                if (buf[len - 1] == '\n')
                        buf[len - 1] = 0;

                ms->match_string = Str_dup(buf);

                if (actionnumber == Action_Exec) {
                        if (command1 == NULL) {
                                ASSERT(savecommand);
                                command1 = copycommand(savecommand);
                        }
                }

                addmatch(ms, actionnumber, linenumber);
        }
        if (actionnumber == Action_Exec && savecommand)
                gccmd(&savecommand);

        fclose(handle);
}


/*
 * Set exit status test object in the current service
 */
static void addstatus(Status_T status) {
        Status_T s;
        ASSERT(status);
        NEW(s);
        s->initialized = status->initialized;
        s->return_value = status->return_value;
        s->operator = status->operator;
        s->action = status->action;
        s->next = current->statuslist;
        current->statuslist = s;

        reset_statusset();
}


/*
 * Set Uid object in the current service
 */
static Uid_T adduid(Uid_T u) {
        ASSERT(u);

        Uid_T uid;
        NEW(uid);
        uid->uid = u->uid;
        uid->action = u->action;
        reset_uidset();
        return uid;
}


/*
 * Set Gid object in the current service
 */
static Gid_T addgid(Gid_T g) {
        ASSERT(g);

        Gid_T gid;
        NEW(gid);
        gid->gid = g->gid;
        gid->action = g->action;
        reset_gidset();
        return gid;
}


/*
 * Add a new filesystem to the current service's filesystem list
 */
static void addfilesystem(FileSystem_T ds) {
        FileSystem_T dev;

        ASSERT(ds);

        NEW(dev);
        dev->resource           = ds->resource;
        dev->operator           = ds->operator;
        dev->limit_absolute     = ds->limit_absolute;
        dev->limit_percent      = ds->limit_percent;
        dev->action             = ds->action;

        dev->next               = current->filesystemlist;
        current->filesystemlist = dev;

        reset_filesystemset();

}


/*
 * Add a new icmp object to the current service's icmp list
 */
static void addicmp(Icmp_T is) {
        Icmp_T icmp;

        ASSERT(is);

        NEW(icmp);
        icmp->family        = is->family;
        icmp->type          = is->type;
        icmp->size          = is->size;
        icmp->count         = is->count;
        icmp->timeout       = is->timeout;
        icmp->action        = is->action;
        icmp->outgoing      = is->outgoing;
        icmp->check_invers  = is->check_invers;
        icmp->is_available  = Connection_Init;

        icmp->responsetime.limit    = responsetimeset.limit;
        icmp->responsetime.current  = responsetimeset.current;
        icmp->responsetime.operator = responsetimeset.operator;

        icmp->next          = current->icmplist;
        current->icmplist   = icmp;

        reset_responsetimeset();
        reset_icmpset();
}


/*
 * Set EventAction object
 */
static void addeventaction(EventAction_T *_ea, Action_Type failed, Action_Type succeeded) {
        EventAction_T ea;

        ASSERT(_ea);

        NEW(ea);
        NEW(ea->failed);
        NEW(ea->succeeded);

        ea->failed->id = failed;
        ea->failed->repeat = repeat1;
        ea->failed->count = rate1.count;
        ea->failed->cycles = rate1.cycles;
        if (failed == Action_Exec) {
                ASSERT(command1);
                ea->failed->exec = command1;
                command1 = NULL;
        }

        ea->succeeded->id = succeeded;
        ea->succeeded->repeat = repeat2;
        ea->succeeded->count = rate2.count;
        ea->succeeded->cycles = rate2.cycles;
        if (succeeded == Action_Exec) {
                ASSERT(command2);
                ea->succeeded->exec = command2;
                command2 = NULL;
        }
        *_ea = ea;
        reset_rateset(&rate);
        reset_rateset(&rate1);
        reset_rateset(&rate2);
        repeat = repeat1 = repeat2 = 0;
}


/*
 * Add a generic protocol handler to
 */
static void addgeneric(Port_T port, char *send, char *expect) {
        Generic_T g = port->parameters.generic.sendexpect;
        if (! g) {
                NEW(g);
                port->parameters.generic.sendexpect = g;
        } else {
                while (g->next)
                        g = g->next;
                NEW(g->next);
                g = g->next;
        }
        if (send) {
                g->send = send;
                g->expect = NULL;
        } else if (expect) {
                int reg_return;
                NEW(g->expect);
                reg_return = regcomp(g->expect, expect, REG_NOSUB|REG_EXTENDED);
                FREE(expect);
                if (reg_return != 0) {
                        char errbuf[STRLEN];
                        regerror(reg_return, g->expect, errbuf, STRLEN);
                        yyerror2("Regex parsing error: %s", errbuf);
                }
                g->send = NULL;
        }
}


/*
 * Add the current command object to the current service object's
 * start or stop program.
 */
static void addcommand(int what, unsigned int timeout) {

        switch (what) {
                case START:   current->start = command; break;
                case STOP:    current->stop = command; break;
                case RESTART: current->restart = command; break;
        }

        command->timeout = timeout;

        command = NULL;

}


/*
 * Add a new argument to the argument list
 */
static void addargument(char *argument) {

        ASSERT(argument);

        if (! command) {
                check_exec(argument);
                NEW(command);
        }

        command->arg[command->length++] = argument;
        command->arg[command->length] = NULL;

        if (command->length >= ARGMAX)
                yyerror("Exceeded maximum number of program arguments");

}


/*
 * Setup a url request for the current port object
 */
static void prepare_urlrequest(URL_T U) {

        ASSERT(U);

        /* Only the HTTP protocol is supported for URLs currently. See also the lexer if this is to be changed in the future */
        portset.protocol = Protocol_get(Protocol_HTTP);

        if (urlrequest == NULL)
                NEW(urlrequest);
        urlrequest->url = U;
        portset.hostname = Str_dup(U->hostname);
        portset.target.net.port = U->port;
        portset.url_request = urlrequest;
        portset.type = Socket_Tcp;
        portset.parameters.http.request = Str_cat("%s%s%s", U->path, U->query ? "?" : "", U->query ? U->query : "");
        if (IS(U->protocol, "https"))
                sslset.flags = SSL_Enabled;
}


/*
 * Set the url request for a port
 */
static void  seturlrequest(int operator, char *regex) {

        ASSERT(regex);

        if (! urlrequest)
                NEW(urlrequest);
        urlrequest->operator = operator;
        int reg_return;
        NEW(urlrequest->regex);
        reg_return = regcomp(urlrequest->regex, regex, REG_NOSUB|REG_EXTENDED);
        if (reg_return != 0) {
                char errbuf[STRLEN];
                regerror(reg_return, urlrequest->regex, errbuf, STRLEN);
                yyerror2("Regex parsing error: %s", errbuf);
        }
}


/*
 * Add a new data recipient server to the mmonit server list
 */
static void addmmonit(Mmonit_T mmonit) {
        ASSERT(mmonit->url);

        Mmonit_T c;
        NEW(c);
        c->url = mmonit->url;
        c->compress = MmonitCompress_Init;
        _setSSLOptions(&(c->ssl));
        if (IS(c->url->protocol, "https")) {
#ifdef HAVE_OPENSSL
                c->ssl.flags = SSL_Enabled;
#else
                yyerror("SSL check cannot be activated -- SSL disabled");
#endif
        }
        c->timeout = mmonit->timeout;
        c->next = NULL;

        if (Run.mmonits) {
                Mmonit_T C;
                for (C = Run.mmonits; C->next; C = C->next)
                        /* Empty */ ;
                C->next = c;
        } else {
                Run.mmonits = c;
        }
        reset_sslset();
        reset_mmonitset();
}


/*
 * Add a new smtp server to the mail server list
 */
static void addmailserver(MailServer_T mailserver) {

        MailServer_T s;

        ASSERT(mailserver->host);

        NEW(s);
        s->host        = mailserver->host;
        s->port        = mailserver->port;
        s->username    = mailserver->username;
        s->password    = mailserver->password;

        if (sslset.flags && (mailserver->port == 25 || mailserver->port == 587))
                sslset.flags = SSL_StartTLS;
        _setSSLOptions(&(s->ssl));

        s->next = NULL;

        if (Run.mailservers) {
                MailServer_T l;
                for (l = Run.mailservers; l->next; l = l->next)
                        /* empty */;
                l->next = s;
        } else {
                Run.mailservers = s;
        }
        reset_mailserverset();
}


/*
 * Return uid if found on the system. If the parameter user is NULL
 * the uid parameter is used for looking up the user id on the system,
 * otherwise the user parameter is used.
 */
static uid_t get_uid(char *user, uid_t uid) {
        char buf[4096];
        struct passwd pwd, *result = NULL;
        if (user) {
                if (getpwnam_r(user, &pwd, buf, sizeof(buf), &result) != 0 || ! result) {
                        yyerror2("Requested user not found on the system");
                        return(0);
                }
        } else {
                if (getpwuid_r(uid, &pwd, buf, sizeof(buf), &result) != 0 || ! result) {
                        yyerror2("Requested uid not found on the system");
                        return(0);
                }
        }
        return(pwd.pw_uid);
}


/*
 * Return gid if found on the system. If the parameter group is NULL
 * the gid parameter is used for looking up the group id on the system,
 * otherwise the group parameter is used.
 */
static gid_t get_gid(char *group, gid_t gid) {
        struct group *grd;

        if (group) {
                grd = getgrnam(group);

                if (! grd) {
                        yyerror2("Requested group not found on the system");
                        return(0);
                }

        } else {

                if (! (grd = getgrgid(gid))) {
                        yyerror2("Requested gid not found on the system");
                        return(0);
                }

        }

        return(grd->gr_gid);

}


/*
 * Add a new user id to the current command object.
 */
static void addeuid(uid_t uid) {
        if (! getuid()) {
                command->has_uid = true;
                command->uid = uid;
        } else {
                yyerror("UID statement requires root privileges");
        }
}


/*
 * Add a new group id to the current command object.
 */
static void addegid(gid_t gid) {
        if (! getuid()) {
                command->has_gid = true;
                command->gid = gid;
        } else {
                yyerror("GID statement requires root privileges");
        }
}


/*
 * Reset the logfile if changed
 */
static void setlogfile(char *logfile) {
        if (Run.files.log) {
                if (IS(Run.files.log, logfile)) {
                        FREE(logfile);
                        return;
                } else {
                        FREE(Run.files.log);
                }
        }
        Run.files.log = logfile;
}


/*
 * Reset the pidfile if changed
 */
static void setpidfile(char *pidfile) {
        if (Run.files.pid) {
                if (IS(Run.files.pid, pidfile)) {
                        FREE(pidfile);
                        return;
                } else {
                        FREE(Run.files.pid);
                }
        }
        Run.files.pid = pidfile;
}


/*
 * Read a apache htpasswd file and add credentials found for username
 */
static void addhtpasswdentry(char *filename, char *username, Digest_Type dtype) {
        char *ht_username = NULL;
        char *ht_passwd = NULL;
        char buf[STRLEN];
        FILE *handle = NULL;
        int credentials_added = 0;

        ASSERT(filename);

        handle = fopen(filename, "r");

        if (handle == NULL) {
                if (username != NULL)
                        yyerror2("Cannot read htpasswd (%s) for user %s", filename, username);
                else
                        yyerror2("Cannot read htpasswd (%s)", filename);
                return;
        }

        while (! feof(handle)) {
                char *colonindex = NULL;

                if (! fgets(buf, STRLEN, handle))
                        continue;

                Str_rtrim(buf);
                Str_curtail(buf, "#");

                if (NULL == (colonindex = strchr(buf, ':')))
                continue;

                ht_passwd = Str_dup(colonindex+1);
                *colonindex = '\0';

                /* In case we have a file in /etc/passwd or /etc/shadow style we
                 *  want to remove ":.*$" and Crypt and MD5 hashed dont have a colon
                 */

                if ((NULL != (colonindex = strchr(ht_passwd, ':'))) && (dtype != Digest_Cleartext))
                        *colonindex = '\0';

                ht_username = Str_dup(buf);

                if (username == NULL) {
                        if (addcredentials(ht_username, ht_passwd, dtype, false))
                                credentials_added++;
                } else if (Str_cmp(username, ht_username) == 0)  {
                        if (addcredentials(ht_username, ht_passwd, dtype, false))
                                credentials_added++;
                } else {
                        FREE(ht_passwd);
                        FREE(ht_username);
                }
        }

        if (credentials_added == 0) {
                if (username == NULL)
                        yywarning2("htpasswd file (%s) has no usable credentials", filename);
                else
                        yywarning2("htpasswd file (%s) has no usable credentials for user %s", filename, username);
        }
        fclose(handle);
}


#ifdef HAVE_LIBPAM
static void addpamauth(char* groupname, int readonly) {
        Auth_T prev = NULL;

        ASSERT(groupname);

        if (! Run.httpd.credentials)
                NEW(Run.httpd.credentials);

        Auth_T c = Run.httpd.credentials;
        do {
                if (c->groupname != NULL && IS(c->groupname, groupname)) {
                        yywarning2("PAM group %s was added already, entry ignored", groupname);
                        FREE(groupname);
                        return;
                }
                prev = c;
                c = c->next;
        } while (c != NULL);

        NEW(prev->next);
        c = prev->next;

        c->next        = NULL;
        c->uname       = NULL;
        c->passwd      = NULL;
        c->groupname   = groupname;
        c->digesttype  = Digest_Pam;
        c->is_readonly = readonly;

        DEBUG("Adding PAM group '%s'\n", groupname);

        return;
}
#endif


/*
 * Add Basic Authentication credentials
 */
static bool addcredentials(char *uname, char *passwd, Digest_Type dtype, bool readonly) {
        Auth_T c;

        ASSERT(uname);
        ASSERT(passwd);

        if (strlen(passwd) > Str_compareConstantTimeStringLength) {
                yyerror2("Password for user %s is too long, maximum %d allowed", uname, Str_compareConstantTimeStringLength);
                FREE(uname);
                FREE(passwd);
                return false;
        }

        if (! Run.httpd.credentials) {
                NEW(Run.httpd.credentials);
                c = Run.httpd.credentials;
        } else {
                if (Util_getUserCredentials(uname) != NULL) {
                        yywarning2("Credentials for user %s were already added, entry ignored", uname);
                        FREE(uname);
                        FREE(passwd);
                        return false;
                }
                c = Run.httpd.credentials;
                while (c->next != NULL)
                        c = c->next;
                NEW(c->next);
                c = c->next;
        }

        c->next        = NULL;
        c->uname       = uname;
        c->passwd      = passwd;
        c->groupname   = NULL;
        c->digesttype  = dtype;
        c->is_readonly = readonly;

        DEBUG("Adding credentials for user '%s'\n", uname);

        return true;

}


/*
 * Set the syslog and the facilities to be used
 */
static void setsyslog(char *facility) {

        if (! Run.files.log || ihp.logfile) {
                ihp.logfile = true;
                setlogfile(Str_dup("syslog"));
                Run.flags |= Run_UseSyslog;
                Run.flags |= Run_Log;
        }

        if (facility) {
                if (IS(facility,"log_local0"))
                        Run.facility = LOG_LOCAL0;
                else if (IS(facility, "log_local1"))
                        Run.facility = LOG_LOCAL1;
                else if (IS(facility, "log_local2"))
                        Run.facility = LOG_LOCAL2;
                else if (IS(facility, "log_local3"))
                        Run.facility = LOG_LOCAL3;
                else if (IS(facility, "log_local4"))
                        Run.facility = LOG_LOCAL4;
                else if (IS(facility, "log_local5"))
                        Run.facility = LOG_LOCAL5;
                else if (IS(facility, "log_local6"))
                        Run.facility = LOG_LOCAL6;
                else if (IS(facility, "log_local7"))
                        Run.facility = LOG_LOCAL7;
                else if (IS(facility, "log_daemon"))
                        Run.facility = LOG_DAEMON;
                else
                        yyerror2("Invalid syslog facility");
        } else {
                Run.facility = LOG_USER;
        }

}


/*
 * Reset the current sslset for reuse
 */
static void reset_sslset() {
        memset(&sslset, 0, sizeof(struct SslOptions_T));
        sslset.version = sslset.verify = sslset.allowSelfSigned = -1;
}


/*
 * Reset the current mailset for reuse
 */
static void reset_mailset() {
        memset(&mailset, 0, sizeof(struct Mail_T));
}


/*
 * Reset the mailserver set to default values
 */
static void reset_mailserverset() {
        memset(&mailserverset, 0, sizeof(struct MailServer_T));
        mailserverset.port = PORT_SMTP;
}


/*
 * Reset the mmonit set to default values
 */
static void reset_mmonitset() {
        memset(&mmonitset, 0, sizeof(struct Mmonit_T));
        mmonitset.timeout = Run.limits.networkTimeout;
}


/*
 * Reset the Port set to default values
 */
static void reset_portset() {
        memset(&portset, 0, sizeof(struct Port_T));
        portset.check_invers = false;
        portset.socket = -1;
        portset.type = Socket_Tcp;
        portset.family = Socket_Ip;
        portset.timeout = Run.limits.networkTimeout;
        portset.retry = 1;
        portset.protocol = Protocol_get(Protocol_DEFAULT);
        urlrequest = NULL;
}


/*
 * Reset the Proc set to default values
 */
static void reset_resourceset() {
        resourceset.resource_id = 0;
        resourceset.limit = 0;
        resourceset.action = NULL;
        resourceset.operator = Operator_Equal;
}


/*
 * Reset the Timestamp set to default values
 */
static void reset_timestampset() {
        timestampset.type = Timestamp_Default;
        timestampset.operator = Operator_Equal;
        timestampset.time = 0;
        timestampset.test_changes = false;
        timestampset.initialized = false;
        timestampset.action = NULL;
}


/*
 * Reset the ActionRate set to default values
 */
static void reset_actionrateset() {
        actionrateset.count = 0;
        actionrateset.cycle = 0;
        actionrateset.action = NULL;
}


/*
 * Reset the Size set to default values
 */
static void reset_sizeset() {
        sizeset.operator = Operator_Equal;
        sizeset.size = 0;
        sizeset.test_changes = false;
        sizeset.action = NULL;
}


/*
 * Reset the Uptime set to default values
 */
static void reset_uptimeset() {
        uptimeset.operator = Operator_Equal;
        uptimeset.uptime = 0;
        uptimeset.action = NULL;
}


static void reset_responsetimeset() {
        responsetimeset.operator = Operator_Less;
        responsetimeset.current = 0.;
        responsetimeset.limit = -1.;
}


static void reset_linkstatusset() {
        linkstatusset.check_invers = false;
        linkstatusset.action = NULL;
}


static void reset_linkspeedset() {
        linkspeedset.action = NULL;
}


static void reset_linksaturationset() {
        linksaturationset.limit = 0.;
        linksaturationset.operator = Operator_Equal;
        linksaturationset.action = NULL;
}


/*
 * Reset the Bandwidth set to default values
 */
static void reset_bandwidthset() {
        bandwidthset.operator = Operator_Equal;
        bandwidthset.limit = 0ULL;
        bandwidthset.action = NULL;
}


/*
 * Reset the Pid set to default values
 */
static void reset_pidset() {
        pidset.action = NULL;
}


/*
 * Reset the PPid set to default values
 */
static void reset_ppidset() {
        ppidset.action = NULL;
}


/*
 * Reset the Fsflag set to default values
 */
static void reset_fsflagset() {
        fsflagset.action = NULL;
}


/*
 * Reset the Nonexist set to default values
 */
static void reset_nonexistset() {
        nonexistset.action = NULL;
}


static void reset_existset() {
        existset.action = NULL;
}


/*
 * Reset the Checksum set to default values
 */
static void reset_checksumset() {
        checksumset.type         = Hash_Unknown;
        checksumset.test_changes = false;
        checksumset.action       = NULL;
        *checksumset.hash        = 0;
}


/*
 * Reset the Perm set to default values
 */
static void reset_permset() {
        permset.test_changes = false;
        permset.perm = 0;
        permset.action = NULL;
}


/*
 * Reset the Status set to default values
 */
static void reset_statusset() {
        statusset.initialized = false;
        statusset.return_value = 0;
        statusset.operator = Operator_Equal;
        statusset.action = NULL;
}


/*
 * Reset the Uid set to default values
 */
static void reset_uidset() {
        uidset.uid = 0;
        uidset.action = NULL;
}


/*
 * Reset the Gid set to default values
 */
static void reset_gidset() {
        gidset.gid = 0;
        gidset.action = NULL;
}


/*
 * Reset the Filesystem set to default values
 */
static void reset_filesystemset() {
        filesystemset.resource = 0;
        filesystemset.operator = Operator_Equal;
        filesystemset.limit_absolute = -1;
        filesystemset.limit_percent = -1.;
        filesystemset.action = NULL;
}


/*
 * Reset the ICMP set to default values
 */
static void reset_icmpset() {
        icmpset.type = ICMP_ECHO;
        icmpset.size = ICMP_SIZE;
        icmpset.count = ICMP_ATTEMPT_COUNT;
        icmpset.timeout = Run.limits.networkTimeout;
        icmpset.check_invers = false;
        icmpset.action = NULL;
}


/*
 * Reset the Rate set to default values
 */
static void reset_rateset(struct rate_t *r) {
        r->count = 1;
        r->cycles = 1;
}


/* ---------------------------------------------------------------- Checkers */


/*
 * Check for unique service name
 */
static void check_name(char *name) {
        ASSERT(name);

        if (Util_existService(name) || (current && IS(name, current->name)))
                yyerror2("Service name conflict, %s already defined", name);
        if (name && *name == '/')
                yyerror2("Service name '%s' must not start with '/' -- ", name);
}


/*
 * Permission statement semantic check
 */
static int check_perm(int perm) {
        int result;
        char *status;
        char buf[STRLEN];

        snprintf(buf, STRLEN, "%d", perm);

        result = (int)strtol(buf, &status, 8);

        if (*status != '\0' || result < 0 || result > 07777)
                yyerror2("Permission statements must have an octal value between 0 and 7777");

        return result;
}


/*
 * Check the dependency graph for errors
 * by doing a topological sort, thereby finding any cycles.
 * Assures that graph is a Directed Acyclic Graph (DAG).
 */
static void check_depend() {
        Service_T depends_on = NULL;
        Service_T* dlt = &depend_list; /* the current tail of it                                 */
        bool done;                /* no unvisited nodes left?                               */
        bool found_some;          /* last iteration found anything new ?                    */
        depend_list = NULL;            /* depend_list will be the topological sorted servicelist */

        do {
                done = true;
                found_some = false;
                for (Service_T s = servicelist; s; s = s->next) {
                        Dependant_T d;
                        if (s->visited)
                                continue;
                        done = false; // still unvisited nodes
                        depends_on = NULL;
                        for (d = s->dependantlist; d; d = d->next) {
                                Service_T dp = Util_getService(d->dependant);
                                if (! dp) {
                                        Log_error("Depending service '%s' is not defined in the control file\n", d->dependant);
                                        exit(1);
                                }
                                if (! dp->visited) {
                                        depends_on = dp;
                                }
                        }

                        if (! depends_on) {
                                s->visited = true;
                                found_some = true;
                                *dlt = s;
                                dlt = &s->next_depend;
                        }
                }
        } while (found_some && ! done);

        if (! done) {
                ASSERT(depends_on);
                Log_error("Found a depend loop in the control file involving the service '%s'\n", depends_on->name);
                exit(1);
        }

        ASSERT(depend_list);
        servicelist = depend_list;

        for (Service_T s = depend_list; s; s = s->next_depend)
                s->next = s->next_depend;
}


// Check and warn if the executable does not exist
static void check_exec(char *exec) {
        if (! File_exist(exec))
                yywarning2("Program does not exist:");
        else if (! File_isExecutable(exec))
                yywarning2("Program is not executable:");
}


/* Return a valid max forward value for SIP header */
static int verifyMaxForward(int mf) {
        if (mf == 0) {
                return INT_MAX; // Differentiate uninitialized (0) and explicit zero
        } else if (mf > 0 && mf <= 255) {
                return mf;
        }
        yywarning2("SIP max forward is outside the range [0..255]. Setting max forward to 70");
        return 70;
}


/* -------------------------------------------------------------------- Misc */


/*
 * Cleans up a hash string, tolower and remove byte separators
 */
static int cleanup_hash_string(char *hashstring) {
        int i = 0, j = 0;

        ASSERT(hashstring);

        while (hashstring[i]) {
                if (isxdigit((int)hashstring[i])) {
                        hashstring[j] = tolower((int)hashstring[i]);
                        j++;
                }
                i++;
        }
        hashstring[j] = 0;
        return j;
}


/* Return deep copy of the command */
static command_t copycommand(command_t source) {
        int i;
        command_t copy = NULL;

        NEW(copy);
        copy->length = source->length;
        copy->has_uid = source->has_uid;
        copy->uid = source->uid;
        copy->has_gid = source->has_gid;
        copy->gid = source->gid;
        copy->timeout = source->timeout;
        for (i = 0; i < copy->length; i++)
                copy->arg[i] = Str_dup(source->arg[i]);
        copy->arg[copy->length] = NULL;

        return copy;
}


static void _setPEM(char **store, char *path, const char *description, bool isFile) {
        if (*store) {
                yyerror2("Duplicate %s", description);
                FREE(path);
        } else if (! File_exist(path)) {
                yyerror2("%s doesn't exist", description);
                FREE(path);
        } else if (! (isFile ? File_isFile(path) : File_isDirectory(path))) {
                yyerror2("%s is not a %s", description, isFile ? "file" : "directory");
                FREE(path);
        } else if (! File_isReadable(path)) {
                yyerror2("Cannot read %s", description);
                FREE(path);
        } else {
                sslset.flags = SSL_Enabled;
                *store = path;
        }
}


static void _setSSLOptions(SslOptions_T options) {
        options->allowSelfSigned = sslset.allowSelfSigned;
        options->CACertificateFile = sslset.CACertificateFile;
        options->CACertificatePath = sslset.CACertificatePath;
        options->checksum = sslset.checksum;
        options->checksumType = sslset.checksumType;
        options->ciphers = sslset.ciphers;
        options->clientpemfile = sslset.clientpemfile;
        options->flags = sslset.flags;
        options->pemfile = sslset.pemfile;
        options->pemchain = sslset.pemchain;
        options->pemkey = sslset.pemkey;
        options->verify = sslset.verify;
        options->version = sslset.version;
        reset_sslset();
}


#ifdef HAVE_OPENSSL
static void _setSSLVersion(short version) {
        sslset.flags = SSL_Enabled;
        if (sslset.version == -1)
                sslset.version = version;
        else
                sslset.version |= version;
}
#endif


static void _unsetSSLVersion(short version) {
        if (sslset.version != -1)
                sslset.version &= ~version;
}


static void addsecurityattribute(char *value, Action_Type failed, Action_Type succeeded) {
        SecurityAttribute_T attr;
        NEW(attr);
        addeventaction(&(attr->action), failed, succeeded);
        attr->attribute = value;
        attr->next = current->secattrlist;
        current->secattrlist = attr;
}


static void addfiledescriptors(Operator_Type operator, bool total, long long value_absolute, float value_percent, Action_Type failed, Action_Type succeeded) {
        Filedescriptors_T fds;
        NEW(fds);
        addeventaction(&(fds->action), failed, succeeded);
        fds->total = total;
        fds->limit_absolute = value_absolute;
        fds->limit_percent = value_percent;
        fds->operator = operator;
        fds->next = current->filedescriptorslist;
        current->filedescriptorslist = fds;
}

static void _sanityCheckEveryStatement(Service_T s) {
        if (s->every.type != Every_Initializing) {
                yywarning2("The 'every' statement can be specified only once, the last value will be used\n");
                switch (s->every.type) {
                        case Every_Cron:
                        case Every_NotInCron:
                                FREE(s->every.spec.cron);
                                break;
                        default:
                                break;
                }
        }
}

