/* HexTextBuffer.c generated by valac 0.48.17, the Vala compiler
 * generated from HexTextBuffer.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define MOSERIAL_TYPE_HEX_TEXT_BUFFER (moserial_hex_text_buffer_get_type ())
#define MOSERIAL_HEX_TEXT_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_HEX_TEXT_BUFFER, moserialHexTextBuffer))
#define MOSERIAL_HEX_TEXT_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_HEX_TEXT_BUFFER, moserialHexTextBufferClass))
#define MOSERIAL_IS_HEX_TEXT_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_HEX_TEXT_BUFFER))
#define MOSERIAL_IS_HEX_TEXT_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_HEX_TEXT_BUFFER))
#define MOSERIAL_HEX_TEXT_BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_HEX_TEXT_BUFFER, moserialHexTextBufferClass))

typedef struct _moserialHexTextBuffer moserialHexTextBuffer;
typedef struct _moserialHexTextBufferClass moserialHexTextBufferClass;
typedef struct _moserialHexTextBufferPrivate moserialHexTextBufferPrivate;
enum  {
	MOSERIAL_HEX_TEXT_BUFFER_0_PROPERTY,
	MOSERIAL_HEX_TEXT_BUFFER_NUM_PROPERTIES
};
static GParamSpec* moserial_hex_text_buffer_properties[MOSERIAL_HEX_TEXT_BUFFER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_PREFERENCES (preferences_get_type ())
#define PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES, Preferences))
#define PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES, PreferencesClass))
#define IS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES))
#define IS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES))
#define PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES, PreferencesClass))

typedef struct _Preferences Preferences;
typedef struct _PreferencesClass PreferencesClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _moserialHexTextBuffer {
	GtkTextBuffer parent_instance;
	moserialHexTextBufferPrivate * priv;
};

struct _moserialHexTextBufferClass {
	GtkTextBufferClass parent_class;
};

struct _moserialHexTextBufferPrivate {
	GtkTextMark* nextHexMark;
	GtkTextMark* nextCharMark;
	GtkTextTag* addressTag;
	gint hexBytes;
};

static gint moserialHexTextBuffer_private_offset;
static gpointer moserial_hex_text_buffer_parent_class = NULL;

GType moserial_hex_text_buffer_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (moserialHexTextBuffer, g_object_unref)
GType preferences_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Preferences, g_object_unref)
void moserial_hex_text_buffer_applyPreferences (moserialHexTextBuffer* self,
                                                Preferences* preferences);
const gchar* preferences_get_highlightColor (Preferences* self);
void moserial_hex_text_buffer_clear (moserialHexTextBuffer* self);
static void moserial_hex_text_buffer_setup (moserialHexTextBuffer* self);
void moserial_hex_text_buffer_add (moserialHexTextBuffer* self,
                                   guchar data);
moserialHexTextBuffer* moserial_hex_text_buffer_new (void);
moserialHexTextBuffer* moserial_hex_text_buffer_construct (GType object_type);
static GObject * moserial_hex_text_buffer_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static void moserial_hex_text_buffer_finalize (GObject * obj);
static GType moserial_hex_text_buffer_get_type_once (void);

static inline gpointer
moserial_hex_text_buffer_get_instance_private (moserialHexTextBuffer* self)
{
	return G_STRUCT_MEMBER_P (self, moserialHexTextBuffer_private_offset);
}

void
moserial_hex_text_buffer_applyPreferences (moserialHexTextBuffer* self,
                                           Preferences* preferences)
{
	GtkTextTag* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (preferences != NULL);
	_tmp0_ = self->priv->addressTag;
	_tmp1_ = preferences_get_highlightColor (preferences);
	_tmp2_ = _tmp1_;
	g_object_set (_tmp0_, "foreground", _tmp2_, NULL);
}

void
moserial_hex_text_buffer_clear (moserialHexTextBuffer* self)
{
	GtkTextMark* _tmp0_;
	GtkTextMark* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->nextHexMark;
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, _tmp0_);
	_tmp1_ = self->priv->nextCharMark;
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, _tmp1_);
	gtk_text_buffer_set_text ((GtkTextBuffer*) self, "", 0);
	moserial_hex_text_buffer_setup (self);
}

static void
moserial_hex_text_buffer_setup (moserialHexTextBuffer* self)
{
	GtkTextIter nextHexIter = {0};
	GtkTextIter nextCharIter = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextMark* _tmp1_;
	GtkTextMark* _tmp2_;
	GtkTextIter _tmp3_;
	GtkTextIter _tmp4_;
	GtkTextMark* _tmp5_;
	GtkTextMark* _tmp6_;
	GtkTextIter _tmp7_;
	g_return_if_fail (self != NULL);
	gtk_text_buffer_get_end_iter ((GtkTextBuffer*) self, &_tmp0_);
	nextHexIter = _tmp0_;
	_tmp1_ = gtk_text_mark_new ("nextHex", TRUE);
	_g_object_unref0 (self->priv->nextHexMark);
	self->priv->nextHexMark = _tmp1_;
	_tmp2_ = self->priv->nextHexMark;
	_tmp3_ = nextHexIter;
	gtk_text_buffer_add_mark ((GtkTextBuffer*) self, _tmp2_, &_tmp3_);
	_tmp4_ = nextHexIter;
	nextCharIter = _tmp4_;
	_tmp5_ = gtk_text_mark_new ("nextChar", TRUE);
	_g_object_unref0 (self->priv->nextCharMark);
	self->priv->nextCharMark = _tmp5_;
	_tmp6_ = self->priv->nextCharMark;
	_tmp7_ = nextCharIter;
	gtk_text_buffer_add_mark ((GtkTextBuffer*) self, _tmp6_, &_tmp7_);
	self->priv->hexBytes = 0;
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

void
moserial_hex_text_buffer_add (moserialHexTextBuffer* self,
                              guchar data)
{
	GtkTextIter nextHexIter = {0};
	GtkTextIter nextCharIter = {0};
	gchar* incomingHexBuffer = NULL;
	gchar* _tmp0_;
	GtkTextMark* _tmp34_;
	GtkTextIter _tmp35_ = {0};
	const gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	GtkTextMark* _tmp44_;
	GtkTextIter _tmp45_ = {0};
	const gchar* _tmp46_;
	gint _tmp47_;
	gint _tmp48_;
	GtkTextMark* _tmp49_;
	GtkTextMark* _tmp50_;
	GtkTextMark* _tmp51_;
	GtkTextIter _tmp52_;
	GtkTextIter tempIter = {0};
	GtkTextIter _tmp53_;
	gchar* _tmp54_;
	gint _tmp55_;
	GtkTextMark* _tmp56_;
	GtkTextIter _tmp57_ = {0};
	gunichar c = 0U;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gunichar _tmp60_;
	gchar* s = NULL;
	gchar* _tmp61_;
	gboolean _tmp62_ = FALSE;
	const gchar* _tmp63_;
	GtkTextMark* _tmp75_;
	GtkTextMark* _tmp76_;
	GtkTextMark* _tmp77_;
	GtkTextIter _tmp78_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	incomingHexBuffer = _tmp0_;
	if ((self->priv->hexBytes % 16) == 0) {
		GtkTextIter startIter = {0};
		GtkTextMark* _tmp1_;
		GtkTextIter _tmp2_ = {0};
		GtkTextMark* startMark = NULL;
		GtkTextMark* _tmp3_;
		GtkTextMark* _tmp4_;
		GtkTextIter _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GtkTextIter _tmp8_ = {0};
		GtkTextMark* _tmp9_;
		GtkTextIter _tmp10_ = {0};
		GtkTextIter _tmp11_;
		GtkTextIter _tmp12_;
		GtkTextMark* _tmp13_;
		GtkTextIter _tmp14_ = {0};
		GtkTextMark* _tmp15_;
		GtkTextIter _tmp16_;
		GtkTextMark* _tmp17_;
		GtkTextMark* _tmp18_;
		GtkTextIter _tmp19_;
		GtkTextIter _tmp20_ = {0};
		GtkTextMark* _tmp21_;
		GtkTextMark* _tmp22_;
		GtkTextMark* _tmp23_;
		GtkTextIter _tmp24_;
		_tmp1_ = self->priv->nextCharMark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp2_, _tmp1_);
		nextCharIter = _tmp2_;
		_tmp3_ = gtk_text_mark_new ("startMark", TRUE);
		startMark = _tmp3_;
		_tmp4_ = startMark;
		_tmp5_ = nextCharIter;
		gtk_text_buffer_add_mark ((GtkTextBuffer*) self, _tmp4_, &_tmp5_);
		_tmp6_ = g_strdup_printf ("\n%08x", (guint) self->priv->hexBytes);
		_tmp7_ = _tmp6_;
		gtk_text_buffer_insert ((GtkTextBuffer*) self, &nextCharIter, _tmp7_, 9);
		_g_free0 (_tmp7_);
		gtk_text_buffer_get_end_iter ((GtkTextBuffer*) self, &_tmp8_);
		nextCharIter = _tmp8_;
		_tmp9_ = startMark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp10_, _tmp9_);
		startIter = _tmp10_;
		_tmp11_ = startIter;
		_tmp12_ = nextCharIter;
		gtk_text_buffer_apply_tag_by_name ((GtkTextBuffer*) self, "hex_address", &_tmp11_, &_tmp12_);
		_tmp13_ = startMark;
		gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, _tmp13_);
		gtk_text_buffer_insert ((GtkTextBuffer*) self, &nextCharIter, " ", 1);
		gtk_text_buffer_get_end_iter ((GtkTextBuffer*) self, &_tmp14_);
		nextCharIter = _tmp14_;
		_tmp15_ = self->priv->nextHexMark;
		gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, _tmp15_);
		_tmp16_ = nextCharIter;
		nextHexIter = _tmp16_;
		_tmp17_ = gtk_text_mark_new ("nextHex", TRUE);
		_g_object_unref0 (self->priv->nextHexMark);
		self->priv->nextHexMark = _tmp17_;
		_tmp18_ = self->priv->nextHexMark;
		_tmp19_ = nextHexIter;
		gtk_text_buffer_add_mark ((GtkTextBuffer*) self, _tmp18_, &_tmp19_);
		gtk_text_buffer_insert ((GtkTextBuffer*) self, &nextCharIter, "                                                   ", 51);
		gtk_text_buffer_get_end_iter ((GtkTextBuffer*) self, &_tmp20_);
		nextCharIter = _tmp20_;
		_tmp21_ = self->priv->nextCharMark;
		gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, _tmp21_);
		_tmp22_ = gtk_text_mark_new ("nextChar", TRUE);
		_g_object_unref0 (self->priv->nextCharMark);
		self->priv->nextCharMark = _tmp22_;
		_tmp23_ = self->priv->nextCharMark;
		_tmp24_ = nextCharIter;
		gtk_text_buffer_add_mark ((GtkTextBuffer*) self, _tmp23_, &_tmp24_);
		_g_object_unref0 (startMark);
	} else {
		if ((self->priv->hexBytes % 8) == 0) {
			GtkTextMark* _tmp25_;
			GtkTextIter _tmp26_ = {0};
			GtkTextMark* _tmp27_;
			GtkTextIter _tmp28_ = {0};
			GtkTextMark* _tmp29_;
			GtkTextMark* _tmp30_;
			GtkTextMark* _tmp31_;
			GtkTextIter _tmp32_;
			GtkTextIter tempIter = {0};
			GtkTextIter _tmp33_;
			_tmp25_ = self->priv->nextHexMark;
			gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp26_, _tmp25_);
			nextHexIter = _tmp26_;
			gtk_text_buffer_insert ((GtkTextBuffer*) self, &nextHexIter, "  ", 2);
			_tmp27_ = self->priv->nextHexMark;
			gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp28_, _tmp27_);
			nextHexIter = _tmp28_;
			gtk_text_iter_forward_chars (&nextHexIter, 2);
			_tmp29_ = self->priv->nextHexMark;
			gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, _tmp29_);
			_tmp30_ = gtk_text_mark_new ("nextHex", TRUE);
			_g_object_unref0 (self->priv->nextHexMark);
			self->priv->nextHexMark = _tmp30_;
			_tmp31_ = self->priv->nextHexMark;
			_tmp32_ = nextHexIter;
			gtk_text_buffer_add_mark ((GtkTextBuffer*) self, _tmp31_, &_tmp32_);
			_tmp33_ = nextHexIter;
			tempIter = _tmp33_;
			gtk_text_iter_forward_chars (&tempIter, 2);
			gtk_text_buffer_delete ((GtkTextBuffer*) self, &nextHexIter, &tempIter);
		}
	}
	_tmp34_ = self->priv->nextHexMark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp35_, _tmp34_);
	nextHexIter = _tmp35_;
	_tmp36_ = incomingHexBuffer;
	_tmp37_ = g_strdup_printf ("%02X ", (guint) data);
	_tmp38_ = _tmp37_;
	_tmp39_ = g_strconcat (_tmp36_, _tmp38_, NULL);
	_g_free0 (incomingHexBuffer);
	incomingHexBuffer = _tmp39_;
	_g_free0 (_tmp38_);
	_tmp40_ = incomingHexBuffer;
	_tmp41_ = incomingHexBuffer;
	_tmp42_ = strlen (_tmp41_);
	_tmp43_ = _tmp42_;
	gtk_text_buffer_insert ((GtkTextBuffer*) self, &nextHexIter, _tmp40_, (gint) _tmp43_);
	_tmp44_ = self->priv->nextHexMark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp45_, _tmp44_);
	nextHexIter = _tmp45_;
	_tmp46_ = incomingHexBuffer;
	_tmp47_ = strlen (_tmp46_);
	_tmp48_ = _tmp47_;
	gtk_text_iter_forward_chars (&nextHexIter, _tmp48_);
	_tmp49_ = self->priv->nextHexMark;
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, _tmp49_);
	_tmp50_ = gtk_text_mark_new ("nextHex", TRUE);
	_g_object_unref0 (self->priv->nextHexMark);
	self->priv->nextHexMark = _tmp50_;
	_tmp51_ = self->priv->nextHexMark;
	_tmp52_ = nextHexIter;
	gtk_text_buffer_add_mark ((GtkTextBuffer*) self, _tmp51_, &_tmp52_);
	_tmp53_ = nextHexIter;
	tempIter = _tmp53_;
	gtk_text_iter_forward_chars (&tempIter, 3);
	gtk_text_buffer_delete ((GtkTextBuffer*) self, &nextHexIter, &tempIter);
	_tmp54_ = g_strdup ("");
	_g_free0 (incomingHexBuffer);
	incomingHexBuffer = _tmp54_;
	_tmp55_ = self->priv->hexBytes;
	self->priv->hexBytes = _tmp55_ + 1;
	_tmp56_ = self->priv->nextCharMark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp57_, _tmp56_);
	nextCharIter = _tmp57_;
	_tmp58_ = g_strdup_printf ("%c", (gint) data);
	_tmp59_ = _tmp58_;
	_tmp60_ = string_get_char (_tmp59_, (glong) 0);
	_g_free0 (_tmp59_);
	c = _tmp60_;
	_tmp61_ = g_strdup_printf ("%c", (gint) data);
	s = _tmp61_;
	_tmp63_ = s;
	if (g_utf8_validate (_tmp63_, (gssize) -1, NULL)) {
		_tmp62_ = g_unichar_isprint (c);
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		const gchar* _tmp64_;
		const gchar* _tmp65_;
		gint _tmp66_;
		gint _tmp67_;
		GtkTextMark* _tmp68_;
		GtkTextIter _tmp69_ = {0};
		const gchar* _tmp70_;
		gint _tmp71_;
		gint _tmp72_;
		_tmp64_ = s;
		_tmp65_ = s;
		_tmp66_ = strlen (_tmp65_);
		_tmp67_ = _tmp66_;
		gtk_text_buffer_insert ((GtkTextBuffer*) self, &nextCharIter, _tmp64_, (gint) _tmp67_);
		_tmp68_ = self->priv->nextCharMark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp69_, _tmp68_);
		nextCharIter = _tmp69_;
		_tmp70_ = s;
		_tmp71_ = strlen (_tmp70_);
		_tmp72_ = _tmp71_;
		gtk_text_iter_forward_chars (&nextCharIter, _tmp72_);
	} else {
		GtkTextMark* _tmp73_;
		GtkTextIter _tmp74_ = {0};
		gtk_text_buffer_insert ((GtkTextBuffer*) self, &nextCharIter, ".", 1);
		_tmp73_ = self->priv->nextCharMark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp74_, _tmp73_);
		nextCharIter = _tmp74_;
		gtk_text_iter_forward_chars (&nextCharIter, 1);
	}
	_tmp75_ = self->priv->nextCharMark;
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, _tmp75_);
	_tmp76_ = gtk_text_mark_new ("nextChar", TRUE);
	_g_object_unref0 (self->priv->nextCharMark);
	self->priv->nextCharMark = _tmp76_;
	_tmp77_ = self->priv->nextCharMark;
	_tmp78_ = nextCharIter;
	gtk_text_buffer_add_mark ((GtkTextBuffer*) self, _tmp77_, &_tmp78_);
	_g_free0 (s);
	_g_free0 (incomingHexBuffer);
}

moserialHexTextBuffer*
moserial_hex_text_buffer_construct (GType object_type)
{
	moserialHexTextBuffer * self = NULL;
	self = (moserialHexTextBuffer*) g_object_new (object_type, NULL);
	return self;
}

moserialHexTextBuffer*
moserial_hex_text_buffer_new (void)
{
	return moserial_hex_text_buffer_construct (MOSERIAL_TYPE_HEX_TEXT_BUFFER);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GObject *
moserial_hex_text_buffer_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	moserialHexTextBuffer * self;
	GtkTextTag* _tmp0_;
	GtkTextTag* _tmp1_;
	parent_class = G_OBJECT_CLASS (moserial_hex_text_buffer_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MOSERIAL_TYPE_HEX_TEXT_BUFFER, moserialHexTextBuffer);
	moserial_hex_text_buffer_setup (self);
	_tmp0_ = gtk_text_buffer_create_tag ((GtkTextBuffer*) self, "hex_address", "foreground", "#2020ff", NULL, NULL);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->addressTag);
	self->priv->addressTag = _tmp1_;
	return obj;
}

static void
moserial_hex_text_buffer_class_init (moserialHexTextBufferClass * klass,
                                     gpointer klass_data)
{
	moserial_hex_text_buffer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &moserialHexTextBuffer_private_offset);
	G_OBJECT_CLASS (klass)->constructor = moserial_hex_text_buffer_constructor;
	G_OBJECT_CLASS (klass)->finalize = moserial_hex_text_buffer_finalize;
}

static void
moserial_hex_text_buffer_instance_init (moserialHexTextBuffer * self,
                                        gpointer klass)
{
	self->priv = moserial_hex_text_buffer_get_instance_private (self);
}

static void
moserial_hex_text_buffer_finalize (GObject * obj)
{
	moserialHexTextBuffer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MOSERIAL_TYPE_HEX_TEXT_BUFFER, moserialHexTextBuffer);
	_g_object_unref0 (self->priv->nextHexMark);
	_g_object_unref0 (self->priv->nextCharMark);
	_g_object_unref0 (self->priv->addressTag);
	G_OBJECT_CLASS (moserial_hex_text_buffer_parent_class)->finalize (obj);
}

static GType
moserial_hex_text_buffer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (moserialHexTextBufferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_hex_text_buffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialHexTextBuffer), 0, (GInstanceInitFunc) moserial_hex_text_buffer_instance_init, NULL };
	GType moserial_hex_text_buffer_type_id;
	moserial_hex_text_buffer_type_id = g_type_register_static (gtk_text_buffer_get_type (), "moserialHexTextBuffer", &g_define_type_info, 0);
	moserialHexTextBuffer_private_offset = g_type_add_instance_private (moserial_hex_text_buffer_type_id, sizeof (moserialHexTextBufferPrivate));
	return moserial_hex_text_buffer_type_id;
}

GType
moserial_hex_text_buffer_get_type (void)
{
	static volatile gsize moserial_hex_text_buffer_type_id__volatile = 0;
	if (g_once_init_enter (&moserial_hex_text_buffer_type_id__volatile)) {
		GType moserial_hex_text_buffer_type_id;
		moserial_hex_text_buffer_type_id = moserial_hex_text_buffer_get_type_once ();
		g_once_init_leave (&moserial_hex_text_buffer_type_id__volatile, moserial_hex_text_buffer_type_id);
	}
	return moserial_hex_text_buffer_type_id__volatile;
}

