/* InputParser.c generated by valac 0.48.17, the Vala compiler
 * generated from InputParser.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#define TYPE_INPUT_PARSER (input_parser_get_type ())
#define INPUT_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INPUT_PARSER, InputParser))
#define INPUT_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_INPUT_PARSER, InputParserClass))
#define IS_INPUT_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INPUT_PARSER))
#define IS_INPUT_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_INPUT_PARSER))
#define INPUT_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_INPUT_PARSER, InputParserClass))

typedef struct _InputParser InputParser;
typedef struct _InputParserClass InputParserClass;
typedef struct _InputParserPrivate InputParserPrivate;
enum  {
	INPUT_PARSER_0_PROPERTY,
	INPUT_PARSER_NUM_PROPERTIES
};
static GParamSpec* input_parser_properties[INPUT_PARSER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

typedef enum  {
	HEX_PARSE_ERROR_INVALID_INPUT
} HexParseError;
#define HEX_PARSE_ERROR hex_parse_error_quark ()
struct _InputParser {
	GObject parent_instance;
	InputParserPrivate * priv;
};

struct _InputParserClass {
	GObjectClass parent_class;
};

static gpointer input_parser_parent_class = NULL;

GQuark hex_parse_error_quark (void);
GType input_parser_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (InputParser, g_object_unref)
gchar* input_parser_statusReplace (const gchar* oldString);
guchar* input_parser_parseHex (const gchar* s,
                               gint* result_length1,
                               GError** error);
static guchar input_parser_xtoi (gunichar c);
InputParser* input_parser_new (void);
InputParser* input_parser_construct (GType object_type);
static GType input_parser_get_type_once (void);

GQuark
hex_parse_error_quark (void)
{
	return g_quark_from_static_string ("hex-parse-error-quark");
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
input_parser_statusReplace (const gchar* oldString)
{
	gchar* _tmp0_;
	gchar* result = NULL;
	g_return_val_if_fail (oldString != NULL, NULL);
	_tmp0_ = string_replace (oldString, "\\r", "\\n");
	result = _tmp0_;
	return result;
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

guchar*
input_parser_parseHex (const gchar* s,
                       gint* result_length1,
                       GError** error)
{
	glong len = 0L;
	gint _tmp0_;
	gint _tmp1_;
	guchar* r = NULL;
	guchar* _tmp2_;
	gint r_length1;
	gint _r_size_;
	guchar* _tmp10_;
	gint _tmp10__length1;
	GError* _inner_error0_ = NULL;
	guchar* result = NULL;
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = strlen (s);
	_tmp1_ = _tmp0_;
	len = (glong) _tmp1_;
	_tmp2_ = g_new0 (guchar, (len + 1) / 2);
	r = _tmp2_;
	r_length1 = (len + 1) / 2;
	_r_size_ = r_length1;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gunichar c = 0U;
				gint i = 0;
				gint temp = 0;
				const gchar* _tmp8_;
				guchar* _tmp9_;
				gint _tmp9__length1;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = x;
					x = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				if (!(((glong) x) < ((len + 1) / 2))) {
					break;
				}
				c = string_get_char (s, (glong) 0);
				i = (gint) input_parser_xtoi (c);
				if (i > 15) {
					GError* _tmp5_;
					_tmp5_ = g_error_new_literal (HEX_PARSE_ERROR, HEX_PARSE_ERROR_INVALID_INPUT, _ ("Invalid Input"));
					_inner_error0_ = _tmp5_;
					if (_inner_error0_->domain == HEX_PARSE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						r = (g_free (r), NULL);
						return NULL;
					} else {
						r = (g_free (r), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				if (len > ((glong) 1)) {
					const gchar* _tmp6_;
					i *= 16;
					_tmp6_ = g_utf8_next_char (s);
					s = _tmp6_;
					c = string_get_char (s, (glong) 0);
					temp = (gint) input_parser_xtoi (c);
					if (temp > 15) {
						GError* _tmp7_;
						_tmp7_ = g_error_new_literal (HEX_PARSE_ERROR, HEX_PARSE_ERROR_INVALID_INPUT, _ ("Invalid Input"));
						_inner_error0_ = _tmp7_;
						if (_inner_error0_->domain == HEX_PARSE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							r = (g_free (r), NULL);
							return NULL;
						} else {
							r = (g_free (r), NULL);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					i += temp;
				}
				_tmp8_ = g_utf8_next_char (s);
				s = _tmp8_;
				_tmp9_ = r;
				_tmp9__length1 = r_length1;
				_tmp9_[x] = (guchar) i;
			}
		}
	}
	_tmp10_ = r;
	_tmp10__length1 = r_length1;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	return result;
}

static guchar
input_parser_xtoi (gunichar c)
{
	guchar i = '\0';
	guchar result = '\0';
	i = (guchar) 16;
	switch (c) {
		case '0':
		{
			i = (guchar) 0;
			break;
		}
		case '1':
		{
			i = (guchar) 1;
			break;
		}
		case '2':
		{
			i = (guchar) 2;
			break;
		}
		case '3':
		{
			i = (guchar) 3;
			break;
		}
		case '4':
		{
			i = (guchar) 4;
			break;
		}
		case '5':
		{
			i = (guchar) 5;
			break;
		}
		case '6':
		{
			i = (guchar) 6;
			break;
		}
		case '7':
		{
			i = (guchar) 7;
			break;
		}
		case '8':
		{
			i = (guchar) 8;
			break;
		}
		case '9':
		{
			i = (guchar) 9;
			break;
		}
		case 'a':
		{
			i = (guchar) 10;
			break;
		}
		case 'b':
		{
			i = (guchar) 11;
			break;
		}
		case 'c':
		{
			i = (guchar) 12;
			break;
		}
		case 'd':
		{
			i = (guchar) 13;
			break;
		}
		case 'e':
		{
			i = (guchar) 14;
			break;
		}
		case 'f':
		{
			i = (guchar) 15;
			break;
		}
		case 'A':
		{
			i = (guchar) 10;
			break;
		}
		case 'B':
		{
			i = (guchar) 11;
			break;
		}
		case 'C':
		{
			i = (guchar) 12;
			break;
		}
		case 'D':
		{
			i = (guchar) 13;
			break;
		}
		case 'E':
		{
			i = (guchar) 14;
			break;
		}
		case 'F':
		{
			i = (guchar) 15;
			break;
		}
		default:
		break;
	}
	result = i;
	return result;
}

InputParser*
input_parser_construct (GType object_type)
{
	InputParser * self = NULL;
	self = (InputParser*) g_object_new (object_type, NULL);
	return self;
}

InputParser*
input_parser_new (void)
{
	return input_parser_construct (TYPE_INPUT_PARSER);
}

static void
input_parser_class_init (InputParserClass * klass,
                         gpointer klass_data)
{
	input_parser_parent_class = g_type_class_peek_parent (klass);
}

static void
input_parser_instance_init (InputParser * self,
                            gpointer klass)
{
}

static GType
input_parser_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (InputParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) input_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (InputParser), 0, (GInstanceInitFunc) input_parser_instance_init, NULL };
	GType input_parser_type_id;
	input_parser_type_id = g_type_register_static (G_TYPE_OBJECT, "InputParser", &g_define_type_info, 0);
	return input_parser_type_id;
}

GType
input_parser_get_type (void)
{
	static volatile gsize input_parser_type_id__volatile = 0;
	if (g_once_init_enter (&input_parser_type_id__volatile)) {
		GType input_parser_type_id;
		input_parser_type_id = input_parser_get_type_once ();
		g_once_init_leave (&input_parser_type_id__volatile, input_parser_type_id);
	}
	return input_parser_type_id__volatile;
}

