/* Profile.c generated by valac 0.48.17, the Vala compiler
 * generated from Profile.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>

#define TYPE_PROFILE (profile_get_type ())
#define PROFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROFILE, Profile))
#define PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROFILE, ProfileClass))
#define IS_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROFILE))
#define IS_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROFILE))
#define PROFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROFILE, ProfileClass))

typedef struct _Profile Profile;
typedef struct _ProfileClass ProfileClass;
typedef struct _ProfilePrivate ProfilePrivate;
enum  {
	PROFILE_0_PROPERTY,
	PROFILE_PROFILE_CHANGED_PROPERTY,
	PROFILE_NUM_PROPERTIES
};
static GParamSpec* profile_properties[PROFILE_NUM_PROPERTIES];
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _Profile {
	GObject parent_instance;
	ProfilePrivate * priv;
};

struct _ProfileClass {
	GObjectClass parent_class;
};

struct _ProfilePrivate {
	gboolean _profileChanged;
	GKeyFile* keyFile;
};

static gint Profile_private_offset;
static gpointer profile_parent_class = NULL;

GType profile_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Profile, g_object_unref)
gchar* profile_getString (Profile* self,
                          const gchar* group,
                          const gchar* key);
void profile_setString (Profile* self,
                        const gchar* group,
                        const gchar* key,
                        const gchar* new_val);
static void profile_set_profileChanged (Profile* self,
                                 gboolean value);
gint profile_getInteger (Profile* self,
                         const gchar* group,
                         const gchar* key,
                         gint default_val);
void profile_setInteger (Profile* self,
                         const gchar* group,
                         const gchar* key,
                         gint new_val);
gboolean profile_getBoolean (Profile* self,
                             const gchar* group,
                             const gchar* key,
                             gboolean default_val);
void profile_setBoolean (Profile* self,
                         const gchar* group,
                         const gchar* key,
                         gboolean new_val);
gboolean profile_load (Profile* self,
                       const gchar* filename,
                       GtkWindow* window);
void profile_toString (Profile* self);
void profile_save (Profile* self,
                   const gchar* filename,
                   GtkWindow* window);
Profile* profile_new (void);
Profile* profile_construct (GType object_type);
gboolean profile_get_profileChanged (Profile* self);
static GObject * profile_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties);
static void profile_finalize (GObject * obj);
static GType profile_get_type_once (void);
static void _vala_profile_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec);
static void _vala_profile_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec);

static inline gpointer
profile_get_instance_private (Profile* self)
{
	return G_STRUCT_MEMBER_P (self, Profile_private_offset);
}

gchar*
profile_getString (Profile* self,
                   const gchar* group,
                   const gchar* key)
{
	gchar* _result_ = NULL;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_result_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		GKeyFile* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->priv->keyFile;
		_tmp2_ = g_key_file_get_string (_tmp1_, group, key, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			_g_free0 (_result_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_free0 (_result_);
		_result_ = _tmp3_;
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		FILE* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = stdout;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		fprintf (_tmp4_, "%s\n", _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (_result_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = _result_;
	return result;
}

void
profile_setString (Profile* self,
                   const gchar* group,
                   const gchar* key,
                   const gchar* new_val)
{
	gboolean changed = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	GKeyFile* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (new_val != NULL);
	_tmp0_ = profile_getString (self, group, key);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strcmp0 (_tmp1_, new_val) != 0;
	_g_free0 (_tmp1_);
	changed = _tmp2_;
	_tmp3_ = self->priv->keyFile;
	g_key_file_set_string (_tmp3_, group, key, new_val);
	if (changed) {
		profile_set_profileChanged (self, TRUE);
	}
}

gint
profile_getInteger (Profile* self,
                    const gchar* group,
                    const gchar* key,
                    gint default_val)
{
	gint _result_ = 0;
	GError* _inner_error0_ = NULL;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (group != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	_result_ = default_val;
	{
		gint _tmp0_ = 0;
		GKeyFile* _tmp1_;
		_tmp1_ = self->priv->keyFile;
		_tmp0_ = g_key_file_get_integer (_tmp1_, group, key, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp2_ = -1;
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
		_result_ = _tmp0_;
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		FILE* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = stdout;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		fprintf (_tmp3_, "%s\n", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp6_ = -1;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp6_;
	}
	result = _result_;
	return result;
}

void
profile_setInteger (Profile* self,
                    const gchar* group,
                    const gchar* key,
                    gint new_val)
{
	gboolean changed = FALSE;
	GKeyFile* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	changed = profile_getInteger (self, group, key, 0) != new_val;
	_tmp0_ = self->priv->keyFile;
	g_key_file_set_integer (_tmp0_, group, key, new_val);
	if (changed) {
		profile_set_profileChanged (self, TRUE);
	}
}

gboolean
profile_getBoolean (Profile* self,
                    const gchar* group,
                    const gchar* key,
                    gboolean default_val)
{
	gboolean _result_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (group != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_result_ = default_val;
	{
		gboolean _tmp0_ = FALSE;
		GKeyFile* _tmp1_;
		_tmp1_ = self->priv->keyFile;
		_tmp0_ = g_key_file_get_boolean (_tmp1_, group, key, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp2_ = FALSE;
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
		_result_ = _tmp0_;
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		FILE* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = stdout;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		fprintf (_tmp3_, "%s\n", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp6_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp6_;
	}
	result = _result_;
	return result;
}

void
profile_setBoolean (Profile* self,
                    const gchar* group,
                    const gchar* key,
                    gboolean new_val)
{
	gboolean changed = FALSE;
	GKeyFile* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	changed = profile_getBoolean (self, group, key, FALSE) != new_val;
	_tmp0_ = self->priv->keyFile;
	g_key_file_set_boolean (_tmp0_, group, key, new_val);
	if (changed) {
		profile_set_profileChanged (self, TRUE);
	}
}

gboolean
profile_load (Profile* self,
              const gchar* filename,
              GtkWindow* window)
{
	gchar* f = NULL;
	gboolean default_profile = FALSE;
	gboolean _tmp14_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (window != NULL, FALSE);
	default_profile = FALSE;
	if (filename == NULL) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		default_profile = TRUE;
		_tmp0_ = g_get_user_config_dir ();
		_tmp1_ = g_strdup_printf ("%s/moserial.conf", _tmp0_);
		_g_free0 (f);
		f = _tmp1_;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (filename);
		_g_free0 (f);
		f = _tmp2_;
	}
	{
		GKeyFile* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = self->priv->keyFile;
		_tmp4_ = f;
		g_key_file_load_from_file (_tmp3_, _tmp4_, G_KEY_FILE_NONE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp5_ = FALSE;
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (f);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp5_;
		}
		profile_set_profileChanged (self, FALSE);
		result = TRUE;
		_g_free0 (f);
		return result;
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		FILE* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = stdout;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		fprintf (_tmp6_, "%s\n", _tmp8_);
		profile_set_profileChanged (self, FALSE);
		result = TRUE;
		_g_error_free0 (e);
		_g_free0 (f);
		return result;
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		if (!default_profile) {
			GtkMessageDialog* errorDialog = NULL;
			GError* _tmp9_;
			const gchar* _tmp10_;
			GtkMessageDialog* _tmp11_;
			GtkMessageDialog* _tmp12_;
			GtkMessageDialog* _tmp13_;
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			_tmp11_ = (GtkMessageDialog*) gtk_message_dialog_new (window, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s: %s\n%s", _ ("Error: Could not open file"), filename, _tmp10_);
			g_object_ref_sink (_tmp11_);
			errorDialog = _tmp11_;
			_tmp12_ = errorDialog;
			gtk_dialog_run ((GtkDialog*) _tmp12_);
			_tmp13_ = errorDialog;
			gtk_widget_destroy ((GtkWidget*) _tmp13_);
			_g_object_unref0 (errorDialog);
		}
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (f);
		return result;
	}
	__finally0:
	_g_free0 (f);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp14_;
}

void
profile_toString (Profile* self)
{
	gsize s = 0UL;
	FILE* _tmp0_;
	GKeyFile* _tmp1_;
	gsize _tmp2_ = 0UL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	_tmp1_ = self->priv->keyFile;
	_tmp3_ = g_key_file_to_data (_tmp1_, &_tmp2_, NULL);
	s = _tmp2_;
	_tmp4_ = _tmp3_;
	fprintf (_tmp0_, "%s\n", _tmp4_);
	_g_free0 (_tmp4_);
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

void
profile_save (Profile* self,
              const gchar* filename,
              GtkWindow* window)
{
	GFile* file = NULL;
	GFileOutputStream* fos = NULL;
	gchar* f = NULL;
	gboolean default_profile = FALSE;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	default_profile = FALSE;
	if (filename == NULL) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		default_profile = TRUE;
		_tmp0_ = g_get_user_config_dir ();
		_tmp1_ = g_strdup_printf ("%s/moserial.conf", _tmp0_);
		_g_free0 (f);
		f = _tmp1_;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (filename);
		_g_free0 (f);
		f = _tmp2_;
	}
	_tmp3_ = f;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	_g_object_unref0 (file);
	file = _tmp4_;
	{
		gsize s = 0UL;
		gchar* data = NULL;
		GFileOutputStream* _tmp5_ = NULL;
		GFile* _tmp6_;
		GFileOutputStream* _tmp7_;
		GFileOutputStream* _tmp8_;
		GKeyFile* _tmp9_;
		gsize _tmp10_ = 0UL;
		gchar* _tmp11_;
		GFileOutputStream* _tmp12_;
		const gchar* _tmp13_;
		guint8* _tmp14_;
		gint _tmp14__length1;
		gint _tmp15_ = 0;
		guint8* _tmp16_;
		gint _tmp16__length1;
		_tmp6_ = file;
		_tmp7_ = g_file_replace (_tmp6_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
		_tmp5_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (data);
			goto __catch0_g_error;
		}
		_tmp8_ = _tmp5_;
		_tmp5_ = NULL;
		_g_object_unref0 (fos);
		fos = _tmp8_;
		_tmp9_ = self->priv->keyFile;
		_tmp11_ = g_key_file_to_data (_tmp9_, &_tmp10_, NULL);
		s = _tmp10_;
		_g_free0 (data);
		data = _tmp11_;
		_tmp12_ = fos;
		_tmp13_ = data;
		_tmp14_ = string_get_data (_tmp13_, &_tmp15_);
		_tmp14__length1 = _tmp15_;
		_tmp16_ = _tmp14_;
		_tmp16__length1 = _tmp14__length1;
		g_output_stream_write ((GOutputStream*) _tmp12_, _tmp16_, (gsize) _tmp16__length1, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			_g_free0 (data);
			goto __catch0_g_error;
		}
		_g_object_unref0 (_tmp5_);
		_g_free0 (data);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp17_;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = stdout;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		fprintf (_tmp17_, "profile.save error: %s\n", _tmp19_);
		if (!default_profile) {
			GtkMessageDialog* errorDialog = NULL;
			GError* _tmp20_;
			const gchar* _tmp21_;
			GtkMessageDialog* _tmp22_;
			GtkMessageDialog* _tmp23_;
			GtkMessageDialog* _tmp24_;
			_tmp20_ = e;
			_tmp21_ = _tmp20_->message;
			_tmp22_ = (GtkMessageDialog*) gtk_message_dialog_new (window, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s: %s\n%s", _ ("Error: Could not open file"), filename, _tmp21_);
			g_object_ref_sink (_tmp22_);
			errorDialog = _tmp22_;
			_tmp23_ = errorDialog;
			gtk_dialog_run ((GtkDialog*) _tmp23_);
			_tmp24_ = errorDialog;
			gtk_widget_destroy ((GtkWidget*) _tmp24_);
			_g_object_unref0 (errorDialog);
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (f);
		_g_object_unref0 (fos);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	profile_set_profileChanged (self, FALSE);
	_g_free0 (f);
	_g_object_unref0 (fos);
	_g_object_unref0 (file);
}

Profile*
profile_construct (GType object_type)
{
	Profile * self = NULL;
	self = (Profile*) g_object_new (object_type, NULL);
	return self;
}

Profile*
profile_new (void)
{
	return profile_construct (TYPE_PROFILE);
}

gboolean
profile_get_profileChanged (Profile* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_profileChanged;
	return result;
}

static void
profile_set_profileChanged (Profile* self,
                            gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = profile_get_profileChanged (self);
	if (old_value != value) {
		self->priv->_profileChanged = value;
		g_object_notify_by_pspec ((GObject *) self, profile_properties[PROFILE_PROFILE_CHANGED_PROPERTY]);
	}
}

static GObject *
profile_constructor (GType type,
                     guint n_construct_properties,
                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	Profile * self;
	GKeyFile* _tmp0_;
	parent_class = G_OBJECT_CLASS (profile_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROFILE, Profile);
	_tmp0_ = g_key_file_new ();
	_g_key_file_unref0 (self->priv->keyFile);
	self->priv->keyFile = _tmp0_;
	return obj;
}

static void
profile_class_init (ProfileClass * klass,
                    gpointer klass_data)
{
	profile_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Profile_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_profile_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_profile_set_property;
	G_OBJECT_CLASS (klass)->constructor = profile_constructor;
	G_OBJECT_CLASS (klass)->finalize = profile_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PROFILE_PROFILE_CHANGED_PROPERTY, profile_properties[PROFILE_PROFILE_CHANGED_PROPERTY] = g_param_spec_boolean ("profileChanged", "profileChanged", "profileChanged", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
profile_instance_init (Profile * self,
                       gpointer klass)
{
	self->priv = profile_get_instance_private (self);
	self->priv->_profileChanged = FALSE;
}

static void
profile_finalize (GObject * obj)
{
	Profile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROFILE, Profile);
	_g_key_file_unref0 (self->priv->keyFile);
	G_OBJECT_CLASS (profile_parent_class)->finalize (obj);
}

static GType
profile_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ProfileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) profile_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Profile), 0, (GInstanceInitFunc) profile_instance_init, NULL };
	GType profile_type_id;
	profile_type_id = g_type_register_static (G_TYPE_OBJECT, "Profile", &g_define_type_info, 0);
	Profile_private_offset = g_type_add_instance_private (profile_type_id, sizeof (ProfilePrivate));
	return profile_type_id;
}

GType
profile_get_type (void)
{
	static volatile gsize profile_type_id__volatile = 0;
	if (g_once_init_enter (&profile_type_id__volatile)) {
		GType profile_type_id;
		profile_type_id = profile_get_type_once ();
		g_once_init_leave (&profile_type_id__volatile, profile_type_id);
	}
	return profile_type_id__volatile;
}

static void
_vala_profile_get_property (GObject * object,
                            guint property_id,
                            GValue * value,
                            GParamSpec * pspec)
{
	Profile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PROFILE, Profile);
	switch (property_id) {
		case PROFILE_PROFILE_CHANGED_PROPERTY:
		g_value_set_boolean (value, profile_get_profileChanged (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_profile_set_property (GObject * object,
                            guint property_id,
                            const GValue * value,
                            GParamSpec * pspec)
{
	Profile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PROFILE, Profile);
	switch (property_id) {
		case PROFILE_PROFILE_CHANGED_PROPERTY:
		profile_set_profileChanged (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

