/* Rzwrapper.c generated by valac 0.48.17, the Vala compiler
 * generated from Rzwrapper.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */
/* Class for communicating with the rz program*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <gtk/gtk.h>

#define MOSERIAL_TYPE_RZWRAPPER (moserial_rzwrapper_get_type ())
#define MOSERIAL_RZWRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_RZWRAPPER, moserialRzwrapper))
#define MOSERIAL_RZWRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_RZWRAPPER, moserialRzwrapperClass))
#define MOSERIAL_IS_RZWRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_RZWRAPPER))
#define MOSERIAL_IS_RZWRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_RZWRAPPER))
#define MOSERIAL_RZWRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_RZWRAPPER, moserialRzwrapperClass))

typedef struct _moserialRzwrapper moserialRzwrapper;
typedef struct _moserialRzwrapperClass moserialRzwrapperClass;
typedef struct _moserialRzwrapperPrivate moserialRzwrapperPrivate;
typedef enum  {
	MOSERIAL_RZWRAPPER_PROTOCOL_XMODEM,
	MOSERIAL_RZWRAPPER_PROTOCOL_YMODEM,
	MOSERIAL_RZWRAPPER_PROTOCOL_ZMODEM,
	MOSERIAL_RZWRAPPER_PROTOCOL_NULL
} moserialRzwrapperProtocol;

#define MOSERIAL_RZWRAPPER_TYPE_PROTOCOL (moserial_rzwrapper_protocol_get_type ())

#define MOSERIAL_TYPE_SERIAL_CONNECTION (moserial_serial_connection_get_type ())
#define MOSERIAL_SERIAL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnection))
#define MOSERIAL_SERIAL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionClass))
#define MOSERIAL_IS_SERIAL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION))
#define MOSERIAL_IS_SERIAL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SERIAL_CONNECTION))
#define MOSERIAL_SERIAL_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionClass))

typedef struct _moserialSerialConnection moserialSerialConnection;
typedef struct _moserialSerialConnectionClass moserialSerialConnectionClass;
enum  {
	MOSERIAL_RZWRAPPER_0_PROPERTY,
	MOSERIAL_RZWRAPPER_PROTOCOL_PROPERTY,
	MOSERIAL_RZWRAPPER_SC_PROPERTY,
	MOSERIAL_RZWRAPPER_PATH_PROPERTY,
	MOSERIAL_RZWRAPPER_FILENAME_PROPERTY,
	MOSERIAL_RZWRAPPER_NUM_PROPERTIES
};
static GParamSpec* moserial_rzwrapper_properties[MOSERIAL_RZWRAPPER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	MOSERIAL_RZWRAPPER_TRANSFER_COMPLETE_SIGNAL,
	MOSERIAL_RZWRAPPER_UPDATE_STATUS_SIGNAL,
	MOSERIAL_RZWRAPPER_NUM_SIGNALS
};
static guint moserial_rzwrapper_signals[MOSERIAL_RZWRAPPER_NUM_SIGNALS] = {0};

struct _moserialRzwrapper {
	GObject parent_instance;
	moserialRzwrapperPrivate * priv;
	gboolean running;
};

struct _moserialRzwrapperClass {
	GObjectClass parent_class;
};

struct _moserialRzwrapperPrivate {
	moserialRzwrapperProtocol _protocol;
	moserialSerialConnection* _sc;
	GIOChannel* IOChannelInput;
	GIOChannel* IOChannelOutput;
	GIOChannel* IOChannelError;
	guint outputChannelId;
	guint errorChannelId;
	GPid pid;
	gchar* _path;
	gchar* _filename;
};

static gint moserialRzwrapper_private_offset;
static gpointer moserial_rzwrapper_parent_class = NULL;

GType moserial_rzwrapper_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (moserialRzwrapper, g_object_unref)
GType moserial_rzwrapper_protocol_get_type (void) G_GNUC_CONST;
GType moserial_serial_connection_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (moserialSerialConnection, g_object_unref)
moserialRzwrapper* moserial_rzwrapper_new (moserialRzwrapperProtocol* protocol,
                                           moserialSerialConnection* sc,
                                           const gchar* p,
                                           const gchar* filename);
moserialRzwrapper* moserial_rzwrapper_construct (GType object_type,
                                                 moserialRzwrapperProtocol* protocol,
                                                 moserialSerialConnection* sc,
                                                 const gchar* p,
                                                 const gchar* filename);
void moserial_rzwrapper_writeChar (moserialRzwrapper* self,
                                   guchar byte);
static void moserial_rzwrapper_shutdown (moserialRzwrapper* self);
void moserial_rzwrapper_flush (moserialRzwrapper* self);
static gboolean moserial_rzwrapper_readError (moserialRzwrapper* self,
                                       GIOChannel* source,
                                       GIOCondition condition);
gchar* mo_utils_getLastMessage (const gchar* messages);
void moserial_rzwrapper_transferCanceled (moserialRzwrapper* self,
                                          GObject* o);
moserialRzwrapperProtocol moserial_rzwrapper_get_protocol (moserialRzwrapper* self);
moserialSerialConnection* moserial_rzwrapper_get_sc (moserialRzwrapper* self);
void moserial_serial_connection_sendByte (moserialSerialConnection* self,
                                          guchar byte);
static gboolean moserial_rzwrapper_shutdown_timeout (moserialRzwrapper* self);
static gboolean _moserial_rzwrapper_shutdown_timeout_gsource_func (gpointer self);
static gboolean moserial_rzwrapper_readBytes (moserialRzwrapper* self,
                                       GIOChannel* source,
                                       GIOCondition condition);
static void moserial_rzwrapper_set_protocol (moserialRzwrapper* self,
                                      moserialRzwrapperProtocol value);
static void moserial_rzwrapper_set_sc (moserialRzwrapper* self,
                                moserialSerialConnection* value);
const gchar* moserial_rzwrapper_get_path (moserialRzwrapper* self);
static void moserial_rzwrapper_set_path (moserialRzwrapper* self,
                                  const gchar* value);
const gchar* moserial_rzwrapper_get_filename (moserialRzwrapper* self);
static void moserial_rzwrapper_set_filename (moserialRzwrapper* self,
                                      const gchar* value);
static GObject * moserial_rzwrapper_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static gboolean _moserial_rzwrapper_readBytes_gio_func (GIOChannel* source,
                                                 GIOCondition condition,
                                                 gpointer self);
static gboolean _moserial_rzwrapper_readError_gio_func (GIOChannel* source,
                                                 GIOCondition condition,
                                                 gpointer self);
static void moserial_rzwrapper_finalize (GObject * obj);
static GType moserial_rzwrapper_get_type_once (void);
static void _vala_moserial_rzwrapper_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_moserial_rzwrapper_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

const gchar* MOSERIAL_RZWRAPPER_ProtocolStrings[3] = {N_ ("Xmodem"), N_ ("Ymodem"), N_ ("Zmodem")};

static inline gpointer
moserial_rzwrapper_get_instance_private (moserialRzwrapper* self)
{
	return G_STRUCT_MEMBER_P (self, moserialRzwrapper_private_offset);
}

static GType
moserial_rzwrapper_protocol_get_type_once (void)
{
	static const GEnumValue values[] = {{MOSERIAL_RZWRAPPER_PROTOCOL_XMODEM, "MOSERIAL_RZWRAPPER_PROTOCOL_XMODEM", "xmodem"}, {MOSERIAL_RZWRAPPER_PROTOCOL_YMODEM, "MOSERIAL_RZWRAPPER_PROTOCOL_YMODEM", "ymodem"}, {MOSERIAL_RZWRAPPER_PROTOCOL_ZMODEM, "MOSERIAL_RZWRAPPER_PROTOCOL_ZMODEM", "zmodem"}, {MOSERIAL_RZWRAPPER_PROTOCOL_NULL, "MOSERIAL_RZWRAPPER_PROTOCOL_NULL", "null"}, {0, NULL, NULL}};
	GType moserial_rzwrapper_protocol_type_id;
	moserial_rzwrapper_protocol_type_id = g_enum_register_static ("moserialRzwrapperProtocol", values);
	return moserial_rzwrapper_protocol_type_id;
}

GType
moserial_rzwrapper_protocol_get_type (void)
{
	static volatile gsize moserial_rzwrapper_protocol_type_id__volatile = 0;
	if (g_once_init_enter (&moserial_rzwrapper_protocol_type_id__volatile)) {
		GType moserial_rzwrapper_protocol_type_id;
		moserial_rzwrapper_protocol_type_id = moserial_rzwrapper_protocol_get_type_once ();
		g_once_init_leave (&moserial_rzwrapper_protocol_type_id__volatile, moserial_rzwrapper_protocol_type_id);
	}
	return moserial_rzwrapper_protocol_type_id__volatile;
}

moserialRzwrapper*
moserial_rzwrapper_construct (GType object_type,
                              moserialRzwrapperProtocol* protocol,
                              moserialSerialConnection* sc,
                              const gchar* p,
                              const gchar* filename)
{
	moserialRzwrapper * self = NULL;
	moserialRzwrapperProtocol pro = 0;
	pro = *protocol;
	self = (moserialRzwrapper*) g_object_new (object_type, "protocol", pro, "sc", sc, "path", p, "filename", filename, NULL);
	return self;
}

moserialRzwrapper*
moserial_rzwrapper_new (moserialRzwrapperProtocol* protocol,
                        moserialSerialConnection* sc,
                        const gchar* p,
                        const gchar* filename)
{
	return moserial_rzwrapper_construct (MOSERIAL_TYPE_RZWRAPPER, protocol, sc, p, filename);
}

void
moserial_rzwrapper_writeChar (moserialRzwrapper* self,
                              guchar byte)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->running) {
		gsize bytesWritten = 0UL;
		gchar* b = NULL;
		gchar* _tmp0_;
		gint b_length1;
		gint _b_size_;
		gchar* _tmp1_;
		gint _tmp1__length1;
		_tmp0_ = g_new0 (gchar, 1);
		b = _tmp0_;
		b_length1 = 1;
		_b_size_ = b_length1;
		_tmp1_ = b;
		_tmp1__length1 = b_length1;
		_tmp1_[0] = (gchar) byte;
		{
			if (self->running) {
				GIOChannel* _tmp2_;
				gchar* _tmp3_;
				gint _tmp3__length1;
				gsize _tmp4_ = 0UL;
				_tmp2_ = self->priv->IOChannelInput;
				_tmp3_ = b;
				_tmp3__length1 = b_length1;
				g_io_channel_write_chars (_tmp2_, _tmp3_, (gint) _tmp3__length1, &_tmp4_, &_inner_error0_);
				bytesWritten = _tmp4_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == G_IO_CHANNEL_ERROR) {
						goto __catch0_g_io_channel_error;
					}
					if (_inner_error0_->domain == G_CONVERT_ERROR) {
						goto __catch0_g_convert_error;
					}
					b = (g_free (b), NULL);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		}
		goto __finally0;
		__catch0_g_io_channel_error:
		{
			GError* e = NULL;
			FILE* _tmp5_;
			GError* _tmp6_;
			const gchar* _tmp7_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			moserial_rzwrapper_shutdown (self);
			_tmp5_ = stdout;
			_tmp6_ = e;
			_tmp7_ = _tmp6_->message;
			fprintf (_tmp5_, "writeChar() %s\n", _tmp7_);
			_g_error_free0 (e);
		}
		goto __finally0;
		__catch0_g_convert_error:
		{
			GError* e = NULL;
			FILE* _tmp8_;
			GError* _tmp9_;
			const gchar* _tmp10_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp8_ = stdout;
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			fprintf (_tmp8_, "%s\n", _tmp10_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			b = (g_free (b), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		b = (g_free (b), NULL);
	}
}

void
moserial_rzwrapper_flush (moserialRzwrapper* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->running) {
		{
			if (self->running) {
				GIOChannel* _tmp0_;
				_tmp0_ = self->priv->IOChannelInput;
				g_io_channel_flush (_tmp0_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == G_IO_CHANNEL_ERROR) {
						goto __catch0_g_io_channel_error;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		}
		goto __finally0;
		__catch0_g_io_channel_error:
		{
			GError* e = NULL;
			FILE* _tmp1_;
			GError* _tmp2_;
			const gchar* _tmp3_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			moserial_rzwrapper_shutdown (self);
			_tmp1_ = stdout;
			_tmp2_ = e;
			_tmp3_ = _tmp2_->message;
			fprintf (_tmp1_, "flush() %s\n", _tmp3_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gboolean
moserial_rzwrapper_readError (moserialRzwrapper* self,
                              GIOChannel* source,
                              GIOCondition condition)
{
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	if (self->running) {
		gchar* m_buf = NULL;
		gchar* _tmp0_;
		gint m_buf_length1;
		gint _m_buf_size_;
		gchar* message = NULL;
		gchar* _tmp1_;
		gchar* messages = NULL;
		gchar* _tmp2_;
		gsize bytesRead = 0UL;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		_tmp0_ = g_new0 (gchar, 1000);
		m_buf = _tmp0_;
		m_buf_length1 = 1000;
		_m_buf_size_ = m_buf_length1;
		_tmp1_ = g_strdup ("");
		message = _tmp1_;
		_tmp2_ = g_strdup ("");
		messages = _tmp2_;
		bytesRead = (gsize) 0;
		if (!(condition == G_IO_IN)) {
			result = TRUE;
			_g_free0 (messages);
			_g_free0 (message);
			m_buf = (g_free (m_buf), NULL);
			return result;
		}
		{
			gchar* _tmp3_;
			gint _tmp3__length1;
			gsize _tmp4_ = 0UL;
			_tmp3_ = m_buf;
			_tmp3__length1 = m_buf_length1;
			g_io_channel_read_chars (source, _tmp3_, (gint) _tmp3__length1, &_tmp4_, &_inner_error0_);
			bytesRead = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp5_ = FALSE;
				if (_inner_error0_->domain == G_CONVERT_ERROR) {
					goto __catch0_g_convert_error;
				}
				if (_inner_error0_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch0_g_io_channel_error;
				}
				_g_free0 (messages);
				_g_free0 (message);
				m_buf = (g_free (m_buf), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp5_;
			}
		}
		goto __finally0;
		__catch0_g_convert_error:
		{
			GError* e = NULL;
			FILE* _tmp6_;
			GError* _tmp7_;
			const gchar* _tmp8_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp6_ = stdout;
			_tmp7_ = e;
			_tmp8_ = _tmp7_->message;
			fprintf (_tmp6_, "readError() %s\n", _tmp8_);
			_g_error_free0 (e);
		}
		goto __finally0;
		__catch0_g_io_channel_error:
		{
			GError* e = NULL;
			FILE* _tmp9_;
			GError* _tmp10_;
			const gchar* _tmp11_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp9_ = stdout;
			_tmp10_ = e;
			_tmp11_ = _tmp10_->message;
			fprintf (_tmp9_, "readError() %s\n", _tmp11_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp12_ = FALSE;
			_g_free0 (messages);
			_g_free0 (message);
			m_buf = (g_free (m_buf), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp12_;
		}
		{
			gint x = 0;
			x = 0;
			{
				gboolean _tmp13_ = FALSE;
				_tmp13_ = TRUE;
				while (TRUE) {
					gunichar c = 0U;
					gchar* _tmp15_;
					gint _tmp15__length1;
					gchar _tmp16_;
					gboolean _tmp17_ = FALSE;
					if (!_tmp13_) {
						gint _tmp14_;
						_tmp14_ = x;
						x = _tmp14_ + 1;
					}
					_tmp13_ = FALSE;
					if (!(((gsize) x) < bytesRead)) {
						break;
					}
					_tmp15_ = m_buf;
					_tmp15__length1 = m_buf_length1;
					_tmp16_ = _tmp15_[x];
					c = (gunichar) _tmp16_;
					if (g_unichar_isprint (c)) {
						_tmp17_ = TRUE;
					} else {
						_tmp17_ = g_unichar_isspace (c);
					}
					if (_tmp17_) {
						const gchar* _tmp18_;
						gchar* _tmp19_;
						gint _tmp19__length1;
						gchar _tmp20_;
						gchar* _tmp21_;
						gchar* _tmp22_;
						gchar* _tmp23_;
						_tmp18_ = messages;
						_tmp19_ = m_buf;
						_tmp19__length1 = m_buf_length1;
						_tmp20_ = _tmp19_[x];
						_tmp21_ = g_strdup_printf ("%c", (gint) _tmp20_);
						_tmp22_ = _tmp21_;
						_tmp23_ = g_strconcat (_tmp18_, _tmp22_, NULL);
						_g_free0 (messages);
						messages = _tmp23_;
						_g_free0 (_tmp22_);
					}
				}
			}
		}
		_tmp24_ = messages;
		_tmp25_ = mo_utils_getLastMessage (_tmp24_);
		_g_free0 (message);
		message = _tmp25_;
		_tmp26_ = message;
		if (!(g_strcmp0 (_tmp26_, "") == 0)) {
			const gchar* _tmp27_;
			_tmp27_ = message;
			g_signal_emit (self, moserial_rzwrapper_signals[MOSERIAL_RZWRAPPER_UPDATE_STATUS_SIGNAL], 0, _tmp27_);
		}
		_tmp28_ = messages;
		if (string_index_of (_tmp28_, "Transfer complete", 0) >= 0) {
			moserial_rzwrapper_shutdown (self);
		}
		_tmp29_ = messages;
		if (string_index_of (_tmp29_, "Transfer incomplete", 0) >= 0) {
			moserial_rzwrapper_shutdown (self);
		}
		result = TRUE;
		_g_free0 (messages);
		_g_free0 (message);
		m_buf = (g_free (m_buf), NULL);
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static gboolean
_moserial_rzwrapper_shutdown_timeout_gsource_func (gpointer self)
{
	gboolean result;
	result = moserial_rzwrapper_shutdown_timeout ((moserialRzwrapper*) self);
	return result;
}

void
moserial_rzwrapper_transferCanceled (moserialRzwrapper* self,
                                     GObject* o)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	if (self->running) {
		g_signal_emit (self, moserial_rzwrapper_signals[MOSERIAL_RZWRAPPER_UPDATE_STATUS_SIGNAL], 0, "canceled");
		{
			gint x = 0;
			x = 0;
			{
				gboolean _tmp0_ = FALSE;
				_tmp0_ = TRUE;
				while (TRUE) {
					moserialRzwrapperProtocol _tmp2_;
					if (!_tmp0_) {
						gint _tmp1_;
						_tmp1_ = x;
						x = _tmp1_ + 1;
					}
					_tmp0_ = FALSE;
					if (!(x < 20)) {
						break;
					}
					_tmp2_ = self->priv->_protocol;
					if (_tmp2_ == MOSERIAL_RZWRAPPER_PROTOCOL_ZMODEM) {
						moserialSerialConnection* _tmp3_;
						_tmp3_ = self->priv->_sc;
						moserial_serial_connection_sendByte (_tmp3_, (guchar) ('X' & 037));
						moserial_rzwrapper_writeChar (self, (guchar) ('X' & 037));
					} else {
						moserialSerialConnection* _tmp4_;
						_tmp4_ = self->priv->_sc;
						moserial_serial_connection_sendByte (_tmp4_, (guchar) 0x18);
					}
				}
			}
		}
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 2000, _moserial_rzwrapper_shutdown_timeout_gsource_func, g_object_ref (self), g_object_unref);
	}
}

static gboolean
moserial_rzwrapper_shutdown_timeout (moserialRzwrapper* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	moserial_rzwrapper_shutdown (self);
	result = FALSE;
	return result;
}

static void
moserial_rzwrapper_shutdown (moserialRzwrapper* self)
{
	g_return_if_fail (self != NULL);
	if (self->running) {
		self->running = FALSE;
		g_source_remove (self->priv->outputChannelId);
		g_source_remove (self->priv->errorChannelId);
		g_spawn_close_pid (self->priv->pid);
		g_signal_emit (self, moserial_rzwrapper_signals[MOSERIAL_RZWRAPPER_TRANSFER_COMPLETE_SIGNAL], 0);
	}
}

static gboolean
moserial_rzwrapper_readBytes (moserialRzwrapper* self,
                              GIOChannel* source,
                              GIOCondition condition)
{
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	if (self->running) {
		gchar* m_buf = NULL;
		gchar* _tmp0_;
		gint m_buf_length1;
		gint _m_buf_size_;
		gsize bytesRead = 0UL;
		_tmp0_ = g_new0 (gchar, 1000);
		m_buf = _tmp0_;
		m_buf_length1 = 1000;
		_m_buf_size_ = m_buf_length1;
		bytesRead = (gsize) 0;
		if (!(condition == G_IO_IN)) {
			result = TRUE;
			m_buf = (g_free (m_buf), NULL);
			return result;
		}
		{
			gchar* _tmp1_;
			gint _tmp1__length1;
			gsize _tmp2_ = 0UL;
			_tmp1_ = m_buf;
			_tmp1__length1 = m_buf_length1;
			g_io_channel_read_chars (source, _tmp1_, (gint) _tmp1__length1, &_tmp2_, &_inner_error0_);
			bytesRead = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp3_ = FALSE;
				if (_inner_error0_->domain == G_CONVERT_ERROR) {
					goto __catch0_g_convert_error;
				}
				if (_inner_error0_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch0_g_io_channel_error;
				}
				m_buf = (g_free (m_buf), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp3_;
			}
		}
		goto __finally0;
		__catch0_g_convert_error:
		{
			GError* e = NULL;
			FILE* _tmp4_;
			GError* _tmp5_;
			const gchar* _tmp6_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp4_ = stdout;
			_tmp5_ = e;
			_tmp6_ = _tmp5_->message;
			fprintf (_tmp4_, "readBytes() %s\n", _tmp6_);
			_g_error_free0 (e);
		}
		goto __finally0;
		__catch0_g_io_channel_error:
		{
			GError* e = NULL;
			FILE* _tmp7_;
			GError* _tmp8_;
			const gchar* _tmp9_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp7_ = stdout;
			_tmp8_ = e;
			_tmp9_ = _tmp8_->message;
			fprintf (_tmp7_, "readError() %s\n", _tmp9_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp10_ = FALSE;
			m_buf = (g_free (m_buf), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp10_;
		}
		{
			gint x = 0;
			x = 0;
			{
				gboolean _tmp11_ = FALSE;
				_tmp11_ = TRUE;
				while (TRUE) {
					moserialSerialConnection* _tmp13_;
					gchar* _tmp14_;
					gint _tmp14__length1;
					gchar _tmp15_;
					if (!_tmp11_) {
						gint _tmp12_;
						_tmp12_ = x;
						x = _tmp12_ + 1;
					}
					_tmp11_ = FALSE;
					if (!(((gsize) x) < bytesRead)) {
						break;
					}
					_tmp13_ = self->priv->_sc;
					_tmp14_ = m_buf;
					_tmp14__length1 = m_buf_length1;
					_tmp15_ = _tmp14_[x];
					moserial_serial_connection_sendByte (_tmp13_, (guchar) _tmp15_);
				}
			}
		}
		result = TRUE;
		m_buf = (g_free (m_buf), NULL);
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

moserialRzwrapperProtocol
moserial_rzwrapper_get_protocol (moserialRzwrapper* self)
{
	moserialRzwrapperProtocol result;
	moserialRzwrapperProtocol _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_protocol;
	result = _tmp0_;
	return result;
}

static void
moserial_rzwrapper_set_protocol (moserialRzwrapper* self,
                                 moserialRzwrapperProtocol value)
{
	moserialRzwrapperProtocol old_value;
	g_return_if_fail (self != NULL);
	old_value = moserial_rzwrapper_get_protocol (self);
	if (old_value != value) {
		self->priv->_protocol = value;
		g_object_notify_by_pspec ((GObject *) self, moserial_rzwrapper_properties[MOSERIAL_RZWRAPPER_PROTOCOL_PROPERTY]);
	}
}

moserialSerialConnection*
moserial_rzwrapper_get_sc (moserialRzwrapper* self)
{
	moserialSerialConnection* result;
	moserialSerialConnection* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sc;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
moserial_rzwrapper_set_sc (moserialRzwrapper* self,
                           moserialSerialConnection* value)
{
	moserialSerialConnection* old_value;
	g_return_if_fail (self != NULL);
	old_value = moserial_rzwrapper_get_sc (self);
	if (old_value != value) {
		moserialSerialConnection* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_sc);
		self->priv->_sc = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, moserial_rzwrapper_properties[MOSERIAL_RZWRAPPER_SC_PROPERTY]);
	}
}

const gchar*
moserial_rzwrapper_get_path (moserialRzwrapper* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_path;
	result = _tmp0_;
	return result;
}

static void
moserial_rzwrapper_set_path (moserialRzwrapper* self,
                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = moserial_rzwrapper_get_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_path);
		self->priv->_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, moserial_rzwrapper_properties[MOSERIAL_RZWRAPPER_PATH_PROPERTY]);
	}
}

const gchar*
moserial_rzwrapper_get_filename (moserialRzwrapper* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_filename;
	result = _tmp0_;
	return result;
}

static void
moserial_rzwrapper_set_filename (moserialRzwrapper* self,
                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = moserial_rzwrapper_get_filename (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_filename);
		self->priv->_filename = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, moserial_rzwrapper_properties[MOSERIAL_RZWRAPPER_FILENAME_PROPERTY]);
	}
}

static gboolean
_moserial_rzwrapper_readBytes_gio_func (GIOChannel* source,
                                        GIOCondition condition,
                                        gpointer self)
{
	gboolean result;
	result = moserial_rzwrapper_readBytes ((moserialRzwrapper*) self, source, condition);
	return result;
}

static gboolean
_moserial_rzwrapper_readError_gio_func (GIOChannel* source,
                                        GIOCondition condition,
                                        gpointer self)
{
	gboolean result;
	result = moserial_rzwrapper_readError ((moserialRzwrapper*) self, source, condition);
	return result;
}

static GObject *
moserial_rzwrapper_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	moserialRzwrapper * self;
	gboolean _tmp0_ = FALSE;
	moserialRzwrapperProtocol _tmp1_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (moserial_rzwrapper_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MOSERIAL_TYPE_RZWRAPPER, moserialRzwrapper);
	_tmp1_ = self->priv->_protocol;
	if (_tmp1_ == MOSERIAL_RZWRAPPER_PROTOCOL_NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->_path;
		_tmp0_ = _tmp2_ == NULL;
	}
	if (_tmp0_) {
		self->running = FALSE;
	} else {
		gchar** argv = NULL;
		gint argv_length1 = 0;
		gint _argv_size_ = 0;
		moserialRzwrapperProtocol _tmp3_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		gchar* _tmp7_;
		moserialRzwrapperProtocol _tmp8_;
		gchar** _tmp15_;
		gint _tmp15__length1;
		gchar* _tmp16_;
		moserialRzwrapperProtocol _tmp17_;
		gint output = 0;
		gint _error_ = 0;
		gint input = 0;
		_tmp3_ = self->priv->_protocol;
		if (_tmp3_ == MOSERIAL_RZWRAPPER_PROTOCOL_XMODEM) {
			gchar** _tmp4_;
			_tmp4_ = g_new0 (gchar*, 4 + 1);
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			argv = _tmp4_;
			argv_length1 = 4;
			_argv_size_ = argv_length1;
		} else {
			gchar** _tmp5_;
			_tmp5_ = g_new0 (gchar*, 3 + 1);
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			argv = _tmp5_;
			argv_length1 = 3;
			_argv_size_ = argv_length1;
		}
		_tmp6_ = argv;
		_tmp6__length1 = argv_length1;
		_tmp7_ = g_strdup ("rz");
		_g_free0 (_tmp6_[0]);
		_tmp6_[0] = _tmp7_;
		_tmp8_ = self->priv->_protocol;
		switch (_tmp8_) {
			case MOSERIAL_RZWRAPPER_PROTOCOL_XMODEM:
			{
				gchar** _tmp9_;
				gint _tmp9__length1;
				gchar* _tmp10_;
				_tmp9_ = argv;
				_tmp9__length1 = argv_length1;
				_tmp10_ = g_strdup ("--xmodem");
				_g_free0 (_tmp9_[1]);
				_tmp9_[1] = _tmp10_;
				break;
			}
			case MOSERIAL_RZWRAPPER_PROTOCOL_YMODEM:
			{
				gchar** _tmp11_;
				gint _tmp11__length1;
				gchar* _tmp12_;
				_tmp11_ = argv;
				_tmp11__length1 = argv_length1;
				_tmp12_ = g_strdup ("--ymodem");
				_g_free0 (_tmp11_[1]);
				_tmp11_[1] = _tmp12_;
				break;
			}
			default:
			case MOSERIAL_RZWRAPPER_PROTOCOL_ZMODEM:
			{
				gchar** _tmp13_;
				gint _tmp13__length1;
				gchar* _tmp14_;
				_tmp13_ = argv;
				_tmp13__length1 = argv_length1;
				_tmp14_ = g_strdup ("--zmodem");
				_g_free0 (_tmp13_[1]);
				_tmp13_[1] = _tmp14_;
				break;
			}
		}
		_tmp15_ = argv;
		_tmp15__length1 = argv_length1;
		_tmp16_ = g_strdup ("-vv");
		_g_free0 (_tmp15_[2]);
		_tmp15_[2] = _tmp16_;
		_tmp17_ = self->priv->_protocol;
		if (_tmp17_ == MOSERIAL_RZWRAPPER_PROTOCOL_XMODEM) {
			gchar** _tmp18_;
			gint _tmp18__length1;
			const gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp18_ = argv;
			_tmp18__length1 = argv_length1;
			_tmp19_ = self->priv->_filename;
			_tmp20_ = g_strdup (_tmp19_);
			_g_free0 (_tmp18_[3]);
			_tmp18_[3] = _tmp20_;
		}
		{
			const gchar* _tmp21_;
			gchar** _tmp22_;
			gint _tmp22__length1;
			GPid _tmp23_ = 0;
			gint _tmp24_ = 0;
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
			GIOChannel* _tmp27_;
			GIOChannel* _tmp28_;
			GIOChannel* _tmp29_;
			GIOChannel* _tmp30_;
			GIOChannel* _tmp31_;
			GIOChannel* _tmp32_;
			GIOChannel* _tmp33_;
			GIOChannel* _tmp34_;
			GIOChannel* _tmp35_;
			GIOChannel* _tmp36_;
			_tmp21_ = self->priv->_path;
			_tmp22_ = argv;
			_tmp22__length1 = argv_length1;
			g_spawn_async_with_pipes (_tmp21_, _tmp22_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp23_, &_tmp24_, &_tmp25_, &_tmp26_, &_inner_error0_);
			self->priv->pid = _tmp23_;
			input = _tmp24_;
			output = _tmp25_;
			_error_ = _tmp26_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_SPAWN_ERROR) {
					goto __catch0_g_spawn_error;
				}
				if (_inner_error0_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch0_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
			}
			_tmp27_ = g_io_channel_unix_new (output);
			_g_io_channel_unref0 (self->priv->IOChannelOutput);
			self->priv->IOChannelOutput = _tmp27_;
			_tmp28_ = g_io_channel_unix_new (input);
			_g_io_channel_unref0 (self->priv->IOChannelInput);
			self->priv->IOChannelInput = _tmp28_;
			_tmp29_ = g_io_channel_unix_new (_error_);
			_g_io_channel_unref0 (self->priv->IOChannelError);
			self->priv->IOChannelError = _tmp29_;
			_tmp30_ = self->priv->IOChannelOutput;
			g_io_channel_set_encoding (_tmp30_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_SPAWN_ERROR) {
					goto __catch0_g_spawn_error;
				}
				if (_inner_error0_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch0_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
			}
			_tmp31_ = self->priv->IOChannelOutput;
			g_io_channel_set_flags (_tmp31_, G_IO_FLAG_NONBLOCK, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_SPAWN_ERROR) {
					goto __catch0_g_spawn_error;
				}
				if (_inner_error0_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch0_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
			}
			_tmp32_ = self->priv->IOChannelError;
			g_io_channel_set_encoding (_tmp32_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_SPAWN_ERROR) {
					goto __catch0_g_spawn_error;
				}
				if (_inner_error0_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch0_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
			}
			_tmp33_ = self->priv->IOChannelError;
			g_io_channel_set_flags (_tmp33_, G_IO_FLAG_NONBLOCK, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_SPAWN_ERROR) {
					goto __catch0_g_spawn_error;
				}
				if (_inner_error0_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch0_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
			}
			_tmp34_ = self->priv->IOChannelInput;
			g_io_channel_set_encoding (_tmp34_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_SPAWN_ERROR) {
					goto __catch0_g_spawn_error;
				}
				if (_inner_error0_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch0_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
			}
			_tmp35_ = self->priv->IOChannelOutput;
			self->priv->outputChannelId = g_io_add_watch (_tmp35_, G_IO_IN, _moserial_rzwrapper_readBytes_gio_func, self);
			_tmp36_ = self->priv->IOChannelError;
			self->priv->errorChannelId = g_io_add_watch (_tmp36_, G_IO_IN, _moserial_rzwrapper_readError_gio_func, self);
			self->running = TRUE;
		}
		goto __finally0;
		__catch0_g_spawn_error:
		{
			GError* e = NULL;
			FILE* _tmp37_;
			GError* _tmp38_;
			const gchar* _tmp39_;
			GtkMessageDialog* errorDialog = NULL;
			GError* _tmp40_;
			const gchar* _tmp41_;
			GtkMessageDialog* _tmp42_;
			GtkMessageDialog* _tmp43_;
			GtkMessageDialog* _tmp44_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			self->running = FALSE;
			_tmp37_ = stdout;
			_tmp38_ = e;
			_tmp39_ = _tmp38_->message;
			fprintf (_tmp37_, "spawn error: %s\n", _tmp39_);
			_tmp40_ = e;
			_tmp41_ = _tmp40_->message;
			_tmp42_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s", _tmp41_);
			g_object_ref_sink (_tmp42_);
			errorDialog = _tmp42_;
			_tmp43_ = errorDialog;
			gtk_dialog_run ((GtkDialog*) _tmp43_);
			_tmp44_ = errorDialog;
			gtk_widget_destroy ((GtkWidget*) _tmp44_);
			_g_object_unref0 (errorDialog);
			_g_error_free0 (e);
		}
		goto __finally0;
		__catch0_g_io_channel_error:
		{
			GError* e = NULL;
			FILE* _tmp45_;
			GError* _tmp46_;
			const gchar* _tmp47_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp45_ = stdout;
			_tmp46_ = e;
			_tmp47_ = _tmp46_->message;
			fprintf (_tmp45_, "readError() %s\n", _tmp47_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	}
	return obj;
}

static void
moserial_rzwrapper_class_init (moserialRzwrapperClass * klass,
                               gpointer klass_data)
{
	moserial_rzwrapper_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &moserialRzwrapper_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_moserial_rzwrapper_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_moserial_rzwrapper_set_property;
	G_OBJECT_CLASS (klass)->constructor = moserial_rzwrapper_constructor;
	G_OBJECT_CLASS (klass)->finalize = moserial_rzwrapper_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_RZWRAPPER_PROTOCOL_PROPERTY, moserial_rzwrapper_properties[MOSERIAL_RZWRAPPER_PROTOCOL_PROPERTY] = g_param_spec_enum ("protocol", "protocol", "protocol", MOSERIAL_RZWRAPPER_TYPE_PROTOCOL, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_RZWRAPPER_SC_PROPERTY, moserial_rzwrapper_properties[MOSERIAL_RZWRAPPER_SC_PROPERTY] = g_param_spec_object ("sc", "sc", "sc", MOSERIAL_TYPE_SERIAL_CONNECTION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_RZWRAPPER_PATH_PROPERTY, moserial_rzwrapper_properties[MOSERIAL_RZWRAPPER_PATH_PROPERTY] = g_param_spec_string ("path", "path", "path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_RZWRAPPER_FILENAME_PROPERTY, moserial_rzwrapper_properties[MOSERIAL_RZWRAPPER_FILENAME_PROPERTY] = g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	moserial_rzwrapper_signals[MOSERIAL_RZWRAPPER_TRANSFER_COMPLETE_SIGNAL] = g_signal_new ("transfer-complete", MOSERIAL_TYPE_RZWRAPPER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	moserial_rzwrapper_signals[MOSERIAL_RZWRAPPER_UPDATE_STATUS_SIGNAL] = g_signal_new ("update-status", MOSERIAL_TYPE_RZWRAPPER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
moserial_rzwrapper_instance_init (moserialRzwrapper * self,
                                  gpointer klass)
{
	self->priv = moserial_rzwrapper_get_instance_private (self);
	self->running = FALSE;
}

static void
moserial_rzwrapper_finalize (GObject * obj)
{
	moserialRzwrapper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MOSERIAL_TYPE_RZWRAPPER, moserialRzwrapper);
	_g_object_unref0 (self->priv->_sc);
	_g_io_channel_unref0 (self->priv->IOChannelInput);
	_g_io_channel_unref0 (self->priv->IOChannelOutput);
	_g_io_channel_unref0 (self->priv->IOChannelError);
	_g_free0 (self->priv->_path);
	_g_free0 (self->priv->_filename);
	G_OBJECT_CLASS (moserial_rzwrapper_parent_class)->finalize (obj);
}

static GType
moserial_rzwrapper_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (moserialRzwrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_rzwrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialRzwrapper), 0, (GInstanceInitFunc) moserial_rzwrapper_instance_init, NULL };
	GType moserial_rzwrapper_type_id;
	moserial_rzwrapper_type_id = g_type_register_static (G_TYPE_OBJECT, "moserialRzwrapper", &g_define_type_info, 0);
	moserialRzwrapper_private_offset = g_type_add_instance_private (moserial_rzwrapper_type_id, sizeof (moserialRzwrapperPrivate));
	return moserial_rzwrapper_type_id;
}

GType
moserial_rzwrapper_get_type (void)
{
	static volatile gsize moserial_rzwrapper_type_id__volatile = 0;
	if (g_once_init_enter (&moserial_rzwrapper_type_id__volatile)) {
		GType moserial_rzwrapper_type_id;
		moserial_rzwrapper_type_id = moserial_rzwrapper_get_type_once ();
		g_once_init_leave (&moserial_rzwrapper_type_id__volatile, moserial_rzwrapper_type_id);
	}
	return moserial_rzwrapper_type_id__volatile;
}

static void
_vala_moserial_rzwrapper_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	moserialRzwrapper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MOSERIAL_TYPE_RZWRAPPER, moserialRzwrapper);
	switch (property_id) {
		case MOSERIAL_RZWRAPPER_PROTOCOL_PROPERTY:
		g_value_set_enum (value, moserial_rzwrapper_get_protocol (self));
		break;
		case MOSERIAL_RZWRAPPER_SC_PROPERTY:
		g_value_set_object (value, moserial_rzwrapper_get_sc (self));
		break;
		case MOSERIAL_RZWRAPPER_PATH_PROPERTY:
		g_value_set_string (value, moserial_rzwrapper_get_path (self));
		break;
		case MOSERIAL_RZWRAPPER_FILENAME_PROPERTY:
		g_value_set_string (value, moserial_rzwrapper_get_filename (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_moserial_rzwrapper_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	moserialRzwrapper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MOSERIAL_TYPE_RZWRAPPER, moserialRzwrapper);
	switch (property_id) {
		case MOSERIAL_RZWRAPPER_PROTOCOL_PROPERTY:
		moserial_rzwrapper_set_protocol (self, g_value_get_enum (value));
		break;
		case MOSERIAL_RZWRAPPER_SC_PROPERTY:
		moserial_rzwrapper_set_sc (self, g_value_get_object (value));
		break;
		case MOSERIAL_RZWRAPPER_PATH_PROPERTY:
		moserial_rzwrapper_set_path (self, g_value_get_string (value));
		break;
		case MOSERIAL_RZWRAPPER_FILENAME_PROPERTY:
		moserial_rzwrapper_set_filename (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

