/* Szwrapper.c generated by valac 0.48.17, the Vala compiler
 * generated from Szwrapper.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */
/* Class for communicating with the sz program*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>

#define MOSERIAL_TYPE_SZWRAPPER (moserial_szwrapper_get_type ())
#define MOSERIAL_SZWRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SZWRAPPER, moserialSzwrapper))
#define MOSERIAL_SZWRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SZWRAPPER, moserialSzwrapperClass))
#define MOSERIAL_IS_SZWRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SZWRAPPER))
#define MOSERIAL_IS_SZWRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SZWRAPPER))
#define MOSERIAL_SZWRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SZWRAPPER, moserialSzwrapperClass))

typedef struct _moserialSzwrapper moserialSzwrapper;
typedef struct _moserialSzwrapperClass moserialSzwrapperClass;
typedef struct _moserialSzwrapperPrivate moserialSzwrapperPrivate;
typedef enum  {
	MOSERIAL_SZWRAPPER_PROTOCOL_XMODEM,
	MOSERIAL_SZWRAPPER_PROTOCOL_YMODEM,
	MOSERIAL_SZWRAPPER_PROTOCOL_ZMODEM,
	MOSERIAL_SZWRAPPER_PROTOCOL_RAW,
	MOSERIAL_SZWRAPPER_PROTOCOL_NULL
} moserialSzwrapperProtocol;

#define MOSERIAL_SZWRAPPER_TYPE_PROTOCOL (moserial_szwrapper_protocol_get_type ())

#define MOSERIAL_TYPE_SERIAL_CONNECTION (moserial_serial_connection_get_type ())
#define MOSERIAL_SERIAL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnection))
#define MOSERIAL_SERIAL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionClass))
#define MOSERIAL_IS_SERIAL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION))
#define MOSERIAL_IS_SERIAL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SERIAL_CONNECTION))
#define MOSERIAL_SERIAL_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionClass))

typedef struct _moserialSerialConnection moserialSerialConnection;
typedef struct _moserialSerialConnectionClass moserialSerialConnectionClass;
enum  {
	MOSERIAL_SZWRAPPER_0_PROPERTY,
	MOSERIAL_SZWRAPPER_PROTOCOL_PROPERTY,
	MOSERIAL_SZWRAPPER_SC_PROPERTY,
	MOSERIAL_SZWRAPPER_FILENAME_PROPERTY,
	MOSERIAL_SZWRAPPER_NUM_PROPERTIES
};
static GParamSpec* moserial_szwrapper_properties[MOSERIAL_SZWRAPPER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	MOSERIAL_SZWRAPPER_TRANSFER_COMPLETE_SIGNAL,
	MOSERIAL_SZWRAPPER_UPDATE_STATUS_SIGNAL,
	MOSERIAL_SZWRAPPER_NUM_SIGNALS
};
static guint moserial_szwrapper_signals[MOSERIAL_SZWRAPPER_NUM_SIGNALS] = {0};

struct _moserialSzwrapper {
	GObject parent_instance;
	moserialSzwrapperPrivate * priv;
	gboolean running;
};

struct _moserialSzwrapperClass {
	GObjectClass parent_class;
};

struct _moserialSzwrapperPrivate {
	moserialSzwrapperProtocol _protocol;
	moserialSerialConnection* _sc;
	GIOChannel* IOChannelInput;
	GIOChannel* IOChannelOutput;
	GIOChannel* IOChannelError;
	guint outputChannelId;
	guint errorChannelId;
	GPid pid;
	gchar* _filename;
};

static gint moserialSzwrapper_private_offset;
static gpointer moserial_szwrapper_parent_class = NULL;

GType moserial_szwrapper_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (moserialSzwrapper, g_object_unref)
GType moserial_szwrapper_protocol_get_type (void) G_GNUC_CONST;
GType moserial_serial_connection_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (moserialSerialConnection, g_object_unref)
moserialSzwrapper* moserial_szwrapper_new (moserialSzwrapperProtocol* protocol,
                                           moserialSerialConnection* sc,
                                           const gchar* filename);
moserialSzwrapper* moserial_szwrapper_construct (GType object_type,
                                                 moserialSzwrapperProtocol* protocol,
                                                 moserialSerialConnection* sc,
                                                 const gchar* filename);
void moserial_szwrapper_writeChar (moserialSzwrapper* self,
                                   guchar byte);
static void moserial_szwrapper_shutdown (moserialSzwrapper* self);
static gboolean moserial_szwrapper_readError (moserialSzwrapper* self,
                                       GIOChannel* source,
                                       GIOCondition condition);
gchar* mo_utils_getLastMessage (const gchar* messages);
static gboolean moserial_szwrapper_shutdown_timeout (moserialSzwrapper* self);
static gboolean _moserial_szwrapper_shutdown_timeout_gsource_func (gpointer self);
void moserial_szwrapper_transferCanceled (moserialSzwrapper* self,
                                          GObject* o);
moserialSzwrapperProtocol moserial_szwrapper_get_protocol (moserialSzwrapper* self);
moserialSerialConnection* moserial_szwrapper_get_sc (moserialSzwrapper* self);
void moserial_serial_connection_sendByte (moserialSerialConnection* self,
                                          guchar byte);
static gboolean moserial_szwrapper_readBytes (moserialSzwrapper* self,
                                       GIOChannel* source,
                                       GIOCondition condition);
void moserial_serial_connection_sendBytes (moserialSerialConnection* self,
                                           gchar* bytes,
                                           gint bytes_length1,
                                           gsize size);
static void moserial_szwrapper_set_protocol (moserialSzwrapper* self,
                                      moserialSzwrapperProtocol value);
static void moserial_szwrapper_set_sc (moserialSzwrapper* self,
                                moserialSerialConnection* value);
const gchar* moserial_szwrapper_get_filename (moserialSzwrapper* self);
static void moserial_szwrapper_set_filename (moserialSzwrapper* self,
                                      const gchar* value);
static GObject * moserial_szwrapper_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static gboolean _moserial_szwrapper_readBytes_gio_func (GIOChannel* source,
                                                 GIOCondition condition,
                                                 gpointer self);
static gboolean _moserial_szwrapper_readError_gio_func (GIOChannel* source,
                                                 GIOCondition condition,
                                                 gpointer self);
static void moserial_szwrapper_finalize (GObject * obj);
static GType moserial_szwrapper_get_type_once (void);
static void _vala_moserial_szwrapper_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_moserial_szwrapper_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

const gchar* MOSERIAL_SZWRAPPER_ProtocolStrings[4] = {N_ ("Xmodem"), N_ ("Ymodem"), N_ ("Zmodem"), N_ ("None (straight binary)")};

static inline gpointer
moserial_szwrapper_get_instance_private (moserialSzwrapper* self)
{
	return G_STRUCT_MEMBER_P (self, moserialSzwrapper_private_offset);
}

static GType
moserial_szwrapper_protocol_get_type_once (void)
{
	static const GEnumValue values[] = {{MOSERIAL_SZWRAPPER_PROTOCOL_XMODEM, "MOSERIAL_SZWRAPPER_PROTOCOL_XMODEM", "xmodem"}, {MOSERIAL_SZWRAPPER_PROTOCOL_YMODEM, "MOSERIAL_SZWRAPPER_PROTOCOL_YMODEM", "ymodem"}, {MOSERIAL_SZWRAPPER_PROTOCOL_ZMODEM, "MOSERIAL_SZWRAPPER_PROTOCOL_ZMODEM", "zmodem"}, {MOSERIAL_SZWRAPPER_PROTOCOL_RAW, "MOSERIAL_SZWRAPPER_PROTOCOL_RAW", "raw"}, {MOSERIAL_SZWRAPPER_PROTOCOL_NULL, "MOSERIAL_SZWRAPPER_PROTOCOL_NULL", "null"}, {0, NULL, NULL}};
	GType moserial_szwrapper_protocol_type_id;
	moserial_szwrapper_protocol_type_id = g_enum_register_static ("moserialSzwrapperProtocol", values);
	return moserial_szwrapper_protocol_type_id;
}

GType
moserial_szwrapper_protocol_get_type (void)
{
	static volatile gsize moserial_szwrapper_protocol_type_id__volatile = 0;
	if (g_once_init_enter (&moserial_szwrapper_protocol_type_id__volatile)) {
		GType moserial_szwrapper_protocol_type_id;
		moserial_szwrapper_protocol_type_id = moserial_szwrapper_protocol_get_type_once ();
		g_once_init_leave (&moserial_szwrapper_protocol_type_id__volatile, moserial_szwrapper_protocol_type_id);
	}
	return moserial_szwrapper_protocol_type_id__volatile;
}

moserialSzwrapper*
moserial_szwrapper_construct (GType object_type,
                              moserialSzwrapperProtocol* protocol,
                              moserialSerialConnection* sc,
                              const gchar* filename)
{
	moserialSzwrapper * self = NULL;
	moserialSzwrapperProtocol pro = 0;
	pro = *protocol;
	self = (moserialSzwrapper*) g_object_new (object_type, "protocol", pro, "sc", sc, "filename", filename, NULL);
	return self;
}

moserialSzwrapper*
moserial_szwrapper_new (moserialSzwrapperProtocol* protocol,
                        moserialSerialConnection* sc,
                        const gchar* filename)
{
	return moserial_szwrapper_construct (MOSERIAL_TYPE_SZWRAPPER, protocol, sc, filename);
}

void
moserial_szwrapper_writeChar (moserialSzwrapper* self,
                              guchar byte)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->running) {
		gsize bytesWritten = 0UL;
		gchar* b = NULL;
		gchar* _tmp0_;
		gint b_length1;
		gint _b_size_;
		gchar* _tmp1_;
		gint _tmp1__length1;
		_tmp0_ = g_new0 (gchar, 1);
		b = _tmp0_;
		b_length1 = 1;
		_b_size_ = b_length1;
		_tmp1_ = b;
		_tmp1__length1 = b_length1;
		_tmp1_[0] = (gchar) byte;
		{
			if (self->running) {
				GIOChannel* _tmp2_;
				gchar* _tmp3_;
				gint _tmp3__length1;
				gsize _tmp4_ = 0UL;
				_tmp2_ = self->priv->IOChannelInput;
				_tmp3_ = b;
				_tmp3__length1 = b_length1;
				g_io_channel_write_chars (_tmp2_, _tmp3_, (gint) _tmp3__length1, &_tmp4_, &_inner_error0_);
				bytesWritten = _tmp4_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == G_IO_CHANNEL_ERROR) {
						goto __catch0_g_io_channel_error;
					}
					if (_inner_error0_->domain == G_CONVERT_ERROR) {
						goto __catch0_g_convert_error;
					}
					b = (g_free (b), NULL);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			if (self->running) {
				GIOChannel* _tmp5_;
				_tmp5_ = self->priv->IOChannelInput;
				g_io_channel_flush (_tmp5_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == G_IO_CHANNEL_ERROR) {
						goto __catch0_g_io_channel_error;
					}
					if (_inner_error0_->domain == G_CONVERT_ERROR) {
						goto __catch0_g_convert_error;
					}
					b = (g_free (b), NULL);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		}
		goto __finally0;
		__catch0_g_io_channel_error:
		{
			GError* e = NULL;
			FILE* _tmp6_;
			GError* _tmp7_;
			const gchar* _tmp8_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			moserial_szwrapper_shutdown (self);
			_tmp6_ = stdout;
			_tmp7_ = e;
			_tmp8_ = _tmp7_->message;
			fprintf (_tmp6_, "writeChar() %s\n", _tmp8_);
			_g_error_free0 (e);
		}
		goto __finally0;
		__catch0_g_convert_error:
		{
			GError* e = NULL;
			FILE* _tmp9_;
			GError* _tmp10_;
			const gchar* _tmp11_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp9_ = stdout;
			_tmp10_ = e;
			_tmp11_ = _tmp10_->message;
			fprintf (_tmp9_, "%s\n", _tmp11_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			b = (g_free (b), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		b = (g_free (b), NULL);
	}
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gboolean
_moserial_szwrapper_shutdown_timeout_gsource_func (gpointer self)
{
	gboolean result;
	result = moserial_szwrapper_shutdown_timeout ((moserialSzwrapper*) self);
	return result;
}

static gboolean
moserial_szwrapper_readError (moserialSzwrapper* self,
                              GIOChannel* source,
                              GIOCondition condition)
{
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (gtk_events_pending ()) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = gdk_events_pending ();
		}
		if (!_tmp0_) {
			break;
		}
		gtk_main_iteration_do (FALSE);
	}
	if (self->running) {
		gchar* m_buf = NULL;
		gchar* _tmp1_;
		gint m_buf_length1;
		gint _m_buf_size_;
		gchar* messages = NULL;
		gchar* _tmp2_;
		gchar* message = NULL;
		gchar* _tmp3_;
		gsize bytesRead = 0UL;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		_tmp1_ = g_new0 (gchar, 1000);
		m_buf = _tmp1_;
		m_buf_length1 = 1000;
		_m_buf_size_ = m_buf_length1;
		_tmp2_ = g_strdup ("");
		messages = _tmp2_;
		_tmp3_ = g_strdup ("");
		message = _tmp3_;
		bytesRead = (gsize) 0;
		if (!(condition == G_IO_IN)) {
			result = TRUE;
			_g_free0 (message);
			_g_free0 (messages);
			m_buf = (g_free (m_buf), NULL);
			return result;
		}
		{
			gchar* _tmp4_;
			gint _tmp4__length1;
			gsize _tmp5_ = 0UL;
			_tmp4_ = m_buf;
			_tmp4__length1 = m_buf_length1;
			g_io_channel_read_chars (source, _tmp4_, (gint) _tmp4__length1, &_tmp5_, &_inner_error0_);
			bytesRead = _tmp5_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp6_ = FALSE;
				if (_inner_error0_->domain == G_CONVERT_ERROR) {
					goto __catch0_g_convert_error;
				}
				if (_inner_error0_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch0_g_io_channel_error;
				}
				_g_free0 (message);
				_g_free0 (messages);
				m_buf = (g_free (m_buf), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp6_;
			}
		}
		goto __finally0;
		__catch0_g_convert_error:
		{
			GError* e = NULL;
			FILE* _tmp7_;
			GError* _tmp8_;
			const gchar* _tmp9_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp7_ = stdout;
			_tmp8_ = e;
			_tmp9_ = _tmp8_->message;
			fprintf (_tmp7_, "%s\n", _tmp9_);
			_g_error_free0 (e);
		}
		goto __finally0;
		__catch0_g_io_channel_error:
		{
			GError* e = NULL;
			FILE* _tmp10_;
			GError* _tmp11_;
			const gchar* _tmp12_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp10_ = stdout;
			_tmp11_ = e;
			_tmp12_ = _tmp11_->message;
			fprintf (_tmp10_, "readError() %s\n", _tmp12_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp13_ = FALSE;
			_g_free0 (message);
			_g_free0 (messages);
			m_buf = (g_free (m_buf), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp13_;
		}
		{
			gint x = 0;
			x = 0;
			{
				gboolean _tmp14_ = FALSE;
				_tmp14_ = TRUE;
				while (TRUE) {
					gunichar c = 0U;
					gchar* _tmp16_;
					gint _tmp16__length1;
					gchar _tmp17_;
					gboolean _tmp18_ = FALSE;
					if (!_tmp14_) {
						gint _tmp15_;
						_tmp15_ = x;
						x = _tmp15_ + 1;
					}
					_tmp14_ = FALSE;
					if (!(((gsize) x) < bytesRead)) {
						break;
					}
					_tmp16_ = m_buf;
					_tmp16__length1 = m_buf_length1;
					_tmp17_ = _tmp16_[x];
					c = (gunichar) _tmp17_;
					if (g_unichar_isprint (c)) {
						_tmp18_ = TRUE;
					} else {
						_tmp18_ = g_unichar_isspace (c);
					}
					if (_tmp18_) {
						const gchar* _tmp19_;
						gchar* _tmp20_;
						gint _tmp20__length1;
						gchar _tmp21_;
						gchar* _tmp22_;
						gchar* _tmp23_;
						gchar* _tmp24_;
						_tmp19_ = messages;
						_tmp20_ = m_buf;
						_tmp20__length1 = m_buf_length1;
						_tmp21_ = _tmp20_[x];
						_tmp22_ = g_strdup_printf ("%c", (gint) _tmp21_);
						_tmp23_ = _tmp22_;
						_tmp24_ = g_strconcat (_tmp19_, _tmp23_, NULL);
						_g_free0 (messages);
						messages = _tmp24_;
						_g_free0 (_tmp23_);
					}
				}
			}
		}
		_tmp25_ = messages;
		_tmp26_ = mo_utils_getLastMessage (_tmp25_);
		_g_free0 (message);
		message = _tmp26_;
		_tmp27_ = message;
		if (!(g_strcmp0 (_tmp27_, "") == 0)) {
			const gchar* _tmp28_;
			_tmp28_ = message;
			g_signal_emit (self, moserial_szwrapper_signals[MOSERIAL_SZWRAPPER_UPDATE_STATUS_SIGNAL], 0, _tmp28_);
		}
		_tmp29_ = messages;
		if (string_index_of (_tmp29_, "Transfer complete", 0) >= 0) {
			g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 2000, _moserial_szwrapper_shutdown_timeout_gsource_func, g_object_ref (self), g_object_unref);
		}
		_tmp30_ = messages;
		if (string_index_of (_tmp30_, "Transfer incomplete", 0) >= 0) {
			moserial_szwrapper_shutdown (self);
		}
		result = TRUE;
		_g_free0 (message);
		_g_free0 (messages);
		m_buf = (g_free (m_buf), NULL);
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

void
moserial_szwrapper_transferCanceled (moserialSzwrapper* self,
                                     GObject* o)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	if (self->running) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		moserialSzwrapperProtocol _tmp2_;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		moserialSzwrapperProtocol _tmp12_;
		g_signal_emit (self, moserial_szwrapper_signals[MOSERIAL_SZWRAPPER_UPDATE_STATUS_SIGNAL], 0, _ ("canceled"));
		_tmp2_ = self->priv->_protocol;
		if (_tmp2_ == MOSERIAL_SZWRAPPER_PROTOCOL_XMODEM) {
			_tmp1_ = TRUE;
		} else {
			moserialSzwrapperProtocol _tmp3_;
			_tmp3_ = self->priv->_protocol;
			_tmp1_ = _tmp3_ == MOSERIAL_SZWRAPPER_PROTOCOL_YMODEM;
		}
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			moserialSzwrapperProtocol _tmp4_;
			_tmp4_ = self->priv->_protocol;
			_tmp0_ = _tmp4_ == MOSERIAL_SZWRAPPER_PROTOCOL_ZMODEM;
		}
		if (_tmp0_) {
			{
				gint x = 0;
				x = 0;
				{
					gboolean _tmp5_ = FALSE;
					_tmp5_ = TRUE;
					while (TRUE) {
						moserialSzwrapperProtocol _tmp7_;
						if (!_tmp5_) {
							gint _tmp6_;
							_tmp6_ = x;
							x = _tmp6_ + 1;
						}
						_tmp5_ = FALSE;
						if (!(x < 20)) {
							break;
						}
						_tmp7_ = self->priv->_protocol;
						if (_tmp7_ == MOSERIAL_SZWRAPPER_PROTOCOL_ZMODEM) {
							moserialSerialConnection* _tmp8_;
							_tmp8_ = self->priv->_sc;
							moserial_serial_connection_sendByte (_tmp8_, (guchar) ('X' & 037));
							moserial_szwrapper_writeChar (self, (guchar) ('X' & 037));
						} else {
							moserialSerialConnection* _tmp9_;
							_tmp9_ = self->priv->_sc;
							moserial_serial_connection_sendByte (_tmp9_, (guchar) 0x18);
						}
					}
				}
			}
		}
		_tmp12_ = self->priv->_protocol;
		if (_tmp12_ == MOSERIAL_SZWRAPPER_PROTOCOL_XMODEM) {
			_tmp11_ = TRUE;
		} else {
			moserialSzwrapperProtocol _tmp13_;
			_tmp13_ = self->priv->_protocol;
			_tmp11_ = _tmp13_ == MOSERIAL_SZWRAPPER_PROTOCOL_YMODEM;
		}
		if (_tmp11_) {
			_tmp10_ = TRUE;
		} else {
			moserialSzwrapperProtocol _tmp14_;
			_tmp14_ = self->priv->_protocol;
			_tmp10_ = _tmp14_ == MOSERIAL_SZWRAPPER_PROTOCOL_RAW;
		}
		if (_tmp10_) {
			moserial_szwrapper_shutdown (self);
		}
	}
}

static gboolean
moserial_szwrapper_shutdown_timeout (moserialSzwrapper* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	moserial_szwrapper_shutdown (self);
	result = FALSE;
	return result;
}

static void
moserial_szwrapper_shutdown (moserialSzwrapper* self)
{
	g_return_if_fail (self != NULL);
	if (self->running) {
		self->running = FALSE;
		g_source_remove (self->priv->outputChannelId);
		g_source_remove (self->priv->errorChannelId);
		g_spawn_close_pid (self->priv->pid);
		g_signal_emit (self, moserial_szwrapper_signals[MOSERIAL_SZWRAPPER_TRANSFER_COMPLETE_SIGNAL], 0);
	}
}

static gboolean
moserial_szwrapper_readBytes (moserialSzwrapper* self,
                              GIOChannel* source,
                              GIOCondition condition)
{
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (gtk_events_pending ()) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = gdk_events_pending ();
		}
		if (!_tmp0_) {
			break;
		}
		gtk_main_iteration_do (FALSE);
	}
	if (self->running) {
		gchar* m_buf = NULL;
		gchar* _tmp1_;
		gint m_buf_length1;
		gint _m_buf_size_;
		gsize bytesRead = 0UL;
		moserialSerialConnection* _tmp12_;
		gchar* _tmp13_;
		gint _tmp13__length1;
		_tmp1_ = g_new0 (gchar, 1024);
		m_buf = _tmp1_;
		m_buf_length1 = 1024;
		_m_buf_size_ = m_buf_length1;
		bytesRead = (gsize) 0;
		if (!(condition == G_IO_IN)) {
			result = TRUE;
			m_buf = (g_free (m_buf), NULL);
			return result;
		}
		{
			gchar* _tmp2_;
			gint _tmp2__length1;
			gsize _tmp3_ = 0UL;
			_tmp2_ = m_buf;
			_tmp2__length1 = m_buf_length1;
			g_io_channel_read_chars (source, _tmp2_, (gint) _tmp2__length1, &_tmp3_, &_inner_error0_);
			bytesRead = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp4_ = FALSE;
				if (_inner_error0_->domain == G_CONVERT_ERROR) {
					goto __catch0_g_convert_error;
				}
				if (_inner_error0_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch0_g_io_channel_error;
				}
				m_buf = (g_free (m_buf), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp4_;
			}
		}
		goto __finally0;
		__catch0_g_convert_error:
		{
			GError* e = NULL;
			FILE* _tmp5_;
			GError* _tmp6_;
			const gchar* _tmp7_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp5_ = stdout;
			_tmp6_ = e;
			_tmp7_ = _tmp6_->message;
			fprintf (_tmp5_, "%s\n", _tmp7_);
			_g_error_free0 (e);
		}
		goto __finally0;
		__catch0_g_io_channel_error:
		{
			GError* e = NULL;
			FILE* _tmp8_;
			GError* _tmp9_;
			const gchar* _tmp10_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp8_ = stdout;
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			fprintf (_tmp8_, "readError() %s\n", _tmp10_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp11_ = FALSE;
			m_buf = (g_free (m_buf), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp11_;
		}
		_tmp12_ = self->priv->_sc;
		_tmp13_ = m_buf;
		_tmp13__length1 = m_buf_length1;
		moserial_serial_connection_sendBytes (_tmp12_, _tmp13_, (gint) _tmp13__length1, bytesRead);
		result = TRUE;
		m_buf = (g_free (m_buf), NULL);
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

moserialSzwrapperProtocol
moserial_szwrapper_get_protocol (moserialSzwrapper* self)
{
	moserialSzwrapperProtocol result;
	moserialSzwrapperProtocol _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_protocol;
	result = _tmp0_;
	return result;
}

static void
moserial_szwrapper_set_protocol (moserialSzwrapper* self,
                                 moserialSzwrapperProtocol value)
{
	moserialSzwrapperProtocol old_value;
	g_return_if_fail (self != NULL);
	old_value = moserial_szwrapper_get_protocol (self);
	if (old_value != value) {
		self->priv->_protocol = value;
		g_object_notify_by_pspec ((GObject *) self, moserial_szwrapper_properties[MOSERIAL_SZWRAPPER_PROTOCOL_PROPERTY]);
	}
}

moserialSerialConnection*
moserial_szwrapper_get_sc (moserialSzwrapper* self)
{
	moserialSerialConnection* result;
	moserialSerialConnection* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sc;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
moserial_szwrapper_set_sc (moserialSzwrapper* self,
                           moserialSerialConnection* value)
{
	moserialSerialConnection* old_value;
	g_return_if_fail (self != NULL);
	old_value = moserial_szwrapper_get_sc (self);
	if (old_value != value) {
		moserialSerialConnection* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_sc);
		self->priv->_sc = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, moserial_szwrapper_properties[MOSERIAL_SZWRAPPER_SC_PROPERTY]);
	}
}

const gchar*
moserial_szwrapper_get_filename (moserialSzwrapper* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_filename;
	result = _tmp0_;
	return result;
}

static void
moserial_szwrapper_set_filename (moserialSzwrapper* self,
                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = moserial_szwrapper_get_filename (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_filename);
		self->priv->_filename = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, moserial_szwrapper_properties[MOSERIAL_SZWRAPPER_FILENAME_PROPERTY]);
	}
}

static gboolean
_moserial_szwrapper_readBytes_gio_func (GIOChannel* source,
                                        GIOCondition condition,
                                        gpointer self)
{
	gboolean result;
	result = moserial_szwrapper_readBytes ((moserialSzwrapper*) self, source, condition);
	return result;
}

static gboolean
_moserial_szwrapper_readError_gio_func (GIOChannel* source,
                                        GIOCondition condition,
                                        gpointer self)
{
	gboolean result;
	result = moserial_szwrapper_readError ((moserialSzwrapper*) self, source, condition);
	return result;
}

static GObject *
moserial_szwrapper_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	moserialSzwrapper * self;
	gboolean _tmp0_ = FALSE;
	moserialSzwrapperProtocol _tmp1_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (moserial_szwrapper_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MOSERIAL_TYPE_SZWRAPPER, moserialSzwrapper);
	_tmp1_ = self->priv->_protocol;
	if (_tmp1_ == MOSERIAL_SZWRAPPER_PROTOCOL_NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->_filename;
		_tmp0_ = _tmp2_ == NULL;
	}
	if (_tmp0_) {
		self->running = FALSE;
	} else {
		gchar** argv = NULL;
		gint argv_length1 = 0;
		gint _argv_size_ = 0;
		moserialSzwrapperProtocol _tmp3_;
		gint output = 0;
		gint _error_ = 0;
		gint input = 0;
		_tmp3_ = self->priv->_protocol;
		if (_tmp3_ == MOSERIAL_SZWRAPPER_PROTOCOL_RAW) {
			gchar** _tmp4_;
			gchar** _tmp5_;
			gint _tmp5__length1;
			gchar* _tmp6_;
			gchar** _tmp7_;
			gint _tmp7__length1;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp4_ = g_new0 (gchar*, 2 + 1);
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			argv = _tmp4_;
			argv_length1 = 2;
			_argv_size_ = argv_length1;
			_tmp5_ = argv;
			_tmp5__length1 = argv_length1;
			_tmp6_ = g_strdup ("cat");
			_g_free0 (_tmp5_[0]);
			_tmp5_[0] = _tmp6_;
			_tmp7_ = argv;
			_tmp7__length1 = argv_length1;
			_tmp8_ = self->priv->_filename;
			_tmp9_ = g_strdup (_tmp8_);
			_g_free0 (_tmp7_[1]);
			_tmp7_[1] = _tmp9_;
		} else {
			gchar** _tmp10_;
			gchar** _tmp11_;
			gint _tmp11__length1;
			gchar* _tmp12_;
			moserialSzwrapperProtocol _tmp13_;
			gchar** _tmp20_;
			gint _tmp20__length1;
			gchar* _tmp21_;
			gchar** _tmp22_;
			gint _tmp22__length1;
			const gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp10_ = g_new0 (gchar*, 4 + 1);
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			argv = _tmp10_;
			argv_length1 = 4;
			_argv_size_ = argv_length1;
			_tmp11_ = argv;
			_tmp11__length1 = argv_length1;
			_tmp12_ = g_strdup ("sz");
			_g_free0 (_tmp11_[0]);
			_tmp11_[0] = _tmp12_;
			_tmp13_ = self->priv->_protocol;
			switch (_tmp13_) {
				case MOSERIAL_SZWRAPPER_PROTOCOL_XMODEM:
				{
					gchar** _tmp14_;
					gint _tmp14__length1;
					gchar* _tmp15_;
					_tmp14_ = argv;
					_tmp14__length1 = argv_length1;
					_tmp15_ = g_strdup ("--xmodem");
					_g_free0 (_tmp14_[1]);
					_tmp14_[1] = _tmp15_;
					break;
				}
				case MOSERIAL_SZWRAPPER_PROTOCOL_YMODEM:
				{
					gchar** _tmp16_;
					gint _tmp16__length1;
					gchar* _tmp17_;
					_tmp16_ = argv;
					_tmp16__length1 = argv_length1;
					_tmp17_ = g_strdup ("--ymodem");
					_g_free0 (_tmp16_[1]);
					_tmp16_[1] = _tmp17_;
					break;
				}
				default:
				case MOSERIAL_SZWRAPPER_PROTOCOL_ZMODEM:
				{
					gchar** _tmp18_;
					gint _tmp18__length1;
					gchar* _tmp19_;
					_tmp18_ = argv;
					_tmp18__length1 = argv_length1;
					_tmp19_ = g_strdup ("--zmodem");
					_g_free0 (_tmp18_[1]);
					_tmp18_[1] = _tmp19_;
					break;
				}
			}
			_tmp20_ = argv;
			_tmp20__length1 = argv_length1;
			_tmp21_ = g_strdup ("-vv");
			_g_free0 (_tmp20_[2]);
			_tmp20_[2] = _tmp21_;
			_tmp22_ = argv;
			_tmp22__length1 = argv_length1;
			_tmp23_ = self->priv->_filename;
			_tmp24_ = g_strdup (_tmp23_);
			_g_free0 (_tmp22_[3]);
			_tmp22_[3] = _tmp24_;
		}
		{
			gchar** _tmp25_;
			gint _tmp25__length1;
			GPid _tmp26_ = 0;
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			GIOChannel* _tmp30_;
			GIOChannel* _tmp31_;
			GIOChannel* _tmp32_;
			GIOChannel* _tmp33_;
			GIOChannel* _tmp34_;
			GIOChannel* _tmp35_;
			GIOChannel* _tmp36_;
			GIOChannel* _tmp37_;
			GIOChannel* _tmp38_;
			GIOChannel* _tmp39_;
			_tmp25_ = argv;
			_tmp25__length1 = argv_length1;
			g_spawn_async_with_pipes (NULL, _tmp25_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp26_, &_tmp27_, &_tmp28_, &_tmp29_, &_inner_error0_);
			self->priv->pid = _tmp26_;
			input = _tmp27_;
			output = _tmp28_;
			_error_ = _tmp29_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_SPAWN_ERROR) {
					goto __catch0_g_spawn_error;
				}
				if (_inner_error0_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch0_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
			}
			_tmp30_ = g_io_channel_unix_new (output);
			_g_io_channel_unref0 (self->priv->IOChannelOutput);
			self->priv->IOChannelOutput = _tmp30_;
			_tmp31_ = g_io_channel_unix_new (input);
			_g_io_channel_unref0 (self->priv->IOChannelInput);
			self->priv->IOChannelInput = _tmp31_;
			_tmp32_ = g_io_channel_unix_new (_error_);
			_g_io_channel_unref0 (self->priv->IOChannelError);
			self->priv->IOChannelError = _tmp32_;
			_tmp33_ = self->priv->IOChannelOutput;
			g_io_channel_set_encoding (_tmp33_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_SPAWN_ERROR) {
					goto __catch0_g_spawn_error;
				}
				if (_inner_error0_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch0_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
			}
			_tmp34_ = self->priv->IOChannelOutput;
			g_io_channel_set_flags (_tmp34_, G_IO_FLAG_NONBLOCK, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_SPAWN_ERROR) {
					goto __catch0_g_spawn_error;
				}
				if (_inner_error0_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch0_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
			}
			_tmp35_ = self->priv->IOChannelError;
			g_io_channel_set_encoding (_tmp35_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_SPAWN_ERROR) {
					goto __catch0_g_spawn_error;
				}
				if (_inner_error0_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch0_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
			}
			_tmp36_ = self->priv->IOChannelError;
			g_io_channel_set_flags (_tmp36_, G_IO_FLAG_NONBLOCK, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_SPAWN_ERROR) {
					goto __catch0_g_spawn_error;
				}
				if (_inner_error0_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch0_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
			}
			_tmp37_ = self->priv->IOChannelInput;
			g_io_channel_set_encoding (_tmp37_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_SPAWN_ERROR) {
					goto __catch0_g_spawn_error;
				}
				if (_inner_error0_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch0_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
			}
			_tmp38_ = self->priv->IOChannelOutput;
			self->priv->outputChannelId = g_io_add_watch (_tmp38_, G_IO_IN, _moserial_szwrapper_readBytes_gio_func, self);
			_tmp39_ = self->priv->IOChannelError;
			self->priv->errorChannelId = g_io_add_watch (_tmp39_, G_IO_IN, _moserial_szwrapper_readError_gio_func, self);
			self->running = TRUE;
		}
		goto __finally0;
		__catch0_g_spawn_error:
		{
			GError* e = NULL;
			FILE* _tmp40_;
			GError* _tmp41_;
			const gchar* _tmp42_;
			GtkMessageDialog* errorDialog = NULL;
			GError* _tmp43_;
			const gchar* _tmp44_;
			GtkMessageDialog* _tmp45_;
			GtkMessageDialog* _tmp46_;
			GtkMessageDialog* _tmp47_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			self->running = FALSE;
			_tmp40_ = stdout;
			_tmp41_ = e;
			_tmp42_ = _tmp41_->message;
			fprintf (_tmp40_, "spawn error: %s\n", _tmp42_);
			_tmp43_ = e;
			_tmp44_ = _tmp43_->message;
			_tmp45_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s", _tmp44_);
			g_object_ref_sink (_tmp45_);
			errorDialog = _tmp45_;
			_tmp46_ = errorDialog;
			gtk_dialog_run ((GtkDialog*) _tmp46_);
			_tmp47_ = errorDialog;
			gtk_widget_destroy ((GtkWidget*) _tmp47_);
			_g_object_unref0 (errorDialog);
			_g_error_free0 (e);
		}
		goto __finally0;
		__catch0_g_io_channel_error:
		{
			GError* e = NULL;
			FILE* _tmp48_;
			GError* _tmp49_;
			const gchar* _tmp50_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp48_ = stdout;
			_tmp49_ = e;
			_tmp50_ = _tmp49_->message;
			fprintf (_tmp48_, "readError() %s\n", _tmp50_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	}
	return obj;
}

static void
moserial_szwrapper_class_init (moserialSzwrapperClass * klass,
                               gpointer klass_data)
{
	moserial_szwrapper_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &moserialSzwrapper_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_moserial_szwrapper_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_moserial_szwrapper_set_property;
	G_OBJECT_CLASS (klass)->constructor = moserial_szwrapper_constructor;
	G_OBJECT_CLASS (klass)->finalize = moserial_szwrapper_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_SZWRAPPER_PROTOCOL_PROPERTY, moserial_szwrapper_properties[MOSERIAL_SZWRAPPER_PROTOCOL_PROPERTY] = g_param_spec_enum ("protocol", "protocol", "protocol", MOSERIAL_SZWRAPPER_TYPE_PROTOCOL, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_SZWRAPPER_SC_PROPERTY, moserial_szwrapper_properties[MOSERIAL_SZWRAPPER_SC_PROPERTY] = g_param_spec_object ("sc", "sc", "sc", MOSERIAL_TYPE_SERIAL_CONNECTION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_SZWRAPPER_FILENAME_PROPERTY, moserial_szwrapper_properties[MOSERIAL_SZWRAPPER_FILENAME_PROPERTY] = g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	moserial_szwrapper_signals[MOSERIAL_SZWRAPPER_TRANSFER_COMPLETE_SIGNAL] = g_signal_new ("transfer-complete", MOSERIAL_TYPE_SZWRAPPER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	moserial_szwrapper_signals[MOSERIAL_SZWRAPPER_UPDATE_STATUS_SIGNAL] = g_signal_new ("update-status", MOSERIAL_TYPE_SZWRAPPER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
moserial_szwrapper_instance_init (moserialSzwrapper * self,
                                  gpointer klass)
{
	self->priv = moserial_szwrapper_get_instance_private (self);
	self->running = FALSE;
}

static void
moserial_szwrapper_finalize (GObject * obj)
{
	moserialSzwrapper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MOSERIAL_TYPE_SZWRAPPER, moserialSzwrapper);
	_g_object_unref0 (self->priv->_sc);
	_g_io_channel_unref0 (self->priv->IOChannelInput);
	_g_io_channel_unref0 (self->priv->IOChannelOutput);
	_g_io_channel_unref0 (self->priv->IOChannelError);
	_g_free0 (self->priv->_filename);
	G_OBJECT_CLASS (moserial_szwrapper_parent_class)->finalize (obj);
}

static GType
moserial_szwrapper_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (moserialSzwrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_szwrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialSzwrapper), 0, (GInstanceInitFunc) moserial_szwrapper_instance_init, NULL };
	GType moserial_szwrapper_type_id;
	moserial_szwrapper_type_id = g_type_register_static (G_TYPE_OBJECT, "moserialSzwrapper", &g_define_type_info, 0);
	moserialSzwrapper_private_offset = g_type_add_instance_private (moserial_szwrapper_type_id, sizeof (moserialSzwrapperPrivate));
	return moserial_szwrapper_type_id;
}

GType
moserial_szwrapper_get_type (void)
{
	static volatile gsize moserial_szwrapper_type_id__volatile = 0;
	if (g_once_init_enter (&moserial_szwrapper_type_id__volatile)) {
		GType moserial_szwrapper_type_id;
		moserial_szwrapper_type_id = moserial_szwrapper_get_type_once ();
		g_once_init_leave (&moserial_szwrapper_type_id__volatile, moserial_szwrapper_type_id);
	}
	return moserial_szwrapper_type_id__volatile;
}

static void
_vala_moserial_szwrapper_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	moserialSzwrapper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MOSERIAL_TYPE_SZWRAPPER, moserialSzwrapper);
	switch (property_id) {
		case MOSERIAL_SZWRAPPER_PROTOCOL_PROPERTY:
		g_value_set_enum (value, moserial_szwrapper_get_protocol (self));
		break;
		case MOSERIAL_SZWRAPPER_SC_PROPERTY:
		g_value_set_object (value, moserial_szwrapper_get_sc (self));
		break;
		case MOSERIAL_SZWRAPPER_FILENAME_PROPERTY:
		g_value_set_string (value, moserial_szwrapper_get_filename (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_moserial_szwrapper_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	moserialSzwrapper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MOSERIAL_TYPE_SZWRAPPER, moserialSzwrapper);
	switch (property_id) {
		case MOSERIAL_SZWRAPPER_PROTOCOL_PROPERTY:
		moserial_szwrapper_set_protocol (self, g_value_get_enum (value));
		break;
		case MOSERIAL_SZWRAPPER_SC_PROPERTY:
		moserial_szwrapper_set_sc (self, g_value_get_object (value));
		break;
		case MOSERIAL_SZWRAPPER_FILENAME_PROPERTY:
		moserial_szwrapper_set_filename (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

