/* libnetbrake.h -- header file for libnetbrake.c
 *
 * COPYRIGHT AND PERMISSION NOTICE
 * 
 * Copyright (c) 2001 Salvatore Sanfilippo
 * 
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 * 
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 */

#ifndef _LIBNETBRAKE_H
#define _LIBNETBRAKE_H

/* defines */
#define NB_MAX_FD			1024
#define NB_LOADTABLE_SZ 		10

#define NB_DEFAULT_OPT_DEBUG		0
#define NB_DEFAULT_OPT_BPSLIMIT		(1024*2)
#define NB_DEFAULT_OPT_LIMIT_TCP	1
#define NB_DEFAULT_OPT_LIMIT_UDP	1
#define NB_DEFAULT_OPT_RCVBUF_SIZE	(1024*8)
#define NB_DEFAULT_OPT_LIMIT_GETC	0
#define NB_DEFAULT_OPT_HTTPFS		0
#define NB_DEFAULT_OPT_INCLUDE_HTTPHDR	0
#define NB_DEFAULT_OPT_PRINT_BPS	0
#define NB_DEFAULT_OPT_NETLIMIT		1

#define MIN(x,y) (((x)<(y))?(x):(y))

/* structures */
struct nb_loadtable_ele {
	long long usec;
	size_t load;
};

#endif /* _LIBNETBRAKE_H */
