#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "secstring.h"
#include "antigetopt.h"
#include "netbrake.h"

enum { OPT_BPS, OPT_NOTCP, OPT_NOUDP, OPT_RCVBUF, OPT_DEBUG, OPT_LIMITGETC,
       OPT_HTTPFS, OPT_HTTPHDR, OPT_BPSINFO, OPT_LIMIT, OPT_HELP };

static struct ago_optlist nb_optlist[] = {
	{ 'r',	"bps",		OPT_BPS,	AGO_NEEDARG },
	{ 'T',  "notcp",	OPT_NOTCP,	AGO_NOARG },
	{ 'U',	"noudp",	OPT_NOUDP,	AGO_NOARG },
	{ 'b',	"rcvbuf",	OPT_RCVBUF,	AGO_NOARG },
	{ 'd',	"debug",	OPT_DEBUG,	AGO_NOARG },
	{ 'g',	"limit-getc",	OPT_LIMITGETC,	AGO_NOARG },
	{ 'w',  "httpfs",	OPT_HTTPFS,	AGO_NOARG },
	{ 'H',	"httphdr",	OPT_HTTPHDR,	AGO_NOARG },
	{ 'p',	"bpsinfo",	OPT_BPSINFO,	AGO_NOARG },
	{ 'l',	"limit",	OPT_LIMIT,	AGO_NOARG },
	{ 'h',	"help",		OPT_HELP,	AGO_NOARG },
	AGO_LIST_TERM
};

static void show_help(void)
{
	printf(HELPTEXT);
	exit(1);
}

int main(int argc, char **argv)
{
	char libnetbrake[NB_PATHSZ];
	char *first_command_arg = NULL;
	int i, o;

	while((o = antigetopt(argc, argv, nb_optlist)) != AGO_EOF) {
		switch(o) {
		case AGO_UNKNOWN:
		case AGO_REQARG:
		case AGO_AMBIG:
			ago_gnu_error("netbrake", o);
			fprintf(stderr, "Try netbrake --help\n");
			exit(1);
		case OPT_BPS:
			setenv("NETBRAKE_BPS", ago_optarg, 1);
			break;
		case OPT_NOTCP:
			setenv("NETBRAKE_LIMIT_TCP", "0", 1);
			break;
		case OPT_NOUDP:
			setenv("NETBRAKE_LIMIT_UDP", "0", 1);
			break;
		case OPT_RCVBUF:
			setenv("NETBRAKE_RCVBUF", ago_optarg, 1);
			break;
		case OPT_DEBUG:
			setenv("NETBRAKE_DEBUG", "1", 1);
			break;
		case OPT_LIMITGETC:
			setenv("NETBRAKE_LIMIT_GETC", "1", 1);
			break;
		case OPT_HTTPFS:
			setenv("NETBRAKE_HTTP_FS", "1", 1);
			break;
		case OPT_HTTPHDR:
			setenv("NETBRAKE_HTTP_HDR", "1", 1);
			break;
		case OPT_BPSINFO:
			setenv("NETBRAKE_PRINT_BPS", "1", 1);
			break;
		case OPT_LIMIT:
			setenv("NETBRAKE_NETLIMIT", "1", 1);
			break;
		case OPT_HELP:
			show_help();
			break;
		case AGO_ALONE:
			first_command_arg = ago_optarg;
			goto out;
		}
	}
	show_help();

out: /* reached the first argument for the program to execute */

	/* search the argv[] index of the first prog argument */
	for (i = 1; ; i++) {
		if (argv[i] == first_command_arg)
			break;
	}

	sec_snprintf(libnetbrake, NB_PATHSZ, "%s/%s", LIBPATH, LIBNETBRAKE);
	setenv("LD_PRELOAD", libnetbrake, 1);
	execvp(argv[i], argv+i);
	perror("netbrake");
	return 0;
}
