%undefine _hardened_build

%global nixbld_user "nix-builder-"
%global nixbld_group "nixbld"

# NOTE: BUILD on EL7 requires
# - Centos / RHEL7 software collection repository 
#   yum install centos-release-scl
#
# - Recent boost backport
#   curl https://copr.fedorainfracloud.org/coprs/whosthere/boost/repo/epel-7/whosthere-boost-epel-7.repo -o /etc/yum.repos.d/whosthere-boost-epel-7.repo
#

# Disable documentation generation
# necessary on some platforms
%bcond_without docgen

Summary: The Nix software deployment system
Name: nix
Version: 2.3.15
Release: 2%{?dist}
License: LGPLv2+
Group: Applications/System
URL: http://nixos.org/
Source0: %{name}-%{version}.tar.bz2

Requires: curl
Requires: bzip2
Requires: gzip
Requires: xz
BuildRequires: bison
BuildRequires: boost-devel >= 1.60
BuildRequires: bzip2-devel

# for RHEL <= 7, we need software collections for a C++14 compatible compatible compiler
%if 0%{?rhel}
BuildRequires: devtoolset-7-gcc
BuildRequires: devtoolset-7-gcc-c++
%endif

BuildRequires: flex
BuildRequires: libcurl-devel
BuildRequires: libseccomp-devel
BuildRequires: openssl-devel
BuildRequires: sqlite-devel
BuildRequires: xz-devel

%description
Nix is a purely functional package manager. It allows multiple
versions of a package to be installed side-by-side, ensures that
dependency specifications are complete, supports atomic upgrades and
rollbacks, allows non-root users to install software, and has many
other features. It is the basis of the NixOS Linux distribution, but
it can be used equally well under other Unix systems.

%package        devel
Summary:        Development files for %{name}
Requires:       %{name}%{?_isa} = %{version}-%{release}

%description   devel
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.


%package doc
Summary:        Documentation files for %{name}
BuildArch:      noarch
Requires:       %{name} = %{version}-%{release}

%description   doc
The %{name}-doc package contains documentation files for %{name}.

%prep
%setup -q


%build
%if 0%{?rhel}
source /opt/rh/devtoolset-7/enable 
%endif
extraFlags=
# - override docdir so large documentation files are owned by the
#   -doc subpackage
# - set localstatedir by hand to the preferred nix value
%configure --localstatedir=/nix/var \
	   %{!?without_docgen:--disable-doc-gen} \
           --docdir=%{_defaultdocdir}/%{name}-doc-%{version} \
           $extraFlags
make V=1 %{?_smp_mflags}


%install
%if 0%{?rhel}
source /opt/rh/devtoolset-7/enable 
%endif

make DESTDIR=$RPM_BUILD_ROOT install

find $RPM_BUILD_ROOT -name '*.la' -exec rm -f {} ';'

# make the store
mkdir -p $RPM_BUILD_ROOT/nix/store
chmod 1775 $RPM_BUILD_ROOT/nix/store

# make per-user directories
for d in profiles gcroots;
do
  mkdir -p $RPM_BUILD_ROOT/nix/var/nix/$d/per-user
  chmod 755 $RPM_BUILD_ROOT/nix/var/nix/$d/per-user
done

# fix permission of nix profile
# (until this is fixed in the relevant Makefile)
chmod -x $RPM_BUILD_ROOT%{_sysconfdir}/profile.d/nix.sh

# we ship this file in the base package
rm -f $RPM_BUILD_ROOT%{_defaultdocdir}/%{name}-doc-%{version}/README

# Get rid of Upstart job.
rm -rf $RPM_BUILD_ROOT%{_sysconfdir}/init


%clean
rm -rf $RPM_BUILD_ROOT


%pre
getent group %{nixbld_group} >/dev/null || groupadd -r %{nixbld_group}
for i in $(seq 10);
do
  getent passwd %{nixbld_user}$i >/dev/null || \
    useradd -r -g %{nixbld_group} -G %{nixbld_group} -d /var/empty \
      -s %{_sbindir}/nologin \
      -c "Nix build user $i" %{nixbld_user}$i
done

%post
chgrp %{nixbld_group} /nix/store
%if ! 0%{?rhel} || 0%{?rhel} >= 7
# Enable and start Nix worker
systemctl enable nix-daemon.socket nix-daemon.service
systemctl start  nix-daemon.socket
%endif

%files
%license COPYING
%{_bindir}/nix*
%{_libdir}/*.so
%{_prefix}/libexec/*
%if ! 0%{?rhel} || 0%{?rhel} >= 7
%{_prefix}/lib/systemd/system/nix-daemon.socket
%{_prefix}/lib/systemd/system/nix-daemon.service
%endif
%{_datadir}/nix
#%if ! %{without docgen}
#%{_mandir}/man1/*.1*
#%{_mandir}/man5/*.5*
#%{_mandir}/man8/*.8*
#%endif
%config(noreplace) %{_sysconfdir}/profile.d/nix.sh
%config(noreplace) %{_sysconfdir}/profile.d/nix-daemon.sh
/nix

%files devel
%{_includedir}/nix
%{_prefix}/lib/pkgconfig/*.pc


#%if ! %{without docgen}
#%files doc
#%docdir %{_defaultdocdir}/%{name}-doc-%{version}
#%{_defaultdocdir}/%{name}-doc-%{version}
#%endif
