/******************************************************************************
*
* Copyright (C) 2002 Hugo PEREIRA <mailto: hugo.pereira@free.fr>
*
* This is free software; you can redistribute it and/or modify it under the
* terms of the GNU General Public License as published by the Free Software
* Foundation; either version 2 of the License, or (at your option) any later
* version.
*
* This software is distributed in the hope that it will be useful, but WITHOUT
* Any WARRANTY; without even the implied warranty of MERCHANTABILITY or
* FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
* for more details.
*
* You should have received a copy of the GNU General Public License along with
* this program.  If not, see <http://www.gnu.org/licenses/>.
*
*******************************************************************************/

#include "TransparentWidget.h"
#include "WidgetDragMonitor.h"

#include <QLineEdit>
#include <QPaintEvent>
#include <QPixmap>
#include <QResizeEvent>

class AskPassQt  : public Transparency::TransparentWidget
{
    Q_OBJECT

    public:

    //* constructor
    explicit AskPassQt( QWidget* = nullptr );

    protected:

    //* paint
    void paintEvent( QPaintEvent* ) override;

    //* resize
    void resizeEvent( QResizeEvent* ) override;

    private Q_SLOTS:

    //* accept pass phrase
    void accept();

    //* cancel pass phrase selection
    void cancel();

    protected:

    //* paint to device
    void _paint( QPaintDevice&, const QRect& ) override;

    private:

    //* drag monitor
    WidgetDragMonitor widgetDragMonitor_;

    //* editor
    QLineEdit* editor_ = nullptr;

};
