/******************************************************************************
*
* Copyright (C) 2002 Hugo PEREIRA <mailto: hugo.pereira@free.fr>
*
* This is free software; you can redistribute it and/or modify it under the
* terms of the GNU General Public License as published by the Free Software
* Foundation; either version 2 of the License, or (at your option) any later
* version.
*
* This software is distributed in the hope that it will be useful, but WITHOUT
* Any WARRANTY; without even the implied warranty of MERCHANTABILITY or
* FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
* for more details.
*
* You should have received a copy of the GNU General Public License along with
* this program.  If not, see <http://www.gnu.org/licenses/>.
*
*******************************************************************************/


#include "AskPassQt.h"
#include "ErrorHandler.h"
#include "SvgDefaultOptions.h"
#include "TransparencyDefaultOptions.h"
#include "XmlOptions.h"

#include <QApplication>
#include <QIcon>
#include <cstdio>

//____________________________________________________
int main( int argc, char *argv[] )
{
    setvbuf(stdout, 0, _IONBF, 0);

    // install error handler
    ErrorHandler::initialize();

    Q_INIT_RESOURCE( pixmaps );
    QApplication application(argc, argv);

    application.setApplicationName( "openssh-askpass" );

    // default options
    installSvgOptions();
    installTransparencyOptions();

    // icon
    AskPassQt mainWidget;
    mainWidget.setWindowIcon( QPixmap( ":/icon.png" ) );
    mainWidget.show();
    application.connect( &application, SIGNAL(lastWindowClosed()), &mainWidget, SLOT(cancel()) );
    application.exec();
    return 0;
}
