#! /usr/bin/env python3
# -*- coding: utf-8 -*-

#Do not change these during runtime!

METADATA={
    #The pretty name of this program. Used for NSM display and Jack client name
    #Can contain everything a linux file/path supports. Never change this or it will break the
    #session, making your file unable to load and destroying saved Jack connections.
    "name" : "Patroneo",

    #Set this to the name the user types into a terminal.
    #MUST be the same as the binary name as well as the name in configure.
    #Program reports that as proc title so you can killall it by name.
    #Should not contain spaces or special characters. We use this as save file extension as well
    #to distinguish between compatible program versions. In basic programs this will just be e.g.
    #patroneo. But in complex programs with a bright future it will be "laborejo1" "laborejo2" etc.
    "shortName" : "patroneo",

    #A very short description used in various places: Desktop file, overview on the website,
    #release announcements, entries in software directories etc.
    "tagline" : 'Easy to use pattern based midi sequencer.',

    "version" : "2.2.0",
    "year" : "2021",
    "author" : "Laborejo Software Suite",
    "url" : "https://www.laborejo.org/patroneo",

    "supportedLanguages" : {"German":"de.qm"},

    #Show the About Dialog the first time the program starts up. This is the initial state for a
    #new instance in NSM, not the saved state! Decide on how annoying it would be for every new
    #instance to show about. Fluajho does not show it because you add it many times into a session.
    #Patroneo does because its only added once.
    "showAboutDialogFirstStart" : True,

    #If your program handles very small duration with n-tuplets you should increase D4.
    #This will not be visible to the outside jack world
    "quarterNoteInTicks" : 96,

    #How many audio outputs do you want? must be pairs. These are just unconnected jack outputs
    #that need to be connected internally to instrument outputs like fluidsynth
    "cboxOutputs" : 2 * 0,

    #Does the program uses a metronome? In this case you need at least two cboxOutputs above
    "metronome" : False,

    #Various strings for the README
    #Extra whitespace will be stripped so we don't need to worry about docstring indentation
    "description" : """
Patroneo (which is Esperanto for "Pattern") is an easy to use, pattern based midi sequencer, a
program that sends digital "notes" to software instruments such as synthesizers and samplers.

Patroneo is primarily designed for educational purposes, where the main goal is to teach the
importance of patterns and repetitions in any kind of music. However, Patroneo is a full sequencer
you can use to create real music. The constraints it presents will more likely boost your
creativity than suppressing it.

You have tracks with one pattern each. Turn on steps in the pattern to play
musical notes. Switch the patterns on and off in a sequence to create a song structure.
Connect external synthesizers and samplers to create sounds.
""",

    "dependencies" : "\n".join("* "+dep for dep in ()),
}
